#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/Listener.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include "Listener.h"
#include <errno.h>

/*lint -save -e1401 */

CListener *CListener::oCListener = 0;

CListener ::CListener()
{
	oApplication = new CApplication();
}

CListener ::~CListener()
{
	if (oApplication != NULL)
		delete oApplication;
//	if (oCListener  != NULL)
//		delete oCListener;
	oCListener = NULL;
}

CListener* CListener::getCListenerInstance()
{
	if (oCListener == NULL)
		oCListener = new CListener();
	return oCListener;
}

int CListener::startListen()
{
    ENTRY
	oApplication->InitMe(objTest->m_strTestcase);
	oApplication->registerCallback(this);
	return 0;
}
void CListener::simulateListenTest()
{
    ENTRY
	oApplication->simulateListenTest();
}

void CListener::stopListen()
{
    ENTRY
	oApplication->DeInitMe();
}

int CListener::getResult()
{
	return 0;
}

void CListener::ListenerCallback(int value)
{
    ENTRY
	objTest->testCallback(value);
}
void CListener::ListenerCallback(cTestData* value)
{
    ENTRY
	objTest->testCallback(value);
}
void CListener::registerCallback(cBaseTest *obj)
{
    ENTRY
	if(obj->bLetFWValidateResult == false)
		oApplication->bsendEachResult = true;
	objTest = obj;
}
void CListener::registerEvent(enIDs eEventType)
{
	oApplication->RegisterEvent(eEventType);
}

/*******************************Application part*************************************************************/

CApplication::CApplication()
{
	bsendEachResult = false;
	if (setResultsRef.size() > 0)
		setResultsRef.clear();
	if(setResultsobtained.size() > 0)
		setResultsobtained.clear();
	if (SignalsVectList.size() > 0)
		SignalsVectList.clear();
}

CApplication::~CApplication()
{
	if (setResultsRef.size() > 0)
		setResultsRef.clear();
	if (setResultsobtained.size() > 0)
		setResultsobtained.clear();
	if (SignalsVectList.size() > 0)
		SignalsVectList.clear();
    if (pEvLib != NULL)
        delete pEvLib;
//  if (mobjListener != NULL)
//      delete mobjListener;
    mobjListener = NULL;
}

void CApplication::InitMe(string strId)
{
    ENTRY
	/*
	when 'oRegisterEvent' is called, it returns a sigc::connection object.
	Application needs to store this object. so that when finished listening to the signal, it can disconnect from it using the
	u8DetachConnection API passing this connection object as the argument. Once detached from the signal, the callback will not be
	invoked even if the signal emitted
	*/
	if (SignalsVectList.size() > 0)
		SignalsVectList.clear();
	pEvLib = EventDispatcher::poGetEventDispatcher();
	m_strTestId = strId;
}

void CApplication::DeInitMe()
{
	/*** Unregister all the signals assigned to the listener ***/
	UnregisterEvents();
	//EventDispatcher::poGetEventDispatcher()->u8DetachConnection(m_signalConnectorID);
}

void CApplication::UpdateResult(guint32 u32EventId,gpointer pParam1, gpointer pParam2)
{
    ENTRY
	//bTestFlag = true;
	static int count =0;
	int Resultsize = setResultsRef.size();
	msgValues *msgValuesRef = new msgValues;
	msgValuesRef->strMsg = (char *)pParam1;
	setResultsobtained[count]=msgValuesRef;
//	cout <<"setResultsobtained data "<<setResultsobtained[count]<<endl;
	count++;
	//cout << "Call for event "<<u32EventId<<"and data is "<<(char *)pParam1<<endl;
	if(bsendEachResult == true)
	{
		//cout << "Sending result to testcase to validate "<<endl;
		mobjListener->ListenerCallback((cTestData *)pParam2);
	}
	else if(count == Resultsize)
	{
		//
		//cout << "FW validate "<<endl;
		mobjListener->ListenerCallback(getResult((cTestData *)pParam2));
	}

}

void CApplication::simulateListenTest()
{
    ENTRY
}

int CApplication::getResult(cTestData *ocTestData = NULL)
{
    ENTRY
	int result = 0;
	int Resultsize = setResultsRef.size();

	for(int i=0;i < Resultsize && (0 == result);i++)
	{
		msgValues *msgValues1,*msgValues2 = NULL;
		msgValues1 = setResultsRef[i];
		msgValues2 = setResultsobtained[i];
		result = validateMsgParams(msgValues1,msgValues2);
		//Incase of Logic Validators presence iterate the lsit fully
		if(ocTestData !=NULL)
		{
			switch(ocTestData->eMSGTYPE)
			{
				case EV_GETMEDIAOBJECTALBUMINFOANSWER:
				    ETG_TRACE_USR2(("%s", "EV_GETMEDIAOBJECTALBUMINFOANSWER"));

				    //cout<< "MIME TYPE " << ocTestData->mimeType <<endl;
				    //cout<< "List Size " << ocTestData->size <<endl;
					//cout<< "user context fun id  " << ocTestData->userContext.functionID <<endl;
					break;

				default:
					break;
			}
		}
	}

	if(1==result)
		printResults();
	return result;
}

int CApplication::validateMsgParams(msgValues *msgValues1, msgValues *msgValues2)
{
    ENTRY
	if (NULL != msgValues2)
	{
		//cout <<"setResultsRef data "<<msgValues2->strMsg<<endl;
		if(msgValues2->strMsg== msgValues1->strMsg)
		{
			//Validate params by going through the  vectors..
			//
			return 0;
		}
		else
			return 1;
	}
	else
		return 1;
}

void CApplication::printResults()
{
    ENTRY
	int ResultRefsize = setResultsRef.size();
	for(int i=0;i < ResultRefsize;i++)
	{
	    ETG_TRACE_USR2(("%s", setResultsRef[i]->strMsg.c_str()));
	    //	cout <<"Expected sequence is "<<setResultsRef[i]->strMsg<< "  and Received seqence is";
		if (NULL != setResultsobtained[i])
			cout <<setResultsobtained[i]->strMsg;
		cout<<endl;

	}
}

void CApplication::RegisterAllEvents()
{
    ENTRY
	//register for atll the events in simulator
	//
	SignalsVectList.push_back(pEvLib->oRegisterEvent(EV_TEST,this,&CApplication::UpdateResult));
	//m_signalConnectorID = pEvLib->oRegisterEvent(EV_TEST,this,&CApplication::UpdateResult);
	SignalsVectList.push_back(pEvLib->oRegisterEvent(EV_GETMEDIAOBJECTALBUMINFOANSWER,this,&CApplication::UpdateResult));
	SignalsVectList.push_back(pEvLib->oRegisterEvent(EV_GETMEDIAOBJECTALBUMARTANSWER,this,&CApplication::UpdateResult));
}


void CApplication::RegisterEvent(guint32 u32EventId)
{
    ENTRY
	//register for specific events
	//
	SignalsVectList.push_back(pEvLib->oRegisterEvent(u32EventId,this,&CApplication::UpdateResult));
	
}

void CApplication::registerCallback(CListener *objListener)
{
    ENTRY
	mobjListener = objListener;
}

void CApplication::UnregisterEvents()
{
    ENTRY
	int SignalVctSize = SignalsVectList.size ();
	if(SignalVctSize > 0)
	{
		  for (int i = 0; i < SignalVctSize; i++)
		  {
			  sigc::connection m_signalConnectorID1 = SignalsVectList.at(i);
			  EventDispatcher::poGetEventDispatcher()->u8DetachConnection(SignalsVectList.at(i));
		  }
	}
	//cout <<"UnregisterEvents Ended  "<< "\n";
}
