#ifndef LISTENERDEFINITIONS_H_
#define LISTENERDEFINITIONS_H_

#include <iostream>
#include <stdlib.h>
#include <set>
#include <vector>
#include <map>
#include <string.h>
#include <glib.h>

#include "EventDispatcher.h"
#include "EventDefinitions.h"
#include "SimulationConfiguration.h"
#include "SimulationOutputWrapper.h"
#include "SimulationCustomControl.h"
#include "test_util.h"

typedef vector<string> vecParams;

using namespace std;

typedef struct
{
	string strMsg;
	vecParams objvecParams;
} msgValues;

//structMsgValues structMsgValuesRef;
typedef map<int, msgValues*> setResults;

class CListener;

class CApplication
{
	public:
		void InitMe(string strId = "");
		void DeInitMe();
		void UpdateResult(guint32 u32EventId, gpointer pParam1, gpointer pParam2);
		int getResult(cTestData *);
		int validateMsgParams(msgValues *, msgValues *);
		void simulateListenTest();
		void printResults();
		void RegisterAllEvents();
		void RegisterEvent(guint32 u32EventId);
		void LoadRefResults();
		void Reset();
		void registerCallback(CListener *);
		bool bsendEachResult;
		void UnregisterEvents();
		CApplication();
		~CApplication();

	private:
		sigc::connection m_signalConnectorID;
		string m_strTestId;
		//bool bTestFlag;
		setResults setResultsRef;
		setResults setResultsobtained;
		EventDispatcher *pEvLib;
		CListener *mobjListener;
		vector <sigc::connection> SignalsVectList;
};

class CListener: public cBaseTest
{
	public:
		int getResult();
		int startListen();
		void stopListen();
		void simulateListenTest();
		void Reset();
		void ListenerCallback(cTestData *);
		void ListenerCallback(int);
		void UpdateResult();
		void registerCallback(cBaseTest *);
		void registerEvent(enIDs);
		static CListener* getCListenerInstance();
		~CListener();

	private:
		CListener();
		CApplication *oApplication;
		SimulationOutputWrapper *oSimulatorOutputWrapper;
		cBaseTest *objTest;
		static CListener *oCListener;
};
#endif
