/* ETG definitions */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_ROOT_DAEMON
#ifdef TARGET_BUILD
#include "trcGenProj/Header/GMPRootDaemon.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_ROOT_DAEMON
#endif
#endif
#include "FunctionTracer.h"
#include "VarTrace.h"

/* others */
#include "LocalSPM.h"
#include "GMPRootDaemon.h"

/*lint -save -e578 -e1401 */

RootDaemon::RootDaemon(const tComponentID componentID) :
        ILocalSPM(componentID)
{
    ENTRY_INTERNAL
    mGmpCommands.SetCommandFd(-1); // CID 17926 (#1 of 1): Uninitialized scalar field (UNINIT_CTOR)
}

RootDaemon::~RootDaemon()
{
    ENTRY_INTERNAL
}

void RootDaemon::Create()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    CreateDone(ret);
}

// to init everything
tResult RootDaemon::Init(tInitReason reason)
{
    ENTRY
    VARTRACE(reason);

    if (LocalSPM::GetDataProvider().RootDaemonDirectCallGMPCommands() == 0) {
        ETG_TRACE_USR3(("connect root daemon client"));
        mClient.Connect("/tmp/GMP.root.cmd");
    }
    mClient.Start();

    return InitDone(0);
}

tResult RootDaemon::Run()
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    RunDone(0);
    return ret;
}

tResult RootDaemon::Stop()
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    mClient.Stop();
    StopDone(0);
    return ret;
}

tResult RootDaemon::Done()
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    if (LocalSPM::GetDataProvider().RootDaemonDirectCallGMPCommands() == 0) {
        ETG_TRACE_USR3(("disconnect root daemon client"));
        ret = mClient.Disconnect();
    }
    DoneDone(0);
    return ret;
}

int RootDaemon::Command(const int commandNo, const char *arguments, const int timeoutMs)
{
	ENTRY
		int ret = 0;

	if ((LocalSPM::GetDataProvider().RootDaemonDirectCallGMPCommands() == 1) || (commandNo == GMPCommands::GMP_USB_SCAN_VIDEO_METADATA)) {
		ret = mGmpCommands.Command(IN commandNo, IN arguments, IN timeoutMs);
	} else {
		ETG_TRACE_USR3(("use root daemon client"));
		ret = mClient.Command(IN commandNo, IN arguments, IN timeoutMs);
	}

    return ret;
}
