/**
 * @defgroup RootDaemon GMPCommands
 * @author Matthias Thömel
 *
 * @brief Public interface for the Root Daemon commands of the GMP
 * @{
 */

#ifndef _GMP_COMMANDS_H_
#define _GMP_COMMANDS_H_

#include <unistd.h>
#include <sys/types.h>
#include <pwd.h>
#include <grp.h>

#define GMP_COMMANDS_DELIM "\377"

class GMPCommands {
public:
    int Command(const int commandNo, const char *arguments,const int timeoutMs = 0);

    /* list of all supported commands for the media player */
    enum {
        /* real commands for running of media player */
        GMP_CMD_UNMOUNT = 1,
        GMP_CAT_MTAB,
        GMP_DF,
        GMP_LS_1RA,
        GMP_GREP_CIE,
        GMP_MD5SUM,
        GMP_IAP_LOAD_MODULE,
        GMP_IAP_UNLOAD_MODULE,
        GMP_IAP_COMMON_WRITE,
        GMP_IAP_MOUNT,
        GMP_IAP_UMOUNT,
        GMP_USB_RM_TEMP,
        GMP_USB_SCAN_VIDEO_METADATA,
        GMP_IAP_MOUNT_CONFIGFS,
        GMP_IAP_UMOUNT_CONFIGFS,
        GMP_DU,
        GMP_KILL_LS_1RA,
		GMP_FIND,
		GMP_RM_FOLDER_CONTENT,
		GMP_FILE_CHMOD,
		GMP_MOUNT_OPERATION,
        /* for module tests */
        GMP_CMD_LS = 900,
        GMP_CMD_TEST_TRANSFER,
        GMP_CMD_REMOVE_LS_TXT
    };

    /* members */
    static char *PipeName()
    {
        return (char *)"/tmp/GMP.rootd.cmd";
    }

    static char *UserName()
    {
#ifdef TARGET_BUILD
        return (char *)"aid_mediaplayer";
#else
        /* for uBuntu run: get the current user name and return this */
        uid_t uid = geteuid();
        struct passwd *pw = getpwuid(uid);
        if (pw) {
            return pw->pw_name;
        }
        return (char *)"";
#endif
    }

    static char *GroupName()
    {
#ifdef TARGET_BUILD
        return (char *)"aid_mediaplayer";
#else
        /* for uBuntu run: get the current group name and return this */
        gid_t gid = getegid();
        struct group *grp = getgrgid(gid);
        if (grp) {
            return grp->gr_name;
        }
        return (char *)"";
#endif
    }

    void SetCommandFd(int commandFd)
    {
        mCommandFd = commandFd;
    }

    int CommandFd()
    {
        return mCommandFd;
    }

private:
    int mCommandFd;
    //>--Roadmap CMG3G-10221 : 'Scene Recorder '
    int setfilePermission(char *path, char* mode);
    int setMountOperation(char *path, char *filetype, char* mode);
    int isFileAccessible(char *path);
    //<--Roadmap CMG3G-10221 : 'Scene Recorder '
};

#endif // #ifndef _GMP_COMMANDS_H_
