/**
 * @defgroup RootDaemon ClientProtocol
 * @author Matthias Thömel
 *
 * @brief Public interface for the Root Daemon client protocol
 * @{
 */

#ifndef _GMPCLIENT_PROTOCOL_H_
#define _GMPCLIENT_PROTOCOL_H_

#include "GMPCommands.h"
#include "CommonTypes.h"
#include "Lock.h"

#define ROOTD_CLIENT "ClientProtocol"

class GMPClientProtocol
{
public:
    GMPClientProtocol() : mStop(0) {};
    int Connect(const char *commandPipeName);
    int Command(const int commandNo, const char *arguments, const int timeoutMs = 0);
    void Start() {mStop=0;};
    void Stop() {mStop=1;};
    int Disconnect();

private:
    Lock mCommandLock;
    int mStop;
};

#endif // #ifndef _GMPCLIENT_PROTOCOL_H_
