#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_PLAYER_MANAGER
#ifdef TARGET_BUILD
#include "trcGenProj/Header/PlayerManager.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_PLAYER_MANAGER
#endif
#endif

#include "LocalSPM.h"
#include "FunctionTracer.h"
#include "VarTrace.h"
#include "Dispatcher.h"
#include "MediaPlayer_ErrorCodes.h"
#include "PlayerManager.h"

//tPlaybackSpeed pPlaybackSpeed;
me::speed_e pPlaybackSpeed ;
tPlaybackSpeed curPlaybackSpeed = PBK_SPEED_1X;
speedstate_e IsPlaybackSpeed = ME_SPEEDSTATE_OFF;

/*lint -save -e1401 */

PlayerManager::PlayerManager(const tComponentID componentID):ILocalSPM(componentID)
{
    ENTRY_INTERNAL

    /* Early initialization of variables */
    m_AutoRegisterOnDBTrigger = TS_ON;
    m_MultipleNextWaitTimerID = 0;
    m_FFwdFRevProgressTimerID = 0;
    m_GetAudioDeviceTimerID = 0;
    m_AppleBugWrongSourceTimerID = 0;
    m_FirstErrorTimerID = 0;
    m_ActiveDevice = DEVICE_ID_NOT_SET;
}

PlayerManager::~PlayerManager()
{
    ENTRY_INTERNAL
}

void PlayerManager::Create()
{
    ENTRY

    /* Create the state machine */
    PlayerManagerSM::Create();

    CreateDone(0);
}

tResult PlayerManager::Init(tInitReason reason)
{
    ENTRY
    (void)reason;

    /* Init the state machine */
    PlayerManagerSM::Init();
    SetAnswerTimeout(PLAYER_MANAGER_SM_ANSWER_TIMEOUT_MS); // Set answer timeout

    /* Register state machine with dispatcher */
    Dispatcher::GetInstance().Register(IN this);

    return InitDone(0);
}

tResult PlayerManager::InitSM()
{
    ENTRY

    /* Initialize variables */
    m_ErrorHandlerRetryCounter = 0;
    m_StreamingMode = SM_OFF;
    m_AudioOutputDevice[0] = '\0';
    m_ListID = LIST_ID_NONE;
    m_StartTime = 0;
    m_BufferIndex = POSITION_NOT_SET;
    m_LastAction = PBA_STOP;
    m_FirstErrorObjectID = OBJECT_ID_NONE;
    m_firstErrorObjectPosition = POSITION_NOT_SET;
    m_AutoPlayFlag = FALSE;
    m_SAPauseFlag = FALSE;
    m_NewStreamingObject = FALSE;

    InitMediaObject(OUT m_MediaObject);

    m_HMIPlaybackState = HMI_PBS_STOPPED;

    m_HMINowPlaying.listID = LIST_ID_NONE;
    m_HMINowPlaying.state = NP_INVALID;
    m_HMINowPlaying.position = 0;
    m_HMINowPlaying.objectID = OBJECT_ID_NONE;
    InitMediaObject(OUT m_HMINowPlaying.object);
    InitMediaObject(OUT m_PrevNowPlayingUpdateMediaObject);
    m_PrevNowPlayingUpdateListID = LIST_ID_NONE;
    m_AlbumArtAvailable = true;

    m_HMIElapsedPlaytime = 0;
    m_HMITotalPlaytime = 0;
    m_ValidLastMode = FALSE;
    mIsScanMode = false;
    m_firstScannedMediaObjectID = OBJECT_ID_NONE;
    m_HMIObjectID = OBJECT_ID_NONE;
    return MP_NO_ERROR;
}

tResult PlayerManager::Run()
{
    ENTRY

    //tResult ret = MP_NO_ERROR;

    LocalSPM::GetThreadFactory().Do(this, 0, NULL); //PlayerManager inclusive state machine

    if(TS_ON == m_AutoRegisterOnDBTrigger)
    {
        /* Register on DB trigger */
        /*ret = */SwitchDBTrigger(TT_ALL, TS_ON);
    }

    return RunDone(0);
}

void PlayerManager::Do(int functionID, void *ptr)
{
    ENTRY
    (void)functionID;
    (void)ptr;

    //set the threads name
    LocalSPM::GetThreadFactory().SetName(PlayerManagerSM::GetSMNameFull());

    //actual thread
    while(PlayerManagerSM::STATE_MACHINE_FINISHED != PlayerManagerSM::StateMachine_Main()){}
}

tResult PlayerManager::Stop()
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    /* Deregister on DB trigger */
    ret = SwitchDBTrigger(TT_ALL, TS_OFF);

    /* Send STOP message to own SM */
    ret = SendForceEvent(STOP_SM, (char *)NULL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult PlayerManager::StopEventProcessed()
{
    ENTRY

    /* Send stop done to SPM in the transition to final state in state machine */
    return StopDone(0);
}

tResult PlayerManager::Done()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Deregister state machine with dispatcher */
    Dispatcher::GetInstance().DeRegister(IN this);

    /* Send DONE message to own SM */
    ret = SendForceEvent(DONE, (char *)NULL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult PlayerManager::DoneEventProcessed()
{
    ENTRY

    /* Send done done to SPM in the transition to final state in state machine */
    return DoneDone(0);
}

char *PlayerManager::GetSMStateName(OUT tGeneralString stateName, size_t size)
{
    GetCurrentState((char *)stateName, size);
    return stateName;
}

#if 0
tResult PlayerManager::ErrorHandler(const tResult error, const tTransition *trans, const char *fnName)
{
    ENTRY

    if((NULL == trans)
       ||
       (NULL == fnName))
    {
        ETG_TRACE_ERR(("Invalid parameter: trans or fnName is NULL"));
        return MP_ERR_PM_INVALID_PARAM;
    }
    ETG_TRACE_FATAL(("PlayerManager::ErrorHandler error:%d, transition:%128s, fnName:%s", error, trans->name, fnName));

    tResult ret = 0; // continue retry loop

    m_ErrorHandlerRetryCounter++;

    if (0 == m_ErrorHandlerRetryCounter % 3)
    {
        m_ErrorHandlerRetryCounter = 0;
        ret = 1; // stop the retry loop
    }
    else
    {
        usleep(100000); //sleep 100ms
    }

    return ret;
}
#endif

tResult PlayerManager::AllocateAudioOutput(const tAudioOutputDevice audioOutputDevice)
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    if(NULL == audioOutputDevice)
    {
        ETG_TRACE_ERR(("Invalid parameter: audioOutputDevice is NULL"));
        ret = MP_ERR_PM_INVALID_PARAM;
    }
    else
    {
        ETG_TRACE_USR3(("PlayerManager::AllocateAudioOutput audioOutputDevice:%s", audioOutputDevice));

        /* Check if GetAudioDevice request is ongoing */
        if(m_GetAudioDeviceTimerID != 0)
        {
            /* Cancel get audio device timer */
            m_GetAudioDeviceTimer.CancelTimer(m_GetAudioDeviceTimerID);
            m_GetAudioDeviceTimerID = 0;

            /* Send SPI MethodAnswer for GetAudioDevice */
            tDeviceID deviceID = DEVICE_ID_NOT_SET; //Not used yet
            ret = LocalSPM::GetOutputWrapper().SendGetAudioDeviceAnswer(IN deviceID, IN audioOutputDevice);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending GetAudioDeviceAnswer via OutputWrapper (ErrorCode:%s)", errorString(ret)));
            }

            if(LocalSPM::GetDataProvider().SourceActivityDelayEnabled())
            {
                /* Cancel wrong source timer if it is already running */
                if(m_AppleBugWrongSourceTimerID != 0)
                {
                    m_AppleBugWrongSourceTimer.CancelTimer(m_AppleBugWrongSourceTimerID);
                    m_AppleBugWrongSourceTimerID = 0;
                }

                /* Start wrong source timer */
                m_AppleBugWrongSourceTimer.StartTimer(OUT m_AppleBugWrongSourceTimerID,
                           IN LocalSPM::GetDataProvider().AppleBugWrongSourceTimeout(),
                           IN 0L,
                           IN &LocalSPM::GetPlayerManager(),
                           IN &AppleBugWrongSourceTimerCallback,
                           IN NULL);
            }
        }

        /* Send ALLOCATE message to DeviceDispatcherSM */
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];

        strncpy_r(OUT msgToSendString, IN "DeviceDispatcherSM::ALLOCATE", IN sizeof(msgToSendString));
        strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::ALLOCATE_ANSWER", IN sizeof(answerMsgString));

        ret = LocalSPM::GetDeviceDispatcher().ParameterALLOCATE(OUT parameterString, IN size, IN audioOutputDevice);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }

        /* Store audio output device (alsa device name) internally */
        m_Mutex.lock();
        strncpy_r(OUT m_AudioOutputDevice, IN audioOutputDevice, IN sizeof(m_AudioOutputDevice));
        m_Mutex.unlock();
    }

    if(MP_NO_ERROR != ret)
    {
        /* Send ACTION_ERROR message to own SM */
        tResult ret2 = SendEvent(ACTION_ERROR, (char *)NULL);
        if(MP_NO_ERROR != ret2)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret2)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult PlayerManager::DeAllocateAudioOutput()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::DeAllocateAudioOutput"));

    tResult ret = MP_NO_ERROR;

    /* Cancel wrong source timer if it is already running */
    if(m_AppleBugWrongSourceTimerID != 0)
    {
        m_AppleBugWrongSourceTimer.CancelTimer(m_AppleBugWrongSourceTimerID);
        m_AppleBugWrongSourceTimerID = 0;
    }

    /* Send DEALLOCATE message to DeviceDispatcherSM */
    char msgToSendString[64];
    char answerMsgString[64];

    strncpy_r(OUT msgToSendString, IN "DeviceDispatcherSM::DEALLOCATE", IN sizeof(msgToSendString));
    strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::DEALLOCATE_ANSWER", IN sizeof(answerMsgString));

    ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN answerMsgString);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));

        /* Send ACTION_ERROR message to own SM */
        tResult ret2 = SendEvent(ACTION_ERROR, (char *)NULL);
        if(MP_NO_ERROR != ret2)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret2)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult PlayerManager::SendPlaybackAction(const tPlaybackAction playbackAction, const tNextPrevSkipCount nextPrevSkipCount, const tPlaybackSpeed playbackSpeed, const speedstate_e isPlaybackSpeed)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SendPlaybackAction playbackAction:%u, steps:%u, playbackspeed:%u, isplaybackspeed:%u ", playbackAction, nextPrevSkipCount, playbackSpeed, isPlaybackSpeed));

    tResult ret = MP_NO_ERROR;

    // Handle Folder up/down request is valid only for USB,MTP,CD-MP3. Hence ignore for other Device types.
    if( (PBA_FOLDER_UP == playbackAction) || (PBA_FOLDER_DOWN == playbackAction) )
    {
        tNowPlaying nowPlaying;
        if( MP_NO_ERROR == GetNowPlaying(OUT nowPlaying) )
        {
            if((FALSE == IsMassStorageDevice(IN nowPlaying.object.deviceType)) && (DTY_MTP != nowPlaying.object.deviceType))
            {
                ETG_TRACE_ERR((" Handle Folder up/down request is not valid for device type: %d", ETG_CENUM(tDeviceType,nowPlaying.object.deviceType)));
                ret = MP_ERR_PM_INVALID_PARAM;
            }
        }
    }

    if(MP_NO_ERROR == ret)
    {
        tGeneralString eventString = {0};
        tAllParameters parameterString = {0};
        size_t size = sizeof(parameterString);
        pPlaybackSpeed = (me::speed_e)playbackSpeed;
        IsPlaybackSpeed = isPlaybackSpeed;//ME_SPEEDSTATE_ON;//

        tBoolean eventToOwnSM = TRUE;
        tBoolean forwardEvent = TRUE;

        /* Get current streaming mode */
        tStreamingMode currentStreamingMode = SM_OFF;
        GetStreamingMode(OUT currentStreamingMode);

        if(LocalSPM::GetDataProvider().TrackScanningSupported() && mIsScanMode)
        {
            ETG_TRACE_USR4(("PlaybackAction Request:%u has come from HMI while Scan is ON.Hence turning-off scan",playbackAction));
            ret = SendScanMode((tScanMode)false);
        }

        if( SM_ON == currentStreamingMode )
        {
            /* Send general playback action message to own SM */
            //event = PLAYBACK_ACTION;
            strncpy_r(OUT eventString, IN "PLAYBACK_ACTION",IN  sizeof(eventString));

            ret = ParameterPLAYBACK_ACTION(OUT parameterString, IN size, IN playbackAction, IN nextPrevSkipCount);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            }
        }
        else
        {
            switch(playbackAction)
            {
                case PBA_PLAY:
                {
                   /*Precond: Playback Stops on reaching Begin/End of list;
                   Action:User Presses PLAY button
                   Result:If PlayOnUserRequestWhenListFinished is true,then play the list again from beginning.Else,remain stopped.*/
                    ret = LocalSPM::GetOutputWrapper().UpdatePlaybackSpeed();
                    if( MP_NO_ERROR != ret )
                    {
                        ETG_TRACE_ERR(("Error while updating playbackspeed to registered clients"));
                    }
                   tNowPlaying nowPlaying;
                   ret = GetNowPlaying(OUT nowPlaying);
                   if((NP_LIST_COMPLETE == nowPlaying.state || NP_LIST_START == nowPlaying.state) && LocalSPM::GetDataProvider().PlayOnUserRequestWhenListFinished() )
                   {
                      tListID currentListID = LIST_ID_NONE;
                      tIndex index = tIndex_init;
                      tPlaytime playtime = tPlaytime_init;
                      ret = GetListID(OUT currentListID);
                      //Suzuki CRQ 296694 and Bug 265009
                        if (LocalSPM::GetDataProvider().FirstItemFromShuffleList()) {
                            tPlaybackMode playbackMode;
                            ret = LocalSPM::GetListControl().GetPlaybackMode(playbackMode);
                            if (!ret) {
                                if (PBM_RANDOM == playbackMode) {
                                    tIndex indexLocal = LocalSPM::GetListControl().GetFirstItemFromShuffleList(
                                            currentListID);
                                    if (INDEX_NONE != indexLocal) {
                                        index = indexLocal;
                                    }
                                }
                            }
                        }
                      ret = SendNewList(IN currentListID, index, playtime);
                      forwardEvent = FALSE;
                   }
                   else
                   {
                        //event = RESUME;
                        strncpy_r(OUT eventString, IN "RESUME",IN  sizeof(eventString));
                   }
                   break;
                }
                case PBA_PAUSE:
                {
                    //event = PAUSE;
                    strncpy_r(OUT eventString, IN "PAUSE",IN  sizeof(eventString));
                    break;
                }
                case PBA_STOP:
                {
                    //event = STOP;
                    strncpy_r(OUT eventString, IN "STOP",IN  sizeof(eventString));
                    break;
                }
                case PBA_PREV:
                {
                    //event = PREV;
                    strncpy_r(OUT eventString, IN "PREV",IN  sizeof(eventString));
                    break;
                }
                case PBA_NEXT:
                {
                    //event = NEXT;
                    strncpy_r(OUT eventString, IN "NEXT",IN  sizeof(eventString));
                    break;
                }
                case PBA_FREV_START:
                {
                    //event = FREV_START;
                    strncpy_r(OUT eventString, IN "FREV_START",IN  sizeof(eventString));
                    break;
                }
                case PBA_FREV_STOP:
                {
                    //event = FREV_STOP;
                    strncpy_r(OUT eventString, IN "FREV_STOP",IN  sizeof(eventString));
                    break;
                }
                case PBA_FFWD_START:
                {
                    //event = FFWD_START;
                    strncpy_r(OUT eventString, IN "FFWD_START",IN  sizeof(eventString));
                    break;
                }
                case PBA_FFWD_STOP:
                {
                    //event = FFWD_STOP;
                    strncpy_r(OUT eventString, IN "FFWD_STOP",IN  sizeof(eventString));
                    break;
                }
                case PBA_FOLDER_UP:
                case PBA_FOLDER_DOWN:
                {
                    //event = CustomControlSM::HANDLE_FOLDER_UP_DOWN
                    eventToOwnSM = FALSE;
                    strncpy_r(OUT eventString, IN "CustomControlSM::HANDLE_FOLDER_UP_DOWN", IN sizeof(eventString));
                    break;
                }
                default:
                {
                    ETG_TRACE_ERR(("Invalid playbackAction type: %u",playbackAction));
                    ret = MP_ERR_PM_INVALID_PARAM;
                    break;
                }
            }

            // Pack respective parameters for the event
            if( (MP_NO_ERROR == ret) && (TRUE == forwardEvent) )
            {
                if((PBA_PREV == playbackAction)
                   ||
                   (PBA_NEXT == playbackAction))
                {
                    ret = ParameterNEXT(OUT parameterString, IN size, IN nextPrevSkipCount, IN true/*isHMIRequest*/);
                }
                else if((PBA_FOLDER_UP == playbackAction)
                       ||
                       (PBA_FOLDER_DOWN == playbackAction))
                {
                    ret = LocalSPM::GetCustomControl().ParameterHANDLE_FOLDER_UP_DOWN(OUT parameterString, IN size, IN playbackAction, IN nextPrevSkipCount);
                }
                if(MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                }
            }
        }

        // Send event
        if( (MP_NO_ERROR == ret) && (TRUE == forwardEvent) )
        {
            if(TRUE == eventToOwnSM)
            {
                /* Send event to own SM */
                ret = SendEventByName(IN eventString, IN parameterString);
            }
            else
            {
                /* Send event via Dispatcher to redirect to different SM */
                ret = Dispatcher::GetInstance().SendMessage(IN eventString, IN parameterString);
            }

            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    return ret;
}

tResult PlayerManager::SendAllocate(const tAudioOutputDevice audioOutputDevice)
{
    ENTRY

    if(NULL == audioOutputDevice)
    {
        ETG_TRACE_ERR(("Invalid parameter: audioOutputDevice is NULL"));
        return MP_ERR_PM_INVALID_PARAM;
    }
    ETG_TRACE_USR3(("PlayerManager::SendAllocate audioOutputDevice:%s", audioOutputDevice));

    tResult ret = MP_NO_ERROR;

    /* Do ALLOCATE request and wait for the answer */
    char messageString[64];
    strncpy_r(OUT messageString, IN "PlayerManagerSM::ALLOCATE", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = ParameterALLOCATE(OUT parameterString, IN size, IN audioOutputDevice);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
    }
    else
    {
        RequestResponseSM rrAllocate;
        ret = rrAllocate.DoEventAnswer(IN messageString, IN parameterString, NULL, 2000);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

#if 0
    /* Get current allocate state */
    tAllocateState currentAllocateState;
    tAudioOutputDevice currentAudioOutputDevice;
    GetAllocateState(OUT currentAllocateState, OUT currentAudioOutputDevice);
    if(ALS_DEALLOCATED == currentAllocateState)
    {
        ret = MP_ERR_PM_WRONG_STATE;
    }
#endif

    return ret;
}

tResult PlayerManager::SendDeAllocate()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SendDeAllocate"));

    tResult ret = MP_NO_ERROR;
    int answerTimeoutMS = 2000;

    if(LocalSPM::GetDataProvider().nextPossibleSourceEnabled())
    {
        answerTimeoutMS = LocalSPM::GetDataProvider().nextPossibleSourceEnabledTimeoutMs();/*NCG3D-86873*/
    }

    /* Check if audio sourcing sequence is correct */
    tBoolean isActive;
    GetActiveState(OUT isActive);

    if(isActive)
    {
        ETG_TRACE_FATAL(("Call DEALLOCATE in state active without getting a SA_OFF before (PlayerEngine can still run and last mode is lost)!!!"));
    }

    LocalSPM::GetDataProvider().DiPOStartReason = DIPO_START_REASON_UNKNOWN;

    /* Do DEALLOCATE request and wait for the answer */
    char messageString[64];
    strncpy_r(OUT messageString, IN "PlayerManagerSM::DEALLOCATE", IN sizeof(messageString));

    RequestResponseSM rrDeallocate;
    ret = rrDeallocate.DoEventAnswer(IN messageString, (char *)NULL, NULL, answerTimeoutMS);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }

#if 0
    /* Get current allocate state */
    tAllocateState currentAllocateState;
    tAudioOutputDevice currentAudioOutputDevice;
    GetAllocateState(OUT currentAllocateState, OUT currentAudioOutputDevice);
    if(ALS_DEALLOCATED != currentAllocateState)
    {
        ret = MP_ERR_PM_WRONG_STATE;
    }
#endif

    return ret;
}

tResult PlayerManager::SendSourceActivity(const tSourceActivity sourceActivity)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SendSourceActivity sourceActivity:%u", sourceActivity));

    tResult ret = MP_NO_ERROR;
    int answerTimeoutMS = 2000;
    /* Send SA_ON or SA_OFF request to own SM and wait for the answer */
    char messageString[64];
    switch(sourceActivity)
    {

        case SA_PAUSE:
        {
            if(LocalSPM::GetDataProvider().nextPossibleSourceEnabled())
            {
                answerTimeoutMS = LocalSPM::GetDataProvider().nextPossibleSourceEnabledTimeoutMs();/*NCG3D-86873*/
            }
        }/*intentional fallthrough*/
        case SA_OFF:
        {
            //CarPlay TAKE/BORROW HID Play extension
            //check for active device MYMEDIA
            /* Try to get device related information for media object via listID -> listInfo -> deviceInfo */
            tListID currentListID = LIST_ID_NONE;
            tListInfo listInfo;
            InitListInfo(listInfo);
            if( MP_NO_ERROR != GetListID(OUT currentListID) )
            {
                ETG_TRACE_ERR(("Current listID is not valid -> Cannot deliver device part of media object"));
            }
            else
            {
                tListInfo listInfo;
                if( MP_NO_ERROR != LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN currentListID, IN false) )
                {
                    ETG_TRACE_ERR(("Error while getting list info at ListControl -> Cannot deliver device part of media object (ErrorCode:%s)", errorString(ret)));
                }
            }

            //Mediaplayer got SA_OFF and deallocate -> CarPlay audio UNKNOWN, SPI to wait for details from base channel status
            LocalSPM::GetDataProvider().DiPOStopReason = listInfo.deviceID == MY_MEDIA ? DIPO_STOP_REASON_DEVICE_SWITCHED : DIPO_STOP_REASON_UNKNOWN;

            if(SA_PAUSE == sourceActivity)
            {
                m_SAPauseFlag = TRUE;
            }
            else
            {
                m_SAPauseFlag = FALSE;
            }

            strncpy_r(OUT messageString, IN "PlayerManagerSM::SOURCE_ACTIVITY_OFF", IN sizeof(messageString));

            /* Whenever SA_PAUSE/SA_OFF received,the PrevNowPlayingUpdate info is reset.When SA_ON received,eventhough same track resumes the
             * very fist NowplayingUpdate carries NP_NEW_TRACK
             */
            InitMediaObject(OUT m_PrevNowPlayingUpdateMediaObject);
            m_PrevNowPlayingUpdateListID = LIST_ID_NONE;
            break;
        }
        case SA_ON:
        {
            /* Check if audio sourcing sequence is correct */
            tAllocateState allocateState;
            tAudioOutputDevice audioOutputDevice;
            GetAllocateState(OUT allocateState, OUT audioOutputDevice);

            if(ALS_DEALLOCATED == allocateState)
            {
                ETG_TRACE_FATAL(("Call SA_ON in state deallocated without getting a ALLOCATE before do not work because of missing ALSA device!!!"));
            }

            strncpy_r(OUT messageString, IN "PlayerManagerSM::SOURCE_ACTIVITY_ON", IN sizeof(messageString));
            break;
        }
        default:
        {
            ETG_TRACE_ERR(("Invalid sourceActivity type: %u", sourceActivity));
            messageString[0] = '\0';
            ret = MP_ERR_PM_INVALID_PARAM;
            break;
        }
    }

    if(MP_NO_ERROR == ret)
    {
        RequestResponseSM rrSourceActivity;
        ret = rrSourceActivity.DoEventAnswer(IN messageString, (char *)NULL, NULL, answerTimeoutMS);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult PlayerManager::SendStart()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SendStart"));

    tResult ret = MP_NO_ERROR;

    /* Send START message to own SM */
    ret = SendEvent(START, (char *)NULL);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult PlayerManager::SendStop()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SendStop"));

    tResult ret = MP_NO_ERROR;

    /* Send STOP message to own SM */
    ret = SendEventByName("STOP", (char *)NULL);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult PlayerManager::SendExit()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SendExit"));

    tResult ret = MP_NO_ERROR;

    /* Send EXIT message to own SM */
    ret = SendUrgentEvent(EXIT, (char *)NULL);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult PlayerManager::SendNext()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SendNext"));

    tResult ret = MP_NO_ERROR;

    /* Send NEXT message to own SM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tNextPrevSkipCount steps = 1;
    curPlaybackSpeed = PBK_SPEED_1X;
    ret = LocalSPM::GetOutputWrapper().UpdatePlaybackSpeed();
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while updating playbackspeed to registered clients"));
    }

    ret = ParameterNEXT(OUT parameterString, IN size, IN steps, IN false/*isHMIRequest*/);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
    }
    else
    {
        ret = SendEvent(NEXT, IN parameterString);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult PlayerManager::SendHMINext()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SendHMINext"));

    tResult ret = MP_NO_ERROR;

    /* Send NEXT message to own SM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tNextPrevSkipCount steps = 1;
    curPlaybackSpeed = PBK_SPEED_1X;
    ret = LocalSPM::GetOutputWrapper().UpdatePlaybackSpeed();
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while updating playbackspeed to registered clients"));
    }

    ret = ParameterNEXT(OUT parameterString, IN size, IN steps, IN true/*isHMIRequest*/);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
    }
    else
    {
        ret = SendEvent(NEXT, IN parameterString);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult PlayerManager::SendPrevious()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SendPrevious"));

    tResult ret = MP_NO_ERROR;

    /* Send PREV message to own SM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tNextPrevSkipCount steps = 1;
    curPlaybackSpeed = PBK_SPEED_1X;
    ret = LocalSPM::GetOutputWrapper().UpdatePlaybackSpeed();
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while updating playbackspeed to registered clients"));
    }
    ret = ParameterPREV(OUT parameterString, IN size, IN steps, IN false/*isHMIRequest*/);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
    }
    else
    {
        ret = SendEvent(PREV, IN parameterString);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult PlayerManager::SendHMIPrevious()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SendHMIPrevious"));

    tResult ret = MP_NO_ERROR;

    /* Send PREV message to own SM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tNextPrevSkipCount steps = 1;
    curPlaybackSpeed = PBK_SPEED_1X;
    ret = LocalSPM::GetOutputWrapper().UpdatePlaybackSpeed();
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while updating playbackspeed to registered clients"));
    }

    ret = ParameterPREV(OUT parameterString, IN size, IN steps, IN true/*isHMIRequest*/);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
    }
    else
    {
        ret = SendEvent(PREV, IN parameterString);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult PlayerManager::SendStartAndResetTime()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SendStartAndResetTime"));

    tResult ret = MP_NO_ERROR;

    /* Set start playtime to 0 */
    m_StartTime = 0;

    /* Send START message to own SM */
    ret = SendStart();
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while calling SendStart"));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult PlayerManager::SendPreviousAndSetToEnd()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SendPreviousAndSetToEnd"));

    tResult ret = MP_NO_ERROR;

    /* Set start playtime to end of object */
    m_StartTime = PLAYTIME_END_OF_OBJECT;

    /* Send PREV message to own SM */
    ret = SendHMIPrevious();
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while calling SendHMIPrevious"));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult PlayerManager::SendSeekTo(const tPlaytime playpointPosition, const tPlaypointFormat playpointFormat)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SendSeekTo position:%u, format:%u", playpointPosition, playpointFormat));

    tResult ret = MP_NO_ERROR;

    tPlaytime position = playpointPosition;

    /* get the current playtime seen by HMI */
    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;
    ret = GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime,OUT objectID);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while getting current media object"));
        return MP_ERR_PM_NO_MEDIA_OBJECT;
    }
    else
    {
        if(PPF_PERCENTAGE == playpointFormat)
        {
            /* Calculate absolute playtime position */
            if((0 < totalPlaytime)
               &&
               (PLAYTIME_NONE != totalPlaytime))
            {
                position = ((totalPlaytime * playpointPosition) + 50) / 100; //+50: for correct rounding
                ETG_TRACE_USR2(("totalPlaytime=%d, calc'ed position=%d", totalPlaytime, position));
            }
            else
            {
                return MP_ERR_PM_NO_TOTAL_PLAYTIME;
            }
        }

        /* Check if new position is not bigger than total playtime of current track */
        if((0 < totalPlaytime)
           &&
           (position > totalPlaytime))
        {
            position = totalPlaytime;
        }
    }

    if(LocalSPM::GetDataProvider().TrackScanningSupported() && mIsScanMode)
    {
        ETG_TRACE_USR4(("SEEK Request has come from HMI while Scan is ON.Hence turning-off scan"));
        ret = SendScanMode((tScanMode)false);
    }

    /* Send SEEK_TO message to own SM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = ParameterSEEK_TO(OUT parameterString, IN size, IN position);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
    }
    else
    {
        ret = SendEventByName("SEEK_TO", IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult PlayerManager::SendGetAudioDevice(const tDeviceID deviceID)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SendGetAudioDevice deviceID:%u", deviceID));

    tResult ret = MP_NO_ERROR;

    if( LocalSPM::GetDataProvider().iPodControlIAP2CarPlayModeEnabled() )
    {
        /* Send GET_AUDIO_DEVICE message to own SM */
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = ParameterGET_AUDIO_DEVICE(OUT parameterString, IN size, IN deviceID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            ret = SendEventByName("GET_AUDIO_DEVICE", IN parameterString);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    return ret;
}

tResult PlayerManager::SendGetAudioDeviceAnswer(const tDeviceID deviceID, const tSuccess success)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SendGetAudioDeviceAnswer deviceID:%u, success:%u", deviceID, success));

    tResult ret = MP_NO_ERROR;

    if( (LocalSPM::GetDataProvider().iPodControlIAP2CarPlayModeEnabled())
        &&
        (SC_NO == success)) // RequestAVActivation is denied
    {
        /* Send GET_AUDIO_DEVICE_ANSWER message to own SM */
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = ParameterGET_AUDIO_DEVICE_ANSWER(OUT parameterString, IN size, IN deviceID, IN success);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

            ret = SendEventByName("GET_AUDIO_DEVICE_ANSWER", IN parameterString);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }

    return ret;
}

tResult PlayerManager::SendPlaybackMode(const tPlaybackMode playbackMode)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SendPlaybackMode playbackMode:%u", playbackMode));

    tResult ret = MP_NO_ERROR;

    /* Send PLAYBACK_MODE message to own SM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = ParameterPLAYBACK_MODE(OUT parameterString, IN size, IN playbackMode);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
    }
    else
    {
        ret = SendEvent(PLAYBACK_MODE, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult PlayerManager::SendRepeatMode(const tRepeatMode repeatMode)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SendRepeatMode repeatMode:%u", repeatMode));

    tResult ret = MP_NO_ERROR;

    /* Send REPEAT_MODE message to own SM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = ParameterREPEAT_MODE(OUT parameterString, IN size, IN repeatMode);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
    }
    else
    {
        ret = SendEvent(REPEAT_MODE, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult PlayerManager::SendNewList(const tListID listID, const tIndex listIndex, const tPlaytime offset)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SendNewList listID:%u index:%u offset:%u", listID, listIndex, offset));

    tResult ret = MP_NO_ERROR;

    /* Parameter check */
    if(LIST_ID_NONE == listID)
    {
        ETG_TRACE_ERR(("Received listID is invalid"));
        return MP_ERR_PM_INVALID_PARAM;
    }

    if(LocalSPM::GetDataProvider().FavoritesSupported())
    {
        tBoolean favAvailable = false;
        /* Get current active device ID */
        tDeviceID currentDeviceID = DEVICE_ID_NOT_SET;
        ret = LocalSPM::GetDBManager().GetActiveDevice(OUT currentDeviceID);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while getting active device from DBManager -> Cannot send repeat mode (ErrorCode:%s)", errorString(ret)));
            ret = MP_NO_ERROR;
        }else
        {
            tDeviceInfo deviceInfo;
            ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN currentDeviceID);
            if( MP_NO_ERROR != ret )
            {
               ETG_TRACE_ERR(("Error while getting device info from DBManager -> Cannot send repeat mode (ErrorCode:%s)", errorString(ret)));
               ret = MP_NO_ERROR;
            }else
            {
                tListInfo listInfo;
                tBoolean withListSize = false;
                ret = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listID, IN withListSize);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while getting list info at ListControl (ErrorCode:%s)", errorString(ret)));
                    ret = MP_NO_ERROR;
                }else
                {
                    VARTRACE(listInfo);
                    ETG_TRACE_USR3(("deviceType:%d deviceID:%d streaming:%d", deviceInfo.deviceType, deviceInfo.deviceID, listInfo.streaming));
                    favAvailable=( (IsAppleDevice(deviceInfo.deviceType))&&(LocalSPM::GetDeviceDispatcher().IsBatchPlayable(deviceInfo.deviceID))
                               &&(LTY_CURRENT_SELECTION == listInfo.listType));
                }
            }
        }

        /* Deactivate all favorites in DB */
        /* This must be done here and not in NewList because the new favorite is set after this call */
        ETG_TRACE_USR3(("favAvailable:%d", favAvailable));
        if(!favAvailable)
        {
            ret = LocalSPM::GetDBManager().DeActivateAllFavorites();
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while deactivating all favorites in DB (ErrorCode:%s)", errorString(ret)));
                ret = MP_NO_ERROR;
            }
        }
    }

    /* Send NEW_LIST message to own SM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = ParameterNEW_LIST(OUT parameterString, IN size, IN listID, IN listIndex, IN offset);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
    }
    else
    {
        ret = SendEventToResultInternal(NEW_LIST, IN parameterString);        /* New List of priority ExternalResultingInternal, so that it ll be of lesser priority than START - PSARCC30-4630 */
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult PlayerManager::SendNextList(const tListID listID)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SendNextList listID:%u", listID));

    tResult ret = MP_NO_ERROR;

    /* Parameter check */
    if(LIST_ID_NONE == listID)
    {
        ETG_TRACE_ERR(("Received listID is invalid"));
        return MP_ERR_PM_INVALID_PARAM;
    }

    /* Send NEXT_LIST message to own SM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = ParameterNEXT_LIST(OUT parameterString, IN size, IN listID,IN true/*tBoolean updateNowPlaying*/);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
    }
    else
    {
        ret = SendEvent(NEXT_LIST, IN parameterString);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult PlayerManager::SendNoObjectAndNext(const tDeviceCount deviceCount, const tDeviceID deviceID)
{
    ENTRY
    (void)deviceCount;
    ETG_TRACE_USR3(("PlayerManager::SendNoObjectAndNext"));

    tResult ret = MP_NO_ERROR;

    /* Check if removed device (deviceID) is the current real device */
    tMediaObject currentMediaObject;
    ret = GetMediaObject(OUT currentMediaObject);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while getting current media object -> No further action (NoObject and Next) possible"));
    }
    else
    {
        if( currentMediaObject.deviceID == deviceID)
        {
            /* Do we play from a MyMedia list? */
            tListID currentListID = LIST_ID_NONE;
            tDeviceID currentDeviceID = MY_MEDIA;

            ret = GetListID(OUT currentListID);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Current listID is not valid"));
            }
            else
            {
                tListInfo listInfo;
                tBoolean withListSize = false;
                ret = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN currentListID, IN withListSize);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while getting list info at ListControl (ErrorCode:%s)", errorString(ret)));
                }
                else
                {
                    currentDeviceID = listInfo.deviceID;
                }
            }

            if(MY_MEDIA == currentDeviceID)
            {
                /* Send NEXT message to own SM */
                ret = SendNext();
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while calling SendNext"));
                }
            }
            else
            {
                /* Send NO_OBJECT message to own SM */
                ret = SendNoObject(NOR_DEVICE_REMOVED);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while calling SendNoObject"));
                }

                /* Set start playtime (NCG3D-2375) */
                tPlaytime elapsedPlaytime = PLAYTIME_NONE;
                ret = GetLastModePlaytime(OUT elapsedPlaytime);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while getting current playtime -> Cannot set start position"));
                }
                else
                {
                    if(PLAYTIME_NONE != elapsedPlaytime) //Playtime is not reset
                    {
                        m_StartTime = elapsedPlaytime;
                    }
                }

                SetActiveDevice(DEVICE_ID_NOT_SET);
                /* Remove the messages from queue , included in this function also as device can be removed and storelastplayed might not be called (if SA_OFF not received).
                /* Get current streaming mode */
                tStreamingMode currentStreamingMode = SM_OFF;
                GetStreamingMode(OUT currentStreamingMode);

                /* Remove all delayed messages from queue of own SM */
                if( SM_ON == currentStreamingMode && LocalSPM::GetDataProvider().BTAudioSourceAsStatic())
                {
                    RemoveMessageByName("PLAYBACK_ACTION");
                    RemoveMessageByName("SEEK_TO");
                }
            }

        }
    }

    return ret;
}

tResult PlayerManager::SendNoObject(const tNoObjectReason noObjectReason)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SendNoObject reason:%u", noObjectReason));

    tResult ret = MP_NO_ERROR;

    /* Send NO_OBJECT message to own SM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = ParameterNO_OBJECT(OUT parameterString, IN size, IN noObjectReason);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
    }
    else
    {
        ret = SendEvent(NO_OBJECT, IN parameterString);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult PlayerManager::NoObject(const tNoObjectReason noObjectReason)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::NoObject reason:%u", noObjectReason));

    tResult ret = MP_NO_ERROR;

    /* Change to a not playable list */
    if((NOR_LIST_IS_NOT_PLAYABLE == noObjectReason)
       ||
       (NOR_DEVICE_REMOVED == noObjectReason))
    {
        /* Store last mode */
        StoreLastPlayedList();

        /* Remove highlighting */
        tListID currentListID = LIST_ID_NONE;
        ret = GetListID(OUT currentListID);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Current listID is not valid -> No remove of highlighting"));
        }
        else
        {
            /* Remove obsolete highlighting on old list */
            tPosition position;
            ret = LocalSPM::GetListControl().UpdateNowPlaying(OUT position, IN currentListID, IN OBJECT_ID_NONE);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while informing ListControl about object currently played (ErrorCode:%s)", errorString(ret)));
            }

            /* Remove highlighting of parent lists */
            ret = LocalSPM::GetListControl().ResetParentHighlighting(IN currentListID);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while resetting highlighting of parent lists (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    /* Stop playback of a media object */
    ret = StopMediaObject();
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while stopping media object"));
    }

    /* Reset current media object */
    tMediaObject mediaObject;
    InitMediaObject(OUT mediaObject);
    SetMediaObject(IN mediaObject);

    /* Reset playtime */
    SetPlaytime(IN 0, IN 0, IN false /*validLastMode*/,IN OBJECT_ID_NONE);

    /* Inform CustomControl that list is empty */
    ret = ListIsEmpty(noObjectReason);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while calling ListIsEmpty"));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult PlayerManager::NewList(const tListID listID, const tIndex listIndex, const tPlaytime offset)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::NewList listID:%u index:%u offset:%u", listID, listIndex, offset));

    tResult ret = MP_NO_ERROR;

    /* Parameter check */
    if(LIST_ID_NONE == listID)
    {
        ETG_TRACE_ERR(("Received listID is invalid"));
        return MP_ERR_PM_INVALID_PARAM;
    }

#if 0
    //tph:Not needed because CustomCtrl is doing nothing within ListIsEmpty in case of noObjectReason=NOR_NEW_LIST
    //    and StopMediaObject is done while changing to new media object in StartMediaObject.
    /* Send NO_OBJECT message to own SM */
    tResult ret2 = SendNoObject(NOR_NEW_LIST);
    if(MP_NO_ERROR != ret2)
    {
        ETG_TRACE_ERR(("Error while sending NoObject"));
    }
#endif

    /* Check if listID changes */
    tListID currentListID = LIST_ID_NONE;
    ret = GetListID(OUT currentListID);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_USR3(("Current listID is not valid -> Cannot store last position"));
    }

    if(currentListID != listID)
    {
        if(LIST_ID_NONE != currentListID)
        {
            /* Store last mode */
            StoreLastPlayedList();

            /* Remove obsolete highlighting on old list */
            tPosition position;
            ret = LocalSPM::GetListControl().UpdateNowPlaying(OUT position, IN currentListID, IN OBJECT_ID_NONE);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while informing ListControl about object currently played (ErrorCode:%s)", errorString(ret)));
            }

            /* Remove highlighting of parent lists */
            ret = LocalSPM::GetListControl().ResetParentHighlighting(IN currentListID);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while resetting highlighting of parent lists (ErrorCode:%s)", errorString(ret)));
            }
        }

        /* Store listID internally */
        SetListID(IN listID);
    }
    else
    {
        /* Store last playtime of old media object even if listID does not change */
        StoreLastPlaytime();
    }

    if(LocalSPM::GetDataProvider().TrackScanningSupported())
    {
        if(mIsScanMode)
        {
            ETG_TRACE_USR3(("Turning-off Scan  PlayerManager::NewList got called"));

            tListInfo nowPlayingListInfo;
            ret = LocalSPM::GetListControl().GetListInfo(OUT nowPlayingListInfo, IN currentListID, IN (tBoolean)false);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while getting nowPlayingListInfo at ListControl (ErrorCode:%s)", errorString(ret)));
            }
            else
            {
                tDeviceInfo activeDeviceInfo;
                ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT activeDeviceInfo, IN nowPlayingListInfo.deviceID);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while getting device info from DBManager (ErrorCode:%s)", errorString(ret)));
                }
                else
                {
                    PrepAndSendScanMessage(IN activeDeviceInfo.deviceType, IN activeDeviceInfo.deviceID, IN (tScanMode)false);
                }
            }
        }
        else
        {
            ETG_TRACE_USR4(("No Need to Request DeviceControl to turn-off scan as it is already OFF"));
        }
    }

    /* Set active media object in ListControl */
    tMediaObject mediaObject;
    ret = LocalSPM::GetListControl().SetMediaObject(OUT mediaObject, IN listID, IN listIndex);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_USR1(("Cannot set active media object at ListControl (ErrorCode:%s)", errorString(ret)));
    }
    else
    {
      //Reshuffle the ShuffleTable & ensure currentRow set as first item in the table
      ret = LocalSPM::GetListControl().ReshuffleShuffleTable(IN listID, IN listIndex);
    }

    if( 0 == offset )
    {
        /* Restore last playtime of current media object */
        RestoreLastPlaytime();
    }
    else
    {
        /* Set start playtime */
        m_StartTime = offset;
    }

    /* Reset last action to PLAY */
    m_LastAction = PBA_PLAY;

    /* Reset first element of list which causes an error */
    m_FirstErrorObjectID = OBJECT_ID_NONE;
    /* Reset position of first element of list which causes an error */
    m_firstErrorObjectPosition = POSITION_NOT_SET;
    /* Set auto play flag */
    m_AutoPlayFlag = TRUE;

    /* In case of current SM state is not active update NowPlaying from DB immediately (SUZUKI-9573) */
    tBoolean isActive;
    GetActiveState(OUT isActive);

    VARTRACE(mediaObject.deviceType)

    if(FALSE == isActive)
    {
        UpdateNowPlayingFromDB();

        if(mediaObject.deviceType == DTY_BLUETOOTH)
        {
            m_NewStreamingObject = FALSE;   //NCG3D-99233 :In the below flow PlayMediaObjectStreaming (Event : START) is called only if the source is active,
                                            //only inside the function PlayMediaObjectStreaming ,  m_NewStreamingObject will be set to FALSE. otherwise it will remain true.
        }
    }

    /* Send STREAMING_MODE_ON/OFF message to own SM */
    tListInfo listInfo;
    tBoolean withListSize = false;
    ret = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listID, IN withListSize);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while getting list info at ListControl (ErrorCode:%s)", errorString(ret)));
    }
    else
    {
        /* Get current streaming mode */
        tStreamingMode currentStreamingMode = SM_OFF;
        GetStreamingMode(OUT currentStreamingMode);

        if((SM_ON == currentStreamingMode)
           &&
           (false == listInfo.streaming))
        {
            /* Set initial playtime because it is used to store last mode while streaming mode change */
            SetPlaytime(IN m_StartTime, IN mediaObject.totalPlaytime, IN true /*validLastMode*/,IN mediaObject.objectID);

            ret = SendEvent(STREAMING_MODE_OFF, (char *)NULL);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
        else if((SM_OFF == currentStreamingMode)
                &&
                (listInfo.streaming))
        {
            ret = SendEvent(STREAMING_MODE_ON, (char *)NULL);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
        else if(isActive)
        {
            /* Set last mode playtime to invalid to prevent storing of current playtime if MP is deallocated immediately (SUZUKI-21186) */
            SetPlaytime(IN m_StartTime, IN mediaObject.totalPlaytime, IN false /*validLastMode*/,IN mediaObject.objectID);

            /* Send START message to own SM */
            ret = SendEvent(START, (char *)NULL);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }

        /*CMG3G-8071:When repeatemode is RPT_ALL,if user selects any track to play,then
         *RepeatMode should switch from RPT_ALL to DBDefaultRepeatMode.
         *
         *PSARCC21-1836:Due user selection of track to play,
         *repeatmode switches from RPT_ALL to RPT_ALL_LISTS(which is DBDefaultRepeatMode for PSA as of now),
         *Hence, 2 NewLists created:1st List is due to User Selection;2nd List is due to repeat mode change
         *2nd List should be created only after PlayerManager begins the User selected track from 1st List.
         */
        if((MP_NO_ERROR == ret) && (LIST_ID_NONE != currentListID) && (currentListID != listID)) //PSARCC-1835:Only when the NewListID different from currentListID,decide for RepeatMode switch
        {
            DecideSwitchingToDefaultRepeatMode();
        }

        if(listInfo.streaming)
        {
            /* Set new streaming object flag */
            m_NewStreamingObject = TRUE;

            if( (DTY_UNKNOWN == mediaObject.deviceType)
                ||
                (DEVICE_ID_NOT_SET == mediaObject.deviceID)
                ||
                (0 == strlen_r(mediaObject.mountPoint)) )
            {
                 /* Try to get device related information for media object */
                tDeviceInfo deviceInfo;
                ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN listInfo.deviceID);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while getting device info from DBManager -> Cannot send play to device control (ErrorCode:%s)", errorString(ret)));
                }
                else
                {
                    mediaObject.deviceType = deviceInfo.deviceType;
                    mediaObject.deviceID = deviceInfo.deviceID;
                    strncpy_r(OUT mediaObject.mountPoint, IN deviceInfo.mountPoint, IN sizeof(mediaObject.mountPoint));
                }
            }

            /* Send STREAMING_MODE_ON message to specific DeviceControlSM */
            char msgToSendString[64];
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);

            strncpy_r(OUT msgToSendString, IN "STREAMING_MODE_ON", IN sizeof(msgToSendString));

            ret = LocalSPM::GetUSBControl().ParameterSTREAMING_MODE_ON(OUT parameterString,
                IN size,
                IN mediaObject.deviceType,
                IN mediaObject.deviceID,
                IN mediaObject.mountPoint);

            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                parameterString[0] = '\0';
            }

            ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mediaObject.deviceType, IN msgToSendString, IN parameterString);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    return ret;
}

tResult PlayerManager::NextMediaObject(const tNextPrevSkipCount steps, const tHMIRequest isHMIRequest)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::NextMediaObject steps:%u, isHMIRequest:%u", steps, isHMIRequest));

    tResult ret = MP_NO_ERROR;

    tListID currentListID = LIST_ID_NONE;
    ret = GetListID(OUT currentListID);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Current listID is not valid -> Cancel NextMediaObject"));
    }
    else
    {
        if (LocalSPM::GetDataProvider().FavoritesSupported())
        {
            /* Deactivate all favorites in DB in case of LTY_SONG */
            tListInfo listInfo;
            tBoolean withListSize = false;
            ret = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN currentListID, IN withListSize);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while getting list info at ListControl (ErrorCode:%s)", errorString(ret)));
            }
            else
            {
                if (LTY_SONG == listInfo.listType)
                {
                    ret = LocalSPM::GetDBManager().DeActivateAllFavorites();
                    if (MP_NO_ERROR != ret)
                    {
                        ETG_TRACE_ERR(("Error while deactivating all favorites in DB (ErrorCode:%s)", errorString(ret)));
                    }
                }
            }
        }

        /* Store last playtime of old media object */
        StoreLastPlaytime();

        /* Skip to next media object in ListControl */
        tListID newListID = currentListID;
        ret = LocalSPM::GetListControl().Next(INOUT newListID, IN steps, IN isHMIRequest);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while setting the next media object at ListControl (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            /* Did the listID change due to following list */
            if( newListID != currentListID )
            {
                NextList(IN newListID,IN false/*tBoolean*/);
            }

            if( LocalSPM::GetDataProvider().LastModePosAfterNext() )
            {
                /* Restore last playtime of current media object */
                RestoreLastPlaytime();
            }
            else
            {
                /* Set start playtime to 0 */
                m_StartTime = 0;
            }

            /* Store last action */
            m_LastAction = PBA_NEXT;

            /* Set auto play flag */
            m_AutoPlayFlag = TRUE;

            /* Delay Next only in playback state PLAYING or PAUSED */
            tHMIPlaybackState playbackState = HMI_PBS_PLAYING;
            ret = CalcPlaybackState(OUT playbackState);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while calculating PlaybackState"));
            }

            if((LocalSPM::GetDataProvider().MultipleNextWaitTime() > 0)
               &&
               (isHMIRequest)
               &&
               ((HMI_PBS_PLAYING == playbackState) || (HMI_PBS_PAUSED == playbackState)))
            {
                /* Inform HMI about new NowPlaying status since the playback will start after wait time */
                ReStartMultipleNextWaitTimer();
                UpdateNowPlayingFromDB();
            }
            else
            {
                /* Send START message to own SM */
                ret = SendEvent(START, (char *) NULL);
                if(MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
                }
            }
        }
    }

    if(MP_NO_ERROR != ret)
    {
        /* Send NO_OBJECT message to own SM */
        tNoObjectReason noObjectReason = NOR_NO_OBJECT;
        //if(MP_ERR_LC_LIST_IS_NOT_PLAYABLE == ret)
        //{
        //    noObjectReason = NOR_LIST_IS_NOT_PLAYABLE;
        //}
        if(MP_ERR_LC_NEXT_AT_END_OF_LIST == ret)
        {
            noObjectReason = NOR_END_OF_LIST;
        }
//Suzuki CRQ 296694 and Bug 265009
        if (LocalSPM::GetDataProvider().FirstItemFromShuffleList()) {

            ETG_TRACE_USR4(("PlayerManager::NextMediaObject  m_FirstErrorObjectID =  %d ",m_FirstErrorObjectID));
            ETG_TRACE_USR4(("PlayerManager::NextMediaObject  m_firstErrorObjectPosition = %d ",m_firstErrorObjectPosition));

            if (0 == m_firstErrorObjectPosition && m_FirstErrorObjectID) {
                ETG_TRACE_USR4(("PlayerManager::NextMediaObject  reset the noObjectReason to noObjectReason "));
                noObjectReason = NOR_NO_OBJECT;
            }
        }
        tResult ret2 = SendNoObject(IN noObjectReason);
        if( MP_NO_ERROR != ret2 )
        {
            ETG_TRACE_ERR(("Error while sending NoObject"));
        }
    }

    return ret;
}

tResult PlayerManager::ReStartMultipleNextWaitTimer()
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    if(m_MultipleNextWaitTimerID != 0)
    {
        m_MultipleNextWaitTimer.CancelTimer(m_MultipleNextWaitTimerID);
        m_MultipleNextWaitTimerID = 0;
    }

    /* Reset elapsed playtime */
    tListID currentListID = LIST_ID_NONE;

    ret = GetListID(OUT currentListID);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Current listID is not valid -> Change to state noObject"));
    }
    else
    {
        /* Get current media object data from ListControl */
        tMediaObject mediaObject;
        mediaObject.objectID = OBJECT_ID_NONE;
        ret = LocalSPM::GetListControl().GetCurrentMediaObject(OUT mediaObject, IN currentListID);
        if((MP_NO_ERROR != ret)
           ||
           (OBJECT_ID_NONE == mediaObject.objectID))
        {
            ETG_TRACE_ERR(("Error while getting current media object from ListControl (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            /* Set internal player manager member Playtime to new value */
            SetPlaytime(IN 0, IN mediaObject.totalPlaytime, IN true /*validLastMode*/,IN mediaObject.objectID);
        }
    }

    m_MultipleNextWaitTimer.StartTimer(OUT m_MultipleNextWaitTimerID,
               IN LocalSPM::GetDataProvider().MultipleNextWaitTime(),
               IN 0L,
               IN &LocalSPM::GetPlayerManager(),
               IN &MultipleNextWaitTimerCallback,
               IN NULL);

    return ret;
}

bool PlayerManager::MultipleNextWaitTimerCallback(timer_t timerID , void* instance ,const void *userData)
{
    ENTRY
    (void)userData;
    tResult ret = MP_NO_ERROR;

    if(NULL == instance)
    {
        ETG_TRACE_ERR(("Invalid parameter: instance is NULL"));
    }
    else
    {
        ETG_TRACE_USR3(("PlayerManager::MultipleNextWaitTimerCallback timerID:0x%X, instance:0x%X", (int)((long)timerID), instance));

        /* Send the TIMEOUT event */
        PlayerManager *self = (PlayerManager*)instance;
        ret = self->SendEventByName("TIMEOUT", (char *) NULL);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
        self->m_MultipleNextWaitTimerID = 0;
    }

    return false;
}

tResult PlayerManager::StopMultipleNextWaitTimer()
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    if(m_MultipleNextWaitTimerID != 0)
    {
        m_MultipleNextWaitTimer.CancelTimer(m_MultipleNextWaitTimerID);
        m_MultipleNextWaitTimerID = 0;
    }

    return ret;
}

tResult PlayerManager::PrevMediaObject(const tNextPrevSkipCount steps, const tHMIRequest isHMIRequest)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::PrevMediaObject steps:%u, isHMIRequest:%u", steps, isHMIRequest));

    tResult ret = MP_NO_ERROR;

    tListID currentListID = LIST_ID_NONE;
    ret = GetListID(OUT currentListID);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Current listID is not valid -> Cancel PrevMediaObject"));
    }
    else
    {
        if (LocalSPM::GetDataProvider().FavoritesSupported())
        {
            /* Deactivate all favorites in DB in case of LTY_SONG */
            tListInfo listInfo;
            tBoolean withListSize = false;
            ret = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN currentListID, IN withListSize);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while getting list info at ListControl (ErrorCode:%s)", errorString(ret)));
            }
            else
            {
                if (LTY_SONG == listInfo.listType)
                {
                    ret = LocalSPM::GetDBManager().DeActivateAllFavorites();
                    if (MP_NO_ERROR != ret)
                    {
                        ETG_TRACE_ERR(("Error while deactivating all favorites in DB (ErrorCode:%s)", errorString(ret)));
                    }
                }
            }
        }

        /* Store last playtime of old media object */
        StoreLastPlaytime();

        /* Decrement steps if media object is not at the beginning
         * -> reset media object to start position */
        tNextPrevSkipCount prevSteps = steps;
        if((false == IsAtBeginningOfPlayback())
            &&
           (0 < prevSteps))
        {
            prevSteps--;
        }

        /* Skip to previous media object in ListControl */
        tListID newListID = currentListID;
        ret = LocalSPM::GetListControl().Prev(INOUT newListID, IN prevSteps, IN isHMIRequest);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while setting the previous media object at ListControl (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            /* Did the listID change due to following list */
            if( newListID != currentListID )
            {
                NextList(IN newListID,false/*tBoolean*/);
            }

            if(PLAYTIME_END_OF_OBJECT != m_StartTime) //Don't overwrite playtime if it is set to end of object
            {
                /* Set start playtime to 0 */
                m_StartTime = 0;
            }
            else if( LocalSPM::GetDataProvider().LastModePosAfterPrev() )
            {
                /* Restore last playtime of current media object */
                RestoreLastPlaytime();
            }

            /* Store last action */
            m_LastAction = PBA_PREV;

            /* Set auto play flag */
            m_AutoPlayFlag = TRUE;

            /* Delay Prev only in playback state PLAYING or PAUSED */
            tHMIPlaybackState playbackState = HMI_PBS_PLAYING;
            ret = CalcPlaybackState(OUT playbackState);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while calculating PlaybackState"));
            }

            if((LocalSPM::GetDataProvider().MultipleNextWaitTime() > 0)
               &&
               (0 < prevSteps) // if skipping to previous track
               &&
               (isHMIRequest)
               &&
               ((HMI_PBS_PLAYING == playbackState) || (HMI_PBS_PAUSED == playbackState)))
            {
                /* Inform HMI about new NowPlaying status since the playback will start after wait time */
                ReStartMultipleNextWaitTimer();
                UpdateNowPlayingFromDB();
            }
            else
            {
                /* Send START message to own SM */
                ret = SendEvent(START, (char *) NULL);
                if(MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
                }
            }
        }
    }

    if( MP_NO_ERROR != ret )
    {
        /* Send NO_OBJECT message to own SM */
        tNoObjectReason noObjectReason = NOR_NO_OBJECT;
        //if(MP_ERR_LC_LIST_IS_NOT_PLAYABLE == ret)
        //{
        //    noObjectReason = NOR_LIST_IS_NOT_PLAYABLE;
        //}
        if(MP_ERR_LC_PREV_AT_START_OF_LIST == ret)
        {
            noObjectReason = NOR_START_OF_LIST;
        }

        tResult ret2 = SendNoObject(IN noObjectReason);
        if( MP_NO_ERROR != ret2 )
        {
            ETG_TRACE_ERR(("Error while sending NoObject"));
        }
    }

    return ret;
}

tResult PlayerManager::PlayMediaObject()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::PlayMediaObject"));

    tResult ret = MP_NO_ERROR;

    /* Get current media object data from ListControl */
    tListID currentListID = LIST_ID_NONE;

    ret = GetListID(OUT currentListID);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Current listID is not valid -> Change to state noObject"));
    }
    else
    {
        tMediaObject mediaObject;
        mediaObject.objectID = OBJECT_ID_NONE;
        ret = LocalSPM::GetListControl().GetCurrentMediaObject(OUT mediaObject, IN currentListID);
        if((MP_NO_ERROR != ret)
           ||
           (OBJECT_ID_NONE == mediaObject.objectID))
        {
            ETG_TRACE_ERR(("Error while getting current media object from ListControl (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            if(LocalSPM::GetDataProvider().TrackScanningSupported())
            {
                /*Turn OFF scan if the First scanned mediaObject is about to be played Again in the currently playing list
                i.e All the Items in the List is scanned and the Scanning of the items in the list about to begin for the second time.
                The m_HMIPlaybackState == HMI_PBS_PLAYING is added to avoid turning-off scan if user Being in PAUSED(i.e PAUSE->Enter TUNER/FM etc.->Enter Media Again and seen to remain in Paused state) activates scan which leads to RESUME event& hence this scenario will occur.
                */
                if(mIsScanMode)
                {
                    if((m_firstScannedMediaObjectID == mediaObject.objectID) && ( HMI_PBS_PLAYING == m_HMIPlaybackState))
                    {
                        ETG_TRACE_USR4(("m_firstScannedMediaObjectID reached when HMI already being in Playing State.Hence Stopping Scan"));
                        PrepAndSendScanMessage(IN mediaObject.deviceType, IN mediaObject.deviceID, IN (tScanMode)false);
                    }
                }
                else
                {
                    ETG_TRACE_USR4(("No Need to Request DeviceControl to turn-off scan as it is already OFF"));
                }
            }
            /* Remove all old messages coming from device from queue of own SM */
            RemoveMessageByName("PLAYBACK_STATUS_RESPONSE");
            RemoveMessageByName("PLAYBACK_STATUS");
            RemoveMessageByName("NOW_PLAYING_STATUS");
            //RemoveMessageByName("TICK_TIME_ELAPSED"); obsolete event
            RemoveMessageByName("PLAYTIME_STATUS");
            RemoveMessageByName("ALBUM_ART_STATUS");
            //RemoveMessageByName("PLAYBACK_MODE_STATUS"); //Do not remove because this event is coming from the device spontaneously and only once (JAC2-5497)
            //RemoveMessageByName("REPEAT_MODE_STATUS"); //Do not remove because this event is coming from the device spontaneously and only once (JAC2-5497)
            RemoveMessageByName("STREAM_ERROR");

            RemoveMessageByName("PLAY_ANSWER");
            RemoveMessageByName("PLAY_ANSWER_NEW");
            RemoveMessageByName("RESUME_ANSWER");
            RemoveMessageByName("RESUME_ANSWER_NEW");

            /* Store mediaObject internally */
            SetMediaObject(IN mediaObject);

            /* Set start playtime */
            tPlaytime elapsedPlaytime = 0;
            if(0 != m_StartTime)
            {
                if(PLAYTIME_END_OF_OBJECT == m_StartTime)
                {
                    /* Set start playtime to end of object */
                    if(1000 <= mediaObject.totalPlaytime)
                    {
                        elapsedPlaytime = mediaObject.totalPlaytime - 1000;
                    }
                }
                else
                {
                    /* Set start playtime to dedicated start time */
                    elapsedPlaytime = m_StartTime;
                }

                //m_StartTime = 0; //Reset to normal behaviour (disabled because of CMG3GB-804)
            }

            /* Set initial playtime, refer to GMNGA-57544 */
            SetPlaytime(IN elapsedPlaytime, IN mediaObject.totalPlaytime, IN true /*validLastMode*/,IN mediaObject.objectID);

            /* Reset album art availability to true (without update NowPlaying to HMI)*/
            SetAlbumArtAvailability(IN true, IN false);

            if(DTY_MTP == mediaObject.deviceType)
            {
                tListInfo listInfo;
                LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN currentListID, IN false);
                if((IsPlayableList(listInfo.listType)) && (!IsFileList(listInfo.listType))){
                    if(strlen_r(listInfo.path)){
                        strncat_r(mediaObject.fileName,"#",sizeof(mediaObject.fileName));
                        strncat_r(mediaObject.fileName,listInfo.path,sizeof(mediaObject.fileName));
                    }
                }
            }
            /* Enable/disable video layer
             * Not necessary yet because HMI is doing that independently */

            /* Send PLAY message to DeviceDispatcherSM */
            char msgToSendString[64];
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            char answerMsgString[64];

            strncpy_r(OUT msgToSendString, IN "DeviceDispatcherSM::PLAY", IN sizeof(msgToSendString));
            if( LocalSPM::GetDataProvider().UseMediaEngine() )
            {
                strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::PLAY_ANSWER_NEW", IN sizeof(answerMsgString));
            }
            else
            {
                strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::PLAY_ANSWER", IN sizeof(answerMsgString));
            }

            tStreaming streaming = false;
            ret = LocalSPM::GetDeviceDispatcher().ParameterPLAY(OUT parameterString,
                    IN size,
                    IN mediaObject.deviceType,
                    IN mediaObject.deviceID,
                    IN mediaObject.fileName,
                    IN mediaObject.mountPoint,
                    IN mediaObject.UUID,
                    IN (tPEHandle)mediaObject.objectID,
                    IN elapsedPlaytime,
                    IN streaming);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                parameterString[0] = '\0';
            }

            ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
            }

            /* Check if deviceType is able to buffer something and gapless play is configured by DataProvider */
            if(IsMassStorageDevice(IN mediaObject.deviceType) //DTY_USB, DTY_SD, DTY_CDROM, DTY_FLASH
               &&
               LocalSPM::GetDataProvider().GaplessPlay())
            {
                /* Set current buffer index */
                tPosition position;
                ret = LocalSPM::GetListControl().GetPositionInList(OUT position, IN currentListID, IN mediaObject.objectID);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while getting position in list from ListControl -> Cannot set buffer index (ErrorCode:%s)", errorString(ret)));
                }
                else
                {
                    SetBufferIndex(IN position);
                }
            }
        }
    }

    if( MP_NO_ERROR != ret )
    {
        /* Send NO_OBJECT message to own SM */
        tResult ret2 = SendNoObject(NOR_NO_OBJECT);
        if( MP_NO_ERROR != ret2 )
        {
            ETG_TRACE_ERR(("Error while sending NoObject"));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult PlayerManager::PlayMediaObjectStreaming()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::PlayMediaObjectStreaming"));

    tResult ret = MP_NO_ERROR;

    /* Get current media object data from ListControl */
    tListID currentListID = LIST_ID_NONE;

    ret = GetListID(OUT currentListID);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Current listID is not valid -> Change to state noObject"));
    }
    else
    {
        tMediaObject mediaObject;

        if(FALSE == m_NewStreamingObject)
        {
            ret = LocalSPM::GetListControl().SetMediaObject(OUT mediaObject, IN currentListID, IN INDEX_LAST_ACTIVE_OBJECT);
        }
        else
        {
            ret = LocalSPM::GetListControl().GetCurrentMediaObject(OUT mediaObject, IN currentListID);
        }

        //TODO(pee1cob): When GetCurrentMediaObject failed,why doing GetDevicePartOfMediaObject ?.
        //This makes res == MP_NO_ERROR  & PlyerManager tries playback when the objectID is OBJECT_ID_NONE .Bug!
        if((MP_NO_ERROR != ret)
           ||
           (DTY_UNKNOWN == mediaObject.deviceType)
           ||
           (DEVICE_ID_NOT_SET == mediaObject.deviceID)
           ||
           (0 == strlen_r(mediaObject.mountPoint)))
        {
            /* Try to get device related information for media object via current listID */
            ret = GetDevicePartOfMediaObject(OUT mediaObject);
        }

        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while getting current media object -> Cancel PlayMediaObjectStreaming and fake answer (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            /* Remove all old messages coming from device from queue of own SM */
            tMediaObject currentMediaObject;
            InitMediaObject(currentMediaObject);
            ret = GetMediaObject(currentMediaObject);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while getting current media object (ErrorCode:%s)", errorString(ret)));
            }
            // Do not remove messages of the same device since it might clear the valid update NCG3D-93911
            if(mediaObject.deviceID != currentMediaObject.deviceID)
            {
            RemoveMessageByName("PLAYBACK_STATUS_RESPONSE");
            RemoveMessageByName("PLAYBACK_STATUS");
            RemoveMessageByName("NOW_PLAYING_STATUS");

            RemoveMessageByName("PLAYTIME_STATUS");
            }
            RemoveMessageByName("ALBUM_ART_STATUS");
            //RemoveMessageByName("PLAYBACK_MODE_STATUS"); //Do not remove because this event is coming from the device spontaneously and only once (JAC2-5497)
            //RemoveMessageByName("REPEAT_MODE_STATUS"); //Do not remove because this event is coming from the device spontaneously and only once (JAC2-5497)
            RemoveMessageByName("STREAM_ERROR");

            RemoveMessageByName("STOP_ANSWER");
            RemoveMessageByName("STOP_ANSWER_NEW");
            RemoveMessageByName("PLAY_ANSWER");
            RemoveMessageByName("PLAY_ANSWER_NEW");
            RemoveMessageByName("PLAYBACK_ACTION_ANSWER");
            //RemoveMessageByName("SEEK_TO_ANSWER"); obsolete event
            RemoveMessageByName("SEEK_TO_ANSWER_NEW");
            RemoveMessageByName("ACTION_ERROR");

            /* Delete file name of media object to only resume playback */
            if((FALSE == m_NewStreamingObject)
               &&
               (LocalSPM::GetDataProvider().IsPermanentStreamingActive(mediaObject.deviceType))
               &&
               (mediaObject.deviceType == DTY_BLUETOOTH)) //special handling BT only
            {
                mediaObject.fileName[0] = 0;
            }

            /* Store mediaObject internally */
            SetMediaObject(IN mediaObject);

            //m_StartTime = 0; //Reset to normal behaviour (disabled because of CMG3GB-804)

            /* Set initial playtime, refer to GMNGA-57544 */
            //SetPlaytime(IN PLAYTIME_NONE, IN mediaObject.totalPlaytime, IN true /*validLastMode*/);

            //Fix for Bug 342570 set the albumart availability to false.
            /* Reset album art availability to false (without update NowPlaying to HMI)*/
            if(mediaObject.deviceType != DTY_BLUETOOTH)
            {
                SetAlbumArtAvailability(IN false, IN false);
            }

            /* Enable/disable video layer
             * Not necessary yet because HMI is doing that independently */

            /* Send PLAY message to DeviceDispatcherSM */
            char msgToSendString[64];
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            char answerMsgString[64];

            strncpy_r(OUT msgToSendString, IN "DeviceDispatcherSM::PLAY", IN sizeof(msgToSendString));
            if( LocalSPM::GetDataProvider().UseMediaEngine() )
            {
                strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::PLAY_ANSWER_NEW", IN sizeof(answerMsgString));
            }
            else
            {
                strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::PLAY_ANSWER", IN sizeof(answerMsgString));
            }

            ret = LocalSPM::GetDeviceDispatcher().ParameterPLAY(OUT parameterString,
                    IN size,
                    IN mediaObject.deviceType,
                    IN mediaObject.deviceID,
                    IN mediaObject.fileName,
                    IN mediaObject.mountPoint,
                    IN mediaObject.UUID,
                    IN (tPEHandle)mediaObject.objectID,
                    IN PLAYTIME_NONE,
                    IN (tStreaming)currentListID); //send listID in parameter streaming
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                parameterString[0] = '\0';
            }

            ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    if( MP_NO_ERROR != ret )
    {
        /* Send PLAY_ANSWER message to own SM */
        tResult ret2 = SendEvent(IN PLAY_ANSWER, (char *)NULL);
        if( MP_NO_ERROR != ret2 )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    /* Reset new streaming object flag */
    m_NewStreamingObject = FALSE;

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult PlayerManager::StopMediaObject()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::StopMediaObject"));

    tResult ret = MP_NO_ERROR;

    /* Reset playtime */
    //SetPlaytime(IN 0, IN 0, IN false /*validLastMode*/);

    //Normally in streaming mode the media object should come from DB (VTiPod) and not from PlayerManager internal,
    //but in this case only the mount point is used by DeviceControl and it is the same
    tMediaObject currentMediaObject;
    ret = GetMediaObject(OUT currentMediaObject);
    if((MP_NO_ERROR != ret)
       ||
       (DTY_UNKNOWN == currentMediaObject.deviceType)
       ||
       (DEVICE_ID_NOT_SET == currentMediaObject.deviceID)
       ||
       (0 == strlen_r(currentMediaObject.mountPoint)))
    {
        /* Try to get device related information for media object via current listID */
        ret = GetDevicePartOfMediaObject(OUT currentMediaObject);
    }

    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while getting current media object -> Cancel StopMediaObect and fake answer (ErrorCode:%s)", errorString(ret)));
    }
    else
    {
        /* Disable video layer
         * Not necessary yet because HMI is doing that independently */
        if(LocalSPM::GetDataProvider().TrackScanningSupported())
        {
            if( mIsScanMode)
            {
                ETG_TRACE_USR3(("Turning-off Scan as StopMediaObject get called For currentMediaObject.deviceType:%u,currentMediaObject.deviceID:%u",currentMediaObject.deviceType,currentMediaObject.deviceID));
                PrepAndSendScanMessage(IN currentMediaObject.deviceType, IN currentMediaObject.deviceID, IN (tScanMode)false);
            }
            else
            {
                ETG_TRACE_USR4(("No Need to Request DeviceControl to turn-off scan as it is already OFF"));
            }
        }

        /* Send STOP message to specific DeviceControlSM */
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];

        //strncpy_r(OUT msgToSendString, IN "STOP", IN sizeof(msgToSendString));
        strncpy_r(OUT msgToSendString, IN "DeviceDispatcherSM::STOP", IN sizeof(msgToSendString));
        if( LocalSPM::GetDataProvider().UseMediaEngine() )
        {
            strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::STOP_ANSWER_NEW", IN sizeof(answerMsgString));
        }
        else
        {
            strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::STOP_ANSWER", IN sizeof(answerMsgString));
        }

        ret = LocalSPM::GetDeviceDispatcher().ParameterSTOP(OUT parameterString,
                IN size,
                IN currentMediaObject.deviceType,   //Not used in specific DeviceControl
                IN currentMediaObject.deviceID,     //Not used in specific DeviceControl
                IN currentMediaObject.fileName,     //Not used in specific DeviceControl
                IN currentMediaObject.mountPoint);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        //ret = LocalSPM::GetDeviceDispatcher().RouteMessageAnswer(IN currentMediaObject.deviceType, IN msgToSendString,
        //        IN parameterString, IN answerMsgString);
        ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling RouteMessageAnswer of DeviceDispatcher (ErrorCode:%s)", errorString(ret)));
        }
    }

    if( MP_NO_ERROR != ret )
    {
        /* Send STOP_ANSWER message to own SM */
        tResult ret2 = SendEvent(STOP_ANSWER, (char *)NULL);
        if(MP_NO_ERROR != ret2)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret2)));
        }
    }

    /* Reset play context of DeviceDispatcher to make the whole play loop
     * for the next media object again (startAudioInput, startStreaming, ...) */
    //LocalSPM::GetDeviceDispatcher().ResetContext(); now done in DeviceDispatcher::StartStop

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult PlayerManager::PauseMediaObject()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::PauseMediaObject"));

    tResult ret = MP_NO_ERROR;

    /* Set start playtime */
    tPlaytime elapsedPlaytime = PLAYTIME_NONE;
    ret = GetLastModePlaytime(OUT elapsedPlaytime);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while getting current playtime -> Cannot set start playtime"));
    }
    else
    {
        if(PLAYTIME_NONE != elapsedPlaytime) //Playtime is not reset
        {
            m_StartTime = elapsedPlaytime;
        }
    }

    /* Pause playback */
    tMediaObject currentMediaObject;
    ret = GetMediaObject(OUT currentMediaObject);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while getting current media object-> Cancel PauseResetTime and fake answer"));
    }
    else
    {
        /* Send PAUSE message to specific DeviceControlSM */
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];

        //strncpy_r(OUT msgToSendString, IN "PAUSE", IN sizeof(msgToSendString));
        strncpy_r(OUT msgToSendString, IN "DeviceDispatcherSM::PAUSE", IN sizeof(msgToSendString));
        if( LocalSPM::GetDataProvider().UseMediaEngine() )
        {
            strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::PAUSE_ANSWER_NEW", IN sizeof(answerMsgString));
        }
        else
        {
            strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::PAUSE_ANSWER", IN sizeof(answerMsgString));
        }

        ret = LocalSPM::GetDeviceDispatcher().ParameterPAUSE(OUT parameterString,
                IN size,
                IN currentMediaObject.deviceType,
                IN currentMediaObject.deviceID,
                IN currentMediaObject.fileName,
                IN currentMediaObject.mountPoint);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        //ret = LocalSPM::GetDeviceDispatcher().RouteMessageAnswer(IN currentMediaObject.deviceType, IN msgToSendString, IN parameterString, IN answerMsgString);
        ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling RouteMessageAnswer of DeviceDispatcher (ErrorCode:%s)", errorString(ret)));
        }
    }

    if( MP_NO_ERROR != ret )
    {
        /* Send PAUSE_ANSWER message to own SM */
        tResult ret2 = SendEvent(PAUSE_ANSWER, (char *)NULL);
        if(MP_NO_ERROR != ret2)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret2)));
        }
    }

    return ret;
}

tResult PlayerManager::ResumeMediaObject()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::ResumeMediaObject"));

    tResult ret = MP_NO_ERROR;

    /* Reset start playtime */
    //m_StartTime = 0; (disabled because of CMG3GB-804)

    tMediaObject currentMediaObject;
    ret = GetMediaObject(OUT currentMediaObject);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while getting current media object -> Change to state noObject"));
    }
    else
    {
        /* Send RESUME message to specific DeviceControlSM */
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];

        //strncpy_r(OUT msgToSendString, IN "RESUME", IN sizeof(msgToSendString));
        strncpy_r(OUT msgToSendString, IN "DeviceDispatcherSM::RESUME", IN sizeof(msgToSendString));
        if( LocalSPM::GetDataProvider().UseMediaEngine() )
        {
            strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::RESUME_ANSWER_NEW", IN sizeof(answerMsgString));
        }
        else
        {
            strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::RESUME_ANSWER", IN sizeof(answerMsgString));
        }

        ret = LocalSPM::GetDeviceDispatcher().ParameterRESUME(OUT parameterString,
                IN size,
                IN currentMediaObject.deviceType,
                IN currentMediaObject.deviceID,
                IN currentMediaObject.fileName,
                IN currentMediaObject.mountPoint);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        //ret = LocalSPM::GetDeviceDispatcher().RouteMessageAnswer(IN currentMediaObject.deviceType, IN msgToSendString,
        //        IN parameterString, IN answerMsgString);
        ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling RouteMessageAnswer of DeviceDispatcher (ErrorCode:%s)", errorString(ret)));
        }
    }

    if( MP_NO_ERROR != ret )
    {
        /* Send NO_OBJECT message to own SM */
        tResult ret2 = SendNoObject(NOR_NO_OBJECT);
        if( MP_NO_ERROR != ret2 )
        {
            ETG_TRACE_ERR(("Error while sending NoObject"));
        }
    }

    return ret;
}

tResult PlayerManager::FastForwardStart() //Roadmap 13018: 100%
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::FastForwardStart"));
    ETG_TRACE_USR3(("----------------------> playbackspeed:%u, isplaybackspeed:%u, pplayblackspeed: %u",curPlaybackSpeed, IsPlaybackSpeed, pPlaybackSpeed));
    tResult ret = MP_NO_ERROR;

    tMediaObject currentMediaObject;
    ret = GetMediaObject(OUT currentMediaObject);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while getting current media object -> Change to state noObject"));
    }
    else
    {
        /* Send request reduce volume to AudioManagement via OutputWrapper if configured */
        if( LocalSPM::GetDataProvider().FFVolumeReduction() )
        {
            tVolumeState volumeState = VOS_REDUCED;
            ret = LocalSPM::GetOutputWrapper().RequestVolumeChange(IN volumeState);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while requesting reduce volume at OutputWrapper (ErrorCode:%s)", errorString(ret)));
            }
        }

        /* Send FFWD message to specific DeviceControlSM */
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];
        tCueingRate rate;

        if(ME_SPEEDSTATE_ON == IsPlaybackSpeed)
        {
            if((int_t)PBK_SPEED_INCREASE == (int_t)pPlaybackSpeed )
            {
                if(curPlaybackSpeed<LocalSPM::GetDataProvider().MaximumPlaybackspeed())
                    curPlaybackSpeed = (tPlaybackSpeed)(curPlaybackSpeed+1);
                else
                    curPlaybackSpeed = (tPlaybackSpeed)(curPlaybackSpeed);
            }
            else if ((int_t)PBK_SPEED_DECREASE == (int_t)pPlaybackSpeed)
            {
                if(curPlaybackSpeed>LocalSPM::GetDataProvider().MinimumPlaybackspeed())
                    curPlaybackSpeed = (tPlaybackSpeed)(curPlaybackSpeed-1);
                else
                    curPlaybackSpeed = (tPlaybackSpeed)(curPlaybackSpeed);
            }
            else
            {
                curPlaybackSpeed = (tPlaybackSpeed)pPlaybackSpeed;//PBK_SPEED_2X;//
            }
            ret = convertPlaybackSpeed(curPlaybackSpeed);
            rate = pPlaybackSpeed;

            ret = LocalSPM::GetOutputWrapper().UpdatePlaybackSpeed();
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while updating playbackspeed to registered clients"));
            }

            ETG_TRACE_USR3(("PlayerManager::FastForwardStart:playbackSpeed:%d", rate));
        }
        else
        {
             rate = LocalSPM::GetDataProvider().CueingRate(); // 10; //after every second jump 10s
            ETG_TRACE_USR3(("PlayerManager::FastForwardStart:CueingRate:%d", rate));
        }

        //strncpy_r(OUT msgToSendString, IN "FFWD", IN sizeof(msgToSendString));
        strncpy_r(OUT msgToSendString, IN "DeviceDispatcherSM::FFWD", IN sizeof(msgToSendString));
        if( LocalSPM::GetDataProvider().UseMediaEngine() )
        {
            strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::FFWD_ANSWER_NEW", IN sizeof(answerMsgString));
        }
        else
        {
            strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::FFWD_ANSWER", IN sizeof(answerMsgString));
        }

        ret = LocalSPM::GetDeviceDispatcher().ParameterFFWD(OUT parameterString,
                IN size,
                IN currentMediaObject.deviceType,
                IN currentMediaObject.deviceID,
                IN currentMediaObject.fileName,
                IN currentMediaObject.mountPoint,
                IN rate,
                IN IsPlaybackSpeed);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        //ret = LocalSPM::GetDeviceDispatcher().RouteMessageAnswer(IN currentMediaObject.deviceType, IN msgToSendString,
        //        IN parameterString, IN answerMsgString);
        ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling RouteMessageAnswer of DeviceDispatcher (ErrorCode:%s)", errorString(ret)));
        }
    }

    if( MP_NO_ERROR != ret )
    {
        /* Send FFWD_ANSWER message to own SM */
        tResult ret2 = SendEvent(FFWD_ANSWER, (char *)NULL);
        if(MP_NO_ERROR != ret2)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret2)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}
tResult PlayerManager::convertPlaybackSpeed(tPlaybackSpeed curPlaybackSpeed)
{
    switch(curPlaybackSpeed)
    {
        case PBK_SPEED_0_2X:
            pPlaybackSpeed = (me::speed_e)20;
            break;
        case PBK_SPEED_0_5X:
            pPlaybackSpeed = (me::speed_e)50;
            break;
        case PBK_SPEED_1X:
            pPlaybackSpeed = (me::speed_e)100;
            break;
        case PBK_SPEED_2X:
            pPlaybackSpeed = (me::speed_e)200;
            break;
        case PBK_SPEED_4X:
            pPlaybackSpeed = (me::speed_e)400;
            break;
        case PBK_SPEED_8X:
            pPlaybackSpeed = (me::speed_e)800;
            break;
        case PBK_SPEED_16X:
            pPlaybackSpeed = (me::speed_e)1600;
            break;
        case PBK_SPEED_32X:
            pPlaybackSpeed = (me::speed_e)3200;
            break;
        default:
            break;
    }
    return pPlaybackSpeed;
}
tResult PlayerManager::FastForwardStop() //Roadmap 13018: 100%
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::FastForwardStop"));

    tResult ret = MP_NO_ERROR;
    curPlaybackSpeed = PBK_SPEED_1X;
    tMediaObject currentMediaObject;
    ret = GetMediaObject(OUT currentMediaObject);
    if( MP_NO_ERROR != ret )
    {
       ETG_TRACE_ERR(("Error while getting current media object -> Change to state noObject"));
    }
    else
    {
        /* Try to get device connection state */
        tDeviceConnected connected = true;
        tDeviceInfo deviceInfo;
        ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN currentMediaObject.deviceID);
        if( MP_NO_ERROR != ret )
        {
           ETG_TRACE_ERR(("Error while getting device info from DBManager (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
           connected = deviceInfo.connected;
        }

        if(connected) //Device is still connected
        {
            /* Send request normal volume to AudioManagement via OutputWrapper if configured */
            if( LocalSPM::GetDataProvider().FFVolumeReduction() )
            {
                tVolumeState volumeState = VOS_NORMAL;
                ret = LocalSPM::GetOutputWrapper().RequestVolumeChange(IN volumeState);
                if (MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while requesting normal volume at OutputWrapper (ErrorCode:%s)", errorString(ret)));
                }
            }
            ret = LocalSPM::GetOutputWrapper().UpdatePlaybackSpeed();
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while updating playbackspeed to registered clients"));
            }
            /* Send FFWD_STOP message to specific DeviceControlSM */
            char msgToSendString[64];
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            char answerMsgString[64];

            //strncpy_r(OUT msgToSendString, IN "FFWD_STOP", IN sizeof(msgToSendString));
            strncpy_r(OUT msgToSendString, IN "DeviceDispatcherSM::FFWD_STOP", IN sizeof(msgToSendString));
            if( LocalSPM::GetDataProvider().UseMediaEngine() )
            {
                strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::FFWD_STOP_ANSWER_NEW", IN sizeof(answerMsgString));
            }
            else
            {
                strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::FFWD_STOP_ANSWER", IN sizeof(answerMsgString));
            }

            ret = LocalSPM::GetDeviceDispatcher().ParameterFFWD_STOP(OUT parameterString,
                    IN size,
                    IN currentMediaObject.deviceType,
                    IN currentMediaObject.deviceID,
                    IN currentMediaObject.fileName,
                    IN currentMediaObject.mountPoint,
                    IN IsPlaybackSpeed);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                parameterString[0] = '\0';
            }

            //ret = LocalSPM::GetDeviceDispatcher().RouteMessageAnswer(IN currentMediaObject.deviceType, IN msgToSendString,
            //        IN parameterString, IN answerMsgString);
            ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while calling RouteMessageAnswer of DeviceDispatcher (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    if( MP_NO_ERROR != ret )
    {
        /* Send NO_OBJECT message to own SM */
        tResult ret2 = SendNoObject(NOR_NO_OBJECT);
        if( MP_NO_ERROR != ret2 )
        {
            ETG_TRACE_ERR(("Error while sending NoObject"));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult PlayerManager::FastReverseStart() //Roadmap 13018: 100%
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::FastReverseStart"));

    tResult ret = MP_NO_ERROR;

    tMediaObject currentMediaObject;
    ret = GetMediaObject(OUT currentMediaObject);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while getting current media object -> Change to state noObject"));
    }
    else
    {
        /* Send request reduce volume to AudioManagement via OutputWrapper if configured */
        if( LocalSPM::GetDataProvider().FFVolumeReduction() )
        {
            tVolumeState volumeState = VOS_REDUCED;
            ret = LocalSPM::GetOutputWrapper().RequestVolumeChange(IN volumeState);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while requesting reduce volume at OutputWrapper (ErrorCode:%s)", errorString(ret)));
            }
        }

        /* Send FREV message to specific DeviceControlSM */
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];
        tCueingRate rate;
        if(ME_SPEEDSTATE_ON == IsPlaybackSpeed)
        {
            if((int_t)PBK_SPEED_INCREASE == (int_t)pPlaybackSpeed )
            {
                if(curPlaybackSpeed<LocalSPM::GetDataProvider().MaximumPlaybackspeed())
                    curPlaybackSpeed = (tPlaybackSpeed)(curPlaybackSpeed+1);
                else if (curPlaybackSpeed == LocalSPM::GetDataProvider().MaximumPlaybackspeed())
                    curPlaybackSpeed = (tPlaybackSpeed)(curPlaybackSpeed);
            }
            else if ((int_t)PBK_SPEED_DECREASE == (int_t)pPlaybackSpeed)
            {
                if(curPlaybackSpeed>LocalSPM::GetDataProvider().MinimumPlaybackspeed())
                    curPlaybackSpeed = (tPlaybackSpeed)(curPlaybackSpeed-1);
                else if (curPlaybackSpeed == LocalSPM::GetDataProvider().MinimumPlaybackspeed())
                    curPlaybackSpeed = (tPlaybackSpeed)(curPlaybackSpeed);
            }
            else
            {
                curPlaybackSpeed = (tPlaybackSpeed)pPlaybackSpeed;
            }
            ret = convertPlaybackSpeed(curPlaybackSpeed);
            rate = pPlaybackSpeed;
            ret = LocalSPM::GetOutputWrapper().UpdatePlaybackSpeed();
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while updating playbackspeed to registered clients"));
            }
            ETG_TRACE_USR3(("PlayerManager::FastReverseStart:PlaybackSpeed:%d", rate));
        }
        else
        {
            rate = LocalSPM::GetDataProvider().CueingRate(); // 10; //after every second jump 10s
            ETG_TRACE_USR3(("PlayerManager::FastReverseStart:CueingRate:%d", rate));
        }
        //strncpy_r(OUT msgToSendString, IN "FREV", IN sizeof(msgToSendString));
        strncpy_r(OUT msgToSendString, IN "DeviceDispatcherSM::FREV", IN sizeof(msgToSendString));
        if( LocalSPM::GetDataProvider().UseMediaEngine() )
        {
            strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::FREV_ANSWER_NEW", IN sizeof(answerMsgString));
        }
        else
        {
            strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::FREV_ANSWER", IN sizeof(answerMsgString));
        }

        ret = LocalSPM::GetDeviceDispatcher().ParameterFREV(OUT parameterString,
                IN size,
                IN currentMediaObject.deviceType,
                IN currentMediaObject.deviceID,
                IN currentMediaObject.fileName,
                IN currentMediaObject.mountPoint,
                IN rate,
                IN IsPlaybackSpeed);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        //ret = LocalSPM::GetDeviceDispatcher().RouteMessageAnswer(IN currentMediaObject.deviceType, IN msgToSendString,
        //        IN parameterString, IN answerMsgString);
        ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling RouteMessageAnswer of DeviceDispatcher (ErrorCode:%s)", errorString(ret)));
        }
    }

    if( MP_NO_ERROR != ret )
    {
        /* Send FREV_ANSWER message to own SM */
        tResult ret2 = SendEvent(FREV_ANSWER, (char *)NULL);
        if(MP_NO_ERROR != ret2)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret2)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult PlayerManager::FastReverseStop() //Roadmap 13018: 100%
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::FastReverseStop"));

    tResult ret = MP_NO_ERROR;
    curPlaybackSpeed = PBK_SPEED_1X;
    tMediaObject currentMediaObject;
    ret = GetMediaObject(OUT currentMediaObject);
    if( MP_NO_ERROR != ret )
    {
       ETG_TRACE_ERR(("Error while getting current media object -> Change to state noObject"));
    }
    else
    {
        /* Try to get device connection state */
        tDeviceConnected connected = true;
        tDeviceInfo deviceInfo;
        ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN currentMediaObject.deviceID);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while getting device info from DBManager (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            connected = deviceInfo.connected;
        }

        if(connected) //Device is still connected
        {
            /* Send request normal volume to AudioManagement via OutputWrapper if configured */
            if( LocalSPM::GetDataProvider().FFVolumeReduction() )
            {
                tVolumeState volumeState = VOS_NORMAL;
                ret = LocalSPM::GetOutputWrapper().RequestVolumeChange(IN volumeState);
                if (MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while requesting normal volume at OutputWrapper (ErrorCode:%s)", errorString(ret)));
                }
            }
            ret = LocalSPM::GetOutputWrapper().UpdatePlaybackSpeed();
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while updating playbackspeed to registered clients"));
            }

            /* Send FREV_STOP message to specific DeviceControlSM */
            char msgToSendString[64];
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            char answerMsgString[64];

            //strncpy_r(OUT msgToSendString, IN "FREV_STOP", IN sizeof(msgToSendString));
            strncpy_r(OUT msgToSendString, IN "DeviceDispatcherSM::FREV_STOP", IN sizeof(msgToSendString));
            if( LocalSPM::GetDataProvider().UseMediaEngine() )
            {
                strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::FREV_STOP_ANSWER_NEW", IN sizeof(answerMsgString));
            }
            else
            {
                strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::FREV_STOP_ANSWER", IN sizeof(answerMsgString));
            }

            ret = LocalSPM::GetDeviceDispatcher().ParameterFREV_STOP(OUT parameterString,
                   IN size,
                   IN currentMediaObject.deviceType,
                   IN currentMediaObject.deviceID,
                   IN currentMediaObject.fileName,
                   IN currentMediaObject.mountPoint,
                   IN IsPlaybackSpeed);
            if(MP_NO_ERROR != ret)
            {
               ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
               parameterString[0] = '\0';
            }

            //ret = LocalSPM::GetDeviceDispatcher().RouteMessageAnswer(IN currentMediaObject.deviceType, IN msgToSendString,
            //        IN parameterString, IN answerMsgString);
            ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
            if(MP_NO_ERROR != ret)
            {
               ETG_TRACE_ERR(("Error while calling RouteMessageAnswer of DeviceDispatcher (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    if( MP_NO_ERROR != ret )
    {
        /* Send NO_OBJECT message to own SM */
        tResult ret2 = SendNoObject(NOR_NO_OBJECT);
        if( MP_NO_ERROR != ret2 )
        {
            ETG_TRACE_ERR(("Error while sending NoObject"));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult PlayerManager::ActiveSeekTo(const tPlaytime position)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::ActiveSeekTo position:%u", position));

    tResult ret = MP_NO_ERROR;

    //Normally in streaming mode the media object should come from DB (VTiPod) and not from PlayerManager internal,
    //but in this case only the mount point is used by DeviceControl and it is the same
    tMediaObject currentMediaObject;
    ret = GetMediaObject(OUT currentMediaObject);
    if((MP_NO_ERROR != ret)
       ||
       (DTY_UNKNOWN == currentMediaObject.deviceType)
       ||
       (DEVICE_ID_NOT_SET == currentMediaObject.deviceID)
       ||
       (0 == strlen_r(currentMediaObject.mountPoint)))
    {
        /* Try to get device related information for media object via current listID */
        ret = GetDevicePartOfMediaObject(OUT currentMediaObject);
    }

    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while getting current media object -> Cancel ActiveSeekTo and fake answer (ErrorCode:%s)", errorString(ret)));
    }
    else
    {
        /* Send SEEK_TO message to specific DeviceControlSM */
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];

        //strncpy_r(OUT msgToSendString, IN "SEEK_TO", IN sizeof(msgToSendString));
        strncpy_r(OUT msgToSendString, IN "DeviceDispatcherSM::SEEK_TO", IN sizeof(msgToSendString));
        //if( LocalSPM::GetDataProvider().UseMediaEngine() )
        //{
            strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::SEEK_TO_ANSWER_NEW", IN sizeof(answerMsgString));
        //}
        //else
        //{
        //    strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::SEEK_TO_ANSWER", IN sizeof(answerMsgString));
        //}

        ret = LocalSPM::GetDeviceDispatcher().ParameterSEEK_TO(OUT parameterString,
                IN size,
                IN currentMediaObject.deviceType,   //Not used in specific DeviceControl
                IN currentMediaObject.deviceID,     //Not used in specific DeviceControl
                IN currentMediaObject.fileName,     //Not used in specific DeviceControl
                IN currentMediaObject.mountPoint,
                IN position);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        //ret = LocalSPM::GetDeviceDispatcher().RouteMessageAnswer(IN currentMediaObject.deviceType,
        //        IN msgToSendString, IN parameterString, IN answerMsgString);
        ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling RouteMessageAnswer of DeviceDispatcher (ErrorCode:%s)", errorString(ret)));
        }
    }

    if( MP_NO_ERROR != ret )
    {
        /* Send SEEK_TO_ANSWER_NEW message to own SM */
        tResult ret2 = SendEvent(SEEK_TO_ANSWER_NEW, (char *)NULL);
        if(MP_NO_ERROR != ret2)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret2)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult PlayerManager::InactiveSeekTo(const tPlaytime position)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::InactiveSeekTo position:%u", position));

    tResult ret = MP_NO_ERROR;

    tMediaObject currentMediaObject;
    ret = GetMediaObject(OUT currentMediaObject);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while getting current media object -> Cannot set playtime"));
    }
    else
    {
        /* Set internal player manager member Playtime to new value */
        SetPlaytime(IN position, IN currentMediaObject.totalPlaytime, IN true /*validLastMode*/,IN currentMediaObject.objectID);
    }

    /* Store last mode even the PlayerMangerSM is not active*/
    if(LocalSPM::GetDataProvider().SaveLastModeInNotActive())
    {
        StoreLastPlayedList();
    }

    /* Set start playtime */
    m_StartTime = position;

    return ret;
}

tResult PlayerManager::PlaybackActionStreaming(const tPlaybackAction playbackAction, const tNextPrevSkipCount nextPrevSkipCount)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::PlaybackActionStreaming playbackAction:%u, steps:%u", playbackAction, nextPrevSkipCount));

    tResult ret = MP_NO_ERROR;

    tMediaObject currentMediaObject;
    ret = GetMediaObject(OUT currentMediaObject);
    if((MP_NO_ERROR != ret)
       ||
       (DTY_UNKNOWN == currentMediaObject.deviceType)
       ||
       (DEVICE_ID_NOT_SET == currentMediaObject.deviceID)
       ||
       (0 == strlen_r(currentMediaObject.mountPoint)))
    {
        /* Try to get device related information for media object via current listID */
        ret = GetDevicePartOfMediaObject(OUT currentMediaObject);
    }

    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while getting current media object -> Cancel PlaybackActionStreaming and fake answer (ErrorCode:%s)", errorString(ret)));
    }
    else
    {
        /* Send PLAYBACK_ACTION message to specific DeviceControlSM */
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        char answerMsgString[64];

        strncpy_r(OUT msgToSendString, IN "PLAYBACK_ACTION", IN sizeof(msgToSendString));
        strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::PLAYBACK_ACTION_ANSWER", IN sizeof(answerMsgString));

        if(DTY_DVD_DRIVE == currentMediaObject.deviceType)
        {
            ret = LocalSPM::GetUSBControl().ParameterPLAYBACK_ACTION(OUT parameterString,
                    IN size,
                    IN currentMediaObject.deviceType,   //Not used in specific DeviceControl
                    IN currentMediaObject.deviceID,     //Not used in specific DeviceControl
                    IN currentMediaObject.fileName,     //Not used in specific DeviceControl
                    IN currentMediaObject.mountPoint,
                    IN playbackAction,
                    IN (tNextPrevSkipCount)pPlaybackSpeed);
        }
        else
        {
        ret = LocalSPM::GetUSBControl().ParameterPLAYBACK_ACTION(OUT parameterString,
                IN size,
                IN currentMediaObject.deviceType,   //Not used in specific DeviceControl
                IN currentMediaObject.deviceID,     //Not used in specific DeviceControl
                IN currentMediaObject.fileName,     //Not used in specific DeviceControl
                IN currentMediaObject.mountPoint,
                IN playbackAction,
                IN nextPrevSkipCount);
        }
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = LocalSPM::GetDeviceDispatcher().RouteMessageAnswer(IN currentMediaObject.deviceType, IN msgToSendString,
                IN parameterString, IN answerMsgString);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling RouteMessageAnswer of DeviceDispatcher (ErrorCode:%s)", errorString(ret)));
        }
    }

    if( MP_NO_ERROR != ret )
    {
        /* Send PLAYBACK_ACTION_ANSWER message to own SM */
        tResult ret2 = SendEvent(IN PLAYBACK_ACTION_ANSWER, (char *)NULL);
        if( MP_NO_ERROR != ret2 )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult PlayerManager::PlaybackMode(const tPlaybackMode playbackMode)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::PlaybackMode playbackMode:%u", playbackMode));

    tResult ret = MP_NO_ERROR;

    tStreamingMode currentStreamingMode = SM_OFF;
    GetStreamingMode(OUT currentStreamingMode);

    /* Reset first element of list which causes an error */
    m_FirstErrorObjectID = OBJECT_ID_NONE;

    /* Reset position of first element of list which causes an error */
    m_firstErrorObjectPosition = POSITION_NOT_SET;
    /* Get current active device ID */
    tDeviceID currentDeviceID = DEVICE_ID_NOT_SET;
    ret = LocalSPM::GetDBManager().GetActiveDevice(OUT currentDeviceID);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while getting active device from DBManager -> Cannot send playback mode (ErrorCode:%s)", errorString(ret)));
    }
    else
    {
        tDeviceInfo deviceInfo;
        ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN currentDeviceID);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while getting device info from DBManager -> Cannot send playback mode (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            if( LocalSPM::GetDataProvider().TrackScanningSupported() && (LocalSPM::GetDataProvider().IsDeviceSupportTrackScanning(deviceInfo.deviceType)))
            {
                if(mIsScanMode)
                {
                    ETG_TRACE_USR3(("Shuffle mode changed while being in Scan-ON.Hence Turning-off scan"));
                    PrepAndSendScanMessage(IN deviceInfo.deviceType, IN deviceInfo.deviceID, IN (tScanMode)false);
                }
                else
                {
                    ETG_TRACE_USR3(("Shuffle mode changed .But scan is already OFF.Hence no need to change scanMode"));
                }
            }

            /* Check if deviceType is able to buffer something and gapless play is configured by DataProvider */
            if(IsMassStorageDevice(IN deviceInfo.deviceType) //DTY_USB, DTY_SD, DTY_CDROM, DTY_FLASH
               &&
               LocalSPM::GetDataProvider().GaplessPlay())
            {
                /* Send DISCARD_BUFFER message to specific DeviceControlSM */
                char msgToSendString[32];
                strncpy_r(OUT msgToSendString, IN "DISCARD_BUFFER", IN sizeof(msgToSendString));

                ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN deviceInfo.deviceType, IN msgToSendString, (char *)NULL);
                if (MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
                }
            }

            if( (MY_MEDIA != currentDeviceID) //not for MyMdeia
                &&
                ((IsAppleDevice(deviceInfo.deviceType))    //only for DTY_IPOD, DTY_IPHONE
                 ||
                 (DTY_BLUETOOTH == deviceInfo.deviceType)
                 ||(DTY_DVD_DRIVE == deviceInfo.deviceType)) //or DTY_BLUETOOTH
                &&
                ((SM_ON == currentStreamingMode)                                      //only in streaming mode
                ||
                 (LocalSPM::GetDataProvider().SetDevicePlaybackModeNonStreaming())) ) //or configured for non streaming mode
            {
                /* Send SET_PLAYBACK_MODE message to specific DeviceControlSM */
                char msgToSendString[64];
                tAllParameters parameterString;
                size_t size = sizeof(parameterString);

                strncpy_r(OUT msgToSendString, IN "SET_PLAYBACK_MODE", IN sizeof(msgToSendString));

                ret = LocalSPM::GetUSBControl().ParameterSET_PLAYBACK_MODE(OUT parameterString,
                    IN size,
                    IN deviceInfo.deviceType,
                    IN currentDeviceID,
                    IN deviceInfo.mountPoint,
                    IN playbackMode);
                if (MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                    parameterString[0] = '\0';
                }

                ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN deviceInfo.deviceType, IN msgToSendString, IN parameterString);
                if (MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
                }
            }
            else
            {
                ETG_TRACE_USR3(("Setting of device playback mode is not possible for device or configured for non streaming mode -> do it only internal"));

                /* Set playback mode in ListControl */
                ret = LocalSPM::GetListControl().SetPlaybackMode(IN currentDeviceID, IN playbackMode);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while setting playback mode at ListControl (ErrorCode:%s)", errorString(ret)));
                }

               //Reshuffle the ShuffleTable & ensure currentRow set as first item in the table
               tNowPlaying nowPlaying;
               ret = GetNowPlaying(OUT nowPlaying);
               if(ret == MP_NO_ERROR)
               {
                  ret = LocalSPM::GetListControl().ReshuffleShuffleTable(IN nowPlaying.listID,IN nowPlaying.position);
               }
            }
        }
    }

    return ret;
}

tResult PlayerManager::RepeatMode(const tRepeatMode repeatMode)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::RepeatMode repeatMode:%u", repeatMode));

    tResult ret = MP_NO_ERROR;

    tStreamingMode currentStreamingMode = SM_OFF;
    GetStreamingMode(OUT currentStreamingMode);

    /* Get current active device ID */
    tDeviceID currentDeviceID = DEVICE_ID_NOT_SET;
    ret = LocalSPM::GetDBManager().GetActiveDevice(OUT currentDeviceID);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while getting active device from DBManager -> Cannot send repeat mode (ErrorCode:%s)", errorString(ret)));
    }
    else
    {
        tDeviceInfo deviceInfo;
        ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN currentDeviceID);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while getting device info from DBManager -> Cannot send repeat mode (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            if( LocalSPM::GetDataProvider().TrackScanningSupported() && (LocalSPM::GetDataProvider().IsDeviceSupportTrackScanning(deviceInfo.deviceType)))
            {
                if(mIsScanMode)
                {
                    ETG_TRACE_USR3(("Repeat mode changed while being in Scan-ON.Hence Turning-off scan"));
                    PrepAndSendScanMessage(IN deviceInfo.deviceType, IN deviceInfo.deviceID, IN (tScanMode)false);
                }
                else
                {
                    ETG_TRACE_USR3(("Repeat mode changed .But scan is already OFF.Hence no need to change scanMode"));
                }
            }

            if( (MY_MEDIA != currentDeviceID) //not for MyMdeia
                &&
                ((IsAppleDevice(deviceInfo.deviceType))    //only for DTY_IPOD, DTY_IPHONE
                 ||
                 (DTY_BLUETOOTH == deviceInfo.deviceType) //or DTY_BLUETOOTH
                 ||(DTY_DVD_DRIVE == deviceInfo.deviceType))  //or DTY_DVD_DRIVE
                &&
                ((SM_ON == currentStreamingMode)                                    //only in streaming mode
                ||
                 (LocalSPM::GetDataProvider().SetDeviceRepeatModeNonStreaming())) ) //or configured for non streaming mode
            {
                /* Send SET_REPEAT_MODE message to specific DeviceControlSM */
                char msgToSendString[64];
                tAllParameters parameterString;
                size_t size = sizeof(parameterString);

                strncpy_r(OUT msgToSendString, IN "SET_REPEAT_MODE", IN sizeof(msgToSendString));

                ret = LocalSPM::GetUSBControl().ParameterSET_REPEAT_MODE(OUT parameterString,
                    IN size,
                    IN deviceInfo.deviceType,
                    IN currentDeviceID,
                    IN deviceInfo.mountPoint,
                    IN repeatMode);
                if (MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                    parameterString[0] = '\0';
                }

                ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN deviceInfo.deviceType, IN msgToSendString, IN parameterString);
                if (MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
                }
            }
            else
            {
                ETG_TRACE_USR3(("Setting of device repeat mode is not possible for device or configured for non streaming mode -> do it only internal"));

                /* Set repeat mode in ListControl directly */
                ret = LocalSPM::GetListControl().SetRepeatMode(IN repeatMode);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while setting repeat mode at ListControl (ErrorCode:%s)", errorString(ret)));
                }
            }
        }
    }

    return ret;
}

tResult PlayerManager::NextBufferMediaObject()
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    tMediaObject currentMediaObject;
    ret = GetMediaObject(OUT currentMediaObject);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while getting current media object -> Send BUFFER_ANSWER with SC_NO"));
    }
    else
    {
        /* Get next media object to buffer from ListControl */
        tPosition bufferIndex;
        GetBufferIndex(OUT bufferIndex);
        tListID currentListID = LIST_ID_NONE;
        ret = GetListID(OUT currentListID);
        if((MP_NO_ERROR != ret)
           ||
           POSITION_NOT_SET == bufferIndex)
        {
            ETG_TRACE_ERR(("Current listID/bufferIndex is not valid -> Send BUFFER_ANSWER with SC_NO"));
        }
        else
        {
            tMediaObject bufferMediaObject;
            ret = LocalSPM::GetListControl().GetMediaObject(OUT bufferMediaObject, IN currentListID, IN bufferIndex + 1);
            if((MP_NO_ERROR != ret)
               ||
               (OBJECT_ID_NONE == bufferMediaObject.objectID))
            {
                ETG_TRACE_ERR(("Error while getting next media object to buffer from ListControl listID: %u, index: %u (ErrorCode:%s)", currentListID, bufferIndex + 1, errorString(ret)));
            }
            else
            {
                if(bufferMediaObject.deviceType != currentMediaObject.deviceType)
                {
                    ETG_TRACE_USR3(("Cannot buffer next media object because it's not the same deviceType (%u -> %u)", currentMediaObject.deviceType, bufferMediaObject.deviceType));
                    ret = MP_ERR_PM_NO_MEDIA_OBJECT;
                }
                else
                {
                    /* Send BUFFER message to specific DeviceControlSM */
                    char msgToSendString[64];
                    tAllParameters parameterString;
                    size_t size = sizeof(parameterString);
                    char answerMsgString[64];

                    //strncpy_r(OUT msgToSendString, IN "BUFFER", IN sizeof(msgToSendString));
                    strncpy_r(OUT msgToSendString, IN "DeviceDispatcherSM::BUFFER", IN sizeof(msgToSendString));
                    strncpy_r(OUT answerMsgString, IN "PlayerManagerSM::BUFFER_ANSWER", IN sizeof(answerMsgString));

                    ret = LocalSPM::GetDeviceDispatcher().ParameterBUFFER(OUT parameterString,
                            IN size,
                            IN bufferMediaObject.deviceType,
                            IN bufferMediaObject.deviceID,
                            IN bufferMediaObject.fileName,
                            IN bufferMediaObject.mountPoint,
                            IN (tPEHandle)bufferMediaObject.objectID);
                    if(MP_NO_ERROR != ret)
                    {
                        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                        parameterString[0] = '\0';
                    }

                    //ret = LocalSPM::GetDeviceDispatcher().RouteMessageAnswer(IN bufferMediaObject.deviceType, IN msgToSendString,
                    //        IN parameterString, IN answerMsgString);
                    ret = Dispatcher::GetInstance().SendMessageAnswer(IN msgToSendString, IN parameterString, IN answerMsgString);
                    if(MP_NO_ERROR != ret)
                    {
                        ETG_TRACE_ERR(("Error while calling RouteMessageAnswer of DeviceDispatcher (ErrorCode:%s)", errorString(ret)));
                    }
                }
            }
        }
    }

    if( MP_NO_ERROR != ret )
    {
        /* Send BUFFER_ANSWER message to own SM */
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        tSuccess success = SC_NO;

        tResult ret2 = ParameterBUFFER_ANSWER(OUT parameterString, IN size, IN success);
        if( MP_NO_ERROR != ret2 )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            ret2 = SendEvent(BUFFER_ANSWER, IN parameterString);
            if( MP_NO_ERROR != ret2 )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult PlayerManager::NextList(const tListID listID,const tBoolean updateNowPlaying)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::NextList listID:%u", listID));

    tResult ret = MP_NO_ERROR;
    tListID currentListID = LIST_ID_NONE;
    ret = GetListID(OUT currentListID);

    //If incoming list is same as the current list,do nothing.
    if(listID == currentListID) return ret;

    /* Get current active device ID */
    tDeviceID currentDeviceID = DEVICE_ID_NOT_SET;
    ret = LocalSPM::GetDBManager().GetActiveDevice(OUT currentDeviceID);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while getting active device from DBManager -> Cannot decide on GaplessPlay (ErrorCode:%s)", errorString(ret)));
    }
    else
    {
        tDeviceInfo deviceInfo;
        ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN currentDeviceID);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while getting device info from DBManager -> Cannot decide on GaplessPlay (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            /* Check if deviceType is able to buffer something and gapless play is configured by DataProvider */
            if(IsMassStorageDevice(IN deviceInfo.deviceType) //DTY_USB, DTY_SD, DTY_CDROM, DTY_FLASH
               &&
               LocalSPM::GetDataProvider().GaplessPlay())
            {
                /* Send DISCARD_BUFFER message to specific DeviceControlSM */
                char msgToSendString[32];
                strncpy_r(OUT msgToSendString, IN "DISCARD_BUFFER", IN sizeof(msgToSendString));

                ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN deviceInfo.deviceType, IN msgToSendString, (char *)NULL);
                if (MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
                }
            }
        }
    }

    /* Remove obsolete highlighting on old list */
    tPosition position;
    ret = LocalSPM::GetListControl().UpdateNowPlaying(OUT position, IN currentListID, IN OBJECT_ID_NONE);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while informing ListControl about object currently played (ErrorCode:%s)", errorString(ret)));
    }

    /* Remove highlighting of parent lists */
    ret = LocalSPM::GetListControl().ResetParentHighlighting(IN currentListID);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while resetting highlighting of parent lists (ErrorCode:%s)", errorString(ret)));
    }

    /* Store listID internally */
    SetListID(IN listID);

    /*Inform HMI that received listID as NowplayingList and highlight the Nowplaying Item in it */
    ret = SetNowPlayingState(NP_NEW_TRACK);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while calling SetNowPlayState(NP_NEW_TRACK) (ErrorCode:%s)", errorString(ret)));
    }
    return ret;
}

tResult PlayerManager::IsAutoPlay()
{
    ENTRY

    tReturnValue returnValue = LocalSPM::GetDataProvider().AutoPlayInPause();

    if(FALSE == returnValue)
    {
        /* Inform HMI about new NowPlaying status because PLAY is blocked here */
        UpdateNowPlayingFromDB();
    }

    ETG_TRACE_USR3(("PlayerManager::IsAutoPlay returnValue:%u", returnValue));
    return returnValue;
}

tResult PlayerManager::IsAutoPlayInStop()
{
    ENTRY

    return IsAutoPlay();
}

tResult PlayerManager::IsAutoPlayInLastMode()
{
    ENTRY

    tReturnValue returnValue = (LocalSPM::GetDataProvider().AutoPlayInLastModePause() && !m_SAPauseFlag) || m_AutoPlayFlag;

    if(FALSE == returnValue)
    {
        /* Inform HMI about new NowPlaying status because PLAY is blocked here */
        UpdateNowPlayingFromDB();
    }

    ETG_TRACE_USR3(("PlayerManager::IsAutoPlayInLastMode returnValue:%u", returnValue));
    return returnValue;
}

tResult PlayerManager::IsAtBeginningOfPlayback()
{
    ENTRY

    tReturnValue returnValue = false;

    tResult ret = MP_NO_ERROR;
    tPlaytime elapsedPlaytime = 0;
    tPlaytime totalPlaytime = 0;
    tObjectID objectID = OBJECT_ID_NONE;
    ret = GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime,OUT objectID);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while getting current playtime -> Always at beginning"));
        returnValue = true;
    }
    else
    {
        tPlaytime configPrevBufferTime = LocalSPM::GetDataProvider().PrevBufferTime();

        /* Check if we are playing on a Apple device */
        tMediaObject currentMediaObject;
        ret = GetMediaObject(OUT currentMediaObject);
        if((MP_NO_ERROR != ret)
           ||
           (DTY_UNKNOWN == currentMediaObject.deviceType))
        {
            /* Try to get device related information for media object via current listID */
            ret = GetDevicePartOfMediaObject(OUT currentMediaObject);
        }

        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while getting current media object -> Assume that it is not a Apple device (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            if( IsAppleDevice(IN currentMediaObject.deviceType) ) //DTY_IPOD, DTY_IPHONE
            {
                configPrevBufferTime = LocalSPM::GetDataProvider().PrevBufferTimeAppleDevice();
            }
        }

        if( configPrevBufferTime >= elapsedPlaytime)
        {
            returnValue = true;
        }
    }

    ETG_TRACE_USR3(("PlayerManager::IsAtBeginningOfPlayback returnValue:%u", returnValue));
    return returnValue;
}

tResult PlayerManager::IsFFwdContinuousCueing()
{
    ENTRY

    //TODO: No waiting for FFWD_STOP_ANSWER response yet before starting next action (e.g. PlayMediaObject)
    tReturnValue returnValue = LocalSPM::GetDataProvider().ContinuousCueing();

    ETG_TRACE_USR3(("PlayerManager::IsFFwdContinuousCueing returnValue:%u", returnValue));
    return returnValue;
}

tResult PlayerManager::IsFRevContinuousCueing()
{
    ENTRY

    //TODO: No waiting for FREV_STOP_ANSWER response yet before starting next action (e.g. PlayMediaObject)
    tReturnValue returnValue = LocalSPM::GetDataProvider().ContinuousCueing();

    ETG_TRACE_USR3(("PlayerManager::IsFRevContinuousCueing returnValue:%u", returnValue));
    return returnValue;
}

tResult PlayerManager::IsSourceActivityOnDelay()
{
    ENTRY

    tReturnValue returnValue = false;

    if(m_AppleBugWrongSourceTimerID != 0)
    {
        returnValue = true;
    }

    ETG_TRACE_USR3(("PlayerManager::IsSourceActivityOnDelay returnValue:%u", returnValue));
    return returnValue;
}

tResult PlayerManager::IsAllocateSuccessful(const tReturnValue returnValue)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::IsAllocateSuccessful returnValue:%u", returnValue));

    if(false == returnValue)
    {
        ETG_TRACE_ERR(("Allocate of audio output device failed!"));
    }

    return returnValue;
}

tResult PlayerManager::IsDeAllocateSuccessful(const tReturnValue returnValue)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::IsDeAllocateSuccessful returnValue:%u", returnValue));

    if(false == returnValue)
    {
        ETG_TRACE_ERR(("Deallocate of audio output device failed!"));
    }

    return returnValue;
}

tResult PlayerManager::AllocationFailed(const tReturnValue returnValue)
{
    ENTRY

    //MP_FATAL_ASSERT(returnValue);
    MP_NORMAL_ASSERT(returnValue);

    return MP_NO_ERROR;
}

tResult PlayerManager::DeAllocationFailed(const tReturnValue returnValue)
{
    ENTRY

    MP_NORMAL_ASSERT(returnValue);

    return MP_NO_ERROR;
}

tResult PlayerManager::HandleAnswerTimeout()
{
    ENTRY
    ETG_TRACE_ERR(("PlayerManager::HandleAnswerTimeout"));

    tResult ret = MP_NO_ERROR;

    /* Send releasing event to own waiting state machine */
    ret = ReleaseWaiting();
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while releasing waiting via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult PlayerManager::HandleSAOffFinished()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::HandleSAOffFinished"));

    tResult ret = MP_NO_ERROR;

    /* Cancel wrong source timer if it is already running */
    if(m_AppleBugWrongSourceTimerID != 0)
    {
        m_AppleBugWrongSourceTimer.CancelTimer(m_AppleBugWrongSourceTimerID);
        m_AppleBugWrongSourceTimerID = 0;
    }

    /* Send answer to waiting IIL state machine */
    ret = SendAnswer(NULL);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult PlayerManager::HandleSAOnFinished()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::HandleSAOnFinished"));

    tResult ret = MP_NO_ERROR;

    /* Get current media object data from ListControl */
    tListID currentListID = LIST_ID_NONE;

    ret = GetListID(OUT currentListID);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Current listID is not valid -> Cannot reset list position"));
    }
    else
    {
        /* Reset the list position to current object */
        ret = LocalSPM::GetListControl().ResetListPosition(IN currentListID);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while resetting list position at ListControl (ErrorCode:%s)", errorString(ret)));
        }
    }

    /* Send answer to waiting IIL state machine */
    ret = SendAnswer(NULL);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult PlayerManager::HandleAllocateFinished()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::HandleAllocateFinished"));

    tResult ret = MP_NO_ERROR;

    /* Send answer to waiting IIL state machine */
    ret = SendAnswer(NULL);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult PlayerManager::HandleDeAllocateFinished()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::HandleDeAllocateFinished"));

    tResult ret = MP_NO_ERROR;

    /* Send answer to waiting IIL state machine */
    ret = SendAnswer(NULL);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult PlayerManager::HandleGetAudioDeviceNotAllocated(const tDeviceID deviceID)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::HandleGetAudioDeviceNotAllocated deviceID:%u", deviceID));

    tResult ret = MP_NO_ERROR;
    tDeviceInfo deviceInfo;
    ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while getting device info from DBManager -> Cannot send remote activity (ErrorCode:%s)", errorString(ret)));
    }

    /* Check if deviceType is able to support CarPlayMode */
    if( IsAppleDevice(IN deviceInfo.deviceType) ) //DTY_IPOD, DTY_IPHONE
    {
        /* Cancel get audio device timer if it is already running */
        if(m_GetAudioDeviceTimerID != 0)
        {
            m_GetAudioDeviceTimer.CancelTimer(m_GetAudioDeviceTimerID);
            m_GetAudioDeviceTimerID = 0;
        }

        /* Start get audio device timer */
        m_GetAudioDeviceTimer.StartTimer(OUT m_GetAudioDeviceTimerID,
                   IN LocalSPM::GetDataProvider().GetAudioDeviceTimeout(),
                   IN 0L,
                   IN &LocalSPM::GetPlayerManager(),
                   IN &GetAudioDeviceTimerCallback,
                   IN (void *)(unsigned long)deviceID); // thoemel: additinal cast (unsigned long) due to 64 bit compiler

        if(LocalSPM::GetDataProvider().SourceActivityDelayEnabled())
        {
            /* Fix for GMMY17_7960 */
            ret = LocalSPM::GetCustomControl().SendActiveMediaDeviceSet(IN deviceID, IN true);

            /* Send AVAcitivation request to audio management */
            ret = LocalSPM::GetOutputWrapper().RequestAVActivation(IN 1, IN LC_MAIN_AUDIO);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
        else
        {
            //voicemail issue GMMY17-10773
            const tDiPOStopReason diPOStopReason = (tDiPOStopReason)LocalSPM::GetDataProvider().DiPOStopReason();
            VARTRACE(diPOStopReason);
            if(diPOStopReason != DIPO_STOP_REASON_SOURCE_SUSPENDED) {
                LocalSPM::GetDataProvider().DiPOStopReason = DIPO_STOP_REASON_UNKNOWN;
            }

            LocalSPM::GetDataProvider().DiPOStartReason = DIPO_START_REASON_REMOTE_ACTIVITY;

            /* Send SET_REMOTE_ACTIVITY message to specific DeviceControlSM */
            char msgToSendString[64];
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);

            strncpy_r(OUT msgToSendString, IN "SET_REMOTE_ACTIVITY", IN sizeof(msgToSendString));

            ret = LocalSPM::GetIPODControl().ParameterSET_REMOTE_ACTIVITY(OUT parameterString, IN size, IN deviceID);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                parameterString[0] = '\0';
            }

            ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN deviceInfo.deviceType, IN msgToSendString, IN parameterString);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    return ret;
}

tResult PlayerManager::HandleGetAudioDeviceAllocated(const tDeviceID deviceID)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::HandleGetAudioDeviceAllocated deviceID:%u", deviceID));

    tResult ret = MP_NO_ERROR;
    tDeviceInfo deviceInfo;
    ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while getting device info from DBManager -> Cannot send remote activity (ErrorCode:%s)", errorString(ret)));
    }

    /* Check if deviceType is able to support CarPlayMode (configured by DataProvider) */
    if( IsAppleDevice(IN deviceInfo.deviceType) ) //DTY_IPOD, DTY_IPHONE
    {
        /* Check if device is another one than the current real device */
        tMediaObject currentMediaObject;
        tDeviceID realDeviceID = DEVICE_ID_NOT_SET;
        ret = GetMediaObject(OUT currentMediaObject);
        if((MP_NO_ERROR != ret)
           ||
           (DTY_UNKNOWN == currentMediaObject.deviceType)
           ||
           (DEVICE_ID_NOT_SET == currentMediaObject.deviceID)
           ||
           (0 == strlen_r(currentMediaObject.mountPoint)))
        {
            /* Try to get device related information for media object via current listID */
            ret = GetDevicePartOfMediaObject(OUT currentMediaObject);
        }
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while getting current media object -> send SET_REMOTE_ACTIVITY always (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            realDeviceID = currentMediaObject.deviceID;
        }

        if( realDeviceID != deviceID )
        {
#if 0
            /* Cancel get audio device timer if it is already running */
            if(m_GetAudioDeviceTimerID != 0)
            {
                m_GetAudioDeviceTimer.CancelTimer(m_GetAudioDeviceTimerID);
                m_GetAudioDeviceTimerID = 0;
            }

            /* Start get audio device timer */
            m_GetAudioDeviceTimer.StartTimer(OUT m_GetAudioDeviceTimerID,
                       IN LocalSPM::GetDataProvider().GetAudioDeviceTimeout(),
                       IN 0L,
                       IN &LocalSPM::GetPlayerManager(),
                       IN &GetAudioDeviceTimerCallback,
                       IN (void *)deviceID);
#endif
            char msgToSendString[64];
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);

            if((DTY_UNKNOWN == currentMediaObject.deviceType)
               ||
               (DEVICE_ID_NOT_SET == currentMediaObject.deviceID)
               ||
               (0 == strlen_r(currentMediaObject.mountPoint)))
            {
                /* Do STOP request and wait for the answer */
                strncpy_r(OUT msgToSendString, IN "DeviceDispatcherSM::STOP", IN sizeof(msgToSendString));

                ret = LocalSPM::GetDeviceDispatcher().ParameterSTOP(OUT parameterString,
                        IN size,
                        IN currentMediaObject.deviceType,   //Not used in specific DeviceControl
                        IN currentMediaObject.deviceID,     //Not used in specific DeviceControl
                        IN currentMediaObject.fileName,     //Not used in specific DeviceControl
                        IN currentMediaObject.mountPoint);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                }
                else
                {
                    RequestResponseSM rrStop;
                    ret = rrStop.DoEventAnswer(IN msgToSendString, IN parameterString, NULL, PLAYER_MANAGER_SM_ANSWER_TIMEOUT_MS);
                    if( MP_NO_ERROR != ret )
                    {
                        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
                    }
                }
            }

            //voicemail issue GMMY17-6080
            const tDiPOStopReason diPOStopReason = (tDiPOStopReason)LocalSPM::GetDataProvider().DiPOStopReason();
            VARTRACE(diPOStopReason);
            if(diPOStopReason != DIPO_STOP_REASON_SOURCE_SUSPENDED) {
                LocalSPM::GetDataProvider().DiPOStopReason = DIPO_STOP_REASON_UNKNOWN;
            }

            LocalSPM::GetDataProvider().DiPOStartReason = DIPO_START_REASON_REMOTE_ACTIVITY;

            /* Send SET_REMOTE_ACTIVITY message to specific DeviceControlSM */
            strncpy_r(OUT msgToSendString, IN "SET_REMOTE_ACTIVITY", IN sizeof(msgToSendString));

            ret = LocalSPM::GetIPODControl().ParameterSET_REMOTE_ACTIVITY(OUT parameterString, IN size, IN deviceID);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                parameterString[0] = '\0';
            }

            ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN deviceInfo.deviceType, IN msgToSendString, IN parameterString);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }

        /* Send SPI MethodAnswer for GetAudioDevice immediately */
        tAudioOutputDevice audioOutputDevice;
        m_Mutex.lock();
        strncpy_r(OUT audioOutputDevice, IN m_AudioOutputDevice, IN sizeof(audioOutputDevice));
        m_Mutex.unlock();

        ret = LocalSPM::GetOutputWrapper().SendGetAudioDeviceAnswer(IN deviceID, IN audioOutputDevice);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending GetAudioDeviceAnswer via OutputWrapper (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send SPI MethodError for GetAudioDevice */
        ret = LocalSPM::GetOutputWrapper().SendGetAudioDeviceError(IN deviceID);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending GetAudioDeviceError via OutputWrapper (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

bool PlayerManager::GetAudioDeviceTimerCallback(timer_t timerID , void* instance ,const void *userData)
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    if(NULL == instance)
    {
        ETG_TRACE_ERR(("Invalid parameter: instance is NULL"));
    }
    else
    {
        PlayerManager *self = (PlayerManager*)instance;
        const tDeviceID deviceID = (tDeviceID)(unsigned long)userData; // thoemel: the additional cast to unsigned long is due to 64 bit compiler

        ETG_TRACE_USR3(("PlayerManager::GetAudioDeviceTimerCallback timerID:0x%X, instance:0x%X, deviceID:%u", (int)((long)timerID), instance, deviceID));

        /* Send GET_AUDIO_DEVICE_ANSWER(success=SC_NO) event */
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = self->ParameterGET_AUDIO_DEVICE_ANSWER(OUT parameterString, IN size, IN deviceID, IN SC_NO);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = self->SendEventByName("GET_AUDIO_DEVICE_ANSWER", IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return false;
}

tResult PlayerManager::GetAudioDeviceAnswer(const tDeviceID deviceID, const tSuccess success)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::GetAudioDeviceAnswer deviceID:%u, success:%u", deviceID, success));

    tResult ret = MP_NO_ERROR;

    /* Check if GetAudioDevice request is ongoing */
    if(m_GetAudioDeviceTimerID != 0)
    {
        /* Cancel get audio device timer */
        m_GetAudioDeviceTimer.CancelTimer(m_GetAudioDeviceTimerID);
        m_GetAudioDeviceTimerID = 0;

        if( SC_YES == success )
        {
            /* Send SPI MethodAnswer for GetAudioDevice */
            tAudioOutputDevice audioOutputDevice;
            m_Mutex.lock();
            strncpy_r(OUT audioOutputDevice, IN m_AudioOutputDevice, IN sizeof(audioOutputDevice));
            m_Mutex.unlock();

            ret = LocalSPM::GetOutputWrapper().SendGetAudioDeviceAnswer(IN deviceID, IN audioOutputDevice);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending GetAudioDeviceAnswer via OutputWrapper (ErrorCode:%s)", errorString(ret)));
            }
        }
        else
        {
            /* Send SPI MethodError for GetAudioDevice */
            ret = LocalSPM::GetOutputWrapper().SendGetAudioDeviceError(IN deviceID);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending GetAudioDeviceError via OutputWrapper (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    return ret;
}

bool PlayerManager::AppleBugWrongSourceTimerCallback(timer_t timerID , void* instance ,const void *userData)
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    if(NULL == instance)
    {
        ETG_TRACE_ERR(("Invalid parameter: instance is NULL"));
    }
    else
    {
        PlayerManager *self = (PlayerManager*)instance;

        ETG_TRACE_USR3(("PlayerManager::AppleBugWrongSourceTimerCallback timerID:0x%X, instance:0x%X", (int)((long)timerID), instance));

        /* Send SOURCE_ACTIVITY_ON_DELAY event */
        ret = self->SendEventByName("SOURCE_ACTIVITY_ON_DELAY", (char *)NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }

        self->m_AppleBugWrongSourceTimerID = 0;
    }

    return false;
}

tResult PlayerManager::UpdateNowPlayingFromDB()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::UpdateNowPlayingFromDB"));

    tResult ret = MP_NO_ERROR;

    /* Get current media object data from ListControl */
    tListID currentListID = LIST_ID_NONE;

    ret = GetListID(OUT currentListID);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Current listID is not valid -> Cancel UpdateNowPlayingFromDB"));
    }
    else
    {
        /* Get current media object data from ListControl */
        tMediaObject mediaObject;
        mediaObject.objectID = OBJECT_ID_NONE;

        ret = LocalSPM::GetListControl().GetCurrentMediaObject(OUT mediaObject, IN currentListID);
        if((MP_NO_ERROR != ret)
           ||
           (OBJECT_ID_NONE == mediaObject.objectID))
        {
            ETG_TRACE_ERR(("Error while getting current media object from ListControl (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            tListInfo listInfo;
            tBoolean bWithListSize = false;
            ret = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN currentListID, IN bWithListSize);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while getting list info from ListControl (ErrorCode:%s)", errorString(ret)));
            }
            else
            {
                /*if a filelist element is already indexed, use the indexed metadata fromDB*/
                if (LTY_FILELIST == listInfo.listType)
                {
                    tMediaObject mediaObjectFromDB;
                    InitMediaObject(OUT mediaObjectFromDB);
                    ret = LocalSPM::GetDBManager().GetMediaObject(OUT mediaObjectFromDB, INOUT mediaObject.objectID);
                    if (MP_NO_ERROR != ret)
                    {
                        ETG_TRACE_USR1(("Cannot take filelist element from DB because not indexed yet"));
                    }
                    else
                    {
                        if (0 != mediaObjectFromDB.MetadataTag1) /*already indexed !*/
                        {
                           strncpy_r(OUT mediaObject.MetadataField1, IN mediaObjectFromDB.MetadataField1, IN sizeof(mediaObject.MetadataField1));
                           strncpy_r(OUT mediaObject.MetadataField2, IN mediaObjectFromDB.MetadataField2, IN sizeof(mediaObject.MetadataField2));
                           strncpy_r(OUT mediaObject.MetadataField3, IN mediaObjectFromDB.MetadataField3, IN sizeof(mediaObject.MetadataField3));
                           strncpy_r(OUT mediaObject.MetadataField4, IN mediaObjectFromDB.MetadataField4, IN sizeof(mediaObject.MetadataField4));
                           strncpy_r(OUT mediaObject.title, IN mediaObjectFromDB.title, IN sizeof(mediaObject.title));
                           mediaObject.metadataConvertFlag = mediaObjectFromDB.metadataConvertFlag;
                        }
                    }

                    /* Cut file extension from the title */
                    if (LocalSPM::GetDataProvider().DBRemoveExtensionFromFilename())
                    {
                        FastUTF8::tString title;
                        FastUTF8::tString extension;
                        title = (FastUTF8::tString)strdup(mediaObject.title);
                        FastUTF8::SplitExtension(OUT extension, INOUT title);

                        if (extension) //extension found
                        {
                            strncpy_r(OUT mediaObject.title, IN (const char *)title, IN sizeof(mediaObject.title));
                        }
                        free(title);
                    }
                }
            }

            /* Store mediaObject internally */
            SetMediaObject(IN mediaObject);

            if((IsAppleDevice(IN mediaObject.deviceType)) //DTY_IPOD, DTY_IPHONE
               ||
               (m_MultipleNextWaitTimerID != 0)) //MultipleNext timer is running
            {
                /* Set album art availability to false (without update NowPlaying to HMI)*/
                SetAlbumArtAvailability(IN false, IN false);
            }
            else
            {
                /* Reset album art availability to true (without update NowPlaying to HMI)*/
                SetAlbumArtAvailability(IN true, IN false);
            }

            /* Update HMI and ListControl by setting NowPlayingState */
            ret = SetNowPlayingState(NP_NEW_TRACK);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while setting NowPlaying state"));
            }

            /* Store last mode even the PlayerMangerSM is not active*/
            if(LocalSPM::GetDataProvider().SaveLastModeInNotActive())
            {
                /* Set internal player manager member Playtime to new value */
                if(m_StartTime <= mediaObject.totalPlaytime)
                {
                    SetPlaytime(IN m_StartTime, IN mediaObject.totalPlaytime, IN true /*validLastMode*/,IN mediaObject.objectID);
                }

                StoreLastPlayedList();
            }
        }
    }

    return ret;
}

tResult PlayerManager::ListIsEmpty(const tNoObjectReason noObjectReason)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::ListIsEmpty noObjectReason:%u", noObjectReason));

    tResult ret = MP_NO_ERROR;

    if(NOR_LIST_IS_NOT_PLAYABLE == noObjectReason)
    {
        /* Reset listID */
        SetListID(LIST_ID_NONE);
    }

    /* Inform CustomControl about no media object available */
    tListID currentListID = LIST_ID_NONE;

    ret = GetListID(OUT currentListID);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_USR3(("Current listID is not valid -> Cancel ListIsEmpty"));
        ret = MP_NO_ERROR;
    }
    else
    {
#if 0
        ret = LocalSPM::GetCustomControl().ListIsEmpty(IN currentListID, IN noObjectReason);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while informing CustomControl about no media object available (ErrorCode:%s)", errorString(ret)));
        }
#else
        /* Send LIST_IS_EMPTY message to CustomControlSM */
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        strncpy_r(OUT msgToSendString, IN "CustomControlSM::LIST_IS_EMPTY", IN sizeof(msgToSendString));

        ret = LocalSPM::GetCustomControl().ParameterLIST_IS_EMPTY(OUT parameterString, IN size, IN currentListID, IN noObjectReason);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = Dispatcher::GetInstance().SendMessage(IN msgToSendString, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
#endif
    }

    return ret;
}

tResult PlayerManager::StoreLastPlayed()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::StoreLastPlayed"));

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().FavoritesSupported())
    {
        if(!LocalSPM::GetCustomControl().GetFavoritesManager().GetDeactivationReqFlag())   //Ignore the Deactivation of all favorites
        {
            ETG_TRACE_USR3(("Deactivation of favorites NOT required"));
        }
        else
        {
            /* Deactivate all favorites in DB */
            ret = LocalSPM::GetDBManager().DeActivateAllFavorites();
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while Deactivating all favorites in DB (ErrorCode:%s)", errorString(ret)));
            }
        }
        // Set deactivation flag to TRUE..
        ret = LocalSPM::GetCustomControl().GetFavoritesManager().SetDeactivationReqFlag(TRUE);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while Fetching DeactivationReqFlag (ErrorCode:%s)", errorString(ret)));
        }
    }

    /* Store last mode */
    StoreLastPlayedList();


    /* Check connection state of MyMedia */
    ret = CheckConnectionStateMyMedia();
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while checking connection state of MyMedia (ErrorCode:%s)", errorString(ret)));
    }

    /* Set start playtime */
    tPlaytime elapsedPlaytime = PLAYTIME_NONE;
    ret = GetLastModePlaytime(OUT elapsedPlaytime);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while getting current playtime -> Cannot set start position"));
    }
    else
    {
        if(PLAYTIME_NONE != elapsedPlaytime) //Playtime is not reset
        {
            m_StartTime = elapsedPlaytime;
        }
    }

    /* Reset internal NowPlaying variable (NCG3D-15511) */
    ResetNowPlaying();

    /* Reset auto play flag */
    m_AutoPlayFlag = FALSE;

    /* Get current streaming mode */
    tStreamingMode currentStreamingMode = SM_OFF;
    GetStreamingMode(OUT currentStreamingMode);

    /* Remove all delayed messages from queue of own SM */
    if( SM_ON == currentStreamingMode )
    {
        RemoveMessageByName("PLAYBACK_ACTION");
        RemoveMessageByName("SEEK_TO");
    }
    RemoveMessageByName("START");
    RemoveMessageByName("NO_OBJECT");

    /* Set allocate state to ALLOCATED */
    SetAllocateState(IN ALS_ALLOCATED);

    return ret;
}

tResult PlayerManager::StoreLastPlayedList()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::StoreLastPlayedList"));

    tResult ret = MP_NO_ERROR;

    /* Store last played media object data in ListControl */
    tListID currentListID = LIST_ID_NONE;
    ret = GetListID(OUT currentListID);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_USR3(("Current listID is not valid -> Cannot store last position"));
    }
    else
    {
        /* Do it only if playtime is not reset */
        tPlaytime elapsedPlaytime = PLAYTIME_NONE;
        ret = GetLastModePlaytime(OUT elapsedPlaytime);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while getting current playtime -> Cannot store last position"));
        }
        else if(PLAYTIME_NONE != elapsedPlaytime) //Playtime is not reset
        {
            ret = LocalSPM::GetListControl().StoreLastPlayedList(IN currentListID, IN elapsedPlaytime);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while storing last mode at ListControl (ErrorCode:%s)", errorString(ret)));
            }

            /* Store last playtime of old media object */
            StoreLastPlaytime();

            /* Update totalPlaytime of current mediaObject */
            tMediaObject currentMediaObject;
            ret = GetMediaObject(OUT currentMediaObject);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while getting current media object -> Cannot update totalPlaytime of current mediaObject"));
            }
            else
            {
                if((0 < currentMediaObject.totalPlaytime)
                   &&
                   (PLAYTIME_NONE != currentMediaObject.totalPlaytime))
                {
                    ret = LocalSPM::GetDBManager().UpdateMediaObject(IN currentMediaObject);
                    if( MP_NO_ERROR != ret )
                    {
                        ETG_TRACE_ERR(("Error while updating media object at DBManager (ErrorCode:%s)", errorString(ret)));
                    }
                }
            }
        }

    }

    return ret;
}

tResult PlayerManager::StoreLastPlaytime()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::StoreLastPlaytime"));

    tResult ret = MP_NO_ERROR;

    tMediaObject currentMediaObject;
    ret = GetMediaObject(OUT currentMediaObject);
    if((MP_NO_ERROR != ret)
       ||
       (OBJECT_ID_NONE == currentMediaObject.objectID))
    {
        ETG_TRACE_ERR(("Error while getting current media object -> Cannot store last mode position"));
    }
    else
    {
        /* Check if last mode position of current media object is supported */
        VARTRACE(currentMediaObject.objectID);
        if( LocalSPM::GetDataProvider().IsLastModePositionSupported(IN currentMediaObject.deviceType, IN currentMediaObject.catType) )
        {
            /* Do it only if playtime is not reset */
            tPlaytime elapsedPlaytime = PLAYTIME_NONE;
            ret = GetLastModePlaytime(OUT elapsedPlaytime);
            if((MP_NO_ERROR != ret)
               ||
               (PLAYTIME_NONE == elapsedPlaytime))
            {
                ETG_TRACE_ERR(("Error while getting current playtime -> Cannot store last position"));
            }
            else
            {
                /* Check if media object was played for a while */
                tPlaytime deltaTime = 0;
                tPlaytime storedPlaytime = PLAYTIME_NONE;
                ret = LocalSPM::GetDBManager().GetLastPlaytime(OUT storedPlaytime, IN currentMediaObject.objectID);
                if((MP_NO_ERROR != ret)
                   ||
                   (PLAYTIME_NONE == storedPlaytime))
                {
                    ETG_TRACE_USR1(("Last mode position of media object is not available -> pass check if media object was played for a while"));
                    deltaTime = LocalSPM::GetDataProvider().LastModeDeltaTime() + 1;
                    ret = MP_NO_ERROR;
                }
                else
                {
                    /* Last mode position of current media object is available */
                    deltaTime = (elapsedPlaytime > storedPlaytime) ? (elapsedPlaytime - storedPlaytime) : (storedPlaytime - elapsedPlaytime);
                }

                if( deltaTime > (tPlaytime)LocalSPM::GetDataProvider().LastModeDeltaTime() )
                {
                    /* Check if total playtime is valid */
                    tPlaytime totalPlaytime = currentMediaObject.totalPlaytime;
                    if((0 == totalPlaytime)
                       ||
                       (PLAYTIME_NONE == totalPlaytime))
                    {
                        ETG_TRACE_USR1(("Total playtime of current object is not valid -> pass check if end of media object is reached"));
                        totalPlaytime = elapsedPlaytime + LocalSPM::GetDataProvider().LastModeDeltaTimeZero() + 1;
                    }

                    /* In case of end of media object or beginning of the media object is reached store position 0 */
                    if(((totalPlaytime - elapsedPlaytime) < LocalSPM::GetDataProvider().LastModeDeltaTimeZero())
                       ||
                       (elapsedPlaytime < (tPlaytime)LocalSPM::GetDataProvider().LastModeDeltaTimeZero()))
                    {
                        ret = LocalSPM::GetDBManager().StoreLastPlaytime(IN currentMediaObject.objectID, IN 0);
                    }
                    else
                    {
                        ret = LocalSPM::GetDBManager().StoreLastPlaytime(IN currentMediaObject.objectID, IN elapsedPlaytime);
                    }
                }
            }
        }
    }

    return ret;
}

tResult PlayerManager::RestoreLastPlaytime()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::RestoreLastPlaytime"));

    /* Set start playtime to 0 */
    m_StartTime = 0;

    tResult ret = MP_NO_ERROR;
    tListID currentListID = LIST_ID_NONE;
    ret = GetListID(OUT currentListID);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Current listID is not valid -> Cannot restore last mode position"));
    }
    else
    {
        tMediaObject mediaObject;
        mediaObject.objectID = OBJECT_ID_NONE;
        ret = LocalSPM::GetListControl().GetCurrentMediaObject(OUT mediaObject, IN currentListID);
        if((MP_NO_ERROR != ret)
           ||
           (OBJECT_ID_NONE == mediaObject.objectID))
        {
            ETG_TRACE_ERR(("Error while getting current media object from ListControl -> Cannot restore last mode position (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            /* Check if last mode position of media object is supported */
            VARTRACE(mediaObject.objectID);
            if( LocalSPM::GetDataProvider().IsLastModePositionSupported(IN mediaObject.deviceType, IN mediaObject.catType) )
            {
                /* Check if last mode position of media object is available */
                tPlaytime elapsedPlaytime = PLAYTIME_NONE;
                ret = LocalSPM::GetDBManager().GetLastPlaytime(OUT elapsedPlaytime, IN mediaObject.objectID);
                if((MP_NO_ERROR != ret)
                   ||
                   (PLAYTIME_NONE == elapsedPlaytime))
                {
                    ETG_TRACE_USR1(("Last mode position of media object is not available -> Set start playtime to 0"));
                    ret = MP_NO_ERROR;
                }
                else
                {
                    m_StartTime = elapsedPlaytime;
                }
            }
        }
    }

    return ret;
}

tResult PlayerManager::StoreAllocated()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::StoreAllocated"));

    tResult ret = MP_NO_ERROR;

    /* Set allocate state to ALLOCATED */
    SetAllocateState(IN ALS_ALLOCATED);

    return ret;
}

tResult PlayerManager::StoreActive()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::StoreActive"));

    tResult ret = MP_NO_ERROR;

    /* Set allocate state to ACTIVE */
    SetAllocateState(IN ALS_ACTIVE);

    /* Reset last action to PLAY */
    m_LastAction = PBA_PLAY;

    /* Reset first element of list which causes an error */
    m_FirstErrorObjectID = OBJECT_ID_NONE;

    /* Reset position of first element of list which causes an error */
    m_firstErrorObjectPosition = POSITION_NOT_SET;
    tListInfo listInfo;
    tMediaContext mediaContext;
    tListID currentListID = LIST_ID_NONE;
    ret = GetListID(OUT currentListID);
    LocalSPM::GetDBManager().GetMediaContext(OUT mediaContext);

    if( MP_NO_ERROR != LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN currentListID, IN false))
    {
        ETG_TRACE_ERR(("Error while getting list info (ErrorCode:%s)", errorString(ret)));
    }

    ETG_TRACE_USR3(("Media Context %d and FTS %d and streaming %d", mediaContext, listInfo.fileTypeSelection, listInfo.streaming));

    //fix for bug-927993: added condition to check if activedevice and listInfo.deviceID are stored differently, if different currentlistID and Mediaobject are reset.
    bool resetCurrentListInfo = false;

    /* Get current active device ID */
    tDeviceID currentActiveDeviceID = DEVICE_ID_NOT_SET;
    ret = LocalSPM::GetDBManager().GetActiveDevice(OUT currentActiveDeviceID);

    if(MP_NO_ERROR == ret)
    {
        if((DEVICE_ID_NOT_SET != currentActiveDeviceID) && (DEVICE_ID_NOT_SET != listInfo.deviceID) && (currentActiveDeviceID != listInfo.deviceID))
        {
            resetCurrentListInfo = true;
        }
    }
    else
    {
        ETG_TRACE_ERR(("Error while getting active device from DBManager (ErrorCode:%s)", errorString(ret)));
    }

    if( resetCurrentListInfo || (((MC_VIDEO == mediaContext) && (FALSE == LocalSPM::GetDataProvider().CreateListForVideoSource())) &&
                                                            ((FTS_VIDEO != listInfo.fileTypeSelection) || (1 == listInfo.streaming))))
    {
        ResetCurrentListAndMediaObject();
    }

     /* Send START message to own SM */
    ret = SendEvent(START, (char *)NULL);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }


#if 0
    /* Get current streaming mode */
    tStreamingMode currentStreamingMode = SM_OFF;
    GetStreamingMode(OUT currentStreamingMode);

    /* Immediately pause playback if last mode is PAUSED in streaming mode with related configuration */
    if( (SM_ON == currentStreamingMode)
        &&
        (PBA_PAUSE == m_LastAction)
        &&
        (!IsAutoPlayInLastMode()))
    {
        /* Send playback action PAUSE message to own SM */
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = ParameterPLAYBACK_ACTION(OUT parameterString, IN size, IN PBA_PAUSE, IN 0);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(PLAYBACK_ACTION, IN parameterString);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
#endif

    return ret;
}

tResult PlayerManager::StoreDeAllocated()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::StoreDeAllocated"));

    tResult ret = MP_NO_ERROR;

    /* Set allocate state to DEALLOCATED */
    SetAllocateState(IN ALS_DEALLOCATED);

    return ret;
}

tResult PlayerManager::ResetNowPlaying()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::ResetNowPlaying"));

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();

    m_HMINowPlaying.listID = LIST_ID_NONE;
    m_HMINowPlaying.state = NP_INVALID;
    m_HMINowPlaying.position = 0;
    m_HMINowPlaying.objectID = OBJECT_ID_NONE;
    InitMediaObject(OUT m_HMINowPlaying.object);
    m_Mutex.unlock();

    return ret;
}

tResult PlayerManager::SetNowPlayingState(const tNowPlayingState nowPlayingState)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SetNowPlayingState state:%u", nowPlayingState));

    tResult ret = MP_NO_ERROR;
    tPosition position = POSITION_NOT_SET;
    tListID listID = LIST_ID_NONE;
    tObjectID objectID = OBJECT_ID_NONE;

    m_Mutex.lock();

    m_HMINowPlaying.listID = m_ListID;
    m_HMINowPlaying.state = nowPlayingState;
    m_HMINowPlaying.position = 0;
    m_HMINowPlaying.objectID = m_MediaObject.objectID;

    //fill the yomi data for musicbox device
    if((LocalSPM::GetDataProvider().YomiMetadataSupport()) && MUSICBOX_DEVICE_ID == m_MediaObject.deviceID)
    {
        ETG_TRACE_USR3(("PlayerManager::SetNowPlayingState trying the yomi data from Database"));
        tYomiMetadata yomiMetadata;
        if(!LocalSPM::GetDBManager().GetYomiMetadata(m_HMINowPlaying.objectID, yomiMetadata))
        {
            ETG_TRACE_USR3(("PlayerManager::SetNowPlayingState Filling the yomi data from Database"));
            strncpy_r(m_MediaObject.YomiTitle,yomiMetadata.YomiTitle,sizeof(tMetadata));
            strncpy_r(m_MediaObject.YomiArtist,yomiMetadata.YomiArtist,sizeof(tMetadata));
            strncpy_r(m_MediaObject.YomiAlbum,yomiMetadata.YomiAlbum,sizeof(tMetadata));
            VARTRACE(yomiMetadata);
        }
        else
        {
            ETG_TRACE_USR3(("PlayerManager::SetNowPlayingState Fetching the yomi data from Database got failed"));
        }

    }
    m_HMINowPlaying.object = m_MediaObject;

    if(NP_NO_DEVICE != nowPlayingState)/*no need for UpdateNowPlaying in device removel case*/
    {
        listID = m_HMINowPlaying.listID;
        objectID = m_HMINowPlaying.objectID;
    }

    m_Mutex.unlock();

    if(LIST_ID_NONE == listID)
    {
        /* Nothing to do */
        return MP_NO_ERROR;
    }

    /* Inform ListControl about object currently played (for highlighting in the list) */
    ret = LocalSPM::GetListControl().UpdateNowPlaying(OUT position, IN listID, IN objectID);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while informing ListControl about object currently played (ErrorCode:%s)", errorString(ret)));
    }

    /* Update HMI of property NowPlaying */
    ret = UpdateNowPlayingWithGivenPosition(IN listID,IN position);


    return ret;
}

tResult PlayerManager::GetNowPlaying(tNowPlaying &nowPlaying)
{
    ENTRY

    m_Mutex.lock();
    nowPlaying = m_HMINowPlaying;

    /* Delete album art string if it is not available yet */
    if(false == m_AlbumArtAvailable)
    {
        nowPlaying.object.albumArtString[0] = '\0';
    }

    //clear filename attribute for all Apple devices, since the stinrg is internal and not relevant for user
    if(IsAppleDevice(nowPlaying.object.deviceType))
    {
        nowPlaying.object.fileName[0] = '\0';
        // check whether this has vt objectID - (NCG3D-119603 - For HMI to get correct position for showing coverflow)
        if(nowPlaying.objectID & IPOD_MARKER_BIT)
        {
            // Get the Object ID from DB
            tMediaObject IPODMediaObject;
            tResult result = LocalSPM::GetDBManager().GetIPODMediaObjectByUUID(IPODMediaObject, nowPlaying.object.deviceID, nowPlaying.object.UUID);
            if(MP_NO_ERROR == result)
            {
                nowPlaying.objectID = IPODMediaObject.objectID;
                nowPlaying.object.objectID = IPODMediaObject.objectID;
            }
            else
            {
                ETG_TRACE_USR3(("Error fetching Object ID using uuid"));
            }
            VARTRACE(nowPlaying.object.objectID);
        }
    }
    m_Mutex.unlock();

    if(ALS_ACTIVE == m_AllocateState)
    {
        nowPlaying.object.isPlaying = true; //Is playing in case of active
    }
    else
    {
        nowPlaying.object.isPlaying = false;
    }

    /* Replace unknown text of meta data fields if configured */
    static char dbUnknownText[64] = {0};
    strncpy_r(OUT dbUnknownText, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(dbUnknownText));
    static char nowPlayingUnknownText[64] = {0};
    strncpy_r(OUT nowPlayingUnknownText, IN LocalSPM::GetDataProvider().NowPlayingUnknownText().c_str(), IN sizeof(nowPlayingUnknownText));
    if(strcmp(dbUnknownText, nowPlayingUnknownText))
    {
        if(!strcmp(dbUnknownText, nowPlaying.object.MetadataField1))
        {
            strncpy_r(OUT nowPlaying.object.MetadataField1, IN nowPlayingUnknownText, IN sizeof(nowPlaying.object.MetadataField1));
        }
        if(!strcmp(dbUnknownText, nowPlaying.object.MetadataField2))
        {
            strncpy_r(OUT nowPlaying.object.MetadataField2, IN nowPlayingUnknownText, IN sizeof(nowPlaying.object.MetadataField2));
        }
        if(!strcmp(dbUnknownText, nowPlaying.object.MetadataField3))
        {
            strncpy_r(OUT nowPlaying.object.MetadataField3, IN nowPlayingUnknownText, IN sizeof(nowPlaying.object.MetadataField3));
        }
        if(!strcmp(dbUnknownText, nowPlaying.object.MetadataField4))
        {
            strncpy_r(OUT nowPlaying.object.MetadataField4, IN nowPlayingUnknownText, IN sizeof(nowPlaying.object.MetadataField4));
        }
        if(!strcmp(dbUnknownText, nowPlaying.object.title))
        {
            strncpy_r(OUT nowPlaying.object.title, IN nowPlayingUnknownText, IN sizeof(nowPlaying.object.title));
        }
    }

    //NCG3D-22460:nowPlaying.state is setup differently for Different DeviceTypes.
    CalculateNowPlayingState(INOUT nowPlaying);

    ETG_TRACE_USR3(("PlayerManager::GetNowPlaying state:%u, listID:%u, objectID:%u title:%s",
            nowPlaying.state, nowPlaying.listID, nowPlaying.objectID, nowPlaying.object.title));
    return MP_NO_ERROR;
}

tResult PlayerManager::SetAlbumArtAvailability(const tAvailable available, const tBoolean updateHMI)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SetAlbumArtAvailability available:%u, updateHMI:%u", available, updateHMI));

    tResult ret = MP_NO_ERROR;
    tBoolean changed = false;
    tDeviceID nowPlayingDeviceID = DEVICE_ID_NOT_SET;

    m_Mutex.lock();
    if(available != m_AlbumArtAvailable)
    {
        m_AlbumArtAvailable = available;
        changed = true;
    }
    nowPlayingDeviceID = m_MediaObject.deviceID;
    m_Mutex.unlock();

    if(updateHMI && changed)
    {
        /* Get current active device ID */
        //tDeviceID currentDeviceID = DEVICE_ID_NOT_SET;
        //ret = LocalSPM::GetDBManager().GetActiveDevice(OUT currentDeviceID);
        if((MP_NO_ERROR == ret)
           &&
           ((nowPlayingDeviceID == m_ActiveDevice) //nowPlaying is related to active device
            ||
            (MY_MEDIA == m_ActiveDevice)))
        {
            /* Update HMI of property NowPlaying */
            ret = LocalSPM::GetOutputWrapper().UpdateNowPlaying();
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while updating NowPlaying via OutputWrapper (ErrorCode:%s)", errorString(ret)));
            }
        }
        else
        {
            ETG_TRACE_USR1(("Album art availability is not related to the active device -> No update"));
        }
    }

    return ret;
}

tResult PlayerManager::SetPlaytime(const tPlaytime elapsedPlaytime, const tPlaytime totalPlaytime, const tBoolean validLastMode,const tObjectID objectID)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SetPlaytime elapsedPlaytime:%u, totalPlaytime:%u, validLastMode:%u", elapsedPlaytime, totalPlaytime, validLastMode));

    tResult ret = MP_NO_ERROR;
    tBoolean changed = false;
    tDeviceID nowPlayingDeviceID = DEVICE_ID_NOT_SET;

    tPlaytime localTotalPlaytime = totalPlaytime;
    if(PLAYTIME_NONE == totalPlaytime)
    {
        localTotalPlaytime = m_HMITotalPlaytime;
    }

    tPlaytime localElapsedPlaytime = elapsedPlaytime;
    if(PLAYTIME_NONE == elapsedPlaytime)
    {
        localElapsedPlaytime = m_HMIElapsedPlaytime;
    }
    else if(PLAYTIME_END_OF_OBJECT == elapsedPlaytime)
    {
        localElapsedPlaytime = localTotalPlaytime - 1000;
    }


    m_Mutex.lock();
    m_ValidLastMode = validLastMode;
    nowPlayingDeviceID = m_MediaObject.deviceID;

    if(localElapsedPlaytime != m_HMIElapsedPlaytime)
    {
        m_HMIElapsedPlaytime = localElapsedPlaytime;
        changed = true;
    }
    if(localTotalPlaytime != m_HMITotalPlaytime)
    {
        m_HMITotalPlaytime = localTotalPlaytime;
        m_MediaObject.totalPlaytime = localTotalPlaytime;
        changed = true;
    }
    m_HMIObjectID = objectID;
    m_Mutex.unlock();

    if(changed)
    {
        /* Get current active device ID */
        tDeviceID currentDeviceID = DEVICE_ID_NOT_SET;
        //ret = LocalSPM::GetDBManager().GetActiveDevice(OUT currentDeviceID);
        GetActiveDevice(OUT currentDeviceID);
        if((MP_NO_ERROR == ret)
           &&
           ((nowPlayingDeviceID == currentDeviceID) //playtime is related to the active device
            ||
            (MY_MEDIA == currentDeviceID)))
        {
            /* Update HMI of property Playtime */
            ret = LocalSPM::GetOutputWrapper().UpdatePlaytime();
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while updating Playtime via OutputWrapper (ErrorCode:%s)", errorString(ret)));
            }
        }
        else
        {
            ETG_TRACE_USR1(("Playtime is not related to the active device -> No update"));
        }
    }

    return ret;
}

tResult PlayerManager::GetPlaytime(tPlaytime &elapsedPlaytime, tPlaytime &totalPlaytime,tObjectID &objectID)
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();
    elapsedPlaytime = m_HMIElapsedPlaytime;
    totalPlaytime = m_HMITotalPlaytime;
    objectID = m_HMIObjectID;
    m_Mutex.unlock();

    ETG_TRACE_USR3(("PlayerManager::GetPlaytime elapsedPlaytime:%u, totalPlaytime:%u,objectID:%u", elapsedPlaytime, totalPlaytime,objectID));
    return ret;
}

tResult PlayerManager::GetLastModePlaytime(tPlaytime &elapsedPlaytime)
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();
    if(FALSE == m_ValidLastMode)
    {
        elapsedPlaytime = PLAYTIME_NONE;

        //ret = MP_ERR_PM_NO_TOTAL_PLAYTIME;
    }
    else
    {
        elapsedPlaytime = m_HMIElapsedPlaytime;
    }
    m_Mutex.unlock();

    ETG_TRACE_USR3(("PlayerManager::GetLastModePlaytime elapsedPlaytime:%u", elapsedPlaytime));
    return ret;
}

tResult PlayerManager::UpdatePlaybackState(const tPEPlaybackState status)
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    tHMIPlaybackState playbackState = HMI_PBS_STOPPED;

    /* Get current streaming mode */
    tStreamingMode currentStreamingMode = SM_OFF;
    GetStreamingMode(OUT currentStreamingMode);

    if( SM_OFF == currentStreamingMode )
    {
        /* Mapping of state machine state to HMI playback state */
        ret = CalcPlaybackState(OUT playbackState);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calculating PlaybackState"));
        }
    }
    else
    {
        switch(status)
        {
        case PE_PBS_STOPPEDSTATE:
            playbackState = HMI_PBS_STOPPED;
            break;
        case PE_PBS_PLAYINGSTATE:
        case PE_PBS_LOADINGSTATE:
            playbackState = HMI_PBS_PLAYING;
            break;
        case PE_PBS_PAUSEDSTATE:
            playbackState = HMI_PBS_PAUSED;
            break;
        case PE_PBS_FASTFORWARDSTATE:
            playbackState = HMI_PBS_FFWD;
            break;
        case PE_PBS_FASTREVERSESTATE:
            playbackState = HMI_PBS_FREV;
            break;
        case PE_PBS_BUFFERINGSTATE:
        case PE_PBS_ABOUTTOFINISHSTATE:
        case PE_PBS_FINISHEDSTATE:
        case PE_PBS_SEEKTOSTATE:
        case PE_PBS_ERRORSTATE:
        default:
            ret = MP_ERR_PM_INVALID_PARAM;
            break;
        }
    }

    if(MP_NO_ERROR == ret)
    {
        ETG_TRACE_USR3(("PlayerManager::UpdatePlaybackState playbackState: %u", playbackState));
        tBoolean changed = false;

        m_Mutex.lock();
        if(playbackState != m_HMIPlaybackState)
        {
            m_HMIPlaybackState = playbackState;

            changed = true;
        }
        m_Mutex.unlock();

        /* Update HMI of property PlaybackState */
        if(changed)
        {
            ret = LocalSPM::GetOutputWrapper().UpdatePlaybackState();
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while updating PlaybackState via OutputWrapper (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    return ret;
}

tResult PlayerManager::UpdatePlaybackState(void)
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    /* Update PlaybackState derived from internal SM state */
    ret = UpdatePlaybackState(PE_PBS_STOPPEDSTATE);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while updating PlaybackState"));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult PlayerManager::GetPlaybackState(tHMIPlaybackState &playbackState)
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();
    playbackState = m_HMIPlaybackState;
    m_Mutex.unlock();

    ETG_TRACE_USR3(("PlayerManager::GetPlaybackState playbackState:%u", playbackState));
    return ret;
}

tResult PlayerManager::CalcPlaybackState(tHMIPlaybackState &playbackState)
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    /* Mapping of state machine state to HMI playback state */
    PlayerManagerSM_states state = (PlayerManagerSM_states)PlayerManagerSM::GetState();
    switch (state)
        {
            case playing:
            case waitingFor_fFwd:
            case waitingFor_fRev:
            case waitingFor_paused:
            case waitingForSeekTo_playing:
            case waitingForMultipleNext_playing:
            case streamingActive:
            case waitingFor_streamingAction:
                playbackState = HMI_PBS_PLAYING;
                break;
            case paused:
            case waitingForSeekTo_paused:
            case waitingForPlay_pausedFFwd:
            case waitingForPlay_pausedFRev:
            case waitingForResume_playing:
            case waitingForMultipleNext_paused:
            case waitingFor_pausedFFwd:
            case waitingFor_pausedFRev:
            case pausedStop:
            case waitingFor_pausedStop:
                playbackState = HMI_PBS_PAUSED;
                break;
            case fFwd:
            case pausedFFwd:
            case waitingForPlay_fFwd:
            case waitingForFastStop_paused:
            case waitingForFFwdStop_playing:
            case fFwd_deAllocate:
                playbackState = HMI_PBS_FFWD;
                break;
            case fRev:
            case pausedFRev:
            case waitingForPlay_fRev:
            case waitingForFRevStop_playing:
            case fRev_deAllocate:
                playbackState = HMI_PBS_FREV;
                break;
            case topPlayerManager:
            case playerManager:
            case normalMode:
            case streamingMode:
            case waitingFor_allocate:
            case allocated:
            case waitingFor_deAllocate:
            case deAllocated:
            case active:
            case stop:
            case finalPlayerManager:
            case waitingFor_playing:
            case waitingFor_saOff:
            case playingLastMode:
            case pausedLastMode:
            case noObject:
            case waitingFor_noObject:
            case waitingFor_streamingAllocate:
            case streamingAllocated:
            case waitingFor_streamingDeAllocate:
            case streamingDeAllocated:
            case waitingFor_streamingSAOff:
            default:
                playbackState = HMI_PBS_STOPPED;
                break;
        }

    ETG_TRACE_USR4(("PlayerManager::CalcPlaybackStatus state:%u -> playbackState:%u (0=playing, 1=paused, 2=stopped, 3=ffwd, 4=frev)", state, playbackState));
    return ret;
}

tResult PlayerManager::BufferStatus(const tSuccess success)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::BufferStatus success:%u", success));

    if(SC_YES == success)
    {
        tPosition bufferIndex;
        GetBufferIndex(OUT bufferIndex);
        SetBufferIndex(IN bufferIndex+1);
    }

    return MP_NO_ERROR;
}

tResult PlayerManager::PlaybackStatusPlay(const tPEPlaybackState status,
                                          const tMetadata metadata1,
                                          const tMetadata metadata2,
                                          const tMetadata metadata3,
                                          const tMetadata metadata4,
                                          const tTitle metadataTitle,
                                          const tMediaType mediaType,
                                          const tConvertFlag metadataConvertFlag,
                                          const tUUID uuid)
{
    ENTRY

    ForwardPlaybackStatus(IN status, IN metadata1, IN metadata2, IN metadata3, IN metadata4, IN metadataTitle, IN mediaType, IN metadataConvertFlag, IN uuid);

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult PlayerManager::PlaybackStatus(const tPEPlaybackState status)
{
    ENTRY

    tMetadata metadata = {0};
    tTitle title = {0};
    tMediaType mediaType = MTY_UNKNOWN;

    ForwardPlaybackStatus(IN status, IN metadata, IN metadata, IN metadata, IN metadata, IN title, IN mediaType);

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult PlayerManager::PlaybackStatusNew(const tPEHandle handle, const tPEPlaybackState playbackState, const me::reason_e reason, const me::speed_e speed)
{
    ENTRY

    ForwardPlaybackStatusNew(IN handle, IN playbackState, IN reason, IN speed);

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult PlayerManager::ForwardPlaybackStatus(const tPEPlaybackState status,
                                             const tMetadata metadata1,
                                             const tMetadata metadata2,
                                             const tMetadata metadata3,
                                             const tMetadata metadata4,
                                             const tTitle metadataTitle,
                                             const tMediaType mediaType,
                                             const tConvertFlag metadataConvertFlag,
                                             const tUUID uuid,
                                             const tObjectID objectID)
{
    ENTRY

    if((NULL == metadata1)
       ||
       (NULL == metadata2)
       ||
       (NULL == metadata3)
       ||
       (NULL == metadata4)
       ||
       (NULL == metadataTitle))
    {
        ETG_TRACE_ERR(("Invalid parameter: metadata is NULL"));
        return MP_ERR_PM_INVALID_PARAM;
    }
    ETG_TRACE_USR3(("PlayerManager::ForwardPlaybackStatus status:%u, metadataTitle:%40s, mediaType:%u, convertFlag:%u, uuid:%40s , objectID:%d",
            status, CHECK_NULL(metadataTitle), mediaType, metadataConvertFlag, CHECK_NULL(uuid),objectID));
    ETG_TRACE_USR3(("PlayerManager::ForwardPlaybackStatus metadata1:%40s, metadata2:%40s, metadata3:%40s, metadata4:%s ",
            CHECK_NULL(metadata1), CHECK_NULL(metadata2), CHECK_NULL(metadata3), CHECK_NULL(metadata4)));
    VARTRACE(uuid);

    tResult ret = MP_NO_ERROR;

    switch(status)
    {
        case PE_PBS_ERRORSTATE:
        {
#if 0
            /* Send STREAM_ERROR message to own SM */
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);

            ret = ParameterSTREAM_ERROR(OUT parameterString, IN size, IN metadata2);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            }
            else
            {
                ret = SendEvent(STREAM_ERROR, IN parameterString);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
                }
            }
#else
            ETG_TRACE_ERR(("PE_PBS_ERRORSTATE should not come anymore! -> STREAM_ERROR or ACTION_ERROR"));
            ret = MP_ERR_PM_INVALID_PARAM;
#endif
            break;
        }
        case PE_PBS_FINISHEDSTATE:
        {
            /* Send FINISHED message to own SM */
            ret = SendEvent(FINISHED, (char *)NULL);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
            break;
        }
        case PE_PBS_STOPPEDSTATE:
        case PE_PBS_PAUSEDSTATE:
        {
            /* Update PlaybackState derived from internal SM state */
            ret = UpdatePlaybackState(IN status);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while updating PlaybackState"));
            }
            break;
        }
        case PE_PBS_FASTFORWARDSTATE:
        case PE_PBS_FASTREVERSESTATE:
        case PE_PBS_PLAYINGSTATE:
        {
            /* Update PlaybackState derived from internal SM state */
            ret = UpdatePlaybackState(IN status);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while updating PlaybackState"));
            }


            /* Update NowPlaying */
            tListID currentListID = LIST_ID_NONE;
            ret = GetListID(OUT currentListID);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Current listID is not valid -> Cannot update NowPlaying status"));
            }
            else
            {
                tListInfo listInfo;
                tBoolean withListSize = false;
                ret = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN currentListID, IN withListSize);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while getting list info at ListControl -> Cannot update NowPlaying status (ErrorCode:%s)", errorString(ret)));
                }
                else
                {
                    if(LocalSPM::GetDataProvider().FavoritesSupported())
                    {
                        tReturnValue isDeActivateReq = IsDeActivateAllFavoritesRequired(IN uuid, IN listInfo.deviceID, IN currentListID, IN listInfo.listSize);
                        VARTRACE(isDeActivateReq);
                        if(isDeActivateReq)
                        {
                            ret = LocalSPM::GetDBManager().DeActivateAllFavorites();
                            if( MP_NO_ERROR != ret )
                            {
                                   ETG_TRACE_ERR(("Error while deactivating all favorites in DB (ErrorCode:%s)", errorString(ret)));
                            }
                        }
                    }

                    tMediaObject currentMediaObject;
                    InitMediaObject(OUT currentMediaObject);
                    tBoolean mediaObjectAvailable = TRUE;
                    if(LTY_CURRENT_SELECTION == listInfo.listType) //only for iPod current selection list
                    {
                        /* Position the iPod current selection */
                        ret = LocalSPM::GetListControl().SetMediaObject(OUT currentMediaObject, IN currentListID, IN INDEX_LAST_ACTIVE_OBJECT);
                        //ret = LocalSPM::GetListControl().GetCurrentMediaObject(OUT currentMediaObject, IN currentListID);
                        if( MP_NO_ERROR != ret )
                        {
                            ETG_TRACE_USR1(("Cannot position the iPod current selection (ErrorCode:%s)", errorString(ret)));

                            /* Take media object from database as error handling */
                            ret = GetMediaObject(OUT currentMediaObject);
                            if( MP_NO_ERROR != ret )
                            {
                                ETG_TRACE_ERR(("Error while getting current media object -> Cannot update NowPlaying state"));
                                mediaObjectAvailable = FALSE;
                            }
                        }
                        else
                        {
                            /* Try to get device related information for media object */
                            tDeviceInfo deviceInfo;
                            ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN listInfo.deviceID);
                            if( MP_NO_ERROR != ret )
                            {
                                ETG_TRACE_ERR(("Error while getting device info from DBManager (ErrorCode:%s)", errorString(ret)));
                            }
                            else
                            {
                                currentMediaObject.deviceID = deviceInfo.deviceID;
                                currentMediaObject.deviceType = deviceInfo.deviceType;
                                strncpy_r(OUT currentMediaObject.mountPoint, IN deviceInfo.mountPoint, IN sizeof(currentMediaObject.mountPoint));
                            }

                            /* Set current media object */
                            SetMediaObject(IN currentMediaObject);
                        }
                    }
                    else
                    {
                        if(0 == strlen_r(metadataTitle)) //Metadata from DeviceControl not available
                        {
                            mediaObjectAvailable = FALSE;
                        }


                        ret = GetMediaObject(OUT currentMediaObject);
                        if( MP_NO_ERROR != ret )
                        {
                            ETG_TRACE_ERR(("Error while getting current media object -> Cannot update NowPlaying state"));
                            mediaObjectAvailable = FALSE;
                        }
                    }

                    if(mediaObjectAvailable)
                    {
                        //Overwrite title always because in case of playing from file list it is filled with filename inclusive extension
                        strncpy_r(OUT currentMediaObject.title, IN metadataTitle, IN sizeof(currentMediaObject.title));

                        if(0 < strlen_r(metadata1)) //Overwrite genre from DeviceControl
                        {
                            strncpy_r(OUT currentMediaObject.MetadataField1, IN metadata1, IN sizeof(currentMediaObject.MetadataField1));
                        }
                        else
                        {
                            strncpy_r(OUT currentMediaObject.MetadataField1, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(currentMediaObject.MetadataField1));
                        }

                        if(0 < strlen_r(metadata2)) //Overwrite artist from DeviceControl
                        {
                            strncpy_r(OUT currentMediaObject.MetadataField2, IN metadata2, IN sizeof(currentMediaObject.MetadataField2));
                        }
                        else
                        {
                            strncpy_r(OUT currentMediaObject.MetadataField2, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(currentMediaObject.MetadataField2));
                        }

                        if(0 < strlen_r(metadata3)) //Overwrite composer from DeviceControl
                        {
                            strncpy_r(OUT currentMediaObject.MetadataField3, IN metadata3, IN sizeof(currentMediaObject.MetadataField3));
                        }
                        else
                        {
                            strncpy_r(OUT currentMediaObject.MetadataField3, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(currentMediaObject.MetadataField3));
                        }

                        if(0 < strlen_r(metadata4)) //Overwrite album from DeviceControl
                        {
                            strncpy_r(OUT currentMediaObject.MetadataField4, IN metadata4, IN sizeof(currentMediaObject.MetadataField4));
                        }
                        else
                        {
                            strncpy_r(OUT currentMediaObject.MetadataField4, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(currentMediaObject.MetadataField4));
                        }

                        currentMediaObject.metadataConvertFlag = metadataConvertFlag;

                        if(MTY_UNKNOWN != mediaType)
                        {
                            currentMediaObject.mediaType = mediaType;
                            currentMediaObject.catType = LocalSPM::GetDBManager().GetCTYByMTY(mediaType);
                        }
                        else
                        {
                            /* Reorder metadata because it is filled like MTY_MUSIC_FILE (GMMY17-4835) */
                            if(MTY_AUDIOBOOK == currentMediaObject.mediaType)
                            {
                                strncpy_r(OUT currentMediaObject.MetadataField1, IN currentMediaObject.MetadataField2, sizeof(currentMediaObject.MetadataField1));
                                strncpy_r(OUT currentMediaObject.MetadataField2, IN currentMediaObject.MetadataField4, sizeof(currentMediaObject.MetadataField2));
                                strncpy_r(OUT currentMediaObject.MetadataField3, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(currentMediaObject.MetadataField3));
                                strncpy_r(OUT currentMediaObject.MetadataField4, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(currentMediaObject.MetadataField4));
                            }
                            else if(MTY_PODCAST == currentMediaObject.mediaType)
                            {
                                strncpy_r(OUT currentMediaObject.MetadataField1, IN currentMediaObject.MetadataField4, sizeof(currentMediaObject.MetadataField1));
                                strncpy_r(OUT currentMediaObject.MetadataField2, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(currentMediaObject.MetadataField2));
                                strncpy_r(OUT currentMediaObject.MetadataField3, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(currentMediaObject.MetadataField3));
                                strncpy_r(OUT currentMediaObject.MetadataField4, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(currentMediaObject.MetadataField4));
                            }
                        }

                        /* fill all ID's from DB or Livetags table */
                        LocalSPM::GetDBManager().FillupMetaDataIDs(INOUT currentMediaObject);

                        if(OBJECT_ID_NONE != objectID)
                        {
                            currentMediaObject.objectID =  objectID;
                        }
                        /* Change metadata of current media object */
                        SetMediaObject(IN currentMediaObject);
                    }

                    /* Set internal player manager member NowPlayingState to new value */
                    ret = SetNowPlayingState(NP_NEW_TRACK);
                    if(MP_NO_ERROR != ret)
                    {
                        ETG_TRACE_ERR(("Error while setting NowPlaying state"));
                    }
                }
            }
            break;
        }
        case PE_PBS_LOADINGSTATE:
        {
            /* Used for start streaming -> do nothing */
            break;
        }
        default:
        {
            ETG_TRACE_ERR(("Invalid playback state from PlayerEngine: %u\n ",status));
            ret = MP_ERR_PM_INVALID_PARAM;
            break;
        }
    }

    return ret;
}

#if 0 //-> Obsolete event SEEK_TO_ANSWER
tResult PlayerManager::PlaytimeStatus(const tPlaytime elapsedPlaytime, const tPlaytime totalPlaytime)
{
    ENTRY

    ForwardPlaytimeStatus(IN elapsedPlaytime, IN totalPlaytime);

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}
#endif

#if 0 //-> Obsolete event TICK_TIME_ELAPSED
tResult PlayerManager::ForwardPlaytimeStatus(const tPlaytime elapsedPlaytime, const tPlaytime totalPlaytime)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::ForwardPlaytimeStatus elapsedPlaytime:%u, totalPlaytime:%u", elapsedPlaytime, totalPlaytime));

    tResult ret = MP_NO_ERROR;

    if(PLAYTIME_NONE == elapsedPlaytime) return MP_ERR_PM_INVALID_PARAM;

    /* Don't update playtime in playback state STOPPED */
    tHMIPlaybackState playbackState = HMI_PBS_PLAYING;
    ret = CalcPlaybackState(OUT playbackState);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while calculating PlaybackState"));
    }

    if(HMI_PBS_STOPPED != playbackState)
    {
        if(HMI_PBS_FREV == playbackState)
        {
            /* Detect beginning of object while fast reverse */
            tPlaytime lastElapsedPlaytime = 0;
            tPlaytime lastTotalPlaytime = 0;
            ret = GetPlaytime(OUT lastElapsedPlaytime, OUT lastTotalPlaytime);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while getting last playtime -> Cannot detect beginning of object"));
            }
                else
            {
                if((lastElapsedPlaytime > elapsedPlaytime)
                   &&
                   (1000 > elapsedPlaytime))
                {
                    /* Send FINISHED message to own SM */
                    ret = SendEvent(FINISHED, (char *)NULL);
                    if(MP_NO_ERROR != ret)
                    {
                        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
                    }
                }
            }
        }

        /* Ignore value 0 for totalPlaytime */
        tPlaytime localTotalPlaytime = totalPlaytime;
        if(0 == totalPlaytime)
        {
            localTotalPlaytime = PLAYTIME_NONE;
        }

        /* Set internal player manager member Playtime to new value */
        SetPlaytime(IN elapsedPlaytime, IN localTotalPlaytime, IN true /*validLastMode*/);

        if(1000 < (int)elapsedPlaytime)
        {
            /* Reset last action to PLAY */
            m_LastAction = PBA_PLAY;

            /* Media object is playable, reset first element of list which causes an error */
            m_FirstErrorObjectID = OBJECT_ID_NONE;
        }
    }

    return ret;
}
#endif

tResult PlayerManager::PlaytimeStatusNew(const tPEHandle handle, const tDeviceID deviceID, const tPETimeInfo timeInfo)
{
    ENTRY

    ForwardPlaytimeStatusNew(IN handle, IN deviceID, IN timeInfo);

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult PlayerManager::ForwardPlaytimeStatusNew(const tPEHandle handle, const tDeviceID deviceID, const tPETimeInfo timeInfo)
{
    ENTRY

    VARTRACE(handle);
    VARTRACE(deviceID);
    VARTRACE(timeInfo);

    tResult ret = MP_NO_ERROR;
    tBoolean update = true;

    /* Check handle or deviceID if it fits to current object */
    tMediaObject currentMediaObject;
    ret = GetMediaObject(OUT currentMediaObject);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while getting current media object -> Cannot check handle or deviceID"));
    }
    else
    {
        /* Get current streaming mode */
        tStreamingMode currentStreamingMode = SM_OFF;
        GetStreamingMode(OUT currentStreamingMode);

        if( SM_OFF == currentStreamingMode )
        {
            if(handle != (tPEHandle)currentMediaObject.objectID)
            {
                update = false;
                ETG_TRACE_ERR(("Handle does not fit -> Do not update Playtime status"));
            }
        }
        else //SM_ON
        {
            if(deviceID != currentMediaObject.deviceID)
            {
                update = false;
                ETG_TRACE_ERR(("DeviceID does not fit -> Do not update Playtime status"));
            }
        }
    }

    if(update)
    {
        /* Unmarshal string of timeInfo into the corresponding struct */
        tPETimeInfoStruct timeInfoStruct;
        SMF::UnMarshal(IN timeInfo,
                IN DOUBLE_MARSHAL_SEPARATOR,
                IN tPEBytes_format tPEPercentage_format tPEMilliseconds_format tPEBytes_format tPEMilliseconds_format,
                OUT &timeInfoStruct.position.bytes,
                OUT &timeInfoStruct.position.pct,
                OUT &timeInfoStruct.position.ms,
                OUT &timeInfoStruct.duration.bytes,
                OUT &timeInfoStruct.duration.ms);

        tPlaytime elapsedPlaytime = (tPlaytime)timeInfoStruct.position.ms;
        tPlaytime totalPlaytime = (tPlaytime)timeInfoStruct.duration.ms;

        ETG_TRACE_USR3(("PlayerManager::ForwardPlaytimeStatusNew elapsedPlaytime:%u, totalPlaytime:%u", elapsedPlaytime, totalPlaytime));

        if(0 > (int)elapsedPlaytime) return MP_ERR_PM_INVALID_PARAM;

        /* Don't update playtime in playback state STOPPED */
        tHMIPlaybackState playbackState = HMI_PBS_PLAYING;
        ret = CalcPlaybackState(OUT playbackState);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calculating PlaybackState"));
        }

        if(HMI_PBS_STOPPED != playbackState)
        {
            if(HMI_PBS_FREV == playbackState)
            {
                /* Detect beginning of object while fast reverse */
                tPlaytime lastElapsedPlaytime = 0;
                tPlaytime lastTotalPlaytime = 0;
                tObjectID objectID = OBJECT_ID_NONE;

                ret = GetPlaytime(OUT lastElapsedPlaytime, OUT lastTotalPlaytime, OUT objectID);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while getting last playtime -> Cannot detect beginning of object"));
                }
                else
                {
                    if((lastElapsedPlaytime > elapsedPlaytime)
                       &&
                       (1000 > elapsedPlaytime))
                    {
                        /* Send FINISHED message to own SM */
                        ret = SendEvent(FINISHED, (char *)NULL);
                        if(MP_NO_ERROR != ret)
                        {
                            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
                        }
                    }
                }
            }

            /* Ignore value 0 for totalPlaytime */
            if(0 == totalPlaytime)
            {
                totalPlaytime = PLAYTIME_NONE;
            }

            /* Set internal player manager member Playtime to new value */
            SetPlaytime(IN elapsedPlaytime, IN totalPlaytime, IN true /*validLastMode*/,IN handle);

            if(1000 < (int)elapsedPlaytime)
            {
                /* Reset last action to PLAY */
                m_LastAction = PBA_PLAY;

                /* Media object is playable, reset first element of list which causes an error */
                m_FirstErrorObjectID = OBJECT_ID_NONE;

                /* Reset position of first element of list which causes an error */
                m_firstErrorObjectPosition = POSITION_NOT_SET;
            }
        }
    }

    return ret;
}

tResult PlayerManager::ForwardPlaybackStatusNew(const tPEHandle handle, const tPEPlaybackState status, const me::reason_e reason, const me::speed_e speed)
{
    ENTRY

    VARTRACE(handle);
    VARTRACE(status);
    VARTRACE(reason);
    VARTRACE(speed);

    tResult ret = MP_NO_ERROR;
    tPEPlaybackState localStatus = status;

    if((REASON_BUSY == reason)
       ||
       (REASON_IDLE == reason))
    {
#if 0
        /* Forward activity status */
        tPEActivityStatus activityStatus = PE_ACS_IDLE;
        if(REASON_IDLE == reason)
        {
            activityStatus = PE_ACS_BUSY;
        }
        //TODO ForwardActivityStatus(IN handle, IN activityStatus);
#endif
    }
    else if(REASON_EMPTY == reason/* ||
            REASON_END_OF_STREAM == reason*/)
    {
        localStatus = PE_PBS_FINISHEDSTATE;
    }
    else if(REASON_NEW_TRACK == reason)
    {
        localStatus = PE_PBS_BUFFERINGSTATE;
    }

    switch(localStatus)
    {
        case PE_PBS_ERRORSTATE:
        {
#if 0
            /* Send STREAM_ERROR message to own SM */
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);

            ret = ParameterSTREAM_ERROR(OUT parameterString, IN size, IN reason);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            }
            else
            {
                ret = SendEvent(STREAM_ERROR, IN parameterString);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
                }
            }
#else
            ETG_TRACE_ERR(("PE_PBS_ERRORSTATE should not come anymore! -> STREAM_ERROR or ACTION_ERROR"));
            ret = MP_ERR_PM_INVALID_PARAM;
#endif
            break;
        }
        case PE_PBS_FINISHEDSTATE:
        {
            /* Send FINISHED message to own SM */
            ret = SendEvent(FINISHED, (char *)NULL);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
            break;
        }
        case PE_PBS_BUFFERINGSTATE:
        {
            /* Check if gapless play is configured by DataProvider */
            if( LocalSPM::GetDataProvider().GaplessPlay() )
            {
                /* Send NEXT_BUFFER message to own SM */
                ret = SendEvent(NEXT_BUFFER, (char *)NULL);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
                }
            }
            break;
        }
        case PE_PBS_STOPPEDSTATE:
        case PE_PBS_PAUSEDSTATE:
        case PE_PBS_FASTFORWARDSTATE:
        case PE_PBS_FASTREVERSESTATE:
        case PE_PBS_PLAYINGSTATE:
        {
            /* Update PlaybackState derived from internal SM state */
            ret = UpdatePlaybackState(IN localStatus);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while updating PlaybackState"));
            }
            break;
        }
        case PE_PBS_LOADINGSTATE:
        {
            /* Used for start streaming -> do nothing */
            break;
        }
        default:
        {
            ETG_TRACE_ERR(("Invalid playback state from PlayerEngine: %u\n ",localStatus));
            ret = MP_ERR_PM_INVALID_PARAM;
            break;
        }
    }

    return ret;
}

tResult PlayerManager::ForwardNowPlayingStatus(const tPEHandle handle,
                                               const tMetadata metadata1,
                                               const tMetadata metadata2,
                                               const tMetadata metadata3,
                                               const tMetadata metadata4,
                                               const tTitle metadataTitle,
                                               const tMediaType mediaType,
                                               const tBitRate bitRate,
                                               const me::samplerate_i sampleRate,
                                               const tAudioChannelFormat audioChannelFormat,
                                               const tConvertFlag metadataConvertFlag,
                                               const tUUID uuid,
                                               const tAlbumArt albumArtString)
{
    ENTRY

    if((NULL == metadata1)
       ||
       (NULL == metadata2)
       ||
       (NULL == metadata3)
       ||
       (NULL == metadata4)
       ||
       (NULL == metadataTitle))
    {
        ETG_TRACE_ERR(("Invalid parameter: metadata is NULL"));
        return MP_ERR_PM_INVALID_PARAM;
    }
    VARTRACE(handle);
    VARTRACE(metadata1);
    VARTRACE(metadata2);
    VARTRACE(metadata3);
    VARTRACE(metadata4);
    VARTRACE(metadataTitle);
    VARTRACE(mediaType);
    VARTRACE(bitRate);
    VARTRACE(sampleRate);
    VARTRACE(audioChannelFormat);
    VARTRACE(metadataConvertFlag);
    VARTRACE(uuid);
    VARTRACE(albumArtString);

    tResult ret = MP_NO_ERROR;

    tListID currentListID = LIST_ID_NONE;
    ret = GetListID(OUT currentListID);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Current listID is not valid -> Cannot update NowPlaying status"));
    }
    else
    {
        tListInfo listInfo;
        tBoolean withListSize = false;
        ret = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN currentListID, IN withListSize);
        /* Try to get device related information for media object */
        tDeviceInfo deviceInfo;
        ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN listInfo.deviceID);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while getting list info at ListControl -> Cannot update NowPlaying status (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            if(LocalSPM::GetDataProvider().FavoritesSupported())
            {
                VARTRACE(m_prevMediaObject);
                if(strncmp(m_prevMediaObject.UUID, uuid, sizeof(m_prevMediaObject.UUID)))
                {
                    tReturnValue isDeActivateReq = IsDeActivateAllFavoritesRequired(IN uuid, IN listInfo.deviceID, IN currentListID, IN listInfo.listSize);
                    VARTRACE(isDeActivateReq);
                    if(isDeActivateReq)
                    {
                        ret = LocalSPM::GetDBManager().DeActivateAllFavorites();
                        if( MP_NO_ERROR != ret )
                        {
                            ETG_TRACE_ERR(("Error while deactivating all favorites in DB (ErrorCode:%s)", errorString(ret)));
                        }
                    }
                }
            }

            tMediaObject currentMediaObject;
            InitMediaObject(OUT currentMediaObject);
            tBoolean mediaObjectAvailable = TRUE;
            if(LTY_CURRENT_SELECTION == listInfo.listType) //only for iPod current selection list
            {
                /* Position the iPod current selection */
                ret = LocalSPM::GetListControl().SetMediaObject(OUT currentMediaObject, IN currentListID, IN INDEX_LAST_ACTIVE_OBJECT);
                //ret = LocalSPM::GetListControl().GetCurrentMediaObject(OUT currentMediaObject, IN currentListID);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_USR1(("Cannot position the iPod current selection (ErrorCode:%s)", errorString(ret)));

                    /* Take media object from database as error handling */
                    ret = GetMediaObject(OUT currentMediaObject);
                    if( MP_NO_ERROR != ret )
                    {
                        ETG_TRACE_ERR(("Error while getting current media object -> Cannot update NowPlaying state"));
                        mediaObjectAvailable = FALSE;
                    }
                }
                else
                {

                    if( MP_NO_ERROR != ret )
                    {
                        ETG_TRACE_ERR(("Error while getting device info from DBManager (ErrorCode:%s)", errorString(ret)));
                    }
                    else
                    {
                        currentMediaObject.deviceID = deviceInfo.deviceID;
                        currentMediaObject.deviceType = deviceInfo.deviceType;
                        strncpy_r(OUT currentMediaObject.mountPoint, IN deviceInfo.mountPoint, IN sizeof(currentMediaObject.mountPoint));
                    }

                    /* Set current media object */
                    SetMediaObject(IN currentMediaObject);
                }
            }
            else
            {
                if(0 == strlen_r(metadataTitle)) //Metadata from DeviceControl not available
                {
                    mediaObjectAvailable = FALSE;
                }

                /* Take media object from database */
                ret = GetMediaObject(OUT currentMediaObject);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while getting current media object -> Cannot update NowPlaying status"));
                    mediaObjectAvailable = FALSE;
                }
                else
                {
                    /* Check if new handle is another one than current objectID */
                    if((HANDLE_NONE != handle)
                       &&
                       (handle != (tPEHandle)currentMediaObject.objectID))
                    {
                        /* Set and get current media object at ListControl */
                        ret = LocalSPM::GetListControl().SetCurrentMediaObject(IN currentListID, IN (tObjectID)handle);
                        if( MP_NO_ERROR != ret )
                        {
                            ETG_TRACE_ERR(("Error while setting current media object at ListControl (ErrorCode:%s)", errorString(ret)));
                        }
                        else if(DTY_BLUETOOTH != deviceInfo.deviceType) //The mediaobject might not be available in the (dynamic) now-playing list of bluetooth yet.
                        {
                            ret = LocalSPM::GetListControl().GetCurrentMediaObject(OUT currentMediaObject, IN currentListID);
                            if(MP_NO_ERROR != ret)
                            {
                                ETG_TRACE_ERR(("Error while getting current media object from ListControl (ErrorCode:%s)", errorString(ret)));
                            }
                        }
                    }
                }
            }

            if(mediaObjectAvailable)
            {
                //Overwrite title always because in case of playing from file list it is filled with filename inclusive extension
                strncpy_r(OUT currentMediaObject.title, IN metadataTitle, IN sizeof(currentMediaObject.title));

                if(0 < strlen_r(metadata1)) //Overwrite genre from DeviceControl
                {
                    strncpy_r(OUT currentMediaObject.MetadataField1, IN metadata1, IN sizeof(currentMediaObject.MetadataField1));
                }
                else
                {
                    strncpy_r(OUT currentMediaObject.MetadataField1, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(currentMediaObject.MetadataField1));
                }

                if(0 < strlen_r(metadata2)) //Overwrite artist from DeviceControl
                {
                    strncpy_r(OUT currentMediaObject.MetadataField2, IN metadata2, IN sizeof(currentMediaObject.MetadataField2));
                }
                else
                {
                    strncpy_r(OUT currentMediaObject.MetadataField2, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(currentMediaObject.MetadataField2));
                }

                if(0 < strlen_r(metadata3)) //Overwrite composer from DeviceControl
                {
                    strncpy_r(OUT currentMediaObject.MetadataField3, IN metadata3, IN sizeof(currentMediaObject.MetadataField3));
                }
                else
                {
                    strncpy_r(OUT currentMediaObject.MetadataField3, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(currentMediaObject.MetadataField3));
                }

                if(0 < strlen_r(metadata4)) //Overwrite album from DeviceControl
                {
                    strncpy_r(OUT currentMediaObject.MetadataField4, IN metadata4, IN sizeof(currentMediaObject.MetadataField4));
                }
                else
                {
                    strncpy_r(OUT currentMediaObject.MetadataField4, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(currentMediaObject.MetadataField4));
                }

                //NCG3D-245881: Albumart not present for video files
                if(CTY_VIDEO == currentMediaObject.catType)
                {
                    currentMediaObject.albumArtString[0] = '\0';
                }
                else
                {
                    /* Task 317554    Album art extraction from BT device � AVRCP1.6 */
                    if(0 < strlen_r(albumArtString)) //Overwrite albumArtString from DeviceControl
                    {
                        strncpy_r(OUT currentMediaObject.albumArtString, IN albumArtString, IN sizeof(currentMediaObject.albumArtString));
                    }
                }

                if(MTY_UNKNOWN != mediaType)
                {
                    currentMediaObject.mediaType = mediaType;
                    currentMediaObject.catType = LocalSPM::GetDBManager().GetCTYByMTY(mediaType);
                }
                else
                {
                    /* Reorder metadata because it is filled like MTY_MUSIC_FILE (GMMY17-4835) */
                    if(MTY_AUDIOBOOK == currentMediaObject.mediaType)
                    {
                        strncpy_r(OUT currentMediaObject.MetadataField1, IN currentMediaObject.MetadataField2, sizeof(currentMediaObject.MetadataField1));
                        strncpy_r(OUT currentMediaObject.MetadataField2, IN currentMediaObject.MetadataField4, sizeof(currentMediaObject.MetadataField2));
                        strncpy_r(OUT currentMediaObject.MetadataField3, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(currentMediaObject.MetadataField3));
                        strncpy_r(OUT currentMediaObject.MetadataField4, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(currentMediaObject.MetadataField4));
                    }
                    else if(MTY_PODCAST == currentMediaObject.mediaType)
                    {
                        strncpy_r(OUT currentMediaObject.MetadataField1, IN currentMediaObject.MetadataField4, sizeof(currentMediaObject.MetadataField1));
                        strncpy_r(OUT currentMediaObject.MetadataField2, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(currentMediaObject.MetadataField2));
                        strncpy_r(OUT currentMediaObject.MetadataField3, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(currentMediaObject.MetadataField3));
                        strncpy_r(OUT currentMediaObject.MetadataField4, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(currentMediaObject.MetadataField4));
                    }
                }

                currentMediaObject.metadataConvertFlag = metadataConvertFlag;
                currentMediaObject.bitRate = bitRate;
                currentMediaObject.sampleRate = sampleRate;
                currentMediaObject.audioChannelFormat = audioChannelFormat;

                /* fill all ID's from DB or Livetags table */
                LocalSPM::GetDBManager().FillupMetaDataIDs(INOUT currentMediaObject);


                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while getting device info from DBManager (ErrorCode:%s)", errorString(ret)));
                }
                else
                {
                    if(DTY_BLUETOOTH == deviceInfo.deviceType)
                    {
                        currentMediaObject.objectID =  (tObjectID)handle;
                    }
                }
                /* Change metadata of current media object */
                SetMediaObject(IN currentMediaObject);
            }

            /* Set internal player manager member NowPlayingState to new value */
            ret = SetNowPlayingState(NP_NEW_TRACK);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while setting NowPlaying state"));
            }
        }
    }

    return ret;
}

tResult PlayerManager::ForwardPlaybackModeStatus(const tDeviceID deviceID, const tPlaybackMode playbackMode)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::ForwardPlaybackModeStatus deviceID:%u, playbackMode:%u", deviceID, playbackMode));

    tResult ret = MP_NO_ERROR;

    /* Set playback mode in ListControl */
    ret = LocalSPM::GetListControl().SetPlaybackMode(IN deviceID, IN playbackMode);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while setting playback mode at ListControl (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult PlayerManager::ForwardRepeatModeStatus(const tDeviceID deviceID, tRepeatMode repeatMode)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::ForwardPlaybackModeStatus deviceID:%u, repeatMode:%u", deviceID, repeatMode));

    tResult ret = MP_NO_ERROR;

    /* Set repeat mode in ListControl */
    ret = LocalSPM::GetListControl().SetRepeatMode(IN deviceID, IN repeatMode);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while setting playback mode at ListControl (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult PlayerManager::ForwardAlbumArtStatus(const tPEHandle handle, const tAvailable available)
{
    ENTRY;
    VARTRACE(handle);
    VARTRACE(available);

    tResult ret = MP_NO_ERROR;
    tBoolean update = true;

    /* Get current streaming mode */
    tStreamingMode currentStreamingMode = SM_OFF;
    GetStreamingMode(OUT currentStreamingMode);

    if( SM_OFF == currentStreamingMode )
    {
        /* Check handle if it fits to current objectID */
        tMediaObject currentMediaObject;
        ret = GetMediaObject(OUT currentMediaObject);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while getting current media object -> Cannot check handle"));
        }
        else
        {
            if(handle != (tPEHandle)currentMediaObject.objectID)
            {
                update = false;
                ETG_TRACE_ERR(("Handle does not fit -> Do not update AlbumArtAvailability status"));
            }
        }
    }

    /* Set internal player manager member AlbumArtAvailability to new value */
    if(update)
    {
        ret = SetAlbumArtAvailability(IN available, IN update);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while setting AlbumArtAvailability"));
        }
    }

    return ret;
}

tResult PlayerManager::RemoteActivity(const tDeviceID deviceID)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::RemoteActivity deviceID:%u", deviceID));

    tResult ret = MP_NO_ERROR;

    /* Get current list type */
    tListID currentListID = LIST_ID_NONE;
    tListType currentListType = LTY_SONG;
    tPath currentListPath = "" ;
    ret = GetListID(OUT currentListID);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Current listID is not valid"));
    }
    else
    {
        tListInfo listInfo;
        tBoolean withListSize = false;
        ret = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN currentListID, IN withListSize);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while getting list info at ListControl (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            currentListType = listInfo.listType;
            strncpy_r(OUT currentListPath , IN listInfo.path, IN sizeof(currentListPath));
        }
    }

    /* Get current streaming mode */
    tStreamingMode currentStreamingMode = SM_OFF;
    GetStreamingMode(OUT currentStreamingMode);

    /* Get current active device ID */
    tDeviceID currentDeviceID = DEVICE_ID_NOT_SET;
    ret = LocalSPM::GetDBManager().GetActiveDevice(OUT currentDeviceID);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while getting active device from DBManager (ErrorCode:%s)", errorString(ret)));
    }

    /* Check if switching to streaming mode is configured if a remote activity in a not active device is recognized */
    if( false == LocalSPM::GetDataProvider().iPodRemoteEventHandleInactiveDevice() )
    {
        currentDeviceID = deviceID;
    }

    /* Set active streaming device and create a streaming list */
    /*   if(((LTY_CURRENT_SELECTION != currentListType) && (!((LTY_BLUETOOTH_FILELIST == currentListType) && (!(strncmp(((const char*)(currentListPath)),"now-playing",sizeof(currentListPath)))))))
       ||
       (SM_OFF == currentStreamingMode)
       ||
       (deviceID != currentDeviceID))*/
    //If the list is now-playing for LTY_BLUETOOTH_FILELIST the remote activity is to be continued.
    if((LTY_CURRENT_SELECTION != currentListType)
            ||
            (SM_OFF == currentStreamingMode)
            ||
            (deviceID != currentDeviceID))
    {
#if 0
        ret = LocalSPM::GetCustomControl().SetActiveStreamingDevice(IN deviceID);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while setting active streaming device at CustomControl (ErrorCode:%s)", errorString(ret)));
        }
#else
        /* Send SET_ACTIVE_STREAMING_DEVICE message to CustomControlSM */
        char msgToSendString[64];
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        strncpy_r(OUT msgToSendString, IN "CustomControlSM::SET_ACTIVE_STREAMING_DEVICE", IN sizeof(msgToSendString));

        ret = LocalSPM::GetCustomControl().ParameterSET_ACTIVE_STREAMING_DEVICE(OUT parameterString, IN size, IN deviceID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = Dispatcher::GetInstance().SendMessage(IN msgToSendString, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
#endif
    }
    else
    {
        /* Position the iPod current selection */
        if(LIST_ID_NONE != currentListID)
        {
            tMediaObject mediaObject;
            ret = LocalSPM::GetListControl().SetMediaObject(OUT mediaObject, IN currentListID, IN INDEX_LAST_ACTIVE_OBJECT);
            //ret = LocalSPM::GetListControl().GetCurrentMediaObject(OUT mediaObject, IN currentListID);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_USR1(("Cannot position the iPod current selection (ErrorCode:%s)", errorString(ret)));
            }

            if( (DTY_UNKNOWN == mediaObject.deviceType)
                ||
                (DEVICE_ID_NOT_SET == mediaObject.deviceID)
                ||
                (0 == strlen_r(mediaObject.mountPoint)) )
            {
                /* Try to get device related information for media object */
                tDeviceInfo deviceInfo;
                ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while getting device info from DBManager -> Cannot send streaming mode on to device control (ErrorCode:%s)", errorString(ret)));
                }
                else
                {
                    mediaObject.deviceType = deviceInfo.deviceType;
                    mediaObject.deviceID = deviceInfo.deviceID;
                    strncpy_r(OUT mediaObject.mountPoint, IN deviceInfo.mountPoint, IN sizeof(mediaObject.mountPoint));
                }
            }

            if( MP_NO_ERROR == ret )
            {
                /* Send STREAMING_MODE_ON message to specific DeviceControlSM */
                char msgToSendString[64];
                tAllParameters parameterString;
                size_t size = sizeof(parameterString);

                strncpy_r(OUT msgToSendString, IN "STREAMING_MODE_ON", IN sizeof(msgToSendString));

                ret = LocalSPM::GetUSBControl().ParameterSTREAMING_MODE_ON(OUT parameterString,
                    IN size,
                    IN mediaObject.deviceType,
                    IN mediaObject.deviceID,
                    IN mediaObject.mountPoint);

                if (MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                    parameterString[0] = '\0';
                }

                ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mediaObject.deviceType, IN msgToSendString, IN parameterString);
                if (MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
                }
            }

            m_StartTime = PLAYTIME_NONE;
        }
    }

    return ret;
}

tResult PlayerManager::StreamingModeOn()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::StreamingModeOn"));

#if 0
    tResult ret = MP_NO_ERROR;

    /* Get current active device ID */
    tDeviceID currentDeviceID = DEVICE_ID_NOT_SET;
    ret = LocalSPM::GetDBManager().GetActiveDevice(OUT currentDeviceID);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while getting active device from DBManager -> Cannot send streaming mode ON (ErrorCode:%s)", errorString(ret)));
    }
    else
    {
        tDeviceInfo deviceInfo;
        ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN currentDeviceID);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while getting device info from DBManager -> Cannot send streaming mode ON (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            if( MY_MEDIA != currentDeviceID )
            {
                /* Send STREAMING_MODE_ON message to specific DeviceControlSM */
                char msgToSendString[64];
                tAllParameters parameterString;
                size_t size = sizeof(parameterString);

                strncpy_r(OUT msgToSendString, IN "STREAMING_MODE_ON", IN sizeof(msgToSendString));

                ret = LocalSPM::GetUSBControl().ParameterSTREAMING_MODE_ON(OUT parameterString,
                    IN size,
                    IN deviceInfo.deviceType,
                    IN currentDeviceID,
                    IN deviceInfo.mountPoint);

                if (MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                    parameterString[0] = '\0';
                }

                ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN deviceInfo.deviceType, IN msgToSendString, IN parameterString);
                if (MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
                }
            }
        }
    }
#endif

    return SetStreamingMode(SM_ON);
}

tResult PlayerManager::StreamingModeOff()
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::StreamingModeOff"));

    tResult ret = MP_NO_ERROR;

    if(!LocalSPM::GetDataProvider().RepeatModeAdjustable())
    {
        /* Reset repeat mode to default in ListControl */
        ret = LocalSPM::GetListControl().SetRepeatMode(IN (tRepeatMode)LocalSPM::GetDataProvider().DBDefaultRepeatMode());
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while setting playback mode at ListControl (ErrorCode:%s)", errorString(ret)));
        }
    }

    return SetStreamingMode(SM_OFF);
}

tResult PlayerManager::HandleStreamError(const me::reason_e reason)
{
    ENTRY
    //ETG_TRACE_USR3(("PlayerManager::HandleStreamError reason:%u", reason));
    VARTRACE(reason);

    tResult ret = MP_NO_ERROR;

    tFileErrorHandling fileErrorHandling = (tFileErrorHandling)LocalSPM::GetDataProvider().FileErrorHandling();
    if((FEH_MARK_OBJECT == fileErrorHandling)
       ||
       (FEH_MARK_OBJECT_PERMANENT == fileErrorHandling)
       ||
       (FEH_DELETE_OBJECT == fileErrorHandling))
    {
        tMediaObject currentMediaObject;
        ret = GetMediaObject(OUT currentMediaObject);
        if((MP_NO_ERROR != ret)
           ||
           (OBJECT_ID_NONE == currentMediaObject.objectID))
        {
            ETG_TRACE_ERR(("Error while getting current media object -> Cannot mark/remove old media object"));
        }
        else
        {
            if ((FEH_MARK_OBJECT == fileErrorHandling)
                ||
                (FEH_MARK_OBJECT_PERMANENT == fileErrorHandling))
            {
                /* Get indexing priority from DataProvider */
                tPriority priority = PRIORITY_NONE;
                ret = LocalSPM::GetDataProvider().GetIndexingPriority(OUT priority, IN currentMediaObject.deviceType);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while getting indexing priority from DataProvider (ErrorCode:%s)", errorString(ret)));
                }
                else
                {
                    if(PRIORITY_NONE != priority)
                    {
                        /* Mark old media object as not playable in DB */
                        switch(reason)
                        {
                            case REASON_DRM_ERROR:        currentMediaObject.notPlayable = FNP_DRM_PROTECTED; break;
                            case REASON_FORMAT_ERROR:     currentMediaObject.notPlayable = FNP_FORMAT_ERROR; break;
                            case REASON_FATAL_READ_ERROR: currentMediaObject.notPlayable = FNP_READ_ERROR; break;
                            case REASON_URL_ERROR:        currentMediaObject.notPlayable = FNP_NOT_PLAYABLE; break;
                            default:                     currentMediaObject.notPlayable = FNP_PLAYABLE; break;
                        }

                        if(FNP_PLAYABLE != currentMediaObject.notPlayable)
                        {
                            ret = LocalSPM::GetDBManager().UpdateMediaObject(IN currentMediaObject);
                            if( MP_NO_ERROR != ret )
                            {
                                ETG_TRACE_ERR(("Error while updating media object at DBManager (ErrorCode:%s)", errorString(ret)));
                            }

                            ret = LocalSPM::GetDBManager().UpdateLiveTagsElement(IN currentMediaObject.objectID, IN currentMediaObject.notPlayable);
                            if( MP_NO_ERROR != ret )
                            {
                                ETG_TRACE_ERR(("Error while updating live tag element at DBManager (ErrorCode:%s)", errorString(ret)));
                            }

                            /* Store mediaObject internally */
                            SetMediaObject(IN currentMediaObject);

                            /* Set internal player manager member NowPlayingState to new value */
                            ret = SetNowPlayingState(NP_NEW_TRACK);
                            if(MP_NO_ERROR != ret)
                            {
                                ETG_TRACE_ERR(("Error while setting NowPlaying state"));
                            }
                        }
                    }
                    else
                    {
                        ETG_TRACE_USR1(("Cannot mark media object as not playable because indexing of device type is not supported"));
                    }
                }
            }
            else if(FEH_DELETE_OBJECT == fileErrorHandling)
            {
                if((REASON_URL_ERROR == reason)
                   ||
                   (REASON_FORMAT_ERROR == reason)
                   ||
                   (REASON_DRM_ERROR == reason)
                   ||
                   (REASON_FATAL_READ_ERROR == reason))
                {
                    /* Remove old media object entries in the database */
                    ret = LocalSPM::GetDBManager().RemoveMediaObject(IN currentMediaObject.objectID);
                    if( MP_NO_ERROR != ret )
                    {
                        ETG_TRACE_ERR(("Error while removing media object at ListControl (ErrorCode:%s)", errorString(ret)));
                    }
                }
            }
        }
    }

    /* Reset buffer index */
    SetBufferIndex(POSITION_NOT_SET);

    /* Do we play from a MyMedia list? */
    tListID currentListID = LIST_ID_NONE;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tDeviceConnected connected = true;

    ret = GetListID(OUT currentListID);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Current listID is not valid"));
    }
    else
    {
        tListInfo listInfo;
        tBoolean withListSize = false;
        ret = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN currentListID, IN withListSize);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while getting list info at ListControl (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            deviceID = listInfo.deviceID;

           /* Try to get device connection state */
           tDeviceInfo deviceInfo;
           ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
           if( MP_NO_ERROR != ret )
           {
               ETG_TRACE_ERR(("Error while getting device info from DBManager (ErrorCode:%s)", errorString(ret)));
           }
           else
           {
               connected = deviceInfo.connected;
           }
        }
    }

    if(REASON_UNDERVOLTAGE_ERROR == reason) //Undervoltage
    {
        /* Send PAUSE message to own SM */
        ret = SendPlaybackAction(PBA_PAUSE);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while calling SendPlaybackAction"));
        }
    }
    else if((connected) //Device is still connected
            &&
            ((REASON_DEVICE_ERROR != reason) //File error
             ||
             (MY_MEDIA == deviceID)))
    {
        tMediaObject currentMediaObject;
        ret = GetMediaObject(OUT currentMediaObject);
        if((MP_NO_ERROR != ret)
           ||
           (OBJECT_ID_NONE == currentMediaObject.objectID))
        {
            ETG_TRACE_ERR(("Error while getting current media object -> Cannot check if it is the first object of error handling"));
            currentMediaObject.objectID = OBJECT_ID_NONE;
        }

        if( OBJECT_ID_NONE == currentMediaObject.objectID )
        {
            ret = MP_NO_ERROR; //Nothing to do
        }
        else if( currentMediaObject.objectID == m_FirstErrorObjectID )
        {
            /* Reach first element of list which causes an error again -> stop next processing loop */
            ret = SendNoObject(NOR_NO_OBJECT);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending NoObject"));
            }
        }
        else if( PBA_PREV == m_LastAction )
        {
            /* Send PREV message to own SM */
            ret = SendHMIPrevious();
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while calling SendHMIPrevious"));
            }
        }
        else
        {
            /* Send NEXT message to own SM */
            ret = SendHMINext();
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while calling SendHMINext"));
            }
        }

        /* Store first element of list which causes an error */
        if((OBJECT_ID_NONE == m_FirstErrorObjectID)
           &&
           (OBJECT_ID_NONE != currentMediaObject.objectID))
        {
            m_FirstErrorObjectID = currentMediaObject.objectID;
//Suzuki CRQ 296694 and Bug 265009
            if (LocalSPM::GetDataProvider().FirstItemFromShuffleList()) {
                tPosition currrentListPosition = POSITION_NOT_SET;
                tPosition shuffleListPosition = POSITION_NOT_SET;
                ret = LocalSPM::GetListControl().GetPositionInList(currrentListPosition, currentListID,
                        m_FirstErrorObjectID);
                if (!ret) {
                    tPlaybackMode playbackMode;
                    LocalSPM::GetListControl().GetPlaybackMode(playbackMode);
                    if (!ret) {
                        if (PBM_RANDOM == playbackMode) {
                            ret = LocalSPM::GetListControl().GetPositionFromShuffleList(currentListID,
                                    currrentListPosition, shuffleListPosition);
                            if (!ret) {
                                m_firstErrorObjectPosition = shuffleListPosition;
                            }
                            else {
                                ETG_TRACE_ERR(
                                        ("Error while getting position from shuffle list (ErrorCode:%s)", errorString(ret)));
                            }
                        }
                        else {
                            m_firstErrorObjectPosition = currrentListPosition;
                        }
                    }
                }
            }
        }
    }
    else //Device error
    {
        ret = SendNoObject(NOR_DEVICE_REMOVED);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending NoObject"));
        }
    }
    if((REASON_BUFFER_UNAVAILABLE == reason) || (REASON_BUFFER_AVAILABLE == reason))
    {
        ret = SendNoResponseEvent(reason);
    }
    return ret;
}

tResult PlayerManager::HandleStreamErrorStreaming(const me::reason_e reason)
{
    ENTRY
    //ETG_TRACE_USR3(("PlayerManager::HandleStreamErrorStreaming reason:%u", reason));
    VARTRACE(reason);

    tResult ret = MP_NO_ERROR;

    if(m_FirstErrorTimerID != 0) //first restart of streaming is less than 10s ago (prevent endless loop)
    {
        /* Send NO_OBJECT message to own SM */
        ret = SendNoObject(NOR_LIST_IS_NOT_PLAYABLE);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending NoObject"));
        }
    }
    else
    {
        /* Restart of streaming */
        ret = SendStart();
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while calling SendStart"));
        }

        m_FirstErrorTimer.StartTimer(OUT m_FirstErrorTimerID,
                   IN LocalSPM::GetDataProvider().FirstErrorTimeMS(),
                   IN 0L,
                   IN &LocalSPM::GetPlayerManager(),
                   IN &FirstErrorTimerCallback,
                   IN NULL);
    }

    return ret;
}

bool PlayerManager::FirstErrorTimerCallback(timer_t timerID , void* instance ,const void *userData)
{
    ENTRY
    (void)userData;

    if(NULL == instance)
    {
        ETG_TRACE_ERR(("Invalid parameter: instance is NULL"));
    }
    else
    {
        ETG_TRACE_USR3(("PlayerManager::FirstErrorTimerCallback timerID:0x%X, instance:0x%X", (int)((long)timerID), instance));

        PlayerManager *self = (PlayerManager*)instance;
        self->m_FirstErrorTimerID = 0;
    }

    return false;
}

tResult PlayerManager::HandleActionError(const me::reason_e reason)
{
    ENTRY
    //ETG_TRACE_USR3(("PlayerManager::HandleActionError reason:%u", reason));
    VARTRACE(reason);

    tResult ret = MP_NO_ERROR;

    /* Clear release event and disarm timer of own state machine in case of still waiting */
    ret = ClearReleaseEvent();
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while clearing release event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    HandleStreamError(IN reason);

    /* Update PlaybackState derived from internal SM state */
    ret = UpdatePlaybackState(PE_PBS_STOPPEDSTATE);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while updating PlaybackState"));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult PlayerManager::RestoreAllocateState(const tAllocateState allocateState, const tAudioOutputDevice audioOutputDevice)
{
    ENTRY

    if(NULL == audioOutputDevice)
    {
        ETG_TRACE_ERR(("Invalid parameter: audioOutputDevice is NULL"));
        return MP_ERR_PM_INVALID_PARAM;
    }
    ETG_TRACE_USR3(("PlayerManager::RestoreAllocateState allocateState:%u, audioOutputDevice:%s", allocateState, audioOutputDevice));

    tResult ret = MP_NO_ERROR;

    /* Get current allocate state */
    tAllocateState currentAllocateState;
    tAudioOutputDevice currentAudioOutputDevice;
    ret = GetAllocateState(OUT currentAllocateState, OUT currentAudioOutputDevice);//CID 10400
    if(ret)
    {
        ETG_TRACE_ERR(("GetAllocateState returned error: %d", ret));
    }
    /* Decide what to do */
    tBoolean allocate = false;
    tBoolean deallocate = false;
    tBoolean activityOn = false;
    tBoolean activityOff = false;
    if(ALS_DEALLOCATED == currentAllocateState)
    {
        if((ALS_ALLOCATED == allocateState) || (ALS_ACTIVE == allocateState)) allocate = true;
        if(ALS_ACTIVE == allocateState) activityOn = true;
    }
    else if(ALS_ALLOCATED == currentAllocateState)
    {
        if(ALS_ACTIVE == allocateState) activityOn = true;
        if(ALS_DEALLOCATED == allocateState) deallocate = true;
    }
    else if(ALS_ACTIVE == currentAllocateState)
    {
        if((ALS_ALLOCATED == allocateState) || (ALS_DEALLOCATED == allocateState)) activityOff = true;
        if(ALS_DEALLOCATED == allocateState) deallocate = true;
    }

    /* Send related events to trigger requested allocate state again (Attention: order of events is important) */
    if(allocate)
    {
        ret = SendAllocate(IN audioOutputDevice);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while calling SendAllocate"));
        }
    }

    if(activityOn)
    {
        ret = SendSourceActivity(IN SA_ON);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while calling SendSourceActivity"));
        }
    }

    if(activityOff)
    {
        ret = SendSourceActivity(IN SA_OFF);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while calling SendSourceActivity"));
        }
    }

    if(deallocate)
    {
        ret = SendDeAllocate();
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while calling SendAllocate"));
        }
    }

    return ret;
}

tResult PlayerManager::SetAllocateState(const tAllocateState allocateState)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SetAllocateState allocateState:%u", allocateState));

    m_Mutex.lock();
    m_AllocateState = allocateState;
    m_Mutex.unlock();

    return MP_NO_ERROR;
}

tResult PlayerManager::GetAllocateState(tAllocateState &allocateState, tAudioOutputDevice &audioOutputDevice)
{
    ENTRY

    m_Mutex.lock();
    allocateState = m_AllocateState;
    strncpy_r(OUT audioOutputDevice, IN m_AudioOutputDevice, IN sizeof(audioOutputDevice));
    m_Mutex.unlock();

    ETG_TRACE_USR3(("PlayerManager::GetAllocateState allocateState:%u, audioOutputDevice:%s", allocateState, audioOutputDevice));
    return MP_NO_ERROR;
}

tResult PlayerManager::GetActiveState(tBoolean &isActive)
{
    ENTRY

    m_Mutex.lock();
    if(ALS_ACTIVE == m_AllocateState)
    {
        isActive = TRUE;
    }
    else
    {
        isActive = FALSE;
    }
    m_Mutex.unlock();

    ETG_TRACE_USR3(("PlayerManager::GetActiveState isActive:%u", isActive));
    return MP_NO_ERROR;
}

tResult PlayerManager::SetStreamingMode(const tStreamingMode newStreamingMode)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SetStreamingMode streamingMode:%u", newStreamingMode));

    m_Mutex.lock();
    m_StreamingMode = newStreamingMode;
    m_Mutex.unlock();

    return MP_NO_ERROR;
}

tResult PlayerManager::GetStreamingMode(tStreamingMode &currentStreamingMode)
{
    ENTRY

    m_Mutex.lock();
    currentStreamingMode = m_StreamingMode;
    m_Mutex.unlock();

    ETG_TRACE_USR3(("PlayerManager::GetStreamingMode streamingMode:%u", currentStreamingMode));
    return MP_NO_ERROR;
}

tResult PlayerManager::SetListID(const tListID listID)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SetListID listID:%u", listID));

    m_Mutex.lock();
    m_ListID = listID;
    m_Mutex.unlock();

    return MP_NO_ERROR;
}

tResult PlayerManager::GetListID(tListID &listID)
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();
    listID = m_ListID;
    m_Mutex.unlock();

    if(LIST_ID_NONE == listID)
    {
        ret = MP_ERR_PM_NO_LIST_ID;
    }

    ETG_TRACE_USR3(("PlayerManager::GetListID listID:%u", listID));
    return ret;
}

tResult PlayerManager::SetMediaObject(const tMediaObject mediaObject)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SetMediaObject mediaObjectID:%u,UUID:%s", mediaObject.objectID,mediaObject.UUID));

    m_Mutex.lock();
    m_prevMediaObject = m_MediaObject;
    m_MediaObject = mediaObject;
    m_Mutex.unlock();

    return MP_NO_ERROR;
}

tResult PlayerManager::GetMediaObject(tMediaObject &mediaObject)
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();
    mediaObject = m_MediaObject;
    m_Mutex.unlock();

    if(OBJECT_ID_NONE == mediaObject.objectID)
    {
        ret = MP_ERR_PM_NO_MEDIA_OBJECT;
    }

    ETG_TRACE_USR3(("PlayerManager::GetMediaObject mediaObjectID:%u", mediaObject.objectID));
    return ret;
}

tResult PlayerManager::GetDevicePartOfMediaObject(tMediaObject &mediaObject)
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    /* Try to get device related information for media object via listID -> listInfo -> deviceInfo */
    tListID currentListID = LIST_ID_NONE;
    ret = GetListID(OUT currentListID);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Current listID is not valid -> Cannot deliver device part of media object"));
    }
    else
    {
        tListInfo listInfo;
        tBoolean withListSize = false;
        ret = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN currentListID, IN withListSize);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while getting list info at ListControl -> Cannot deliver device part of media object (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            tDeviceInfo deviceInfo;
            ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN listInfo.deviceID);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while getting device info from DBManager -> Cannot deliver device part of media object (ErrorCode:%s)", errorString(ret)));
            }
            else
            {
                mediaObject.deviceType = deviceInfo.deviceType;
                mediaObject.deviceID = deviceInfo.deviceID;
                strncpy_r(OUT mediaObject.mountPoint, IN deviceInfo.mountPoint, IN sizeof(mediaObject.mountPoint));

                ETG_TRACE_USR3(("PlayerManager::GetDevicePartOfMediaObject deviceType:%u, deviceID:%u, mountPoint:%s", deviceInfo.deviceType, deviceInfo.deviceID, deviceInfo.mountPoint));
            }
        }
    }

    return ret;
}

tResult PlayerManager::SetBufferIndex(tPosition bufferIndex)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SetBufferIndex bufferIndex:%u", bufferIndex));

    m_Mutex.lock();
    m_BufferIndex = bufferIndex;
    m_Mutex.unlock();

    return MP_NO_ERROR;
}

tResult PlayerManager::GetBufferIndex(tPosition &bufferIndex)
{
    ENTRY

    m_Mutex.lock();
    bufferIndex = m_BufferIndex;
    m_Mutex.unlock();

    ETG_TRACE_USR3(("PlayerManager::GetBufferIndex bufferIndex:%u", bufferIndex));
    return MP_NO_ERROR;
}

tResult PlayerManager::AutoRegisterOnDBTrigger(const tTriggerState autoRegister)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::AutoRegisterOnDBTrigger autoRegister: %u", autoRegister));

    m_AutoRegisterOnDBTrigger = autoRegister;

    return MP_NO_ERROR;
}

tResult PlayerManager::SwitchDBTrigger(const tTriggerType trigger, const tTriggerState requestedState)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SwitchDBTrigger trigger:%u, requestedState: %u", trigger, requestedState));

    tResult ret = MP_NO_ERROR;

    if(TS_ON == requestedState)
    {
        /* Register on DB trigger */
        if((TT_DB_DEVICE_REMOVED == trigger)
           ||
           (TT_ALL == trigger))
        {
            if(0 == m_TriggerID_DevRemoved)
            {
                //Roadmap 13035_Overtemperature: ConnectionState 2=CS_DISCONNECTED, 6=CS_OVERTEMP, 7=CS_ON_HOLD
                ret = LocalSPM::GetDBManager().OnUpdateTrigger(OUT m_TriggerID_DevRemoved,
                    IN PlayerManagerSM::GetSMNameFull(),
                    IN "DB_DEVICE_REMOVED",
                    IN "Devices",
                    IN "ConnectionState",
                    IN "WHEN OLD.ConnectionState<>2 AND OLD.ConnectionState<>6 AND OLD.ConnectionState<>7 AND (NEW.ConnectionState=2 OR NEW.ConnectionState=6 OR NEW.ConnectionState=7)",
                    IN "COUNT()",
                    IN "SELECT ID FROM Devices WHERE ROWID=OLD.ROWID");
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while registering DB trigger (ErrorCode:%s)", errorString(ret)));
                }
            }
        }
    }
    else
    {
        /* Deregister on DB trigger */
        if((TT_DB_DEVICE_REMOVED == trigger)
           ||
           (TT_ALL == trigger))
        {
            if(m_TriggerID_DevRemoved)
            {
                ret = LocalSPM::GetDBManager().UnregisterTrigger(IN m_TriggerID_DevRemoved);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while unregistering DB trigger (ErrorCode:%s)", errorString(ret)));
                }
                m_TriggerID_DevRemoved = 0;
            }
        }
    }

    return ret;
}

tResult PlayerManager::IsFFwdFRevSimulationEnabled()
{
    ENTRY

    tResult enable = 0x00;

    if(LocalSPM::GetDataProvider().FFwdFRevSimulationRate() > 0)
    {
        tResult ret = MP_NO_ERROR;
        tListID currentListID = LIST_ID_NONE;
        ret = GetListID(OUT currentListID);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_USR3(("IsFFwdFRevSimulationEnabled : No Valid list set"));
        }
        else
        {
            tMediaObject mediaObject;
            mediaObject.objectID = OBJECT_ID_NONE;
            ret = LocalSPM::GetListControl().GetCurrentMediaObject(OUT mediaObject, IN currentListID);
            if((MP_NO_ERROR != ret)
               ||
               (OBJECT_ID_NONE == mediaObject.objectID))
            {
                ETG_TRACE_ERR(("IsFFwdFRevSimulationEnabled : No Valid Mediaobject set"));
            }
            else
            {
                enable = 0x01;
            }
        }
    }

    return enable;
}

tResult PlayerManager::FastForwardSimulationStart()
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    tCueingRate srate1, srate2;
    srate1 = (tCueingRate)LocalSPM::GetDataProvider().FFwdFRevTimeInterval();
    srate2 = (tCueingRate)LocalSPM::GetDataProvider().FFwdFRevSimulationRate();
    tCueingRate simulationRate = (tCueingRate)srate1 * (tCueingRate)srate2;
    tPlaytime elapsedPlaytime = m_StartTime;
    tPlaytime totalPlaytime = 0;

    /* Get current media object data from ListControl */
    tMediaObject mediaObject;
    mediaObject.objectID = OBJECT_ID_NONE;
    tListID currentListID = LIST_ID_NONE;
    ret = GetListID(OUT currentListID);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Current listID is not valid"));
    }
    else
    {
        ret = LocalSPM::GetListControl().GetCurrentMediaObject(OUT mediaObject, IN currentListID);
        if((MP_NO_ERROR != ret)
           ||
           (OBJECT_ID_NONE == mediaObject.objectID))
        {
            ETG_TRACE_ERR(("Error while getting current media object from ListControl (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            totalPlaytime = mediaObject.totalPlaytime;
        }
    }

    /*if total playtime is not available for the current mediaobect ,
     * fetch it from the respective device control*/
    if(totalPlaytime == 0)
    {
        ETG_TRACE_USR3(("FastForwardSimulationStart : Request total play time from the device control"));
        //LocalSPM::GetDeviceDispatcher().GetTotalPlayTime(OUT totalPlaytime, )
    }

    if(totalPlaytime > (elapsedPlaytime + simulationRate))
    {
        /* Set internal player manager member Playtime to new value */
        SetPlaytime(IN elapsedPlaytime + simulationRate, IN totalPlaytime, IN true /*validLastMode*/,IN mediaObject.objectID);

        /* Create FastForwardSimulation timer */
        m_FFwdFRevProgressTimer.StartTimer(OUT m_FFwdFRevProgressTimerID,
                    IN LocalSPM::GetDataProvider().FFwdFRevTimeInterval(),
                    IN LocalSPM::GetDataProvider().FFwdFRevTimeInterval(),
                    IN &LocalSPM::GetPlayerManager(),
                    IN &FFwdFRevProgressTimerCallBack,
                    IN NULL);

        /* Update PlaybackState derived from internal SM state */
        ret = UpdatePlaybackState(PE_PBS_FASTFORWARDSTATE);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while updating PlaybackState"));
        }
    }
    else
    {
        /* Send FFWD_STOP message to own SM to cancel the FFWD*/
        ETG_TRACE_USR3(("FastForwardSimulationStart : Abort fast forward simulation as elapsed time is not in the boundary"));
        ret = SendEvent(FFWD_STOP, (char *)NULL);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return MP_NO_ERROR;
}

tResult PlayerManager::FastForwardSimulationStop()
{
    ENTRY

    if(m_FFwdFRevProgressTimerID != 0)
    {
        tResult ret = MP_NO_ERROR;
        m_FFwdFRevProgressTimer.CancelTimer(m_FFwdFRevProgressTimerID);
        m_FFwdFRevProgressTimerID = 0;

        /* Save the simulated elapsed time for next playback resume when PlayerManager is active */
        StoreLastPlayedList();

        /* Set start playtime */
        tPlaytime elapsedPlaytime = PLAYTIME_NONE;
        ret = GetLastModePlaytime(OUT elapsedPlaytime);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while getting current playtime -> Cannot set start position"));
        }
        else
        {
            if(PLAYTIME_NONE != elapsedPlaytime) //Playtime is not reset
            {
                m_StartTime = elapsedPlaytime;
            }
        }
    }

    return MP_NO_ERROR;
}

tResult PlayerManager::FastReverseSimulationStart()
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    tCueingRate srate1, srate2;
    srate1 = (tCueingRate)LocalSPM::GetDataProvider().FFwdFRevTimeInterval();
    srate2 = (tCueingRate)LocalSPM::GetDataProvider().FFwdFRevSimulationRate();
    tCueingRate simulationRate = (tCueingRate)srate1 * (tCueingRate)srate2;
    tPlaytime elapsedPlaytime = m_StartTime;
    tPlaytime totalPlaytime = 0;

    /* Get current media object data from ListControl */
    tMediaObject mediaObject;
    tListID currentListID = LIST_ID_NONE;
    ret = GetListID(OUT currentListID);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Current listID is not valid"));
    }
    else
    {
        mediaObject.objectID = OBJECT_ID_NONE;
        ret = LocalSPM::GetListControl().GetCurrentMediaObject(OUT mediaObject, IN currentListID);
        if((MP_NO_ERROR != ret)
           ||
           (OBJECT_ID_NONE == mediaObject.objectID))
        {
            ETG_TRACE_ERR(("Error while getting current media object from ListControl (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            totalPlaytime = mediaObject.totalPlaytime;
        }
    }

    /*if total playtime is not available for the current mediaobect ,
     * fetch it from the respective device control*/
    if(totalPlaytime == 0)
    {
        ETG_TRACE_USR3(("FastForwardSimulationStart : Request total play time from the device control"));
        //LocalSPM::GetDeviceDispatcher().GetTotalPlayTime(OUT totalPlaytime, )
    }
    if(elapsedPlaytime == 0)
    {
        ETG_TRACE_USR3(("FastForwardSimulationStart : Get elapsed time from the lastmode"));
        //elapsedPlaytime = m_StartTime;
    }

    if(elapsedPlaytime > simulationRate)
    {
        /* Set internal player manager member Playtime to new value */
        SetPlaytime(IN (elapsedPlaytime - simulationRate), IN totalPlaytime, IN true /*validLastMode*/,IN mediaObject.objectID);

        /* Create FastReverseSimulation timer*/
        m_FFwdFRevProgressTimer.StartTimer(OUT m_FFwdFRevProgressTimerID,
                        IN LocalSPM::GetDataProvider().FFwdFRevTimeInterval(),
                        IN LocalSPM::GetDataProvider().FFwdFRevTimeInterval(),
                        IN &LocalSPM::GetPlayerManager(),
                        IN &FFwdFRevProgressTimerCallBack,
                        IN NULL);

        /* Update PlaybackState derived from internal SM state */
        ret = UpdatePlaybackState(PE_PBS_FASTREVERSESTATE);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while updating PlaybackState"));
        }
    }
    else
    {
        /* Send FFWD_STOP message to own SM to cancel the FFWD*/
        ret = SendEvent(FREV_STOP, (char *)NULL);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return MP_NO_ERROR;
}

tResult PlayerManager::FastReverseSimulationStop()
{
    ENTRY
    return FastForwardSimulationStop();
}

tBool PlayerManager::FFwdFRevProgressTimerCallBack()
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    tBool continueTimer = false;
    tPlaytime elapsedPlaytime = 0;
    tPlaytime totalPlaytime = 0;
    tObjectID objectID = OBJECT_ID_NONE;
    ret = GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime,OUT objectID);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while getting last playtime -> Cannot set playtime"));
    }
    else
    {
        tMediaObject currentMediaObject;
        ret = GetMediaObject(OUT currentMediaObject);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while getting current media object -> Cannot set playtime"));
        }
        else
        {
            tCueingRate srate1, srate2;
            srate1 = (tCueingRate)LocalSPM::GetDataProvider().FFwdFRevTimeInterval();
            srate2 = (tCueingRate)LocalSPM::GetDataProvider().FFwdFRevSimulationRate();
            tCueingRate simulationRate = (tCueingRate)srate1 * (tCueingRate)srate2;
            PlayerManagerSM_states state = (PlayerManagerSM_states)PlayerManagerSM::GetState();
            switch (state)
            {
                case fFwd_deAllocate:
                    if(totalPlaytime > (elapsedPlaytime + simulationRate))
                    {
                        continueTimer = true;
                        elapsedPlaytime += simulationRate;
                    }
                    else
                    {
                        ret = SendEvent(FFWD_STOP, (char *)NULL);
                        if(MP_NO_ERROR != ret)
                        {
                            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
                        }
                    }
                    break;

                case fRev_deAllocate:
                    if(elapsedPlaytime > simulationRate)
                    {
                        continueTimer = true;
                        elapsedPlaytime -= simulationRate;
                    }
                    else
                    {
                        ret = SendEvent(FREV_STOP, (char *)NULL);
                        if(MP_NO_ERROR != ret)
                        {
                            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
                        }
                    }
                    break;

                case deAllocated:
                    //UpdatePlaybackState(PE_PBS_STOPPEDSTATE);size
                    break;

                default:
                    break;
            }

            /* Set internal player manager member Playtime to new value */
            // Do not call function directly in timer callback, send event instead
            //SetPlaytime(IN elapsedPlaytime, IN totalPlaytime, IN true /*validLastMode*/);

            tPETimeInfoStruct timeInfoStruct;
            InitPETimeInfoStruct(timeInfoStruct);
            timeInfoStruct.position.ms = (tPEMilliseconds)elapsedPlaytime;
            timeInfoStruct.duration.ms = (tPEMilliseconds)totalPlaytime;

            /* Marshal struct of timeInfo into a string */
            tPETimeInfo timeInfo;
            size_t size = sizeof(timeInfo);
            SMF::Marshal(OUT timeInfo,
                    IN size-1,
                    IN DOUBLE_MARSHAL_SEPARATOR,
                    IN tPEBytes_format tPEPercentage_format tPEMilliseconds_format tPEBytes_format tPEMilliseconds_format,
                    IN timeInfoStruct.position.bytes,
                    IN timeInfoStruct.position.pct,
                    IN timeInfoStruct.position.ms,
                    IN timeInfoStruct.duration.bytes,
                    IN timeInfoStruct.duration.ms);

            /* Send PLAYTIME_STATUS message to own SM */
            tAllParameters parameterString;
            size = sizeof(parameterString);

            ret = ParameterPLAYTIME_STATUS(OUT parameterString, IN size, IN (tPEHandle)currentMediaObject.objectID, IN currentMediaObject.deviceID, IN timeInfo);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            }
            else
            {
                ret = SendEvent(PLAYTIME_STATUS, IN parameterString);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
                }
            }
        }
    }

    return continueTimer;
}

bool PlayerManager::FFwdFRevProgressTimerCallBack(timer_t timerID , void* instance ,const void *userData)
{
    ENTRY
    (void)timerID;
    (void)userData;

    if(NULL == instance)
    {
        ETG_TRACE_ERR(("Invalid parameter: instance is NULL"));
    }
    else
    {
        PlayerManager *self = (PlayerManager*)instance;
        return self->FFwdFRevProgressTimerCallBack();
    }

    return false;
}

tResult PlayerManager::IsDeActivateAllFavoritesRequired(const tUUID uuid, tDeviceID deviceid, const tListID currentListID, const tListSize listsize)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    VARTRACE(uuid);
    VARTRACE(deviceid);
    VARTRACE(currentListID);
    VARTRACE(listsize);

    tReturnValue deactivateReq = false;
    tCategoryType favobjectType= CTY_NONE;
    tDeviceInfo deviceInfo;
    ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceid);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while getting device info from DBManager (ErrorCode:%s)", errorString(ret)));
        return deactivateReq;
    }

    if((IsAppleDevice(deviceInfo.deviceType)) && LocalSPM::GetDeviceDispatcher().IsBatchPlayable(deviceInfo.deviceID))
    {
        tMediaObject bufferMediaObject;
        ret = LocalSPM::GetListControl().GetCurrentMediaObject(OUT bufferMediaObject, IN currentListID);
         if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while getting current media object from ListControl (ErrorCode:%s)", errorString(ret)));
        }
        VARTRACE(bufferMediaObject);
        tFavoriteID favoriteActive=0;
        vector<tFavoriteInfo> favoritesInfo;
        ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetAllFavoriteInfo(favoritesInfo);
        tUInt iter;
        for(iter=0; iter<favoritesInfo.size(); iter++)
        {
            if(favoritesInfo[iter].active == true)
            {
                favoriteActive=favoritesInfo[iter].active;
                favobjectType=favoritesInfo[iter].objectType;
                ETG_TRACE_USR3(("PlayerManager::ForwardPlaybackStatus favoriteActive:%u",favoriteActive));
                break;
            }
        }
        if(favoriteActive)
        {
            if(0 < strlen_r(bufferMediaObject.UUID))
            {
                if(strcmp(bufferMediaObject.UUID, uuid))
                {
                    if(favobjectType == CTY_SONG || favobjectType == CTY_CHAPTER || favobjectType == CTY_EPISODE)
                    {
                        deactivateReq = true;
                        ETG_TRACE_USR3(("PlayerManager::ForwardPlaybackStatus CTY_SONG deactivate favoriteActive:%u",favoriteActive));
                    }else
                    {
                        tPosition position = 0;
                        ret = LocalSPM::GetListControl().GetPositionInList(OUT position, IN currentListID, IN bufferMediaObject.objectID);
                        VARTRACE(position);
                        tPosition posi = position;
                        if(listsize-1 == position)
                        {
                            posi=0;
                        }
                        else
                        {
                            posi=posi+1;
                        }
                        ret = LocalSPM::GetListControl().GetMediaObject(OUT bufferMediaObject, IN currentListID, IN posi);
                        VARTRACE(bufferMediaObject);
                        if(strcmp(bufferMediaObject.UUID, uuid))
                        {
                            if( 0 == position)
                            {
                                posi=listsize-1;
                            }
                            else
                            {
                                posi=posi-1;
                            }
                            ret = LocalSPM::GetListControl().GetMediaObject(OUT bufferMediaObject, IN currentListID, IN posi);
                            VARTRACE(bufferMediaObject);
                            if(strcmp(bufferMediaObject.UUID, uuid))
                            {
                                ETG_TRACE_USR3(("PlayerManager::ForwardPlaybackStatus album or artist deactivate!! favoriteActive:%u",favoriteActive));
                                deactivateReq = true;
                            }
                        }
                    }
                }
            }
        }
    }

    return deactivateReq;
}

tResult PlayerManager::SendScanMode(const tScanMode scanMode)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::SendScanMode scanMode:%u", scanMode));

    tResult ret = MP_NO_ERROR;

    /* Get current active device ID */
    tDeviceID activeDeviceID = DEVICE_ID_NOT_SET;

    /*
    If any active device found,then the (GenericMediaplayer& active DeviceType) were checked to know their trackscan support
    If both found to support scanning,then the PlayerManagerSM is informed to forward the SCAN mode value to corresponding DeviceControl */
    ret = LocalSPM::GetDBManager().GetActiveDevice(OUT activeDeviceID);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while getting active device from DBManager -> Cannot send ScanMode to the DeviceControl (ErrorCode:%s)", errorString(ret)));
        ret = -1;
    }
    else
    {
        tDeviceInfo deviceInfo;
        ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN activeDeviceID);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while getting device info from DBManager -> Cannot send ScanMode to the DeviceControl(ErrorCode:%s)", errorString(ret)));
            ret = -1;
        }
        else
        {
            if(LocalSPM::GetDataProvider().IsDeviceSupportTrackScanning(deviceInfo.deviceType))
            {
                /* Send SCAN_MODE message to own SM */
                tAllParameters parameterString;
                size_t size = sizeof(parameterString);

                ret = ParameterSCAN_MODE(OUT parameterString, IN size,IN deviceInfo.deviceType,IN activeDeviceID, IN scanMode);
                if (MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while preparing parameter string for SCAN_MODE(ErrorCode:%s)", errorString(ret)));
                    ret = -1;
                }
                else
                {
                    ret = SendEvent(SCAN_MODE, IN parameterString);
                    if (MP_NO_ERROR != ret)
                    {
                        ETG_TRACE_USR4(("Error while sending internal SCAN_MODE event via SMF (ErrorCode:%s)", errorString(ret)));
                         ret = -1;
                    }
                }
            }
            else
            {
                ETG_TRACE_ERR(("Active DeviceType:%d doesnt support track scanning",deviceInfo.deviceType));
            }
        }
    }
    return ret;
}
tResult PlayerManager::ScanMode(const tDeviceType deviceType,const tDeviceID deviceID,const tScanMode scanMode)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::ScanMode:%u,deviceID:%d,deviceType:%d",scanMode,deviceID,deviceType));

    tResult ret = MP_NO_ERROR;

    /* Get current active device ID */
    tDeviceID activeDeviceID = DEVICE_ID_NOT_SET;
    ret = LocalSPM::GetDBManager().GetActiveDevice(OUT activeDeviceID);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while getting active device from DBManager -> Cannot send ScanMode to the DeviceControl (ErrorCode:%s)", errorString(ret)));
        ret = -1;
    }
    else
    {
        ETG_TRACE_USR4(("activeDeviceID:%d",activeDeviceID));

        if(deviceID == activeDeviceID)
        {
            if(scanMode)
            {
                /*If Scan-ON Requested being in Repeat track mode,then the RepeatMode has to be turned-off followed by Scanning of tracks*/
                tRepeatMode repeatMode;
                ret = LocalSPM::GetListControl().GetRepeatMode(OUT repeatMode);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while getting repeat mode from ListControl (ErrorCode:%s)", errorString(ret)));
                }
                else
                {
                    if(RPT_ONE == repeatMode)
                    {
                        ETG_TRACE_USR4(("Scan-ON was requested while RepeatMode being RPT_ONE.Hence setting Default RepeatMode as current RepeatMode"));
                        /* Reset repeat mode to default in ListControl */
                        tMediaContext mediaContext;
                        LocalSPM::GetDBManager().GetMediaContext( OUT mediaContext);
                        if(MC_VIDEO == mediaContext)
                            repeatMode = (tRepeatMode)LocalSPM::GetDataProvider().DBDefaultVideoRepeatMode();
                        else
                            repeatMode = (tRepeatMode)LocalSPM::GetDataProvider().DBDefaultRepeatMode();

                        ETG_TRACE_USR4(("DBDefaultRepeatMode is :%d",repeatMode));
                        ret = LocalSPM::GetListControl().SetRepeatMode(IN deviceID, IN repeatMode);
                        if( MP_NO_ERROR != ret )
                        {
                            ETG_TRACE_ERR(("Error while setting playback mode at ListControl (ErrorCode:%s)", errorString(ret)));
                        }
                    }
                }

                /*If Scan-ON Requested while HMI not being in Playing State,then resume the playback followed by Scanning of tracks */
                if(m_HMIPlaybackState != HMI_PBS_PLAYING)
                {
                    ETG_TRACE_USR4(("Scan-ON was requested while HMI was not in Playing State.Hence Resuming the Playback"));

                    tAllParameters parameterString = {0};
                    ret = SendEventByName("RESUME", IN parameterString);
                    if(MP_NO_ERROR != ret)
                    {
                        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
                    }
                }
            }
            /*Prepare and send the scan message to the DeviceControl managing the device with deviceID*/
            ret = PrepAndSendScanMessage(IN deviceType, IN deviceID, IN scanMode);
        }
        else
        {
            ETG_TRACE_USR4(("ActiveDeviceID is not same as the DeviceID for which scan was Requested"));
        }
    }
    return ret;
}
tResult PlayerManager::GetScanMode(tScanMode &scanMode)
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();
    scanMode = mIsScanMode;
    m_Mutex.unlock();

    ETG_TRACE_USR3(("PlayerManager::GetScanMode scanMode:%u", scanMode));
    return ret;
}

tResult PlayerManager::ForwardScanModeStatus(const tDeviceID deviceID, const tScanMode scanMode)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::ForwardScanModeStatus deviceID:%u, scanMode:%u", deviceID, scanMode));

    tResult ret = MP_NO_ERROR;

    /* Get current active device ID */
    tDeviceID activeDeviceID = DEVICE_ID_NOT_SET;
    ret = LocalSPM::GetDBManager().GetActiveDevice(OUT activeDeviceID);

    ETG_TRACE_USR3(("activeDeviceID:%u, mIsScanMode:%u", activeDeviceID, mIsScanMode));

    if  (mIsScanMode != scanMode)
    {
        mIsScanMode = scanMode;

        /* Update HMI of property ScanMode */
        ret = LocalSPM::GetOutputWrapper().UpdateScanMode();

        tMediaObject currentMediaObject;
        ret = GetMediaObject(OUT currentMediaObject);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while getting current media object -> No further action (NoObject and Next) possible"));
            return ret = -1;
        }

        if( mIsScanMode)
        {
            m_firstScannedMediaObjectID = currentMediaObject.objectID;
        }
        else
        {
            m_firstScannedMediaObjectID = OBJECT_ID_NONE;
        }
    }
    else
    {
        ETG_TRACE_USR3(("ScanMode not forwarded to HMI"));
    }

    return ret;
}

tResult PlayerManager::PrepAndSendScanMessage(const tDeviceType deviceType, const tDeviceID deviceID, const tScanMode scanMode)
{
    ENTRY
    ETG_TRACE_USR3(("PlayerManager::PrepAndSendScanMessage deviceType:%u, deviceID:%u, scanMode:%u", deviceType, deviceID, scanMode));

    /* Send SET_SCAN_MODE message to specific DeviceControlSM */
    char msgToSendString[64];
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tResult ret = MP_NO_ERROR;

    strncpy_r(OUT msgToSendString, IN "SET_SCAN_MODE", IN sizeof(msgToSendString));

    ret = LocalSPM::GetUSBControl().ParameterSET_SCAN_MODE(OUT parameterString,
                                                            IN size,
                                                            IN deviceType,
                                                            IN deviceID,
                                                            IN scanMode);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string for SET_SCAN_MODE event(ErrorCode:%s)", errorString(ret)));;
        ret = -1;
    }
    else
    {
        ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN deviceType, IN msgToSendString, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending SET_SCAN_MODE message via SMF (ErrorCode:%s)", errorString(ret)));
            ret = -1;
        }
    }
    return ret;
}


tResult PlayerManager::CheckConnectionStateMyMedia()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Get current active device ID */
    tDeviceID currentDeviceID = DEVICE_ID_NOT_SET;
    ret = LocalSPM::GetDBManager().GetActiveDevice(OUT currentDeviceID);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while getting active device from DBManager -> Cannot check connection state of MyMedia (ErrorCode:%s)", errorString(ret)));
    }
    else
    {
        tDeviceCount devCount = 0;
        ret = LocalSPM::GetDBManager().GetConnectedDeviceCount(devCount);
        if(MP_NO_ERROR != ret) devCount = 0;

        /* Set MYMedia to not active if less than 3 devices (incl. MyMedia) are connected */
        if ((MY_MEDIA == currentDeviceID)
            &&
            (3 > devCount))
        {
            ret = LocalSPM::GetDBManager().ActiveMediaDeviceSet(MY_MEDIA, IN false);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while resetting active device at DBManager (ErrorCode:%s)", errorString(ret)));
            }
            else
            {
                tListID currentListID;
                ret = GetListID(OUT currentListID);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Current listID is not valid"));
                }
                else
                {
                    tListInfo listInfo;
                    ret = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN currentListID, IN false);
                    if( MP_NO_ERROR != ret )
                    {
                        ETG_TRACE_ERR(("Error while getting list info at ListControl -> Cannot reset listID (ErrorCode:%s)", errorString(ret)));
                    }
                    else
                    {
                        if(MY_MEDIA == listInfo.deviceID)
                        {
                            /* Reset listID */
                            SetListID(LIST_ID_NONE);
                        }
                    }
                }
            }
        }
    }

    return MP_NO_ERROR;
};

tResult PlayerManager::CalculateNowPlayingState(tNowPlaying &nowPlaying)
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /*When DeviceIDs of Previous & current nowplaying update Differ or PlayerManager is Inactive,then
     * clearoff the remembered Previous nowplaying update info
     */
    if((m_PrevNowPlayingUpdateMediaObject.deviceID != nowPlaying.object.deviceID) ||(false == nowPlaying.object.isPlaying))
    {
        if(m_PrevNowPlayingUpdateMediaObject.deviceID != DEVICE_ID_NOT_SET)
        {
            InitMediaObject(OUT m_PrevNowPlayingUpdateMediaObject);
            m_PrevNowPlayingUpdateListID = LIST_ID_NONE;
        }
    }

    if((nowPlaying.object.deviceID != DEVICE_ID_NOT_SET) && (true == nowPlaying.object.isPlaying))
    {
        if(OBJECT_ID_NONE == nowPlaying.objectID)
        {
            nowPlaying.state = NP_INVALID;
        }
        //For MassStorage Devices - ObjectID compared to decide the track as new track or same track
        if(IsMassStorageDevice(IN nowPlaying.object.deviceType))
        {
            if((NP_NEW_TRACK == nowPlaying.state) &&
                    (m_PrevNowPlayingUpdateListID == nowPlaying.listID) &&
                    (m_PrevNowPlayingUpdateMediaObject.objectID == nowPlaying.objectID))
            {
                nowPlaying.state = NP_SAME_TRACK;
            }

            if(nowPlaying.state != NP_SAME_TRACK)
            {
                m_PrevNowPlayingUpdateMediaObject.objectID = nowPlaying.objectID;
                m_PrevNowPlayingUpdateListID = nowPlaying.listID;
            }
        }
        /* For Apple Devices - Metadata & UUID compared to decide the track as new track or same track
         * Title comparison Reason:For same UUID title "Loading..." followed proper title update sent
         */
        else if(IsAppleDevice(nowPlaying.object.deviceType))
        {
            if(NP_NEW_TRACK == nowPlaying.state)
            {
                if(strncmp(nowPlaying.object.title,m_PrevNowPlayingUpdateMediaObject.title,sizeof(tTitle)))
                {
                    strncpy_r(m_PrevNowPlayingUpdateMediaObject.title,nowPlaying.object.title,sizeof(tTitle));
                    strncpy_r(m_PrevNowPlayingUpdateMediaObject.MetadataField4 ,nowPlaying.object.MetadataField4,sizeof(tMetadata));
                    strncpy_r(m_PrevNowPlayingUpdateMediaObject.MetadataField3 ,nowPlaying.object.MetadataField3,sizeof(tMetadata));
                    strncpy_r(m_PrevNowPlayingUpdateMediaObject.MetadataField2 ,nowPlaying.object.MetadataField2,sizeof(tMetadata));
                    strncpy_r(m_PrevNowPlayingUpdateMediaObject.MetadataField1 ,nowPlaying.object.MetadataField1,sizeof(tMetadata));
                    //strncpy_r(m_PrevNowPlayingUpdateMediaObject.UUID,nowPlaying.object.UUID,sizeof(tUUID));
                    m_PrevNowPlayingUpdateMediaObject.totalPlaytime = nowPlaying.object.totalPlaytime;
                }
                else if(strncmp(nowPlaying.object.MetadataField4,m_PrevNowPlayingUpdateMediaObject.MetadataField4,sizeof(tMetadata)))
                {
                    strncpy_r(m_PrevNowPlayingUpdateMediaObject.MetadataField4 ,nowPlaying.object.MetadataField4,sizeof(tMetadata));
                    strncpy_r(m_PrevNowPlayingUpdateMediaObject.MetadataField3 ,nowPlaying.object.MetadataField3,sizeof(tMetadata));
                    strncpy_r(m_PrevNowPlayingUpdateMediaObject.MetadataField2 ,nowPlaying.object.MetadataField2,sizeof(tMetadata));
                    strncpy_r(m_PrevNowPlayingUpdateMediaObject.MetadataField1 ,nowPlaying.object.MetadataField1,sizeof(tMetadata));
                    //strncpy_r(m_PrevNowPlayingUpdateMediaObject.UUID,nowPlaying.object.UUID,sizeof(tUUID));
                    m_PrevNowPlayingUpdateMediaObject.totalPlaytime = nowPlaying.object.totalPlaytime;
                }
                else if(strncmp(nowPlaying.object.MetadataField3,m_PrevNowPlayingUpdateMediaObject.MetadataField3,sizeof(tMetadata)))
                {
                    strncpy_r(m_PrevNowPlayingUpdateMediaObject.MetadataField3 ,nowPlaying.object.MetadataField3,sizeof(tMetadata));
                    strncpy_r(m_PrevNowPlayingUpdateMediaObject.MetadataField2 ,nowPlaying.object.MetadataField2,sizeof(tMetadata));
                    strncpy_r(m_PrevNowPlayingUpdateMediaObject.MetadataField1 ,nowPlaying.object.MetadataField1,sizeof(tMetadata));
                    //strncpy_r(m_PrevNowPlayingUpdateMediaObject.UUID,nowPlaying.object.UUID,sizeof(tUUID));
                    m_PrevNowPlayingUpdateMediaObject.totalPlaytime = nowPlaying.object.totalPlaytime;
                }
                else if(strncmp(nowPlaying.object.MetadataField2,m_PrevNowPlayingUpdateMediaObject.MetadataField2,sizeof(tMetadata)))
                {
                    strncpy_r(m_PrevNowPlayingUpdateMediaObject.MetadataField2 ,nowPlaying.object.MetadataField2,sizeof(tMetadata));
                    strncpy_r(m_PrevNowPlayingUpdateMediaObject.MetadataField1 ,nowPlaying.object.MetadataField1,sizeof(tMetadata));
                    //strncpy_r(m_PrevNowPlayingUpdateMediaObject.UUID,nowPlaying.object.UUID,sizeof(tUUID));
                    m_PrevNowPlayingUpdateMediaObject.totalPlaytime = nowPlaying.object.totalPlaytime;
                }
                else if(strncmp(nowPlaying.object.MetadataField1,m_PrevNowPlayingUpdateMediaObject.MetadataField1,sizeof(tMetadata)))
                {
                    strncpy_r(m_PrevNowPlayingUpdateMediaObject.MetadataField1 ,nowPlaying.object.MetadataField1,sizeof(tMetadata));
                    //strncpy_r(m_PrevNowPlayingUpdateMediaObject.UUID,nowPlaying.object.UUID,sizeof(tUUID));
                    m_PrevNowPlayingUpdateMediaObject.totalPlaytime = nowPlaying.object.totalPlaytime;
                }
                else if((nowPlaying.object.totalPlaytime != m_PrevNowPlayingUpdateMediaObject.totalPlaytime) && (m_PrevNowPlayingUpdateMediaObject.totalPlaytime != PLAYTIME_NONE))
                {
                    m_PrevNowPlayingUpdateMediaObject.totalPlaytime = nowPlaying.object.totalPlaytime;
                }
#if 0
                else if(strncmp(nowPlaying.object.UUID,m_PrevNowPlayingUpdateMediaObject.UUID,sizeof(tUUID)))
                {
                    strncpy_r(m_PrevNowPlayingUpdateMediaObject.UUID,nowPlaying.object.UUID,sizeof(tUUID));
                }
#endif
                else
                {
                    nowPlaying.state = NP_SAME_TRACK;
                }
            }
        }
    }
    return ret;
}

tBoolean PlayerManager::ValidateVideoProperty(IN const tVideoProperty videoProperty, IN const tPropertyValue propertyValue)
{
    ENTRY_INTERNAL
    tBoolean ret = false;

    switch(videoProperty)
    {
        case VP_BRIGHTNESS:
        {
            ret = (LocalSPM::GetDataProvider().MinBrightness() <= propertyValue) && (propertyValue <= LocalSPM::GetDataProvider().MaxBrightness()) ? true : false;
            break;
        }
        case VP_HUE:
        {
            ret = (LocalSPM::GetDataProvider().MinHue() <= propertyValue) && (propertyValue <= LocalSPM::GetDataProvider().MaxHue()) ? true : false;
            break;
        }
        case VP_SATURATION:
        {
            ret = (LocalSPM::GetDataProvider().MinSaturation() <= propertyValue) && (propertyValue <= LocalSPM::GetDataProvider().MaxSaturation()) ? true : false;
            break;
        }
        case VP_CONTRAST:
        {
            ret = (LocalSPM::GetDataProvider().MinContrast() <= propertyValue) && (propertyValue <= LocalSPM::GetDataProvider().MaxContrast()) ? true : false;
            break;
        }
        case VP_BRIGHTNESS_OFFSET:
        {
            ret = (LocalSPM::GetDataProvider().MinBrightnessOffset() <= propertyValue) && (propertyValue <= LocalSPM::GetDataProvider().MaxBrightnessOffset()) ? true : false;
            break;
        }
        case VP_HUE_OFFSET:
        {
            ret = (LocalSPM::GetDataProvider().MinHueOffset() <= propertyValue) && (propertyValue <= LocalSPM::GetDataProvider().MaxhueOffset()) ? true : false;
            break;
        }
        case VP_SATURATION_OFFSET:
        {
            ret = (LocalSPM::GetDataProvider().MinSaturationOffset() <= propertyValue) && (propertyValue <= LocalSPM::GetDataProvider().MaxSaturationOffset()) ? true : false;
            break;
        }
        default:
        {
            ETG_TRACE_ERR(("Invalid video property type: %u",videoProperty));
            break;
        }
    }
return ret;

}

tResult PlayerManager::SendVideoProperty(IN const tVideoProperty videoProperty, IN const tPropertyValue propertyValue)
{
    ENTRY
    VARTRACE(videoProperty)
    VARTRACE(propertyValue)

    tResult ret = MP_NO_ERROR;

    if((1 == LocalSPM::GetDataProvider().SetVideoProperty() || 1 == LocalSPM::GetDataProvider().SetDVDVideoProperty()) && ValidateVideoProperty(videoProperty,propertyValue))
    {
/* below implementatiopn shall wait till the video property value is updated in db and then updateclients on property changed. \
This shall prevent the unsynchronized values bewteen set and get property call*/
#if 0
        /* Do set video property request and wait for the answer */
        char messageString[64];
        strncpy_r(OUT messageString, IN "PlayerManagerSM::SET_VIDEO_PROPERTY", IN sizeof(messageString));
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = ParameterSET_VIDEO_PROPERTY(OUT parameterString, IN size, IN videoProperty, IN propertyValue);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            RequestResponseSM rrSetVideoProperty;
            ret = rrSetVideoProperty.DoEventAnswer(IN messageString, IN parameterString, NULL, 2000);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
            }

            /* update registered clients on the property change via output wrapper */
            ret = LocalSPM::GetOutputWrapper().UpdateVideoProperty(IN videoProperty);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while updating video property to registered clients"));
            }
        }
#endif
        /* Send SET_VIDEO_PROPERTY message to own SM */
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = ParameterSET_VIDEO_PROPERTY(OUT parameterString, IN size, IN propertyValue, IN videoProperty);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            ret = SendEvent(SET_VIDEO_PROPERTY, IN parameterString);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
    }
    else
    {
        ret = -1;
    }
    return ret;
}

tResult PlayerManager::HandleVideoProperty(IN const tPropertyValue propertyValue,IN const tVideoProperty videoProperty)
{
    ENTRY
    VARTRACE(videoProperty)
    VARTRACE(propertyValue)

    tResult ret = MP_NO_ERROR;
    tPropertyValue getPropertyValue = 0;

    switch(videoProperty)
    {
        case VP_BRIGHTNESS:
        {
            ret = LocalSPM::GetDBManager().GetVideoBrightness(OUT (tVideoBrightness &)getPropertyValue);
            break;
        }
        case VP_HUE:
        {
            ret = LocalSPM::GetDBManager().GetVideoHue(OUT (tVideoHue &)getPropertyValue);
            break;
        }
        case VP_SATURATION:
        {
            ret = LocalSPM::GetDBManager().GetVideoSaturation(OUT (tVideoSaturation &)getPropertyValue);
            break;
        }
        case VP_CONTRAST:
        {
            ret = LocalSPM::GetDBManager().GetVideoContrast(OUT (tVideoContrast &)getPropertyValue);
            break;
        }
        case VP_BRIGHTNESS_OFFSET:
        {
            ret = LocalSPM::GetDBManager().GetVideoBrightnessOffset(OUT (tVideoBrightnessOffset &)getPropertyValue);
            break;
        }
        case VP_HUE_OFFSET:
        {
            ret = LocalSPM::GetDBManager().GetVideoHueOffset(OUT (tVideoHueOffset &)getPropertyValue);
            break;
        }
        case VP_SATURATION_OFFSET:
        {
            ret = LocalSPM::GetDBManager().GetVideoSaturationOffset(OUT (tVideoSaturationOffset &)getPropertyValue);
            break;
        }
        default:
        {
            ETG_TRACE_ERR(("Invalid video property type: %u",videoProperty));
            break;
        }
    }
    VARTRACE(getPropertyValue)
    if((MP_NO_ERROR == ret) && (propertyValue != getPropertyValue))
    {
        ret = LocalSPM::GetDBManager().UpdateVideoProperty(videoProperty,propertyValue);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while updating video property to db"));
        }
        else
        {
            /* Send SET_VIDEO_PROPERTY message to USB DeviceControlSM */
            char msgToSendString[64];
            strncpy_r(OUT msgToSendString, IN "SET_VIDEO_PROPERTY", IN sizeof(msgToSendString));


            /* Get current active device ID */
               tDeviceID activeDeviceID = DEVICE_ID_NOT_SET;

               ret = LocalSPM::GetDBManager().GetActiveDevice(OUT activeDeviceID);
               if(MP_NO_ERROR != ret)
               {
                   ETG_TRACE_ERR(("Error while getting active device from DBManager -> Cannot send ScanMode to the DeviceControl (ErrorCode:%s)", errorString(ret)));
               }
               else
               {
                   tDeviceInfo deviceInfo;
                   ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN activeDeviceID);
                   if( MP_NO_ERROR != ret )
                   {
                       ETG_TRACE_ERR(("Error while getting device info from DBManager -> Cannot send ScanMode to the DeviceControl(ErrorCode:%s)", errorString(ret)));
                   }
                   else
                   {
                        if(DTY_USB == deviceInfo.deviceType || DTY_MTP == deviceInfo.deviceType || ((1 == LocalSPM::GetDataProvider().SetDVDVideoProperty()) && DTY_DVD_DRIVE == deviceInfo.deviceType))
                            ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN deviceInfo.deviceType, IN msgToSendString, IN (char*)NULL);
                        else
                            return MP_NO_ERROR;
                   }
               }

            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
            }
            else
            {
                /* update registered clients on the property change via output wrapper */
                ret = LocalSPM::GetOutputWrapper().UpdateVideoProperty(IN videoProperty);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while updating video property to registered clients"));
                }
            }
        }
    }
    else
    {
        ETG_TRACE_USR3(("No change in the video property value, ignoring the request"));
    }

#if 0
    /* send answer to rr SM to release the wait */
    ret = SendAnswer(NULL);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }
#endif

    return ret;
}

tResult PlayerManager::UpdateNowPlayingWithGivenPosition(const tListID listID,const tPosition position)
{
    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();

    if(m_HMINowPlaying.listID == listID)
    {
        m_HMINowPlaying.position = position;
        if((DTY_BLUETOOTH == m_MediaObject.deviceType) && (OBJECT_ID_NONE != m_HMINowPlaying.objectID))
        {
            m_HMINowPlaying.position = m_HMINowPlaying.objectID - 1;
        }
        m_Mutex.unlock();

        /*Get current active device ID */
        tDeviceID currentDeviceID = DEVICE_ID_NOT_SET;
        ret = LocalSPM::GetDBManager().GetActiveDevice(OUT currentDeviceID);

        if((MP_NO_ERROR == ret)
           &&
           ((m_HMINowPlaying.object.deviceID == currentDeviceID) //nowPlaying is related to the active device
            ||
            (MY_MEDIA == currentDeviceID)))
        {
            ETG_TRACE_USR4(("UpdateNowPlayingWithGivenPosition:sending NowPlaying update "));
            /* Update HMI of property NowPlaying */
            ret = LocalSPM::GetOutputWrapper().UpdateNowPlaying();
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while updating NowPlaying via OutputWrapper (ErrorCode:%s)", errorString(ret)));
            }
        }
        else
        {
            ETG_TRACE_USR1(("NowPlaying is not related to the active device -> No update"));
        }
    }
    else
    {
        m_Mutex.unlock();
    }
    return ret;
}

tResult PlayerManager::DecideSwitchingToDefaultRepeatMode()
{
    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().ChangeFromRepeatAllToDefaultRepeatMode())
    {
        /* Get the repeat mode for that device */
        tRepeatMode repeatMode = RPT_INVALID;

        ret = LocalSPM::GetListControl().GetRepeatMode(OUT repeatMode);

        if(RPT_ALL == repeatMode)
        {
            ETG_TRACE_USR4(("Switching RepeatMode from RPT_ALL to DBDefaultRepeatMode"));
            /* reset repeat mode */
            ret = SendRepeatMode(IN (tRepeatMode)LocalSPM::GetDataProvider().DBDefaultRepeatMode());
        }
    }
    return ret;
}

tResult PlayerManager::ClearLastModePause(const tDeviceID deviceID)
{
    ENTRY
    VARTRACE(deviceID)

    tResult ret = MP_NO_ERROR;

    if(DEVICE_ID_NOT_SET == deviceID)
    {
        ret = MP_ERR_PM_INVALID_PARAM;
    }
    else
    {
        tBoolean isStreamingDevice = LocalSPM::GetDataProvider().IsPermanentStreamingActive(IN deviceID);
        if(isStreamingDevice)
        {
            LocalSPM::GetDataProvider().AddDeviceToIgnoreLastModePause(deviceID);
        }
        else
        {
            m_AutoPlayFlag = TRUE;
        }
    }
    return ret;
}
tResult PlayerManager::SetAutoPlayFlag()
{
    m_AutoPlayFlag = TRUE;
    return MP_NO_ERROR;
}
void PlayerManager::SetActiveDevice(tDeviceID activeDevice)
{
    m_Mutex.lock();
    m_ActiveDevice = activeDevice;
    m_Mutex.unlock();
}
void PlayerManager::GetActiveDevice(tDeviceID & activeDevice)
{
    m_Mutex.lock();
    activeDevice = m_ActiveDevice;
    m_Mutex.unlock();
}

void PlayerManager::ResetCurrentListAndMediaObject()
{
     SetListID(LIST_ID_NONE);
    tMediaObject mediaObject;
    InitMediaObject(OUT mediaObject);
    SetMediaObject(IN mediaObject);
}
void PlayerManager::GetPlaybackSpeed(OUT tPlaybackSpeed &playbackSpeed)
{
    m_Mutex.lock();
    playbackSpeed = curPlaybackSpeed;
    m_Mutex.unlock();
}
tBoolean PlayerManager::IsSourceActivityPause()
{
    ENTRY
    VARTRACE(m_SAPauseFlag);
    tBoolean ret = false;
    ret = m_SAPauseFlag;
    return ret;
}
tResult PlayerManager::SendNoResponseEvent(const me::reason_e response)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    /* Get current active device ID */
    tDeviceID activeDeviceID = DEVICE_ID_NOT_SET;

    ret = LocalSPM::GetDBManager().GetActiveDevice(OUT activeDeviceID);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while getting active device from DBManager -> Cannot send ScanMode to the DeviceControl (ErrorCode:%s)", errorString(ret)));
    }
    else
    {
        tDeviceInfo deviceInfo;
        ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN activeDeviceID);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while getting device info from DBManager -> Cannot send ScanMode to the DeviceControl(ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            if(DTY_BLUETOOTH == deviceInfo.deviceType)
            {
                char messageString[64];
                tAllParameters parameterString;
                size_t size = sizeof(parameterString);

                ret = LocalSPM::GetPlayerManager().ParameterSTREAM_ERROR(OUT parameterString, IN size, IN response);
                strncpy_r(OUT messageString, IN "BTControlSM::NO_RESPONSE_MSG", IN sizeof(messageString));
                ETG_TRACE_USR4(("Message %s", parameterString));
                ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN deviceInfo.deviceType, IN messageString, IN parameterString);
            }
            else
            {
                return MP_NO_ERROR;
            }
        }
    }
    return ret;

}
tResult PlayerManager::HandelNoResponseProperty(tResponseMsg response, tDeviceID id, tDeviceType type)
{
    ENTRY
    tResult ret = MP_NO_ERROR;


    m_Mutex.lock();
    mResponseMsg.deviceType = type;
    mResponseMsg.response = response;
    mDeviceIdResponse = id;
    m_Mutex.unlock();

    VARTRACE(mResponseMsg.response)
    VARTRACE(mDeviceIdResponse)
    VARTRACE(mResponseMsg.deviceType);
    ret = LocalSPM::GetOutputWrapper().UpdateStreamingInfo();

    return ret;
}
tResult PlayerManager::getStreamingInfo(OUT tResponseMsg &info, OUT tDeviceType &type, OUT tDeviceID &deviceId)
{
    ENTRY

    VARTRACE(m_ActiveDevice)

    info  = REASON_OK;
    if(mDeviceIdResponse==m_ActiveDevice)
    {
        info = mResponseMsg.response;
        type = mResponseMsg.deviceType;
        deviceId = mDeviceIdResponse;
    }
    return MP_NO_ERROR;
}
tResult PlayerManager::SetNowPlayingMetadataEditedByUser(const tObjectID editedMediaObjectID)
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();

    if(editedMediaObjectID == m_HMINowPlaying.objectID)
    {
        //fill the yomi data for musicbox device
        if( MUSICBOX_DEVICE_ID == m_HMINowPlaying.object.deviceID)
        {
            if(LocalSPM::GetDataProvider().YomiMetadataSupport())
            {
                ETG_TRACE_USR3(("PlayerManager::SetNowPlayingMetadataEditedByUser trying the yomi data from Database"));
                tYomiMetadata yomiMetadata;
                if(MP_NO_ERROR == LocalSPM::GetDBManager().GetYomiMetadata(m_HMINowPlaying.objectID, yomiMetadata))
                {
                    ETG_TRACE_USR3(("PlayerManager::SetNowPlayingMetadataEditedByUser Filling the yomi data from Database"));
                    strncpy_r(m_HMINowPlaying.object.YomiTitle,yomiMetadata.YomiTitle,sizeof(tMetadata));
                    strncpy_r(m_HMINowPlaying.object.YomiArtist,yomiMetadata.YomiArtist,sizeof(tMetadata));
                    strncpy_r(m_HMINowPlaying.object.YomiAlbum,yomiMetadata.YomiAlbum,sizeof(tMetadata));
                    VARTRACE(yomiMetadata);
                }
                else
                {
                    ETG_TRACE_USR3(("PlayerManager::SetNowPlayingMetadataEditedByUser Fetching the yomi data from Database got failed"));
                }
            }
            tMediaObject mediaObjectFromDB;
            if(MP_NO_ERROR == LocalSPM::GetDBManager().GetMediaObject(OUT mediaObjectFromDB,IN m_HMINowPlaying.objectID,IN CTY_SONG,IN MUSICBOX_DEVICE_ID))
            {
                ETG_TRACE_USR3(("PlayerManager::SetNowPlayingMetadataEditedByUser Filling the yomi data from Database"));
                strncpy_r(m_HMINowPlaying.object.title,mediaObjectFromDB.title,sizeof(tTitle));
                strncpy_r(m_HMINowPlaying.object.MetadataField4 , mediaObjectFromDB.MetadataField4,sizeof(tMetadata));
                strncpy_r(m_HMINowPlaying.object.MetadataField3 , mediaObjectFromDB.MetadataField3,sizeof(tMetadata));
                strncpy_r(m_HMINowPlaying.object.MetadataField2 , mediaObjectFromDB.MetadataField2,sizeof(tMetadata));
                strncpy_r(m_HMINowPlaying.object.MetadataField1 , mediaObjectFromDB.MetadataField1,sizeof(tMetadata));
            }
            else
            {
                ETG_TRACE_USR3(("PlayerManager::SetNowPlayingMetadataEditedByUser Fetching the metadata data from Database got failed"));
            }
            m_Mutex.unlock();
            //Update now playing to HMI
            ETG_TRACE_USR4(("UpdateNowPlayingAfterUserEdit:sending NowPlaying update "));
            /* Update HMI of property NowPlaying */
            ret = LocalSPM::GetOutputWrapper().UpdateNowPlaying();
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while updating NowPlaying via OutputWrapper (ErrorCode:%s)", errorString(ret)));
            }
        }
        else
        {
            m_Mutex.unlock();
        }

    }
    else
    {
        m_Mutex.unlock();
    }
    return ret;
}
