#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/PictureManagerTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif


#include "PictureManager.h"
#include "PictureManagerTest.h"
#include "FunctionTracer.h"
#include "VarTrace.h"
#include "LocalSPM.h"
#include "CppUnitDefinitions.h"

#include "Dispatcher.h"
#include "RequestResponseSM.h"
#include "MediaPlayer_ErrorCodes.h"


PictureManagerTest::PictureManagerTest()
{
    ENTRY
}

/**********************************************************************
 * Test cases
 *********************************************************************/

void PictureManagerTest::InitTestsuite()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Register DB trigger of indexer */
    ret = LocalSPM::GetIndexer().SwitchDBTrigger(IN TT_ALL, IN TS_ON);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);


    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tDeviceCount deviceCount = 3;

    /* Get deviceID */
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    ret = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Disconnect device (mark it as DISCONNECTED in DB) */
    ret = LocalSPM::GetDBManager().DeviceDisconnected(IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    ret = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished(IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    // test intermediate result
    tDeviceInfo deviceInfo;
    ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(CS_DISCONNECTED == deviceInfo.connectionState);

    ret = LocalSPM::GetDBManager().DeviceAttached(IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Send DB_DEVICE_INSERTED message to IndexerSM to create scan context */
    ret = LocalSPM::GetIndexer().ParameterDB_DEVICE_INSERTED(OUT parameterString, IN size, IN deviceCount, IN deviceID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = LocalSPM::GetIndexer().SendEventByName("DB_DEVICE_INSERTED", IN parameterString);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    for (unsigned int iter = 15; iter > 0 ; iter--) {
        sleep(2);
        ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
        CPPUNIT_ASSERT(MP_NO_ERROR == ret);
        if (IDS_COMPLETE == deviceInfo.indexedState) break;
    }
    CPPUNIT_ASSERT(CS_CONNECTED == deviceInfo.connectionState);
    CPPUNIT_ASSERT(IDS_COMPLETE == deviceInfo.indexedState);
}

void PictureManagerTest::EndTestsuite()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Deregister DB trigger of indexer */
    ret = LocalSPM::GetIndexer().SwitchDBTrigger(IN TT_ALL, IN TS_OFF);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Recreate the test database */
    ret = LocalSPM::GetDataProvider().RecreateTestDatabase(true, true);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
}

void PictureManagerTest::NewList_CreateMPIndexedList()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Create a new indexed list */
    tListSize listSize = 0;
    tListType listType = LTY_IMAGE;
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID;

    /* Get deviceID */
    ret = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Set the filter tags */
    tag1.tag = 0;
    tag2.artist = 0;
    tag3.composer = 0;
    tag4.album = 0;

    tListID listID = LIST_ID_NONE;
    /* Call create list */
    ret = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            IN listType,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);

    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(LIST_ID_NONE != listID);
    CPPUNIT_ASSERT(9 == listSize);


    vector<tMediaObject> mediaObjectVector;
    ret = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
                OUT mediaObjectVector,
                IN listID,
                0,
                listSize);

    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    VARTRACE(mediaObjectVector);

    for (unsigned int uiIndex = 0; uiIndex < listSize; uiIndex++)
    {
        switch(uiIndex)
        {
            case 0:
                CPPUNIT_ASSERT(!strcmp("/albumart/Art-MP3-Its_Raining_Again.jpg", mediaObjectVector[uiIndex].fileName));
                break;
            case 1:
                CPPUNIT_ASSERT(!strcmp("/albumart/Art-MP3-Neuland.jpg", mediaObjectVector[uiIndex].fileName));
                break;
            case 2:
                CPPUNIT_ASSERT(!strcmp("/music/Grönemeyer_-_Anders/bleibtallesanders.jpg", mediaObjectVector[uiIndex].fileName));
                break;
            case 3:
                CPPUNIT_ASSERT(!strcmp("/albumart/bmp.bmp", mediaObjectVector[uiIndex].fileName));
                break;
            case 4:
                CPPUNIT_ASSERT(!strcmp("/albumart/gif.gif", mediaObjectVector[uiIndex].fileName));
                break;
            case 5:
                CPPUNIT_ASSERT(!strcmp("/albumart/Nations_256.jpg", mediaObjectVector[uiIndex].fileName));
                break;
            case 6:
                CPPUNIT_ASSERT(!strcmp("/albumart/png.png", mediaObjectVector[uiIndex].fileName));
                break;
            case 7:
                CPPUNIT_ASSERT(!strcmp("/albumart/tif.tif", mediaObjectVector[uiIndex].fileName));
                break;
            case 8:
                 CPPUNIT_ASSERT(!strcmp("/albumart/zjpeg.jpeg", mediaObjectVector[uiIndex].fileName));
                 break;
            default:
                break;
        }

        /*Validate*/
        if(!strcmp(mediaObjectVector[uiIndex].fileName,"/albumart/Art-MP3-Its_Raining_Again.jpg"))
        {
#if IMAGE_ATTRIBUTES_IN_METADATA
            CPPUNIT_ASSERT(!strcmp(mediaObjectVector[uiIndex].MetadataField1,"4230401"));
#ifndef TARGET_BUILD            
            CPPUNIT_ASSERT(!strcmp(mediaObjectVector[uiIndex].MetadataField2,"2014:03:27 15:29:32"));
#endif            
            CPPUNIT_ASSERT(!strcmp(mediaObjectVector[uiIndex].MetadataField3,"3456x5184"));
            CPPUNIT_ASSERT(!strcmp(mediaObjectVector[uiIndex].MetadataField4,"72x72"));
#else
            CPPUNIT_ASSERT(mediaObjectVector[uiIndex].fileSize == 4230401LL);
#ifndef TARGET_BUILD
            CPPUNIT_ASSERT(!strcmp(mediaObjectVector[uiIndex].dateTime, "2014:03:27 15:29:32"));
#endif            
            CPPUNIT_ASSERT(!strcmp(mediaObjectVector[uiIndex].MetadataField2, "3456x5184"));
            CPPUNIT_ASSERT(!strcmp(mediaObjectVector[uiIndex].MetadataField1, "72x72"));
#endif
        }
        else if(!strcmp(mediaObjectVector[uiIndex].fileName,"/albumart/Art-MP3-Neuland.jpg"))
        {
#if IMAGE_ATTRIBUTES_IN_METADATA
            CPPUNIT_ASSERT(!strcmp(mediaObjectVector[uiIndex].MetadataField1,"5432543"));
#ifndef TARGET_BUILD            
            CPPUNIT_ASSERT(!strcmp(mediaObjectVector[uiIndex].MetadataField2,"2014:03:27 15:29:34"));
#endif            
            CPPUNIT_ASSERT(!strcmp(mediaObjectVector[uiIndex].MetadataField3,"2832x4256"));
            CPPUNIT_ASSERT(!strcmp(mediaObjectVector[uiIndex].MetadataField4,"72x72"));
#else
            CPPUNIT_ASSERT(mediaObjectVector[uiIndex].fileSize == 5432543LL);
#ifndef TARGET_BUILD
            CPPUNIT_ASSERT(!strcmp(mediaObjectVector[uiIndex].dateTime, "2014:03:27 15:29:34"));
#endif            
            CPPUNIT_ASSERT(!strcmp(mediaObjectVector[uiIndex].MetadataField2, "2832x4256"));
            CPPUNIT_ASSERT(!strcmp(mediaObjectVector[uiIndex].MetadataField1, "72x72"));
#endif
        }
        else
        {
            /* do nothing */
        }
    }

    ret = LocalSPM::GetPictureViewer().StartSlideshow(IN listID, IN  mediaObjectVector[4].objectID);

    tHMIPlaybackState playstatus;
    for(int sec=30; sec; sec--) {
        ret = LocalSPM::GetPictureViewer().GetSlideshowState(OUT playstatus);
        CPPUNIT_ASSERT(MP_NO_ERROR == ret);
        if (HMI_PBS_PLAYING == playstatus) break;
        sleep(1);
    }
    CPPUNIT_ASSERT(HMI_PBS_PLAYING == playstatus);

    tNowShowing nowShowing;
    ret = LocalSPM::GetPictureViewer().GetNowShowing(OUT nowShowing);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(listID == nowShowing.listID);
    CPPUNIT_ASSERT(!strcmp("/albumart/gif.gif", nowShowing.object.fileName));
    CPPUNIT_ASSERT(!strcmp("/albumart/Nations_256.jpg",nowShowing.nextFile));

    /*wait for slide show to skip tp next image*/
    sleep(LocalSPM::GetDataProvider().SlideShowTimeInterval()/1000 + 1);

    ret = LocalSPM::GetPictureViewer().GetNowShowing(OUT nowShowing);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    CPPUNIT_ASSERT(!strcmp("/albumart/Nations_256.jpg", nowShowing.object.fileName));
    CPPUNIT_ASSERT(!strcmp("/albumart/png.png",nowShowing.nextFile));

}

void PictureManagerTest::PlaybackActionNext()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    tNowShowing lastShowing;
    ret = LocalSPM::GetPictureViewer().GetNowShowing(OUT lastShowing);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);


    tNextPrevSkipCount steps = 1;
    ret = LocalSPM::GetPictureViewer().RequestSlideshowAction(PBA_NEXT, IN steps);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    // test result
    tNowShowing nowShowing;
    for(int sec=30; sec; sec--) {
        ret = LocalSPM::GetPictureViewer().GetNowShowing(OUT nowShowing);
        CPPUNIT_ASSERT(MP_NO_ERROR == ret);
        if (lastShowing.listID == nowShowing.listID &&
            lastShowing.object.objectID != nowShowing.object.objectID &&
            !strcmp(lastShowing.nextFile, nowShowing.object.fileName)) break;
        sleep(1);
    }
    CPPUNIT_ASSERT(lastShowing.listID == nowShowing.listID);
    CPPUNIT_ASSERT(lastShowing.object.objectID != nowShowing.object.objectID);
    CPPUNIT_ASSERT(!strcmp(lastShowing.nextFile, nowShowing.object.fileName));
}

void PictureManagerTest::PlaybackActionPrev()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    tNowShowing lastShowing;
    ret = LocalSPM::GetPictureViewer().GetNowShowing(OUT lastShowing);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    tNextPrevSkipCount steps = 1;
    ret = LocalSPM::GetPictureViewer().RequestSlideshowAction(PBA_PREV, IN steps);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    // test result
    tNowShowing nowShowing;
    for(int sec=30; sec; sec--) {
        ret = LocalSPM::GetPictureViewer().GetNowShowing(OUT nowShowing);
        CPPUNIT_ASSERT(MP_NO_ERROR == ret);
        if (lastShowing.listID == nowShowing.listID &&
            lastShowing.object.objectID != nowShowing.object.objectID &&
            !strcmp(lastShowing.object.fileName, nowShowing.nextFile)) break;
        sleep(1);
    }
    CPPUNIT_ASSERT(lastShowing.listID == nowShowing.listID);
    CPPUNIT_ASSERT(lastShowing.object.objectID != nowShowing.object.objectID);
    CPPUNIT_ASSERT(!strcmp(lastShowing.object.fileName, nowShowing.nextFile));
}


void PictureManagerTest::PlaybackActionPause()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Call SendPlaybackAction(PAUSE) */
    ret = LocalSPM::GetPictureViewer().RequestSlideshowAction(PBA_PAUSE);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    // test result
    tHMIPlaybackState playstatus;
    for(int sec=30; sec; sec--) {
        ret = LocalSPM::GetPictureViewer().GetSlideshowState(OUT playstatus);
        CPPUNIT_ASSERT(MP_NO_ERROR == ret);
        if (HMI_PBS_PAUSED == playstatus) break;
        sleep(1);
    }
    CPPUNIT_ASSERT(HMI_PBS_PAUSED == playstatus);
}

void PictureManagerTest::PlaybackActionNextOnPaused()
{
    ENTRY
    PlaybackActionNext();
}

void PictureManagerTest::PlaybackActionPrevOnPaused()
{
    ENTRY
    PlaybackActionPrev();
}

void PictureManagerTest::PlaybackActionPlay()
{
    ENTRY
    tResult ret = MP_NO_ERROR;


    ret = LocalSPM::GetPictureViewer().RequestSlideshowAction(PBA_PLAY);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    // test result
    tHMIPlaybackState playstatus;
    for(int sec=30; sec; sec--) {
        ret = LocalSPM::GetPictureViewer().GetSlideshowState(OUT playstatus);
        CPPUNIT_ASSERT(MP_NO_ERROR == ret);
        if (HMI_PBS_PLAYING == playstatus) break;
        sleep(1);
    }
    CPPUNIT_ASSERT(HMI_PBS_PLAYING == playstatus);
}

void PictureManagerTest::PlaybackActionStop()
{
    ENTRY
    tResult ret = MP_NO_ERROR;


    ret = LocalSPM::GetPictureViewer().RequestSlideshowAction(PBA_STOP);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    // test result
    tHMIPlaybackState playstatus;
    for(int sec=30; sec; sec--) {
        ret = LocalSPM::GetPictureViewer().GetSlideshowState(OUT playstatus);
        CPPUNIT_ASSERT(MP_NO_ERROR == ret);
        if (HMI_PBS_STOPPED == playstatus) break;
        sleep(1);
    }
    CPPUNIT_ASSERT(HMI_PBS_STOPPED == playstatus);
}

void PictureManagerTest::PlaybackActionPlayOnStop()
{
    ENTRY
    PlaybackActionPlay();
}


void PictureManagerTest::PlaybackActionStopOnPaused()
{
    ENTRY

    PlaybackActionPause();
    PlaybackActionStop();
}











