#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_INTERFACE
#ifdef TARGET_BUILD
#include "trcGenProj/Header/OutputWrapper.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_INTERFACE
#endif
#endif

#include "FunctionTracer.h"
#include "VarTrace.h"
#include "LocalSPM.h"

#ifndef TARGET_BUILD_GEN3
/***************************************************************************
** Authentication CP functions
***************************************************************************/

/***************************************************************************
** FUNCTION:  tS32  AuthenticationInit(void)
***************************************************************************/
extern "C" tS32 AuthenticationInit(void) //finished: 100%
{
    ENTRY
    return LocalSPM::GetOutputWrapper().AuthenticationInit(TRUE);
}

/***************************************************************************
** FUNCTION:    tS32  AuthenticationDeinit(void)
***************************************************************************/
extern "C" tS32 AuthenticationDeinit(void) //finished: 100�%
{
    ENTRY
    return LocalSPM::GetOutputWrapper().AuthenticationInit(FALSE);
}


/***************************************************************************
** FUNCTION:    void AuthenticationGetCertificate(tU16 *CertLength, tU8 *...
***************************************************************************/
extern "C" void AuthenticationGetCertificate(tU16 *CertLength, tU8 *CertData) //finished: 100%
{
    ENTRY
    LocalSPM::GetOutputWrapper().AccessoryCertificate(CertLength,CertData);
}


/***************************************************************************
** FUNCTION:    tS32  AuthenticationSetCertificate(tU16 certLen, tU8 *certData)
***************************************************************************/
extern "C" tS32 AuthenticationSetCertificate(tU16 certLen, tU8 *certData) //finished: 100%
{
    ENTRY
    return LocalSPM::GetOutputWrapper().IPodCertificate(certLen, certData);
}


/***************************************************************************
** FUNCTION:    tS32 AuthenticationGetSignatureData(const tU8  *Response...
***************************************************************************/
extern "C" tS32 AuthenticationGetSignatureData(const tU8  *ResponseBuffer, tU16 *SignatureDataLength, tU8 *SignatureData) //finished: 100%
{
    ENTRY
    return LocalSPM::GetOutputWrapper().GenSignature(ResponseBuffer, SignatureDataLength, SignatureData);
}


/***************************************************************************
** FUNCTION:    S32  AuthenticationGetSignature(U16 sigDataLen, U8 *sigData)
***************************************************************************/
extern "C" tS32 AuthenticationGetSignature(tU16 sigDataLen, tU8 *sigData) //finished: 100%
{
    ENTRY
    return LocalSPM::GetOutputWrapper().SetSignature(sigDataLen, sigData);
}


/***************************************************************************
** FUNCTION:    S32  AuthenticationGetChallengeData(U16 *Challe...
***************************************************************************/
extern "C" tS32 AuthenticationGetChallengeData(tU16 *ChallengeDataLength, tU8 *ChallengeData) //finished: 100%
{
    ENTRY
    return LocalSPM::GetOutputWrapper().GetChallenge(ChallengeDataLength, ChallengeData);
}

/***************************************************************************
** FUNCTION:    tS32  AuthenticationGetDeviceID (tU32 *AuthenticationDeviceID)
***************************************************************************/
extern "C" tS32 AuthenticationGetDeviceID (tU32 *AuthenticationDeviceID) //finished: 100%
{
    ENTRY
    return LocalSPM::GetOutputWrapper().DeviceID((tU32 *)AuthenticationDeviceID);
}


/***************************************************************************
** FUNCTION:    tS32  AuthenticationGetFirmwareVersion (tU8 *majorVer, tU8 *...
***************************************************************************/
extern "C" tS32 AuthenticationGetFirmwareVersion (tU8 *majorVer, tU8 *minorVer) //finished: 100%
{
    ENTRY
    return LocalSPM::GetOutputWrapper().FirmwareVersion(majorVer, minorVer);
}

/***************************************************************************
** FUNCTION:    S32  AuthenticationSelftest (U8 *majorVer, U8 *minorVer)
***************************************************************************/
extern "C" tS32 AuthenticationGetProtocolVersion (tU8 *majorVer, tU8 *minorVer) //finished: 100%
{
    ENTRY
    return LocalSPM::GetOutputWrapper().AuthenticationProtocolVersion(majorVer, minorVer);
}

/***************************************************************************
** FUNCTION:    tS32  AuthenticationSelftest (tU8 *certificate, tU8 *privat...
***************************************************************************/
extern "C" tS32  AuthenticationSelftest (tU8 *certificate, tU8 *private_key, tU8 *ram_check, tU8 *checksum) //finished: 100%
{
    ENTRY
    return LocalSPM::GetOutputWrapper().IPodAuthenticationSelftest(certificate, private_key, ram_check, checksum);
}

#endif //! TARGET_BUILD_GEN3

tResult OutputWrapper::OnFocusAppChanges(const tDeviceID deviceID, const tAppName focusAppName) //Roadmap 13008
{
    ENTRY
    VARTRACE(deviceID)
    VARTRACE(focusAppName)

    tResult res;
    vector<tApplTableEntry> appTable;

    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    if (res) return res;

    VARTRACE(deviceInfo.diPOCaps);
    tAppName appName = {0};

    //source to mediaplayer (default) in case of CarPlay device
    if(!IsDiPOCapability_HostMode(deviceInfo.diPOCaps)) {
        strncpy_r(appName, focusAppName, sizeof(appName));
    }

    if(IsDiPOCapability_HostMode(deviceInfo.diPOCaps) && !LocalSPM::GetDataProvider().iPodControlIAP2CarPlayModeEnabled() ) {
        ETG_TRACE_USR3(("OnFocusAppChanges ignored for DiPO mode"));
    } else {
        // get project dependent table
        res = LocalSPM::GetDataProvider().GetApplicationTable(OUT appTable, IN deviceInfo.deviceType);
        if (res) return res;

        vector<tApplTableEntry>::iterator it;
        for(it = appTable.begin(); it < appTable.end(); it++)
        {
            if(0 == strncmp(it->appName, appName, strlen_r(it->appName))) // application found in table
            {
                VARTRACE(it->appName);
                VARTRACE(it->source);
                VARTRACE(currentSource);
                VARTRACE(currentSourceActive);
                if (it->source != currentSource || !currentSourceActive || ((LocalSPM::GetDataProvider().CheckActiveDeviceForAVActivation()) && (audioAllocatedDevice != deviceID))) //GMMY17-12999 //CAFI06-1819,PSARCCB-5691
                {
                    // ask AVManagement to activate source
                    RequestAVActivation(IN 1, LC_MAIN_AUDIO, IN it->source, deviceID);
                }
                break;
            }
        }
    }
    return MP_NO_ERROR;
}

tResult OutputWrapper::SetCurrentSource(const tSource source)  //Roadmap 13008
{
    ENTRY
    VARTRACE(source)
    currentSource = source;
    return MP_NO_ERROR;
}

tResult OutputWrapper::SetCurrentSourceActive(const tBool active)
{
    ENTRY;
    VARTRACE(active);
    currentSourceActive = active;
    return MP_NO_ERROR;
}

tResult OutputWrapper::RequestMuteState(const tMuteState muteState, const tRampType /*rampType*/)  //Roadmap 13018
{
    ENTRY
    VARTRACE(muteState)

    /* Fake AVManager response: Send expected mute state to DeviceDispatcher immediately */
    LocalSPM::GetDeviceDispatcher().SendMuteStatus(IN muteState);

    return MP_NO_ERROR;
}

tResult OutputWrapper::GetCurrentSource(tSource &source)  //Roadmap 13031
{
    ENTRY
    source = currentSource;
    return MP_NO_ERROR;
}

tResult OutputWrapper::SetAudioAllocatedDevice(const tDeviceID deviceID)
{
    ENTRY
    VARTRACE(deviceID)
    audioAllocatedDevice = deviceID;
    return MP_NO_ERROR;
}

