#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/ListControlTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif
#include "FunctionTracer.h"
#include "VarTrace.h"

#include <errno.h>
#include <memory.h>
#include <ListControl.h>
#include <unistd.h>


#include "ListControlTest.h"
#include <FunctionTracer.h>
#include "LocalSPM.h"
#include "CppUnitDefinitions.h"
#include <sortlib.h>


#undef USE_CHECK_FAKE_DBENTRY_AFTERWRITE


/*lint -save -e1401 */

static tListID mListID;
static tListID mFileListID;

void ListControlTest::setUp()
{
    pthread_mutex_init(&mutex,NULL);
    pthread_cond_init(&condition,NULL);
    ticks.begin();
}

void ListControlTest::tearDown()
{
    ticks.elapsed();
    pthread_mutex_destroy(&mutex);
    pthread_cond_destroy(&condition);
}

ListControlTest::ListControlTest()
{
    mListID = 0;
    mFileListID = 0;
}

/**********************************************************************
 * Test cases
 *********************************************************************/

void ListControlTest::InitTestsuite()
{
    ENTRY
    tResult res;

    ETG_TRACE_USR2(("%s", __PRETTY_FUNCTION__));

    /* recreate the test database */
    res = LocalSPM::GetDataProvider().RecreateTestDatabase(true, true);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::CreateMediaPlayerIndexedListForTests()
{
    ENTRY_TEST

    tResult res;
    tListSize listSize;
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID;

    // set the filter tags
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    // get the usb device
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    // call create list
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT mListID,
            OUT listSize,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSize == 31);

    /* set a specific song as active */
    tMediaObject mediaObject;
    res = LocalSPM::GetListControl().SetMediaObject(OUT mediaObject, IN mListID, IN 24);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::CreatePlayList_4Tags()
{
    ENTRY_TEST

    tResult res;
    tListID listID;
    tStreaming streaming = FALSE;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID;

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    // set the filter tags
    tag1.genre = 0x0;
    tag2.artist = 24;   //Herbert Grönemeyer
    tag3.tag = 0;
    tag4.album = 25;    //Bleibt Alles Anders

    // call create list
    res = LocalSPM::GetListControl().CreatePlayList(OUT listID, LTY_ARTIST_ALBUM_SONG,
            IN streaming, IN tag1, IN tag2, IN tag3, IN tag4, PC_NO_REPEAT, IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::CreatePlayList_DoNextCheckGetPosition()
{
    ENTRY_TEST


    tResult res;
    tStreaming streaming = false;
    tFilterTag1 tag1 = { 0 };
    tFilterTag2 tag2 = { 0 };
    tFilterTag3 tag3 = { 0 };
    tFilterTag4 tag4 = { 0 };
    tListID listID;
    tListSize listSize;
    vector<tMediaObject> mediaObjectVector;
    tDeviceID deviceID;

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* create a album list */
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_ALBUM,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    if(LocalSPM::GetDataProvider().DBUnifiedSchema())
    {
        CPPUNIT_ASSERT(listSize == 4);
    }
    else
    {
        CPPUNIT_ASSERT(listSize == 5);
    }

    /* request slice from the album list */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            IN 0,
            IN listSize);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    if(LocalSPM::GetDataProvider().DBUnifiedSchema())
    {
        CPPUNIT_ASSERT(mediaObjectVector.size() == 4);
        CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField4, "Garbage"));
        tag4.album = mediaObjectVector[3].MetadataTag4;
    }
    else
    {
        CPPUNIT_ASSERT(mediaObjectVector.size() == 5);
        CPPUNIT_ASSERT(!strcmp(mediaObjectVector[4].MetadataField4, "Garbage"));
        tag4.album = mediaObjectVector[4].MetadataTag4;
    }

    /* delete album list */
    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);


    // create a song list
    tListID listID2;
    vector<tMediaObject> mediaObjectVector2;
    res = LocalSPM::GetListControl().CreatePlayList(
            OUT listID2,
            LTY_ALBUM_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            PC_NO_REPEAT,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* get a valid object id */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector2,
            IN listID2,
            IN 0,
            IN 3);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(mediaObjectVector2.size() == 3);

    /* set the now playing object */
    tPosition position;
    res = LocalSPM::GetListControl().UpdateNowPlaying(OUT position, IN listID2, IN mediaObjectVector2[2].objectID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(position == 2);

    res = LocalSPM::GetListControl().ReleaseList(IN listID2);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::CreatePlayList_Object()
{
    ENTRY_TEST

    tResult res;

    /* get the first contents */
    vector<tMediaObject> mediaObjectVector;
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN mListID, 0, 1);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(mediaObjectVector.size() > 0);
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField4, "Garbage"));

    /* Play object ID */
    tObjectID objectID = mediaObjectVector[0].objectID; // must be a song tag

    // call create list
    tListID listID2;
    res = LocalSPM::GetListControl().CreatePlayList(OUT listID2, IN objectID, IN CTY_SONG, IN PC_NO_REPEAT, IN MY_MEDIA);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().ReleaseList(IN listID2);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::StoreLastPlayed()
{
    ENTRY_TEST

    tResult res = 0;
    tMediaObject lastMediaObject;

    /* Get last media object */
    InitMediaObject(OUT lastMediaObject);
    res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT lastMediaObject, IN mListID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* Store the last mode */
    tPosition position;
    res = LocalSPM::GetListControl().UpdateNowPlaying(OUT position, IN mListID, IN lastMediaObject.objectID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().StoreLastPlayedList(IN mListID, IN 4321);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* Get deviceID via listInfo */
    tListInfo listInfo;
    tBoolean withListSize = false;
    res = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN mListID, IN withListSize);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* Get the last mode info */
    tListID listID;
    tIndex listIndex;
    tPlaytime playtime;
    tMediaObject currentMediaObject;
    res = LocalSPM::GetListControl().GetLastPlayedList(OUT listID, OUT listIndex, OUT playtime, IN listInfo.deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(playtime == 4321);

    /* Get current media object */
    InitMediaObject(OUT currentMediaObject);
    res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT currentMediaObject, IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(lastMediaObject.objectID == currentMediaObject.objectID);

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::SetMediaObject()
{
    ENTRY

    ETG_TRACE_USR2(("%s", __PRETTY_FUNCTION__));

    tResult res;
    tMediaObject mediaObject;

    // just get the current media object and set the elapsedPlaytime, do net set it as current
    InitMediaObject(OUT mediaObject);
    res = LocalSPM::GetListControl().SetMediaObject(OUT mediaObject, IN mListID, IN INDEX_LAST_ACTIVE_OBJECT);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(strcmp(mediaObject.fileName, "/music/Garbage/Garbage-Garbage-08-Stupid_Girl.mp3") == 0);

    // set the current media object
    InitMediaObject(OUT mediaObject);
    res = LocalSPM::GetListControl().SetMediaObject(OUT mediaObject, IN mListID, IN 0);
    CPPUNIT_ASSERT(strcmp(mediaObject.fileName, "/music/Garbage/Garbage-Garbage-06-A_Stroke_of_Luck.mp3") == 0);

    // set the current media object
    InitMediaObject(OUT mediaObject);
    res = LocalSPM::GetListControl().SetMediaObject(OUT mediaObject, IN mListID, IN 2);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(strcmp(mediaObject.fileName, "/music/Mando_Diao-Bring_Em_In-RETAIL-2002-EVIGHET/11-bring_em_in-evighet.mp3") == 0);
}

void ListControlTest::GetObjectID()
{
    ENTRY_TEST

    tResult res;
    tObjectID objectID;
    tURL url;
    tDeviceID deviceID;
    tMediaObject mediaObject;

    /* set the current media object */
    InitMediaObject(OUT mediaObject);
    res = LocalSPM::GetListControl().SetMediaObject(OUT mediaObject, IN mListID, IN 2);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(strcmp(mediaObject.fileName, "/music/Mando_Diao-Bring_Em_In-RETAIL-2002-EVIGHET/11-bring_em_in-evighet.mp3") == 0);

    /* set test parameter */
    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    strncpy_r(OUT url, "/music/Mando_Diao-Bring_Em_In-RETAIL-2002-EVIGHET/11-bring_em_in-evighet.mp3", IN sizeof(url));

    /* get the object id */
    res = LocalSPM::GetDBManager().GetObjectID(OUT objectID, IN deviceID, IN url);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* compare the object id's */
    CPPUNIT_ASSERT(objectID == mediaObject.objectID);
}

void ListControlTest::CheckMediaObject()
{
    ENTRY_TEST

    tResult res;
    tMediaObjectInfo mediaObjectInfo;

    res = LocalSPM::GetListControl().CheckMediaObject(OUT mediaObjectInfo, IN mListID, 2, 4321);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    CPPUNIT_ASSERT(mediaObjectInfo.ObjectValid == 1);
    CPPUNIT_ASSERT(mediaObjectInfo.ObjectInvalid == 0);
    CPPUNIT_ASSERT(mediaObjectInfo.ListInvalid == 0);
    CPPUNIT_ASSERT(mediaObjectInfo.PositionInvalid == 0);
    CPPUNIT_ASSERT(mediaObjectInfo.GeneralError == 0);
}

void ListControlTest::GetCurrentMediaObject()
{
    ENTRY_TEST

    tResult res;
    tMediaObject mediaObject;

    InitMediaObject(OUT mediaObject);
    res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT mediaObject, IN mListID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(strcmp(mediaObject.fileName, "/music/Mando_Diao-Bring_Em_In-RETAIL-2002-EVIGHET/11-bring_em_in-evighet.mp3") == 0);
}

void ListControlTest::GetPositionInList()
{
    ENTRY_TEST

    tResult res;
    tMediaObject mediaObject;
    tPosition position;

    InitMediaObject(OUT mediaObject);
    res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT mediaObject, IN mListID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().GetPositionInList(OUT position, IN mListID, IN mediaObject.objectID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(position == 2);
}

void ListControlTest::NextMediaObject()
{
    ENTRY_TEST

    tResult res;
    tMediaObject mediaObject;

    tListID localListID = mListID;
    res = LocalSPM::GetListControl().Next(INOUT localListID, IN 1 /*stepCount*/, IN true /*isHMIRequest*/);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    InitMediaObject(OUT mediaObject);
    res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT mediaObject, IN localListID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(strcmp(mediaObject.fileName, "/music/Grönemeyer_-_Anders/Herbert_Grönemeyer_-_Bleibt_Alles_Anders.mp3") == 0);
}

void ListControlTest::PrevMediaObject()
{
    ENTRY_TEST

    tResult res;
    tMediaObject mediaObject;

    tListID localListID = mListID;
    res = LocalSPM::GetListControl().Prev(INOUT localListID, IN 1 /*stepCount*/, IN true /*isHMIRequest*/);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    InitMediaObject(OUT mediaObject);
    res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT mediaObject, IN localListID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(strcmp(mediaObject.fileName, "/music/Mando_Diao-Bring_Em_In-RETAIL-2002-EVIGHET/11-bring_em_in-evighet.mp3") == 0);
}

void ListControlTest::ReleaseList()
{
    ENTRY_TEST

    tResult res;

    /* Release global indexed list */
    res = LocalSPM::GetListControl().ReleaseList(IN mListID, true/*force*/);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    tListInfo listInfo;
    tBoolean withListSize = false;
    res = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN mListID, IN withListSize);
    CPPUNIT_ASSERT(res != MP_NO_ERROR);
}

void ListControlTest::ReleaseLastModeFileList()
{
    ENTRY_TEST

    tResult res = 0;

    /* Get last media object */
    tMediaObject lastMediaObject;
    InitMediaObject(OUT lastMediaObject);
    res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT lastMediaObject, IN mFileListID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* Store the last mode */
    tPosition position;
    res = LocalSPM::GetListControl().UpdateNowPlaying(OUT position, IN mFileListID, IN lastMediaObject.objectID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().StoreLastPlayedList(IN mFileListID, IN 9999);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* Get deviceID via listInfo */
    tListInfo listInfo;
    tBoolean withListSize = false;
    res = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN mFileListID, IN withListSize);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* Release global file list */
    res = LocalSPM::GetListControl().ReleaseList(IN mFileListID, true/*force*/);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* Get the last mode info twice */
    tListID listID1;
    tIndex listIndex1;
    tPlaytime playtime1;
    res = LocalSPM::GetListControl().GetLastPlayedList(OUT listID1, OUT listIndex1, OUT playtime1, IN IN listInfo.deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listID1 != LIST_ID_NONE);
    CPPUNIT_ASSERT(playtime1 == 9999);
    CPPUNIT_ASSERT(listIndex1 == position);

    tListID listID2;
    tIndex listIndex2;
    tPlaytime playtime2;
    res = LocalSPM::GetListControl().GetLastPlayedList(OUT listID2, OUT listIndex2, OUT playtime2, IN IN listInfo.deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listID2 != LIST_ID_NONE);
    CPPUNIT_ASSERT(playtime2 == 9999);
    CPPUNIT_ASSERT(listIndex2 == position);

    /* Release of list should not work because create counter of list is >1 */
    res = LocalSPM::GetListControl().ReleaseList(IN listID1);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listID1, IN withListSize);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* Release of list should  work now */
    res = LocalSPM::GetListControl().ReleaseList(IN listID2);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listID2, IN withListSize);
    CPPUNIT_ASSERT(res != MP_NO_ERROR);
}

void ListControlTest::RequestListInformation()
{
    ENTRY_TEST

    tResult res;
    tListType listType;
    tListID parentListID = LIST_ID_NONE;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tPosition position = 0;
    tListSize listSize = 0;

    res = LocalSPM::GetListControl().RequestListInformation(
            OUT listType,
            OUT parentListID,
            OUT deviceID,
            OUT position,
            OUT listSize,
            IN mListID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listType == LTY_SONG);
    CPPUNIT_ASSERT(listSize == 31);
    CPPUNIT_ASSERT(position == 0);

    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(strncmp(deviceInfo.deviceName, "USB", strlen_r("USB")) == 0);
}

void ListControlTest::Quicksearch_Itemfound()
{
    ENTRY_TEST

    tResult res;
    tPosition outposition=0;
    tSearchResult quicksearchresult= ENDOFLIST;
    tPosition startposition=0;
    tSearchString searchstring;
    memset(searchstring,0,sizeof(searchstring));
    strcpy(searchstring,"M");
    ETG_TRACE_USR3(("ListControlTest::QuickSearch searchstring:%s",  searchstring));
    res = LocalSPM::GetListControl().Quicksearch(OUT outposition ,OUT quicksearchresult , IN mListID, IN startposition , IN searchstring);
    ETG_TRACE_USR3(("ListControlTest::QuickSearchFOUND Quicksearchresult :%u , outposition:%u",  quicksearchresult , outposition));
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(FOUND == quicksearchresult);
}
void ListControlTest::Quicksearch_Itemnotfound_following()
{
    ENTRY_TEST

    tResult res;
    tPosition outposition=0;
    tSearchResult quicksearchresult= ENDOFLIST;
    tPosition startposition=0;
    tSearchString searchstring;
    memset(searchstring,0,sizeof(searchstring));
    strcpy(searchstring,"I");
    ETG_TRACE_USR3(("ListControlTest::QuickSearch searchstring:%s",  searchstring));
    res = LocalSPM::GetListControl().Quicksearch(OUT outposition ,OUT quicksearchresult , IN mListID, IN startposition , IN searchstring);
    ETG_TRACE_USR3(("ListControlTest::QuickSearchFOLLOWING Quicksearchresult :%u,outposition : %u",  quicksearchresult,outposition));
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(quicksearchresult == FOLLOWING);
}
void ListControlTest::Quicksearch_Itemnotfound_endoflist()
{
    ENTRY_TEST

    tResult res;
    tPosition outposition=0;
    tSearchResult quicksearchresult= ENDOFLIST;
    tPosition startposition=0;
    tSearchString searchstring;
    memset(searchstring,0,sizeof(searchstring));
    strcpy(searchstring,"Z");
    ETG_TRACE_USR3(("ListControlTest::QuickSearch searchstring:%s",  searchstring));
    res = LocalSPM::GetListControl().Quicksearch(OUT outposition ,OUT quicksearchresult , IN mListID, IN startposition , IN searchstring);
    ETG_TRACE_USR3(("ListControlTest::QuickSearchEOL Quicksearchresult :%u , outposition :%u",  quicksearchresult,outposition));
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(quicksearchresult == ENDOFLIST);
}

void ListControlTest::Quicksearch_Unsupported_list()
{
    ENTRY_TEST

    tResult res;
    tPosition outposition=0;
    tSearchResult quicksearchresult= ENDOFLIST;
    tPosition startposition=0;
    tSearchString searchstring;
    memset(searchstring,0,sizeof(searchstring));
    strcpy(searchstring,"U");
    res = LocalSPM::GetListControl().Quicksearch(OUT outposition ,OUT quicksearchresult , IN mListID, IN startposition , IN searchstring);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(quicksearchresult != NOTSUPPORTED);
}

void ListControlTest::Quicksearch_File_list()
{
    ENTRY_TEST

    tResult res;
    tPosition outposition=0;
    tSearchResult quicksearchresult= ENDOFLIST;

#if 0
    tListID fileListID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPosition position;
    tPath path;
    tDeviceID deviceID; // USB device

    res = LocalSPM::GetListControl().CreateMediaPlayerFileList(
               OUT fileListID,
               OUT listSize,
               OUT numberOfMediaObjects,
               OUT numberOfPlayLists,
               OUT numberOfFolders,
               OUT position,
               IN path,
               IN deviceID);
       CPPUNIT_ASSERT(res == MP_NO_ERROR);
       CPPUNIT_ASSERT(fileListID != LIST_ID_NONE);

       ETG_TRACE_USR3(("ListControlTest::QuickSearchFILELIST listSize :%u , numberOfMediaObjects:%u,mFileListID:%d",  listSize , numberOfMediaObjects,fileListID));
       ETG_TRACE_USR3(("ListControlTest::QuickSearchFILELIST numberOfFolders :%u , numberOfPlayLists:%u",  numberOfFolders , numberOfPlayLists));
#endif
    tPosition startposition=0;
    tSearchString searchstring;
    memset(searchstring,0,sizeof(searchstring));
    strcpy(searchstring,"A");
    ETG_TRACE_USR3(("ListControlTest::QuickSearch searchstring:%s",  searchstring));

    res = LocalSPM::GetListControl().Quicksearch(OUT outposition ,OUT quicksearchresult , IN mFileListID, IN startposition , IN searchstring);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    ETG_TRACE_USR3(("ListControlTest::QuickSearchFILELIST Quicksearchresult :%u , outposition:%u",  quicksearchresult , outposition));
    CPPUNIT_ASSERT(FOUND == quicksearchresult);

    startposition=2;
    strcpy(searchstring,"P");
    ETG_TRACE_USR3(("ListControlTest::QuickSearch searchstring:%s",  searchstring));

    res = LocalSPM::GetListControl().Quicksearch(OUT outposition ,OUT quicksearchresult , IN mFileListID, IN startposition , IN searchstring);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    ETG_TRACE_USR3(("ListControlTest::QuickSearchFILELIST Quicksearchresult :%u , outposition:%u",  quicksearchresult , outposition));
    CPPUNIT_ASSERT(FOUND == quicksearchresult);

    startposition=2;
    strcpy(searchstring,"G");
    ETG_TRACE_USR3(("ListControlTest::QuickSearch searchstring:%s",  searchstring));

    res = LocalSPM::GetListControl().Quicksearch(OUT outposition ,OUT quicksearchresult , IN mFileListID, IN startposition , IN searchstring);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    ETG_TRACE_USR3(("ListControlTest::QuickSearchFILELIST Quicksearchresult :%u , outposition:%u",  quicksearchresult , outposition));
    CPPUNIT_ASSERT(FOUND == quicksearchresult);

    startposition=2;
    strcpy(searchstring,"U");
    ETG_TRACE_USR3(("ListControlTest::QuickSearch searchstring:%s",  searchstring));

    res = LocalSPM::GetListControl().Quicksearch(OUT outposition ,OUT quicksearchresult , IN mFileListID, IN startposition , IN searchstring);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    ETG_TRACE_USR3(("ListControlTest::QuickSearchFILELIST Quicksearchresult :%u , outposition:%u",  quicksearchresult , outposition));
    CPPUNIT_ASSERT(FOUND != quicksearchresult);

}

void ListControlTest::SearchKeyboardMediaPlayerList()
{
    ENTRY_TEST

    vector<tSearchKeyboard> searchKeyboardList;
    tResult res;

    res = LocalSPM::GetListControl().SearchKeyboardMediaPlayerList(OUT searchKeyboardList, IN mListID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    CPPUNIT_ASSERT(searchKeyboardList['A' - 'A'+1].available == true); //lint !e778
    CPPUNIT_ASSERT(searchKeyboardList['B' - 'A'+1].available == true);
    CPPUNIT_ASSERT(searchKeyboardList['D' - 'A'+1].available == true);
    CPPUNIT_ASSERT(searchKeyboardList['F' - 'A'+1].available == true);
    CPPUNIT_ASSERT(searchKeyboardList['L' - 'A'+1].available == true);
    CPPUNIT_ASSERT(searchKeyboardList['M' - 'A'+1].available == true);
    CPPUNIT_ASSERT(searchKeyboardList['N' - 'A'+1].available == true);
    CPPUNIT_ASSERT(searchKeyboardList['O' - 'A'+1].available == true);
    CPPUNIT_ASSERT(searchKeyboardList['P' - 'A'+1].available == true);
    CPPUNIT_ASSERT(searchKeyboardList['Q' - 'A'+1].available == true);
    CPPUNIT_ASSERT(searchKeyboardList['S' - 'A'+1].available == true);
    CPPUNIT_ASSERT(searchKeyboardList['T' - 'A'+1].available == true);
    CPPUNIT_ASSERT(searchKeyboardList['V' - 'A'+1].available == true);
}

void ListControlTest::RequestMediaPlayerIndexedListSlice()
{
    ENTRY_TEST

    tResult res;
    vector<tMediaObject> mediaObjectVector;

    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN mListID,
            4,
            3);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(mediaObjectVector.size() > 0);
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField1, "Alternative"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField1, "German Pop"));
}

void ListControlTest::RequestMediaPlayerIndexedListSliceMoreThanAvail()
{
    ENTRY_TEST

    tResult res;
    vector<tMediaObject> mediaObjectVector;

    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN mListID,
            4,
            100);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(mediaObjectVector.size() == 27);
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField1, "Alternative"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField1, "German Pop"));
}

void ListControlTest::RequestMediaPlayerIndexedUUIDListSlice()
{
    ENTRY_TEST

    tResult res;
    tListSize maxListSize = LocalSPM::GetDataProvider().LimitNumberObjectsPerDevice();
    /* Vector of tU64 (batchPlaybackListPtr) will be deleted in specific device control (iPodControl) */
    tBatchPlaybackList *batchPlaybackListPtr = new tBatchPlaybackList;

    CPPUNIT_ASSERT(batchPlaybackListPtr != NULL);

    if(batchPlaybackListPtr) {
        /* get all UUID's for the list */
        res = LocalSPM::GetListControl().RequestMediaPlayerIndexedUUIDListSlice(OUT batchPlaybackListPtr, IN mListID, 0, maxListSize);
        CPPUNIT_ASSERT(res == MP_NO_ERROR);
        CPPUNIT_ASSERT(batchPlaybackListPtr->size() > 0);
        delete batchPlaybackListPtr;
    }
}

void ListControlTest::RequestMediaPlayerIndexedListSlice_LTY_GENRE_ARTIST_ALBUM()
{
    ENTRY_TEST

    tResult res;
    tListID listID;
    tListSize listSize;
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID;
    vector<tMediaObject> mediaObjectVector;

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* create a list to get the test filter tag id's */
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_ARTIST,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* search for Herbert */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            0,
            20);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    tUInt row;
    for(row = 0; row < mediaObjectVector.size(); row++) {
        if (!strcmp(mediaObjectVector[row].MetadataField2, "Herbert Grönemeyer")) break;
    }
    CPPUNIT_ASSERT(row < mediaObjectVector.size());

    // set the filter tags
    tag1.genre = mediaObjectVector[row].MetadataTag1;  //German Pop
    tag2.artist = mediaObjectVector[row].MetadataTag2; //Herbert Grönemeyer
    tag3.tag = 0;
    tag4.album = 0x0;

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* create a list with the tags found before */
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_GENRE_ARTIST_ALBUM,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSize == 1);

    /* second ask for all albums */
    mediaObjectVector.clear();
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            0,
            5);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(mediaObjectVector.size() == 1);
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField1, "German Pop"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField2, "Herbert Grönemeyer"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField4, "Bleibt Alles Anders"));

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::RequestMediaPlayerIndexedListSlice_LTY_GENRE()
{
    ENTRY_TEST

    tResult res;
    tListID listID;
    tListSize listSize;
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID;
    vector<tMediaObject> mediaObjectVector;

    // set the filter tags
    tag1.tag = 0;
    tag2.artist = 0x0;
    tag3.tag = 0;
    tag4.album = 0x0;

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* first create a list */
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_GENRE,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSize == 4);

    /* second ask for all albums */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            0,
            5);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(mediaObjectVector.size() == 4);
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField1, "Alternative"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField1, "German Pop"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField1, "Hip-Hop"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField1, "Rock"));

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::RequestMediaPlayerIndexedListSlice_LTY_ARTIST()
{
    ENTRY_TEST

    tResult res;
    tListID listID;
    tListSize listSize;
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID;
    vector<tMediaObject> mediaObjectVector;

    // set the filter tags
    tag1.tag = 0;
    tag2.artist = 0x0;
    tag3.tag = 0;
    tag4.album = 0x0;

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* first create a list */
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_ARTIST,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSize == 4);

    /* second ask for all albums */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            0,
            5);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(mediaObjectVector.size() == 4);

    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField1, "Alternative"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField2, "Garbage"));

    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField1, "German Pop"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField2, "Herbert Grönemeyer"));

    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField1, "Hip-Hop"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField2, "K'Naan"));

    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField1, "Rock"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField2, "Mando Diao"));

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::RequestMediaPlayerIndexedListSlice_LTY_ALBUM_UNKNOWN_ALBUMART()
{
    ENTRY_TEST

    tResult res;
    tListID listID;
    tListSize listSize;
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID;
    vector<tMediaObject> mediaObjectVector;

    // set the filter tags
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* create a list for all albums without album art entry */
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_ALBUM_UNKNOWN_ALBUMART,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSize == 4);

    /* ask for all albums */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            0,
            5);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(mediaObjectVector.size() == 4);
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField4, "2010 FIFA World Cup Anthem"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField4, "Bleibt Alles Anders"));
    CPPUNIT_ASSERT(!strcasecmp(mediaObjectVector[2].MetadataField4, "Bring Em IN"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField4, "Garbage"));

    /* store cover art path and thumbnail blob for first album */
    tAlbumArt coverArtPath;
    strncpy_r(OUT coverArtPath, IN "/var/opt/bosch/dynamic/media/coverart/dev01/2010 FIFA World Cup Anthem_280_280.png", IN sizeof(coverArtPath));
    const tU8 image[] = {0x12, 0x34, 0x56, 0x78, 0x90};
    tImageBlob thumbnailBlob;
    thumbnailBlob.imageSize = sizeof(image);
    thumbnailBlob.imageData = (tImageData)malloc(thumbnailBlob.imageSize);
    memcpy(thumbnailBlob.imageData, image, thumbnailBlob.imageSize);

    res = LocalSPM::GetDBManager().StoreAlbumArt(IN mediaObjectVector[0].deviceID, IN mediaObjectVector[0].MetadataTag4, IN mediaObjectVector[0].title, IN coverArtPath, IN thumbnailBlob, IN mediaObjectVector[0].dateTime);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    if (thumbnailBlob.imageData) free(thumbnailBlob.imageData);

    /* store no cover art path and thumbnail blob for last album */
    strncpy_r(OUT coverArtPath, IN "", IN sizeof(coverArtPath));
    thumbnailBlob.imageSize = 0;
    thumbnailBlob.imageData = NULL;

    res = LocalSPM::GetDBManager().StoreAlbumArt(IN mediaObjectVector[3].deviceID, IN mediaObjectVector[3].MetadataTag4, IN mediaObjectVector[3].title, IN "", IN thumbnailBlob, IN mediaObjectVector[3].dateTime);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* ask for all albums again */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            0,
            5);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(mediaObjectVector.size() == 2);
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField4, "Bleibt Alles Anders"));
    CPPUNIT_ASSERT(!strcasecmp(mediaObjectVector[1].MetadataField4, "Bring Em IN"));

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::GetPlaybackMode()
{
    ENTRY_TEST

    tResult res;
    tPlaybackMode pm;
    tDeviceID deviceID;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetDBManager().SetActiveDevice(IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().GetPlaybackMode(OUT pm);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::SetPlaybackMode()
{
    ENTRY_TEST

    tResult res;
    tPlaybackMode pm = PBM_NORMAL;
    tPlaybackMode oldPm;
    tDeviceID deviceID;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetDBManager().SetActiveDevice(IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    oldPm = (tPlaybackMode)-1;
    res = LocalSPM::GetListControl().GetPlaybackMode(OUT oldPm);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    switch(oldPm) {
    case PBM_NORMAL: pm = PBM_RANDOM; break;
    case PBM_RANDOM: pm = PBM_NORMAL; break;
    case PBM_INVALID:
        break;

    }

    res = LocalSPM::GetListControl().SetPlaybackMode(IN pm);
    // debug printf("SetPlaybackMode: res=%d\n", res); fflush(stdout);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    pm = (tPlaybackMode)-1;
    res = LocalSPM::GetListControl().GetPlaybackMode(OUT pm);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(pm != oldPm);

    /* reset playback mode to normal - shuffle tests will follow */
    res = LocalSPM::GetListControl().SetPlaybackMode(IN PBM_NORMAL);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::GetRepeatMode()
{
    ENTRY_TEST

    tResult res;
    tRepeatMode rm;
    tDeviceID deviceID;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetDBManager().SetActiveDevice(IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().GetRepeatMode(OUT rm);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::SetRepeatMode()
{
    ENTRY_TEST

    tResult res;
    tRepeatMode rm;
    tRepeatMode oldRm;
    tDeviceID deviceID;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetDBManager().SetActiveDevice(IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    oldRm = RPT_INVALID;
    res = LocalSPM::GetListControl().GetRepeatMode(OUT oldRm);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    switch(oldRm) {
    case RPT_NONE:               rm = RPT_ONE; break;
    case RPT_ONE:                rm = RPT_ALL; break;
    case RPT_LIST:
    case RPT_LIST_WITH_SUBLISTS:
    case RPT_ALL:
    default:                     rm = RPT_NONE; break;
    }

    res = LocalSPM::GetListControl().SetRepeatMode(rm);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    rm = RPT_INVALID;
    res = LocalSPM::GetListControl().GetRepeatMode(rm);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(rm != oldRm);
}

void ListControlTest::RepeatList()
{
    ENTRY_TEST

    tResult res;
    tDeviceID deviceID;
    tListID listID;
    tListSize listSize;
    tMediaObject mediaObject;
    tMediaObject lastMediaObject;

    /* set device and repeat mode */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetDBManager().SetActiveDevice(IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().SetRepeatMode(RPT_LIST);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().SetPlaybackMode(IN PBM_NORMAL);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* create a list */
    tStreaming streaming = FALSE;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    res = LocalSPM::GetListControl().CreatePlayList(OUT listID,
            LTY_SONG,
            IN streaming, IN tag1, IN tag2, IN tag3, IN tag4,
            PC_REPEAT_CURRENT_LEVEL,
            IN deviceID
            );
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    tListInfo listInfo;
    tBoolean withListSize = true;
    res = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listID, IN withListSize);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    listSize = listInfo.listSize;

    res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT lastMediaObject, IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* forward: do several nexts until listsize is done twice */
    for(tUInt i=0; i<(listSize*2); i++) {

        res = LocalSPM::GetListControl().Next(INOUT listID, IN 1 /*stepCount*/, IN true /*isHMIRequest*/);
        CPPUNIT_ASSERT(res == MP_NO_ERROR);

        /* get the active object */
        res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT mediaObject, IN listID);
        CPPUNIT_ASSERT(res == MP_NO_ERROR);

        ETG_TRACE_USR2(("run=%d/%d, mediaObject=%d, lastMediaObject=%d", i, listSize, mediaObject.objectID, lastMediaObject.objectID));
        CPPUNIT_ASSERT_MESSAGE("objects do not differ", mediaObject.objectID != lastMediaObject.objectID);

        /* save the current as the last object */
        lastMediaObject = mediaObject;
    }

    /* backwards: do several nexts until listsize is done twice */
    for(tUInt i=0; i<(listSize*2); i++) {

        res = LocalSPM::GetListControl().Prev(INOUT listID, IN 1 /*stepCount*/, IN true /*isHMIRequest*/);
        CPPUNIT_ASSERT(res == MP_NO_ERROR);

        /* get the active object */
        res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT mediaObject, IN listID);
        CPPUNIT_ASSERT(res == MP_NO_ERROR);

        ETG_TRACE_USR2(("run=%d/%d, mediaObject=%d, lastMediaObject=%d", i, listSize, mediaObject.objectID, lastMediaObject.objectID));
        CPPUNIT_ASSERT_MESSAGE("objects do not differ", mediaObject.objectID != lastMediaObject.objectID);

        /* save the current as the last object */
        lastMediaObject = mediaObject;
    }

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::RepeatAll()
{
    ENTRY_TEST


    tResult res;
    tDeviceID deviceID;
    tListID listID;
    tListSize listSize;
    tMediaObject mediaObject;
    tMediaObject lastMediaObject;

    /* set device and repeat mode */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetDBManager().SetActiveDevice(IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().SetRepeatMode(RPT_ALL);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().SetPlaybackMode(IN PBM_NORMAL);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* create a songs list, this should behave like RPT_LIST */
    tStreaming streaming = FALSE;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    res = LocalSPM::GetListControl().CreatePlayList(
            OUT listID,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            PC_STEPUP_ONE_LEVEL,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    tListInfo listInfo;
    tBoolean withListSize = true;
    res = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listID, IN withListSize);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    listSize = listInfo.listSize;

    res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT lastMediaObject, IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* do several nexts until listsize is done twice */
    for(tUInt i=0; i<(listSize*2); i++) {

        res = LocalSPM::GetListControl().Next(INOUT listID, IN 1 /*stepCount*/, IN true /*isHMIRequest*/);
        CPPUNIT_ASSERT(res == MP_NO_ERROR);

        /* get the active object */
        res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT mediaObject, IN listID);
        CPPUNIT_ASSERT(res == MP_NO_ERROR);

        ETG_TRACE_USR2(("run=%d/%d, mediaObject=%d, lastMediaObject=%d", i, listSize, mediaObject.objectID, lastMediaObject.objectID));
        CPPUNIT_ASSERT_MESSAGE("objects do not differ", mediaObject.objectID != lastMediaObject.objectID);

        /* save the current as the last object */
        lastMediaObject = mediaObject;
    }

    /* search for artist=Garbage */
    vector<tMediaObject> mediaObjectVector;
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            0,
            listSize);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    tUInt row;
    for(row = 0; row < mediaObjectVector.size(); row++) {
        if (!strcmp(mediaObjectVector[row].MetadataField2, "Garbage")) break;
    }
    CPPUNIT_ASSERT(row < mediaObjectVector.size());

    // set the filter tags
    tag1.genre = mediaObjectVector[row].MetadataTag1;  // Alternative
    tag2.artist = mediaObjectVector[row].MetadataTag2; // Garbage
    tag3.tag = 0;
    tag4.album = mediaObjectVector[row].MetadataTag4;  // Garbage

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* create a genre artist song list, this should invoke the special repeat function */
    res = LocalSPM::GetListControl().CreatePlayList(
            OUT listID,
            LTY_GENRE_ARTIST_ALBUM_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            PC_STEPUP_ONE_LEVEL,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT lastMediaObject, IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* forward: do several next until former listsize (number of all songs in db) is done twice */
    for(tUInt i=0; i<(listSize*2); i++) {

        res = LocalSPM::GetListControl().Next(INOUT listID, IN 1 /*stepCount*/, IN true /*isHMIRequest*/);
        CPPUNIT_ASSERT(res == MP_NO_ERROR);

        /* get the active object */
        res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT mediaObject, IN listID);
        CPPUNIT_ASSERT(res == MP_NO_ERROR);

        ETG_TRACE_USR2(("run=%d/%d, mediaObject=%d, lastMediaObject=%d", i, listSize, mediaObject.objectID, lastMediaObject.objectID));
        CPPUNIT_ASSERT_MESSAGE("objects do not differ", mediaObject.objectID != lastMediaObject.objectID);

        ETG_TRACE_USR2(("tag1=%32s, tag2=%32s, tag4=%32s, title=%32s",
                mediaObject.MetadataField1, mediaObject.MetadataField2, mediaObject.MetadataField4, mediaObject.title));

        /* save the current as the last object */
        lastMediaObject = mediaObject;
    }

    /* backwards: do several next until former listsize (number of all songs in db) is done twice */
    for(tUInt i=0; i<(listSize*2); i++) {

        res = LocalSPM::GetListControl().Prev(INOUT listID, IN 1 /*stepCount*/, IN true /*isHMIRequest*/);
        CPPUNIT_ASSERT(res == MP_NO_ERROR);

        /* get the active object */
        res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT mediaObject, IN listID);
        CPPUNIT_ASSERT(res == MP_NO_ERROR);

        ETG_TRACE_USR2(("run=%d/%d, mediaObject=%d, lastMediaObject=%d", i, listSize, mediaObject.objectID, lastMediaObject.objectID));
        CPPUNIT_ASSERT_MESSAGE("objects do not differ", mediaObject.objectID != lastMediaObject.objectID);

        ETG_TRACE_USR2(("tag1=%32s, tag2=%32s, tag4=%32s, title=%32s",
                mediaObject.MetadataField1, mediaObject.MetadataField2, mediaObject.MetadataField4, mediaObject.title));

        /* save the current as the last object */
        lastMediaObject = mediaObject;
    }

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().SetRepeatMode(RPT_ALL);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::CreateMediaPlayerFileList()
{
    ENTRY_TEST

    tResult res;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPosition position;
    tPath path;
    tDeviceID deviceID; // usb device

    /* Set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* Create a file list from a specific directory */
    strncpy_r(path, "/music/Garbage/Garbage-Garbage-07-Vow.mp3", sizeof(path));
    res = LocalSPM::GetListControl().CreateMediaPlayerFileList(
            OUT mFileListID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            OUT position,
            IN path,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(numberOfMediaObjects == 12);
    CPPUNIT_ASSERT(numberOfPlayLists == 0);
    CPPUNIT_ASSERT(numberOfFolders == 0);
    CPPUNIT_ASSERT(position == 6);

    res = LocalSPM::GetListControl().ReleaseList(mFileListID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* Create a file list from root directory */
    strncpy_r(OUT path, IN "/", IN sizeof(path));
    res = LocalSPM::GetListControl().CreateMediaPlayerFileList(
            OUT mFileListID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN LTY_FILELIST,
            IN path,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(numberOfMediaObjects == 3);
    CPPUNIT_ASSERT(numberOfPlayLists == 0);
    CPPUNIT_ASSERT(numberOfFolders == 4);
}

void ListControlTest::RequestMediaPlayerFileListSlice()
{
    ENTRY_TEST

    tResult res;

    /* Get the list slice */
    vector<tFiles> mediaFileVector;
    res= LocalSPM::GetListControl().RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN mFileListID, 0, 10);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* Check the resulting entries */
    CPPUNIT_ASSERT(mediaFileVector.size() == 7);
    CPPUNIT_ASSERT(strcmp(mediaFileVector[0].fileName, "albumart") == 0);
    CPPUNIT_ASSERT(mediaFileVector[0].type == FT_FOLDER);
    CPPUNIT_ASSERT(strcmp(mediaFileVector[1].fileName, "music") == 0);
    CPPUNIT_ASSERT(mediaFileVector[1].type == FT_FOLDER);
    CPPUNIT_ASSERT(strcmp(mediaFileVector[2].fileName, "playlists") == 0);
    CPPUNIT_ASSERT(mediaFileVector[2].type == FT_FOLDER);
    CPPUNIT_ASSERT(strcmp(mediaFileVector[3].fileName, "video") == 0);
    CPPUNIT_ASSERT(mediaFileVector[3].type == FT_FOLDER);
    CPPUNIT_ASSERT(strcmp(mediaFileVector[4].fileName, "Garbage-Garbage-01-Supervixen.MP3") == 0);
    CPPUNIT_ASSERT(mediaFileVector[4].type == FT_AUDIO);
    CPPUNIT_ASSERT(mediaFileVector[4].fileFormat == FFT_MP3);
    CPPUNIT_ASSERT(strcmp(mediaFileVector[5].fileName, "Garbage-Garbage-02-Queer.MP3") == 0);
    CPPUNIT_ASSERT(mediaFileVector[5].type == FT_AUDIO);
    CPPUNIT_ASSERT(mediaFileVector[5].fileFormat == FFT_MP3);
    CPPUNIT_ASSERT(strcmp(mediaFileVector[6].fileName, "Garbage-Garbage-03-Only_Happy_When_It_Rains.MP3") == 0);
    CPPUNIT_ASSERT(mediaFileVector[6].type == FT_AUDIO);
    CPPUNIT_ASSERT(mediaFileVector[6].fileFormat == FFT_MP3);
}

void ListControlTest::PlayMediaPlayerFileList()
{
    ENTRY_TEST

    tResult res;
    tMediaObject mo;

    res = LocalSPM::GetListControl().SetMediaObject(OUT mo, mFileListID, IN 4);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(strcmp(mo.fileName, "/Garbage-Garbage-01-Supervixen.MP3") == 0);
    CPPUNIT_ASSERT(strcmp(mo.title, "Garbage-Garbage-01-Supervixen.MP3") == 0);

    res = LocalSPM::GetListControl().SetMediaObject(OUT mo, mFileListID, IN 5);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(strcmp(mo.fileName, "/Garbage-Garbage-02-Queer.MP3") == 0);
    CPPUNIT_ASSERT(strcmp(mo.title, "Garbage-Garbage-02-Queer.MP3") == 0);

    res = LocalSPM::GetListControl().SetMediaObject(OUT mo, mFileListID, IN 6);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(strcmp(mo.fileName, "/Garbage-Garbage-03-Only_Happy_When_It_Rains.MP3") == 0);
    CPPUNIT_ASSERT(strcmp(mo.title, "Garbage-Garbage-03-Only_Happy_When_It_Rains.MP3") == 0);

    res = LocalSPM::GetListControl().SetMediaObject(OUT mo, mFileListID, IN 4);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(strcmp(mo.fileName, "/Garbage-Garbage-01-Supervixen.MP3") == 0);
    CPPUNIT_ASSERT(strcmp(mo.title, "Garbage-Garbage-01-Supervixen.MP3") == 0);
}

void ListControlTest::NextMediaPlayerFileList()
{
    ENTRY_TEST

    tResult res;
    tMediaObject mediaObject;

    tListID localListID = mFileListID;
    res = LocalSPM::GetListControl().Next(INOUT localListID, IN 1 /*stepCount*/, IN true /*isHMIRequest*/);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    InitMediaObject(OUT mediaObject);
    res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT mediaObject, IN localListID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(strcmp(mediaObject.fileName, "/Garbage-Garbage-02-Queer.MP3") == 0);
    CPPUNIT_ASSERT(strcmp(mediaObject.title, "Garbage-Garbage-02-Queer.MP3") == 0);
}

void ListControlTest::StoreLastPlayedFileList()
{
    ENTRY_TEST

    tResult res = 0;
    tMediaObject lastMediaObject;

    /* Get last media object */
    InitMediaObject(OUT lastMediaObject);
    res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT lastMediaObject, IN mFileListID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* Store the last mode */
    tPosition position;
    res = LocalSPM::GetListControl().UpdateNowPlaying(OUT position, IN mFileListID, IN lastMediaObject.objectID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().StoreLastPlayedList(IN mFileListID, IN 1001);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* Get deviceID via listInfo */
    tListInfo listInfo;
    tBoolean withListSize = false;
    res = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN mFileListID, IN withListSize);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* Get the last mode info */
    tListID fileListID;
    tIndex listIndex;
    tPlaytime playtime;
    tMediaObject currentMediaObject;
    res = LocalSPM::GetListControl().GetLastPlayedList(OUT fileListID, OUT listIndex, OUT playtime, IN IN listInfo.deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(playtime == 1001);
    CPPUNIT_ASSERT(listIndex == position);

    /* Get current media object */
    InitMediaObject(OUT currentMediaObject);
    res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT currentMediaObject, IN fileListID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(strcmp(lastMediaObject.fileName, currentMediaObject.fileName) == 0);

    res = LocalSPM::GetListControl().ReleaseList(IN fileListID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::ParentFileListHighlighting()
{
    ENTRY_TEST

    tResult res;
    tListID fileListID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPosition position;
    tPath path;
    tDeviceID deviceID; // USB device
    tIndex index = 3;

    /* Set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* Create a file list from a subdirectory */
    strncpy_r(path, "/music/Garbage/", sizeof(path));
    res = LocalSPM::GetListControl().CreateMediaPlayerFileList(
            OUT fileListID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            OUT position,
            IN path,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(fileListID != LIST_ID_NONE);
    CPPUNIT_ASSERT(listSize > index);
    CPPUNIT_ASSERT(numberOfMediaObjects == 12);
    CPPUNIT_ASSERT(numberOfPlayLists == 0);
    CPPUNIT_ASSERT(numberOfFolders == 0);

    /* Set the third object as current one */
    tMediaObject currentMediaObject;
    res = LocalSPM::GetListControl().SetMediaObject(OUT currentMediaObject, IN fileListID, IN index);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* Get current media object */
    InitMediaObject(OUT currentMediaObject);
    res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT currentMediaObject, IN fileListID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* Update NowPlaying for this list */
    res = LocalSPM::GetListControl().UpdateNowPlaying(OUT position, IN fileListID, IN currentMediaObject.objectID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(position == index);

    /* Get the list slice of the root directory */
    vector<tFiles> mediaFileVector;
    res= LocalSPM::GetListControl().RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN mFileListID, 0, IN listSize);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(mediaFileVector.size() > 1);
    CPPUNIT_ASSERT(strcmp(mediaFileVector[1].fileName, "music") == 0);
    CPPUNIT_ASSERT(mediaFileVector[1].type == FT_FOLDER);
    CPPUNIT_ASSERT(mediaFileVector[1].isPlaying > 0);

    res = LocalSPM::GetListControl().ReleaseList(IN fileListID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::UpdateNowPlaying()
{
    ENTRY_TEST

    tResult res;
    vector<tMediaObject> mediaObjectVector;
    tMediaObject currentMediaObject;

    /* Get the first object */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN mListID, 0, 3);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(mediaObjectVector.size() > 0);

    /* Set active object to the first one */
    tPosition position;
    res = LocalSPM::GetListControl().UpdateNowPlaying(OUT position, IN mListID, IN mediaObjectVector[0].objectID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(position == 0);

    /* Check whether current object is same as set via UpdateNowPlaying */
    res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT currentMediaObject, IN mListID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(currentMediaObject.objectID == mediaObjectVector[0].objectID);

    /* Check if the right object is playing */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN mListID, 0, 3);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(mediaObjectVector.size() > 2);
    CPPUNIT_ASSERT(mediaObjectVector[0].isPlaying > 0);
    CPPUNIT_ASSERT(mediaObjectVector[1].isPlaying == 0);
    CPPUNIT_ASSERT(mediaObjectVector[2].isPlaying == 0);

    /* Set now the 3rd as active object */
    res = LocalSPM::GetListControl().UpdateNowPlaying(OUT position, IN mListID, IN mediaObjectVector[2].objectID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(position == 2);

    /* Check whether current object is same as set via UpdateNowPlaying */
    res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT currentMediaObject, IN mListID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(currentMediaObject.objectID == mediaObjectVector[2].objectID);

    /* Check if the right object is playing */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN mListID, 0, 3);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(mediaObjectVector.size() > 2);
    CPPUNIT_ASSERT(mediaObjectVector[0].isPlaying == 0);
    CPPUNIT_ASSERT(mediaObjectVector[1].isPlaying == 0);
    CPPUNIT_ASSERT(mediaObjectVector[2].isPlaying > 0);
}

void ListControlTest::CreatePlayableFileList(void)
{
    ENTRY_TEST

    tResult res;
    tListID listID;
    tPath path;
    tDeviceID deviceID; // usb device

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* set the path */
    strncpy_r(OUT path, IN "/", IN sizeof(path));

    res = LocalSPM::GetListControl().CreateFileListOfMediaObjects(
            OUT listID,
            IN path,
            IN deviceID,
            IN false /*withSubFolders*/);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* Get list size via listInfo */
    tListInfo listInfo;
    tBoolean withListSize = true;
    res = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listID, IN withListSize);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    tRowNumber newRow = 0;
    tMediaObject mediaObject;
    res = LocalSPM::GetListControl().SetMediaObject(OUT mediaObject, IN listID, IN newRow);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    ETG_TRACE_USR2(("CreatePlayableFileList  includeSubfolder GetCurrentMediaObject: objectID:%d title:%s", mediaObject.objectID, mediaObject.title));
    CPPUNIT_ASSERT(mediaObject.objectID != 0);
    CPPUNIT_ASSERT(0 < strlen_r(mediaObject.title));

    vector<tFiles> mediaFileVector; /* resulting entries */
    /* get the list slice */
    res= LocalSPM::GetListControl().RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, 3);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* check the resulting entries */
    CPPUNIT_ASSERT(mediaFileVector.size() == 3);
    CPPUNIT_ASSERT(strcmp(mediaFileVector[0].fileName, "Garbage-Garbage-01-Supervixen.MP3") == 0);
    CPPUNIT_ASSERT(mediaFileVector[0].type == FT_AUDIO);
    CPPUNIT_ASSERT(strcmp(mediaFileVector[1].fileName, "Garbage-Garbage-02-Queer.MP3") == 0);
    CPPUNIT_ASSERT(mediaFileVector[1].type == FT_AUDIO);
    CPPUNIT_ASSERT(strcmp(mediaFileVector[2].fileName, "Garbage-Garbage-03-Only_Happy_When_It_Rains.MP3") == 0);
    CPPUNIT_ASSERT(mediaFileVector[2].type == FT_AUDIO);

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::CreatePlayableCDList(void)
{
    ENTRY_TEST

    tResult res;
    tListID listID;
    tPath path;
    tDeviceID deviceID; // cd device

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_CDDA, IN "CDDA");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* set the path */
    strncpy_r(OUT path, IN "/", IN sizeof(path));

    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    res = LocalSPM::GetListControl().CreateMediaPlayerFileList(OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN LTY_CD,
            path,
            deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(numberOfMediaObjects == 9);
    CPPUNIT_ASSERT(listSize == 9);
    CPPUNIT_ASSERT(numberOfPlayLists == 0);
    CPPUNIT_ASSERT(numberOfFolders == 0);

    /* Get list size via listInfo */
    tListInfo listInfo;
    tBoolean withListSize = true;
    res = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listID, IN withListSize);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    tRowNumber newRow = 0;
    tMediaObject mediaObject;
    res = LocalSPM::GetListControl().SetMediaObject(OUT mediaObject, IN listID, IN newRow);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    ETG_TRACE_USR2(("CreatePlayableCDList: objectID:%d title:%s", mediaObject.objectID, mediaObject.title));
    CPPUNIT_ASSERT(mediaObject.objectID != 0);
    CPPUNIT_ASSERT(0 < strlen_r(mediaObject.title));

    vector<tFiles> mediaFileVector; /* resulting entries */
    /* get the list slice */
    res= LocalSPM::GetListControl().RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, 3);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* check the resulting entries */
    CPPUNIT_ASSERT(mediaFileVector.size() == 3);
    CPPUNIT_ASSERT(strcmp(mediaFileVector[0].fileName, "Frontera / Trigger") == 0);
    CPPUNIT_ASSERT(mediaFileVector[0].type == FT_AUDIO);
    CPPUNIT_ASSERT(strcmp(mediaFileVector[1].fileName, "Epic") == 0);
    CPPUNIT_ASSERT(mediaFileVector[1].type == FT_AUDIO);
    CPPUNIT_ASSERT(strcmp(mediaFileVector[2].fileName, "The News About William") == 0);
    CPPUNIT_ASSERT(mediaFileVector[2].type == FT_AUDIO);

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::CreatePlayableFileList_IncludeSubFolder(void)
{
    ENTRY_TEST

    tResult res;
    tListID listID;
    tPath path;
    tDeviceID deviceID; // usb device

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* set the path */
    strncpy_r(OUT path, IN "/", IN sizeof(path));

    res = LocalSPM::GetListControl().CreateFileListOfMediaObjects(
            OUT listID,
            IN path,
            IN deviceID,
            IN true /*withSubFolders*/);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* Get list size via listInfo */
    tListInfo listInfo;
    tBoolean withListSize = true;
    res = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listID, IN withListSize);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    tRowNumber newRow = 0;
    tMediaObject mediaObject;
    res = LocalSPM::GetListControl().SetMediaObject(OUT mediaObject, IN listID, IN newRow);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    ETG_TRACE_USR2(("CreatePlayableFileList  includeSubfolder GetCurrentMediaObject: objectID:%d title:%s", mediaObject.objectID, mediaObject.title));
    CPPUNIT_ASSERT(mediaObject.objectID != 0);
    CPPUNIT_ASSERT(0 < strlen_r(mediaObject.title));

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::CreateMediaPlayerPlaylistList()
{
    ENTRY_TEST

    tResult res;
    tListSize listSize;
    tListID listID;

    /* create playlist list */
    res = LocalSPM::GetListControl().CreateMediaPlayerPlaylistList(
            OUT listID,
            OUT listSize,
            IN "/music/Mando_Diao-Bring_Em_In-RETAIL-2002-EVIGHET/00-mando_diao-bring_em_in-retail-2002-evighet.m3u");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSize == 12);


    vector<tMediaObject> mediaObjectVector; /* resulting entries */
    res= LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, IN 0, IN listSize);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(mediaObjectVector.size() == listSize);

    /*validate the position of each entry with objectID as serach input*/
    for(tUInt iter = 0; iter < mediaObjectVector.size(); iter++)
    {
        /*search for position of the entry in the list with its objectID as input*/
        tPosition position = POSITION_NOT_SET;
        res= LocalSPM::GetListControl().GetPositionInList(OUT position, IN listID, IN mediaObjectVector[iter].objectID);
        CPPUNIT_ASSERT(res == MP_NO_ERROR);
        CPPUNIT_ASSERT(position == iter);
    }

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::CreateRequestCreateReleaseRequest()
{
    ENTRY_TEST

    tResult res;
    tListID listID;
    tListSize listSize;
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID;
    vector<tMediaObject> mediaObjectVector;

    // set the filter tags
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* get the list slice from first list */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN mListID,
            0,
            12);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* create a album list */
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_ALBUM,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);

    // test result
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    if(LocalSPM::GetDataProvider().DBUnifiedSchema())
    {
        CPPUNIT_ASSERT(listSize == 4);
    }
    else
    {
        CPPUNIT_ASSERT(listSize == 5);
    }

    /* request slice from second list */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            0,
            12);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    if(LocalSPM::GetDataProvider().DBUnifiedSchema())
    {
        CPPUNIT_ASSERT(mediaObjectVector.size() == 4);
    }
    else
    {
        CPPUNIT_ASSERT(mediaObjectVector.size() == 5);
    }

    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField1, "Hip-Hop"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField2, "K'Naan"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField4, "2010 FIFA World Cup Anthem"));

    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField1, "German Pop"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField2, "Herbert Grönemeyer"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField4, "Bleibt Alles Anders"));

    if(LocalSPM::GetDataProvider().DBUnifiedSchema())
    {
        CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField1, "Rock"));
        CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField2, "Mando Diao"));
        CPPUNIT_ASSERT(!strcasecmp(mediaObjectVector[2].MetadataField4, "Bring Em IN"));
        //CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField4, "Bring Em In"));

        CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField1, "Alternative"));
        CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField2, "Garbage"));
        CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField4, "Garbage"));
    }
    else
    {
        CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField1, "Rock"));
        CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField2, "Mando Diao"));
        CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField4, "Bring Em In"));

        CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField1, "Rock"));
        CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField2, "Mando Diao"));
        CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField4, "Bring Em IN"));

        CPPUNIT_ASSERT(!strcmp(mediaObjectVector[4].MetadataField1, "Alternative"));
        CPPUNIT_ASSERT(!strcmp(mediaObjectVector[4].MetadataField2, "Garbage"));
        CPPUNIT_ASSERT(!strcmp(mediaObjectVector[4].MetadataField4, "Garbage"));
    }

    /* delete second list */
    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::CreateListCheckShuffle()
{
    ENTRY_TEST

    tResult res;
    vector<tMediaObject> mediaObjectVector;
    tMediaObject mediaObject;
    tListID localListID = mListID;

    /* get the list slice from first list */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN localListID,
            0,
            5);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(mediaObjectVector.size() > 4);

    /* set the current object to the first one */
    res = LocalSPM::GetListControl().SetMediaObject(OUT mediaObject, IN localListID, IN 0);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* step through the list by Next and check the sequence */
    for(tRowNumber row=0; row<5; row++) {

        /* get the current object */
        res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT mediaObject, IN localListID);
        CPPUNIT_ASSERT(res == MP_NO_ERROR);

        ETG_TRACE_USR1(("PBM_NORMAL: row=%d, file=%s", row, mediaObject.fileName));

        /* compare the file name */
        CPPUNIT_ASSERT(strcmp(mediaObject.fileName, mediaObjectVector[row].fileName) == 0);

        /* do the Next */
        res = LocalSPM::GetListControl().Next(INOUT localListID, IN 1 /*stepCount*/, IN true /*isHMIRequest*/);
        CPPUNIT_ASSERT(res == MP_NO_ERROR);
    }

    /* set the current object back to the first one */
    res = LocalSPM::GetListControl().SetMediaObject(OUT mediaObject, IN localListID, IN 0);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* switch the device in random play */
    res = LocalSPM::GetListControl().SetPlaybackMode(IN PBM_RANDOM);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* now, recheck the sequence. it should be different to the display sequence */
    int testErrorCount = 0;
    for(tRowNumber row=0; row<5; row++) {

        /* get the current object */
        res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT mediaObject, IN localListID);
        CPPUNIT_ASSERT(res == MP_NO_ERROR);

        ETG_TRACE_USR1(("PBM_RANDOM: row=%d, file=%s", row, mediaObject.fileName));

        /* compare the file name */
        if (strcmp(mediaObject.fileName, mediaObjectVector[row].fileName) == 0) testErrorCount++;

        /* do the Next */
        res = LocalSPM::GetListControl().Next(INOUT localListID, IN 1 /*stepCount*/, IN true /*isHMIRequest*/);
        if (res == MP_ERR_DB_END_OF_LIST) break; // this can happen because the original object could be at the end of the random list
        CPPUNIT_ASSERT(res == MP_NO_ERROR);
    }

    /* switch the device back to normal play */
    res = LocalSPM::GetListControl().SetPlaybackMode(IN PBM_NORMAL);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    CPPUNIT_ASSERT(testErrorCount < 5);

    /* set the current object back to the first one */
    res = LocalSPM::GetListControl().SetMediaObject(OUT mediaObject, IN localListID, IN 0);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* step through the list by Next and check the sequence */
    for(tRowNumber row=0; row<5; row++) {

        /* get the current object */
        res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT mediaObject, IN localListID);
        CPPUNIT_ASSERT(res == MP_NO_ERROR);

        ETG_TRACE_USR1(("PBM_NORMAL: row=%d, file=%s", row, mediaObject.fileName));

        /* compare the file name */
        CPPUNIT_ASSERT(strcmp(mediaObject.fileName, mediaObjectVector[row].fileName) == 0);

        /* do the Next */
        res = LocalSPM::GetListControl().Next(INOUT localListID, IN 1 /*stepCount*/, IN true /*isHMIRequest*/);
        CPPUNIT_ASSERT(res == MP_NO_ERROR);
    }
}

void ListControlTest::CreateListAndCheckParents()
{
    ENTRY_TEST

    tResult res;
    tListSize listSize;
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID;
    tListID listID;
    vector<tMediaObject> mediaObjectVector;

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* create a list to get the test filter tag id's */
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_ARTIST,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* search for artist=Herbert Grönemeyer */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            0,
            listSize);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    tUInt row;
    for(row = 0; row < mediaObjectVector.size(); row++) {
        if (!strcmp(mediaObjectVector[row].MetadataField2, "Herbert Grönemeyer")) break;
    }
    CPPUNIT_ASSERT(row < mediaObjectVector.size());

    // set the filter tags
    tag1.genre = mediaObjectVector[row].MetadataTag1;  // German Pop
    tag2.artist = mediaObjectVector[row].MetadataTag2; // Herbert Grönemeyer
    tag3.tag = 0;
    tag4.album = mediaObjectVector[row].MetadataTag4;  // Bleibt Alles Anders

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    // create the first list
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_GENRE_ARTIST_ALBUM_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);

    // test result
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

#if 0
    /* debug print */
    for(tRowNumber row=0; row<5; row++) {

        /* get the current object */
        res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT mediaObject, IN listID);
        CPPUNIT_ASSERT(res == MP_NO_ERROR);

        ETG_TRACE_USR1(("CreateListAndCheckParents: row=%d, title=%s", row, mediaObject.title));

        /* do the Next */
        res = LocalSPM::GetListControl().Nexlt(INOUT listID, IN 1 /*stepCount*/, IN true /*isHMIRequest*/);
        if (res) break;
    }
#endif
    CPPUNIT_ASSERT(listSize == 3);

    /* check the parent lists */
    tListType listType;
    tListID parentListID;
    tListID childListID;
    tPosition position;
    tDeviceID deviceIDInfo;

    childListID = listID;
    res = LocalSPM::GetListControl().RequestListInformation(
            OUT listType,
            OUT parentListID,
            OUT deviceIDInfo,
            OUT position,
            OUT listSize,
            IN childListID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listType == LTY_GENRE_ARTIST_ALBUM_SONG);
    CPPUNIT_ASSERT(listSize == 3);
    CPPUNIT_ASSERT(deviceIDInfo == deviceID);
    CPPUNIT_ASSERT(position == 0);

    // parent should be a LTY_GENRE_ARTIST_ALBUM list
    childListID = parentListID;
    res = LocalSPM::GetListControl().RequestListInformation(
            OUT listType,
            OUT parentListID,
            OUT deviceIDInfo,
            OUT position,
            OUT listSize,
            IN childListID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listType == LTY_GENRE_ARTIST_ALBUM);
    CPPUNIT_ASSERT(listSize == 1);
    CPPUNIT_ASSERT(deviceIDInfo == deviceID);
    CPPUNIT_ASSERT(position == 0);

    // parent should be a LTY_GENRE_ARTIST list
    childListID = parentListID;
    res = LocalSPM::GetListControl().RequestListInformation(
            OUT listType,
            OUT parentListID,
            OUT deviceIDInfo,
            OUT position,
            OUT listSize,
            IN childListID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listType == LTY_GENRE_ARTIST);
    CPPUNIT_ASSERT(listSize == 1);
    CPPUNIT_ASSERT(deviceIDInfo == deviceID);
    CPPUNIT_ASSERT(position == 1);

    // parent should be a LTY_GENRE list
    childListID = parentListID;
    res = LocalSPM::GetListControl().RequestListInformation(
            OUT listType,
            OUT parentListID,
            OUT deviceIDInfo,
            OUT position,
            OUT listSize,
            IN childListID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listType == LTY_GENRE);
    CPPUNIT_ASSERT(listSize == 4);
    CPPUNIT_ASSERT(deviceIDInfo == deviceID);
    CPPUNIT_ASSERT(position == 0);

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::CreatePlayableFilelist()
{
    ENTRY_TEST

    tResult res;
    tDeviceID deviceID;
    tIndex startPosition;

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* get the first playable object found on the USB device */
    tListID listID = LIST_ID_NONE;
    tListSize listSize = 0;
    res = LocalSPM::GetListControl().CreatePlayableFilelist(OUT listID, OUT listSize, OUT startPosition, IN deviceID, IN false /*streaming*/);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listID != LIST_ID_NONE);
    CPPUNIT_ASSERT(listSize > 0);
    CPPUNIT_ASSERT(startPosition >= 0);

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}

void ListControlTest::CreateFollowingList()
{
    ENTRY_TEST

    /* Enable CreateFollowingList configuration */
    int createFollowingList = LocalSPM::GetDataProvider().CreateFollowingList();
    if (0 == createFollowingList)
    {
        LocalSPM::GetDataProvider().CreateFollowingList = 1;
    }

    tResult res;
    tListSize listSize;
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID;
    tListID listID;
    vector<tMediaObject> mediaObjectVector;

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* create a list to get the test filter tag id's */
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_ARTIST,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(LIST_ID_NONE != listID);
    CPPUNIT_ASSERT(listSize > 0);

    /* search for artist=K'Naan */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            0,
            listSize);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    tUInt row;
    for(row = 0; row < mediaObjectVector.size(); row++) {
        if (!strcmp(mediaObjectVector[row].MetadataField2, "K'Naan")) break;
    }
    CPPUNIT_ASSERT(row < mediaObjectVector.size());

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* create a song list of this artist */
    tag1.tag = 0;
    tag2.artist = mediaObjectVector[row].MetadataTag2; // K'Naan
    tag3.tag = 0;
    tag4.tag = 0;
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_ARTIST_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(LIST_ID_NONE != listID);
    CPPUNIT_ASSERT(listSize > 0);

    /* Set repeat mode to RPT_LIST_WITH_SUBLISTS */
    res = LocalSPM::GetListControl().SetRepeatMode(RPT_LIST_WITH_SUBLISTS);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    tRepeatMode repeatMode;
    res = LocalSPM::GetListControl().GetRepeatMode(OUT repeatMode);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(RPT_LIST_WITH_SUBLISTS == repeatMode);


    tListID nextListID = listID;
    res = LocalSPM::GetListControl().Next(INOUT nextListID, IN 1 /*stepCount*/, IN true /*isHMIRequest*/);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(nextListID == listID); //Being in RPT_LIST_WITH_SUBLISTS,Once LTY_ARTIST_SONG ends,it should repeat the same list.


    /* Reset CreateFollowingList configuration */
    LocalSPM::GetDataProvider().CreateFollowingList = createFollowingList;

    /* Reset repeat mode to default */
    res = LocalSPM::GetListControl().SetRepeatMode(IN (tRepeatMode)LocalSPM::GetDataProvider().DBDefaultRepeatMode());
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().GetRepeatMode(OUT repeatMode);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT((tRepeatMode)LocalSPM::GetDataProvider().DBDefaultRepeatMode() == repeatMode);

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
}


//>>Roadmap 160014 'Full text search'


tResult ListControlTest::helperSetupParentList_LTY_ARTIST_SEARCH(OUT tListID &listIDParent, OUT vector<tMediaObject> &mediaObjectVector)
{

    ENTRY
    ETG_TRACE_USR2(("%s", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;

    //init OUT-values
    listIDParent = LIST_ID_NONE;
    mediaObjectVector.clear();

    //=====================================
    //test setup
    //=====================================
    tListID listID ;
    tListSize listSize;
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID;

    // set the filter tags
    tag1.tag    = 0;
    tag2.artist = 0x0;
    tag3.tag    = 0;
    tag4.album =  0x0;

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    //---------------------
    // create a list:LTY_ARTIST
    //---------------------

    /* create a artist list */
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_ARTIST,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);

    CPPUNIT_ASSERT(listID   != LIST_ID_NONE);
    CPPUNIT_ASSERT(res      == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSize == 4);

    //---------------------
    // get a slice from List
    //---------------------
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
    OUT mediaObjectVector,
    IN listID,
    0,
    5); //although list is of size 4 slize is demanded form 0 to 5

    //tbd. add hint here to explain metatdata fields
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(mediaObjectVector.size() == 4);

    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField1, "Alternative"));//genre
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField2, "Garbage")); //<-----Artist

    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField1, "German Pop"));//genre
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField2, "Herbert Grönemeyer"));//<----Artist

    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField1, "Hip-Hop"));//genre
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField2, "K'Naan"));//<----Artist

    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField1, "Rock")); //genre
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField2, "Mando Diao"));//<------Artist

    //care for OUT-values
     //mediaObjectVector already filled if list creation has been successfull
    if(listID != LIST_ID_NONE)
    {
        listIDParent = listID;
    }

    return res;

}

tListSize ListControlTest::helperWaitCheckAnswer_MethodReturnCreateListWithSearchStringAll(IN SimulationOutputWrapper *pSimulationOutputWrapper,
                                                                                   IN tListID listIDExpected,
                                                                                   IN tListSize listSizeExpected,
                                                                                   IN tDeviceID deviceIDExpected,
                                                                                   IN int numOfExpectedMsgs)
{

    ENTRY
    ETG_TRACE_USR2(("%s", __PRETTY_FUNCTION__));

    tListSize retListSize = 0;


    //-----------------------------
    //receive asynchronous answers
    //----------------------------

    ETG_TRACE_USR2(("Check answer:FIRST %s", __PRETTY_FUNCTION__));

    //First answer
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                              SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnFirst,
                                                              listIDExpected,
                                                              1,
                                                              deviceIDExpected );

    ETG_TRACE_USR2(("Check answer:MID %s", __PRETTY_FUNCTION__));
    //Middle answers
    //Note to ease testing:
    //       first middle answer returns listSizeExpected like first message
    //       last  middle answer return  listSizeExpected like last  message
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                               SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnMiddle,
                                                               listIDExpected,
                                                               listSizeExpected,
                                                               deviceIDExpected,
                                                               numOfExpectedMsgs);

    if(numOfExpectedMsgs==NUM_OF_EXPECTED_MSGS_DISABLED_NONE) //numOfExpected is used to catch only part of Middle messages because abort test is done
    {
        ETG_TRACE_USR2(("Check answer:LAST EXPECTED %s", __PRETTY_FUNCTION__));
        //Last answer
        helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                               SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnLast,
                                                               listIDExpected,
                                                               listSizeExpected,
                                                               deviceIDExpected);
    }
    else
    {
        ETG_TRACE_USR2(("Check answer:LAST NOT EXPECTED %s", __PRETTY_FUNCTION__));
    }


     retListSize = listSizeExpected; //tbd. care for return value of other helpers
     return retListSize;
}
//===========================================================
//Test function type: Test function type: normal usage interface
//===========================================================

tResult ListControlTest::helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(IN SimulationOutputWrapper *pSimulationOutputWrapper,
                                                                                   IN SimulationOutputWrapper::tenFctType eFctTypeExpected,
                                                                                   IN tListID listIDExpected,
                                                                                   IN tListSize listSizeExpected,
                                                                                   IN tDeviceID deviceIDExpected,
                                                                                   IN int numOfExpectedMsgs)
{
    ENTRY
    ETG_TRACE_USR2(("Begin: %s", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;

    VARTRACE(eFctTypeExpected);
    VARTRACE(listIDExpected);
    VARTRACE(listSizeExpected);
    VARTRACE(deviceIDExpected);
    VARTRACE(numOfExpectedMsgs);

    int len = 0;
    int offset = 0;
    char *pu8Buffer = NULL;
    unsigned int uLength;
    unsigned int timeout_ms = 1000;

    int numOfMsgsReceived = 0;


    CPPUNIT_ASSERT(pSimulationOutputWrapper !=NULL);


    tBool bLoop = TRUE;

    int ErrorCount = 0;
    while(bLoop) //looping done for middle messages only first and last message is expected only once
    {
        //blocking wait on queue
        pu8Buffer = (char*)pSimulationOutputWrapper->testMsgQWait(OUT uLength, IN timeout_ms);
        if(uLength == 0)
        {
            ETG_TRACE_FATAL(("helperWaitCheckAnswer_MethodReturnCreateListWithSearchString: testMsgQWait timout after %d",timeout_ms));
            ErrorCount++;
            sleep(1);
            if(ErrorCount <3)
            {
                res = MP_ERR_LC_GENERAL_ERROR;
                break;
            }
        }
        else
        {
            CPPUNIT_ASSERT(pu8Buffer != NULL);

            ++numOfMsgsReceived;

            //if it is method middle then catch all of those messages i.e. continue to loop
            if(eFctTypeExpected != SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnMiddle)
            {
                 bLoop = FALSE;
            }
            else if (numOfExpectedMsgs>0)
            {
                if(numOfMsgsReceived >=numOfExpectedMsgs)
                {
                    ETG_TRACE_USR4(("helperWaitCheckAnswer_MethodReturnCreateListWithSearchString: numOfExpectedMsgs:%d reached stop to listen for messages",numOfExpectedMsgs));
                    bLoop = FALSE;
                }
            }

            if(pu8Buffer)
            {
                //is len of answer ok?
                len = sizeof(SimulationOutputWrapper::tenFctType) + sizeof(tListID) + sizeof(tListSize) + sizeof(tDeviceID);
                CPPUNIT_ASSERT(len == (int)uLength);

                //parameters which will be extracted from async answer
                SimulationOutputWrapper::tenFctType eFctType;
                tListID   listID;
                tListSize listSize;
                tDeviceID deviceID; //already declared

                //extract params
                offset = 0;
                len   = sizeof(SimulationOutputWrapper::tenFctType);
                memcpy((void*)&eFctType,(void*)(pu8Buffer+offset),len);

                offset += len;
                len    = sizeof(tListID);
                memcpy((void*)&listID,(void*)(pu8Buffer+offset),len);

                offset += len;
                len    = sizeof(tListSize);
                memcpy((void*)&listSize,(void*)(pu8Buffer+offset),len);

                offset += len;
                len    = sizeof(tDeviceID);
                memcpy((void*)&deviceID,(void*)(pu8Buffer+offset),len);

                //drop/release buffer of received message
                pSimulationOutputWrapper->testMsgQDropRecBuf(pu8Buffer);

                //error echeck if params ok
                ETG_TRACE_USR4(("helperWaitCheckAnswer_MethodReturnCreateListWithSearchString:eFctType:%d eFctTypeExpected=%d",eFctType,eFctTypeExpected))
                CPPUNIT_ASSERT(eFctType == eFctTypeExpected );

                CPPUNIT_ASSERT(listID != 0);
                CPPUNIT_ASSERT(listID == listIDExpected);

                if(eFctTypeExpected == SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnMiddle)
                {
                    CPPUNIT_ASSERT(listSize <= listSizeExpected); //first answer is expected to return one answer since
                    if(listSize >= listSizeExpected)
                    {
                        bLoop = FALSE; //last middle message found - hence give up wating for more such messages. Last message is expected
                    }
                }
                else
                {
                    CPPUNIT_ASSERT(listSize == listSizeExpected); //first answer is expected to return one answer since
                }

                CPPUNIT_ASSERT(deviceID != 0);
                CPPUNIT_ASSERT(deviceID == deviceIDExpected);
            }
        }
    }

    if(numOfExpectedMsgs > NUM_OF_EXPECTED_MSGS_DISABLED_NONE)
    {
        CPPUNIT_ASSERT(numOfMsgsReceived == numOfExpectedMsgs);
    }

    ETG_TRACE_USR2(("End: %s", __PRETTY_FUNCTION__));

    return res;
}






void ListControlTest::CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_NOMATCH()
{


    ENTRY_TEST

    //=====================================
    //test setup
    //=====================================
    tReturnValue res = MP_NO_ERROR;
    vector<tMediaObject> mediaObjectVector;
    tListID listIDParent;

    ETG_TRACE_USR1(("          ***Test Level1 Create parent list %s***", __PRETTY_FUNCTION__));

    res = helperSetupParentList_LTY_ARTIST_SEARCH(OUT listIDParent,OUT mediaObjectVector);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    //this part is repeated here to give hint for content of list
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField2, "Garbage")); //<-----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField2, "Herbert Grönemeyer"));//<----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField2, "K'Naan"));//<----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField2, "Mando Diao"));//<------Artist

    //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // SUT: System under test
    //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //--------------------------------------------------------------------------
    //create a LTY_ARTIST_SEARCH-list: Parent is above LTY_ARTIST - list, search string is  "e"
    //---------------------------------------------------------------------helperSetupParentList-----

    //-----------------------------------------------------------------------------------------
    //Outputwrapper shell write to queue - has to be setup before search list is created to catch all messages
    //----------------------------------------------------------------------------------------
    ETG_TRACE_USR1(("          ***Test Level2 Outputwrapper starts to write into queue %s***", __PRETTY_FUNCTION__));
    SimulationOutputWrapper *pSimulationOutputWrapper = (SimulationOutputWrapper*)&LocalSPM::GetOutputWrapper();
    CPPUNIT_ASSERT(pSimulationOutputWrapper!=NULL);

    pSimulationOutputWrapper->testMsgQInit();

    //-------------------------------------------------
    // create a list:LTY_SEARCH with search string 'c'
    //-------------------------------------------------
    ETG_TRACE_USR1(("          ***Test Level3 create  fts list %s***", __PRETTY_FUNCTION__));

    //OUT params (additional)
    tListID   listIDSearch   = LIST_ID_NONE;
    tListSize listSize       = tListSize_init;
    tDeviceID deviceIDSearch = DEVICE_ID_NOT_SET;


    //IN params

    tListID listIDReplacable = LIST_ID_NONE;
    tSearchString searchString;
    snprintf(searchString,sizeof(tSearchString),"c"); //<====DEARCH STRING is 'c' no match in LTY_ARTIST - list is expected because neither Garbage,Herbert Grönemeyer,K'Naan,Mando Diao do not contain 'c'

    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedListWithSearchString(
          OUT listIDSearch,
          OUT listSize,
          OUT deviceIDSearch,
          IN  listIDParent,
          IN  listIDReplacable,
          IN  searchString);

    GMPTEST_EXPECT_EQ(res,MP_NO_ERROR);//CPPUNIT_ASSERT(res == MP_NO_ERROR);
    GMPTEST_EXPECT_EQ(listSize,0);//CPPUNIT_ASSERT(listSize == 0); //00 means nothing has been found, at least on element found matching the search string


    //-----------------------------
    //receive asynchronous answers
    //----------------------------

    ETG_TRACE_USR1(("          ***Test Level4 check Answer:First %s***", __PRETTY_FUNCTION__));

    //First answer
    res = helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                       SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnFirst,
                                                                       listIDSearch   /*listIDExpected*/,
                                                                       0              /*listSizeExpected*/,
                                                                       deviceIDSearch /*deviceIDExpected*/);
    GMPTEST_EXPECT_EQ(res,MP_NO_ERROR);//CPPUNIT_ASSERT(res == MP_NO_ERROR);

    ETG_TRACE_USR1(("          ***Test Level5 check Answer:Mid %s***", __PRETTY_FUNCTION__));

    //Middle answers
    //Note to ease testing:
    //       last  middle answer return  listSizeExpected like last  message
    res = helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                       SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnMiddle,
                                                                       listIDSearch   /*listIDExpected*/,
                                                                       0              /*listSizeExpected*/,
                                                                       deviceIDSearch /*deviceIDExpected*/);
    GMPTEST_EXPECT_EQ(res,MP_NO_ERROR);//CPPUNIT_ASSERT(res == MP_NO_ERROR);


    ETG_TRACE_USR1(("          ***Test Level6 check Answer:Last %s***", __PRETTY_FUNCTION__));

    //Last answer
    res = helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                       SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnLast,
                                                                       listIDSearch   /*listIDExpected*/,
                                                                       0              /*listSizeExpected*/,
                                                                       deviceIDSearch /*deviceIDExpected*/);
    GMPTEST_EXPECT_EQ(res,MP_NO_ERROR);//CPPUNIT_ASSERT(res == MP_NO_ERROR);




    //====================================
    //Release List i.e. ListID will be unusable after that
    //=====================================
    ETG_TRACE_USR1(("          ***Test Level7 Release list %s***", __PRETTY_FUNCTION__));
    pSimulationOutputWrapper->testMsqQDelete();
    pSimulationOutputWrapper = NULL;

    res = LocalSPM::GetListControl().ReleaseList(IN listIDSearch); //here list is done
    GMPTEST_EXPECT_EQ(res,MP_NO_ERROR);//CPPUNIT_ASSERT(res == MP_NO_ERROR);


    res = LocalSPM::GetListControl().ReleaseList(IN listIDParent); //here list is done
    GMPTEST_EXPECT_EQ(res,MP_NO_ERROR);//CPPUNIT_ASSERT(res == MP_NO_ERROR);



}

void ListControlTest::CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH(void)
{

    ENTRY_TEST

    //=====================================
    //test setup
    //=====================================
    ETG_TRACE_USR1(("          ***Test Level_1 Create Parent list list %s***", __PRETTY_FUNCTION__));
    tReturnValue res = MP_NO_ERROR;
    vector<tMediaObject> mediaObjectVector;
    tListID listIDParent;


    res = helperSetupParentList_LTY_ARTIST_SEARCH(OUT listIDParent,OUT mediaObjectVector);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    //this part is repeated here to give hint for content of list
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField2, "Garbage")); //<-----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField2, "Herbert Grönemeyer"));//<----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField2, "K'Naan"));//<----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField2, "Mando Diao"));//<------Artist


    //--------------------------------------------------------------------------
    //create a LTY_ARTIST_SEARCH-list: Parent is above LTY_ARTIST - list, search string is  "e"
    //--------------------------------------------------------------------------

    //-------------------------------
    //Outputwrapper shell write to queue
    //------------------------------
    ETG_TRACE_USR1(("          ***Test Level_2 init outputwrapper writing to queue %s***", __PRETTY_FUNCTION__));
    SimulationOutputWrapper *pSimulationOutputWrapper = (SimulationOutputWrapper*)&LocalSPM::GetOutputWrapper();
    CPPUNIT_ASSERT(pSimulationOutputWrapper!=NULL);

    pSimulationOutputWrapper->testMsgQInit();

    //-------------------------------------------------
    // create a list:LTY_SEARCH with search string 'a'
    //-------------------------------------------------
    ETG_TRACE_USR1(("          ***Test Level_3 create searfch list %s***", __PRETTY_FUNCTION__));

    //OUT params (additional)
    tListID   listIDSearch   = LIST_ID_NONE;
    tListSize listSize       = tListSize_init;
    tDeviceID deviceIDSearch = DEVICE_ID_NOT_SET;


    //IN params
    tListID listIDReplacable = LIST_ID_NONE;
    tSearchString searchString;
    snprintf(searchString,sizeof(tSearchString),"a"); //<====SEARCH STRING is 'a' num of expected matches in LTY_ARTIST is 3 i.e. Garbage,K'Naan,Mando Diao"

    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedListWithSearchString(
          OUT listIDSearch,
          OUT listSize,
          OUT deviceIDSearch,
          IN  listIDParent,
          IN listIDReplacable,
          IN  searchString);

    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(1 == listSize); //00 means nothing has been found, at least on element found matching the search string


    //-----------------------------
    //receive asynchronous answers
    //----------------------------
    ETG_TRACE_USR1(("          ***Test Level_4 check answer:First %s***", __PRETTY_FUNCTION__));

    //First answer
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                 SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnFirst,
                                                                 listIDSearch   /*listIDExpected*/,
                                                                 1              /*listSizeExpected*/,
                                                                 deviceIDSearch /*deviceIDExpected*/);

    ETG_TRACE_USR1(("          ***Test Level_5 check answer:Mid %s***", __PRETTY_FUNCTION__));

    //Middle answers
    //Note to ease testing:
    //       first middle answer returns listSizeExpected like first message
    //       last  middle answer return  listSizeExpected like last  message
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                  SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnMiddle,
                                                                  listIDSearch   /*listIDExpected*/,
                                                                  3              /*listSizeExpected*/,
                                                                  deviceIDSearch /*deviceIDExpected*/);

    ETG_TRACE_USR1(("          ***Test Level_6 check answer:Last %s***", __PRETTY_FUNCTION__));

    //Last answer
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                  SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnLast,
                                                                  listIDSearch   /*listIDExpected*/,
                                                                  3              /*listSizeExpected*/,
                                                                  deviceIDSearch /*deviceIDExpected*/);




    //====================================
    //Release List i.e. ListID will be unusable after that
    //=====================================
    ETG_TRACE_USR1(("          ***Test Level_7 delete test q %s***", __PRETTY_FUNCTION__));
    pSimulationOutputWrapper->testMsqQDelete();
    pSimulationOutputWrapper = NULL;

    ETG_TRACE_USR1(("          ***Test Level_8 release lists %s***", __PRETTY_FUNCTION__));

    res = LocalSPM::GetListControl().ReleaseList(IN listIDSearch); //here list is done
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().ReleaseList(IN listIDParent); //here list is done
    CPPUNIT_ASSERT(res == MP_NO_ERROR);


}


void ListControlTest::CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_ReleaseParentListWhichReleaseAlsoSearchList()
{
    ENTRY_TEST

    int levelCounter = 0;
    //=====================================
    //test setup
    //=====================================
    tReturnValue res = MP_NO_ERROR;
    vector<tMediaObject> mediaObjectVector;
    tListID listIDParent;

    ETG_TRACE_USR1(("          ***Test Level_%d create parent list %s***",++levelCounter, __PRETTY_FUNCTION__));

    res = helperSetupParentList_LTY_ARTIST_SEARCH(OUT listIDParent,OUT mediaObjectVector);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    //this part is repeated here to give hint for content of list
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField2, "Garbage")); //<-----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField2, "Herbert Grönemeyer"));//<----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField2, "K'Naan"));//<----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField2, "Mando Diao"));//<------Artist


    //--------------------------------------------------------------------------
    //create a LTY_ARTIST_SEARCH-list: Parent is above LTY_ARTIST - list, search string is  "e"
    //--------------------------------------------------------------------------

    //-------------------------------
    //Outputwrapper shell write to queue
    //------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d output wrapper writes to testq %s***",++levelCounter, __PRETTY_FUNCTION__));
    SimulationOutputWrapper *pSimulationOutputWrapper = (SimulationOutputWrapper*)&LocalSPM::GetOutputWrapper();
    CPPUNIT_ASSERT(pSimulationOutputWrapper!=NULL);

    pSimulationOutputWrapper->testMsgQInit();

    //-------------------------------------------------
    // create a list:LTY_SEARCH with search string 'a'
    //-------------------------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d create fts list %s***",++levelCounter, __PRETTY_FUNCTION__));

    //OUT params (additional)
    tListID   listIDSearch   = LIST_ID_NONE;
    tListSize listSize       = tListSize_init;
    tDeviceID deviceIDSearch = DEVICE_ID_NOT_SET;


    //IN params
    tListID listIDReplacable = LIST_ID_NONE;
    tSearchString searchString;
    snprintf(searchString,sizeof(tSearchString),"a"); //<====SEARCH STRING is 'a' num of expected matches in LTY_ARTIST is 3 i.e. Garbage,K'Naan,Mando Diao"

    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedListWithSearchString(
        OUT listIDSearch,
        OUT listSize,
        OUT deviceIDSearch,
        IN  listIDParent,
        IN listIDReplacable,
        IN  searchString);

    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSize == 1); //00 means nothing has been found, at least on element found matching the search string


    //-----------------------------
    //receive asynchronous answers
    //----------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d check answer:first %s***",++levelCounter, __PRETTY_FUNCTION__));

    //First answer
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                               SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnFirst,
                                                               listIDSearch   /*listIDExpected*/,
                                                               1              /*listSizeExpected*/,
                                                               deviceIDSearch /*deviceIDExpected*/);

    ETG_TRACE_USR1(("          ***Test Level_%d check answer:Mid %s***",++levelCounter, __PRETTY_FUNCTION__));

    //Middle answers
    //Note to ease testing:
    //       first middle answer returns listSizeExpected like first message
    //       last  middle answer return  listSizeExpected like last  message
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnMiddle,
                                                                listIDSearch   /*listIDExpected*/,
                                                                3              /*listSizeExpected*/,
                                                                deviceIDSearch /*deviceIDExpected*/);

    ETG_TRACE_USR1(("          ***Test Level_%d check answer:Last %s***",++levelCounter, __PRETTY_FUNCTION__))

    //Last answer
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnLast,
                                                                listIDSearch   /*listIDExpected*/,
                                                                3              /*listSizeExpected*/,
                                                                deviceIDSearch /*deviceIDExpected*/);




    //====================================
    //Release List i.e. ListID will be unusable after that
    //=====================================
    ETG_TRACE_USR1(("          ***Test Level_%d delete test q %s***",++levelCounter, __PRETTY_FUNCTION__))
    pSimulationOutputWrapper->testMsqQDelete();
    pSimulationOutputWrapper = NULL;


    ETG_TRACE_USR1(("          ***Test Level_%d release lists %s***",++levelCounter, __PRETTY_FUNCTION__))

    res = LocalSPM::GetListControl().ReleaseList(IN listIDParent); //here list is done
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    tListInfo listInfo;
    tResult expectedError;
    expectedError = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listIDParent, false /*with list size*/);
    CPPUNIT_ASSERT(MP_ERR_LC_UNDEFINED_LIST_ID == expectedError);

    //release of parent list should also release child list
    expectedError = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listIDSearch, false /*with list size*/);
    CPPUNIT_ASSERT(MP_ERR_LC_UNDEFINED_LIST_ID == expectedError);

}

//to create MethodReturn_Middle database search is done only for one next element.
void ListControlTest::CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_INCREMENT1()
{
    ENTRY_TEST

    int levelCounter=0;
    //=====================================
    //test setup
    //=====================================
    ETG_TRACE_USR1(("          ***Test Level_%d setup search list  %s***",++levelCounter, __PRETTY_FUNCTION__));

    tReturnValue res = MP_NO_ERROR;
    vector<tMediaObject> mediaObjectVector;
    tListID listIDParent;

    res = helperSetupParentList_LTY_ARTIST_SEARCH(OUT listIDParent,OUT mediaObjectVector);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    //this part is repeated here to give hint for content of list
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField2, "Garbage")); //<-----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField2, "Herbert Grönemeyer"));//<----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField2, "K'Naan"));//<----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField2, "Mando Diao"));//<------Artist

    //--------------------------------------------------------------------------
    //create a LTY_ARTIST_SEARCH-list: Parent is above LTY_ARTIST - list, search string is  "e"
    //--------------------------------------------------------------------------

    //-------------------------------
    //Outputwrapper shell write to queue
    //------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d output wrapper writes to test q %s***",++levelCounter, __PRETTY_FUNCTION__));
    SimulationOutputWrapper *pSimulationOutputWrapper = (SimulationOutputWrapper*)&LocalSPM::GetOutputWrapper();
    CPPUNIT_ASSERT(pSimulationOutputWrapper!=NULL);

    pSimulationOutputWrapper->testMsgQInit();

    //-------------------------------------------------
    // create a list:LTY_SEARCH with search string 'a'
    //-------------------------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d create fts list %s***",++levelCounter, __PRETTY_FUNCTION__));

    //OUT params (additional)
    tListID   listIDSearch   = LIST_ID_NONE;
    tListSize listSize       = tListSize_init;
    tDeviceID deviceIDSearch = DEVICE_ID_NOT_SET;


    //IN params
    tListID          listIDReplacable = LIST_ID_NONE;
    tSearchIncrement seachIncrement = 1; //<--------------------------------------that is why test has inclrement1 in its name
    tSearchString    searchString;
    snprintf(searchString,sizeof(tSearchString),"a"); //<====DEARCH STRING is 'a' num of expected matches in LTY_ARTIST is 3 i.e. Garbage,K'Naan,Mando Diao"

    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedListWithSearchString(
          OUT listIDSearch,
          OUT listSize,
          OUT deviceIDSearch,
          IN  listIDParent,
          IN listIDReplacable,
          IN  searchString,
          IN  seachIncrement);

    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSize == 1); //00 means nothing has been found, at least on element found matching the search string


    //-----------------------------
    //receive asynchronous answers
    //----------------------------

    ETG_TRACE_USR1(("          ***Test Level_%d check answer:FIRST %s***",++levelCounter, __PRETTY_FUNCTION__));

    //First answer
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                 SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnFirst,
                                                                 listIDSearch   /*listIDExpected*/,
                                                                 1              /*listSizeExpected*/,
                                                                 deviceIDSearch /*deviceIDExpected*/,
                                                                 1 /*numOfExpectedMsgs*/);

    ETG_TRACE_USR1(("          ***Test Level_%d check answer:MID %s***",++levelCounter, __PRETTY_FUNCTION__));

    //Middle answers
    //Note to ease testing:
    //       first middle answer returns listSizeExpected like first message
    //       last  middle answer return  listSizeExpected like last  message
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                  SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnMiddle,
                                                                  listIDSearch   /*listIDExpected*/,
                                                                  3              /*listSizeExpected*/,
                                                                  deviceIDSearch /*deviceIDExpected*/,
                                                                  3 /*SearchIncrement is 1, there are 3 results, first has been found with first message i.e. 3-1 = 2 are expected*/);


    ETG_TRACE_USR1(("          ***Test Level_%d check answer:LAST %s***",++levelCounter, __PRETTY_FUNCTION__));

    //Last answer
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                  SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnLast,
                                                                  listIDSearch   /*listIDExpected*/,
                                                                  3              /*listSizeExpected*/,
                                                                  deviceIDSearch /*deviceIDExpected*/,
                                                                  1 /*numOfExpectedMsgs*/);




    //====================================
    //Release List i.e. ListID will be unusable after that
    //=====================================
    ETG_TRACE_USR1(("          ***Test Level_%d delete test q %s***",++levelCounter, __PRETTY_FUNCTION__));
    pSimulationOutputWrapper->testMsqQDelete();
    pSimulationOutputWrapper = NULL;

    ETG_TRACE_USR1(("          ***Test Level_%d release list %s***",++levelCounter, __PRETTY_FUNCTION__));

    res = LocalSPM::GetListControl().ReleaseList(IN listIDSearch); //here list is done
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().ReleaseList(IN listIDParent); //here list is done
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

}

//to create MethodReturn_Middle database search is done only for one next element. After the first increment we abort the search by calling release list
//to do this an test delay has to be added to the mechanism
void ListControlTest::CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_INCREMENT1_ABORT()
{
    ENTRY_TEST

    //=====================================
    //test setup
    //=====================================
    int levelCounter=0;
    ETG_TRACE_USR1(("          ***Test Level_%d create parent list %s***",++levelCounter, __PRETTY_FUNCTION__));

    tReturnValue res = MP_NO_ERROR;
    vector<tMediaObject> mediaObjectVector;
    tListID listIDParent;

    res = helperSetupParentList_LTY_ARTIST_SEARCH(OUT listIDParent,OUT mediaObjectVector);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    //this part is repeated here to give hint for content of list
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField2, "Garbage")); //<-----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField2, "Herbert Grönemeyer"));//<----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField2, "K'Naan"));//<----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField2, "Mando Diao"));//<------Artist

    //--------------------------------------------------------------------------
    //create a LTY_ARTIST_SEARCH-list: Parent is above LTY_ARTIST - list, search string is  "e"
    //--------------------------------------------------------------------------

    //-------------------------------
    //Outputwrapper shell write to queue
    //------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d output wrapper ini to write to test q %s***",++levelCounter, __PRETTY_FUNCTION__));

    SimulationOutputWrapper *pSimulationOutputWrapper = (SimulationOutputWrapper*)&LocalSPM::GetOutputWrapper();
    CPPUNIT_ASSERT(pSimulationOutputWrapper!=NULL);

    pSimulationOutputWrapper->testMsgQInit();

    //-------------------------------------------------
    // create a list:LTY_SEARCH with search string 'a'
    //-------------------------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d create fts list %s***",++levelCounter, __PRETTY_FUNCTION__));

    //OUT params (additional)
    tListID   listIDSearch   = LIST_ID_NONE;
    tListSize listSize       = tListSize_init;
    tDeviceID deviceIDSearch = DEVICE_ID_NOT_SET;


    //IN params
    tListID          listIDReplacable = LIST_ID_NONE;
    tSearchString    searchString;
    tSearchIncrement seachIncrement   = 1; //<------value for test
    tDelaySec        testDelaySec     = 1;  //<------enough to call an abort after first search result

    snprintf(searchString,sizeof(tSearchString),"a"); //<====DEARCH STRING is 'a' num of expected matches in LTY_ARTIST is 3 i.e. Garbage,K'Naan,Mando Diao"

    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedListWithSearchString(
          OUT listIDSearch,
          OUT listSize,
          OUT deviceIDSearch,
          IN  listIDParent,
          IN  listIDReplacable,
          IN  searchString,
          IN  seachIncrement,
          IN  testDelaySec);

    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSize == 1); //00 means nothing has been found, at least on element found matching the search string


    //-----------------------------
    //receive asynchronous answers
    //----------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d check answer:FIRST %s***",++levelCounter, __PRETTY_FUNCTION__));
    //First answer
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                 SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnFirst,
                                                                 listIDSearch   /*listIDExpected*/,
                                                                 1              /*listSizeExpected*/,
                                                                 deviceIDSearch /*deviceIDExpected*/,
                                                                 1 /*numOfExpectedMsgs*/);

    ETG_TRACE_USR1(("          ***Test Level_%d check answer:MID %s***",++levelCounter, __PRETTY_FUNCTION__));

    //Middle answers : catch first and second anawer
    //Note to ease testing:
    //       first middle answer returns listSizeExpected like first message
    //       last  middle answer return  listSizeExpected like last  message
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                  SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnMiddle,
                                                                  listIDSearch   /*listIDExpected*/,
                                                                  1              /*listSizeExpected*/,
                                                                  deviceIDSearch /*deviceIDExpected*/,
                                                                  1 /*SearchIncrement is 1, there are 3 results, first has been found with first message i.e. 3-1 = 2 are expected*/);

    ETG_TRACE_USR1(("          ***Test Level_%d check answer:MID %s***",++levelCounter, __PRETTY_FUNCTION__));
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                  SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnMiddle,
                                                                  listIDSearch   /*listIDExpected*/,
                                                                  2              /*listSizeExpected*/,
                                                                  deviceIDSearch /*deviceIDExpected*/,
                                                                  1 /*SearchIncrement is 1, there are 3 results, first has been found with first message i.e. 3-1 = 2 are expected*/);


    //after the second answer abort is forced due to the testDelaySec each answer is given with a gap of one second. This is enaough for this thread to get the correspodning thread informed to finish
    //alternative would have been to work with a bigger database. But to save test time it has been decided to do major tests first with existing test database

    //++++++++++++++++++++++++++++++++++
    //abort after first two messages have been received
    //++++++++++++++++++++++++++++++++++
    ETG_TRACE_USR1(("          ***Test Level_%d release search list %s***",++levelCounter, __PRETTY_FUNCTION__));

    ETG_TRACE_USR4(("CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_INCREMENT1_ABORT: ReleasList: listIDSearch:%d",listIDSearch))
    res = LocalSPM::GetListControl().ReleaseList(listIDSearch);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    //catch Abort of previous list which has been released
    ETG_TRACE_USR1(("          ***Test Level_%d check answer:ABORT %s***",++levelCounter, __PRETTY_FUNCTION__));
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                    SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnAbort,
                                                                    listIDSearch   /*listIDExpected*/,
                                                                    2              /*listSizeExpected*/,
                                                                    deviceIDSearch /*deviceIDExpected*/,
                                                                    1 /*numOfExpectedMsgs*/);

       ETG_TRACE_USR1(("          ***Test Level_%d check answer:MID %s***",++levelCounter, __PRETTY_FUNCTION__));


    //thread has stopped and due to the test delay not send any message anymore.
    int iNum = pSimulationOutputWrapper->testMsgQGetMsgsInQueue();
    CPPUNIT_ASSERT(iNum == 0);


    //====================================
    //Release List i.e. ListID will be unusable after that
    //=====================================
    ETG_TRACE_USR1(("          ***Test Level_%d delete test message queue %s***",++levelCounter, __PRETTY_FUNCTION__));

    pSimulationOutputWrapper->testMsqQDelete();
    pSimulationOutputWrapper = NULL;

    ETG_TRACE_USR1(("          ***Test Level_%d release lists %s***",++levelCounter, __PRETTY_FUNCTION__));
    res = LocalSPM::GetListControl().ReleaseList(IN listIDSearch);
    CPPUNIT_ASSERT(res == MP_ERR_LC_UNDEFINED_LIST_ID); //because has already been released


    res = LocalSPM::GetListControl().ReleaseList(IN listIDParent); //here list is done
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

}

void ListControlTest::CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_INCREMENT1_REPLACELIST_AfterSearchFinished()
{
    ENTRY_TEST

    //=====================================
    //test setup
    //=====================================
    int levelCounter=0;
    ETG_TRACE_USR1(("          ***Test Level_%d create parent list %s***",++levelCounter, __PRETTY_FUNCTION__));

    tReturnValue res = MP_NO_ERROR;
    vector<tMediaObject> mediaObjectVector;
    tListID listIDParent;


    res = helperSetupParentList_LTY_ARTIST_SEARCH(OUT listIDParent,OUT mediaObjectVector);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    //this part is repeated here to give hint for content of list
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField2, "Garbage")); //<-----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField2, "Herbert Grönemeyer"));//<----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField2, "K'Naan"));//<----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField2, "Mando Diao"));//<------Artist


    //--------------------------------------------------------------------------
    //create a LTY_ARTIST_SEARCH-list: Parent is above LTY_ARTIST - list, search string is  "e"
    //--------------------------------------------------------------------------

    //-------------------------------
    //Outputwrapper shell write to queue
    //------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d output wrapper writes to queue %s***",++levelCounter, __PRETTY_FUNCTION__));

    SimulationOutputWrapper *pSimulationOutputWrapper = (SimulationOutputWrapper*)&LocalSPM::GetOutputWrapper();
    CPPUNIT_ASSERT(pSimulationOutputWrapper!=NULL);

    pSimulationOutputWrapper->testMsgQInit();

    //-------------------------------------------------
    // create a list:LTY_SEARCH with search string 'a'
    //-------------------------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d create fts list %s***",++levelCounter, __PRETTY_FUNCTION__));

    //OUT params (additional)
    tListID   listIDSearch   = LIST_ID_NONE;
    tListSize listSize       = tListSize_init;
    tDeviceID deviceIDSearch = DEVICE_ID_NOT_SET;

    //IN params
    tListID listIDReplacable = LIST_ID_NONE;
    tSearchString searchString;
    snprintf(searchString,sizeof(tSearchString),"a"); //<====SEARCH STRING is 'a' num of expected matches in LTY_ARTIST is 3 i.e. Garbage,K'Naan,Mando Diao"

    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedListWithSearchString(
          OUT listIDSearch,
          OUT listSize,
          OUT deviceIDSearch,
          IN  listIDParent,
          IN listIDReplacable,
          IN  searchString);

    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSize == 1); //00 means nothing has been found, at least on element found matching the search string


    //-----------------------------
    //receive asynchronous answers
    //----------------------------

    ETG_TRACE_USR1(("          ***Test Level_%d async answer:FIRST %s***",++levelCounter, __PRETTY_FUNCTION__));

    //First answer
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                 SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnFirst,
                                                                 listIDSearch   /*listIDExpected*/,
                                                                 1              /*listSizeExpected*/,
                                                                 deviceIDSearch /*deviceIDExpected*/);

    ETG_TRACE_USR1(("          ***Test Level_%d async answer:MID %s***",++levelCounter, __PRETTY_FUNCTION__));

    //Middle answers
    //Note to ease testing:
    //       first middle answer returns listSizeExpected like first message
    //       last  middle answer return  listSizeExpected like last  message
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                  SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnMiddle,
                                                                  listIDSearch   /*listIDExpected*/,
                                                                  3              /*listSizeExpected*/,
                                                                  deviceIDSearch /*deviceIDExpected*/);


    ETG_TRACE_USR1(("          ***Test Level_%d async answer:LAST %s***",++levelCounter, __PRETTY_FUNCTION__));

    //Last answer
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                  SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnLast,
                                                                  listIDSearch   /*listIDExpected*/,
                                                                  3              /*listSizeExpected*/,
                                                                  deviceIDSearch /*deviceIDExpected*/);


    //all messages have been received ok there should be no more in the queue
    int iNum = pSimulationOutputWrapper->testMsgQGetMsgsInQueue();
    CPPUNIT_ASSERT(iNum == 0);


    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //search has finished - create new list with first one replaceable i.e. first one is then automatically deleted
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     ETG_TRACE_USR1(("          ***Test Level_%d Search finished %s***",++levelCounter, __PRETTY_FUNCTION__));
    //-------------------------------------------------
    // create a list:LTY_SEARCH with search string 'b'
    //-------------------------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d create next fts list %s***",++levelCounter, __PRETTY_FUNCTION__));

    //OUT params (additional)
    tListID  listIDSearch2 = LIST_ID_NONE;
    listSize               = tListSize_init;
    deviceIDSearch         = DEVICE_ID_NOT_SET;


    //IN params
    listIDReplacable  = listIDSearch;
    snprintf(searchString,sizeof(tSearchString),"b"); //<====SEARCH STRING is 'a' num of expected matches in LTY_ARTIST is 2 i.e. Garbage,Herbert Grönemeyer"

    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedListWithSearchString(
          OUT listIDSearch2,
          OUT listSize,
          OUT deviceIDSearch,
          IN  listIDParent,
          IN  listIDReplacable,
          IN  searchString);

    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSize == 1); //00 means nothing has been found, 1 means first element has been found

    //old list is expected to be invalid now
    tListInfo listInfo;
    tResult expectedError = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listIDSearch, false /*with list size*/);
    CPPUNIT_ASSERT(MP_ERR_LC_UNDEFINED_LIST_ID == expectedError);


    //new list is expected to have 2 elements
    //-----------------------------
    //receive asynchronous answers
    //----------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d check answer:FIRST %s***",++levelCounter, __PRETTY_FUNCTION__));

     //First answer
     helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                  SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnFirst,
                                                                  listIDSearch2   /*listIDExpected*/,
                                                                  1              /*listSizeExpected*/,
                                                                  deviceIDSearch /*deviceIDExpected*/);

     ETG_TRACE_USR1(("          ***Test Level_%d check answer:MID %s***",++levelCounter, __PRETTY_FUNCTION__));
     //Middle answers
     //Note to ease testing:
     //       first middle answer returns listSizeExpected like first message
     //       last  middle answer return  listSizeExpected like last  message
     helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                   SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnMiddle,
                                                                   listIDSearch2   /*listIDExpected*/,
                                                                   2              /*listSizeExpected*/,
                                                                   deviceIDSearch /*deviceIDExpected*/);

     ETG_TRACE_USR1(("          ***Test Level_%d check answer:LAST %s***",++levelCounter, __PRETTY_FUNCTION__));
     //Last answer
     helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                   SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnLast,
                                                                   listIDSearch2   /*listIDExpected*/,
                                                                   2              /*listSizeExpected*/,
                                                                   deviceIDSearch /*deviceIDExpected*/);

     //all messages have been received ok there should be no more in the queue
     iNum = pSimulationOutputWrapper->testMsgQGetMsgsInQueue();
     CPPUNIT_ASSERT(iNum == 0);
    //====================================
    //Release List i.e. ListID will be unusable after that
    //=====================================
    pSimulationOutputWrapper->testMsqQDelete();
    pSimulationOutputWrapper = NULL;

    ETG_TRACE_USR1(("          ***Test Level_%d release list %s***",++levelCounter, __PRETTY_FUNCTION__));
    res = LocalSPM::GetListControl().ReleaseList(IN listIDSearch); //here list is done
    CPPUNIT_ASSERT(res == MP_ERR_LC_UNDEFINED_LIST_ID);

    res = LocalSPM::GetListControl().ReleaseList(IN listIDSearch2); //here list is done
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().ReleaseList(IN listIDParent); //here list is done
    CPPUNIT_ASSERT(res == MP_NO_ERROR);


}

void ListControlTest::CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_INCREMENT1_REPLACELIST_DuringSearch()
{
    ENTRY_TEST

    //=====================================
    //test setup
    //=====================================
    int levelCounter=0;
    ETG_TRACE_USR1(("          ***Test Level_%d create parent list %s***",++levelCounter, __PRETTY_FUNCTION__));

    tReturnValue res = MP_NO_ERROR;
    vector<tMediaObject> mediaObjectVector;
    tListID listIDParent;

    res = helperSetupParentList_LTY_ARTIST_SEARCH(OUT listIDParent,OUT mediaObjectVector);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    //this part is repeated here to give hint for content of list
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField2, "Garbage")); //<-----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField2, "Herbert Grönemeyer"));//<----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField2, "K'Naan"));//<----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField2, "Mando Diao"));//<------Artist


    //==============================================================================================
    //create a LTY_ARTIST_SEARCH-list: Parent is above LTY_ARTIST - list, search string is  "e"
    //==============================================================================================

    //-------------------------------
    //Outputwrapper shell write to queue
    //------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d outputwrapper writes to queue %s***",++levelCounter, __PRETTY_FUNCTION__));

    SimulationOutputWrapper *pSimulationOutputWrapper = (SimulationOutputWrapper*)&LocalSPM::GetOutputWrapper();
    CPPUNIT_ASSERT(pSimulationOutputWrapper!=NULL);

    pSimulationOutputWrapper->testMsgQInit();

    //-------------------------------------------------
    // create a list:LTY_SEARCH with search string 'a'
    //-------------------------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d create fts list 'a'  %s***",++levelCounter, __PRETTY_FUNCTION__));

    //OUT params (additional)
    tListID   listIDSearch   = LIST_ID_NONE;
    tListSize listSize       = tListSize_init;
    tDeviceID deviceIDSearch = DEVICE_ID_NOT_SET;

    //IN params
    tListID          listIDReplacable = LIST_ID_NONE;
    tSearchString    searchString;
    tSearchIncrement searchIncrement = 1;
    tDelaySec        testDelaySec    = 1;
    snprintf(searchString,sizeof(tSearchString),"a"); //<====SEARCH STRING is 'a' num of expected matches in LTY_ARTIST is 3 i.e. Garbage,K'Naan,Mando Diao"

    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedListWithSearchString(
          OUT listIDSearch,
          OUT listSize,
          OUT deviceIDSearch,
          IN  listIDParent,
          IN  listIDReplacable,
          IN  searchString,
          IN  searchIncrement,
          IN  testDelaySec);

    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSize == 1); //00 means nothing has been found, at least on element found matching the search string


    //-----------------------------
    //receive asynchronous answers
    //----------------------------

       ETG_TRACE_USR1(("          ***Test Level_%d Expect Answer:FIRST  %s***",++levelCounter, __PRETTY_FUNCTION__));

    //First answer
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                 SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnFirst,
                                                                 listIDSearch   /*listIDExpected*/,
                                                                 1              /*listSizeExpected*/,
                                                                 deviceIDSearch /*deviceIDExpected*/);

    ETG_TRACE_USR1(("          ***Test Level_%d Expect Answer:MID  %s***",++levelCounter, __PRETTY_FUNCTION__));

    //Middle answers
    //Note to ease testing:
    //       first middle answer returns listSizeExpected like first message
    //       last  middle answer return  listSizeExpected like last  message
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                  SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnMiddle,
                                                                  listIDSearch   /*listIDExpected*/,
                                                                  2              /*listSizeExpected*/,
                                                                  deviceIDSearch /*deviceIDExpected*/,
                                                                  2              /*numOfExpectedMsgs*/);




    ETG_TRACE_USR1(("          ***Test Level_%d Expect Answer:NO MID expected %s***",++levelCounter, __PRETTY_FUNCTION__));

    //after first received middle answer new list is created. I.e. listIDSearch is deleted with all dependencies

    //all messages have been received ok there should be no more in the queue due to testDelaySec set at creation of list
    // check size of injected delay in other cases
    tUInt iNum = pSimulationOutputWrapper->testMsgQGetMsgsInQueue();
    CPPUNIT_ASSERT(iNum == 0);

    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //create new list with first one replaceable i.e. first one is then automatically deleted - first search finished
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //-------------------------------------------------
    // create a list:LTY_SEARCH with search string 'b'
    //-------------------------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d fts search list 'b':  %s***",++levelCounter, __PRETTY_FUNCTION__));

    //OUT params (additional)
    tListID  listIDSearch2    = LIST_ID_NONE;
    listSize                  = tListSize_init;
    tDeviceID deviceIDSearch2 = DEVICE_ID_NOT_SET;


    //IN params
    listIDReplacable  = listIDSearch;
    snprintf(searchString,sizeof(tSearchString),"b"); //<====SEARCH STRING is 'a' num of expected matches in LTY_ARTIST is 2 i.e. Garbage,Herbert Grönemeyer"



    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedListWithSearchString(
          OUT listIDSearch2,
          OUT listSize,
          OUT deviceIDSearch2,
          IN  listIDParent,
          IN  listIDReplacable,
          IN  searchString);

    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSize == 1); //00 means nothing has been found, 1 means first element has been found

    ETG_TRACE_USR1(("          ***Test Level_%d Expect Answer:ABORT  %s***",++levelCounter, __PRETTY_FUNCTION__));


    //catch last answer of previous list
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                   SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnAbort,
                                                                   listIDSearch   /*listIDExpected*/,
                                                                   2              /*listSizeExpected*/,
                                                                   deviceIDSearch /*deviceIDExpected*/,
                                                                   1              /*numOfExpectedMsgs*/);

    //old list is expected to be invalid now
    tListInfo listInfo;
    tResult expectedError = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listIDSearch, false /*with list size*/);
    CPPUNIT_ASSERT(MP_ERR_LC_UNDEFINED_LIST_ID == expectedError);


    //new list is expected to have 2 elements
    //-----------------------------
    //receive asynchronous answers
    //----------------------------

    ETG_TRACE_USR1(("          ***Test Level_%d check answer:FIRST :  %s***",++levelCounter, __PRETTY_FUNCTION__));

     //First answer
     helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                  SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnFirst,
                                                                  listIDSearch2   /*listIDExpected*/,
                                                                  1              /*listSizeExpected*/,
                                                                  deviceIDSearch /*deviceIDExpected*/);


     ETG_TRACE_USR1(("          ***Test Level_%d check answer:MID :  %s***",++levelCounter, __PRETTY_FUNCTION__));
     //Middle answers
     //Note to ease testing:
     //       first middle answer returns listSizeExpected like first message
     //       last  middle answer return  listSizeExpected like last  message
     helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                   SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnMiddle,
                                                                   listIDSearch2   /*listIDExpected*/,
                                                                   2              /*listSizeExpected*/,
                                                                   deviceIDSearch /*deviceIDExpected*/);



    ETG_TRACE_USR1(("          ***Test Level_%d check answer:LAST :  %s***",++levelCounter, __PRETTY_FUNCTION__));
     //Last answer
     helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                   SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnLast,
                                                                   listIDSearch2   /*listIDExpected*/,
                                                                   2              /*listSizeExpected*/,
                                                                   deviceIDSearch /*deviceIDExpected*/);


    //====================================
    //Release List i.e. ListID will be unusable after that
    //=====================================
    pSimulationOutputWrapper->testMsqQDelete();
    pSimulationOutputWrapper = NULL;


    ETG_TRACE_USR1(("          ***Test Level_%d crelease lists  %s***",++levelCounter, __PRETTY_FUNCTION__));


    res = LocalSPM::GetListControl().ReleaseList(IN listIDSearch); //here list is done
    CPPUNIT_ASSERT(res == MP_ERR_LC_UNDEFINED_LIST_ID);

    res = LocalSPM::GetListControl().ReleaseList(IN listIDSearch2); //here list is done
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().ReleaseList(IN listIDParent); //here list is done
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

}


void ListControlTest::CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_INCREMENT1_REPLACELIST_USER_TYPE_CHARS_AfterEachSearchFinished()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listIDParent;
    vector<tMediaObject> mediaObjectVector;

    //----------------------
    //setup parent list
    //-----------------------
    int levelCounter=0;
    ETG_TRACE_USR1(("          ***Test Level_%d create parent list  %s***",++levelCounter, __PRETTY_FUNCTION__));
    res = helperSetupParentList_LTY_ARTIST_SEARCH(OUT listIDParent, OUT mediaObjectVector);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField2, "Garbage")); //<-----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField2, "Herbert Grönemeyer"));//<----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField2, "K'Naan"));//<----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField2, "Mando Diao"));//<------Artist

    //-------------------------------
    //Outputwrapper shell write to queue
    //------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d outputwrapper writes to queue %s***",++levelCounter, __PRETTY_FUNCTION__));
    SimulationOutputWrapper *pSimulationOutputWrapper = (SimulationOutputWrapper*)&LocalSPM::GetOutputWrapper();
    CPPUNIT_ASSERT(pSimulationOutputWrapper!=NULL);

    pSimulationOutputWrapper->testMsgQInit();


    //-------------------------------------------------
    // create a list:LTY_SEARCH with search string 'a'
    //-------------------------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d create search list 'a'  %s***",++levelCounter, __PRETTY_FUNCTION__));

    //OUT params (additional)
    tListID   listIDSearch      = LIST_ID_NONE;
    tListSize listSize          = tListSize_init;
    tDeviceID deviceIDSearch    = DEVICE_ID_NOT_SET;

    //IN params
    tListID listIDReplacable  = LIST_ID_NONE;
    tSearchString searchString;
    snprintf(searchString,sizeof(tSearchString),"a"); //<====SEARCH STRING is 'a' num of expected matches in LTY_ARTIST is 3: "Garbage","K'Naan","Mando Diao"
    tListSize listSizeExpected = 3;

    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedListWithSearchString(
         OUT listIDSearch,
         OUT listSize,
         OUT deviceIDSearch,
         IN  listIDParent,
         IN  listIDReplacable,
         IN  searchString);

    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSize == 1); //00 means nothing has been found, 1 means first element has been found

    ETG_TRACE_USR1(("          ***Test Level_%d check answers: ALL %s***",++levelCounter, __PRETTY_FUNCTION__));

    helperWaitCheckAnswer_MethodReturnCreateListWithSearchStringAll(pSimulationOutputWrapper,listIDSearch,listSizeExpected,deviceIDSearch);

    //-------------------------------------------------
    // create a list:LTY_SEARCH with search string 'an'
    //-------------------------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d create search list 'an' %s***",++levelCounter, __PRETTY_FUNCTION__));

    //OUT params (additional)
    tListID listIDSearch2      = LIST_ID_NONE;
    listSize          = tListSize_init;
    deviceIDSearch    = DEVICE_ID_NOT_SET;

    //IN params
    listIDReplacable  = listIDSearch;
    //tSearchString searchString;
    snprintf(searchString,sizeof(tSearchString),"an"); //<====SEARCH STRING is 'an' num of expected matches in LTY_ARTIST is 2: "K'Naan","Mando Diao"
    listSizeExpected = 2;

    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedListWithSearchString(
         OUT listIDSearch2,
         OUT listSize,
         OUT deviceIDSearch,
         IN  listIDParent,
         IN  listIDReplacable,
         IN  searchString);

    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSize == 1); //00 means nothing has been found, 1 means first element has been found

    tListInfo listInfo;
    tResult expectedError = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listIDSearch, false /*with list size*/);
    CPPUNIT_ASSERT(MP_ERR_LC_UNDEFINED_LIST_ID == expectedError); //old list is expected to be invalid now

    //receive all asynchronous answers and check if these are ok
    ETG_TRACE_USR1(("          ***Test Level_%d check answers all %s***",++levelCounter, __PRETTY_FUNCTION__));

    helperWaitCheckAnswer_MethodReturnCreateListWithSearchStringAll(pSimulationOutputWrapper,listIDSearch2,listSizeExpected,deviceIDSearch);

    //-------------------------------------------------
    // create a list:LTY_SEARCH with search string 'and'
    //-------------------------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d create search list 'and' %s***",++levelCounter, __PRETTY_FUNCTION__));

    //OUT params (additional)
    tListID listIDSearch3      = LIST_ID_NONE;
    listSize          = tListSize_init;
    deviceIDSearch    = DEVICE_ID_NOT_SET;

    //IN params
    listIDReplacable  = listIDSearch2;
    //tSearchString searchString;
    snprintf(searchString,sizeof(tSearchString),"and"); //<====SEARCH STRING is 'an' num of expected matches in LTY_ARTIST is 1: ,"Mando Diao"
    listSizeExpected = 1;

    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedListWithSearchString(
         OUT listIDSearch3,
         OUT listSize,
         OUT deviceIDSearch,
         IN  listIDParent,
         IN  listIDReplacable,
         IN  searchString);

    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSize == 1); //00 means nothing has been found, 1 means first element has been found

    InitListInfo(listInfo);
    expectedError = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listIDSearch2, false /*with list size*/);
    CPPUNIT_ASSERT(MP_ERR_LC_UNDEFINED_LIST_ID == expectedError); //old list is expected to be invalid now

    //receive all asynchronous answers and check if these are ok
    ETG_TRACE_USR1(("          ***Test Level_%d check answers all %s***",++levelCounter, __PRETTY_FUNCTION__));
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchStringAll(pSimulationOutputWrapper,listIDSearch3,listSizeExpected,deviceIDSearch);

    //-------------------------------------------------
    // create a list:LTY_SEARCH with search string 'b'
    //-------------------------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d create search list 'b' %s***",++levelCounter, __PRETTY_FUNCTION__));

    //OUT params (additional)
    tListID listIDSearch4      = LIST_ID_NONE;
    listSize          = tListSize_init;
    deviceIDSearch    = DEVICE_ID_NOT_SET;

    //IN params
    listIDReplacable  = listIDSearch3;
    //tSearchString searchString;
    snprintf(searchString,sizeof(tSearchString),"b"); //<====SEARCH STRING is 'an' num of expected matches in LTY_ARTIST is 2: ,"Garbage","Herbert Grönemeyer"
    listSizeExpected = 2;

    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedListWithSearchString(
         OUT listIDSearch4,
         OUT listSize,
         OUT deviceIDSearch,
         IN  listIDParent,
         IN  listIDReplacable,
         IN  searchString);

    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSize == 1); //00 means nothing has been found, 1 means first element has been found

    InitListInfo(listInfo);
    expectedError = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listIDSearch3, false /*with list size*/);
    CPPUNIT_ASSERT(MP_ERR_LC_UNDEFINED_LIST_ID == expectedError); //old list is expected to be invalid now

    //receive all asynchronous answers and check if these are ok
    ETG_TRACE_USR1(("          ***Test Level_%d check answers all %s***",++levelCounter, __PRETTY_FUNCTION__));
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchStringAll(pSimulationOutputWrapper,listIDSearch4,listSizeExpected,deviceIDSearch);

    //==========================
    //release list
    //==========================
    ETG_TRACE_USR1(("          ***Test Level_%d release lists %s***",++levelCounter, __PRETTY_FUNCTION__));

    pSimulationOutputWrapper->testMsqQDelete();
    pSimulationOutputWrapper = NULL;

    res = LocalSPM::GetListControl().ReleaseAllLists();
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

}

void ListControlTest::CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_INCREMENT1_REPLACELIST_USER_TYPE_CHARS_DuringEachSearch()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listIDParent;
    vector<tMediaObject> mediaObjectVector;

    //----------------------
    //setup parent list
    //-----------------------
    int levelCounter=0;
    ETG_TRACE_USR1(("          ***Test Level_%d setup parent list %s***",++levelCounter, __PRETTY_FUNCTION__));

    res = helperSetupParentList_LTY_ARTIST_SEARCH(OUT listIDParent, OUT mediaObjectVector);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField2, "Garbage")); //<-----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField2, "Herbert Grönemeyer"));//<----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField2, "K'Naan"));//<----Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField2, "Mando Diao"));//<------Artist

    //-------------------------------
    //Outputwrapper shell write to queue
    //------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d outputwrapper writes to queue %s***",++levelCounter, __PRETTY_FUNCTION__));

    SimulationOutputWrapper *pSimulationOutputWrapper = (SimulationOutputWrapper*)&LocalSPM::GetOutputWrapper();
    CPPUNIT_ASSERT(pSimulationOutputWrapper!=NULL);

    pSimulationOutputWrapper->testMsgQInit();

    //to test thread stopping due to setting up new list with replacable list for the test search is done with database in steps of 1. Additionally a test delay helps the
    //test to interrupt a search. Stop is possible only between increments of search . I.e. it is not an sql-stop
    tSearchIncrement seachIncrement   = 1; //<------value for test
    tDelaySec        testDelaySec     = 1;  //<------enough to call an abort after first search result
    //-------------------------------------------------
    // create a list:LTY_SEARCH with search string 'a'
    //-------------------------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d create search list 'a' %s***",++levelCounter, __PRETTY_FUNCTION__));


    //OUT params (additional)
    tListID   listIDSearch      = LIST_ID_NONE;
    tListSize listSize          = tListSize_init;
    tDeviceID deviceIDSearch    = DEVICE_ID_NOT_SET;

    //IN params
    tListID listIDReplacable  = LIST_ID_NONE;
    tSearchString searchString;
    snprintf(searchString,sizeof(tSearchString),"a"); //<====SEARCH STRING is 'a' num of expected matches in LTY_ARTIST is 3: "Garbage","K'Naan","Mando Diao"
    tListSize listSizeExpected = 3;

    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedListWithSearchString(
        OUT listIDSearch,
        OUT listSize,
        OUT deviceIDSearch,
        IN  listIDParent,
        IN  listIDReplacable,
        IN  searchString,
        IN seachIncrement,
        IN testDelaySec); //<----------Testdelay for answer set!

    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSize == 1); //00 means nothing has been found, 1 means first element has been found

    ETG_TRACE_USR1(("          ***Test Level_%d check for all answers  %s***",++levelCounter, __PRETTY_FUNCTION__));
    int numOfExpectedMiddleMsgsThenStop = 2;
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchStringAll(pSimulationOutputWrapper,listIDSearch,listSizeExpected  ,deviceIDSearch,numOfExpectedMiddleMsgsThenStop);

    //all messages have been received ok there should be no more in the queue due to testDelaySec set at creation of list
    tUInt iNum = pSimulationOutputWrapper->testMsgQGetMsgsInQueue();
    CPPUNIT_ASSERT(iNum == 0);
    //-------------------------------------------------
    // create a list:LTY_SEARCH with search string 'an'
    //-------------------------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d create search list 'an' %s***",++levelCounter, __PRETTY_FUNCTION__));

    //OUT params (additional)
    tListID listIDSearch2        = LIST_ID_NONE;
    listSize                     = tListSize_init;
    tDeviceID deviceIDSearch2    = DEVICE_ID_NOT_SET;

    //IN params
    listIDReplacable  = listIDSearch;
    //tSearchString searchString;
    snprintf(searchString,sizeof(tSearchString),"an"); //<====SEARCH STRING is 'an' num of expected matches in LTY_ARTIST is 2: "K'Naan","Mando Diao"
    tListSize listSizeExpected2 = 2;

    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedListWithSearchString(
        OUT listIDSearch2,
        OUT listSize,
        OUT deviceIDSearch2,
        IN  listIDParent,
        IN  listIDReplacable,
        IN  searchString,
        IN  seachIncrement,
        IN  testDelaySec);

    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSize == 1); //00 means nothing has been found, 1 means first element has been found

    //CATCH LAST MESSAGE OF PREVIOUS LIST
    //because of creation of new list old list search is aborted an abort message is expected here
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                 SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnAbort,
                                                                 listIDSearch     /*listIDExpected*/,
                                                                 numOfExpectedMiddleMsgsThenStop  /*listSizeExpected*/,
                                                                 deviceIDSearch /*deviceIDExpected*/,
                                                                 1 /*numOfExpectedMsgs*/);

    //CHECK IF PREVIOUS LIST IS INVALID NOW
    tListInfo listInfo;
    tResult expectedError = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listIDSearch, false /*with list size*/);
    CPPUNIT_ASSERT(MP_ERR_LC_UNDEFINED_LIST_ID == expectedError); //old list is expected to be invalid now

    //receive all asynchronous answers and check if these are ok
    ETG_TRACE_USR1(("          ***Test Level_%d check for all answers  %s***",++levelCounter, __PRETTY_FUNCTION__));

    numOfExpectedMiddleMsgsThenStop = 2;
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchStringAll(pSimulationOutputWrapper,listIDSearch2,listSizeExpected2,deviceIDSearch2,numOfExpectedMiddleMsgsThenStop);

    //all messages have been received ok there should be no more in the queue due to testDelaySec set at creation of list
    iNum = pSimulationOutputWrapper->testMsgQGetMsgsInQueue();
    CPPUNIT_ASSERT(iNum == 0);

    //-------------------------------------------------
    // create a list:LTY_SEARCH with search string 'and'
    //-------------------------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d create search list 'and' %s***",++levelCounter, __PRETTY_FUNCTION__));

    //OUT params (additional)
    tListID listIDSearch3        = LIST_ID_NONE;
    listSize                     = tListSize_init;
    tDeviceID deviceIDSearch3    = DEVICE_ID_NOT_SET;

    //IN params
    listIDReplacable  = listIDSearch2;
    //tSearchString searchString;
    snprintf(searchString,sizeof(tSearchString),"and"); //<====SEARCH STRING is 'an' num of expected matches in LTY_ARTIST is 1: ,"Mando Diao"
    tListSize listSizeExpected3 = 1;

    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedListWithSearchString(
        OUT listIDSearch3,
        OUT listSize,
        OUT deviceIDSearch3,
        IN  listIDParent,
        IN  listIDReplacable,
        IN  searchString);

    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSize == 1); //00 means nothing has been found, 1 means first element has been found


    //CATCH LAST MESSAGE OF PREVIOUS LIST
    //because of creation of new list old list search is aborted an abort message is expected here
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                     SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnAbort,
                                                                     listIDSearch2     /*listIDExpected*/,
                                                                     numOfExpectedMiddleMsgsThenStop  /*listSizeExpected*/,
                                                                     deviceIDSearch2 /*deviceIDExpected*/,
                                                                     1 /*numOfExpectedMsgs*/);

    InitListInfo(listInfo);
    expectedError = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listIDSearch2, false /*with list size*/);
    CPPUNIT_ASSERT(MP_ERR_LC_UNDEFINED_LIST_ID == expectedError); //old list is expected to be invalid now

    //receive all asynchronous answers and check if these are ok
      ETG_TRACE_USR1(("          ***Test Level_%d check for all answers  %s***",++levelCounter, __PRETTY_FUNCTION__))
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchStringAll(pSimulationOutputWrapper,listIDSearch3,listSizeExpected3,deviceIDSearch3);

    //-------------------------------------------------
    // create a list:LTY_SEARCH with search string 'b'
    //-------------------------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d create search list 'b' %s***",++levelCounter, __PRETTY_FUNCTION__));

       //OUT params (additional)
       tListID listIDSearch4     = LIST_ID_NONE;
       listSize                  = tListSize_init;
       tDeviceID deviceIDSearch4 = DEVICE_ID_NOT_SET;

       //IN params
       listIDReplacable  = listIDSearch3;
       //tSearchString searchString;
       snprintf(searchString,sizeof(tSearchString),"b"); //<====SEARCH STRING is 'an' num of expected matches in LTY_ARTIST is 2: ,"Garbage","Herbert Grönemeyer"
       tListSize listSizeExpected4 = 2;

       res = LocalSPM::GetListControl().CreateMediaPlayerIndexedListWithSearchString(
            OUT listIDSearch4,
            OUT listSize,
            OUT deviceIDSearch4,
            IN  listIDParent,
            IN  listIDReplacable,
            IN  searchString,
            IN seachIncrement,
            IN testDelaySec);

       CPPUNIT_ASSERT(res == MP_NO_ERROR);
       CPPUNIT_ASSERT(listSize == 1); //00 means nothing has been found, 1 means first element has been found




       //Check if previous list does not exist anymore as expected
       InitListInfo(listInfo);
       expectedError = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listIDSearch3, false /*with list size*/);
       CPPUNIT_ASSERT(MP_ERR_LC_UNDEFINED_LIST_ID == expectedError); //old list is expected to be invalid now

       //receive all asynchronous answers and check if these are ok
          ETG_TRACE_USR1(("          ***Test Level_%d check for all answers  %s***",++levelCounter, __PRETTY_FUNCTION__))
       numOfExpectedMiddleMsgsThenStop = 2;
       helperWaitCheckAnswer_MethodReturnCreateListWithSearchStringAll(pSimulationOutputWrapper,listIDSearch4,listSizeExpected4,deviceIDSearch4,numOfExpectedMiddleMsgsThenStop);

       res = LocalSPM::GetListControl().ReleaseList(IN listIDSearch4); //here list is done
       CPPUNIT_ASSERT(res == MP_NO_ERROR);

       //CATCH LAST MESSAGE OF PREVIOUS LIST
       //because of Release of old list search is aborted an abort message is expected here
       helperWaitCheckAnswer_MethodReturnCreateListWithSearchString(pSimulationOutputWrapper,
                                                                    SimulationOutputWrapper::eSend_onCreateMediaPlayerListSearchString_MethodReturnAbort,
                                                                    listIDSearch4     /*listIDExpected*/,
                                                                    listSizeExpected4  /*listSizeExpected*/,
                                                                    deviceIDSearch4 /*deviceIDExpected*/,
                                                                    1 /*numOfExpectedMsgs*/);

       iNum = pSimulationOutputWrapper->testMsgQGetMsgsInQueue(); //due to test delay sending middle messages and ReleaseList which stops the searchlist and its thread there are no more messages in the list
       CPPUNIT_ASSERT(iNum == 0);

       //--------------------------------------------------------
       //all other lists used in this test expected to be not existent anymore
       //--------------------------------------------------------
       ETG_TRACE_USR1(("          ***Test Level_%d release all lists %s***",++levelCounter, __PRETTY_FUNCTION__));
       pSimulationOutputWrapper->testMsqQDelete();
       pSimulationOutputWrapper = NULL;

       res = LocalSPM::GetListControl().ReleaseList(IN listIDSearch);
       CPPUNIT_ASSERT(res == MP_ERR_LC_UNDEFINED_LIST_ID); //because has already been released
       res = LocalSPM::GetListControl().ReleaseList(IN listIDSearch2);
       CPPUNIT_ASSERT(res == MP_ERR_LC_UNDEFINED_LIST_ID); //because has already been released
       res = LocalSPM::GetListControl().ReleaseList(IN listIDSearch3);
       CPPUNIT_ASSERT(res == MP_ERR_LC_UNDEFINED_LIST_ID); //because has already been released
       res = LocalSPM::GetListControl().ReleaseList(IN listIDSearch4);
       CPPUNIT_ASSERT(res == MP_ERR_LC_UNDEFINED_LIST_ID); //because has already been released

}


void ListControlTest::RequestSlice_AfterSearchFinished_LTY_ARTIST_SEARCH()
{
    //same like CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH(); optimize tis later
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listIDParent;
    vector<tMediaObject> mediaObjectVector;

    //======================
    //setup parent list - LTY_ARTIST
    //======================
    int levelCounter = 0;
    ETG_TRACE_USR1(("          ***Test Level_%d create parent list %s***",++levelCounter, __PRETTY_FUNCTION__));
    res = helperSetupParentList_LTY_ARTIST_SEARCH(OUT listIDParent, OUT mediaObjectVector);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    //resulting list of artists with tests content used
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField2, "Garbage"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField2, "Herbert Grönemeyer"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField2, "K'Naan"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField2, "Mando Diao"));

    //-------------------------------
    //Outputwrapper shell write to queue
    //------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d outputwrapper writes to queue %s***",++levelCounter, __PRETTY_FUNCTION__));

    SimulationOutputWrapper *pSimulationOutputWrapper = (SimulationOutputWrapper*)&LocalSPM::GetOutputWrapper();
    CPPUNIT_ASSERT(pSimulationOutputWrapper!=NULL);

    pSimulationOutputWrapper->testMsgQInit();
    //OUT parms (additional)
    tListID   listIDSearch;
    tListSize listSizeFirstAnswer;
    tDeviceID deviceIDSearch;


    //-------------------------------
    //create fts list with 'a'
    //-----------------------------

    ETG_TRACE_USR1(("          ***Test Level_%d create fts search list 'a' %s***",++levelCounter, __PRETTY_FUNCTION__));

    //IN params
    tListID listIDReplacable = LIST_ID_NONE; //no lists should be released with this
    tSearchString searchString;
    snprintf(searchString,sizeof(tSearchString),"a"); //i.e. slize expected is "Garbage","K'Naan","Mando Diao"

    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedListWithSearchString(
          OUT listIDSearch,
          OUT listSizeFirstAnswer,
          OUT deviceIDSearch,
          IN  listIDParent,
          IN  listIDReplacable,
          IN  searchString);

    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSizeFirstAnswer == 1); //0 means: no element found at all, 1 means at least one element has been found paralelle search ahs been started



    //===========================================
    //wait for end of search - i.e. receive all async answers elements
    //===========================================
    ETG_TRACE_USR1(("          ***Test Level_%d check all answers %s***",++levelCounter, __PRETTY_FUNCTION__));

    tListSize listSizeExpected = 3; //i.e. slize expected is "Garbage","K'Naan","Mando Diao"
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchStringAll(pSimulationOutputWrapper,listIDSearch,listSizeExpected,deviceIDSearch);

    //==================================
    //Request Slice of this list
    //==================================
    ETG_TRACE_USR1(("          ***Test Level_%d get ListSlize %s***",++levelCounter, __PRETTY_FUNCTION__));
    mediaObjectVector.clear();
    tListSize  len = mediaObjectVector.size();

        /* second ask for all albums */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listIDSearch,
            0,
            listSizeExpected);//<------asks for maximum size available

    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    len = mediaObjectVector.size();
    CPPUNIT_ASSERT(len== listSizeExpected);

    //those which fit to search string 'a' only. Metadata fiel2 is for Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField1, "Alternative")); //genre
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField2, "Garbage"));//artist
    CPPUNIT_ASSERT(mediaObjectVector[0].catType == CTY_ARTIST);//artist

    //CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField1, "German Pop")); //genre
    //CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField2, "Herbert Grönemeyer")); //artist

    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField1, "Hip-Hop"));//genre
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField2, "K'Naan")); //artist
    CPPUNIT_ASSERT(mediaObjectVector[1].catType == CTY_ARTIST);//artist

    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField1, "Rock")); //genre
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField2, "Mando Diao")); //artist
    CPPUNIT_ASSERT(mediaObjectVector[2].catType ==CTY_ARTIST);//artist


    //====================================
    //Release List i.e. ListID will be unusable after that
    //=====================================
    ETG_TRACE_USR1(("          ***Test Level_%d get Release List %s***",++levelCounter, __PRETTY_FUNCTION__));

    pSimulationOutputWrapper->testMsqQDelete();
    pSimulationOutputWrapper = NULL;

    res = LocalSPM::GetListControl().ReleaseList(IN listIDSearch); //here list is done
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().ReleaseList(IN listIDParent); //here list is done
    CPPUNIT_ASSERT(res == MP_NO_ERROR);


}


void ListControlTest::RequestSliceSizeToHigh_AfterSearchFinished_LTY_ARTIST_SEARCH()
{
    //same like CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH(); optimize tis later
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listIDParent;
    vector<tMediaObject> mediaObjectVector;

    //======================
    //setup parent list - LTY_ARTIST
    //======================
    int levelCounter=0;
    ETG_TRACE_USR1(("          ***Test Level_%d create parant List %s***",++levelCounter, __PRETTY_FUNCTION__));

    res = helperSetupParentList_LTY_ARTIST_SEARCH(OUT listIDParent, OUT mediaObjectVector);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    //resulting list of artists with tests content used
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField2, "Garbage"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField2, "Herbert Grönemeyer"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField2, "K'Naan"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField2, "Mando Diao"));


    //-------------------------------
    //Outputwrapper shell write to queue
    //------------------------------
    SimulationOutputWrapper *pSimulationOutputWrapper = (SimulationOutputWrapper*)&LocalSPM::GetOutputWrapper();
    CPPUNIT_ASSERT(pSimulationOutputWrapper!=NULL);

    pSimulationOutputWrapper->testMsgQInit();

    //-------------------------------
    //Outputwrapper shell write to queue
    //------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d search list 'a' %s***",++levelCounter, __PRETTY_FUNCTION__));
    //OUT parms (additional)
    tListID   listIDSearch;
    tListSize listSizeFirstAnswer;
    tDeviceID deviceIDSearch;

    //IN params
    tListID listIDReplacable = LIST_ID_NONE; //no lists should be released with this
    tSearchString searchString;
    snprintf(searchString,sizeof(tSearchString),"a"); //i.e. slize expected is "Garbage","K'Naan","Mando Diao"

    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedListWithSearchString(
          OUT listIDSearch,
          OUT listSizeFirstAnswer,
          OUT deviceIDSearch,
          IN  listIDParent,
          IN  listIDReplacable,
          IN  searchString);

    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSizeFirstAnswer == 1); //0 means: no element found at all, 1 means at least one element has been found paralelle search ahs been started


    //===========================================
    //wait for end of search - i.e. receive all async answers elements
    //===========================================
    ETG_TRACE_USR1(("          ***Test Level_%d check answers:all %s***",++levelCounter, __PRETTY_FUNCTION__));
    tListSize listSizeExpected = 3; //i.e. slize expected is "Garbage","K'Naan","Mando Diao"
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchStringAll(pSimulationOutputWrapper,listIDSearch,listSizeExpected,deviceIDSearch);

    //==================================
    //Request Slice of this list
    //==================================
    ETG_TRACE_USR1(("          ***Test Level_%d get & check ListSlize %s***",++levelCounter, __PRETTY_FUNCTION__));

    mediaObjectVector.clear();
    tListSize  len = mediaObjectVector.size();

        /* second ask for all albums */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listIDSearch,
            0,
            listSizeExpected+10);//<------asks for more then available in the list. Normally one should only demand based on the received listzize! I.e. Robus implmentation offers this with the 5

    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    len = mediaObjectVector.size();
    CPPUNIT_ASSERT(len== listSizeExpected);

    //those which fit to search string 'a' only. Metadata fiel2 is for Artist
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField1, "Alternative")); //genre
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField2, "Garbage"));//artist

    //CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField1, "German Pop")); //genre
    //CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField2, "Herbert Grönemeyer")); //artist

    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField1, "Hip-Hop"));//genre
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField2, "K'Naan")); //artist

    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField1, "Rock")); //genre
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField2, "Mando Diao")); //artist


    //====================================
    //Release List i.e. ListID will be unusable after that
    //=====================================
    ETG_TRACE_USR1(("          ***Test Level_%d release lists %s***",++levelCounter, __PRETTY_FUNCTION__));

    pSimulationOutputWrapper->testMsqQDelete();
    pSimulationOutputWrapper = NULL;

    res = LocalSPM::GetListControl().ReleaseList(IN listIDSearch); //here list is done
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().ReleaseList(IN listIDParent); //here list is done
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

}



void ListControlTest::RequestSlice_AfterRleaseOfList_LTY_ARTIST_SEARCH()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listIDParent;
    vector<tMediaObject> mediaObjectVector;

    //======================
    //setup parent list - LTY_ARTIST
    //======================
    int levelCounter = 0;
    ETG_TRACE_USR1(("          ***Test Level_%d create parent list %s***",++levelCounter, __PRETTY_FUNCTION__));

    res = helperSetupParentList_LTY_ARTIST_SEARCH(OUT listIDParent, OUT mediaObjectVector);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    //resulting list of artists with tests content used
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField2, "Garbage"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[1].MetadataField2, "Herbert Grönemeyer"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[2].MetadataField2, "K'Naan"));
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[3].MetadataField2, "Mando Diao"));



    //-------------------------------
    //Outputwrapper shell write to queue
    //------------------------------
    ETG_TRACE_USR1(("          ***Test Level_%d outputwrapper writes to queue %s***",++levelCounter, __PRETTY_FUNCTION__));
    SimulationOutputWrapper *pSimulationOutputWrapper = (SimulationOutputWrapper*)&LocalSPM::GetOutputWrapper();
    CPPUNIT_ASSERT(pSimulationOutputWrapper!=NULL);

    pSimulationOutputWrapper->testMsgQInit();



    ETG_TRACE_USR1(("          ***Test Level_%d create search list 'a'%s***",++levelCounter, __PRETTY_FUNCTION__));

    //OUT parms (additional)
    tListID   listIDSearch;
    tListSize listSizeFirstAnswer;
    tDeviceID deviceIDSearch;

    //IN params
    tListID listIDReplacable = LIST_ID_NONE; //no lists should be released with this
    tSearchString searchString;
    snprintf(searchString,sizeof(tSearchString),"a"); //i.e. slize expected is "Garbage","K'Naan","Mando Diao"

    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedListWithSearchString(
       OUT listIDSearch,
       OUT listSizeFirstAnswer,
       OUT deviceIDSearch,
       IN  listIDParent,
       IN  listIDReplacable,
       IN  searchString);

    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listSizeFirstAnswer == 1); //0 means: no element found at all, 1 means at least one element has been found paralelle search ahs been started




    //===========================================
    //wait for end of search - i.e. receive all async answers elements
    //===========================================
    ETG_TRACE_USR1(("          ***Test Level_%d check all answers 'a' %s***",++levelCounter, __PRETTY_FUNCTION__));

    tListSize listSizeExpected = 3; //i.e. slize expected is "Garbage","K'Naan","Mando Diao"
    helperWaitCheckAnswer_MethodReturnCreateListWithSearchStringAll(pSimulationOutputWrapper,listIDSearch,listSizeExpected,deviceIDSearch);


    //==========================================
    //Release the list - afterwards Request of list slice should fail
    //==========================================
    res = LocalSPM::GetListControl().ReleaseList(IN listIDSearch); //here list is done
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    //==================================
    //Request Slice of this list
    //==================================
    ETG_TRACE_USR1(("          ***Test Level_%d get&check ListSlize %s***",++levelCounter, __PRETTY_FUNCTION__));

    mediaObjectVector.clear();
    tListSize  len = mediaObjectVector.size();

     /* second ask for all albums */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
         OUT mediaObjectVector,
         IN listIDSearch,
         0,
         listSizeExpected);

    CPPUNIT_ASSERT(res != MP_NO_ERROR);
    len = mediaObjectVector.size();
    CPPUNIT_ASSERT(len== 0);

    //====================================
    //Release List i.e. ListID will be unusable after that
    //=====================================
    ETG_TRACE_USR1(("          ***Test Level_%d release lists %s***",++levelCounter, __PRETTY_FUNCTION__));

    //delete test mesg queue to have clean situation for next round
    pSimulationOutputWrapper->testMsqQDelete();
    pSimulationOutputWrapper = NULL;

    res = LocalSPM::GetListControl().ReleaseList(IN listIDSearch);
    CPPUNIT_ASSERT(res == MP_ERR_LC_UNDEFINED_LIST_ID); //because has already been released

    res = LocalSPM::GetListControl().ReleaseList(IN listIDParent); //here list is done
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

}
void ListControlTest::RequestSlice_LTY_ARTIST_SEARCH_INCREMENT1_SEVERALSLIZES()
{
    ENTRY_TEST
}

//===========================================================
//Test function type: wrong usage of interface scenarios
//===========================================================


void ListControlTest::CreateMediaPlayerIndexedListWithSearchString_LTY_ARTIST_SEARCH_CreateMoreThatOneList()
{
    ENTRY_TEST
}






//===========================================================
//Test function type: check all other types of lists
//===========================================================
tResult ListControlTest::helperSetupParentList_FullTextSearch(OUT tListID &listIDParent, IN tListType listType, IN tDeviceType testDevice)
{

    ENTRY
    ETG_TRACE_USR2(("%s", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;

    //init OUT-values
    listIDParent = LIST_ID_NONE;


    //=====================================
    //test setup
    //=====================================
    tListID listID ;
    tListSize listSize;
    tListSize listSizeExpected = tListSize_init;
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID;

    tListID listIDBaseParent = LIST_ID_NONE;
    tMediaObject MediaObject;
    InitMediaObject(MediaObject);
    std::string stringToFind = "";

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, testDevice);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);


    /* these lists have been communicated by the feature owner AIVI to be realised*/

    switch(listType)
    {
        //--------------------
        case LTY_GENRE:
        //--------------------
           ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_GENRE"));
           tag1.tag = 0;
           tag2.tag = 0;
           tag3.tag = 0;
           tag4.tag = 0;
           listSizeExpected = 4;
           break;
        //--------------------
        case LTY_ARTIST:
        //--------------------
           ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_ARTIST"));
           tag1.tag = 0;
           tag2.tag = 0;
           tag3.tag = 0;
           tag4.tag = 0;
           listSizeExpected = 4;
           break;
        //--------------------
        case  LTY_ALBUM:
        //--------------------
           ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_ALBUM"));
           tag1.tag = 0;
           tag2.tag = 0;
           tag3.tag = 0;
           tag4.tag = 0;
           listSizeExpected = 4;
           break;
       //--------------------
       case  LTY_COMPILATION:
       //--------------------
          ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_COMPILATION"));
          tag1.tag = 0;
          tag2.tag = 0;
          tag3.tag = 0;
          tag4.tag = 0;
          listSizeExpected = 3;
          break;
        //--------------------
        case  LTY_SONG:
        //--------------------
           ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_SONG"));
           tag1.tag = 0;
           tag2.tag = 0;
           tag3.tag = 0;
           tag4.tag = 0;
           listSizeExpected = 31;
           break;
        //--------------------
        case  LTY_PODCAST:
        //--------------------
           ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_PODCAST"));
           tag1.tag = 0;
           tag2.tag = 0;
           tag3.tag = 0;
           tag4.tag = 0;
           listSizeExpected = 3;
           break;
        //--------------------
        case  LTY_AUDIOBOOK:
        //--------------------
           ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_AUDIOBOOK"));
           tag1.tag = 0;
           tag2.tag = 0;
           tag3.tag = 0;
           tag4.tag = 0;
           listSizeExpected = 3;
           break;
        //---------------------
        case LTY_GENRE_ARTIST:
        //---------------------
           ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_GENRE_ARTIST"));

           //setup base parent genre list
           listIDBaseParent = LIST_ID_NONE;
           res = helperSetupParentList_FullTextSearch(OUT listIDBaseParent, LTY_GENRE);//recursive call
           CPPUNIT_ASSERT(res == MP_NO_ERROR);
           CPPUNIT_ASSERT(listIDBaseParent != LIST_ID_NONE);

           res = helperShowContentParentList(listIDBaseParent);
           CPPUNIT_ASSERT(res == MP_NO_ERROR);


           //find first genre and get MetadataTag1 of this
           stringToFind = "German Pop";
           InitMediaObject(MediaObject);
           res = helperGetElementFromList(OUT MediaObject, IN stringToFind, IN listIDBaseParent);
           CPPUNIT_ASSERT(res == MP_NO_ERROR);
           CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField1, stringToFind.c_str()));

           //fill tag
           tag1.genre = MediaObject.MetadataTag1;
           tag2.tag   = 0;
           tag3.tag   = 0;
           tag4.tag   = 0;
           listSizeExpected = 1;
           break;

        //---------------------------
        case LTY_GENRE_ARTIST_ALBUM:
        //--------------------------
           ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_GENRE_ARTIST_ALBUM"));

           //setup base parent genre list
           listIDBaseParent = LIST_ID_NONE;
           res = helperSetupParentList_FullTextSearch(OUT listIDBaseParent, LTY_GENRE);//recursive call
           CPPUNIT_ASSERT(res == MP_NO_ERROR);
           CPPUNIT_ASSERT(listIDBaseParent != LIST_ID_NONE);

           res = helperShowContentParentList(listIDBaseParent);
           CPPUNIT_ASSERT(res == MP_NO_ERROR);

           //find first genre and get MetadataTag1 of this
           stringToFind = "Hip-Hop";
           InitMediaObject(MediaObject);
           res = helperGetElementFromList(OUT MediaObject, IN stringToFind, IN listIDBaseParent);
           CPPUNIT_ASSERT(res == MP_NO_ERROR);
           CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField1, stringToFind.c_str()));
           CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField2,"K'Naan")); //artist

           //fill tag
           tag1.genre  = MediaObject.MetadataTag1;
           tag2.artist = MediaObject.MetadataTag2;
           tag3.tag    = 0;
           tag4.tag    = 0;
           listSizeExpected = 1;
           break;
        //-------------------------------
        case LTY_GENRE_ARTIST_ALBUM_SONG:
        //-------------------------------
           ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_GENRE_ARTIST_ALBUM_SONG"));

           //setup base parent genre list
           listIDBaseParent = LIST_ID_NONE;
           res = helperSetupParentList_FullTextSearch(OUT listIDBaseParent, LTY_GENRE);//recursive call
           CPPUNIT_ASSERT(res == MP_NO_ERROR);
           CPPUNIT_ASSERT(listIDBaseParent != LIST_ID_NONE);

           res = helperShowContentParentList(listIDBaseParent);
           CPPUNIT_ASSERT(res == MP_NO_ERROR);

           //find first genre and get MetadataTag1 of this
           stringToFind = "Hip-Hop";
           InitMediaObject(MediaObject);
           res = helperGetElementFromList(OUT MediaObject, IN stringToFind, IN listIDBaseParent);
           CPPUNIT_ASSERT(res == MP_NO_ERROR);
           CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField1, stringToFind.c_str()));
           CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField2,"K'Naan"));  //artist
           CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField4,"2010 FIFA World Cup Anthem")); //album

           //fill tag
           tag1.genre  = MediaObject.MetadataTag1;
           tag2.artist = MediaObject.MetadataTag2;
           tag3.tag    = 0;
           tag4.album  = MediaObject.MetadataTag4;
           listSizeExpected = 1;
           break;
        //--------------------------
        case  LTY_GENRE_ARTIST_SONG:
        //--------------------------
           ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_GENRE_ARTIST_SONG"));

           //setup base parent genre list
           listIDBaseParent = LIST_ID_NONE;
           res = helperSetupParentList_FullTextSearch(OUT listIDBaseParent, LTY_GENRE);//recursive call
           CPPUNIT_ASSERT(res == MP_NO_ERROR);
           CPPUNIT_ASSERT(listIDBaseParent != LIST_ID_NONE);

           res = helperShowContentParentList(listIDBaseParent);
           CPPUNIT_ASSERT(res == MP_NO_ERROR);

           //find first genre and get MetadataTag1 of this
           stringToFind = "Hip-Hop";
           InitMediaObject(MediaObject);
           res = helperGetElementFromList(OUT MediaObject, IN stringToFind, IN listIDBaseParent);
           CPPUNIT_ASSERT(res == MP_NO_ERROR);
           CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField1, stringToFind.c_str()));
           CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField2,"K'Naan"));  //artist


           //fill tag
           tag1.genre  = MediaObject.MetadataTag1;
           tag2.artist = MediaObject.MetadataTag2;
           tag3.tag    = 0;
           tag4.album  = 0;
           listSizeExpected = 1;
           break;

        //--------------------
        case  LTY_GENRE_ALBUM:
        //--------------------
           ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_GENRE_ALBUM"));

           //setup base parent  genre list
           listIDBaseParent = LIST_ID_NONE;
           res = helperSetupParentList_FullTextSearch(OUT listIDBaseParent, LTY_GENRE); //recursive call
           CPPUNIT_ASSERT(res == MP_NO_ERROR);
           CPPUNIT_ASSERT(listIDBaseParent != LIST_ID_NONE);

           res = helperShowContentParentList(listIDBaseParent);
           CPPUNIT_ASSERT(res == MP_NO_ERROR);

           //find first genre and get MetadataTag1 of this
           stringToFind = "German Pop";
           InitMediaObject(MediaObject);
           res = helperGetElementFromList(OUT MediaObject, IN stringToFind, IN listIDBaseParent);;
           CPPUNIT_ASSERT(res == MP_NO_ERROR);
           CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField1, stringToFind.c_str()));

           //fill tag
           tag1.genre = MediaObject.MetadataTag1;
           tag2.tag   = 0;
           tag3.tag   = 0;
           tag4.tag   = 0;
           listSizeExpected = 1;
           break;
        //---------------------------
        case LTY_GENRE_ALBUM_SONG:
        //---------------------------
            ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_GENRE_ALBUM_SONG"));

           //setup base parent  genre list
            listIDBaseParent = LIST_ID_NONE;
            res = helperSetupParentList_FullTextSearch(OUT listIDBaseParent, LTY_GENRE); //recursive call
            CPPUNIT_ASSERT(res == MP_NO_ERROR);
            CPPUNIT_ASSERT(listIDBaseParent != LIST_ID_NONE);

            res = helperShowContentParentList(listIDBaseParent);
            CPPUNIT_ASSERT(res == MP_NO_ERROR);

            //find first genre and get MetadataTag1 of this
            stringToFind = "German Pop";
            InitMediaObject(MediaObject);
            res = helperGetElementFromList(OUT MediaObject, IN stringToFind, IN listIDBaseParent);
            CPPUNIT_ASSERT(res == MP_NO_ERROR);
            CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField1, stringToFind.c_str()));
            CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField4, "Bleibt Alles Anders"));

            //fill tag
            tag1.genre = MediaObject.MetadataTag1;
            tag2.tag   = 0;
            tag3.tag   = 0;
            tag4.album = MediaObject.MetadataTag4;
            listSizeExpected = 3;
            break;

        //---------------------
        case  LTY_GENRE_SONG:
        //---------------------
           ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_GENRE_SONG"));

           //setup base parent  genre list
           listIDBaseParent = LIST_ID_NONE;
           res = helperSetupParentList_FullTextSearch(OUT listIDBaseParent, LTY_GENRE); //recursive call
           CPPUNIT_ASSERT(res == MP_NO_ERROR);
           CPPUNIT_ASSERT(listIDBaseParent != LIST_ID_NONE);

           res = helperShowContentParentList(listIDBaseParent);
           CPPUNIT_ASSERT(res == MP_NO_ERROR);

           //find first genre and get MetadataTag1 of this
           stringToFind = "German Pop";
           InitMediaObject(MediaObject);
           res = helperGetElementFromList(OUT MediaObject, IN stringToFind, IN listIDBaseParent);
           CPPUNIT_ASSERT(res == MP_NO_ERROR);
           CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField1, stringToFind.c_str()));

           //fill tag
           tag1.genre = MediaObject.MetadataTag1;
           tag2.tag   = 0;
           tag3.tag   = 0;
           tag4.tag   = 0;
           listSizeExpected = 3;
           break;

        //-----------------------
        case LTY_ARTIST_ALBUM:
        //-----------------------
           ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_ARTIST_ALBUM"));

           //setup base parent genre list
           listIDBaseParent = LIST_ID_NONE;
           res = helperSetupParentList_FullTextSearch(OUT listIDBaseParent, LTY_ARTIST);//recursive call
           CPPUNIT_ASSERT(res == MP_NO_ERROR);
           CPPUNIT_ASSERT(listIDBaseParent != LIST_ID_NONE);

           res = helperShowContentParentList(listIDBaseParent);
           CPPUNIT_ASSERT(res == MP_NO_ERROR);

           //find first genre and get MetadataTag1 of this
           stringToFind = "Mando Diao"; //<--artist
           InitMediaObject(MediaObject);
           res = helperGetElementFromList(OUT MediaObject, IN stringToFind, IN listIDBaseParent);
           CPPUNIT_ASSERT(res == MP_NO_ERROR);
           CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField2, stringToFind.c_str()));

           //fill tag
           tag1.tag     = 0;
           tag2.artist  = MediaObject.MetadataTag2;
           tag3.tag     = 0;
           tag4.tag     = 0;
           listSizeExpected = 1;
           break;
        //-----------------------
        case LTY_ARTIST_ALBUM_SONG:
        //-----------------------
           ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_ARTIST_ALBUM_SONG"));

           //setup base parent genre list
            listIDBaseParent = LIST_ID_NONE;
            res = helperSetupParentList_FullTextSearch(OUT listIDBaseParent, LTY_ARTIST);//recursive call
            CPPUNIT_ASSERT(res == MP_NO_ERROR);
            CPPUNIT_ASSERT(listIDBaseParent != LIST_ID_NONE);

            res = helperShowContentParentList(listIDBaseParent);
            CPPUNIT_ASSERT(res == MP_NO_ERROR);

            //find first genre and get MetadataTag1 of this
            stringToFind = "Herbert Grönemeyer"; //<--artist
            InitMediaObject(MediaObject);
            res = helperGetElementFromList(OUT MediaObject, IN stringToFind, IN listIDBaseParent);
            CPPUNIT_ASSERT(res == MP_NO_ERROR);
            CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField2, stringToFind.c_str()));  //check found artists
            CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField4, "Bleibt Alles Anders")); //check found album

           tag1.tag     = 0;
           tag2.artist  = MediaObject.MetadataTag2;
           tag3.tag     = 0;
           tag4.album   = MediaObject.MetadataTag4;
           listSizeExpected = 3;
           break;

        //-----------------------
        case  LTY_ARTIST_SONG:
        //-----------------------
            ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_ARTIST_SONG"));

            //setup base parent genre list
            listIDBaseParent = LIST_ID_NONE;
            res = helperSetupParentList_FullTextSearch(OUT listIDBaseParent, LTY_ARTIST);//recursive call
            CPPUNIT_ASSERT(res == MP_NO_ERROR);
            CPPUNIT_ASSERT(listIDBaseParent != LIST_ID_NONE);

            res = helperShowContentParentList(listIDBaseParent);
            CPPUNIT_ASSERT(res == MP_NO_ERROR);

            //find artist
            stringToFind = "Herbert Grönemeyer"; //<--artist
            InitMediaObject(MediaObject);
            res = helperGetElementFromList(OUT MediaObject, IN stringToFind, IN listIDBaseParent);
            CPPUNIT_ASSERT(res == MP_NO_ERROR);
            CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField2, stringToFind.c_str()));

            //fill tag
            tag1.tag     = 0;
            tag2.artist  = MediaObject.MetadataTag2;
            tag3.tag     = 0;
            tag4.tag     = 0;
            listSizeExpected = 3;
            break;

        //--------------------
        case LTY_ALBUM_SONG:
        //--------------------
           ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_ALBUM_SONG"));

           //setup base parent genre list
           listIDBaseParent = LIST_ID_NONE;
           res = helperSetupParentList_FullTextSearch(OUT listIDBaseParent, LTY_ALBUM);//recursive call
           CPPUNIT_ASSERT(res == MP_NO_ERROR);
           CPPUNIT_ASSERT(listIDBaseParent != LIST_ID_NONE);

           res = helperShowContentParentList(listIDBaseParent);
           CPPUNIT_ASSERT(res == MP_NO_ERROR);

           //find falbum
           stringToFind = "Bleibt Alles Anders";
           InitMediaObject(MediaObject);
           res = helperGetElementFromList(OUT MediaObject, IN stringToFind, IN listIDBaseParent);

           CPPUNIT_ASSERT(res == MP_NO_ERROR);
           CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField4, stringToFind.c_str()));

           //fill tag
           tag1.tag     = 0;
           tag2.tag     = 0;
           tag3.tag     = 0;
           tag4.album   = MediaObject.MetadataTag4;
           listSizeExpected = 3;
           break;

        //------------------------
        case LTY_COMPILATION_SONG:
        //------------------------
           ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_COMPILATION_SONG"));

           //setup base parent genre list
           listIDBaseParent = LIST_ID_NONE;
           res = helperSetupParentList_FullTextSearch(OUT listIDBaseParent, LTY_COMPILATION);//recursive call
           CPPUNIT_ASSERT(res == MP_NO_ERROR);
           CPPUNIT_ASSERT(listIDBaseParent != LIST_ID_NONE);

           res = helperShowContentParentList(listIDBaseParent);
           CPPUNIT_ASSERT(res == MP_NO_ERROR);

           //find falbum
           stringToFind = "CompilationName1";
           InitMediaObject(MediaObject);
           res = helperGetElementFromList(OUT MediaObject, IN stringToFind, IN listIDBaseParent);

           CPPUNIT_ASSERT(res == MP_NO_ERROR);
           CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField4, stringToFind.c_str()));
           CPPUNIT_ASSERT(MediaObject.compilationFlag == 1); //<-------------additional this flag is set for type LTY_COMPILATION

           //fill tag
           tag1.tag     = 0;
           tag2.tag     = 0;
           tag3.tag     = 0;
           tag4.album   = MediaObject.MetadataTag4;
           listSizeExpected = 10;
           break;


            //------------------------
           case  LTY_PODCAST_EPISODE:
           //------------------------
               ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_PODCAST_EPISODE"));

               //setup base parent genre list
               listIDBaseParent = LIST_ID_NONE;
               res = helperSetupParentList_FullTextSearch(OUT listIDBaseParent, LTY_PODCAST,testDevice);//recursive call
               CPPUNIT_ASSERT(res == MP_NO_ERROR);
               CPPUNIT_ASSERT(listIDBaseParent != LIST_ID_NONE);

               res = helperShowContentParentList(listIDBaseParent);
               CPPUNIT_ASSERT(res == MP_NO_ERROR);

               //find artist
               stringToFind = "PodcastName1";
               InitMediaObject(MediaObject);
               res = helperGetElementFromList(OUT MediaObject, IN stringToFind, IN listIDBaseParent);
               CPPUNIT_ASSERT(res == MP_NO_ERROR);
               CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField1, stringToFind.c_str()));

               //fill tag
               tag1.podcast     = MediaObject.MetadataTag1;
               tag2.tag     = 0;
               tag3.tag     = 0;
               tag4.tag     = 0;
               listSizeExpected = 10;
               break;

            //----------------------------------
            case  LTY_BOOKTITLE_CHAPTER:
            //-----------------------------------
               ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_BOOKTITLE_CHAPTER"));

               //setup base parent genre list
               listIDBaseParent = LIST_ID_NONE;
               res = helperSetupParentList_FullTextSearch(OUT listIDBaseParent, LTY_AUDIOBOOK,testDevice);//recursive call
               CPPUNIT_ASSERT(res == MP_NO_ERROR);
               CPPUNIT_ASSERT(listIDBaseParent != LIST_ID_NONE);

               res = helperShowContentParentList(listIDBaseParent);
               CPPUNIT_ASSERT(res == MP_NO_ERROR);

               //find artist
               stringToFind = "AudioBookName1";
               InitMediaObject(MediaObject);
               res = helperGetElementFromList(OUT MediaObject, IN stringToFind, IN listIDBaseParent);
               CPPUNIT_ASSERT(res == MP_NO_ERROR);
               CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField2, stringToFind.c_str()));

               //fill tag
               tag1.podcast     = 0;
               tag2.audiobook   = MediaObject.MetadataTag2;
               tag3.tag         = 0;
               tag4.tag         = 0;
               listSizeExpected = 10;
               break;


/*
        case LTY_PODCAST:
            ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_PODCAST"));
            tag1.tag    = 0;
            tag2.tag    = 0;
            tag3.tag    = 0;
            tag4.tag    = 0;
            break;
        case LTY_PODCAST_EPISODE:
            ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_PODCAST_EPISODE"));
            tag1.podcast = 0;
            tag2.tag     = 0;
            tag3.tag     = 0;
            tag4.tag     = 0;
            break;
        case LTY_AUDIOBOOK:
            ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_AUDIOBOOK"));
            tag1.tag    = 0;
            tag2.tag    = 0;
            tag3.tag    = 0;
            tag4.tag    = 0;
            break;
        case LTY_BOOKTITLE_CHAPTER:
            ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_BOOKTITLE_CHAPTER"));
            tag1.tag       = 0;
            tag2.booktitle = 0;
            tag3.tag       = 0;
            tag4.tag       = 0;
            break;
  */
        case LTY_COMPOSER:
            ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_COMPOSER"));
            tag1.tag    = 0;
            tag2.tag    = 0;
            tag3.tag    = 0;
            tag4.tag    = 0;
            listSizeExpected = 3;
            break;
        case LTY_COMPOSER_ALBUM:
            ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_COMPOSER_ALBUM"));

            //setup base parent composer list
            listIDBaseParent = LIST_ID_NONE;
            res = helperSetupParentList_FullTextSearch(OUT listIDBaseParent, LTY_COMPOSER);//recursive call
            CPPUNIT_ASSERT(res == MP_NO_ERROR);
            CPPUNIT_ASSERT(listIDBaseParent != LIST_ID_NONE);

            res = helperShowContentParentList(listIDBaseParent);
            CPPUNIT_ASSERT(res == MP_NO_ERROR);

            //find composer
            stringToFind = "Dixgård/Norén";
            InitMediaObject(MediaObject);
            res = helperGetElementFromList(OUT MediaObject, IN stringToFind, IN listIDBaseParent);

            CPPUNIT_ASSERT(res == MP_NO_ERROR);
            CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField3, stringToFind.c_str()));
            tag1.tag      = 0;
            tag2.tag      = 0;
            tag3.composer = MediaObject.MetadataTag3;
            tag4.tag      = 0;
            listSizeExpected = 1;
            break;
        case LTY_COMPOSER_ALBUM_SONG:
            ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_COMPOSER_ALBUM_SONG"));
            //setup base parent  compose list
            listIDBaseParent = LIST_ID_NONE;
            res = helperSetupParentList_FullTextSearch(OUT listIDBaseParent, LTY_COMPOSER); //recursive call
            CPPUNIT_ASSERT(res == MP_NO_ERROR);
            CPPUNIT_ASSERT(listIDBaseParent != LIST_ID_NONE);

            res = helperShowContentParentList(listIDBaseParent);
            CPPUNIT_ASSERT(res == MP_NO_ERROR);


            stringToFind = "Dixgård/Norén";//album
            InitMediaObject(MediaObject);
            res = helperGetElementFromList(OUT MediaObject, IN stringToFind, IN listIDBaseParent);
            CPPUNIT_ASSERT(res == MP_NO_ERROR);
            CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField3, stringToFind.c_str()));
            CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField4, "Bring Em IN"));

            //fill tag
            tag1.genre = 0;
            tag2.tag   = 0;
            tag3.tag   = MediaObject.MetadataTag3;
            tag4.tag   = MediaObject.MetadataTag4;
            listSizeExpected = 11;
            break;
        case LTY_COMPOSER_SONG:
            ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_COMPOSER_SONG"));
            //setup base parent composer list
            listIDBaseParent = LIST_ID_NONE;
            res = helperSetupParentList_FullTextSearch(OUT listIDBaseParent, LTY_COMPOSER);//recursive call
            CPPUNIT_ASSERT(res == MP_NO_ERROR);
            CPPUNIT_ASSERT(listIDBaseParent != LIST_ID_NONE);

            res = helperShowContentParentList(listIDBaseParent);
            CPPUNIT_ASSERT(res == MP_NO_ERROR);

            //find list element of a certain composer as basis to set up LTY_COMPOSER_SONG-List
            stringToFind = "Dixgård/Norén";
            InitMediaObject(MediaObject);
            res = helperGetElementFromList(OUT MediaObject, IN stringToFind, IN listIDBaseParent);
            CPPUNIT_ASSERT(res == MP_NO_ERROR);
            CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField3, stringToFind.c_str()));
            tag1.tag      = 0;
            tag2.tag      = 0;
            tag3.composer = MediaObject.MetadataTag3;
            tag4.tag      = 0;
            listSizeExpected = 11;//then calling tests shows all elements this helps to set this number
            break;

        case  LTY_VIDEO:
            ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_VIDEO"));
            tag1.tag    = 0;
            tag2.tag    = 0;
            tag3.tag    = 0;
            tag4.tag    = 0;
            listSizeExpected = 11; //test which uses this is currently running on target only - target is the essential test!
            //listSizeExpected = 8; Ubuntu has only 8 elements tbd.: Check why?
            break;

        case  LTY_VIDEO_EPISODE:
             ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_VIDEO_EPISODE"));

            //setup base parent video list
            listIDBaseParent = LIST_ID_NONE;
            res = helperSetupParentList_FullTextSearch(OUT listIDBaseParent, LTY_VIDEO);//recursive call
            CPPUNIT_ASSERT(res == MP_NO_ERROR);
            CPPUNIT_ASSERT(listIDBaseParent != LIST_ID_NONE);

            res = helperShowContentParentList(listIDBaseParent);
            CPPUNIT_ASSERT(res == MP_NO_ERROR);

            //find list element of a certain Videor as basis to set up LTY_VIDEO_EPISODE-List
            stringToFind = "Matrix Reloaded Trailer";
            InitMediaObject(MediaObject);
            res = helperGetElementFromList(OUT MediaObject, IN stringToFind, IN listIDBaseParent);
            CPPUNIT_ASSERT(res == MP_NO_ERROR);
            CPPUNIT_ASSERT(0   == strcmp(MediaObject.MetadataField1, stringToFind.c_str()));

             tag1.tag    = MediaObject.MetadataTag1;
             tag2.tag    = 0;
             tag3.tag    = 0;
             tag4.tag    = 0;
             listSizeExpected = 1;
             break;

        case  LTY_IMAGE:
            ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: ListType = LTY_IMAGE"));
            tag1.tag    = 0;
            tag2.tag    = 0;
            tag3.tag    = 0;
            tag4.tag    = 0;
            listSizeExpected = 9;
            break;
/*
        case     LTY_VIDEO_EPISODE
            tag1.tag    = 0;
            tag2.tag    = 0;
            tag3.tag    = 0;
            tag4.tag    = 0;
            break;
        case     LTY_PLAYLIST
            break;
        case     LTY_PLAYLIST_SONG
            break;
        case     LTY_IMAGE
            break;
        //Folderlists
        case         FTS_VIDEO
            break;
        case         FTS_AUDIO_PLAYLIST
            break;
        case         FTS_IMAGE
*/
        default:
            res = MP_ERR_LC_NOT_IMPLEMENTED_LIST_TYPE;
            break;

    }



    //------------
    // create a list
    //------------
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            IN listType,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);

    ETG_TRACE_USR4(("helperSetupParentList_FullTextSearch: listType=%d, listID=%d,listSize=%d,listSizeExpected=%d",listType,listID,listSize,listSizeExpected));

    CPPUNIT_ASSERT(listID   != LIST_ID_NONE);
    CPPUNIT_ASSERT(res      == MP_NO_ERROR);


    helperShowContentParentList(listID);


    CPPUNIT_ASSERT(listSize == listSizeExpected);

    //care for OUT-values
    if(listID != LIST_ID_NONE)
    {
        listIDParent = listID;
    }
    else
    {
        res = MP_ERR_LC_UNDEFINED_LIST_ID;
    }

    return res;

}

tResult ListControlTest::helperFillTestSearchString(IN tListID listIDParent,OUT std::string &searchString, OUT vector <std::string> &expectedResultList)
{
    ETG_TRACE_USR2(("Begin: %s", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;
    tListInfo listInfoParent;

    tBoolean withListSize = true;
    res = LocalSPM::GetListControl().GetListInfo(OUT listInfoParent, IN listIDParent, IN withListSize);
    CPPUNIT_ASSERT(res==MP_NO_ERROR);

    //Init out variables
    searchString = "";
    expectedResultList.clear();

    ETG_TRACE_USR4(("------------------------------------------------------------"));

    switch (listInfoParent.listType)
    {
      case LTY_GENRE:
                /* Parent list
                [3318055348]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5176,->-----mediaObjectVector.size():4 ------------------------------------------------------------------
                [3318055348]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5184,LTY_GENRE: MetadataField1[0]:Alternative
                [3318055348]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5184,LTY_GENRE: MetadataField1[1]:German Pop
                [3318055348]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5184,LTY_GENRE: MetadataField1[2]:Hip-Hop
                [3318055348]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5184,LTY_GENRE: MetadataField1[3]:Rock
                [3318055348]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5278,<---------------------------------------------------------------------------------------------------
                */
          searchString = "op"; //find 2: German-Pop'Hip-Hop
          expectedResultList.push_back("German-Pop");
          expectedResultList.push_back("Hip-Hop");

          ETG_TRACE_USR4(("LTY_GENRE_SEARCH: searchString:%s",searchString.c_str()));
          break;
      case LTY_ARTIST:
                /*
                [3318298345]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5176,->-----mediaObjectVector.size():4 ------------------------------------------------------------------
                [3318298345]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5187,LTY_ARTIST: MetadataField2[0]:Garbage
                [3318298345]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5187,LTY_ARTIST: MetadataField2[1]:Herbert Gr�nemeyer
                [3318298345]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5187,LTY_ARTIST: MetadataField2[2]:K'Naan
                [3318298345]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5187,LTY_ARTIST: MetadataField2[3]:Mando Diao
                [3318298345]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5278,<---------------------------------------------------------------------------------------------------
                */
          searchString = "G"; //finds 2: Garbage, Herbert Groenemyer
          expectedResultList.push_back("Garbage");
          expectedResultList.push_back("Herbert Gr�nemyer");

          ETG_TRACE_USR4(("LTY_ARTIST_SEARCH: searchString:%s",searchString.c_str()));
          break;
      case LTY_ALBUM:
                /*
                [3318367254]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5176,->-----mediaObjectVector.size():4 ------------------------------------------------------------------
                [3318367254]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5190,LTY_ALBUM: MetadataField4[0]:2010 FIFA World Cup Anthem
                [3318367254]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5190,LTY_ALBUM: MetadataField4[1]:Bleibt Alles Anders
                [3318367254]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5190,LTY_ALBUM: MetadataField4[2]:Bring Em IN
                [3318367254]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5190,LTY_ALBUM: MetadataField4[3]:Garbage
                [3318367254]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5278,<---------------------------------------------------------------------------------------------------
                */
          searchString = "B"; //finds 3: Bleibt Alles Anders, Bring Em IN, Garbage
          expectedResultList.push_back("Bleibt Alles Anders");
          expectedResultList.push_back("Bring Em IN");
          expectedResultList.push_back("Garbage");

          ETG_TRACE_USR4(("LTY_ALBUM_SEARCH: searchString:%s",searchString.c_str()));
          break;
      case LTY_COMPILATION:
                /*
                 [4284621828]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5648,->-----mediaObjectVector.size():3 ------------------------------------------------------------------
                 [4284621828]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5701,LTY_COMPILATION: MetadataField1[0]:CompilationName1
                 [4284621828]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5701,LTY_COMPILATION: MetadataField1[1]:CompilationName2
                 [4284621828]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5701,LTY_COMPILATION: MetadataField1[2]:CompilationName3
                 [4284621828]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5753,<---------------------------------------------------------------------------------------------------
               */
          searchString = "Comp";
          expectedResultList.push_back("CompilationName1");
          expectedResultList.push_back("CompilationName2");
          expectedResultList.push_back("CompilationName3");

          ETG_TRACE_USR4(("LTY_COMPILATION_SEARCH: searchString:%s",searchString.c_str()));
          break;
      case LTY_SONG:
                /*
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5176,->-----mediaObjectVector.size():31 ------------------------------------------------------------------
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[0]:A Stroke of Luck
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[1]:As Heaven Is Wide
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[2]:bring em in
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[3]:Bleibt Alles Anders
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[4]:Dog New Tricks
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[5]:Fanatisch
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[6]:Fix Me Now
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[7]:lady
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[8]:laurens cathedral
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[9]:little boy jr
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[10]:motown blood
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[11]:mr moon
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[12]:Milk
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[13]:My Lover's Box
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[14]:Nach Mir
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[15]:Not My Idea
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[16]:Only Happy When It Rains
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[17]:Only Happy When It Rains
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[18]:p.u.s.a
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[19]:paralyzed
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[20]:Queer
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[21]:Queer
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[22]:sheepdog
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[23]:sweet ride
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[24]:Stupid Girl
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[25]:Supervixen
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[26]:Supervixen
                [3318402962]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[27]:the band
                [3318402963]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[28]:to china with love
                [3318402963]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[29]:Vow
                [3318402963]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5193,LTY_SONG: title[30]:Wavin' Flag (The Celebration Mix)
                [3318402963]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5278,<---------------------------------------------------------------------------------------------------
                */
          searchString = "up"; //find 3: Stupid Girl,Supervixen,Supervixen (2nd)
          expectedResultList.push_back("Stupid Girl");
          expectedResultList.push_back("Supervixen");
          expectedResultList.push_back("Supervixen");

          ETG_TRACE_USR4(("LTY_SONG_SEARCH: searchString:%s",searchString.c_str()));
          break;
      case LTY_GENRE_ARTIST:
                /*
                Input: GENRE:German Pop
                [3318456622]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5176,->-----mediaObjectVector.size():1 ------------------------------------------------------------------
                [3318456622]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5196,LTY_GENRE_ARTIST: MetadataField2[0]:Herbert Gr�nemeyer
                [3318456622]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5278,<---------------------------------------------------------------------------------------------------
                */
          searchString = "erb"; //find 1: Herbert Gr�nemeyer
          expectedResultList.push_back("Herbert Gr�nemeyer");

          ETG_TRACE_USR4(("LTY_GENRE_ARTIST_SEARCH: searchString:%s",searchString.c_str()));
          break;
      case LTY_GENRE_ARTIST_ALBUM:
                /*
                 Input: GENRE:Hip-Hop; ARTIST: K'Naan
                [3318508430]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5176,->-----mediaObjectVector.size():1 ------------------------------------------------------------------
                [3318508431]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5199,LTY_GENRE_ARTIST_ALBUM: MetadataField4[0]:2010 FIFA World Cup Anthem
                [3318508431]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5278,<---------------------------------------------------------------------------------------------------
                */
          searchString = "FIF"; //find 1: 2010 FIFA World Cup Anthem
          expectedResultList.push_back("2010 FIFA World Cup Anthem");

          ETG_TRACE_USR4(("LTY_GENRE_ARTIST_ALBUM_SEARCH: searchString:%s",searchString.c_str()));
          break;
      case LTY_GENRE_ARTIST_ALBUM_SONG:
                /*
                INPUT:  GENRE: HIP-HOP; ARTIST: K'Naan; ALBUM: 2010 FIFA World Cup Anthem
                [3318538995]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5202,LTY_GENRE_ARTIST_ALBUM_SONG: title[0]:Wavin' Flag (The Celebration Mix)
                [3318538995]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5278,<---------------------------------------------------------------------------------------------------

                */
          searchString = "Wa"; //find 1: Wavin' Flag (The Celebration Mix)
          expectedResultList.push_back("Wavin' Flag (The Celebration Mix)");

          ETG_TRACE_USR4(("LTY_GENRE_ARTIST_ALBUM_SONG_SEARCH: searchString:%s",searchString.c_str()));
          break;
      case LTY_GENRE_ARTIST_SONG:
                /*
                INPUT:  GENRE: HIP-HOP; ARTIST: K'Naan;
                [3318598169]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5176,->-----mediaObjectVector.size():1 ------------------------------------------------------------------
                [3318598169]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5205,LTY_GENRE_ARTIST_SONG: title[0]:Wavin' Flag (The Celebration Mix)
                [3318598169]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5278,<---------------------------------------------------------------------------------------------------
                */
          searchString = "n"; //find 1: Wavin' Flag (The Celebration Mix)
          expectedResultList.push_back("Wavin' Flag (The Celebration Mix)");

          ETG_TRACE_USR4(("LTY_GENRE_ARTIST_SONG_SEARCH: searchString:%s",searchString.c_str()));
          break;
      case LTY_GENRE_ALBUM:
                /*
                Input: GENRE:German Pop;
                [3318634317]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5176,->-----mediaObjectVector.size():1 ------------------------------------------------------------------
                [3318634317]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5208,LTY_GENRE_ALBUM MetadataField4[0]:Bleibt Alles Anders
                [3318634317]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5278,<---------------------------------------------------------------------------------------------------
                */
          searchString = "n"; //find 1: Bleibt Alles Anders
          expectedResultList.push_back("Bleibt Alles Anders");

          ETG_TRACE_USR4(("LTY_GENRE_ALBUM_SEARCH: searchString:%s",searchString.c_str()));
          break;
      case LTY_GENRE_ALBUM_SONG:
                /*
                Input: GENRE:German Pop; ALBUM: BLEIBT ALLES ANDERS
                [3318679808]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5176,->-----mediaObjectVector.size():3 ------------------------------------------------------------------
                [3318679808]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5211,LTY_GENRE_ALBUM_SONG: title[0]:Nach Mir
                [3318679808]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5211,LTY_GENRE_ALBUM_SONG: title[1]:Bleibt Alles Anders
                [3318679808]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5211,LTY_GENRE_ALBUM_SONG: title[2]:Fanatisch
                [3318679808]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5278,<---------------------------------------------------------------------------------------------------
                */

          searchString = "na"; //find 2:Nach Mir, Fanatisch //this tests also case sensitiv/insensitiv
          expectedResultList.push_back("Nach Mir");
          expectedResultList.push_back("Fanatisch");

          ETG_TRACE_USR4(("LTY_GENRE_ALBUM_SONG_SEARCH: searchString:%s",searchString.c_str()));
          break;
      case LTY_GENRE_SONG:
                /*
                 Input: GENRE:German Pop
                [3318729052]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5176,->-----mediaObjectVector.size():3 ------------------------------------------------------------------
                [3318729052]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5214,LTY_GENRE_SONG: title[0]:Bleibt Alles Anders
                [3318729052]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5214,LTY_GENRE_SONG: title[1]:Fanatisch
                [3318729052]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5214,LTY_GENRE_SONG: title[2]:Nach Mir
                [3318729052]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5278,<---------------------------------------------------------------------------------------------------
                */
          searchString = "Bl"; //find 1: :Bleibt Alles Anders
          expectedResultList.push_back("Bleibt Alles Anders");

          ETG_TRACE_USR4(("LTY_GENRE_SONG_SEARCH: searchString:%s",searchString.c_str()));
          break;
      case LTY_ARTIST_ALBUM:
                /*
                INPUT: ARTIST: Mando Diao
                [3318769322]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5176,->-----mediaObjectVector.size():1 ------------------------------------------------------------------
                [3318769322]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5217,LTY_ARTIST_ALBUM: MetadataField4[0]:Bring Em IN
                [3318769322]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5278,<---------------------------------------------------------------------------------------------------
                */
          searchString = "n"; //find 1: Bring Em IN
          expectedResultList.push_back("Bring Em IN");

          ETG_TRACE_USR4(("LTY_ARTIST_ALBUM_SEARCH: searchString:%s",searchString.c_str()));
          break;

      case LTY_ARTIST_ALBUM_SONG:
                /*
                Input: :ARTIST: Herbert Groenemeyer; ALBUM: Bleibt alles Anders
                [3318810676]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5220,LTY_ARTIST_ALBUM_SONG: title[0]:Nach Mir
                [3318810676]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5220,LTY_ARTIST_ALBUM_SONG: title[1]:Bleibt Alles Anders
                [3318810676]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5220,LTY_ARTIST_ALBUM_SONG: title[2]:Fanatisch
                [3318810676]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5278,<---------------------------------------------------------------------------------------------------
                [3318810676]TEST,TRACE_LEVEL_USER2,Function:helperShowContentParentList,LINE:5282,End  : tResult ListControlTest::helperShowContentParentList(tListID)
                */
          searchString = "n"; //find 3: Nach Mir, Bleibt Alles Anders, Fanatisch
          expectedResultList.push_back("Nach Mir");
          expectedResultList.push_back("Bleibt Alles Anders");
          expectedResultList.push_back("Fanatisch");

          ETG_TRACE_USR4(("LTY_ARTIST_ALBUM_SONG_SEARCH: searchString:%s",searchString.c_str()));
          break;
      case LTY_ARTIST_SONG:
                /*
                Input: :ARTIST: Herbert Groenemeyer; ALBUM:
                [3318839688]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5176,->-----mediaObjectVector.size():3 ------------------------------------------------------------------
                [3318839688]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5223,LTY_ARTIST_SONG: title[0]:Bleibt Alles Anders
                [3318839688]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5223,LTY_ARTIST_SONG: title[1]:Fanatisch
                [3318839688]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5223,LTY_ARTIST_SONG: title[2]:Nach Mir
                [3318839689]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5278,<---------------------------------------------------------------------------------------------------
                */
          searchString = "ach"; //find 1: Nach Mir
          expectedResultList.push_back("Nach Mir");

          ETG_TRACE_USR4(("LTY_ARTIST_SONG_SEARCH: searchString:%s",searchString.c_str()));
          break;
      case LTY_ALBUM_SONG:
                /*
                Input: :ALBUM: Bleibt Alles Anders
                [3318869305]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5176,->-----mediaObjectVector.size():3 ------------------------------------------------------------------
                [3318869305]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5226,LTY_ALBUM_SONG: title[0]:Nach Mir
                [3318869305]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5226,LTY_ALBUM_SONG: title[1]:Bleibt Alles Anders
                [3318869305]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5226,LTY_ALBUM_SONG: title[2]:Fanatisch
                [3318869305]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5278,<---------------------------------------------------------------------------------------------------
                [3318869305]TEST,TRACE_LEVEL_USER2,Function:helperShowContentParentList,LINE:5282,End  : tResult ListControlTest::helperShowContentParentList(tListID)
                */
          searchString = "All"; //find 1: Bleibt Alles Anders
          expectedResultList.push_back("Bleibt Alles Anders");

          ETG_TRACE_USR4(("LTY_ALBUM_SONG_SEARCH: searchString:%s",searchString.c_str()));
          break;
      case LTY_PODCAST:
                /*
                 [4284621828]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5648,->-----mediaObjectVector.size():3 ------------------------------------------------------------------
                 [4284621828]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5701,LTY_PODCAST: MetadataField1[0]:PodcastName1
                 [4284621828]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5701,LTY_PODCAST: MetadataField1[1]:PodcastName2
                 [4284621828]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5701,LTY_PODCAST: MetadataField1[2]:PodcastName3
                 [4284621828]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5753,<---------------------------------------------------------------------------------------------------
               */
          searchString = "Pod";
          expectedResultList.push_back("PodcastName1");
          expectedResultList.push_back("PodcastName2");
          expectedResultList.push_back("PodcastName3");

          ETG_TRACE_USR4(("LTY_PODCAST_SEARCH: searchString:%s",searchString.c_str()));
          break;
      case LTY_PODCAST_EPISODE:
                /*
                [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5652,->-----mediaObjectVector.size():10 ------------------------------------------------------------------
                [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_PODCAST_EPISODE: title[0]:podcastEpisode_1 (of PodcastName1)
                [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_PODCAST_EPISODE: title[1]:podcastEpisode_2 (of PodcastName1)
                [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_PODCAST_EPISODE: title[2]:podcastEpisode_3 (of PodcastName1)
                [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_PODCAST_EPISODE: title[3]:podcastEpisode_4 (of PodcastName1)
                [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_PODCAST_EPISODE: title[4]:podcastEpisode_5 (of PodcastName1)
                [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_PODCAST_EPISODE: title[5]:podcastEpisode_6 (of PodcastName1)
                [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_PODCAST_EPISODE: title[6]:podcastEpisode_7 (of PodcastName1)
                [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_PODCAST_EPISODE: title[7]:podcastEpisode_8 (of PodcastName1)
                [4286879630]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_PODCAST_EPISODE: title[8]:podcastEpisode_9 (of PodcastName1)
                [4286879630]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_PODCAST_EPISODE: title[9]:podcastEpisode_10 (of PodcastName1)
                [4286879630]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5757,<---------------------------------------------------------------------------------------------------
                */
          searchString = "_7";
          expectedResultList.push_back("PodcastEpisode_7 (of PodcastName1)");

          ETG_TRACE_USR4(("LTY_PODCAST_SEARCH: searchString:%s",searchString.c_str()));
          break;

       case LTY_COMPILATION_SONG:
                /*
                [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5652,->-----mediaObjectVector.size():10 ------------------------------------------------------------------
                [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_COMPILATION_SONG: title[0]:CompilationSong1 (of CompilationName1)
                [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_COMPILATION_SONG: title[1]:CompilationSong2 (of CompilationName1)
                [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_COMPILATION_SONG: title[2]:CompilationSong3 (of CompilationName1)
                [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_COMPILATION_SONG: title[3]:CompilationSong4 (of CompilationName1)
                [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_COMPILATION_SONG: title[4]:CompilationSong5 (of CompilationName1)
                [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_COMPILATION_SONG: title[5]:CompilationSong6 (of CompilationName1)
                [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_COMPILATION_SONG: title[6]:CompilationSong7 (of CompilationName1)
                [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_COMPILATION_SONG: title[7]:CompilationSong8 (of CompilationName1)
                [4286879630]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_COMPILATION_SONG: title[8]:CompilationSong9 (of CompilationName1)
                [4286879630]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_COMPILATION_SONG: title[9]:CompilationSong10 (of CompilationName1)
                [4286879630]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5757,<---------------------------------------------------------------------------------------------------
                */
          searchString = "7";
          expectedResultList.push_back("CompilationSong7 (of CompilationName1)");

          ETG_TRACE_USR4(("LTY_COMPILATION_SONG: searchString:%s",searchString.c_str()));
          break;

        case LTY_AUDIOBOOK:
                   /*
                    [4284621828]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5648,->-----mediaObjectVector.size():3 ------------------------------------------------------------------
                    [4284621828]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5701,LTY_PODCAST: MetadataField1[0]:AudioBookName1
                    [4284621828]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5701,LTY_PODCAST: MetadataField1[1]:AudioBookName2
                    [4284621828]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5701,LTY_PODCAST: MetadataField1[2]:AudioBookName3
                    [4284621828]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5753,<---------------------------------------------------------------------------------------------------
                  */
             searchString = "Aud";
             expectedResultList.push_back("AudioBookName1");
             expectedResultList.push_back("AudioBookName2");
             expectedResultList.push_back("AudioBookName3");

             ETG_TRACE_USR4(("LTY_AUDIOBOOK: searchString:%s",searchString.c_str()));
             break;
         case LTY_BOOKTITLE_CHAPTER:
                   /*
                   [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5652,->-----mediaObjectVector.size():10 ------------------------------------------------------------------
                   [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_PODCAST_EPISODE: title[0]:BookTitleChapter_1 (of AudioBookName1)
                   [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_PODCAST_EPISODE: title[1]:BookTitleChapter_2 (of AudioBookName1)
                   [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_PODCAST_EPISODE: title[2]:BookTitleChapter_3 (of AudioBookName1)
                   [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_PODCAST_EPISODE: title[3]:BookTitleChapter_4 (of AudioBookName1)
                   [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_PODCAST_EPISODE: title[4]:BookTitleChapter_5 (of AudioBookName1)
                   [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_PODCAST_EPISODE: title[5]:BookTitleChapter_6 (of AudioBookName1)
                   [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_PODCAST_EPISODE: title[6]:BookTitleChapter_7 (of AudioBookName1)
                   [4286879629]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_PODCAST_EPISODE: title[7]:BookTitleChapter_8 (of AudioBookName1)
                   [4286879630]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_PODCAST_EPISODE: title[8]:BookTitleChapter_9 (of AudioBookName1)
                   [4286879630]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5708,LTY_PODCAST_EPISODE: title[9]:BookTitleChapter_10 (of AudioBookName1)
                   [4286879630]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5757,<---------------------------------------------------------------------------------------------------
                   */
             searchString = "_7";
             expectedResultList.push_back("BookTitleChapter_7 (of AudioBookName1)");

             ETG_TRACE_USR4(("LTY_PODCAST_SEARCH: searchString:%s",searchString.c_str()));
             break;


/*

      case LTY_AUDIOBOOK:
          ETG_TRACE_USR4(("LTY_AUDIOBOOK: MetadataField2[%d]:%s",index++,(*it).MetadataField2));
          break;
      case LTY_BOOKTITLE_CHAPTER:
          ETG_TRACE_USR4(("LTY_BOOKTITLE_CHAPTER: title[%d]:%s",index++,(*it).title));
          break;
 */
      case LTY_COMPOSER:
              /*
              [3773736663]TEST,TRACE_LEVEL_USER4,Function:CreateMediaPlayerIndexedListWithSearchString_AllTypeOfLists_ParametrizedTest,LINE:5719,----------------------------------------------------------------------------------------------
              [3773736663]TEST,TRACE_LEVEL_USER4,Function:CreateMediaPlayerIndexedListWithSearchString_AllTypeOfLists_ParametrizedTest,LINE:5720,searchString:i
              [3773736663]TEST,TRACE_LEVEL_USER4,Function:CreateMediaPlayerIndexedListWithSearchString_AllTypeOfLists_ParametrizedTest,LINE:5722,expectedSearchResultList.size(): 1
              [3773736663]TEST,TRACE_LEVEL_USER4,Function:CreateMediaPlayerIndexedListWithSearchString_AllTypeOfLists_ParametrizedTest,LINE:5725,helperFillTestSearchString: expectedResultList[0]: Dixgård/Norén
              [3773736663]TEST,TRACE_LEVEL_USER4,Function:CreateMediaPlayerIndexedListWithSearchString_AllTypeOfLists_ParametrizedTest,LINE:5727,----------------------------------------------------------------------------------------------
              */
          searchString = "i";
          expectedResultList.push_back("Dixgård/Norén");
          ETG_TRACE_USR4(("LTY_COMPOSER: searchString:%s",searchString.c_str()));
          break;
      case LTY_COMPOSER_ALBUM:
            /*
            [3776878424]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5426,->-----mediaObjectVector.size():1 ------------------------------------------------------------------
            [3776878424]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5494,LTY_COMPOSER_ALBUM: MetadataField4[0]:Bring Em IN
            [3776878424]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5528,<---------------------------------------------------------------------------------------------------
            */
          searchString = "Em";
          expectedResultList.push_back("Bring Em IN");
          ETG_TRACE_USR4(("LTY_COMPOSER_ALBUM: searchString:%s",searchString.c_str()));
          break;
      case LTY_COMPOSER_ALBUM_SONG:
              /*
              [3834152916]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5450,->-----mediaObjectVector.size():11 ------------------------------------------------------------------
              [3834152916]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5521,LTY_COMPOSER_ALBUM_SONG: title[0]:sheepdog
              [3834152916]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5521,LTY_COMPOSER_ALBUM_SONG: title[1]:motown blood
              [3834152916]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5521,LTY_COMPOSER_ALBUM_SONG: title[2]:mr moon
              [3834152916]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5521,LTY_COMPOSER_ALBUM_SONG: title[3]:the band
              [3834152916]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5521,LTY_COMPOSER_ALBUM_SONG: title[4]:to china with love
              [3834152917]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5521,LTY_COMPOSER_ALBUM_SONG: title[5]:paralyzed
              [3834152917]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5521,LTY_COMPOSER_ALBUM_SONG: title[6]:p.u.s.a
              [3834152917]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5521,LTY_COMPOSER_ALBUM_SONG: title[7]:little boy jr
              [3834152917]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5521,LTY_COMPOSER_ALBUM_SONG: title[8]:lady
              [3834152917]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5521,LTY_COMPOSER_ALBUM_SONG: title[9]:bring em in
              [3834152917]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5521,LTY_COMPOSER_ALBUM_SONG: title[10]:laurens cathedral
              [3834152917]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5552,<---------------------------------------------------------------------------------------------------
              */
          searchString = "p";
          expectedResultList.push_back("sheepdog");
          expectedResultList.push_back("paralyzed");
          expectedResultList.push_back("p.u.s.a");
          ETG_TRACE_USR4(("LTY_COMPOSER_ALBUM_SONG: searchString:%s",searchString.c_str()));
          break;
      case LTY_COMPOSER_SONG:
              /*
              [3835778579]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5467,->-----mediaObjectVector.size():11 ------------------------------------------------------------------
              [3835778579]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5541,LTY_COMPOSER_SONG: title[0]:bring em in
              [3835778579]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5541,LTY_COMPOSER_SONG: title[1]:lady
              [3835778579]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5541,LTY_COMPOSER_SONG: title[2]:laurens cathedral
              [3835778580]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5541,LTY_COMPOSER_SONG: title[3]:little boy jr
              [3835778580]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5541,LTY_COMPOSER_SONG: title[4]:motown blood
              [3835778580]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5541,LTY_COMPOSER_SONG: title[5]:mr moon
              [3835778580]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5541,LTY_COMPOSER_SONG: title[6]:p.u.s.a
              [3835778580]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5541,LTY_COMPOSER_SONG: title[7]:paralyzed
              [3835778580]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5541,LTY_COMPOSER_SONG: title[8]:sheepdog
              [3835778580]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5541,LTY_COMPOSER_SONG: title[9]:the band
              [3835778580]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5541,LTY_COMPOSER_SONG: title[10]:to china with love
              [3835778580]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5569,<---------------------------------------------------------------------------------------------------
              */
          searchString = "th";
          expectedResultList.push_back("laurens cathedral");
          expectedResultList.push_back("the band");
          expectedResultList.push_back("to china with love");
          ETG_TRACE_USR4(("LTY_COMPOSER_SONG: searchString:%s",searchString.c_str()));
          break;

      case LTY_VIDEO:
              /*
                [3860904745]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5567,->-----mediaObjectVector.size():8 ------------------------------------------------------------------
                [3860904745]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5644,LTY_VIDEO: MetadataField1[0]:01_SIF_MediaClip_01.mp4
                [3860904745]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5644,LTY_VIDEO: MetadataField1[1]:01_WMV_good_Q_MediaClip_01.wmv
                [3860904745]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5644,LTY_VIDEO: MetadataField1[2]:01_XviD1.1.2_medium_MediaClip_01.avi
                [3860904745]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5644,LTY_VIDEO: MetadataField1[3]:3GP_MPEG4_MPEG4.3gp
                [3860904745]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5644,LTY_VIDEO: MetadataField1[4]:AVI_XviD_MP3.avi
                [3860904745]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5644,LTY_VIDEO: MetadataField1[5]:Matrix Reloaded Trailer
                [3860904745]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5644,LTY_VIDEO: MetadataField1[6]:MP4_MPEG4_MPEG4.mp4
                [3860904745]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5644,LTY_VIDEO: MetadataField1[7]:UNKNOWN
                [3860904745]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5672,<---------------------------------------------------------------------------------------------------
              */
          searchString = "Media";
          //searchString = "MEDIA"; should also do since feature is case insensitive
          //i.e. searchlist is expected to have these 4 elements
          expectedResultList.push_back("01_SIF_MediaClip_01.mp4");
          expectedResultList.push_back("01_WMV_good_Q_MediaClip_01.wmv");
          expectedResultList.push_back("01_XviD1.1.2_medium_MediaClip_01.avi");
          ETG_TRACE_USR4(("LTY_VIDEO: searchString:%s",searchString.c_str()));
          break;
      case LTY_VIDEO_EPISODE:
            /*
            [3861967291]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5575,->-----mediaObjectVector.size():1 ------------------------------------------------------------------
            [3861967291]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5655,LTY_VIDEO_EPISODE: title[0]:128x96.mp4
            [3861967291]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5680,<---------------------------------------------------------------------------------------------------
            */
        searchString = "x";
        //i.e. searchlist is expected to have these 1 elements
        expectedResultList.push_back("128x96.mp4");
        ETG_TRACE_USR4(("LTY_VIDEO_EPISODE: searchString:%s",searchString.c_str()));
        break;
       case LTY_IMAGE:
                /*
                [3852949809]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5524,->-----mediaObjectVector.size():9 ------------------------------------------------------------------
                [3852949809]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5610,LTY_IMAGE: title[0]:Art-MP3-Its_Raining_Again
                [3852949809]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5610,LTY_IMAGE: title[1]:Art-MP3-Neuland
                [3852949809]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5610,LTY_IMAGE: title[2]:bleibtallesanders
                [3852949809]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5610,LTY_IMAGE: title[3]:bmp
                [3852949809]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5610,LTY_IMAGE: title[4]:gif
                [3852949809]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5610,LTY_IMAGE: title[5]:Nations_256
                [3852949809]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5610,LTY_IMAGE: title[6]:png
                [3852949809]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5610,LTY_IMAGE: title[7]:tif
                [3852949809]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5610,LTY_IMAGE: title[8]:zjpeg
                [3852949809]TEST,TRACE_LEVEL_USER4,Function:helperShowContentParentList,LINE:5629,<---------------------------------------------------------------------------------------------------
                */
              searchString = "p";

              //i.e. searchlist is expected to have these 5 elements
              expectedResultList.push_back("Art-MP3-Its_Raining_Again");
              expectedResultList.push_back("Art-MP3-Neuland");
              expectedResultList.push_back("bmp");
              expectedResultList.push_back("png");
              expectedResultList.push_back("zjpeg");

              ETG_TRACE_USR4(("LTY_IMAGE: searchString:%s",searchString.c_str()));
              break;

/*
      case LTY_VIDEO_EPISODE:
          ETG_TRACE_USR4(("LTY_VIDEO_EPISODE: title[%d]:%s",index++,(*it).title));
          break;
      case LTY_PLAYLIST:
          ETG_TRACE_USR4(("LTY_PLAYLIST: title[%d]:%s",index++,(*it).title)); //tbd.: unclear if ok
          break;

      case LTY_PLAYLIST_SONG:
          ETG_TRACE_USR4(("LTY_PAYLIST_SONG: title[%d]:%s",index++,(*it).title));
          reak;
      case LTY_IMAGE:
          ETG_TRACE_USR4(("LTY_IMAGE: title[%d]:%s",index++,(*it).title)); //tbd.: check it
          break;
      case FTS_VIDEO:
      case FTS_AUDIO_PLAYLIST:
      case FTS_IMAGE:
 */
      default:
          res= MP_ERR_LC_NOT_IMPLEMENTED_LIST_TYPE;
          break;
    }



    ETG_TRACE_USR4(("------------------------------------------------------------"));


    ETG_TRACE_USR2(("End  : %s", __PRETTY_FUNCTION__));

    return res;
}


tResult ListControlTest::helperGetElementFromList(OUT tMediaObject &MediaObject, IN const std::string &stringToFind, IN tListID listID)
{
    ETG_TRACE_USR2(("Begin: %s", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;

    //get info about listID
    tListInfo listInfo;
    tBoolean withListSize = true;
    res = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listID, IN withListSize);
    CPPUNIT_ASSERT(res==MP_NO_ERROR);

    //request slice of list - slice has size of list - it is thought to work with example content only
    vector<tMediaObject> mediaObjectVector;
    tIndex IndexStart = 0;
    tIndex IndexStop  = listInfo.listSize;
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            IN IndexStart,
            IN IndexStop);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    ETG_TRACE_USR4(("helperGetElementFromList:mediaObjectVector.size():%d  (IndexStop-IndexStart):%d ",mediaObjectVector.size(),(IndexStop-IndexStart)));
    CPPUNIT_ASSERT(mediaObjectVector.size() == (IndexStop-IndexStart));

    //search for entity in dependency of ListType which is defined by stringToFind
    tBool bFound = FALSE;
    for(std::vector<tMediaObject>::iterator it = mediaObjectVector.begin(); it != mediaObjectVector.end() && !bFound ;it++)
    {
        switch (listInfo.listType)
        {
            case LTY_GENRE:
                ETG_TRACE_USR4(("helperGetElementFromList: LTY_GENRE"));
                if(0 ==stringToFind.compare((*it).MetadataField1)) //genre is always in field1 (tag1)
                {
                    ETG_TRACE_USR4(("helperGetElementFromList: FOUND: %s",stringToFind.c_str()));
                    memcpy(&MediaObject,&(*it),sizeof(tMediaObject));
                    bFound = TRUE;
                }
                break;
            case LTY_ARTIST:
                ETG_TRACE_USR4(("helperGetElementFromList: LTY_ARTIST"));
                if(0 ==stringToFind.compare((*it).MetadataField2)) //genre is always in field2 (tag2)
                {
                    ETG_TRACE_USR4(("helperGetElementFromList: FOUND: %s",stringToFind.c_str()));
                    memcpy(&MediaObject,&(*it),sizeof(tMediaObject));
                    bFound = TRUE;
                }
                break;
            case LTY_ALBUM:
                ETG_TRACE_USR4(("helperGetElementFromList: LTY_ALBUM"));
                if(0 ==stringToFind.compare((*it).MetadataField4)) //genre is always in field4 (tag4)
                {
                    ETG_TRACE_USR4(("helperGetElementFromList: FOUND: %s",stringToFind.c_str()));
                    memcpy(&MediaObject,&(*it),sizeof(tMediaObject));
                    bFound = TRUE;
                }
                break;
            case LTY_COMPOSER:
                ETG_TRACE_USR4(("helperGetElementFromList: LTY_COMPOSER"));
                if(0 ==stringToFind.compare((*it).MetadataField3)) //composer is always in field3 (tag3)
                {
                    ETG_TRACE_USR4(("helperGetElementFromList: FOUND: %s",stringToFind.c_str()));
                    memcpy(&MediaObject,&(*it),sizeof(tMediaObject));
                    bFound = TRUE;
                }
                break;
            case LTY_VIDEO:
                ETG_TRACE_USR4(("helperGetElementFromList: LTY_VIDEO"));
                if(0 ==stringToFind.compare((*it).MetadataField1)) //video is always in field1 (tag1)
                {
                  ETG_TRACE_USR4(("helperGetElementFromList: FOUND: %s",stringToFind.c_str()));
                  memcpy(&MediaObject,&(*it),sizeof(tMediaObject));
                  bFound = TRUE;
                }
                break;
             case LTY_PODCAST:
                ETG_TRACE_USR4(("helperGetElementFromList: LTY_PODCAST"));
                if(0 ==stringToFind.compare((*it).MetadataField1)) //video is always in field1 (tag1)
                {
                  ETG_TRACE_USR4(("helperGetElementFromList: FOUND: %s",stringToFind.c_str()));
                  memcpy(&MediaObject,&(*it),sizeof(tMediaObject));
                  bFound = TRUE;
                }
                break;
              case LTY_AUDIOBOOK:
                ETG_TRACE_USR4(("helperGetElementFromList: LTY_AUDIOBOOK"));
                if(0 ==stringToFind.compare((*it).MetadataField2)) //video is always in field1 (tag1)
                {
                  ETG_TRACE_USR4(("helperGetElementFromList: FOUND: %s",stringToFind.c_str()));
                  memcpy(&MediaObject,&(*it),sizeof(tMediaObject));
                  bFound = TRUE;
                }
                break;
              case LTY_COMPILATION:
                ETG_TRACE_USR4(("helperGetElementFromList: LTY_COMPILATION"));
                if(0 ==stringToFind.compare((*it).MetadataField4)) //genre is always in field4 (tag4)
                {
                    ETG_TRACE_USR4(("helperGetElementFromList: FOUND: %s",stringToFind.c_str()));
                    memcpy(&MediaObject,&(*it),sizeof(tMediaObject));
                    bFound = TRUE;
                }
                break;
/* tbd.: unclear if used

            case LTY_COMPOSER:
                break;
            case LTY_VIDEO:
                break;
            case LTY_PLAYLIST:
                break;


            case LTY_IMAGE:
                ETG_TRACE_USR4(("LTY_IMAGE: title[%d]:%s",index++,(*it).title)); //tbd.: check it
                break;
            case FTS_VIDEO:
            case FTS_AUDIO_PLAYLIST:
            case FTS_IMAGE:
  */
            default:
                res= MP_ERR_LC_NOT_IMPLEMENTED_LIST_TYPE;
                break;
        }
    }

    ETG_TRACE_USR2(("End  : %s", __PRETTY_FUNCTION__));

    return res;

}
tResult ListControlTest::helperShowContentParentList(IN tListID listIDParent)
{
    ETG_TRACE_USR2(("Begin  : %s", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;
    tListInfo listInfoParent;

    tBoolean withListSize = true;
    res = LocalSPM::GetListControl().GetListInfo(OUT listInfoParent, IN listIDParent, IN withListSize);
    CPPUNIT_ASSERT(res==MP_NO_ERROR);


    ETG_TRACE_USR4(("helperShowContentParentList: listIDParent:%d, listInfoParent.listSize:%d, listInfoParent.listType:%d ",listIDParent,listInfoParent.listSize,listInfoParent.listType));

    vector<tMediaObject> mediaObjectVector;
    mediaObjectVector.clear();

        /* second ask for all albums */
    tIndex IndexStart = 0;
    tIndex IndexStop  = (tIndex)listInfoParent.listSize;

    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listIDParent,
            IndexStart,
            IndexStop);

       CPPUNIT_ASSERT(res == MP_NO_ERROR);

       tListSize len = mediaObjectVector.size();
       CPPUNIT_ASSERT(listInfoParent.listSize==len);

       ETG_TRACE_USR4(("->-----mediaObjectVector.size():%d ------------------------------------------------------------------",len));
       int index = 0;
       for(std::vector<tMediaObject>::iterator it = mediaObjectVector.begin(); it != mediaObjectVector.end() ;it++)
       {
           //check content
           switch (listInfoParent.listType)
           {
               case LTY_GENRE:
                   ETG_TRACE_USR4(("LTY_GENRE: MetadataField1[%d]:%s",index++,(*it).MetadataField1));
                   break;
               case LTY_ARTIST:
                   ETG_TRACE_USR4(("LTY_ARTIST: MetadataField2[%d]:%s",index++,(*it).MetadataField2));
                   break;
               case LTY_ALBUM:
                   ETG_TRACE_USR4(("LTY_ALBUM: MetadataField4[%d]:%s",index++,(*it).MetadataField4));
                   break;
               case LTY_COMPILATION:
                   ETG_TRACE_USR4(("LTY_COMPILATION: MetadataField4[%d]:%s",index++,(*it).MetadataField4));
                   break;
               case LTY_SONG:
                   ETG_TRACE_USR4(("LTY_SONG: title[%d]:%s",index++,(*it).title));
                   break;
               case LTY_GENRE_ARTIST:
                   ETG_TRACE_USR4(("LTY_GENRE_ARTIST: MetadataField2[%d]:%s",index++,(*it).MetadataField2));
                   break;
               case LTY_GENRE_ARTIST_ALBUM:
                   ETG_TRACE_USR4(("LTY_GENRE_ARTIST_ALBUM: MetadataField4[%d]:%s",index++,(*it).MetadataField4));
                   break;
               case LTY_GENRE_ARTIST_ALBUM_SONG:
                   ETG_TRACE_USR4(("LTY_GENRE_ARTIST_ALBUM_SONG: title[%d]:%s",index++,(*it).title));
                   break;
               case LTY_GENRE_ARTIST_SONG:
                   ETG_TRACE_USR4(("LTY_GENRE_ARTIST_SONG: title[%d]:%s",index++,(*it).title));
                   break;
               case LTY_GENRE_ALBUM:
                   ETG_TRACE_USR4(("LTY_GENRE_ALBUM MetadataField4[%d]:%s",index++,(*it).MetadataField4));
                   break;
               case LTY_GENRE_ALBUM_SONG:
                   ETG_TRACE_USR4(("LTY_GENRE_ALBUM_SONG: title[%d]:%s",index++,(*it).title));
                   break;
               case LTY_GENRE_SONG:
                   ETG_TRACE_USR4(("LTY_GENRE_SONG: title[%d]:%s",index++,(*it).title));
                   break;
               case LTY_ARTIST_ALBUM:
                   ETG_TRACE_USR4(("LTY_ARTIST_ALBUM: MetadataField4[%d]:%s",index++,(*it).MetadataField4));
                   break;
               case LTY_ARTIST_ALBUM_SONG:
                   ETG_TRACE_USR4(("LTY_ARTIST_ALBUM_SONG: title[%d]:%s",index++,(*it).title));
                   break;
               case LTY_ARTIST_SONG:
                   ETG_TRACE_USR4(("LTY_ARTIST_SONG: title[%d]:%s",index++,(*it).title));
                   break;
               case LTY_ALBUM_SONG:
                   ETG_TRACE_USR4(("LTY_ALBUM_SONG: title[%d]:%s",index++,(*it).title));
                   break;
                case LTY_COMPILATION_SONG:
                   ETG_TRACE_USR4(("LTY_COMPILATION_SONG: title[%d]:%s",index++,(*it).title));
                   break;
               case LTY_PODCAST:
                   ETG_TRACE_USR4(("LTY_PODCAST: MetadataField1[%d]:%s",index++,(*it).MetadataField1));
                   break;
               case LTY_PODCAST_EPISODE:
                   ETG_TRACE_USR4(("LTY_PODCAST_EPISODE: title[%d]:%s",index++,(*it).title));
                   break;
               case LTY_AUDIOBOOK:
                   ETG_TRACE_USR4(("LTY_AUDIOBOOK: MetadataField2[%d]:%s",index++,(*it).MetadataField2));
                   break;
               case LTY_BOOKTITLE_CHAPTER:
                   ETG_TRACE_USR4(("LTY_BOOKTITLE_CHAPTER: title[%d]:%s",index++,(*it).title));
                   break;
               case LTY_COMPOSER:
                   ETG_TRACE_USR4(("LTY_COMPOSER: MetadataField3[%d]:%s",index++,(*it).MetadataField3));
                   break;
               case LTY_COMPOSER_ALBUM:
                   ETG_TRACE_USR4(("LTY_COMPOSER_ALBUM: MetadataField4[%d]:%s",index++,(*it).MetadataField4));
                   break;
               case LTY_COMPOSER_ALBUM_SONG:
                   ETG_TRACE_USR4(("LTY_COMPOSER_ALBUM_SONG: title[%d]:%s",index++,(*it).title));
                   break;
               case LTY_COMPOSER_SONG:
                   ETG_TRACE_USR4(("LTY_COMPOSER_SONG: title[%d]:%s",index++,(*it).title));
                   break;
               case LTY_VIDEO:
                   //printf("LTY_VIDEO: MetadataField1[%d]:%s\n",index++,(*it).MetadataField1); //tbd.: check this
                   ETG_TRACE_USR4(("LTY_VIDEO: MetadataField1[%d]:%s",index++,(*it).MetadataField1)); //tbd.: check this
                   break;
               case LTY_VIDEO_EPISODE:
                   ETG_TRACE_USR4(("LTY_VIDEO_EPISODE: title[%d]:%s",index++,(*it).title));
                   break;
               case LTY_PLAYLIST:
                   ETG_TRACE_USR4(("LTY_PLAYLIST: title[%d]:%s",index++,(*it).title)); //tbd.: unclear if ok
                   break;
               case LTY_IMAGE:
                   ETG_TRACE_USR4(("LTY_IMAGE: title[%d]:%s",index++,(*it).title)); //tbd.: unclear if ok
                   break;
 /*
               case LTY_PLAYLIST_SONG:
                   ETG_TRACE_USR4(("LTY_PAYLIST_SONG: title[%d]:%s",index++,(*it).title));
                   reak;

               case FTS_VIDEO:
               case FTS_AUDIO_PLAYLIST:
               case FTS_IMAGE:
 */
               default:
                   res= MP_ERR_LC_NOT_IMPLEMENTED_LIST_TYPE;
                   break;
           }

       }
       ETG_TRACE_USR4(("<---------------------------------------------------------------------------------------------------"));



    ETG_TRACE_USR2(("End  : %s", __PRETTY_FUNCTION__));

    return res;
}

tResult ListControlTest::helperCheckContentOfList(IN tListID listIDSearch,IN std::vector <std::string> &expectedSearchResultList)
{

    ENTRY
    ETG_TRACE_USR2(("Begin: %s", __PRETTY_FUNCTION__));

    tReturnValue res = MP_NO_ERROR;

    //--------------
    //get listSlize
    //--------------
    tListSize listSizeExpected = expectedSearchResultList.size();
    vector<tMediaObject>  ListSlice;

    ListSlice.clear();
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
         OUT ListSlice,
         IN listIDSearch,
         0,
         IN listSizeExpected);

    tListSize len = ListSlice.size();

    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(len == listSizeExpected);


    //-------------------
    //get list type
    //-------------------
    tListInfo listInfo;
    tBoolean withListSize = false;
    res = LocalSPM::GetListControl().GetListInfo(OUT listInfo, IN listIDSearch, IN withListSize);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    tListType listType = listInfo.listType;


    //---------------------------------------------------
    //in dependency of the list type fill string vector
    //---------------------------------------------------
    vector<std::string> searchResultList;
    searchResultList.clear();
    for(std::vector<tMediaObject>::iterator it = ListSlice.begin(); it != ListSlice.end() ;it++)
    {
        switch(listType)
        {
            case LTY_SONG_SEARCH:
                searchResultList.push_back((*it).title);
                break;
            case LTY_GENRE_SEARCH:
                searchResultList.push_back((*it).MetadataField1);
                break;
            case LTY_ARTIST_SEARCH:
                searchResultList.push_back((*it).MetadataField2);
                break;
            case LTY_ALBUM_SEARCH:
                searchResultList.push_back((*it).MetadataField4);
                break;
            case LTY_GENRE_ARTIST_SEARCH:
                searchResultList.push_back((*it).MetadataField2);
                break;
            case LTY_GENRE_ARTIST_ALBUM_SEARCH:
                searchResultList.push_back((*it).MetadataField4);
                break;
            case LTY_GENRE_ARTIST_ALBUM_SONG_SEARCH:
                searchResultList.push_back((*it).title);
                break;
            case LTY_GENRE_ARTIST_SONG_SEARCH:
                searchResultList.push_back((*it).title);
                break;
            case LTY_GENRE_ALBUM_SEARCH:
                searchResultList.push_back((*it).MetadataField4);
                break;
            case LTY_GENRE_ALBUM_SONG_SEARCH:
                searchResultList.push_back((*it).title);
                break;
            case LTY_GENRE_SONG_SEARCH:
                searchResultList.push_back((*it).title);
                break;
            case LTY_ARTIST_ALBUM_SEARCH:
                searchResultList.push_back((*it).MetadataField4);
                break;
            case LTY_ARTIST_ALBUM_SONG_SEARCH:
                searchResultList.push_back((*it).title);
                break;
            case LTY_ARTIST_SONG_SEARCH:
                searchResultList.push_back((*it).title);
                break;
            case LTY_ALBUM_SONG_SEARCH:
                 searchResultList.push_back((*it).title);
                break;
            case LTY_COMPOSER_SEARCH:
                searchResultList.push_back((*it).MetadataField3);
                break;
            case LTY_COMPOSER_ALBUM_SEARCH:
                searchResultList.push_back((*it).MetadataField4);
                break;
            case LTY_COMPOSER_ALBUM_SONG_SEARCH:
                searchResultList.push_back((*it).title);
                break;
            case LTY_COMPOSER_SONG_SEARCH:
                searchResultList.push_back((*it).title);
                break;
            case LTY_VIDEO_SEARCH:
                searchResultList.push_back((*it).MetadataField1);
                break;
            case LTY_VIDEO_EPISODE_SEARCH:
                searchResultList.push_back((*it).title);
                break;
            case LTY_IMAGE_SEARCH:
                searchResultList.push_back((*it).title);
                break;
            case LTY_PODCAST_SEARCH:
                 searchResultList.push_back((*it).MetadataField1);
                 break;
            case LTY_PODCAST_EPISODE_SEARCH:
                 searchResultList.push_back((*it).title);
                 break;
            case LTY_AUDIOBOOK_SEARCH:
                 searchResultList.push_back((*it).MetadataField2);
                 break;
            case LTY_BOOKTITLE_CHAPTER_SEARCH:
                 searchResultList.push_back((*it).title);
                 break;
            case LTY_COMPILATION_SEARCH:
                 searchResultList.push_back((*it).MetadataField4);
                 break;
             case LTY_COMPILATION_SONG_SEARCH:
                 searchResultList.push_back((*it).title);
                 break;
            default:
                 ETG_TRACE_FATAL(("[ERROR] ListType not supported: %d", listType));
                break;

        }
    }


    len = searchResultList.size();
    CPPUNIT_ASSERT(len == listSizeExpected);

    //NOK
    if(searchResultList.size() != expectedSearchResultList.size())
    {
       ETG_TRACE_FATAL(("[ERROR]: helperCheckContentOfList: ListSlice.size (%d)  != expectedSearchResultList.size (%d)",ListSlice.size(),expectedSearchResultList.size()));
    }
    //OK
    else
    {
          ETG_TRACE_USR4(("-----------------------------------------------------------------------------------------------"));
          tBool bFound;
          std::string stringToCompare = "";
          int count = 0;
          for(std::vector<std::string>::iterator itExpectedList = expectedSearchResultList.begin(); itExpectedList != expectedSearchResultList.end() ;itExpectedList++)
          {
              bFound = TRUE;
              for(std::vector<std::string>::iterator itSearchList = searchResultList.begin(); itSearchList != searchResultList.end() ;itSearchList++)
              {
                 if(0 == (*itSearchList).compare((*itExpectedList))) //check if equal
                 {
                     bFound = TRUE;
                     ETG_TRACE_USR4(("helperCheckContentOfList: Found: ListSliceElement[%d]: %s",count++,(*itSearchList).c_str()));
                     searchResultList.erase(itSearchList); //delete element to care for double entities as well
                     break;
                 }
              }
              if(bFound == FALSE)
              {
                  ETG_TRACE_FATAL(("[ERROR]: helperCheckContentOfList: ListSlice != expectedSearchResultList: Missing element: %s",(*itExpectedList).c_str()));
                  break;
              }
          }
          ETG_TRACE_USR4(("-----------------------------------------------------------------------------------------------"));
    }


    ETG_TRACE_USR2(("End  : %s", __PRETTY_FUNCTION__));

    return res;
}


tResult ListControlTest::helperAddDeleteTestContentToDB(IN tDeviceType testDevice, IN tCategoryType categoryType,IN int numOfCategories,IN int numOfMediaObjectsToAdd,IN tBool bDelete)
{
    ETG_TRACE_USR2(("Begin  : %s", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;
    int i,k;

    CPPUNIT_ASSERT(numOfMediaObjectsToAdd > 0);
    CPPUNIT_ASSERT(numOfCategories >0);

    //--------------------------------------------------------------
    //add test content to support in tests lists which are bound to Appledevices
    //
    // example content can be checked directly with sqlitebrowser (/var/opt/bosch/dynamic/media/db/MyMedia.db):
    // select rowid,lowerfiltertag1,title from [Main].[MediaObjects] where deviceid=2 and categoryid=12 group by title COLLATE SORT_LIB limit 30 offset 0 //if written to DTY_IPOD
    //select rowid,lowerfiltertag1,title from [Main].[MediaObjects] where deviceid=1 and categoryid=12 group by title COLLATE SORT_LIB limit 30 offset 0  //if written to DTY_USB
    //
    //--------------------------------------------------------------
    if(categoryType == CTY_PODCAST)
    {
        tResult res = MP_NO_ERROR;
        tMediaObject mediaObject;

        //current test database own already a test apple device ID=2
        tDeviceID deviceID;
        res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN testDevice);
        CPPUNIT_ASSERT(res == 0);

        /* store a dummy podcast object */
        int numOfPodcasts = numOfCategories;
        int numOfEpisodes = numOfMediaObjectsToAdd;
        for(k=1;k<=numOfPodcasts; k++)
        {
            for(i=1;i<=numOfEpisodes;i++)
            {
                InitMediaObject(OUT mediaObject); //clear object
                //---------------------
                //write a media object
                //---------------------
                mediaObject.deviceID = deviceID;
                mediaObject.catType = categoryType;
                snprintf(OUT mediaObject.MetadataField2, IN sizeof(mediaObject.MetadataField1), "PodcastName%d",k); //

                snprintf(OUT mediaObject.fileName, IN sizeof(mediaObject.fileName), "/podcast/podcastEpisode%d_FileName_%d",(k-1)*10+i,(k-1)*10+i);
                snprintf(OUT mediaObject.title,    IN sizeof(mediaObject.title),    "podcastEpisode_%d (of PodcastName%d)",(k-1)*10+i,k );


                snprintf( OUT mediaObject.MetadataField1, IN sizeof(mediaObject.MetadataField1), "PodcastName%d",k); //
                strncpy_r(OUT mediaObject.MetadataField2, "field2:-", IN sizeof(mediaObject.MetadataField2)); //resolution
                strncpy_r(OUT mediaObject.MetadataField3, "field3:-", IN sizeof(mediaObject.MetadataField3));
                strncpy_r(OUT mediaObject.MetadataField4, "field4:-", IN sizeof(mediaObject.MetadataField4));

                mediaObject.metadataConvertFlag = 0;
                mediaObject.compilationFlag = 0;
                mediaObject.totalPlaytime = 0;
                strncpy_r(OUT mediaObject.albumArtString, "", IN sizeof(mediaObject.albumArtString));
                mediaObject.trackNumber = 0;
                strncpy_r(OUT mediaObject.path, "/podcast/", IN sizeof(mediaObject.path));
                mediaObject.notPlayable = FNP_NOT_PLAYABLE;//?
                mediaObject.fileSize = 1LL;
                strncpy_r(OUT mediaObject.dateTime, "2009:02:08 10:40:27", IN sizeof(mediaObject.dateTime));
                mediaObject.fileMode = 0;
                mediaObject.userID = 0;
                mediaObject.groupID = 0;

                //--------------------------------------
                //delete or add this mediaobject to database
                //--------------------------------------
                if(TRUE == bDelete)
                {
                    tMediaObject mediaObjectToDelete;
                    InitMediaObject(OUT mediaObjectToDelete);
                    res = LocalSPM::GetDBManager().GetObjectID(OUT mediaObjectToDelete.objectID, IN mediaObject.deviceID, IN mediaObject.fileName);
                    CPPUNIT_ASSERT(res == 0);
                    //delete this object
                    res = LocalSPM::GetDBManager().RemoveMediaObject(IN mediaObjectToDelete.objectID);
                    CPPUNIT_ASSERT(res == 0);
                }
                else
                {
                    res = LocalSPM::GetDBManager().StoreMediaObject(IN mediaObject);
                    CPPUNIT_ASSERT(res == 0);

#ifdef USE_CHECK_FAKE_DBENTRY_AFTERWRITE
                    res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
                    CPPUNIT_ASSERT(res == 0);

                    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
                    CPPUNIT_ASSERT(res == 0);

                    /* get the media object to compare */
                    tMediaObject newMediaObject;
                    InitMediaObject(OUT newMediaObject);
                    res = LocalSPM::GetDBManager().GetObjectID(OUT newMediaObject.objectID, IN mediaObject.deviceID, IN mediaObject.fileName);
                    CPPUNIT_ASSERT(res == 0);

                    res = LocalSPM::GetDBManager().GetMediaObject(OUT newMediaObject, INOUT newMediaObject.objectID);
                    CPPUNIT_ASSERT(res == 0);
                    VARTRACE(newMediaObject);
                    CPPUNIT_ASSERT(mediaObject.deviceID == newMediaObject.deviceID);
                    CPPUNIT_ASSERT(mediaObject.catType == newMediaObject.catType);
                    CPPUNIT_ASSERT(strcmp(mediaObject.fileName, newMediaObject.fileName) == 0);
                    CPPUNIT_ASSERT(strcmp(mediaObject.title, newMediaObject.title) == 0);
                    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField1, newMediaObject.MetadataField1) == 0);
                    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField2, newMediaObject.MetadataField2) == 0);
                    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField3, newMediaObject.MetadataField3) == 0);
                    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField4, newMediaObject.MetadataField4) == 0);
                    CPPUNIT_ASSERT(mediaObject.metadataConvertFlag == newMediaObject.metadataConvertFlag);
                    CPPUNIT_ASSERT(mediaObject.compilationFlag == newMediaObject.compilationFlag);
                    CPPUNIT_ASSERT(mediaObject.totalPlaytime == newMediaObject.totalPlaytime);
                    CPPUNIT_ASSERT(strstr(newMediaObject.albumArtString, mediaObject.albumArtString)); //DBManager add mount point to album art string
                    CPPUNIT_ASSERT(mediaObject.trackNumber == newMediaObject.trackNumber);
                    CPPUNIT_ASSERT(strcmp(mediaObject.path, newMediaObject.path) == 0);
                    CPPUNIT_ASSERT(mediaObject.notPlayable == newMediaObject.notPlayable);
                    CPPUNIT_ASSERT(mediaObject.fileSize == newMediaObject.fileSize);
                    CPPUNIT_ASSERT(strcmp(mediaObject.dateTime, newMediaObject.dateTime) == 0);
                    CPPUNIT_ASSERT(mediaObject.fileMode == newMediaObject.fileMode);
                    CPPUNIT_ASSERT(mediaObject.userID == newMediaObject.userID);
                    CPPUNIT_ASSERT(mediaObject.groupID == newMediaObject.groupID);
#endif //USE_CHECK_FAKE_DBENTRY_AFTERWRITE
                }
            }
        }

#ifndef USE_CHECK_FAKE_DBENTRY_AFTERWRITE
        if(TRUE == bDelete)
        {
            //might not be necessary here but possibly helpful
            res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
            CPPUNIT_ASSERT(res == 0);
        }
        else
        {
            //last entry done store finally (from cash to file kind of flush)
            res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
            CPPUNIT_ASSERT(res == 0);

            res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
            CPPUNIT_ASSERT(res == 0);
        }
#endif
    }
    //-------------------------------------------------------------------------------------------------------------------------------------------------
    // example content can be checked directly with sqlitebrowser (/var/opt/bosch/dynamic/media/db/MyMedia.db):
    // select rowid,lowerfiltertag2,title from [Main].[MediaObjects] where deviceid=2 and categoryid=20 group by title COLLATE SORT_LIB limit 30 offset 0 //if written to DTY_IPOD
    // select rowid,lowerfiltertag2,title from [Main].[MediaObjects] where deviceid=1 and categoryid=20 group by title COLLATE SORT_LIB limit 30 offset 0  //if written to DTY_USB
    //-------------------------------------------------------------------------------------------------------------------------------------------------
    else if(categoryType == CTY_AUDIOBOOK)
    {
        tResult res = MP_NO_ERROR;
        tMediaObject mediaObject;

        //current test database own already a test apple device ID=2
        tDeviceID deviceID;
        res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN testDevice);
        CPPUNIT_ASSERT(res == 0);

        /* store a dummy podcast object */
        int numOfAudioBooks       = numOfCategories;
        int numOfBookTitleChapter = numOfMediaObjectsToAdd;
        for(k=1;k<=numOfAudioBooks; k++)
        {
            for(i=1;i<=numOfBookTitleChapter;i++)
            {
                InitMediaObject(OUT mediaObject); //clear object
                //---------------------
                //write a media object
                //---------------------
                mediaObject.deviceID = deviceID;
                mediaObject.catType = categoryType;


                snprintf(OUT mediaObject.fileName, IN sizeof(mediaObject.fileName), "/audiobook/numOfBookTitleChapter%d_FileName_%d",(k-1)*10+i,(k-1)*10+i);
                snprintf(OUT mediaObject.title,    IN sizeof(mediaObject.title),    "numOfBookTitleChapter%d (of AudioBookName%d)",(k-1)*10+i,k );

                snprintf(OUT mediaObject.MetadataField1, IN sizeof(mediaObject.MetadataField1), "AuthorName%d",k); //resolution
                snprintf(OUT mediaObject.MetadataField2, IN sizeof(mediaObject.MetadataField2), "AudioBookName%d",k); //
                strncpy_r(OUT mediaObject.MetadataField3, "field3:-", IN sizeof(mediaObject.MetadataField3));
                strncpy_r(OUT mediaObject.MetadataField4, "field4:-", IN sizeof(mediaObject.MetadataField4));

                mediaObject.metadataConvertFlag = 0;
                mediaObject.compilationFlag = 0;
                mediaObject.totalPlaytime = 0;
                strncpy_r(OUT mediaObject.albumArtString, "", IN sizeof(mediaObject.albumArtString));
                mediaObject.trackNumber = 0;
                strncpy_r(OUT mediaObject.path, "/audiobook/", IN sizeof(mediaObject.path));
                mediaObject.notPlayable = FNP_NOT_PLAYABLE;//?
                mediaObject.fileSize = 1LL;
                strncpy_r(OUT mediaObject.dateTime, "2009:02:08 10:40:27", IN sizeof(mediaObject.dateTime));
                mediaObject.fileMode = 0;
                mediaObject.userID = 0;
                mediaObject.groupID = 0;

                //----------------------------
                //add this mediaobject to database
                //----------------------------
                if(TRUE == bDelete)
                {
                    tMediaObject mediaObjectToDelete;
                    InitMediaObject(OUT mediaObjectToDelete);
                    res = LocalSPM::GetDBManager().GetObjectID(OUT mediaObjectToDelete.objectID, IN mediaObject.deviceID, IN mediaObject.fileName);
                    CPPUNIT_ASSERT(res == 0);

                    //delete this object
                    res = LocalSPM::GetDBManager().RemoveMediaObject(IN mediaObjectToDelete.objectID);
                    CPPUNIT_ASSERT(res == 0);
                }
                else
                {

                    res = LocalSPM::GetDBManager().StoreMediaObject(IN mediaObject);
                    CPPUNIT_ASSERT(res == 0);

#ifdef USE_CHECK_FAKE_DBENTRY_AFTERWRITE
                    res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
                    CPPUNIT_ASSERT(res == 0);

                    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
                    CPPUNIT_ASSERT(res == 0);

                    //----------------------------
                    //
                    //----------------------------
                    /* get the media object to compare */
                    tMediaObject newMediaObject;
                    InitMediaObject(OUT newMediaObject);
                    res = LocalSPM::GetDBManager().GetObjectID(OUT newMediaObject.objectID, IN mediaObject.deviceID, IN mediaObject.fileName);
                    CPPUNIT_ASSERT(res == 0);

                    res = LocalSPM::GetDBManager().GetMediaObject(OUT newMediaObject, INOUT newMediaObject.objectID);
                    CPPUNIT_ASSERT(res == 0);
                    VARTRACE(newMediaObject);
                    CPPUNIT_ASSERT(mediaObject.deviceID == newMediaObject.deviceID);
                    CPPUNIT_ASSERT(mediaObject.catType == newMediaObject.catType);
                    CPPUNIT_ASSERT(strcmp(mediaObject.fileName, newMediaObject.fileName) == 0);
                    CPPUNIT_ASSERT(strcmp(mediaObject.title, newMediaObject.title) == 0);
                    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField1, newMediaObject.MetadataField1) == 0);
                    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField2, newMediaObject.MetadataField2) == 0);
                    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField3, newMediaObject.MetadataField3) == 0);
                    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField4, newMediaObject.MetadataField4) == 0);
                    CPPUNIT_ASSERT(mediaObject.metadataConvertFlag == newMediaObject.metadataConvertFlag);
                    CPPUNIT_ASSERT(mediaObject.compilationFlag == newMediaObject.compilationFlag);
                    CPPUNIT_ASSERT(mediaObject.totalPlaytime == newMediaObject.totalPlaytime);
                    CPPUNIT_ASSERT(strstr(newMediaObject.albumArtString, mediaObject.albumArtString)); //DBManager add mount point to album art string
                    CPPUNIT_ASSERT(mediaObject.trackNumber == newMediaObject.trackNumber);
                    CPPUNIT_ASSERT(strcmp(mediaObject.path, newMediaObject.path) == 0);
                    CPPUNIT_ASSERT(mediaObject.notPlayable == newMediaObject.notPlayable);
                    CPPUNIT_ASSERT(mediaObject.fileSize == newMediaObject.fileSize);
                    CPPUNIT_ASSERT(strcmp(mediaObject.dateTime, newMediaObject.dateTime) == 0);
                    CPPUNIT_ASSERT(mediaObject.fileMode == newMediaObject.fileMode);
                    CPPUNIT_ASSERT(mediaObject.userID == newMediaObject.userID);
                    CPPUNIT_ASSERT(mediaObject.groupID == newMediaObject.groupID);
#endif
                }
            }
        }

#ifndef USE_CHECK_FAKE_DBENTRY_AFTERWRITE
        if(TRUE == bDelete)
        {
            //might not be necessary here but possibly helpful
            res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
            CPPUNIT_ASSERT(res == 0);
        }
        else
        {
            res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
            CPPUNIT_ASSERT(res == 0);
            res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
            CPPUNIT_ASSERT(res == 0);
        }
#endif //USE_CHECK_FAKE_DBENTRY_AFTERWRITE
        }

    //-------------------------------------------------------------------------------------------------------------------------------------------------
    // example content can be checked directly with sqlitebrowser (/var/opt/bosch/dynamic/media/db/MyMedia.db):
    // select rowid,lowerfiltertag2,title from [Main].[MediaObjects] where deviceid=2 and categoryid=20 group by title COLLATE SORT_LIB limit 30 offset 0 //if written to DTY_IPOD
    // select rowid,lowerfiltertag2,title from [Main].[MediaObjects] where deviceid=1 and categoryid=20 group by title COLLATE SORT_LIB limit 30 offset 0  //if written to DTY_USB
    //-------------------------------------------------------------------------------------------------------------------------------------------------
    else if(categoryType == CTY_SONG)
    {
        tResult res = MP_NO_ERROR;
        tMediaObject mediaObject;

        //current test database own already a test apple device ID=2
        tDeviceID deviceID;
        res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN testDevice);
        CPPUNIT_ASSERT(res == 0);

        /* store a dummy podcast object */
        int numOfCompilations    = numOfCategories;
        int numOfSongs           = numOfMediaObjectsToAdd;
        for(k=1;k<=numOfCompilations; k++)
        {
            for(i=1;i<=numOfSongs;i++)
            {
                InitMediaObject(OUT mediaObject); //clear object
                //---------------------
                //write a media object
                //---------------------
                mediaObject.deviceID = deviceID;
                mediaObject.catType = categoryType;


                snprintf(OUT mediaObject.fileName, IN sizeof(mediaObject.fileName), "/song/CompilationSong%d_FileName_%d",(k-1)*10+i,(k-1)*10+i);
                snprintf(OUT mediaObject.title,    IN sizeof(mediaObject.title),    "CompilationSong%d (of Compilation%d)",(k-1)*10+i,k );

                //don't write content here because this causes additional dependency with existing tests.
                snprintf(OUT mediaObject.MetadataField1, IN sizeof(mediaObject.MetadataField1), "GenreName%d",k);
                snprintf(OUT mediaObject.MetadataField2, IN sizeof(mediaObject.MetadataField2), "ArtistName%d",k);
                snprintf(OUT mediaObject.MetadataField3, IN sizeof(mediaObject.MetadataField3), "ComposerName%d",k);
                snprintf(OUT mediaObject.MetadataField4, IN sizeof(mediaObject.MetadataField4), "CompilationName%d",k);



                mediaObject.metadataConvertFlag = 0;
                mediaObject.compilationFlag = 1; //<--------------------------COMPILATION FLAG SET!
                mediaObject.totalPlaytime = 0;
                strncpy_r(OUT mediaObject.albumArtString, "", IN sizeof(mediaObject.albumArtString));
                mediaObject.trackNumber = 0;
                strncpy_r(OUT mediaObject.path, "/song/", IN sizeof(mediaObject.path));
                mediaObject.notPlayable = FNP_NOT_PLAYABLE;//?
                mediaObject.fileSize = 1LL;
                strncpy_r(OUT mediaObject.dateTime, "2009:02:08 10:40:27", IN sizeof(mediaObject.dateTime));
                mediaObject.fileMode = 0;
                mediaObject.userID = 0;
                mediaObject.groupID = 0;

                //----------------------------
                //add this mediaobject to database
                //----------------------------
                if(TRUE == bDelete)
                {
                    tMediaObject mediaObjectToDelete;
                    InitMediaObject(OUT mediaObjectToDelete);
                    res = LocalSPM::GetDBManager().GetObjectID(OUT mediaObjectToDelete.objectID, IN mediaObject.deviceID, IN mediaObject.fileName);
                    CPPUNIT_ASSERT(res == 0);

                    //delete this object
                    res = LocalSPM::GetDBManager().RemoveMediaObject(IN mediaObjectToDelete.objectID);
                    CPPUNIT_ASSERT(res == 0);
                }
                else
                {
                    res = LocalSPM::GetDBManager().StoreMediaObject(IN mediaObject);
                    CPPUNIT_ASSERT(res == 0);

#ifdef USE_CHECK_FAKE_DBENTRY_AFTERWRITE
                    res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
                    CPPUNIT_ASSERT(res == 0);

                    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
                    CPPUNIT_ASSERT(res == 0);

                    //----------------------------
                    //
                    //----------------------------
                    /* get the media object to compare */
                    tMediaObject newMediaObject;
                    InitMediaObject(OUT newMediaObject);
                    res = LocalSPM::GetDBManager().GetObjectID(OUT newMediaObject.objectID, IN mediaObject.deviceID, IN mediaObject.fileName);
                    CPPUNIT_ASSERT(res == 0);

                    res = LocalSPM::GetDBManager().GetMediaObject(OUT newMediaObject, INOUT newMediaObject.objectID);
                    CPPUNIT_ASSERT(res == 0);
                    VARTRACE(newMediaObject);
                    CPPUNIT_ASSERT(mediaObject.deviceID == newMediaObject.deviceID);
                    CPPUNIT_ASSERT(mediaObject.catType == newMediaObject.catType);
                    CPPUNIT_ASSERT(strcmp(mediaObject.fileName, newMediaObject.fileName) == 0);
                    CPPUNIT_ASSERT(strcmp(mediaObject.title, newMediaObject.title) == 0);
                    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField1, newMediaObject.MetadataField1) == 0);
                    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField2, newMediaObject.MetadataField2) == 0);
                    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField3, newMediaObject.MetadataField3) == 0);
                    CPPUNIT_ASSERT(strcmp(mediaObject.MetadataField4, newMediaObject.MetadataField4) == 0);
                    CPPUNIT_ASSERT(mediaObject.metadataConvertFlag == newMediaObject.metadataConvertFlag);
                    CPPUNIT_ASSERT(mediaObject.compilationFlag == newMediaObject.compilationFlag);
                    CPPUNIT_ASSERT(mediaObject.totalPlaytime == newMediaObject.totalPlaytime);
                    CPPUNIT_ASSERT(strstr(newMediaObject.albumArtString, mediaObject.albumArtString)); //DBManager add mount point to album art string
                    CPPUNIT_ASSERT(mediaObject.trackNumber == newMediaObject.trackNumber);
                    CPPUNIT_ASSERT(strcmp(mediaObject.path, newMediaObject.path) == 0);
                    CPPUNIT_ASSERT(mediaObject.notPlayable == newMediaObject.notPlayable);
                    CPPUNIT_ASSERT(mediaObject.fileSize == newMediaObject.fileSize);
                    CPPUNIT_ASSERT(strcmp(mediaObject.dateTime, newMediaObject.dateTime) == 0);
                    CPPUNIT_ASSERT(mediaObject.fileMode == newMediaObject.fileMode);
                    CPPUNIT_ASSERT(mediaObject.userID == newMediaObject.userID);
                    CPPUNIT_ASSERT(mediaObject.groupID == newMediaObject.groupID);
#endif
                }
            }
        }

#ifndef USE_CHECK_FAKE_DBENTRY_AFTERWRITE
        if(TRUE == bDelete)
        {
            //might not be necessary here but possibly helpful
            res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
            CPPUNIT_ASSERT(res == 0);
        }
        else
        {
            res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
            CPPUNIT_ASSERT(res == 0);
            res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
            CPPUNIT_ASSERT(res == 0);
        }
#endif //USE_CHECK_FAKE_DBENTRY_AFTERWRITE
    }
    else
    {
        ETG_TRACE_FATAL(("helperAddDeleteTestContentToDB: No match with parameters!"));
        res = MP_ERR_LC_GENERAL_ERROR;
    }

    ETG_TRACE_USR2(("End  : %s", __PRETTY_FUNCTION__));
    return res;
}


tResult ListControlTest::helperLoopTest(std::vector<tListType> &listTypesOfFullTextSearch)
{

    tResult res = MP_NO_ERROR;
    int levelCounter=0;
    tListSize listSizeExpected =tListSize_init;
    tListID listIDParent = LIST_ID_NONE;
    tListType listType = tListType_init;
    tDeviceType testDevice = tDeviceType_init;
    std::vector<std::string> expectedSearchResultList;
    std::string searchString;

    //if called writes into queue
    SimulationOutputWrapper *pSimulationOutputWrapper = NULL;

    ETG_TRACE_USR1(("          ***Test Level_%d start test rounds %s***",++levelCounter, __PRETTY_FUNCTION__));

    int round=0;
    for(std::vector<tListType>::iterator it = listTypesOfFullTextSearch.begin(); it != listTypesOfFullTextSearch.end();it++)
    {
        listType = *it;

        ETG_TRACE_USR4(("Round%d++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",++round));


        //take into account: some lists are bound to Apple device
        if(  (listType == LTY_PODCAST)
           ||(listType == LTY_PODCAST_EPISODE)
           ||(listType == LTY_BOOKTITLE_CHAPTER))
        {
            //testDevice = DTY_IPOD; due to dependency with IPODCtrl which does not have real IPOD connected this does not work
            testDevice = DTY_USB;
        }
        //other lists are done based on mass storage device DTY_USB
        else
        {
            testDevice = DTY_USB;
        }

        ETG_TRACE_USR1(("          ***Round:%d: Test Level_%d setup parent list %s***",round,levelCounter+1, __PRETTY_FUNCTION__));

        res = helperSetupParentList_FullTextSearch(OUT listIDParent,IN listType, IN testDevice);
        CPPUNIT_ASSERT(res == MP_NO_ERROR);
        CPPUNIT_ASSERT(listIDParent != LIST_ID_NONE);

        ETG_TRACE_USR1(("          ***Round:%dTest Level_%d show parent list %s***",round,levelCounter+2, __PRETTY_FUNCTION__));
        res = helperShowContentParentList(IN listIDParent);
        CPPUNIT_ASSERT(res == MP_NO_ERROR);



        ETG_TRACE_USR1(("          ***Round:%dTest Level_%d set test search string & expected results %s***",round,levelCounter+3, __PRETTY_FUNCTION__));
        searchString = "";
        expectedSearchResultList.clear();
        res = helperFillTestSearchString(IN listIDParent,OUT searchString, OUT expectedSearchResultList);
        CPPUNIT_ASSERT(res == MP_NO_ERROR);

        ETG_TRACE_USR1(("          ***Round:%dTest Level_%d show expected result %s***",round,levelCounter+4, __PRETTY_FUNCTION__));
        ETG_TRACE_USR4(("----------------------------------------------------------------------------------------------"));
        ETG_TRACE_USR4(("searchString:%s",searchString.c_str()));
        int count = 0;
        ETG_TRACE_USR4(("expectedSearchResultList.size(): %d",expectedSearchResultList.size()));
        for(std::vector<std::string>::iterator it = expectedSearchResultList.begin(); it != expectedSearchResultList.end();it++)
        {
            ETG_TRACE_USR4(("helperFillTestSearchString: expectedResultList[%d]: %s",count++,(*it).c_str()));
        }
        ETG_TRACE_USR4(("----------------------------------------------------------------------------------------------"));

        //-----------------------------------------------------------------
        //Outputwrapper shell write to queue directly after Full text search list is created
        //-----------------------------------------------------------------
        ETG_TRACE_USR1(("          ***Round:%dTest Level_%d output wrapper init to write to test q %s***",round,levelCounter+5, __PRETTY_FUNCTION__));
        pSimulationOutputWrapper = (SimulationOutputWrapper*)&LocalSPM::GetOutputWrapper();
        CPPUNIT_ASSERT(pSimulationOutputWrapper!=NULL);
        pSimulationOutputWrapper->testMsgQInit();

        //------------------------------
        //create corresponding search list
        //------------------------------
        ETG_TRACE_USR1(("          ***Round:%d Test Level_%d create fts list %s***",round,levelCounter+5, __PRETTY_FUNCTION__));

        //Outs
        tListID   listIDSearch   = LIST_ID_NONE;
        tListSize listSize       = tListSize_init;
        tDeviceID deviceIDSearch = DEVICE_ID_NOT_SET;

        //IN params
        tListID listIDReplacable = LIST_ID_NONE;

        res = LocalSPM::GetListControl().CreateMediaPlayerIndexedListWithSearchString(
              OUT listIDSearch,
              OUT listSize,
              OUT deviceIDSearch,
              IN  listIDParent,
              IN  listIDReplacable,
              IN  searchString.c_str());

         CPPUNIT_ASSERT(res == MP_NO_ERROR);
         CPPUNIT_ASSERT(listSize == 1); //expect a result

        //---------------------------------------------
        //Wait for all answers and check resulting ListSize
        //---------------------------------------------
        ETG_TRACE_USR1(("          ***Round:%d Test Level_%d check expected answer messages with size %s***",round,levelCounter+6, __PRETTY_FUNCTION__));
        listSizeExpected = expectedSearchResultList.size();
        helperWaitCheckAnswer_MethodReturnCreateListWithSearchStringAll(IN pSimulationOutputWrapper,IN listIDSearch,IN listSizeExpected,IN deviceIDSearch);

        //---------------------------------------------------------------
        //request ListSlize with all found elements and compare expected list elements
        //---------------------------------------------------------------
        ETG_TRACE_USR1(("          ***Round:%d Test Level_%d check expected answer List elements %s***",round,levelCounter+6, __PRETTY_FUNCTION__));
        res = helperCheckContentOfList(IN listIDSearch,IN expectedSearchResultList);
        CPPUNIT_ASSERT(res == MP_NO_ERROR);

        ETG_TRACE_USR1(("          ***Round:%d Test Level_%d delete test q %s***",round,levelCounter+6, __PRETTY_FUNCTION__));

        //delete test mesg queue to have clean situation for next round
        pSimulationOutputWrapper->testMsqQDelete();
        pSimulationOutputWrapper = NULL;


        ETG_TRACE_USR1(("          ***Round:%d Test Level_%d Release lists %s***",round,levelCounter+6, __PRETTY_FUNCTION__));

        res = LocalSPM::GetListControl().ReleaseAllLists();
        CPPUNIT_ASSERT(res == MP_NO_ERROR);




        ETG_TRACE_USR4(("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"));


    }

    return res;
}


/*
---------------------------------------------------
 Description to add a new search list type at all in the system
 ---------------------------------------------------
 1.) add new list type to tListType in Common/Typedefinitions.h
 2.) add correspodning new LTY_<newList>_SEARCH_COUNT entry - see comments with Roadmap 160014
 3.) add to DBManager/inc/queries.h corresponding command string for sql - see other examples tagged with comment Raodmap 160014
 - for entry and filtertag1,2,3,4/title LIKE ?  please check definition of tFilterTag1,tFilterTag2,tFilterTag3,tFilterTag4
 - this helps to set the correct one in dependency with the List-type
 4.) add to function DBManager::GetListSize case to bind LTY_<newList>_SEARCH to LTY_<newList>_SEARCH_COUNT
 5.) add to function DBManager::MaskOutFilterTagsByListType(...) corresponding case
 5.) add to ListControl::SetParentListCriteria() binding to corresponding parent list
 6.) ListControl::CreateMediaPlayerIndexedListWithSearchString(...) - care for parent child mapping

 ---------------------------------------------------
 Description how to extend the test if a new search list type has to be tested
 ---------------------------------------------------
 1) fct: CreateMediaPlayerIndexedListWithSearchString_AllTypeOfLists_ParametrizedTest()
 -listTypesOfFullTextSearch.push_back(<your list>)
 2) add to function ListControlTest::helperCheckContentOfList()
 -a case for the new list type to pack from ListSlice-Mediaobject the correct string -field in to std::string array
 3) ListControlTest::helperShowContentParentList(..) add case to show correct content of list
 4) helperSetupParentList_FullTextSearch
 - add case for parent i.e. to set up a parent list for the child search list
 - sometimes a base parent list gives basis for such parent list
 - set this variable 'listSizeExpected' can be done by  calling test CreateMediaPlayerIndexedListWithSearchString_AllTypeOfLists_ParametrizedTest()
   which calls helperShowContentParentList(IN listIDParent);shows all elements this helps to set this number
 5) fct: helperFillTestSearchString(...)
 -  take output list seen with previously mentioned function helperShowContentParentList(...)
 - and add this to the correspodning case of function helperFillTestSearchString
 - lo0king at the content choose a search string and fill expected list
 -such expected list is used in function 'helperCheckContentOfList() it is compared to the output of your new created search list where same searchstring is used'
 */
void ListControlTest::CreateMediaPlayerIndexedListWithSearchString_AllTypeOfLists_ParametrizedTest()
{
    ENTRY
    ETG_TRACE_USR1(("          ++++++++++++++++++++++++++++"));
    ETG_TRACE_USR1(("          ***Test Start %s***", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;
    std::vector<tListType> listTypesOfFullTextSearch;

    //vector to contains list types which will be tested
    ETG_TRACE_USR1(("          ***Test Level_%d setup tesplan %s***",0, __PRETTY_FUNCTION__));

    //=============
    //Test Setup
    //=============

    //Test Bound to device DTY_USB
    listTypesOfFullTextSearch.push_back(LTY_GENRE); //to test LTY_GENRE_SEARCH
    listTypesOfFullTextSearch.push_back(LTY_ARTIST);//to test LTY_ARTIST_SEARCH
    listTypesOfFullTextSearch.push_back(LTY_ALBUM); //to test LTY_ALBUM_SEARCH
    listTypesOfFullTextSearch.push_back(LTY_SONG); //to test LTY_SONG_SEARCH
    listTypesOfFullTextSearch.push_back(LTY_GENRE_ARTIST);//to test LTY_GENRE_ARTIST_SEARCH
    listTypesOfFullTextSearch.push_back(LTY_GENRE_ARTIST_ALBUM);// to test LTY_GENRE_ARTIST_ALBUM_SEARCH
    listTypesOfFullTextSearch.push_back(LTY_GENRE_ARTIST_ALBUM_SONG); // to test LTY_GENRE_ARTIST_ALBUM_SONG_SEARCH
    listTypesOfFullTextSearch.push_back(LTY_GENRE_ARTIST_SONG);//to test LTY_GENRE_ARTIST_SONG_SEARCH
    listTypesOfFullTextSearch.push_back(LTY_GENRE_ALBUM);// to test LTY_GENRE_ALBUM_SEARCH
    listTypesOfFullTextSearch.push_back(LTY_GENRE_ALBUM_SONG);// to test LTY_GENRE_ALBUM_SONG_SEARCH
    listTypesOfFullTextSearch.push_back(LTY_GENRE_SONG); //to test LTY_GENRE_SONG_SEARCH
    listTypesOfFullTextSearch.push_back(LTY_ARTIST_ALBUM);//to test LTY_ARTIST_ALBUM_SEARCH
    listTypesOfFullTextSearch.push_back(LTY_ARTIST_ALBUM_SONG);
    listTypesOfFullTextSearch.push_back(LTY_ARTIST_SONG);
    listTypesOfFullTextSearch.push_back(LTY_ALBUM_SONG);
    listTypesOfFullTextSearch.push_back(LTY_COMPOSER);
    listTypesOfFullTextSearch.push_back(LTY_COMPOSER_ALBUM);
    listTypesOfFullTextSearch.push_back(LTY_COMPOSER_ALBUM_SONG);
    listTypesOfFullTextSearch.push_back(LTY_COMPOSER_SONG);
#ifdef TARGET_BUILD
    //ubuntu test: Parent list has smaller size then it should be - thus disabled - target is the essential test thus test is valid
    //tbd.: analyse later
    listTypesOfFullTextSearch.push_back(LTY_VIDEO);
    listTypesOfFullTextSearch.push_back(LTY_VIDEO_EPISODE);
#endif
    listTypesOfFullTextSearch.push_back(LTY_IMAGE);

    //special
    //listTypesOfFullTextSearch.push_back(LTY_PLAYLIST);
    //listTypesOfFullTextSearch.push_back(LTY_PLAYLIST_SONG);

    //test Bound to DTY_IPOD
    //listTypesOfFullTextSearch.push_back(LTY_CURRENT_SELECTION); //<---not tested because directly communicates to IPOD. Thus. Decision made with expert not to offer this. similar to KeySearchLists
    //listTypesOfFullTextSearch.push_back(LTY_IMAGE_FOLDER);

    //Bound to DTY_USB?
    //listTypesOfFullTextSearch.push_back(FTS_AUDIO);
    //listTypesOfFullTextSearch.push_back(FTS_VIDEO);
    //listTypesOfFullTextSearch.push_back(FTS_PAYLIST);
    //listTypesOfFullTextSearch.push_back(FTS_IMAGE);
    //listTypesOfFullTextSearch.push_back(FTS_AUDIO_PLAYLIST);
    //listTypesOfFullTextSearch.push_back(FTS_ALL;

    //=============
    //Test
    //=============
    res = helperLoopTest(listTypesOfFullTextSearch);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    ETG_TRACE_USR1(("          ***Test End %s***", __PRETTY_FUNCTION__));

}

//same like CreateMediaPlayerIndexedListWithSearchString_AllTypeOfLists_ParametrizedTest but dummy content added to test certain lists
void ListControlTest::CreateMediaPlayerIndexedListWithSearchString_AllTypeOfLists_ParametrizedTest_UseDummyContent()
{
    ENTRY
    ETG_TRACE_USR1(("          ++++++++++++++++++++++++++++"));
    ETG_TRACE_USR1(("          ***Test Start %s***", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;
    std::vector<tListType> listTypesOfFullTextSearch;

    //vector to contains list types which will be tested
    ETG_TRACE_USR1(("          ***Test Level_%d setup tesplan %s***",0, __PRETTY_FUNCTION__));


    //=============
    //Test Setup
    //=============

    //Note: Test Bound to DTY_IPOD (in theory for pratical reason because dependency with ipodctrl if no device is connected forces to test with )

     //------------------------------------------------------
     //LTY_PODCAST_SEARCH, LTY_PODCAST_EPISODE_SEARCH
     //------------------------------------------------------
    int numOfPodcasts = 3;
    int numOfEpisodes = 10;
    //res = helperAddDeleteTestContentToDB(DTY_IPOD,CTY_PODCAST,numOfPodcasts,numOfEpisodes); //does not work since IPODCntrl. checks for existence of device
    res = helperAddDeleteTestContentToDB(DTY_USB,CTY_PODCAST,numOfPodcasts,numOfEpisodes);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    //listTypesOfFullTextSearch.push_back(LTY_PODCAST);
    listTypesOfFullTextSearch.push_back(LTY_PODCAST_EPISODE);

    //LTY_AUDIOBOOK_SEARCH,LTY_BOOKTITLE_CHAPTER_SEARCH
    //------------------------------------------------------
    int numOfAudiobook = 3;
    int numOfBookTitleChapters = 10;
    //res = helperAddDeleteTestContentToDB(DTY_IPOD,CTY_AUDIOBOOK,numOfPodcasts,numOfEpisodes); //does not work since IPODCntrl. checks for existence of device
    res = helperAddDeleteTestContentToDB(DTY_USB,CTY_AUDIOBOOK,numOfAudiobook,numOfBookTitleChapters);
    listTypesOfFullTextSearch.push_back(LTY_AUDIOBOOK);
    listTypesOfFullTextSearch.push_back(LTY_BOOKTITLE_CHAPTER);

    //------------------------------------------------------
    //LTY_COMPILATION_SEARCH,LTY_COMPILATION_SONG_SEARCH
    //------------------------------------------------------
    int numOfCompilations = 3;
    int numOfSongs = 10;
    res = helperAddDeleteTestContentToDB(DTY_USB,CTY_SONG,numOfCompilations,numOfSongs); //Song is used to crate compilation
    listTypesOfFullTextSearch.push_back(LTY_COMPILATION);
    listTypesOfFullTextSearch.push_back(LTY_COMPILATION_SONG);

    //=============
    //Test
    //=============
    res = helperLoopTest(listTypesOfFullTextSearch);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    //delete database entries added for this test to prepare Db in the way further tests or this test group are used to it. There seemed to be a dependency within a group of tests
    tBool bDelete = TRUE;
    res = helperAddDeleteTestContentToDB(DTY_USB,CTY_PODCAST,numOfPodcasts,numOfEpisodes,bDelete);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    res = helperAddDeleteTestContentToDB(DTY_USB,CTY_AUDIOBOOK,numOfAudiobook,numOfBookTitleChapters,bDelete);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    res = helperAddDeleteTestContentToDB(DTY_USB,CTY_SONG,numOfCompilations,numOfSongs,bDelete);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);


    ETG_TRACE_USR1(("          ***Test End %s***", __PRETTY_FUNCTION__));

}

void ListControlTest::CheckListsPerformanceTest()
{
    ENTRY_TEST


    tResult res;
    tStreaming streaming = false;
    tFilterTag1 tag1 = { 0 };
    tFilterTag2 tag2 = { 0 };
    tFilterTag3 tag3 = { 0 };
    tFilterTag4 tag4 = { 0 };
    vector<tListID> listIDVector;
    tListSize listSize;
    vector<tMediaObject> mediaObjectVector;
    tDeviceID deviceID;
    tListID listID;

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* create a album list */
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_ARTIST,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    ETG_TRACE_USR4(("CheckListsPerformanceTest:listSize:%d",listSize));
    ETG_TRACE_USR4(("LocalSPM::GetDataProvider().DBUnifiedSchema():%d",LocalSPM::GetDataProvider().DBUnifiedSchema()));
    if(LocalSPM::GetDataProvider().DBUnifiedSchema())
    {
        CPPUNIT_ASSERT(listSize == 4);
    }
    else
    {
        CPPUNIT_ASSERT(listSize == 5);
    }

    /* request slice from the album list */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            IN 0,
            IN listSize);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    // set the filter tags
      tag1.genre  = mediaObjectVector[1].MetadataTag1;  //German Pop
      tag2.artist = mediaObjectVector[1].MetadataTag2; //Herbert Grönemeyer
      tag3.tag = 0;
      tag4.album = 0x0;

      res = LocalSPM::GetListControl().ReleaseList(IN listID);
      CPPUNIT_ASSERT(res == MP_NO_ERROR);

      /* create a list with the tags found before */
      res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
              OUT listID,
              OUT listSize,
              LTY_GENRE_ARTIST_ALBUM,
              IN streaming,
              IN tag1,
              IN tag2,
              IN tag3,
              IN tag4,
              IN deviceID);
      CPPUNIT_ASSERT(res == MP_NO_ERROR);




    /* delete album list */
    //res = LocalSPM::GetListControl().ReleaseList(IN listID);
   // CPPUNIT_ASSERT(res == MP_NO_ERROR);


    // create a song list
    tListID listID2;
    vector<tMediaObject> mediaObjectVector2;
    res = LocalSPM::GetListControl().CreatePlayList(
            OUT listID2,
            LTY_ALBUM_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            PC_NO_REPEAT,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* get a valid object id */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector2,
            IN listID2,
            IN 0,
            IN 3);
 //   CPPUNIT_ASSERT(res == MP_NO_ERROR);
  //  CPPUNIT_ASSERT(mediaObjectVector2.size() == 3);

    /* set the now playing object */
 //   tPosition position;
//    res = LocalSPM::GetListControl().UpdateNowPlaying(OUT position, IN listID2, IN mediaObjectVector2[2].objectID);
//    CPPUNIT_ASSERT(res == MP_NO_ERROR);
 //   CPPUNIT_ASSERT(position == 2);

  //  res = LocalSPM::GetListControl().ReleaseList(IN listID2);
  //  CPPUNIT_ASSERT(res == MP_NO_ERROR);

    LocalSPM::GetListControl().CheckLists(deviceID);
}


//<<Roadmap Music Box , recording year list types
void ListControlTest:: CreateLTY_YEAR()
{

        ENTRY_TEST
        tResult res;
        tStreaming streaming = false;
        tFilterTag1 tag1 = { 0 };
        tFilterTag2 tag2 = { 0 };
        tFilterTag3 tag3 = { 0 };
        tFilterTag4 tag4 = { 0 };
        vector<tListID> listIDVector;
        tListSize listSize;
        vector<tMediaObject> mediaObjectVector;
        vector<tMediaObject> mediaObjectVectorSongs;
        tDeviceID deviceID;
        tListID listID;

        /* set device id */
        res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB");
        CPPUNIT_ASSERT(res == MP_NO_ERROR);

        /* create a album list */
        res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
                OUT listID,
                OUT listSize,
                LTY_YEAR,
                IN streaming,
                IN tag1,
                IN tag2,
                IN tag3,
                IN tag4,
                IN deviceID);
        CPPUNIT_ASSERT(res == MP_NO_ERROR);
        VARTRACE(listID);
        VARTRACE(listSize);
        CPPUNIT_ASSERT(listSize == 4);
        res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
                 OUT mediaObjectVector,
                 IN listID,
                 IN 0,
                 IN listSize);
         CPPUNIT_ASSERT(res == MP_NO_ERROR);
         VARTRACE(mediaObjectVector);
         res = LocalSPM::GetListControl().ReleaseList(IN listID);
         CPPUNIT_ASSERT(res == MP_NO_ERROR);

//for(unsigned int i = 0 ; i < listSize ;i++)
//{
         tag1.yearID = mediaObjectVector[0].yearID;
         VARTRACE(tag1.yearID);
        // snprintf(tag1,sizeof(tFilterTag1),"2002");

         /* second ask for all albums */
         res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
                        OUT listID,
                        OUT listSize,
                        LTY_YEAR_ALBUM,
                        IN streaming,
                        IN tag1,
                        IN tag2,
                        IN tag3,
                        IN tag4,
                        IN deviceID);
                CPPUNIT_ASSERT(res == MP_NO_ERROR);

                VARTRACE(listSize);


                mediaObjectVector.clear();
                res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
                        OUT mediaObjectVector,
                        IN listID,
                        0,
                        listSize);

                CPPUNIT_ASSERT(res == MP_NO_ERROR);

                VARTRACE(mediaObjectVector);
                res = LocalSPM::GetListControl().ReleaseList(IN listID);

                tag1.yearID = mediaObjectVector[0].yearID;
                tag4.album = mediaObjectVector[0].MetadataTag4;


                /* second ask for all SONGS in the album with a particular year */
                res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
                               OUT listID,
                               OUT listSize,
                               LTY_YEAR_ALBUM_SONG,
                               IN streaming,
                               IN tag1,
                               IN tag2,
                               IN tag3,
                               IN tag4,
                               IN deviceID);
               CPPUNIT_ASSERT(res == MP_NO_ERROR);
               mediaObjectVector.clear();
               res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
                       OUT mediaObjectVector,
                       IN listID,
                       0,
                       listSize);

               CPPUNIT_ASSERT(res == MP_NO_ERROR);
               /* Set active object to the first one */
               tPosition position;
               res = LocalSPM::GetListControl().UpdateNowPlaying(OUT position, IN listID, IN mediaObjectVector[0].objectID);
               CPPUNIT_ASSERT(res == MP_NO_ERROR);
               CPPUNIT_ASSERT(position == 0);
               tMediaObject currentMediaObject;
               /* Check whether current object is same as set via UpdateNowPlaying */
               res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT currentMediaObject, IN listID);
               CPPUNIT_ASSERT(res == MP_NO_ERROR);
               CPPUNIT_ASSERT(currentMediaObject.objectID == mediaObjectVector[0].objectID);

               VARTRACE(mediaObjectVector);
               res = LocalSPM::GetListControl().ReleaseList(IN listID);

}

void ListControlTest::CreatePlaylist_RequestedMultipleTimesFor_SameAttributes_DifferentAttributes()
{
    ENTRY_TEST

    tResult res;
    tStreaming streaming = false;
    tFilterTag1 tag1 = { 0 };
    tFilterTag2 tag2 = { 0 };
    tFilterTag3 tag3 = { 0 };
    tFilterTag4 tag4 = { 0 };
    tSearchString searchText;
    // set the filter tags
    tag1.genre = 0x0;
    tag2.artist = 0;
    tag3.tag = 0;
    tag4.album = 4;    //Garbage
    strncpy_r(searchText,"A",sizeof(searchText));

    vector<tListID> listIDVector;
    tListSize listSize;
    vector<tMediaObject> mediaObjectVector;
    tDeviceID deviceID;
    tListID listID, listID1, listID2, listID3;

    /*Enable FullTextSearch configuration if not enabled*/
    int fullTextSearch = LocalSPM::GetDataProvider().FullTextSearch();
    if (0 == fullTextSearch)
    {
        LocalSPM::GetDataProvider().FullTextSearch = 1;
    }

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    //1. Create a list of songs for album "Garbage" with search text = "A".
    res = LocalSPM::GetListControl().CreatePlayList(OUT listID,
            IN LTY_ALBUM_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN PC_STEPUP_ONE_LEVEL,
            IN deviceID,
            IN true,
            IN searchText);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    //2. Again create a list of songs for album "Garbage" with search text = "A".
    res = LocalSPM::GetListControl().CreatePlayList(OUT listID1,
            IN LTY_ALBUM_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN PC_STEPUP_ONE_LEVEL,
            IN deviceID,
            IN true,
            IN searchText);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    //3. No new list should be created for step 2. List created in step 1 and 2 should have same list ID
    CPPUNIT_ASSERT(listID == listID1);

    //change only the search text
    strncpy_r(searchText,"M",sizeof(searchText));

    //4. Again create a list of songs for album "Garbage" with search text = "M".
    res = LocalSPM::GetListControl().CreatePlayList(OUT listID2,
            IN LTY_ALBUM_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN PC_STEPUP_ONE_LEVEL,
            IN deviceID,
            IN true,
            IN NULL);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    //5. A new list should be created for step4. List created in step 1 and 4 should have different list ID.
    CPPUNIT_ASSERT(listID != listID2);

    // set the filter tags
    tag1.genre = 0x0;
    tag2.artist = 0;
    tag3.tag = 0;
    tag4.album = 29;//2010 FIFA World Cup Anthem

    //6. Create another list of songs for album "2010 FIFA World Cup Anthem"
    res = LocalSPM::GetListControl().CreatePlayList(OUT listID3,
            IN LTY_ALBUM_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN PC_STEPUP_ONE_LEVEL,
            IN deviceID,
            IN true,
            IN NULL);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    //7. A new list should be created for step6. This list ID should be different from all the list ID's created.
    CPPUNIT_ASSERT(listID2 != listID3);
    CPPUNIT_ASSERT(listID != listID3);

    tListType listType;
    tListID parentListID;
    tDeviceID deviceIDInfo;
    tPosition position;

    //Releasing a list will decrement the CreationCounter and will actually release the list only if the CreationCounter becomes 0.

    //The CreationCounter for the listID1(album "Garbage" with search text = "A") is 2, since we have created the list twice.
    //So Release the list twice to release it completely
    res = LocalSPM::GetListControl().ReleaseList(IN listID1);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    res = LocalSPM::GetListControl().RequestListInformation(
               OUT listType,
               OUT parentListID,
               OUT deviceIDInfo,
               OUT position,
               OUT listSize,
               IN listID1);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    res = LocalSPM::GetListControl().RequestListInformation(
               OUT listType,
               OUT parentListID,
               OUT deviceIDInfo,
               OUT position,
               OUT listSize,
               IN listID);
    CPPUNIT_ASSERT(res == MP_ERR_LC_UNDEFINED_LIST_ID);

    //The CreationCounter for the listID2(album "Garbage" with search text = "M") is 1, since we have created the list only once
    //Release the list once to release it completely
    res = LocalSPM::GetListControl().ReleaseList(IN listID2);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    res = LocalSPM::GetListControl().RequestListInformation(
               OUT listType,
               OUT parentListID,
               OUT deviceIDInfo,
               OUT position,
               OUT listSize,
               IN listID2);
    CPPUNIT_ASSERT(res == MP_ERR_LC_UNDEFINED_LIST_ID);

    //The CreationCounter for the listID3(album "2010 FIFA World Cup Anthem") is 1, since we have created the list only once
    //Release the list once to release it completely
    res = LocalSPM::GetListControl().ReleaseList(IN listID3);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    res = LocalSPM::GetListControl().RequestListInformation(
               OUT listType,
               OUT parentListID,
               OUT deviceIDInfo,
               OUT position,
               OUT listSize,
               IN listID3);
    CPPUNIT_ASSERT(res == MP_ERR_LC_UNDEFINED_LIST_ID);

    /*Restore the FullTextSearch configuration*/
    if (fullTextSearch != LocalSPM::GetDataProvider().FullTextSearch())
    {
        LocalSPM::GetDataProvider().FullTextSearch = fullTextSearch;
    }

}

void ListControlTest::CreateMediaPlayerFileList_RequestedMultipleTimesFor_SameAttributes_DifferentAttributes()
{
    ENTRY_TEST

    tResult res;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPosition position;
    tPath path;
    tListID listID, listID1, listID2;
    tDeviceID deviceID; // usb device

    /*Enable DBFileBrowsingByDB configuration if not enabled, to simulate bug NCG3D-132472*/
    int dbFileBrowsingByDb = LocalSPM::GetDataProvider().DBFileBrowsingByDB();
    if (0 == dbFileBrowsingByDb)
    {
        LocalSPM::GetDataProvider().DBFileBrowsingByDB = 1;
    }

    /* Set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    //1.Create a file list for the directory "/music/Garbage/Garbage-Garbage-07-Vow.mp3"
    strncpy_r(path, "/music/Garbage/Garbage-Garbage-07-Vow.mp3", sizeof(path));
    res = LocalSPM::GetListControl().CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            OUT position,
            IN path,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    //2.Create a file list for the directory "/music/Garbage/Garbage-Garbage-07-Vow.mp3"
    strncpy_r(path, "/music/Garbage/Garbage-Garbage-07-Vow.mp3", sizeof(path));
    res = LocalSPM::GetListControl().CreateMediaPlayerFileList(
            OUT listID1,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            OUT position,
            IN path,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    //3. No new list should be created for step 2. List created in step 1 and 2 should have same list ID
    CPPUNIT_ASSERT(listID == listID1);

    //4.Create a file list for the directory "/music/"
    strncpy_r(OUT path, IN "/music/", IN sizeof(path));
    res = LocalSPM::GetListControl().CreateMediaPlayerFileList(
            OUT listID2,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN LTY_FILELIST,
            IN path,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(listID1 != listID2);

    tListType listType;
    tListID parentListID;
    tDeviceID deviceIDInfo;

    //Releasing a list will decrement the CreationCounter and will actually release the list only if the CreationCounter becomes 0.

    //The CreationCounter for the listID1(path = "/music/Garbage/Garbage-Garbage-07-Vow.mp3") is 2, since we have created the list twice.
    //So Release the list twice to release it completely
    res = LocalSPM::GetListControl().ReleaseList(listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    res = LocalSPM::GetListControl().RequestListInformation(
               OUT listType,
               OUT parentListID,
               OUT deviceIDInfo,
               OUT position,
               OUT listSize,
               IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetListControl().ReleaseList(listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    res = LocalSPM::GetListControl().RequestListInformation(
               OUT listType,
               OUT parentListID,
               OUT deviceIDInfo,
               OUT position,
               OUT listSize,
               IN listID);
    CPPUNIT_ASSERT(res == MP_ERR_LC_UNDEFINED_LIST_ID);

    //The CreationCounter for the listID2(path = "/music/") is 1, since we have created the list only once
    //Release the list once to release it completely
    res = LocalSPM::GetListControl().ReleaseList(listID2);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    res = LocalSPM::GetListControl().RequestListInformation(
               OUT listType,
               OUT parentListID,
               OUT deviceIDInfo,
               OUT position,
               OUT listSize,
               IN listID2);
    CPPUNIT_ASSERT(res == MP_ERR_LC_UNDEFINED_LIST_ID);

    /*Restore the DBFileBrowsingByDB configuration*/
    if (dbFileBrowsingByDb != LocalSPM::GetDataProvider().DBFileBrowsingByDB())
    {
        LocalSPM::GetDataProvider().DBFileBrowsingByDB = dbFileBrowsingByDb;
    }

}
