#include "ConfigTest.h"



#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/MediaPlayerInterfaceTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include "MediaPlayerInterfaceTest.h"
#include "VarTrace.h"
#include "../DBManager/src/UCASort/UCASort.h"
#include "DVDBackendCMD.h"

#if !defined(TARGET_BUILD)
// access project specific usage flag for MediaEngine in DataProvider only for simulation
#define RETURN_ON_MEDIAENGINE_ON   if(1 == LocalSPM::GetDataProvider().UseMediaEngine()) { return; }
#else
#define RETURN_ON_MEDIAENGINE_ON // target
#endif

#include "wait.h"
#include "sys/types.h"
#define SPACE_ " "


/*Songs*/
tObjectID mFAVORITE_1_OBJECT_ID;
tObjectID mFAVORITE_2_OBJECT_ID;

#define FAVORITE_1_LABEL        "Milk"
#define FAVORITE_2_LABEL        "sheepdog"

#define WAIT_FOR_HMI_STATE(stateToReach, timeoutInSec) \
        if (CheckPlaybackState((stateToReach), (timeoutInSec)) != MP_NO_ERROR) {\
            tHMIPlaybackState playstatus = HMI_PBS_UNDEFINED;\
            GMPTEST_EXPECT(stateToReach == playstatus);\
        }

static MediaPlayerInterface&  mMediaPlayerInterface = MediaPlayerInterface::GetInstance();

static tUInt genre;
static tUInt artist;
static tUInt album;
static tUInt podcast;
static tUInt audiobook;
static tUInt author;
static tUInt composer;
static tUInt video;
static tUInt playlist;

static tListID mListID;
static tListSize mListSize;

static tListID mMultiLanguageSongListID ;
static tListSize mMultiLanguageSongListSize ;

MediaPlayerInterfaceTest::MediaPlayerInterfaceTest() : mSimulationConfiguration(COMPONENT_ID_CONFIGURATION),
        mSimulationOutputWrapper(COMPONENT_ID_OUTPUTWRAPPER),
        mSimulationCustomControl(COMPONENT_ID_CUSTOMCONTROL)
{
    funPtr = NULL;
}

void MediaPlayerInterfaceTest::setUp()
{
    ticks.begin();
}

void MediaPlayerInterfaceTest::tearDown()
{
    ticks.elapsed();
}

void MediaPlayerInterfaceTest::InitTestsuite()
{
    ENTRY

    tResult res = MP_NO_ERROR;

    /* recreate the test database */
    res = LocalSPM::GetDataProvider().RecreateTestDatabase(true, true); //after this call all components are reset because localSPM goes to Off and Normal again
    GMPTEST_EXPECT(res == 0);

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    GMPTEST_EXPECT(res == 0);

    RegisterUpdatePlaybackState();
    RegisterUpdatePlaytime();
    RegisterNowPlaying();
}

void MediaPlayerInterfaceTest::EnableBrowseList()
{
    ENTRY_TEST

    tResult res;

    /* Enable DBFileBrowsingByDB configuration */
    int browsingByDB = LocalSPM::GetDataProvider().DBFileBrowsingByDB();
    if (0 == browsingByDB)
    {
        LocalSPM::GetDataProvider().DBFileBrowsingByDB = 1;
    }

    /* Recreate the test database */
    InitTestsuite();

    /* scan the second USB test data too */
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB-2");
    GMPTEST_EXPECT(res == 0);

    res = LocalSPM::GetDBManager().ScanDirForTest(deviceID);
    GMPTEST_EXPECT(res == 0);
}

void MediaPlayerInterfaceTest::DisableBrowseList()
{
    ENTRY_TEST

    /* Disable DBFileBrowsingByDB configuration */
    int browsingByDB = LocalSPM::GetDataProvider().DBFileBrowsingByDB();
    if (0 != browsingByDB)
    {
        LocalSPM::GetDataProvider().DBFileBrowsingByDB = 0;
    }

    /* Recreate the test database */
    InitTestsuite();
}

tResult MediaPlayerInterfaceTest::WaitForPlaytimeUpdate(int sec)
{
    tResult res = MP_NO_ERROR;
    tPlaytime elapsedPlaytime = 0;
    tPlaytime elapsedPlaytimeCompare = 0;
    tPlaytime totalPlaytime = 0;
    tObjectID objectID = OBJECT_ID_NONE;
    int secMax = sec;

    for(; sec; sec--) {

        /* get the current playtime */
        res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
        if (res != MP_NO_ERROR) break;

        if(secMax == sec) { // if first run, store only the current play time as compare value
            elapsedPlaytimeCompare = elapsedPlaytime;
        } else { // if additional run, check if playtime changes
            if ((elapsedPlaytimeCompare != elapsedPlaytime) && (elapsedPlaytime != 0)) {
                break;
            }
        }
        sleep(1);
    }
    if(0 == sec) {
        res = MP_ERR_MISC_TIMEOUT; //playtime was not updated
    }
    return res;
}

tResult MediaPlayerInterfaceTest::WaitForListID(const tListID listID, int sec)
{
    tResult res = MP_NO_ERROR;
    tNowPlaying nowPlaying;

    for(; sec; sec--) {
        res = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
        if (res != MP_NO_ERROR) break;

        if(listID == nowPlaying.listID) break;
        sleep(1);
    }
    if(0 == sec) {
        res = MP_ERR_MISC_TIMEOUT; //requested list not found in time
    }
    return res;
}

tResult MediaPlayerInterfaceTest::WaitForTitleUpdate(const char *title, int sec,tBoolean isVideoObject)
{
    tResult res = MP_NO_ERROR;
    tNowPlaying nowPlaying;

    for(; sec; sec--) {
        res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
        if (res != MP_NO_ERROR) break;

        if(isVideoObject)
        {
            if(!strcmp(title, (const char *)nowPlaying.object.MetadataField1)) break;
        }
        else
        {
            if(!strcmp(title, (const char *)nowPlaying.object.title)) break;
        }
        sleep(1);
    }
    if(0 == sec) {
        res = MP_ERR_MISC_TIMEOUT; //requested title not found in time
    }
    return res;
}

/************** Interface Test Case Started ******************/
//Already Startup test case is added in the MediaPlayerStartupTest file

void MediaPlayerInterfaceTest::PrepareTestValues()
{
    ENTRY_TEST

    tResult res;

    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* set the filter tags */
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            mListID,
            mListSize,
            LTY_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mListSize > 0);

    /* get the object ID for the favorite test song Milk */
    vector<tMediaObject> mediaObjectVector;
    res =  mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN mListID,
            0,
            IN mListSize);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() == mListSize);

    /* search the Milk song */
    mFAVORITE_1_OBJECT_ID = 0;
    for(tUInt i=0; i<mediaObjectVector.size(); i++) {

        if (!strcmp(FAVORITE_1_LABEL, mediaObjectVector[i].title)) {
            mFAVORITE_1_OBJECT_ID = mediaObjectVector[i].objectID;
            break;
        }
    }
    GMPTEST_EXPECT(mFAVORITE_1_OBJECT_ID != 0);

    /* search for sheepdog song */
    mFAVORITE_2_OBJECT_ID = 0;
    for(tUInt i=0; i<mediaObjectVector.size(); i++)
    {
        if (!strcmp(FAVORITE_2_LABEL, mediaObjectVector[i].title)) {
            mFAVORITE_2_OBJECT_ID = mediaObjectVector[i].objectID;
            break;
        }
    }
    GMPTEST_EXPECT(mFAVORITE_2_OBJECT_ID != 0);
}

void MediaPlayerInterfaceTest::CreateMediaPlayer()
{
    ENTRY_TEST

    tResult res = -1;

    res = mMediaPlayerInterface.Register(&mSimulationConfiguration);
    GMPTEST_EXPECT(res == 0);

    res = mMediaPlayerInterface.Register(&mSimulationOutputWrapper);
    GMPTEST_EXPECT(res == 0);

    res = mMediaPlayerInterface.Register(&mSimulationCustomControl);
    GMPTEST_EXPECT(res == 0);

    res = mMediaPlayerInterface.CreateMediaPlayer();
    GMPTEST_EXPECT(res == 0);
}

void MediaPlayerInterfaceTest::StateChangeNormal()
{
    ENTRY_TEST

    tResult res = mMediaPlayerInterface.StateChangeNormal();
    GMPTEST_EXPECT(res == 0);
}

void MediaPlayerInterfaceTest::StateChangeOff()
{
    ENTRY_TEST

    tResult res = mMediaPlayerInterface.StateChangeOff();
    GMPTEST_EXPECT(res == 0);
}


void MediaPlayerInterfaceTest::SendAllocate()
{
    ENTRY_TEST

    tResult res = -1;

    /* Call SendAllocate */
    tAudioOutputDevice audioOutputDevice;
    strncpy_r(OUT audioOutputDevice, USB_ALSA_DEVICENAME, IN sizeof(audioOutputDevice));

    res = mMediaPlayerInterface.SendAllocate(IN audioOutputDevice);
    GMPTEST_EXPECT(res == 0);
}

void MediaPlayerInterfaceTest::SendSourceActivityOn()
{
    ENTRY_TEST

    tResult res = -1;

    tSourceActivity sourceActivity = SA_ON;
    res = mMediaPlayerInterface.SendSourceActivity(IN sourceActivity);
    GMPTEST_EXPECT(res == 0);
}


void MediaPlayerInterfaceTest::SendSourceActivityOff()
{
    ENTRY_TEST

    tResult res = -1;

    tSourceActivity sourceActivity = SA_OFF;
    res = mMediaPlayerInterface.SendSourceActivity(IN sourceActivity);
    GMPTEST_EXPECT(res == 0);
}

void MediaPlayerInterfaceTest::SendDeAllocate()
{
    ENTRY_TEST

    tResult res = -1;

    /* Call SendDeAllocate */
    res = mMediaPlayerInterface.SendDeAllocate();
    GMPTEST_EXPECT(res == 0);
}

void MediaPlayerInterfaceTest::SimulateDeviceError()
{

    ENTRY
    ETG_TRACE_USR4(("          ***Start %s***", __PRETTY_FUNCTION__));
    tUndervoltage undervoltage = false;
    tResult res = MP_NO_ERROR;
    vector<tDeviceInfo> deviceInfos;

    tDeviceID deviceID;
    // Enable triggers
    res = LocalSPM::GetIndexer().SwitchDBTrigger(IN TT_ALL, IN TS_ON);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    res = LocalSPM::GetCustomControl().SwitchDBTrigger(IN TT_ALL, IN TS_ON);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    res = LocalSPM::GetPlayerManager().SwitchDBTrigger(IN TT_ALL, IN TS_ON);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);



    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB-2");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID, 0);

    tMountPoint OldMountPoint;
    strncpy_r(OUT OldMountPoint, IN deviceInfo.mountPoint, IN sizeof(OldMountPoint));

    /*create symbolic link to simulate "mount" command*/
    tSearchString commandString;
    strncpy_r(commandString, "ln -s", sizeof(commandString));
    strncat_r(commandString, SPACE_, sizeof(commandString));
    strncat_r(commandString, deviceInfo.mountPoint, sizeof(commandString));
    strncat_r(commandString, SPACE_, sizeof(commandString));

#ifdef TARGET_BUILD
    strncpy_r(deviceInfo.mountPoint, "/tmp/dummy_link", sizeof(deviceInfo.mountPoint));
#else
    /*create the symbolic link under home directory of the user(ex:/home/kmv5cob/dummy_link) and make it the new mountpoint*/
    const char *userName = getenv("USER");
    strncpy_r(deviceInfo.mountPoint, "/home/", sizeof(deviceInfo.mountPoint));
    strncat_r(deviceInfo.mountPoint, userName, sizeof(deviceInfo.mountPoint));
    strncat_r(deviceInfo.mountPoint, "/dummy_link", sizeof(deviceInfo.mountPoint));
#endif
    strncat_r(commandString, deviceInfo.mountPoint, sizeof(commandString));

    ETG_TRACE_USR4(("MediaPlayerInterfaceTest::SimulateDeviceError : commandString for creating symbolic link : %s",commandString));
    system(commandString);

    //feed interface
    deviceInfo.connectionState = CS_ATTACHED;
    deviceInfos.push_back(deviceInfo);//holds at position 0 last notification

    //this will disconnect the device and connect it again, since mount point has changed
    res = MediaPlayerInterface::GetInstance().DeviceChanged(IN undervoltage, IN deviceInfos);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    sleep(2);
    res = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(deviceInfo.connectionState == CS_CONNECTED);

    /* Allocate */
    tAudioOutputDevice audioOutputDevice;
    strncpy_r(OUT audioOutputDevice, USB_ALSA_DEVICENAME, IN sizeof(audioOutputDevice));

    res = mMediaPlayerInterface.SendAllocate(IN audioOutputDevice);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = mMediaPlayerInterface.ActiveMediaDeviceSet(IN deviceID, IN true);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    /* SA_ON */
    tSourceActivity sourceActivity = SA_ON;
    res = mMediaPlayerInterface.SendSourceActivity(IN sourceActivity);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    ASYNC_WAIT_START(1);

    res = mMediaPlayerInterface.ActiveMediaDeviceGet(deviceInfo);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(deviceInfo.deviceID == deviceID);

    sleep(3); //Play at least 3s

    WAIT_FOR_HMI_STATE(HMI_PBS_PLAYING, 30);

    /*Now delete the symbolic link which has been created earlier to simulate device error*/
    tSearchString commandString1;
    strncpy_r(commandString1, "rm", sizeof(commandString1));
    strncat_r(commandString1, SPACE_, sizeof(commandString));
    strncat_r(commandString1, deviceInfo.mountPoint, sizeof(commandString1));
    ETG_TRACE_USR4(("MediaPlayerInterfaceTest::SimulateDeviceError : commandString1 for deleting symbolic link : %s",commandString1));
    system(commandString1);

    // when device error is triggered, the device will be moved to disconnected state
    int retry = 10;
    while(retry)
    {
        res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID, 0);
        if(deviceInfo.connectionState == CS_DISCONNECTED)
            break;
        sleep(1);
        retry--;
    }
    CPPUNIT_ASSERT(deviceInfo.connectionState == CS_DISCONNECTED);
    //restore oldmountpoint in db
    strncpy_r(OUT deviceInfo.mountPoint, IN OldMountPoint, IN sizeof(deviceInfo.mountPoint));
    deviceInfos.clear();
    deviceInfos.push_back(deviceInfo);

    res = MediaPlayerInterface::GetInstance().DeviceChanged(IN undervoltage, IN deviceInfos);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    res = LocalSPM::GetIndexer().SwitchDBTrigger(IN TT_ALL, IN TS_OFF);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    res = LocalSPM::GetCustomControl().SwitchDBTrigger(IN TT_ALL, IN TS_OFF);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    res = LocalSPM::GetPlayerManager().SwitchDBTrigger(IN TT_ALL, IN TS_OFF);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

}
void MediaPlayerInterfaceTest::SourceChangeSuzuki()
{
    ENTRY_TEST

    tResult res = -1;

    /* Activate first USB device */
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB-2");
    GMPTEST_EXPECT(res == 0);

    res = mMediaPlayerInterface.ActiveMediaDeviceSet(IN deviceID, IN true);
    GMPTEST_EXPECT(res == 0);
    ASYNC_WAIT_START(1);

    tDeviceInfo deviceInfo;
    res = mMediaPlayerInterface.ActiveMediaDeviceGet(deviceInfo);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(!strcmp(deviceInfo.deviceName, "USB-2"));
    GMPTEST_EXPECT(deviceInfo.deviceID == deviceID);

    /* SA_OFF */
    tSourceActivity sourceActivity = SA_OFF;
    res = mMediaPlayerInterface.SendSourceActivity(IN sourceActivity);
    GMPTEST_EXPECT(res == 0);

    /* DeAllocate */
    res = mMediaPlayerInterface.SendDeAllocate();
    GMPTEST_EXPECT(res == 0);

    /* Allocate */
    tAudioOutputDevice audioOutputDevice;
    strncpy_r(OUT audioOutputDevice, USB_ALSA_DEVICENAME, IN sizeof(audioOutputDevice));

    res = mMediaPlayerInterface.SendAllocate(IN audioOutputDevice);
    GMPTEST_EXPECT(res == 0);

    /* Activate second USB device */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB");
    GMPTEST_EXPECT(res == 0);

    res = mMediaPlayerInterface.ActiveMediaDeviceSet(IN deviceID, IN true);
    GMPTEST_EXPECT(res == 0);

    /* SA_ON */
    sourceActivity = SA_ON;
    res = mMediaPlayerInterface.SendSourceActivity(IN sourceActivity);
    GMPTEST_EXPECT(res == 0);
    ASYNC_WAIT_START(1);

    res = mMediaPlayerInterface.ActiveMediaDeviceGet(deviceInfo);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(!strcmp(deviceInfo.deviceName, "USB"));
    GMPTEST_EXPECT(deviceInfo.deviceID == deviceID);
}

void MediaPlayerInterfaceTest::GetIndexingStateOfexisting()
{
    ENTRY_TEST

    tResult res = -1;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tIndexingState indexingState;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    res = mMediaPlayerInterface.GetIndexingState(OUT indexingState, IN deviceID);
    GMPTEST_EXPECT(res == 0);
    //GMPTEST_EXPECT(IDS_COMPLETE == indexingState); //TODO: indexing state is not COMPLETE in test database, indexed DB will cause other failures
}

void MediaPlayerInterfaceTest::GetIndexingStateOfAllDevices()
{
    ENTRY_TEST

    tResult res = -1;
    vector<tIndexingStateResult> indexingState;

    res = mMediaPlayerInterface.GetIndexingState(OUT indexingState);
    GMPTEST_EXPECT(res == 0);
}

void MediaPlayerInterfaceTest::CreateMediaPlayerFileList()
{
    ENTRY_TEST

    tResult res = -1;
    tListID fileListID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* create a file list from root directory */
    strncpy_r(OUT path, IN "/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT fileListID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(numberOfMediaObjects == 3);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 4);
}

void MediaPlayerInterfaceTest::CreateMediaPlayerFileList_SecondLevelDir()
{
    ENTRY_TEST

    tResult res = -1;
    tListID fileListID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB-4");
    GMPTEST_EXPECT(res == 0);

    /* create a file list from root directory (Negavtive Test Case)*/
    strncpy_r(OUT path, IN "/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT fileListID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(numberOfMediaObjects == 0);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 1);

    /* create a file list from invalid directory path (Negavtive Test Case)*/
    strncpy_r(OUT path, IN "/Test/Test2/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT fileListID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(numberOfMediaObjects == 0);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 0);

    /* create a file list from second level root directory (Positive Test Case)*/
    strncpy_r(OUT path, IN "/Test/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT fileListID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    GMPTEST_EXPECT(numberOfMediaObjects != 4);
    GMPTEST_EXPECT(numberOfMediaObjects == 5);
    GMPTEST_EXPECT(numberOfMediaObjects != 6);

    GMPTEST_EXPECT(numberOfPlayLists != 1);
    GMPTEST_EXPECT(numberOfPlayLists == 2);
    GMPTEST_EXPECT(numberOfPlayLists != 3);

    GMPTEST_EXPECT(numberOfFolders != 4);
    GMPTEST_EXPECT(numberOfFolders == 5);
    GMPTEST_EXPECT(numberOfFolders != 6);

    /* create a file list from valid directory path but with invalid deviceID (Negavtive Test Case)*/
    strncpy_r(OUT path, IN "/Test/", IN sizeof(path));
    deviceID = 10001;
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT fileListID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID);
    GMPTEST_EXPECT(res != 0);
    GMPTEST_EXPECT(numberOfMediaObjects == 0);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 0);
}

void MediaPlayerInterfaceTest::UCADynamicSort()
{
    ENTRY_TEST

    tResult res = -1;
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
    tDeviceInfo deviceInfo;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    vector<tFiles> mediaFileVector;
    tLanguageType eLanguages[5]={LNG_SWEDISH,LNG_NORWEGIAN,LNG_FINNISH,LNG_DANISH,LNG_NA_ENGLISH};

    //Initialization

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB-2");
    GMPTEST_EXPECT(res == 0);
    res = mMediaPlayerInterface.ActiveMediaDeviceSet(IN deviceID /*device ID for USB-2 at this time*/, true /*to make device active */);
    GMPTEST_EXPECT(res == 0);

    sleep(1);

    res = mMediaPlayerInterface.ActiveMediaDeviceGet(deviceInfo);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(!strcmp(deviceInfo.deviceName, "USB-2"));
    GMPTEST_EXPECT(deviceInfo.deviceID == deviceID);

    strncpy_r(OUT path, IN "/UCASort/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, 50);
    GMPTEST_EXPECT(res == 0);
    for(tUInt i=0;i<mediaFileVector.size();i++)
    {
        ETG_TRACE_USR1(("UCASupportforVW with sortlib File name :  %s",mediaFileVector[i].fileName));
    }

    tListSize listSize_newplayback = 0;
    tIndex index = 1; /*from the second song */
    tPlaytime offset = 0;
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize_newplayback, IN listID, IN index, IN offset);
    GMPTEST_EXPECT(res == 0);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    //switch on the UCA Sort feature
    LocalSPM::GetDataProvider().DBSortUseUCAOn = 1;
    for(int countInt=0;countInt<5;countInt++)
    {
        //setting the Language
        res = mMediaPlayerInterface.SetLanguage(eLanguages[countInt]);
        GMPTEST_EXPECT(res == 0);

        sleep(1);

        res = LocalSPM::GetPlayerManager().GetListID(listID);
        GMPTEST_EXPECT(res == 0);
        res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, 50);
        GMPTEST_EXPECT(res == 0);

        for(tUInt i=0;i<mediaFileVector.size();i++)
        {
            ETG_TRACE_USR1(("UCASupportforVW with UCA language:%d,File name :  %s",eLanguages[countInt],mediaFileVector[i].fileName));
        }
    }

    //switch off the UCA Sort feature
    LocalSPM::GetDataProvider().DBSortUseUCAOn = 0;
}

void MediaPlayerInterfaceTest::CreateQuickPlaylistLTY_FILELIST_playlist()
{
    ENTRY_TEST

    tResult res = -1;
    tListID fileListID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* set the path to create a folder view which includes a playlist*/
    strncpy_r(OUT path, IN "/music/Mando_Diao-Bring_Em_In-RETAIL-2002-EVIGHET/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT fileListID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID);
    /*check the created folder view is as expected*/
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(numberOfMediaObjects == 12);
    GMPTEST_EXPECT(numberOfPlayLists == 1);
    GMPTEST_EXPECT(numberOfFolders == 0);

    /* quickplay playlist 00-mando_diao-bring_em_in-retail-2002-evighet.m3u which is at index 0 of the FolderView created in the previous step */
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN fileListID, 0, 0);
    GMPTEST_EXPECT(res == 0);

    /*Verify if first track in the playlist is playing*/
    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    tNowPlaying nowPlaying;
    res = LocalSPM::GetPlayerManager().GetNowPlaying(nowPlaying);
    VARTRACE(nowPlaying);
    //nowPlaying.object.fileName,"/music/Mando_Diao-Bring_Em_In-RETAIL-2002-EVIGHET/01-sheepdog-evighet.mp3"
}

void MediaPlayerInterfaceTest::CreateQuickPlaylistLTY_FILELIST_folder()
{
    ENTRY_TEST

    tResult res = -1;
    tListSize listSize;
    tListID fileListID;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* create a file list from directory "music" */
    strncpy_r(OUT path, IN "/music/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT fileListID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID);
    /*check the created folder view is as expected*/
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(numberOfMediaObjects == 1);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 6);

    /* play folder Garbage which is at index 3 of the FolderView created in the previous step */
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN fileListID, 3, 0);
    GMPTEST_EXPECT(res == 0);

    /*Verify if first track in the Folder is playing*/
    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    tNowPlaying nowPlaying;
    res = LocalSPM::GetPlayerManager().GetNowPlaying(nowPlaying);
    VARTRACE(nowPlaying);
    //(nowPlaying.object.fileName,"/music/Garbage/Garbage-Garbage-01-Supervixen.mp3");
}

void MediaPlayerInterfaceTest::CreateMediaPlayerIndexedList_SONG()
{
    ENTRY_TEST

    tResult res = -1;
    tListID listID;
    tListSize listSize;
    tListType ListType = LTY_SONG;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID;

    /* set the filter tags */
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    // call create list
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            IN ListType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    // test result
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize > 0);

    vector<tMediaObject> mediaObjectVector;
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, listSize);
    // test result
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() == listSize);
}

void MediaPlayerInterfaceTest::PlayItemFromListDefaultOffset()
{
    ENTRY_TEST

    tResult res = -1;
    /* Check if listID is valid */
    GMPTEST_EXPECT(LIST_ID_NONE != mListID);

    /* Call PlayItemFromList */
    tListSize listSize = 0;
    tIndex index = 0;
    tPlaytime offset = 0;
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN mListID, IN index, IN offset);
    // test result
    GMPTEST_EXPECT(res == 0);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    // Call GetPlaybackState to check the current playback state of the MediaPlayer
    tHMIPlaybackState playstatus;
    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1((" PlayItemFromList::GetPlaybackState Action : %d ", playstatus));
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);

}

void MediaPlayerInterfaceTest::GetPlaybackState()
{
    ENTRY_TEST

    tResult res = -1;

    // Call GetPlaybackState to check the current playback state of the MediaPlayer
    tHMIPlaybackState playstatus;
    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("GetPlaybackState Action : %d ", playstatus));
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);
}

// Generic function defined to re-call PlayItemFromList from any function
void MediaPlayerInterfaceTest::PlayItemFromList(tListSize &listSize, tIndex index, tPlaytime offset)
{
    ENTRY_TEST

    tResult res = -1;

    /* Check if listID is valid */
    GMPTEST_EXPECT(LIST_ID_NONE != mListID);

    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN mListID, IN index, IN offset);
    // test result
    GMPTEST_EXPECT(res == 0);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    // Call GetPlaybackState to check the current playback state of the MediaPlayer
    tHMIPlaybackState playstatus;
    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1((" PlayItemFromList::GetPlaybackState Action : %d ", playstatus));
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);
}

void MediaPlayerInterfaceTest::SendPlaybackMode_VideoAudio()
{
    ENTRY_TEST

    tResult res = -1;
    tMediaContext oldMediaContext;
    LocalSPM::GetDBManager().GetMediaContext(OUT oldMediaContext);

    /*set media context to video and then set the playback mode*/
    LocalSPM::GetDBManager().SetMediaContext(IN MC_VIDEO);
    res = mMediaPlayerInterface.SendPlaybackMode(PBM_RANDOM);
    GMPTEST_EXPECT(res == 0);
    sleep(1);
    ETG_TRACE_USR1(("SendPlaybackMode_VideoAudio::SendPlaybackMode :setting playback mode for video to %d",PBM_RANDOM));

    /*set media context to audio and then set the playback mode*/
    LocalSPM::GetDBManager().SetMediaContext(IN MC_AUDIO);
    res = mMediaPlayerInterface.SendPlaybackMode(PBM_RANDOM);
    GMPTEST_EXPECT(res == 0);
    sleep(1);
    ETG_TRACE_USR1(("SendPlaybackMode_VideoAudio::SendPlaybackMode :setting playback mode for audio to %d",PBM_RANDOM));


    /*set media context to video and then check whether playback mode is PBM_RANDOM */
    LocalSPM::GetDBManager().SetMediaContext(IN MC_VIDEO);
    tPlaybackMode playbackMode;
    res = mMediaPlayerInterface.GetPlaybackMode(OUT playbackMode);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("SendPlaybackMode_VideoAudio::SendPlaybackMode : playback mode for video is %d",playbackMode));
    GMPTEST_EXPECT(playbackMode == PBM_RANDOM);

    /*set media context to audio and then check whether playback mode is PBM_RANDOM */
    LocalSPM::GetDBManager().SetMediaContext(IN MC_AUDIO);
    res = mMediaPlayerInterface.GetPlaybackMode(OUT playbackMode);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("SendPlaybackMode_VideoAudio::SendPlaybackMode : playback mode for audio is %d",playbackMode));
    GMPTEST_EXPECT(playbackMode == PBM_RANDOM);

    /*restore default playback mode for both video and audio*/
    tDeviceInfo deviceInfo;
    res = LocalSPM::GetCustomControl().ActiveMediaDeviceGet(OUT deviceInfo);
    res = LocalSPM::GetDBManager().ResetAllPlaybackModes(deviceInfo.deviceID);
    GMPTEST_EXPECT(res == 0);

    /*check whether playback mode for audio is restored properly*/
    res = mMediaPlayerInterface.GetPlaybackMode(OUT playbackMode);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(playbackMode == PBM_NORMAL);

    /*check whether playback mode for video is restored properly*/
    LocalSPM::GetDBManager().SetMediaContext(IN MC_VIDEO);
    res = mMediaPlayerInterface.GetPlaybackMode(OUT playbackMode);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(playbackMode == PBM_NORMAL);

    /*Restore old mediacontext*/
    if(MC_VIDEO != oldMediaContext)
        LocalSPM::GetDBManager().SetMediaContext(IN oldMediaContext);
}

void MediaPlayerInterfaceTest::SendPlaybackMode_Random()
{
    ENTRY_TEST

    tResult res = -1;
    res = mMediaPlayerInterface.SendPlaybackMode(PBM_RANDOM);
    GMPTEST_EXPECT(res == 0);

    sleep(1);

    tPlaybackMode playbackMode;
    res = mMediaPlayerInterface.GetPlaybackMode(OUT playbackMode);
    ETG_TRACE_USR1(("SendPlaybackMode_Random::GetPlaybackMode : %d ", playbackMode));
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(playbackMode == PBM_RANDOM);
}

void MediaPlayerInterfaceTest::SendPlaybackActionPause()
{
    ENTRY_TEST

    tResult res = -1;

    tNextPrevSkipCount steps = 1;
    res = mMediaPlayerInterface.SendPlaybackAction(PBA_PAUSE, IN steps);
    // test result
    GMPTEST_EXPECT(res == 0);

    sleep(1);

    // Call GetPlaybackState to check the current playback state of the MediaPlayer
    tHMIPlaybackState playstatus;
    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("SendPlaybackActionPause::GetPlaybackState Action : %d ", playstatus));
    GMPTEST_EXPECT(playstatus == HMI_PBS_PAUSED);
}
tResult MediaPlayerInterfaceTest::setplaybackspeedNormal()
{
    int res = -1;
    res =  mMediaPlayerInterface.SendPlaybackSpeed(PBK_FORWARD, PBK_SPEED_1X);
    return res;
}
void MediaPlayerInterfaceTest::SendPlaybackSpeedForward_with_0_2x()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start %s***", __PRETTY_FUNCTION__));

    ///////////////
    tResult res = -1;

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;

    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    GMPTEST_EXPECT(res == 0);

    ETG_TRACE_USR1(("elapsedPlaytime : %d, totalPlaytime : %d", elapsedPlaytime, totalPlaytime));

    /* Call sendplaybackspeed with 2X speed */
    //tPlaytime position = totalPlaytime -10000;
    res = mMediaPlayerInterface.SendPlaybackSpeed(PBK_FORWARD, PBK_SPEED_0_2X);
    GMPTEST_EXPECT(res == 0);
    tPlaytime sleeptime = 15;

    sleep(sleeptime);

    res = setplaybackspeedNormal();
    GMPTEST_EXPECT(res == 0);

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytimeSeeked;
    tPlaytime totalPlaytimeSeeked;
    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytimeSeeked, OUT totalPlaytimeSeeked, OUT objectID);
    GMPTEST_EXPECT(res == 0);


    ETG_TRACE_USR1(("  elapsedPlaytimeSeeked : %d, totalPlaytimeSeeked : %d", elapsedPlaytimeSeeked, totalPlaytimeSeeked));


    int diff = (int)elapsedPlaytimeSeeked - (int)elapsedPlaytime;
    tPlaytime balancetime = abs(diff);

    ETG_TRACE_USR1 (( " balancetime : %d", balancetime ));

    GMPTEST_EXPECT(((balancetime/1000) >= 2));

}
void MediaPlayerInterfaceTest::SendPlaybackSpeedForward_with_0_5x()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start %s***", __PRETTY_FUNCTION__));

    ///////////////
    tResult res = -1;

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;

    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    GMPTEST_EXPECT(res == 0);

    ETG_TRACE_USR1((" elapsedPlaytime : %d, totalPlaytime : %d", elapsedPlaytime, totalPlaytime));

    /* Call sendplaybackspeed with 2X speed */
    //tPlaytime position = totalPlaytime -10000;
    res = mMediaPlayerInterface.SendPlaybackSpeed(PBK_FORWARD, PBK_SPEED_0_5X);
    GMPTEST_EXPECT(res == 0);
    tPlaytime sleeptime = 15;

    sleep(sleeptime);

    res = setplaybackspeedNormal();
    GMPTEST_EXPECT(res == 0);

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytimeSeeked;
    tPlaytime totalPlaytimeSeeked;
    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytimeSeeked, OUT totalPlaytimeSeeked, OUT objectID);
    GMPTEST_EXPECT(res == 0);


    ETG_TRACE_USR1(("  elapsedPlaytimeSeeked : %d, totalPlaytimeSeeked : %d", elapsedPlaytimeSeeked, totalPlaytimeSeeked));


    int diff = (int)elapsedPlaytimeSeeked - (int)elapsedPlaytime;
    tPlaytime balancetime = abs(diff);

    ETG_TRACE_USR1 (( "  balancetime : %d", balancetime ));

    GMPTEST_EXPECT(((balancetime/1000) >= 5));

}
void MediaPlayerInterfaceTest::SendPlaybackSpeedForward_with_2x()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start %s***", __PRETTY_FUNCTION__));

    ///////////////
    tResult res = -1;

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;

    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    GMPTEST_EXPECT(res == 0);

    ETG_TRACE_USR1((" elapsedPlaytime : %d, totalPlaytime : %d", elapsedPlaytime, totalPlaytime));

    /* Call sendplaybackspeed with 2X speed */
    //tPlaytime position = totalPlaytime -10000;
    res = mMediaPlayerInterface.SendPlaybackSpeed(PBK_FORWARD, PBK_SPEED_2X);
    GMPTEST_EXPECT(res == 0);
    tPlaytime sleeptime = 6;

    sleep(sleeptime);

    res = setplaybackspeedNormal();
    GMPTEST_EXPECT(res == 0);

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytimeSeeked;
    tPlaytime totalPlaytimeSeeked;
    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytimeSeeked, OUT totalPlaytimeSeeked, OUT objectID);
    GMPTEST_EXPECT(res == 0);


    ETG_TRACE_USR1(("  elapsedPlaytimeSeeked : %d, totalPlaytimeSeeked : %d", elapsedPlaytimeSeeked, totalPlaytimeSeeked));


    int diff = (int)elapsedPlaytimeSeeked - (int)elapsedPlaytime;
    tPlaytime balancetime = abs(diff);

    ETG_TRACE_USR1 (( "  balancetime : %d", balancetime ));

    GMPTEST_EXPECT(((balancetime/1000) >= 10));


}
void MediaPlayerInterfaceTest::SendPlaybackSpeedForward_with_4x()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start %s***", __PRETTY_FUNCTION__));

    ///////////////
    tResult res = -1;

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;

    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    GMPTEST_EXPECT(res == 0);

    ETG_TRACE_USR1((" elapsedPlaytime : %d, totalPlaytime : %d", elapsedPlaytime, totalPlaytime));

    /* Call sendplaybackspeed with 2X speed */
    //tPlaytime position = totalPlaytime -10000;
    res = mMediaPlayerInterface.SendPlaybackSpeed(PBK_FORWARD, PBK_SPEED_4X);
    GMPTEST_EXPECT(res == 0);
    tPlaytime sleeptime = 4;

    sleep(sleeptime);

    res = setplaybackspeedNormal();
    GMPTEST_EXPECT(res == 0);

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytimeSeeked;
    tPlaytime totalPlaytimeSeeked;
    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytimeSeeked, OUT totalPlaytimeSeeked, OUT objectID);
    GMPTEST_EXPECT(res == 0);


    ETG_TRACE_USR1((" elapsedPlaytimeSeeked : %d, totalPlaytimeSeeked : %d", elapsedPlaytimeSeeked, totalPlaytimeSeeked));


    int diff = (int)elapsedPlaytimeSeeked - (int)elapsedPlaytime;
    tPlaytime balancetime = abs(diff);

    ETG_TRACE_USR1 (( "  balancetime : %d", balancetime ));

    GMPTEST_EXPECT(((balancetime/1000) >= 12));

}
void MediaPlayerInterfaceTest::SendPlaybackSpeedForward_with_8x()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start %s***", __PRETTY_FUNCTION__));

    ///////////////
    tResult res = -1;

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;

    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    GMPTEST_EXPECT(res == 0);

    ETG_TRACE_USR1((" elapsedPlaytime : %d, totalPlaytime : %d", elapsedPlaytime, totalPlaytime));

    /* Call sendplaybackspeed with 2X speed */
    //tPlaytime position = totalPlaytime -10000;
    res = mMediaPlayerInterface.SendPlaybackSpeed(PBK_FORWARD, PBK_SPEED_8X);
    GMPTEST_EXPECT(res == 0);
    tPlaytime sleeptime = 3;

    sleep(sleeptime);

    res = setplaybackspeedNormal();
    GMPTEST_EXPECT(res == 0);

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytimeSeeked;
    tPlaytime totalPlaytimeSeeked;
    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytimeSeeked, OUT totalPlaytimeSeeked, OUT objectID);
    GMPTEST_EXPECT(res == 0);


    ETG_TRACE_USR1(("  elapsedPlaytimeSeeked : %d, totalPlaytimeSeeked : %d", elapsedPlaytimeSeeked, totalPlaytimeSeeked));


    int diff = (int)elapsedPlaytimeSeeked - (int)elapsedPlaytime;
    tPlaytime balancetime = abs(diff);

    ETG_TRACE_USR1 (( "  balancetime : %d", balancetime ));

    GMPTEST_EXPECT(((balancetime/1000) >= 20));

}
void MediaPlayerInterfaceTest::SendPlaybackSpeedForward_with_16x()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start %s***", __PRETTY_FUNCTION__));

    ///////////////
    tResult res = -1;

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;

    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    GMPTEST_EXPECT(res == 0);

    ETG_TRACE_USR1((" elapsedPlaytime : %d, totalPlaytime : %d", elapsedPlaytime, totalPlaytime));

    /* Call sendplaybackspeed with 2X speed */
    //tPlaytime position = totalPlaytime -10000;
    res = mMediaPlayerInterface.SendPlaybackSpeed(PBK_FORWARD, PBK_SPEED_16X);
    GMPTEST_EXPECT(res == 0);
    tPlaytime sleeptime = 3;

    sleep(sleeptime);

    res = setplaybackspeedNormal();
    GMPTEST_EXPECT(res == 0);

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytimeSeeked;
    tPlaytime totalPlaytimeSeeked;
    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytimeSeeked, OUT totalPlaytimeSeeked, OUT objectID);
    GMPTEST_EXPECT(res == 0);


    ETG_TRACE_USR1(("  elapsedPlaytimeSeeked : %d, totalPlaytimeSeeked : %d", elapsedPlaytimeSeeked, totalPlaytimeSeeked));


    int diff = (int)elapsedPlaytimeSeeked - (int)elapsedPlaytime;
    tPlaytime balancetime = abs(diff);

    ETG_TRACE_USR1 (( "  balancetime : %d", balancetime ));

    GMPTEST_EXPECT(((balancetime/1000) >= 40));

}
void MediaPlayerInterfaceTest::SendPlaybackSpeedForward_with_32x()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start %s***", __PRETTY_FUNCTION__));

    ///////////////
    tResult res = -1;

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;

    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    GMPTEST_EXPECT(res == 0);

    ETG_TRACE_USR1((" elapsedPlaytime : %d, totalPlaytime : %d", elapsedPlaytime, totalPlaytime));

    /* Call sendplaybackspeed with 2X speed */
    //tPlaytime position = totalPlaytime -10000;
    res = mMediaPlayerInterface.SendPlaybackSpeed(PBK_FORWARD, PBK_SPEED_32X);
    GMPTEST_EXPECT(res == 0);
    tPlaytime sleeptime = 3;

    sleep(sleeptime);

    res = setplaybackspeedNormal();
    CPPUNIT_ASSERT(res == 0);

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytimeSeeked;
    tPlaytime totalPlaytimeSeeked;
    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytimeSeeked, OUT totalPlaytimeSeeked, OUT objectID);
    GMPTEST_EXPECT(res == 0);


    ETG_TRACE_USR1(("  elapsedPlaytimeSeeked : %d, totalPlaytimeSeeked : %d", elapsedPlaytimeSeeked, totalPlaytimeSeeked));


    int diff = (int)elapsedPlaytimeSeeked - (int)elapsedPlaytime;
    tPlaytime balancetime = abs(diff);

    ETG_TRACE_USR1 (( "  balancetime : %d", balancetime ));

    GMPTEST_EXPECT(((balancetime/1000) >= 90));

}
void MediaPlayerInterfaceTest::SendPlaybackSpeedRewind_with_0_2x()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start %s***", __PRETTY_FUNCTION__));

    ///////////////
    tResult res = -1;

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;

    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    GMPTEST_EXPECT(res == 0);

    ETG_TRACE_USR1((" elapsedPlaytime : %d, totalPlaytime : %d", elapsedPlaytime, totalPlaytime));

    SendSeekTo_Absoulte_Playing();

    sleep(2);
    /* Call sendplaybackspeed with 2X speed */
    //tPlaytime position = totalPlaytime -10000;
    res = mMediaPlayerInterface.SendPlaybackSpeed(PBK_BACKWARD, PBK_SPEED_0_2X);
    GMPTEST_EXPECT(res == 0);
    tPlaytime sleeptime = 15;

    sleep(sleeptime);

    res = setplaybackspeedNormal();
    GMPTEST_EXPECT(res == 0);

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytimeSeeked;
    tPlaytime totalPlaytimeSeeked;
    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytimeSeeked, OUT totalPlaytimeSeeked, OUT objectID);
    GMPTEST_EXPECT(res == 0);


    ETG_TRACE_USR1(("  elapsedPlaytimeSeeked : %d, totalPlaytimeSeeked : %d", elapsedPlaytimeSeeked, totalPlaytimeSeeked));


    int diff = (int)elapsedPlaytime - (int)elapsedPlaytimeSeeked;
    tPlaytime balancetime = abs(diff);

    ETG_TRACE_USR1 (( "  balancetime : %d", balancetime ));

    GMPTEST_EXPECT(((balancetime/1000) >= 2));

}
void MediaPlayerInterfaceTest::SendPlaybackSpeedRewind_with_0_5x()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start %s***", __PRETTY_FUNCTION__));

    ///////////////
    tResult res = -1;

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;

    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    GMPTEST_EXPECT(res == 0);

    ETG_TRACE_USR1((" elapsedPlaytime : %d, totalPlaytime : %d", elapsedPlaytime, totalPlaytime));

    SendSeekTo_Absoulte_Playing();

    sleep(2);
    /* Call sendplaybackspeed with 5X speed */
    res = mMediaPlayerInterface.SendPlaybackSpeed(PBK_BACKWARD, PBK_SPEED_0_5X);
    GMPTEST_EXPECT(res == 0);
    tPlaytime sleeptime = 15;

    sleep(sleeptime);

    res = setplaybackspeedNormal();
    GMPTEST_EXPECT(res == 0);

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytimeSeeked;
    tPlaytime totalPlaytimeSeeked;
    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytimeSeeked, OUT totalPlaytimeSeeked, OUT objectID);
    GMPTEST_EXPECT(res == 0);


    ETG_TRACE_USR1(("  elapsedPlaytimeSeeked : %d, totalPlaytimeSeeked : %d", elapsedPlaytimeSeeked, totalPlaytimeSeeked));


    int diff = (int)elapsedPlaytime - (int)elapsedPlaytimeSeeked;
    tPlaytime balancetime = abs(diff);

    ETG_TRACE_USR1 (( "  balancetime : %d", balancetime ));

    GMPTEST_EXPECT(((balancetime/1000) >= 5));

}
void MediaPlayerInterfaceTest::SendPlaybackSpeedRewind_with_2x()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start %s***", __PRETTY_FUNCTION__));

    ///////////////
    tResult res = -1;

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;

    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    GMPTEST_EXPECT(res == 0);

    ETG_TRACE_USR1((" elapsedPlaytime : %d, totalPlaytime : %d", elapsedPlaytime, totalPlaytime));

    SendSeekTo_Absoulte_Playing();

    sleep(2);
    /* Call sendplaybackspeed with 2X speed */
    //tPlaytime position = totalPlaytime -10000;
    res = mMediaPlayerInterface.SendPlaybackSpeed(PBK_BACKWARD, PBK_SPEED_2X);
    GMPTEST_EXPECT(res == 0);
    tPlaytime sleeptime = 6;

    sleep(sleeptime);

    res = setplaybackspeedNormal();
    GMPTEST_EXPECT(res == 0);

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytimeSeeked;
    tPlaytime totalPlaytimeSeeked;
    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytimeSeeked, OUT totalPlaytimeSeeked, OUT objectID);
    GMPTEST_EXPECT(res == 0);


    ETG_TRACE_USR1(("  elapsedPlaytimeSeeked : %d, totalPlaytimeSeeked : %d", elapsedPlaytimeSeeked, totalPlaytimeSeeked));


    int diff = (int)elapsedPlaytime - (int)elapsedPlaytimeSeeked;
    tPlaytime balancetime = abs(diff);

    ETG_TRACE_USR1 (( "   balancetime : %d", balancetime ));

    GMPTEST_EXPECT(((balancetime/1000) >= 10));
}
void MediaPlayerInterfaceTest::SendPlaybackSpeedRewind_with_4x()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start %s***", __PRETTY_FUNCTION__));

    ///////////////
    tResult res = -1;

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;

    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    GMPTEST_EXPECT(res == 0);

    ETG_TRACE_USR1(("  elapsedPlaytime : %d, totalPlaytime : %d", elapsedPlaytime, totalPlaytime));

    SendSeekTo_Absoulte_Playing();

    sleep(2);
    /* Call sendplaybackspeed with 2X speed */
    //tPlaytime position = totalPlaytime -10000;
    res = mMediaPlayerInterface.SendPlaybackSpeed(PBK_BACKWARD, PBK_SPEED_4X);
    GMPTEST_EXPECT(res == 0);
    tPlaytime sleeptime = 3;

    sleep(sleeptime);

    res = setplaybackspeedNormal();
    GMPTEST_EXPECT(res == 0);

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytimeSeeked;
    tPlaytime totalPlaytimeSeeked;
    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytimeSeeked, OUT totalPlaytimeSeeked, OUT objectID);
    GMPTEST_EXPECT(res == 0);


    ETG_TRACE_USR1(("   elapsedPlaytimeSeeked : %d, totalPlaytimeSeeked : %d", elapsedPlaytimeSeeked, totalPlaytimeSeeked));


    int diff = (int)elapsedPlaytime - (int)elapsedPlaytimeSeeked;
    tPlaytime balancetime = abs(diff);

    ETG_TRACE_USR1 (( "   balancetime : %d", balancetime ));

    GMPTEST_EXPECT(((balancetime/1000) >= 10));
}
void MediaPlayerInterfaceTest::SendPlaybackSpeedRewind_with_8x()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start %s***", __PRETTY_FUNCTION__));

    ///////////////
    tResult res = -1;

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;

    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    GMPTEST_EXPECT(res == 0);

    ETG_TRACE_USR1(("  elapsedPlaytime : %d, totalPlaytime : %d", elapsedPlaytime, totalPlaytime));

    SendSeekTo_Absoulte_Playing();

    sleep(2);
    /* Call sendplaybackspeed with 2X speed */
    //tPlaytime position = totalPlaytime -10000;
    res = mMediaPlayerInterface.SendPlaybackSpeed(PBK_BACKWARD, PBK_SPEED_8X);
    GMPTEST_EXPECT(res == 0);
    tPlaytime sleeptime = 3;

    sleep(sleeptime);

    res = setplaybackspeedNormal();
    GMPTEST_EXPECT(res == 0);

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytimeSeeked;
    tPlaytime totalPlaytimeSeeked;
    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytimeSeeked, OUT totalPlaytimeSeeked, OUT objectID);
    GMPTEST_EXPECT(res == 0);


    ETG_TRACE_USR1(("   elapsedPlaytimeSeeked : %d, totalPlaytimeSeeked : %d", elapsedPlaytimeSeeked, totalPlaytimeSeeked));


    int diff = (int)elapsedPlaytime - (int)elapsedPlaytimeSeeked;
    tPlaytime balancetime = abs(diff);

    ETG_TRACE_USR1 (( "   balancetime : %d", balancetime ));

    GMPTEST_EXPECT(((balancetime/1000) >= 20));
}
void MediaPlayerInterfaceTest::SendPlaybackSpeedRewind_with_16x()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start %s***", __PRETTY_FUNCTION__));

    ///////////////
    tResult res = -1;

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;

    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    GMPTEST_EXPECT(res == 0);

    ETG_TRACE_USR1(("  elapsedPlaytime : %d, totalPlaytime : %d", elapsedPlaytime, totalPlaytime));

    SendSeekTo_Absoulte_Playing();

    sleep(2);
    /* Call sendplaybackspeed with 2X speed */
    //tPlaytime position = totalPlaytime -10000;
    res = mMediaPlayerInterface.SendPlaybackSpeed(PBK_BACKWARD, PBK_SPEED_16X);
    GMPTEST_EXPECT(res == 0);
    tPlaytime sleeptime = 3;

    sleep(sleeptime);

    res = setplaybackspeedNormal();
    GMPTEST_EXPECT(res == 0);

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytimeSeeked;
    tPlaytime totalPlaytimeSeeked;
    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytimeSeeked, OUT totalPlaytimeSeeked, OUT objectID);
    GMPTEST_EXPECT(res == 0);


    ETG_TRACE_USR1(("   elapsedPlaytimeSeeked : %d, totalPlaytimeSeeked : %d", elapsedPlaytimeSeeked, totalPlaytimeSeeked));


    int diff = (int)elapsedPlaytime - (int)elapsedPlaytimeSeeked;
    tPlaytime balancetime = abs(diff);

    ETG_TRACE_USR1 (( "   balancetime : %d", balancetime ));

    GMPTEST_EXPECT(((balancetime/1000) >= 40));
}
void MediaPlayerInterfaceTest::SendPlaybackSpeedRewind_with_32x()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start %s***", __PRETTY_FUNCTION__));

    ///////////////
    tResult res = -1;

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;

    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    GMPTEST_EXPECT(res == 0);

    ETG_TRACE_USR1(("  elapsedPlaytime : %d, totalPlaytime : %d", elapsedPlaytime, totalPlaytime));

    SendSeekTo_Absoulte_Playing();

    sleep(2);
    /* Call sendplaybackspeed with 2X speed */
    //tPlaytime position = totalPlaytime -10000;
    res = mMediaPlayerInterface.SendPlaybackSpeed(PBK_BACKWARD, PBK_SPEED_32X);
    GMPTEST_EXPECT(res == 0);
    tPlaytime sleeptime = 3;

    sleep(sleeptime);

    res = setplaybackspeedNormal();
    GMPTEST_EXPECT(res == 0);

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytimeSeeked;
    tPlaytime totalPlaytimeSeeked;
    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytimeSeeked, OUT totalPlaytimeSeeked, OUT objectID);
    GMPTEST_EXPECT(res == 0);


    ETG_TRACE_USR1(("   elapsedPlaytimeSeeked : %d, totalPlaytimeSeeked : %d", elapsedPlaytimeSeeked, totalPlaytimeSeeked));


    int diff = (int)elapsedPlaytime - (int)elapsedPlaytimeSeeked;
    tPlaytime balancetime = abs(diff);

    ETG_TRACE_USR1 (( "   balancetime : %d", balancetime ));

    GMPTEST_EXPECT(((balancetime/1000) >= 90));
}
void MediaPlayerInterfaceTest::SendPlaybackSpeedForward_with_realative_Increase()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start %s***", __PRETTY_FUNCTION__));

    ///////////////
    tResult res = -1;

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;

    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    GMPTEST_EXPECT(res == 0);

    ETG_TRACE_USR1(("  elapsedPlaytime : %d, totalPlaytime : %d", elapsedPlaytime, totalPlaytime));

    /* Call sendplaybackspeed with 2X speed */
    //tPlaytime position = totalPlaytime -10000;
    res = mMediaPlayerInterface.SendPlaybackSpeed(PBK_FORWARD, PBK_SPEED_2X);
    GMPTEST_EXPECT(res == 0);
    sleep(6);

    tPlaytime elapsedPlaytime2;
    tPlaytime totalPlaytime2;
    tObjectID objectID2 = OBJECT_ID_NONE;

    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime2, OUT totalPlaytime2, OUT objectID2);
    GMPTEST_EXPECT(res == 0);

    ETG_TRACE_USR1(("  elapsedPlaytime2 : %d, totalPlaytime2 : %d", elapsedPlaytime2, totalPlaytime2));
    int dif_2x = (int)elapsedPlaytime2 - (int)elapsedPlaytime;
    tPlaytime baltime_2x = abs(dif_2x);
    GMPTEST_EXPECT(((baltime_2x/1000) >= 10));

    res = mMediaPlayerInterface.SendPlaybackSpeed(PBK_FORWARD, PBK_SPEED_INCREASE);
    GMPTEST_EXPECT(res == 0);
    tPlaytime sleeptime = 3;
    sleep(sleeptime);

    res = setplaybackspeedNormal();
    GMPTEST_EXPECT(res == 0);

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytimeSeeked;
    tPlaytime totalPlaytimeSeeked;
    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytimeSeeked, OUT totalPlaytimeSeeked, OUT objectID);
    GMPTEST_EXPECT(res == 0);


    ETG_TRACE_USR1(("   elapsedPlaytimeSeeked : %d, totalPlaytimeSeeked : %d", elapsedPlaytimeSeeked, totalPlaytimeSeeked));


    int diff = (int)elapsedPlaytimeSeeked - (int)elapsedPlaytime;
    tPlaytime balancetime = abs(diff);

    ETG_TRACE_USR1 (( "   balancetime : %d", balancetime ));

    GMPTEST_EXPECT(((balancetime/1000) >= 21));


}
void MediaPlayerInterfaceTest::SendPlaybackSpeedForward_with_realative_Decrease()
{

    ENTRY
    ETG_TRACE_USR1(("          ***Start %s***", __PRETTY_FUNCTION__));

    ///////////////
    tResult res = -1;

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;

    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    GMPTEST_EXPECT(res == 0);

    ETG_TRACE_USR1(("  elapsedPlaytime : %d, totalPlaytime : %d", elapsedPlaytime, totalPlaytime));

    /* Call sendplaybackspeed with 2X speed */
    //tPlaytime position = totalPlaytime -10000;
    res = mMediaPlayerInterface.SendPlaybackSpeed(PBK_FORWARD, PBK_SPEED_4X);
    GMPTEST_EXPECT(res == 0);
    sleep(3);

    tPlaytime elapsedPlaytime4;
    tPlaytime totalPlaytime4;
    tObjectID objectID4 = OBJECT_ID_NONE;

    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime4, OUT totalPlaytime4, OUT objectID4);
    GMPTEST_EXPECT(res == 0);

    ETG_TRACE_USR1(("  elapsedPlaytime4 : %d, totalPlaytime4 : %d", elapsedPlaytime4, totalPlaytime4));
    int dif_4x = (int)elapsedPlaytime4 - (int)elapsedPlaytime;
    tPlaytime baltime_4x = abs(dif_4x);
    GMPTEST_EXPECT(((baltime_4x/1000) >= 10));

    res = mMediaPlayerInterface.SendPlaybackSpeed(PBK_FORWARD, PBK_SPEED_DECREASE);
    GMPTEST_EXPECT(res == 0);
    tPlaytime sleeptime = 3;
    sleep(sleeptime);

    res = setplaybackspeedNormal();
    GMPTEST_EXPECT(res == 0);

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytimeSeeked;
    tPlaytime totalPlaytimeSeeked;
    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytimeSeeked, OUT totalPlaytimeSeeked, OUT objectID);
    GMPTEST_EXPECT(res == 0);


    ETG_TRACE_USR1(("   elapsedPlaytimeSeeked : %d, totalPlaytimeSeeked : %d", elapsedPlaytimeSeeked, totalPlaytimeSeeked));


    int diff = (int)elapsedPlaytimeSeeked - (int)elapsedPlaytime;
    tPlaytime balancetime = abs(diff);

    ETG_TRACE_USR1 (( "   balancetime : %d", balancetime ));

    GMPTEST_EXPECT(((balancetime/1000) >= 16));

}

void MediaPlayerInterfaceTest::SendSeekTo_Absoulte_Pause()
{
    ENTRY_TEST

    tResult res = -1;

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;

    tNowPlaying nowPlaying;
    mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(nowPlaying.objectID == objectID);

    ETG_TRACE_USR1(("elapsedPlaytime : %d, totalPlaytime : %d", elapsedPlaytime, totalPlaytime));

    /* Call SendSeekTo */
    tPlaytime position = totalPlaytime -10000;
    res = mMediaPlayerInterface.SendSeekTo(IN position, PPF_ABSOLUTE);
    GMPTEST_EXPECT(res == 0);
    tPlaytime sleeptime = 6;

    sleep(sleeptime);

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytimeSeeked;
    tPlaytime totalPlaytimeSeeked;
    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytimeSeeked, OUT totalPlaytimeSeeked, OUT objectID);
    GMPTEST_EXPECT(res == 0);


    ETG_TRACE_USR1(("elapsedPlaytimeSeeked : %d, totalPlaytimeSeeked : %d", elapsedPlaytimeSeeked, totalPlaytimeSeeked));

    position = position + (sleeptime * 1000);

    int diff = (int)position - (int)elapsedPlaytimeSeeked;
    tPlaytime balancetime = abs(diff);

    ETG_TRACE_USR1 (( "balancetime : %d", balancetime ));

    GMPTEST_EXPECT(((balancetime/1000) <= 8));
}

void MediaPlayerInterfaceTest::SendSeekTo_Percentage_Pause()
{
    ENTRY_TEST

    tResult res = -1;

    /* Call SendSeekTo */
    tPlaytime position = 50;
    res = mMediaPlayerInterface.SendSeekTo(IN position, PPF_PERCENTAGE);
    GMPTEST_EXPECT(res == 0);
}

void MediaPlayerInterfaceTest::SendPlaybackActionPlay()
{
    ENTRY_TEST

    tResult res = -1;

    tNextPrevSkipCount steps = 1;
    res = mMediaPlayerInterface.SendPlaybackAction(PBA_PLAY, IN steps);
    // test result
    GMPTEST_EXPECT(res == 0);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    // Call GetPlaybackState to check the current playback state of the MediaPlayer
    tHMIPlaybackState playstatus;
    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("SendPlaybackActionPause::GetPlaybackState Action : %d ", playstatus));
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);
}

void MediaPlayerInterfaceTest::GetNowPlaying()
{
    ENTRY_TEST

    tResult res = -1;

    // call GetNowPlaying to get the info about the current playing song
    tNowPlaying nowPlaying;
    res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1 (( "Current Song objectID : %d fileName : %s", nowPlaying.object.objectID, nowPlaying.object.fileName));
}

void MediaPlayerInterfaceTest::GetPlaytime()
{
    ENTRY_TEST

    tResult res = -1;
    tPlaytime elapsedPlaytime = 0;
    tPlaytime totalPlaytime = 0;
    tObjectID objectID = OBJECT_ID_NONE;
    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    GMPTEST_EXPECT(res == 0 && elapsedPlaytime > 0 && totalPlaytime > 0);
}

void MediaPlayerInterfaceTest::SendSeekTo_Absoulte_Playing()
{
    ENTRY_TEST

    tResult res = -1;

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    // Call GetPlaytime to check the current elapsed playtime and the total playtime of the song
    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;
    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(totalPlaytime > 10000);

    ETG_TRACE_USR1(("elapsedPlaytime : %d, totalPlaytime : %d", elapsedPlaytime, totalPlaytime));

    /* Call SendSeekTo */
    tPlaytime position = totalPlaytime-10000;
    res = mMediaPlayerInterface.SendSeekTo(IN position, PPF_ABSOLUTE);
    GMPTEST_EXPECT(res == 0);
    tPlaytime sleeptime = 6;

    sleep(sleeptime);

    // Call GetPlaytime to check the current elapsed playtime and the total playtime of the song
    tPlaytime elapsedPlaytimeSeeked;
    tPlaytime totalPlaytimeSeeked;
    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytimeSeeked, OUT totalPlaytimeSeeked, OUT objectID);
    GMPTEST_EXPECT(res == 0);

    position = position + (sleeptime * 1000);

    int diff = (int)position - (int)elapsedPlaytimeSeeked;
    tPlaytime balancetime = abs(diff);

    ETG_TRACE_USR1(("elapsedPlaytimeSeeked : %d, totalPlaytimeSeeked : %d", elapsedPlaytimeSeeked, totalPlaytimeSeeked));
    ETG_TRACE_USR1(("position : %d, sleeptime : %d", position, sleeptime));

    ETG_TRACE_USR1 (( "balancetime : %d", balancetime ));
    GMPTEST_EXPECT(((balancetime/1000) <= 2));
}

void MediaPlayerInterfaceTest::SendPlaybackMode_Normal()
{
    ENTRY_TEST

    tResult res = -1;
    res = mMediaPlayerInterface.SendPlaybackMode(PBM_NORMAL);
    GMPTEST_EXPECT(res == 0);

    sleep(1);

    tPlaybackMode playbackMode;
    res = mMediaPlayerInterface.GetPlaybackMode(OUT playbackMode);
    ETG_TRACE_USR1(("SendPlaybackMode_Normal::GetPlaybackMode : %d ", playbackMode));
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(playbackMode == PBM_NORMAL);
}

void MediaPlayerInterfaceTest::GetPlaybackMode()
{
    ENTRY_TEST

    //tResult res = -1;
    tPlaybackMode playbackMode;
    /*res = */mMediaPlayerInterface.GetPlaybackMode(OUT playbackMode);

    ETG_TRACE_USR1(("PlayBack Mode : %d", playbackMode));
}

void MediaPlayerInterfaceTest::SendPlaybackActionNext()
{
    ENTRY_TEST

    tResult res = -1;

    // call GetNowPlaying to get the info about the current playing song
    tNowPlaying nowPlaying;
    res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
    ETG_TRACE_USR1 (( "Current Song objectID : %d fileName : %s", nowPlaying.object.objectID, nowPlaying.object.fileName));

    tNextPrevSkipCount steps = 1;
    res = mMediaPlayerInterface.SendPlaybackAction(PBA_NEXT, IN steps);
    // test result
    GMPTEST_EXPECT(res == 0);

    tUInt sleepTime = (LocalSPM::GetDataProvider().MultipleNextWaitTime()/1000) + 1;
    sleep(sleepTime);

    // call GetNowPlaying to get the info about the current playing song
    tNowPlaying nowPlaying_next;
    res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying_next);
    ETG_TRACE_USR1 (( "Next Song Filename : %64s : %d " , nowPlaying_next.object.fileName, nowPlaying_next.object.objectID));

    // Call GetPlaybackState to check the current playback state of the MediaPlayer
    tHMIPlaybackState playstatus;
    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("SendPlaybackActionNext::GetPlaybackState : %d ", playstatus));
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);
}

void MediaPlayerInterfaceTest::SendRepeatMode_VideoAudio()
{
    ENTRY_TEST

    tResult res = -1;
    tMediaContext oldMediaContext;
    LocalSPM::GetDBManager().GetMediaContext(OUT oldMediaContext);

    /*set media context to video and then set the repeatmode*/
    LocalSPM::GetDBManager().SetMediaContext(IN MC_VIDEO);
    res = mMediaPlayerInterface.SendRepeatMode(RPT_ONE);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("SendRepeatMode_VideoAudio::SendRepeatMode :setting repeat mode for video to %d",RPT_ONE));
    sleep(1);

    /*set media context to audio and then set the repeatmode*/
    LocalSPM::GetDBManager().SetMediaContext(IN MC_AUDIO);
    res = mMediaPlayerInterface.SendRepeatMode(RPT_ALL);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("SendRepeatMode_VideoAudio::SendRepeatMode :setting repeat mode for audio to %d",RPT_ALL));
    sleep(1);

    /*set media context to video and then check whether repeat mode is RPT_ONE */
    tRepeatMode repeatMode;
    LocalSPM::GetDBManager().SetMediaContext(IN MC_VIDEO);
    res = mMediaPlayerInterface.GetRepeatMode(OUT repeatMode);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("SendRepeatMode_VideoAudio::SendRepeatMode : repeat mode for video is %d",repeatMode));
    GMPTEST_EXPECT(repeatMode == RPT_ONE);
    /*restore default repeat mode for video*/
    res = mMediaPlayerInterface.SendRepeatMode((tRepeatMode)LocalSPM::GetDataProvider().DBDefaultVideoRepeatMode());
    GMPTEST_EXPECT(res == 0);
    sleep(1);

    /*set media context to audio and then check whether repeat mode is RPT_ALL */
    LocalSPM::GetDBManager().SetMediaContext(IN MC_AUDIO);
    res = mMediaPlayerInterface.GetRepeatMode(OUT repeatMode);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("SendRepeatMode_VideoAudio::SendRepeatMode : repeat mode for audio is %d",repeatMode));
    GMPTEST_EXPECT(repeatMode == RPT_ALL);

    /*restore default repeat mode for both video and audio*/
    tDeviceInfo deviceInfo;
    res = LocalSPM::GetCustomControl().ActiveMediaDeviceGet(OUT deviceInfo);
    res = LocalSPM::GetDBManager().ResetAllRepeatModes(deviceInfo.deviceID);
    GMPTEST_EXPECT(res == 0);
    sleep(1);
    /*check whether repeat mode for audio is restored properly*/
    res = mMediaPlayerInterface.GetRepeatMode(OUT repeatMode);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(repeatMode == (tRepeatMode)LocalSPM::GetDataProvider().DBDefaultRepeatMode());

    /*check whether repeat mode for video is restored properly*/
    LocalSPM::GetDBManager().SetMediaContext(IN MC_VIDEO);
    res = mMediaPlayerInterface.GetRepeatMode(OUT repeatMode);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(repeatMode == (tRepeatMode)LocalSPM::GetDataProvider().DBDefaultVideoRepeatMode());

    /*Restore old mediacontext*/
    if(MC_VIDEO != oldMediaContext)
        LocalSPM::GetDBManager().SetMediaContext(IN oldMediaContext);
}

void MediaPlayerInterfaceTest::SendRepeatMode_RepeatOne()
{
    ENTRY_TEST

    tResult res = -1;
    res = mMediaPlayerInterface.SendRepeatMode(RPT_ONE);
    GMPTEST_EXPECT(res == 0);

    sleep(1);

    tRepeatMode repeatMode;
    res = mMediaPlayerInterface.GetRepeatMode(OUT repeatMode);
    ETG_TRACE_USR1(("SendRepeatMode_RepeatOne::GetRepeatMode : %d ", repeatMode));
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(repeatMode == RPT_ONE);
}

void MediaPlayerInterfaceTest::GetRepeatMode()
{
    ENTRY_TEST

    tResult res = -1;
    tRepeatMode repeatMode;
    res = mMediaPlayerInterface.GetRepeatMode(OUT repeatMode);
    ETG_TRACE_USR1(("GetRepeatMode : %d", repeatMode));
    GMPTEST_EXPECT(res == 0);
}


void MediaPlayerInterfaceTest::SendSeekTo_Percentage_Playing()
{
    ENTRY_TEST

    tResult res = -1;

    /* Call SendSeekTo */
    tPlaytime position = 50;
    res = mMediaPlayerInterface.SendSeekTo(IN position, PPF_PERCENTAGE);
    GMPTEST_EXPECT(res == 0);
}

void MediaPlayerInterfaceTest::SendPlaybackActionPrev()
{
    ENTRY_TEST

    tResult res = -1;

    // call GetNowPlaying to get the info about the current playing song
    tNowPlaying nowPlaying;
    res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
    ETG_TRACE_USR1 (( "Current Song Filename : %64s : %d " , nowPlaying.object.fileName, nowPlaying.object.objectID));

    tNextPrevSkipCount steps = 1;
    res = mMediaPlayerInterface.SendPlaybackAction(PBA_PREV, IN steps);
    // test result
    GMPTEST_EXPECT(res == 0);

    tUInt sleepTime = (LocalSPM::GetDataProvider().MultipleNextWaitTime()/1000) + 1;
    sleep(sleepTime);

    // call GetNowPlaying to get the info about the current playing song
    tNowPlaying nowPlayingPrev;
    res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlayingPrev);
    ETG_TRACE_USR1 (( "Prev Song Filename : %64s : %d " , nowPlayingPrev.object.fileName, nowPlayingPrev.object.objectID));

    // Call GetPlaybackState to check the current playback state of the MediaPlayer
    tHMIPlaybackState playstatus;
    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("SendPlaybackActionPrev::GetPlaybackState Action : %d ", playstatus));
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);
}

void MediaPlayerInterfaceTest::SendPlaybackActionStop()
{
    ENTRY_TEST

    tResult res = -1;

    tNextPrevSkipCount steps = 1;
    res = mMediaPlayerInterface.SendPlaybackAction(PBA_STOP, IN steps);
    // test result
    GMPTEST_EXPECT(res == 0);

    sleep(2);

    // Call GetPlaybackState to check the current playback state of the MediaPlayer
    tHMIPlaybackState playstatus;
    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("SendPlaybackActionStop::GetPlaybackState Action : %d ", playstatus));
    GMPTEST_EXPECT(playstatus == HMI_PBS_PAUSED);
}

void MediaPlayerInterfaceTest::SendRepeatMode_Normal()
{
    ENTRY_TEST

    tResult res = -1;
    res = mMediaPlayerInterface.SendRepeatMode(RPT_NONE);
    GMPTEST_EXPECT(res == 0);

    sleep(1);

    tRepeatMode repeatMode;
    res = mMediaPlayerInterface.GetRepeatMode(OUT repeatMode);
    ETG_TRACE_USR1(("SendRepeatMode_Normal::GetRepeatMode : %d ", repeatMode));
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(repeatMode == RPT_NONE);
}

void MediaPlayerInterfaceTest::SendRepeatMode_RepeatAll()
{
    ENTRY_TEST

    tResult res = -1;

    // call GetNowPlaying to get the info about the current playing song
    tNowPlaying nowPlayingPrev;
    res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlayingPrev);
    ETG_TRACE_USR1 (( "Song Filename Before : %64s : %d : %d" , nowPlayingPrev.object.fileName, nowPlayingPrev.object.objectID, mListSize));

    tListSize listSize = 0;
    tIndex index = mListSize - 1;
    tPlaytime offset = 0;

    PlayItemFromList(OUT listSize, IN index, IN offset);

    res = mMediaPlayerInterface.SendRepeatMode(RPT_ALL);
    GMPTEST_EXPECT(res == 0);

    sleep(1);

    // Call GetPlaytime to check the current song elapsedtime and the total playtime of the song
    tPlaytime elapsedPlaytimeSeeked;
    tPlaytime totalPlaytimeSeeked;
    tObjectID objectID = OBJECT_ID_NONE;
    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytimeSeeked, OUT totalPlaytimeSeeked, OUT objectID);
    GMPTEST_EXPECT(res == 0);

    tPlaytime position = totalPlaytimeSeeked - 2000;
    res = mMediaPlayerInterface.SendSeekTo(IN position, PPF_ABSOLUTE);
    GMPTEST_EXPECT(res == 0);

    // call GetNowPlaying to get the info about the current playing song
    res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlayingPrev);
    ETG_TRACE_USR1 (( "Song Filename after : %64s : %d " , nowPlayingPrev.object.fileName, nowPlayingPrev.object.objectID));
    GMPTEST_EXPECT(res == 0);

    tRepeatMode repeatMode;
    res = mMediaPlayerInterface.GetRepeatMode(repeatMode);
    ETG_TRACE_USR1(("SendRepeatMode_RepeatAll::GetRepeatMode : %d ", repeatMode));
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(repeatMode == RPT_ALL);
}

void MediaPlayerInterfaceTest::SendRepeatMode_InValidParamter()
{
    ENTRY_TEST

    tResult res = -1;
    res = mMediaPlayerInterface.SendRepeatMode((tRepeatMode) -1);
    GMPTEST_EXPECT(res == 0);

    sleep(1);

    tRepeatMode repeatMode;
    res = mMediaPlayerInterface.GetRepeatMode(repeatMode);
    ETG_TRACE_USR1(("SendRepeatMode_InValidParamter::GetRepeatMode : %d ", repeatMode));
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(repeatMode == -1);
}

void MediaPlayerInterfaceTest::ActiveMediaDeviceSet_ValidDeviceTag()
{
    ENTRY_TEST

    tResult res = -1;
    tDeviceInfo deviceInfo;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB");
    GMPTEST_EXPECT(res == 0);

    res = mMediaPlayerInterface.ActiveMediaDeviceSet(IN deviceID, IN true);
    GMPTEST_EXPECT(res == 0);

    sleep(1);

    res = mMediaPlayerInterface.ActiveMediaDeviceGet(deviceInfo);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(!strcmp(deviceInfo.deviceName, "USB"));
    GMPTEST_EXPECT(deviceInfo.deviceID == deviceID);
}

void MediaPlayerInterfaceTest::ActiveMediaDeviceGet()
{
    ENTRY_TEST

    tResult res = -1;
    tNumberOfDevices numberOfDevices;
    vector<tDeviceInfo> deviceInfoList;
    tDeviceInfo deviceInfo;

    res = mMediaPlayerInterface.ActiveMediaDeviceGet(deviceInfo);
    GMPTEST_EXPECT(res == 0);

    res = mMediaPlayerInterface.GetMediaplayerDeviceConnections(OUT numberOfDevices, OUT deviceInfoList);
    GMPTEST_EXPECT(res == 0);

    ETG_TRACE_USR1(("ActiveMediaDeviceGet::numberOfDevices - %d", numberOfDevices ));
    GMPTEST_EXPECT(numberOfDevices >= 4);

    for (tUInt i = 0; i < deviceInfoList.size(); i++)
    {
        ETG_TRACE_USR1(("DeviceID : %d, DeviceName : %s", deviceInfoList.at(i).deviceID, deviceInfoList.at(i).deviceName));
    }
}

void MediaPlayerInterfaceTest::ActiveMediaDeviceSet_InvalidDeviceTag()
{
    ENTRY_TEST

    tResult res = -1;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    res = mMediaPlayerInterface.ActiveMediaDeviceSet(IN deviceID, IN true);
    GMPTEST_EXPECT(res != 0);
}

void MediaPlayerInterfaceTest::GetIndexingStateUnsupportedDevice()
{
    ENTRY_TEST

    // TODO: Add unsupported device type to test database (e.g. DTY_MSZUNE)
    // and make a DB_DEVICE_CONNECTED test run in IndexerTest to have an unsupported device
#if 0
    tResult res = -1;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tIndexingState indexingState;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_MSZUNE);
    GMPTEST_EXPECT(res == 0);

    res = mMediaPlayerInterface.GetIndexingState(OUT indexingState, IN deviceID);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(IDS_NOT_SUPPORTED == indexingState);
#endif
}

void MediaPlayerInterfaceTest::GetIndexingStateforNewDevice()
{
    ENTRY_TEST
}

void MediaPlayerInterfaceTest::CreateMediaPlayerIndexedListInvalidTag()
{
    ENTRY_TEST

    tListID ListIDs;
    tListSize listSize;
    tListType ListType = LTY_ALBUM_SONG;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tResult res = -1;

    // set the filter tags
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x9999;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    // call create list
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT ListIDs,
            OUT listSize,
            IN ListType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 0);
}

void MediaPlayerInterfaceTest::CreateMediaPlayerIndexedListInvalidDevice()
{
    ENTRY_TEST

    tListID ListIDs;
    tListSize listSize;
    tListType ListType = LTY_SONG;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tResult res = -1;

    // set the filter tags
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    // call create list
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT ListIDs,
            OUT listSize,
            IN ListType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res != 0);
    GMPTEST_EXPECT(listSize == 0);
}

void MediaPlayerInterfaceTest::CreateMediaPlayerIndexedList_ALBUM_SONG()
{
    ENTRY_TEST

    tResult res = -1;
    tListID listID;
    tListSize listSize;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    vector<tMediaObject> mediaObjectVector;

    // set the filter tags
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    //ALBUM
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_ALBUM,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    mediaObjectVector.clear();

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 5);
    GMPTEST_EXPECT(res == 0);

    GMPTEST_EXPECT(listID > 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 1); //At least 2 elements
    GMPTEST_EXPECT(!strcmp(mediaObjectVector[1].MetadataField1, "German Pop"));
    GMPTEST_EXPECT(!strcmp(mediaObjectVector[1].MetadataField2, "Herbert Grönemeyer"));
    GMPTEST_EXPECT(!strcmp(mediaObjectVector[1].MetadataField4, "Bleibt Alles Anders"));

    //ALBUM_SONG
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.album = mediaObjectVector[1].MetadataTag4;

    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_ALBUM_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    mediaObjectVector.clear();

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 5);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);
}

void MediaPlayerInterfaceTest::CreateMediaPlayerIndexedList_ARTIST_ALBUM_SONG()
{
    ENTRY_TEST

    tResult res = -1;
    tListID listID;
    tListSize listSize;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    vector<tMediaObject> mediaObjectVector;

    //ARTIST
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_ARTIST,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    mediaObjectVector.clear();

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 5);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);

    //ALBUM
    tag1.tag = 0x0;
    tag2.artist = mediaObjectVector[0].MetadataTag2;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_ARTIST_ALBUM,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    mediaObjectVector.clear();

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 5);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);

    //SONG
    tag1.genre = 0x0;
    tag2.artist = mediaObjectVector[0].MetadataTag2;
    tag3.tag = 0x0;
    tag4.album = mediaObjectVector[0].MetadataTag4;

    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_ARTIST_ALBUM_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    mediaObjectVector.clear();

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 5);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);
}

void MediaPlayerInterfaceTest::CreateMediaPlayerIndexedList_COMPOSER_ALBUM_SONG()
{
    ENTRY_TEST

    tResult res = -1;
    tListID listID;
    tListSize listSize;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    vector<tMediaObject> mediaObjectVector;

    //COMPOSER
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_COMPOSER,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    mediaObjectVector.clear();

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 5);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);

    //ALBUM
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.composer = mediaObjectVector[0].MetadataTag3;
    tag4.tag = 0x0;

    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_COMPOSER_ALBUM,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    mediaObjectVector.clear();

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 5);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);

    //SONG
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.composer = mediaObjectVector[0].MetadataTag3;
    tag4.album = mediaObjectVector[0].MetadataTag4;

    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_COMPOSER_ALBUM_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    mediaObjectVector.clear();

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 5);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);
}

void MediaPlayerInterfaceTest::CreateMediaPlayerIndexedList_GENRE_ARTIST_ALBUM()
{
    ENTRY_TEST

    tResult res = -1;
    tListID listID;
    tListSize listSize;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    vector<tMediaObject> mediaObjectVector;

    // set the filter tags
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    //GENRE
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_GENRE,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 4);

    mediaObjectVector.clear();

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 5);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);

    genre = mediaObjectVector[0].MetadataTag1;

    //GENRE_ARTIST
    tag1.genre = genre;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_GENRE_ARTIST,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    mediaObjectVector.clear();

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 5);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);

    artist = mediaObjectVector[0].MetadataTag2;

    //GENRE_ARTIST_ALBUM
    tag1.genre = genre;
    tag2.artist = artist;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_GENRE_ARTIST_ALBUM,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 1);

    mediaObjectVector.clear();

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 5);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);

    GMPTEST_EXPECT(strcmp(mediaObjectVector[0].MetadataField1, "Garbage"));

    composer = mediaObjectVector[0].MetadataTag3;
    album = mediaObjectVector[0].MetadataTag4;
}

void MediaPlayerInterfaceTest::CreateMediaPlayerIndexedList_PODCAST_EPISODE()
{
    ENTRY_TEST

    tResult res = -1;
    tListID listID;
    tListSize listSize;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    vector<tMediaObject> mediaObjectVector;

    // set the filter tags
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    //ALBUM
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_PODCAST,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    mediaObjectVector.clear();

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 5);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);

    podcast = mediaObjectVector[0].MetadataTag1;

    //ALBUM_SONG
    tag1.podcast = podcast;
    tag2.tag = 0x0;
    tag3.tag = 0x0;

    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_PODCAST_EPISODE,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    mediaObjectVector.clear();

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 5);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);
}

void MediaPlayerInterfaceTest::CreateMediaPlayerIndexedList_BOOKTITLE_CHAPTER()
{
    ENTRY_TEST

    tResult res = -1;
    tListID listID;
    tListSize listSize;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    vector<tMediaObject> mediaObjectVector;

    // set the filter tags
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    //ALBUM
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_AUDIOBOOK,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    mediaObjectVector.clear();

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 5);
    ETG_TRACE_USR1(("CreateMediaPlayerIndexedList_BOOKTITLE_CHAPTER >> res : %d", res));
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);

    audiobook = mediaObjectVector[0].MetadataTag2;

    GMPTEST_EXPECT(audiobook > 0);

    //ALBUM_SONG
    tag1.tag = 0x0;
    tag2.audiobook = audiobook;
    tag3.tag = 0x0;

    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_BOOKTITLE_CHAPTER,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    ETG_TRACE_USR1(("CreateMediaPlayerIndexedList_BOOKTITLE_CHAPTER >> res : %d", res));
    GMPTEST_EXPECT(res == 0);

    mediaObjectVector.clear();

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 5);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);
}

void MediaPlayerInterfaceTest::CreateMediaPlayerIndexedList_AUTHOR_BOOKTITILE_CHAPTER()
{
    ENTRY_TEST

    tResult res = -1;
    tListID listID;
    tListSize listSize;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    vector<tMediaObject> mediaObjectVector;

    // set the filter tags
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    //AUTHOR
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_AUTHOR,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    mediaObjectVector.clear();

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 5);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);

    author = mediaObjectVector[0].MetadataTag1;

    //AUTHOR_BOOKTITLE
    tag1.author = author;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_AUTHOR_BOOKTITLE,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    mediaObjectVector.clear();

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 5);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);

    audiobook = mediaObjectVector[0].MetadataTag2;

    tag1.author = author;
    tag2.audiobook = audiobook;
    tag3.tag = 0x0;
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_AUTHOR_BOOKTITLE_CHAPTER,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    mediaObjectVector.clear();

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 5);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);

    ETG_TRACE_USR1(("CreateMediaPlayerIndexedList_AUTHOR_BOOKTITILE_CHAPTER >> MetadataField1 : %s", mediaObjectVector[0].MetadataField1));

    GMPTEST_EXPECT(!strcmp(mediaObjectVector[0].MetadataField1, "Rock"));
}

void MediaPlayerInterfaceTest::CreateMediaPlayerIndexedList_VIDEO_EPISODE()
{
    ENTRY_TEST

    tResult res = -1;
    tListID listID;
    tListSize listSize;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    vector<tMediaObject> mediaObjectVector;

    // set the filter tags
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    //VIDEO
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_VIDEO,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    mediaObjectVector.clear();

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, listSize);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 2);

    /* use 3rd video because the first 2 ones are not supported by codec restriction */
    video = mediaObjectVector[2].MetadataTag1;
    GMPTEST_EXPECT(video > 0);

    //VIDEO_EPISODE
    tag1.video = video;
    tag2.tag = 0x0;
    tag3.tag = 0x0;

    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_VIDEO_EPISODE,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    mediaObjectVector.clear();

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, listSize);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);
}

void MediaPlayerInterfaceTest::CreateMediaPlayerIndexedList_EPISODE()
{
    ENTRY_TEST

    tResult res = -1;
    tListID listID;
    tListSize listSize;
    tListType ListType = LTY_EPISODE_OF_VIDEO;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID;

    /* set the filter tags */
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    // call create list
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            IN ListType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    // test result
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize > 0);

    vector<tMediaObject> mediaObjectVector;
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, listSize);
    // test result
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() == listSize);
}

void MediaPlayerInterfaceTest::CreateMediaPlayerIndexedList_PLAYLIST_SONG()
{
    ENTRY_TEST

    /* Create a list and plays an item from the list*/
    tResult res = -1;
    tListID listID;
    tListSize listSize;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    vector<tMediaObject> mediaObjectVector;

    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_PLAYLIST,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            MY_MEDIA);
    GMPTEST_EXPECT(res == 0);

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(mediaObjectVector, IN listID, 0, 1);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);
    res = mMediaPlayerInterface.ReleaseList(IN listID);
    GMPTEST_EXPECT(res == 0);

    playlist = mediaObjectVector[0].MetadataTag1; //corresponds to a playlist

    // set the filter tags
    tag1.playlist = playlist;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    //create the list
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_PLAYLIST_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    // retrieve a slice of items from the list
    mediaObjectVector.clear();
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 5);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() == 5);
    VARTRACE(mediaObjectVector);

    // play an item from the list just created
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN listID , 2 ,0);
    GMPTEST_EXPECT(res == 0);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    // validate is nowplaying is updated to played list item
    res = WaitForTitleUpdate((const char *)"motown blood");
    GMPTEST_EXPECT(res == 0);
}

void MediaPlayerInterfaceTest::GetNowPlayingWithoutFilePlaying()
{
    ENTRY_TEST

    tResult res = -1;

    // call GetNowPlaying to get the info about the current playing song
    tNowPlaying nowPlayingPrev;
    res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlayingPrev);
    GMPTEST_EXPECT(res == 0);
}

void MediaPlayerInterfaceTest::GetPlaytimeWithoutFilePlaying()
{
    ENTRY_TEST

    tResult res = -1;
    tPlaytime elapsedPlaytime = 0;
    tPlaytime totalPlaytime = 0;
    tObjectID objectID = OBJECT_ID_NONE;
    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    ETG_TRACE_USR1(("res : %d, elapsedPlaytime : %d, totalPlaytime : %d objectID:%u", res, elapsedPlaytime, totalPlaytime,objectID));
    GMPTEST_EXPECT(res == 0);
    //GMPTEST_EXPECT(res == 0 && elapsedPlaytime == 0 && totalPlaytime == 0);
}

void MediaPlayerInterfaceTest::CreateMediaPlayerPlaylistList()
{
    ENTRY_TEST

    tResult res = -1;
    tListSize listSize;
    tListID listID;
    tFilename playListName;

    vector<tFiles> mediaObjects;
    tIndex startIndex = 1;
    tIndex sliceSize = 4;

    /* create playlist name for test */
    strncpy_r(OUT playListName, IN "/music/Mando_Diao-Bring_Em_In-RETAIL-2002-EVIGHET/00-mando_diao-bring_em_in-retail-2002-evighet.m3u", IN sizeof(playListName));

    ETG_TRACE_USR1(("The PlayList Name : %s", playListName));

    /* create playlist list */
    res = mMediaPlayerInterface.CreateMediaPlayerPlaylistList(OUT listID, OUT listSize, IN playListName);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 12);

    res = mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaObjects,IN listID,IN startIndex,IN sliceSize);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjects.size() == 4);

    for (tUInt i = 0; i < mediaObjects.size(); i++)
    {
        ETG_TRACE_USR1(("fileName : %s", mediaObjects.at(i).fileName));
    }
    GMPTEST_EXPECT(!strcmp(mediaObjects.at(0).fileName, "02-sweet_ride-evighet.mp3"));
}

void MediaPlayerInterfaceTest::CreateMediaPlayerPlaylistListInvalidURL()
{
    ENTRY_TEST

    tResult res = -1;
    tListSize listSize;
    tListID listID;
    char playListName[1024];

    /* create playlist name for test */
#ifndef TARGET_BUILD
    char *pwd = get_current_dir_name();
    strncpy_r(OUT playListName, IN pwd, IN sizeof(playListName));
    strncat_r(OUT playListName, IN "/", IN sizeof(playListName));
    strncat_r(OUT playListName, IN "Customer/Simulation/CustomControl/abc", IN sizeof(playListName));
#else
    strncpy_r(OUT playListName, IN "/opt/bosch/test/data/GMP/abc", IN sizeof(playListName));
#endif

    /* create playlist list */
    res = mMediaPlayerInterface.CreateMediaPlayerPlaylistList(OUT listID, OUT listSize, IN playListName);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 0);
}

void MediaPlayerInterfaceTest::CreateQuickPlaylistLTY_GENRE_SONG()
{
    ENTRY_TEST

    tResult res = -1;
    tListInfo listInfo;
    tListType listType = LTY_GENRE_SONG;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set parameters */
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.genre = genre;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* test */
    res = mMediaPlayerInterface.CreateQuickPlayList(
            OUT listInfo,
            IN listType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN playContinuation,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("obtained List id in CreateQuickPlayList: %d ", listInfo.listID));

    ASYNC_WAIT_START(1);

    res = WaitForListID(IN listInfo.listID);
    GMPTEST_EXPECT(res == 0);
}

void MediaPlayerInterfaceTest::CreateQuickPlaylistLTY_GENRE_ARTIST_SONG()
{
    ENTRY_TEST

    tResult res = -1;
    tListInfo listInfo;
    tListType listType = LTY_GENRE_ARTIST_SONG;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set parameters */
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.genre = genre;
    tag2.artist = artist;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* test */
    res = mMediaPlayerInterface.CreateQuickPlayList(
            OUT listInfo,
            IN listType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN playContinuation,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("obtained List id in CreateQuickPlayList: %d ", listInfo.listID));

    ASYNC_WAIT_START(1);

    tNowPlaying nowPlaying;
    for(int sec=30; sec; sec--) {
        res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
        GMPTEST_EXPECT(res == 0);
        if (nowPlaying.listID == listInfo.listID) break;
        sleep(1);
    }
    ETG_TRACE_USR1(("obtained List id in nowPlaying: %d ", listInfo.listID));
    GMPTEST_EXPECT(nowPlaying.listID == listInfo.listID);
}

void MediaPlayerInterfaceTest::CreateQuickPlaylistLTY_GENRE_ARTIST_ALBUM_SONG()
{
    ENTRY_TEST

    tResult res = -1;
    tListInfo listInfo;
    tListType listType = LTY_GENRE_ARTIST_ALBUM_SONG;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set parameters */
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.genre = genre;
    tag2.artist = artist;
    tag3.tag = 0x0;
    tag4.album = album;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* test */
    res = mMediaPlayerInterface.CreateQuickPlayList(
            OUT listInfo,
            IN listType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN playContinuation,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("obtained List id in CreateQuickPlayList: %d ", listInfo.listID));

    ASYNC_WAIT_START(1);

    tNowPlaying nowPlaying;
    for(int sec=30; sec; sec--) {
        res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
        GMPTEST_EXPECT(res == 0);
        if (nowPlaying.listID == listInfo.listID) break;
        sleep(1);
    }
    ETG_TRACE_USR1(("obtained List id in nowPlaying: %d ", listInfo.listID));
    GMPTEST_EXPECT(nowPlaying.listID == listInfo.listID);
}

void MediaPlayerInterfaceTest::CreateQuickPlaylistLTY_GENRE_ARTIST_ALBUM_SONG_TAGALL()
{
    ENTRY_TEST

    tResult res = -1;
    tListInfo listInfo;
    tListType listType = LTY_GENRE_ARTIST_ALBUM_SONG;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set parameters */
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.genre = genre;
    tag2.artist = artist;
    tag3.tag = 0x0;
    tag4.album = album;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* test */
    res = mMediaPlayerInterface.CreateQuickPlayList(
            OUT listInfo,
            IN listType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN playContinuation,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("obtained List id in CreateQuickPlayList: %d ", listInfo.listID));

    ASYNC_WAIT_START(1);

    tNowPlaying nowPlaying;
    for(int sec=30; sec; sec--) {
        res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
        GMPTEST_EXPECT(res == 0);
        if (nowPlaying.listID == listInfo.listID) break;
        sleep(1);
    }
    ETG_TRACE_USR1(("obtained List id in nowPlaying: %d ", listInfo.listID));
    GMPTEST_EXPECT(nowPlaying.listID == listInfo.listID);
}

void MediaPlayerInterfaceTest::CreateQuickPlaylistLTY_ARTIST_SONG()
{
    ENTRY_TEST

    tResult res = -1;
    tListInfo listInfo;
    tListType listType = LTY_ARTIST_SONG;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set parameters */
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = 0x0;
    tag2.artist = artist;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* test */
    res = mMediaPlayerInterface.CreateQuickPlayList(
            OUT listInfo,
            IN listType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN playContinuation,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("obtained List id in CreateQuickPlayList: %d ", listInfo.listID));

    ASYNC_WAIT_START(1);

    res = WaitForListID(IN listInfo.listID);
    GMPTEST_EXPECT(res == 0);
}

void MediaPlayerInterfaceTest::CreateQuickPlaylistLTY_ARTIST_ALBUM_SONG()
{
    ENTRY_TEST

    tResult res = -1;
    tListInfo listInfo;
    tListType listType = LTY_ARTIST_ALBUM_SONG;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set parameters */
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = 0x0;
    tag2.artist = artist;
    tag3.tag = 0x0;
    tag4.album = album;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* test */
    res = mMediaPlayerInterface.CreateQuickPlayList(
            OUT listInfo,
            IN listType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN playContinuation,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("obtained List id in CreateQuickPlayList: %d ", listInfo.listID));

    ASYNC_WAIT_START(1);

    res = WaitForListID(IN listInfo.listID);
    GMPTEST_EXPECT(res == 0);
}

void MediaPlayerInterfaceTest::CreateQuickPlaylistLTY_ARTIST_ALBUM_SONG_TAGALL()
{
    ENTRY_TEST

    tResult res = -1;
    tListInfo listInfo;
    tListType listType = LTY_ARTIST_ALBUM_SONG;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set parameters */
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = 0x0;
    tag2.artist = artist;
    tag3.tag = 0x0;
    tag4.album = album;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* test */
    res = mMediaPlayerInterface.CreateQuickPlayList(
            OUT listInfo,
            IN listType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN playContinuation,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("obtained List id in CreateQuickPlayList: %d ", listInfo.listID));

    ASYNC_WAIT_START(1);

    res = WaitForListID(IN listInfo.listID);
    GMPTEST_EXPECT(res == 0);
}

void MediaPlayerInterfaceTest::CreateQuickPlaylistLTY_ALBUM_SONG()
{
    ENTRY_TEST

    tResult res = -1;
    tListInfo listInfo;
    tListType listType = LTY_ALBUM_SONG;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set parameters */
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.album = album;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* test */
    res = mMediaPlayerInterface.CreateQuickPlayList(
            OUT listInfo,
            IN listType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN playContinuation,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("obtained List id in CreateQuickPlayList: %d ", listInfo.listID));

    ASYNC_WAIT_START(1);

    tNowPlaying nowPlaying;
    for(int sec=30; sec; sec--) {
        res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
        GMPTEST_EXPECT(res == 0);
        if (nowPlaying.listID == listInfo.listID) break;
        sleep(1);
    }
    ETG_TRACE_USR1(("obtained List id in nowPlaying: %d ", listInfo.listID));
    GMPTEST_EXPECT(nowPlaying.listID == listInfo.listID);
}

void MediaPlayerInterfaceTest::CreateQuickPlaylistLTY_ALBUM_SONG_TAGALL()
{
    ENTRY_TEST

    tResult res = -1;
    tListInfo listInfo;
    tListType listType = LTY_ALBUM_SONG;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set parameters */
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.album = album;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* test */
    res = mMediaPlayerInterface.CreateQuickPlayList(
            OUT listInfo,
            IN listType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN playContinuation,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("obtained List id in CreateQuickPlayList: %d ", listInfo.listID));

    ASYNC_WAIT_START(1);

    tNowPlaying nowPlaying;
    for(int sec=30; sec; sec--) {
        res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
        GMPTEST_EXPECT(res == 0);
        if (nowPlaying.listID == listInfo.listID) break;
        sleep(1);
    }
    ETG_TRACE_USR1(("obtained List id in nowPlaying: %d ", listInfo.listID));
    GMPTEST_EXPECT(nowPlaying.listID == listInfo.listID);
}

void MediaPlayerInterfaceTest::CreateQuickPlaylistLTY_SONG()
{
    ENTRY_TEST

    tResult res = -1;
    tListInfo listInfo;
    tListType listType = LTY_SONG;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set parameters */
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* test */
    res = mMediaPlayerInterface.CreateQuickPlayList(
            OUT listInfo,
            IN listType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN playContinuation,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("obtained List id in CreateQuickPlayList: %d ", listInfo.listID));

    ASYNC_WAIT_START(1);

    tNowPlaying nowPlaying;
    for(int sec=30; sec; sec--) {
        res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
        GMPTEST_EXPECT(res == 0);
        if (nowPlaying.listID == listInfo.listID) break;
        sleep(1);
    }
    ETG_TRACE_USR1(("obtained List id in nowPlaying: %d ", listInfo.listID));
    GMPTEST_EXPECT(nowPlaying.listID == listInfo.listID);
}

void MediaPlayerInterfaceTest::CreateQuickPlaylistLTY_PODCAST_EPISODE()
{
    ENTRY_TEST

    tResult res = -1;
    tListInfo listInfo;
    tListType listType = LTY_PODCAST_EPISODE;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set parameters */
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.podcast = podcast;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* test */
    res = mMediaPlayerInterface.CreateQuickPlayList(
            OUT listInfo,
            IN listType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN playContinuation,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("obtained List id in CreateQuickPlayList: %d ", listInfo.listID));

    ASYNC_WAIT_START(1);

    tNowPlaying nowPlaying;
    res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("obtained List id in nowPlaying: %d ", listInfo.listID));
    GMPTEST_EXPECT(nowPlaying.listID == listInfo.listID);
}

void MediaPlayerInterfaceTest::CreateQuickPlaylistLTY_BOOKTITLE_CHAPTER()
{
    ENTRY_TEST

    tResult res = -1;
    tListInfo listInfo;
    tListType listType = LTY_BOOKTITLE_CHAPTER;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set parameters */
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = 0x0;
    tag2.audiobook = audiobook;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* test */
    res = mMediaPlayerInterface.CreateQuickPlayList(
            OUT listInfo,
            IN listType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN playContinuation,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("obtained List id in CreateQuickPlayList: %d ", listInfo.listID));

    ASYNC_WAIT_START(1);

    tNowPlaying nowPlaying;
    res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("obtained List id in nowPlaying: %d ", listInfo.listID));
    GMPTEST_EXPECT(nowPlaying.listID == listInfo.listID);
}

void MediaPlayerInterfaceTest::CreateQuickPlaylistLTY_COMPOSER_ALBUM_SONG()
{
    ENTRY_TEST

    tResult res = -1;
    tListInfo listInfo;
    tListType listType = LTY_COMPOSER_ALBUM_SONG;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set parameters */
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.composer = composer;
    tag4.album = album;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* test */
    res = mMediaPlayerInterface.CreateQuickPlayList(
            OUT listInfo,
            IN listType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN playContinuation,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("obtained List id in CreateQuickPlayList: %d ", listInfo.listID));

    ASYNC_WAIT_START(1);

    tNowPlaying nowPlaying;
    for(int sec=30; sec; sec--) {
        res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
        GMPTEST_EXPECT(res == 0);
        if (nowPlaying.listID == listInfo.listID) break;
        sleep(1);
    }
    ETG_TRACE_USR1(("obtained List id in nowPlaying: %d ", listInfo.listID));
    GMPTEST_EXPECT(nowPlaying.listID == listInfo.listID);
}

void MediaPlayerInterfaceTest::CreateQuickPlaylistLTY_COMPOSER_SONG()
{
    ENTRY_TEST

    tResult res = -1;
    tListInfo listInfo;
    tListType listType = LTY_COMPOSER_SONG;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set parameters */
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.composer = composer;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* test */
    res = mMediaPlayerInterface.CreateQuickPlayList(
            OUT listInfo,
            IN listType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN playContinuation,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("obtained List id in CreateQuickPlayList: %d ", listInfo.listID));

    ASYNC_WAIT_START(1);

    tNowPlaying nowPlaying;
    for(int sec=30; sec; sec--) {
        res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
        GMPTEST_EXPECT(res == 0);
        if (nowPlaying.listID == listInfo.listID) break;
        sleep(1);
    }
    ETG_TRACE_USR1(("obtained List id in nowPlaying: %d ", listInfo.listID));
    GMPTEST_EXPECT(nowPlaying.listID == listInfo.listID);
}

#if defined(TARGET_TEST)
void MediaPlayerInterfaceTest::CreateQuickPlaylistLTY_VIDEO_EPISODE()
{
    ENTRY_TEST

    tResult res = -1;
    tListInfo listInfo;
    tListType listType = LTY_VIDEO_EPISODE;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set parameters */
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.video = video;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* test */
    res = mMediaPlayerInterface.CreateQuickPlayList(
            OUT listInfo,
            IN listType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN playContinuation,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("obtained List id in CreateQuickPlayList: %d ", listInfo.listID));

    ASYNC_WAIT_START(1);

    tNowPlaying nowPlaying;
    res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("obtained List id in nowPlaying: %d ", listInfo.listID));
    GMPTEST_EXPECT(nowPlaying.listID == listInfo.listID);
}
#endif

void MediaPlayerInterfaceTest::CreateQuickPlaylistLTY_PLAYLIST_SONG()
{
    ENTRY_TEST

    tResult res = -1;
    tListInfo listInfo;
    tListType listType = LTY_PLAYLIST_SONG;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set parameters */
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.playlist = playlist;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* test */
    res = mMediaPlayerInterface.CreateQuickPlayList(
            OUT listInfo,
            IN listType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN playContinuation,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("obtained List id in CreateQuickPlayList: %d ", listInfo.listID));

    ASYNC_WAIT_START(1);

    tNowPlaying nowPlaying;
    for(int sec=30; sec; sec--) {
        res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
        GMPTEST_EXPECT(res == 0);
        if (nowPlaying.listID == listInfo.listID) break;
        sleep(1);
    }
    ETG_TRACE_USR1(("obtained List id in nowPlaying: %d ", listInfo.listID));
    GMPTEST_EXPECT(nowPlaying.listID == listInfo.listID);
}

void MediaPlayerInterfaceTest::CreateMediaPlayerFileListWithInvalidParam()
{
    ENTRY_TEST

    tResult res = -1;
    tListID fileListID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* create a file list from root directory */
    strncpy_r(OUT path, IN "/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT fileListID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID);
    GMPTEST_EXPECT(res != 0);
}

void MediaPlayerInterfaceTest::CreateMediaPlayerFileListWithUSBDisconnected()
{
    //Unmount USB or corrupt the data base to fetch the data
    //
    ENTRY_TEST

    tResult res = -1;
    tListID listID = LIST_ID_NONE;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set the path */
    strncpy_r(OUT path, IN "/", IN sizeof(path));

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "MIXED");
    GMPTEST_EXPECT(res == 0);

    /* try to create a file list from root directory */
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID);
    GMPTEST_EXPECT(res != 0);
}

void MediaPlayerInterfaceTest::CreateMediaPlayerFileList_AllTypes()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;

#ifdef USE_GENERIC_STICK
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB,"USB-2");
    GMPTEST_EXPECT(res == 0);
#else
    tDeviceID deviceID = 3;/*stick_2*/
#endif


    /* create a file list from root directory */
    strncpy_r(OUT path, IN "/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_ALL);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 14);

    /* get the list slice */
    vector<tFiles> mediaFileVector;
    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, listSize);
    GMPTEST_EXPECT(res == 0);

    GMPTEST_EXPECT(mediaFileVector[0].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[1].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[2].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[3].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[4].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[5].type == FT_PLAYLIST);
    GMPTEST_EXPECT(mediaFileVector[6].type == FT_PLAYLIST);
    GMPTEST_EXPECT(mediaFileVector[7].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[8].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[9].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[10].type == FT_VIDEO);
    GMPTEST_EXPECT(mediaFileVector[11].type == FT_IMAGE);
    GMPTEST_EXPECT(mediaFileVector[12].type == FT_IMAGE);
    GMPTEST_EXPECT(mediaFileVector[13].type== FT_IMAGE);

    GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"ID3V1"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[1].fileName,"Supertramp"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[2].fileName,"UCASort"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[3].fileName,"Unheilig"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[4].fileName,"Wolfsheim"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[5].fileName,"Playlist1.wpl"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[6].fileName,"Playlist2.m3u"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[7].fileName,"04_lakshya.mp3"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[8].fileName,"DRMProtected.wma"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[9].fileName,"Radkaeppchen.mp3"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[10].fileName,"FLV-Sorenson_AAC.flv"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[11].fileName,"Art-MP3-A_Stroke_of_Luck.jpg"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[12].fileName,"Art-MP3-Its_Raining_Again.jpg"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[13].fileName,"Art-MP3-Neuland.jpg"));
}


void MediaPlayerInterfaceTest::CreateMediaPlayerFileList_AllTypes_SecondLevelDir()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;

#ifdef USE_GENERIC_STICK
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB,"USB-4");
    GMPTEST_EXPECT(res == 0);
#else
    tDeviceID deviceID = 3;/*stick_2*/
#endif

    /* create a file list from root directory (Negative test case) */
    strncpy_r(OUT path, IN "/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_ALL);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 1);

    /* create a file list from invalid directory (Negative test case) */
    strncpy_r(OUT path, IN "/Test/Test2/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_ALL);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 0);

    /* create a file list from root directory (Negative test case) */
    strncpy_r(OUT path, IN "/Test/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_ALL);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 15);

    /* get the list slice */
    vector<tFiles> mediaFileVector;
    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, listSize);
    GMPTEST_EXPECT(res == 0);

    GMPTEST_EXPECT(mediaFileVector[0].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[1].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[2].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[3].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[4].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[5].type == FT_PLAYLIST);
    GMPTEST_EXPECT(mediaFileVector[6].type == FT_PLAYLIST);
    GMPTEST_EXPECT(mediaFileVector[7].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[8].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[9].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[10].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[11].type == FT_VIDEO);
    GMPTEST_EXPECT(mediaFileVector[12].type == FT_IMAGE);
    GMPTEST_EXPECT(mediaFileVector[13].type == FT_IMAGE);
    GMPTEST_EXPECT(mediaFileVector[14].type== FT_IMAGE);

    GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"ID3V1_stick4"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[1].fileName,"Supertramp_stick4"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[2].fileName,"UCASort_stick4"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[3].fileName,"Unheilig_stick4"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[4].fileName,"Wolfsheim_stick4"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[5].fileName,"Playlist1_stick4.wpl"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[6].fileName,"Playlist2_stick4.m3u"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[7].fileName,"01_WAV_Speedway_stick4.wav"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[8].fileName,"04_lakshya_stick4.mp3"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[9].fileName,"DRMProtected_stick4.wma"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[10].fileName,"Radkaeppchen_stick4.mp3"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[11].fileName,"FLV-Sorenson_AAC_stick4.flv"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[12].fileName,"Art-MP3-A_Stroke_of_Luck_stick4.jpg"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[13].fileName,"Art-MP3-Its_Raining_Again_stick4.jpg"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[14].fileName,"Art-MP3-Neuland_stick4.jpg"));

    /* create a file list from root directory with invalid deviceID (Negative test case) */
    strncpy_r(OUT path, IN "/Test/", IN sizeof(path));
    deviceID = 19999;
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_ALL);
    GMPTEST_EXPECT(res != 0);
    GMPTEST_EXPECT(listSize == 0);
}

void MediaPlayerInterfaceTest::CreateMediaPlayerFileList_AudioVideoPlaylistOnly()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
#ifdef USE_GENERIC_STICK
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB,"USB-2");
    GMPTEST_EXPECT(res == 0);
#else
    tDeviceID deviceID = 3;/*stick_2*/
#endif


    /* create a file list from root directory */
    strncpy_r(OUT path, IN "/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_AUDIO_VIDEO_PLAYLIST);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 11);

    /* get the list slice */
    vector<tFiles> mediaFileVector;
    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, listSize);
    GMPTEST_EXPECT(res == 0);

    GMPTEST_EXPECT(mediaFileVector[0].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[1].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[2].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[3].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[4].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[5].type == FT_PLAYLIST);
    GMPTEST_EXPECT(mediaFileVector[6].type == FT_PLAYLIST);
    GMPTEST_EXPECT(mediaFileVector[7].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[8].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[9].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[10].type == FT_VIDEO);

    GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"ID3V1"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[1].fileName,"Supertramp"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[2].fileName,"UCASort"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[3].fileName,"Unheilig"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[4].fileName,"Wolfsheim"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[5].fileName,"Playlist1.wpl"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[6].fileName,"Playlist2.m3u"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[7].fileName,"04_lakshya.mp3"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[8].fileName,"DRMProtected.wma"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[9].fileName,"Radkaeppchen.mp3"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[10].fileName,"FLV-Sorenson_AAC.flv"));
}

void MediaPlayerInterfaceTest::CreateMediaPlayerFileList_AudioVideoPlaylistOnly_SecondLevelDir()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
#ifdef USE_GENERIC_STICK
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB,"USB-4");
    GMPTEST_EXPECT(res == 0);
#else
    tDeviceID deviceID = 3;/*stick_2*/
#endif

    /* create a file list from root directory (Negative test case) */
    strncpy_r(OUT path, IN "/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_AUDIO_VIDEO_PLAYLIST);

    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 1);
    GMPTEST_EXPECT(numberOfMediaObjects == 0);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 1);

    /* create a file list from invalid directory (Negative test case) */
    strncpy_r(OUT path, IN "/Test/Test2/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_AUDIO_VIDEO_PLAYLIST);

    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 0);
    GMPTEST_EXPECT(numberOfMediaObjects == 0);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 0);

    /* create a file list from second root directory (Positive test case) */
    strncpy_r(OUT path, IN "/Test/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_AUDIO_VIDEO_PLAYLIST);
    GMPTEST_EXPECT(res == 0);

    GMPTEST_EXPECT(listSize != 11);
    GMPTEST_EXPECT(listSize == 12);
    GMPTEST_EXPECT(listSize != 13);

    GMPTEST_EXPECT(numberOfMediaObjects != 4);
    GMPTEST_EXPECT(numberOfMediaObjects == 5);
    GMPTEST_EXPECT(numberOfMediaObjects != 6);

    GMPTEST_EXPECT(numberOfPlayLists != 1);
    GMPTEST_EXPECT(numberOfPlayLists == 2);
    GMPTEST_EXPECT(numberOfPlayLists != 3);

    GMPTEST_EXPECT(numberOfFolders != 4);
    GMPTEST_EXPECT(numberOfFolders == 5);
    GMPTEST_EXPECT(numberOfFolders != 6);

    /* get the list slice */
    vector<tFiles> mediaFileVector;
    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, listSize);
    GMPTEST_EXPECT(res == 0);

    GMPTEST_EXPECT(mediaFileVector[0].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[1].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[2].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[3].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[4].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[5].type == FT_PLAYLIST);
    GMPTEST_EXPECT(mediaFileVector[6].type == FT_PLAYLIST);
    GMPTEST_EXPECT(mediaFileVector[7].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[8].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[9].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[10].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[11].type == FT_VIDEO);

    GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"ID3V1_stick4"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[1].fileName,"Supertramp_stick4"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[2].fileName,"UCASort_stick4"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[3].fileName,"Unheilig_stick4"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[4].fileName,"Wolfsheim_stick4"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[5].fileName,"Playlist1_stick4.wpl"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[6].fileName,"Playlist2_stick4.m3u"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[7].fileName,"01_WAV_Speedway_stick4.wav"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[8].fileName,"04_lakshya_stick4.mp3"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[9].fileName,"DRMProtected_stick4.wma"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[10].fileName,"Radkaeppchen_stick4.mp3"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[11].fileName,"FLV-Sorenson_AAC_stick4.flv"));

    /* create a file list from second root directory with invalid deviceID (Negative test case) */
    strncpy_r(OUT path, IN "/Test/", IN sizeof(path));
    deviceID = 20999;
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_AUDIO_VIDEO_PLAYLIST);

    GMPTEST_EXPECT(res != 0);
    GMPTEST_EXPECT(listSize == 0);
    GMPTEST_EXPECT(numberOfMediaObjects == 0);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 0);
}

void MediaPlayerInterfaceTest::CreateMediaPlayerFileList_AudioPlaylistOnly()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
#ifdef USE_GENERIC_STICK
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB,"USB-2");
    GMPTEST_EXPECT(res == 0);
#else
    tDeviceID deviceID = 3;/*stick_2*/
#endif


    /* create a file list from root directory */
    strncpy_r(OUT path, IN "/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_AUDIO_PLAYLIST);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 10);

    /* get the list slice */
    vector<tFiles> mediaFileVector;
    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, listSize);
    GMPTEST_EXPECT(res == 0);

    GMPTEST_EXPECT(mediaFileVector[0].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[1].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[2].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[3].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[4].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[5].type == FT_PLAYLIST);
    GMPTEST_EXPECT(mediaFileVector[6].type == FT_PLAYLIST);
    GMPTEST_EXPECT(mediaFileVector[7].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[8].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[9].type == FT_AUDIO);

    GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"ID3V1"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[1].fileName,"Supertramp"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[2].fileName,"UCASort"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[3].fileName,"Unheilig"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[4].fileName,"Wolfsheim"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[5].fileName,"Playlist1.wpl"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[6].fileName,"Playlist2.m3u"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[7].fileName,"04_lakshya.mp3"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[8].fileName,"DRMProtected.wma"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[9].fileName,"Radkaeppchen.mp3"));
}

void MediaPlayerInterfaceTest::CreateMediaPlayerFileList_AudioPlaylistOnly_SecondLevelDir()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
#ifdef USE_GENERIC_STICK
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB-4");
    GMPTEST_EXPECT(res == 0);
#else
    tDeviceID deviceID = 3;/*stick_2*/
#endif

    /* create a file list from root directory (Negative test case) */
    strncpy_r(OUT path, IN "/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_AUDIO_PLAYLIST);

    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 1);
    GMPTEST_EXPECT(numberOfMediaObjects == 0);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 1);

    /* create a file list from invalid root directory (Negative test case) */
    strncpy_r(OUT path, IN "/Test/Test2/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_AUDIO_PLAYLIST);

    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 0);
    GMPTEST_EXPECT(numberOfMediaObjects == 0);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 0);

    /* create a file list from second root directory (Positive test case) */
    strncpy_r(OUT path, IN "/Test/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_AUDIO_PLAYLIST);

    GMPTEST_EXPECT(res == 0);

    GMPTEST_EXPECT(listSize != 10);
    GMPTEST_EXPECT(listSize == 11);
    GMPTEST_EXPECT(listSize != 12);

    GMPTEST_EXPECT(numberOfMediaObjects != 3);
    GMPTEST_EXPECT(numberOfMediaObjects == 4);
    GMPTEST_EXPECT(numberOfMediaObjects != 5);

    GMPTEST_EXPECT(numberOfPlayLists != 1);
    GMPTEST_EXPECT(numberOfPlayLists == 2);
    GMPTEST_EXPECT(numberOfPlayLists != 3);

    GMPTEST_EXPECT(numberOfFolders != 4);
    GMPTEST_EXPECT(numberOfFolders == 5);
    GMPTEST_EXPECT(numberOfFolders != 6);

    /* get the list slice */
    vector<tFiles> mediaFileVector;
    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, listSize);
    GMPTEST_EXPECT(res == 0);

    GMPTEST_EXPECT(mediaFileVector[0].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[1].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[2].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[3].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[4].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[5].type == FT_PLAYLIST);
    GMPTEST_EXPECT(mediaFileVector[6].type == FT_PLAYLIST);
    GMPTEST_EXPECT(mediaFileVector[7].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[8].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[9].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[10].type == FT_AUDIO);

    GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"ID3V1_stick4"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[1].fileName,"Supertramp_stick4"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[2].fileName,"UCASort_stick4"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[3].fileName,"Unheilig_stick4"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[4].fileName,"Wolfsheim_stick4"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[5].fileName,"Playlist1_stick4.wpl"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[6].fileName,"Playlist2_stick4.m3u"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[7].fileName,"01_WAV_Speedway_stick4.wav"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[8].fileName,"04_lakshya_stick4.mp3"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[9].fileName,"DRMProtected_stick4.wma"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[10].fileName,"Radkaeppchen_stick4.mp3"));


    /* create a file list from second root directory with invalid deviceID (Negative test case) */
    strncpy_r(OUT path, IN "/Test/", IN sizeof(path));
    deviceID = 9999;
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_AUDIO_PLAYLIST);

    GMPTEST_EXPECT(res != 0);
    GMPTEST_EXPECT(listSize == 0);
    GMPTEST_EXPECT(numberOfMediaObjects == 0);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 0);
}

void MediaPlayerInterfaceTest::CreateMediaPlayerFileList_AudioOnly()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
#ifdef USE_GENERIC_STICK
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB,"USB-2");
    GMPTEST_EXPECT(res == 0);
#else
    tDeviceID deviceID = 3;/*stick_2*/
#endif


    /* create a file list from root directory */
    strncpy_r(OUT path, IN "/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_AUDIO);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 8);

    /* get the list slice */
    vector<tFiles> mediaFileVector;
    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, listSize);
    GMPTEST_EXPECT(res == 0);

    for (tUInt i = 0; i < mediaFileVector.size(); i++)
    {
        ETG_TRACE_USR1(("fileName : %s", mediaFileVector.at(i).fileName));
    }

    GMPTEST_EXPECT(mediaFileVector[0].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[1].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[2].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[3].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[4].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[5].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[6].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[7].type == FT_AUDIO);

    GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"ID3V1"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[1].fileName,"Supertramp"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[2].fileName,"UCASort"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[3].fileName,"Unheilig"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[4].fileName,"Wolfsheim"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[5].fileName,"04_lakshya.mp3"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[6].fileName,"DRMProtected.wma"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[7].fileName,"Radkaeppchen.mp3"));
}

void MediaPlayerInterfaceTest::CreateMediaPlayerFileList_AudioOnly_SecondLevelDir()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
#ifdef USE_GENERIC_STICK
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB,"USB-4");
    GMPTEST_EXPECT(res == 0);
#else
    tDeviceID deviceID = 3;/*stick_2*/
#endif

    /* create a file list from root directory (Negative test case)*/
    strncpy_r(OUT path, IN "/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_AUDIO);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 1);
    GMPTEST_EXPECT(numberOfMediaObjects == 0);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 1);

    /* create a file list from invalid directory (Negative test case)*/
    strncpy_r(OUT path, IN "/Test/Test2/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_AUDIO);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 0);
    GMPTEST_EXPECT(numberOfMediaObjects == 0);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 0);

    /* create a file list from second root directory (Positive test case)*/
    strncpy_r(OUT path, IN "/Test/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_AUDIO);
    GMPTEST_EXPECT(res == 0);

    GMPTEST_EXPECT(listSize != 8);
    GMPTEST_EXPECT(listSize == 9);
    GMPTEST_EXPECT(listSize != 10);

    GMPTEST_EXPECT(numberOfMediaObjects != 4);
    GMPTEST_EXPECT(numberOfMediaObjects == 5);
    GMPTEST_EXPECT(numberOfMediaObjects != 6);

    GMPTEST_EXPECT(numberOfPlayLists != 1);
    GMPTEST_EXPECT(numberOfPlayLists == 2);
    GMPTEST_EXPECT(numberOfPlayLists != 3);

    GMPTEST_EXPECT(numberOfFolders != 4);
    GMPTEST_EXPECT(numberOfFolders == 5);
    GMPTEST_EXPECT(numberOfFolders != 6);

    /* get the list slice */
    vector<tFiles> mediaFileVector;
    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, listSize);
    GMPTEST_EXPECT(res == 0);

    for (tUInt i = 0; i < mediaFileVector.size(); i++)
    {
        ETG_TRACE_USR1(("fileName : %s", mediaFileVector.at(i).fileName));
    }

    GMPTEST_EXPECT(mediaFileVector[0].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[1].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[2].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[3].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[4].type == FT_FOLDER);
    GMPTEST_EXPECT(mediaFileVector[5].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[6].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[7].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[8].type == FT_AUDIO);

    GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"ID3V1_stick4"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[1].fileName,"Supertramp_stick4"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[2].fileName,"UCASort_stick4"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[3].fileName,"Unheilig_stick4"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[4].fileName,"Wolfsheim_stick4"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[5].fileName,"01_WAV_Speedway_stick4.wav"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[6].fileName,"04_lakshya_stick4.mp3"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[7].fileName,"DRMProtected_stick4.wma"));
    GMPTEST_EXPECT(!strcmp(mediaFileVector[8].fileName,"Radkaeppchen_stick4.mp3"));


    /* create a file list from second root directory with invalid deviceID (Negative test case)*/
    strncpy_r(OUT path, IN "/Test/", IN sizeof(path));
    deviceID = 20999;
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_AUDIO);
    GMPTEST_EXPECT(res != 0);
    GMPTEST_EXPECT(listSize == 0);
    GMPTEST_EXPECT(numberOfMediaObjects == 0);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 0);
}

void MediaPlayerInterfaceTest::CreateMediaPlayerFileList_VideoOnly()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
#ifdef USE_GENERIC_STICK
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB,"USB-2");
    GMPTEST_EXPECT(res == 0);
#else
    tDeviceID deviceID = 3;/*stick_2*/
#endif


    /* create a file list from root directory */
    strncpy_r(OUT path, IN "/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_VIDEO);
    GMPTEST_EXPECT(res == 0);
    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB()) //filtering via media content (only folders with video content are included)
    {
        GMPTEST_EXPECT(listSize == 1);
    }
    else  //filtering via file type (all folders are included)
    {
        GMPTEST_EXPECT(listSize == 6);
    }

    /* get the list slice */
    vector<tFiles> mediaFileVector;
    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, listSize);
    GMPTEST_EXPECT(res == 0);

    for (tUInt i = 0; i < mediaFileVector.size(); i++)
    {
        ETG_TRACE_USR1(("fileName : %s", mediaFileVector.at(i).fileName));
    }

    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB()) //filtering via media content (only folders with video content are included)
    {
        GMPTEST_EXPECT(mediaFileVector[0].type == FT_VIDEO);

        GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"FLV-Sorenson_AAC.flv"));
    }
    else  //filtering via file type (all folders are included)
    {
        GMPTEST_EXPECT(mediaFileVector[0].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[1].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[2].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[3].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[4].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[5].type == FT_VIDEO);

        GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"ID3V1"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[1].fileName,"Supertramp"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[2].fileName,"UCASort"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[3].fileName,"Unheilig"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[4].fileName,"Wolfsheim"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[5].fileName,"FLV-Sorenson_AAC.flv"));
    }
}

void MediaPlayerInterfaceTest::CreateMediaPlayerFileList_VideoOnly_SecondLevelDir()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
#ifdef USE_GENERIC_STICK
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB,"USB-4");
    GMPTEST_EXPECT(res == 0);
#else
    tDeviceID deviceID = 3;/*stick_2*/
#endif

    /* create a file list from root directory (Negative test case) */
    strncpy_r(OUT path, IN "/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_VIDEO);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 1);
    GMPTEST_EXPECT(numberOfMediaObjects == 0);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 1);


    /* create a file list from invalid root directory (Negative test case) */
    strncpy_r(OUT path, IN "/Test/Test2/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_VIDEO);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 0);
    GMPTEST_EXPECT(numberOfMediaObjects == 0);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 0);

    /* create a file list from second root directory */
    strncpy_r(OUT path, IN "/Test/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_VIDEO);
    GMPTEST_EXPECT(res == 0);

    GMPTEST_EXPECT(listSize != 5);
    GMPTEST_EXPECT(listSize == 6);
    GMPTEST_EXPECT(listSize != 7);

    GMPTEST_EXPECT(numberOfMediaObjects != 4);
    GMPTEST_EXPECT(numberOfMediaObjects == 5);
    GMPTEST_EXPECT(numberOfMediaObjects != 6);

    GMPTEST_EXPECT(numberOfPlayLists != 1);
    GMPTEST_EXPECT(numberOfPlayLists == 2);
    GMPTEST_EXPECT(numberOfPlayLists != 3);

    GMPTEST_EXPECT(numberOfFolders != 4);
    GMPTEST_EXPECT(numberOfFolders == 5);
    GMPTEST_EXPECT(numberOfFolders != 6);

    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB()) //filtering via media content (only folders with video content are included)
    {
        GMPTEST_EXPECT(listSize == 1);
    }
    else  //filtering via file type (all folders are included)
    {
        GMPTEST_EXPECT(listSize == 6);
    }

    /* get the list slice */
    vector<tFiles> mediaFileVector;
    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, listSize);
    GMPTEST_EXPECT(res == 0);

    for (tUInt i = 0; i < mediaFileVector.size(); i++)
    {
        ETG_TRACE_USR1(("fileName : %s", mediaFileVector.at(i).fileName));
    }

    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB()) //filtering via media content (only folders with video content are included)
    {
        GMPTEST_EXPECT(mediaFileVector[0].type == FT_VIDEO);

        GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"FLV-Sorenson_AAC_stick4.flv"));
    }
    else  //filtering via file type (all folders are included)
    {
        GMPTEST_EXPECT(mediaFileVector[0].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[1].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[2].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[3].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[4].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[5].type == FT_VIDEO);

        GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"ID3V1_stick4"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[1].fileName,"Supertramp_stick4"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[2].fileName,"UCASort_stick4"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[3].fileName,"Unheilig_stick4"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[4].fileName,"Wolfsheim_stick4"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[5].fileName,"FLV-Sorenson_AAC_stick4.flv"));
    }

    /* create a file list from second root directory with invalid deviceID (Negative test case) */
    strncpy_r(OUT path, IN "/Test/", IN sizeof(path));
    deviceID = 12999;
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_VIDEO);
    GMPTEST_EXPECT(res != 0);
    GMPTEST_EXPECT(listID == 0);
    GMPTEST_EXPECT(numberOfMediaObjects == 0);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 0);
}

void MediaPlayerInterfaceTest::CreateMediaPlayerFileList_PlaylistOnly()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
#ifdef USE_GENERIC_STICK
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB,"USB-2");
    GMPTEST_EXPECT(res == 0);
#else
    tDeviceID deviceID = 3;/*stick_2*/
#endif


    /* create a file list from root directory */
    strncpy_r(OUT path, IN "/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_PLAYLIST);
    GMPTEST_EXPECT(res == 0);
    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB()) //filtering via media content (only folders with video content are included)
    {
        GMPTEST_EXPECT(listSize == 2);
    }
    else  //filtering via file type (all folders are included)
    {
        GMPTEST_EXPECT(listSize == 7);
    }

    /* get the list slice */
    vector<tFiles> mediaFileVector;
    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, listSize);
    GMPTEST_EXPECT(res == 0);

    for (tUInt i = 0; i < mediaFileVector.size(); i++)
    {
        ETG_TRACE_USR1(("fileName : %s", mediaFileVector.at(i).fileName));
    }

    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB()) //filtering via media content (only folders with playlist content are included)
    {
        GMPTEST_EXPECT(mediaFileVector[0].type == FT_PLAYLIST);
        GMPTEST_EXPECT(mediaFileVector[1].type == FT_PLAYLIST);

        GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"Playlist1.wpl"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[1].fileName,"Playlist2.m3u"));
    }
    else  //filtering via file type (all folders are included)
    {
        GMPTEST_EXPECT(mediaFileVector[0].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[1].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[2].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[3].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[4].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[5].type == FT_PLAYLIST);
        GMPTEST_EXPECT(mediaFileVector[6].type == FT_PLAYLIST);

        GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"ID3V1"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[1].fileName,"Supertramp"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[2].fileName,"UCASort"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[3].fileName,"Unheilig"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[4].fileName,"Wolfsheim"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[5].fileName,"Playlist1.wpl"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[6].fileName,"Playlist2.m3u"));
    }
}

void MediaPlayerInterfaceTest::CreateMediaPlayerFileList_PlaylistOnly_SecondLevelDir()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
#ifdef USE_GENERIC_STICK
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB,"USB-4");
    GMPTEST_EXPECT(res == 0);
#else
    tDeviceID deviceID = 3;/*stick_2*/
#endif

    /* create a file list from root directory (Negative test case) */
    strncpy_r(OUT path, IN "/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_PLAYLIST);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 1);
    GMPTEST_EXPECT(numberOfMediaObjects == 0);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 1);

    /* create a file list from invalid directory (Negative test case) */
    strncpy_r(OUT path, IN "/Test/Test2/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_PLAYLIST);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 0);
    GMPTEST_EXPECT(numberOfMediaObjects == 0);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 0);

    /* create a file list from second root directory (Positive test case) */
    strncpy_r(OUT path, IN "/Test/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_PLAYLIST);
    GMPTEST_EXPECT(res == 0);

    GMPTEST_EXPECT(listSize != 6);
    GMPTEST_EXPECT(listSize == 7);
    GMPTEST_EXPECT(listSize != 8);

    GMPTEST_EXPECT(numberOfMediaObjects != 4);
    GMPTEST_EXPECT(numberOfMediaObjects == 5);
    GMPTEST_EXPECT(numberOfMediaObjects != 6);

    GMPTEST_EXPECT(numberOfPlayLists != 1);
    GMPTEST_EXPECT(numberOfPlayLists == 2);
    GMPTEST_EXPECT(numberOfPlayLists != 3);

    GMPTEST_EXPECT(numberOfFolders != 4);
    GMPTEST_EXPECT(numberOfFolders == 5);
    GMPTEST_EXPECT(numberOfFolders != 6);

    GMPTEST_EXPECT(res == 0);
    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB()) //filtering via media content (only folders with video content are included)
    {
        GMPTEST_EXPECT(listSize == 2);
    }
    else  //filtering via file type (all folders are included)
    {
        GMPTEST_EXPECT(listSize == 7);
    }

    /* get the list slice */
    vector<tFiles> mediaFileVector;
    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, listSize);
    GMPTEST_EXPECT(res == 0);

    for (tUInt i = 0; i < mediaFileVector.size(); i++)
    {
        ETG_TRACE_USR1(("fileName : %s", mediaFileVector.at(i).fileName));
    }

    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB()) //filtering via media content (only folders with playlist content are included)
    {
        GMPTEST_EXPECT(mediaFileVector[0].type == FT_PLAYLIST);
        GMPTEST_EXPECT(mediaFileVector[1].type == FT_PLAYLIST);

        GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"Playlist1.wpl"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[1].fileName,"Playlist2.m3u"));
    }
    else  //filtering via file type (all folders are included)
    {
        GMPTEST_EXPECT(mediaFileVector[0].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[1].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[2].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[3].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[4].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[5].type == FT_PLAYLIST);
        GMPTEST_EXPECT(mediaFileVector[6].type == FT_PLAYLIST);

        GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"ID3V1_stick4"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[1].fileName,"Supertramp_stick4"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[2].fileName,"UCASort_stick4"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[3].fileName,"Unheilig_stick4"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[4].fileName,"Wolfsheim_stick4"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[5].fileName,"Playlist1_stick4.wpl"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[6].fileName,"Playlist2_stick4.m3u"));
    }

    /* create a file list from second root directory with invalid deviceID (Negative test case) */
    strncpy_r(OUT path, IN "/Test/", IN sizeof(path));
    deviceID = 20999;
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_PLAYLIST);
    GMPTEST_EXPECT(res != 0);
    GMPTEST_EXPECT(listSize == 0);
    GMPTEST_EXPECT(numberOfMediaObjects == 0);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 0);
}

void MediaPlayerInterfaceTest::CreateMediaPlayerFileList_ImageOnly()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
#ifdef USE_GENERIC_STICK
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB,"USB-2");
    GMPTEST_EXPECT(res == 0);
#else
    tDeviceID deviceID = 3;/*stick_2*/
#endif


    /* create a file list from root directory */
    strncpy_r(OUT path, IN "/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_IMAGE);
    GMPTEST_EXPECT(res == 0);
    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB()) //filtering via media content (only folders with video content are included)
    {
        GMPTEST_EXPECT(listSize == 3);
    }
    else  //filtering via file type (all folders are included)
    {
        GMPTEST_EXPECT(listSize == 8);
    }

    /* get the list slice */
    vector<tFiles> mediaFileVector;
    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, listSize);
    GMPTEST_EXPECT(res == 0);

    for (tUInt i = 0; i < mediaFileVector.size(); i++)
    {
        ETG_TRACE_USR1(("fileName : %s", mediaFileVector.at(i).fileName));
    }

    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB()) //filtering via media content (only folders with image content are included)
    {
        GMPTEST_EXPECT(mediaFileVector[0].type == FT_IMAGE);
        GMPTEST_EXPECT(mediaFileVector[1].type == FT_IMAGE);
        GMPTEST_EXPECT(mediaFileVector[2].type== FT_IMAGE);

        GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"Art-MP3-A_Stroke_of_Luck.jpg"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[1].fileName,"Art-MP3-Its_Raining_Again.jpg"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[2].fileName,"Art-MP3-Neuland.jpg"));
    }
    else  //filtering via file type (all folders are included)
    {
        GMPTEST_EXPECT(mediaFileVector[0].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[1].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[2].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[3].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[4].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[5].type == FT_IMAGE);
        GMPTEST_EXPECT(mediaFileVector[6].type == FT_IMAGE);
        GMPTEST_EXPECT(mediaFileVector[7].type== FT_IMAGE);

        GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"ID3V1"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[1].fileName,"Supertramp"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[2].fileName,"UCASort"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[3].fileName,"Unheilig"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[4].fileName,"Wolfsheim"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[5].fileName,"Art-MP3-A_Stroke_of_Luck.jpg"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[6].fileName,"Art-MP3-Its_Raining_Again.jpg"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[7].fileName,"Art-MP3-Neuland.jpg"));
    }
}

void MediaPlayerInterfaceTest::CreateMediaPlayerFileList_ImageOnly_SecondLevelDir()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
#ifdef USE_GENERIC_STICK
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB,"USB-4");
    GMPTEST_EXPECT(res == 0);
#else
    tDeviceID deviceID = 3;/*stick_2*/
#endif

    /* create a file list from root directory (Negative test case) */
    strncpy_r(OUT path, IN "/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_IMAGE);

    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 1);
    GMPTEST_EXPECT(numberOfMediaObjects == 0);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 1);

    /* create a file list from invalid root directory (Negative test case) */
    strncpy_r(OUT path, IN "/Test/User1/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_IMAGE);

    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 0);
    GMPTEST_EXPECT(numberOfMediaObjects == 0);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 0);

    /* create a file list from second root directory (Positive test case) */
    strncpy_r(OUT path, IN "/Test/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_IMAGE);

    GMPTEST_EXPECT(res == 0);

    GMPTEST_EXPECT(listSize != 7);
    GMPTEST_EXPECT(listSize == 8);
    GMPTEST_EXPECT(listSize != 9);

    GMPTEST_EXPECT(numberOfMediaObjects != 4);
    GMPTEST_EXPECT(numberOfMediaObjects == 5);
    GMPTEST_EXPECT(numberOfMediaObjects != 6);

    GMPTEST_EXPECT(numberOfPlayLists != 1);
    GMPTEST_EXPECT(numberOfPlayLists == 2);
    GMPTEST_EXPECT(numberOfPlayLists != 3);

    GMPTEST_EXPECT(numberOfFolders != 4);
    GMPTEST_EXPECT(numberOfFolders == 5);
    GMPTEST_EXPECT(numberOfFolders != 6);

    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB()) //filtering via media content (only folders with video content are included)
    {
        GMPTEST_EXPECT(listSize == 3);
    }
    else  //filtering via file type (all folders are included)
    {
        GMPTEST_EXPECT(listSize == 8);
    }

    /* get the list slice */
    vector<tFiles> mediaFileVector;
    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, listSize);
    GMPTEST_EXPECT(res == 0);

    for (tUInt i = 0; i < mediaFileVector.size(); i++)
    {
        ETG_TRACE_USR1(("fileName : %s", mediaFileVector.at(i).fileName));
    }

    if(LocalSPM::GetDataProvider().DBFileBrowsingByDB()) //filtering via media content (only folders with image content are included)
    {
        GMPTEST_EXPECT(mediaFileVector[0].type == FT_IMAGE);
        GMPTEST_EXPECT(mediaFileVector[1].type == FT_IMAGE);
        GMPTEST_EXPECT(mediaFileVector[2].type== FT_IMAGE);

        GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"Art-MP3-A_Stroke_of_Luck_stick4.jpg"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[1].fileName,"Art-MP3-Its_Raining_Again_stick4.jpg"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[2].fileName,"Art-MP3-Neuland_stick4.jpg"));
    }
    else  //filtering via file type (all folders are included)
    {
        GMPTEST_EXPECT(mediaFileVector[0].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[1].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[2].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[3].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[4].type == FT_FOLDER);
        GMPTEST_EXPECT(mediaFileVector[5].type == FT_IMAGE);
        GMPTEST_EXPECT(mediaFileVector[6].type == FT_IMAGE);
        GMPTEST_EXPECT(mediaFileVector[7].type== FT_IMAGE);

        GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"ID3V1_stick4"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[1].fileName,"Supertramp_stick4"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[2].fileName,"UCASort_stick4"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[3].fileName,"Unheilig_stick4"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[4].fileName,"Wolfsheim_stick4"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[5].fileName,"Art-MP3-A_Stroke_of_Luck_stick4.jpg"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[6].fileName,"Art-MP3-Its_Raining_Again_stick4.jpg"));
        GMPTEST_EXPECT(!strcmp(mediaFileVector[7].fileName,"Art-MP3-Neuland_stick4.jpg"));
    }

    /* create a file list from second root directory with invalid deviceID (Negative test case) */
    strncpy_r(OUT path, IN "/Test/", IN sizeof(path));
    deviceID = 13999;
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_IMAGE);

    GMPTEST_EXPECT(res != 0);
    GMPTEST_EXPECT(listSize == 0);
    GMPTEST_EXPECT(numberOfMediaObjects == 0);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 0);
}

void MediaPlayerInterfaceTest::CheckFileListHighlighting()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID1;
    tListSize listSize1;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
#ifdef USE_GENERIC_STICK
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB,"USB-2");
    GMPTEST_EXPECT(res == 0);
#else
    tDeviceID deviceID = 3;/*stick_2*/
#endif


    /* create a file list from root directory */
    strncpy_r(OUT path, IN "/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID1,
            OUT listSize1,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize1 > 1);
    GMPTEST_EXPECT(numberOfFolders > 1);

    /* get the list slice */
    vector<tFiles> mediaFileVector;
    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID1, IN 0, IN listSize1);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaFileVector.size() == listSize1);
    GMPTEST_EXPECT(mediaFileVector[1].type == FT_FOLDER);
    GMPTEST_EXPECT(!strcmp(mediaFileVector[1].fileName,"Supertramp"));

    /* create a file list from subdirectory "Supertramp" */
    tListID listID2;
    tListSize listSize2;
    strncat_r(OUT path, IN mediaFileVector[1].fileName, IN sizeof(path));
    strncat_r(OUT path, IN "/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID2,
            OUT listSize2,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize2 > 0);
    GMPTEST_EXPECT(numberOfFolders > 0);

    /* get the list slice */
    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID2, IN 0, IN listSize2);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaFileVector.size() == listSize2);
    GMPTEST_EXPECT(mediaFileVector[0].type == FT_FOLDER);
    GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"Breakfast_In_America"));

    /* create a file list from subdirectory "Breakfast_In_America" */
    tListID listID3;
    tListSize listSize3;
    strncat_r(OUT path, IN mediaFileVector[0].fileName, IN sizeof(path));
    strncat_r(OUT path, IN "/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID3,
            OUT listSize3,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize3 > 1);
    GMPTEST_EXPECT(numberOfMediaObjects > 1);

    // play second item from the list just created
    tListSize listSize;
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN listID3, IN 1, IN 0);
    GMPTEST_EXPECT(res == 0);

    sleep(1);

    /* get the list slice of playing list */
    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID3, IN 0, IN listSize3);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaFileVector.size() == 3);
    GMPTEST_EXPECT(mediaFileVector[0].type == FT_AUDIO);
    GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"Supertramp_-_Breakfast_in_America_-_01_-_Gone_Hollywood.mp3"));
    GMPTEST_EXPECT(mediaFileVector[0].isPlaying == 0);
    GMPTEST_EXPECT(mediaFileVector[1].type == FT_AUDIO);
    GMPTEST_EXPECT(!strcmp(mediaFileVector[1].fileName,"Supertramp_-_Breakfast_in_America_-_02_-_The_Logical_Song.mp3"));
    GMPTEST_EXPECT(mediaFileVector[1].isPlaying != 0); //playing object
    GMPTEST_EXPECT(mediaFileVector[2].type == FT_AUDIO);
    GMPTEST_EXPECT(!strcmp(mediaFileVector[2].fileName,"Supertramp_-_Breakfast_in_America_-_03_-_Goodbye_Stranger.mp3"));
    GMPTEST_EXPECT(mediaFileVector[2].isPlaying == 0);

    /* get the list slice of first parent list */
    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID2, IN 0, IN listSize2);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaFileVector.size() == 2);
    GMPTEST_EXPECT(mediaFileVector[0].type == FT_FOLDER);
    GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"Breakfast_In_America"));
    GMPTEST_EXPECT(mediaFileVector[0].isPlaying != 0); //playing object
    GMPTEST_EXPECT(mediaFileVector[1].type == FT_AUDIO);
    GMPTEST_EXPECT(!strcmp(mediaFileVector[1].fileName,"Supertramp_-_Singles_-_00_-_Its_Raining_Again.mp3"));
    GMPTEST_EXPECT(mediaFileVector[1].isPlaying == 0);

    /* get the list slice of second parent list (root directory) */
    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID1, IN 0, IN listSize1);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaFileVector.size() > 1);
    GMPTEST_EXPECT(mediaFileVector[0].type == FT_FOLDER);
    GMPTEST_EXPECT(!strcmp(mediaFileVector[0].fileName,"ID3V1"));
    GMPTEST_EXPECT(mediaFileVector[0].isPlaying == 0);
    GMPTEST_EXPECT(mediaFileVector[1].type == FT_FOLDER);
    GMPTEST_EXPECT(!strcmp(mediaFileVector[1].fileName,"Supertramp"));
    GMPTEST_EXPECT(mediaFileVector[1].isPlaying != 0); //playing object
    //...
}

void MediaPlayerInterfaceTest::PlayMediaPlayerObject()
{
    ENTRY_TEST

    tResult res = -1;
    tListID listID;
    tListSize listSize;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tListID listID1;
    vector<tMediaObject> mediaObjectVector;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    // set the filter tags
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    // create the first list
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID1,
            OUT listSize,
            IN LTY_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    // test result
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize > 0);

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID1, 0, 12);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);

    res = mMediaPlayerInterface.PlayMediaPlayerObject(OUT listID, OUT listSize, IN mediaObjectVector[0].objectID, IN playContinuation);
    GMPTEST_EXPECT(res == 0);
    //GMPTEST_EXPECT(listID == MediaObjecttListID);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    tNowPlaying nowPlaying;
    res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
    GMPTEST_EXPECT(res == 0);

    ETG_TRACE_USR1(("nowplaying listidt: %d ", nowPlaying.listID));
    ETG_TRACE_USR1(("nowplaying object id : %d ", nowPlaying.object.objectID));
    ETG_TRACE_USR1(("nowplaying state as : %d ", nowPlaying.state));
}

void MediaPlayerInterfaceTest::PlayMediaPlayerObjectRepeat()
{
    ENTRY_TEST

    tResult res = -1;
    tListID listID;
    tListSize listSize;
    vector<tMediaObject> mediaObjectVector;
    tPlayContinuation playContinuation = PC_REPEAT_CURRENT_LEVEL;
    tNowPlaying nowPlaying;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tListID listID1;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    // set the filter tags
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    // create the first list
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID1,
            OUT listSize,
            IN LTY_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    // test result
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize > 0);

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID1, 0, 12);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);

    res = LocalSPM::GetCustomControl().PlayMediaPlayerObject(OUT listID, OUT listSize, IN mediaObjectVector[0].objectID, IN playContinuation);
    GMPTEST_EXPECT(res == 0);
    //GMPTEST_EXPECT(listID == MediaObjecttListID);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);

    ETG_TRACE_USR1(("nowplaying listidt: %d ", nowPlaying.listID));
    ETG_TRACE_USR1(("nowplaying object id : %d ", nowPlaying.object.objectID));
    ETG_TRACE_USR1(("nowplaying state as : %d ", nowPlaying.state));
}

void MediaPlayerInterfaceTest::PlayMediaPlayerObjectWithSourceDeallocationOff()
{
    ENTRY_TEST

    SendSourceActivityOff();

    tResult res = -1;
    tListID listID;
    tListSize listSize;
    vector<tMediaObject> mediaObjectVector;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tListID listID1;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    // set the filter tags
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    // create the first list
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID1,
            OUT listSize,
            IN LTY_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    // test result
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize > 0);

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID1, 0, 12);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);

    res = LocalSPM::GetCustomControl().PlayMediaPlayerObject(OUT listID, OUT listSize, IN mediaObjectVector[0].objectID, IN playContinuation);
    GMPTEST_EXPECT(res == 0);
    //GMPTEST_EXPECT(listID == MediaObjecttListID);

    tNowPlaying nowPlaying;
    res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);

    ETG_TRACE_USR1(("nowplaying listidt: %d ", nowPlaying.listID));
    ETG_TRACE_USR1(("nowplaying object id : %d ", nowPlaying.object.objectID));
    ETG_TRACE_USR1(("nowplaying state as : %d ", nowPlaying.state));

    SendSourceActivityOn();

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);
}

void MediaPlayerInterfaceTest::PlayMediaPlayerObjectWithSourceDeallocationOffAndOn()
{
    ENTRY_TEST

    SendSourceActivityOff();

    tResult res = -1;
    tListID listID;
    tListSize listSize;
    vector<tMediaObject> mediaObjectVector;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tListID listID1;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    // set the filter tags
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    // create the first list
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID1,
            OUT listSize,
            IN LTY_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    // test result
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize > 0);

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID1, 0, 12);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);

    res = LocalSPM::GetCustomControl().PlayMediaPlayerObject(OUT listID, OUT listSize, IN mediaObjectVector[0].objectID, IN playContinuation);
    GMPTEST_EXPECT(res == 0);
    //GMPTEST_EXPECT(listID == MediaObjecttListID);

    SendSourceActivityOn();

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    tNowPlaying nowPlaying;
    res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);

    ETG_TRACE_USR1(("nowplaying listidt: %d ", nowPlaying.listID));
    ETG_TRACE_USR1(("nowplaying object id : %d ", nowPlaying.object.objectID));
    ETG_TRACE_USR1(("nowplaying state as : %d ", nowPlaying.state));
}

void MediaPlayerInterfaceTest::PlayMediaPlayerObjectInvalidObjectId()
{
    ENTRY_TEST

    tResult res = -1;
    tListID listID;
    tListSize listSize;
    vector<tMediaObject> mediaObjectVector;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tListID listID1;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tObjectID objectID = OBJECT_ID_NONE;

    // set the filter tags
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    // create the first list
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID1,
            OUT listSize,
            IN LTY_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    // test result
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize > 0);

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID1, 0, 12);
    GMPTEST_EXPECT(res == 0);

    res = LocalSPM::GetCustomControl().PlayMediaPlayerObject(OUT listID, OUT listSize, IN objectID, IN playContinuation);
    GMPTEST_EXPECT(res != 0);
    //GMPTEST_EXPECT(listID == MediaObjecttListID);
}

void MediaPlayerInterfaceTest::PlayMediaPlayerObjectTwice()
{
    ENTRY_TEST

    tResult res = -1;
    tListID listID;
    tListSize listSize;
    vector<tMediaObject> mediaObjectVector;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tListID listID1;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    // set the filter tags
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    // create the first list
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID1,
            OUT listSize,
            IN LTY_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    // test result
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize > 0);

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID1, 0, 12);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);

    res = LocalSPM::GetCustomControl().PlayMediaPlayerObject(OUT listID, OUT listSize, IN mediaObjectVector[0].objectID, IN playContinuation);
    GMPTEST_EXPECT(res == 0);
    //GMPTEST_EXPECT(listID == MediaObjecttListID);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    tNowPlaying nowPlaying;
    res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);

    ETG_TRACE_USR1(("nowplaying listidt: %d ", nowPlaying.listID));
    ETG_TRACE_USR1(("nowplaying object id : %d ", nowPlaying.object.objectID));
    ETG_TRACE_USR1(("nowplaying state as : %d ", nowPlaying.state));

    res = LocalSPM::GetCustomControl().PlayMediaPlayerObject(OUT listID, OUT listSize, IN mediaObjectVector[0].objectID, IN playContinuation);
    GMPTEST_EXPECT(res == 0);
    //GMPTEST_EXPECT(listID == MediaObjecttListID);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
    //GMPTEST_EXPECT(res == 0);
}

/*void MediaPlayerInterfaceTest::GetPlaytime()
{
    ENTRY_TEST

    tResult res = -1;
    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;

    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(totalPlaytime > 0);
}

void MediaPlayerInterfaceTest::GetPlayback()
{
    ENTRY_TEST

    tResult res = -1;
    tHMIPlaybackState playstatus;

    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(HMI_PBS_STOPPED == playstatus);
}*/

void MediaPlayerInterfaceTest::GetNowPlayingWithoutFileCurrentlyPlaying()
{
    ENTRY_TEST

    SendPlaybackActionStop();

    //Intended to get the values when no file is playing
    tResult res = -1;
    tNowPlaying nowPlaying;

    res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(nowPlaying.object.objectID > 0);
    GMPTEST_EXPECT(nowPlaying.state > 0);
}

void MediaPlayerInterfaceTest::GetPlaytimeWithoutFileCurrentlyPlaying()
{
    ENTRY_TEST

    SendPlaybackActionStop();

    //Intended to get the values when no file is playing
    tResult res = -1;
    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;

    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(totalPlaytime > 0);
}

void MediaPlayerInterfaceTest::GetPlaybackStateWithoutFileCurrentlyPlaying()
{
    ENTRY_TEST

    SendPlaybackActionStop();

    //Intended to get the values when no file is playing
    tResult res = -1;
    tHMIPlaybackState playstatus;

    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(HMI_PBS_STOPPED == playstatus);
}

void MediaPlayerInterfaceTest::RequestMediaPlayerFileListSlice()
{
    ENTRY_TEST

    tResult res = -1;
    tListID fileListID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set the path */
    strncpy_r(OUT path, IN "/", IN sizeof(path));

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* create a file list from root directory */
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT fileListID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize > 0);

    /* get the list slice */
    vector<tFiles> mediaFileVector; /* resulting entries */
    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN fileListID, 0, 10);
    GMPTEST_EXPECT(res == 0);

    /* check the resulting entries */
    GMPTEST_EXPECT(mediaFileVector.size() == 7);
    GMPTEST_EXPECT(strcmp(mediaFileVector[0].fileName, "albumart") == 0);
    GMPTEST_EXPECT(mediaFileVector[0].type == FT_FOLDER);
    GMPTEST_EXPECT(strcmp(mediaFileVector[1].fileName, "music") == 0);
    GMPTEST_EXPECT(mediaFileVector[1].type == FT_FOLDER);
    GMPTEST_EXPECT(strcmp(mediaFileVector[2].fileName, "playlists") == 0);
    GMPTEST_EXPECT(mediaFileVector[2].type == FT_FOLDER);
    GMPTEST_EXPECT(strcmp(mediaFileVector[3].fileName, "video") == 0);
    GMPTEST_EXPECT(mediaFileVector[3].type == FT_FOLDER);
    GMPTEST_EXPECT(strcmp(mediaFileVector[4].fileName, "Garbage-Garbage-01-Supervixen.MP3") == 0);
    GMPTEST_EXPECT(mediaFileVector[4].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[4].fileFormat == FFT_MP3);
    GMPTEST_EXPECT(strcmp(mediaFileVector[5].fileName, "Garbage-Garbage-02-Queer.MP3") == 0);
    GMPTEST_EXPECT(mediaFileVector[5].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[5].fileFormat == FFT_MP3);
    GMPTEST_EXPECT(strcmp(mediaFileVector[6].fileName, "Garbage-Garbage-03-Only_Happy_When_It_Rains.MP3") == 0);
    GMPTEST_EXPECT(mediaFileVector[6].type == FT_AUDIO);
    GMPTEST_EXPECT(mediaFileVector[6].fileFormat == FFT_MP3);
}

void MediaPlayerInterfaceTest::PlayItemFromFileList()
{
    ENTRY_TEST

    tResult res = -1;
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
    tDeviceID deviceID;
    /* set the path */
    strncpy_r(OUT path, IN "/", IN sizeof(path));

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    /* play item from the file list created in the previous testcase */
    listSize = 0;
    res= mMediaPlayerInterface.PlayItemFromList(OUT listSize , IN listID, 5, 0);
    GMPTEST_EXPECT(res == 0);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    tNowPlaying nowPlaying;
    res= mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
    GMPTEST_EXPECT(res == 0);
    VARTRACE(nowPlaying);
    GMPTEST_EXPECT(!strcmp("/Garbage-Garbage-02-Queer.MP3",nowPlaying.object.fileName));
}

void MediaPlayerInterfaceTest::PlayItemFromCDList()
{
    ENTRY_TEST

    tResult res = -1;
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
    tDeviceID deviceID;
    /* set the path */
    strncpy_r(OUT path, IN "/", IN sizeof(path));

    /* Enable CDDA as supported device type */
    int supportedDeviceType_06 = LocalSPM::GetDataProvider().SupportedDeviceType_06();
    if (DTY_CDDA != (tDeviceType)supportedDeviceType_06)
    {
        LocalSPM::GetDataProvider().SupportedDeviceType_06 = (int)DTY_CDDA;
    }

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_CDDA, "CDDA");
    GMPTEST_EXPECT(res == 0);

    res = mMediaPlayerInterface.CreateMediaPlayerCDList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    /* play item from the file list created in the previous testcase */
    listSize = 0;
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN listID, 5, 0);
    GMPTEST_EXPECT(res == 0);

    res = WaitForListID(IN listID);
    GMPTEST_EXPECT(res == 0);

    tNowPlaying nowPlaying;
    res= mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
    GMPTEST_EXPECT(res == 0);
    VARTRACE(nowPlaying);
    GMPTEST_EXPECT(!strcmp("file6.cda",nowPlaying.object.fileName));

    /* Reset configuration */
    LocalSPM::GetDataProvider().SupportedDeviceType_06 = supportedDeviceType_06;
}

void MediaPlayerInterfaceTest::RequestMediaPlayerFileListSliceInvalidListId()
{
    ENTRY_TEST

    tResult res = -1;
    vector<tFiles> mediaFileVector; /* resulting entries */

    /* get the list slice */
    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN LIST_ID_NONE, 0, 10);
    GMPTEST_EXPECT(res == MP_ERR_LC_UNDEFINED_LIST_ID);
}

void MediaPlayerInterfaceTest::ReleaseMediaPlayerList()
{
    ENTRY_TEST

    tResult res = -1;
    tListID listID1 = LIST_ID_NONE;
    tListSize listSize = 0;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;

    vector<tMediaObject> mediaObjectVector;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    // set the filter tags
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    // create the first list
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID1,
            OUT listSize,
            IN LTY_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    // test result
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize > 0);

    /* delete first list */
    res = LocalSPM::GetListControl().ReleaseList(IN listID1, true/*force*/);
    GMPTEST_EXPECT(res == 0);

    mediaObjectVector.clear();
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID1,
            0,
            12);
    GMPTEST_EXPECT(res == MP_ERR_LC_UNDEFINED_LIST_ID);
    GMPTEST_EXPECT(mediaObjectVector.size() == 0);
}

void MediaPlayerInterfaceTest::ReleaseMediaPlayerListwithInvalidListId()
{
    ENTRY_TEST

    tResult res = -1;
    tListID listID = -1234;

    res = LocalSPM::GetListControl().ReleaseList(IN listID, true/*force*/);
    GMPTEST_EXPECT(res != 0);
}

void MediaPlayerInterfaceTest::ReleaseActiveMediaPlayerList()
{
    ENTRY_TEST

    tResult res = -1;
    tListInfo listInfo;
    tListType listType = LTY_GENRE_ARTIST_ALBUM_SONG;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set parameters */
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.genre = genre;
    tag2.artist = artist;
    tag3.tag = 0x0;
    tag4.album = album;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* test */
    res = mMediaPlayerInterface.CreateQuickPlayList(
            OUT listInfo,
            IN listType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN playContinuation,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("obtained List id in CreateQuickPlayList: %d ", listInfo.listID));

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    tNowPlaying nowPlaying;
    res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);

    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("obtained List id in nowPlaying: %d ", nowPlaying.listID));

    GMPTEST_EXPECT(nowPlaying.listID == listInfo.listID);

    res = LocalSPM::GetListControl().ReleaseList(listInfo.listID, true/*force*/);
    GMPTEST_EXPECT(res == 0);
}

void MediaPlayerInterfaceTest::GetNowPlayingOnReleasedList()
{
    ENTRY_TEST

    //Intended to get the values when a list is released
    tResult res = -1;
    tNowPlaying nowPlaying;

    res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(OBJECT_ID_NONE != nowPlaying.object.objectID);
}

void MediaPlayerInterfaceTest::GetPlaytimeOnReleasedList()
{
    ENTRY_TEST

    //Intended to get the values when a list is relaesed
    tResult res = -1;
    tPlaytime elapsedPlaytime;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;

    res = mMediaPlayerInterface.GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(totalPlaytime > 0);
}

void MediaPlayerInterfaceTest::GetPlaybackStateOnReleasedList()
{
    ENTRY_TEST

    //Intended to get the values when a list is relaesed
    tResult res = -1;
    tHMIPlaybackState playstatus;

    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    GMPTEST_EXPECT(res == 0);
}

void MediaPlayerInterfaceTest::RequestListInformation()
{
    ENTRY_TEST

    tResult res = -1;
    tListType listType;
    tListID parentListID;
    tDeviceID deviceIDtemp;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tPosition position;
    tListSize listSizeTemp;
    tPath path;

    /* Check if listID is valid */
    GMPTEST_EXPECT(LIST_ID_NONE != mListID);

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* get the list information */
    res = mMediaPlayerInterface.RequestListInformation(
            OUT listType,
            OUT parentListID,
            OUT deviceIDtemp,
            OUT position,
            OUT listSizeTemp,
            OUT path,
            IN mListID);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listType == LTY_SONG);
    GMPTEST_EXPECT(deviceIDtemp == deviceID);//check member values
    GMPTEST_EXPECT(listSizeTemp > 0);
}

void MediaPlayerInterfaceTest::RequestListInformationInvalidListId()
{
    ENTRY_TEST

    tListType listType;
    tListID parentListID;
    tDeviceID deviceIDtemp;
    tPosition position;
    tListSize listSizeTemp;
    tPath path;

    /* get the list information */
    tResult res = mMediaPlayerInterface.RequestListInformation(
            OUT listType,
            OUT parentListID,
            OUT deviceIDtemp,
            OUT position,
            OUT listSizeTemp,
            OUT path,
            LIST_ID_NONE);
    GMPTEST_EXPECT(res != 0);
}

void MediaPlayerInterfaceTest::SearchKeyboardMediaPlayerListInvalidListId()
{
    ENTRY_TEST

    vector<tSearchKeyboard> searchKeyboardList;
    tResult res = -1;

    res = mMediaPlayerInterface.SearchKeyboardMediaPlayerList(OUT searchKeyboardList, IN LIST_ID_NONE);
    GMPTEST_EXPECT(res != 0);
}

void MediaPlayerInterfaceTest::SearchKeyboardMediaPlayerList()
{
    ENTRY_TEST

    vector<tSearchKeyboard> searchKeyboardList;
    tResult res = -1;

    res = mMediaPlayerInterface.SearchKeyboardMediaPlayerList(OUT searchKeyboardList, IN mListID);
    GMPTEST_EXPECT(res == 0);

    GMPTEST_EXPECT(searchKeyboardList[/*'A' - 'A'+*/1].available == true);  //comment out to avoid lint warning Info 778
    GMPTEST_EXPECT(searchKeyboardList['D' - 'A'+1].available == true);
    GMPTEST_EXPECT(searchKeyboardList['F' - 'A'+1].available == true);
    GMPTEST_EXPECT(searchKeyboardList['M' - 'A'+1].available == true);
    GMPTEST_EXPECT(searchKeyboardList['N' - 'A'+1].available == true);
    GMPTEST_EXPECT(searchKeyboardList['O' - 'A'+1].available == true);
    GMPTEST_EXPECT(searchKeyboardList['Q' - 'A'+1].available == true);
    GMPTEST_EXPECT(searchKeyboardList['S' - 'A'+1].available == true);
    GMPTEST_EXPECT(searchKeyboardList['V' - 'A'+1].available == true);
}

void MediaPlayerInterfaceTest::GetMediaObject()
{
    ENTRY_TEST

    tResult res = -1;

    //create an all song list and find album "Garbage"
    tListID listID;
    tListSize listSize;
    tFilterTag1 tag1 = { 0 };
    tFilterTag2 tag2 = { 0 };
    tFilterTag3 tag3 = { 0 };
    tFilterTag4 tag4 = { 0 };
    vector<tMediaObject> mediaObjectVector;
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            MY_MEDIA);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 31);

    /* get the first contents */
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 1);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);
    GMPTEST_EXPECT(!strcmp(mediaObjectVector[0].MetadataField4, "Garbage"));

    // set the filter tags
    tMediaObjectID objectID = mediaObjectVector[0].objectID; // must be a song tag

    mediaObjectVector.clear();
    res = mMediaPlayerInterface.ReleaseList(IN listID);
    GMPTEST_EXPECT(res == 0);

    tCategoryType categoryType = CTY_SONG;
    tMediaObject mediaObject;
    InitMediaObject(OUT mediaObject);

    res = mMediaPlayerInterface.GetMediaObject(OUT mediaObject, IN objectID, IN categoryType);
    GMPTEST_EXPECT(res == 0);

    ETG_TRACE_USR1(("Current File : %64s", mediaObject.fileName));

    GMPTEST_EXPECT(strcmp(mediaObject.fileName, "/music/Garbage/Garbage-Garbage-06-A_Stroke_of_Luck.mp3") == 0);
}

/*void MediaPlayerInterfaceTest::GetMediaObjectInvalidId()
{
    ENTRY_TEST

    tResult res = -1;
    tMediaObject mediaObject;
    tCategoryType categoryType = CTY_NONE;

    InitMediaObject(OUT mediaObject);

    res = mMediaPlayerInterface.GetMediaObject(OUT mediaObject, IN categoryType);
    ETG_TRACE_USR1(( "Current File : %64s, elapsedPlaytime : %d, res : %d", mediaObject.fileName, mediaObject.elapsedPlaytime, res));

    GMPTEST_EXPECT(res != 0);
}*/

void MediaPlayerInterfaceTest::GetMediaObjectAlbumArtInfoCallback(cTestData *objTestData)
{
    ENTRY_INTERNAL

    if(objTestData !=NULL)
    {
        switch(objTestData->eMSGTYPE)
        {
            case EV_GETMEDIAOBJECTALBUMINFOANSWER:
                ETG_TRACE_USR1(( "EV_GETMEDIAOBJECTALBUMINFOANSWER Switch case" ));
                //if(objTestData->size == 15004)
                {
                    nresultObatined = 0;
                }
                ETG_TRACE_USR1(("*** Unlocking Mutex ***"));
                ASYNC_WAIT_RELEASE
                break;
            case EV_GETMEDIAOBJECTALBUMARTANSWER:
                ETG_TRACE_USR1(( "EV_GETMEDIAOBJECTALBUMARTANSWER Switch case" ));
                //if(objTestData->size == 11993)
                {
                    nresultObatined = 0;
                }
                ETG_TRACE_USR1(("*** Unlocking Mutex ***"));
                ASYNC_WAIT_RELEASE
                break;
            default:
                break;
        }
    }
}

void MediaPlayerInterfaceTest::testCallback(cTestData *objTestData)
{
    ENTRY
    (this->*funPtr)(objTestData);
}

void MediaPlayerInterfaceTest::GetMediaObjectAlbumArtInfo()
{
    ENTRY_TEST

    tResult res = -1;
    vector<tMediaObject> mediaObjectVector;
    tUserContext userContext;

    tListInfo listInfo;
    tListType listType = LTY_GENRE_ARTIST_ALBUM_SONG;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set parameters */
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;

    tag1.genre = genre;
    tag2.artist = artist;
    tag3.tag = 0x0;
    tag4.album = album;

    this->m_strTestcase = "GetMediaObjectAlbumArtInfo";
    this->bLetFWValidateResult = false ;
    nresultObatined = -1;
    //Test Bench call

    CListener *oListener = CListener::getCListenerInstance();
    oListener->registerCallback(this);
    oListener->startListen();
    oListener->registerEvent(EV_GETMEDIAOBJECTALBUMINFOANSWER);
    MediaPlayerInterfaceTest::funPtr =  &MediaPlayerInterfaceTest::GetMediaObjectAlbumArtInfoCallback;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* test */
    res = mMediaPlayerInterface.CreateQuickPlayList(
            OUT listInfo,
            IN listType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN playContinuation,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("obtained List id in CreateQuickPlayList: %d ", listInfo.listID));

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    /* get the first contents */
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listInfo.listID, 0, 12);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);

    /* get the device info for the media object */
    tDeviceInfo deviceInfo;
    res = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN mediaObjectVector[0].deviceID);
    GMPTEST_EXPECT(res == 0);

    /* create the compare string */
    char compareString[1024];
    strncpy_r(OUT compareString, IN deviceInfo.mountPoint, IN sizeof(compareString));
    strncat_r(OUT compareString, IN "/music/Garbage/Garbage-Garbage-06-A_Stroke_of_Luck.mp3", IN sizeof(compareString));

    /* search for row of "A Stroke of Luck" (has album art) */
    tUInt row;
    for(row = 0; row < mediaObjectVector.size(); row++) {
        if (!strcmp(mediaObjectVector[row].albumArtString, compareString)) break;
    }
    GMPTEST_EXPECT(row < mediaObjectVector.size());

    /* ask for album art information*/
    userContext.sourceAppID = 0x109;
    userContext.registerID = 0x4;
    userContext.cmdCounter = 0x1;
    userContext.functionID = 0x1234;
    userContext.serviceID = 0x0;

    res = mMediaPlayerInterface.GetMediaObjectAlbumArtInfo(IN mediaObjectVector[row].albumArtString, 128, 128, MMT_JPG, IN userContext);
    GMPTEST_EXPECT(res == 0);

    sleep(3);
    ASYNC_WAIT_START(1);

    GMPTEST_EXPECT(nresultObatined == 0);
    oListener->stopListen();
    delete oListener;

    res = mMediaPlayerInterface.ReleaseList(IN listInfo.listID);
    GMPTEST_EXPECT(res == 0);
}

void MediaPlayerInterfaceTest::GetMediaObjectAlbumArtInfoInvalidAlbumArtString()
{
    ENTRY_TEST

    tResult res = -1;
    tUserContext userContext;
    tFilename fileName;
    strncpy_r(OUT fileName, IN "/opt/bosch/test/data/GMP/test/hello.mp3", IN sizeof(fileName));

    ETG_TRACE_USR1(("The File Name : %s", fileName));

    this->m_strTestcase = "GetMediaObjectAlbumArtInfo";
    this->bLetFWValidateResult = false ;
    nresultObatined = -1;
    //Test Bench call

    CListener *oListener = CListener::getCListenerInstance();
    oListener->registerCallback(this);
    oListener->startListen();
    oListener->registerEvent(EV_GETMEDIAOBJECTALBUMINFOANSWER);
    MediaPlayerInterfaceTest::funPtr =  &MediaPlayerInterfaceTest::GetMediaObjectAlbumArtInfoCallback;

    /* ask for album art information*/
    userContext.sourceAppID = 0x109;
    userContext.registerID = 0x4;
    userContext.cmdCounter = 0x1;
    userContext.functionID = 0x1234;

    res = mMediaPlayerInterface.GetMediaObjectAlbumArtInfo(IN fileName, 128, 128, MMT_JPG, IN userContext);
    GMPTEST_EXPECT(res == 0);

    ASYNC_WAIT_START(1);
    GMPTEST_EXPECT(nresultObatined != 0);
    oListener->stopListen();
    delete oListener;
}

void MediaPlayerInterfaceTest::GetMediaObjectAlbumArt()
{
    ENTRY_TEST

    tResult res = -1;
    vector<tMediaObject> mediaObjectVector;
    tUserContext userContext;

    tListInfo listInfo;
    tListType listType = LTY_GENRE_ARTIST_ALBUM_SONG;
    tPlayContinuation playContinuation = PC_NO_REPEAT;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    memset(&userContext, 0, sizeof(userContext));

    /* set parameters */
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;

    tag1.genre = genre;
    tag2.artist = artist;
    tag3.tag = 0x0;
    tag4.album = album;

    this->m_strTestcase = "GetMediaObjectAlbumArt";
    this->bLetFWValidateResult = false ;
    nresultObatined = -1;
    //Test Bench call

    CListener *oListener = CListener::getCListenerInstance();
    oListener->registerCallback(this);
    oListener->startListen();
    oListener->registerEvent(EV_GETMEDIAOBJECTALBUMARTANSWER);
    MediaPlayerInterfaceTest::funPtr =  &MediaPlayerInterfaceTest::GetMediaObjectAlbumArtInfoCallback;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);

    /* test */
    res = mMediaPlayerInterface.CreateQuickPlayList(
            OUT listInfo,
            IN listType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN playContinuation,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("obtained List id in CreateQuickPlayList: %d ", listInfo.listID));

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    /* get the first contents */
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listInfo.listID, 0, 12);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 0);

    /* get the device info for the media object */
    tDeviceInfo deviceInfo;
    res = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN mediaObjectVector[0].deviceID);
    GMPTEST_EXPECT(res == 0);

    /* create the compare string */
    char compareString[1024];
    strncpy_r(OUT compareString, IN deviceInfo.mountPoint, IN sizeof(compareString));
    strncat_r(OUT compareString, IN "/music/Garbage/Garbage-Garbage-06-A_Stroke_of_Luck.mp3", IN sizeof(compareString));

    /* search for row of "A Stroke of Luck" (has album art) */
    tUInt row;
    for(row = 0; row < mediaObjectVector.size(); row++) {
        if (!strcmp(mediaObjectVector[row].albumArtString, compareString)) break;
    }
    GMPTEST_EXPECT(row < mediaObjectVector.size());

    /* ask for album art information*/
    userContext.sourceAppID = 0x109;
    userContext.registerID = 0x4;
    userContext.cmdCounter = 0x1;
    userContext.functionID = 0x1234;

    res = mMediaPlayerInterface.GetMediaObjectAlbumArt(IN mediaObjectVector[row].albumArtString, 128, 128, MMT_JPG, IN userContext);
    GMPTEST_EXPECT(res == 0);

    sleep(3);
    ASYNC_WAIT_START(1);

    GMPTEST_EXPECT(nresultObatined == 0);
    oListener->stopListen();
    delete oListener;

    res = mMediaPlayerInterface.ReleaseList(IN listInfo.listID);
    GMPTEST_EXPECT(res == 0);
}

void MediaPlayerInterfaceTest::GetMediaObjectAlbumArtInvalidAlbumArtString()
{
    ENTRY_TEST

    tResult res = -1;
    tUserContext userContext;
    tFilename fileName;
    strncpy_r(OUT fileName, IN "/opt/bosch/test/data/GMP/test/hello.mp3", IN sizeof(fileName));

    ETG_TRACE_USR1(("The File Name : %s", fileName));

    this->m_strTestcase = "GetMediaObjectAlbumArt";
    this->bLetFWValidateResult = false ;
    nresultObatined = -1;
    //Test Bench call

    CListener *oListener = CListener::getCListenerInstance();
    oListener->registerCallback(this);
    oListener->startListen();
    oListener->registerEvent(EV_GETMEDIAOBJECTALBUMARTANSWER);
    MediaPlayerInterfaceTest::funPtr =  &MediaPlayerInterfaceTest::GetMediaObjectAlbumArtInfoCallback;

    /* ask for album art information*/
    userContext.sourceAppID = 0x109;
    userContext.registerID = 0x4;
    userContext.cmdCounter = 0x1;
    userContext.functionID = 0x1234;

    res = mMediaPlayerInterface.GetMediaObjectAlbumArt(IN fileName, 128, 128, MMT_JPG, IN userContext);
    GMPTEST_EXPECT(res == 0);

    ASYNC_WAIT_START(1);
    GMPTEST_EXPECT(nresultObatined != 0);
    oListener->stopListen();
    delete oListener;
}

void MediaPlayerInterfaceTest::PlayItemFromListDefaultIndexOffset()
{
    ENTRY_TEST

    tResult res = -1;
    /* Check if listID is valid */
    GMPTEST_EXPECT(LIST_ID_NONE != mListID);

    /* Call PlayItemFromList */
    tListSize listSize = 0;
    //tIndex index = INDEX_LAST_ACTIVE_OBJECT;
    tIndex index = 1;
    tPlaytime offset = 0;
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN mListID, IN index, IN offset);
    // test result
    GMPTEST_EXPECT(res == 0);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    // Call GetPlaybackState to check the current playback state of the MediaPlayer
    tHMIPlaybackState playstatus;
    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1((" PlayItemFromListDefaultIndexOffset::GetPlaybackState Action : %d ", playstatus));
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);
}

void MediaPlayerInterfaceTest::PlayItemFromListDefaultIndex()
{
    ENTRY_TEST

    tResult res = -1;
    /* Check if listID is valid */
    GMPTEST_EXPECT(LIST_ID_NONE != mListID);

    /* Call PlayItemFromList */
    tListSize listSize = 0;
    tIndex index = 1;
    tPlaytime offset = 2000;
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN mListID, IN index, IN offset);
    // test result
    GMPTEST_EXPECT(res == 0);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    // Call GetPlaybackState to check the current playback state of the MediaPlayer
    tHMIPlaybackState playstatus;
    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1((" PlayItemFromListDefaultIndex::GetPlaybackState Action : %d ", playstatus));
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);
}

void MediaPlayerInterfaceTest::PlayItemFromListWithAudioTurnedOff()
{
    ENTRY_TEST

    tResult res = -1;
    /* Check if listID is valid */
    GMPTEST_EXPECT(LIST_ID_NONE != mListID);

    // Call SendSourceActivityOff to set the source to SA_OFF
    SendSourceActivityOff();

    /* Call PlayItemFromList */
    tListSize listSize = 0;
    tIndex index = 1;
    tPlaytime offset = 2000;
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN mListID, IN index, IN offset);
    // test result
    GMPTEST_EXPECT(res == 0);

    sleep(2);

    // Call GetPlaybackState to check the current playback state of the MediaPlayer
    tHMIPlaybackState playstatus;
    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("GetPlaybackState Action : %d ", playstatus));
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_STOPPED);
}

void MediaPlayerInterfaceTest::PlayItemFromListWithAudioTurnedOffAndOn()
{
    ENTRY_TEST

    tResult res = -1;

    // Call SendSourceActivityon to set the source to SA_ON
    SendSourceActivityOn();

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    WAIT_FOR_HMI_STATE(HMI_PBS_PLAYING, 30);

    // Call GetPlaybackState to check the current playback state of the MediaPlayer
    tHMIPlaybackState playstatus;
    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("GetPlaybackState Action : %d ", playstatus));
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);
}

void MediaPlayerInterfaceTest::PlayItemFromListInvalidListId()
{
    ENTRY_TEST

    tResult res = -1;
    tListID listIDEmpty = LIST_ID_NONE;

    // Call GetPlaybackState to check the last playback state of the MediaPlayer
    tHMIPlaybackState lastPlaystatus;
    res = mMediaPlayerInterface.GetPlaybackState(OUT lastPlaystatus);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("PlayItemFromListInvalidListId::GetPlaybackState Action : %d ", lastPlaystatus));

    /* Call PlayItemFromList */
    tListSize listSize = 0;
    tIndex index = 3;
    tPlaytime offset = 85000;
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN listIDEmpty, IN index, IN offset);
    // test result
    GMPTEST_EXPECT(res != 0);

    //res = WaitForPlaytimeUpdate();
    //GMPTEST_EXPECT(res == 0);

    // Call GetPlaybackState to check the current playback state of the MediaPlayer
    tHMIPlaybackState currentPlaystatus;
    res = mMediaPlayerInterface.GetPlaybackState(OUT currentPlaystatus);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("PlayItemFromListInvalidListId::GetPlaybackState Action : %d ", currentPlaystatus));

    GMPTEST_EXPECT(lastPlaystatus == currentPlaystatus);
}

void MediaPlayerInterfaceTest::GetMediaplayerDeviceConnections()
{
    ENTRY_TEST

    tResult res = -1;
    tNumberOfDevices numberOfDevices;
    vector<tDeviceInfo> deviceInfoList;

    res = mMediaPlayerInterface.GetMediaplayerDeviceConnections(OUT numberOfDevices, OUT deviceInfoList);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(numberOfDevices >= 4); // this test must run with custom control test on, there a device will be deleted
}
/************** Interface Test Case Ended ******************/

void MediaPlayerInterfaceTest::SendAllocateInvalidAudioDevice()
{
    ENTRY_TEST
}

void MediaPlayerInterfaceTest::SendDeAllocateInvalidAudioDevice()
{
    ENTRY_TEST
}

void MediaPlayerInterfaceTest::SendPlaybackActionFstRev()
{
    ENTRY_TEST

    tResult res = -1;

    tNextPrevSkipCount steps = 1;
    res = mMediaPlayerInterface.SendPlaybackAction(PBA_FREV_START, IN steps);
    // test result
    GMPTEST_EXPECT(res == 0);

    sleep(5);

    res = mMediaPlayerInterface.SendPlaybackAction(PBA_FREV_STOP, IN steps);
    GMPTEST_EXPECT(res == 0);
}

void MediaPlayerInterfaceTest::SendPlaybackActionFstForward()
{
    ENTRY_TEST

    tResult res = -1;

    tNextPrevSkipCount steps = 1;
    res = mMediaPlayerInterface.SendPlaybackAction(PBA_FFWD_START, IN steps);
    // test result
    GMPTEST_EXPECT(res == 0);

    sleep(5);

    res = mMediaPlayerInterface.SendPlaybackAction(PBA_FFWD_STOP, IN steps);
    GMPTEST_EXPECT(res == 0);
}

void MediaPlayerInterfaceTest::ConnectDeviceUSBStick()
{
    ENTRY_TEST

    tResult res = -1;
    tDeviceInfo deviceInfoItem;
    vector<tDeviceInfo> deviceInfos;
    tUndervoltage undervoltage = false;

    //Example output of deviceManager
    //<dragon@usb1>(core0)VD_DVM_SRV_DVM__SYS :***************/RequestDeviceManagerNotifyConnectionStatus(eUpdateClients)********** [VD_DeviceManager_service_DeviceManager.cpp(817)]
    //<dragon@usb1>(core0)VD_DVM_SRV_DVM__SYS :RequestDeviceManagerNotifyConnectionStatus: m_cSerialID     : Kingston_DT_R400_0018F3D97163BC1121480BF8_20F1-24F7 [VD_DeviceManager_service_DeviceManager.cpp(818)]
    //<dragon@usb1>(core0)VD_DVM_SRV_DVM__SYS :RequestDeviceManagerNotifyConnectionStatus: m_cUSBPort      : 1 [VD_DeviceManager_service_DeviceManager.cpp(819)]
    //<dragon@usb1>(core0)VD_DVM_SRV_DVM__SYS :RequestDeviceManagerNotifyConnectionStatus: m_eDeviceType   : DTY_USB (1) [VD_DeviceManager_service_DeviceManager.cpp(820)]
    //<dragon@usb1>(core0)VD_DVM_SRV_DVM__SYS :RequestDeviceManagerNotifyConnectionStatus: m_cDeviceVersion: 0100 [VD_DeviceManager_service_DeviceManager.cpp(821)]
    //<dragon@usb1>(core0)VD_DVM_SRV_DVM__SYS :RequestDeviceManagerNotifyConnectionStatus: m_cDeviceName   : K?CHLING [VD_DeviceManager_service_DeviceManager.cpp(822)]
    //<dragon@usb1>(core0)VD_DVM_SRV_DVM__SYS :RequestDeviceManagerNotifyConnectionStatus: m_cAcessoryName : /dev/sda [VD_DeviceManager_service_DeviceManager.cpp(823)]
    //<dragon@usb1>(core0)VD_DVM_SRV_DVM__SYS :RequestDeviceManagerNotifyConnectionStatus: m_cMountPoint   : /dev/media/20F1-24F7 [VD_DeviceManager_service_DeviceManager.cpp(824)]
    //<dragon@usb1>(core0)VD_DVM_SRV_DVM__SYS :RequestDeviceManagerNotifyConnectionStatus: m_eConnectStatus: USB_DEV_CONNECTED (2) [VD_DeviceManager_service_DeviceManager.cpp(825)]
    //<dragon@usb1>(core0)VD_DVM_SRV_DVM__SYS :***************RequestDeviceManagerNotifyConnectionStatus************************** [VD_DeviceManager_service_DeviceManager.cpp(826)]

    //128 is currently defined in framework this check is to ensure that central definition still fits
    // Suppressing Lint errors by tagging IF statement with NOLINT
    if(    (sizeof(deviceInfoItem.serialNumber)  >= 128)
            && (sizeof(deviceInfoItem.UUID)          >= 128)
            && (sizeof(deviceInfoItem.deviceVersion) >= 128)
            && (sizeof(deviceInfoItem.deviceName)    >= 128)
            && (sizeof(deviceInfoItem.accessoryName) >= 128)
            && (sizeof(deviceInfoItem.mountPoint)    >= 128))  // NOLINT

    {
        deviceInfoItem.deviceType      = DTY_USB;
        deviceInfoItem.connectionState = CS_ATTACHED;
        deviceInfoItem.disconnectReason = DR_REMOVED;

        sprintf(deviceInfoItem.serialNumber,  "Kingston_DT_R400_0018F3D97163BC1121480BF8_20F1-24F7");
        sprintf(deviceInfoItem.UUID,          "Kingston_DT_R400_0018F3D97163BC1121480BF8_20F1-24F7");
        sprintf(deviceInfoItem.deviceVersion, "0100");
        sprintf(deviceInfoItem.deviceName,    "MIXED");
        sprintf(deviceInfoItem.accessoryName, "/dev/sda");
        //sprintf(deviceInfoItem.mountPoint,    "/dev/media/20F1-24F7");

#ifndef TARGET_BUILD
        strncpy_r(OUT deviceInfoItem.mountPoint, IN get_current_dir_name(), IN sizeof(deviceInfoItem.mountPoint));
        strncat_r(OUT deviceInfoItem.mountPoint, IN "/Customer/Simulation/CustomControl/stick_3", IN sizeof(deviceInfoItem.mountPoint));
#else
        strncpy_r(OUT deviceInfoItem.mountPoint, IN "/opt/bosch/test/data/GMP/stick_3", IN sizeof(deviceInfoItem.mountPoint));
#endif

        //feed interface
        deviceInfos.push_back(deviceInfoItem);//holds at position 0 last notification
        deviceInfos.push_back(deviceInfoItem);//holds at position 1..end all connected devices
        res = MediaPlayerInterface::GetInstance().DeviceChanged(IN undervoltage, IN deviceInfos);
        GMPTEST_EXPECT(res == 0);

        /*wait till device reaches the state connected from attached*/
        sleep(1);

        //----------------EVALUATE RESULT------------------------
        //check if device can be found in database and
        tDeviceID deviceID = DEVICE_ID_NOT_SET;
        tDeviceInfo deviceInfo;

        res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN deviceInfoItem.mountPoint);
        GMPTEST_EXPECT(res == 0);
        ETG_TRACE_USR1(("             MediaPlayerInterfaceTest::ConnectDeviceUSBStick deviceID=%d ***",deviceID))
        res = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN deviceID);
        GMPTEST_EXPECT(res == 0);

        if(deviceInfo.connectionState == CS_CONNECTED)
        {
            ETG_TRACE_USR1(("             MediaPlayerInterfaceTest::ConnectDeviceUSBStick (simulated): RESULT: OK***"));
        }
        else
        {
            ETG_TRACE_USR1(("             MediaPlayerInterfaceTest::ConnectDeviceUSBStick (simulated): RESULT: NOK***"));
            res = -1;
            GMPTEST_EXPECT(res == 0);
        }


    }
    else
    {
        res = -1;
        GMPTEST_EXPECT(res == 0);
        ETG_TRACE_FATAL(("             MediaPlayerInterfaceTest::ConnectDeviceUSBStick: ERROR check size of property items***"));
    }
}

void MediaPlayerInterfaceTest::DisconnectDeviceUSBStick()
{
    ENTRY_TEST

    tResult res = -1;
    tDeviceInfo deviceInfoItem;
    vector<tDeviceInfo> deviceInfos;
    tUndervoltage undervoltage = false;

    //Example output of deviceManager
    //<dragon@usb1>(core0)VD_DVM_SRV_DVM__SYS :***************/RequestDeviceManagerNotifyConnectionStatus(eUpdateClients)********** [VD_DeviceManager_service_DeviceManager.cpp(817)]
    //<dragon@usb1>(core0)VD_DVM_SRV_DVM__SYS :RequestDeviceManagerNotifyConnectionStatus: m_cSerialID     : Kingston_DT_R400_0018F3D97163BC1121480BF8_20F1-24F7 [VD_DeviceManager_service_DeviceManager.cpp(818)]
    //<dragon@usb1>(core0)VD_DVM_SRV_DVM__SYS :RequestDeviceManagerNotifyConnectionStatus: m_cUSBPort      : 1 [VD_DeviceManager_service_DeviceManager.cpp(819)]
    //<dragon@usb1>(core0)VD_DVM_SRV_DVM__SYS :RequestDeviceManagerNotifyConnectionStatus: m_eDeviceType   : DTY_USB (1) [VD_DeviceManager_service_DeviceManager.cpp(820)]
    //<dragon@usb1>(core0)VD_DVM_SRV_DVM__SYS :RequestDeviceManagerNotifyConnectionStatus: m_cDeviceVersion: 0100 [VD_DeviceManager_service_DeviceManager.cpp(821)]
    //<dragon@usb1>(core0)VD_DVM_SRV_DVM__SYS :RequestDeviceManagerNotifyConnectionStatus: m_cDeviceName   : MIXED [VD_DeviceManager_service_DeviceManager.cpp(822)]
    //<dragon@usb1>(core0)VD_DVM_SRV_DVM__SYS :RequestDeviceManagerNotifyConnectionStatus: m_cAcessoryName : /dev/sda [VD_DeviceManager_service_DeviceManager.cpp(823)]
    //<dragon@usb1>(core0)VD_DVM_SRV_DVM__SYS :RequestDeviceManagerNotifyConnectionStatus: m_cMountPoint   : /dev/media/20F1-24F7 [VD_DeviceManager_service_DeviceManager.cpp(824)]
    //<dragon@usb1>(core0)VD_DVM_SRV_DVM__SYS :RequestDeviceManagerNotifyConnectionStatus: m_eConnectStatus: USB_DEV_REMOVED_BY_USR (3) [VD_DeviceManager_service_DeviceManager.cpp(825)]
    //<dragon@usb1>(core0)VD_DVM_SRV_DVM__SYS :***************RequestDeviceManagerNotifyConnectionStatus************************** [VD_DeviceManager_service_DeviceManager.cpp(826)]

    //128 is currently defined in framework this check is to ensure that central definition still fits
    // Suppressing Lint errors by tagging IF statement with NOLINT
    if(    (sizeof(deviceInfoItem.serialNumber)  >= 128)
            && (sizeof(deviceInfoItem.UUID)          >= 128)
            && (sizeof(deviceInfoItem.deviceVersion) >= 128)
            && (sizeof(deviceInfoItem.deviceName)    >= 128)
            && (sizeof(deviceInfoItem.accessoryName) >= 128)
            && (sizeof(deviceInfoItem.mountPoint)    >= 128))  // NOLINT

    {
        deviceInfoItem.deviceType      = DTY_USB;
        deviceInfoItem.connectionState = CS_DISCONNECTED;
        deviceInfoItem.disconnectReason = DR_REMOVED;

        sprintf(deviceInfoItem.serialNumber,  "Kingston_DT_R400_0018F3D97163BC1121480BF8_20F1-24F7");
        sprintf(deviceInfoItem.UUID,          "Kingston_DT_R400_0018F3D97163BC1121480BF8_20F1-24F7");
        sprintf(deviceInfoItem.deviceVersion, "0100");
        sprintf(deviceInfoItem.deviceName,    "MIXED");
        sprintf(deviceInfoItem.accessoryName, "/dev/sda");

#ifndef TARGET_BUILD
        strncpy_r(OUT deviceInfoItem.mountPoint, IN get_current_dir_name(), IN sizeof(deviceInfoItem.mountPoint));
        strncat_r(OUT deviceInfoItem.mountPoint, IN "/Customer/Simulation/CustomControl/stick_3", IN sizeof(deviceInfoItem.mountPoint));
#else
        strncpy_r(OUT deviceInfoItem.mountPoint, IN "/opt/bosch/test/data/GMP/stick_3", IN sizeof(deviceInfoItem.mountPoint));
#endif

        //sprintf(deviceInfoItem.mountPoint,    "/dev/media/20F1-24F7");

        //feed interface
        deviceInfos.push_back(deviceInfoItem); //holds single device only further tests will hold more then a single device
        res = MediaPlayerInterface::GetInstance().DeviceChanged(IN undervoltage, IN deviceInfos);
        GMPTEST_EXPECT(res == 0);


        //----------------EVALUATE RESULT------------------------
        //check if device can be found in database and
        tDeviceID deviceID = DEVICE_ID_NOT_SET;
        tDeviceInfo deviceInfo;


        res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN deviceInfoItem.mountPoint);
        GMPTEST_EXPECT(res == 0);
        ETG_TRACE_USR1(("             MediaPlayerInterfaceTest::DisconnectDeviceUSBStick deviceID=%d ***",deviceID))
        res = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN deviceID);
        GMPTEST_EXPECT(res == 0);

        if(deviceInfo.connectionState == CS_DISCONNECTED)
        {
            ETG_TRACE_USR1(("             MediaPlayerInterfaceTest::DisconnectDeviceUSBStick (simulated): RESULT: OK***"));
        }
        else
        {
            ETG_TRACE_USR1(("             MediaPlayerInterfaceTest::DisconnectDeviceUSBStick (simulated): RESULT: NOK***"));
            res = -1;
            GMPTEST_EXPECT(res == 0);
        }
    }
    else
    {
        ETG_TRACE_FATAL(("             MediaPlayerInterfaceTest::DisconnectDeviceUSBStick: ERROR check size of property items***"));
    }
}

void MediaPlayerInterfaceTest::StressConnectDeviceUSBStick()
{
    ENTRY_TEST

    ETG_TRACE_USR1(("             Mutliple connect & disconnect USB_Stick (simulated) to stress functionality"));

    for(int i=0;i<10;i++)
    {
        ConnectDeviceUSBStick();
        ETG_TRACE_USR1(("             MediaPlayerInterfaceTest::StressConnectDeviceUSBStick: CONNECT"));
        ETG_TRACE_USR1(("             MediaPlayerInterfaceTest::StressConnectDeviceUSBStick: DELAY 1sec"));
        sleep(1);
        ETG_TRACE_USR1(("             MediaPlayerInterfaceTest::StressConnectDeviceUSBStick: DISCONNECT"));
        DisconnectDeviceUSBStick();
    }
}

void MediaPlayerInterfaceTest::ConnectDeviceUSBStickSeveral()
{
    ENTRY_TEST

    tResult res = -1;
    tDeviceInfo deviceInfoItem[2];
    vector<tDeviceInfo> deviceInfos;
    tUndervoltage undervoltage = false;

    //---------1st device-------------
    // changed the subscripts  2-> 1 and 1-> 0 throughout this function as array indexing was incorrect
    deviceInfoItem[0].deviceType       = DTY_USB;
    deviceInfoItem[0].connectionState  = CS_ATTACHED;
    deviceInfoItem[0].disconnectReason = DR_REMOVED;

    sprintf(deviceInfoItem[0].serialNumber,  "Kingston_DT_R400_0018F3D97163BC1121480BF8_20F1-24F7");
    sprintf(deviceInfoItem[0].UUID,          "Kingston_DT_R400_0018F3D97163BC1121480BF8_20F1-24F7");
    sprintf(deviceInfoItem[0].deviceVersion, "0100");
    sprintf(deviceInfoItem[0].deviceName,    "MIXED");
    sprintf(deviceInfoItem[0].accessoryName, "/dev/sda");
    //sprintf(deviceInfoItem[1].mountPoint,    "/dev/media/20F1-24F7");
#ifndef TARGET_BUILD
    strncpy_r(OUT deviceInfoItem[0].mountPoint, IN get_current_dir_name(), IN sizeof(deviceInfoItem[0].mountPoint));
    strncat_r(OUT deviceInfoItem[0].mountPoint, IN "/Customer/Simulation/CustomControl/stick_3", IN sizeof(deviceInfoItem[0].mountPoint));
#else
    strncpy_r(OUT deviceInfoItem[0].mountPoint, IN "/opt/bosch/test/data/GMP/stick_3", IN sizeof(deviceInfoItem[0].mountPoint));
#endif

    //-------2nd device-------------
    deviceInfoItem[1].deviceType       = DTY_USB;
    deviceInfoItem[1].connectionState  = CS_ATTACHED;
    deviceInfoItem[1].disconnectReason = DR_REMOVED;

    sprintf(deviceInfoItem[1].serialNumber,  "987654321");
    sprintf(deviceInfoItem[1].UUID,          "987654321");
    sprintf(deviceInfoItem[1].deviceVersion, "1.0");
    sprintf(deviceInfoItem[1].deviceName,    "USB-3");
    sprintf(deviceInfoItem[1].accessoryName, "/dev/sda");
#ifndef TARGET_BUILD
    strncpy_r(OUT deviceInfoItem[1].mountPoint, IN get_current_dir_name(), IN sizeof(deviceInfoItem[1].mountPoint));
    strncat_r(OUT deviceInfoItem[1].mountPoint, IN "/Customer/Simulation/CustomControl/stick_3", IN sizeof(deviceInfoItem[1].mountPoint));
#else
    strncpy_r(OUT deviceInfoItem[1].mountPoint, IN "/opt/bosch/test/data/GMP/stick_3", IN sizeof(deviceInfoItem[1].mountPoint));
#endif


    //feed interface 1st device
    deviceInfos.push_back(deviceInfoItem[0]);//index 0 holds last change
    deviceInfos.push_back(deviceInfoItem[0]);//index 1...last holds all connected devices
    res = MediaPlayerInterface::GetInstance().DeviceChanged(IN undervoltage, IN deviceInfos);
    GMPTEST_EXPECT(res == 0);

    //feed interface 2nd device
    deviceInfos.insert(deviceInfos.begin(),deviceInfoItem[1]);//index 0 holds last change
    deviceInfos.push_back(deviceInfoItem[1]);//index 1...last holds all connected devices
}

void MediaPlayerInterfaceTest::DisconnectDeviceUSBStickSeveral()
{
    ENTRY_TEST

    tResult res = -1;
    tDeviceInfo deviceInfoItem[3];  //CID 16233 (#1 of 1): Out-of-bounds write (OVERRUN)
    vector<tDeviceInfo> deviceInfos;
    tUndervoltage undervoltage = false;

    //---------1st device-------------
    deviceInfoItem[1].deviceType       = DTY_USB;
    deviceInfoItem[1].connectionState  = CS_DISCONNECTED;
    deviceInfoItem[1].disconnectReason = DR_REMOVED;

    sprintf(deviceInfoItem[1].serialNumber,  "Kingston_DT_R400_0018F3D97163BC1121480BF8_20F1-24F7");
    sprintf(deviceInfoItem[1].UUID,          "Kingston_DT_R400_0018F3D97163BC1121480BF8_20F1-24F7");
    sprintf(deviceInfoItem[1].deviceVersion, "0100");
    sprintf(deviceInfoItem[1].deviceName,    "MIXED");
    sprintf(deviceInfoItem[1].accessoryName, "/dev/sda");
    //sprintf(deviceInfoItem[1].mountPoint,    "/dev/media/20F1-24F7");
#ifndef TARGET_BUILD
    strncpy_r(OUT deviceInfoItem[1].mountPoint, IN get_current_dir_name(), IN sizeof(deviceInfoItem[1].mountPoint));
    strncat_r(OUT deviceInfoItem[1].mountPoint, IN "/Customer/Simulation/CustomControl/stick_3", IN sizeof(deviceInfoItem[1].mountPoint));
#else
    strncpy_r(OUT deviceInfoItem[1].mountPoint, IN "/opt/bosch/test/data/GMP/stick_3", IN sizeof(deviceInfoItem[1].mountPoint));
#endif

    //-------2nd device-------------
    deviceInfoItem[2].deviceType      = DTY_USB;
    deviceInfoItem[2].connectionState = CS_ATTACHED;
    deviceInfoItem[2].disconnectReason = DR_REMOVED;

    sprintf(deviceInfoItem[2].serialNumber,  "987654321");
    sprintf(deviceInfoItem[2].UUID,          "987654321");
    sprintf(deviceInfoItem[2].deviceVersion, "1.0");
    sprintf(deviceInfoItem[2].deviceName,    "USB-3");
    sprintf(deviceInfoItem[2].accessoryName, "/dev/sda");
#ifndef TARGET_BUILD
    strncpy_r(OUT deviceInfoItem[2].mountPoint, IN get_current_dir_name(), IN sizeof(deviceInfoItem[2].mountPoint));
    strncat_r(OUT deviceInfoItem[2].mountPoint, IN "/Customer/Simulation/CustomControl/stick_3", IN sizeof(deviceInfoItem[2].mountPoint));
#else
    strncpy_r(OUT deviceInfoItem[2].mountPoint, IN "/opt/bosch/test/data/GMP/stick_3", IN sizeof(deviceInfoItem[2].mountPoint));
#endif

    //at index 0 we announce 1st device to be removed at index 1..end all connected devices will be send i.e. the second one
    deviceInfos.push_back(deviceInfoItem[1]);//index 0 holds last change
    deviceInfos.push_back(deviceInfoItem[2]);//index 1...last holds all connected devices
    res = MediaPlayerInterface::GetInstance().DeviceChanged(IN undervoltage, IN deviceInfos);
    GMPTEST_EXPECT(res == 0);

    //at index 0 we announce 2nd device to be removed at index 1..end no connected device will appear
    deviceInfos.clear(); //delete all elements in vector
    deviceInfoItem[2].connectionState = CS_DISCONNECTED;
    deviceInfos.push_back(deviceInfoItem[2]);//index 1...last holds all connected devices
}

void MediaPlayerInterfaceTest::StressConnectDeviceUSBStickSeveral()
{
    ENTRY_TEST

    ETG_TRACE_USR1(("             Mutliple connect & disconnect of several USB_Sticks (simulated) to stress functionality"));

    for(int i=0;i<10;i++)
    {
        ConnectDeviceUSBStickSeveral();
        ETG_TRACE_USR1(("             MediaPlayerInterfaceTest::StressConnectDeviceUSBStickSeveral: CONNECT"));
        ETG_TRACE_USR1(("             MediaPlayerInterfaceTest::StressConnectDeviceUSBStickSeveral: DELAY 1sec"));
        sleep(1);
        ETG_TRACE_USR1(("             MediaPlayerInterfaceTest::StressConnectDeviceUSBStickSeveral: DISCONNECT"));
        DisconnectDeviceUSBStickSeveral();
    }
}

void MediaPlayerInterfaceTest::StoreFavorites()
{
    ENTRY_TEST

    tResult ret = 0;

    tFavoriteID retFavID;

    /*store an known object in the database as favorite*/
    tObjectID objectID = mFAVORITE_1_OBJECT_ID;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().StoreFavorite(OUT retFavID,IN objectID);

    GMPTEST_EXPECT(ret == 0);           //favorite store success full
    GMPTEST_EXPECT(1 == retFavID);      // favorite ID will auto increment with every new store starting from 1
}

void MediaPlayerInterfaceTest::GetFavoriteInfo()
{
    ENTRY_TEST

    tResult ret;

    tFavoriteInfo favoriteInfo;
    InitFavoriteInfo(OUT favoriteInfo);

    tFavoriteID favoriteID = 1;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo(favoriteInfo,favoriteID);
    ETG_TRACE_USR2(("favorite label name : %s \n",favoriteInfo.labelText));

    GMPTEST_EXPECT(ret == 0);

#ifndef TARGET_BUILD // Do not validate label in target build since ObjectID are not unique every time for a label
    GMPTEST_EXPECT(!strcmp(favoriteInfo.labelText, FAVORITE_1_LABEL));
#endif
    VARTRACE(favoriteInfo)
}

void MediaPlayerInterfaceTest::ActivateFavorite()
{
    ENTRY_TEST

    tResult ret = 0;

    tFavoriteID retFavID;
    tFavoriteID favID = 1;

    ret = LocalSPM::GetCustomControl().GetFavoritesManager().ActivateFavorite(OUT retFavID,IN favID,LC_MAIN_AUDIO,LC_MAIN_AUDIO);

    GMPTEST_EXPECT(ret == 0);             //favorite activate success full
    GMPTEST_EXPECT(favID == retFavID);

    tFavoriteInfo favoriteInfo;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo( OUT favoriteInfo, IN favID);
    GMPTEST_EXPECT(ret == 0);
    GMPTEST_EXPECT(favoriteInfo.active == true);    //verify if active flag set on the favorite

    /*wait for playback to start*/
    sleep (5);

    /*Verify if Playmanager is in Active state*/
    tBoolean isActive = FALSE;
    ret = LocalSPM::GetPlayerManager().GetActiveState(OUT isActive);
    GMPTEST_EXPECT(ret == 0);
//  GMPTEST_EXPECT_MESSAGE("PlayerManager is not active ! Is PlayerEngine started late ?", isActive);

    /*Verify if Playmanager::NowPlaying is same as the requested Favorite is in Active state*/
    tNowPlaying nowPlaying;
    ret = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
    GMPTEST_EXPECT(ret == 0);
    VARTRACE(nowPlaying);
    GMPTEST_EXPECT(nowPlaying.objectID == mFAVORITE_1_OBJECT_ID);

#ifndef TARGET_BUILD // since objectID generate in target is different , cannot verify against fixed label
   // GMPTEST_EXPECT_MESSAGE("Activated Song's title not matching with nowPlaying's title",!strcmp(nowPlaying.object.title, FAVORITE_1_LABEL));    //verify Song name
#endif
    sleep(1);
}

void MediaPlayerInterfaceTest::DeleteFavorite()
{
    ENTRY_TEST

    tResult ret;
    tFavoriteID favoriteID = 1;
    tFavoriteID retFavID;

    ret = LocalSPM::GetCustomControl().GetFavoritesManager().DeleteFavorite(OUT retFavID , IN favoriteID);
    GMPTEST_EXPECT(ret == 0);
    GMPTEST_EXPECT(retFavID == favoriteID);

    tFavoriteInfo favoriteInfo;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo(favoriteInfo,favoriteID);
    GMPTEST_EXPECT(ret != 0);           // an attempt to retrieve the deleted favorite should return error
    GMPTEST_EXPECT(ret == MP_ERR_DB_END_OF_LIST);
}

void MediaPlayerInterfaceTest::ResetFavorites()
{
    ENTRY_TEST

    tResult ret;

    //reset the favorites which clears all the stored favorites records
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().ResetFavorites();
    GMPTEST_EXPECT(ret == 0);

    /********************************************************************************************************/
    // verify that all the favorites cleared
    tFavoriteInfo favoriteInfo;
    tFavoriteID favoriteID;

    favoriteID = 1;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo(favoriteInfo,favoriteID);
    GMPTEST_EXPECT(ret != 0);           // an attempt to retrieve the deleted favorite should return error
    GMPTEST_EXPECT(ret == MP_ERR_DB_END_OF_LIST);
}

void MediaPlayerInterfaceTest::SetLanguage()
{
    ENTRY_TEST

    tResult ret;

    //LocalSPM::GetDataProvider().DBSortUseUCAOn = 1;

    /*language change should recreate the database */
    ret = mMediaPlayerInterface.SetLanguage(LNG_UK_ENGLISH);
    GMPTEST_EXPECT(ret == 0);
}

void MediaPlayerInterfaceTest::GetLanguage()
{
    ENTRY_TEST

    tResult ret;
    // sim4hi 180629: initialized variable as fix for Coverity CID-17548
    tLanguageType language = LNG_NA_ENGLISH;

    /*Get the language */
    ret = mMediaPlayerInterface.GetLanguage(language);
    ETG_TRACE_USR1 (( "Language %d", language));
    GMPTEST_EXPECT(ret == 0);
}

void MediaPlayerInterfaceTest::SetLanguageWithSorting()
{
    ENTRY_TEST

    tResult ret;

    LocalSPM::GetDataProvider().DBSortUseUCAOn = 1;

    /*language change should recreate the database */
    ret = mMediaPlayerInterface.SetLanguage(LNG_GERMAN);
    GMPTEST_EXPECT(ret == 0);

    LocalSPM::GetDataProvider().DBSortUseUCAOn = 0;
}

void MediaPlayerInterfaceTest::Umount()
{
    ENTRY_TEST

    tResult res = -1;
    tErrorCode errorCode;
    // Call Umount to check the general command processing, use MYMEDIA that cannot be umounted
    //tHMIPlaybackState playstatus;
    res = mMediaPlayerInterface.Umount(OUT errorCode, IN 0);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(errorCode == MP_ERR_UMOUNT_NOT_SUPPORTED);
}


void MediaPlayerInterfaceTest::SendMuteStatus()
{
    ENTRY_TEST

    tResult res = -1;
    tMuteState muteState = MUS_MUTED;

    res = mMediaPlayerInterface.SendMuteStatus(IN muteState);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    muteState = MUS_DEMUTED;  // initial state

    res = mMediaPlayerInterface.SendMuteStatus(IN muteState);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
}

void MediaPlayerInterfaceTest::CreateMediaPlayerFileListExt()
{
    ENTRY_TEST

    tResult res = -1;

    tListID fileListID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPosition position;
    tPath path; // Change
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    /* create a file list from "/music" directory and search for a special file in this list */
    strncpy_r(OUT path, IN "/music/wavin_flag.mp3", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileListExt(
            OUT fileListID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            OUT position,
            IN path,
            IN deviceID);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(fileListID != LIST_ID_NONE);
    GMPTEST_EXPECT(numberOfMediaObjects == 1);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 6);
    GMPTEST_EXPECT(listSize == numberOfMediaObjects+numberOfPlayLists+numberOfFolders);
    GMPTEST_EXPECT(position == 6);

    /* create a file list from "/music" directory and search for a special folder in this list */
    strncpy_r(OUT path, IN "/music/Alanis_Morissette", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileListExt(
            OUT fileListID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            OUT position,
            IN path,
            IN deviceID);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(fileListID != LIST_ID_NONE);
    GMPTEST_EXPECT(numberOfMediaObjects == 1);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 6);
    GMPTEST_EXPECT(listSize == numberOfMediaObjects+numberOfPlayLists+numberOfFolders);
    GMPTEST_EXPECT(position == 1);

}

void MediaPlayerInterfaceTest::GetDeviceInfo()
{
    ENTRY_TEST

    tResult res = -1;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tDeviceInfo deviceInfo;

    // Set DeviceType to USB device to retrieve DeviceID
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    // validate device information retrieved from the DB
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo , IN deviceID);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    GMPTEST_EXPECT(deviceInfo.deviceID == deviceID);
    GMPTEST_EXPECT(deviceInfo.connectionType == DCT_USB);
    GMPTEST_EXPECT(deviceInfo.connected == 0x01); // ???
    GMPTEST_EXPECT(deviceInfo.deviceType == DTY_USB);
    GMPTEST_EXPECT(deviceInfo.connectionState == CS_CONNECTED); // ???

}

void MediaPlayerInterfaceTest::GetConnectedDeviceCount()
{
    ENTRY_TEST

    tResult res = -1;
    tNumberOfDevices numberOfDevices, numberOfConnectedDevices;
    vector<tDeviceInfo> deviceInfo;

    res = mMediaPlayerInterface.GetMediaplayerDeviceConnections(OUT numberOfDevices, OUT deviceInfo);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(numberOfDevices >= 4); // this test must run with custom control test on, there a device will be deleted

    numberOfConnectedDevices = 0;
    for (unsigned int i = 0; i < deviceInfo.size(); i++)
    {
        ETG_TRACE_USR1(("DeviceID : %d, DeviceName : %s", deviceInfo.at(i).deviceID, deviceInfo.at(i).deviceName));
        ETG_TRACE_USR1(("DeviceID : %d, connected : %d",  deviceInfo.at(i).deviceID, deviceInfo.at(i).connected));
        ETG_TRACE_USR1(("DeviceID : %d, connectionCount : %d",  deviceInfo.at(i).deviceID, deviceInfo.at(i).connectionCount));
        if (deviceInfo.at(i).connected == 1)
        {
            numberOfConnectedDevices++;
        }
    }

    ETG_TRACE_USR1(("Number of Connected Devices : %d", numberOfConnectedDevices));

    numberOfDevices = 0;
    res = mMediaPlayerInterface.GetConnectedDeviceCount(OUT numberOfDevices);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(numberOfConnectedDevices == numberOfDevices);

}

void MediaPlayerInterfaceTest::GetBTProfileInfo()
{
    ENTRY_TEST

    tResult res = -1;
    tBTProfileList profileList;
    res = MediaPlayerInterface::GetInstance().GetBTProfileInfo(profileList);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    // NB iPod Control does not function under Ubuntu, therefore simulator tests return no data
}
void MediaPlayerInterfaceTest::GetDiPONowPlaying()
{
    ENTRY_TEST

    tResult res = -1;
    tDeviceID deviceID;
    tDiPONowPlaying nowPlaying;
    res = MediaPlayerInterface::GetInstance().GetDiPONowPlaying(deviceID, nowPlaying);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    // NB iPod Control does not function under Ubuntu, therefore simulator tests return no data
}
void MediaPlayerInterfaceTest::GetDiPOPlaybackStatus()
{
    ENTRY_TEST

    tResult res = -1;
    tDeviceID deviceID;
    tHMIPlaybackState playbackState;
    res = MediaPlayerInterface::GetInstance().GetDiPOPlaybackStatus(deviceID, playbackState);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    // NB iPod Control does not function under Ubuntu, therefore simulator tests return no data
}
void MediaPlayerInterfaceTest::GetDiPOPlaybackShuffleMode()
{
    ENTRY_TEST

    tResult res = -1;
    tPlaybackMode playbackMode;
    tDeviceID deviceID;
    res = MediaPlayerInterface::GetInstance().GetDiPOPlaybackShuffleMode(deviceID, playbackMode);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    // NB iPod Control does not function under Ubuntu, therefore simulator tests return no data
}
void MediaPlayerInterfaceTest::GetDiPOPlaybackRepeatMode()
{
    ENTRY_TEST

    tResult res = -1;
    tRepeatMode repeatMode;
    tDeviceID deviceID;
    res = MediaPlayerInterface::GetInstance().GetDiPOPlaybackRepeatMode(deviceID, repeatMode);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    // NB iPod Control does not function under Ubuntu, therefore simulator tests return no data
}
void MediaPlayerInterfaceTest::GetDiPOCallState()
{
    ENTRY_TEST

    tResult res = -1;
    tDeviceID deviceID;
    tDiPOCallState callStateList;
    res = MediaPlayerInterface::GetInstance().GetDiPOCallState(deviceID, callStateList);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    // NB iPod Control does not function under Ubuntu, therefore simulator tests return no data
}
void MediaPlayerInterfaceTest::GetDiPOCommunications()
{
    ENTRY_TEST

    tResult res = -1;
    tDeviceID deviceID;
    tDiPOCommunications communications;
    res = MediaPlayerInterface::GetInstance().GetDiPOCommunications(deviceID, communications);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    // NB iPod Control does not function under Ubuntu, therefore simulator tests return no data
}

void MediaPlayerInterfaceTest::PlayItemFromListByTag()
{
    ENTRY_TEST

    // need parameters : tListSize &listSize, const tListID listID, const tObjectID objectID
    tResult res = -1;
    tListID listID;
    tListSize listSize = 0;

    tListType ListType = LTY_SONG;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    // set the filter tags
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    // get device id
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    // create Indexed list
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            IN ListType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);

    // Check if listID is valid
    GMPTEST_EXPECT(LIST_ID_NONE != listID);

    vector<tMediaObject> mediaObjectVector;
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, listSize);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    // use oblectId to get listSize
    res = mMediaPlayerInterface.PlayItemFromListByTag(OUT listSize, IN listID, IN mediaObjectVector[1].objectID);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    // Call GetPlaybackState to check the current playback state of the MediaPlayer
    tHMIPlaybackState playstatus;
    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);

    ETG_TRACE_USR1((" PlayItemFromListByTag::GetPlaybackState Action : %d ", playstatus));
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);

}

void MediaPlayerInterfaceTest::GetCurrentFolderPath()
{
    ENTRY_TEST

    tResult res = -1;
    tListID fileListID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path, folderPath;  // typedef char tPath[1024];
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tHMIPlaybackState playstatus;

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    /* set the path to create a folder view which includes a playlist*/
    strncpy_r(OUT path, IN "/music/Mando_Diao-Bring_Em_In-RETAIL-2002-EVIGHET/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT fileListID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID);
    /*check the created folder view is as expected*/
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(numberOfMediaObjects == 12);
    GMPTEST_EXPECT(numberOfPlayLists == 1);
    GMPTEST_EXPECT(numberOfFolders == 0);

    // quickplay playlist 00-mando_diao-bring_em_in-retail-2002-evighet.m3u
    // which is at index 0 of the FolderView created in the previous step
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN fileListID, 0, 0);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    // Verify if first track in the playlist is playing
    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    // check current playback state
    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1((" PlayItemFromList::GetPlaybackState Action : %d ", playstatus));
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);

    tNowPlaying nowPlaying;
    res = LocalSPM::GetPlayerManager().GetNowPlaying(nowPlaying);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    VARTRACE(nowPlaying);
    // nowPlaying.object.fileName,"/music/Mando_Diao-Bring_Em_In-RETAIL-2002-EVIGHET/01-sheepdog-evighet.mp3"

    res = mMediaPlayerInterface.GetCurrentFolderPath(OUT folderPath, IN fileListID);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    //string path0(path);
    //path0.erase(path0.find_last_not_of('/') + 1);

    //string path1(folderPath);
    //path1.erase(path1.find_last_not_of('/') + 1);

    //GMPTEST_EXPECT(path0 == path1);

    VARTRACE(path);
    VARTRACE(folderPath);
    GMPTEST_EXPECT(!strcmp(path, folderPath));

}


void MediaPlayerInterfaceTest::GetAllFavoriteInfo()
{
    ENTRY_TEST

    tResult res = -1;

    tObjectID objectID;
    tFavoriteInfo favoriteInfo;
    tFavoriteID retFavID;
    vector<tFavoriteInfo> favoritesInfoVector;
    InitFavoriteInfo(OUT favoriteInfo);
    unsigned int i;

    // clear all the stored favorites records
    res = LocalSPM::GetCustomControl().GetFavoritesManager().ResetFavorites();
    GMPTEST_EXPECT(res == 0);


    // first store favourites
    // N.B. In prepareTestId   FAVORITE_1_OBJECT_ID = findSong(IN mediaObjectVector, 5, FAVORITE_1_LABEL);
    objectID = mFAVORITE_1_OBJECT_ID;
    res = mMediaPlayerInterface.StoreFavorite(OUT retFavID, IN objectID);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(retFavID == 2);  // favorite ID will auto increment with every new store
/*
    res = LocalSPM::GetCustomControl().GetFavoritesManager().DeleteFavorite(OUT retFavID , IN 1);
    GMPTEST_EXPECT(res == 0);
    res = LocalSPM::GetCustomControl().GetFavoritesManager().DeleteFavorite(OUT retFavID , IN 2);
    GMPTEST_EXPECT(res == 0);
*/
    objectID = mFAVORITE_2_OBJECT_ID;
    res = mMediaPlayerInterface.StoreFavorite(OUT retFavID, IN objectID);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(retFavID == 3);  // favorite ID will auto increment with every new store

    // Now retrieve elements stored as Favourites
    res = mMediaPlayerInterface.GetAllFavoriteInfo(favoritesInfoVector);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    i = favoritesInfoVector.size();
    // Should be 2 elements
    ETG_TRACE_USR2(("favourites info size : %d \n",i));
    GMPTEST_EXPECT(i == 2);
    // label 1 = Milk, label 2 = sheepdog
    GMPTEST_EXPECT(strcmp(favoritesInfoVector[0].labelText, "Milk") == 0);
    GMPTEST_EXPECT(strcmp(favoritesInfoVector[1].labelText, "sheepdog") == 0);

}



void MediaPlayerInterfaceTest::ClearMediaPlayerData()
{
    ENTRY_TEST

    tResult res = -1;
    tNumberOfDevices numberOfDevices;
    vector<tDeviceInfo> deviceInfoList;

    tListID listID;
    tListSize listSize;
    tFilterTag1 tag1 = { 0 };
    tFilterTag2 tag2 = { 0 };
    tFilterTag3 tag3 = { 0 };
    tFilterTag4 tag4 = { 0 };
    vector<tMediaObject> mediaObjectVector;

    // Check there are devices and associated data in database
    res = mMediaPlayerInterface.GetMediaplayerDeviceConnections(OUT numberOfDevices, OUT deviceInfoList);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    ETG_TRACE_USR1(("ClearMediaPlayerData::numberOfDevices: %d", numberOfDevices ));
    GMPTEST_EXPECT(numberOfDevices >= 4);

    // Now delete the data
    res = mMediaPlayerInterface.ClearMediaPlayerData();
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    // Check there are no devices in database
    res = mMediaPlayerInterface.GetMediaplayerDeviceConnections(OUT numberOfDevices, OUT deviceInfoList);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    ETG_TRACE_USR1(("ClearMediaPlayerData::numberOfDevices: %d", numberOfDevices ));
    GMPTEST_EXPECT(numberOfDevices == 2);  // internal device only

    //check device one: MyMedia, DTY_MYMEDIA
    int iFoundDevice=0;
    for(unsigned int i=0; i<deviceInfoList.size();i++)
    {
        ETG_TRACE_USR1(("deviceInfoList[%d].deviceName: %s",i,deviceInfoList[i].deviceName));
        ETG_TRACE_USR1(("deviceInfoList[%d].deviceType: %d",i,deviceInfoList[i].deviceType));

        if(0==strcmp(deviceInfoList[i].deviceName, "MyMedia"))
        {
            if(deviceInfoList[i].deviceType == DTY_MYMEDIA)
            {
                iFoundDevice=1;
                break;
            }
        }
    }
    GMPTEST_EXPECT(iFoundDevice == 1);

    //check device one: MusicBox,DTY_MUSICBOX
    iFoundDevice=0;
    for(unsigned int i=0; i<deviceInfoList.size();i++)
    {
        ETG_TRACE_USR1(("deviceInfoList[%d].deviceName: %s",i,deviceInfoList[i].deviceName));
        ETG_TRACE_USR1(("deviceInfoList[%d].deviceType: %d",i,deviceInfoList[i].deviceType));

        if(0==strcmp(deviceInfoList[i].deviceName, "MusicBox"))
        {
            if(deviceInfoList[i].deviceType == DTY_MUSICBOX)
            {
                iFoundDevice=1;
                break;
            }
        }
    }
    GMPTEST_EXPECT(iFoundDevice == 1);


    // Check no songs in database
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            MY_MEDIA);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 1);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(mediaObjectVector.size() == 0);

    /* Recreate the test database */
    InitTestsuite();

    // Check there are devices and associated data in database
    res = mMediaPlayerInterface.GetMediaplayerDeviceConnections(OUT numberOfDevices, OUT deviceInfoList);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(numberOfDevices >= 4);

}


void MediaPlayerInterfaceTest::SetOutsideTemperature()
{
    ENTRY_TEST

    tResult res = -1;
    tOutsideTemperature outsideTemperature;
    outsideTemperature = INVALID_OUTSIDE_TEMPERATURE;

    // intial value of outsideTemperature = INVALID_OUTSIDE_TEMPERATURE = -10000
    // Get configuration default value
    outsideTemperature = LocalSPM::GetDataProvider().iPodControlVehicleStatusOutsideTemperature();
    // returns default value outsideTemperature = 0
    GMPTEST_EXPECT(outsideTemperature == 0);

    // Set outsideTemperature to random value
    outsideTemperature = 21;
    res = mMediaPlayerInterface.SetOutsideTemperature(outsideTemperature);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

}

/**********************************************************************
 * Deprecated (iPod classic).
 *
void MediaPlayerInterfaceTest::TransferTags()
{
    ENTRY
    ENTRY_TEST

    // N.B. Method is called to transfer tags to an Apple device

    tResult res = -1;

    tDeviceID deviceTag = 1;
    vector<tTagTransfer> transferTags;
    tTagTransferStatus transferStatus = TAG_TRANSFER_COMM_ERROR;
    vector<tUntransferredTag> untransferredTags;

    for (i = 0; i < transferTags.size(); i++)
      InitTagTransfer(transferTags);
    for (i = 0; i < untransferredTags.size(); i++)
      InitUntransferredTag(untransferredTags);

    strncpy_r(OUT transferTags[0].tagTrackName, IN "Milk", IN sizeof(transferTags[0].tagTrackName));
    strncpy_r(OUT transferTags[0].tagArtistName, IN "Garbage", IN 7);

    res = mMediaPlayerInterface.TransferTags(IN deviceTag, IN transferTags,
                                             OUT transferStatus, OUT untransferredTags);


    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(transferStatus == TAG_TRANSFER_SUCCESS);
    for(i = 0; i < untransferredTags.size(); i++)
    {
       ETG_TRACE_USR1(("UntransferredTags : %s, %s \n", untransferredTags[i].tagTrackName, untransferredTags[i].tagArtistName));
    }

}
*/

void MediaPlayerInterfaceTest::SendAppControlConnect()
{
    ENTRY_TEST
    // Method provides the interface for the Internet Radio to send an IAP command to the MediaPlayer.
    tResult res = -1;

    tMountPoint mountPoint; // string containing the iPhone device HID name

    // for  AppControl interface
    tProtocolName protocol = {0};     // char array [128] - containing protocol of the IAP application
    tBundleSeedID bundleSeedID = {0}; // char array [128] - containing the bundle seed ID of the IAP application
    tAppName appName = {0};           // char array [128] - containing App name of the IAP application
    tAppLaunchOption launchOption = ALO_LAUNCH_WITH_USER_ALERT;

    // NB the use of {0} is called aggregate initialization ... all unspecified members are default initialized to 0
    // An aggregate is an array or a class with no user-declared constructors, no private or protected
    // non-static data members, no base classes, and no virtual functions

    strncpy_r(OUT mountPoint, IN "dev/usb/hiddev0", IN sizeof(mountPoint)); // value found in database

    res = mMediaPlayerInterface.SendAppControlConnect(IN mountPoint, IN protocol, IN bundleSeedID, IN appName, IN launchOption);

    GMPTEST_EXPECT(res == MP_NO_ERROR);
}

void MediaPlayerInterfaceTest::SendAppControlCommand()
{
    ENTRY_TEST

    tResult res = -1;

    tMountPoint mountPoint;
    tAppName appName = {0};
    tSessionID sessionID = 0; // The session ID of the connected IAP application
    tSize sizeOfBuffer = 0;   // size of the command buffer
    tCommandBufferPtr commandBuffer = tCommandBufferPtr_init;  // IAP command

    tUserContext userContext;

    // Initialisation of user context
    userContext.sourceAppID = tSourceAppID_init;
    userContext.registerID = tRegisterID_init;
    userContext.cmdCounter = tCmdCounter_init;
    userContext.functionID = tFunctionID_init;
    userContext.serviceID = tServiceID_init;

    strncpy_r(OUT mountPoint, IN "dev/usb/hiddev0", IN sizeof(mountPoint)); // value found in database

    res = mMediaPlayerInterface.SendAppControlCommand(IN mountPoint, IN appName, IN sessionID,
            IN sizeOfBuffer, IN commandBuffer, IN userContext);

    GMPTEST_EXPECT(res == MP_NO_ERROR);
}

void MediaPlayerInterfaceTest::SendAppControlClose()
{
    ENTRY_TEST

    tMountPoint mountPoint; // a string containing the iPhone device HID name
    tAppName appName  = {0};
    tSessionID sessionID = 1;

    tResult res = -1;

    strncpy_r(OUT mountPoint, IN "dev/usb/hiddev0", IN sizeof(mountPoint)); // this value found in database

    res = mMediaPlayerInterface.SendAppControlClose(mountPoint, appName, sessionID);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
}

void MediaPlayerInterfaceTest::StartAudio()
{
    ENTRY_TEST
    // Function triggers a mount for a device id which is done by the special device control
    // This function requires an iPod Module Test on a real device. This is not existing yet
    // Therefore, under current circumstances value for res = iPod Error Code 4002 => MP_ERR_IPOD_NO_ACCESS
    tResult res = -1;

    tMountPoint mountPoint;
    strncpy_r(OUT mountPoint, IN "dev/usb/hiddev0", IN sizeof(mountPoint)); // value found in database

    res = mMediaPlayerInterface.StartAudio(IN mountPoint);

    // res = iPode Error Code 4002 => MP_ERR_IPOD_NO_ACCESS
    GMPTEST_EXPECT(res == MP_ERR_IPOD_NO_ACCESS);
}

void MediaPlayerInterfaceTest::StopAudio()
{
    ENTRY_TEST
    // Function triggers an unmount for a device id which is done by the special device control
    // This function requires an iPod Module Test on a real device. This is not existing yet
    // Therefore, under current circumstances value for res = iPod Error Code 4002 => MP_ERR_IPOD_NO_ACCESS
    tResult res = -1;

    tMountPoint mountPoint; // mountPoint a string containing the iPhone device HID name
    strncpy_r(OUT mountPoint, IN "dev/usb/hiddev0", IN sizeof(mountPoint)); // value found in database

    res = mMediaPlayerInterface.StopAudio(IN mountPoint);

    GMPTEST_EXPECT(res == MP_ERR_IPOD_NO_ACCESS);
}

void MediaPlayerInterfaceTest::Reindexing()
{
    ENTRY_TEST
    // Function triggers re-indexing for a device id
    tResult res = -1;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    tListID listID;
    tListSize listSize;
    tFilterTag1 tag1 = { 0 };
    tFilterTag2 tag2 = { 0 };
    tFilterTag3 tag3 = { 0 };
    tFilterTag4 tag4 = { 0 };
    vector<tMediaObject> mediaObjectVector;

    // Enable triggers
    res = LocalSPM::GetIndexer().SwitchDBTrigger(IN TT_ALL, IN TS_ON);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    // set device id
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    //create an all song list and find album "Garbage"
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    // find first object
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 1);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(!strcmp(mediaObjectVector[0].MetadataField4, "Garbage"));

    // initial value of mediaObjectVector[0].totalPlaytime = 285000
    // initial value of mediaObjectVector[0].notPlayable = FNP_PLAYABLE

    // manipulate data fields - N.B. With GetDBManager().UpdateMediaObject only totalPlaytime and notPlayable will be updated
    //strncpy_r(OUT mediaObjectVector[0].MetadataField4, IN "Rubbish", IN 8);
    //strncpy_r(OUT mediaObjectVector[0].title, IN "Das ist mir wurst", IN 18);
    mediaObjectVector[0].totalPlaytime = 987654;
    mediaObjectVector[0].notPlayable = FNP_PLAY_RESTRICTION;


    res = LocalSPM::GetDBManager().UpdateMediaObject(IN mediaObjectVector[0]);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    //reset indexing state to synchronize to reindexing end
    res = LocalSPM::GetDBManager().SetIndexingState(IN deviceID, IN IDS_NOT_STARTED, IN 0);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    //change deviceState to ok
    tDeviceInfo deviceInfo;
    res = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    res = LocalSPM::GetDBManager().SetDeviceNameAndConnectionState(IN deviceID, IN deviceInfo.deviceName, IN deviceInfo.connectionState, IN DS_OK);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    // Force re-indexing
    res = mMediaPlayerInterface.Reindexing(IN deviceID);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    /* Wait for end of indexing */
    tIndexingState indexingState;
    int retry = 20;
    while(retry) {
        res = LocalSPM::GetDBManager().GetIndexingState(OUT indexingState, IN deviceID);
        GMPTEST_EXPECT(MP_NO_ERROR == res);
        if (IDS_COMPLETE == indexingState) break;
        sleep(1);
        retry--;
    }
    ETG_TRACE_USR4(("%d retries left", retry));
    GMPTEST_EXPECT(retry != 0);

    LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished(IN deviceID);

    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 1);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    // check the list contents have been modified to reflect original values
    tMediaObject checkObject = mediaObjectVector[0];
    GMPTEST_EXPECT(checkObject.totalPlaytime == 285000);
    GMPTEST_EXPECT(checkObject.notPlayable == FNP_PLAYABLE);

    // Disable triggers
    res = LocalSPM::GetIndexer().SwitchDBTrigger(IN TT_ALL, IN TS_OFF);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

}

void MediaPlayerInterfaceTest::DiagnosisPlaySong()
{
    ENTRY_TEST
    //plays the song specified with filename on the first found device of type deviceType

    tResult res = -1;
    tDeviceType deviceType = DTY_USB;
    tFilename filename;

    /* create filename name for test */
    strncpy_r(OUT filename, IN "/music/Mando_Diao-Bring_Em_In-RETAIL-2002-EVIGHET/01-sheepdog-evighet.mp3", IN sizeof(filename));

    ETG_TRACE_USR1(("The filename Name : %s", filename));

    res = mMediaPlayerInterface.DiagnosisPlaySong(IN deviceType, IN filename);

    GMPTEST_EXPECT(res == MP_NO_ERROR);
}

void MediaPlayerInterfaceTest::GetSlideshowTime()
{
    ENTRY_TEST

    tResult res = -1;
    tSlideshowTime slideshowTime = 0;
    // slideshowTime is image display period in seconds

    res = mMediaPlayerInterface.GetSlideshowTime(OUT slideshowTime);
    // NB slideshowTime = -1 is a valid value. It means the next image is not automatically displayed
    // Only slideshowTime = 0 is invalid
    GMPTEST_EXPECT(res == MP_NO_ERROR && slideshowTime != 0);
    VARTRACE(slideshowTime);
}

void MediaPlayerInterfaceTest::SetSlideshowTime()
{
    ENTRY_TEST

    tResult res = -1;
    tSlideshowTime slideshowTime = 5;

    res = mMediaPlayerInterface.SetSlideshowTime(IN slideshowTime);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    // check if stored ok
    slideshowTime = 0;
    res = mMediaPlayerInterface.GetSlideshowTime(OUT slideshowTime);
    // check returned value is the one previously written
    GMPTEST_EXPECT(res == MP_NO_ERROR && slideshowTime == 5);
}

void MediaPlayerInterfaceTest::StartSlideshow()
{
    ENTRY_TEST

    tResult res = -1;
    tListType ListType = LTY_IMAGE;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tListID listID;
    tListSize listSize;

    // set the filter tags
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    // call create list
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            IN ListType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    // test result
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(listSize > 0);

    vector<tMediaObject> mediaObjectVector;
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, listSize);
    // test result
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(mediaObjectVector.size() == listSize);

    res = mMediaPlayerInterface.StartSlideshow(IN listID, IN mediaObjectVector[0].objectID);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
}

void MediaPlayerInterfaceTest::GetSlideshowState()
{
    ENTRY_TEST

    tResult res = -1;

    // Call GetPlaybackState to check the current playback state of the MediaPlayer
    // NB no type specifically for SlideShowState
    tHMIPlaybackState playstatus;
    res = mMediaPlayerInterface.GetSlideshowState(OUT playstatus);
    ETG_TRACE_USR1(("GetSlideshowState Action : %d ", playstatus));
    GMPTEST_EXPECT(res == MP_NO_ERROR);

}

void MediaPlayerInterfaceTest::GetNowShowing()
{
    ENTRY_TEST

    tResult res = -1;

    tNowShowing nowShowing;
    InitMediaObject(nowShowing.object);

    res = mMediaPlayerInterface.GetNowShowing(OUT nowShowing);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    if (nowShowing.state != NP_NO_DEVICE)
    {
        // need to populate database before the following lines can be included
        if (nowShowing.state != NP_NEW_TRACK)  // Sometimes see NP_NEW_TRACK where title is empty
            GMPTEST_EXPECT(strlen_r(nowShowing.object.title) != 0);   // "Art-MP3-Its_Raining_Again"
        ETG_TRACE_USR1 (( "Currently showing objectID : %d fileName : %s", nowShowing.object.objectID, nowShowing.object.fileName ));
        //Currently showing objectID : 7 fileName : /albumart/Art-MP3-Its_Raining_Again.jpg
    }
}

void MediaPlayerInterfaceTest::SendSlideshowAction()
{
    ENTRY_TEST
    /**
     * Requests the slideshow action for the currently shown image list.
     * Actions include: previous or next track, play, pause and stop */
    tResult res = -1;

    tHMIPlaybackState playstatus;
    tPlaybackAction slideshowAction;
    tNextPrevSkipCount steps = 1;
    tNowShowing nowShowing;

    // STOP begin
    slideshowAction = PBA_STOP;
    res = mMediaPlayerInterface.SendSlideshowAction(slideshowAction, IN steps);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    sleep(1);
    // check the current SlideShow state of the MediaPlayer - last playback state sent to HMI
    res = mMediaPlayerInterface.GetSlideshowState(OUT playstatus);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(playstatus == HMI_PBS_STOPPED);
    // STOP end
    res = mMediaPlayerInterface.GetNowShowing(OUT nowShowing); // last Nowshowing object send to HMI
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(nowShowing.state != NP_NO_DEVICE); // list start

    // NEXT begin
    res = mMediaPlayerInterface.SendSlideshowAction(IN PBA_NEXT, IN steps);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    res = mMediaPlayerInterface.GetNowShowing(OUT nowShowing);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(nowShowing.state != NP_NO_DEVICE); // list start

    // check the current SlideShow state of the MediaPlayer
    res = mMediaPlayerInterface.SendSlideshowAction(IN PBA_PLAY, IN steps);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    sleep(1);
    res = mMediaPlayerInterface.GetSlideshowState(OUT playstatus);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);
    // NEXT end

    // PAUSE begin
    slideshowAction = PBA_PAUSE;
    res = mMediaPlayerInterface.SendSlideshowAction(slideshowAction, IN steps);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    sleep(1);
    // check the current SlideShow state of the MediaPlayer
    res = mMediaPlayerInterface.GetSlideshowState(OUT playstatus);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(playstatus == HMI_PBS_PAUSED);
    // PAUSE end

    // PLAY begin
    res = mMediaPlayerInterface.SendSlideshowAction(IN PBA_PLAY, IN steps);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    sleep(1);
    // check the current SlideShow state of the MediaPlayer
    res = mMediaPlayerInterface.GetSlideshowState(OUT playstatus);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);
    // PLAY end

    // PREV begin
    res = mMediaPlayerInterface.SendSlideshowAction(IN PBA_PREV, IN steps);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    sleep(1);
    res = mMediaPlayerInterface.SendSlideshowAction(IN PBA_PLAY, IN steps);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    sleep(1);
    // check the current SlideShow state of the MediaPlayer
    res = mMediaPlayerInterface.GetSlideshowState(OUT playstatus);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);
    // PREV end

    // STOP begin
    slideshowAction = PBA_STOP;
    res = mMediaPlayerInterface.SendSlideshowAction(slideshowAction, IN steps);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    sleep(1);
    // check the current SlideShow state of the MediaPlayer
    res = mMediaPlayerInterface.GetSlideshowState(OUT playstatus);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(playstatus == HMI_PBS_STOPPED);
    // STOP end

}


void MediaPlayerInterfaceTest::RestartOfCrashedMediaEngine()
{
    ENTRY_TEST
#ifdef TARGET_BUILD
    tResult res = -1;

    tListSize listSize = 0;
    int status;

/*
1) start playback of a media file e.g. mp3
2) simulate a crash of mediaEngine process by killing it
3) wait for nowPlaying updates of the next media file that should be played back after restart
4) if there are no updates for a certain time -> CPPUNIT ASSERT
 */
    /*play first item from a list */
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN mListID, IN 0, IN 0);
    GMPTEST_EXPECT(res == 0);

    // Check if anything is playing
    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    // Call GetPlaybackState to check the current playback state of the MediaPlayer
    tHMIPlaybackState playstatus;
    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("GetPlaybackState Action : %d ", playstatus));
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);

    int MediaEnginePId = 0;
    char PIdStr[10] = {0};

    // Find the Media Engine Process Id
    // Can use system calls in test s/w as it will not be included in production code
    res = system("ps aux | grep [m]ediaengine | $2 > /tmp/ProcessId");

    GMPTEST_EXPECT(res == MP_NO_ERROR);

    FILE *f =   fopen("/tmp/ProcessId", "r");
    if (f == NULL)
    {
        ETG_TRACE_USR1(("Error opening file"));
        MediaEnginePId = 0;
    }
    else
    {
        fgets(PIdStr, 10, f);
        fclose(f);
        MediaEnginePId = atoi(PIdStr);
    }

    if (MediaEnginePId > 0)   // value of PID = 0 -> kill signal sent to all processes
    {
        ETG_TRACE_USR1(("send kill to Media Engine-Process Id = %d", MediaEnginePId));
        kill(MediaEnginePId, SIGKILL);
    }
    else
        ETG_TRACE_USR1(("invalid Media Engine-Process Id =%d", MediaEnginePId));

    // wait for end of Media Engine process
    res = waitpid(MediaEnginePId, OUT &status, IN 0);
    if (res == -1)
    {
        ETG_TRACE_USR1(("attempted kill of Media Engine Process failed: status=%d", status));
    }
    else
        ETG_TRACE_USR1(("Media Engine Process successfully killed"));

//   res = LocalSPM::MediaEngine.StartThread();



    GMPTEST_EXPECT(res == MP_NO_ERROR);
#endif
}



void MediaPlayerInterfaceTest::DiPOActiveDevice()
{
    ENTRY_TEST
    //MediaPlayer is informed when a device is used as DiPO device

    tResult res = -1;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tDiPOActive diPOActive = true;
    tUserContext userContext;

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_IPOD, "IPOD");
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    // Initialisation of user context
    userContext.sourceAppID = tSourceAppID_init;
    userContext.registerID = tRegisterID_init;
    userContext.cmdCounter = tCmdCounter_init;
    userContext.functionID = tFunctionID_init;
    userContext.serviceID = tServiceID_init;

    res = mMediaPlayerInterface.DiPOActiveDevice(IN deviceID, IN diPOActive, IN userContext);

    GMPTEST_EXPECT(res == MP_NO_ERROR);
}

void MediaPlayerInterfaceTest::DiPORoleSwitchRequest()
{
    ENTRY_TEST
    // Requests a USB role switch: From USB client to USB host or vice versa

    tResult res = -1;

    tDeviceID deviceID;
    tDiPORoleStatus diPORoleStatus = DIPO_CLIENT_MODE;
    tUserContext userContext;
    // Initialisation of user context
    userContext.sourceAppID = tSourceAppID_init;
    userContext.registerID = tRegisterID_init;
    userContext.cmdCounter = tCmdCounter_init;
    userContext.functionID = tFunctionID_init;
    userContext.serviceID = tServiceID_init;

    memset(&userContext, 0, sizeof(userContext));

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB-2");
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    res = mMediaPlayerInterface.DiPORoleSwitchRequest(IN deviceID, IN diPORoleStatus, IN userContext);

    GMPTEST_EXPECT(res == MP_NO_ERROR);
}

void MediaPlayerInterfaceTest::DiPORoleSwitchRequiredResult()
{
    ENTRY_TEST

    tResult res = -1;

    tDeviceID deviceID;
    tDiPOSwitchReqResponse diPOSwitchReqResponse = DIPO_ROLE_SWITCH_REQUIRED_FOR_CARPLAY_AND_NATIVE_TRANSPORT;

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB-2");
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    res = mMediaPlayerInterface.DiPORoleSwitchRequiredResult(IN deviceID, IN diPOSwitchReqResponse);

    GMPTEST_EXPECT(res == MP_NO_ERROR);
}

void MediaPlayerInterfaceTest::DiPOTransferGPSData()
{
    ENTRY_TEST
    // Transfers GPS data to DiPO device

    tResult res = -1;

    tDeviceID deviceID;
    tMountPoint USBSerialNumber;
    tDiPOGPGGAData diPOGPGGAData;
    tDiPOGPRMCData diPOGPRMCData;
    tDiPOGPGSVData diPOGPGSVData;
    tDiPOGPHDTData diPOGPHDTData;
    tUserContext userContext;

    // Initialisation of user context
    userContext.sourceAppID = tSourceAppID_init;
    userContext.registerID = tRegisterID_init;
    userContext.cmdCounter = tCmdCounter_init;
    userContext.functionID = tFunctionID_init;
    userContext.serviceID = tServiceID_init;

    memset(&diPOGPGGAData, 0, sizeof(diPOGPGGAData));
    memset(&diPOGPRMCData, 0, sizeof(diPOGPRMCData));
    memset(&diPOGPGSVData, 0, sizeof(diPOGPGSVData));
    memset(&diPOGPHDTData, 0, sizeof(diPOGPHDTData));
    memset(&userContext, 0, sizeof(userContext));
    memset(USBSerialNumber, '\0', sizeof(USBSerialNumber));

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_IPOD, "IPOD");
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, deviceID); //OK to call DBManagrer here, it is not the SM thread
    if(MP_NO_ERROR != res) {
        ETG_TRACE_ERR(("LocalSPM::GetDBManager().GetDeviceInfo() failed"));
    }
    strncpy_r(USBSerialNumber, deviceInfo.appleDeviceUSBSerialNumber, sizeof(USBSerialNumber));

    res = mMediaPlayerInterface.DiPOTransferGPSData(IN deviceID, IN USBSerialNumber, IN diPOGPGGAData, IN diPOGPRMCData,
            IN diPOGPGSVData, IN diPOGPHDTData, IN userContext);

    GMPTEST_EXPECT(res == MP_NO_ERROR);
}

void MediaPlayerInterfaceTest::DiPOTransferDRData()
{
    ENTRY_TEST

    tResult res = -1;
    tDeviceID deviceID;
    tMountPoint USBSerialNumber;
    tDiPOPASCDData diPOPASCDData;
    tDiPOPAGCDData diPOPAGCDData;
    tDiPOPAACDData diPOPAACDData;
    tUserContext userContext;
    // Initialisation of user context
    userContext.sourceAppID = tSourceAppID_init;
    userContext.registerID = tRegisterID_init;
    userContext.cmdCounter = tCmdCounter_init;
    userContext.functionID = tFunctionID_init;
    userContext.serviceID = tServiceID_init;

    memset(&diPOPASCDData, 0, sizeof(diPOPASCDData));
    memset(&diPOPAGCDData, 0, sizeof(diPOPAGCDData));
    memset(&diPOPAACDData, 0, sizeof(diPOPAACDData));
    memset(&userContext, 0, sizeof(userContext));
    memset(USBSerialNumber, '\0', sizeof(USBSerialNumber));

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_IPOD, "IPOD");
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, deviceID); //OK to call DBManagrer here, it is not the SM thread
    if(MP_NO_ERROR != res) {
        ETG_TRACE_ERR(("LocalSPM::GetDBManager().GetDeviceInfo() failed"));
    }
    strncpy_r(USBSerialNumber, deviceInfo.appleDeviceUSBSerialNumber, sizeof(USBSerialNumber));

    res = mMediaPlayerInterface.DiPOTransferDRData(IN deviceID, IN USBSerialNumber, IN diPOPASCDData, IN diPOPAGCDData,
            IN diPOPAACDData, IN userContext);

    GMPTEST_EXPECT(res == MP_NO_ERROR);
}

void MediaPlayerInterfaceTest::DiPORequestAudioDevice()
{
    ENTRY_TEST

    tResult res = -1;
    tDeviceID deviceID;

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_IPOD, "IPOD");
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    res = mMediaPlayerInterface.DiPORequestAudioDevice(IN deviceID);

    GMPTEST_EXPECT(res == MP_NO_ERROR);
}

void MediaPlayerInterfaceTest::DiPOReleaseAudioDevice()
{
    ENTRY_TEST

    tResult res = -1;
    tDeviceID deviceID;

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_IPOD, "IPOD");
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    res = mMediaPlayerInterface.DiPOReleaseAudioDevice(IN deviceID);

    GMPTEST_EXPECT(res == MP_NO_ERROR);
}

void MediaPlayerInterfaceTest::StopMediaPlaybackResult()
{
    ENTRY_TEST

    tResult res = -1;

    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_IPOD, IN "IPOD");
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    res = mMediaPlayerInterface.StopMediaPlaybackResult(deviceID);

    GMPTEST_EXPECT(res == MP_NO_ERROR);
}

void MediaPlayerInterfaceTest::RequestAVActivationResult()
{
    ENTRY_TEST

    tResult res = -1;
    tSuccess success = SC_NO;

    res = mMediaPlayerInterface.RequestAVActivationResult(success);

    GMPTEST_EXPECT(res == MP_NO_ERROR);
}

void MediaPlayerInterfaceTest::RegisterUpdatePlaybackState()
{
    ENTRY_INTERNAL

    this->m_strTestcase = "RegisterUpdatePlaybackState";
    this->bLetFWValidateResult = false ;

    CListener *oListener = CListener::getCListenerInstance();
    oListener->registerCallback(this);
    oListener->startListen();
    oListener->registerEvent(EV_UPDATEPLAYBACKSTATE);
    MediaPlayerInterfaceTest::funPtr =  &MediaPlayerInterfaceTest::UpdatePlaybackStateCallback;
}

void MediaPlayerInterfaceTest::RegisterUpdatePlaytime()
{
    ENTRY_INTERNAL

    this->m_strTestcase = "RegisterUpdatePlaytime";
    this->bLetFWValidateResult = false ;

    CListener *oListener = CListener::getCListenerInstance();
    oListener->registerCallback(this);
    oListener->startListen();
    oListener->registerEvent(EV_UPDATEPLAYTIME);
    MediaPlayerInterfaceTest::funPtr =  &MediaPlayerInterfaceTest::UpdatePlaybackStateCallback;
}

void MediaPlayerInterfaceTest::RegisterNowPlaying()
{
    ENTRY_INTERNAL

    this->m_strTestcase = "RegisterNowPlaying";
    this->bLetFWValidateResult = false ;

    CListener *oListener = CListener::getCListenerInstance();
    oListener->registerCallback(this);
    oListener->startListen();
    oListener->registerEvent(EV_UPDATENOWPLAYING);
    //DataProviderTest::funPtr =  &DataProviderTest::GetMediaObjectAlbumArtInfotestCallback;
}

void MediaPlayerInterfaceTest::UpdatePlaybackStateCallback(cTestData*objTestData)
{
    ENTRY_INTERNAL
    (void)objTestData;

    ASYNC_WAIT_RELEASE;
}

void MediaPlayerInterfaceTest::PlayMediaPlayerObjectCallback(cTestData*objTestData)
{
    ENTRY_INTERNAL

    if(objTestData !=NULL)
    {
        switch(objTestData->eMSGTYPE)
        {
            case EV_UPDATEPLAYTIME:
                ETG_TRACE_USR1 (( "type %d", objTestData->mimeType));
                ETG_TRACE_USR1 (( "size %d", objTestData->mimeType));
                break;
            case EV_UPDATENOWPLAYING:
                ETG_TRACE_USR1 (( "type %d", objTestData->mimeType));
                ETG_TRACE_USR1 (( "size %d", objTestData->mimeType));
                break;
            case EV_UPDATEPLAYBACKSTATE:
                ETG_TRACE_USR1 (( "type %d", objTestData->mimeType));
                ETG_TRACE_USR1 (( "size %d", objTestData->mimeType));
                //if ( userContext.functionID == objTestData->userContext.functionID )
                //nresultObatined = 0;
                break;
            default:
                break;
        };
    }
}

void MediaPlayerInterfaceTest::CreateInternalPlaylist()
{
    ENTRY_TEST

    tResult res = -1;
    tDeviceID deviceTag = DEVICE_ID_NOT_SET;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceTag, DTY_USB,"USB");
    GMPTEST_EXPECT(res == 0);
    tDeviceInfo deviceInfo;
    res = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN deviceTag);
    string InternalPlaylistStoragePathFromConfig = LocalSPM::GetDataProvider().InternalPlaylistStoragePath();
    LocalSPM::GetDataProvider().InternalPlaylistStoragePath = deviceInfo.mountPoint;


    tPlaylistName playlistName;
    tPath playlistPath ;
    tPath playlistValidPath ;

    /*Create playlist 1 as MyList1.m3u*/
    strncpy_r(OUT playlistName, IN "MyList1.m3u", IN sizeof(playlistName));
    res = mMediaPlayerInterface.CreateInternalFileNamePlaylist(OUT playlistPath, IN deviceTag, IN playlistName);
    GMPTEST_EXPECT(res == 0);

    /*Validate if playlist 1 is created as expected path*/

    GMPTEST_EXPECT(!strcmp(playlistPath, playlistName));

    /*Create playlist 2 as MyList2.m3u*/
    strncpy_r(OUT playlistName, IN "MyList2.m3u", IN sizeof(playlistName));
    res = mMediaPlayerInterface.CreateInternalFileNamePlaylist(OUT playlistPath, IN deviceTag, IN playlistName);
    GMPTEST_EXPECT(res == 0);

    /*Validate if playlist 2 is created as expected path*/
    GMPTEST_EXPECT(!strcmp(playlistPath, playlistName));

    strncpy_r(OUT playlistName, IN "MyList3", IN sizeof(playlistName));
    res = mMediaPlayerInterface.CreateInternalFileNamePlaylist(OUT playlistPath, IN deviceTag, IN playlistName);
    GMPTEST_EXPECT(res == 0);
    /* Validating the list of internal playlist list which includes the newly created playlists MyList1.m3u and MyList2.m3u */
    tListID listID;
    tListSize listSize;
    res = mMediaPlayerInterface.CreateMediaPlayerInternalPlaylistList(OUT listID, OUT listSize, IN deviceTag);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 3);

    vector<tMediaObject> mediaObjects;
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjects, IN listID, IN 0, IN listSize);
    GMPTEST_EXPECT(res == 0);

    for (tUInt iter = 0; iter < mediaObjects.size(); iter++)
    {
        ETG_TRACE_USR1(("InternalPlaylist Filename:%s", mediaObjects.at(iter).fileName));
    }
    GMPTEST_EXPECT(!strcmp(mediaObjects.at(0).title, "MyList1.m3u"));
    GMPTEST_EXPECT(!strcmp(mediaObjects.at(1).title, "MyList2.m3u"));
    GMPTEST_EXPECT(!strcmp(mediaObjects.at(2).title, "MyList3"));
}

void MediaPlayerInterfaceTest::AddEntryToPlaylist1()
{
    ENTRY_TEST

    tResult res = -1;
    tPath playlistName = "MyList1.m3u";
    tDeviceID deviceTag = DEVICE_ID_NOT_SET;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceTag, DTY_USB,"USB");
    GMPTEST_EXPECT(res == 0);


    /*choose the internal playlist to which entry is to be added*/



    /* Select the file entries from an Indexed list and add it into already created internal playlist*/
    /* Create a indexed list for Songs*/
    tListID listID;
    tListSize listSize;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB,"USB");
    GMPTEST_EXPECT(res == 0);

    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    /*get the song slice*/
    vector<tMediaObject> mediaObjectVector;
    res =  mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector,IN listID,0,10);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() != 0);
    GMPTEST_EXPECT(mediaObjectVector.size() == 10);

    vector<tPosition>  positionVector;
    vector<string> filenamePathVector;
    /*add the songs from the indexed list slice to the internal playlist*/
    for (tUInt iter = 0; iter < mediaObjectVector.size(); iter++)
    {
        filenamePathVector.push_back(mediaObjectVector.at(iter).fileName);
        positionVector.push_back(iter);
    }
    LocalSPM::GetOutputWrapper().StartFileOperation();
    res = mMediaPlayerInterface.AddFileNamesToPlaylist(IN playlistName, IN deviceTag, IN filenamePathVector , IN positionVector);
    res = WaitForFileOperationResult();
    GMPTEST_EXPECT(res == 0);


    /*now parse the internal playlist and check if files added from the previous steps are available as part of the playlist content*/
    res = mMediaPlayerInterface.CreateMediaPlayerPlaylistList(OUT listID, OUT listSize, IN playlistName);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 10);

    vector<tFiles> fileObjects;
    res = mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT fileObjects, IN listID, IN 0, IN 10);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(fileObjects.size() == 10);

    /*validate if content of the internal playlist matches with the entries added from LTY_SONG*/
    for (tUInt iter = 0; iter < fileObjects.size(); iter++)
    {
        ETG_TRACE_USR1(("playlist entry %d:%s", iter ,fileObjects.at(iter).fileName));
    }
    GMPTEST_EXPECT(!strcmp(fileObjects.at(0).fileName, "Garbage-Garbage-06-A_Stroke_of_Luck.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(1).fileName, "Garbage-Garbage-04-As_Heaven_Is_Wide.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(2).fileName, "11-bring_em_in-evighet.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(3).fileName, "Herbert_Grönemeyer_-_Bleibt_Alles_Anders.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(4).fileName, "Garbage-Garbage-09-Dog_New_Tricks.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(5).fileName, "Herbert_Grönemeyer_-_Fanatisch.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(6).fileName, "Garbage-Garbage-11-Fix_Me_Now.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(7).fileName, "10-lady-evighet.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(8).fileName, "12-laurens_cathedral-evighet.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(9).fileName, "09-little_boy_jr-evighet.mp3"));
}


void MediaPlayerInterfaceTest::AddEntryToPlaylist2()
{
    ENTRY_TEST

    tResult res = -1;
    tPath playlistName = "MyList2.m3u";
    tDeviceID deviceTag = DEVICE_ID_NOT_SET;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceTag, DTY_USB,"USB");
    GMPTEST_EXPECT(res == 0);


    /*choose the internal playlist to which entry is to be added*/



    vector<tPosition>  positionVector;
    vector<string> filenamePathVector;

    positionVector.push_back(0);
    positionVector.push_back(1);
    positionVector.push_back(2);
    filenamePathVector.push_back("/music/Mando_Diao-Bring_Em_In-RETAIL-2002-EVIGHET/09-little_boy_jr-evighet.mp3");
    filenamePathVector.push_back("/music/Mando_Diao-Bring_Em_In-RETAIL-2002-EVIGHET/10-lady-evighet.mp3");
    filenamePathVector.push_back("/music/Garbage/Garbage-Garbage-05-Not_My_Idea.mp3");



    LocalSPM::GetOutputWrapper().StartFileOperation();
    /* add 3 file entries from different folders in to the already created playlist*/
    res = mMediaPlayerInterface.AddFileNamesToPlaylist(IN playlistName , IN deviceTag, IN filenamePathVector, IN positionVector);
    res = WaitForFileOperationResult();
    GMPTEST_EXPECT(res == 0);


    /*now parse the internal playlist and check if files added from the previous steps are available as part of the playlist content*/
    tListID listID;
    tListSize listSize;
    res = mMediaPlayerInterface.CreateMediaPlayerPlaylistList(OUT listID, OUT listSize, IN playlistName);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 3);

    vector<tFiles> fileObjects;
    res = mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT fileObjects,IN listID,IN 0,IN listSize);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(fileObjects.size() == listSize);

    /*validate if content of the internal playlist matches with the entries added from LTY_SONG*/
    for (tUInt iter = 0; iter < fileObjects.size(); iter++)
    {
        ETG_TRACE_USR1(("playlist entry %d:%s", iter ,fileObjects.at(iter).fileName));
    }
    GMPTEST_EXPECT(!strcmp(fileObjects.at(0).fileName, "09-little_boy_jr-evighet.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(1).fileName, "10-lady-evighet.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(2).fileName, "Garbage-Garbage-05-Not_My_Idea.mp3"));
}



void MediaPlayerInterfaceTest::AddEntryToPlaylistWithMultipleEntries()
{
    ENTRY_TEST

    tResult res = -1;
    tPath playlistName = "MyList3.m3u" ;
    tDeviceID deviceTag = DEVICE_ID_NOT_SET;

    int dataProviderValFromConfig  = LocalSPM::GetDataProvider().PlaylistMulipleEntriesAllowed();

    LocalSPM::GetDataProvider().PlaylistMulipleEntriesAllowed = 0;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceTag, DTY_USB,"USB");
    GMPTEST_EXPECT(res == 0);


    /*choose the internal playlist to which entry is to be added*/


    vector<tPosition>  positionVector;
    vector<string> filenamePathVector;

    positionVector.push_back(0);
    positionVector.push_back(1);
    positionVector.push_back(2);
    filenamePathVector.push_back("/music/Mando_Diao-Bring_Em_In-RETAIL-2002-EVIGHET/09-little_boy_jr-evighet.mp3");
    filenamePathVector.push_back("/music/Mando_Diao-Bring_Em_In-RETAIL-2002-EVIGHET/10-lady-evighet.mp3");
    filenamePathVector.push_back("/music/Mando_Diao-Bring_Em_In-RETAIL-2002-EVIGHET/10-lady-evighet.mp3");
    filenamePathVector.push_back("/music/Garbage/Garbage-Garbage-05-Not_My_Idea.mp3");



    LocalSPM::GetOutputWrapper().StartFileOperation();
    /* add 3 file entries from different folders in to the already created playlist*/
    res = mMediaPlayerInterface.AddFileNamesToPlaylist(IN playlistName, IN deviceTag, IN filenamePathVector, IN positionVector);
    res = WaitForFileOperationResult();
    GMPTEST_EXPECT(res == MP_ERR_LC_PLAYLIST_MULTIPLE_ENTRIS_FOUND);


    /*now parse the internal playlist and check if files added from the previous steps are available as part of the playlist content*/
    tListID listID;
    tListSize listSize;
    res = mMediaPlayerInterface.CreateMediaPlayerPlaylistList(OUT listID, OUT listSize, IN playlistName);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 3);

    vector<tFiles> fileObjects;
    res = mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT fileObjects,IN listID,IN 0,IN listSize);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(fileObjects.size() == listSize);

    /*validate if content of the internal playlist matches with the entries added from LTY_SONG*/
    for (tUInt iter = 0; iter < fileObjects.size(); iter++)
    {
        ETG_TRACE_USR1(("playlist entry %d:%s", iter ,fileObjects.at(iter).fileName));
    }
    GMPTEST_EXPECT(!strcmp(fileObjects.at(0).fileName, "09-little_boy_jr-evighet.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(1).fileName, "10-lady-evighet.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(2).fileName, "Garbage-Garbage-05-Not_My_Idea.mp3"));

    LocalSPM::GetDataProvider().PlaylistMulipleEntriesAllowed = 1;

    LocalSPM::GetOutputWrapper().StartFileOperation();

    /* add 3 file entries from different folders in to the already created playlist*/
    res = mMediaPlayerInterface.AddFileNamesToPlaylist(IN playlistName, IN deviceTag, IN filenamePathVector, IN positionVector);
    res = WaitForFileOperationResult();
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    res = mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT fileObjects,IN listID,IN 0,IN 10);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(fileObjects.size() == 7);// earlier 3 + listSize(4) =7; as we have added two times one without PlaylistMulipleEntriesAllowed and one with PlaylistMulipleEntriesAllowed

    GMPTEST_EXPECT(!strcmp(fileObjects.at(0).fileName, "09-little_boy_jr-evighet.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(1).fileName, "10-lady-evighet.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(2).fileName, "Garbage-Garbage-05-Not_My_Idea.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(3).fileName, "09-little_boy_jr-evighet.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(4).fileName, "10-lady-evighet.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(5).fileName, "10-lady-evighet.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(6).fileName, "Garbage-Garbage-05-Not_My_Idea.mp3"));
    //set the value to default value configured in dataprovider
    LocalSPM::GetDataProvider().PlaylistMulipleEntriesAllowed = dataProviderValFromConfig;
}

void MediaPlayerInterfaceTest::PlayItemFromInternalPlaylist()
{
    ENTRY_TEST

    tResult res;
    tPath playlistName =  "MyList2.m3u";
    tDeviceID deviceTag = DEVICE_ID_NOT_SET;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceTag, DTY_USB,"USB");
    GMPTEST_EXPECT(res == 0);

    /*choose the internal playlist MyList2.m3u which is already created*/




    /*now parse the internal playlist and check if files added from the previous steps are available as part of the playlist content*/
    tListID listID;
    tListSize listSize;
    res = mMediaPlayerInterface.CreateMediaPlayerPlaylistList(OUT listID, OUT listSize, IN playlistName);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 3);

    vector<tFiles> fileObjects;
    res = mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT fileObjects,IN listID,IN 0,IN listSize);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(fileObjects.size() == listSize);

    /*validate if content of the internal playlist matches with the entries added in previous test case*/
    for (tUInt iter = 0; iter < fileObjects.size(); iter++)
    {
        ETG_TRACE_USR1(("playlist entry %d:%s", iter ,fileObjects.at(iter).fileName));
    }
    GMPTEST_EXPECT(!strcmp(fileObjects.at(0).fileName, "09-little_boy_jr-evighet.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(1).fileName, "10-lady-evighet.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(2).fileName, "Garbage-Garbage-05-Not_My_Idea.mp3"));

    // play an item from the list just created
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN listID, IN 1, IN 0);
    GMPTEST_EXPECT(res == 0);

    /*Verify whether the second track in the playlist is playing*/
    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    tNowPlaying nowPlaying;
    res = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
    GMPTEST_EXPECT(res == 0);
    VARTRACE(nowPlaying);
    GMPTEST_EXPECT(!strcmp(nowPlaying.object.fileName,"/music/Mando_Diao-Bring_Em_In-RETAIL-2002-EVIGHET/10-lady-evighet.mp3"));
}

void MediaPlayerInterfaceTest::QuickPlayInternalPlaylist()
{
    ENTRY_TEST

    /* Create a list and plays an item from the list*/
    tResult res = -1;
    tListID listID;
    tListSize listSize;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    vector<tMediaObject> mediaObjectVector;

    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB,"USB");
    GMPTEST_EXPECT(res == 0);

    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_PLAYLIST_INTERNAL,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, IN listSize);
    GMPTEST_EXPECT(res == 0);

    ETG_TRACE_USR1(("mediaObjectVector.size():%d",mediaObjectVector.size()));
    GMPTEST_EXPECT(mediaObjectVector.size() == 3);
    for (tUInt iter = 0; iter < mediaObjectVector.size(); iter++)
    {
        ETG_TRACE_USR1(("Playlists category:%d,Filename:%s ", mediaObjectVector[iter].catType, mediaObjectVector[iter].fileName));
    }

    // set the filter tags
    tag1.playlist = mediaObjectVector[0].MetadataTag1;  //corresponds to a playlist
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    tListInfo listInfo;
    tPlayContinuation playContinuation = PC_NO_REPEAT;

    res = mMediaPlayerInterface.CreateQuickPlayList(
            OUT listInfo,
            IN LTY_PLAYLIST_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN playContinuation,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    // validate if nowPlaying is updated to played list item
    tNowPlaying nowPlaying;
    res = mMediaPlayerInterface.GetNowPlaying(OUT nowPlaying);
    GMPTEST_EXPECT(res == 0);
    VARTRACE(nowPlaying);

    // Call GetPlaybackState to check the current playback state of the MediaPlayer
    tHMIPlaybackState playstatus;
    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("SendPlaybackActionPrev::GetPlaybackState Action : %d ", playstatus));
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);
}

void MediaPlayerInterfaceTest::DeleteEntryFromPlaylist()
{
    ENTRY_TEST

    tResult res;
    tPath playlistName = "MyList1.m3u";
    tDeviceID deviceTag = DEVICE_ID_NOT_SET;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceTag, DTY_USB,"USB");
    GMPTEST_EXPECT(res == 0);





    vector<tPosition> PositionVector;
    PositionVector.push_back(2);
    PositionVector.push_back(4);
    PositionVector.push_back(7);

    LocalSPM::GetOutputWrapper().StartFileOperation();
    /* Deleting multiple entries from different position in the MyList1.m3u */
    res = mMediaPlayerInterface.DeleteEntriesFromPlaylist(IN playlistName, IN deviceTag, IN PositionVector);
    res = WaitForFileOperationResult();
    GMPTEST_EXPECT(res == 0);

    /*now parse the internal playlist and check if files deleted from the previous steps are not available as part of the playlist content anymore*/
    tListID listID;
    tListSize listSize;
    res = mMediaPlayerInterface.CreateMediaPlayerPlaylistList(OUT listID, OUT listSize, IN playlistName);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 7);

    vector<tFiles> fileObjects;
    res = mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT fileObjects, IN listID, IN 0, IN listSize);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(fileObjects.size() == listSize);

    /*validate if content of the internal playlist matches with the entries added from LTY_SONG*/
    for (tUInt iter = 0; iter < fileObjects.size(); iter++)
    {
        ETG_TRACE_USR1(("playlist entry %d:%s", iter ,fileObjects.at(iter).fileName));
    }
    GMPTEST_EXPECT(!strcmp(fileObjects.at(0).fileName, "Garbage-Garbage-06-A_Stroke_of_Luck.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(1).fileName, "Garbage-Garbage-04-As_Heaven_Is_Wide.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(2).fileName, "Herbert_Grönemeyer_-_Bleibt_Alles_Anders.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(3).fileName, "Garbage-Garbage-09-Dog_New_Tricks.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(4).fileName, "Garbage-Garbage-11-Fix_Me_Now.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(5).fileName, "10-lady-evighet.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(6).fileName, "12-laurens_cathedral-evighet.mp3"));
}

void MediaPlayerInterfaceTest::RenameInternalPlaylist()
{
    ENTRY_TEST

    tResult res;
    tPlaylistName oldPlaylistName = "MyList1.m3u";
    tPlaylistName newPlaylistName = "MyNewList1.m3u";
    tDeviceID deviceTag = DEVICE_ID_NOT_SET;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceTag, DTY_USB,"USB");
    GMPTEST_EXPECT(res == 0);




    /*rename the playlist*/
    res = mMediaPlayerInterface.RenameInternalPlaylist(IN deviceTag, IN oldPlaylistName, IN newPlaylistName);
    GMPTEST_EXPECT(res == 0);

    /* Validating if new title for playlist is reflected as part of playlist list slice */
    tListID listID;
    tListSize listSize;
    res = mMediaPlayerInterface.CreateMediaPlayerInternalPlaylistList(OUT listID, OUT listSize, IN deviceTag);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 3);

    /*get the slice*/
    vector<tMediaObject> mediaObjects;
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjects, IN listID, IN 0, IN listSize);
    GMPTEST_EXPECT(res == 0);

    for (tUInt iter = 0; iter < mediaObjects.size(); iter++)
    {
        ETG_TRACE_USR1(("InternalPlaylist Filename:%s", mediaObjects[iter].fileName));
        ETG_TRACE_USR1(("InternalPlaylist title:%s", mediaObjects[iter].title));
    }
    /*validate if the slice has the entry with new title*/
    GMPTEST_EXPECT(!strcmp(mediaObjects.at(2).title, "MyNewList1.m3u"));
    GMPTEST_EXPECT(!strcmp(mediaObjects.at(1).title, "MyList3"));
}

void MediaPlayerInterfaceTest::DeleteInternalPlaylist()
{
    ENTRY_TEST

    tResult res;
    tPlaylistName playlistName = "MyList2.m3u";
    tDeviceID deviceTag = DEVICE_ID_NOT_SET;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceTag, DTY_USB,"USB");
    GMPTEST_EXPECT(res == 0);



    /*delete the playlist*/
    res = mMediaPlayerInterface.DeleteInternalPlaylist(IN deviceTag, IN playlistName);
    GMPTEST_EXPECT(res == 0);

    /* Validating if playlist count is reduced after deleting a playlist*/
    tListID listID;
    tListSize listSize;
    res = mMediaPlayerInterface.CreateMediaPlayerInternalPlaylistList(OUT listID, OUT listSize, IN deviceTag);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR4(("DeleteInternalPlaylist: listSize:%d",listSize));
    GMPTEST_EXPECT(listSize == 2/*before:1*/); //Anoop please check the test here

    /*get the slice*/
    vector<tMediaObject> mediaObjects;
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjects, IN listID, IN 0, IN listSize);
    GMPTEST_EXPECT(res == 0);

    for (tUInt iter = 0; iter < mediaObjects.size(); iter++)
    {
        ETG_TRACE_USR1(("InternalPlaylist Filename:%s",  mediaObjects[iter].fileName));
    }
    /*validate if the slice has the entry with new title*/
    GMPTEST_EXPECT(!strcmp(mediaObjects.at(0).title, "MyList3"));
}

void MediaPlayerInterfaceTest::InternalPlaylist_InvalidInputsTest()
{
    ENTRY_TEST
    //

    tResult res;
    tPath playlistPath ;

    tPlaylistName oldPlaylistName = "MyList2.m3u";
    tPlaylistName newPlaylistName = "MyNewList2.m3u";

    tDeviceID deviceTag = DEVICE_ID_NOT_SET;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceTag, DTY_USB,"USB");
    GMPTEST_EXPECT(res == 0);




    // Renaming a non existing playlist.
    res = mMediaPlayerInterface.RenameInternalPlaylist(IN deviceTag, IN oldPlaylistName, IN newPlaylistName);
    GMPTEST_EXPECT(res != 0);

    // Deleting a non existing playlist.
    res = mMediaPlayerInterface.DeleteInternalPlaylist(IN deviceTag, IN playlistPath);
    GMPTEST_EXPECT(res != 0);

    vector<string> filenamePathVector;
    vector<tPosition> positionVector;

    filenamePathVector.push_back("/music/Garbage/Garbage-Garbage-05-Not_My_Idea.mp3");
    positionVector.push_back(2);

    LocalSPM::GetOutputWrapper().StartFileOperation();
    // Adding playlist entries in a non existing playlist.
    res = mMediaPlayerInterface.AddFileNamesToPlaylist(IN playlistPath, IN deviceTag, IN filenamePathVector, IN positionVector);
    res = WaitForFileOperationResult();
    GMPTEST_EXPECT(res != 0);

    sleep(2);

    LocalSPM::GetOutputWrapper().StartFileOperation();
    // Deleting the playlist entries in a non existing playlist.
    res = mMediaPlayerInterface.DeleteEntriesFromPlaylist(IN playlistPath, IN deviceTag, IN positionVector);
    res = WaitForFileOperationResult();
    GMPTEST_EXPECT(res != 0);

    strncpy_r(playlistPath, LocalSPM::GetDataProvider().InternalPlaylistStoragePath().c_str(), sizeof(playlistPath));
    strncat_r(playlistPath, "/", sizeof(playlistPath));
    strncat_r(playlistPath, "MyNewList1.m3u", sizeof(playlistPath));
    positionVector.erase(positionVector.begin(),positionVector.end());

    LocalSPM::GetOutputWrapper().StartFileOperation();
    // Adding playlist entries in an existing[valid] playlist with invalid position.
    res = mMediaPlayerInterface.AddFileNamesToPlaylist(IN playlistPath, IN deviceTag, IN filenamePathVector, IN  positionVector);
    res = WaitForFileOperationResult();
    GMPTEST_EXPECT(res != 0);

    positionVector.erase(positionVector.begin(),positionVector.end());
    positionVector.push_back(2);

    LocalSPM::GetOutputWrapper().StartFileOperation();
    // Adding playlist entries in an existing[valid] playlist with invalid position.
    res = mMediaPlayerInterface.AddFileNamesToPlaylist(IN playlistPath, IN deviceTag, IN filenamePathVector, IN positionVector);
    res = WaitForFileOperationResult();
    GMPTEST_EXPECT(res != 0);

    positionVector.erase(positionVector.begin(),positionVector.end());
    positionVector.push_back(-2);

    LocalSPM::GetOutputWrapper().StartFileOperation();
    // Deleting the playlist entries from an existing[valid] playlist with invalid position.
    res = mMediaPlayerInterface.DeleteEntriesFromPlaylist(IN playlistPath, IN deviceTag, IN positionVector);
    res = WaitForFileOperationResult();
    GMPTEST_EXPECT(res != 0);

    positionVector.erase(positionVector.begin(),positionVector.end());
    positionVector.push_back(7);

    LocalSPM::GetOutputWrapper().StartFileOperation();
    // Deleting the playlist entries from an existing[valid] playlist with invalid position.
    res = mMediaPlayerInterface.DeleteEntriesFromPlaylist(IN playlistPath, IN deviceTag, IN positionVector);
    res = WaitForFileOperationResult();
    GMPTEST_EXPECT(res != 0);
}

void MediaPlayerInterfaceTest::PlayItemFromInvalidInternalPlaylist()
{
    ENTRY_TEST



    tResult res = -1;
    tPath playlistPath = "MyList1.m3u" ;
    tDeviceID deviceTag = DEVICE_ID_NOT_SET;
    vector<string> filenamePathVector;
    vector<tPosition> positionVector;


    res = LocalSPM::GetDBManager().GetDevice(OUT deviceTag, DTY_USB,"USB");
    GMPTEST_EXPECT(res == 0);

    /*now parse the internal playlist and check if files deleted from the previous steps are not available as part of the playlist content anymore*/
    tListID listID;
    tListSize listSize;
    res = mMediaPlayerInterface.CreateMediaPlayerPlaylistList(OUT listID, OUT listSize, IN playlistPath);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 7);

    LocalSPM::GetOutputWrapper().StartFileOperation();
    res = mMediaPlayerInterface.DeleteEntriesFromPlaylist(IN playlistPath, IN deviceTag, IN positionVector);
    res = WaitForFileOperationResult();
    GMPTEST_EXPECT(res == 0);

    filenamePathVector.push_back("/Void/ABC.mp3");
    filenamePathVector.push_back("/Void/ABCD.mp3");
    filenamePathVector.push_back("/DoNotExist.mp3");
    filenamePathVector.push_back("/1/2/3/4/5/6/7/8/9/0.mp3");


    LocalSPM::GetOutputWrapper().StartFileOperation();

    /*add 4 invalid file entries to the playlist*/
    res = mMediaPlayerInterface.AddFileNamesToPlaylist(IN playlistPath, IN deviceTag, IN filenamePathVector, IN positionVector);
    res = WaitForFileOperationResult();
    GMPTEST_EXPECT(res == 0);


    /*now parse the internal playlist and check if files added from the previous steps are available as part of the playlist content*/
    res = mMediaPlayerInterface.CreateMediaPlayerPlaylistList(OUT listID, OUT listSize, IN playlistPath);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 4);

    vector<tFiles> fileObjects;
    res = mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT fileObjects, IN listID, IN 0, IN listSize);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(fileObjects.size() == listSize);

    /*validate if content of the internal playlist matches with the entries added from LTY_SONG*/
    for (tUInt iter = 0; iter < fileObjects.size(); iter++)
    {
        ETG_TRACE_USR1(("playlist entry %d:%s", iter, fileObjects.at(iter).fileName));
    }
    GMPTEST_EXPECT(!strcmp(fileObjects.at(0).fileName, "ABC.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(1).fileName, "ABCD.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(2).fileName, "DoNotExist.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(3).fileName, "0.mp3"));

    /*play first item from the list just created*/
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN listID, IN 0, IN 0);
    GMPTEST_EXPECT(res == 0);

    /*Verify if anything is playing because of error handling (playing a song of DB all songs list of device)*/
    res = WaitForPlaytimeUpdate(5);
    GMPTEST_EXPECT(res == 0);

    if(0 == LocalSPM::GetDataProvider().UseMediaEngine()) { // thoemel: the new media engine reports a file name also if the file is not playable
        tNowPlaying nowPlaying;
        for(int sec=30; sec; sec--) {
            res = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
            GMPTEST_EXPECT(res == 0);
            if (!strcmp(nowPlaying.object.fileName,"")) break;
            sleep(1);
        }
        ETG_TRACE_USR1(("nowPlaying.object.fileName='%s'", nowPlaying.object.fileName));
        GMPTEST_EXPECT(strcmp(nowPlaying.object.fileName, ""));
        GMPTEST_EXPECT(strcmp(nowPlaying.object.fileName, "ABC.mp3"));
    }

    tHMIPlaybackState playbackState;
    res = MediaPlayerInterface::GetInstance().GetPlaybackState(OUT playbackState);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(playbackState == HMI_PBS_PLAYING);
}

void MediaPlayerInterfaceTest::ResetInternalPlaylists()
{
    ENTRY_TEST

    tResult res;
    tPath playlistPath = "MyList1.m3u";
    tDeviceID deviceTag = DEVICE_ID_NOT_SET;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceTag, DTY_USB,"USB");
    GMPTEST_EXPECT(res == 0);




    /*delete the  playlist*/
    res = mMediaPlayerInterface.DeleteInternalPlaylist(IN deviceTag, IN playlistPath);
    GMPTEST_EXPECT(res == 0);




    /*delete the last remaining playlist*/
    res = mMediaPlayerInterface.DeleteInternalPlaylist(IN deviceTag, IN "MyList3.m3u");
    GMPTEST_EXPECT(res == 0);


    /* Validate if internal playlist list now has zero entries */
    tListID listID;
    tListSize listSize;
    res = mMediaPlayerInterface.CreateMediaPlayerInternalPlaylistList(OUT listID, OUT listSize, IN deviceTag);

    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 0);
}

void MediaPlayerInterfaceTest::InsertBTDevice()
{
    ENTRY_TEST

    tResult result;

    /*prepare a bt test device which supports avrcp 1.4 */
    vector<tDeviceInfo> deviceInfos;
    tDeviceInfo btDevice;
    InitDeviceInfo(INOUT btDevice);
    btDevice.deviceType = DTY_BLUETOOTH;
    strncpy_r(OUT btDevice.serialNumber, IN "aabbccddeeff", IN sizeof(btDevice.serialNumber)); // known serial number faked from the bt-daemon
    strncpy_r(OUT btDevice.deviceName, IN "DineshIphone5", IN sizeof(btDevice.deviceName));
    strncpy_r(OUT btDevice.mountPoint, IN "dev_aa_bb_cc_dd_ee_ff", IN sizeof(btDevice.mountPoint));
    btDevice.connectionState = CS_ATTACHED;
    btDevice.connectionType = DCT_BLUETOOTH;
    btDevice.disconnectReason = DR_REMOVED;
    deviceInfos.push_back(btDevice);

    result = LocalSPM::GetIndexer().SwitchDBTrigger(IN TT_ALL, IN TS_ON);
    GMPTEST_EXPECT(result == 0);
    /*insert the prepared device as connected*/
    result = MediaPlayerInterface::GetInstance().DeviceChanged(IN false /*undervoltage*/, IN deviceInfos);
    GMPTEST_EXPECT(result == 0);

    /*wait till device reaches the state connected from attached*/
    sleep(2);

    /*now validate if inserted BT device is part of deviceList available with DB */
    tDeviceID deviceID;
    result = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_BLUETOOTH);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(deviceID != DEVICE_ID_NOT_SET);

    /*validate the details of device from the DB*/
    tDeviceInfo deviceInfo;
    result = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(deviceInfo.deviceID == deviceID);
    GMPTEST_EXPECT(deviceInfo.connected == 0x01);
    GMPTEST_EXPECT(deviceInfo.deviceType == DTY_BLUETOOTH);
    GMPTEST_EXPECT(deviceInfo.connectionState == CS_CONNECTED);
    GMPTEST_EXPECT(deviceInfo.connectionType == DCT_BLUETOOTH);
    GMPTEST_EXPECT(deviceInfo.indexedState == IDS_NOT_SUPPORTED);
    GMPTEST_EXPECT(!strcmp(deviceInfo.mountPoint, "dev_aa_bb_cc_dd_ee_ff"));
    GMPTEST_EXPECT(!strcmp(deviceInfo.deviceName, "DineshIphone5"));
}

void MediaPlayerInterfaceTest::ActivateBTDevice()
{
    RETURN_ON_MEDIAENGINE_ON

    ENTRY_TEST

    tResult result;

    /*get the deviceID of the previously connected BT device from the DB*/
    tDeviceID deviceID;
    result = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_BLUETOOTH);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(deviceID != DEVICE_ID_NOT_SET);

    result = mMediaPlayerInterface.ActiveMediaDeviceSet(IN deviceID, IN true);
    GMPTEST_EXPECT(result == 0);

    sleep(3);

    tDeviceID activeDeviceID;
    result = LocalSPM::GetDBManager().GetActiveDevice(OUT activeDeviceID);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(deviceID == activeDeviceID);

    tNowPlaying nowPlaying;
    result = MediaPlayerInterface::GetInstance().GetNowPlaying(OUT nowPlaying);
    GMPTEST_EXPECT(result == 0);
    VARTRACE(nowPlaying);

    tHMIPlaybackState playbackState;
    result = MediaPlayerInterface::GetInstance().GetPlaybackState(OUT playbackState);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(playbackState == HMI_PBS_PLAYING);
}

void MediaPlayerInterfaceTest::BTDevicePlaybackAction()
{
    RETURN_ON_MEDIAENGINE_ON

    ENTRY_TEST

    tResult result;

    tPlaybackAction playbackAction = PBA_PAUSE;
    result = MediaPlayerInterface::GetInstance().SendPlaybackAction(playbackAction,0);
    GMPTEST_EXPECT(result == 0);

    sleep(1);

    tHMIPlaybackState playbackState;
    result = MediaPlayerInterface::GetInstance().GetPlaybackState(OUT playbackState);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(playbackState == HMI_PBS_PAUSED);
}

void MediaPlayerInterfaceTest::BTDeviceBrowseRootFolder()
{
    RETURN_ON_MEDIAENGINE_ON

    ENTRY_TEST

    tResult result;
    tDeviceID activeDeviceID;

    /*ensure that active device is already set as DTY_BLUETOOTH*/
    result = LocalSPM::GetDBManager().GetActiveDevice(OUT activeDeviceID);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(activeDeviceID != DEVICE_ID_NOT_SET);

    tDeviceInfo deviceInfo;
    result = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN activeDeviceID);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(deviceInfo.deviceType == DTY_BLUETOOTH);

    /*Now create file list for the BT Device */
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
    /* set the path */
    strncpy_r(OUT path, IN "/", IN sizeof(path));

    result = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN activeDeviceID);
    GMPTEST_EXPECT(result == 0);

    /*validate the list outline*/
    ETG_TRACE_USR1(("BT root folder file list size : %d\n",numberOfMediaObjects+numberOfPlayLists+numberOfFolders));
    GMPTEST_EXPECT(numberOfMediaObjects == 0);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 8);

    /*Request for the BT File list slice*/
    vector<tFiles> mediaFileVector; /* resulting entries */
    result= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, numberOfFolders);
    GMPTEST_EXPECT(result == 0);
    VARTRACE(mediaFileVector);
    /* validate the resulting slice entries */
    GMPTEST_EXPECT(mediaFileVector.size() == 8);
    GMPTEST_EXPECT(strcmp(mediaFileVector[0].fileName, "ALBUMS") == 0);
    GMPTEST_EXPECT(mediaFileVector[0].type == FT_FOLDER);
    GMPTEST_EXPECT(strcmp(mediaFileVector[1].fileName, "ARTISTS") == 0);
    GMPTEST_EXPECT(mediaFileVector[1].type == FT_FOLDER);
    GMPTEST_EXPECT(strcmp(mediaFileVector[2].fileName, "PLAYLISTS") == 0);
    GMPTEST_EXPECT(mediaFileVector[2].type == FT_FOLDER);
    GMPTEST_EXPECT(strcmp(mediaFileVector[3].fileName, "SONGS") == 0);
    GMPTEST_EXPECT(mediaFileVector[3].type == FT_FOLDER);
    GMPTEST_EXPECT(strcmp(mediaFileVector[4].fileName, "COMPILATIONS") == 0);
    GMPTEST_EXPECT(mediaFileVector[4].type == FT_FOLDER);
    GMPTEST_EXPECT(strcmp(mediaFileVector[5].fileName, "COMPOSERS") == 0);
    GMPTEST_EXPECT(mediaFileVector[5].type == FT_FOLDER);
    GMPTEST_EXPECT(strcmp(mediaFileVector[6].fileName, "GENRES") == 0);
    GMPTEST_EXPECT(mediaFileVector[6].type == FT_FOLDER);
    GMPTEST_EXPECT(strcmp(mediaFileVector[7].fileName, "PODCASTS") == 0);
    GMPTEST_EXPECT(mediaFileVector[7].type == FT_FOLDER);

}

void MediaPlayerInterfaceTest::BTDeviceBrowseSubFolder()
{
    RETURN_ON_MEDIAENGINE_ON

    ENTRY_TEST

    tResult result;
    tDeviceID activeDeviceID;

    /*ensure that active device is already set as DTY_BLUETOOTH*/
    result = LocalSPM::GetDBManager().GetActiveDevice(OUT activeDeviceID);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(activeDeviceID != DEVICE_ID_NOT_SET);

    tDeviceInfo deviceInfo;
    result = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN activeDeviceID);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(deviceInfo.deviceType == DTY_BLUETOOTH);

    /*Now create file list for the BT Device */
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
    /* set the path */
    strncpy_r(OUT path, IN "/ALBUMS", IN sizeof(path));

    result = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN activeDeviceID);
    GMPTEST_EXPECT(result == 0);

    /*validate the list outline*/
    ETG_TRACE_USR1(("BT sub folder file list size : %d\n",numberOfMediaObjects+numberOfPlayLists+numberOfFolders));
    GMPTEST_EXPECT(numberOfMediaObjects == 0);
    GMPTEST_EXPECT(numberOfPlayLists == 0);
    GMPTEST_EXPECT(numberOfFolders == 3);
    printf("BT sub folder file list  media:%d,folders:%d\n",numberOfMediaObjects,numberOfFolders);
    /*Request for the BT File list slice*/
    vector<tFiles> mediaFileVector; /* resulting entries */
    result= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, numberOfMediaObjects+numberOfPlayLists+numberOfFolders);
    GMPTEST_EXPECT(result == 0);
    VARTRACE(mediaFileVector);

    /* validate the resulting slice entries */
    GMPTEST_EXPECT(mediaFileVector.size() == 3);
    GMPTEST_EXPECT(strcmp(mediaFileVector[0].fileName, "SANGAMAM") == 0);
    GMPTEST_EXPECT(mediaFileVector[0].type == FT_FOLDER);
    GMPTEST_EXPECT(strcmp(mediaFileVector[1].fileName, "VEERA") == 0);
    GMPTEST_EXPECT(mediaFileVector[1].type == FT_FOLDER);
    GMPTEST_EXPECT(strcmp(mediaFileVector[2].fileName, "JEANS") == 0);
    GMPTEST_EXPECT(mediaFileVector[2].type == FT_FOLDER);
}

void MediaPlayerInterfaceTest::RemoveBTDevice()
{
    ENTRY_TEST

    tResult result;

    /*prepare a bt test device which supports avrcp 1.4 */
    vector<tDeviceInfo> deviceInfos;
    tDeviceInfo btDevice;
    InitDeviceInfo(INOUT btDevice);
    btDevice.deviceType = DTY_BLUETOOTH;
    strncpy_r(OUT btDevice.serialNumber, IN "aabbccddeeff", IN sizeof(btDevice.serialNumber));
    strncpy_r(OUT btDevice.deviceName, IN "DineshIphone5", IN sizeof(btDevice.deviceName));
    strncpy_r(OUT btDevice.mountPoint, IN "dev_aa_bb_cc_dd_ee_ff",IN sizeof(btDevice.mountPoint));
    btDevice.connectionState = CS_DISCONNECTED;
    btDevice.connectionType = DCT_BLUETOOTH;
    btDevice.disconnectReason = DR_REMOVED;
    deviceInfos.push_back(btDevice);

    /*before removing the device save its deviceID for later validation*/
    tDeviceID deviceID;
    result = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_BLUETOOTH);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(deviceID != DEVICE_ID_NOT_SET);

    /*insert the prepared device as connected*/
    result = MediaPlayerInterface::GetInstance().DeviceChanged(IN false /*undervoltage*/, IN deviceInfos);
    GMPTEST_EXPECT(result == 0);

    /*validate the details of device from the DB*/
    tDeviceInfo deviceInfo;
    result = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(deviceInfo.deviceID == deviceID);
    GMPTEST_EXPECT(deviceInfo.connected == 0x00);
    GMPTEST_EXPECT(deviceInfo.deviceType == DTY_BLUETOOTH);
    GMPTEST_EXPECT(deviceInfo.connectionState == CS_DISCONNECTED);

}

void MediaPlayerInterfaceTest::FindMTPDevice()
{
    tResult res;
    ENTRY_TEST

    /*find the connected MTP device if any*/
    gMTPConnected = REALDEVICECONNECTED_NO;

    LIBMTP_error_number_t ret;
    LIBMTP_mtpdevice_t *pDevice, *pDeviceList;

    ret = LIBMTP_Get_Connected_Devices(OUT &pDeviceList); ///@todo care for error case
    pDevice = NULL; // thoemel: valgrind
    if (LIBMTP_ERROR_NONE == ret)
    {
        for(pDevice = pDeviceList; pDevice != NULL; pDevice = pDevice->next)
        {
            gMTPConnected = REALDEVICECONNECTED_YES;
            break;
        }
    }

    if(pDevice == NULL || gMTPConnected == REALDEVICECONNECTED_NO) // no real device is connected
    {
        ETG_TRACE_USR1(("MediaPlayerInterfaceTest::FindMTPDevice -> No real MTP devices connected ***"));
        return;
    }

    /*if a real MTP device is connected then insert it into DB*/
    tDeviceInfo deviceInfo;
    InitDeviceInfo(INOUT deviceInfo);

    deviceInfo.connected        = 1;
    deviceInfo.deviceType       = DTY_MTP;
    deviceInfo.connectionState  = CS_CONNECTED;
    deviceInfo.disconnectReason = DR_REMOVED;

    // sim4hi 180629: separated strings from libmtp to delete after usage as fix for CID-16680, CID-16679, CID-16678
    char* mtpserial  = LIBMTP_Get_Serialnumber(pDevice);
    char* mtpversion = LIBMTP_Get_Deviceversion(pDevice);
    char* mtpname    = LIBMTP_Get_Friendlyname(pDevice);
    if (NULL == mtpserial)  mtpserial  = strdup("\0");
    if (NULL == mtpversion) mtpversion = strdup("\0");
    if (NULL == mtpname)    mtpname    = strdup("\0");
    snprintf(deviceInfo.UUID ,        sizeof (deviceInfo.UUID ),         "%s",mtpserial);//LIBMTP_Get_Serialnumber(pDevice));
    snprintf(deviceInfo.serialNumber ,sizeof (deviceInfo.serialNumber ), "%s",mtpserial);//LIBMTP_Get_Serialnumber(pDevice));
    snprintf(deviceInfo.deviceVersion,sizeof (deviceInfo.deviceVersion ),"%s",mtpversion);//LIBMTP_Get_Deviceversion(pDevice));
    snprintf(deviceInfo.deviceName,   sizeof (deviceInfo.deviceName ),   "%s",mtpname);//LIBMTP_Get_Friendlyname(pDevice));
    snprintf(deviceInfo.mountPoint ,  sizeof (deviceInfo.mountPoint),"%s/%s/%s/",mtpname,mtpversion,mtpserial);//LIBMTP_Get_Friendlyname(pDevice),LIBMTP_Get_Deviceversion(pDevice),LIBMTP_Get_Serialnumber(pDevice));
    if (NULL!=mtpserial)  free(mtpserial);
    if (NULL!=mtpversion) free(mtpversion);
    if (NULL!=mtpname)    free(mtpname);
    // sim4hi 180629: end of fix for Coverty issues (see above)

    deviceInfo.fileSystemType   = FSTY_UNKNOWN;
    deviceInfo.partitionNumber  = PARTITION_NUMBER_NONE;
    deviceInfo.productID        = 1111;
    deviceInfo.connectionType   = DCT_USB;

    //add device to DB
    res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
    GMPTEST_EXPECT(res == 0);

    /*get the deviceID of the previously connected MTP device from the DB*/
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_MTP);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(deviceID != DEVICE_ID_NOT_SET);

    res = mMediaPlayerInterface.ActiveMediaDeviceSet(IN deviceID, IN true);
    GMPTEST_EXPECT(res == 0);

    sleep(2);

    tDeviceID activeDeviceID;
    res = LocalSPM::GetDBManager().GetActiveDevice(OUT activeDeviceID);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(deviceID == activeDeviceID);
}

void BrowseMTPDevice(tDeviceID deviceID , const char *path,int maxListCount)
{
    ENTRY
    ETG_TRACE_USR1(("MediaPlayerInterfaceTest::BrowseMTPDevice path:%s",path));

    /*Now create file list for the BT Device */
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tResult result;
    static int listCount = 0;

    result = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID);
    GMPTEST_EXPECT(result == 0);

    /*validate the list outline*/
    ETG_TRACE_USR1(("MTP filelist size for path %200s:%d\n",path,numberOfMediaObjects+numberOfPlayLists+numberOfFolders));

    /*Request for the BT File list slice*/
    vector<tMediaObject> mediaFileVector; /* resulting entries */
    result= mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaFileVector, IN listID, 0, numberOfMediaObjects+numberOfPlayLists+numberOfFolders);
    GMPTEST_EXPECT(result == 0);
    VARTRACE(mediaFileVector);

    /*browse deep down recursively*/
    tUInt iter ;
    listCount++;
    for(iter = 0 ; iter < mediaFileVector.size() ; iter++ )
    {
        ETG_TRACE_USR1(("enrty name : %200s , type:%d \n",mediaFileVector[iter].fileName, mediaFileVector[iter].fileType));
        if((mediaFileVector[iter].fileType == FT_FOLDER) && (listCount <= maxListCount))
        {
            BrowseMTPDevice(deviceID,mediaFileVector[iter].fileName,maxListCount);
        }
    }
}

void MediaPlayerInterfaceTest::FileBrowseMTPDevice()
{
    ENTRY_TEST

    if(gMTPConnected == REALDEVICECONNECTED_NO) // no real device is connected
    {
        ETG_TRACE_USR1(("MediaPlayerInterfaceTest::FileBrowseMTPDevice -> No real MTP devices connected to test filebrowse***"));
        return;
    }

    tResult result;

    /*ensure that active device is already set as DTY_MTP*/
    tDeviceID activeDeviceID;
    result = LocalSPM::GetDBManager().GetActiveDevice(OUT activeDeviceID);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(activeDeviceID != DEVICE_ID_NOT_SET);

    tDeviceInfo deviceInfo;
    result = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN activeDeviceID);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(deviceInfo.deviceType == DTY_MTP);

    BrowseMTPDevice(activeDeviceID,"/",10); //browse recursively deep for first 10 paths possible

}


void MediaPlayerInterfaceTest::CDROMInsertedSetOvertempCDROM_ExpectRemoveAtIndexerSM()
{
    ENTRY_TEST

#if 0

    /* Recreate the test database without song table */
    ret = LocalSPM::GetDataProvider().RecreateTestDatabase(true, false); //after this call all components are reset because localSPM goes to Off and Normal again
    GMPTEST_EXPECT(MP_NO_ERROR == ret);

    /* Set MY_MEDIA as active device so we can free the DB entries of other devices */
    ret = LocalSPM::GetDBManager().ActiveMediaDeviceSet(IN MY_MEDIA, true);
    GMPTEST_EXPECT(MP_NO_ERROR == ret);

    /* Register DB trigger of indexer */
    ret = LocalSPM::GetIndexer().SwitchDBTrigger(IN TT_ALL, IN TS_ON);
    GMPTEST_EXPECT(MP_NO_ERROR == ret);

    /* Deregister DB_DEVICE_CONNECTED trigger of indexer to be able to test each use case separately */
    ret = LocalSPM::GetIndexer().SwitchDBTrigger(IN TT_DB_DEVICE_CONNECTED, IN TS_OFF);
    GMPTEST_EXPECT(MP_NO_ERROR == ret);
#endif

#if 0
    tDeviceInfo deviceInfoItem;
    //setup test condition (Note: could be shifted to fuxture if tests would be isolated to its own .cpp-file)
    helperPrepareCDROM(OUT deviceInfoItem);
    helperChangeDevice(IN deviceInfoItem, IN CS_ATTACHED, IN DR_REMOVED);
    //helperChangeDevice(IN deviceInfoItem, IN CS_OVERTEMP, IN DR_TEMPERATURE);

    //evaluation of test
#endif
    tBool bPlayholder = TRUE; //I'll do care with the next label
    GMPTEST_EXPECT(bPlayholder == TRUE);
}

void MediaPlayerInterfaceTest::CDROMInsertedSetOvertempCDROM_ExpectRemoveAtPlayerManagerSM()
{
    ENTRY_TEST

#if 0
    tDeviceInfo deviceInfoItem;
    //setup test condition (Note: could be shifted to fuxture if tests would be isolated to its own .cpp-file)
    helperPrepareCDROM(OUT deviceInfoItem);
    helperChangeDevice(IN deviceInfoItem, IN CS_ATTACHED, IN DR_REMOVED);
    //helperChangeDevice(IN deviceInfoItem, IN CS_OVERTEMP, IN DR_TEMPERATURE);

    //evaluation of test
#endif
    tBool bPlayholder = TRUE; //I'll do care with the next label
    GMPTEST_EXPECT(bPlayholder == TRUE);
}

void MediaPlayerInterfaceTest::CDROMInsertedSetOvertempCDROM_ExpectUpdateMPDeviveConnectionAtOutputWrapper()
{
    ENTRY_TEST

#if 0
    tDeviceInfo deviceInfoItem;
    //setup test condition (Note: could be shifted to fuxture if tests would be isolated to its own .cpp-file)
    helperPrepareCDROM(OUT deviceInfoItem);
    helperChangeDevice(IN deviceInfoItem, IN CS_ATTACHED, IN DR_REMOVED);
    //helperChangeDevice(IN deviceInfoItem, IN CS_OVERTEMP, IN DR_TEMPERATURE);

    //evaluation of test
#endif
    tBool bPlayholder = TRUE; //I'll do care with the next label
    GMPTEST_EXPECT(bPlayholder == TRUE);
}

void MediaPlayerInterfaceTest::CDROMInsertedSetOvertempCDROM_ExpectUpdateDeviceConnectionAtOutputWrapper()
{
    ENTRY_TEST

#if 0
    tDeviceInfo deviceInfoItem;
    //setup test condition (Note: could be shifted to fuxture if tests would be isolated to its own .cpp-file)
    helperPrepareCDROM(OUT deviceInfoItem);
    helperChangeDevice(IN deviceInfoItem, IN CS_ATTACHED, IN DR_REMOVED);
#endif
    tBool bPlayholder = TRUE; //I'll do care with the next label
    GMPTEST_EXPECT(bPlayholder == TRUE);
}

void MediaPlayerInterfaceTest::helperPrepareCDROM(tDeviceInfo &deviceInfoItem)
{
    ENTRY_INTERNAL

    /* Example take from trace:
       RequestDeviceManagerNotifyConnectionStatus(eUpdateClients)********** [VD_DeviceManager_service_DeviceManager.cpp(854)]
       RequestDeviceManagerNotifyConnectionStatus: m_cSerialID     : TESTID:462424963 [VD_DeviceManager_service_DeviceManager.cpp(855)]
       RequestDeviceManagerNotifyConnectionStatus: m_cUSBPort      : 1 [VD_DeviceManager_service_DeviceManager.cpp(856)]
       RequestDeviceManagerNotifyConnectionStatus: m_eDeviceType   : DTY_CDROM (11) [VD_DeviceManager_service_DeviceManager.cpp(857)]
       RequestDeviceManagerNotifyConnectionStatus: m_cDeviceVersion: DRIVE: ID_VENDOR:PIONEER_ID_MODEL:MASCA_ID_REVISION:0a87 [VD_DeviceManager_service_DeviceManager.cpp(858)]
       RequestDeviceManagerNotifyConnectionStatus: m_cDeviceName   : MP3-1501.01.0392 [VD_DeviceManager_service_DeviceManager.cpp(859)]
       RequestDeviceManagerNotifyConnectionStatus: m_cAcessoryName : /dev/sr0 [VD_DeviceManager_service_DeviceManager.cpp(860)]
       RequestDeviceManagerNotifyConnectionStatus: m_cMountPoint   : /dev/media/cdrom [VD_DeviceManager_service_DeviceManager.cpp(861)]
       RequestDeviceManagerNotifyConnectionStatus: m_eConnectStatus: USB_DEV_CONNECTED (2) [VD_DeviceManager_service_DeviceManager.cpp(862)]
       RequestDeviceManagerNotifyConnectionStatus: m_cManufacturer : Test:Manufacturer [VD_DeviceManager_service_DeviceManager.cpp(864)]
       RequestDeviceManagerNotifyConnectionStatus: m_iVendorID     : 0xdead [VD_DeviceManager_service_DeviceManager.cpp(865)]
       RequestDeviceManagerNotifyConnectionStatus: m_iProductID    : 0xbeaf [VD_DeviceManager_service_DeviceManager.cpp(866)]
       RequestDeviceManagerNotifyConnectionStatus: u64Size [KB]    : 0 [VD_DeviceManager_service_DeviceManager.cpp(867)]
       RequestDeviceManagerNotifyConnectionStatus: m_eFSType         : FSTY_ISO9660 (6) [VD_DeviceManager_service_DeviceManager.cpp(870)]
       RequestDeviceManagerNotifyConnectionStatus: m_u64TotalSize_KB : 402744 [VD_DeviceManager_service_DeviceManager.cpp(874)]
       RequestDeviceManagerNotifyConnectionStatus: m_u64UsedSize_KB  : 402744 [VD_DeviceManager_service_DeviceManager.cpp(875)]
       RequestDeviceManagerNotifyConnectionStatus: m_u64FreeSize_KB  : 0 [VD_DeviceManager_service_DeviceManager.cpp(876)]
       RequestDeviceManagerNotifyConnectionStatus: m_iValidPartitionNo: 1 [VD_DeviceManager_service_DeviceManager.cpp(879)]
       RequestDeviceManagerNotifyConnectionStatus: ->DTY_IPAD        : mapped to DTY_IPOD [VD_DeviceManager_service_DeviceManager.cpp(883)]
       RequestDeviceManagerNotifyConnectionStatus: ->DTY_SD_INTERNAL : mapped to DTY_SD [VD_DeviceManager_service_DeviceManager.cpp(889)]
     ***************RequestDeviceManagerNotifyConnectionStatus************************** [VD_DeviceManager_service_DeviceManager.cpp(893)]
     */

    deviceInfoItem.deviceType       = DTY_CDROM;
    deviceInfoItem.connectionState  = CS_DISCONNECTED;    //SET THIS CALLING helperChangeDevice
    deviceInfoItem.disconnectReason = DR_REMOVED;

    sprintf(deviceInfoItem.serialNumber,  "Kingston_DT_R400_0018F3D97163BC1121480BF8_20F1-24F7");
    sprintf(deviceInfoItem.UUID,          "Kingston_DT_R400_0018F3D97163BC1121480BF8_20F1-24F7");
    sprintf(deviceInfoItem.deviceVersion, "0100");
    sprintf(deviceInfoItem.deviceName,    "MIXED");
    sprintf(deviceInfoItem.accessoryName, "/dev/sda");
    //sprintf(deviceInfoItem.mountPoint,    "/dev/media/20F1-24F7");

#ifndef TARGET_BUILD
    strncpy_r(OUT deviceInfoItem.mountPoint, IN get_current_dir_name(), IN sizeof(deviceInfoItem.mountPoint));
    strncat_r(OUT deviceInfoItem.mountPoint, IN "/Customer/Simulation/CustomControl/stick_2/", IN sizeof(deviceInfoItem.mountPoint));
#else
    strncpy_r(OUT deviceInfoItem.mountPoint, IN "/opt/bosch/test/data/GMP/stick_2/", IN sizeof(deviceInfoItem.mountPoint));
#endif
}

void MediaPlayerInterfaceTest::helperChangeDevice(tDeviceInfo deviceInfoItem, const tConnectionState connectionState, const tDisconnectReason disconnectReason)
{
    ENTRY_INTERNAL

    tResult res = -1;

    tUndervoltage undervoltage= false;
    vector<tDeviceInfo> deviceInfos;

    //feed interface
    deviceInfoItem.connectionState = connectionState;
    deviceInfoItem.disconnectReason = disconnectReason;
    deviceInfos.push_back(deviceInfoItem);//holds at position 0 last notification
    deviceInfos.push_back(deviceInfoItem);//holds at position 1..end all connected devices
    res = MediaPlayerInterface::GetInstance().DeviceChanged(IN undervoltage, IN deviceInfos);
    GMPTEST_EXPECT(res == 0);

    //----------------EVALUATE RESULT------------------------
    //check if device can be found in database and
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tDeviceInfo deviceInfo;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN deviceInfoItem.mountPoint);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR1(("             MediaPlayerInterfaceTest::helperConnectDevice deviceID=%d ***",deviceID))
    res = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    GMPTEST_EXPECT(res == 0);

    if(deviceInfo.connectionState == CS_CONNECTED)
    {
        ETG_TRACE_USR1(("             MediaPlayerInterfaceTest::helperChangeDevice (simulated): RESULT: OK***"));
    }
    else
    {
        ETG_TRACE_USR1(("             MediaPlayerInterfaceTest::helperChangeDevice (simulated): RESULT: NOK***"));
        res = -1;
        GMPTEST_EXPECT(res == 0);
    }
}

void MediaPlayerInterfaceTest::GetImageFileCount()
{
    ENTRY_TEST

    tResult res = -1;
    tListSize listSize;

    res = mMediaPlayerInterface.GetImageFileCount(OUT listSize, IN MY_MEDIA);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize > 0);
}

void MediaPlayerInterfaceTest::PictureViewerAccordingtoFolder()
{
    ENTRY_TEST

    tResult res = -1;
    tListID listID;
    tListSize listSize;
    tListType ListType = LTY_IMAGE_FOLDER;
    tDeviceID deviceID = MY_MEDIA;
    tPath path;

    res = mMediaPlayerInterface.CreateMediaPlayerIndexedImageFolderList(
            OUT listID,
            OUT listSize,
            IN ListType,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize > 0);

#if USE_IMAGE_OBJECT
    vector<tImageObject> ImageObjectVector;
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedImageFolderListSlice(OUT ImageObjectVector, IN listID, IN 0, IN listSize);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR2(("GetlistSize: listSize=%d", ImageObjectVector.size()));
    GMPTEST_EXPECT(ImageObjectVector.size() == listSize);
    GMPTEST_EXPECT(ImageObjectVector[0].type == FT_FOLDER);
    GMPTEST_EXPECT(!strcmp(ImageObjectVector[0].path, "/albumart/"));

    strncpy_r(OUT path, IN ImageObjectVector[0].path, IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedImageFolderItemList(OUT listID, OUT listSize, IN path, IN deviceID);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listID != LIST_ID_NONE);
    GMPTEST_EXPECT(listSize > 0);

    ImageObjectVector.clear();
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedImageFolderListSlice(OUT ImageObjectVector, IN listID, IN 0, IN listSize);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(ImageObjectVector.size() == listSize);
    GMPTEST_EXPECT(ImageObjectVector[0].type == FT_IMAGE);
    GMPTEST_EXPECT(ImageObjectVector[0].fileFormat == FFT_JPEG);
    GMPTEST_EXPECT(!strcmp(ImageObjectVector[0].imageFile, "/albumart/Art-MP3-Its_Raining_Again.jpg"));
#else
    vector<tMediaObject> mediaObjectVector;
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, IN 0, IN listSize);
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR2(("GetlistSize: listSize=%d", mediaObjectVector.size()));
    GMPTEST_EXPECT(mediaObjectVector.size() == listSize);
    GMPTEST_EXPECT(mediaObjectVector[0].fileType == FT_FOLDER);
    GMPTEST_EXPECT(!strcmp(mediaObjectVector[0].path, "/albumart/"));

    strncpy_r(OUT path, IN mediaObjectVector[0].path, IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedImageFolderItemList(OUT listID, OUT listSize, IN path, IN deviceID);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listID != LIST_ID_NONE);
    GMPTEST_EXPECT(listSize > 0);

    mediaObjectVector.clear();
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, IN 0, IN listSize);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() == listSize);
    GMPTEST_EXPECT(mediaObjectVector[0].fileType == FT_IMAGE);
    GMPTEST_EXPECT(mediaObjectVector[0].fileFormat == FFT_JPEG);
    GMPTEST_EXPECT(!strcmp(mediaObjectVector[0].fileName, "/albumart/Art-MP3-Its_Raining_Again.jpg"));
    GMPTEST_EXPECT(!strcmp(mediaObjectVector[0].MetadataField1, "72x72"));
    GMPTEST_EXPECT(!strcmp(mediaObjectVector[0].MetadataField2, "3456x5184"));
    GMPTEST_EXPECT(mediaObjectVector[0].fileSize == 4230401);
#ifndef TARGET_BUILD
    GMPTEST_EXPECT(!strcmp(mediaObjectVector[0].dateTime, "2014:03:27 15:29:32"));
#endif
#endif
}

tResult MediaPlayerInterfaceTest::CheckPlaybackState(const tHMIPlaybackState stateToReach, const int timeoutInSec)
{
    ENTRY_INTERNAL
    tResult ret;
    tHMIPlaybackState playstatus = HMI_PBS_UNDEFINED;

    /* check loop */
    for(int sec=timeoutInSec; sec; sec--)
    {
        ret = LocalSPM::GetPlayerManager().GetPlaybackState(OUT playstatus);
        if (MP_NO_ERROR != ret) return ret;

        if (playstatus == stateToReach)
        {
            ETG_TRACE_USR2(("state reached: playstatus=%d", playstatus));
            return MP_NO_ERROR;
        }
        sleep(1);
    }

    ETG_TRACE_USR2(("state not reached: stateToReach=%d, playstatus=%d", stateToReach, playstatus));

    return MP_ERR_SM_GENERAL_ERROR;
}

void MediaPlayerInterfaceTest::AddUSBPortNumberInfo()
{
    ENTRY_TEST
    tResult res = -1;

    //switch on the Portnumber feature
    LocalSPM::GetDataProvider().AddPortNumberToDeviceName = 1;

    tUndervoltage undervoltage = false;
    vector<tDeviceInfo> deviceInfos;
    tDeviceInfo deviceInfoItem[3];
    InitDeviceInfo(INOUT deviceInfoItem[0]);
    InitDeviceInfo(INOUT deviceInfoItem[1]);
    InitDeviceInfo(INOUT deviceInfoItem[2]);

    //---------1st device-------------  //Add a new device#1
    deviceInfoItem[0].deviceType      = DTY_USB;
    deviceInfoItem[0].connectionState = CS_ATTACHED;
    deviceInfoItem[0].connectionType = DCT_USB;
    strncpy_r(OUT deviceInfoItem[0].serialNumber, IN "Kingston_DT_R400_0018F3D97163BC1121480BZ5", IN sizeof(deviceInfoItem[0].serialNumber));
    strncpy_r(OUT deviceInfoItem[0].deviceName, IN "GannyUSB1", IN sizeof(deviceInfoItem[0].deviceName));
    sprintf(deviceInfoItem[0].portNumber,    "1");
    strncpy_r(OUT deviceInfoItem[0].mountPoint, IN "/dev/media/GannyUSB1", IN sizeof(deviceInfoItem[0].mountPoint));

    tDeviceName test1="1:GannyUSB1";

    //---------2nd device-------------  //Add a new device#2
    deviceInfoItem[1].deviceType      = DTY_USB;
    deviceInfoItem[1].connectionState = CS_ATTACHED;
    deviceInfoItem[1].connectionType = DCT_USB;
    strncpy_r(OUT deviceInfoItem[1].serialNumber, IN "Sandisk_DT_R400_0018F3D97163BC1121480BZ7", IN sizeof(deviceInfoItem[1].serialNumber));
    strncpy_r(OUT deviceInfoItem[1].deviceName, IN "GannyUSB2", IN sizeof(deviceInfoItem[1].deviceName));
    sprintf(deviceInfoItem[1].portNumber,    "2");
    strncpy_r(OUT deviceInfoItem[1].mountPoint, IN "/dev/media/GannyUSB2", IN sizeof(deviceInfoItem[1].mountPoint));

    tDeviceName test2="2:GannyUSB2";

    //---------3rd device-------------  //Add a new device#3
    deviceInfoItem[2].deviceType      = DTY_USB;
    deviceInfoItem[2].connectionState = CS_ATTACHED;
    deviceInfoItem[2].connectionType = DCT_USB;
    strncpy_r(OUT deviceInfoItem[2].serialNumber, IN "Transcend_DT_R400_0018F3D97163BC1121480BZ9", IN sizeof(deviceInfoItem[2].serialNumber));
    strncpy_r(OUT deviceInfoItem[2].deviceName, IN "GannyUSB3", IN sizeof(deviceInfoItem[2].deviceName));
    sprintf(deviceInfoItem[2].portNumber,    "3");
    strncpy_r(OUT deviceInfoItem[2].mountPoint, IN "/dev/media/GannyUSB3", IN sizeof(deviceInfoItem[2].mountPoint));

    tDeviceName test3="3:GannyUSB3";

    //Push deviceinfo to DB
    deviceInfos.push_back(deviceInfoItem[0]);
    deviceInfos.push_back(deviceInfoItem[1]);
    deviceInfos.push_back(deviceInfoItem[2]);
    res = MediaPlayerInterface::GetInstance().DeviceChanged(IN undervoltage, IN deviceInfos);
    GMPTEST_EXPECT(res == 0);

    vector<tDeviceInfo> deviceInfoList;
    tNumberOfDevices numberOfDevices;
    res = mMediaPlayerInterface.GetMediaplayerDeviceConnections(OUT numberOfDevices, OUT deviceInfoList);
    GMPTEST_EXPECT(res == 0);


    //check if device test1 can be found in DB and accessable via Mediaplayer interface
    int iFound = 0;
    for (tUInt i = 0; i < deviceInfoList.size(); i++)
    {
        ETG_TRACE_USR1(("DeviceID : %d, DeviceName : %s", deviceInfoList.at(i).deviceID, deviceInfoList.at(i).deviceName));
        if(0 == strcmp(deviceInfoList.at(i).deviceName, test1))
        {
            iFound = 1;
            break;
        }
    }
    GMPTEST_EXPECT(iFound==1);

    //check if device test2 can be found in DB and accessable via Mediaplayer interface
    iFound = 0;
    for (tUInt i = 0; i < deviceInfoList.size(); i++)
    {
        ETG_TRACE_USR1(("DeviceID : %d, DeviceName : %s", deviceInfoList.at(i).deviceID, deviceInfoList.at(i).deviceName));
        if(0 == strcmp(deviceInfoList.at(i).deviceName, test2))
        {
            iFound = 1;
            break;
        }
    }
    GMPTEST_EXPECT(iFound==1);


    //check if device test3 can be found in DB and accessable via Mediaplayer interface
    iFound = 0;
    for (tUInt i = 0; i < deviceInfoList.size(); i++)
    {
        ETG_TRACE_USR1(("DeviceID : %d, DeviceName : %s", deviceInfoList.at(i).deviceID, deviceInfoList.at(i).deviceName));
        if(0 == strcmp(deviceInfoList.at(i).deviceName, test3))
        {
            iFound = 1;
            break;
        }
    }
    GMPTEST_EXPECT(iFound==1);

    //switch off the Portnumber feature
    LocalSPM::GetDataProvider().AddPortNumberToDeviceName = 0;
}

void MediaPlayerInterfaceTest::UpdateUSBPortNumberInfo()
{
    ENTRY_TEST
    tResult res = -1;

    //switch on the Portnumber feature
    LocalSPM::GetDataProvider().AddPortNumberToDeviceName = 1;

    tUndervoltage undervoltage = false;
    vector<tDeviceInfo> deviceInfos;
    tDeviceInfo deviceInfoItem[2];
    InitDeviceInfo(INOUT deviceInfoItem[0]);
    InitDeviceInfo(INOUT deviceInfoItem[1]);

    vector<tDeviceInfo> deviceInfoList;
    tNumberOfDevices numberOfDevices;

    //---------1st device------------- //Disconnected
    deviceInfoItem[0].deviceType      = DTY_USB;
    deviceInfoItem[0].connectionState = CS_DISCONNECTED;
    deviceInfoItem[0].connectionType = DCT_USB;
    strncpy_r(OUT deviceInfoItem[0].serialNumber, IN "Kingston_DT_R400_0018F3D97163BC1121480BZ5", IN sizeof(deviceInfoItem[0].serialNumber));
    strncpy_r(OUT deviceInfoItem[0].deviceName, IN "GannyUSB1", IN sizeof(deviceInfoItem[0].deviceName));
    sprintf(deviceInfoItem[0].portNumber,    "1");
    strncpy_r(OUT deviceInfoItem[0].mountPoint, IN "/dev/media/GannyUSB1", IN sizeof(deviceInfoItem[0].mountPoint));
    deviceInfos.push_back(deviceInfoItem[0]);
    res = MediaPlayerInterface::GetInstance().DeviceChanged(IN undervoltage, IN deviceInfos);
    GMPTEST_EXPECT(res == 0);

    //---------1st device-------------  //Checking Same DeviceID with different portnumber
    deviceInfoItem[0].deviceType      = DTY_USB;
    deviceInfoItem[0].connectionState = CS_ATTACHED;
    deviceInfoItem[0].connectionType = DCT_USB;
    strncpy_r(OUT deviceInfoItem[0].serialNumber, IN "Kingston_DT_R400_0018F3D97163BC1121480BZ5", IN sizeof(deviceInfoItem[0].serialNumber));
    strncpy_r(OUT deviceInfoItem[0].deviceName, IN "GannyUSB1", IN sizeof(deviceInfoItem[0].deviceName));
    sprintf(deviceInfoItem[0].portNumber,    "6");
    strncpy_r(OUT deviceInfoItem[0].mountPoint, IN "/dev/media/GannyUSB1", IN sizeof(deviceInfoItem[0].mountPoint));

    tDeviceName test1="6:GannyUSB1";

    //Checking already added device with same portnumber
    deviceInfoItem[1].deviceType      = DTY_USB;
    deviceInfoItem[1].connectionState = CS_ATTACHED;
    deviceInfoItem[1].connectionType = DCT_USB;
    strncpy_r(OUT deviceInfoItem[1].serialNumber, IN "Sandisk_DT_R400_0018F3D97163BC1121480BZ7", IN sizeof(deviceInfoItem[1].serialNumber));
    strncpy_r(OUT deviceInfoItem[1].deviceName, IN "GannyUSB2", IN sizeof(deviceInfoItem[1].deviceName));
    sprintf(deviceInfoItem[1].portNumber,    "2");
    strncpy_r(OUT deviceInfoItem[1].mountPoint, IN "/dev/media/GannyUSB2", IN sizeof(deviceInfoItem[1].mountPoint));

    tDeviceName test2="2:GannyUSB2";

    //Push deviceinfo to DB
    deviceInfos.push_back(deviceInfoItem[0]);
    deviceInfos.push_back(deviceInfoItem[1]);

    res = MediaPlayerInterface::GetInstance().DeviceChanged(IN undervoltage, IN deviceInfos);
    GMPTEST_EXPECT(res == 0);

    res = mMediaPlayerInterface.GetMediaplayerDeviceConnections(OUT numberOfDevices, OUT deviceInfoList);
    GMPTEST_EXPECT(res == 0);

    /*check after update that device test1 is still in db*/
    int iFound = 0;
    for (tUInt i = 0; i < deviceInfoList.size(); i++)
    {
        ETG_TRACE_USR1(("DeviceID : %d, DeviceName : %s", deviceInfoList.at(i).deviceID, deviceInfoList.at(i).deviceName));
        if(0 == strcmp(deviceInfoList.at(i).deviceName, test1))
        {
            iFound = 1;
            break;
        }
    }
    GMPTEST_EXPECT(iFound==1);


    /*check after update that device test2 is still in db*/
    iFound = 0;
    for (tUInt i = 0; i < deviceInfoList.size(); i++)
    {
        ETG_TRACE_USR1(("DeviceID : %d, DeviceName : %s", deviceInfoList.at(i).deviceID, deviceInfoList.at(i).deviceName));
        if(0 == strcmp(deviceInfoList.at(i).deviceName, test2))
        {
            iFound = 1;
            break;
        }
    }
    GMPTEST_EXPECT(iFound==1);



    //switch off the Portnumber feature
    LocalSPM::GetDataProvider().AddPortNumberToDeviceName = 0;
}

void MediaPlayerInterfaceTest::RemoveUSBPortNumberInfo()
{
    ENTRY_TEST
    tResult res = -1;

    //switch on the Portnumber feature
    LocalSPM::GetDataProvider().AddPortNumberToDeviceName = 1;

    tUndervoltage undervoltage = false;
    vector<tDeviceInfo> deviceInfos;
    tDeviceInfo deviceInfoItem;
    InitDeviceInfo(INOUT deviceInfoItem);

    //---------1st device------------- //Disconnected
    deviceInfoItem.deviceType      = DTY_USB;
    deviceInfoItem.connectionState = CS_DISCONNECTED;
    deviceInfoItem.connectionType = DCT_USB;
    strncpy_r(OUT deviceInfoItem.serialNumber, IN "Kingston_DT_R400_0018F3D97163BC1121480BZ5", IN sizeof(deviceInfoItem.serialNumber));
    strncpy_r(OUT deviceInfoItem.deviceName, IN "GannyUSB1", IN sizeof(deviceInfoItem.deviceName));
    sprintf(deviceInfoItem.portNumber,    "1");
    strncpy_r(OUT deviceInfoItem.mountPoint, IN "/dev/media/GannyUSB1", IN sizeof(deviceInfoItem.mountPoint));

    tDeviceName test1="-1:GannyUSB1";

    //Push deviceinfo to DB
    deviceInfos.push_back(deviceInfoItem);
    res = MediaPlayerInterface::GetInstance().DeviceChanged(IN undervoltage, IN deviceInfos);
    GMPTEST_EXPECT(res == 0);

    vector<tDeviceInfo> deviceInfoList;
    tNumberOfDevices numberOfDevices;
    res = mMediaPlayerInterface.GetMediaplayerDeviceConnections(OUT numberOfDevices, OUT deviceInfoList);

    GMPTEST_EXPECT(res == 0);

    //check if only device test1 is available in databas and thus accessable via mediaplayer interface
    int iFound=0;
    for (tUInt i = 0; i < deviceInfoList.size(); i++)
    {
        ETG_TRACE_USR1(("DeviceID : %d, DeviceName : %s", deviceInfoList.at(i).deviceID, deviceInfoList.at(i).deviceName));
        if(0 == strcmp(deviceInfoList.at(i).deviceName, test1))
        {
            iFound = 1;
            break;
        }
    }
    GMPTEST_EXPECT(iFound==1);

    //switch off the Portnumber feature
    LocalSPM::GetDataProvider().AddPortNumberToDeviceName = 0;
}
void MediaPlayerInterfaceTest::EnableCodesetConversion()
{
    ENTRY
    /* Enable Codesetconversion support configuration */
    int isSupported = LocalSPM::GetDataProvider().CodeSetConversionSupported();
    if (0 == isSupported)
    {
        LocalSPM::GetDataProvider().CodeSetConversionSupported = 1;

        /* recreate the test database */
        //InitTestsuite();
    }
    GMPTEST_EXPECT(true == LocalSPM::GetDataProvider().CodeSetConversionSupported());
}
void MediaPlayerInterfaceTest::DisableCodesetConversion()
{
    ENTRY

    /* Disable Codesetconversion support configuration */
    int isSupported = LocalSPM::GetDataProvider().CodeSetConversionSupported();
    if (isSupported)
    {
        LocalSPM::GetDataProvider().CodeSetConversionSupported = 0;

        /* recreate the test database */
        //InitTestsuite();
    }
    GMPTEST_EXPECT(false  == LocalSPM::GetDataProvider().CodeSetConversionSupported());
}
void MediaPlayerInterfaceTest::InsertUSBDeviceWithMultiLanguageMediaFiles()
{
    ENTRY
    tResult res;
    tDeviceID deviceID;
    tDeviceInfo deviceInfo;

    ETG_TRACE_USR2(("%s", __PRETTY_FUNCTION__));

    // add a second usb device for the test data for my media tests
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB-3");
    if (res) {
        deviceInfo.activeSource = 0;
        deviceInfo.connected = 1;
        strncpy_r(OUT deviceInfo.deviceName, IN "USB-3", IN sizeof(deviceInfo.deviceName));
        deviceInfo.deviceType = DTY_USB;
        deviceInfo.connectionState = CS_CONNECTED;
        strncpy_r(OUT deviceInfo.serialNumber, IN "987444321", IN sizeof(deviceInfo.serialNumber));
        strncpy_r(OUT deviceInfo.deviceVersion, IN "1.1", IN sizeof(deviceInfo.deviceVersion));
        strncpy_r(OUT deviceInfo.UUID, IN "3", IN sizeof(deviceInfo.UUID)); // unique
        strncpy_r(OUT deviceInfo.accessoryName, IN "/dev/sdc", IN sizeof(deviceInfo.accessoryName));
        deviceInfo.fileSystemType = FSTY_FAT;
        deviceInfo.partitionNumber = 1;
        deviceInfo.totalSize = 4194304; //4GB
        deviceInfo.freeSize = 524288; //512MB
        deviceInfo.productID = 5652;
        deviceInfo.connectionType = DCT_USB;
#if 1 // for moduletests with data stored in view
#ifndef TARGET_BUILD
        strncpy_r(OUT deviceInfo.mountPoint, IN get_current_dir_name(), IN sizeof(deviceInfo.mountPoint));
        strncat_r(OUT deviceInfo.mountPoint, IN "/Customer/Simulation/CustomControl/Multi_language_tracks", IN sizeof(deviceInfo.mountPoint));
#else
        strncpy_r(OUT deviceInfo.mountPoint, IN "/opt/bosch/test/data/GMP/Multi_language_tracks", IN sizeof(deviceInfo.mountPoint));
#endif
#else // for a test with a stick on ubuntu:
        strncpy_r(OUT deviceInfo.mountPoint, IN "/media/KINGSTON", IN sizeof(deviceInfo.mountPoint));
#endif
        res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
        GMPTEST_EXPECT(res == 0);

        /* scan the second USB test data */
        res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB-3");
        GMPTEST_EXPECT(res == 0);

        res = LocalSPM::GetDBManager().ScanDirForTest(deviceID);
        GMPTEST_EXPECT(res == 0);

        res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
        GMPTEST_EXPECT(res == 0);
    }
}
void MediaPlayerInterfaceTest::ActivateDeviceWithMultiLanguageMediaFiles()
{
    ENTRY

    ETG_TRACE_USR2(("%s", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;
    /* scan the second USB test data */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB-3");
    GMPTEST_EXPECT(res == 0);

    res = mMediaPlayerInterface.ActiveMediaDeviceSet(IN deviceID, IN true);
    GMPTEST_EXPECT(res == 0);
    ASYNC_WAIT_START(1);

    tDeviceInfo deviceInfo;
    res = mMediaPlayerInterface.ActiveMediaDeviceGet(deviceInfo);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(!strcmp(deviceInfo.deviceName, "USB-3"));
    GMPTEST_EXPECT(deviceInfo.deviceID == deviceID);
}
void MediaPlayerInterfaceTest::ValidateMediaObjectsInSysLangEnglish()
{
    ENTRY

    ETG_TRACE_USR2(("%s", __PRETTY_FUNCTION__));

    tResult res;
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID;

    // set the filter tags
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB-3");
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    // call create list
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT mMultiLanguageSongListID,
            OUT mMultiLanguageSongListSize,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    /* request slice from the list */
    vector<tMediaObject> mediaObjectVector;

    //Validate MediaObjects' title  when system Language is LNG_ENGLISH
    tLanguageType sysLanguage = LNG_NA_ENGLISH;
    res = MediaPlayerInterface::GetInstance().SetLanguage(sysLanguage);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN mMultiLanguageSongListID,
            IN 0,
            IN mMultiLanguageSongListSize);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    map<string,string> mediaObjectTitleMap;
    map<string,string>::iterator it;

    PreparemediaObjectTitleMap(INOUT mediaObjectTitleMap);

    for(unsigned int i=0; i<mediaObjectVector.size(); i++)
    {
        //Check whether the filename available in map
        it = mediaObjectTitleMap.find(mediaObjectVector[i].fileName);
        GMPTEST_EXPECT(it != mediaObjectTitleMap.end());

        //Check whether the title is same as the one stored in map
        GMPTEST_EXPECT(string(mediaObjectVector[i].title) == mediaObjectTitleMap.at(mediaObjectVector[i].fileName));
    }
}
void MediaPlayerInterfaceTest::ValidateMediaObjectsInSysLangTurkish()
{
    ENTRY
    ETG_TRACE_USR2(("%s", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;
    size_t i;

    //Validate MediaObjects' title  when system Language is LNG_TURKISH
    tLanguageType sysLanguage = LNG_TURKISH;
    res = MediaPlayerInterface::GetInstance().SetLanguage(sysLanguage);
    GMPTEST_EXPECT(res == MP_NO_ERROR);


    vector<tMediaObject> mediaObjectVector;

    res = MediaPlayerInterface::GetInstance().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN mMultiLanguageSongListID,
            IN 0,
            IN mMultiLanguageSongListSize);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    for(i=0; i<mediaObjectVector.size(); i++)
    {
        if(0 == strncmp(mediaObjectVector[i].fileName,"/ISO8859-9_Turkish.mp3",strlen_r(mediaObjectVector[i].fileName)))
        {
            GMPTEST_EXPECT(0 == strncmp(mediaObjectVector[i].title,"¡£¦©ª«¬®ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏĞÑÒÓÔÕ",strlen_r(mediaObjectVector[i].title)));
            break;
        }
    }
    GMPTEST_EXPECT(i != mediaObjectVector.size());

    // play the Turkish item from list
    tListSize listSize;
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN mMultiLanguageSongListID , i ,0);
    GMPTEST_EXPECT(res == 0);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    // validate is nowplaying is updated to played list item
    res = WaitForTitleUpdate((const char *)"¡£¦©ª«¬®ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏĞÑÒÓÔÕ");
    GMPTEST_EXPECT(res == 0);
}
void MediaPlayerInterfaceTest::ValidateMediaObjectsInSysLangArabic()
{
    ENTRY
    ETG_TRACE_USR2(("%s", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;
    size_t i;

    //Validate MediaObjects' title  when system Language is LNG_ARABIC
    tLanguageType sysLanguage = LNG_ARABIC;
    res = MediaPlayerInterface::GetInstance().SetLanguage(sysLanguage);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    vector<tMediaObject> mediaObjectVector;

    res = MediaPlayerInterface::GetInstance().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN mMultiLanguageSongListID,
            IN 0,
            IN mMultiLanguageSongListSize);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    for(i=0; i<mediaObjectVector.size(); i++)
    {
        if(0 == strncmp(mediaObjectVector[i].fileName,"/ISO8859-6_Arabic.mp3",strlen_r(mediaObjectVector[i].fileName)))
        {
            GMPTEST_EXPECT(0 == strncmp(mediaObjectVector[i].title,"ءآأؤإئابةتثجحخدذرزسشصضطظعغـفقك",strlen_r(mediaObjectVector[i].title)));
            break;
        }
    }
    GMPTEST_EXPECT(i != mediaObjectVector.size());

    // play the Arabic item from list
    tListSize listSize;
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN mMultiLanguageSongListID , i ,0);
    GMPTEST_EXPECT(res == 0);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    // validate is nowplaying is updated to played list item
    res = WaitForTitleUpdate((const char *)"ءآأؤإئابةتثجحخدذرزسشصضطظعغـفقك");
    GMPTEST_EXPECT(res == 0);
}
void MediaPlayerInterfaceTest::ValidateMediaObjectsInSysLangRussian()
{
    ENTRY
    ETG_TRACE_USR2(("%s", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;
    size_t i;

    tLanguageType sysLanguage = LNG_RUSSIAN;
    res = MediaPlayerInterface::GetInstance().SetLanguage(sysLanguage);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    vector<tMediaObject> mediaObjectVector;

    res = MediaPlayerInterface::GetInstance().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN mMultiLanguageSongListID,
            IN 0,
            IN mMultiLanguageSongListSize);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    for(i=0; i<mediaObjectVector.size(); i++)
    {
        if(0 == strncmp(mediaObjectVector[i].fileName,"/ISO8859-5_Russian.mp3",strlen_r(mediaObjectVector[i].fileName)))
        {
            GMPTEST_EXPECT(0 == strncmp(mediaObjectVector[i].title,"АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭ",strlen_r(mediaObjectVector[i].title)));
            break;
        }
    }
    GMPTEST_EXPECT(i != mediaObjectVector.size());

    // play the Russian item from list
    tListSize listSize;
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN mMultiLanguageSongListID , i ,0);
    GMPTEST_EXPECT(res == 0);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    // validate is nowplaying is updated to played list item
    res = WaitForTitleUpdate((const char *)"АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭ");
    GMPTEST_EXPECT(res == 0);
}
void MediaPlayerInterfaceTest::ValidateMediaObjectsInSysLangCroatian()
{
    ENTRY
    ETG_TRACE_USR2(("%s", __PRETTY_FUNCTION__));
    tResult res = MP_NO_ERROR;
    size_t i;

    tLanguageType sysLanguage = LNG_CROATIAN;
    res = MediaPlayerInterface::GetInstance().SetLanguage(sysLanguage);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    vector<tMediaObject> mediaObjectVector;

    res = MediaPlayerInterface::GetInstance().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN mMultiLanguageSongListID,
            IN 0,
            IN mMultiLanguageSongListSize);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    for(i=0; i<mediaObjectVector.size(); i++)
    {
        if(0 == strncmp(mediaObjectVector[i].fileName,"/ISO8859-2_Croatian.mp3",strlen_r(mediaObjectVector[i].fileName)))
        {
            GMPTEST_EXPECT(0 == strncmp(mediaObjectVector[i].title,"ĄŁŚŠŞŤŹŽŔÁÂĂÄĹĆÇČÉĘËĚÍÎĎĐŃŇÓÔŐ",strlen_r(mediaObjectVector[i].title)));
            break;
        }
    }
    GMPTEST_EXPECT(i != mediaObjectVector.size());

    // play the Croatian item from list
    tListSize listSize;
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN mMultiLanguageSongListID , i ,0);
    GMPTEST_EXPECT(res == 0);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    // validate is nowplaying is updated to played list item
    res = WaitForTitleUpdate((const char *)"ĄŁŚŠŞŤŹŽŔÁÂĂÄĹĆÇČÉĘËĚÍÎĎĐŃŇÓÔŐ");
    GMPTEST_EXPECT(res == 0);

}
void MediaPlayerInterfaceTest::ValidateMediaObjectsInSysLangGerman()
{
    ENTRY
    ETG_TRACE_USR2(("%s", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;
    size_t i;

    tLanguageType sysLanguage = LNG_GERMAN;
    res = MediaPlayerInterface::GetInstance().SetLanguage(sysLanguage);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    vector<tMediaObject> mediaObjectVector;

    res = MediaPlayerInterface::GetInstance().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN mMultiLanguageSongListID,
            IN 0,
            IN mMultiLanguageSongListSize);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    for(i=0; i<mediaObjectVector.size(); i++)
    {
        if(0 == strncmp(mediaObjectVector[i].fileName,"/ISO8859-1_German.mp3",strlen_r(mediaObjectVector[i].fileName)))
        {
            GMPTEST_EXPECT(0 == strncmp(mediaObjectVector[i].title,"ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖ×ØÙÚÛÜÝ",strlen_r(mediaObjectVector[i].title)));
            break;
        }
    }
    GMPTEST_EXPECT(i != mediaObjectVector.size());

    // play the German item from list
    tListSize listSize;
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN mMultiLanguageSongListID , i ,0);
    GMPTEST_EXPECT(res == 0);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    // validate is nowplaying is updated to played list item
    res = WaitForTitleUpdate((const char *)"ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖ×ØÙÚÛÜÝ");
    GMPTEST_EXPECT(res == 0);
}
void MediaPlayerInterfaceTest::ValidateMediaObjectsInSysLangJapanese()
{
    ENTRY
    ETG_TRACE_USR2(("%s", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;
    size_t i ;

    tLanguageType sysLanguage = LNG_JAPANESE;
    res = MediaPlayerInterface::GetInstance().SetLanguage(sysLanguage);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    vector<tMediaObject> mediaObjectVector;

    res = MediaPlayerInterface::GetInstance().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN mMultiLanguageSongListID,
            IN 0,
            IN mMultiLanguageSongListSize);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    for( i=0; i<mediaObjectVector.size(); i++)
    {
        if(0 == strncmp(mediaObjectVector[i].fileName,"/CP932_Japanese.mp3",strlen_r(mediaObjectVector[i].fileName)))
        {
            GMPTEST_EXPECT(0 == strncmp(mediaObjectVector[i].title,"ｦｧｨｩｪｫｮｯｰｱｲｳｴｵｶｷｸｹｺｻｼｽｾｿﾀﾁﾂﾃﾄﾅ",strlen_r(mediaObjectVector[i].title)));
            break;
        }
    }
    GMPTEST_EXPECT(i != mediaObjectVector.size());

    // play the Japanese item from list
    tListSize listSize;
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN mMultiLanguageSongListID , i ,0);
    GMPTEST_EXPECT(res == 0);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    // validate is nowplaying is updated to played list item
    res = WaitForTitleUpdate((const char *)"ｦｧｨｩｪｫｮｯｰｱｲｳｴｵｶｷｸｹｺｻｼｽｾｿﾀﾁﾂﾃﾄﾅ");
    GMPTEST_EXPECT(res == 0);

}
void MediaPlayerInterfaceTest::ValidateMediaObjectsInSysLangFrench()
{
    ENTRY
    ETG_TRACE_USR2(("%s", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;
    size_t i ;

    tLanguageType sysLanguage = LNG_FRENCH;
    res = MediaPlayerInterface::GetInstance().SetLanguage(sysLanguage);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    vector<tMediaObject> mediaObjectVector;

    res = MediaPlayerInterface::GetInstance().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN mMultiLanguageSongListID,
            IN 0,
            IN mMultiLanguageSongListSize);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    for(i=0; i<mediaObjectVector.size(); i++)
    {
        if(0 == strncmp(mediaObjectVector[i].fileName,"/ISO8859-15_French.mp3",strlen_r(mediaObjectVector[i].fileName)))
        {
            GMPTEST_EXPECT(0 == strncmp(mediaObjectVector[i].title,"¡¢£€¥Š§š©ª«¬®¯°±²³Žµ¶ž¹º»ŒœŸ¿",strlen_r(mediaObjectVector[i].title)));
            break;
        }
    }
    GMPTEST_EXPECT(i != mediaObjectVector.size());

    // play the French item from list
    tListSize listSize;
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN mMultiLanguageSongListID , i ,0);
    GMPTEST_EXPECT(res == 0);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    // validate is nowplaying is updated to played list item
    res = WaitForTitleUpdate((const char *)"¡¢£€¥Š§š©ª«¬®¯°±²³Žµ¶ž¹º»ŒœŸ¿");
    GMPTEST_EXPECT(res == 0);
}
void MediaPlayerInterfaceTest::ValidateMediaObjectsInSysLangThai()
{
    ENTRY
    ETG_TRACE_USR2(("%s", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;
    size_t i ;

    tLanguageType sysLanguage = LNG_THAI;
    res = MediaPlayerInterface::GetInstance().SetLanguage(sysLanguage);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    vector<tMediaObject> mediaObjectVector;

    res = MediaPlayerInterface::GetInstance().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN mMultiLanguageSongListID,
            IN 0,
            IN mMultiLanguageSongListSize);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    for(i=0; i<mediaObjectVector.size(); i++)
    {
        if(0 == strncmp(mediaObjectVector[i].fileName,"/ISO8859-11_Thai.mp3",strlen_r(mediaObjectVector[i].fileName)))
        {
            GMPTEST_EXPECT(0 == strncmp(mediaObjectVector[i].title,"กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพ",strlen_r(mediaObjectVector[i].title)));
            break;
        }
    }
    GMPTEST_EXPECT(i != mediaObjectVector.size());

    // play the Thai item from list
    tListSize listSize;
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN mMultiLanguageSongListID , i ,0);
    GMPTEST_EXPECT(res == 0);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    // validate is nowplaying is updated to played list item
    res = WaitForTitleUpdate((const char *)"กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพ");
    GMPTEST_EXPECT(res == 0);
}
void MediaPlayerInterfaceTest::ValidateMediaObjectsInSysLangGreek()
{
    ENTRY
    ETG_TRACE_USR2(("%s", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;
    size_t i ;
    tLanguageType sysLanguage = LNG_GREEK;
    res = MediaPlayerInterface::GetInstance().SetLanguage(sysLanguage);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    vector<tMediaObject> mediaObjectVector;

    res = MediaPlayerInterface::GetInstance().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN mMultiLanguageSongListID,
            IN 0,
            IN mMultiLanguageSongListSize);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    for(i=0; i<mediaObjectVector.size(); i++)
    {
        if(0 == strncmp(mediaObjectVector[i].fileName,"/ISO8859-7_Greek.mp3",strlen_r(mediaObjectVector[i].fileName)))
        {
            GMPTEST_EXPECT(0 == strncmp(mediaObjectVector[i].title,"ΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩΪΫάήέή",strlen_r(mediaObjectVector[i].title)));
            break;
        }
    }
    GMPTEST_EXPECT(i != mediaObjectVector.size());

    // play the Greek item from list
    tListSize listSize;
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN mMultiLanguageSongListID , i ,0);
    GMPTEST_EXPECT(res == 0);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    // validate is nowplaying is updated to played list item
    res = WaitForTitleUpdate((const char *)"ΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩΪΫάήέή");
    GMPTEST_EXPECT(res == 0);
}
void MediaPlayerInterfaceTest::ValidateEpisodeObjectsInSysLangArabic()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tListSize listSize;
    size_t i;
    tListType ListType = LTY_EPISODE_OF_VIDEO;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID;

    /* set the filter tags */
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = 0x0;
    tag4.tag = 0x0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetActiveDevice(OUT deviceID);
    GMPTEST_EXPECT(res == 0);

    //setting the Language
    res = mMediaPlayerInterface.SetLanguage(LNG_ARABIC);
    GMPTEST_EXPECT(res == 0);

    // call create list
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            IN ListType,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    // test result
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize > 0);

    vector<tMediaObject> mediaObjectVector;
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, listSize);

    VARTRACE(mediaObjectVector)

    // test result
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() == listSize);

    for(i=0; i<mediaObjectVector.size(); i++)
    {
        if(0 == strncmp(mediaObjectVector[i].fileName,"/o-bekhabar-Muskurahat.mp4",strlen_r(mediaObjectVector[i].fileName)))
        {
            GMPTEST_EXPECT(0 == strncmp(mediaObjectVector[i].MetadataField1,"ءآأؤإئابةتثجحخدذرزسشصضطظعغـفقك",strlen_r(mediaObjectVector[i].MetadataField1)));
            break;
        }
    }
    GMPTEST_EXPECT(i != mediaObjectVector.size());
    // play the Video Item with Arabic Metadata from list
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize, IN listID , i ,0);
    GMPTEST_EXPECT(res == 0);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    // validate is nowplaying is updated to played list item
    res = WaitForTitleUpdate((const char *)"ءآأؤإئابةتثجحخدذرزسشصضطظعغـفقك",true);
    GMPTEST_EXPECT(res == 0);
}

void MediaPlayerInterfaceTest::GetPositionInCTY_ALBUM()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    //Create Album List
    tListID listIDLtyAlbum;
    tListSize listSizeLtyAlbum;
    tFilterTag1 tag1 = { 0 };
    tFilterTag2 tag2 = { 0 };
    tFilterTag3 tag3 = { 0 };
    tFilterTag4 tag4 = { 0 };
    vector<tMediaObject> mediaObjectVectorLtyAlbum;
    //Create Albums List
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listIDLtyAlbum,
            OUT listSizeLtyAlbum,
            LTY_ALBUM,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    //Request Album List
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVectorLtyAlbum, IN listIDLtyAlbum, 0, listSizeLtyAlbum);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVectorLtyAlbum.size() == listSizeLtyAlbum);

    //Create Songs List
    tListID listIDLtySong;
    tListSize listSizeLtySong;
    vector<tMediaObject> mediaObjectVectorLtySong;
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listIDLtySong,
            OUT listSizeLtySong,
            LTY_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    //Request Song  List
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVectorLtySong, IN listIDLtySong, 0, listSizeLtySong);
    GMPTEST_EXPECT(res == 0);

    GMPTEST_EXPECT(mediaObjectVectorLtySong.size() == listSizeLtySong);

    unsigned int i;
    tPosition position = -1;
    /*Loop through Each song in LTY_SONG list*/
    for(i=0; i < listSizeLtySong; i++, position = -1)
    {
        /* For each song get its corresponding position in LTY_ALBUM list*/
        res = mMediaPlayerInterface.GetListPositionOfObject(position, listIDLtyAlbum, IN mediaObjectVectorLtySong[i].objectID);
        GMPTEST_EXPECT(res == 0);
        ETG_TRACE_USR4(("MediaPlayerInterfaceTest::GetPositionInCTY_ALBUM - GetListPositionOfObject(position) = %d",position));

        /* Make sure the position which we get in the above call is correct, by comparing it with album index in LTY_ALBUM List*/
        ETG_TRACE_USR1(("MediaPlayerInterfaceTest::GetPositionInCTY_ALBUM mediaObjectVectorLtyAlbum[position].objectID = %d",mediaObjectVectorLtyAlbum[position].objectID));
        ETG_TRACE_USR1(("MediaPlayerInterfaceTest::GetPositionInCTY_ALBUM mediaObjectVectorLtySong[i].MetadataTag4 = %d",mediaObjectVectorLtySong[i].MetadataTag4));

        GMPTEST_EXPECT(mediaObjectVectorLtyAlbum[position].objectID == mediaObjectVectorLtySong[i].MetadataTag4)
    }
}

void MediaPlayerInterfaceTest::GetAndPlayMediaObjectCTY_ALBUM()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB-3");
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    //Create Album List
    tListID listID;
    tListSize listSize;
    tFilterTag1 tag1 = { 0 };
    tFilterTag2 tag2 = { 0 };
    tFilterTag3 tag3 = { 0 };
    tFilterTag4 tag4 = { 0 };
    vector<tMediaObject> mediaObjectVector;
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_ALBUM,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    //Request Album List
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, listSize);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() == listSize);

    //Get the ObjectID of Album "a" in list
    unsigned int i;
    for(i=0; i<mediaObjectVector.size(); i++)
    {
        if(0 ==strncmp(mediaObjectVector[i].MetadataField4, "a",sizeof(mediaObjectVector[i].MetadataField4))){
            break;}
    }
    GMPTEST_EXPECT(i < mediaObjectVector.size());

    //Prepare Expected Data:ID of Album "a",MediaType,CategoryType
    tMediaObjectID objectIDExpected = mediaObjectVector[i].objectID;
    tCategoryType categoryTypeExpected = CTY_ALBUM;
    tMediaType mediaTypeExpected = MTY_MUSIC_FILE;

    tMediaObject mediaObject;
    InitMediaObject(OUT mediaObject);

    //GetMediaObject and compare result & Expected
    res = mMediaPlayerInterface.GetMediaObject(OUT mediaObject, IN mediaObjectVector[i].objectID, IN CTY_NONE);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(objectIDExpected == mediaObject.objectID);
    GMPTEST_EXPECT(categoryTypeExpected == mediaObject.catType);
    GMPTEST_EXPECT(mediaTypeExpected == mediaObject.mediaType);

    tListID playbackListID;
    tListSize playbackListSize;
    res = mMediaPlayerInterface.PlayMediaPlayerObject(OUT playbackListID, OUT playbackListSize, IN mediaObject.objectID, IN PC_NO_REPEAT);
    GMPTEST_EXPECT(res == 0);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    // validate playback of selected item
    res = WaitForTitleUpdate((const char *)"unnai kandane");
    GMPTEST_EXPECT(res == 0);
}
void MediaPlayerInterfaceTest::GetAndPlayMediaObjectCTY_SONG()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB-3");
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    //Create Songs List
    tListID listID;
    tListSize listSize;
    tFilterTag1 tag1 = { 0 };
    tFilterTag2 tag2 = { 0 };
    tFilterTag3 tag3 = { 0 };
    tFilterTag4 tag4 = { 0 };
    vector<tMediaObject> mediaObjectVector;
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);

    //Request Song  List
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, listSize);
    GMPTEST_EXPECT(res == 0);

    //Find the song with title "a"
    unsigned int i;
    for(i=0; i<mediaObjectVector.size(); i++)
    {
        if(0 ==strncmp(mediaObjectVector[i].title, "a",sizeof(mediaObjectVector[i].title))){
            break;}
    }
    GMPTEST_EXPECT(i < mediaObjectVector.size());

    //Prepare Expected Data:ID of of Song "a",MediaType,CategoryType
    tMediaObjectID objectIDExpected = mediaObjectVector[i].objectID;
    tCategoryType categoryTypeExpected = CTY_SONG;
    tMediaType mediaTypeExpected = MTY_MUSIC_FILE;

    tMediaObject mediaObject;
    InitMediaObject(OUT mediaObject);

    //GetMediaObject and compare result & Expected
    res = mMediaPlayerInterface.GetMediaObject(OUT mediaObject, IN mediaObjectVector[i].objectID, IN CTY_NONE);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(objectIDExpected == mediaObject.objectID);
    GMPTEST_EXPECT(categoryTypeExpected == mediaObject.catType);
    GMPTEST_EXPECT(mediaTypeExpected == mediaObject.mediaType);

    tListID playbackListID;
    tListSize playbackListSize;
    res = mMediaPlayerInterface.PlayMediaPlayerObject(OUT playbackListID, OUT playbackListSize, IN mediaObject.objectID, IN PC_NO_REPEAT);
    GMPTEST_EXPECT(res == 0);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    // validate playback of selected item
    res = WaitForTitleUpdate((const char *)"a");
    GMPTEST_EXPECT(res == 0);
}
void MediaPlayerInterfaceTest::GetMediaObjectLTY_PLAYLIST()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB-3");
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    //Create Playlist List
    tListID listID;
    tListSize listSize;
    tFilterTag1 tag1 = { 0 };
    tFilterTag2 tag2 = { 0 };
    tFilterTag3 tag3 = { 0 };
    tFilterTag4 tag4 = { 0 };
    vector<tMediaObject> mediaObjectVector;
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_PLAYLIST,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(listSize == 2);

    //Request Playlist List
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, listSize);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() == 2);

    res = mMediaPlayerInterface.ReleaseList(IN listID);
    GMPTEST_EXPECT(res == 0);

    //Get the ObjectID of 1st Album in list
    tMediaObjectID objectID = mediaObjectVector[0].objectID;

    //Prepare Expected Data:ID,MediaType,CategoryType
    tMediaObjectID objectIDExpected = objectID;
    tCategoryType categoryTypeExpected = CTY_PLAYLIST;
    tMediaType mediaTypeExpected = MTY_PLAYLIST;

    tMediaObject mediaObject;
    InitMediaObject(OUT mediaObject);

    //GetMediaObject and compare result & Expected
    res = mMediaPlayerInterface.GetMediaObject(OUT mediaObject, IN objectID, IN CTY_NONE);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(objectIDExpected == mediaObject.objectID);
    GMPTEST_EXPECT(categoryTypeExpected == mediaObject.catType);
    GMPTEST_EXPECT(mediaTypeExpected == mediaObject.mediaType);
}

void MediaPlayerInterfaceTest::PreparemediaObjectTitleMap(map<string,string> &mediaObjectTitleMap)
{
    mediaObjectTitleMap["/ISO8859-9_Turkish.mp3"] = "¡£¦©ª«¬®ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕ";
    mediaObjectTitleMap["/ISO8859-6_Arabic.mp3"] = "ÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖ×ØÙÚàáâã";
    mediaObjectTitleMap["/ISO8859-5_Russian.mp3"] = "°±²³´µ¶·¸¹º»¼½¾¿ÀÁÂÃÄÅÆÇÈÉÊËÌÍ";
    mediaObjectTitleMap["/ISO8859-2_Croatian.mp3"] = "¡£¦©ª«¬®ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕ";
    mediaObjectTitleMap["/ISO8859-1_German.mp3"] = "ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖ×ØÙÚÛÜÝ";
    mediaObjectTitleMap["/CP932_Japanese.mp3"] = "¦§¨©ª«®¯°±²³´µ¶·¸¹º»¼½¾¿ÀÁÂÃÄÅ";
    mediaObjectTitleMap["/ISO8859-15_French.mp3"] = "¡¢£¤¥¦§¨©ª«¬®¯°±²³´µ¶¸¹º»¼½¾¿";
    mediaObjectTitleMap["/ISO8859-11_Thai.mp3"] = "¡¢£¤¥¦§¨©ª«¬­®¯°±²³´µ¶·¸¹º»¼½¾";
    mediaObjectTitleMap["/ISO8859-7_Greek.mp3"] = "ÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÓÔÕÖ×ØÙÚÛÜÞÝÞ";
    mediaObjectTitleMap["/03.Yellae_Lama.mp3"] = "a";
    mediaObjectTitleMap["/unnai_Kandane.mp3"] = "unnai kandane";
}

void MediaPlayerInterfaceTest::SendVideoBrightness()
{
    ENTRY_TEST

    tResult res = -1;
    res = mMediaPlayerInterface.SendVideoProperty(VP_BRIGHTNESS,101);
    if(1 == LocalSPM::GetDataProvider().SetVideoProperty() || 1 == LocalSPM::GetDataProvider().SetDVDVideoProperty())
    {
        GMPTEST_EXPECT(res == 0);
        sleep(1);
        tVideoBrightness videoBrightness;
        res = mMediaPlayerInterface.GetVideoBrightness(OUT videoBrightness);
        ETG_TRACE_USR1(("SendVideoProperty::GetVideoBrightness : %d ", videoBrightness));
        GMPTEST_EXPECT(res == 0);
        GMPTEST_EXPECT(videoBrightness == 101);

        /* check for boundary condition */
        res = mMediaPlayerInterface.SendVideoProperty(VP_BRIGHTNESS,-1);
        GMPTEST_EXPECT(res == -1);
        sleep(1);
        res = mMediaPlayerInterface.GetVideoBrightness(OUT videoBrightness);
        GMPTEST_EXPECT(res == 0);
        GMPTEST_EXPECT(videoBrightness == 101);

        res = mMediaPlayerInterface.SendVideoProperty(VP_BRIGHTNESS,201);
        GMPTEST_EXPECT(res == -1);
        sleep(1);
        res = mMediaPlayerInterface.GetVideoBrightness(OUT videoBrightness);
        GMPTEST_EXPECT(res == 0);
        GMPTEST_EXPECT(videoBrightness == 101);
    }
    else
        GMPTEST_EXPECT(res == -1);
}

void MediaPlayerInterfaceTest::SendVideoHue()
{
    ENTRY_TEST

    tResult res = -1;
    res = mMediaPlayerInterface.SendVideoProperty(VP_HUE,-102);
    if(1 == LocalSPM::GetDataProvider().SetVideoProperty() || 1 == LocalSPM::GetDataProvider().SetDVDVideoProperty())
    {
        GMPTEST_EXPECT(res == 0);
        sleep(1);
        tVideoHue videoHue;
        res = mMediaPlayerInterface.GetVideoHue(OUT videoHue);
        ETG_TRACE_USR1(("SendVideoProperty::GetVideoHue : %d ", videoHue));
        GMPTEST_EXPECT(res == 0);
        GMPTEST_EXPECT(videoHue == -102);

        /* check for boundary condition */
        res = mMediaPlayerInterface.SendVideoProperty(VP_HUE,-181);
        GMPTEST_EXPECT(res == -1);
        sleep(1);
        res = mMediaPlayerInterface.GetVideoHue(OUT videoHue);
        GMPTEST_EXPECT(res == 0);
        GMPTEST_EXPECT(videoHue == -102);

        res = mMediaPlayerInterface.SendVideoProperty(VP_HUE,181);
        GMPTEST_EXPECT(res == -1);
        sleep(1);
        res = mMediaPlayerInterface.GetVideoHue(OUT videoHue);
        GMPTEST_EXPECT(res == 0);
        GMPTEST_EXPECT(videoHue == -102);
    }
    else
        GMPTEST_EXPECT(res == -1);
}

void MediaPlayerInterfaceTest::SendVideoSaturation()
{
    ENTRY_TEST

    tResult res = -1;
    res = mMediaPlayerInterface.SendVideoProperty(VP_SATURATION,103);
    if(1 == LocalSPM::GetDataProvider().SetVideoProperty() || 1 == LocalSPM::GetDataProvider().SetDVDVideoProperty())
    {
        GMPTEST_EXPECT(res == 0);
        sleep(1);
        tVideoSaturation videoSaturation;
        res = mMediaPlayerInterface.GetVideoSaturation(OUT videoSaturation);
        ETG_TRACE_USR1(("SendVideoProperty::GetVideoSaturation : %d ", videoSaturation));
        GMPTEST_EXPECT(res == 0);
        GMPTEST_EXPECT(videoSaturation == 103);

        /* check for boundary condition */
        res = mMediaPlayerInterface.SendVideoProperty(VP_SATURATION,-1);
        GMPTEST_EXPECT(res == -1);
        sleep(1);
        res = mMediaPlayerInterface.GetVideoSaturation(OUT videoSaturation);
        GMPTEST_EXPECT(res == 0);
        GMPTEST_EXPECT(videoSaturation == 103);

        res = mMediaPlayerInterface.SendVideoProperty(VP_SATURATION,201);
        GMPTEST_EXPECT(res == -1);
        sleep(1);
        res = mMediaPlayerInterface.GetVideoSaturation(OUT videoSaturation);
        GMPTEST_EXPECT(res == 0);
        GMPTEST_EXPECT(videoSaturation == 103);
    }
    else
        GMPTEST_EXPECT(res == -1);
}

void MediaPlayerInterfaceTest::SendVideoContrast()
{
    ENTRY_TEST

    tResult res = -1;
    res = mMediaPlayerInterface.SendVideoProperty(VP_CONTRAST,104);
    if(1 == LocalSPM::GetDataProvider().SetVideoProperty() || 1 == LocalSPM::GetDataProvider().SetDVDVideoProperty())
    {
        GMPTEST_EXPECT(res == 0);
        sleep(1);
        tVideoContrast videoContrast;
        res = mMediaPlayerInterface.GetVideoContrast(OUT videoContrast);
        ETG_TRACE_USR1(("SendVideoProperty::GetVideoContrast : %d ", videoContrast));
        GMPTEST_EXPECT(res == 0);
        GMPTEST_EXPECT(videoContrast == 104);

        /* check for boundary condition */
        res = mMediaPlayerInterface.SendVideoProperty(VP_CONTRAST,-1);
        GMPTEST_EXPECT(res == -1);
        sleep(1);
        res = mMediaPlayerInterface.GetVideoContrast(OUT videoContrast);
        GMPTEST_EXPECT(res == 0);
        GMPTEST_EXPECT(videoContrast == 104);

        res = mMediaPlayerInterface.SendVideoProperty(VP_CONTRAST,201);
        GMPTEST_EXPECT(res == -1);
        sleep(1);
        res = mMediaPlayerInterface.GetVideoContrast(OUT videoContrast);
        GMPTEST_EXPECT(res == 0);
        GMPTEST_EXPECT(videoContrast == 104);
    }
    else
        GMPTEST_EXPECT(res == -1);
}

void MediaPlayerInterfaceTest::SendVideoBrightnessOffset()
{
    ENTRY_TEST

    tResult res = -1;
    res = mMediaPlayerInterface.SendVideoProperty(VP_BRIGHTNESS_OFFSET,50);
    if(1 == LocalSPM::GetDataProvider().SetVideoProperty() || 1 == LocalSPM::GetDataProvider().SetDVDVideoProperty())
    {
        GMPTEST_EXPECT(res == 0);
        sleep(1);
        tVideoBrightnessOffset videoBrightnessOffset;
        res = mMediaPlayerInterface.GetVideoBrightnessOffset(OUT videoBrightnessOffset);
        ETG_TRACE_USR1(("SendVideoProperty::GetVideoBrightnessOffset : %d ", videoBrightnessOffset));
        GMPTEST_EXPECT(res == 0);
        GMPTEST_EXPECT(videoBrightnessOffset == 50);

        /* check for boundary condition */
        res = mMediaPlayerInterface.SendVideoProperty(VP_BRIGHTNESS_OFFSET,-101);
        GMPTEST_EXPECT(res == -1);
        sleep(1);
        res = mMediaPlayerInterface.GetVideoBrightnessOffset(OUT videoBrightnessOffset);
        GMPTEST_EXPECT(res == 0);
        GMPTEST_EXPECT(videoBrightnessOffset == 50);

        res = mMediaPlayerInterface.SendVideoProperty(VP_BRIGHTNESS_OFFSET,101);
        GMPTEST_EXPECT(res == -1);
        sleep(1);
        res = mMediaPlayerInterface.GetVideoBrightnessOffset(OUT videoBrightnessOffset);
        GMPTEST_EXPECT(res == 0);
        GMPTEST_EXPECT(videoBrightnessOffset == 50);
    }
    else
        GMPTEST_EXPECT(res == -1);
}

void MediaPlayerInterfaceTest::SendVideoHueOffset()
{
    ENTRY_TEST

    tResult res = -1;
    res = mMediaPlayerInterface.SendVideoProperty(VP_HUE_OFFSET,107);
    if(1 == LocalSPM::GetDataProvider().SetVideoProperty() || 1 == LocalSPM::GetDataProvider().SetDVDVideoProperty())
    {
        GMPTEST_EXPECT(res == 0);
        sleep(1);
        tVideoHueOffset videoHueOffset;
        res = mMediaPlayerInterface.GetVideoHueOffset(OUT videoHueOffset);
        ETG_TRACE_USR1(("SendVideoProperty::GetVideoHueOffset : %d ", videoHueOffset));
        GMPTEST_EXPECT(res == 0);
        GMPTEST_EXPECT(videoHueOffset == 107);

        /* check for boundary condition */
        res = mMediaPlayerInterface.SendVideoProperty(VP_HUE_OFFSET,-181);
        GMPTEST_EXPECT(res == -1);
        sleep(1);
        res = mMediaPlayerInterface.GetVideoHueOffset(OUT videoHueOffset);
        GMPTEST_EXPECT(res == 0);
        GMPTEST_EXPECT(videoHueOffset == 107);

        res = mMediaPlayerInterface.SendVideoProperty(VP_HUE_OFFSET,181);
        GMPTEST_EXPECT(res == -1);
        sleep(1);
        res = mMediaPlayerInterface.GetVideoHueOffset(OUT videoHueOffset);
        GMPTEST_EXPECT(res == 0);
        GMPTEST_EXPECT(videoHueOffset == 107);
    }
    else
        GMPTEST_EXPECT(res == -1);
}

void MediaPlayerInterfaceTest::SendVideoSaturationOffset()
{
    ENTRY_TEST

    tResult res = -1;
    res = mMediaPlayerInterface.SendVideoProperty(VP_SATURATION_OFFSET,106);
    if(1 == LocalSPM::GetDataProvider().SetVideoProperty() || 1 == LocalSPM::GetDataProvider().SetDVDVideoProperty())
    {
        GMPTEST_EXPECT(res == 0);
        sleep(1);
        tVideoSaturationOffset videoSaturationOffset;
        res = mMediaPlayerInterface.GetVideoSaturationOffset(OUT videoSaturationOffset);
        ETG_TRACE_USR1(("SendVideoProperty::GetVideoSaturationOffset : %d ", videoSaturationOffset));
        GMPTEST_EXPECT(res == 0);
        GMPTEST_EXPECT(videoSaturationOffset == 106);

        /* check for boundary condition */
        res = mMediaPlayerInterface.SendVideoProperty(VP_SATURATION_OFFSET,-1);
        GMPTEST_EXPECT(res == -1);
        sleep(1);
        res = mMediaPlayerInterface.GetVideoSaturationOffset(OUT videoSaturationOffset);
        GMPTEST_EXPECT(res == 0);
        GMPTEST_EXPECT(videoSaturationOffset == 106);

        res = mMediaPlayerInterface.SendVideoProperty(VP_SATURATION_OFFSET,201);
        GMPTEST_EXPECT(res == -1);
        sleep(1);
        res = mMediaPlayerInterface.GetVideoSaturationOffset(OUT videoSaturationOffset);
        GMPTEST_EXPECT(res == 0);
        GMPTEST_EXPECT(videoSaturationOffset == 106);
    }
    else
        GMPTEST_EXPECT(res == -1);
}

void MediaPlayerInterfaceTest::DisableAutoPlayInLastModePause()
{
    ENTRY_TEST

    LocalSPM::GetDataProvider().AutoPlayInLastModePause = 0;

    GMPTEST_EXPECT(false == LocalSPM::GetDataProvider().AutoPlayInLastModePause());
}

void MediaPlayerInterfaceTest::EnableAutoPlayInLastModePause()
{
    ENTRY_TEST
    LocalSPM::GetDataProvider().AutoPlayInLastModePause = 1;

    GMPTEST_EXPECT(true == LocalSPM::GetDataProvider().AutoPlayInLastModePause());
}

void MediaPlayerInterfaceTest::SendClearLastModePause()
{
    ENTRY_TEST
    tResult res = MP_NO_ERROR;
    tDeviceID activeDeviceID;

    res = LocalSPM::GetDBManager().GetActiveDevice(OUT activeDeviceID);
    GMPTEST_EXPECT(MP_NO_ERROR == res);

    res = mMediaPlayerInterface.ClearLastModePause(IN activeDeviceID);
    GMPTEST_EXPECT(MP_NO_ERROR == res);
}

void MediaPlayerInterfaceTest::CheckPlaybackStatePLAYING()
{
    ENTRY_TEST
    tResult res = MP_NO_ERROR;

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == 0);

    // Call GetPlaybackState to check the current playback state of the MediaPlayer
    tHMIPlaybackState playstatus;
    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1((" PlayItemFromList::CheckPlaybackStatePLAYING playstatus : %d ", playstatus));
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);
}

void  MediaPlayerInterfaceTest::CheckPlaybackStateSTOPPED()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    sleep(1);

    // Call GetPlaybackState to check the current playback state of the MediaPlayer
    tHMIPlaybackState playstatus;
    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("CheckPlaybackStateSTOPPED Action : %d ", playstatus));
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_STOPPED);
}


void MediaPlayerInterfaceTest::MultipartitionDeviceCheck_AllValidPartitions()
{
    ENTRY_TEST
    tResult res = -1;

    //switch on the MultiPartitionSupported feature
    LocalSPM::GetDataProvider().MultiPartitionSupported = 1;

    tUndervoltage undervoltage = false;
    vector<tDeviceInfo> deviceInfos;
    tDeviceInfo deviceInfoItem[4];
    InitDeviceInfo(INOUT deviceInfoItem[0]);
    InitDeviceInfo(INOUT deviceInfoItem[1]);
    InitDeviceInfo(INOUT deviceInfoItem[2]);
    InitDeviceInfo(INOUT deviceInfoItem[3]);

    //---------1st device- 1st Partition-------------  //Add a new partition #1 for device#1
    deviceInfoItem[0].deviceType      = DTY_USB;
    deviceInfoItem[0].connectionState = CS_ATTACHED;
    deviceInfoItem[0].fileSystemType = FSTY_FAT;
    strncpy_r(OUT deviceInfoItem[0].serialNumber, IN "Kingston_DT_R400_0018F3D97163BC1121480BZ5", IN sizeof(deviceInfoItem[0].serialNumber));
    strncpy_r(OUT deviceInfoItem[0].deviceName, IN "USB1_Part1", IN sizeof(deviceInfoItem[0].deviceName));
    strncpy_r(OUT deviceInfoItem[0].accessoryName2, IN "Kingston_DT_R400_", IN sizeof(deviceInfoItem[0].accessoryName2));
    strncpy_r(OUT deviceInfoItem[0].mountPoint, IN "/dev/media/USB1.1", IN sizeof(deviceInfoItem[0].mountPoint));
    strncpy_r(OUT deviceInfoItem[0].accessoryName2, IN "Kingston_DT_R400", IN sizeof(deviceInfoItem[0].accessoryName2));

    //---------1st device- 2nd Partition-------------  //Add a new partition #2 for device#1
    deviceInfoItem[1].deviceType      = DTY_USB;
    deviceInfoItem[1].connectionState = CS_ATTACHED;
    deviceInfoItem[1].fileSystemType = FSTY_FAT;
    strncpy_r(OUT deviceInfoItem[1].serialNumber, IN "Kingston_DT_R400_LM3444D97163BC112R324421", IN sizeof(deviceInfoItem[1].serialNumber));
    strncpy_r(OUT deviceInfoItem[1].deviceName, IN "USB1_Part2", IN sizeof(deviceInfoItem[1].deviceName));
    strncpy_r(OUT deviceInfoItem[1].accessoryName2, IN "Kingston_DT_R400_", IN sizeof(deviceInfoItem[1].accessoryName2));
    strncpy_r(OUT deviceInfoItem[1].mountPoint, IN "/dev/media/USB1.2", IN sizeof(deviceInfoItem[1].mountPoint));
    strncpy_r(OUT deviceInfoItem[1].accessoryName2, IN "Kingston_DT_R400", IN sizeof(deviceInfoItem[1].accessoryName2));

    //---------1st device- 3rd Partition-------------  //Add a new partition #3 for device#1
    deviceInfoItem[2].deviceType      = DTY_USB;
    deviceInfoItem[2].connectionState = CS_ATTACHED;
    deviceInfoItem[2].fileSystemType = FSTY_FAT;
    strncpy_r(OUT deviceInfoItem[2].serialNumber, IN "Kingston_DT_R400_K22RTD97163BC111234445Z", IN sizeof(deviceInfoItem[2].serialNumber));
    strncpy_r(OUT deviceInfoItem[2].deviceName, IN "USB1_Part3", IN sizeof(deviceInfoItem[2].deviceName));
    strncpy_r(OUT deviceInfoItem[2].accessoryName2, IN "Kingston_DT_R400_", IN sizeof(deviceInfoItem[2].accessoryName2));
    strncpy_r(OUT deviceInfoItem[2].mountPoint, IN "/dev/media/USB1.3", IN sizeof(deviceInfoItem[2].mountPoint));
    strncpy_r(OUT deviceInfoItem[2].accessoryName2, IN "Kingston_DT_R400", IN sizeof(deviceInfoItem[2].accessoryName2));

    //---------1st device- 4th Partition-------------  //Add a new partition #4 for device#1
    deviceInfoItem[3].deviceType      = DTY_USB;
    deviceInfoItem[3].connectionState = CS_ATTACHED;
    deviceInfoItem[3].fileSystemType = FSTY_FAT;
    strncpy_r(OUT deviceInfoItem[3].serialNumber, IN "Kingston_DT_R400_R33GF3D97163BC11C234RT", IN sizeof(deviceInfoItem[3].serialNumber));
    strncpy_r(OUT deviceInfoItem[3].deviceName, IN "USB1_Part4", IN sizeof(deviceInfoItem[3].deviceName));
    strncpy_r(OUT deviceInfoItem[3].accessoryName2, IN "Kingston_DT_R400_", IN sizeof(deviceInfoItem[3].accessoryName2));
    strncpy_r(OUT deviceInfoItem[3].mountPoint, IN "/dev/media/USB1.4", IN sizeof(deviceInfoItem[3].mountPoint));
    strncpy_r(OUT deviceInfoItem[3].accessoryName2, IN "Kingston_DT_R400", IN sizeof(deviceInfoItem[3].accessoryName2));


    //Push deviceinfo to DB
    deviceInfos.push_back(deviceInfoItem[0]);
    deviceInfos.push_back(deviceInfoItem[1]);
    deviceInfos.push_back(deviceInfoItem[2]);
    deviceInfos.push_back(deviceInfoItem[3]);
    res = MediaPlayerInterface::GetInstance().DeviceChanged(IN undervoltage, IN deviceInfos);
    GMPTEST_EXPECT(res == 0);

    //switch off the MultiPartitionSupported feature
    LocalSPM::GetDataProvider().MultiPartitionSupported = 0;
}


void MediaPlayerInterfaceTest::MultipartitionDeviceCheck_3Valid1InvalidPartitions()
{
    ENTRY_TEST
    tResult res = -1;

    //switch on the MultiPartitionSupported feature
    LocalSPM::GetDataProvider().MultiPartitionSupported = 1;

    tUndervoltage undervoltage = false;
    vector<tDeviceInfo> deviceInfos;
    tDeviceInfo deviceInfoItem[4];
    InitDeviceInfo(INOUT deviceInfoItem[0]);
    InitDeviceInfo(INOUT deviceInfoItem[1]);
    InitDeviceInfo(INOUT deviceInfoItem[2]);
    InitDeviceInfo(INOUT deviceInfoItem[3]);

    //---------1st device- 1st Partition-------------  //Add a new partition #1 for device#1
    deviceInfoItem[0].deviceType      = DTY_USB;
    deviceInfoItem[0].connectionState = CS_ATTACHED;
    deviceInfoItem[0].fileSystemType = FSTY_FAT;
    strncpy_r(OUT deviceInfoItem[0].serialNumber, IN "Kingston_DT_R400_0018F3D97163BC1121480BZ5", IN sizeof(deviceInfoItem[0].serialNumber));
    strncpy_r(OUT deviceInfoItem[0].deviceName, IN "USB1_Part1", IN sizeof(deviceInfoItem[0].deviceName));
    strncpy_r(OUT deviceInfoItem[0].accessoryName2, IN "Kingston_DT_R400_", IN sizeof(deviceInfoItem[0].accessoryName2));
    strncpy_r(OUT deviceInfoItem[0].mountPoint, IN "/dev/media/USB1.1", IN sizeof(deviceInfoItem[0].mountPoint));
    strncpy_r(OUT deviceInfoItem[0].accessoryName2, IN "Kingston_DT_R400", IN sizeof(deviceInfoItem[0].accessoryName2));

    //---------1st device- 2nd Partition-------------  //Add a new partition #2 for device#1
    deviceInfoItem[1].deviceType      = DTY_USB;
    deviceInfoItem[1].connectionState = CS_ATTACHED;
    deviceInfoItem[1].fileSystemType = FSTY_FAT;
    strncpy_r(OUT deviceInfoItem[1].serialNumber, IN "Kingston_DT_R400_LM3444D97163BC112R324421", IN sizeof(deviceInfoItem[1].serialNumber));
    strncpy_r(OUT deviceInfoItem[1].deviceName, IN "USB1_Part2", IN sizeof(deviceInfoItem[1].deviceName));
    strncpy_r(OUT deviceInfoItem[1].accessoryName2, IN "Kingston_DT_R400_", IN sizeof(deviceInfoItem[1].accessoryName2));
    strncpy_r(OUT deviceInfoItem[1].mountPoint, IN "/dev/media/USB1.2", IN sizeof(deviceInfoItem[1].mountPoint));
    strncpy_r(OUT deviceInfoItem[1].accessoryName2, IN "Kingston_DT_R400", IN sizeof(deviceInfoItem[1].accessoryName2));

    //---------1st device- 3rd Partition---INVALID PARTITION----------  //Add a new partition #3 for device#1
    deviceInfoItem[2].deviceType      = DTY_USB;
    deviceInfoItem[2].connectionState = CS_ATTACHED;
    deviceInfoItem[2].fileSystemType = FSTY_UNKNOWN;
    strncpy_r(OUT deviceInfoItem[2].serialNumber, IN "Kingston_DT_R400_K22RTD97163BC111234445Z", IN sizeof(deviceInfoItem[2].serialNumber));
    strncpy_r(OUT deviceInfoItem[2].deviceName, IN "USB1_Part3", IN sizeof(deviceInfoItem[2].deviceName));
    strncpy_r(OUT deviceInfoItem[2].accessoryName2, IN "Kingston_DT_R400_", IN sizeof(deviceInfoItem[2].accessoryName2));
    strncpy_r(OUT deviceInfoItem[2].mountPoint, IN "/dev/media/USB1.3", IN sizeof(deviceInfoItem[2].mountPoint));
    strncpy_r(OUT deviceInfoItem[2].accessoryName2, IN "Kingston_DT_R400", IN sizeof(deviceInfoItem[2].accessoryName2));

    //---------1st device- 4th Partition-------------  //Add a new partition #4 for device#1
    deviceInfoItem[3].deviceType      = DTY_USB;
    deviceInfoItem[3].connectionState = CS_ATTACHED;
    deviceInfoItem[3].fileSystemType = FSTY_FAT;
    strncpy_r(OUT deviceInfoItem[3].serialNumber, IN "Kingston_DT_R400_R33GF3D97163BC11C234RT", IN sizeof(deviceInfoItem[3].serialNumber));
    strncpy_r(OUT deviceInfoItem[3].deviceName, IN "USB1_Part4", IN sizeof(deviceInfoItem[3].deviceName));
    strncpy_r(OUT deviceInfoItem[3].accessoryName2, IN "Kingston_DT_R400_", IN sizeof(deviceInfoItem[3].accessoryName2));
    strncpy_r(OUT deviceInfoItem[3].mountPoint, IN "/dev/media/USB1.4", IN sizeof(deviceInfoItem[3].mountPoint));
    strncpy_r(OUT deviceInfoItem[3].accessoryName2, IN "Kingston_DT_R400", IN sizeof(deviceInfoItem[3].accessoryName2));


    //Push deviceinfo to DB
    deviceInfos.push_back(deviceInfoItem[0]);
    deviceInfos.push_back(deviceInfoItem[1]);
    deviceInfos.push_back(deviceInfoItem[2]);
    deviceInfos.push_back(deviceInfoItem[3]);
    res = MediaPlayerInterface::GetInstance().DeviceChanged(IN undervoltage, IN deviceInfos);
    GMPTEST_EXPECT(res == 0);

    //switch off the MultiPartitionSupported feature
    LocalSPM::GetDataProvider().MultiPartitionSupported = 0;
}

void MediaPlayerInterfaceTest::MultipartitionDeviceCheck_4ValidUSB1ValidPartitions1NonUSB()
{
    ENTRY_TEST
    tResult res = -1;

    //switch on the MultiPartitionSupported feature
    LocalSPM::GetDataProvider().MultiPartitionSupported = 1;

    tUndervoltage undervoltage = false;
    vector<tDeviceInfo> deviceInfos;
    tDeviceInfo deviceInfoItem[5];
    InitDeviceInfo(INOUT deviceInfoItem[0]);
    InitDeviceInfo(INOUT deviceInfoItem[1]);
    InitDeviceInfo(INOUT deviceInfoItem[2]);
    InitDeviceInfo(INOUT deviceInfoItem[3]);
    InitDeviceInfo(INOUT deviceInfoItem[4]);

    //---------1st device- 1st Partition-------------  //Add a new partition #1 for device#1
    deviceInfoItem[0].deviceType      = DTY_USB;
    deviceInfoItem[0].connectionState = CS_ATTACHED;
    deviceInfoItem[0].fileSystemType = FSTY_FAT;
    strncpy_r(OUT deviceInfoItem[0].serialNumber, IN "Kingston_DT_R400_0018F3D97163BC1121480BZ5", IN sizeof(deviceInfoItem[0].serialNumber));
    strncpy_r(OUT deviceInfoItem[0].deviceName, IN "USB1_Part1", IN sizeof(deviceInfoItem[0].deviceName));
    strncpy_r(OUT deviceInfoItem[0].accessoryName2, IN "Kingston_DT_R400_", IN sizeof(deviceInfoItem[0].accessoryName2));
    strncpy_r(OUT deviceInfoItem[0].mountPoint, IN "/dev/media/USB1.1", IN sizeof(deviceInfoItem[0].mountPoint));
    strncpy_r(OUT deviceInfoItem[0].accessoryName2, IN "Kingston_DT_R400", IN sizeof(deviceInfoItem[0].accessoryName2));

    //---------1st device- 2nd Partition-------------  //Add a new partition #2 for device#1
    deviceInfoItem[1].deviceType      = DTY_USB;
    deviceInfoItem[1].connectionState = CS_ATTACHED;
    deviceInfoItem[1].fileSystemType = FSTY_FAT;
    strncpy_r(OUT deviceInfoItem[1].serialNumber, IN "Kingston_DT_R400_LM3444D97163BC112R324421", IN sizeof(deviceInfoItem[1].serialNumber));
    strncpy_r(OUT deviceInfoItem[1].deviceName, IN "USB1_Part2", IN sizeof(deviceInfoItem[1].deviceName));
    strncpy_r(OUT deviceInfoItem[1].accessoryName2, IN "Kingston_DT_R400_", IN sizeof(deviceInfoItem[1].accessoryName2));
    strncpy_r(OUT deviceInfoItem[1].mountPoint, IN "/dev/media/USB1.2", IN sizeof(deviceInfoItem[1].mountPoint));
    strncpy_r(OUT deviceInfoItem[1].accessoryName2, IN "Kingston_DT_R400", IN sizeof(deviceInfoItem[1].accessoryName2));

    //---------2nd device- VALID IPHONE----------  //Add a new IPHONE for device#2
    deviceInfoItem[2].deviceType      = DTY_IPHONE;
    deviceInfoItem[2].connectionState = CS_ATTACHED;
    deviceInfoItem[2].fileSystemType = FSTY_UNKNOWN;
    strncpy_r(OUT deviceInfoItem[2].serialNumber, IN "Apple_Inc._iPhone_17e7291b3e346198", IN sizeof(deviceInfoItem[2].serialNumber));
    strncpy_r(OUT deviceInfoItem[2].deviceName, IN "IPHONE", IN sizeof(deviceInfoItem[2].deviceName));
    strncpy_r(OUT deviceInfoItem[2].accessoryName2, IN "A123", IN sizeof(deviceInfoItem[2].accessoryName2));
    strncpy_r(OUT deviceInfoItem[2].mountPoint, IN "17e7291b3e346198", IN sizeof(deviceInfoItem[2].mountPoint));
    strncpy_r(OUT deviceInfoItem[2].accessoryName2, IN "", IN sizeof(deviceInfoItem[2].accessoryName2));

    //---------1st device- 3rd Partition-------  //Add a new partition #3 for device#1
    deviceInfoItem[3].deviceType      = DTY_USB;
    deviceInfoItem[3].connectionState = CS_ATTACHED;
    deviceInfoItem[3].fileSystemType = FSTY_FAT;
    strncpy_r(OUT deviceInfoItem[3].serialNumber, IN "Kingston_DT_R400_K22RTD97163BC111234445Z", IN sizeof(deviceInfoItem[3].serialNumber));
    strncpy_r(OUT deviceInfoItem[3].deviceName, IN "USB1_Part3", IN sizeof(deviceInfoItem[3].deviceName));
    strncpy_r(OUT deviceInfoItem[3].accessoryName2, IN "Kingston_DT_R400_", IN sizeof(deviceInfoItem[3].accessoryName2));
    strncpy_r(OUT deviceInfoItem[3].mountPoint, IN "/dev/media/USB1.3", IN sizeof(deviceInfoItem[3].mountPoint));
    strncpy_r(OUT deviceInfoItem[3].accessoryName2, IN "Kingston_DT_R400", IN sizeof(deviceInfoItem[3].accessoryName2));

    //---------1st device- 4th Partition-------------  //Add a new partition #4 for device#1
    deviceInfoItem[4].deviceType      = DTY_USB;
    deviceInfoItem[4].connectionState = CS_ATTACHED;
    deviceInfoItem[4].fileSystemType = FSTY_FAT;
    strncpy_r(OUT deviceInfoItem[4].serialNumber, IN "Kingston_DT_R400_R33GF3D97163BC11C234RT", IN sizeof(deviceInfoItem[4].serialNumber));
    strncpy_r(OUT deviceInfoItem[4].deviceName, IN "USB1_Part4", IN sizeof(deviceInfoItem[4].deviceName));
    strncpy_r(OUT deviceInfoItem[4].accessoryName2, IN "Kingston_DT_R400_", IN sizeof(deviceInfoItem[4].accessoryName2));
    strncpy_r(OUT deviceInfoItem[4].mountPoint, IN "/dev/media/USB1.4", IN sizeof(deviceInfoItem[4].mountPoint));
    strncpy_r(OUT deviceInfoItem[4].accessoryName2, IN "Kingston_DT_R400", IN sizeof(deviceInfoItem[4].accessoryName2));


    //Push deviceinfo to DB
    deviceInfos.push_back(deviceInfoItem[0]);
    deviceInfos.push_back(deviceInfoItem[1]);
    deviceInfos.push_back(deviceInfoItem[2]);
    deviceInfos.push_back(deviceInfoItem[3]);
    deviceInfos.push_back(deviceInfoItem[4]);
    res = MediaPlayerInterface::GetInstance().DeviceChanged(IN undervoltage, IN deviceInfos);
    GMPTEST_EXPECT(res == 0);

    //switch off the MultiPartitionSupported feature
    LocalSPM::GetDataProvider().MultiPartitionSupported = 0;
}


void MediaPlayerInterfaceTest::GetDiPOPower()
{
    ENTRY_TEST

    tResult res = -1;
    tDeviceID deviceID;
    tDiPOPower power;
    res = MediaPlayerInterface::GetInstance().GetDiPOPower(deviceID, power);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(power.BatteryChargingState == DIPO_BATTERY_CHARGE_STATE_DISABLED );
    GMPTEST_EXPECT(power.AccessoryPowerMode == DIPO_ACCESSORY_MODE_RESERVED );
    GMPTEST_EXPECT(power.BatteryChargeLevel == 0 );
    GMPTEST_EXPECT(power.MaximumCurrentDrawnFromAccessory == 0 );
    GMPTEST_EXPECT(power.DeviceBatteryWillChargeIfPowerIsPresent == 0 );
    GMPTEST_EXPECT(power.IsExternalChargerConnected == 0 );
    // NB iPod Control does not function under Ubuntu, therefore simulator tests return no data
}

void MediaPlayerInterfaceTest::SwapCalls()
{
    ENTRY_TEST
    tResult result;
    tDeviceID deviceID;
    /* set device id */
    result = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_IPOD, "IPOD");
    GMPTEST_EXPECT(result == MP_NO_ERROR);
    result = mMediaPlayerInterface.SendSwapCalls(deviceID);

    GMPTEST_EXPECT(result == MP_NO_ERROR);
}


//>--Roadmap 16003 : 'CD Ripping With Gracenote'
void MediaPlayerInterfaceTest::ReorderInternalPlaylist()
{
    ENTRY_TEST
    tResult res = -1;
    tPath playlistName = "MyList1.m3u" ;
    tDeviceID deviceTag = 1;
    tPosition oldPosition = 1;
    tPosition newPosition = 5;

    tBool activeSource = true;
    res = MediaPlayerInterface::GetInstance().ReorderInternalPlaylist(IN playlistName,IN deviceTag, IN oldPosition, IN newPosition);
    GMPTEST_EXPECT(res == 0);
    tListID listID;
    tListSize listSize;
    res = mMediaPlayerInterface.CreateMediaPlayerPlaylistList(OUT listID, OUT listSize, IN playlistName);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize == 7);
    vector<tFiles> fileObjects;
    res = mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT fileObjects, IN listID, IN 0, IN listSize);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(fileObjects.size() == listSize);
    for (tUInt iter = 0; iter < fileObjects.size(); iter++)
    {
        ETG_TRACE_USR1(("playlist entry %d:%s", iter ,fileObjects.at(iter).fileName));
    }
    GMPTEST_EXPECT(!strcmp(fileObjects.at(1).fileName, "10-lady-evighet.mp3"));
    GMPTEST_EXPECT(!strcmp(fileObjects.at(5).fileName, "Garbage-Garbage-04-As_Heaven_Is_Wide.mp3"));
}

void MediaPlayerInterfaceTest::DeleteMediaContentByURLForAllFile()
{
    ENTRY_TEST
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tResult res = -1;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;



    vector<tMediaObject> mediaObjectVector;

    HelperFileOperations(OUT deviceID, OUT mediaObjectVector);
    if( mMediaPlayerInterface.DeleteMediaContent(IN LTY_SONG, IN tag1, IN tag2, IN tag3, IN tag4, IN deviceID))
    {
        res = 0;
    }

    GMPTEST_EXPECT(0 == res);
    sleep(2);
    res =  mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN mListID,
            IN 0,
            IN mListSize);
    GMPTEST_EXPECT(0 == mediaObjectVector.size());

}

void MediaPlayerInterfaceTest::DeleteMediaContentCurrentMediaObject()
{
    ENTRY_TEST
    tResult res;

    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tDeviceID deviceID;

    /* set the filter tags */
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    /* Allocate */
    tAudioOutputDevice audioOutputDevice;
    strncpy_r(OUT audioOutputDevice, USB_ALSA_DEVICENAME, IN sizeof(audioOutputDevice));

    res = mMediaPlayerInterface.SendAllocate(IN audioOutputDevice);


    res = mMediaPlayerInterface.ActiveMediaDeviceSet(IN deviceID, IN true);
    sleep(1);


    tSourceActivity sourceActivity = SA_ON;
    res = mMediaPlayerInterface.SendSourceActivity(IN sourceActivity);
    GMPTEST_EXPECT(res == 0);
    ASYNC_WAIT_START(1);
    vector<tMediaObject> mediaObjectVector;
    HelperFileOperations(OUT deviceID, OUT mediaObjectVector);



    tListSize listSize_newplayback = 0;
    tIndex index = 0; /*from the first song */
    tPlaytime offset = 0;
    res = mMediaPlayerInterface.PlayItemFromList(OUT listSize_newplayback, IN mListID, IN index, IN offset);
    // test result
    GMPTEST_EXPECT(res == 0);
    WaitForPlaytimeUpdate(5);
    vector<tObjectID> objectIDs;
    objectIDs.push_back(mediaObjectVector[0].objectID);
    if( mMediaPlayerInterface.DeleteMediaContent(IN objectIDs, IN deviceID))
        res = 0;
    GMPTEST_EXPECT(0 == res);
    sleep(2);
    res =  mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN mListID,
            IN 0,
            IN mListSize);
    GMPTEST_EXPECT((mListSize-1) == mediaObjectVector.size());


}
void MediaPlayerInterfaceTest::DeleteMediaWhileIndexingDifferentDevice()
{
    ENTRY_TEST

    tResult res;

    // Enable triggers
    res = LocalSPM::GetIndexer().SwitchDBTrigger(IN TT_ALL, IN TS_ON);

    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    vector<tMediaObject> mediaObjectVector;
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;


    // set device id
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB-2");
    GMPTEST_EXPECT(res == MP_NO_ERROR);



    //reset indexing state to synchronize to l end
    res = LocalSPM::GetDBManager().SetIndexingState(IN deviceID, IN IDS_NOT_STARTED, IN 0);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    //change deviceState to ok
    tDeviceInfo deviceInfo;
    res = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    res = LocalSPM::GetDBManager().SetDeviceNameAndConnectionState(IN deviceID, IN deviceInfo.deviceName, IN deviceInfo.connectionState, IN DS_OK);
    GMPTEST_EXPECT(res == MP_NO_ERROR);


    tIndexingState indexingState;

    // Force re-indexing
    res = mMediaPlayerInterface.Reindexing(IN deviceID);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    int retry = 20;
    while(retry) {
        res = LocalSPM::GetDBManager().GetIndexingState(OUT indexingState, IN deviceID);
        sleep(3);
        if (IDS_PARTIAL == indexingState) break;
        retry--;
    }



    HelperFileOperations(OUT deviceID, OUT mediaObjectVector);
    if(mMediaPlayerInterface.DeleteMediaContent(IN LTY_SONG, IN tag1, IN tag2, IN tag3, IN tag4, IN deviceID))
    {
        res = 0;
    }
    GMPTEST_EXPECT(0 == res);
    sleep(2);
    res =  mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN mListID,
            IN 0,
            IN mListSize);
    GMPTEST_EXPECT(0 == mediaObjectVector.size());
    res = LocalSPM::GetIndexer().SwitchDBTrigger(IN TT_ALL, IN TS_OFF);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
}
void MediaPlayerInterfaceTest::DeleteMediaWhileIndexingSameDevice()
{
    ENTRY_TEST

    tResult res;

    // Enable triggers
    res = LocalSPM::GetIndexer().SwitchDBTrigger(IN TT_ALL, IN TS_ON);

    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    vector<tMediaObject> mediaObjectVector;
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;
    HelperFileOperations(OUT deviceID, OUT mediaObjectVector);





    //reset indexing state to synchronize to l end
    res = LocalSPM::GetDBManager().SetIndexingState(IN deviceID, IN IDS_NOT_STARTED, IN 0);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    //change deviceState to ok
    tDeviceInfo deviceInfo;
    res = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    res = LocalSPM::GetDBManager().SetDeviceNameAndConnectionState(IN deviceID, IN deviceInfo.deviceName, IN deviceInfo.connectionState, IN DS_OK);
    GMPTEST_EXPECT(res == MP_NO_ERROR);


    tIndexingState indexingState;

    // Force re-indexing
    res = mMediaPlayerInterface.Reindexing(IN deviceID);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    int retry = 20;
    while(retry) {
        res = LocalSPM::GetDBManager().GetIndexingState(OUT indexingState, IN deviceID);
        sleep(3);
        if (IDS_PARTIAL == indexingState) break;

        retry--;
    }

    res =  mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN mListID,
            IN 0,
            IN mListSize);
    vector<tObjectID> objectIDs;
    objectIDs.push_back(mediaObjectVector[0].objectID);
    if( mMediaPlayerInterface.DeleteMediaContent(IN objectIDs, IN deviceID))
    {
        res = 0;
    }
    GMPTEST_EXPECT(0 == res);
    sleep(2);
    res =  mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN mListID,
            IN 0,
            IN mListSize);
    LocalSPM::GetIndexer().SwitchDBTrigger(IN TT_ALL, IN TS_OFF);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    bool foundmediaobject = false;
    for(int i=0;i<mediaObjectVector.size();i++)
    {
        if(objectIDs[0] == mediaObjectVector[i].objectID)
        {
            foundmediaobject = true;
        }
    }

    GMPTEST_EXPECT(!foundmediaobject);


}
void MediaPlayerInterfaceTest::DeleteMediaContentForOneFile()
{
    ENTRY_TEST
    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;
    vector<tMediaObject> mediaObjectVector;

    HelperFileOperations(OUT deviceID, OUT mediaObjectVector);
    vector<tObjectID> objectIDs;
    objectIDs.push_back(mediaObjectVector[0].objectID);
    if(mMediaPlayerInterface.DeleteMediaContent(IN objectIDs, IN deviceID))
    {
        res = 0;
    }
    GMPTEST_EXPECT(res == 0);
    sleep(2);
    res =  mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN mListID,
            IN 0,
            IN mListSize);
    GMPTEST_EXPECT((mListSize-1) == mediaObjectVector.size());

}
void MediaPlayerInterfaceTest::DeleteMediaContentByURLs()
{
    ENTRY_TEST
    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;
    vector<tMediaObject> mediaObjectVector;

    HelperFileOperations(OUT deviceID, OUT mediaObjectVector);
    vector<string> urls;
    urls.push_back(mediaObjectVector[0].fileName);
    if(mMediaPlayerInterface.DeleteMediaContent(IN urls, IN deviceID))
    {
        res = 0;
    }
    GMPTEST_EXPECT(res == 0);
    sleep(2);
    res =  mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN mListID,
            IN 0,
            IN mListSize);
    GMPTEST_EXPECT((mListSize-1) == mediaObjectVector.size());
}


void MediaPlayerInterfaceTest::HelperFileOperations(OUT tDeviceID &deviceID, OUT vector<tMediaObject> &mediaObjectVector)
{
    ENTRY_TEST
    tResult res;

    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;

    /* set device ID */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            mListID,
            mListSize,
            LTY_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mListSize > 0);

    res =  mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN mListID,
            0,
            IN mListSize);
    GMPTEST_EXPECT(res == 0);
}


void MediaPlayerInterfaceTest::EditTitleMetadata()
{
    vector<tMediaObject> mediaObjectVector;
    tDeviceID deviceID;
    tResult res;
    HelperFileOperations(OUT deviceID, OUT mediaObjectVector);
    if(mediaObjectVector.size()>= 1)
    {
        ETG_TRACE_USR1(("EditTitleMetadata Going to edit the metadata for the file %s",mediaObjectVector[0].fileName));

        tEditMetaDataByUrl editMetaDataByUrl;
        memset((void*)&editMetaDataByUrl,0,sizeof(editMetaDataByUrl));
        strncpy_r(OUT editMetaDataByUrl.MediaObjectUrl, IN mediaObjectVector[0].fileName, IN sizeof(editMetaDataByUrl.MediaObjectUrl));
        tObjectID objectIDTobEdited = mediaObjectVector[0].objectID;
        strncpy_r(OUT editMetaDataByUrl.TitleField, IN "MusicBox::SampleTitle", IN sizeof(editMetaDataByUrl.TitleField));
        editMetaDataByUrl.deviceID = deviceID;
        res = mMediaPlayerInterface.EditMetaData(editMetaDataByUrl);
        GMPTEST_EXPECT(res == 0);
        sleep(2);
        res =  mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(
                OUT mediaObjectVector,
                IN mListID,
                IN 0,
                IN mListSize);
        for(tUInt i=0; i<mediaObjectVector.size(); i++)
        {

            if(objectIDTobEdited == mediaObjectVector[i].objectID)
            {

                ETG_TRACE_USR4(("EditTitleMetadata : match found for mediaobject in the vector of mediaobjects"))
                       GMPTEST_EXPECT(!strncmp(mediaObjectVector[i].title,"MusicBox::SampleTitle",sizeof(mediaObjectVector[i].title)));
                break;
            }
        }
    }

}
void MediaPlayerInterfaceTest::EditArtistMetadata()
{
    vector<tMediaObject> mediaObjectVector;
    tDeviceID deviceID;
    tResult res;
    HelperFileOperations(OUT deviceID, OUT mediaObjectVector);
    if(mediaObjectVector.size()>= 1)
    {
        ETG_TRACE_USR1(("EditArtistMetadata Going to edit the metadata for the file %s",mediaObjectVector[0].fileName));

        tEditMetaDataByUrl editMetaDataByUrl;
        memset((void*)&editMetaDataByUrl,0,sizeof(editMetaDataByUrl));
        strncpy_r(OUT editMetaDataByUrl.MediaObjectUrl, IN mediaObjectVector[0].fileName, IN sizeof(editMetaDataByUrl.MediaObjectUrl));
        tObjectID objectIDTobEdited = mediaObjectVector[0].objectID;
        strncpy_r(OUT editMetaDataByUrl.ArtistField, IN "MusicBox::SampleArtist", IN sizeof(editMetaDataByUrl.ArtistField));
        editMetaDataByUrl.deviceID = deviceID;
        res = mMediaPlayerInterface.EditMetaData(editMetaDataByUrl);
        GMPTEST_EXPECT(res == 0);
        sleep(2);
        res =  mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(
                OUT mediaObjectVector,
                IN mListID,
                IN 0,
                IN mListSize);
        for(tUInt i=0; i<mediaObjectVector.size(); i++)
        {
            if(objectIDTobEdited == mediaObjectVector[i].objectID)
            {
                ETG_TRACE_USR4(("EditArtistMetadata : match found for mediaobject in the vector of mediaobjects"))
                       GMPTEST_EXPECT(!strncmp(mediaObjectVector[i].MetadataField3,"MusicBox::SampleArtist",sizeof(mediaObjectVector[i].MetadataField3)));
                break;
            }
        }
    }

}

void MediaPlayerInterfaceTest::EditAlbumMetadata()
{
    vector<tMediaObject> mediaObjectVector;
    tDeviceID deviceID;
    tResult res;
    HelperFileOperations(OUT deviceID, OUT mediaObjectVector);
    if(mediaObjectVector.size()>= 1)
    {
        ETG_TRACE_USR1(("EditAlbumMetadata Going to edit the metadata for the file %s",mediaObjectVector[0].fileName));

        tEditMetaDataByUrl editMetaDataByUrl;
        memset((void*)&editMetaDataByUrl,0,sizeof(editMetaDataByUrl));
        strncpy_r(OUT editMetaDataByUrl.MediaObjectUrl, IN mediaObjectVector[0].fileName, IN sizeof(editMetaDataByUrl.MediaObjectUrl));
        tObjectID objectIDTobEdited = mediaObjectVector[0].objectID;
        strncpy_r(OUT editMetaDataByUrl.AlbumField, IN "MusicBox::SampleAlbum", IN sizeof(editMetaDataByUrl.AlbumField));
        editMetaDataByUrl.deviceID = deviceID;
        res = mMediaPlayerInterface.EditMetaData(editMetaDataByUrl);
        GMPTEST_EXPECT(res == 0);
        sleep(2);
        res =  mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(
                OUT mediaObjectVector,
                IN mListID,
                IN 0,
                IN mListSize);
        for(tUInt i=0; i<mediaObjectVector.size(); i++)
        {
            if(objectIDTobEdited == mediaObjectVector[i].objectID)
            {

                ETG_TRACE_USR4(("EditAlbumMetadata : match found for mediaobject in the vector of mediaobjects"))
                       GMPTEST_EXPECT(!strncmp(mediaObjectVector[i].MetadataField2,"MusicBox::SampleAlbum",sizeof(mediaObjectVector[i].MetadataField2)));
                break;
            }
        }
    }

}
void MediaPlayerInterfaceTest::EditGenreMetadata()
{
    vector<tMediaObject> mediaObjectVector;
    tDeviceID deviceID;
    tResult res;
    HelperFileOperations(OUT deviceID, OUT mediaObjectVector);
    if(mediaObjectVector.size()>= 1)
    {
        ETG_TRACE_USR1(("EditGenreMetadata Going to edit the metadata for the file %s",mediaObjectVector[0].fileName));

        tEditMetaDataByUrl editMetaDataByUrl;
        memset((void*)&editMetaDataByUrl,0,sizeof(editMetaDataByUrl));
        strncpy_r(OUT editMetaDataByUrl.MediaObjectUrl, IN mediaObjectVector[0].fileName, IN sizeof(editMetaDataByUrl.MediaObjectUrl));
        tObjectID objectIDTobEdited = mediaObjectVector[0].objectID;
        strncpy_r(OUT editMetaDataByUrl.GenreField, IN "MusicBox::SampleGenre", IN sizeof(editMetaDataByUrl.GenreField));
        editMetaDataByUrl.deviceID = deviceID;
        res = mMediaPlayerInterface.EditMetaData(editMetaDataByUrl);
        GMPTEST_EXPECT(res == 0);
        sleep(2);
        res =  mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(
                OUT mediaObjectVector,
                IN mListID,
                IN 0,
                IN mListSize);
        for(tUInt i=0; i<mediaObjectVector.size(); i++)
        {
            if(objectIDTobEdited == mediaObjectVector[i].objectID)
            {

                ETG_TRACE_USR4(("EditGenreMetadata : match found for mediaobject in the vector of mediaobjects"))
                       GMPTEST_EXPECT(!strncmp(mediaObjectVector[i].MetadataField1,"MusicBox::SampleGenre",sizeof(mediaObjectVector[i].MetadataField1)));
                break;
            }
        }
    }

}

//<--Roadmap 16003 : 'CD Ripping With Gracenote'
//>--Roadmap 1615 Internal DVD Drive
void  MediaPlayerInterfaceTest::InsertDVD_Device()
{
    ENTRY_TEST
    tResult result = -1;
    tDeviceID deviceID;
    /*now validate if inserted BTl device is part of deviceList available with DB */
    result = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_DVD_DRIVE,true);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(deviceID != DEVICE_ID_NOT_SET);
    /*validate the details of device from the DB*/
    tDeviceInfo deviceInfo;
    result = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    GMPTEST_EXPECT(result == 0);
    printf(" \n  $$$$$$$$$$$$ InsertDVD_Device deviceInfo.deviceType %x , deviceInfo.connectionType %x \n" ,deviceInfo.deviceType,deviceInfo.connectionType);
    sleep(20);
    result = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    GMPTEST_EXPECT(result == 0);
    printf(" \n  $$$$$$$$$$$$ InsertDVD_Device deviceInfo.deviceType %x , deviceInfo.connectionType %x \n" ,deviceInfo.deviceType,deviceInfo.connectionType);
    sleep(10);
    result = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    GMPTEST_EXPECT(result == 0);
    printf(" \n  $$$$$$$$$$$$ InsertDVD_Device deviceInfo.deviceType %x , deviceInfo.connectionType %x \n" ,deviceInfo.deviceType,deviceInfo.connectionType);
    result = mMediaPlayerInterface.ActiveMediaDeviceSet(IN deviceID, IN true);

    GMPTEST_EXPECT(result == 0);

    sleep(10);
    /*validate the details of device from the DB*/
    result = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(deviceInfo.deviceID == deviceID);
    GMPTEST_EXPECT(deviceInfo.connected == 0x01);
    GMPTEST_EXPECT(deviceInfo.deviceType == DTY_DVD_DRIVE);
    GMPTEST_EXPECT(deviceInfo.connectionState == CS_CONNECTED);
    GMPTEST_EXPECT(deviceInfo.connectionType == DCT_USB);

    // result = mMediaPlayerInterface.ActiveMediaDeviceSet(IN deviceID, IN true);

    GMPTEST_EXPECT(result == 0);
}
void  MediaPlayerInterfaceTest::DVD_Playback_DVDVideo_MultiAngle()
{
    ENTRY_TEST
    tResult result;
    // multi angle
    sleep(5);
    //left
    result = mMediaPlayerInterface.SetMenuPlayBackControl(1);
    sleep(5);
    result = mMediaPlayerInterface.SendNavigationKey(KEY_ENTER);
    sleep(8);
    mMediaPlayerInterface.RequestAngleChange(2,7);
    sleep(8);
    result = mMediaPlayerInterface.SetMenuPlayBackControl(1);
    sleep(5);
    result = mMediaPlayerInterface.SendNavigationKey(UPPER);
    sleep(2);
    result = mMediaPlayerInterface.SendNavigationKey(UPPER);
    sleep(2);
    result = mMediaPlayerInterface.SendNavigationKey(UPPER);
    sleep(2);
    result = mMediaPlayerInterface.SendNavigationKey(UPPER);
    sleep(2);
    result = mMediaPlayerInterface.SendNavigationKey(KEY_ENTER);
    sleep(8);
    mMediaPlayerInterface.RequestAngleChange(2,3);
    sleep(8);
    return;
}
void MediaPlayerInterfaceTest::DVDDriveInitialization()
{

    ENTRY_TEST

    tResult result;
    /*prepare a bt test device which supports avrcp 1.4 */
    vector<tDeviceInfo> deviceInfos;
    tDeviceInfo dvdDevice;
    InitDeviceInfo(INOUT dvdDevice);
    dvdDevice.deviceType  = DTY_DVD_DRIVE;
    strncpy_r(OUT dvdDevice.serialNumber, IN "aabbccddeeffdvd", IN sizeof(dvdDevice.serialNumber)); // known serial number faked from the bt-daemon
    strncpy_r(OUT dvdDevice.deviceName, IN "DVD_device", IN sizeof(dvdDevice.deviceName));
    strncpy_r(OUT dvdDevice.mountPoint, IN "/dev/sr1", IN sizeof(dvdDevice.mountPoint));
    dvdDevice.connectionState = CS_ATTACHED;
    dvdDevice.connectionType = DCT_USB;
    dvdDevice.disconnectReason = DR_REMOVED;
    deviceInfos.push_back(dvdDevice);

    result = LocalSPM::GetIndexer().SwitchDBTrigger(IN TT_ALL, IN TS_ON);
    result = LocalSPM::GetCustomControl().SwitchDBTrigger(IN TT_ALL, IN TS_ON);

    GMPTEST_EXPECT(result == 0);
    /*insert the prepared device as connected*/
    result = MediaPlayerInterface::GetInstance().DeviceChanged(IN false /*undervoltage*/, IN deviceInfos);
    GMPTEST_EXPECT(result == 0);

    /*wait till device reaches the state connected from attached*/
    sleep(30);
}

void  MediaPlayerInterfaceTest::InsertDVD_Device_Audio_CD()
{
    ENTRY_TEST

    tResult result;
    tDeviceID deviceID;
    sleep(30);
    /*validate the details of device from the DB*/
    /*now validate if inserted BTl device is part of deviceList available with DB */
    result = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_DVD_DRIVE,true);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(deviceID != DEVICE_ID_NOT_SET);
    tDeviceInfo deviceInfo;
    result = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(deviceInfo.deviceID == deviceID);
    //GMPTEST_EXPECT(deviceInfo.connected == 0x00);
    GMPTEST_EXPECT(deviceInfo.deviceType == DTY_DVD_DRIVE);
    //  GMPTEST_EXPECT(deviceInfo.discType == DISC_AUDIO_CD);
    GMPTEST_EXPECT(deviceInfo.connectionState == CS_ATTACHED);
    GMPTEST_EXPECT(deviceInfo.connectionType == DCT_USB);

    // result = mMediaPlayerInterface.ActiveMediaDeviceSet(IN deviceID, IN true);

    GMPTEST_EXPECT(result == 0);
    ETG_TRACE_USR1(("          ***Stop  %s***", __PRETTY_FUNCTION__));
}
void  MediaPlayerInterfaceTest::InsertDVD_Device_Data_CD()
{

    ENTRY_TEST
    tResult result;
    tDeviceID deviceID;
    sleep(30);
    /*validate the details of device from the DB*/
    /*now validate if inserted BTl device is part of deviceList available with DB */
    result = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_DVD_DRIVE,true);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(deviceID != DEVICE_ID_NOT_SET);
    tDeviceInfo deviceInfo;
    result = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(deviceInfo.deviceID == deviceID);
    //GMPTEST_EXPECT(deviceInfo.connected == 0x00);
    GMPTEST_EXPECT(deviceInfo.deviceType == DTY_DVD_DRIVE);
    GMPTEST_EXPECT(deviceInfo.discType == DISC_DATA);
    GMPTEST_EXPECT(deviceInfo.connectionState == CS_ATTACHED);
    GMPTEST_EXPECT(deviceInfo.connectionType == DCT_USB);

    // result = mMediaPlayerInterface.ActiveMediaDeviceSet(IN deviceID, IN true);

    GMPTEST_EXPECT(result == 0);
    sleep(30);

}
void  MediaPlayerInterfaceTest::DVD_DoneRipping()
{
    ENTRY_TEST

    tResult result;
    /*now validate if inserted BTl device is part of deviceList available with DB */
    tDeviceID deviceID;
    result = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_DVD_DRIVE,true);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(deviceID != DEVICE_ID_NOT_SET);
    char messageString[64];
    sleep(10);
    tResult ret = MP_NO_ERROR;
    LocalSPM::GetCDRipperControl().SendEventByName("STOP_RIPPING", IN NULL);

    LocalSPM::GetDVDControl().SendEventByName("DONE_RIPPING",NULL);
    ETG_TRACE_USR1(("DVDControlSM::DONE_RIPPPING event sent"));
    // strncpy_r(OUT messageString, IN "DVDControlSM::DONE_RIPPPING", IN sizeof(messageString));
    // Dispatcher::GetInstance().SendMessage(IN messageString);
    sleep(15);
    result = mMediaPlayerInterface.ActiveMediaDeviceSet(IN deviceID, IN true);
    GMPTEST_EXPECT(result == 0);
    sleep(10);
    /*validate the details of device from the DB*/
    tDeviceInfo deviceInfo;
    result = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(deviceInfo.deviceID == deviceID);
    //  GMPTEST_EXPECT(deviceInfo.connected == 0x01);
    GMPTEST_EXPECT(deviceInfo.deviceType == DTY_DVD_DRIVE);
    GMPTEST_EXPECT(deviceInfo.discType == DISC_AUDIO_CD);
    GMPTEST_EXPECT(deviceInfo.connectionState == CS_CONNECTED);
    GMPTEST_EXPECT(deviceInfo.connectionType == DCT_USB);

    // result = mMediaPlayerInterface.ActiveMediaDeviceSet(IN deviceID, IN true);

    GMPTEST_EXPECT(result == 0);

}

void MediaPlayerInterfaceTest::DVD_DisableAutoRipping()
{
    ENTRY_TEST

    tResult result;
    result = mMediaPlayerInterface.SetAutoRipping(false);
    sleep(15);
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    result = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_DVD_DRIVE,true);
    result = mMediaPlayerInterface.ActiveMediaDeviceSet(IN deviceID, IN true);
    GMPTEST_EXPECT(result == 0);
    sleep(10);
    /*validate the details of device from the DB*/
    tDeviceInfo deviceInfo;
    result = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(deviceInfo.deviceID == deviceID);
    //  GMPTEST_EXPECT(deviceInfo.connected == 0x01);
    GMPTEST_EXPECT(deviceInfo.deviceType == DTY_DVD_DRIVE);
    GMPTEST_EXPECT(deviceInfo.discType == DISC_AUDIO_CD);
    GMPTEST_EXPECT(deviceInfo.connectionState == CS_CONNECTED);
    GMPTEST_EXPECT(deviceInfo.connectionType == DCT_USB);
}
void  MediaPlayerInterfaceTest::DVD_Eject()
{
    ENTRY_TEST

    tResult result;
    result = MediaPlayerInterface::GetInstance().RequestDiscOperation(1);
    /*now validate if inserted BTl device is part of deviceList available with DB */
    sleep(10);
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    result = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_DVD_DRIVE,true);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(deviceID != DEVICE_ID_NOT_SET);
    /*validate the details of device from the DB*/
    sleep(10);
    tDeviceInfo deviceInfo;
    result = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(deviceInfo.deviceID == deviceID);
    //GMPTEST_EXPECT(deviceInfo.connected == 0x00);
    GMPTEST_EXPECT(deviceInfo.deviceType == DTY_DVD_DRIVE);
    // GMPTEST_EXPECT(deviceInfo.discType == DISC_AUDIO_CD);
    GMPTEST_EXPECT(deviceInfo.connectionState == CS_ATTACHED);
    GMPTEST_EXPECT(deviceInfo.connectionType == DCT_USB);

    // result = mMediaPlayerInterface.ActiveMediaDeviceSet(IN deviceID, IN true);

    GMPTEST_EXPECT(result == 0);
}
void  MediaPlayerInterfaceTest::DVD_PlaybackActions()
{

    ENTRY_TEST

    tResult result;
    tHMIPlaybackState playstatus;
    tNowPlaying nowPlaying;
    sleep(2);
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    result = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_DVD_DRIVE,true);
    result = mMediaPlayerInterface.ActiveMediaDeviceSet(IN deviceID, IN true);
    GMPTEST_EXPECT(result == 0);

    result = mMediaPlayerInterface.SendPlaybackAction(PBA_PAUSE);
    sleep(5);

    result = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("DVD_PLaybackActions PAUSE : %d ", playstatus));
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_PAUSED);

    result = mMediaPlayerInterface.SendPlaybackAction(PBA_PLAY);
    sleep(5);


    result = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("DVD_PLaybackActions PLAY : %d ", playstatus));
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);
    sleep(5);

    ETG_TRACE_USR1(("DVD_PlaybackActions::NowPlaying before NEXT"));
    mMediaPlayerInterface.GetNowPlaying(nowPlaying);
    VARTRACE(nowPlaying);

    result = mMediaPlayerInterface.SendPlaybackAction(PBA_NEXT);
    sleep(10);


    ETG_TRACE_USR1(("DVD_PlaybackActions::NowPlaying After NEXT"));
    mMediaPlayerInterface.GetNowPlaying(nowPlaying);
    VARTRACE(nowPlaying);


    result = mMediaPlayerInterface.SendPlaybackAction(PBA_NEXT);
    sleep(10);


    ETG_TRACE_USR1(("DVD_PlaybackActions::NowPlaying After NEXT 2"));
    mMediaPlayerInterface.GetNowPlaying(nowPlaying);
    VARTRACE(nowPlaying);

    result = mMediaPlayerInterface.SendPlaybackAction(PBA_PREV);
    sleep(5);

    ETG_TRACE_USR1(("DVD_PlaybackActions::NowPlaying After PREV"));
    mMediaPlayerInterface.GetNowPlaying(nowPlaying);
    VARTRACE(nowPlaying);

    result = mMediaPlayerInterface.SendPlaybackSpeed(PBK_FORWARD,PBK_SPEED_8X);
    sleep(5);

    result = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("DVD_PLaybackActions FWD_START : %d ", playstatus));

    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_FFWD);


    result = mMediaPlayerInterface.SendPlaybackSpeed(PBK_FORWARD,PBK_SPEED_1X);
    sleep(5);

    result = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("DVD_PLaybackActions FWD_STOP : %d ", playstatus));

    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);



    result = mMediaPlayerInterface.SendPlaybackSpeed(PBK_BACKWARD,PBK_SPEED_8X);
    sleep(5);

    result = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("DVD_PLaybackActions FREV_START : %d ", playstatus));
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_FREV);


    result = mMediaPlayerInterface.SendPlaybackSpeed(PBK_BACKWARD,PBK_SPEED_1X);
    sleep(5);

    result = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("DVD_PLaybackActions FREV_STOP : %d ", playstatus));
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);


}

void  MediaPlayerInterfaceTest::checkDVDProperties()
{
    ENTRY_TEST
    tResult result;
    // Check disc mechanical status
    tU8 mechanicalInfo = 0;
    result = mMediaPlayerInterface.GetDiskMechanicalInfo(mechanicalInfo);
    ETG_TRACE_USR1(("disc mechanical status : %x ", mechanicalInfo));
    // check disc error
    tBool isError;
    tU8  diskError;
    result = mMediaPlayerInterface.GetDiskError(isError,diskError);
    ETG_TRACE_USR1(("disc error  status : Is error %x error type %x", isError,diskError));
    // check audio channel info
    tU8 totalChannels = 0;
    tBool subWoofer = false;
    tU8 Assignment= 0;
    result = mMediaPlayerInterface.GetAudioChannelInfo(totalChannels,subWoofer,Assignment);
    ETG_TRACE_USR1(("audio assignment : %x : %x ", totalChannels,subWoofer));
}
void  MediaPlayerInterfaceTest::changeDVDSetupProperties()
{
    ENTRY_TEST
    tResult result;
#if 0
    result = mMediaPlayerInterface.SetAngleMarkSetting(true);
    sleep(10);
    result = mMediaPlayerInterface.SetAngleMarkSetting(false);
    sleep(10);
    result = mMediaPlayerInterface.SetDRCSetting(NORMAL_COMPRESSION);
    sleep(10);
    result = mMediaPlayerInterface.SetDRCSetting(WIDE_COMPRESSION);
    sleep(10);
    result = mMediaPlayerInterface.SetDRCSetting(BOOST_COMPRESSION);
    sleep(10);
    result = mMediaPlayerInterface.SetPlayStatusSetting(true);
    sleep(10);
    result = mMediaPlayerInterface.SetPlayStatusSetting(false);
#endif
    result = mMediaPlayerInterface.SetDisplayMode(LETTER_DISPLAY_4_3);
    sleep(10);
    result = mMediaPlayerInterface.SetDisplayMode(DEFAULT_DISPLAY_16_9);
    sleep(10);
    // result = mMediaPlayerInterface.SetLanguageSetting(0x6A61,0x6A61,0x6A61);
    //sleep(30);
    return;
}

void  MediaPlayerInterfaceTest::changeDVDAudioOutput()
{
    ENTRY_TEST

    tU8 soundformat  = 0;
    tU8 VcdAudio = 0;
    tU8 DvdAudio = 0;
    tU8 totalOutput = 0;
    tU16 Lang = 0;

    tResult res =  mMediaPlayerInterface.GetCurrentAudioInfo(soundformat,VcdAudio,DvdAudio,totalOutput,Lang);

    ETG_TRACE_USR1(("changeDVDAudioOutput existing value : SOUND FORMAT %x -- channel vcd %x -- channel dvd %x / %x lang %x ", soundformat,VcdAudio,DvdAudio,totalOutput,Lang));

    if(totalOutput > 0)
    {
        DvdAudio = totalOutput;
        mMediaPlayerInterface.RequestDVDAudioChannel(2,DvdAudio);
        sleep(3);
        tResult res =  mMediaPlayerInterface.GetCurrentAudioInfo(soundformat,VcdAudio,DvdAudio,totalOutput,Lang);

        ETG_TRACE_USR1(("changeDVDAudioOutput existing value : SOUND FORMAT %x -- channel vcd %x -- channel dvd %x / %x lang %x", soundformat,VcdAudio,DvdAudio,totalOutput,Lang));

    }
}

void  MediaPlayerInterfaceTest::changeMultiAngle()
{
    ENTRY_TEST
    tU8 angleTrack  = 0;
    tU8 totalAngle = 0;

    tResult res =  mMediaPlayerInterface.GetAngleInfo( angleTrack, totalAngle);

    ETG_TRACE_USR1(("DVD_changeMultiAngle existing value : %d / %d ", angleTrack,totalAngle));

    if(totalAngle > 0)
    {
        angleTrack = totalAngle;
        mMediaPlayerInterface.RequestAngleChange(2,angleTrack);
        sleep(3);
        tResult res =  mMediaPlayerInterface.GetAngleInfo( angleTrack, totalAngle);

        ETG_TRACE_USR1(("DVD_changeMultiAngle existing value : %d / %d ", angleTrack,totalAngle));
    }
}

void  MediaPlayerInterfaceTest::changeSubtitle()
{
    ENTRY_TEST
    tBool SubtitleState = false;
    unsigned char subtitleCurrent = 0;
    unsigned char totalSubtitle = 0;
    tU16 Lang = 0;
    sleep(5);
    tResult result = mMediaPlayerInterface.GetSubtitleInfo(SubtitleState, subtitleCurrent, totalSubtitle,Lang);
    //SUBTITLE off
    ETG_TRACE_USR1(("DVD_PLaybackActions Subtitle State : %x , current %x , total %x lang %x", SubtitleState ,subtitleCurrent , totalSubtitle, Lang));
    if(totalSubtitle > 0)
    {
        result = mMediaPlayerInterface.RequestSubtitleChange(false, 5 , totalSubtitle);

        sleep(5);
        result = mMediaPlayerInterface.GetSubtitleInfo(SubtitleState, subtitleCurrent, totalSubtitle,Lang);
        ETG_TRACE_USR1(("DVD_PLaybackActions Subtitle State : %x , current %x , total %x lang %x ", SubtitleState ,subtitleCurrent , totalSubtitle, Lang));
    }

}

void  MediaPlayerInterfaceTest::DVD_PlaybackModeTest()
{
    ENTRY_TEST
    tResult result;
    tPlaybackMode PBMode = PBM_INVALID;

    result = mMediaPlayerInterface.SendPlaybackMode(PBM_RANDOM);
    sleep(5);

    result = mMediaPlayerInterface.GetPlaybackMode(PBMode);
    GMPTEST_EXPECT(PBM_RANDOM == PBMode);

    result = mMediaPlayerInterface.SendPlaybackMode(PBM_NORMAL);
    sleep(5);

    result = mMediaPlayerInterface.GetPlaybackMode(PBMode);
    GMPTEST_EXPECT(PBM_NORMAL == PBMode);
}

void  MediaPlayerInterfaceTest::DVD_RepeatModeTest()
{
    ENTRY_TEST
    tResult result;
    tRepeatMode repeateMode = RPT_INVALID;

    result = mMediaPlayerInterface.SendRepeatMode(RPT_ONE);
    sleep(5);

    result = mMediaPlayerInterface.GetRepeatMode(repeateMode);
    GMPTEST_EXPECT(RPT_ONE == repeateMode);

    result = mMediaPlayerInterface.SendRepeatMode(RPT_LIST);
    sleep(5);

    result = mMediaPlayerInterface.GetRepeatMode(repeateMode);
    GMPTEST_EXPECT(RPT_LIST == repeateMode);

    result = mMediaPlayerInterface.SendRepeatMode(RPT_NONE);
    sleep(5);

    result = mMediaPlayerInterface.GetRepeatMode(repeateMode);
    GMPTEST_EXPECT(RPT_NONE == repeateMode);

}

void  MediaPlayerInterfaceTest::RemoveDVD_Device()
{
    ENTRY_TEST

    tResult result;
    vector<tDeviceInfo> deviceInfos;
    tDeviceInfo dvdDevice;
    InitDeviceInfo(INOUT dvdDevice);
    dvdDevice.deviceType  = DTY_DVD_DRIVE;
    strncpy_r(OUT dvdDevice.serialNumber, IN "aabbccddeeffdvd", IN sizeof(dvdDevice.serialNumber)); // known serial number faked from the bt-daemon
    strncpy_r(OUT dvdDevice.deviceName, IN "DVD_device", IN sizeof(dvdDevice.deviceName));
    strncpy_r(OUT dvdDevice.mountPoint, IN "/dev/sr1", IN sizeof(dvdDevice.mountPoint));
    dvdDevice.connectionState = CS_DISCONNECTED;
    dvdDevice.connectionType = DCT_USB;
    dvdDevice.disconnectReason = DR_REMOVED;
    deviceInfos.push_back(dvdDevice);

    /*before removing the device save its deviceID for later validation*/
    tDeviceID deviceID;
    result = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_BLUETOOTH);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(deviceID != DEVICE_ID_NOT_SET);


    result = MediaPlayerInterface::GetInstance().DeviceChanged(IN false /*undervoltage*/, IN deviceInfos);
    sleep(5);

    /*validate the details of device from the DB*/
    tDeviceInfo deviceInfo;
    result = MediaPlayerInterface::GetInstance().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(deviceInfo.deviceID == deviceID);
    GMPTEST_EXPECT(deviceInfo.connected == 0x00);
    GMPTEST_EXPECT(deviceInfo.deviceType == DTY_DVD_DRIVE);
    GMPTEST_EXPECT(deviceInfo.connectionState == CS_DISCONNECTED);

}

void  MediaPlayerInterfaceTest::DVD_Playback_DVDVideo()
{

    ENTRY_TEST

    tResult result;
    tHMIPlaybackState playstatus;
    tNowPlaying nowPlaying;


    // mask of zorro
    sleep(30);
    //left
    result = mMediaPlayerInterface.SendNavigationKey(RIGHT);
    sleep(2);
    //right
    result = mMediaPlayerInterface.SendNavigationKey(RIGHT);
    sleep(2);
    result = mMediaPlayerInterface.SendNavigationKey(KEY_ENTER);
    sleep(2);
    result = mMediaPlayerInterface.SendNavigationKey(LOWER);
    sleep(2);
    result = mMediaPlayerInterface.SendNavigationKey(KEY_ENTER);
    sleep(2);
    //-------------------------------------------------------------------
    result = mMediaPlayerInterface.SetMenuPlayBackControl(1);
    sleep(2);
    result = mMediaPlayerInterface.SendNavigationKey(RIGHT);
    sleep(2);
    //right
    result = mMediaPlayerInterface.SendNavigationKey(RIGHT);
    sleep(2);
    result = mMediaPlayerInterface.SendNavigationKey(RIGHT);
    sleep(2);
    //right
    result = mMediaPlayerInterface.SendNavigationKey(KEY_ENTER);
    sleep(5);
    result = mMediaPlayerInterface.SelectDirectNumber(2);
    sleep(2);
    //right
    result = mMediaPlayerInterface.SendNavigationKey(KEY_ENTER);
    sleep(5);
    //-----------------------------------------------------------------------------------
#if 0 // DVD Firever MY LOve
    result = mMediaPlayerInterface.SendPlaybackAction(PBA_PLAY);
    sleep(5);

    result = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("DVD_PLaybackActions PLAY : %d ", playstatus));
    //  GMPTEST_EXPECT(result == 0);
    // GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);
    sleep(30);
    //down
    result = mMediaPlayerInterface.SendNavigationKey(LOWER);
    sleep(2);
    //enter
    result = mMediaPlayerInterface.SendNavigationKey(KEY_ENTER);

    sleep(30);
    //left
    result = mMediaPlayerInterface.SendNavigationKey(RIGHT);
    sleep(2);
    //right
    result = mMediaPlayerInterface.SendNavigationKey(LEFT);
    sleep(2);
    //enter
    result = mMediaPlayerInterface.SendNavigationKey(KEY_ENTER);
#endif

    sleep(10);
    result = mMediaPlayerInterface.SetPlayStatusSetting(true);
    sleep(10);
    // result = mMediaPlayerInterface.SetAngleMarkSetting(true);
    // sleep(10);

    tBool SubtitleState = false;
    unsigned char subtitleCurrent = 0;
    unsigned char totalSubtitle = 0;
    tU16 Lang = 0;
    sleep(5);
    result = mMediaPlayerInterface.GetSubtitleInfo(SubtitleState, subtitleCurrent, totalSubtitle,Lang);
    //SUBTITLE off
    if(SubtitleState == true)
    {
        ETG_TRACE_USR1(("DVD_PLaybackActions Subtitle State : %x , current %x , total %x ", SubtitleState ,subtitleCurrent , totalSubtitle));
        sleep(5);
        result = mMediaPlayerInterface.RequestSubtitleChange(true, 0 , 1);

        sleep(5);
        result = mMediaPlayerInterface.GetSubtitleInfo(SubtitleState, subtitleCurrent, totalSubtitle,Lang);
        ETG_TRACE_USR1(("DVD_PLaybackActions Subtitle State : %x , current %x , total %x ", SubtitleState ,subtitleCurrent , totalSubtitle));
    }
    sleep(5);
    //SUBTITLE on
    result = mMediaPlayerInterface.RequestSubtitleChange(true, 5 , 1);

    result = mMediaPlayerInterface.GetSubtitleInfo(SubtitleState, subtitleCurrent, totalSubtitle,Lang);

    ETG_TRACE_USR1(("DVD_PLaybackActions Subtitle State : %x , current %x , total %x ", SubtitleState ,subtitleCurrent , totalSubtitle));

    sleep(5);
    result = mMediaPlayerInterface.SendPlaybackAction(PBA_PAUSE);
    sleep(5);

    result = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("DVD_PLaybackActions PAUSE : %d ", playstatus));
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_PAUSED);

    result = mMediaPlayerInterface.SendPlaybackAction(PBA_PLAY);
    sleep(10);


    result = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("DVD_PLaybackActions PLAY : %d ", playstatus));
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);
    //direct search
    result = mMediaPlayerInterface.RequestDirectSearch(1,7); //3,3 for forever my love
    sleep(10);
    ETG_TRACE_USR1(("DVD_PlaybackActions::NowPlaying before NEXT"));
    mMediaPlayerInterface.GetNowPlaying(nowPlaying);

    result = mMediaPlayerInterface.SendPlaybackAction(PBA_NEXT);
    sleep(5);

    ETG_TRACE_USR1(("DVD_PlaybackActions::NowPlaying After NEXT"));
    mMediaPlayerInterface.GetNowPlaying(nowPlaying);

    result = mMediaPlayerInterface.SendPlaybackAction(PBA_PREV);
    sleep(5);

    ETG_TRACE_USR1(("DVD_PlaybackActions::NowPlaying After PREV"));
    mMediaPlayerInterface.GetNowPlaying(nowPlaying);
    sleep(5);

    ETG_TRACE_USR1(("DVD_PlaybackActions::Go back to main menu"));
    result = mMediaPlayerInterface.SetMenuPlayBackControl(1);
    sleep(5);
    result = mMediaPlayerInterface.SendNavigationKey(RIGHT);
    sleep(2);
    //right
    result = mMediaPlayerInterface.SendNavigationKey(RIGHT);
    sleep(2);
    result = mMediaPlayerInterface.SendNavigationKey(RIGHT);
    sleep(2);
    //right
    result = mMediaPlayerInterface.SendNavigationKey(KEY_ENTER);
    sleep(2);
    result = mMediaPlayerInterface.SelectDirectNumber(3);
    //right
    result = mMediaPlayerInterface.SendNavigationKey(KEY_ENTER);
    sleep(5);
    result = mMediaPlayerInterface.SendPlaybackSpeed(PBK_FORWARD,PBK_SPEED_8X);
    sleep(5);

    result = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("DVD_PLaybackActions FWD_START : %d ", playstatus));

    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_FFWD);

    result = mMediaPlayerInterface.SendPlaybackSpeed(PBK_FORWARD,PBK_SPEED_1X);
    sleep(5);

    result = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("DVD_PLaybackActions FWD_STOP : %d ", playstatus));

    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);

    result = mMediaPlayerInterface.SendPlaybackSpeed(PBK_FORWARD,PBK_SPEED_2X);
    sleep(5);

    result = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("DVD_PLaybackActions FWD_START : %d ", playstatus));

    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_FFWD);

    result = mMediaPlayerInterface.SendPlaybackSpeed(PBK_FORWARD,PBK_SPEED_1X);
    sleep(5);

    result = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("DVD_PLaybackActions FWD_STOP : %d ", playstatus));

    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);

    result = mMediaPlayerInterface.SendPlaybackSpeed(PBK_BACKWARD,PBK_SPEED_4X);
    sleep(5);

    result = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("DVD_PLaybackActions FREV_START : %d ", playstatus));
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_FREV);

    result = mMediaPlayerInterface.SendPlaybackSpeed(PBK_BACKWARD,PBK_SPEED_1X);
    sleep(5);

    result = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("DVD_PLaybackActions FREV_STOP : %d ", playstatus));
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);

    result = mMediaPlayerInterface.SendPlaybackSpeed(PBK_BACKWARD,PBK_SPEED_0_2X);
    sleep(5);

    result = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("DVD_PLaybackActions FREV_START : %d ", playstatus));
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_FREV);

    result = mMediaPlayerInterface.SendPlaybackSpeed(PBK_BACKWARD,PBK_SPEED_1X);
    sleep(5);

    result = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("DVD_PLaybackActions FREV_STOP : %d ", playstatus));
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);
    sleep(5);
    tBool skip = false;
    result = mMediaPlayerInterface.GetSkipInfo(skip);
    ETG_TRACE_USR1(("DVD_PLaybackActions skip status : %x ", skip));
    if(skip == true)
    {
        result = mMediaPlayerInterface.RequestCMSkip(0x3C);
        ETG_TRACE_USR1(("DVD_PLaybackActions skip FORWARD +60S  " ));
        sleep(5);
        result = mMediaPlayerInterface.RequestCMSkip(0x3C);
        ETG_TRACE_USR1(("DVD_PLaybackActions skip FORWARD +60S  " ));
        sleep(5);
        result = mMediaPlayerInterface.RequestCMSkip(0xF1);
        ETG_TRACE_USR1(("DVD_PLaybackActions skip REVERSE -15S  "));
        sleep(5);
    }

}
void MediaPlayerInterfaceTest::InitTestsuitewithoutDB()
{
    ENTRY

    tResult res = MP_NO_ERROR;

    res = LocalSPM::GetDBManager().GetDatabase()->CheckDatabaseIntegrity(LocalSPM::GetDBManager().GetDatabase()->Handle());
    GMPTEST_EXPECT(res == 0);

    RegisterUpdatePlaybackState();
    RegisterUpdatePlaytime();
    RegisterNowPlaying();
}

void  MediaPlayerInterfaceTest::StopDVD()
{
    ENTRY_TEST

    tResult result;
    tHMIPlaybackState playstatus;
    sleep(5);
    result = mMediaPlayerInterface.SendPlaybackAction(PBA_STOP);
    sleep(5);

    result = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("DVD_PLaybackActions STOP : %d ", playstatus));
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_STOPPED);

    return;
}
void  MediaPlayerInterfaceTest::PlayDVD()
{
    ENTRY_TEST

    tResult result;
    tHMIPlaybackState playstatus;
    sleep(5);
    result = mMediaPlayerInterface.SendPlaybackAction(PBA_PLAY);
    sleep(5);


    result = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);
    ETG_TRACE_USR1(("DVD_PLaybackActions PLAY : %d ", playstatus));
    GMPTEST_EXPECT(result == 0);
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);

    return;
}



void MediaPlayerInterfaceTest::PlayItemFromListByTagAudioCD()
{
    ENTRY_TEST

    // need parameters : tListSize &listSize, const tListID listID, const tObjectID objectID
    tResult res = -1;

    tListType ListType = LTY_SONG;
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
    tDeviceID deviceID;
    /* set the path */
    strncpy_r(OUT path, IN "/", IN sizeof(path));
    // get device id
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_DVD_DRIVE);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    // create Indexed list

    res = mMediaPlayerInterface.CreateMediaPlayerCDList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID);

    // Check if listID is valid
    GMPTEST_EXPECT(LIST_ID_NONE != listID);
    VARTRACE(listSize);
    vector<tMediaObject> mediaObjectVector;
    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, listSize);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    // use oblectId to get listSize
    res = mMediaPlayerInterface.PlayItemFromListByTag(OUT listSize, IN listID, IN mediaObjectVector[5].objectID);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    tNowPlaying nowPlaying;
    res = LocalSPM::GetPlayerManager().GetNowPlaying(nowPlaying);
    VARTRACE(nowPlaying);
    // Call GetPlaybackState to check the current playback state of the MediaPlayer
    tHMIPlaybackState playstatus;
    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);

    ETG_TRACE_USR1((" PlayItemFromListByTag::GetPlaybackState Action : %d ", playstatus));
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);
#if 0
    // use oblectId to get listSize
    res = mMediaPlayerInterface.PlayItemFromListByTag(OUT listSize, IN listID, IN mediaObjectVector[3].objectID);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    tNowPlaying nowPlaying;
    res = LocalSPM::GetPlayerManager().GetNowPlaying(nowPlaying);
    VARTRACE(nowPlaying);
    // Call GetPlaybackState to check the current playback state of the MediaPlayer
    tHMIPlaybackState playstatus;
    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);

    ETG_TRACE_USR1((" PlayItemFromListByTag::GetPlaybackState Action : %d ", playstatus));
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);

#endif

}


inline tResult MediaPlayerInterfaceTest::WaitForFileOperationResult()
{
    tResult res;
    while(1)
    {
        if(LocalSPM::GetOutputWrapper().isFileOperationCompleted(res))
        {
            ETG_TRACE_USR4(("FileListOperation is completed, the result received is : %d",res ));
            break;
        }
        else
        {
            ETG_TRACE_USR4(("FileListOperation is in Progress, so waiting for some more time to fetch the result"));
            sleep(1);
        }

    }
    return res;
}
// Seperate Media Context testing
void MediaPlayerInterfaceTest::EnableSeparateMediaContent()
{
    LocalSPM::GetDataProvider().SeparateMediaContent = 1;
}

void MediaPlayerInterfaceTest::EnableFileListBrowsingFromDB()
{
    /* Enable DBFileBrowsingByDB configuration */
    int browsingByDB1 = LocalSPM::GetDataProvider().DBFileBrowsingByDB();
    if (0 == browsingByDB1)
    {
        LocalSPM::GetDataProvider().DBFileBrowsingByDB = 1;
    }

    /* Enable DBFileListWhileIndexing configuration */
    int browsingByDB2 = LocalSPM::GetDataProvider().DBFileListWhileIndexing();
    if (0 == browsingByDB2)
    {
        LocalSPM::GetDataProvider().DBFileListWhileIndexing = 1;
    }

    /* recreate the test database */
    InitTestsuite();
}

void MediaPlayerInterfaceTest::InsertUSBWithAudioVideoFiles()
{
    tResult res;
    tDeviceID deviceID;
    tDeviceInfo deviceInfo;

    ETG_TRACE_USR2(("%s", __PRETTY_FUNCTION__));

    // add a second usb device for the test data for my media tests
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB-3");
    if (res) {
        deviceInfo.activeSource = 0;
        deviceInfo.connected = 1;
        strncpy_r(OUT deviceInfo.deviceName, IN "USB-3", IN sizeof(deviceInfo.deviceName));
        deviceInfo.deviceType = DTY_USB;
        deviceInfo.connectionState = CS_CONNECTED;
        strncpy_r(OUT deviceInfo.serialNumber, IN "987444321", IN sizeof(deviceInfo.serialNumber));     //POP:: What number ???
        strncpy_r(OUT deviceInfo.deviceVersion, IN "1.1", IN sizeof(deviceInfo.deviceVersion));
        strncpy_r(OUT deviceInfo.UUID, IN "3", IN sizeof(deviceInfo.UUID)); // unique
        strncpy_r(OUT deviceInfo.accessoryName, IN "/dev/sdc", IN sizeof(deviceInfo.accessoryName));
        deviceInfo.fileSystemType = FSTY_FAT;
        deviceInfo.partitionNumber = 1;
        deviceInfo.totalSize = 4194304; //4GB
        deviceInfo.freeSize = 524288; //512MB
        deviceInfo.productID = 5652;
        deviceInfo.connectionType = DCT_USB;
#if 1 // for moduletests with data stored in view
#ifndef TARGET_BUILD
        strncpy_r(OUT deviceInfo.mountPoint, IN get_current_dir_name(), IN sizeof(deviceInfo.mountPoint));
        strncat_r(OUT deviceInfo.mountPoint, IN "/Customer/Simulation/CustomControl/test", IN sizeof(deviceInfo.mountPoint));
#else
        strncpy_r(OUT deviceInfo.mountPoint, IN "/opt/bosch/test/data", IN sizeof(deviceInfo.mountPoint));
#endif
#else // for a test with a stick on ubuntu:
        strncpy_r(OUT deviceInfo.mountPoint, IN "/media/KINGSTON", IN sizeof(deviceInfo.mountPoint));
#endif
        res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
        CPPUNIT_ASSERT(res == 0);

        /* scan the second USB test data */
        res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB-3");
        CPPUNIT_ASSERT(res == 0);

        res = LocalSPM::GetDBManager().ScanDirForTest(deviceID);
        CPPUNIT_ASSERT(res == 0);
    }
}

void MediaPlayerInterfaceTest::VerifyMediaFileCountInformation()
{
    tNumberOfFiles numberOfTrackInDB;
    tDeviceID deviceID;

    sleep(1);
    /* scan the second USB test data */
    tResult res1 = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB-3");
    CPPUNIT_ASSERT(res1 == 0);

    tResult res2 = LocalSPM::GetDBManager().GetNumberofTracks(OUT numberOfTrackInDB, IN deviceID);
    ETG_TRACE_USR4(("numberOfTrackInDB Audio : %d",numberOfTrackInDB));
    CPPUNIT_ASSERT((numberOfTrackInDB > 0) && (numberOfTrackInDB < NUMBER_OF_FILES_NONE));

    numberOfTrackInDB = 0;
    tResult res3 = LocalSPM::GetDBManager().GetNumberOfVideos(OUT numberOfTrackInDB, IN deviceID);
    ETG_TRACE_USR4(("numberOfTrackInDB Video : %d",numberOfTrackInDB));
    CPPUNIT_ASSERT((numberOfTrackInDB > 0) && (numberOfTrackInDB < NUMBER_OF_FILES_NONE));
}
void MediaPlayerInterfaceTest::PlayItemFromListByTagYearList()
{

    ENTRY_TEST
    tResult res;
    tStreaming streaming = false;
    tFilterTag1 tag1 = { 0 };
    tFilterTag2 tag2 = { 0 };
    tFilterTag3 tag3 = { 0 };
    tFilterTag4 tag4 = { 0 };
    vector<tListID> listIDVector;
    tListSize listSize;
    vector<tMediaObject> mediaObjectVector;
    vector<tMediaObject> mediaObjectVectorSongs;
    tDeviceID deviceID;
    tListID listID;

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB");
    CPPUNIT_ASSERT(res == MP_NO_ERROR);


    res = mMediaPlayerInterface.ActiveMediaDeviceSet(IN deviceID, IN true);
    GMPTEST_EXPECT(res == 0);
    sleep(10);

    /* create a album list */
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_YEAR,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    VARTRACE(listID);
    VARTRACE(listSize);
    CPPUNIT_ASSERT(listSize == 4);
    // CPPUNIT_ASSERT(listSize == 1);
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            IN 0,
            IN listSize);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    VARTRACE(mediaObjectVector);
    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    //for(unsigned int i = 0 ; i < listSize ;i++)
    //{
    tag1.yearID = mediaObjectVector[0].yearID;
    VARTRACE(tag1.yearID);
    // snprintf(tag1,sizeof(tFilterTag1),"2002");
    /* second ask for all albums */
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_YEAR_ALBUM,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    VARTRACE(listSize);


    mediaObjectVector.clear();
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            0,
            listSize);

    CPPUNIT_ASSERT(res == MP_NO_ERROR);

    VARTRACE(mediaObjectVector);
    res = LocalSPM::GetListControl().ReleaseList(IN listID);

    tag1.yearID = mediaObjectVector[0].yearID;
    tag4.album = mediaObjectVector[0].MetadataTag4;


    /* second ask for all SONGS in the album with a particular year */
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_YEAR_ALBUM_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    mediaObjectVector.clear();
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            0,
            listSize);

    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    /* Set active object to the first one */
    tPosition position;
    res = LocalSPM::GetListControl().UpdateNowPlaying(OUT position, IN listID, IN mediaObjectVector[0].objectID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(position == 0);
    tMediaObject currentMediaObject;
    /* Check whether current object is same as set via UpdateNowPlaying */
    res = LocalSPM::GetListControl().GetCurrentMediaObject(OUT currentMediaObject, IN listID);
    CPPUNIT_ASSERT(res == MP_NO_ERROR);
    CPPUNIT_ASSERT(currentMediaObject.objectID == mediaObjectVector[0].objectID);

    VARTRACE(mediaObjectVector);


    res = mMediaPlayerInterface.PlayItemFromListByTag(OUT listSize, IN listID, IN mediaObjectVector[1].objectID);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    res = WaitForPlaytimeUpdate();
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    tNowPlaying nowPlaying;
    res = LocalSPM::GetPlayerManager().GetNowPlaying(nowPlaying);
    VARTRACE(nowPlaying);

    // Call GetPlaybackState to check the current playback state of the MediaPlayer
    tHMIPlaybackState playstatus;
    res = mMediaPlayerInterface.GetPlaybackState(OUT playstatus);

    ETG_TRACE_USR1((" PlayItemFromListByTag::GetPlaybackState Action : %d ", playstatus));
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    GMPTEST_EXPECT(playstatus == HMI_PBS_PLAYING);

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
}
//>--Roadmap CMG3G-10221 : 'Scene Recorder '
void MediaPlayerInterfaceTest::VerifySetFilePermissionMediaObject_Read()
{
    ENTRY_TEST
    tDeviceID deviceID;
    tResult res;
    vector<tFiles> mediaObjectVector;

    HelperFileOperations(OUT deviceID, OUT mediaObjectVector);
    tListSize listSize_newplayback = 0;
    tIndex index = 0; /*from the first song */
    tPlaytime offset = 0;
    //res = mMediaPlayerInterface.PlayItemFromList(OUT listSize_newplayback, IN mListID, IN index, IN offset);
    // test result
    //GMPTEST_EXPECT(res == 0);
    //WaitForPlaytimeUpdate(5);
    tFilePermission file;
    std::vector<tFilePermission> objectIDs;
    for(size_t i = 0; i < mediaObjectVector.size();i++)
    {
        file.objectID = mediaObjectVector[i].objectID;
        file.readOnly = true;
        objectIDs.push_back(file);
    }

    if( !mMediaPlayerInterface.SetFilePermissions(objectIDs, deviceID))
        res = 0;
    GMPTEST_EXPECT(0 == res);
}
void MediaPlayerInterfaceTest::VerifySetFilePermissionMediaObject_ReadWrite()
{
    ENTRY_TEST
    tDeviceID deviceID;
    tResult res;
    vector<tFiles> mediaObjectVector;

    HelperFileOperations(OUT deviceID, OUT mediaObjectVector);
    tListSize listSize_newplayback = 0;
    tIndex index = 0; /*from the first song */
    tPlaytime offset = 0;
    //res = mMediaPlayerInterface.PlayItemFromList(OUT listSize_newplayback, IN mListID, IN index, IN offset);
    // test result
    //GMPTEST_EXPECT(res == 0);
    //WaitForPlaytimeUpdate(5);
    tFilePermission file;
    std::vector<tFilePermission> objectIDs;
    for(size_t i = 0; i < mediaObjectVector.size();i++)
    {
        file.objectID = mediaObjectVector[i].objectID;
        file.readOnly = false;
        objectIDs.push_back(file);
    }

    if( !mMediaPlayerInterface.SetFilePermissions(objectIDs, deviceID))
        res = 0;
    GMPTEST_EXPECT(0 == res);
}
void MediaPlayerInterfaceTest::HelperFileOperations(OUT tDeviceID &deviceID, OUT vector<tFiles> &mediaFileVector)
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
#ifdef USE_GENERIC_STICK
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB,"USB");
    GMPTEST_EXPECT(res == 0);
#else
    tDeviceID deviceID = 3;/*stick_2*/
#endif
    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    ETG_TRACE_USR1(("mount point : %s", deviceInfo.mountPoint));
    /* create a file list from root directory */
    strncpy_r(OUT path, IN "/video", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_ALL);

    ETG_TRACE_USR1(("deviceID : %d", deviceID));
    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, listSize);

    for (tUInt i = 0; i < mediaFileVector.size(); i++)
    {
        ETG_TRACE_USR1(("fileName : %s", mediaFileVector.at(i).fileName));
        ETG_TRACE_USR1(("ObjID : %d", mediaFileVector.at(i).objectID));
    }
}

void MediaPlayerInterfaceTest::MediaplayerFolderInfo()
{
    ENTRY_TEST
    tResult res = -1;
    tPath path;
    tFolderInfo folderinfo;
    tDeviceID deviceID;
#if 1
#ifdef USE_GENERIC_STICK
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB,"USB");
    GMPTEST_EXPECT(res == 0);
#else
    tDeviceID deviceID = 3;/*stick_2*/
#endif
    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    ETG_TRACE_USR1(("mount point : %s", deviceInfo.mountPoint));
    /* create a file list from root directory */
    strncpy_r(OUT path, IN "/music", IN sizeof(path));
    res = mMediaPlayerInterface.MediaplayerFolderInfo(deviceID, path,FTS_ALL,folderinfo);
    GMPTEST_EXPECT(res == 0);

    ETG_TRACE_USR1(("deviceID : %d", deviceID));
    ETG_TRACE_USR1(("totalSize : %lu", folderinfo.totalSize));
    ETG_TRACE_USR1(("totalNumber : %d", folderinfo.totalNumber));
    ETG_TRACE_USR1(("protectedSize : %lu", folderinfo.protectedSize));
    ETG_TRACE_USR1(("protectedNumber : %d", folderinfo.protectedNumber));

#endif
}
//<--Roadmap CMG3G-10221 : 'Scene Recorder '
void MediaPlayerInterfaceTest::TriggerRG()
{
    ENTRY_TEST

    tResult res = -1;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tDiPOActive diPOActive = true;
    tUserContext userContext;
    tDeviceInfo deviceInfo;

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_IPOD, "IPOD");
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    // Initialisation of user context
    userContext.sourceAppID = tSourceAppID_init;
    userContext.registerID = tRegisterID_init;
    userContext.cmdCounter = tCmdCounter_init;
    userContext.functionID = tFunctionID_init;
    userContext.serviceID = tServiceID_init;


    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo , IN deviceID);
    GMPTEST_EXPECT(res == MP_NO_ERROR);
    tResult result;
    tRouteGuidanceDisplayComponentIDList RGDisplayComponentIDs;
    if(deviceInfo.connectionType == DCT_WIFI)
    {
        result = MediaPlayerInterface::GetInstance().DiPOStartRouteGuidance(IN deviceInfo.appleDeviceUSBSerialNumber, RGDisplayComponentIDs, FALSE, FALSE);
        GMPTEST_EXPECT(result == 0);
    }
    else if(deviceInfo.connectionType == DCT_USB)
    {
        result = MediaPlayerInterface::GetInstance().DiPOStartRouteGuidance(IN deviceInfo.mountPoint, RGDisplayComponentIDs, FALSE, FALSE);
        GMPTEST_EXPECT(result == 0);
    }
    tDiPORouteGuidanceUpdate RGUpdate;
    result = MediaPlayerInterface::GetInstance().GetRGUpdate(IN deviceID,OUT RGUpdate);
    GMPTEST_EXPECT(result == 0);
    VARTRACE(RGUpdate);
    tDiPORouteGuidanceManeuverUpdate RGManeuverUpdate;
    result = MediaPlayerInterface::GetInstance().GetRGManeuverUpdate(IN deviceID,OUT RGManeuverUpdate);
    GMPTEST_EXPECT(result == 0);
    VARTRACE(RGManeuverUpdate);
}
//>--Roadmap 16003 : 'CD Ripping With Gracenote'
void MediaPlayerInterfaceTest::AddFileNamesToPlaylistByTag()
{
    ENTRY_TEST
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tResult res = -1;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;
    tPath playlistPath = "MyList3.m3u";
    vector<tMediaObject> mediaObjectVector;
    tListID listID;
    tListSize listSize;
    tListSize listPlaylistSize;





    /*choose the internal playlist to which entry is to be added*/


    // set device id
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == MP_NO_ERROR);


    vector<tPosition> positionVector;


    //first clear all the entries of the playlist
    LocalSPM::GetOutputWrapper().StartFileOperation();
    // Deleting the playlist entries in a non existing playlist.
    res = mMediaPlayerInterface.DeleteEntriesFromPlaylist(IN playlistPath, IN deviceID, IN positionVector);
    res = WaitForFileOperationResult();
    GMPTEST_EXPECT(res == MP_NO_ERROR);



    // create the first list
    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            IN LTY_ALBUM,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);


    res = mMediaPlayerInterface.RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, 5);
    GMPTEST_EXPECT(res == 0);

    res = mMediaPlayerInterface.ReleaseList(IN listID);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(mediaObjectVector.size() > 2); //At least 2 elements
    ETG_TRACE_USR4(("List of albums listSize= %d ",listSize))

    //ALBUM_SONG
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = mediaObjectVector[1].MetadataTag4;
    tag4.tag = 0x0;

    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_ALBUM_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    res = mMediaPlayerInterface.ReleaseList(IN listID);
    GMPTEST_EXPECT(listSize > 0);
    ETG_TRACE_USR4(("firstalbumlistSize= %d ",listSize))






    LocalSPM::GetOutputWrapper().StartFileOperation();
    if( mMediaPlayerInterface.AddFileNamesToPlaylistByTag(IN LTY_ALBUM_SONG, IN tag1, IN tag2, IN tag3, IN tag4, IN playlistPath, IN deviceID))
    {
        res = 0;
    }
    res = WaitForFileOperationResult();


    tListSize secAlbumListSize;
    //ALBUM_SONG
    tag1.tag = 0x0;
    tag2.tag = 0x0;
    tag3.tag = mediaObjectVector[2].MetadataTag4;
    tag4.tag = 0x0;

    res = mMediaPlayerInterface.CreateMediaPlayerIndexedList(
            OUT listID,
            OUT secAlbumListSize,
            LTY_ALBUM_SONG,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            IN deviceID);
    GMPTEST_EXPECT(res == 0);
    res = mMediaPlayerInterface.ReleaseList(IN listID);
    GMPTEST_EXPECT(secAlbumListSize > 0);
    ETG_TRACE_USR4(("secAlbumListSize= %d ",secAlbumListSize))
    LocalSPM::GetOutputWrapper().StartFileOperation();
    if( mMediaPlayerInterface.AddFileNamesToPlaylistByTag(IN LTY_ALBUM_SONG, IN tag1, IN tag2, IN tag3, IN tag4, IN playlistPath, IN deviceID))
    {
        res = 0;
    }
    res = WaitForFileOperationResult();


    /*now parse the internal playlist and check if files added from the previous steps are available as part of the playlist content*/
    res = mMediaPlayerInterface.CreateMediaPlayerPlaylistList(OUT listID, OUT listPlaylistSize, IN playlistPath);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT((listSize+secAlbumListSize) == listPlaylistSize);

    ETG_TRACE_USR4(("listPlaylistSize= %d ",listPlaylistSize))



}
//<--Roadmap 16003 : 'CD Ripping With Gracenote'

void MediaPlayerInterfaceTest::EnableListBrowsingFromDB()
{
    /* Enable DBFileBrowsingByDB configuration */
    int browsingByDB1 = LocalSPM::GetDataProvider().DBFileBrowsingByDB();
    if (0 == browsingByDB1)
    {
        LocalSPM::GetDataProvider().DBFileBrowsingByDB = 1;
    }

    /* Enable DBFileListWhileIndexing configuration */
    int browsingByDB2 = LocalSPM::GetDataProvider().DBFileListWhileIndexing();
    if (0 == browsingByDB2)
    {
        LocalSPM::GetDataProvider().DBFileListWhileIndexing = 1;
    }

    /* recreate the test database */
    InitTestsuite();
}

void MediaPlayerInterfaceTest::InsertUSBWithHugeData()
{
    tResult res;
    tDeviceID deviceID;
    tDeviceInfo deviceInfo;

    ETG_TRACE_USR2(("%s", __PRETTY_FUNCTION__));
    res = LocalSPM::GetIndexer().SwitchDBTrigger(IN TT_ALL, IN TS_ON);
    GMPTEST_EXPECT(res == MP_NO_ERROR);

    // add a second usb device for the test data for my media tests
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB-P");
    if (res) {
        deviceInfo.activeSource = 0;
        deviceInfo.connected = 1;
        strncpy_r(OUT deviceInfo.deviceName, IN "USB-P", IN sizeof(deviceInfo.deviceName));
        deviceInfo.deviceType = DTY_USB;
        deviceInfo.connectionState = CS_CONNECTED;
        strncpy_r(OUT deviceInfo.serialNumber, IN "987444567", IN sizeof(deviceInfo.serialNumber));     //POP:: What number ???
        strncpy_r(OUT deviceInfo.deviceVersion, IN "1.1", IN sizeof(deviceInfo.deviceVersion));
        strncpy_r(OUT deviceInfo.UUID, IN "P", IN sizeof(deviceInfo.UUID)); // unique
        strncpy_r(OUT deviceInfo.accessoryName, IN "/dev/sdb1", IN sizeof(deviceInfo.accessoryName));///dev/sdc
        deviceInfo.fileSystemType = FSTY_FAT;
        deviceInfo.partitionNumber = 1;
        deviceInfo.totalSize = 4194304; //4GB
        deviceInfo.freeSize = 524288; //512MB
        deviceInfo.productID = 5652;
        deviceInfo.connectionType = DCT_USB;

        //For USB testing we need to make it if(0), and Device should be mounted.
#if 1 // for moduletests with data stored in view POP::
#ifndef TARGET_BUILD
        strncpy_r(OUT deviceInfo.mountPoint, IN get_current_dir_name(), IN sizeof(deviceInfo.mountPoint));
        strncat_r(OUT deviceInfo.mountPoint, IN "/Customer/Simulation/CustomControl/test", IN sizeof(deviceInfo.mountPoint));
#else
        strncpy_r(OUT deviceInfo.mountPoint, IN "/opt/bosch/test/data", IN sizeof(deviceInfo.mountPoint));
#endif
#else // for a test with a stick on ubuntu:
        strncpy_r(OUT deviceInfo.mountPoint, IN "/media/sor3kor/KINGSTON", IN sizeof(deviceInfo.mountPoint));
#endif
        res = LocalSPM::GetDBManager().AddDevice(INOUT deviceInfo);
        CPPUNIT_ASSERT(res == 0);

        res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB-P");
        CPPUNIT_ASSERT(res == 0);

        res = LocalSPM::GetDBManager().SetDeviceNameAndConnectionState(IN deviceID, IN deviceInfo.deviceName, IN deviceInfo.connectionState, IN DS_OK);
        GMPTEST_EXPECT(res == MP_NO_ERROR);

        // Force re-indexing
        res = mMediaPlayerInterface.Reindexing(IN deviceID);
        GMPTEST_EXPECT(res == MP_NO_ERROR);

        sleep(5);
        tIndexingState indexingState;
        int retry = 20;
        while(retry) {
            res = LocalSPM::GetDBManager().GetIndexingState(OUT indexingState, IN deviceID);
            GMPTEST_EXPECT(MP_NO_ERROR == res);
            if (IDS_PARTIAL == indexingState) {
                break;
            }
            sleep(1);
            retry--;
        }
        LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished(IN deviceID);
        if(indexingState == IDS_PARTIAL || indexingState == IDS_COMPLETE)
        {
            BrowseFileListInfo();
        }
        // Disable triggers
        res = LocalSPM::GetIndexer().SwitchDBTrigger(IN TT_ALL, IN TS_OFF);
        GMPTEST_EXPECT(res == MP_NO_ERROR);
    }
}

void MediaPlayerInterfaceTest::BrowseFileListInfo()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path, folderPath;
#ifdef USE_GENERIC_STICK
    tDeviceID deviceID;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB,"USB-P");
    GMPTEST_EXPECT(res == 0);
#else
    tDeviceID deviceID = 3;/*stick_2*/
#endif

    /* create a file list from root directory */
    strncpy_r(OUT path, IN "/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID,
            IN FTS_AUDIO_VIDEO_PLAYLIST);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(listSize >= 1);

    /* get the list slice */
    vector<tFiles> mediaFileVector;
    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, listSize);
    GMPTEST_EXPECT(res == 0);
    int listCount = 0;
    vector<tFiles>::iterator  it = mediaFileVector.begin();
    for( ; it!= mediaFileVector.end() ; it++ )
    {
        if((it->type == FT_FOLDER)) listCount++;
    }
    ETG_TRACE_USR2(("listCount: %d",listCount));
}

void MediaPlayerInterfaceTest::DVD_TemperatureTest()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tUserContext context;
    InitUserContext(context);
    res = mMediaPlayerInterface.RequestDVDTemperature(context);
    GMPTEST_EXPECT(res == 0);
}
void MediaPlayerInterfaceTest::ExtractGracenoteMetadataTest()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tMetadata ToCString;
    tUUID uuid;

    strncpy_r(OUT ToCString,IN "150 21757 86962 148262 175405 202816",IN sizeof(tMetadata));
    strncpy_r(OUT uuid,IN "d0e4b2843d9876c9dbfaf8d3c884aebc",IN sizeof(tMetadata));

    res = LocalSPM::GetDBManager().AddMusicBoxToC(ToCString,uuid);
    CPPUNIT_ASSERT(res == 0);

    string albumTitle = "Alchemy: Dire Straits Live [Disc 2]";
    //strncpy_r(OUT albumTitle,IN ,IN sizeof(tMetadata));
    tBool MultipleSelection = 0;
    res = mMediaPlayerInterface.ExtractGracenoteMetadata(albumTitle, MultipleSelection);
    CPPUNIT_ASSERT(res == 0);
}
void MediaPlayerInterfaceTest::RenameMusicBoxPlaylistTest()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    tPath playlistPath1;
    tPath playlistPath2;
    tDeviceID deviceTag = MUSICBOX_DEVICE_ID;
    tPlaylistName playlistName;

    strncpy_r(OUT playlistName, IN "playlist1" , sizeof(tPlaylistName));
    res = mMediaPlayerInterface.CreateInternalFileNamePlaylist(playlistPath1, deviceTag, playlistName);
    CPPUNIT_ASSERT(res == 0);

    strncpy_r(OUT playlistName, IN "playlist2" , sizeof(tPlaylistName));
    res = mMediaPlayerInterface.CreateInternalFileNamePlaylist(playlistPath2, deviceTag, playlistName);
    CPPUNIT_ASSERT(res == 0);

    res = mMediaPlayerInterface.RenameInternalPlaylist(MUSICBOX_DEVICE_ID, playlistPath1, "playlist1");
    CPPUNIT_ASSERT(res == 0);

    res = mMediaPlayerInterface.RenameInternalPlaylist(MUSICBOX_DEVICE_ID, playlistPath2, "playlist1");
    CPPUNIT_ASSERT(res == 1021);

    res = mMediaPlayerInterface.RenameInternalPlaylist(MUSICBOX_DEVICE_ID, playlistPath1, "playlist5");
    CPPUNIT_ASSERT(res == 0);
}
void MediaPlayerInterfaceTest::EditYomimetadataTest()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    tEditMetaDataByID editMetaDataByID;
    memset((void*)&editMetaDataByID,0,sizeof(editMetaDataByID));
    tEditMetaDataByUrl editMetaDataByUrl;
    memset((void*)&editMetaDataByUrl,0,sizeof(editMetaDataByUrl));

    tYomiMetadata yomiMetadata;
    tYomiMetadata res_yomiMetadata;
    tMediaObject mediaObject;
    InitMediaObject(OUT mediaObject);

    mediaObject.deviceID = MUSICBOX_DEVICE_ID;
    mediaObject.catType = CTY_SONG;
    strncpy_r(OUT mediaObject.fileName, "myfile.mp3", IN sizeof(mediaObject.fileName));
    strncpy_r(OUT mediaObject.UUID, "d0e4b2843d9876c9dbfaf8d3c884aebc", IN sizeof(mediaObject.UUID));
    strncpy_r(OUT mediaObject.path, "d0e4b2843d9876c9dbfaf8d3c884aebc", IN sizeof(mediaObject.path));
    strncpy_r(OUT mediaObject.parentUUID, "any parent UUID", IN sizeof(mediaObject.parentUUID));
    strncpy_r(OUT mediaObject.title, "My Song", IN sizeof(mediaObject.title)); //song title
    strncpy_r(OUT mediaObject.MetadataField1, "Rock", IN sizeof(mediaObject.MetadataField1)); //genre
    strncpy_r(OUT mediaObject.MetadataField2, "Thoemel", IN sizeof(mediaObject.MetadataField2)); //artist
    strncpy_r(OUT mediaObject.MetadataField3, "Ghostwriter", IN sizeof(mediaObject.MetadataField3)); //composer
    strncpy_r(OUT mediaObject.MetadataField4, "my first album", IN sizeof(mediaObject.MetadataField4)); //album
    mediaObject.metadataConvertFlag = 0;
    mediaObject.compilationFlag = 0;
    mediaObject.totalPlaytime = 30000;
    strncpy_r(OUT mediaObject.albumArtString, "/mydir/myfile.mp3", IN sizeof(mediaObject.albumArtString));
    mediaObject.trackNumber = 7;
    mediaObject.notPlayable = FNP_PLAYABLE;
    mediaObject.fileSize = 1567000LL;
    strncpy_r(OUT mediaObject.dateTime, "2016:07:08 14:56:00", IN sizeof(mediaObject.dateTime));
    mediaObject.fileMode = 356;
    mediaObject.userID = 190;
    mediaObject.groupID = 49;

    // get the DB info for the device
    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN mediaObject.deviceID);
    CPPUNIT_ASSERT(res == 0);

    /* put the device information into the media object */
    strncpy_r(OUT mediaObject.deviceVersion, IN deviceInfo.deviceVersion, IN sizeof(mediaObject.deviceVersion));
    strncpy_r(OUT mediaObject.mountPoint, IN deviceInfo.mountPoint, IN sizeof(mediaObject.mountPoint));
    mediaObject.deviceType = deviceInfo.deviceType;

    res = LocalSPM::GetDBManager().StoreMediaObject(IN mediaObject);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().StoreMediaObjectEnd();
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
    CPPUNIT_ASSERT(res == 0);

    tObjectID MediaObjectTag;
    res = LocalSPM::GetDBManager().GetObjectID(MediaObjectTag, mediaObject.deviceID,mediaObject.fileName);
    ETG_TRACE_USR4(("URL: %s",mediaObject.fileName));
    ETG_TRACE_USR4(("ObjectID: %d",MediaObjectTag));
    CPPUNIT_ASSERT(res == 0);

    /* add data to the YomiMetadata table*/
    strncpy_r(OUT yomiMetadata.YomiTitle, "yomititle", IN sizeof(mediaObject.YomiTitle));
    strncpy_r(OUT yomiMetadata.YomiArtist, "yomiartist", IN sizeof(mediaObject.YomiArtist));
    strncpy_r(OUT yomiMetadata.YomiAlbum, "yomialbum", IN sizeof(mediaObject.YomiAlbum));
    res = LocalSPM::GetDBManager().AddYomiMetadata(MediaObjectTag, yomiMetadata);
    CPPUNIT_ASSERT(res == 0);

    editMetaDataByID.deviceID = mediaObject.deviceID;

    /*Edit metadata by ID*/
    /*All fields of yomimetadata edited*/
    editMetaDataByID.MediaObjectID = MediaObjectTag;

    strncpy_r(OUT editMetaDataByID.yomiMetaData.YomiTitle, IN "EditedYomiTitle", IN sizeof(editMetaDataByID.yomiMetaData.YomiTitle));
    strncpy_r(OUT editMetaDataByID.yomiMetaData.YomiArtist, IN "EditedYomiArtist", IN sizeof(editMetaDataByID.yomiMetaData.YomiArtist));
    strncpy_r(OUT editMetaDataByID.yomiMetaData.YomiAlbum, IN "EditedYomiAlbum", IN sizeof(editMetaDataByID.yomiMetaData.YomiAlbum));
    res = mMediaPlayerInterface.EditMetaData(editMetaDataByID);
    CPPUNIT_ASSERT(res == 0);


    sleep(1);

    res = LocalSPM::GetDBManager().GetYomiMetadata(MediaObjectTag, res_yomiMetadata);
    CPPUNIT_ASSERT((strcmp(editMetaDataByID.yomiMetaData.YomiTitle,res_yomiMetadata.YomiTitle)) == 0);
    CPPUNIT_ASSERT((strcmp(editMetaDataByID.yomiMetaData.YomiArtist,res_yomiMetadata.YomiArtist)) == 0);
    CPPUNIT_ASSERT((strcmp(editMetaDataByID.yomiMetaData.YomiAlbum,res_yomiMetadata.YomiAlbum)) == 0);

    //Edit title field alone
    strncpy_r(OUT editMetaDataByID.yomiMetaData.YomiTitle, IN "YomiTitleAloneEdited", IN sizeof(editMetaDataByID.yomiMetaData.YomiTitle));
    res = mMediaPlayerInterface.EditMetaData(editMetaDataByID);
    CPPUNIT_ASSERT(res == 0);
    sleep(1);
    res = LocalSPM::GetDBManager().GetYomiMetadata(MediaObjectTag, res_yomiMetadata);
    CPPUNIT_ASSERT((strcmp(editMetaDataByID.yomiMetaData.YomiTitle,res_yomiMetadata.YomiTitle)) == 0);

    //Edit Artist field alone
    strncpy_r(OUT editMetaDataByID.yomiMetaData.YomiArtist, IN "YomiArtistAloneEdited", IN sizeof(editMetaDataByID.yomiMetaData.YomiArtist));
    res = mMediaPlayerInterface.EditMetaData(editMetaDataByID);
    CPPUNIT_ASSERT(res == 0);
    sleep(1);
    res = LocalSPM::GetDBManager().GetYomiMetadata(MediaObjectTag, res_yomiMetadata);
    CPPUNIT_ASSERT((strcmp(editMetaDataByID.yomiMetaData.YomiArtist,res_yomiMetadata.YomiArtist)) == 0);

    //Edit Album field alone
    strncpy_r(OUT editMetaDataByID.yomiMetaData.YomiAlbum, IN "YomiAlbumAloneEdited", IN sizeof(editMetaDataByID.yomiMetaData.YomiAlbum));
    res = mMediaPlayerInterface.EditMetaData(editMetaDataByID);
    CPPUNIT_ASSERT(res == 0);
    sleep(1);
    res = LocalSPM::GetDBManager().GetYomiMetadata(MediaObjectTag, res_yomiMetadata);
    CPPUNIT_ASSERT((strcmp(editMetaDataByID.yomiMetaData.YomiAlbum,res_yomiMetadata.YomiAlbum)) == 0);

    //Edit metadata by URL

    editMetaDataByUrl.deviceID = mediaObject.deviceID;
    //All fields of yomimetadata edited
    strncpy_r(editMetaDataByUrl.MediaObjectUrl,"myfile.mp3", IN sizeof(editMetaDataByUrl.MediaObjectUrl));

    strncpy_r(OUT editMetaDataByUrl.yomiMetaData.YomiTitle, IN "EditedYomiTitlebyURL", IN sizeof(editMetaDataByUrl.yomiMetaData.YomiTitle));
    strncpy_r(OUT editMetaDataByUrl.yomiMetaData.YomiArtist, IN "EditedYomiArtistbyURL", IN sizeof(editMetaDataByUrl.yomiMetaData.YomiArtist));
    strncpy_r(OUT editMetaDataByUrl.yomiMetaData.YomiAlbum, IN "EditedYomiAlbumbyURL", IN sizeof(editMetaDataByUrl.yomiMetaData.YomiAlbum));
    res = mMediaPlayerInterface.EditMetaData(editMetaDataByUrl);
    CPPUNIT_ASSERT(res == 0);


    sleep(1);

    res = LocalSPM::GetDBManager().GetYomiMetadata(MediaObjectTag, res_yomiMetadata);
    CPPUNIT_ASSERT((strcmp(editMetaDataByUrl.yomiMetaData.YomiTitle,res_yomiMetadata.YomiTitle)) == 0);
    CPPUNIT_ASSERT((strcmp(editMetaDataByUrl.yomiMetaData.YomiArtist,res_yomiMetadata.YomiArtist)) == 0);
    CPPUNIT_ASSERT((strcmp(editMetaDataByUrl.yomiMetaData.YomiAlbum,res_yomiMetadata.YomiAlbum)) == 0);

    //Edit title field alone
    strncpy_r(OUT editMetaDataByUrl.yomiMetaData.YomiTitle, IN "YomiTitleAloneEditedbyURL", IN sizeof(editMetaDataByUrl.yomiMetaData.YomiTitle));
    res = mMediaPlayerInterface.EditMetaData(editMetaDataByUrl);
    CPPUNIT_ASSERT(res == 0);
    sleep(1);
    res = LocalSPM::GetDBManager().GetYomiMetadata(MediaObjectTag, res_yomiMetadata);
    CPPUNIT_ASSERT((strcmp(editMetaDataByUrl.yomiMetaData.YomiTitle,res_yomiMetadata.YomiTitle)) == 0);

    //Edit Artist field alone
    strncpy_r(OUT editMetaDataByUrl.yomiMetaData.YomiArtist, IN "YomiArtistAloneEditedbyURL", IN sizeof(editMetaDataByUrl.yomiMetaData.YomiArtist));
    res = mMediaPlayerInterface.EditMetaData(editMetaDataByUrl);
    CPPUNIT_ASSERT(res == 0);
    sleep(1);
    res = LocalSPM::GetDBManager().GetYomiMetadata(MediaObjectTag, res_yomiMetadata);
    CPPUNIT_ASSERT((strcmp(editMetaDataByUrl.yomiMetaData.YomiArtist,res_yomiMetadata.YomiArtist)) == 0);

    //Edit Album field alone
    strncpy_r(OUT editMetaDataByUrl.yomiMetaData.YomiAlbum, IN "YomiAlbumAloneEditedbyURL", IN sizeof(editMetaDataByUrl.yomiMetaData.YomiAlbum));
    res = mMediaPlayerInterface.EditMetaData(editMetaDataByUrl);
    CPPUNIT_ASSERT(res == 0);
    sleep(1);
    res = LocalSPM::GetDBManager().GetYomiMetadata(MediaObjectTag, res_yomiMetadata);
    CPPUNIT_ASSERT((strcmp(editMetaDataByUrl.yomiMetaData.YomiAlbum,res_yomiMetadata.YomiAlbum)) == 0);


}
void MediaPlayerInterfaceTest::VideoasAudio3gpTest()
{
    ENTRY

    ETG_TRACE_USR2(("%s", __PRETTY_FUNCTION__));

    tResult res = MP_NO_ERROR;
    tDeviceID deviceID;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;
    tListID listID;
    tListSize listSize,listSizeRet;
    tStreaming streaming = false;
    vector<tFiles> mediaFileVector;
    tUInt i = 0;


    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    GMPTEST_EXPECT(res == 0);
    ETG_TRACE_USR4(("deviceID  %d", deviceID));

    LocalSPM::GetDataProvider ().InformVideoFileAsAudio = 1;

    res = mMediaPlayerInterface.ActiveMediaDeviceSet(IN deviceID, IN true);
    GMPTEST_EXPECT(res == 0);
    ASYNC_WAIT_START(1);

    tDeviceInfo deviceInfo;
    res = mMediaPlayerInterface.ActiveMediaDeviceGet(deviceInfo);
    GMPTEST_EXPECT(res == 0);
    GMPTEST_EXPECT(!strcmp(deviceInfo.deviceName, "USB"));
    GMPTEST_EXPECT(deviceInfo.deviceID == deviceID);

    strncpy_r(OUT path, IN "/video/", IN sizeof(path));
    res = mMediaPlayerInterface.CreateMediaPlayerFileList(
                OUT listID,
                OUT listSize,
                OUT numberOfMediaObjects,
                OUT numberOfPlayLists,
                OUT numberOfFolders,
                IN path,
                IN deviceID,
                IN FTS_VIDEO);
    ETG_TRACE_USR4(("VideoasAudio3gpTest listID %d ,  listSize  %d , numberOfMediaObjects %d", listID, listSize, numberOfMediaObjects));

    res= mMediaPlayerInterface.RequestMediaPlayerFileListSlice(OUT mediaFileVector, IN listID, 0, 50);
    ETG_TRACE_USR4(("mediaFileVector size  %d", mediaFileVector.size()));
    GMPTEST_EXPECT(res == 0);

    for(i=0;i<mediaFileVector.size();i++)
    {
        ETG_TRACE_USR4(("mediaFileVector[%d].fileName  %s", i, mediaFileVector[i].fileName));
        if(0 == strncmp(mediaFileVector[i].fileName,"3GP_MPEG4_MPEG4.3gp",strlen_r(mediaFileVector[i].fileName)))
        {
            break;
        }
    }

    res = mMediaPlayerInterface.PlayItemFromList(OUT listSizeRet, IN listID, IN i, IN 0);
    GMPTEST_EXPECT(res == 0);

    tNowPlaying nowPlaying;
    res = LocalSPM::GetPlayerManager().GetNowPlaying(nowPlaying);

    LocalSPM::GetDataProvider ().InformVideoFileAsAudio = 0;

    ETG_TRACE_USR4(("nowPlaying fileName  %s",nowPlaying.object.fileName));
    ETG_TRACE_USR4(("nowPlaying mediaType  %d",nowPlaying.object.mediaType));
    ETG_TRACE_USR4(("nowPlaying position  %d",nowPlaying.position));

}
