#include "IpcClient.h"
#include "stdlib.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_FRAMEWORK
#ifdef TARGET_BUILD
#include "trcGenProj/Header/IpcClient.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_FRAMEWORK
#endif
#endif

#include "TraceDefinitions.h"
#include "FunctionTracer.h"
bool IpcClient::append_arg(DBusMessageIter *iter, int type, const char *value , DbusParamList ParamList)
{
    bool Result=true;
    dbus_uint16_t uint16;
    dbus_int16_t int16;
    dbus_uint32_t uint32;
    dbus_int32_t int32;
    dbus_uint64_t uint64;
    dbus_int64_t int64;
    double d;
    unsigned char byte;
    dbus_bool_t v_BOOLEAN;

    /* FIXME - we are ignoring OOM returns on all these functions */
    switch (type)
    {
        case DBUS_TYPE_BYTE:
            byte = strtoul (value, NULL, 0);
            dbus_message_iter_append_basic (iter, DBUS_TYPE_BYTE, &byte);
            break;
        case DBUS_TYPE_DOUBLE:
            d = strtod (value, NULL);
            dbus_message_iter_append_basic (iter, DBUS_TYPE_DOUBLE, &d);
            break;
        case DBUS_TYPE_INT16:
            int16 = strtol (value, NULL, 0);
            dbus_message_iter_append_basic (iter, DBUS_TYPE_INT16, &int16);
            break;

        case DBUS_TYPE_UINT16:
            uint16 = strtoul (value, NULL, 0);
            dbus_message_iter_append_basic (iter, DBUS_TYPE_UINT16, &uint16);
            break;

        case DBUS_TYPE_INT32:
            int32 = strtol (value, NULL, 0);
            dbus_message_iter_append_basic (iter, DBUS_TYPE_INT32, &int32);
            break;

        case DBUS_TYPE_UINT32:
            uint32 = strtoul (value, NULL, 0);
            dbus_message_iter_append_basic (iter, DBUS_TYPE_UINT32, &uint32);
            break;

        case DBUS_TYPE_INT64:
            int64 = strtoll (value, NULL, 0);
            dbus_message_iter_append_basic (iter, DBUS_TYPE_INT64, &int64);
            break;

        case DBUS_TYPE_UINT64:
            uint64 = strtoull (value, NULL, 0);
            dbus_message_iter_append_basic (iter, DBUS_TYPE_UINT64, &uint64);
            break;

        case DBUS_TYPE_STRING:
            dbus_message_iter_append_basic (iter, DBUS_TYPE_STRING, &value);
            break;

        case DBUS_TYPE_OBJECT_PATH:
            dbus_message_iter_append_basic (iter, DBUS_TYPE_OBJECT_PATH, &value);
            break;

        case DBUS_TYPE_BOOLEAN:

            if (strcmp (value, "true") == 0)
            {
                v_BOOLEAN = TRUE;
                dbus_message_iter_append_basic (iter, DBUS_TYPE_BOOLEAN, &v_BOOLEAN);
            }
            else if (strcmp (value, "false") == 0)
            {
                v_BOOLEAN = FALSE;
                dbus_message_iter_append_basic (iter, DBUS_TYPE_BOOLEAN, &v_BOOLEAN);
            }
            else
            {
                ETG_TRACE_USR1(("The value: %s is not a valid boolean value",value));
            }
            break;
        case DBUS_TYPE_VARIANT:
            for (DbusParamList::iterator ii = ParamList.begin(); ii != ParamList.end(); ++ii)
            {
                int returnval;
                returnval = append_variant(iter,(*ii).type,(void*)(*ii).value.c_str());
                //ETG_TRACE_USR4(("returnval :%d",returnval));
            };
            break;

        default:
            ETG_TRACE_USR1(("The type is NOT implemented"));
            Result = false;
            break;
    }
    return Result;
}

int IpcClient::append_variant(DBusMessageIter *iter, char type, void *val)
{
    DBusMessageIter value;
    DbusParamList ParamList;
    char sig[2] = { type, '\0' };
    if(dbus_message_iter_open_container(iter, DBUS_TYPE_VARIANT, sig, &value))
    {
        //if(dbus_message_iter_append_basic(&value, type, val)) /*appending directly with dbus api is commented to append arg genericly.*/
        if(append_arg(&value, type, (const char*)val,ParamList))
        {
            if(dbus_message_iter_close_container(iter, &value))
            {
                return true;
            }
        }
    }
    return false;
}

int IpcClient::dict_append_entry(DBusMessageIter *dict, const char *key, int type, void *val)
{
    DBusMessageIter entry;
    if (type == DBUS_TYPE_STRING)
    {
        const char *str = *((const char **) val);
        if (str == NULL)
        {
            return false;
        }
    }
    if(dbus_message_iter_open_container(dict, DBUS_TYPE_DICT_ENTRY, NULL, &entry))
    {
        if(dbus_message_iter_append_basic(&entry, DBUS_TYPE_STRING, &key))
        {
            if(append_variant(&entry, type, val))
            {
                if(dbus_message_iter_close_container(dict, &entry))
                {
                    return true;
                }
            }
        }
    }
    return false;
}

IpcClient::IpcClient()
{
    mMessage = NULL;
    memset(&mMessageIter, 0, sizeof(mMessageIter));
    mPath.clear();
}

IpcClient::~IpcClient()
{
}

void IpcClient::OverridePath(const char* interface,const char* path)
{
    Locker locker(&mPathLock); //let's make public access to members thread-safe - GMMY17-14251
    mPath[interface] = path;
}

int IpcClient::InitMethodCallNoOverride(const IpcMessageInfo &messageInfo)
{
    mMessage = dbus_message_new_method_call( messageInfo.destination,
            messageInfo.object_path,
            messageInfo.interface_name,
            messageInfo.message_name);
    ETG_TRACE_USR1(("create a message : %128s , %128s , %128s , %s",messageInfo.destination,messageInfo.object_path,messageInfo.interface_name,messageInfo.message_name));
    if (NULL == mMessage)
    {
        ETG_TRACE_ERR(("Dbus message creation is failed"));
        return -1;
    }
    dbus_message_iter_init_append(mMessage, &mMessageIter);
    return 0;
}
int IpcClient::InitMethodCall( const IpcMessageInfo &messageInfo)
{
    std::map<string,string>::iterator iter;

    Locker locker(&mPathLock); //GMMY17-14251
    iter = mPath.find(messageInfo.interface_name);
    if((mPath.end() != iter) && (iter->second.size() != 0)) // override path with dynamic path set for given interface
    {
        mMessage = dbus_message_new_method_call( messageInfo.destination,
                iter->second.c_str(),
                messageInfo.interface_name,
                messageInfo.message_name);
        ETG_TRACE_USR1(("create a message : %128s , %128s , %128s , %s",messageInfo.destination,iter->second.c_str(),messageInfo.interface_name,messageInfo.message_name));
    }
    else	// use the default path for the interface as packed in messageInfo
    {
        mMessage = dbus_message_new_method_call( messageInfo.destination,
                messageInfo.object_path,
                messageInfo.interface_name,
                messageInfo.message_name);
        ETG_TRACE_USR1(("create a message : %128s , %128s , %128s , %s",messageInfo.destination,messageInfo.object_path,messageInfo.interface_name,messageInfo.message_name));
    }

    if (NULL == mMessage)
    {
        ETG_TRACE_ERR(("Dbus message creation is failed"));
        return -1;
    }


    dbus_message_iter_init_append(mMessage, &mMessageIter);

    return 0;
}

int IpcClient::AppendMessage(void *param) const
{
    (void)param;
    ETG_TRACE_ERR(( "Failed to append message with parameter of unknown/not supported type "));
    return 0;
}

int IpcClient::AppendMessage(int param)
{
    if (!dbus_message_iter_append_basic( &mMessageIter,
            DBUS_TYPE_INT32,
            &param))
    {
        ETG_TRACE_ERR(( "Failed to append message"));
        return 0;
    }
    return 1;
}

int IpcClient::AppendMessage(bool param)
{
    dbus_bool_t value = param;
    if (!dbus_message_iter_append_basic( &mMessageIter,
            DBUS_TYPE_BOOLEAN,
            &value))
    {
        ETG_TRACE_ERR(( "Failed to append message DBUS_TYPE_BOOLEAN"));
        return 0;
    }
    return 1;
}

int IpcClient::AppendMessage(unsigned int param)
{
    if (!dbus_message_iter_append_basic( &mMessageIter,
            DBUS_TYPE_UINT32,
            &param))
    {
        ETG_TRACE_ERR(( "Failed to append message type DBUS_TYPE_UINT32"));
        return 0;
    }

    return 1;
}

int IpcClient::AppendMessage(const char *param)
{
    if (!dbus_message_iter_append_basic( &mMessageIter,
            DBUS_TYPE_STRING,
            &param))
    {
        ETG_TRACE_ERR(( "Failed to append message DBUS_TYPE_STRING"));
        return 0;
    }
    return 1;
}

int IpcClient::AppendMessage(unsigned char param)
{
    if (!dbus_message_iter_append_basic( &mMessageIter,
            DBUS_TYPE_BYTE ,
            &param))
    {
        ETG_TRACE_ERR(( "Failed to append message type DBUS_TYPE_BYTE "));
        return 0;
    }

    return 1;
}
int IpcClient::AppendMessage(signed short param)
{
    if (!dbus_message_iter_append_basic( &mMessageIter,
            DBUS_TYPE_INT16 ,
            &param))
    {
        ETG_TRACE_ERR(( "Failed to append message type DBUS_TYPE_INT16 "));
        return 0;
    }

    return 1;
}

int IpcClient::AppendMessage(const unsigned char array[])
{
    if((array != NULL) && (array[0] > 0))
    {
        unsigned int arraySize = array[0];
        const unsigned char *arrayOfBytes= &array[1];

        if (!dbus_message_append_args ( mMessage,
                DBUS_TYPE_ARRAY, DBUS_TYPE_BYTE,  //array of bytes
                &arrayOfBytes,
                arraySize,
                DBUS_TYPE_INVALID))
        {
            ETG_TRACE_ERR(( "Failed to append message DBUS_TYPE_ARRAY of DBUS_TYPE_BYTE"));
            return 0;
        }
    }
    else
    {
        ETG_TRACE_ERR(( "IpcClient::AppendMessage(const char array[]) -> array with size 0"));
    }
    return 1;
}

int IpcClient::AppendMessage(const dbus_uint32_t array[])
{
    if(array != NULL)
    {
        unsigned int arraySize = array[0];
        const dbus_uint32_t *arrayOfBytes= &array[1];

        if (!dbus_message_append_args ( mMessage,
                DBUS_TYPE_ARRAY, DBUS_TYPE_UINT32,  //array of dbus_uint32_t
                &arrayOfBytes,
                arraySize,
                DBUS_TYPE_INVALID))
        {
            ETG_TRACE_ERR(( "Failed to append message DBUS_TYPE_ARRAY of DBUS_TYPE_BYTE"));
            return 0;
        }
    }
    else
    {
        ETG_TRACE_ERR(( "IpcClient::AppendMessage(const char array[]) -> array with size 0"));
    }
    return 1;
}

int IpcClient::AppendMessage(list<string> &param)
{

    ETG_TRACE_USR1(("IpcClient::AppendMessage  param"));
    if(param.size()==3)
    {
        DBusMessageIter subIter;
        char *value,*value1,*value2;
        list<string>::iterator it = param.begin();
        value=strdup((*it).c_str());

        if(value)
        {
            it++;
            value1=strdup((*it).c_str());

            if(value1)
            {
                it++;
                value2=strdup((*it).c_str());

                if(value2)
                {
                    dbus_message_iter_append_basic (&mMessageIter, DBUS_TYPE_STRING, &value);
                    dbus_message_iter_append_basic (&mMessageIter, DBUS_TYPE_STRING, &value1);
                    dbus_message_iter_open_container(&mMessageIter, DBUS_TYPE_VARIANT, DBUS_TYPE_STRING_AS_STRING, &subIter);
                    dbus_message_iter_append_basic(&subIter, DBUS_TYPE_STRING, &value2);
                    dbus_message_iter_close_container(&mMessageIter, &subIter);
                    free(value2);
                    free(value1);
                    free(value);
                    return true;
                }
                free(value1);
            }
            free(value);
        }

    }

    return false;
}

int IpcClient::AppendMessage(map<string, unsigned int> param)
{
    //if (param.size() > 0) //If no parameters are available, following code sends an empty array over DBus - Required for GetImage request whose default is no filter.
    {
        DBusMessageIter dict;
        if (dbus_message_iter_open_container(&mMessageIter, DBUS_TYPE_ARRAY,
                DBUS_DICT_ENTRY_BEGIN_CHAR_AS_STRING
                DBUS_TYPE_STRING_AS_STRING DBUS_TYPE_VARIANT_AS_STRING
                DBUS_DICT_ENTRY_END_CHAR_AS_STRING, &dict))
        {

            for (map<string, unsigned int>::iterator ii = param.begin(); ii != param.end(); ++ii)
            {
                stringstream ss;
                ss << ii->second;
                string StringValue = ss.str();

                if (!dict_append_entry(&dict, (*ii).first.c_str(), DBUS_TYPE_UINT32, (void *)(StringValue.c_str())))
                {
                    return false;
                }
            }
            if (!dbus_message_iter_close_container(&mMessageIter, &dict))
            {
                return false;
            }

            return true;
        }
        return false;
    }
    return false;
}

int IpcClient::AppendMessage(string param)
{
    const char *value = param.c_str();
    if (!dbus_message_iter_append_basic(&mMessageIter, DBUS_TYPE_OBJECT_PATH, &value))
    {
        ETG_TRACE_ERR(( "Failed to append message DBUS_TYPE_OBJECT_PATH"));
        return 0;
    }
    return true;
}

int IpcClient::SendMethodCall(void)
{
    dbus_bool_t ret = 0;
    dbus_uint32_t serial = 0;

    if(mMessage)
    {

#ifdef TARGET_BUILD
        /*communicate over system bus to bt-daemon*/
        if (mSystemBusConnection && (!strcmp(dbus_message_get_destination(mMessage),"com.alps.bt")))
        {
            ret = dbus_connection_send(mSystemBusConnection , mMessage, &serial);
        }
        /*communicate over session bus*/
        else
#endif
            if (mSystemBusConnection && (!strcmp(dbus_message_get_destination(mMessage),"org.bluez")))
            {
                ret = dbus_connection_send(mSystemBusConnection , mMessage, &serial);
            }
#if 1
        //com.bosch.MediaAgentService is listening on separate session bus with address 'unix:path=/tmp/shared/iddbus/lxcdbus'
            else if(mCustomSessionBusConnection && (!strcmp(dbus_message_get_destination(mMessage),"com.bosch.MediaAgentService")))
            {
                ETG_TRACE_USR1(("SendMethodCall through mCustomSessionBusConnection "));
                ret = dbus_connection_send(mCustomSessionBusConnection, mMessage, &serial);
            }

#endif
            else if(mSessionBusConnection)/*communicate over session bus*/
            {
                ETG_TRACE_USR1(("SendMethodCall dbus_message_get_destination mSessionBusConnection"));
                ret = dbus_connection_send(mSessionBusConnection, mMessage, &serial);
            }
        ETG_TRACE_USR1(( "SendMethodCall serial:%d,method name:%s",serial,dbus_message_get_member(mMessage)));
        dbus_message_unref(mMessage);
    }



    if (!ret) {
        ETG_TRACE_ERR(( "SendMethodCall mSessionBusConnection=%p",mSessionBusConnection));
    }

    return ret ? serial : -1;
}

void IpcClient::SendMethodCallWaitForReply(bool isSystemBus,int reply_timeout,bool& isError,string& params,bool isByteArrayNeeded)
{
    ENTRY
    ETG_TRACE_USR4(( " entered IpcClient::SendMethodCallWaitForReply"));
    DBusMessage *reply=NULL;
    DBusError error;
    DBusMessageIter iter;
    dbus_error_init (&error);
    if(mMessage)
    {
        if(isSystemBus)
        {
            reply = dbus_connection_send_with_reply_and_block (mSystemBusConnection, mMessage, reply_timeout,&error);
        }
        else
        {
            const char* dbusMMessage = dbus_message_get_destination(mMessage);
            ETG_TRACE_USR1(("create a message : %s",dbusMMessage));
            if(mCustomSessionBusConnection && (!strcmp(dbus_message_get_destination(mMessage),"com.bosch.MediaAgentService")))
            {
                ETG_TRACE_USR1(("SendMethodCallWaitForReply:Inside custom Bus"));
                reply = dbus_connection_send_with_reply_and_block (mCustomSessionBusConnection, mMessage, reply_timeout,&error);
            }
            else
            {
            reply = dbus_connection_send_with_reply_and_block (mSessionBusConnection, mMessage, reply_timeout,&error);
            }
        }
        if (dbus_error_is_set (&error))
        {
            ETG_TRACE_ERR(( "Not able to send the message %s",error.message));
            ETG_TRACE_ERR(( "Not able to send the message %s",error.name));
            isError=true;
            return ;
        }
        if(reply)
        {
            if(!isByteArrayNeeded)
            {
                if(dbus_message_iter_init (reply, &iter))
                {
                    ParseMessage_iter(&iter, params);
                }
                dbus_message_unref(reply);
            }
            else
                ParseMessageWithByteArray(reply,params);
        }

        dbus_message_unref(mMessage);
    }
    else
    {
        ETG_TRACE_ERR(( "mMessage is empty"));
    }
    return ;
}
