

#include "TraceDefinitions.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_FUNCTION_TRACE
#ifdef TARGET_BUILD
#include "trcGenProj/Header/FunctionTracer.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_FUNCTION_TRACE
#endif
#endif

#include <iostream>
#include "FunctionTracer.h"

#define PREFIX "$FT$"

FunctionTracer::FunctionTracer(tClassTypeFunc cls, const char *name )
{
    mbIsEntryOfTestFunction = false;

    mName = name;
    mTraceLevel = USER_3;
    mCls = cls;
    if (true == etg_bIsTraceActive(TR_CLASS_GEN_MEDIAPLAYER_FUNCTION_TRACE_ALL, TR_LEVEL_USER_3))
    {
        ETG_TRACE_USR3(("" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
    }
    else
    {
        ETG_TRACE_USR3_DCL ((mCls, "" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
    }
};

FunctionTracer::FunctionTracer(tClassTypeFunc cls, const char *name , int traceLevel)
{
    mbIsEntryOfTestFunction = false;

    mName = name;
    mTraceLevel = traceLevel;
    mCls = cls;
    if (true == etg_bIsTraceActive(TR_CLASS_GEN_MEDIAPLAYER_FUNCTION_TRACE_ALL, traceLevel))
    {
        switch(mTraceLevel)
        {
            case USER_1:
                ETG_TRACE_USR1(("" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
                break;
            case USER_2:
                ETG_TRACE_USR2(("" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
                break;
            case USER_3:
                ETG_TRACE_USR3(("" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
                break;
            case USER_4:
                ETG_TRACE_USR4(("" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
                break;
            case COMPONENT:
                ETG_TRACE_COMP(("" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
                break;
            case SYSTEM:
                ETG_TRACE_SYS(("" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
                break;
            default:
                break;
        }
    }
    else
    {
        switch(mTraceLevel)
        {
            case USER_1:
                ETG_TRACE_USR1_DCL ((mCls,"" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
                break;
            case USER_2:
                ETG_TRACE_USR2_DCL ((mCls,"" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
                break;
            case USER_3:
                ETG_TRACE_USR3_DCL ((mCls,"" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
                break;
            case USER_4:
                ETG_TRACE_USR4_DCL ((mCls,"" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
                break;
            case COMPONENT:
                ETG_TRACE_COMP_DCL ((mCls,"" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
                break;
            case SYSTEM:
                ETG_TRACE_SYS_DCL ((mCls,"" PREFIX "entry:%d:%s",(int)pthread_self(),mName));
                break;
            default:
                break;
        }
    }
};

FunctionTracer::FunctionTracer(tClassTypeFunc cls, const char *name,bool bIsEntryOfTestFunction )
{
    mbIsEntryOfTestFunction = bIsEntryOfTestFunction;


    mName = name;
    mTraceLevel = USER_3;
    mCls = cls;
    if(mbIsEntryOfTestFunction)
    {
        if (true == etg_bIsTraceActive(TR_CLASS_GEN_MEDIAPLAYER_FUNCTION_TRACE_ALL, TR_LEVEL_USER_3))
        {
            ETG_TRACE_USR1(("=> BEGIN TEST++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++=>"));
            ETG_TRACE_USR3((" TEST:entry:%p:%s",pthread_self(),mName));
            ETG_TRACE_USR1(("          ***Start %s***",mName));
            ETG_TRACE_USR1(("================================================================================================================="));
        }
        else
        {
            ETG_TRACE_USR1(("=> BEGIN TEST++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++=>"));
            ETG_TRACE_USR3_DCL ((mCls, " TEST:entry:%p:%s",pthread_self(),mName));
            ETG_TRACE_USR1(("          ***Start %s***",mName));
            ETG_TRACE_USR1(("================================================================================================================="));

        }
    }
};


FunctionTracer::~FunctionTracer()
{
    if(!mbIsEntryOfTestFunction)
    {
        if (true == etg_bIsTraceActive(TR_CLASS_GEN_MEDIAPLAYER_FUNCTION_TRACE_ALL, mTraceLevel))
        {
            switch(mTraceLevel)
            {
                case USER_1:
                    ETG_TRACE_USR1(("" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
                    break;
                case USER_2:
                    ETG_TRACE_USR2(("" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
                    break;
                case USER_3:
                    ETG_TRACE_USR3(("" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
                    break;
                case USER_4:
                    ETG_TRACE_USR4(("" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
                    break;
                case COMPONENT:
                    ETG_TRACE_COMP(("" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
                    break;
                case SYSTEM:
                    ETG_TRACE_SYS(("" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
                    break;
                default:
                    break;
            }
        }
        else
        {
            switch(mTraceLevel)
            {
                case USER_1:
                    ETG_TRACE_USR1_DCL ((mCls,"" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
                    break;
                case USER_2:
                    ETG_TRACE_USR2_DCL ((mCls,"" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
                    break;
                case USER_3:
                    ETG_TRACE_USR3_DCL ((mCls,"" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
                    break;
                case USER_4:
                    ETG_TRACE_USR4_DCL ((mCls,"" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
                    break;
                case COMPONENT:
                    ETG_TRACE_COMP_DCL ((mCls,"" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
                    break;
                case SYSTEM:
                    ETG_TRACE_SYS_DCL ((mCls,"" PREFIX "exit:%d:%s",(int)pthread_self(),mName));
                    break;
                default:
                    break;
            }
        }
    }
    //----------------
    //Used for TEST
    //----------------
    else
    {
        if (true == etg_bIsTraceActive(TR_CLASS_GEN_MEDIAPLAYER_FUNCTION_TRACE_ALL, mTraceLevel))
        {
            switch(mTraceLevel)
            {
                case USER_1:
                    ETG_TRACE_USR1((" TEST exit:%d:%s",(int)pthread_self(),mName));
                    ETG_TRACE_USR1(("<= END TEST+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++<"));
                    break;
                case USER_2:
                    ETG_TRACE_USR2((" TEST exit:%d:%s",(int)pthread_self(),mName));
                    ETG_TRACE_USR1(("<= END TEST+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++<"));
                    break;
                case USER_3:
                    ETG_TRACE_USR3((" TEST exit:%d:%s",(int)pthread_self(),mName));
                    ETG_TRACE_USR1(("<= END TEST+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++<"));
                    break;
                case USER_4:
                    ETG_TRACE_USR4((" TEST exit:%d:%s",(int)pthread_self(),mName));
                    ETG_TRACE_USR1(("<= END TEST+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++<"));
                    break;
                case COMPONENT:
                    ETG_TRACE_COMP((" TEST exit:%d:%s",(int)pthread_self(),mName));
                    ETG_TRACE_USR1(("<= END TEST+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++<"));
                    break;
                case SYSTEM:
                    ETG_TRACE_SYS((" TEST exit:%d:%s",(int)pthread_self(),mName));
                    ETG_TRACE_USR1(("<= END TEST+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++<"));

                    break;
                default:
                    break;
            }
        }
        else
        {
            switch(mTraceLevel)
            {
                case USER_1:
                    ETG_TRACE_USR1_DCL ((mCls,"" PREFIX " TEST exit:%d:%s",(int)pthread_self(),mName));
                    ETG_TRACE_USR1(("" PREFIX "<= END TEST+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++<"));
                    break;
                case USER_2:
                    ETG_TRACE_USR2_DCL ((mCls,"" PREFIX " TEST exit:%d:%s",(int)pthread_self(),mName));
                    ETG_TRACE_USR1(("" PREFIX "<= END TEST+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++<"));
                    break;
                case USER_3:
                    ETG_TRACE_USR3_DCL ((mCls,"" PREFIX " TEST exit:%d:%s",(int)pthread_self(),mName));
                    ETG_TRACE_USR1(("" PREFIX "<= END TEST+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++<"));
                    break;
                case USER_4:
                    ETG_TRACE_USR4_DCL ((mCls,"" PREFIX " TEST exit:%d:%s",(int)pthread_self(),mName));
                    ETG_TRACE_USR1(("" PREFIX "<= END TEST+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++<"));
                    break;
                case COMPONENT:
                    ETG_TRACE_COMP_DCL ((mCls,"" PREFIX " TEST exit:%d:%s",(int)pthread_self(),mName));
                    ETG_TRACE_USR1(("" PREFIX "<= END TEST+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++<"));

                    break;
                case SYSTEM:
                    ETG_TRACE_SYS_DCL ((mCls,"" PREFIX " TEST exit:%d:%s",(int)pthread_self(),mName));
                    ETG_TRACE_USR1(("" PREFIX "<= END TEST+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++<"));
                    break;
                default:
                    break;
            }
        }

    }


};
