/**
 * @defgroup Trace Trace
 * @ingroup Mediaplayer
 * @authors Dinesh
 *
 * Utility to trace the current time and time taken by any critical code sections
 * @{
 */

#ifndef TIMETRACE_H_
#define TIMETRACE_H_

#include <time.h>
#include <sys/time.h>

/*
 * Class Timertrace
 */
class TimeTrace
{
public:

    TimeTrace(const char *name);
    TimeTrace(void);

    void begin();
    void elapsed();
    void restart();

    static void now();

private:

    void time_difference(timeval* start , timeval* end ,timeval* difference);

    const char *mName;
    timeval mStartTime;
};

#endif /* TIMERTRACE_H_ */

/** @} */
