
/**
 * @addtogroup Ipc
 * @author Dinesh D
 *
 * Datatypes for IPC communication
 *  
 * @{
 */
 
#ifndef _IPCTYPES_H_
#define _IPCTYPES_H_


/**
 * Defines for Ipc services
 */
#define MEDIAPLAYER_SERVICE     "de.bosch.mediaplayer"
#define MEDIAPLAYER_PATH        "/MediaPlayer"
#define MEDIAPLAYER_INTERFACE   "local.MediaPlayer"

/** 
 * Type to hold Message information
 */
typedef struct sIpcMessageInfo{
    const char *destination;		/**< Dbus service name */
    const char *object_path;		/**< Dbus service Path */
    const char *interface_name;		/**< Dbus service interface name */
    const char *message_name;		/**< Dbus member name , e.g signal or method name */
} IpcMessageInfo;

/** 
 * Macro which defines Dbus call 
 */
#define IPC_DECLARE_MESSAGE(address, component, object_path, interface_name, name) \
const IpcMessageInfo address = { \
        component, \
        object_path, \
        interface_name, \
        name \
};


#endif /*_IPCTYPES_H_*/
/** @} */
