#ifndef _USBCONTROLTEST_H_
#define _USBCONTROLTEST_H_

#include <cppunit/extensions/HelperMacros.h>

#include "ConfigTest.h"
#include "TypeDefinitions.h"
#include "TimeTrace.h"

class USBControlTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( USBControlTest );
    CPPUNIT_TEST( InitIPC );
    CPPUNIT_TEST( SwitchObserver );
    CPPUNIT_TEST( AllocateAudioInput );
    CPPUNIT_TEST( StartStreaming );
    CPPUNIT_TEST( PlayAudio );
    CPPUNIT_TEST( Pause );
    CPPUNIT_TEST( SeekTo );
    CPPUNIT_TEST( Resume );
    CPPUNIT_TEST( FrevStartStop );
    CPPUNIT_TEST( FfwdStartStop );
#ifdef TARGET_BUILD //Playing of umlauts does not work in Ubuntu
    CPPUNIT_TEST( PlayWithUmlauts );
#endif
    CPPUNIT_TEST( Buffer );
    CPPUNIT_TEST( PlayVideo ); //
    CPPUNIT_TEST( ExtractVideoTags );
    CPPUNIT_TEST( ExtractAudioTags_ID3V1);
    CPPUNIT_TEST( CheckDRMProtection);
    CPPUNIT_TEST( ExtractImageTags );
    CPPUNIT_TEST( GetMediaType );

    CPPUNIT_TEST( InitDeviceConnection );
    //CPPUNIT_TEST( GetFingerprint ); //now useful since we changed interface from meassageAnswer to simple event in DeviceControl.zargo
    CPPUNIT_TEST( GetMetadata );
#ifdef TARGET_BUILD
    CPPUNIT_TEST( GetAlbumArt ); //currently disabled due to  reset in ubuntu 64 bit.
#endif
    CPPUNIT_TEST( Umount );
    //CPPUNIT_TEST (ScanFilesForFingerprintCalc);
    CPPUNIT_TEST (ValidatetmpfileForFingerprintCalc);
    //CPPUNIT_TEST (ValidateMountPointForFingerprintCalc);
    CPPUNIT_TEST (ValidateFileExtensionForFingerprintCalc);
    CPPUNIT_TEST (ValidateFileFilterForFingerprintCalc);
    CPPUNIT_TEST (ValidateExecuteCommandForDFandMD5SUM);
    CPPUNIT_TEST( RemoveDeviceConnection );
    CPPUNIT_TEST( Stop );
    CPPUNIT_TEST_SUITE_END();

public:

    USBControlTest(){};

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();

    /*test cases*/
    void InitIPC();
    void AllocateAudioInput();
    void SwitchObserver();
    void StartStreaming();
    void PlayAudio();
    void PlayWithUmlauts();
    void PlayVideo();
    void Buffer();
    void Pause();
    void Stop();
    void Resume();
    void SeekTo();
    void FfwdStartStop();
    void FrevStartStop();
    void InitDeviceConnection();
    void RemoveDeviceConnection();
    void GetFingerprint();
    void GetMetadata();
    void GetAlbumArt();
    void Umount();

    void ExtractVideoTags();
    void ExtractAudioTags_ID3V1();
    void CheckDRMProtection();
    void ExtractImageTags();
    void GetMediaType();
    //void ScanFilesForFingerprintCalc();
    void ValidatetmpfileForFingerprintCalc();
    //void ValidateMountPointForFingerprintCalc();
    void ValidateFileExtensionForFingerprintCalc();
    void ValidateFileFilterForFingerprintCalc();
    void ValidateExecuteCommandForDFandMD5SUM();
private:
    void GetAlbumArt(tAlbumArt albumArt, tMimeType expectedMimeType, tImageSize expectedImageSize, tBool artAvailable, char* imageFileName);
    void Play(const tURL URL, const tObjectID objectID, const tPlaytime position);
    tResult ReadOneVideoMetaData(IN FILE *fpInput, IN char *tmpFileName, const char *format, ...);

    TimeTrace ticks;        /**< time object to trace the time taken by testcases */
};

#endif  // _USBCONTROLTEST_H_
