#ifndef _RIPPERCONTROLTEST_H_
#define _RIPPERCONTROLTEST_H_

#include <cppunit/extensions/HelperMacros.h>

#include "ConfigTest.h"
#include "TypeDefinitions.h"
#include "TimeTrace.h"

class RipperControlTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( RipperControlTest );

#ifdef USE_TESTS_WITH_REAL_DVDDRIVE	
    CPPUNIT_TEST( SetAutoRipping );
    CPPUNIT_TEST( StartDiscRipping );
    CPPUNIT_TEST( CreateMusicBoxFileList );
    CPPUNIT_TEST( InterruptRippingByEject );
    CPPUNIT_TEST( RestartRippingByUser );
    CPPUNIT_TEST( ClearRippedContent );
    CPPUNIT_TEST( CreateMusicBoxRecYearList );
#endif

#if 0
    CPPUNIT_TEST( CalculateHashID );
    CPPUNIT_TEST( CheckFreeSpace );
    CPPUNIT_TEST( PathToRipFile );
    CPPUNIT_TEST( StopRippingEvent );
    CPPUNIT_TEST( UpdateMetadata );
#endif


#ifdef USE_TESTS_WITH_REAL_DVDDRIVE
    CPPUNIT_TEST( RipAudio );
    CPPUNIT_TEST( StopRip );
    CPPUNIT_TEST( PlayRipAudio );
#endif

    CPPUNIT_TEST( CheckAutoRippingMode );
    CPPUNIT_TEST( IsRippedTrackExistsInFlash );
    CPPUNIT_TEST( RestartRipping );
    CPPUNIT_TEST( GetUsedMemoryOnFlash );
    CPPUNIT_TEST( RippingStatus );
    CPPUNIT_TEST( CheckRippingEncodingQuality );
    CPPUNIT_TEST( CheckMusicBoxFileAvailability );
    CPPUNIT_TEST( GetRippedFilePath );

    CPPUNIT_TEST_SUITE_END();

public:

    RipperControlTest(){};

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();

    /*test cases*/


private:

    TimeTrace ticks;        /**< time object to trace the time taken by testcases */
    void StartDiscRipping();
    void CalculateHashID();
    void CheckFreeSpace();
    void PathToRipFile();
    void StopRippingEvent();
    void UpdateMetadata();
    void InterruptRippingByEject();
    void CreateMusicBoxFileList();
    void CreateMusicBoxRecYearList();
    void SetAutoRipping();
    void RestartRippingByUser();
    void ClearRippedContent();
    void RipAudio();
    void StopRip();
    void PlayRipAudio();

    void CheckAutoRippingMode();
    void IsRippedTrackExistsInFlash();
    void RestartRipping();
    void GetUsedMemoryOnFlash();
    void RippingStatus();
    void CheckRippingEncodingQuality();
    void GetRippedFilePath();
    void CheckMusicBoxFileAvailability();


};

#endif  // _RIPPERCONTROLTEST_H_
