#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/MTPControlUnitTestStubbed.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include "MTPControl.h"    ///@todo check header inclusion
#include "FunctionTracer.h"
#include "PlayerEngineIpcIF.h"
#include "LocalSPM.h"
#include "CppUnitDefinitions.h"
#include "Dispatcher.h"
#include "RequestResponseSM.h"

#include "MTPControlUnitTestStubbed.h"
#include <dirent.h>
#include <fstream>

/*--------------------------------------------------------------------------------------------------------
 *  defines
 *--------------------------------------------------------------------------------------------------------*/
#define LENOFPATHFILE 1024
#define FIRSTDEVICE      0
#define FIRSTSONG        0
#define URET_NOERROR     0
/*--------------------------------------------------------------------------------------------------------
 *  static elements
 *--------------------------------------------------------------------------------------------------------*/
bool MTPControlUnitTestStubbed::m_bPrintTestInfo = true;

/**********************************************************************
 * Fixture
 *********************************************************************/
void MTPControlUnitTestStubbed::setUp()  //@todo think about using setUp and tearDown busszword 'fixture'
{
    m_ticks.begin();
    PrintTestInfo();
    clearDevices();
    AddTestDevices();

    MTPControlUnitTestStubbed::m_bPrintTestInfo = false;
    m_ret = MP_NO_ERROR;
}

void MTPControlUnitTestStubbed::tearDown()
{
    m_ticks.elapsed();
}

/**********************************************************************
 * helper
 *********************************************************************/
void MTPControlUnitTestStubbed::PrintTestInfo()
{
	if(m_bPrintTestInfo)
	{
	    ETG_TRACE_USR4(("-> --------MTPControlUnitTestStubbed-----------"));
	}
}

   /*to test mocked MTPLibAdapter*/
void MTPControlUnitTestStubbed::AddTestDevices()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

	tURL URLDev1,URLDev2;
    char *pwd = get_current_dir_name();

    if(pwd)
    {
#ifndef TARGET_BUILD
		strncpy_r(URLDev1, pwd, sizeof(URLDev1));
		strncpy_r(URLDev2, pwd, sizeof(URLDev2));
		strncat_r(URLDev1, "/Customer/Simulation/CustomControl/stick_2/Supertramp/Breakfast_In_America", sizeof(URLDev1)); //@todo shift to define
		strncat_r(URLDev2, "/Customer/Simulation/CustomControl/stick_2/Unheilig/Grosse_Freiheit", sizeof(URLDev2));
#else
		strncpy_r(URLDev1, "/opt/bosch/test/data/GMP/stick_2/Supertramp/Breakfast_In_America", sizeof(URLDev1)); //@todo shift to define
		strncpy_r(URLDev2, "/opt/bosch/test/data/GMP/stick_2/Unheilig/Grosse_Freiheit", sizeof(URLDev2));
#endif

		m_MTPLibWrapperTest.AddTestDevice(URLDev1);
		m_MTPLibWrapperTest.AddTestDevice(URLDev2);

		if(m_bPrintTestInfo)
		{
			ETG_TRACE_USR4(("AddTestDevice: m_MTPLibWrapperTest.m_deviceIndex=0 , device:%s",URLDev1));
			ETG_TRACE_USR4(("AddTestDevice: m_MTPLibWrapperTest.m_deviceIndex=1 , device:%s",URLDev2));
		}

		free(pwd);
    }
    else
    {
    	ETG_TRACE_FATAL(("AddTestDevices(): ERROR with get_current_dir_name()"));
    }

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}

void MTPControlUnitTestStubbed::clearDevices()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));
    //AddTestDevices has started before
    m_MTPLibWrapperTest.clearDevices();

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}


bool MTPControlUnitTestStubbed::fileExists(char *cPathFile)
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

	bool ret = false;
	std::fstream fs;
    fs.open (cPathFile, std::fstream::in);
	if (fs.is_open())
	{
		ret = true;
        fs.close();
	}

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));

    return ret;
}

/**********************************************************************
 * Test cases
 *********************************************************************/

void MTPControlUnitTestStubbed::LIBMTP_Get_Connected_Devices()
{
	  ENTRY_INTERNAL
	  ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));
	  LIBMTP_error_number_t  ret;
	  LIBMTP_mtpdevice_t    *device_list; //is pointer to device

	  ret = m_MTPLibWrapperTest.wLIBMTP_Get_Connected_Devices(&device_list); //is pointer to pointer to device
	  CPPUNIT_ASSERT(LIBMTP_ERROR_NONE == ret);

	  ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

void MTPControlUnitTestStubbed::LIBMTP_Get_Connected_Devices_checkDevPointer()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	tUInt i;
	LIBMTP_error_number_t  ret;
	LIBMTP_mtpdevice_t    *device_list, *pDevice; //is pointer to device

	ret = m_MTPLibWrapperTest.wLIBMTP_Get_Connected_Devices(&device_list); //is pointer to pointer to device
	ETG_TRACE_USR4(("wLIBMTP_Get_Connected_Devices() returned %d", ret));

	i = 0;
	for(pDevice = device_list; pDevice != NULL; pDevice = pDevice->next)
	{
	  CPPUNIT_ASSERT(pDevice == &(m_MTPLibWrapperTest.m_deviceList[i].device));
	  i++;
	}

	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

void MTPControlUnitTestStubbed::LIBMTP_Get_Connected_Devices_m_deviceIndex()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	LIBMTP_error_number_t  ret;
	LIBMTP_mtpdevice_t    *device_list, *pDevice; //is pointer to device

	ret = m_MTPLibWrapperTest.wLIBMTP_Get_Connected_Devices(&device_list); //is pointer to pointer to device
	ETG_TRACE_USR4(("wLIBMTP_Get_Connected_Devices() returned %d", ret));

	tUInt i = 0;
	for(pDevice = device_list; pDevice != NULL; pDevice = pDevice->next)
	{
	  CPPUNIT_ASSERT((int)i  <=   m_MTPLibWrapperTest.m_deviceIndex);
	  i++;
	}
	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

void MTPControlUnitTestStubbed::LIBMTP_Get_Modelname()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	char *pName;
	char expectedName[LENOFSTRING];
	LIBMTP_error_number_t  ret;
    LIBMTP_mtpdevice_t    *device_list, *pDevice; //is pointer to device
	ret = m_MTPLibWrapperTest.wLIBMTP_Get_Connected_Devices(&device_list);
	ETG_TRACE_USR4(("wLIBMTP_Get_Connected_Devices() returned %d", ret));

	tUInt iDeviceIndex = 0;
	for(pDevice = device_list; pDevice != NULL; pDevice = pDevice->next)
	{
	    pName = m_MTPLibWrapperTest.wLIBMTP_Get_Modelname(IN pDevice);

	    snprintf(expectedName,LENOFSTRING,"%d_%s",iDeviceIndex,(char*)"devicename");//modelname is used as devicename
		CPPUNIT_ASSERT(0 == strcmp(pName,expectedName));                            //that's why in the test stub 'devicename' instead of 'friendlyname' is used
		iDeviceIndex++;
	}

	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}
void MTPControlUnitTestStubbed::LIBMTP_Get_Friendlyname()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	char *pName;
	char expectedName[LENOFSTRING];
	LIBMTP_error_number_t  ret;
	LIBMTP_mtpdevice_t    *device_list, *pDevice; //is pointer to device
	ret = m_MTPLibWrapperTest.wLIBMTP_Get_Connected_Devices(&device_list);
	ETG_TRACE_USR4(("wLIBMTP_Get_Connected_Devices() returned %d", ret));

	tUInt iDeviceIndex = 0;
	for(pDevice = device_list; pDevice != NULL; pDevice = pDevice->next)
	{
		pName = m_MTPLibWrapperTest.wLIBMTP_Get_Friendlyname(IN pDevice);

	    snprintf(expectedName,LENOFSTRING,"%d_%s",iDeviceIndex,(char*)"devicename");  //friendlyname is used as devicename
		CPPUNIT_ASSERT(0 == strcmp(pName,expectedName));                              //that's why in the test stub 'devicename' instead of 'friendlyname' is used
		iDeviceIndex++;
	}

	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}
void MTPControlUnitTestStubbed::LIBMTP_Get_Serialnumber()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	char *pName;
	char expectedName[LENOFSTRING];
	LIBMTP_error_number_t  ret;
	LIBMTP_mtpdevice_t    *device_list, *pDevice; //is pointer to device
	ret = m_MTPLibWrapperTest.wLIBMTP_Get_Connected_Devices(&device_list);
	ETG_TRACE_USR4(("wLIBMTP_Get_Connected_Devices() returned %d", ret));

	tUInt iDeviceIndex = 0;
	for(pDevice = device_list; pDevice != NULL; pDevice = pDevice->next)
	{
		pName = m_MTPLibWrapperTest.wLIBMTP_Get_Serialnumber(IN pDevice);

	    snprintf(expectedName,LENOFSTRING,"%d_%s",iDeviceIndex,(char*)"serialnumber");
		CPPUNIT_ASSERT(0 == strcmp(pName,expectedName));
		iDeviceIndex++;
	}

	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}
void MTPControlUnitTestStubbed::LIBMTP_Get_Deviceversion()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	char *pName;
	char expectedName[LENOFSTRING];
	LIBMTP_error_number_t  ret;
	LIBMTP_mtpdevice_t    *device_list, *pDevice; //is pointer to deviceS
	ret = m_MTPLibWrapperTest.wLIBMTP_Get_Connected_Devices(&device_list);   ///@todo check to put it to fixture or helperfunction
	ETG_TRACE_USR4(("wLIBMTP_Get_Connected_Devices() returned %d", ret));

	tUInt iDeviceIndex = 0;
	for(pDevice = device_list; pDevice != NULL; pDevice = pDevice->next)
	{
		pName = m_MTPLibWrapperTest.wLIBMTP_Get_Deviceversion(IN pDevice);
	    snprintf(expectedName,LENOFSTRING,"%d_%s",iDeviceIndex,(char*)"deviceversion");
		CPPUNIT_ASSERT(0 == strcmp(pName,expectedName));
		iDeviceIndex++;
	}

	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}
void MTPControlUnitTestStubbed::LIBMTP_Get_Manufacturername() ///@todo LIBMTP_Get_Deviceversion etc. look similar check to save codelines
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	char *pName;
	char expectedName[LENOFSTRING];
	LIBMTP_error_number_t  ret;
	LIBMTP_mtpdevice_t    *device_list, *pDevice; //is pointer to device
	ret = m_MTPLibWrapperTest.wLIBMTP_Get_Connected_Devices(&device_list);
	ETG_TRACE_USR4(("wLIBMTP_Get_Connected_Devices() returned %d", ret));

	tUInt iDeviceIndex = 0;
	for(pDevice = device_list; pDevice != NULL; pDevice = pDevice->next)
	{
		pName = m_MTPLibWrapperTest.wLIBMTP_Get_Manufacturername(IN pDevice);
	    snprintf(expectedName,LENOFSTRING,"%d_%s",iDeviceIndex,(char*)"manufacturer");
		CPPUNIT_ASSERT(0 == strcmp(pName,expectedName));
		iDeviceIndex++;
	}

	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}


void MTPControlUnitTestStubbed::LIBMTP_Get_Trackmetadata()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	char *pNameExpected;
	tUInt uiTrackId;
	LIBMTP_track_t        *pTrack;
	LIBMTP_error_number_t  ret;
	LIBMTP_mtpdevice_t    *device_list, *pDevice; //is pointer to device
	ret = m_MTPLibWrapperTest.wLIBMTP_Get_Connected_Devices(&device_list);
	ETG_TRACE_USR4(("wLIBMTP_Get_Connected_Devices() returned %d", ret));

	tUInt iDeviceIndex = 0;

	for(pDevice = device_list; pDevice != NULL; pDevice = pDevice->next)
	{
		uiTrackId     = 0;

		do
		{
			//ETG_TRACE_FATAL(("Test:LIBMTP_Get_Trackmetadata: uiTrackId=%d",uiTrackId));
		    pTrack = m_MTPLibWrapperTest.wLIBMTP_Get_Trackmetadata(IN pDevice, IN uiTrackId); //check to put into while condition
		    if(NULL == pTrack)
		    {
		       ETG_TRACE_USR4(("Test:LIBMTP_Get_Trackmetadata:NULL == pTrack"))
		    }
		    else
		    {
		    	pNameExpected = m_MTPLibWrapperTest.m_deviceList[iDeviceIndex].songList[uiTrackId].trackInfo.filename;
				CPPUNIT_ASSERT(0 == strcmp(pTrack->filename,pNameExpected));
				ETG_TRACE_USR4(("Test:LIBMTP_Get_Trackmetadata: %s",pTrack->filename));
				uiTrackId++;
		    }

		}
		while(pTrack!=NULL);
		iDeviceIndex++;
		ETG_TRACE_USR4(("Test:LIBMTP_Get_Trackmetadata: iDeviceIndex=%d",iDeviceIndex));
	}


	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

void MTPControlUnitTestStubbed::LIBMTP_Get_Trackmetadata_numOfSongs()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	tUInt uiTrackId;
	LIBMTP_track_t        *pTrack;
	LIBMTP_error_number_t  ret;
	LIBMTP_mtpdevice_t    *device_list, *pDevice; //is pointer to device
	ret = m_MTPLibWrapperTest.wLIBMTP_Get_Connected_Devices(&device_list);
	ETG_TRACE_USR4(("wLIBMTP_Get_Connected_Devices() returned %d", ret));

	tUInt iDeviceIndex = 0;

	for(pDevice = device_list; pDevice != NULL; pDevice = pDevice->next)
	{
		uiTrackId     = 0;
		do
		{
		    pTrack = m_MTPLibWrapperTest.wLIBMTP_Get_Trackmetadata(IN pDevice, IN uiTrackId); //check to put into while condition
		    if(NULL == pTrack)
		    {
		    	break;
		    }
		    uiTrackId++;
		}
		while(pTrack!=NULL);

		CPPUNIT_ASSERT(m_MTPLibWrapperTest.m_deviceList[iDeviceIndex].numOfSongs == uiTrackId);
		iDeviceIndex++;
	}

	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}


void MTPControlUnitTestStubbed::LIBMTP_Get_Tracklisting_Track_With_Callback()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	LIBMTP_track_t* pTrack;
	uint32_t curTrackIndex;
	LIBMTP_mtpdevice_t    *device_list, *pDevice; //is pointer to device

	m_MTPLibWrapperTest.wLIBMTP_Get_Connected_Devices(&device_list);

	int iDeviceIndex = 0;
	for(pDevice = device_list; pDevice != NULL; pDevice = pDevice->next)
	{
		do
		{
			pTrack = m_MTPLibWrapperTest.wLIBMTP_Get_Tracklisting_Track_With_Callback(pDevice, NULL /*callback*/, NULL, &curTrackIndex); ///@todo check if necessary to simulate callback

			{
				break;
			}
		}
		while(pTrack!=NULL);
        ETG_TRACE_USR4(("MTPControlUnitTestStubbed::LIBMTP_Get_Tracklisting_Track_With_Callback:iDeviceIndex:%d numOfSongs:%d",
        		         iDeviceIndex,
        		         m_MTPLibWrapperTest.m_deviceList[iDeviceIndex].numOfSongs));

		CPPUNIT_ASSERT(m_MTPLibWrapperTest.m_deviceList[iDeviceIndex].numOfSongs == curTrackIndex);
		iDeviceIndex++;
	}


	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));

}

void MTPControlUnitTestStubbed::LIBMTP_Get_Track_To_File()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	uint32_t trackID                 = (uint32_t) FIRSTSONG;
	LIBMTP_mtpdevice_t *pDevice = &(m_MTPLibWrapperTest.m_deviceList[FIRSTDEVICE].device);

	char cPathFile[LENOFPATHFILE];
	snprintf(cPathFile,LENOFPATHFILE,"%s/%s",LOCAL_MTPFILE_PATH_TARGET,LOCAL_MTPFILE_BIN);

	m_MTPLibWrapperTest.wLIBMTP_Get_Track_To_File (pDevice, trackID, cPathFile, NULL /*callback*/, NULL /*data*/);

	CPPUNIT_ASSERT(fileExists(cPathFile) == true); //<--object of tested

	int ret = remove(cPathFile);
	CPPUNIT_ASSERT(ret == 0); //<---this has to work  - remove is a os-function and should work hence think about takeing off this line

	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

//in DeviceControl.zargo - DeviceControlStateMachineDiagramm States and Transition events are drawn
//these are basis for tests below


void MTPControlUnitTestStubbed::matchDevice2MountPointTest()  ///@todo think about renaming this function in to matchDevice2DeviceInfo
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

    tDeviceInfo oDevInfo;
    LIBMTP_mtpdevice_t *pDeviceFound, *pDeviceExpected;

    ETG_TRACE_USR4(("Begin:MTPControlUnitTestStubbed::matchDevice2MountPoint"));

    pDeviceExpected = &(m_MTPLibWrapperTest.m_deviceList[FIRSTDEVICE].device);

    char *strFriendlyname  = m_MTPLibWrapperTest.m_deviceList[FIRSTDEVICE].cFriendlyname;
    //char *strModelname     = m_MTPLibWrapperTest.m_deviceList[FIRSTDEVICE].cModelname;
    char *strSerialnumber  = m_MTPLibWrapperTest.m_deviceList[FIRSTDEVICE].cSerialnumber;
    char *strDeviceversion = m_MTPLibWrapperTest.m_deviceList[FIRSTDEVICE].cDeviceversion;

    snprintf (oDevInfo.deviceName,    sizeof (oDevInfo.deviceName),   "%s",strFriendlyname);
    snprintf (oDevInfo.serialNumber,  sizeof (oDevInfo.serialNumber), "%s",strSerialnumber);
    snprintf (oDevInfo.deviceVersion, sizeof (oDevInfo.deviceVersion),"%s",strDeviceversion);

    ETG_TRACE_USR4(("MTPControlUnitTestStubbed::matchDevice2MountPoint:oDevInfo.deviceName   :%s",oDevInfo.deviceName));
    ETG_TRACE_USR4(("MTPControlUnitTestStubbed::matchDevice2MountPoint:oDevInfo.serialNumber :%s",oDevInfo.serialNumber));
    ETG_TRACE_USR4(("MTPControlUnitTestStubbed::matchDevice2MountPoint:oDevInfo.deviceVersion:%s",oDevInfo.deviceVersion));

    pDeviceFound = m_MTPLibWrapperTest.matchDevice2MountPoint(IN oDevInfo.serialNumber,IN oDevInfo.deviceVersion, IN oDevInfo.deviceName);
    CPPUNIT_ASSERT (pDeviceFound == pDeviceExpected);

    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}


void MTPControlUnitTestStubbed::fillMediaObject()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

    //tResult ret  = MP_NO_ERROR;
    tUInt   uret = URET_NOERROR;

    tDeviceID      deviceID;
    LIBMTP_track_t track;

    char cGenre[LENOFSTRING];
    char cArtist[LENOFSTRING];
    char cAlbum[LENOFSTRING];
    char cTitle[LENOFSTRING];
    char cComposer[LENOFSTRING];
    char cFilename[LENOFSTRING];

    tMountPoint     mountPoint;
    tMediaObjectPtr mediaObjectPtr = NULL;
    mediaObjectPtr = new tMediaObject; //Attention: Has to be deleted by Indexer::CheckMetadata; //care for this ///@todo check if we could use reference

    InitMediaObject(OUT *mediaObjectPtr); //check where to find this function

    //give pointer memory
    track.genre    = cGenre;
    track.artist   = cArtist;
    track.album    = cAlbum;
    track.title    = cTitle;
    track.composer = cComposer;
    track.filename = cFilename;

    //set input parameters
    snprintf(track.genre,   LENOFSTRING,"genre");
    snprintf(track.artist,  LENOFSTRING,"artist");
    snprintf(track.album,   LENOFSTRING,"album");
    snprintf(track.title,   LENOFSTRING,"title");
    snprintf(track.composer,LENOFSTRING,"composer");
    snprintf(track.composer,LENOFSTRING,"filename");

    track.filetype    = LIBMTP_FILETYPE_MP3;
    track.duration    = 0xBEEF;
    track.tracknumber = 0xD00F;

    deviceID = 0xAFFE;

    //Note: m_cMountPoint = m_cDeviceName+"/"+m_cDeviceVersion+"/"+m_cSerialID+"/"
    snprintf(mountPoint,sizeof(mountPoint),(char*)"deviceName/deviceVersion/serialNumber/");
    /*ret = */MTPControl::fillMediaObject(OUT mediaObjectPtr, IN &track, IN mountPoint, IN deviceID, NULL); ///@todo add error case

    if(0xAFFE    != mediaObjectPtr->deviceID)      {uret++;}
    if(0xD00F    != mediaObjectPtr->trackNumber)   {uret++;}
    if(0xBEEF    != mediaObjectPtr->totalPlaytime) {uret++;}
    if(FT_AUDIO  != mediaObjectPtr->fileType)      {uret++;}

    uret += strcmp("genre",    mediaObjectPtr->MetadataField1);
    uret += strcmp("artist",   mediaObjectPtr->MetadataField2);
    uret += strcmp("album",    mediaObjectPtr->MetadataField4);
    uret += strcmp("title",    mediaObjectPtr->title);

    uret += strcmp("filename", mediaObjectPtr->fileName);
    uret += strcmp("composer", mediaObjectPtr->MetadataField3);

    uret += strcmp(mountPoint, mediaObjectPtr->mountPoint);

    CPPUNIT_ASSERT(URET_NOERROR == uret);

    delete mediaObjectPtr;

    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

void MTPControlUnitTestStubbed::factoryGetLibMTPWrapper()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    if(0 == gMTPConnected) //expect faked MTPDevice
    {
        if(NULL == m_pMTPLibWrapper)
        {
    	    m_pMTPLibWrapper = new MTPLibWrapperTest();
    	    m_eTypeOfWrapper = eMTPWrapper_stubLib;

    	    ///@todo add try catch here or FATAL_ASSERT_ALWAYS or work with reference
        }
        else
        {
        	ETG_TRACE_FATAL(("factoryGetLibMTPWrapper: has been created already"));
        }
    }
    else
    {
    	ETG_TRACE_FATAL(("factoryGetLibMTPWrapper: thought for CCAMediaplayer with real usage of libMTP and connected device"));
    }
}



