/*
 * MTPControlTestRealDevice.cpp
 *
 *  Created on: Aug 6, 2013
 *      Author: tritonsu
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/MTPControlTestRealDevice.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include "MTPControl.h"
#include "FunctionTracer.h"
#include "PlayerEngineIpcIF.h"
#include "LocalSPM.h"
#include "CppUnitDefinitions.h"
#include "Dispatcher.h"
#include "RequestResponseSM.h"

#include "MTPControlTestRealDevice.h"
#include "MTPControlCommon.h"

#include "src/libmtp.h"   // use mediaplayer specific libmtp



/**********************************************************************
 * Fixture
 *********************************************************************/
void MTPControlTestRealDevice::setUp()  //@todo think about using setUp and tearDown busszword 'fixture'    //will be called before each CPPUNITTestfunction
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

	m_ticks.begin();

	ETG_TRACE_USR4(("MTPControlTestRealDevice::setUp: check if real MTP devices are connected "));
	m_bRealDeviceConnected = false;
	m_pTestResultMsgQ      = NULL;

	m_totalSize   = 0;
	m_freeSize    = 0;

	//set up Q connection to MTP-Control to receive results which are not send to test
	m_pTestResultMsgQ = TestIF_createTestResultMsgQ();
	if(NULL == m_pTestResultMsgQ)
	{
		ETG_TRACE_FATAL(("NULL == m_pTestResultMsgQ"));
	}
	LocalSPM::GetMTPControl().TestIF_setTestResultMsgQ(IN m_pTestResultMsgQ);


	//@todo: if this takes to long for each test then do it just once
	m_bRealDeviceConnected = false;
	util_getConnectedMTPDevice(OUT m_bRealDeviceConnected,
								IN m_strModelname,
								IN m_strFriendlyname,
								IN m_strSerialnumber,
								IN m_strDeviceversion,
								IN m_strManufacturername);

	ETG_TRACE_USR4(("MTPControlTestRealDevice::util_getConnectedMTPDevice: m_strModelname        : %s",m_strModelname));
	ETG_TRACE_USR4(("MTPControlTestRealDevice::util_getConnectedMTPDevice: m_strFriendlyname     : %s",m_strFriendlyname));
	ETG_TRACE_USR4(("MTPControlTestRealDevice::util_getConnectedMTPDevice: m_strSerialnumber     : %s",m_strSerialnumber));
	ETG_TRACE_USR4(("MTPControlTestRealDevice::util_getConnectedMTPDevice: m_strDeviceversion    : %s",m_strDeviceversion));
	ETG_TRACE_USR4(("MTPControlTestRealDevice::util_getConnectedMTPDevice: m_strManufacturername : %s",m_strManufacturername));


	if(true == m_bRealDeviceConnected)
	{
		ETG_TRACE_USR4(("************************************************"));
		ETG_TRACE_USR4(("MTPControlTestRealDevice:: FOUND REAL MTP DEVICE"));
		ETG_TRACE_USR4(("************************************************"));
		//-----------------------------------------------------
		//care that real MTPLib is used
		//-----------------------------------------------------
		LocalSPM::GetMTPControl().TestIF_setWrapper(eMTPWrapper_realLib);

		//----------------------------------------------------------------------------
		//recreate DB and fill detected device since a real device has been detected
		//----------------------------------------------------------------------------
		util_recreateDB();
		util_InsertNewMTPDevicetoDB(m_strSerialnumber, m_strDeviceversion, m_strFriendlyname, EMPTY_STRING,m_totalSize, m_freeSize);
		util_showdevicesDB();

		//-----------------------------------------------------------------------
		//delete tmp-files on target  i.e. last uploaded MTP-File plus info file
		//-----------------------------------------------------------------------
		util_deleteTmpFile(LOCAL_MTPFILE_PATH_TARGET,LOCAL_MTPFILE_INFO);
		util_deleteTmpFile(LOCAL_MTPFILE_PATH_TARGET,LOCAL_MTPFILE_BIN);

		//----------------------------------------
		//init IPC to player engine
		//----------------------------------------
		util_InitIPC();

		//----------------------------------------
		//further steps to prepare a play
		//----------------------------------------
		util_SwitchObserver();
		util_AllocateAudioInput();
		//StartStreaming();

		//-----------------------------------------
		//simulate connecting device
		//-----------------------------------------
		snprintf(m_mountPoint , sizeof (m_mountPoint ),"%s/%s/%s/",m_strFriendlyname,m_strDeviceversion,m_strSerialnumber);
		util_InitDeviceConnection(OUT m_deviceID,IN m_mountPoint);
		sleep(3); ///@todo add mechanism to get real feedback from MTPControl
	}

	ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}

void MTPControlTestRealDevice::tearDown()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

	/*
	  to warranty for other test modules that system is in the same condition like it was before the tests
	  and to follow the philosophy that all tests might be executed in different order
    */

	//-----------------------------------------------------
	//care that stub MTPLib is used for stubbed test
	//-----------------------------------------------------
	LocalSPM::GetMTPControl().TestIF_setWrapper(eMTPWrapper_stubLib);
	m_bRealDeviceConnected = false;

	//-----------------------------------------------------
	//delete test q
	//-----------------------------------------------------
	LocalSPM::GetMTPControl().TestIF_setTestResultMsgQ(NULL);
	TestIF_deleteTestResultMsgQ(IN m_pTestResultMsgQ);
	m_pTestResultMsgQ      = NULL;

	//-----------------------------------------------------
	//renew database of 'connected' devices
	//-----------------------------------------------------
	util_recreateDB();

	//-----------------------------------------------------------------------
	//delete tmp-files on target  i.e. last uploaded MTP-File plus info file
	//-----------------------------------------------------------------------
	util_deleteTmpFile(LOCAL_MTPFILE_PATH_TARGET,LOCAL_MTPFILE_INFO);
	util_deleteTmpFile(LOCAL_MTPFILE_PATH_TARGET,LOCAL_MTPFILE_BIN);

    m_ticks.elapsed();

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}


/******************************************************************************************************
 *
 *   combined functionalities
 *
 ******************************************************************************************************/

void MTPControlTestRealDevice::Fingerprint()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	MTPControlTestSM objMyRRSM;
	tResult             ret = MP_NO_ERROR;

	if(m_bRealDeviceConnected)
    {
		ETG_TRACE_USR4(("MTPControlTestRealDevice::Fingerprint: REALDEVICECONNECTED_YES "));
		//---------------------------------------------
		//get fingerprint
		//---------------------------------------------
		/* Send GET_FINGERPRINT message to MTPControlSM */
		strncpy(m_lastFingerprint, "size123_files10_hash1234567890", sizeof(m_lastFingerprint)-1);

		strncpy(m_messageString, "MTPControlSM::GET_FINGERPRINT", sizeof(m_messageString)-1);

		ret = LocalSPM::GetMTPControl().ParameterGET_FINGERPRINT(OUT m_parameterString,
															   IN sizeof(m_parameterString),
															   IN m_mountPoint,
															   IN m_deviceID,
															   IN m_lastFingerprint);

		CPPUNIT_ASSERT(MP_NO_ERROR == ret);


		ret = objMyRRSM.DoEventAnswer(IN m_messageString, IN m_parameterString); ///@todo  this is used as a delay because function called in   ///@clarify
		CPPUNIT_ASSERT(MP_NO_ERROR == ret);

		//-----------------------------------------
		//receive result via testQ from MTPControl
		//-----------------------------------------
		tSearchString fingerprint;
	    TestIF_waitForAnswer(IN NULL,OUT fingerprint);//receive ok
		ETG_TRACE_USR4(("%s",fingerprint));

    }
	else
	{
		ETG_TRACE_USR4(("MTPControlTestRealDevice::Fingerprint: REALDEVICECONNECTED_NO "));
	}

	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

void MTPControlTestRealDevice::RetrieveMetadata()
{
	ENTRY_INTERNAL
    ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	if(m_bRealDeviceConnected)
	{
		ETG_TRACE_USR4(("MTPControlTestRealDevice::RetrieveMetadata: REALDEVICECONNECTED_YES "));
		//-------------------------
		// GET METADATA
		//-------------------------
		util_getmetadata(IN m_deviceID, IN m_mountPoint,IN INVALID_READPOS); //note: read position is currently ignored in receiving function

		//-----------------------------------------
		//receive result via testQ from MTPControl
		//-----------------------------------------
		tSearchString url;
		TestIF_waitForAnswer(IN NULL,OUT url);//receive url
	    ETG_TRACE_USR3(("MTPControlTestRealDevice::RetrieveMetadata:url: %s\n",url));

		TestIF_waitForAnswer(STRING_TRESULT_OK);//receive ok

		int numOfMatchingString;
		TestIF_waitForAnswerAlternative(OUT numOfMatchingString,IN STRING_MDS_SUCCESS,IN STRING_MDS_FINISHED);
	}
	else
	{
		ETG_TRACE_USR4(("MTPControlTestRealDevice::RetrieveMetadata: REALDEVICECONNECTED_NO "));
	}

	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}
void MTPControlTestRealDevice::PlaySong()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	if(m_bRealDeviceConnected)
	{
	     ETG_TRACE_USR4(("MTPControlTestRealDevice::PlaySong: REALDEVICECONNECTED_YES "));
		//-------------------------
		// GET METADATA
		//-------------------------
		util_getmetadata(IN m_deviceID, IN m_mountPoint,IN INVALID_READPOS); //note: read position is currently ignored in receiving function

		//------------------------------------------------
		//receive resulting URL via testQ from MTPControl
		//------------------------------------------------
		tSearchString url;
		TestIF_waitForAnswer(NULL,url);//receive url
		ETG_TRACE_USR3(("MTPControlTestRealDevice::RetrieveMetadata:url: %s\n",url));
		TestIF_waitForAnswer(STRING_TRESULT_OK);

		int numOfMatchingString;
		TestIF_waitForAnswerAlternative(OUT numOfMatchingString,IN STRING_MDS_SUCCESS,IN STRING_MDS_FINISHED);

		//--------------------------
		//Play song
		//--------------------------
		util_play(IN m_deviceID, IN m_mountPoint, IN url);

		//-----------------------------------------
		//receive result via testQ from MTPControl
		//-----------------------------------------
		TestIF_waitForAnswer(STRING_TRESULT_OK);//receive ok

		sleep(5); //play for 5 seconds
		util_stop(IN m_deviceID, IN m_mountPoint, IN url); //care that it stops
		sleep(2);

	}
	else
	{
		ETG_TRACE_USR4(("MTPControlTestRealDevice::PlaySong: REALDEVICECONNECTED_NO "));
	}

	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

void MTPControlTestRealDevice::RetrieveMetadataAll()
{
	ENTRY_INTERNAL
    ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	tBool bGetNextMetadata = true;
	int count = 0;
	if(m_bRealDeviceConnected)
	{
		while(bGetNextMetadata)
		{
			ETG_TRACE_USR4(("MTPControlTestRealDevice::RetrieveMetadataAll: REALDEVICECONNECTED_YES "));
			//-------------------------
			// GET METADATA
			//-------------------------
			util_getmetadata(IN m_deviceID, IN m_mountPoint,IN INVALID_READPOS); //note: read position is currently ignored in receiving function

			//-----------------------------------------
			//receive result via testQ from MTPControl
			//-----------------------------------------
			tSearchString url;
			TestIF_waitForAnswer(IN NULL,OUT url);//receive url
			ETG_TRACE_USR3(("MTPControlTestRealDevice::RetrieveMetadataAll:url: %s\n",url));
			TestIF_waitForAnswer(STRING_TRESULT_OK);//receive ok

			int numOfMatchingString;
			TestIF_waitForAnswerAlternative(OUT numOfMatchingString,IN STRING_MDS_SUCCESS,IN STRING_MDS_FINISHED);
			if(2 == numOfMatchingString)
			{
				bGetNextMetadata = false;
			}
			else
			{
				count++;
				ETG_TRACE_USR4(("MTPControlTestRealDevice::RetrieveMetadataAll: Tracks found:%d",count));
			}
		}
	}
	else
	{
		ETG_TRACE_USR4(("MTPControlTestRealDevice::RetrieveMetadataAll: REALDEVICECONNECTED_NO "));
	}

	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}


void MTPControlTestRealDevice::FingerPrintAndRetrieveMetadataAll()
{
	ENTRY_INTERNAL
    ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	MTPControlTestSM objMyRRSM;
    tResult             ret = MP_NO_ERROR;

	tBool bGetNextMetadata = true;
	int count = 0;

	if(m_bRealDeviceConnected)
	{

		ETG_TRACE_USR4(("MTPControlTestRealDevice::Fingerprint: REALDEVICECONNECTED_YES "));
		//---------------------------------------------
		//get fingerprint
		//---------------------------------------------
		/* Send GET_FINGERPRINT message to MTPControlSM */
		strncpy(m_lastFingerprint, "size123_files10_hash1234567890", sizeof(m_lastFingerprint)-1);

		strncpy(m_messageString, "MTPControlSM::GET_FINGERPRINT", sizeof(m_messageString)-1);

		ret = LocalSPM::GetMTPControl().ParameterGET_FINGERPRINT(OUT m_parameterString,
															   IN sizeof(m_parameterString),
															   IN m_mountPoint,
															   IN m_deviceID,
															   IN m_lastFingerprint);

		CPPUNIT_ASSERT(MP_NO_ERROR == ret);


		ret = objMyRRSM.DoEventAnswer(IN m_messageString, IN m_parameterString); ///@todo  this is used as a delay because function called in   ///@clarify
		CPPUNIT_ASSERT(MP_NO_ERROR == ret);

		//-----------------------------------------
		//receive result via testQ from MTPControl
		//-----------------------------------------
		tSearchString fingerprint;
		TestIF_waitForAnswer(IN NULL,OUT fingerprint);//receive ok
		ETG_TRACE_USR4(("%s",fingerprint));

		//-------------------------------------------
		//get metadata now
		//-------------------------------------------
		while(bGetNextMetadata)
		{
			ETG_TRACE_USR4(("MTPControlTestRealDevice::FingerPrintAndRetrieveMetadataAll: REALDEVICECONNECTED_YES "));
			//-------------------------
			// GET METADATA
			//-------------------------
			util_getmetadata(IN m_deviceID, IN m_mountPoint,IN INVALID_READPOS); //note: read position is currently ignored in receiving function

			//-----------------------------------------
			//receive result via testQ from MTPControl
			//-----------------------------------------
			tSearchString url;
			TestIF_waitForAnswer(IN NULL,OUT url);//receive url
			ETG_TRACE_USR3(("MTPControlTestRealDevice::RetrieveMetadataAll:url: %s\n",url));
			TestIF_waitForAnswer(STRING_TRESULT_OK);//receive ok

			int numOfMatchingString;
			TestIF_waitForAnswerAlternative(OUT numOfMatchingString,IN STRING_MDS_SUCCESS,IN STRING_MDS_FINISHED);
			if(2 == numOfMatchingString)
			{
				bGetNextMetadata = false;
			}
			else
			{
				count++;
				ETG_TRACE_USR4(("MTPControlTestRealDevice::RetrieveMetadataAll: Tracks found:%d",count));
			}
		}
	}
	else
	{
		ETG_TRACE_USR4(("MTPControlTestRealDevice::RetrieveMetadataAll: REALDEVICECONNECTED_NO "));
	}

	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}


void MTPControlTestRealDevice::FingerPrintAndRetrieveMetadataSingleTrack()
{
	ENTRY_INTERNAL
    ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	MTPControlTestSM objMyRRSM;
	tResult             ret = MP_NO_ERROR;


	if(m_bRealDeviceConnected)
	{
		ETG_TRACE_USR4(("MTPControlTestRealDevice::FingerPrintAndRetrieveMetadataSingleTrack: REALDEVICECONNECTED_YES "));

		ETG_TRACE_USR4(("MTPControlTestRealDevice::Fingerprint: REALDEVICECONNECTED_YES "));
		//---------------------------------------------
		//get fingerprint
		//---------------------------------------------
		/* Send GET_FINGERPRINT message to MTPControlSM */
		strncpy(m_lastFingerprint, "size123_files10_hash1234567890", sizeof(m_lastFingerprint)-1);

		strncpy(m_messageString, "MTPControlSM::GET_FINGERPRINT", sizeof(m_messageString)-1);

		ret = LocalSPM::GetMTPControl().ParameterGET_FINGERPRINT(OUT m_parameterString,
															   IN sizeof(m_parameterString),
															   IN m_mountPoint,
															   IN m_deviceID,
															   IN m_lastFingerprint);

		CPPUNIT_ASSERT(MP_NO_ERROR == ret);


		ret = objMyRRSM.DoEventAnswer(IN m_messageString, IN m_parameterString); ///@todo  this is used as a delay because function called in   ///@clarify
		CPPUNIT_ASSERT(MP_NO_ERROR == ret);

		//-----------------------------------------
		//receive result via testQ from MTPControl
		//-----------------------------------------
		tSearchString fingerprint;
		TestIF_waitForAnswer(IN NULL,OUT fingerprint);//receive ok
		ETG_TRACE_USR4(("%s",fingerprint));

		//-------------------------
		// GET METADATA
		//-------------------------
		util_getmetadata(IN m_deviceID, IN m_mountPoint,IN INVALID_READPOS); //note: read position is currently ignored in receiving function

		//-----------------------------------------
		//receive result via testQ from MTPControl
		//-----------------------------------------
		tSearchString url;
		TestIF_waitForAnswer(IN NULL,OUT url);//receive url
	    ETG_TRACE_USR3(("MTPControlTestRealDevice::FingerPrintAndRetrieveMetadataSingleTrack:url: %s\n",url));

		TestIF_waitForAnswer(STRING_TRESULT_OK);//receive ok

		int numOfMatchingString;
		TestIF_waitForAnswerAlternative(OUT numOfMatchingString,IN STRING_MDS_SUCCESS,IN STRING_MDS_FINISHED);
	}
	else
	{
		ETG_TRACE_USR4(("MTPControlTestRealDevice::FingerPrintAndRetrieveMetadataSingleTrack: REALDEVICECONNECTED_NO "));
	}

	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}


void MTPControlTestRealDevice::ReadRootFolder(void)
{
    ENTRY_INTERNAL
    ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

    MTPControlTestSM objMyRRSM;
    tResult ret = MP_NO_ERROR;
    tBool bGetNextItem = true;

    if(m_bRealDeviceConnected)
    {
        ETG_TRACE_USR4(("MTPControlTestRealDevice::ReadRootFolder: REALDEVICECONNECTED_YES "));

        char root[] = "/";
        int index = 0;

        strncpy(m_messageString, "MTPControlSM::MTP_GET_FOLDER_ITEM", sizeof(m_messageString)-1);

        while (bGetNextItem)
        {

            ret = LocalSPM::GetMTPControl().ParameterMTP_GET_FOLDER_ITEM(OUT m_parameterString,
                                                                   IN sizeof(m_parameterString),
                                                                   IN m_mountPoint,
                                                                   IN root,
                                                                   IN index);

            CPPUNIT_ASSERT(MP_NO_ERROR == ret);


            ret = objMyRRSM.DoEventAnswer(IN m_messageString, IN m_parameterString); ///@todo  this is used as a delay because function called in   ///@clarify
            CPPUNIT_ASSERT(MP_NO_ERROR == ret);

            //-----------------------------------------
            //receive result via testQ from MTPControl
            //-----------------------------------------
            int numOfMatchingString;
            TestIF_waitForAnswerAlternative(OUT numOfMatchingString,IN STRING_TRESULT_OK,IN STRING_TRESULT_NOK);
            if(2 == numOfMatchingString)
            {
                bGetNextItem = false;
            }
            else
            {
                index++;
                ETG_TRACE_USR4(("MTPControlTestRealDevice::ReadRootFolder: request next item:%d",index));
            }
        }
    }
    else
    {
        ETG_TRACE_USR4(("MTPControlTestRealDevice::Fingerprint: REALDEVICECONNECTED_NO "));
    }

    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}
