/*
 * MTPControlTestComb.cpp
 *
 *  Created on: Jul 11, 2013
 *      Author: tritonsu
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/MTPControlTestCombined.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif


#include "MTPControl.h"
#include "FunctionTracer.h"
#include "PlayerEngineIpcIF.h"
#include "LocalSPM.h"
#include "CppUnitDefinitions.h"
#include "Dispatcher.h"

#include "MTPControlTestCombined.h"

/**********************************************************************
 * Fixture
 *********************************************************************/
void MTPControlTestCombined::setUp()  //@todo think about using setUp and tearDown busszword 'fixture'    //will be called before each CPPUNITTestfunction
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

    m_ticks.begin();

    //---------------------------------------------------------------------------
	//add devices to database and to LibMTPWrapperTest i.e. stub of real libMTP
	//---------------------------------------------------------------------------
	util_initDBplusLibMTPStub();
	util_showdevicesDB();
	util_showdevicesMTPLib();

	//-----------------------------------------------------------------------
	//delete tmp-files on target  i.e. last uploaded MTP-File plus info file
	//-----------------------------------------------------------------------
	util_deleteTmpFile(LOCAL_MTPFILE_PATH_TARGET,LOCAL_MTPFILE_INFO);
	util_deleteTmpFile(LOCAL_MTPFILE_PATH_TARGET,LOCAL_MTPFILE_BIN);

	//----------------------------------------
	//init IPC to player engine
	//----------------------------------------
	util_InitIPC();
	//----------------------------------------
	//further steps to prepare a play
	//----------------------------------------
	util_SwitchObserver();
	util_AllocateAudioInput();
	//StartStreaming();

	m_ret = MP_NO_ERROR; ///@todo checked if used

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}

void MTPControlTestCombined::tearDown()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("Begin: %s", __PRETTY_FUNCTION__));

	util_recreateDB();  //to warranty for other test modules that system is in the same condition like it was before the tests
	                    //and to follow the philosophy that all tests might be executed in different order
    m_ticks.elapsed();

    ETG_TRACE_USR3(("End  : %s", __PRETTY_FUNCTION__));
}


/******************************************************************************************************
 *
 *   combined functionalities
 *
 ******************************************************************************************************/

void MTPControlTestCombined::InitDeviceGetMetadata()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	int i = 0; //device index=0;

	//---------------------
	//init device data...
	//--------------------
	ETG_TRACE_USR3(("(index:%i) %s**********", i, __PRETTY_FUNCTION__));
	snprintf(m_url,sizeof(m_url),"%d",i);
	snprintf(m_mountPoint,sizeof(m_mountPoint),"/%d_deviceversion/%d_serialnumber/",i,i); //refer to util_initDBplusLibMTPStub for better understanding of test data

	//-----------------------------------------
	//simulate connecting device
	//-----------------------------------------
	util_InitDeviceConnection(OUT m_deviceID,IN m_mountPoint);
	sleep(3); ///@todo add mechanism to get real feedback from MTPControl

	//-------------------------
	// GET METADATA
	//-------------------------
	util_getmetadata(IN m_deviceID, IN m_mountPoint,IN INVALID_READPOS); //note: read position is currently ignored in receiving function

	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

void MTPControlTestCombined::InitRemoveDeviceConnection()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	int i = 0; //device index=0;
	unsigned int numOfDevices;
	unsigned int numOfTrials          = 4;
	unsigned int timoutInterval       = 4; /*sec*/
	unsigned int expectedNumOfDevices = 1;

	//---------------------
	//init device data...
	//--------------------
	ETG_TRACE_USR3(("(index:%i) %s**********", i, __PRETTY_FUNCTION__));
	snprintf(m_url,sizeof(m_url),"%d",i);
	snprintf(m_mountPoint,sizeof(m_mountPoint),"/%d_deviceversion/%d_serialnumber/",i,i); //refer to util_initDBplusLibMTPStub for better understanding of test data

	//-----------------------------------------
	//simulate connecting a single devicedevice
	//-----------------------------------------
	util_InitDeviceConnection(OUT m_deviceID,IN m_mountPoint);

	/*check if single device is available in List of MTPControl*/
	numOfDevices = LocalSPM::GetMTPControl().TestIF_GetNumOfDevices(expectedNumOfDevices,timoutInterval,numOfTrials);
	CPPUNIT_ASSERT(numOfDevices == 0);

	//-----------------------------------------
	//simulate disconnecting same device
	//-----------------------------------------
	util_RemoveDeviceConnection(IN m_deviceID,IN m_mountPoint);

	//------------------------------------------
	//check if device is not available in
	//------------------------------------------
	///@todo there seems to be an dependency
	//numOfDevices = LocalSPM::GetMTPControl().TestIF_GetNumOfDevices(expectedNumOfDevices,timoutInterval,numOfTrials);
	//CPPUNIT_ASSERT(numOfDevices == 0);

	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}


void  MTPControlTestCombined::PlayFromDevicesStop()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	int i;

    //----------------------------------------
    //iterate two devices
    //----------------------------------------
	for(i=0;i<NUMOFTESTDEVICES;i++)
	{
		//---------------------
		//init device data...
		//--------------------
		ETG_TRACE_USR3(("(index:%i) %s**********", i, __PRETTY_FUNCTION__));
		snprintf(m_url,sizeof(m_url),"%d",i);
		snprintf(m_mountPoint,sizeof(m_mountPoint),"/%d_deviceversion/%d_serialnumber/",i,i); //refer to util_initDBplusLibMTPStub for better understanding of test data

		//-----------------------------------------
		//simulate connecting device
	    //-----------------------------------------
		util_InitDeviceConnection(OUT m_deviceID,IN m_mountPoint);
		sleep(3); ///@todo add mechanism to get real feedback from MTPControl

		//---------------------------------------
		//play samples from devices
		//---------------------------------------
		util_play(IN m_deviceID, IN m_mountPoint,IN m_url);
		sleep(5); //play at least 5s

	    //------------------------------------------
	    //Stop playing
	    //------------------------------------------
	    util_stop(IN m_deviceID, IN m_mountPoint,IN m_url);

	}

	  ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

void MTPControlTestCombined::PlayFromDevicePauseResumeStop()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	int i = NUMOFTESTDEVICES-1; //take second device for test


	//---------------------
	//init device data...
	//--------------------
	ETG_TRACE_USR3(("(index:%i) %s**********", i, __PRETTY_FUNCTION__));
	snprintf(m_url,sizeof(m_url),"%d",i);
	snprintf(m_mountPoint,sizeof(m_mountPoint),"/%d_deviceversion/%d_serialnumber/",i,i); //refer to util_initDBplusLibMTPStub for better understanding of test data

	//-----------------------------------------
	//simulate connecting device
	//-----------------------------------------
	util_InitDeviceConnection(m_deviceID,m_mountPoint);
	sleep(3);

	//---------------------------------------
	//play samples from devices
	//---------------------------------------
	util_play(m_deviceID, m_mountPoint,m_url);

	//------------------------------------------
	//pause, resume, stop
	//------------------------------------------
	sleep(5); //play at least 5s
	util_pause(m_deviceID, m_mountPoint, m_url);
	sleep(3);
	util_resume(m_deviceID, m_mountPoint, m_url);
	sleep(5);
	util_stop(IN m_deviceID, IN m_mountPoint,IN m_url);

	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

void MTPControlTestCombined::PlayFromDeviceSeekToStop()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	int i = 0; //take second device for test
	tPlaytime position = 30000 /*ms*/; //30s

	//---------------------
	//init device data...
	//--------------------
	ETG_TRACE_USR3(("(index:%i) %s**********",i,  __PRETTY_FUNCTION__));
	snprintf(m_url,sizeof(m_url),"%d",i);
	snprintf(m_mountPoint,sizeof(m_mountPoint),"/%d_deviceversion/%d_serialnumber/",i,i); //refer to util_initDBplusLibMTPStub for better understanding of test data

	//-----------------------------------------
	//simulate connecting device
	//-----------------------------------------
	util_InitDeviceConnection(m_deviceID,m_mountPoint);
	sleep(3); //@todo find a better way to get feedback

	//---------------------------------------
	//play samples from devices and pause
	//---------------------------------------
	util_play(m_deviceID, m_mountPoint,m_url);
	sleep(5); //play at least 5s

	//------------------------------------------
	//seek
	//------------------------------------------
	util_seekto(m_deviceID, m_mountPoint,m_url, position);

	//---------------------------------------
	//play samples from devices from position
	//---------------------------------------
	sleep(3); //play at least 5s

	//------------------------------------------
	//stop
	//------------------------------------------
	util_stop(IN m_deviceID, IN m_mountPoint,IN m_url);

	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

void MTPControlTestCombined::PlayFromDeviceFastForwardStop()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	int i = 0; //take second device for test

	//---------------------
	//init device data...
	//--------------------
	ETG_TRACE_USR3(("(index:%i) %s**********",i, __PRETTY_FUNCTION__));
	snprintf(m_url,sizeof(m_url),"%d",i);
	snprintf(m_mountPoint,sizeof(m_mountPoint),"/%d_deviceversion/%d_serialnumber/",i,i); //refer to util_initDBplusLibMTPStub for better understanding of test data

	//-----------------------------------------
	//simulate connecting device
	//-----------------------------------------
	util_InitDeviceConnection(m_deviceID,m_mountPoint);
	sleep(3); //@todo find a better way to get feedback

	//---------------------------------------
	//play samples from devices and pause
	//---------------------------------------
	util_play(m_deviceID, m_mountPoint,m_url);
	sleep(3); //play at least 3s

	//------------------------------------------
	//seek
	//------------------------------------------
	util_fastforward(m_deviceID, m_mountPoint,m_url, 4 /*rate */); //after every second jump 10s

	//---------------------------------------
	//play samples from devices from position
	//---------------------------------------
	sleep(10); //play at least 10s

	//------------------------------------------
	//stop
	//------------------------------------------
	util_stop(IN m_deviceID, IN m_mountPoint,IN m_url);

	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}


void MTPControlTestCombined::PlayFromDeviceFastRewindStop()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	int i = 1; //take second device for test
	tPlaytime position = 120000 /*ms*/; //2min

	//---------------------
	//init device data...
	//--------------------
	ETG_TRACE_USR3(("(index:%i) %s**********",i, __PRETTY_FUNCTION__));
	snprintf(m_url,sizeof(m_url),"%d",i);
	snprintf(m_mountPoint,sizeof(m_mountPoint),"/%d_deviceversion/%d_serialnumber/",i,i); //refer to util_initDBplusLibMTPStub for better understanding of test data

	//-----------------------------------------
	//simulate connecting device
	//-----------------------------------------
	util_InitDeviceConnection(m_deviceID,m_mountPoint);
	sleep(3); //@todo find a better way to get feedback


	//---------------------------------------
	//play samples from devices and pause
	//---------------------------------------
	util_play(m_deviceID, m_mountPoint,m_url);
	sleep(3); //play at least 3s
    util_seekto(m_deviceID, m_mountPoint,m_url, position);
    sleep(3); //play at least 3s
	//------------------------------------------
	//seek
	//------------------------------------------
	util_fastrewind(m_deviceID, m_mountPoint,m_url, 4 /*rate */); //after every second jump 10s

	//---------------------------------------
	//play samples from devices from position
	//---------------------------------------
	sleep(10); //play at least 5s

	//------------------------------------------
	//stop
	//------------------------------------------
	util_stop(IN m_deviceID, IN m_mountPoint,IN m_url);

	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}
