#ifndef _MTPCONTROLTEST_H_
#define _MTPCONTROLTEST_H_


#include "MTPControlTestUtil.h"

class MTPControlTest : public MTPControlTestUtil, public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( MTPControlTest );

    //----------------------------------------------------------------------------
    //these tests check if state message results in calling corresponding function
    //----------------------------------------------------------------------------
    CPPUNIT_TEST( InitIPC );
    CPPUNIT_TEST( InitDeviceConnection );
    CPPUNIT_TEST( SwitchObserver );
    CPPUNIT_TEST( AllocateAudioInput );
    CPPUNIT_TEST( StartStreaming );
    CPPUNIT_TEST( Play );
    CPPUNIT_TEST( Pause );
    CPPUNIT_TEST( Resume );
    CPPUNIT_TEST( Stop );
    CPPUNIT_TEST( SeekTo );
    CPPUNIT_TEST( FastForward );
    CPPUNIT_TEST( FastRewind );
    CPPUNIT_TEST( RemoveDeviceConnection );
    CPPUNIT_TEST( GetMetadata ); ///@todo it's not fully clear what to do in error case
#ifdef TARGET_BUILD
    CPPUNIT_TEST( GetAlbumArt ); ///@todo check valgrind //currently disabled due to  reset in ubuntu 64 bit.
#endif

    CPPUNIT_TEST_SUITE_END();

public:

    MTPControlTest(){};

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();

    /*test cases*/
    void InitIPC();
    void AllocateAudioInput();
    void SwitchObserver();
    void StartStreaming();
    void InitDeviceConnection();
    void Play();
    void Stop();
    void Pause();
    void Resume();
    void SeekTo();
    void FastForward();
    void FastRewind();
    void RemoveDeviceConnection();

    void GetFingerprint();
    void GetMetadata();
    void GetAlbumArt();

};

#endif  // _MTPCONTROLTEST_H_
