///@todo IN,OUT dranschreiben
///@todo care for different formats like wav,aac,mp3
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/MTPControlTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include "MTPControl.h"
#include "FunctionTracer.h"
#include "PlayerEngineIpcIF.h"
#include "LocalSPM.h"
#include "CppUnitDefinitions.h"
#include "Dispatcher.h"

#include "MTPControlTest.h"

#define  USE_STUBBED_MTPLIB
#include "MTPLibWrapperTest.h"
#include <dirent.h>

/*--------------------------------------------------------------------------------------------------------
 *  class - function definitions
 *--------------------------------------------------------------------------------------------------------*/

/**********************************************************************
 * Fixture
 *********************************************************************/
void MTPControlTest::setUp()  //@todo think about using setUp and tearDown busszword 'fixture'    //will be called before each CPPUNITTestfunction
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

    m_ticks.begin();

	m_ret = MP_NO_ERROR; ///@todo checked if used

    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

void MTPControlTest::tearDown()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

    m_ticks.elapsed();

    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

/**********************************************************************
 * Test cases
 *********************************************************************/

//in DeviceControl.zargo - DeviceControlStateMachineDiagramm States and Transition events are drawn
//these are basis for tests below

/******************************************************************************************************
 *
 *   messages send to State machine to check if MTPControl recieves it in corresponding functions
 *
 ******************************************************************************************************/


//get audio sink
void MTPControlTest::InitIPC()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	util_InitIPC();

    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

//allocate source
void MTPControlTest::AllocateAudioInput()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	util_AllocateAudioInput();

    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}
//send message to tell observer that MTP is used now
void MTPControlTest::SwitchObserver()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	util_SwitchObserver();

    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

//streaming
void MTPControlTest::StartStreaming()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	util_StartStreaming();

    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

void MTPControlTest::InitDeviceConnection()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));
	//---------------------------------------------------------------------------
    //add devices to database and to LibMTPWrapperTest i.e. stub of real libMTP
    //---------------------------------------------------------------------------
	util_initDBplusLibMTPStub();

	//---------------------
	//init device data...
	//--------------------
	int i = 0;
	ETG_TRACE_USR3(("(index:%i) %s **********", i, __PRETTY_FUNCTION__));
	snprintf(m_url,sizeof(m_url),"%d",i);
	snprintf(m_mountPoint,sizeof(m_mountPoint),"/%d_deviceversion/%d_serialnumber/",i,i); //refer to util_initDBplusLibMTPStub for better understanding of test data

	//-----------------------------------------
	//simulate connecting device
	//-----------------------------------------
	util_InitDeviceConnection(OUT m_deviceID,IN m_mountPoint);

    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}


void MTPControlTest::Play()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	//-------------------------
	// PLAY
	//-------------------------
	util_play(IN INVALID_DEVICEID, IN INVALID_MOUNTPOINT, IN INVALID_URL);
	sleep(7); //play at least 7s

    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

void MTPControlTest::SeekTo()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	//-------------------------
	// Seek
	//-------------------------
	util_seekto(IN INVALID_DEVICEID, IN INVALID_MOUNTPOINT, IN INVALID_URL, IN INVALID_POSITION/*ms*/);

    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}


void MTPControlTest::Pause()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	//-------------------------
	// PAUSE
	//-------------------------
	util_pause(IN INVALID_DEVICEID, IN INVALID_MOUNTPOINT, IN (char*)"url");

    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

void MTPControlTest::Resume()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	//-------------------------
	// PAUSE
	//-------------------------
	util_resume(IN INVALID_DEVICEID, IN INVALID_MOUNTPOINT, IN INVALID_URL);

    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

void MTPControlTest::Stop()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	//-------------------------
	// STOP
	//-------------------------
	util_stop(IN INVALID_DEVICEID, IN INVALID_MOUNTPOINT, IN INVALID_URL);

    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

void MTPControlTest::FastForward()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	//-------------------------
	// FFWD
	//-------------------------
	util_fastforward(IN INVALID_DEVICEID, IN INVALID_MOUNTPOINT, IN INVALID_URL, INVALID_CUEINGRATE);

    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

void MTPControlTest::FastRewind()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	//-------------------------
	// FFRWD
	//-------------------------
	util_fastrewind(IN INVALID_DEVICEID, IN INVALID_MOUNTPOINT, IN INVALID_URL, INVALID_CUEINGRATE);

    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}


void MTPControlTest::GetMetadata()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	//-------------------------
	// GET METADATA
	//-------------------------
    util_getmetadata(IN INVALID_DEVICEID, IN INVALID_MOUNTPOINT,IN INVALID_READPOS);

    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

///@todo seems to take long until removed why?
void MTPControlTest::RemoveDeviceConnection()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

    tResult ret = MP_NO_ERROR;

    /* Send REMOVE_DEVICE_CONNECTION message to MTPControlSM */
    ret = LocalSPM::GetMTPControl().ParameterREMOVE_DEVICE_CONNECTION(OUT m_parameterString,
                                                                       IN sizeof(m_parameterString),
                                                                       IN INVALID_MOUNTPOINT,
                                                                       IN INVALID_DEVICEID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = LocalSPM::GetMTPControl().SendEventByName("REMOVE_DEVICE_CONNECTION", IN m_parameterString);

    sleep(1);

    ///@todo is there an answer available?
    // test result
    CPPUNIT_ASSERT(ret == 0);
    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

/* use a request / response state machine for verifying the received AlbumArt data object */


void MTPControlTest::GetAlbumArt()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

	//------------------------------------------
    //GetAlbumArt
	//------------------------------------------

    util_GetAlbumArt(ALBUM_ART_TEST_URL_1,MMT_PNG     ,12089,true ,"/tmp/MTP_Art-MP3-Its_Raining_Again.png");//album art available
    util_GetAlbumArt(ALBUM_ART_TEST_URL_2,MMT_PNG     ,12089,true ,"/tmp/MTP_Art-MP3-Neuland.png");          //album art available
    util_GetAlbumArt(ALBUM_ART_TEST_URL_3,MMT_JPG     ,11993,true ,"/tmp/MTP_Art-MP3-A_Stroke_of_Luck.jpg"); //album art available
    util_GetAlbumArt(ALBUM_ART_TEST_URL_4,(tMimeType)0,0    ,false,"/tmp/MTP_Art-none");                     //album art NOT available

/* before test content has been adjusted
    util_GetAlbumArt(ALBUM_ART_TEST_URL_1,MMT_JPG     ,20774,true ,"/tmp/MTP_Art-MP3-Its_Raining_Again.jpg");//album art available
    util_GetAlbumArt(ALBUM_ART_TEST_URL_2,MMT_JPG     ,39644,true ,"/tmp/MTP_Art-MP3-Neuland.jpg");          //album art available
    util_GetAlbumArt(ALBUM_ART_TEST_URL_3,MMT_JPG     ,11993,true ,"/tmp/MTP_Art-MP3-A_Stroke_of_Luck.jpg"); //album art available
    util_GetAlbumArt(ALBUM_ART_TEST_URL_4,(tMimeType)0,0    ,false,"/tmp/MTP_Art-none");                     //album art NOT available
*/
    //util_GetAlbumArt(ALBUM_ART_TEST_URL_5,MMT_JPG     ,68296,true ,"/tmp/MTP_Art-MP3-Nach_Mir.jpg");         //album art is available as file not as embedded inside mp3 file //@todo album Art as a file not  inside mp3

	ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}

void MTPControlTest::GetFingerprint()
{
	ENTRY_INTERNAL
	ETG_TRACE_USR3(("->********** Start-MTPTest %s **********", __PRETTY_FUNCTION__));

    tResult ret = MP_NO_ERROR;
    MTPControlTestSM objMyRRSM;

    tMountPoint mountPoint;
    tDeviceID deviceID = 2;

#ifndef TARGET_BUILD
    char *pwd = get_current_dir_name();
    strncpy(mountPoint, pwd, sizeof(mountPoint)-1);
    strncat_r(mountPoint, "/Customer/Simulation/CustomControl/test", sizeof(mountPoint));
#else
    strncpy(mountPoint, "/opt/bosch/test/data/GMP/test", sizeof(mountPoint));
#endif

    /* Send GET_FINGERPRINT message to MTPControlSM */
    char messageString[256];
    strncpy(messageString, "MTPControlSM::GET_FINGERPRINT", sizeof(messageString)-1);
    char paramaterString[256];
    size_t size = sizeof(paramaterString);
    tFingerprint dummyFingerprint = {0};

    ret = LocalSPM::GetMTPControl().ParameterGET_FINGERPRINT(OUT paramaterString, IN size, IN mountPoint, IN deviceID, IN dummyFingerprint);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN messageString, IN paramaterString);

    //sleep(1); Not necessary because we are waiting in MTPControlTestSM to response

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
    ETG_TRACE_USR3(("<-********** OK-MTPTest %s **********", __PRETTY_FUNCTION__));
}


