#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/DeviceDispatcherTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif


#include "DeviceDispatcher.h"
#include "FunctionTracer.h"
#include "PlayerEngineIpcIF.h"
#include "LocalSPM.h"
#include "CppUnitDefinitions.h"
#include "Dispatcher.h"
#include "RequestResponseSM.h"

#include "DeviceDispatcherTest.h"

class DeviceDispatcherTestSM: public RequestResponseSM
{
    int HandleInitRequest()
    {
        mResult = MP_NO_ERROR;
        return 0;
    }

    int HandleSuccessRequest(const char *allParameters) // CID 10021 (#1 of 1): Failed to override method (BAD_OVERRIDE)
    {
        /* the request/expect state machine has a general SUCCESS_REQUEST message which is not
        // specialized to a service state machine be called, so all kind of parameters must
        // be processed by hand in this method. */
        ETG_TRACE_USR1(("DeviceDispatcherTestSM::HandleSuccessRequest allParameters:%s", allParameters));
        return 0;
    }

    int HandleActionError(const me::reason_e reason)
    {
        //ETG_TRACE_ERR(("DeviceDispatcherTestSM::HandleActionError reason:%u", reason));
        (void)reason;
        mResult = MP_ERR_ACTION_ERROR;
        return 0;
    }

public:
    tResult mResult;
};


void DeviceDispatcherTest::setUp()
{
    ticks.begin();
}

void DeviceDispatcherTest::tearDown()
{
    ticks.elapsed();
}


/**********************************************************************
 * Test cases
 *********************************************************************/

void DeviceDispatcherTest::Allocate()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start DeviceDispatcherTest::Allocate***"));

    tResult ret = MP_NO_ERROR;

    tAudioOutputDevice audioOutputDevice;
    strncpy_r(OUT audioOutputDevice, USB_ALSA_DEVICENAME, IN sizeof(audioOutputDevice));

    /* Send ALLOCATE message to DeviceDispatcherSM */
    char messageString[256];
    strncpy_r(OUT messageString, "DeviceDispatcherSM::ALLOCATE", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetDeviceDispatcher().ParameterALLOCATE(OUT parameterString, IN size, IN audioOutputDevice);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    DeviceDispatcherTestSM objMyRRSM;
    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, DEV_DISP_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
}

void DeviceDispatcherTest::DeAllocate()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start DeviceDispatcherTest::DeAllocate***"));

    tResult ret = MP_NO_ERROR;

    /* Send DEALLOCATE message to DeviceDispatcherSM */
    char messageString[64];
    strncpy_r(OUT messageString, "DeviceDispatcherSM::DEALLOCATE", IN sizeof(messageString));

    DeviceDispatcherTestSM objMyRRSM;
    ret = objMyRRSM.DoEventAnswer(IN messageString, (char *)NULL, NULL, DEV_DISP_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
}

void DeviceDispatcherTest::PlayTrack1()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start DeviceDispatcherTest::PlayTrack1***"));

    tMediaObject mediaObject;
    tPlaytime position = 20000; //20s
    tStreaming streaming = false;
    GetUSBTrack1(OUT mediaObject);

    Play(IN mediaObject.deviceType, IN mediaObject.deviceID, IN mediaObject.fileName, IN mediaObject.mountPoint, IN mediaObject.objectID,
         IN position, IN streaming);
}

void DeviceDispatcherTest::SeekToTrack1()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start DeviceDispatcherTest::SeekToTrack1***"));

    tResult ret = MP_NO_ERROR;

    tMediaObject mediaObject;
    tPlaytime position = 9999; //10s
    GetUSBTrack1(OUT mediaObject);

    /* Send SEEK_TO message to DeviceDispatcherSM */
    char messageString[256];
    strncpy_r(OUT messageString, "DeviceDispatcherSM::SEEK_TO", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetDeviceDispatcher().ParameterSEEK_TO(OUT parameterString,
            IN size,
            IN mediaObject.deviceType,
            IN mediaObject.deviceID,
            IN mediaObject.fileName,
            IN mediaObject.mountPoint,
            IN position);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    DeviceDispatcherTestSM objMyRRSM;
    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, DEV_DISP_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
}

void DeviceDispatcherTest::BufferTrack2()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start DeviceDispatcherTest::BufferTrack2***"));

    tResult ret = MP_NO_ERROR;

    tMediaObject mediaObject;
    GetUSBTrack2(OUT mediaObject);

    /* Send BUFFER message to DeviceDispatcherSM */
    char messageString[256];
    strncpy_r(OUT messageString, "DeviceDispatcherSM::BUFFER", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetDeviceDispatcher().ParameterBUFFER(OUT parameterString,
            IN size,
            IN mediaObject.deviceType,
            IN mediaObject.deviceID,
            IN mediaObject.fileName,
            IN mediaObject.mountPoint,
            IN (tPEHandle)mediaObject.objectID);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    DeviceDispatcherTestSM objMyRRSM;
    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, DEV_DISP_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
}

void DeviceDispatcherTest::ChangeToTrack2()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start DeviceDispatcherTest::ChangeToTrack2***"));

    tMediaObject mediaObject;
    tPlaytime position = 0; //0s
    tStreaming streaming = false;
    GetUSBTrack2(OUT mediaObject);

    Play(IN mediaObject.deviceType, IN mediaObject.deviceID, IN mediaObject.fileName, IN mediaObject.mountPoint, IN mediaObject.objectID,
         IN position, IN streaming);
}

void DeviceDispatcherTest::PauseAndResumeTrack2()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start DeviceDispatcherTest::PauseAndResumeTrack2***"));

    tResult ret = MP_NO_ERROR;

    tMediaObject mediaObject;
    GetUSBTrack2(OUT mediaObject);

    /* Send PAUSE message to DeviceDispatcherSM */
    char messageString[256];
    strncpy_r(OUT messageString, "DeviceDispatcherSM::PAUSE", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetDeviceDispatcher().ParameterPAUSE(OUT parameterString,
            IN size,
            IN mediaObject.deviceType,
            IN mediaObject.deviceID,
            IN mediaObject.fileName,
            IN mediaObject.mountPoint);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    DeviceDispatcherTestSM objMyRRSM;
    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, DEV_DISP_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Send RESUME message to DeviceDispatcherSM */
    strncpy_r(OUT messageString, "DeviceDispatcherSM::RESUME", IN sizeof(messageString));
    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, DEV_DISP_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
}

void DeviceDispatcherTest::FFwdTrack2()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start DeviceDispatcherTest::FFwdTrack2***"));

    tResult ret = MP_NO_ERROR;

    tMediaObject mediaObject;
    tCueingRate rate = LocalSPM::GetDataProvider().CueingRate();
    GetUSBTrack2(OUT mediaObject);

    /* Send FFWD message to DeviceDispatcherSM */
    char messageString[256];
    strncpy_r(OUT messageString, "DeviceDispatcherSM::FFWD", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    speedstate_e IsPlaybackSpeed = ME_SPEEDSTATE_OFF;

    ret = LocalSPM::GetDeviceDispatcher().ParameterFFWD(OUT parameterString,
            IN size,
            IN mediaObject.deviceType,
            IN mediaObject.deviceID,
            IN mediaObject.fileName,
            IN mediaObject.mountPoint,
            IN rate,
            IN IsPlaybackSpeed);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    DeviceDispatcherTestSM objMyRRSM;
    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, DEV_DISP_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Send FFWD_STOP message to DeviceDispatcherSM */
    strncpy_r(OUT messageString, "DeviceDispatcherSM::FFWD_STOP", IN sizeof(messageString));

    ret = LocalSPM::GetDeviceDispatcher().ParameterFFWD_STOP(OUT parameterString,
            IN size,
            IN mediaObject.deviceType,
            IN mediaObject.deviceID,
            IN mediaObject.fileName,
            IN mediaObject.mountPoint,
            IN IsPlaybackSpeed);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, DEV_DISP_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
}

void DeviceDispatcherTest::FRevTrack2()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start DeviceDispatcherTest::FRevTrack2***"));

    tResult ret = MP_NO_ERROR;

    tMediaObject mediaObject;
    tCueingRate rate = LocalSPM::GetDataProvider().CueingRate();
    GetUSBTrack2(OUT mediaObject);

    /* Send FREV message to DeviceDispatcherSM */
    char messageString[256];
    strncpy_r(OUT messageString, "DeviceDispatcherSM::FREV", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    speedstate_e IsPlaybackSpeed = ME_SPEEDSTATE_OFF;

    ret = LocalSPM::GetDeviceDispatcher().ParameterFREV(OUT parameterString,
            IN size,
            IN mediaObject.deviceType,
            IN mediaObject.deviceID,
            IN mediaObject.fileName,
            IN mediaObject.mountPoint,
            IN rate,
            IN IsPlaybackSpeed);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    DeviceDispatcherTestSM objMyRRSM;
    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, DEV_DISP_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    /* Send FREV_STOP message to DeviceDispatcherSM */
    strncpy_r(OUT messageString, "DeviceDispatcherSM::FREV_STOP", IN sizeof(messageString));

    ret = LocalSPM::GetDeviceDispatcher().ParameterFREV_STOP(OUT parameterString,
            IN size,
            IN mediaObject.deviceType,
            IN mediaObject.deviceID,
            IN mediaObject.fileName,
            IN mediaObject.mountPoint,
            IN IsPlaybackSpeed);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, DEV_DISP_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
}

void DeviceDispatcherTest::StopTrack2()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start DeviceDispatcherTest::StopTrack2***"));

    tResult ret = MP_NO_ERROR;

    tMediaObject mediaObject;
    GetUSBTrack2(OUT mediaObject);

    /* Send STOP message to DeviceDispatcherSM */
    char messageString[256];
    strncpy_r(OUT messageString, "DeviceDispatcherSM::STOP", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetDeviceDispatcher().ParameterSTOP(OUT parameterString,
            IN size,
            IN mediaObject.deviceType,
            IN mediaObject.deviceID,
            IN mediaObject.fileName,
            IN mediaObject.mountPoint);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    DeviceDispatcherTestSM objMyRRSM;
    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, DEV_DISP_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    sleep(1); //wait until Player/Media-Engine really stopped
}

void DeviceDispatcherTest::IPCStressTest()
{
    ENTRY
    ETG_TRACE_USR1(("          ***Start DeviceDispatcherTest::IPCStressTest***"));

    SMF smf = LocalSPM::GetUSBControl();

    while(1)
    {
        if(MP_NO_ERROR != LocalSPM::GetIPCProvider().SwitchObserver(IN &smf))
            break;
    }
}

void DeviceDispatcherTest::GetUSBTrack1(tMediaObject &mediaObject)
{
    ENTRY

    InitMediaObject(OUT mediaObject);

    mediaObject.deviceType = DTY_USB;
    mediaObject.deviceID = 123;
    mediaObject.objectID = 4711;

#ifndef TARGET_BUILD
    char *pwd = get_current_dir_name();
    strncpy_r(OUT mediaObject.fileName, IN pwd, IN sizeof(mediaObject.fileName));
    strncat_r(OUT mediaObject.fileName, "/Customer/Simulation/CustomControl/test/music/Garbage/Garbage-Garbage-01-Supervixen.mp3", IN sizeof(mediaObject.fileName));
#else
    strncpy_r(OUT mediaObject.fileName, "/opt/bosch/test/data/GMP/test/music/Garbage/Garbage-Garbage-01-Supervixen.mp3", IN sizeof(mediaObject.fileName));
#endif
}

void DeviceDispatcherTest::GetUSBTrack2(tMediaObject &mediaObject)
{
    ENTRY

    InitMediaObject(OUT mediaObject);

    mediaObject.deviceType = DTY_USB;
    mediaObject.deviceID = 123;
    mediaObject.objectID = 4712;

#ifndef TARGET_BUILD
    char *pwd = get_current_dir_name();
    strncpy_r(OUT mediaObject.fileName, IN pwd, IN sizeof(mediaObject.fileName));
    strncat_r(OUT mediaObject.fileName, "/Customer/Simulation/CustomControl/test/music/Garbage/Garbage-Garbage-12-Milk.mp3", IN sizeof(mediaObject.fileName));
#else
    strncpy_r(OUT mediaObject.fileName, "/opt/bosch/test/data/GMP/test/music/Garbage/Garbage-Garbage-12-Milk.mp3", IN sizeof(mediaObject.fileName));
#endif
}

void DeviceDispatcherTest::Play(const tDeviceType deviceType,
                                const tDeviceID deviceID,
                                const tURL URL,
                                const tMountPoint mountPoint,
                                const tObjectID objectID,
                                const tPlaytime position,
                                const tStreaming streaming)
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    /* Send PLAY message to DeviceDispatcherSM */
    tUUID uuid = {0};
    char messageString[256];
    strncpy_r(OUT messageString, "DeviceDispatcherSM::PLAY", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetDeviceDispatcher().ParameterPLAY(OUT parameterString,
            IN size,
            IN deviceType,
            IN deviceID,
            IN URL,
            IN mountPoint,
            IN uuid,
            IN (tPEHandle)objectID,
            IN position,
            IN streaming);
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);

    DeviceDispatcherTestSM objMyRRSM;
    ret = objMyRRSM.DoEventAnswer(IN messageString, IN parameterString, NULL, DEV_DISP_SM_ANSWER_TIMEOUT_MS);

    // test result
    CPPUNIT_ASSERT(MP_NO_ERROR == ret);
}

