#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/CDDAControlTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif
#include <unistd.h>
#include "FunctionTracer.h"
#include "DVDControlInterfaceTest.h"


void DVDControlInterfaceTest::setUp()
{
    ticks.begin();
}

void DVDControlInterfaceTest::tearDown()
{
    ticks.elapsed();
}

void DVDControlInterfaceTest::Initialize()
{
    ENTRY;
    int status=0;
    tMountPoint mp = "/dev/sr2";
    status=m_DVDControlInterface.Initialize(mp);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(30);
}
void DVDControlInterfaceTest::DirectPlay()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.directPlay();
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(5);
}
void DVDControlInterfaceTest::FastForward()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.ffwdStart(0);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(10);
    status=m_DVDControlInterface.ffwdStop();
    sleep(1);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
}
void DVDControlInterfaceTest::SlowForward()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.sfwdStart(0);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(10);
    status=m_DVDControlInterface.ffwdStop();
    sleep(1);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
}
void DVDControlInterfaceTest::Eject()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.ejectDisc();
    sleep(10);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
}
void DVDControlInterfaceTest::FastReverse()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.frevStart(0);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(5);
    status=m_DVDControlInterface.frevStop();
    sleep(1);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
}
void DVDControlInterfaceTest::SlowReverse()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.srevStart(0);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(5);
    status=m_DVDControlInterface.frevStop();
    sleep(1);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
}
void DVDControlInterfaceTest::SwitchToBackendMode()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.SwitchtoBackendMode();
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(5);
}
void  DVDControlInterfaceTest::Pause()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.pause();
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(3);
}
void  DVDControlInterfaceTest::Next()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.next();
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(3);
}
void  DVDControlInterfaceTest::Previous()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.previous();
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(3);
}
void  DVDControlInterfaceTest::OneTrackPlay()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.oneTrackPlay(m_DVDControlInterface.getNumberOfTracks()/2);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(3);
}
void  DVDControlInterfaceTest::Repeat()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.setPlaybackMode(tPlaybackFunctionControl::FUNC_COMMAND_TRACK_REPEAT);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(3);
}
void  DVDControlInterfaceTest::RepeatOff()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.setPlaybackMode(tPlaybackFunctionControl::FUNC_COMMAND_OFF);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(3);
}
void  DVDControlInterfaceTest::Shuffle()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.setPlaybackMode(tPlaybackFunctionControl::FUNC_COMMAND_RANDOM);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(3);
}
void  DVDControlInterfaceTest::ShuffleOff()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.setPlaybackMode(tPlaybackFunctionControl::FUNC_COMMAND_OFF);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(3);
}
void  DVDControlInterfaceTest::SubtitleOn()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.setSubtitle(tSubtitleControl::SUB_ON_OFF, 1);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(10);
}
void  DVDControlInterfaceTest::SubtitleOff()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.setSubtitle(tSubtitleControl::SUB_ON_OFF, 0);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(10);
}
void  DVDControlInterfaceTest::SubtitleChange()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.setSubtitle(tSubtitleControl::SUB_DIRECT, 3);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(3);
}
void  DVDControlInterfaceTest::AudioOutputChangeDVD()
{
    ENTRY;
    int status=0;
    unsigned char audioOutput = 2;
    status=m_DVDControlInterface.setAudioChannel(tSelectionOrder::DIRECT,audioOutput);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(3);
}
void  DVDControlInterfaceTest::AudioOutputChangeVCD()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.setAudioChannel(tSelectionOrder::DIRECT,tVCDAudioChannelOutput::VCD_CHANNEL_RR);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(3);
}
void  DVDControlInterfaceTest::AngleChange()
{
    ENTRY;
    int status=0;
    unsigned char angle = 2;
    status=m_DVDControlInterface.setAngle(tSelectionOrder::DIRECT,angle);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(3);
}
void  DVDControlInterfaceTest::DirectSearch()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.directSearch(3,3);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(3);
}
void  DVDControlInterfaceTest::TitleSearch()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.titleSearch(3);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(3);
}
void  DVDControlInterfaceTest::CMSkipF1()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.CMSkip(tSkipTiming::SKIP_FWD_15);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(10);
}
void  DVDControlInterfaceTest::CMSkipF2()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.CMSkip(tSkipTiming::SKIP_FWD_30);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(10);
}
void  DVDControlInterfaceTest::CMSkipF3()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.CMSkip(tSkipTiming::SKIP_FWD_60);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(10);
}
void  DVDControlInterfaceTest::CMSkipR1()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.CMSkip(tSkipTiming::SKIP_REV_15);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(5);
}
void  DVDControlInterfaceTest::CMSkipR2()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.CMSkip(tSkipTiming::SKIP_REV_30);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(5);
}
void  DVDControlInterfaceTest::CMSkipR3()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.CMSkip(tSkipTiming::SKIP_REV_60);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(5);
}
void DVDControlInterfaceTest::readTOC()
{
    ENTRY;
    int status=0;
    sleep(15);
    tCDTOCInfo tocInfo ;
    status=m_DVDControlInterface.readToc(tocInfo);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(2);
}
void DVDControlInterfaceTest::getCDTextInfo()
{
    ENTRY;
    int status=0;
    unsigned int totalTrack = 0;
    //status = m_DVDControlInterface.readDiscInformation();
    // sleep(1);
    totalTrack = (unsigned int)(m_DVDControlInterface.getNumberOfTracks());
    tFiles *tocDataOneTrack = NULL;
    if(totalTrack != 0)
    {
        if(status == MP_NO_ERROR)
        {
            for(unsigned int i=0 ; i <= totalTrack ;i++)
            {
                status=m_DVDControlInterface.getTrackTextInfo(tocDataOneTrack ,(unsigned char)i);
                if(status != MP_NO_ERROR)
                {
                    break;
                }
            }
        }
    }
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(10);
}
void DVDControlInterfaceTest::DirectButtonCommand()
{
    ENTRY;
    int status=0;
    sleep(30);
    status=m_DVDControlInterface.directNumber(1);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(10);
}
void DVDControlInterfaceTest::MenuPlayback()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.setMenuPlayback(tMenuControl::MENU);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(3);
}
void DVDControlInterfaceTest::TopMenuPlayback()
{
    ENTRY;
    int status=0;
    status=m_DVDControlInterface.setMenuPlayback(tMenuControl::TOP_MENU);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(3);
}
void DVDControlInterfaceTest::Navigate()
{
    ENTRY;
    int status=0;
    sleep(30);
    status=m_DVDControlInterface.sendNavigationCommand(KEY_ENTER);
#if 0
    sleep(7);
    status=m_DVDControlInterface.sendNavigationCommand(LOWER);
    sleep(1);
    status=m_DVDControlInterface.sendNavigationCommand(RIGHT);
    sleep(1);
    status=m_DVDControlInterface.sendNavigationCommand(LEFT);
    sleep(1);
#endif
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    //sleep(3);
}
void  DVDControlInterfaceTest::NavigateEnter()
{
    ENTRY;
    int status=0;
    sleep(3);
    status=m_DVDControlInterface.sendNavigationCommand(KEY_ENTER);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
}
void  DVDControlInterfaceTest::NavigateUp()
{
    ENTRY;
    int status=0;
    sleep(3);
    status=m_DVDControlInterface.sendNavigationCommand(UPPER);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
}
void  DVDControlInterfaceTest::NavigateDown()
{
    ENTRY;
    int status=0;
    sleep(3);
    status=m_DVDControlInterface.sendNavigationCommand(LOWER);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
}
void  DVDControlInterfaceTest::NavigateLeft()
{
    ENTRY;
    int status=0;
    sleep(3);
    status=m_DVDControlInterface.sendNavigationCommand(LEFT);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
}
void  DVDControlInterfaceTest::NavigateRight()
{
    ENTRY;
    int status=0;
    sleep(3);
    status=m_DVDControlInterface.sendNavigationCommand(RIGHT);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
}
void  DVDControlInterfaceTest::NavigateReturn()
{
    ENTRY;
    int status=0;
    sleep(3);
    status=m_DVDControlInterface.sendNavigationCommand(KEY_RETURN);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
}
void  DVDControlInterfaceTest::WaitPlease()
{
    ENTRY;
    int status=0;
    sleep(30);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
}
void DVDControlInterfaceTest::TouchCommand()
{
    ENTRY;
    int status=0;
    TouchInput ptouchInput;
    memset(&ptouchInput, 0, sizeof(ptouchInput));
    status=m_DVDControlInterface.sendTouchCommand(ptouchInput);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(3);
}
void DVDControlInterfaceTest::ChangePlayerSettingsLanguage()
{
    ENTRY;
    int status=0;
    tDVDSetupInfo setupInfo;
    m_DVDControlInterface.GetSetupInformationData( setupInfo);
    setupInfo.DVDVideoAudioLang[0]= 'e';
            setupInfo.DVDVideoAudioLang[1]= 'n' ;
            setupInfo.DVDVideoMenuLang[0]= 'e';
                    setupInfo.DVDVideoMenuLang[1]= 'n' ;
                    setupInfo.DVDVideoSubtitleLang[0]= 'e';
                            setupInfo.DVDVideoSubtitleLang[1]= 'n' ;
    status = m_DVDControlInterface.ChangeSetupInformationData(setupInfo);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(3);
}
void DVDControlInterfaceTest::ChangePlayerSettingsDRC()
{
    ENTRY;
    int status=0;
    tDVDSetupInfo setupInfo;
    m_DVDControlInterface.GetSetupInformationData(setupInfo);
    setupInfo.DRCSetting = tDRC::BOOST_COMPRESSION;
    status = m_DVDControlInterface.ChangeSetupInformationData(setupInfo);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(3);
}
void DVDControlInterfaceTest::ChangePlayerDisplayAspectRatio()
{
    ENTRY;
    sleep(10);
    int status=0;
    tDVDSetupInfo setupInfo;
    m_DVDControlInterface.GetSetupInformationData( setupInfo);
    setupInfo.DisplayMode = tDisplaySetting::DEFAULT_DISPLAY_16_9;
    status = m_DVDControlInterface.ChangeSetupInformationData(setupInfo);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(3);
}
void DVDControlInterfaceTest::ChangePlayerOSDFunctionAngleMark()
{
    ENTRY;
    int status=0;
    tDVDSetupInfo setupInfo;
    m_DVDControlInterface.GetSetupInformationData( setupInfo);
    setupInfo.AngleMark = true;
    status = m_DVDControlInterface.ChangeSetupInformationData(setupInfo);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(3);
}
void DVDControlInterfaceTest::ChangePlayerOSDFunctionPlayStatus()
{
    ENTRY;
    int status=0;
    tDVDSetupInfo setupInfo;
    m_DVDControlInterface.GetSetupInformationData( setupInfo);
    setupInfo.PlayStatus = true;
    status = m_DVDControlInterface.ChangeSetupInformationData(setupInfo);
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(3);
}

void DVDControlInterfaceTest::DeInitialize()
{
    ENTRY;
    int status=0;
    //status=m_DVDControlInterface.DeInitialize();
    CPPUNIT_ASSERT(MP_NO_ERROR == status);
    sleep(10);
}
