#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_IPOD_CONTROL
#ifdef TARGET_BUILD
#include "trcGenProj/Header/iPodControlMediaPath.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_IPOD_CONTROL
#endif
#endif

#include "FunctionTracer.h"
#include "VarTrace.h"
#include "iPodControlMediaPath.h"
#include "SMF.h"

iPodControlMediaPath::iPodControlMediaPath()
: mListType(LTY_END_OF_EXTERNAL_LIST_TYPES)
, mTag1(-1)
, mTag2(-1)
, mTag3(-1)
, mTag4(-1)
{
    ENTRY_INTERNAL;
    ResetSelection();
}

iPodControlMediaPath::iPodControlMediaPath(const tListType listType, const int tag1, const int tag2,
            const int tag3, const int tag4)
: mListType(listType)
, mTag1(tag1)
, mTag2(tag2)
, mTag3(tag3)
, mTag4(tag4)
{
    ENTRY_INTERNAL;
    ResetSelection();
}

iPodControlMediaPath& iPodControlMediaPath::operator=(
        const iPodControlMediaPath &other) {
    ENTRY_INTERNAL;
    if (this != &other) {
        mListType = other.mListType;
        mTag1 = other.mTag1;
        mTag2 = other.mTag2;
        mTag3 = other.mTag3;
        mTag4 = other.mTag4;
        mCounts.clear();
        mCounts = other.mCounts;
        mNames.clear();
        mNames = other.mNames;
    }
    return *this;
}

tBoolean iPodControlMediaPath::IsSame(
        const iPodControlMediaPath &other) {
    ENTRY_INTERNAL;
    return  (ConvertLTYCountToLTY(mListType) == ConvertLTYCountToLTY(other.mListType) &&
            mTag1 == other.mTag1 &&
            mTag2 == other.mTag2 &&
            mTag3 == other.mTag3 &&
            mTag4 == other.mTag4);
}

bool iPodControlMediaPath::ReuseList(const iPodControlMediaPath &other) {
    ENTRY_INTERNAL;
    if (ConvertLTYCountToLTY(mListType) ==
        ConvertLTYCountToLTY(other.mListType) &&
        mTag1 == other.mTag1 &&
        mTag2 == other.mTag2 &&
        mTag3 == other.mTag3 &&
        mTag4 == other.mTag4) {

        //maybe a different LTY due to special COUNT type, but no need to renew the iPOod selection though
    	mCounts = other.mCounts;
    	mNames = other.mNames;

        return true;
    }
    return false;
}

tBoolean iPodControlMediaPath::IsValid() const {
    ENTRY_INTERNAL;
    return IsLTYSupported();
}

tBoolean iPodControlMediaPath::IsDBPath() const {
    ENTRY_INTERNAL;
    tListType listType = ConvertLTYCountToLTY(mListType);
    tBoolean ret = (listType != LTY_CURRENT_SELECTION);

    return ret;
}

tBoolean iPodControlMediaPath::IsVideo() const {
    ENTRY_INTERNAL;
    tListType listType = ConvertLTYCountToLTY(mListType);
    tBoolean ret = (listType == LTY_VIDEO) || (listType == LTY_VIDEO_EPISODE);

    return ret;
}

tBoolean iPodControlMediaPath::IsPlaylist() const {
    ENTRY_INTERNAL;
    tListType listType = ConvertLTYCountToLTY(mListType);
    tBoolean ret = (listType == LTY_PLAYLIST) || (listType == LTY_PLAYLIST_SONG);

    return ret;
}

tBoolean iPodControlMediaPath::IsPlaylistList() const {
    ENTRY_INTERNAL;
    tListType listType = ConvertLTYCountToLTY(mListType);
    tBoolean ret = (listType == LTY_PLAYLIST);

    return ret;
}

tBoolean iPodControlMediaPath::IsLTYChapter() const {
    ENTRY_INTERNAL;
    tListType listType = ConvertLTYCountToLTY(mListType);
    tBoolean ret = (listType == LTY_BOOKTITLE_CHAPTER) || (listType == LTY_AUTHOR_BOOKTITLE_CHAPTER);

    return ret;
}

tBoolean iPodControlMediaPath::IsLTYCount() const {
    ENTRY_INTERNAL;
    tListType listType = ConvertLTYToLTYCount(mListType);
    tBoolean ret = (listType == mListType) ;

    return ret;
}

tBoolean iPodControlMediaPath::IsLTYSupported() const {
    ENTRY_INTERNAL;
    tListType listType = ConvertLTYCountToLTY(mListType);
    tBoolean ret = (listType < LTY_END_OF_EXTERNAL_LIST_TYPES);

    return ret;
}

tBoolean iPodControlMediaPath::IsLTYRemoteActivity() const {
    ENTRY_INTERNAL;
    tListType listType = ConvertLTYCountToLTY(mListType);
    tBoolean ret = (listType == LTY_CURRENT_SELECTION ||
                    listType == LTY_IPOD_QUEUE_LIST ||
                    listType == LTY_END_OF_EXTERNAL_LIST_TYPES);

    return ret;
}

int iPodControlMediaPath::GetIndexOfIPODCategory(const int cat) const
{
    ENTRY_INTERNAL;
    int ret = -1; //default error
    tListType listType = ConvertLTYCountToLTY(mListType);

    switch (cat) {
    case IPOD_CAT_PLAYLIST:
        switch (listType) {
        case LTY_PLAYLIST_SONG:
            ret = mTag1;
            break;
        default:
        	break; //all others
        }
        break;
    case IPOD_CAT_ARTIST:
        switch (listType) {
        case LTY_GENRE_ARTIST_SONG:
        case LTY_GENRE_ARTIST_ALBUM:
        case LTY_GENRE_ARTIST_ALBUM_SONG:
        case LTY_ARTIST_ALBUM:
        case LTY_ARTIST_ALBUM_SONG:
        case LTY_ARTIST_SONG:
            ret = mTag2;
            break;
        case LTY_AUTHOR_BOOKTITLE:
        case LTY_AUTHOR_BOOKTITLE_CHAPTER:
        	ret = mTag1;
        	break;
        default:
        	break; //all others
        }
        break;
    case IPOD_CAT_ALBUM:
        ret = mTag4; //PURE ALBUM TAG
        break;
    case IPOD_CAT_GENRE:
        switch (listType) {
        case LTY_GENRE_ARTIST:
        case LTY_GENRE_ARTIST_ALBUM:
        case LTY_GENRE_ARTIST_ALBUM_SONG:
        case LTY_GENRE_ARTIST_SONG:
        case LTY_GENRE_ALBUM:
        case LTY_GENRE_ALBUM_SONG:
        case LTY_GENRE_SONG:
        case LTY_VIDEO_EPISODE:
            ret = mTag1;
            break;
        default:
        	break; //all others
        }
        break;
    case IPOD_CAT_TRACK:
        switch (listType) {
        default:
        	break; //all others
        }
        break;
    case IPOD_CAT_COMPOSER:
    	ret = mTag3; //PURE COMPOSER TAG
    	break;
    case IPOD_CAT_AUDIOBOOK:
        switch (listType) {
        case LTY_BOOKTITLE_CHAPTER:
        case LTY_AUTHOR_BOOKTITLE_CHAPTER:
            ret = mTag2;
            break;
        default:
        	break; //all others
        }
        break;
    case IPOD_CAT_PODCAST:
        switch (listType) {
        case LTY_PODCAST_EPISODE:
            ret = mTag1;
            break;
        default:
        	break; //all others
        }
        break;
    default:
        ETG_TRACE_ERR(("iPodControlMediaPath::GetIndexOfIPODCategory() unknown IPOD_CATEGORY %d", cat));
        break;
    }

    return ret;
}

int iPodControlMediaPath::GetCurrentIPODCategory() const
{
    ENTRY_INTERNAL;
    int ret = -1; //default error
    tListType listType = ConvertLTYCountToLTY(mListType);

    switch (listType) {
    case LTY_GENRE:
    case LTY_VIDEO:
        ret = IPOD_CAT_GENRE;
        break;
    case LTY_ARTIST:
    case LTY_GENRE_ARTIST:
    case LTY_AUTHOR:
        ret = IPOD_CAT_ARTIST;
        break;
    case LTY_ALBUM:
    case LTY_GENRE_ARTIST_ALBUM:
    case LTY_GENRE_ALBUM:
    case LTY_ARTIST_ALBUM:
    case LTY_COMPOSER_ALBUM:
    case LTY_COMPILATION:
        ret = IPOD_CAT_ALBUM;
        break;
    case LTY_SONG:
    case LTY_GENRE_ARTIST_ALBUM_SONG:
    case LTY_GENRE_ARTIST_SONG:
    case LTY_GENRE_ALBUM_SONG:
    case LTY_GENRE_SONG:
    case LTY_ARTIST_ALBUM_SONG:
    case LTY_ARTIST_SONG:
    case LTY_ALBUM_SONG:
    case LTY_PODCAST_EPISODE:
    case LTY_COMPOSER_ALBUM_SONG:
    case LTY_COMPOSER_SONG:
    case LTY_VIDEO_EPISODE:
    case LTY_PLAYLIST_SONG:
    case LTY_CURRENT_SELECTION:
    case LTY_COMPILATION_SONG:
        ret = IPOD_CAT_TRACK;
        break;
    case LTY_PODCAST:
        ret = IPOD_CAT_PODCAST;
        break;
    case LTY_AUDIOBOOK:
    case LTY_BOOKTITLE_CHAPTER:
    case LTY_AUTHOR_BOOKTITLE:
    case LTY_AUTHOR_BOOKTITLE_CHAPTER:
        ret = IPOD_CAT_AUDIOBOOK;
        break;
    case LTY_COMPOSER:
        ret = IPOD_CAT_COMPOSER;
        break;
    case LTY_PLAYLIST:
        ret = IPOD_CAT_PLAYLIST;
        break;
    default:
        ETG_TRACE_ERR(("iPodControlMediaPath::GetCurrentIPODCategory() NO IPOD_CATEGORY found for list type %d", mListType));
        break;
    }

    return ret;
}

void iPodControlMediaPath::GetURL(tURL &url, const int trackIndex,
		const int chapterIndex, const tU64 uuid, const tU64 parentUuid, const char* name, const int specialID) const {
	ENTRY_INTERNAL;
	tMountPoint hiddev = { 0 };
	SMF::MarshalToUtf8(url, sizeof(url) - 1, IPODCONTROL_MARSHAL_SEPARATOR,
			IPODCONTROL_MARSHAL_FORMAT, hiddev, mListType, mTag1, mTag2, mTag3, mTag4,
			trackIndex, chapterIndex, uuid, parentUuid, name, specialID);
}

tListType iPodControlMediaPath::ConvertLTYCountToLTY(const tListType listType) const
{
    ENTRY_INTERNAL;
    tListType ret = listType;

    switch (listType) {
        case LTY_GENRE_COUNT:
            ret = LTY_GENRE;
            break;
        case LTY_ARTIST_COUNT:
            ret = LTY_ARTIST;
            break;
        case LTY_ALBUM_COUNT:
            ret = LTY_ALBUM;
            break;
        case LTY_SONG_COUNT:
            ret = LTY_SONG;
            break;
        case LTY_GENRE_ARTIST_COUNT:
            ret = LTY_GENRE_ARTIST;
            break;
        case LTY_GENRE_ARTIST_ALBUM_COUNT:
            ret = LTY_GENRE_ARTIST_ALBUM;
            break;
        case LTY_GENRE_ARTIST_ALBUM_SONG_COUNT:
            ret = LTY_GENRE_ARTIST_ALBUM_SONG;
            break;
        case LTY_GENRE_ARTIST_SONG_COUNT:
            ret = LTY_GENRE_ARTIST_SONG;
            break;
        case LTY_GENRE_ALBUM_COUNT:
            ret = LTY_GENRE_ALBUM;
            break;
        case LTY_GENRE_ALBUM_SONG_COUNT:
            ret = LTY_GENRE_ALBUM_SONG;
            break;
        case LTY_GENRE_SONG_COUNT:
            ret = LTY_GENRE_SONG;
            break;
        case LTY_ARTIST_ALBUM_COUNT:
            ret = LTY_ARTIST_ALBUM;
            break;
        case LTY_ARTIST_ALBUM_SONG_COUNT:
            ret = LTY_ARTIST_ALBUM_SONG;
            break;
        case LTY_ARTIST_SONG_COUNT:
            ret = LTY_ARTIST_SONG;
            break;
        case LTY_ALBUM_SONG_COUNT:
            ret = LTY_ALBUM_SONG;
            break;
        case LTY_PODCAST_COUNT:
            ret = LTY_PODCAST;
            break;
        case LTY_PODCAST_EPISODE_COUNT:
            ret = LTY_PODCAST_EPISODE;
            break;
        case LTY_AUDIOBOOK_COUNT:
            ret = LTY_AUDIOBOOK;
            break;
        case LTY_BOOKTITLE_CHAPTER_COUNT:
            ret = LTY_BOOKTITLE_CHAPTER;
            break;
        case LTY_AUTHOR_COUNT:
            ret = LTY_AUTHOR;
            break;
        case LTY_AUTHOR_BOOKTITLE_COUNT:
            ret = LTY_AUTHOR_BOOKTITLE;
            break;
        case LTY_AUTHOR_BOOKTITLE_CHAPTER_COUNT:
            ret = LTY_AUTHOR_BOOKTITLE_CHAPTER;
            break;
        case LTY_COMPOSER_COUNT:
            ret = LTY_COMPOSER;
            break;
        case LTY_COMPOSER_ALBUM_COUNT:
            ret = LTY_COMPOSER_ALBUM;
            break;
        case LTY_COMPOSER_ALBUM_SONG_COUNT:
            ret = LTY_COMPOSER_ALBUM_SONG;
            break;
        case LTY_COMPOSER_SONG_COUNT:
            ret = LTY_COMPOSER_SONG;
            break;
        case LTY_VIDEO_COUNT:
            ret = LTY_VIDEO;
            break;
        case LTY_VIDEO_EPISODE_COUNT:
            ret = LTY_VIDEO_EPISODE;
            break;
        case LTY_PLAYLIST_COUNT:
            ret = LTY_PLAYLIST;
            break;
        case LTY_PLAYLIST_SONG_COUNT:
            ret = LTY_PLAYLIST_SONG;
            break;
        case LTY_CURRENT_SELECTION_COUNT:
            ret = LTY_CURRENT_SELECTION;
            break;
        case LTY_COMPILATION_COUNT:
            ret = LTY_COMPILATION;
            break;
        case LTY_COMPILATION_SONG_COUNT:
            ret = LTY_COMPILATION_SONG;
            break;
        default:
        	break;
        }
        return ret;
}

tListType iPodControlMediaPath::ConvertLTYToLTYCount(const tListType listType) const {
    ENTRY_INTERNAL;
    tListType ret = listType;

    switch (listType) {
    case LTY_GENRE:
        ret = LTY_GENRE_COUNT;
        break;
    case LTY_ARTIST:
        ret = LTY_ARTIST_COUNT;
        break;
    case LTY_ALBUM:
        ret = LTY_ALBUM_COUNT;
        break;
    case LTY_SONG:
        ret = LTY_SONG_COUNT;
        break;
    case LTY_GENRE_ARTIST:
        ret = LTY_GENRE_ARTIST_COUNT;
        break;
    case LTY_GENRE_ARTIST_ALBUM:
        ret = LTY_GENRE_ARTIST_ALBUM_COUNT;
        break;
    case LTY_GENRE_ARTIST_ALBUM_SONG:
        ret = LTY_GENRE_ARTIST_ALBUM_SONG_COUNT;
        break;
    case LTY_GENRE_ARTIST_SONG:
        ret = LTY_GENRE_ARTIST_SONG_COUNT;
        break;
    case LTY_GENRE_ALBUM:
        ret = LTY_GENRE_ALBUM_COUNT;
        break;
    case LTY_GENRE_ALBUM_SONG:
        ret = LTY_GENRE_ALBUM_SONG_COUNT;
        break;
    case LTY_GENRE_SONG:
        ret = LTY_GENRE_SONG_COUNT;
        break;
    case LTY_ARTIST_ALBUM:
        ret = LTY_ARTIST_ALBUM_COUNT;
        break;
    case LTY_ARTIST_ALBUM_SONG:
        ret = LTY_ARTIST_ALBUM_SONG_COUNT;
        break;
    case LTY_ARTIST_SONG:
        ret = LTY_ARTIST_SONG_COUNT;
        break;
    case LTY_ALBUM_SONG:
        ret = LTY_ALBUM_SONG_COUNT;
        break;
    case LTY_PODCAST:
        ret = LTY_PODCAST_COUNT;
        break;
    case LTY_PODCAST_EPISODE:
        ret = LTY_PODCAST_EPISODE_COUNT;
        break;
    case LTY_AUDIOBOOK:
        ret = LTY_AUDIOBOOK_COUNT;
        break;
    case LTY_BOOKTITLE_CHAPTER:
        ret = LTY_BOOKTITLE_CHAPTER_COUNT;
        break;
    case LTY_AUTHOR:
        ret = LTY_AUTHOR_COUNT;
        break;
    case LTY_AUTHOR_BOOKTITLE:
        ret = LTY_AUTHOR_BOOKTITLE_COUNT;
        break;
    case LTY_AUTHOR_BOOKTITLE_CHAPTER:
        ret = LTY_AUTHOR_BOOKTITLE_CHAPTER_COUNT;
        break;
    case LTY_COMPOSER:
        ret = LTY_COMPOSER_COUNT;
        break;
    case LTY_COMPOSER_ALBUM:
        ret = LTY_COMPOSER_ALBUM_COUNT;
        break;
    case LTY_COMPOSER_ALBUM_SONG:
        ret = LTY_COMPOSER_ALBUM_SONG_COUNT;
        break;
    case LTY_COMPOSER_SONG:
        ret = LTY_COMPOSER_SONG_COUNT;
        break;
    case LTY_VIDEO:
        ret = LTY_VIDEO_COUNT;
        break;
    case LTY_VIDEO_EPISODE:
        ret = LTY_VIDEO_EPISODE_COUNT;
        break;
    case LTY_PLAYLIST:
        ret = LTY_PLAYLIST_COUNT;
        break;
    case LTY_PLAYLIST_SONG:
        ret = LTY_PLAYLIST_SONG_COUNT;
        break;
    case LTY_CURRENT_SELECTION:
        ret = LTY_CURRENT_SELECTION_COUNT;
        break;
    case LTY_COMPILATION:
        ret = LTY_COMPILATION_COUNT;
        break;
    case LTY_COMPILATION_SONG:
        ret = LTY_COMPILATION_SONG_COUNT;
        break;
    default:
    	break;
    }
    return ret;
}

int iPodControlMediaPath::GetCurrentCount() const
{
	return GetCount(GetCurrentIPODCategory());
}

void iPodControlMediaPath::SetCurrentCount(const int count)
{
	SetCount(GetCurrentIPODCategory(), count);
}

int iPodControlMediaPath::GetCount(const int category) const
{
	tIPODCategoryCounts::const_iterator it = mCounts.find(category);
	if(it != mCounts.end()) {
		return it->second;
	}
	return 0;
}

void iPodControlMediaPath::SetCount(const int category, const int count)
{
	mCounts[category] = count;
}

string iPodControlMediaPath::GetName(const int category) const
{
	tIPODCategoryNames::const_iterator it = mNames.find(category);
	if (it != mNames.end()) {
		return it->second;
	}
	return "";
}

void iPodControlMediaPath::SetName(const int category, const string str)
{
	mNames[category] = str;
}

void iPodControlMediaPath::ResetSelection() {
	mCounts[IPOD_CAT_PLAYLIST] = 0;
	mCounts[IPOD_CAT_ARTIST] = 0;
	mCounts[IPOD_CAT_ALBUM] = 0;
	mCounts[IPOD_CAT_GENRE] = 0;
	mCounts[IPOD_CAT_TRACK] = 0;
	mCounts[IPOD_CAT_COMPOSER] = 0;
	mCounts[IPOD_CAT_AUDIOBOOK] = 0;
	mCounts[IPOD_CAT_PODCAST] = 0;
	mCounts[IPOD_CAT_NESTED_PLAYLIST] = 0;

	mNames[IPOD_CAT_PLAYLIST] = "";
	mNames[IPOD_CAT_ARTIST] = "";
	mNames[IPOD_CAT_ALBUM] = "";
	mNames[IPOD_CAT_GENRE] = "";
	mNames[IPOD_CAT_TRACK] = "";
	mNames[IPOD_CAT_COMPOSER] = "";
	mNames[IPOD_CAT_AUDIOBOOK] = "";
	mNames[IPOD_CAT_PODCAST] = "";
	mNames[IPOD_CAT_NESTED_PLAYLIST] = "";
}

tBoolean iPodControlMediaPath::Increment() {
	//set next path for indexing purpose
	//incrementing indices in the database hierarchy
	//NOTE: After single increment step a new iPodControlIAP::SelectRecord call
	//      is necessary in order to update the map for mCount and mName

	ENTRY_INTERNAL;
	tBoolean ret = true;
	tListType listType = ConvertLTYCountToLTY(mListType);

	switch (listType) {
	case LTY_GENRE_ARTIST_ALBUM_SONG:
		if(mTag1 < 0 || mTag2 < 0 || mTag2 < 0) {
			ETG_TRACE_ERR(("%s - Invalid tags", __PRETTY_FUNCTION__));
			VARTRACE(mTag1);
			VARTRACE(mTag2);
			VARTRACE(mTag4);
			ret = false;
		} else if(mTag4 < (GetCount(IPOD_CAT_ALBUM)-1)) {
			mTag4++; //increment album
		} else if(mTag2 < (GetCount(IPOD_CAT_ARTIST)-1)) {
			mTag2++; //increment artist
			mTag4 = 0;
		} else if(mTag1 < (GetCount(IPOD_CAT_GENRE)-1)) {
			mTag1++; //increment genre
			mTag2 = 0;
			mTag4 = 0;
		} else {
			//reached end of possible selections
			ret = false;
		}
		break;
	case LTY_VIDEO_EPISODE:
		if (mTag1 < 0) {
			ETG_TRACE_ERR(("%s - Invalid tags", __PRETTY_FUNCTION__));
			VARTRACE(mTag1);
			ret = false;
		} else if (mTag1 < (GetCount(IPOD_CAT_GENRE) - 1)) {
			mTag1++; //increment genre
		} else {
			//reached end of possible selections
			ret = false;
		}
		break;
	case LTY_PLAYLIST:
		//reached end of possible selections
		ret = false;
		break;
	default:
		ETG_TRACE_ERR(("%s - unsupported LTY for incrementation to next path", __PRETTY_FUNCTION__));
		VARTRACE(listType);
		ret = false;
		break;
	}
	return ret;
}

