#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_IPOD_CONTROL
#ifdef TARGET_BUILD
#include "trcGenProj/Header/iPodControlIAP.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_IPOD_CONTROL
#endif
#endif

#include <string.h>
#include "FunctionTracer.h"
#include "VarTrace.h"
#include "iPodControlIAP.h"
#include "LocalSPM.h"
#include "MediaPlayer_ErrorCodes.h"
#include "BTDaemonProxy.h"
#include <unistd.h> //usleep()
#include <libudev.h> //role switch
#include <libusb-1.0/libusb.h>
#include <sys/syscall.h>
#include <sys/utsname.h>
#include <sys/mount.h>
#include <sys/time.h>
#include <glob.h>

#ifdef VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
#ifndef _FC_MEDIAPLAYER_ROOTDAEMON_CLIENT_H_
#include "FC_MediaPlayer_rootdaemon_client.h"
#endif
#else
#include "GMPCommands.h"
#endif

#define MAX_REPEAT_MODES 5
#define IAP2_ROUTE_GUIDANCE_LENGTH_VAL 127

#ifdef TARGET_BUILD
# include <libkmod.h> //load modules gadget fs
#endif

#ifdef IAP1_DLT_ENABLE
#ifdef __cplusplus
extern "C" {
#endif
# include "iap1_dlt_log.h"
#ifdef __cplusplus
}
#endif
#endif

#ifdef IAP2_DLT_ENABLE
#ifdef __cplusplus
extern "C" {
#endif
# include "iap2_dlt_log.h"
#ifdef __cplusplus
}
#endif
#endif
#ifdef IPODCONTROL_IAP2_PF_AVAIL

const U8 iPodControlIAP::sHIDReportDescriptor[] = {
    0x05, 0x0C, //USAGE PAGE (CONSUMER Device)
    0x09, 0x01, //USAGE (Consumer Control)
    0xA1, 0x01, //COLLECTION (Application)
    0x15, 0x00, //  LOGICAL MINIMUM (0)
    0x25, 0x01, //  LOGICAL MAXIMUM (1)
    0x75, 0x01, //  REPORT SIZE (1)
    0x95, 0x06, //  REPORT COUNT (6)
    0x09, 0xB0, //  USAGE (Play)
    0x09, 0xB1, //  USAGE (Pause)
    0x09, 0xB5, //  USAGE (Scan Next Track)
    0x09, 0xB6, //  USAGE (Scan Previous Track)
    0x09, 0xB9, //  USAGE (Shuffle)
    0x09, 0xBC, //  USAGE (Repeat)
    0x81, 0x02, //  INPUT (Date,Var,Abs)
    0x75, 0x02, //  REPORT SIZE (2)
    0x95, 0x01, //  REPORT COUNT (1)
    0x81, 0x03, //  INPUT (Cnst,Var,Abs)
    0xC0        //END COLLECTION
};

const U8 iPodControlIAP::sHIDReportDescriptor_NoRepeat[] = {
    0x05, 0x0C, //USAGE PAGE (CONSUMER Device)
    0x09, 0x01, //USAGE (Consumer Control)
    0xA1, 0x01, //COLLECTION (Application)
    0x15, 0x00, //  LOGICAL MINIMUM (0)
    0x25, 0x01, //  LOGICAL MAXIMUM (1)
    0x75, 0x01, //  REPORT SIZE (1)
    0x95, 0x05, //  REPORT COUNT (5)
    0x09, 0xB0, //  USAGE (Play)
    0x09, 0xB1, //  USAGE (Pause)
    0x09, 0xB5, //  USAGE (Scan Next Track)
    0x09, 0xB6, //  USAGE (Scan Previous Track)
    0x09, 0xB9, //  USAGE (Shuffle)
    0x81, 0x02, //  INPUT (Date,Var,Abs)
    0x75, 0x03, //  REPORT SIZE (3)
    0x95, 0x01, //  REPORT COUNT (1)
    0x81, 0x03, //  INPUT (Cnst,Var,Abs)
    0xC0        //END COLLECTION
};

const iAP2USBDeviceModeAudioSampleRate iPodControlIAP::USBDeviceSupportedAudioSampleRate[] = {\
        IAP2_SAMPLERATE_8000HZ,     \
        IAP2_SAMPLERATE_11025HZ,    \
        IAP2_SAMPLERATE_12000HZ,    \
        IAP2_SAMPLERATE_16000HZ,    \
        IAP2_SAMPLERATE_22050HZ,    \
        IAP2_SAMPLERATE_24000HZ,    \
        IAP2_SAMPLERATE_32000HZ,    \
        IAP2_SAMPLERATE_44100HZ,    \
        IAP2_SAMPLERATE_48000HZ     \
};
#endif





vector<string> iPodControlIAP::sKnownUSBiAP1Devices; //GMMY16-18313



/*lint -save -e578 "Declaration of symbol 'count' hides symbol 'std::count() */

//********************* PUBLIC ***********************************************
iPodControlIAP::iPodControlIAP()
: m_IAP1Init(IPOD_ERROR)
, m_NotificationMask(0x80604) //2:flow control, 9:DB changes, 10:FocusApp changes, 19:FocusDisplayApp changes
, m_RemoteEventNotificationMask(0x180) //7:shuffle, 8:repeat
{
    ENTRY;
    m_MountPoint[0] = 0;
}

iPodControlIAP::~iPodControlIAP() {
    ENTRY;
}

//Init
tResult iPodControlIAP::iAP1_Init() {
    ENTRY;
    int res = IPOD_OK;

#ifdef IAP1_DLT_ENABLE
    IAP1REGISTERAPPWITHDLT("IAP1", "iAP1 Logging");
    IAP1REGISTERCTXTWITHDLT();
#endif
    if (m_IAP1Init != IPOD_OK) {

        //Register IAP1 callbacks
        res = (int) iPodRegisterCBUSBDetach(CBIAP1_USBDetach);
        if (IPOD_OK != res) {
            ETG_TRACE_ERR(("iPodRegisterCBUSBDetach failed %d')", res));
        }
        res = (int) iPodRegisterCBUSBAttach(CBIAP1_USBAttach);
        if (IPOD_OK != res) {
            ETG_TRACE_ERR(("iPodRegisterCBUSBAttach failed %d')", res));
        }
        res = (int) iPodRegisterCBNotification(CBIAP1_Notification);
        if (IPOD_OK != res) {
            ETG_TRACE_ERR(("iPodRegisterCBNotification failed %d')", res));
        }
#ifdef TARGET_BUILD_GEN3
        res = (int) iPodRegisterCBRemoteEventNotification(CBIAP1_RemoteEventNotification);
        if (IPOD_OK != res) {
            ETG_TRACE_ERR(("iPodRegisterCBRemoteEventNotification failed %d')", res));
        }
#endif
        res = (int) iPodRegisterCBNotifyStatus(CBIAP1_NotifyStatus);
        if (IPOD_OK != res) {
            ETG_TRACE_ERR(("iPodRegisterCBNotifyStatus failed %d')", res));
        }
        res = (int) iPodRegisterCBNotifyStateChange(CBIAP1_NotifyStateChange);
        if (IPOD_OK != res) {
            ETG_TRACE_ERR(("iPodRegisterCBNotifyStateChange failed %d')", res));
        }
        res = (int) iPodRegisterCBNewiPodTrackInfo(CBIAP1_NewiPodTrackInfo);
        if (IPOD_OK != res) {
            ETG_TRACE_ERR(("iPodRegisterCBNewiPodTrackInfo failed %d')", res));
        }
        res = (int) iPodRegisterCBOpenDataSession(CBIAP1_OpenDataSession);
        if (IPOD_OK != res) {
            ETG_TRACE_ERR(("iPodRegisterCBOpenDataSession failed %d')", res));
        }
        res = (int) iPodRegisterCBCloseDataSession(CBIAP1_CloseDataSession);
        if (IPOD_OK != res) {
            ETG_TRACE_ERR(("iPodRegisterCBCloseDataSession failed %d')", res));
        }
        res = (int) iPodRegisterCBiPodDataTransfer(CBIAP1_DataTransfer);
        if (IPOD_OK != res) {
            ETG_TRACE_ERR(("iPodRegisterCBiPodDataTransfer failed %d')", res));
        }

        //IAP1 Init
        m_IAP1Init = (int) iPodInitConnection();
        ETG_TRACE_USR3(("iPodInitConnection() returned %d", m_IAP1Init));

        if (IPOD_OK == m_IAP1Init) {
            tGeneralString accName = {0};
            tGeneralString accManufacturer = {0};
            tGeneralString accModelNumber = {0};
            tGeneralString accSerialNumber = {0};

            strncpy_r(accName, LocalSPM::GetDataProvider().iPodControlAccessoryInfoModelName().c_str(), sizeof(accName));
            strncpy_r(accManufacturer, LocalSPM::GetDataProvider().iPodControlAccessoryInfoManufacturer().c_str(), sizeof(accManufacturer));
            strncpy_r(accModelNumber, LocalSPM::GetDataProvider().iPodControlAccessoryInfoModelNumber().c_str(), sizeof(accModelNumber));
            strncpy_r(accSerialNumber, LocalSPM::GetDataProvider().iPodControlAccessoryInfoSerialNumber().c_str(), sizeof(accSerialNumber));

            IPOD_ACC_INFO_CONFIGURATION accInfo = { 0 };
            accInfo.Name = (U8*) accName;
            accInfo.Hardware_version.Major_Number = 1;
            accInfo.Software_version.Major_Number = 1;
            accInfo.Manufacturer = (U8*) accManufacturer;
            accInfo.ModelNumber = (U8*) accModelNumber;
            accInfo.SerialNumber = (U8*) accSerialNumber;

            VARTRACE((char*)accInfo.Name);
            VARTRACE((char*)accInfo.Manufacturer);
            VARTRACE((char*)accInfo.ModelNumber);
            VARTRACE((char*)accInfo.SerialNumber);

            res = iPodInitAccessoryConnection(accInfo);
            ETG_TRACE_USR3(("iPodInitAccessoryConnection() returned %d", res));
        } else {
            ETG_TRACE_ERR(("iPodControlIAP::iAP1Init() - failed"));
            return MP_ERR_IPOD_INIT;
        }
        //GMMY16-18313
        mKnownUSBiAP1Devices = sKnownUSBiAP1Devices;
        VARTRACE((int)(long)mKnownUSBiAP1Devices.size()); // thoemel: the additional casting is due to 64 bit compiler
    } else {
        ETG_TRACE_USR3(("iPodControlIAP::iAP1Init() - already initialized"));
    }
    return MP_NO_ERROR;
}

tResult iPodControlIAP::iAP2_Init() {
    ENTRY;
    mHostModeErrorCount.clear();
    //no general init required for IAP2
#ifdef IAP2_DLT_ENABLE
    IAP2REGISTERAPPWITHDLT("IAP2", "iAP2 Logging");
    IAP2REGISTERCTXTWITHDLT();
#endif
    return MP_NO_ERROR;
}

void iPodControlIAP::iAP1_DeInit() {
    ENTRY;

    //clear open connections first
    DisconnectAllOpenIAPConnections();

    if (IPOD_OK == m_IAP1Init) {
#if 1
        iPodDisconnect();
        m_IAP1Init = IPOD_ERROR; //reset member
#endif
    } else {
        ETG_TRACE_USR3(("iPodControlIAP::iAP1DeInit() - IAP1 not yet initialized"));
    }
#ifdef IAP1_DLT_ENABLE
    IAP1DEREGISTERCTXTWITHDLT();
    IAP1DEREGISTERAPPWITHDLT();
#endif
}

void iPodControlIAP::iAP2_DeInit() {
    ENTRY;

    //clear open connections first
    DisconnectAllOpenIAPConnections();
#ifdef IAP2_DLT_ENABLE
    IAP2DEREGISTERCTXTWITHDLT();
    IAP2DEREGISTERAPPWITHDLT();
#endif
}

void iPodControlIAP::iAP2_PollFDs(const tMountPoint mountPoint) {
    ENTRY;
    VARTRACE(mountPoint);

    if(mountPoint == NULL) {
        ETG_TRACE_ERR(("mountPoint == NULL"));
        //clear thread index
        //m_HandleMap.SetPollThreadIndex(mountPoint, -1);
        return;
    }

#ifdef IPODCONTROL_IAP2_PF_AVAIL

    int res = IAP2_OK;
    void *context;
    iAP2Device_t * iap2Device = NULL;
    iAP2GetPollFDs_t getPollFDs;
    memset(&getPollFDs, 0, sizeof(iAP2GetPollFDs_t));
    int nfds = 0;       /* highest-numbered file descriptor in any of the three sets, plus 1 */
    fd_set read_fds;    /* will be watched to see if characters become available for reading */
    fd_set write_fds;
    timeval tv;

    m_HandleMap.LockIAP2(mountPoint); //start critical section
    iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(mountPoint);
    if(iap2Device) {
        res = iAP2GetPollFDs(iap2Device, &getPollFDs);
        ETG_TRACE_USR3(("iAP2GetPollFDs returned %d", res));
        if(IAP2_OK == res) {
            /* FD_ZERO() clears out the fd_set, so it doesn't contain any file descriptors */
            FD_ZERO(&read_fds);
            FD_ZERO(&write_fds);
            res = iAP2_PrepareFDsForPolling(&getPollFDs, &nfds, &read_fds, &write_fds);
            ETG_TRACE_USR3(("iAP2HandleEvent returned %d", res));
        }
        else {
            UpdateIpodCommunicationError(res);
        }
    } else {
        ETG_TRACE_ERR(("%d ### POLLING IAP2 - iap2Device == NULL", (int)pthread_self()));
    }
    m_HandleMap.UnlockIAP2(mountPoint); //end critical section



    while(iap2Device && res == IAP2_OK && getPollFDs.fds != NULL) {
        ETG_TRACE_USR4(("%d ### POLLING IAP2 DEVICE: %s", (int)pthread_self(), mountPoint));

        /* Wait up to five seconds. */
        tv.tv_sec = IPODCONTROL_IAP2_POLL_TIMEOUT_SECS;
        tv.tv_usec = 0;
        int desc_ready = select(nfds+1, &read_fds, &write_fds, NULL, &tv); //see http://linux.die.net/man/2/select
        //VARTRACE(desc_ready);
        ETG_TRACE_USR3(("%d ### desc_ready %d", (int)pthread_self(), desc_ready));
        /* Don't rely on the value of tv now! */

        if(desc_ready < 0) {
            /* desc_ready = 0 : select() timed out
             * desc_ready < 0 : indicates an error (check errno)
             */
            //EBADF 9  /* Bad file number */
            ETG_TRACE_ERR(("%d ### POLLING IAP2 - select failed, errno %d", (int)pthread_self(), errno));
            if(errno != SELECT_EINTR) { //ignore Interrupted system call
                if(errno == SELECT_EBADF) // send disconnection when bad file error is received(NCG3D-89502)
                {
                    m_HandleMap.SetPollThreadIndex(mountPoint, -1); // goa5kor for NCG3D-89502
                    LocalSPM::GetIPODControl().OnCBIAP2_DeviceState(iap2Device, iAP2NotConnected, context);
                }
                break;
            }
        }
        if(desc_ready == 0)                 //When select call times out with 0 as vlaue, polling will stop for disconnected device to avoid invalid FD vlaues.(NCG3D-111347)
        {
            tConnectionState connectionState = m_HandleMap.GetConnectionState(mountPoint);
            VARTRACE(connectionState);
            if((connectionState == CS_DISCONNECTED || connectionState == CS_UNSUPPORTED))
            {
                ETG_TRACE_USR3(("%d ### POLLING IAP2 - Select timed out with errno %d - Polling stops", (int)pthread_self(), desc_ready));
                break;
            }
        }

        m_HandleMap.LockIAP2(mountPoint); //start critical section
        iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(mountPoint);
        if(iap2Device) {
            if(desc_ready > 0 ){
                tConnectionState connectionState = m_HandleMap.GetConnectionState(mountPoint);
                VARTRACE(connectionState);
                if((CS_DISCONNECTED != connectionState) && (getPollFDs.fds != NULL)) { // NCG3D-132803: Disconnection happens after select.
                    for(int i = 0; (i < getPollFDs.numberFDs) && (desc_ready > 0) && !res; i++) {
                        ETG_TRACE_USR3(("%d ### Polling FD %d", (int)pthread_self(), getPollFDs.fds[i].fd));
                        if(FD_ISSET(getPollFDs.fds[i].fd, &read_fds)) {
                            ETG_TRACE_USR3(("%d ### POLLING IAP2 - READ EVENT FD %d", (int)pthread_self(), getPollFDs.fds[i].fd));
                            res = iAP2HandleEvent(iap2Device, getPollFDs.fds[i].fd, getPollFDs.fds[i].event);
                            desc_ready--;
                        } else if(FD_ISSET(getPollFDs.fds[i].fd, &write_fds) ) {
                            ETG_TRACE_USR3(("%d ### POLLING IAP2 - WRITE EVENT FD %d", (int)pthread_self(), getPollFDs.fds[i].fd));
                            res = iAP2HandleEvent(iap2Device, getPollFDs.fds[i].fd, getPollFDs.fds[i].event);
                            desc_ready--;
                        }
                        if(IAP2_OK != res) {
                            ETG_TRACE_USR3(("iAP2HandleEvent failed %d", res));
                            UpdateIpodCommunicationError(res);
                            if(res == IAP2_DEV_NOT_CONNECTED) {
                                ETG_TRACE_USR3(("Exiting poll loop"));
                            } else {
                                res = IAP2_OK;  //Not designed to break on any iAP2HandleEvent ERRORS
                            }
                        }
                    }
                    if(desc_ready) {
                        ETG_TRACE_ERR(("%d ### POLLING IAP2 - UNHANDLED EVENTS: %d", (int)pthread_self(), desc_ready));
                    }
                }
                else {
                    ETG_TRACE_USR3(("%d ### POLLING IAP2 - fds == NULL or CS_DISCONNECTED, Polling breaks:", (int)pthread_self()));
                    m_HandleMap.UnlockIAP2(mountPoint); // Stop critical section before breaking the loop.
                    break;
                }
            }
            if(IAP2_OK == res) {
                //prepare next loop
                /* FD_ZERO() clears out the fd_set, so it doesn't contain any file descriptors */
                FD_ZERO(&read_fds);
                FD_ZERO(&write_fds);
                res = iAP2_PrepareFDsForPolling(&getPollFDs, &nfds, &read_fds, &write_fds);
                if(IAP2_OK != res) {
                    ETG_TRACE_ERR(("iAP2_PrepareFDsForPolling failed %d", res));
                    tConnectionState connectionState = m_HandleMap.GetConnectionState(mountPoint);
                    VARTRACE(connectionState);
                    if(connectionState == CS_CONNECTED || connectionState == CS_ATTACHED)         // When FD value is invalid, breaks out of Polling loop and disconnect device (NCG3D-111347)
                    {
                        LocalSPM::GetIPODControl().OnCBIAP2_DeviceState(iap2Device, iAP2NotConnected, context);
                    }
                    m_HandleMap.UnlockIAP2(mountPoint); // Stop critical section before breaking the loop. //NCG3D-134843
                    break;
                }
            } else {
                ETG_TRACE_USR3(("%d ### POLLING IAP2 - iAP2HandleEvent - Polling stops", (int)pthread_self()));
            }
        } else {
            //valid on IAP2 device disconnection
            ETG_TRACE_USR3(("%d ### POLLING IAP2 - iap2Device == NULL - Polling stops", (int)pthread_self()));
        }
        m_HandleMap.UnlockIAP2(mountPoint); //start critical section
    }

#endif
    //clear thread index
    m_HandleMap.SetPollThreadIndex(mountPoint, -1);
}

#ifdef IPODCONTROL_IAP2_PF_AVAIL
int iPodControlIAP::iAP2_PrepareFDsForPolling(iAP2GetPollFDs_t* getPollFDs, int* maxfd, fd_set* to_readfds, fd_set* to_writefds)
{
    ENTRY_INTERNAL;

    if((getPollFDs == NULL) || (getPollFDs->fds == NULL) || (to_readfds == NULL) || (to_writefds == NULL) || (maxfd == NULL)) {
        return IAP2_CTL_ERROR;
    } else {
        /* adds the file descriptors to the fd_set */
        for(int i = 0; i < getPollFDs->numberFDs; i++) {

            if(getPollFDs->fds[i].fd > FD_SETSIZE)
            {
                return IAP2_CTL_ERROR;                    //FD value should be lesser than FD_SETSIZE, else polling should exit (NCG3D-111347)
            }

            /* find highest-numbered file descriptor */
            if(getPollFDs->fds[i].fd > *maxfd) {
                *maxfd = getPollFDs->fds[i].fd;
            }
            if(getPollFDs->fds[i].event == POLLIN) {
                /* FD_SET() adds the file descriptor to the fd_set */
                FD_SET(getPollFDs->fds[i].fd, to_readfds);
                //ETG_TRACE_USR3(("fd %d is set to_read_fds, event %d", getPollFDs->fds[i].fd, getPollFDs->fds[i].event));
            } else if(getPollFDs->fds[i].event == POLLOUT) {
                /* FD_SET() adds the file descriptor to the fd_set */
                FD_SET(getPollFDs->fds[i].fd, to_writefds);
                //ETG_TRACE_USR3(("fd %d is set to_write_fds, event %d", getPollFDs->fds[i].fd, getPollFDs->fds[i].event));
            } else {
                ETG_TRACE_ERR(("fd %d is used for unknown event %d", getPollFDs->fds[i].fd, getPollFDs->fds[i].event));
            }
        }
    }

    return IAP2_OK;
}
#endif

void iPodControlIAP::DisconnectAllOpenIAPConnections() {
    ENTRY;

    vector<string> mountPoints = m_HandleMap.GetAll();
    for(unsigned int i = 0; i < mountPoints.size(); i++) {
        if(!IsIAP2(mountPoints[i].c_str())) {
            iAP1_DisconnectDeviceConnection(mountPoints[i].c_str(), true);
        } else {
            //clear thread index, do not wait for any thread to finish
            m_HandleMap.SetPollThreadIndex(mountPoints[i].c_str(), -1); //GMMY16-22265
            iAP2_DisconnectDeviceConnection(mountPoints[i].c_str(), true);
        }
        //double check if all handles are reseted
        m_HandleMap.Reset(mountPoints[i].c_str(), true);
    }
}

tResult iPodControlIAP::iAPNewDevice(const tDeviceInfo deviceInfo) {
    ENTRY;
    VARTRACE(deviceInfo.mountPoint);

    if (iAP_IsDeviceHandleAvail(deviceInfo.mountPoint)) {
        ETG_TRACE_USR3(("iPod already connected"));

        //update ALSA device name in all cases [GMMY16-24687]
        m_HandleMap.UpdateHandle(deviceInfo);
        return MP_ERR_IPOD_SELECT;
    }

    m_HandleMap.AddHandle(deviceInfo);
    m_HandleMap.Reset(deviceInfo.mountPoint);

    return MP_NO_ERROR;
}

tResult iPodControlIAP::iAP1_InitDeviceConnection(const tMountPoint mountPoint)
{
    ENTRY;
    VARTRACE(mountPoint);
    tResult ret = MP_NO_ERROR;

    if (IPOD_OK != m_IAP1Init) {
        ETG_TRACE_ERR(("iAP1 library not initialized"));
        return MP_ERR_IPOD_INIT;
    }

    if(LocalSPM::GetDataProvider().iPodControlIAP1AppControlEnabled()) {
        //configure iOS AppInfo support
        if (!SetConfiOSApp(mountPoint)) {
            ETG_TRACE_ERR(("%s - SetiOSAppInfo failed", __PRETTY_FUNCTION__));
        }
    }

#ifdef TARGET_BUILD_GEN3
    const tConnectionType connectionType = m_HandleMap.GetConnectionType(mountPoint);
    int iPodID = (int) iPodInitDeviceConnection((U8*) mountPoint, connectionType == DCT_BLUETOOTH ? IPOD_BT_CONNECT : IPOD_USB_HOST_CONNECT); //lint !e1773 iap1 methode syntax issue
#else
    int iPodID = (int) iPodInitDeviceConnection((U8*) mountPoint); //lint !e1773 iap1 methode syntax issue
#endif
    if (iPodID > 0) {
        ETG_TRACE_USR3(("*** GOT IPOD ID = %d for '%s'", iPodID, mountPoint));
        m_HandleMap.SetiPodID(mountPoint, iPodID);
    } else {
        ETG_TRACE_ERR(("iPodInitDeviceConnection failed %d", iPodID));
        ret = MP_ERR_IPOD_INIT;
    }
    return ret;
}

#ifdef IPODCONTROL_IAP2_PF_AVAIL
iAP2Device_t * iPodControlIAP::iAP2_InitDeviceStructure(const tMountPoint mountPoint, const tBoolean hostMode, const tBoolean carPlay, const tBoolean nativeTransport,const tBoolean wirelessCarplay,const tBoolean carLife)
{
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(hostMode);
    VARTRACE(carPlay);
    VARTRACE(nativeTransport);
    VARTRACE(carLife);
    VARTRACE(wirelessCarplay);

    const tBoolean mySpin =  (nativeTransport && !carLife) ? true:false;
    VARTRACE(mySpin);

    tDeviceInfo deviceInfo;
    m_HandleMap.GetDeviceInfo(mountPoint, deviceInfo);
    VARTRACE(deviceInfo.connectionType);
    tBoolean isCPWActive = m_HandleMap.GetIsCPWActiveForUSBMountPoint(mountPoint);
    VARTRACE(isCPWActive);

    //set initial parameters for IAP2 connection
    iAP2InitParam_t * iAP2InitParameter = new iAP2InitParam_t;
    if(!iAP2InitParameter) return NULL;
    memset(iAP2InitParameter, 0, sizeof(iAP2InitParam_t));

    //store init parameters
    m_HandleMap.SetIAP2InitParameter(mountPoint, (iAP2InitParam_t *)iAP2InitParameter);

    //Device ID
    size_t size = sizeof(iAP2InitParameter->iAP2DeviceId);
    strncpy_r((char *)iAP2InitParameter->iAP2DeviceId, mountPoint, size);

    //AccessoryConfig
    iAP2InitParameter->p_iAP2AccessoryConfig = new iAP2AccessoryConfig_t;
    if(!iAP2InitParameter->p_iAP2AccessoryConfig) return NULL; //lint !e429 deleted by IAP2_Disconnect
    memset(iAP2InitParameter->p_iAP2AccessoryConfig, 0, sizeof(iAP2AccessoryConfig_t));

    //AccessoryInfo
    iAP2InitParameter->p_iAP2AccessoryInfo = new iAP2AccessoryInfo_t;
    if(!iAP2InitParameter->p_iAP2AccessoryInfo) return NULL; //lint !e429 deleted by IAP2_Disconnect
    memset(iAP2InitParameter->p_iAP2AccessoryInfo, 0, sizeof(iAP2AccessoryInfo_t));

    //AppInfo
    int appInfoEANativeTransportCount = 0;
    int appInfoEAPSessionCount = 0;
    vector<tIPODAppInfo> appInfoList;
    if(LocalSPM::GetDataProvider().iPodControlIAP2AppControlEnabled()) {

        if(carLife)
        {
            appInfoList = m_HandleMap.GetAppInfosFromSPI(mountPoint);
        }
        else if(LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp() && nativeTransport/*mySPIN*/)
        {
            //read appControl infos depending on iAP2 mode
            appInfoList = m_HandleMap.GetAppInfos(mountPoint, hostMode, nativeTransport);
        }
        else if(!LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp())
        {
            //read appControl infos depending on iAP2 mode
            appInfoList = m_HandleMap.GetAppInfos(mountPoint, hostMode, nativeTransport);
        }
    }
    iAP2InitParameter->p_iAP2AccessoryInfo->iAP2SupportediOSAppCount = appInfoList.size();
    size = appInfoList.size();
    if(size > 0) {
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2iOSAppInfo = new iAP2iOSAppInfo_t[size];
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2iOSAppInfo) return NULL; //lint !e429 deleted by IAP2_Disconnect
        for(unsigned int i = 0; i < appInfoList.size(); i++) {
            memset(&iAP2InitParameter->p_iAP2AccessoryInfo->iAP2iOSAppInfo[i], 0, sizeof(iAP2iOSAppInfo_t));
            iAP2InitParameter->p_iAP2AccessoryInfo->iAP2iOSAppInfo[i].iAP2iOSAppIdentifier = i+1; //count from zero
            iAP2InitParameter->p_iAP2AccessoryInfo->iAP2iOSAppInfo[i].iAP2EAPMatchAction = IAP2_NO_APP_MATCH;
            size = strnlen(appInfoList[i].protocol, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
            iAP2InitParameter->p_iAP2AccessoryInfo->iAP2iOSAppInfo[i].iAP2iOSAppName = new U8[size];
            if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2iOSAppInfo[i].iAP2iOSAppName) return NULL; //lint !e429 deleted by IAP2_Disconnect
            strncpy_r((char *)iAP2InitParameter->p_iAP2AccessoryInfo->iAP2iOSAppInfo[i].iAP2iOSAppName, appInfoList[i].protocol, size);
            if(LocalSPM::GetDataProvider().iAP2ExternalAccessoryProtocolCarPlayEnabled())
            {
                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2iOSAppInfo[i].iAP2ExternalAccessoryProtocolCarPlay = TRUE;
            }
            if(appInfoList[i].option == AIO_EA_NATIVE_TRANSPORT) {
                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2iOSAppInfo[i].iAP2EANativeTransport = TRUE;
                appInfoEANativeTransportCount++;
            } else {
                appInfoEAPSessionCount++;
            }
        }
    }
    VARTRACE(appInfoEANativeTransportCount);
    VARTRACE(appInfoEAPSessionCount);

    /*Get user configuration values from g_iAP2UserConfig */
    iAP2InitParameter->p_iAP2AccessoryConfig->iAP2iOSintheCar        = (hostMode && carPlay) ? LocalSPM::GetDataProvider().iPodControlSupportIAP2iOSInTheCar() : FALSE; //DIPO ON/OFF

    if(wirelessCarplay)
    {
#ifdef IPODCONTROL_IAP2_PF_IAP2OVERCARPLAY_AVAIL
#ifdef TARGET_BUILD
        iAP2InitParameter->p_iAP2AccessoryConfig->iAP2TransportType = iAP2OVERCARPLAY;
#endif
#endif
        iAP2InitParameter->p_iAP2AccessoryConfig->iAP2iOSintheCar  = TRUE;
    }
    else
    {
        const IPOD_OTG_TYPE otgType = m_HandleMap.GetOTGType(mountPoint);
        VARTRACE(otgType);

        if(otgType == IPOD_OTG_MOLEX)
        {
            iAP2InitParameter->p_iAP2AccessoryConfig->iAP2TransportType   = hostMode ? iAP2MULTIHOSTMODE : (deviceInfo.connectionType == DCT_BLUETOOTH ? iAP2BLUETOOTH : iAP2USBDEVICEMODE);
        }
        else
        {
            iAP2InitParameter->p_iAP2AccessoryConfig->iAP2TransportType   = hostMode ? iAP2USBHOSTMODE : (deviceInfo.connectionType == DCT_BLUETOOTH ? iAP2BLUETOOTH : iAP2USBDEVICEMODE);
        }
        VARTRACE(iAP2InitParameter->p_iAP2AccessoryConfig->iAP2TransportType);
    }
    iAP2InitParameter->p_iAP2AccessoryConfig->iAP2EANativeTransport  = appInfoEANativeTransportCount > 0 ? TRUE : FALSE;
    if(LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp() && deviceInfo.connectionType == DCT_BLUETOOTH){
        iAP2InitParameter->p_iAP2AccessoryConfig->iAP2EAPSupported       = appInfoEAPSessionCount > 0 ? TRUE : FALSE;
    }
    else if(!LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp() && !mySpin && !carLife){
        iAP2InitParameter->p_iAP2AccessoryConfig->iAP2EAPSupported       = appInfoEAPSessionCount > 0 ? TRUE : FALSE;
    }
#ifdef IPODCONTROL_IAP2_PF_CONFIGFS
    iAP2InitParameter->p_iAP2AccessoryConfig->useConfigFS            = hostMode && LocalSPM::GetDataProvider().iPodControlIAP2ConfigFSEnabled();
#endif

#ifdef IPODCONTROL_IAP2_PF_CONTROLSESSION_CONFIG    //default ControlSessionV2
    if(LocalSPM::GetDataProvider().iPodControlIAP2ControlSessionVersion() == 1) { //ControlSessionV1 - PSARCCB-9956
        iAP2InitParameter->p_iAP2AccessoryConfig->ManualLinkConfig = TRUE;
        iAP2InitParameter->p_iAP2AccessoryConfig->LinkConfig_SessionVersion = 1;
    }
#endif

    /*Set accessory Power Configuration */
    iAP2InitParameter->p_iAP2AccessoryConfig->iAP2DeviceBatteryShouldChargeIfPowerIsPresent = TRUE;
    iAP2InitParameter->p_iAP2AccessoryConfig->iAP2MaximumcurrentDrawnFromAccessory          = TRUE;
    iAP2InitParameter->p_iAP2AccessoryConfig->iAP2DeviceBatteryWillChargeIfPowerIsPresent   = TRUE;
    iAP2InitParameter->p_iAP2AccessoryConfig->iAP2AccessoryPowerMode                        = TRUE;
    iAP2InitParameter->p_iAP2AccessoryConfig->iAP2FileXferRcvAsStream                       = TRUE;
    if((LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp() && deviceInfo.connectionType == DCT_BLUETOOTH) || mySpin || carLife)
    {
        iAP2InitParameter->p_iAP2AccessoryConfig->iAP2FileXferSupported                         = FALSE;
    }
    else
    {
        iAP2InitParameter->p_iAP2AccessoryConfig->iAP2FileXferSupported                         = TRUE;
    }

    if(hostMode) {
        size = strnlen(LocalSPM::GetDataProvider().iPodControlIAP2UsbOtgGPIOPower().c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
        iAP2InitParameter->p_iAP2AccessoryConfig->iAP2UsbOtgGPIOPower = new U8[size];
        if(!iAP2InitParameter->p_iAP2AccessoryConfig->iAP2UsbOtgGPIOPower)  return NULL; //lint !e429 deleted by IAP2_Disconnect
        strncpy_r((char *)iAP2InitParameter->p_iAP2AccessoryConfig->iAP2UsbOtgGPIOPower, LocalSPM::GetDataProvider().iPodControlIAP2UsbOtgGPIOPower().c_str(), size);
    }
    iAP2InitParameter->p_iAP2AccessoryConfig->iAP2AuthenticationType = iAP2AUTHI2C;

    size = strnlen(LocalSPM::GetDataProvider().iPodControlAccessoryInfoBTName().c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
    iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryName = new U8[size];
    if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryName)  return NULL; //lint !e429 deleted by IAP2_Disconnect
    strncpy_r((char *)iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryName, LocalSPM::GetDataProvider().iPodControlAccessoryInfoBTName().c_str(), size);

    size = strnlen(LocalSPM::GetDataProvider().iPodControlAccessoryInfoModelName().c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
    iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryModelIdentifier = new U8[size];
    if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryModelIdentifier)   return NULL; //lint !e429 deleted by IAP2_Disconnect
    strncpy_r((char *)iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryModelIdentifier, LocalSPM::GetDataProvider().iPodControlAccessoryInfoModelName().c_str(), size);

    size = strnlen(LocalSPM::GetDataProvider().iPodControlAccessoryInfoManufacturer().c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
    iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryManufacturer = new U8[size];
    if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryManufacturer)  return NULL; //lint !e429 deleted by IAP2_Disconnect
    strncpy_r((char *)iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryManufacturer, LocalSPM::GetDataProvider().iPodControlAccessoryInfoManufacturer().c_str(), size);

    size = strnlen(LocalSPM::GetDataProvider().iPodControlAccessoryInfoSerialNumber().c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
    iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessorySerialNumber = new U8[size];
    if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessorySerialNumber)  return NULL; //lint !e429 deleted by IAP2_Disconnect
    strncpy_r((char *)iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessorySerialNumber, LocalSPM::GetDataProvider().iPodControlAccessoryInfoSerialNumber().c_str(), size);

    size = strnlen(LocalSPM::GetDataProvider().iPodControlAccessoryInfoFWVersion().c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
    iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryFirmwareVersion = new U8[size];
    if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryFirmwareVersion)   return NULL; //lint !e429 deleted by IAP2_Disconnect
    strncpy_r((char *)iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryFirmwareVersion, LocalSPM::GetDataProvider().iPodControlAccessoryInfoFWVersion().c_str(), size);

    size = strnlen(LocalSPM::GetDataProvider().iPodControlAccessoryInfoHWVersion().c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
    iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryHardwareVersion = new U8[size];
    if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryHardwareVersion)   return NULL; //lint !e429 deleted by IAP2_Disconnect
    strncpy_r((char *)iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryHardwareVersion, LocalSPM::GetDataProvider().iPodControlAccessoryInfoHWVersion().c_str(), size);

    size = strnlen(LocalSPM::GetDataProvider().iPodControlIAP2AccessoryVendorId().c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
    iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryVendorId = new U8[size];
    if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryVendorId)  return NULL; //lint !e429 deleted by IAP2_Disconnect
    strncpy_r((char *)iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryVendorId, LocalSPM::GetDataProvider().iPodControlIAP2AccessoryVendorId().c_str(), size);

    size = strnlen(LocalSPM::GetDataProvider().iPodControlIAP2AccessoryProductId().c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
    iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryProductId = new U8[size];
    if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryProductId) return NULL; //lint !e429 deleted by IAP2_Disconnect
    strncpy_r((char *)iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryProductId, LocalSPM::GetDataProvider().iPodControlIAP2AccessoryProductId().c_str(), size);

    size = strnlen(LocalSPM::GetDataProvider().iPodControlIAP2AccessoryBcdDevice().c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
    iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryBcdDevice = new U8[size];
    if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryBcdDevice) return NULL; //lint !e429 deleted by IAP2_Disconnect
    strncpy_r((char *)iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryBcdDevice, LocalSPM::GetDataProvider().iPodControlIAP2AccessoryBcdDevice().c_str(), size);

    size = strnlen(LocalSPM::GetDataProvider().iPodControlIAP2AccessoryInitEndPoint().c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
    iAP2InitParameter->p_iAP2AccessoryInfo->iAP2InitEndPoint = new U8[size];
    if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2InitEndPoint) return NULL; //lint !e429 deleted by IAP2_Disconnect
    strncpy_r((char *)iAP2InitParameter->p_iAP2AccessoryInfo->iAP2InitEndPoint, LocalSPM::GetDataProvider().iPodControlIAP2AccessoryInitEndPoint().c_str(), size);

    //calculated messages send by accessory to apple device
    U16 messageSend[42];
    int messageSendCount = 0;
    if(!mySpin && !carLife)
    {
        if(LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp() && deviceInfo.connectionType != DCT_BLUETOOTH)
        {
          messageSend[messageSendCount++] = IAP2_MSG_ID_START_NOW_PLAYING_UPDATES;
          messageSend[messageSendCount++] = IAP2_MSG_ID_STOP_NOW_PLAYING_UPDATES;
        }
        else if(!LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp())
        {
          messageSend[messageSendCount++] = IAP2_MSG_ID_START_NOW_PLAYING_UPDATES;
          messageSend[messageSendCount++] = IAP2_MSG_ID_STOP_NOW_PLAYING_UPDATES;
        }
    }

    if(appInfoList.size() > 0 && LocalSPM::GetDataProvider().iPodControlIAP2RequestAppLaunchEnabled()) {
        m_HandleMap.SetOption(mountPoint, hasAppLaunchOption, true);
        messageSend[messageSendCount++] = IAP2_MSG_ID_REQUEST_APP_LAUNCH;
    }

    if(((hostMode || wirelessCarplay) && !nativeTransport) && LocalSPM::GetDataProvider().iPodRouteGuidanceEnabled()) {
        messageSend[messageSendCount++] = IAP2_MSG_ID_START_ROUTE_GUIDANCE_UPDATE; //NCG3D-63574
        messageSend[messageSendCount++] = IAP2_MSG_ID_STOP_ROUTE_GUIDANCE_UPDATE; //NCG3D-63574
    }
    if((!carPlay && !wirelessCarplay && !mySpin && !carLife) || LocalSPM::GetDataProvider().iPodControlIAP2CarPlayModeEnabled()) {
        if(LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp() && deviceInfo.connectionType != DCT_BLUETOOTH)
        {
          messageSend[messageSendCount++] = IAP2_MSG_ID_START_MEDIA_LIBRARY_INFORMATION; //PSCRCCB-10105
          messageSend[messageSendCount++] = IAP2_MSG_ID_STOP_MEDIA_LIBRARY_INFORMATION; //PSCRCCB-10105
          messageSend[messageSendCount++] = IAP2_MSG_ID_START_MEDIA_LIBRARY_UPDATES; //PSCRCCB-10105
          messageSend[messageSendCount++] = IAP2_MSG_ID_STOP_MEDIA_LIBRARY_UPDATES; //PSCRCCB-10105
          messageSend[messageSendCount++] = IAP2_MSG_ID_PLAY_MEDIA_LIBRARY_CURRENT_SELECTION;
          messageSend[messageSendCount++] = IAP2_MSG_ID_PLAY_MEDIA_LIBRARY_ITEMS;
          messageSend[messageSendCount++] = IAP2_MSG_ID_PLAY_MEDIA_LIBRARY_COLLECTION;
          messageSend[messageSendCount++] = IAP2_MSG_ID_SET_NOW_PLAYING_INFORMATION;
          messageSend[messageSendCount++] = IAP2_MSG_ID_START_HID;
          messageSend[messageSendCount++] = IAP2_MSG_ID_ACCESSORY_HID_REPORT;
          messageSend[messageSendCount++] = IAP2_MSG_ID_STOP_HID;
        }
        else if(!LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp())
        {
          messageSend[messageSendCount++] = IAP2_MSG_ID_START_MEDIA_LIBRARY_INFORMATION; //PSCRCCB-10105
          messageSend[messageSendCount++] = IAP2_MSG_ID_STOP_MEDIA_LIBRARY_INFORMATION; //PSCRCCB-10105
          messageSend[messageSendCount++] = IAP2_MSG_ID_START_MEDIA_LIBRARY_UPDATES; //PSCRCCB-10105
          messageSend[messageSendCount++] = IAP2_MSG_ID_STOP_MEDIA_LIBRARY_UPDATES; //PSCRCCB-10105
          messageSend[messageSendCount++] = IAP2_MSG_ID_PLAY_MEDIA_LIBRARY_CURRENT_SELECTION;
          messageSend[messageSendCount++] = IAP2_MSG_ID_PLAY_MEDIA_LIBRARY_ITEMS;
          messageSend[messageSendCount++] = IAP2_MSG_ID_PLAY_MEDIA_LIBRARY_COLLECTION;
          messageSend[messageSendCount++] = IAP2_MSG_ID_SET_NOW_PLAYING_INFORMATION;
          messageSend[messageSendCount++] = IAP2_MSG_ID_START_HID;
          messageSend[messageSendCount++] = IAP2_MSG_ID_ACCESSORY_HID_REPORT;
          messageSend[messageSendCount++] = IAP2_MSG_ID_STOP_HID;
        }
    }

    if(wirelessCarplay) {
        if(!LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp())
        {
          messageSend[messageSendCount++] = IAP2_MSG_ID_START_HID;
          messageSend[messageSendCount++] = IAP2_MSG_ID_ACCESSORY_HID_REPORT;
          messageSend[messageSendCount++] = IAP2_MSG_ID_STOP_HID;
        }
    }

    if(!wirelessCarplay && !isCPWActive && !mySpin && !carLife && LocalSPM::GetDataProvider().iPodControlIAP2BTConnectionUpdatesEnabled()) {
        if(LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp() && deviceInfo.connectionType != DCT_BLUETOOTH)
        {
          messageSend[messageSendCount++] = IAP2_MSG_ID_START_BLUETOOTH_CONNECTION_UPDATES;
          messageSend[messageSendCount++] = IAP2_MSG_ID_STOP_BLUETOOTH_CONNECTION_UPDATES;
        }
        else if(!LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp())
        {
          messageSend[messageSendCount++] = IAP2_MSG_ID_START_BLUETOOTH_CONNECTION_UPDATES;
          messageSend[messageSendCount++] = IAP2_MSG_ID_STOP_BLUETOOTH_CONNECTION_UPDATES;
        }
    }

    if(DCT_BLUETOOTH != deviceInfo.connectionType)
    {
        messageSend[messageSendCount++] = IAP2_MSG_ID_START_POWER_UPDATES;
        messageSend[messageSendCount++] = IAP2_MSG_ID_STOP_POWER_UPDATES;
    }

    if(DCT_USB == deviceInfo.connectionType)
    {
        messageSend[messageSendCount++] = IAP2_MSG_ID_POWER_SOURCE_UPDATE;
    }

    if(DCT_USB == deviceInfo.connectionType && !hostMode)
    {
        messageSend[messageSendCount++] = IAP2_MSG_ID_START_USB_DEVICE_MODE_AUDIO;
        messageSend[messageSendCount++] = IAP2_MSG_ID_STOP_USB_DEVICE_MODE_AUDIO;
    }

    if((hostMode || wirelessCarplay) && !mySpin && !carLife)
    {
        if(LocalSPM::GetDataProvider().iPodControlIAP2CallStateUpdateEnabled())
        {
#ifdef IPODCONTROL_IAP2_PF_R22
            messageSend[messageSendCount++] = IAP2_MSG_ID_START_CALL_STATE_UPDATES;
            messageSend[messageSendCount++] = IAP2_MSG_ID_STOP_CALL_STATE_UPDATES;

            tDiPOCallControlsConfiguration callControlsConfig;
            callControlsConfig = LocalSPM::GetDataProvider().GetDiPOCallControlsConfiguration();
            if(callControlsConfig.value != 0)
            {
                if(callControlsConfig.bits.isInitiateCallAvailable) {
                    messageSend[messageSendCount++] = IAP2_MSG_ID_INITIATE_CALL;
                }
                if(callControlsConfig.bits.isAcceptCallAvailable)
                {
                    messageSend[messageSendCount++] = IAP2_MSG_ID_ACCEPT_CALL;
                }
                if(callControlsConfig.bits.isEndCallAvailable)
                {
                    messageSend[messageSendCount++] = IAP2_MSG_ID_END_CALL;
                }
                if(callControlsConfig.bits.isSwapCallsAvailable)
                {
                    messageSend[messageSendCount++] = IAP2_MSG_ID_SWAP_CALLS;
                }
            }
#else
            messageSend[messageSendCount++] = IAP2_MSG_ID_START_TELEPHONY_CALL_STATE_INFORMATION;
            messageSend[messageSendCount++] = IAP2_MSG_ID_STOP_TELEPHONY_CALL_STATE_INFORMATION;
#endif
        }
        if(LocalSPM::GetDataProvider().iPodControlIAP2CommunicationsUpdateEnabled()) {
#ifdef IPODCONTROL_IAP2_PF_R22
            messageSend[messageSendCount++] = IAP2_MSG_ID_START_COMMUNICATIONS_UPDATES;
            messageSend[messageSendCount++] = IAP2_MSG_ID_STOP_COMMUNICATIONS_UPDATES;
#else
            messageSend[messageSendCount++] = IAP2_MSG_ID_START_TELEPHONY_UPDATES;
            messageSend[messageSendCount++] = IAP2_MSG_ID_STOP_TELEPHONY_UPDATES;
#endif
        }
        if(LocalSPM::GetDataProvider().iPodControlVehicleStatusEnabled()) {
            messageSend[messageSendCount++] = IAP2_MSG_ID_VEHICLE_STATUS_UPDATE;
        }
        if(LocalSPM::GetDataProvider().iPodControlIAP2ListUpdateEnabled()) {
            messageSend[messageSendCount++] = IAP2_MSG_ID_START_LIST_UPDATES;
            messageSend[messageSendCount++] = IAP2_MSG_ID_STOP_LIST_UPDATES;
        }
    }

    if((hostMode || wirelessCarplay) && !carLife && !mySpin) {
        if(LocalSPM::GetDataProvider().IsiPodControlLocationInfoEnabled()) {
            messageSend[messageSendCount++] = IAP2_MSG_ID_LOCATION_INFORMATION;
        }
    }

    if(LocalSPM::GetDataProvider().iPodControlIAP2ControlSessionVersion() == 2) {
        messageSend[messageSendCount++] = IAP2_MSG_ID_ACCESSORY_AUTHENTICATION_SERIAL_NUMBER;
    }

    //CARPLAY WIFI:
    if(LocalSPM::GetDataProvider().iPodControlCarPlayWifiEnabled()) {
        if(DCT_BLUETOOTH == deviceInfo.connectionType)
        {
            messageSend[messageSendCount++] = IAP2_MSG_ID_ACCESSORY_WI_FI_CONFIGURATION_INFORMATION;
        }
#ifdef IPODCONTROL_IAP2_PF_OOBBT_AVAIL
#ifdef TARGET_BUILD
        if(carPlay) {
            messageSend[messageSendCount++] = IAP2_MSG_ID_OOBBT_PAIRING_ACCESSORY_INFORMATION;
            messageSend[messageSendCount++] = IAP2_MSG_ID_OOBBT_PAIRING_COMPLETION_INFORMATION;
        }
#endif
#endif
    }

    iAP2InitParameter->p_iAP2AccessoryInfo->iAP2CommandsUsedByApplication = new U16[messageSendCount];
    if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2CommandsUsedByApplication)  return NULL; //lint !e429 deleted by IAP2_Disconnect
    memcpy(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2CommandsUsedByApplication, messageSend, messageSendCount * 2);
    iAP2InitParameter->p_iAP2AccessoryInfo->iAP2CommandsUsedByApplication_length = messageSendCount * 2;

    //calculated messages received by accessory from apple device
    U16 messageRecv[40];
    int messageRecvCount = 0;
    if(LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp() && deviceInfo.connectionType != DCT_BLUETOOTH)
    {
        messageRecv[messageRecvCount++] = IAP2_MSG_ID_DEVICE_INFORMATION_UPDATE;
        if(!mySpin && !carLife)
        {
            messageRecv[messageRecvCount++] = IAP2_MSG_ID_NOW_PLAYING_UPDATE_PARAMETER;
            messageRecv[messageRecvCount++] = IAP2_MSG_ID_DEVICE_LANGUAGE_UPDATE;
        }
    }
    else if(!LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp())
    {
        messageRecv[messageRecvCount++] = IAP2_MSG_ID_DEVICE_INFORMATION_UPDATE;
        if(!mySpin && !carLife)
        {
            messageRecv[messageRecvCount++] = IAP2_MSG_ID_NOW_PLAYING_UPDATE_PARAMETER;
            messageRecv[messageRecvCount++] = IAP2_MSG_ID_DEVICE_LANGUAGE_UPDATE;
        }
    }
    messageRecv[messageRecvCount++] = IAP2_MSG_ID_DEVICE_UUID_UPDATE;
    //CARPLAY WIFI:
    if(LocalSPM::GetDataProvider().iPodControlCarPlayWifiEnabled() && !mySpin && !carLife)
    {
        if(DCT_BLUETOOTH == deviceInfo.connectionType)
        {
            messageRecv[messageRecvCount++] = IAP2_MSG_ID_REQUEST_ACCESSORY_WI_FI_CONFIGURATION_INFORMATION;
        }
        if(DCT_BLUETOOTH == deviceInfo.connectionType || DCT_WIFI == deviceInfo.connectionType)
        {
            messageRecv[messageRecvCount++] = IAP2_MSG_ID_WIRELESS_CAR_PLAY_UPDATE;
        }
#ifdef IPODCONTROL_IAP2_PF_OOBBT_AVAIL
#ifdef TARGET_BUILD
        if(carPlay) {
            messageRecv[messageRecvCount++] = IAP2_MSG_ID_START_OOBBT_PAIRING;
            messageRecv[messageRecvCount++] = IAP2_MSG_ID_OOBBT_PAIRING_LINK_KEY_INFORMATION;
            messageRecv[messageRecvCount++] = IAP2_MSG_ID_STOP_OOBBT_PAIRING;
        }
#endif
#endif

#ifdef IPODCONTROL_IAP2_PF_R26
#ifdef TARGET_BUILD
        messageRecv[messageRecvCount++] = IAP2_MSG_ID_DEVICE_TRANSPORT_IDENTIFIER_NOTIFICATION;
#endif
#endif
    }

    if((!carPlay && !wirelessCarplay && !mySpin && !carLife) || LocalSPM::GetDataProvider().iPodControlIAP2CarPlayModeEnabled()) {
        if(LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp() && deviceInfo.connectionType != DCT_BLUETOOTH)
        {
          messageRecv[messageRecvCount++] = IAP2_MSG_ID_MEDIA_LIBRARY_INFORMATION; //PSCRCCB-10105
          messageRecv[messageRecvCount++] = IAP2_MSG_ID_MEDIA_LIBRARY_UPDATE; //PSCRCCB-10105
          messageRecv[messageRecvCount++] = IAP2_MSG_ID_DEVICE_HID_REPORT;
        }
        else if(!LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp())
        {
          messageRecv[messageRecvCount++] = IAP2_MSG_ID_MEDIA_LIBRARY_INFORMATION; //PSCRCCB-10105
          messageRecv[messageRecvCount++] = IAP2_MSG_ID_MEDIA_LIBRARY_UPDATE; //PSCRCCB-10105
          messageRecv[messageRecvCount++] = IAP2_MSG_ID_DEVICE_HID_REPORT;
        }
    }
    if(!wirelessCarplay && !isCPWActive && !mySpin && !carLife && LocalSPM::GetDataProvider().iPodControlIAP2BTConnectionUpdatesEnabled()) {
        if(LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp() && deviceInfo.connectionType != DCT_BLUETOOTH)
        {
          messageRecv[messageRecvCount++] = IAP2_MSG_ID_BLUETOOTH_CONNECTION_UPDATE;
        }
        else if(!LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp())
        {
          messageRecv[messageRecvCount++] = IAP2_MSG_ID_BLUETOOTH_CONNECTION_UPDATE;
        }
    }

    if(deviceInfo.connectionType != DCT_BLUETOOTH)
    {
        messageRecv[messageRecvCount++] = IAP2_MSG_ID_POWER_UPDATE;
    }

    if(DCT_USB == deviceInfo.connectionType && !hostMode)
    {
        messageRecv[messageRecvCount++] = IAP2_MSG_ID_USB_DEVICE_MODE_AUDIO_INFORMATION;
    }
    if(hostMode && !mySpin && !carLife) {
#if 0  // TELEPHONY_CALL_STATE & CALL_STATE_UPDATE are same. COMMUNICATIONS_UPDATE & TELEPHONY_UPDATE are same.
        if(LocalSPM::GetDataProvider().iPodControlIAP2CallStateUpdateEnabled()) {
            messageRecv[messageRecvCount++] = IAP2_MSG_ID_TELEPHONY_CALL_STATE_INFORMATION;
        }
        if(LocalSPM::GetDataProvider().iPodControlIAP2CommunicationsUpdateEnabled()) {
            messageRecv[messageRecvCount++] = IAP2_MSG_ID_TELEPHONY_UPDATE;
        }
#endif
        if(LocalSPM::GetDataProvider().iPodControlVehicleStatusEnabled()) {
            messageRecv[messageRecvCount++] = IAP2_MSG_ID_START_VEHICLE_STATUS_UPDATES;
            messageRecv[messageRecvCount++] = IAP2_MSG_ID_STOP_VEHICLE_STATUS_UPDATES;
        }
    }

    if((hostMode || wirelessCarplay) && !carLife && !mySpin) {
        if(LocalSPM::GetDataProvider().IsiPodControlLocationInfoEnabled()) {
            messageRecv[messageRecvCount++] = IAP2_MSG_ID_START_LOCATION_INFORMATION;
            messageRecv[messageRecvCount++] = IAP2_MSG_ID_STOP_LOCATION_INFORMATION;
        }
        if(LocalSPM::GetDataProvider().iPodControlGPRMCDataStatusValuesNotification()) {
            messageRecv[messageRecvCount++] = IAP2_MSG_ID_GPRMC_DATA_STATUS_VALUES_NOTIFICATION;
        }
        if(LocalSPM::GetDataProvider().iPodControlIAP2CommunicationsUpdateEnabled()) {
            messageRecv[messageRecvCount++] = IAP2_MSG_ID_COMMUNICATIONS_UPDATE;
        }
        if(LocalSPM::GetDataProvider().iPodControlIAP2CallStateUpdateEnabled()) {
            messageRecv[messageRecvCount++] = IAP2_MSG_ID_CALL_STATE_UPDATE;
        }
        if(LocalSPM::GetDataProvider().iPodControlIAP2ListUpdateEnabled()) {
            messageRecv[messageRecvCount++] = IAP2_MSG_ID_LIST_UPDATE;
        }
        if(!nativeTransport && LocalSPM::GetDataProvider().iPodRouteGuidanceEnabled()) {
          messageRecv[messageRecvCount++] = IAP2_MSG_ID_ROUTE_GUIDANCE_UPDATE; //NCG3D-63574
          messageRecv[messageRecvCount++] = IAP2_MSG_ID_ROUTE_GUIDANCE_MANEUVER_UPDATE; //NCG3D-63574
        }

        messageRecv[messageRecvCount++] = IAP2_MSG_ID_DEVICE_TIME_UPDATE;
    }

    VARTRACE(deviceInfo.connectionType);

    if((appInfoEAPSessionCount || appInfoEANativeTransportCount) && !mySpin) {
        if(LocalSPM::GetDataProvider().iPodControlSupportCarlife() && deviceInfo.connectionType == DCT_USB)
        {
            messageRecv[messageRecvCount++] = IAP2_MSG_ID_START_EXTERNAL_ACCESSORY_PROTOCOL_SESSION;
            messageRecv[messageRecvCount++] = IAP2_MSG_ID_STOP_EXTERNAL_ACCESSORY_PROTOCOL_SESSION;
        }
        else if(!LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp())
        {
           messageRecv[messageRecvCount++] = IAP2_MSG_ID_START_EXTERNAL_ACCESSORY_PROTOCOL_SESSION;
           messageRecv[messageRecvCount++] = IAP2_MSG_ID_STOP_EXTERNAL_ACCESSORY_PROTOCOL_SESSION;
        }
    }

    iAP2InitParameter->p_iAP2AccessoryInfo->iAP2CallbacksExpectedFromDevice = new U16[messageRecvCount];
    if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2CallbacksExpectedFromDevice)    return NULL; //lint !e429 deleted by IAP2_Disconnect
    memcpy(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2CallbacksExpectedFromDevice, messageRecv, messageRecvCount * 2);
    iAP2InitParameter->p_iAP2AccessoryInfo->iAP2CallbacksExpectedFromDevice_length = messageRecvCount * 2;

    size = strnlen(LocalSPM::GetDataProvider().iPodControlAccessoryInfoCurrentLanguage().c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
    iAP2InitParameter->p_iAP2AccessoryInfo->iAP2CurrentLanguage = new U8[size];
    if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2CurrentLanguage) return NULL; //lint !e429 deleted by IAP2_Disconnect
    strncpy_r((char *)iAP2InitParameter->p_iAP2AccessoryInfo->iAP2CurrentLanguage, LocalSPM::GetDataProvider().iPodControlAccessoryInfoCurrentLanguage().c_str(), size);

    iAP2InitParameter->p_iAP2AccessoryInfo->iAP2SupportedLanguageCount = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguageCount();
    size = iAP2InitParameter->p_iAP2AccessoryInfo->iAP2SupportedLanguageCount * sizeof(U8*);
    iAP2InitParameter->p_iAP2AccessoryInfo->iAP2SupportedLanguage = new U8*[size];
    if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2SupportedLanguage) return NULL; //lint !e429 deleted by IAP2_Disconnect

    for(unsigned int i = 0; i < iAP2InitParameter->p_iAP2AccessoryInfo->iAP2SupportedLanguageCount; i++) {
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2SupportedLanguage[i] = NULL;
        string language;
        switch(i) {
        case 0:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_1();
            break;
        case 1:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_2();
            break;
        case 2:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_3();
            break;
        case 3:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_4();
            break;
        case 4:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_5();
            break;
        case 5:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_6();
            break;
        case 6:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_7();
            break;
        case 7:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_8();
            break;
        case 8:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_9();
            break;
        case 9:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_10();
            break;
        case 10:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_11();
            break;
        case 11:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_12();
            break;
        case 12:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_13();
            break;
        case 13:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_14();
            break;
        case 14:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_15();
            break;
        case 15:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_16();
            break;
        case 16:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_17();
            break;
        case 17:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_18();
            break;
        case 18:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_19();
            break;
        case 19:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_20();
            break;
        case 20:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_21();
            break;
        case 21:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_22();
            break;
        case 22:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_23();
            break;
        case 23:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_24();
            break;
        case 24:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_25();
            break;
        case 25:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_26();
            break;
        case 26:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_27();
            break;
        case 27:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_28();
            break;
        case 28:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_29();
            break;
        case 29:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_30();
            break;
        case 30:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_31();
            break;
        case 31:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_32();
            break;
        case 32:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_33();
            break;
        case 33:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_34();
            break;
        case 34:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_35();
            break;
        case 35:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_36();
            break;
        case 36:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_37();
            break;
        case 37:
            language = LocalSPM::GetDataProvider().iPodControlAccessoryInfoSupportedLanguage_38();
            break;
        default:
            ETG_TRACE_ERR(("PLEASE CHECK MEDIAPLAYER CONFIGURATION"));
            return NULL; //lint !e429 deleted by IAP2_Disconnect
        }

        size = strnlen(language.c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2SupportedLanguage[i] = new U8[size];
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2SupportedLanguage[i]) return NULL; //lint !e429 deleted by IAP2_Disconnect
        strncpy_r((char *)iAP2InitParameter->p_iAP2AccessoryInfo->iAP2SupportedLanguage[i],language.c_str(), size);
    }
    iAP2InitParameter->p_iAP2AccessoryInfo->iAP2SupportsiOSintheCar = iAP2InitParameter->p_iAP2AccessoryConfig->iAP2iOSintheCar; //redundant?

    if(!wirelessCarplay && !isCPWActive && !mySpin && !carLife && LocalSPM::GetDataProvider().iPodControlIAP2BTTransportComponentEnabled()) {
        //BluetoothTransportMAC
        tDeviceAddress deviceAddress = {0};
        memset(deviceAddress, 0, sizeof(deviceAddress));
        if(MP_NO_ERROR != GetBTMAC(deviceAddress) ) {
            ETG_TRACE_ERR(("GetBTMAC failed"));
        }
        size = 1; //single MAC
        //using new iAP2BluetoothTransportComponent
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent = new iAP2BluetoothTransportComponent[size];
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent) return NULL; //lint !e429 deleted by IAP2_Disconnect
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent_count = size;
        //TODO: loop over MAC address count, currently single MAC available
        memset(&iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent[0], 0, sizeof(iAP2BluetoothTransportComponent));
        //BT MAC addr
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent[0].iAP2BluetoothTransportMediaAccessControlAddress = new iAP2Blob;
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent[0].iAP2BluetoothTransportMediaAccessControlAddress) return NULL; //lint !e429 deleted by IAP2_Disconnect
        memset(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent[0].iAP2BluetoothTransportMediaAccessControlAddress, 0, sizeof(iAP2Blob) );
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent[0].iAP2BluetoothTransportMediaAccessControlAddress_count++;
        size_t size_blob = sizeof(deviceAddress);
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent[0].iAP2BluetoothTransportMediaAccessControlAddress->iAP2BlobData = new U8[size_blob];
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent[0].iAP2BluetoothTransportMediaAccessControlAddress->iAP2BlobData) return NULL; //lint !e429 deleted by IAP2_Disconnect
        memcpy(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent[0].iAP2BluetoothTransportMediaAccessControlAddress->iAP2BlobData, deviceAddress, size_blob);
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent[0].iAP2BluetoothTransportMediaAccessControlAddress->iAP2BlobLength = size_blob;
        //BT ID
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent[0].iAP2TransportComponentIdentifier = new U16[1];
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent[0].iAP2TransportComponentIdentifier) return NULL; //lint !e429 deleted by IAP2_Disconnect
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent[0].iAP2TransportComponentIdentifier[0] = IAP2_BT_TRANS_COMP_ID;
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent[0].iAP2TransportComponentIdentifier_count++;
        //BT Name
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent[0].iAP2TransportComponentName = new U8*[1];
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent[0].iAP2TransportComponentName) return NULL; //lint !e429 deleted by IAP2_Disconnect
        size_t size_name = strnlen(LocalSPM::GetDataProvider().iPodControlAccessoryInfoBTName().c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent[0].iAP2TransportComponentName[0] = new U8[size_name];
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent[0].iAP2TransportComponentName[0]) return NULL; //lint !e429 deleted by IAP2_Disconnect
        strncpy_r((char *)iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent[0].iAP2TransportComponentName[0], LocalSPM::GetDataProvider().iPodControlAccessoryInfoBTName().c_str(), size_name);
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent[0].iAP2TransportComponentName_count++;
        if(iAP2InitParameter->p_iAP2AccessoryConfig->iAP2TransportType == iAP2BLUETOOTH) {
            //BT iAP2
            iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent[0].iAP2TransportSupportsiAP2Connection_count++; /* Set if Bluetooth component supports iAP2 connection */
        }
    }

    //CARPLAY WIFI:

    // Fix for NCG3D-162752: Not able to establish CPW after enabling the functionality from MD
    // 1) When SPP is connected, instead of triggering iAP BT session without wireless transport component,
    // initiate iAP BT session with wireless transport component.
    // 2) Ignore the BT Limitation mode updates and prevent Reconnection in MP on a BT Limitation mode change from NOT PREPARED to PREPARED
    // - to avoid iAP reconnection triggers from MP to ADIT.
    if(( (iAP2InitParameter->p_iAP2AccessoryConfig->iAP2TransportType == iAP2BLUETOOTH) || wirelessCarplay
            || ((iAP2InitParameter->p_iAP2AccessoryConfig->iAP2TransportType == iAP2USBHOSTMODE || iAP2InitParameter->p_iAP2AccessoryConfig->iAP2TransportType == iAP2MULTIHOSTMODE)  && !mySpin && !carLife)/*For OOBBT */ )
            && LocalSPM::GetDataProvider().iPodControlCarPlayWifiEnabled() )
    {
            size = 1;
            iAP2InitParameter->p_iAP2AccessoryInfo->iAP2WirelessCarPlayTransportComponent = new iAP2WirelessCarPlayTransportComponent[size];
            if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2WirelessCarPlayTransportComponent) return NULL; //lint !e429 deleted by IAP2_Disconnect
            iAP2InitParameter->p_iAP2AccessoryInfo->iAP2WirelessCarPlayTransportComponent_count = TRUE;
            memset(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2WirelessCarPlayTransportComponent,0,sizeof(iAP2WirelessCarPlayTransportComponent));
            //WIFI ID
            iAP2InitParameter->p_iAP2AccessoryInfo->iAP2WirelessCarPlayTransportComponent[0].iAP2TransportComponentIdentifier = new U16[size];
            if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2WirelessCarPlayTransportComponent[0].iAP2TransportComponentIdentifier) return NULL; //lint !e429 deleted by IAP2_Disconnect
            iAP2InitParameter->p_iAP2AccessoryInfo->iAP2WirelessCarPlayTransportComponent[0].iAP2TransportComponentIdentifier[0] = IAP2_WIRELESS_CARPLAY_TRANS_COMP_ID;
            //WIFI Name
            iAP2InitParameter->p_iAP2AccessoryInfo->iAP2WirelessCarPlayTransportComponent[0].iAP2TransportComponentName = new U8*[size];
            if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2WirelessCarPlayTransportComponent[0].iAP2TransportComponentName) return NULL; //lint !e429 deleted by IAP2_Disconnect
            size_t size_name = strnlen(LocalSPM::GetDataProvider().iPodControlAccessoryInfoWIFIName().c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
            iAP2InitParameter->p_iAP2AccessoryInfo->iAP2WirelessCarPlayTransportComponent[0].iAP2TransportComponentName[0] = new U8[size_name];
            if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2WirelessCarPlayTransportComponent[0].iAP2TransportComponentName[0]) return NULL; //lint !e429 deleted by IAP2_Disconnect
            strncpy_r((char *)iAP2InitParameter->p_iAP2AccessoryInfo->iAP2WirelessCarPlayTransportComponent[0].iAP2TransportComponentName[0], LocalSPM::GetDataProvider().iPodControlAccessoryInfoWIFIName().c_str(), size_name);
            iAP2InitParameter->p_iAP2AccessoryInfo->iAP2WirelessCarPlayTransportComponent[0].iAP2TransportSupportsCarPlay_count = TRUE;
            iAP2InitParameter->p_iAP2AccessoryInfo->iAP2WirelessCarPlayTransportComponent[0].iAP2TransportSupportsiAP2Connection_count = TRUE;
    }
    //End of fix

    if(deviceInfo.connectionType != DCT_BLUETOOTH && deviceInfo.connectionType != DCT_WIFI) {
        //sample rate
        size = sizeof(USBDeviceSupportedAudioSampleRate) / sizeof(iAP2USBDeviceModeAudioSampleRate);
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBDeviceSupportedAudioSampleRate = new iAP2USBDeviceModeAudioSampleRate[size];
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBDeviceSupportedAudioSampleRate) return NULL; //lint !e429 deleted by IAP2_Disconnect
        memcpy(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBDeviceSupportedAudioSampleRate, USBDeviceSupportedAudioSampleRate, size * sizeof(iAP2USBDeviceModeAudioSampleRate));
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBDeviceSupportedAudioSampleRate_count = size;
    }

    if((!carPlay && !mySpin && !carLife) || LocalSPM::GetDataProvider().iPodControlIAP2CarPlayModeEnabled()) {
        //HID
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent = new iAP2iAP2HIDComponent;
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent) return NULL; //lint !e429 deleted by IAP2_Disconnect
        memset(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent, 0, sizeof(iAP2iAP2HIDComponent));
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent_count = 1;
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent[0].iAP2HIDComponentFunction = new iAP2HIDComponentFunction;
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent[0].iAP2HIDComponentFunction) return NULL; //lint !e429 deleted by IAP2_Disconnect
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent[0].iAP2HIDComponentFunction_count = 1;
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent[0].iAP2HIDComponentFunction[0] = IAP2_HID_COMPONENT_PLAYBACK_REMOTE;
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent[0].iAP2HIDComponentIdentifier = new U16[1];
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent[0].iAP2HIDComponentIdentifier) return NULL; //lint !e429 deleted by IAP2_Disconnect
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent[0].iAP2HIDComponentIdentifier_count = 1;
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent[0].iAP2HIDComponentIdentifier[0] = IAP2_HID_COMPONENT_IDENTIFIER;
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent[0].iAP2HIDComponentName = new U8*[1];
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent[0].iAP2HIDComponentName) return NULL; //lint !e429 deleted by IAP2_Disconnect
        const char HIDCompName[] = {"Media Playback Remote"};
        size = strnlen(HIDCompName, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent[0].iAP2HIDComponentName[0] = new U8[size];
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent[0].iAP2HIDComponentName[0]) return NULL; //lint !e429 deleted by IAP2_Disconnect
        strncpy_r((char *)iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent[0].iAP2HIDComponentName[0], HIDCompName, size);
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent[0].iAP2HIDComponentName_count = 1;
    }

    //Location
    if((hostMode || wirelessCarplay ) && !carLife && !mySpin && LocalSPM::GetDataProvider().IsiPodControlLocationInfoEnabled()) {
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2LocationInformationComponent = new iAP2LocationInformationComponent_t;
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2LocationInformationComponent) return NULL; //lint !e429 deleted by IAP2_Disconnect
        memset(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2LocationInformationComponent, 0, sizeof(iAP2LocationInformationComponent_t));
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2LocationInformationComponent->iAP2GlobalPositioningSystemFixData =
                LocalSPM::GetDataProvider().iPodControlLocationInfoGPGGA(); //GPGGA  -> Support
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2LocationInformationComponent->iAP2RecommendedMinimumSpecificGPSTransitData =
                LocalSPM::GetDataProvider().iPodControlLocationInfoGPRMC(); //GPRMC  -> Support
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2LocationInformationComponent->iAP2GPSSatelliteInView =
                LocalSPM::GetDataProvider().iPodControlLocationInfoGPGSV(); //GPGSV  -> Support
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2LocationInformationComponent->iAP2VehicleHeadingData =
                LocalSPM::GetDataProvider().iPodControlLocationInfoGPHDT(); //GPHDT  -> Support
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2LocationInformationComponent->iAP2VehicleAccelerometerData =
                LocalSPM::GetDataProvider().iPodControlLocationInfoPAACD(); //PAACD -> not support
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2LocationInformationComponent->iAP2VehicleGyroData =
                LocalSPM::GetDataProvider().iPodControlLocationInfoPAGCD(); //PAGCD -> not support
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2LocationInformationComponent->iAP2VehicleSpeedData =
                LocalSPM::GetDataProvider().iPodControlLocationInfoPASCD(); //PASCD -> Support
    }

    //VehicleStatus
    if((hostMode && !mySpin && !carLife) && LocalSPM::GetDataProvider().iPodControlVehicleStatusEnabled()) {
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2VehicleStatusComponent = new iAP2VehicleStatusComponent_t;
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2VehicleStatusComponent) return NULL; //lint !e429 deleted by IAP2_Disconnect
        memset(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2VehicleStatusComponent, 0, sizeof(iAP2VehicleStatusComponent_t));
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2VehicleStatusComponent->iAP2Range =
                LocalSPM::GetDataProvider().iPodControlVehicleStatusRange(); //Range  -> Support
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2VehicleStatusComponent->iAP2RangeWarning =
                LocalSPM::GetDataProvider().iPodControlVehicleStatusRangeWarning(); //RangeWarning  -> Support
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2VehicleStatusComponent->iAP2OutsideTemperature =
                LocalSPM::GetDataProvider().iPodControlVehicleStatusOutsideTemperature(); //OutsideTemperature  -> Support
    }

    //VehicleInformation
    tEngineType engineType = (tEngineType)LocalSPM::GetDataProvider().EngineType();
    VARTRACE(engineType);
    iAP2EngineTypes iPodEngineType = IAP2_GASOLINE; // default
    bool validEngine = true;
    switch(engineType) {
    case ET_GASOLINE:
        iPodEngineType = IAP2_GASOLINE;    /**< Gasoline Engine */
        break;
    case ET_CNG:
        iPodEngineType = IAP2_CNG;
        break;
    case ET_DIESEL:
        iPodEngineType = IAP2_DIESEL;      /**< Diesel Engine */
        break;
    case ET_ELECTRIC:
        iPodEngineType = IAP2_ELECTRIC;    /**< Electrical Engine */
        break;
    default:
        ETG_TRACE_USR3(("Invalid engine type"));
        validEngine = false;
        break;
    }

    iAP2InitParameter->p_iAP2AccessoryInfo->iAP2VehicleInformationComponent = new iAP2VehicleInformationComponent_t;
    if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2VehicleInformationComponent) return NULL; //lint !e429 deleted by IAP2_Disconnect
    memset(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2VehicleInformationComponent, 0, sizeof(iAP2VehicleInformationComponent_t));

    if(validEngine) {
        VARTRACE(iPodEngineType);
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2VehicleInformationComponent->iAP2EngineType = new iAP2EngineTypes;
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2VehicleInformationComponent->iAP2EngineType) return NULL; //lint !e429 deleted by IAP2_Disconnect
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2VehicleInformationComponent->iAP2EngineType[0] = iPodEngineType;
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2VehicleInformationComponent->iAP2EngineType_count++;
    }

    if((hostMode && !nativeTransport && !carLife) && LocalSPM::GetDataProvider().iPodRouteGuidanceEnabled()) {
        //TBT
#ifdef IAP2_DEFAULT_ROUTEGUIDANCEDISPLAYCOMPONENT
        size_t size = 0;
        ETG_TRACE_ERR(("LocalSPM::GetDBManager().GetRouteGuidanceDisplayComponentInfos() failed"));
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent = new iAP2RouteGuidanceDisplayComponent;
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent) return NULL; //lint !e429 deleted by IAP2_Disconnect
        memset(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent, 0, sizeof(iAP2RouteGuidanceDisplayComponent));
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent_count = 1;

        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2Identifier = new U16[1];
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2Identifier) return NULL; //lint !e429 deleted by IAP2_Disconnect
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2Identifier_count = 1;
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2Identifier[0] = IAP2_ROUTE_GUIDANCE_DISPLAY_COMP_ID;

        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2Name = new U8*[1];
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2Name) return NULL; //lint !e429 deleted by IAP2_Disconnect
        const char displayComponentName[] = {"Route Guidance Display Name"};
        size = strnlen(displayComponentName, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2Name[0] = new U8[size];
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2Name[0]) return NULL; //lint !e429 deleted by IAP2_Disconnect
        strncpy_r((char *)iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2Name[0], displayComponentName, size);
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2Name_count = 1;

        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2MaxCurrentRoadNameLength = new U16[1];
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2MaxCurrentRoadNameLength) return NULL; //lint !e429 deleted by IAP2_Disconnect
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2MaxCurrentRoadNameLength_count = 1;
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2MaxCurrentRoadNameLength[0] = IAP2_ROUTE_GUIDANCE_LENGTH_VAL;

        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2MaxDestinationRoadNameLength = new U16[1];
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2MaxDestinationRoadNameLength) return NULL; //lint !e429 deleted by IAP2_Disconnect
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2MaxDestinationRoadNameLength_count = 1;
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2MaxDestinationRoadNameLength[0] = IAP2_ROUTE_GUIDANCE_LENGTH_VAL;

        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2MaxAfterManeuverRoadNameLength = new U16[1];
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2MaxAfterManeuverRoadNameLength) return NULL; //lint !e429 deleted by IAP2_Disconnect
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2MaxAfterManeuverRoadNameLength_count = 1;
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2MaxAfterManeuverRoadNameLength[0] = IAP2_ROUTE_GUIDANCE_LENGTH_VAL;

        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2MaxManeuverDescriptionLength = new U16[1];
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2MaxManeuverDescriptionLength) return NULL; //lint !e429 deleted by IAP2_Disconnect
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2MaxManeuverDescriptionLength_count = 1;
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2MaxManeuverDescriptionLength[0] = IAP2_ROUTE_GUIDANCE_LENGTH_VAL;

        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2MaxGuidanceManeuverStorageCapacity = new U16[1];
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2MaxGuidanceManeuverStorageCapacity) return NULL; //lint !e429 deleted by IAP2_Disconnect
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2MaxGuidanceManeuverStorageCapacity_count = 1;
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[0].iAP2MaxGuidanceManeuverStorageCapacity[0] = 1;
#else
        vector<tDiPORGDisplayComponentInfo> RGDisplayComponentInfos;
        tResult res = MP_NO_ERROR;
        res = LocalSPM::GetDBManager().GetRouteGuidanceDisplayComponentInfos(RGDisplayComponentInfos);

        size_t compDisplaySize = RGDisplayComponentInfos.size();
        VARTRACE(compDisplaySize);
        if(compDisplaySize > 0){
            iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent = new iAP2RouteGuidanceDisplayComponent[compDisplaySize];
            if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent) return NULL; //lint !e429 deleted by IAP2_Disconnect
            memset(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent, 0, sizeof(iAP2RouteGuidanceDisplayComponent));

            for(int i=0; i<compDisplaySize; i++)
            {
                size_t size = 0;
                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent_count++;

                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2Identifier = new U16[1];
                if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2Identifier) return NULL; //lint !e429 deleted by IAP2_Disconnect
                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2Identifier_count = 1;
                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2Identifier[0] = RGDisplayComponentInfos.at(i).Identifier;
                VARTRACE(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2Identifier[0]);
                VARTRACE(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2Identifier_count);

                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2Name = new U8*[1];
                if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2Name) return NULL; //lint !e429 deleted by IAP2_Disconnect
                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2Name_count = 1;
                size = strnlen(RGDisplayComponentInfos.at(i).Name, IAP2_STRING_MAX)+IAP2_NULL_CHAR_LEN;
                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2Name[0] = new U8[size];
                if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2Name[0]) return NULL; //lint !e429 deleted by IAP2_Disconnect
                strncpy_r((char *)iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2Name[0], RGDisplayComponentInfos.at(i).Name, size);
                VARTRACE(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2Name[0]);
                VARTRACE(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2Name_count);

                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxCurrentRoadNameLength = new U16[1];
                if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxCurrentRoadNameLength) return NULL; //lint !e429 deleted by IAP2_Disconnect
                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxCurrentRoadNameLength_count = 1;
                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxCurrentRoadNameLength[0] = RGDisplayComponentInfos.at(i).CurrentRoadNameLength;
                VARTRACE(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxCurrentRoadNameLength[0]);
                VARTRACE(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxCurrentRoadNameLength_count);

                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxDestinationRoadNameLength = new U16[1];
                if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxDestinationRoadNameLength) return NULL; //lint !e429 deleted by IAP2_Disconnect
                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxDestinationRoadNameLength_count = 1;
                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxDestinationRoadNameLength[0] = RGDisplayComponentInfos.at(i).DestinationNameLength;
                VARTRACE(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxDestinationRoadNameLength_count);
                VARTRACE(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxDestinationRoadNameLength[0]);

                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxAfterManeuverRoadNameLength = new U16[1];
                if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxAfterManeuverRoadNameLength) return NULL; //lint !e429 deleted by IAP2_Disconnect
                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxAfterManeuverRoadNameLength_count = 1;
                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxAfterManeuverRoadNameLength[0] = RGDisplayComponentInfos.at(i).AfterManeuverRoadNameLength;
                VARTRACE(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxAfterManeuverRoadNameLength[0]);
                VARTRACE(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxAfterManeuverRoadNameLength_count);

                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxManeuverDescriptionLength = new U16[1];
                if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxManeuverDescriptionLength) return NULL; //lint !e429 deleted by IAP2_Disconnect
                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxManeuverDescriptionLength_count = 1;
                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxManeuverDescriptionLength[0] = RGDisplayComponentInfos.at(i).ManeuverDescriptionLength;
                VARTRACE(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxManeuverDescriptionLength_count);
                VARTRACE(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxManeuverDescriptionLength[0]);

                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxGuidanceManeuverStorageCapacity = new U16[1];
                if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxGuidanceManeuverStorageCapacity) return NULL; //lint !e429 deleted by IAP2_Disconnect
                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxGuidanceManeuverStorageCapacity_count = 1;
                iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxGuidanceManeuverStorageCapacity[0] = RGDisplayComponentInfos.at(i).GuidanceManeuverCapacity;
                VARTRACE(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxGuidanceManeuverStorageCapacity_count);
                VARTRACE(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxGuidanceManeuverStorageCapacity[0]);
            }
        }
#endif
    }

#ifdef TARGET_BUILD_GEN3_IAP
    //ProductPlanUUID
    if(!LocalSPM::GetDataProvider().iPodControliAP2ProductPlanUUID().empty())
    {
        size_t size = 0;
        size = strnlen(LocalSPM::GetDataProvider().iPodControliAP2ProductPlanUUID().c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
        iAP2InitParameter->p_iAP2AccessoryInfo->iAP2ProductPlanUUID = new U8[size];
        if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2ProductPlanUUID)
        {
            return NULL;  //lint !e429 deleted by IAP2_Disconnect
        }
        strncpy_r((char*)iAP2InitParameter->p_iAP2AccessoryInfo->iAP2ProductPlanUUID, LocalSPM::GetDataProvider().iPodControliAP2ProductPlanUUID().c_str(), size);
        VARTRACE(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2ProductPlanUUID);
    }
    else
    {
        ETG_TRACE_USR3(("ProductPlanUID is empty"));
    }
#endif

#ifdef IPODCONTROL_IAP2_PF_R22
    //DisplayName available with ADIT E49 build
    size_t size_display = strnlen(LocalSPM::GetDataProvider().iPodControlAccessoryInfoBTName().c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
    iAP2InitParameter->p_iAP2AccessoryInfo->iAP2VehicleInformationComponent->iAP2DisplayName = new U8[size_display];
    if(!iAP2InitParameter->p_iAP2AccessoryInfo->iAP2VehicleInformationComponent->iAP2DisplayName) return NULL; //lint !e429 deleted by IAP2_Disconnect
    strncpy_r((char *)iAP2InitParameter->p_iAP2AccessoryInfo->iAP2VehicleInformationComponent->iAP2DisplayName, LocalSPM::GetDataProvider().iPodControlAccessoryInfoBTName().c_str(), size_display);
#endif

    //CSCallbacks
    iAP2InitParameter->p_iAP2CSCallbacks = new iAP2SessionCallbacks_t;
    if(!iAP2InitParameter->p_iAP2CSCallbacks) return NULL; //lint !e429 deleted by IAP2_Disconnect
    memset(iAP2InitParameter->p_iAP2CSCallbacks, 0, sizeof(iAP2SessionCallbacks_t));
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2AuthenticationFailed_cb                    = &CBIAP2_AuthenticationFailed;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2AuthenticationSucceeded_cb                 = &CBIAP2_AuthenticationSucceeded;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2RequestAuthenticationCertificate_cb        = NULL;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2RequestAuthenticationChallengeResponse_cb  = NULL;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2StartIdentification_cb                     = NULL;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2IdentificationAccepted_cb                  = &CBIAP2_IdentificationAccepted;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2IdentificationRejected_cb                  = &CBIAP2_IdentificationRejected;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2BluetoothConnectionUpdate_cb               = &CBIAP2_BluetoothConnectionUpdate;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2DeviceAuthenticationCertificate_cb         = NULL;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2DeviceAuthenticationResponse_cb            = NULL;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2DeviceInformationUpdate_cb                 = &CBIAP2_DeviceInformationUpdate;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2DeviceLanguageUpdate_cb                    = &CBIAP2_DeviceLanguageUpdate;
#ifdef IPODCONTROL_IAP2_PF_R22
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2CallStateUpdate_cb                         = &CBIAP2_CallStateUpdate;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2CommunicationsUpdate_cb                    = &CBIAP2_CommunicationsUpdate;
#else
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2TelephonyCallStateInformation_cb           = &CBIAP2_TelephonyCallStateInformation;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2TelephonyUpdate_cb                         = &CBIAP2_TelephonyUpdate;
#endif
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2StartVehicleStatusUpdates_cb               = &CBIAP2_StartVehicleStatusUpdates;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2StopVehicleStatusUpdates_cb                = &CBIAP2_StopVehicleStatusUpdates;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2AssistiveTouchInformation_cb               = NULL;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2DeviceHIDReport_cb                         = &CBIAP2_DeviceHIDReport;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2StartLocationInformation_cb                = &CBIAP2_StartLocationInformation;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2StopLocationInformation_cb                 = &CBIAP2_StopLocationInformation;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2MediaLibraryInformation_cb                 = &CBIAP2_MediaLibraryInfo;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2MediaLibraryUpdate_cb                      = &CBIAP2_MediaLibraryUpdates;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2NowPlayingUpdateParameter_cb               = &CBIAP2_NowPlayingUpdate;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2PowerUpdate_cb                             = &CBIAP2_PowerUpdate;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2GPRMCDataStatusValuesNotification_cb       = &CBIAP2_GPRMCDataStatusValuesNotification;
#ifdef IPODCONTROL_IAP2_PF_R26
#ifdef TARGET_BUILD
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2RouteGuidanceUpdate_cb                     = &CBIAP2_RouteGuidanceUpdate;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2RouteGuidanceManeuverUpdate_cb             = &CBIAP2_RouteGuidanceManeuverUpdate;
#endif
#endif
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2USBDeviceModeAudioInformation_cb           = &CBIAP2_USBDeviceModeAudioInformation;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2VoiceOverUpdate_cb                         = NULL;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2WiFiInformation_cb                         = NULL;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2StartExternalAccessoryProtocolSession_cb   = &CBIAP2_StartExternalAccessoryProtocolSession;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2StopExternalAccessoryProtocolSession_cb    = &CBIAP2_StopExternalAccessoryProtocolSession;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2DeviceTimeUpdate_cb                        = &CBIAP2_DeviceTimeUpdate;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2DeviceUUIDUpdate_cb                        = &CBIAP2_DeviceUUIDUpdate;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2WirelessCarPlayUpdate_cb                   = &CBIAP2_WirelessCarPlayUpdate;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2RequestAccessoryWiFiConfigurationInformation_cb  = &CBIAP2_RequestAccessoryWiFiConfigurationInformation;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2ListUpdate_cb                              = &CBIAP2_ListUpdate;
#ifdef IPODCONTROL_IAP2_PF_OOBBT_AVAIL
#ifdef TARGET_BUILD
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2StartOOBBTPairing_cb                       = &CBIAP2_StartOOBBTPairing;
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2OOBBTPairingLinkKeyInformation_cb          = &CBIAP2_OOBBTPairingLinkKeyInformation;
#endif
#endif

#ifdef IPODCONTROL_IAP2_PF_R26
#ifdef TARGET_BUILD
    iAP2InitParameter->p_iAP2CSCallbacks->iAP2DeviceTransportIdentifierNotification_cb   = &CBIAP2_DeviceTransportIdentifierNotification;
#endif
#endif
    //Stack callbacks
    iAP2InitParameter->p_iAP2StackCallbacks = new iAP2StackCallbacks_t;
    if(!iAP2InitParameter->p_iAP2StackCallbacks) return NULL; //lint !e429 deleted by IAP2_Disconnect
    memset(iAP2InitParameter->p_iAP2StackCallbacks, 0, sizeof(iAP2StackCallbacks_t));
    iAP2InitParameter->p_iAP2StackCallbacks->p_iAP2DeviceState_cb = &CBIAP2_DeviceState;

    //FileTransfer callbacks
    iAP2InitParameter->p_iAP2FileTransferCallbacks = new iAP2FileTransferCallbacks_t;
    if(!iAP2InitParameter->p_iAP2FileTransferCallbacks) return NULL; //lint !e429 deleted by IAP2_Disconnect
    memset(iAP2InitParameter->p_iAP2FileTransferCallbacks, 0, sizeof(iAP2FileTransferCallbacks_t));
    iAP2InitParameter->p_iAP2FileTransferCallbacks->iAP2FileTransferSuccess_cb           = &CBIAP2_FileTransferSuccess;
    iAP2InitParameter->p_iAP2FileTransferCallbacks->iAP2FileTransferFailure_cb           = &CBIAP2_FileTransferFailure;
    iAP2InitParameter->p_iAP2FileTransferCallbacks->iAP2FileTransferCancel_cb            = &CBIAP2_FileTransferCancel;
    iAP2InitParameter->p_iAP2FileTransferCallbacks->iAP2FileTransferPause_cb             = &CBIAP2_FileTransferPause;
    iAP2InitParameter->p_iAP2FileTransferCallbacks->iAP2FileTransferResume_cb            = &CBIAP2_FileTransferResume;
    iAP2InitParameter->p_iAP2FileTransferCallbacks->iAP2FileTransferDataRcvd_cb          = &CBIAP2_FileTransferDataRcvd;
    iAP2InitParameter->p_iAP2FileTransferCallbacks->iAP2FileTransferSetup_cb             = &CBIAP2_FileTransferSetup;

    //EA callbacks
    iAP2InitParameter->p_iAP2EAPSessionCallbacks = new iAP2EAPSessionCallbacks_t;
    if(!iAP2InitParameter->p_iAP2EAPSessionCallbacks) return NULL; //lint !e429 deleted by IAP2_Disconnect
    memset(iAP2InitParameter->p_iAP2EAPSessionCallbacks, 0, sizeof(iAP2EAPSessionCallbacks_t));
    iAP2InitParameter->p_iAP2EAPSessionCallbacks->iAP2iOSAppDataReceived_cb = &CBIAP2_iOSAppDataReceived;

    // EA Native Transport callbacks
    iAP2InitParameter->p_iAP2EANativeTransportCallbacks = new iAP2EANativeTransportCallbacks_t;
    if(!iAP2InitParameter->p_iAP2EANativeTransportCallbacks) return NULL; //lint !e429 deleted by IAP2_Disconnect
    memset(iAP2InitParameter->p_iAP2EANativeTransportCallbacks , 0 , sizeof(iAP2EANativeTransportCallbacks_t));
    iAP2InitParameter->p_iAP2EANativeTransportCallbacks->p_iAP2StartEANativeTransport_cb = &CBIAP2_StartEANativeTransport;
    iAP2InitParameter->p_iAP2EANativeTransportCallbacks->p_iAP2StopEANativeTransport_cb  = &CBIAP2_StopEANativeTransport;

    return iAP2InitDeviceStructure(iAP2InitParameter); //lint !e429 deleted by IAP2_Disconnect
}
#endif

tResult iPodControlIAP::iAP2_InitDeviceConnection(const tMountPoint mountPoint, const tBoolean hostMode, const tBoolean carPlay, const tBoolean nativeTransport,const tBoolean wirelessCarplay,const tBoolean carLife)
{
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(hostMode);
    VARTRACE(carPlay);
    VARTRACE(nativeTransport);
    VARTRACE(mHostModeErrorCount[mountPoint]);
    tResult ret = MP_NO_ERROR;
    const tDeviceID deviceID = iAPGetDeviceID(mountPoint);
    VARTRACE(deviceID);
#ifdef IPODCONTROL_IAP2_PF_AVAIL

    m_HandleMap.LockIAP2(mountPoint); //start critical section

    iAP2Device_t * iap2Device = iAP2_InitDeviceStructure(mountPoint, hostMode, carPlay, nativeTransport,wirelessCarplay, carLife);
    if (!iap2Device) {
        ETG_TRACE_ERR(("iAP2InitDeviceStructure failed"));
        ret = MP_ERR_IPOD_INIT;
    } else {
        ETG_TRACE_USR3(("*** GOT IAP2 DEVICE for '%s'", mountPoint));
        m_HandleMap.SetIAP2Device(mountPoint, (void *)iap2Device);

        int res = IAP2_OK;
        if(hostMode) {
            ret = SwitchToHostMode(mountPoint);
            ETG_TRACE_USR3(("SwitchToHostMode returned %d", ret));
            if(ret != IAP2_OK) {
                res = IAP2_ERR_USB_ROLE_SWITCH_FAILED;
                LocalSPM::GetOutputWrapper().UpdateDipoCommunicationError(deviceID,IPOD_ROLESWITCH_ERROR,mountPoint);
            }
        }

        if(res == IPOD_OK) {
        ETG_TRACE_USR3(("call iAP2InitDeviceConnection"));
            res = iAP2InitDeviceConnection(iap2Device);
        ETG_TRACE_USR3(("iAP2InitDeviceConnection returned: %d", res));
        }
        if(hostMode && res != IAP2_OK) {
            //inc host mode error counter
            mHostModeErrorCount[mountPoint]++;
            m_HandleMap.ResetElapsedTime(mountPoint, iap2LastHostModeError);
        }

        if(res == IAP2_ERR_USB_ROLE_SWITCH_UNSUP || res == IAP2_ERR_USB_ROLE_SWITCH_FAILED) {
            ETG_TRACE_USR3(("HOST MODE not supported, switching back to DEVICE MODE"));
            iAP2_DisconnectDeviceConnection(mountPoint, true, false); //Do not call iAP2DisconnectDevice - SUZUKI-23052
            iAPClearAppInfofromSPI(mountPoint);

            //deactivating host mode, retry with device mode
            iap2Device = iAP2_InitDeviceStructure(mountPoint, FALSE, FALSE, FALSE,FALSE);
            if (!iap2Device) {
                ETG_TRACE_ERR(("iAP2InitDeviceStructure failed"));
                ret = MP_ERR_IPOD_INIT;
            } else {
                ETG_TRACE_USR3(("*** GOT IAP2 DEVICE for '%s'", mountPoint));
                m_HandleMap.SetIAP2Device(mountPoint, (void *)iap2Device);

                ret = MP_NO_ERROR; //reset return code
                res = iAP2InitDeviceConnection(iap2Device);
                ETG_TRACE_USR3(("iAP2InitDeviceConnection returned: %d", res));
            }
        }
        if(res != IAP2_OK) {
            ret = MP_ERR_IPOD_INIT;
        }
    }
    m_HandleMap.UnlockIAP2(mountPoint); //end critical section
#else
    ret = MP_ERR_IPOD_INIT;
#endif
    return ret;
}

tResult iPodControlIAP::iAP1_DisconnectDeviceConnection(const tMountPoint mountPoint, const bool resetAllParameters) {
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(resetAllParameters);
    tResult ret = MP_NO_ERROR;

    if (IPOD_OK != m_IAP1Init) {
        ETG_TRACE_USR3(("iAP1 library not initialized"));
        ret = MP_ERR_IPOD_INIT;
    } else {
        const int iPodID = m_HandleMap.GetiPodID(mountPoint);
        if (iPodID > 0) {
            sKnownUSBiAP1Devices.push_back(string(mountPoint));
            iPodDisconnectDevice((S32) iPodID);
        }

        //notify app control clients about data session end
        iAPUpdateCloseAllActiveSessions(mountPoint);

        iAPClearAllVTRecords(mountPoint);
        m_HandleMap.Reset(mountPoint, resetAllParameters);
    }
    return ret;
}

tResult iPodControlIAP::iAP2_DisconnectDeviceConnection(const tMountPoint mountPoint, const bool resetAllParameters, const bool callDisconnect) {
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(resetAllParameters);
    VARTRACE(callDisconnect);
    tResult ret = MP_NO_ERROR;
    tBoolean hostMode = false;
    tBoolean roleSwitched = false;

    hostMode = IsIAP2HostMode(mountPoint);
    VARTRACE(hostMode);

    const tBoolean carPlay = IsIAP2CarPlayMode(mountPoint);
    VARTRACE(carPlay);

    const tBoolean wirelessCarPlay = IsIAP2WirelessCarPlayMode(mountPoint);
    VARTRACE(wirelessCarPlay);

    const tBoolean nativeTransport = IsIAP2NativeTransportMode(m_MountPoint);
    const tBoolean carLife =  IsIAP2NativeTransportCarlifeMode(m_MountPoint);
    const tBoolean mySpin =  (nativeTransport && !carLife) ? true:false;

    VARTRACE(nativeTransport);
    VARTRACE(carLife);
    VARTRACE(mySpin);

    const tBoolean isCPWActive = m_HandleMap.GetIsCPWActiveForUSBMountPoint(mountPoint);
    VARTRACE(isCPWActive);
    if(carPlay && isCPWActive)
    {
        m_HandleMap.SetIsCPWActiveForUSBMountpoint(mountPoint,false);
    }
    if(wirelessCarPlay)
    {
        tMountPoint USBMountPoint = {0};
        if( MP_NO_ERROR == GetUSBMountPointbyCPWMountPoint(mountPoint, USBMountPoint) )
        {
            m_HandleMap.SetIsCPWActiveForUSBMountpoint(USBMountPoint,false);
        }
    }

    if(iAPGetConnectionType(mountPoint) == DCT_USB){
        roleSwitched = m_HandleMap.GetRoleSwitched(mountPoint);    //NCG3D-89502 -  Check for role switched only for USB connections
        hostMode = IsIAP2HostMode(mountPoint);
        VARTRACE(roleSwitched);
    }

#ifdef IPODCONTROL_IAP2_PF_AVAIL
    int res = IAP2_OK;

    tDeviceInfo deviceInfo;
    m_HandleMap.GetDeviceInfo(mountPoint, deviceInfo);

    m_HandleMap.LockIAP2(mountPoint); //start critical section

    iAP2InitParam_t * iAP2InitParameter = (iAP2InitParam_t *)m_HandleMap.GetIAP2InitParameter(mountPoint);
    iAP2Device_t * iap2Device = (iAP2Device_t *)m_HandleMap.GetIAP2Device(mountPoint);
    if(iap2Device && iAP2InitParameter) {
        //clear albumart buffer
        tFileXferBuf * pBuf = (tFileXferBuf *) m_HandleMap.GetIAP2AlbumArtBuffer(mountPoint);
        if(pBuf) {
            ETG_TRACE_USR3(("Found obsolete album art buffer for transferID %d - clearing", pBuf->transferID));
            delete [] pBuf->buffer;
            delete pBuf;
        }
        pBuf = 0;
        m_HandleMap.SetIAP2AlbumArtBuffer(mountPoint, pBuf);

        //clear queue list buffer
        tFileXferBuf * pQueueListBuf = (tFileXferBuf *) m_HandleMap.GetQueueListBuffer(mountPoint);
        if(pQueueListBuf) {
            ETG_TRACE_USR3(("Found obsolete queue list buffer for transferID %d - clearing", pQueueListBuf->transferID));
            delete [] pQueueListBuf->buffer;
            delete pQueueListBuf;
        }
        pQueueListBuf = 0;
        m_HandleMap.SetQueueListBuffer(mountPoint, pQueueListBuf);

        //Check if device is already disconnected
        if(deviceInfo.connectionState != CS_CONNECTED) {
            ETG_TRACE_USR3(("Device not connected"));
        } else {
            if((!carPlay && !wirelessCarPlay && !mySpin && !carLife) || LocalSPM::GetDataProvider().iPodControlIAP2CarPlayModeEnabled()) {
                //stop HID
                if(LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp() && deviceInfo.connectionType != DCT_BLUETOOTH){
                ETG_TRACE_USR3(("calling iAP2StopHID"));
                iAP2StopHIDParameter stopHIDParameter;
                memset(&stopHIDParameter, 0, sizeof(iAP2StopHIDParameter) );
                stopHIDParameter.iAP2HIDComponentIdentifier = new U16[1];
                if(stopHIDParameter.iAP2HIDComponentIdentifier != NULL) {
                    stopHIDParameter.iAP2HIDComponentIdentifier[0] = IAP2_HID_COMPONENT_IDENTIFIER;
                    stopHIDParameter.iAP2HIDComponentIdentifier_count++;
                }
                res = iAP2StopHID(iap2Device, &stopHIDParameter);
                ETG_TRACE_USR3(("iAP2StopHID returned %d", res));
                if(res != IAP2_OK) {
                    UpdateIpodCommunicationError(res);
                }
                iAP2FreeiAP2StopHIDParameter(&stopHIDParameter);
              }
              else if(!LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp()){
                ETG_TRACE_USR3(("calling iAP2StopHID"));
                iAP2StopHIDParameter stopHIDParameter;
                memset(&stopHIDParameter, 0, sizeof(iAP2StopHIDParameter) );
                stopHIDParameter.iAP2HIDComponentIdentifier = new U16[1];
                if(stopHIDParameter.iAP2HIDComponentIdentifier != NULL) {
                    stopHIDParameter.iAP2HIDComponentIdentifier[0] = IAP2_HID_COMPONENT_IDENTIFIER;
                    stopHIDParameter.iAP2HIDComponentIdentifier_count++;
                }
                res = iAP2StopHID(iap2Device, &stopHIDParameter);
                ETG_TRACE_USR3(("iAP2StopHID returned %d", res));
                if(res != IAP2_OK) {
                    UpdateIpodCommunicationError(res);
                }
                iAP2FreeiAP2StopHIDParameter(&stopHIDParameter);
              }
            }

            if((wirelessCarPlay || hostMode) && !mySpin && !carLife && LocalSPM::GetDataProvider().iPodControlIAP2CallStateUpdateEnabled()) {
                //stop telephone call state updates
#ifdef IPODCONTROL_IAP2_PF_R22
                iAP2StopCallStateUpdatesParameter stopCallStateUpdatesParameter;
                memset(&stopCallStateUpdatesParameter, 0, sizeof(iAP2StopCallStateUpdatesParameter));
                res = iAP2StopCallStateUpdates(iap2Device, &stopCallStateUpdatesParameter);
                ETG_TRACE_USR3(("iAP2StopCallStateUpdates returned %d", res));
                if(res != IAP2_OK) {
                    UpdateIpodCommunicationError(res);
                }
#else
                iAP2StopTelephonyCallStateInformationParameter stopTelephonyCallStateInformationParameter;
                memset(&stopTelephonyCallStateInformationParameter, 0, sizeof(iAP2StopTelephonyCallStateInformationParameter));
                res = iAP2StopTelephonyCallStateInformation(iap2Device, &stopTelephonyCallStateInformationParameter);
                ETG_TRACE_USR3(("iAP2StopTelephonyCallStateInformation returned %d", res));
                if(res != IAP2_OK) {
                    UpdateIpodCommunicationError(res);
                }
#endif
            }

            if((wirelessCarPlay || hostMode) && !mySpin && !carLife && LocalSPM::GetDataProvider().iPodControlIAP2CommunicationsUpdateEnabled()) {
                //stop telephone updates
#ifdef IPODCONTROL_IAP2_PF_R22
                iAP2StopCommunicationsUpdatesParameter stopCommunicationsUpdatesParameter;
                memset(&stopCommunicationsUpdatesParameter, 0, sizeof(iAP2StopCommunicationsUpdatesParameter));
                res = iAP2StopCommunicationsUpdates(iap2Device, &stopCommunicationsUpdatesParameter);
                ETG_TRACE_USR3(("iAP2StopCommunicationsUpdates returned %d", res));
                if(res != IAP2_OK) {
                    UpdateIpodCommunicationError(res);
                }
#else
                iAP2StopTelephonyUpdatesParameter stopTelephonyUpdatesParameter;
                memset(&stopTelephonyUpdatesParameter, 0, sizeof(iAP2StopTelephonyUpdatesParameter));
                res = iAP2StopTelephonyUpdates(iap2Device, &stopTelephonyUpdatesParameter);
                ETG_TRACE_USR3(("iAP2StopTelephonyUpdatesParameter returned %d", res));
                if(res != IAP2_OK) {
                    UpdateIpodCommunicationError(res);
                }
#endif
            }

            if(!wirelessCarPlay && !isCPWActive && !mySpin && !carLife && LocalSPM::GetDataProvider().iPodControlIAP2BTConnectionUpdatesEnabled()) {
                if(LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp() && deviceInfo.connectionType != DCT_BLUETOOTH){
                //stop bt updates
                iAP2StopBluetoothConnectionUpdatesParameter stopBluetoothConnectionUpdatesParameter;
                memset(&stopBluetoothConnectionUpdatesParameter, 0, sizeof(stopBluetoothConnectionUpdatesParameter));
                res = iAP2StopBluetoothConnectionUpdates(iap2Device, &stopBluetoothConnectionUpdatesParameter);
                ETG_TRACE_USR3(("iAP2StopBluetoothConnectionUpdates returned %d", res));
                if(res != IAP2_OK) {
                    UpdateIpodCommunicationError(res);
                   }
                }
                else if(!LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp()){
                    iAP2StopBluetoothConnectionUpdatesParameter stopBluetoothConnectionUpdatesParameter;
                    memset(&stopBluetoothConnectionUpdatesParameter, 0, sizeof(stopBluetoothConnectionUpdatesParameter));
                    res = iAP2StopBluetoothConnectionUpdates(iap2Device, &stopBluetoothConnectionUpdatesParameter);
                    ETG_TRACE_USR3(("iAP2StopBluetoothConnectionUpdates returned %d", res));
                    if(res != IAP2_OK) {
                        UpdateIpodCommunicationError(res);
                  }
                }
            }

#if 0   //SUZUKI-16788
        //moved call iAP2StartUSBDeviceModeAudio to StartStop
            //stop usb device mode audio
            if(iAP2InitParameter->p_iAP2AccessoryConfig && iAP2InitParameter->p_iAP2AccessoryConfig->iAP2TransportType != iAP2USBHOSTMODE && deviceInfo.connectionType != DCT_BLUETOOTH) {
                iAP2StopUSBDeviceModeAudioParameter usbDeviceModeAudioParameter;
                memset(&usbDeviceModeAudioParameter, 0, sizeof(usbDeviceModeAudioParameter) );
                res = iAP2StopUSBDeviceModeAudio(iap2Device, &usbDeviceModeAudioParameter);
                ETG_TRACE_USR3(("iAP2StopUSBDeviceModeAudio returned %d", res));
            }
#endif
            if(!mySpin && !carLife)
            {
                //stop nowplaying updates
                if(LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp() && deviceInfo.connectionType != DCT_BLUETOOTH){
                    ETG_TRACE_USR3(("calling iAP2StopNowPlayingUpdates"));
                    iAP2StopNowPlayingUpdatesParameter nowPlayingUpdatesParameter;
                    memset(&nowPlayingUpdatesParameter, 0, sizeof(iAP2StopNowPlayingUpdatesParameter));
                    res = iAP2StopNowPlayingUpdates(iap2Device, &nowPlayingUpdatesParameter);
                    ETG_TRACE_USR3(("iAP2StopNowPlayingUpdates returned: %d", res));
                    if(res != IAP2_OK) {
                        UpdateIpodCommunicationError(res);
                    }
                }
                else if(!LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp()){
                    ETG_TRACE_USR3(("calling iAP2StopNowPlayingUpdates"));
                    iAP2StopNowPlayingUpdatesParameter nowPlayingUpdatesParameter;
                    memset(&nowPlayingUpdatesParameter, 0, sizeof(iAP2StopNowPlayingUpdatesParameter));
                    res = iAP2StopNowPlayingUpdates(iap2Device, &nowPlayingUpdatesParameter);
                    ETG_TRACE_USR3(("iAP2StopNowPlayingUpdates returned: %d", res));
                    if(res != IAP2_OK) {
                        UpdateIpodCommunicationError(res);
                    }
                }
            }

            if((!carPlay && !wirelessCarPlay && !mySpin && !carLife) || LocalSPM::GetDataProvider().iPodControlIAP2CarPlayModeEnabled()) {
                if(LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp() && deviceInfo.connectionType != DCT_BLUETOOTH){

                //stop media library information
                ETG_TRACE_USR3(("calling iAP2StopMediaLibraryInformation"));
                iAP2StopMediaLibraryInformationParameter mediaLibraryInformationParameter;
                memset(&mediaLibraryInformationParameter, 0, sizeof(iAP2StopMediaLibraryInformationParameter));
                res = iAP2StopMediaLibraryInformation(iap2Device, &mediaLibraryInformationParameter);
                ETG_TRACE_USR3(("iAP2StopMediaLibraryInformation returned: %d", res));
                if(res != IAP2_OK) {
                    UpdateIpodCommunicationError(res);
                }

                //stop media library update
                iAP2_StopMediaLibraryUpdates(mountPoint);
                }
                else if(!LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp()){
                    //stop media library information
                ETG_TRACE_USR3(("calling iAP2StopMediaLibraryInformation"));
                iAP2StopMediaLibraryInformationParameter mediaLibraryInformationParameter;
                memset(&mediaLibraryInformationParameter, 0, sizeof(iAP2StopMediaLibraryInformationParameter));
                res = iAP2StopMediaLibraryInformation(iap2Device, &mediaLibraryInformationParameter);
                ETG_TRACE_USR3(("iAP2StopMediaLibraryInformation returned: %d", res));
                if(res != IAP2_OK) {
                    UpdateIpodCommunicationError(res);
                }

                //stop media library update
                iAP2_StopMediaLibraryUpdates(mountPoint);
                }
            }
            //Stop List Updates
            if((wirelessCarPlay || carPlay) && !mySpin && !carLife && LocalSPM::GetDataProvider().iPodControlIAP2ListUpdateEnabled()) {
                iAP2StopListUpdatesParameter listUpdateParameter;
                memset(&listUpdateParameter, 0, sizeof(iAP2StopListUpdatesParameter));
                res = iAP2StopListUpdates(iap2Device, &listUpdateParameter);
                ETG_TRACE_USR3(("iAP2StopListUpdates returned %d", res));

            }

            //stop power updates (not for BT)
            if(deviceInfo.connectionType != DCT_BLUETOOTH)
            {
                ETG_TRACE_USR3(("calling iAP2StopPowerUpdates"));
                iAP2StopPowerUpdatesParameter stopPowerUpdatesParameter;
                memset(&stopPowerUpdatesParameter, 0, sizeof(iAP2StopPowerUpdatesParameter));
                res = iAP2StopPowerUpdates(iap2Device, &stopPowerUpdatesParameter);
                ETG_TRACE_USR3(("iAP2StopPowerUpdates returned: %d", res));
            }
        }

        //clear internal init parameters before calling final disconnect to prevent recrusion on reverse role switch
        //m_HandleMap.SetIAP2InitParameter(mountPoint, NULL);

        if(callDisconnect) {
        //disconnect device
        ETG_TRACE_USR3(("calling iAP2DisconnectDevice"));
        res = iAP2DisconnectDevice(iap2Device);
        ETG_TRACE_USR3(("iAP2DisconnectDevice returned: %d", res));
        }
        //deinit structure
        ETG_TRACE_USR3(("calling iAP2DeInitDeviceStructure"));
        res = iAP2DeInitDeviceStructure(iap2Device);
        ETG_TRACE_USR3(("iAP2DeInitDeviceStructure returned: %d", res));

        m_HandleMap.SetIAP2Device(mountPoint, NULL);
    }

    if(iAP2InitParameter) {
        if(iAP2InitParameter->p_iAP2AccessoryConfig) {
            delete[] iAP2InitParameter->p_iAP2AccessoryConfig->iAP2UsbOtgGPIOPower;

        }
        delete iAP2InitParameter->p_iAP2AccessoryConfig;

        if(iAP2InitParameter->p_iAP2AccessoryInfo) {
            delete[] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryName;
            delete[] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryModelIdentifier;
            delete[] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryManufacturer;
            delete[] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessorySerialNumber;
            delete[] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryFirmwareVersion;
            delete[] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryHardwareVersion;
            delete[] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryVendorId;
            delete[] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryProductId;
            delete[] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2AccessoryBcdDevice;
            delete[] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2InitEndPoint;
            delete[] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2CommandsUsedByApplication;
            delete[] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2CallbacksExpectedFromDevice;
            delete[] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2CurrentLanguage;
            for(unsigned int i = 0; i < iAP2InitParameter->p_iAP2AccessoryInfo->iAP2SupportedLanguageCount; i++) {
                delete[] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2SupportedLanguage[i];
            }
            delete[] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2SupportedLanguage;
            for(unsigned int i = 0; i < iAP2InitParameter->p_iAP2AccessoryInfo->iAP2SupportediOSAppCount; i++) {
                delete[] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2iOSAppInfo[i].iAP2iOSAppName;
            }
            delete[] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2iOSAppInfo;
            for(unsigned int i = 0; i < iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent_count; i++) {
                delete iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent[i].iAP2HIDComponentFunction;
                delete [] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent[i].iAP2HIDComponentIdentifier;
                for(unsigned int ii = 0; ii < iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent[i].iAP2HIDComponentName_count; ii++) {
                    delete [] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent[i].iAP2HIDComponentName[ii];
                }
                delete [] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBHIDComponent[i].iAP2HIDComponentName;
            }
            delete [] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2USBDeviceSupportedAudioSampleRate;
            if(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2VehicleInformationComponent) {
                delete iAP2InitParameter->p_iAP2AccessoryInfo->iAP2VehicleInformationComponent->iAP2EngineType; //single engine type
#ifdef IPODCONTROL_IAP2_PF_R22
                delete [] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2VehicleInformationComponent->iAP2DisplayName;
#endif
                delete iAP2InitParameter->p_iAP2AccessoryInfo->iAP2VehicleInformationComponent;
            }
            delete iAP2InitParameter->p_iAP2AccessoryInfo->iAP2VehicleStatusComponent;
            delete iAP2InitParameter->p_iAP2AccessoryInfo->iAP2LocationInformationComponent;
            if(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent) {
                for(unsigned int i = 0; i < iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent_count; i++) {
                    iAP2FreeiAP2BluetoothTransportComponent(&iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent[i]);
                }
                delete [] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent;
            }

            if(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2WirelessCarPlayTransportComponent) {
                delete iAP2InitParameter->p_iAP2AccessoryInfo->iAP2WirelessCarPlayTransportComponent;
            }

            for(unsigned int i = 0; i < iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent_count; i++) {
                delete iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2Identifier;
                for(unsigned int ii = 0; ii < iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2Name_count; ii++) {
                    delete [] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2Name[ii];
                }
                delete [] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2Name;
                delete [] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxCurrentRoadNameLength;
                delete [] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxDestinationRoadNameLength;
                delete [] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxAfterManeuverRoadNameLength;
                delete [] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxManeuverDescriptionLength;
                delete [] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent[i].iAP2MaxGuidanceManeuverStorageCapacity;
            }
            delete [] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2RouteGuidanceDisplayComponent;

#ifdef TARGET_BUILD_GEN3_IAP
            if(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2ProductPlanUUID)
            {
                delete [] iAP2InitParameter->p_iAP2AccessoryInfo->iAP2ProductPlanUUID;
            }
#endif
        }
        delete iAP2InitParameter->p_iAP2AccessoryInfo;

        delete iAP2InitParameter->p_iAP2CSCallbacks;
        delete iAP2InitParameter->p_iAP2StackCallbacks;
        delete iAP2InitParameter->p_iAP2FileTransferCallbacks;
        delete iAP2InitParameter->p_iAP2EAPSessionCallbacks;
        delete iAP2InitParameter->p_iAP2EANativeTransportCallbacks;
        delete iAP2InitParameter;

        m_HandleMap.SetIAP2InitParameter(mountPoint, NULL);
    }
    m_HandleMap.UnlockIAP2(mountPoint); //end critical section

    int pollThreadCount = 0;

    //sync with poll thread end
    while(m_HandleMap.GetPollThreadIndex(mountPoint) >= 0) {
        ETG_TRACE_USR3(("waiting for poll thread end '%s'", mountPoint));
        usleep(100000);
        pollThreadCount++;
        if(pollThreadCount >= 200){        //To exit the Poll thread index from indefinite looping
            break;
        }
    }

    //notify app control clients about data session end
    iAPUpdateCloseAllActiveSessions(mountPoint);

    iAPClearAllVTRecords(mountPoint);

    //check for role switch
    const tBoolean reverseRoleSwitchRequred = hostMode && roleSwitched;
    VARTRACE(reverseRoleSwitchRequred);

    //reset all attributes
    m_HandleMap.Reset(mountPoint, resetAllParameters);

    //update AppControl properties
    iAP2UpdateAllAppControlProperties(mountPoint);

    //role back from host mode
    if(reverseRoleSwitchRequred) {
        iAPClearAppInfofromSPI(mountPoint);
        res = SwitchToDeviceMode(mountPoint, deviceInfo.connectionState);
        ETG_TRACE_USR3(("SwitchToDeviceMode returned: %d", res));
    }
#endif
    return ret;
}

tResult iPodControlIAP::iAP1_OnDeviceInitialized(const tMountPoint mountPoint, const tConnectionState connectionState) {
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(connectionState);
    tResult ret = MP_NO_ERROR;

    m_HandleMap.SetConnectionState(mountPoint, connectionState);
    m_HandleMap.SetOption(mountPoint, hasIAP2Option, false);

    if (CS_CONNECTED == connectionState) {
        if (!SelectDevice(mountPoint)) {
            ret = MP_ERR_IPOD_NO_ACCESS;
        } else {
            iAP1_IdentifyDevice();
        }
    } else if (CS_ATTACHED != connectionState) {
        iAP1_DisconnectDeviceConnection(mountPoint, true);
    }
    return ret;
}

tResult iPodControlIAP::iAP2_OnDeviceInitialized(const tMountPoint mountPoint, const tConnectionState connectionState) {
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(connectionState);
    tResult ret = MP_NO_ERROR;

    m_HandleMap.SetConnectionState(mountPoint, connectionState);
    m_HandleMap.SetOption(mountPoint, hasIAP2Option, true);

    tDeviceInfo deviceInfo;
    m_HandleMap.GetDeviceInfo(mountPoint, deviceInfo);

    if (CS_CONNECTED == connectionState
        || ((DCT_BLUETOOTH == deviceInfo.connectionType)
                && (CS_ATTACHED == connectionState) && LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp() )) {
        if (!SelectDevice(mountPoint)) {
            ret = MP_ERR_IPOD_NO_ACCESS;
        } else {
            ret = iAP2_IdentifyDevice();
        }
        if(ret != MP_NO_ERROR) {
            iAP2_DisconnectDeviceConnection(mountPoint, true);
        }
    } else if (CS_ATTACHED != connectionState) {
        if(!LocalSPM::GetDataProvider().iPodControlSupportIAP1()) {
#ifdef IPODCONTROL_IAP2_PF_AVAIL
            m_HandleMap.LockIAP2(mountPoint); //start critical section
            iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(mountPoint);
            if(iap2Device) {
                int res = iAP2CanceliAP1Support(iap2Device);
                ETG_TRACE_USR3(("iAP2CanceliAP1Support returned %d", res));
            }
            m_HandleMap.UnlockIAP2(mountPoint); //end critical section
#endif
        }
        if(CS_UNSUPPORTED == connectionState && IsIAP2HostMode(mountPoint)) {
            //JAC-2752
            //IAP1 device
             mHostModeErrorCount[mountPoint]++;
             m_HandleMap.ResetElapsedTime(mountPoint, iap2LastHostModeError);
             mKnownUSBiAP1Devices.push_back(string(mountPoint));
        }
        iAP2_DisconnectDeviceConnection(mountPoint, true);
    }
    return ret;
}

//Getter w/o IAP access
tBoolean iPodControlIAP::iAP_IsDeviceHandleAvail(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;

    if (!mountPoint || mountPoint[0] == 0) {
        ETG_TRACE_ERR(("Invalid mountPoint"));
        return false;
    }

    if(IsIAP2(mountPoint)) {
        if (NULL != m_HandleMap.GetIAP2Device(mountPoint)) {
            return true;
        }
    } else {
        if (0 < m_HandleMap.GetiPodID(mountPoint)) {
            return true;
        }
    }
    return false;
}

tBoolean iPodControlIAP::iAP2_IsSet(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return IsIAP2(mountPoint);
}

tBoolean iPodControlIAP::iAP2_IsHostMode(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return IsIAP2HostMode(mountPoint);
}

tBoolean iPodControlIAP::iAP2_IsCarPlayMode(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return IsIAP2CarPlayMode(mountPoint);
}

tBoolean iPodControlIAP::iAP2_IsNativeTransportMode(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return IsIAP2NativeTransportMode(mountPoint);
}

tBoolean iPodControlIAP::iAP2_IsWirelessCarPlayMode(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return IsIAP2WirelessCarPlayMode(mountPoint);
}

tBoolean iPodControlIAP::iAP2_IsNativeTransportAppConfigured(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    vector<tIPODAppInfo> appInfoList;
    if(LocalSPM::GetDataProvider().iPodControlIAP2AppControlEnabled()) {
        //search for native transport app
        appInfoList = m_HandleMap.GetAppInfos(mountPoint, true, true);
        for(unsigned int i = 0; i < appInfoList.size(); i++) {
            if(appInfoList[i].option == AIO_EA_NATIVE_TRANSPORT) {
                return true;
            }
        }
    }
    return false;
}

tBoolean iPodControlIAP::iAP2_IsNativeTransportCarlifeMode(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return IsIAP2NativeTransportCarlifeMode(mountPoint);
}

tBoolean iPodControlIAP::iAP2_IsHostModePossible(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return IsIAP2HostModePossible(mountPoint);
}

tBoolean iPodControlIAP::iAP2_GetStoredHostModePossibility(const tMountPoint mountPoint) {
    ENTRY;
    return  (IPOD_OTG_NONE != m_HandleMap.GetOTGType(mountPoint))? TRUE: FALSE;
}

tBoolean iPodControlIAP::iAP2_IsCarPlayPossible(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;

    tBoolean isCarPlayPossible = false;

    if(LocalSPM::GetDataProvider().iPodControlWiredCarPlayEnabled())
    {
        isCarPlayPossible = iAP2HasCarPlayCapability(mountPoint);
    }
    else
    {
        ETG_TRACE_USR3(("iPodControlIAP::iAP2_IsCarPlayPossible() - CarPlay is disabled"));
    }

    return isCarPlayPossible;
}

tDiPOCaps iPodControlIAP::iAP2_GetDiPOCaps(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    const bool carplay = IsIAP2CarPlayMode(mountPoint);
    const bool nativeTransport = IsIAP2NativeTransportMode(mountPoint);
    const bool wirelessCarplay = IsIAP2WirelessCarPlayMode(mountPoint);
    const bool carlife = IsIAP2NativeTransportCarlifeMode(mountPoint);

    if(carplay && nativeTransport) {
        return DIPO_CAP_CARPLAY_NATIVE_TRANSPORT;
    } else if(carplay && !nativeTransport) {
        return DIPO_CAP_CARPLAY;
    }else if(carlife && nativeTransport) {
        return DIPO_CAP_CARLIFE;
    } else if(!carplay && nativeTransport) {
        return DIPO_CAP_NATIVE_TRANSPORT;
    } else if(wirelessCarplay) {
        return DIPO_CAP_CARPLAY_WIFI;
    }

    //extended DiPOCaps  - PSARCCB-3298
    if(IsIAP2(mountPoint)) {
        if(iAP2HasOTGPort(mountPoint)){
            if(LocalSPM::GetDataProvider().iPodControlWiredCarPlayEnabled() && iAP2HasCarPlayCapability(mountPoint)) {
                return DIPO_CAP_CARPLAY_FEASIBLE;
            }
            return DIPO_CAP_HOSTMODE_FEASIBLE;
        }
    }
    //If IAP2BT enabled only for APP support then send the tDiPOCaps as DIPO_CAP_IAP2BT
    tDeviceInfo deviceInfo;
    iAPGetDeviceInfo(mountPoint,deviceInfo);
    if(deviceInfo.connectionType == DCT_BLUETOOTH && LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp())
    {
        //Check the Dipo capability updated as DIPO_CAP_CARPLAY_WIFI_FEASIBLE for Carplay Wifi
        tDiPOCaps dipoCap = iAPGetLastWirelessCarplayStatus(mountPoint);

        if(DIPO_CAP_CARPLAY_WIFI_FEASIBLE == dipoCap || DIPO_CAP_CARPLAY_WIFI_NOT_FEASIBLE == dipoCap)
        {
            return dipoCap;
        }

    }

    return DIPO_CAP_NONE;
}

tBoolean iPodControlIAP::iAP2_IsiTunesRadioPlaying(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return IsIAP2iTunesRadioPlaying(mountPoint);
}

tDeviceID iPodControlIAP::iAPGetDeviceID(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetDeviceID(mountPoint);
}

void iPodControlIAP::iAPGetFocusApp(const tMountPoint mountPoint,
        tAppName &appName) {
    ENTRY_INTERNAL;
    m_HandleMap.GetFocusApp(appName, mountPoint);
}

tResult iPodControlIAP::iAP1_GetMountPoint(tMountPoint &mountPoint,
        const int iPodID) {
    ENTRY_INTERNAL;
    tResult ret = MP_NO_ERROR;

    m_HandleMap.GetMountPoint(mountPoint, iPodID);
    if (mountPoint[0] == 0) {
        ETG_TRACE_USR3(("iPodControlIAP::iAP1_GetMountPoint() - get mountpoint failed"));
        ret = MP_ERR_IPOD_NO_ACCESS;
    }
    return ret;
}

tResult iPodControlIAP::iAP2_GetMountPoint(tMountPoint &mountPoint,
        const void * iap2Device) {
    ENTRY_INTERNAL;
    tResult ret = MP_NO_ERROR;

    m_HandleMap.GetMountPoint(mountPoint, iap2Device);
    if (mountPoint[0] == 0) {
        ETG_TRACE_USR3(("iPodControlIAP::iAP2_GetMountPoint() - get mountpoint failed"));
        ret = MP_ERR_IPOD_NO_ACCESS;
    }
    return ret;
}

tResult iPodControlIAP::iAPGetMountPointByPEHandle(tMountPoint &mountPoint,
        const tPEHandle handle) {
    ENTRY_INTERNAL;
    tResult ret = MP_NO_ERROR;

    if (handle == HANDLE_NONE) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        m_HandleMap.GetMountPointByPEHandle(mountPoint, handle);
        if (mountPoint[0] == 0) {
            ret = MP_ERR_IPOD_NO_ACCESS;
        }
    }
    return ret;
}

iAP2DeviceErrorState_t iPodControlIAP::iAP2_GetDeviceErrorState(iAP2Device_t* device, void* context)
{
    ENTRY_INTERNAL;
    return iAP2GetDeviceErrorState(device, context);
}

void iPodControlIAP::iAPGetDeviceInfo(const tMountPoint mountPoint,
        tDeviceInfo &deviceInfo) {
    ENTRY_INTERNAL;
    m_HandleMap.GetDeviceInfo(mountPoint, deviceInfo);
}

tConnectionState iPodControlIAP::iAPGetConnectionState(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetConnectionState(mountPoint);
}

tConnectionType iPodControlIAP::iAPGetConnectionType(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetConnectionType(mountPoint);
}

tPEPlaybackState iPodControlIAP::iAPGetCurrentPlaybackState(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetPEPlaybackState(mountPoint);
}

tResult iPodControlIAP::iAPGetIPODPlayerState(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetPlayerState(mountPoint);
}

tPlaytime iPodControlIAP::iAPGetElapsedPlaytime(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetElapsedPlaytime(mountPoint);
}

tPlaytime iPodControlIAP::iAPGetTotalPlaytime(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetTotalPlaytime(mountPoint);
}

me::samplerate_i iPodControlIAP::iAPGetSampleRate(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetSampleRate(mountPoint);
}

tBitRate iPodControlIAP::iAPGetBitRate(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetBitRate(mountPoint);
}

tCodecType iPodControlIAP::iAPGetCodecType(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetCodecType(mountPoint);
}

int iPodControlIAP::iAPGetNowPlayingTrackIndex(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetNowPlayingTrackIndex(mountPoint);
}

int iPodControlIAP::iAPGetPBTrackIndex(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetPBTrackIndex(mountPoint);
}

int iPodControlIAP::iAPGetAlbumArtID(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetAlbumArtID(mountPoint);
}

int iPodControlIAP::iAPGetQueueListID(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetQueueListID(mountPoint);
}

void * iPodControlIAP::iAPGetAlbumArtBuffer(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetIAP2AlbumArtBuffer(mountPoint);
}

void * iPodControlIAP::iAPGetQueueListBuffer(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetQueueListBuffer(mountPoint);
}

void iPodControlIAP::iAPGetNowPlayingMetadata(
        tMetadata &metadata1, tMetadata &metadata2,
        tMetadata &metadata3, tMetadata &metadata4,
        tTitle &metadataTitle, tMediaType &mediaType, const tMountPoint mountPoint,tUUID &uuid) {
    ENTRY_INTERNAL;

    //get a snapshot of the current iPod nowplaying data
    tMediaObject mediaObject;
    InitMediaObject(mediaObject);
    m_HandleMap.GetNowPlayingMediaObject(mediaObject, mountPoint);

    mediaType = mediaObject.mediaType;
    strncpy_r(metadata1, mediaObject.MetadataField1, sizeof(metadata1));
    strncpy_r(metadata2, mediaObject.MetadataField2, sizeof(metadata2));
    strncpy_r(metadata3, mediaObject.MetadataField3, sizeof(metadata3));
    strncpy_r(metadata4, mediaObject.MetadataField4, sizeof(metadata4));
    strncpy_r(metadataTitle, mediaObject.title, sizeof(metadataTitle));
    strncpy_r(uuid, mediaObject.UUID, sizeof((mediaObject.UUID)));
}

void iPodControlIAP::iAPGetNowPlayingMediaObject(tMediaObject &mediaObject, const tMountPoint mountPoint)
{
    ENTRY_INTERNAL;
    m_HandleMap.GetNowPlayingMediaObject(mediaObject, mountPoint);
}

void iPodControlIAP::iAPSetNowPlayingMediaObject(const tMediaObject mediaObject, const tMountPoint mountPoint)
{
    ENTRY_INTERNAL;
    m_HandleMap.SetNowPlayingMediaObject(mediaObject, mountPoint);
}

void iPodControlIAP::iAPGetAlbumArtString(const tMountPoint mountPoint,
        tAlbumArt &albumArtString) {
    ENTRY_INTERNAL;
    m_HandleMap.GetAlbumArtString(albumArtString, mountPoint);
}

void iPodControlIAP::iAPGetAppNameBySessionID(const tMountPoint mountPoint,
        const tSessionID sessionId, tAppName &appName) {
    ENTRY_INTERNAL;
    m_HandleMap.GetAppNameBySessionID(mountPoint, sessionId, appName);
}

void iPodControlIAP::iAPGetAppNameByProtocolID(const tMountPoint mountPoint,
        const unsigned char protocolId, tAppName &appName, tSessionID &sessionId) {
    ENTRY_INTERNAL;
    m_HandleMap.GetAppNameByProtocolID(mountPoint, protocolId, appName, sessionId);
}

void iPodControlIAP::iAPGetProtocolNameByProtocolID(const tMountPoint mountPoint,
        const unsigned char protocolId, tProtocolName &protocolName) {
    ENTRY_INTERNAL;
    m_HandleMap.GetProtocolNameByProtocolID(mountPoint, protocolId,protocolName);
}

void iPodControlIAP::iAPGetActiveSessionList(vector<string> &list,
        const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    m_HandleMap.GetActiveSessionList(list, mountPoint);
}

void iPodControlIAP::iAPGetLaunchApp(const tMountPoint mountPoint,
        tAppName &appName)
{
    ENTRY_INTERNAL;
    m_HandleMap.GetLaunchApp(appName, mountPoint);
}

tDiPOCaps iPodControlIAP::iAPGetLastWirelessCarplayStatus(const tMountPoint mountPoint)
{
    ENTRY_INTERNAL;
    return m_HandleMap.GetLastWirelessCarplayStatus(mountPoint);
}

tBoolean iPodControlIAP::iAPIsTrackFinished(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetTrackFinished(mountPoint);
}

//Setter w/o IAP access
void iPodControlIAP::iAPSetConnectionState(const tMountPoint mountPoint, const tConnectionState connectionState)
{
    ENTRY_INTERNAL;
    m_HandleMap.SetConnectionState(mountPoint, connectionState);
}

void iPodControlIAP::iAPSetCurrentPlaybackState(
        const tMountPoint mountPoint, const tPEPlaybackState status) {
    ENTRY_INTERNAL;
    m_HandleMap.SetPEPlaybackState(mountPoint, status);
}

void iPodControlIAP::iAPSetLastPlaybackState(
        const tMountPoint mountPoint, const tPEPlaybackState status) {
    ENTRY_INTERNAL;
    m_HandleMap.SetLastPlaybackState(mountPoint, status);
}

void iPodControlIAP::iAPSetIPODPlayerState(
        const tMountPoint mountPoint, const int state) {
    ENTRY_INTERNAL;
    m_HandleMap.SetPlayerState(mountPoint, state);
}

void iPodControlIAP::iAPSetElapsedPlaytime(const tMountPoint mountPoint,
        const tPlaytime elapsed) {
    ENTRY_INTERNAL;
    m_HandleMap.SetElapsedPlaytime(mountPoint, elapsed);
}

void iPodControlIAP::iAPSetTotalPlaytime(const tMountPoint mountPoint,
        const tPlaytime total) {
    ENTRY_INTERNAL;
    m_HandleMap.SetTotalPlaytime(mountPoint, total);
}

void iPodControlIAP::iAPSetSampleRate(const tMountPoint mountPoint,
        const me::samplerate_i sampleRate) {
    ENTRY_INTERNAL;
    m_HandleMap.SetSampleRate(mountPoint, sampleRate);
}

void iPodControlIAP::iAPSetBitRate(const tMountPoint mountPoint,
        const tBitRate bitRate) {
    ENTRY_INTERNAL;
    m_HandleMap.SetBitRate(mountPoint, bitRate);
}

void iPodControlIAP::iAPSetCodecType(const tMountPoint mountPoint,
        const tCodecType codecType) {
    ENTRY_INTERNAL;
    m_HandleMap.SetCodecType(mountPoint, codecType);
}

void iPodControlIAP::iAPSetNowPlayingTrackIndex(
        const tMountPoint mountPoint, const int trackIndex) {
    ENTRY_INTERNAL;
    m_HandleMap.SetNowPlayingTrackIndex(mountPoint, trackIndex);
}

void iPodControlIAP::iAPSetNowPlayingTrackCount(
        const tMountPoint mountPoint, const int trackCount) {
    ENTRY_INTERNAL;
    m_HandleMap.SetNowPlayingTrackCount(mountPoint, trackCount);
}

int iPodControlIAP::iAPGetNowPlayingTrackCount(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetNowPlayingTrackCount(mountPoint);
}

void iPodControlIAP::iAPSetNowPlayingChapterIndex(
        const tMountPoint mountPoint, const int trackIndex) {
    ENTRY_INTERNAL;
    m_HandleMap.SetNowPlayingChapterIndex(mountPoint, trackIndex);
}

int iPodControlIAP::iAPGetNowPlayingChapterIndex(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetNowPlayingChapterIndex(mountPoint);
}

void iPodControlIAP::iAPSetPBTrackIndex(const tMountPoint mountPoint,
        const int trackIndex) {
    ENTRY_INTERNAL;
    m_HandleMap.SetPBTrackIndex(mountPoint, trackIndex);
}

void iPodControlIAP::iAPSetPollThreadIndex(const tMountPoint mountPoint,
        const int threadIndex) {
    ENTRY_INTERNAL;
    m_HandleMap.SetPollThreadIndex(mountPoint, threadIndex);
}

void iPodControlIAP::iAPSetAlbumArtID(const tMountPoint mountPoint,
        const int id) {
    ENTRY_INTERNAL;
    m_HandleMap.SetAlbumArtID(mountPoint, id);
}

void iPodControlIAP::iAPSetQueueListID(const tMountPoint mountPoint,
        const int id) {
    ENTRY_INTERNAL;
    m_HandleMap.SetQueueListID(mountPoint, id);
}

void iPodControlIAP::iAPSetAlbumArtBuffer(const tMountPoint mountPoint,
        void * buffer) {
    ENTRY_INTERNAL;
    m_HandleMap.SetIAP2AlbumArtBuffer(mountPoint, buffer);
}

void iPodControlIAP::iAPSetQueueListBuffer(const tMountPoint mountPoint,
        void * buffer) {
    ENTRY_INTERNAL;
    m_HandleMap.SetQueueListBuffer(mountPoint, buffer);
}

void iPodControlIAP::iAPSetSessionIDByIndex(const tMountPoint mountPoint,
        const tSessionID sessionId, const unsigned char protocolIndex,
        tAppName &appName) {
    ENTRY_INTERNAL;
    m_HandleMap.SetSessionIDByIndex(mountPoint, sessionId, protocolIndex, appName);
}

void iPodControlIAP::iAPClearSessionID(const tMountPoint mountPoint,
        const tSessionID sessionId, tAppName &appName) {
    ENTRY_INTERNAL;
    m_HandleMap.ClearSessionID(mountPoint, sessionId, appName);
}

void iPodControlIAP::iAPSetLaunchApp(const tMountPoint mountPoint,
        const tAppName appName) {
    ENTRY_INTERNAL;
    m_HandleMap.SetLaunchApp(mountPoint, appName);;
}

void iPodControlIAP::iAPSetTrackFinished(const tMountPoint mountPoint,
        const tBoolean set) {
    ENTRY_INTERNAL;
    m_HandleMap.SetTrackFinished(mountPoint, set);
}

void iPodControlIAP::iAPSetFocusApp(const tMountPoint mountPoint,
        const char* appName) {
    ENTRY_INTERNAL;
    m_HandleMap.SetFocusApp(mountPoint, appName);
}

void iPodControlIAP::iAPSetDeviceName(const tMountPoint mountPoint,
        const char* deviceName) {
    ENTRY_INTERNAL;
    m_HandleMap.SetDeviceName(mountPoint, deviceName);
}

void iPodControlIAP::iAPSetAlbumArtString(const tMountPoint mountPoint,
        const tAlbumArt albumArtString) {
    ENTRY_INTERNAL;
    m_HandleMap.SetAlbumArtString(mountPoint, albumArtString);
}

void iPodControlIAP::iAPSetLastWirelessCarplayStatus(const tMountPoint mountPoint, tDiPOCaps diPOCaps)
{
    ENTRY_INTERNAL;
    m_HandleMap.SetLastWirelessCarplayStatus(mountPoint, diPOCaps);
}
//Other methods w/o IAP access
void iPodControlIAP::iAPResetElapsedTime(const tMountPoint mountPoint,
        const tiPodElaspedTime elapsedtime) {
    ENTRY_INTERNAL;
    m_HandleMap.ResetElapsedTime(mountPoint, elapsedtime);
}

tBoolean iPodControlIAP::iAPIsTimeElapsed( const tMountPoint mountPoint,
        const tiPodElaspedTime elapsedtime, const tPlaytime interval)
{
    ENTRY_INTERNAL;
    return m_HandleMap.IsTimeElapsed(IN mountPoint, IN elapsedtime, IN interval);
}

void iPodControlIAP::iAPSetWaitingforRoleSwitchResponse(const tMountPoint mountPoint, bool isWaitingforRoleSwitchResponse)
{
    ENTRY_INTERNAL;
    m_HandleMap.SetWaitingforRoleSwitchResponse(mountPoint, isWaitingforRoleSwitchResponse);
}

bool iPodControlIAP::iAPGetWaitingforRoleSwitchResponse(const tMountPoint mountPoint)
{
    ENTRY_INTERNAL;
    return m_HandleMap.GetWaitingforRoleSwitchResponse(mountPoint);
}


void iPodControlIAP::iAPTraceData(const unsigned char * data,
        const unsigned int size) {
    ENTRY_INTERNAL;
    //trace out hex data line
    if (data && size) {
        unsigned char line[8];
        for (unsigned int i = 0, l = 0; l < size; l += 8) {
            for (unsigned int j = 0; j < 8; j++) {
                line[j] = i < size ? data[i++] : 0;
            }
            ETG_TRACE_USR3(("DATA 0x%04x: %02x %02x %02x %02x %02x %02x %02x %02x", l, line[0], line[1], line[2], line[3], line[4], line[5], line[6], line[7]));
        }
    }
}

//Other methods with IAP access
tResult iPodControlIAP::iAPCheckUpdateNowPlaying(const tMountPoint mountPoint) {
    ENTRY;
    VARTRACE(mountPoint);
    tResult ret = MP_NO_ERROR;

    if(IsIAP2(mountPoint)) {
        //already updated via IAP2 nowPlaying callback
        return ret;
    }

    int currenttrack = m_HandleMap.GetNowPlayingTrackIndex(mountPoint);
    int playingtrack = m_HandleMap.GetPBTrackIndex(mountPoint);
    if (((currenttrack != playingtrack) && playingtrack >= 0) || currenttrack
            < 0) {
        ETG_TRACE_USR3(("Update required: index playing %d, current %d", playingtrack, currenttrack));
        if (!SelectDevice(mountPoint)) {
            ret = MP_ERR_IPOD_NO_ACCESS;
            //ETG_TRACE_ERR(("Set status MEDIAPLAYER_ERROR_DEVICE_NOT_FOUND"));
            //change error code to MEDIAPLAYER_ERROR_DEVICE_NOT_FOUND
            //PlayerManger evaluates this metadata in order to stop list processing
            tMetadata errorMeta = { 0 };
            snprintf(errorMeta, sizeof(errorMeta), "%u", MEDIAPLAYER_ERROR_DEVICE_NOT_FOUND);
            m_HandleMap.SetPEPlaybackState(mountPoint, PE_PBS_ERRORSTATE);
            m_HandleMap.SetNowPlayingTags(mountPoint, MTY_UNKNOWN, "", errorMeta, "", "", "", "");
        } else {
            if (!UpdateNowPlaying(true)) {
                ETG_TRACE_ERR(("UpdateNowPlaying failed"));
                ret = MP_ERR_IPOD_METADATA;
            }
        }
    } else {
        ETG_TRACE_USR3(("Track index %d, no update", currenttrack));
    }
    return ret;
}

//Commands with IAP access
tResult iPodControlIAP::iAPPlaySelection(const tMountPoint mountPoint,
        const tURL url, const tPlaytime position, const tBatchPlaybackList * pbatchlist, tBoolean &sync_play_answer, const tBoolean playOnRemoteActivity) {
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(url);
    VARTRACE(position);
    VARTRACE(playOnRemoteActivity);

    tResult ret = MP_NO_ERROR;

    tMountPoint hiddev = { 0 };
    tListType listType = tListType_init;
    int tag1 = -1;
    int tag2 = -1;
    int tag3 = -1;
    int tag4 = -1;
    int rowID = -1;
    int chapterID = -1;
    tU64 uuid = 0;
    tU64 parentuuid = 0;
    tMetadata title = { 0 };
    int specialID = 0;
    bool isUpdateFromDeviceNeeded = true;

    SMF::UnMarshalFromUtf8(url, IPODCONTROL_MARSHAL_SEPARATOR,
            IPODCONTROL_MARSHAL_FORMAT, hiddev, &listType, &tag1, &tag2, &tag3, &tag4,
            &rowID, &chapterID, &uuid, &parentuuid, title, &specialID);

    iPodControlMediaPath path(listType, tag1, tag2, tag3, tag4);
    VARTRACE(hiddev);
    VARTRACE(listType);
    VARTRACE(tag1);
    VARTRACE(tag2);
    VARTRACE(tag3);
    VARTRACE(tag4);
    VARTRACE(rowID);
    VARTRACE(chapterID);
    VARTRACE(uuid);
    VARTRACE(parentuuid);
    VARTRACE(title);
    VARTRACE(specialID);
    VARTRACE(path.IsLTYRemoteActivity())

    //check for same song being played
    tMediaObject mediaObject;
    InitMediaObject(mediaObject);
    m_HandleMap.GetNowPlayingMediaObject(mediaObject, mountPoint);
    VARTRACE(mediaObject.title);
    const int len = strlen_r(title);
    const int titleLen = strlen_r(mediaObject.title);
    const bool validTitles = len > 0 && strlen_r(mediaObject.title) > 0;
    VARTRACE(validTitles);
    const bool reselectItem = validTitles && (len==titleLen) && !strncmp(title, mediaObject.title, len);
    VARTRACE(reselectItem);

    VARTRACE(mediaObject.UUID);
    tU64 nowPlaying_uuid = (tU64)strtoull((char *)mediaObject.UUID, NULL, 16); //Hex
    const bool validUuids = nowPlaying_uuid > 0 && uuid > 0;
    VARTRACE(validUuids);
    const bool reselectUuid = nowPlaying_uuid == uuid;
    VARTRACE(reselectUuid);

    const tPlaytime lastPlaytime = m_HandleMap.GetElapsedPlaytime(mountPoint);
    const tPlaytime variance = lastPlaytime > position ? lastPlaytime - position : position - lastPlaytime;
    VARTRACE(lastPlaytime);
    VARTRACE(variance);

    const int IPODPlayerState = m_HandleMap.GetPlayerState(mountPoint);
    VARTRACE(IPODPlayerState);

    tAppName focusApp = { 0 };
    m_HandleMap.GetFocusApp(focusApp, mountPoint);
    VARTRACE(focusApp);

    const bool isMusicApp = strlen_r(focusApp) > 0 && (!strcmp(focusApp, IAP2_NOW_PLAYING_UPDATE_PLAYBACK_APP_BUNDLE_MUSIC) || !strcmp(focusApp, IAP2_NOW_PLAYING_UPDATE_PLAYBACK_APP_NAME_MUSIC));
    VARTRACE(isMusicApp);

    const bool isPandoraApp = strlen_r(focusApp) > 0 && (!strcmp(focusApp, IAP2_NOW_PLAYING_UPDATE_PLAYBACK_APP_BUNDLE_PANDORA) || !strcmp(focusApp, IAP2_NOW_PLAYING_UPDATE_PLAYBACK_APP_NAME_PANDORA));
    VARTRACE(isPandoraApp);

    const bool isiTunesRadioPlaying = IsIAP2iTunesRadioPlaying(mountPoint);
    VARTRACE(isiTunesRadioPlaying);

    const tDiPOStopReason diPOStopReason = (tDiPOStopReason)LocalSPM::GetDataProvider().DiPOStopReason();
    VARTRACE(diPOStopReason);

    const tDiPOStartReason diPOStartReason = (tDiPOStartReason)LocalSPM::GetDataProvider().DiPOStartReason();
    VARTRACE(diPOStartReason);

    bool carPlayUserActionRestricted = LocalSPM::GetDataProvider().iPodControlIAP2CarPlayModeUserActionOnly() && IsIAP2CarPlayMode(mountPoint);
    if(carPlayUserActionRestricted && m_HandleMap.IsTimeElapsed(IN mountPoint, IN iapInitElapsed, IN LocalSPM::GetDataProvider().iPodControlIAP2CarPlayModeUserActionTimeoutMS())) {
        carPlayUserActionRestricted = diPOStopReason == DIPO_STOP_REASON_UNKNOWN || diPOStopReason == DIPO_STOP_REASON_SOURCE_SUSPENDED || diPOStartReason == DIPO_START_REASON_REMOTE_ACTIVITY;
    }
    VARTRACE(carPlayUserActionRestricted);

    const tPEPlaybackState lastPlaybackState = m_HandleMap.GetLastPlaybackState(mountPoint);
    VARTRACE(lastPlaybackState);
    m_HandleMap.SetLastPlaybackState(mountPoint, PE_PBS_LOADINGSTATE); //reset last mode

    const tDeviceID deviceID = iAPGetDeviceID(mountPoint);
    const tBoolean ignoreLastModePause = LocalSPM::GetDataProvider().IsIgnoreLastModePauseNeeded(deviceID);
    const bool keepPausedState = LocalSPM::GetDataProvider().KeepLastPlaybackStateForStreamingDevicesEnabled() && IsStreaming(mountPoint) && ((lastPlaybackState == PE_PBS_PAUSEDSTATE)&& (false == ignoreLastModePause));
    VARTRACE(keepPausedState);

    bool remoteActivity_sent = false;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else if(playOnRemoteActivity && path.IsLTYRemoteActivity()) {
        //redundant play call detected as triggered by a privous RemoteActivity to PlayerManager
        //Do not call PLAY to iPod due to ATS findings - GMMY16-26007
        ETG_TRACE_USR3(("Redundant PLAY command detected, skipping"));
        m_HandleMap.SetPEPlaybackState(m_MountPoint, PE_PBS_PLAYINGSTATE);
        m_HandleMap.SetPBPath(m_MountPoint, path);
    } else if(IsIAP2(m_MountPoint)) {

        //cached VT record for all live list types got invalid
        iAPClearLiveVTRecords(m_MountPoint);

        if(uuid == 0 || !path.IsDBPath()) {
            //case LTY_CURRENTSELECTION

            if(!carPlayUserActionRestricted && !keepPausedState) {
                if((!IsStreaming(m_MountPoint) || reselectItem || reselectUuid) && (isMusicApp && uuid != 0) && !isiTunesRadioPlaying) { //SUZUKI-14113, SUZUKI-28076
                    //resume music app audio
                    //NOTE: isiTunesRadioPlaying=true - iPhone does not resume playback of iTUnesRadio but starts playing music library (iOS8 issue)
                    ret = PlayMediaLibraryCurrentSelection(isiTunesRadioPlaying);
                } else {
                    //resume any audio app
                    ret = iAPPlayResume(m_MountPoint);
                }
            }
            if(!IsStreaming(m_MountPoint) || !path.IsLTYRemoteActivity()) {
                //enable streaming mode on LTY_CURRENTSELECTION
                LocalSPM::GetIPODControl().SendRemoteActivity(m_MountPoint);
                remoteActivity_sent = true;
            }
        } else {
            //valid uuid

            //check playtime elapsed - must exceed the PREV limit of iPod (first 3 seconds of song)
            if(!LocalSPM::GetDataProvider().iPodControlIAP2BatchPlaying() && reselectItem && position == 0 && (int)lastPlaytime > LocalSPM::GetDataProvider().iPodControlPrevBufferTimeMS()) {
                ETG_TRACE_USR3(("Item reselect detected '%64s' - seek back to position %d", title, position));
                ret = iAPPlayPrev(m_MountPoint, 1);
#ifdef IPODCONTROL_IAP2_PF_AVAIL
                if(ret == MP_NO_ERROR && m_HandleMap.GetPlayerState(m_MountPoint) != IAP2_PLAYBACK_STATUS_PLAYING) {
                    ETG_TRACE_USR3(("Resuming item '%64s'", title));
                    ret = iAPPlayResume(m_MountPoint);
                }
#endif
            } else {
                //reset albumart
                //m_HandleMap.SetAlbumArtID(m_MountPoint, -1); //keep same image for differnt song in same album

                //batch playback list
                if(/*LINT !remoteActivity_sent &&*/ LocalSPM::GetDataProvider().iPodControlIAP2BatchPlaying() && pbatchlist) {
                    m_HandleMap.SetFocusApp(m_MountPoint, IAP2_NOW_PLAYING_UPDATE_PLAYBACK_APP_BUNDLE_MUSIC); //early reset appname (see issue weh Pandora is previous source)
                    if(!IsStreaming(m_MountPoint) || !path.IsLTYRemoteActivity()) {
                        LocalSPM::GetIPODControl().SendRemoteActivity(m_MountPoint); //return to LTY_CURRENTSELECTION
                        remoteActivity_sent = true;
                    }
                }

                if(listType == LTY_PLAYLIST_SONG && parentuuid && rowID >= 0) {
                    ret = PlayMediaLibraryCollection(parentuuid, IAP2_COLLECTION_TYPE_PLAYLIST, rowID, false);
                } else if(listType == LTY_ITUNES_RADIO_STATION ) {
                    ret = PlayMediaLibraryCollection(uuid, IAP2_COLLECTION_TYPE_PLAYLIST, 0, true);
                    if(!remoteActivity_sent && !IsStreaming(m_MountPoint)) {
                        //enable streaming mode on LTY_CURRENTSELECTION
                        LocalSPM::GetIPODControl().SendRemoteActivity(m_MountPoint);
                        remoteActivity_sent = true;
                    }
                } else if(listType == LTY_IPOD_QUEUE_LIST ) {
                    if(!reselectUuid && nowPlaying_uuid > 0) {
                        if(LocalSPM::GetDataProvider().iPodControlIAP2UseSetNowPlayingInfo()) {
                        ret = iAP2SetPlaybackQueueIndex(rowID);
                        }
                        else
                        {
                            isUpdateFromDeviceNeeded = false;
                        }
                        //if(LocalSPM::GetDataProvider().iPodControlIAP2QueueListResumeOnSelection()) { //PSARCCB-10001
                            ret = iAPPlayResume(m_MountPoint);
                        //}
                        VARTRACE(isUpdateFromDeviceNeeded);
                    } else if(!carPlayUserActionRestricted && !keepPausedState) {
                        if(isMusicApp && !isiTunesRadioPlaying) { //PSARCCB-10150
                            ret = PlayMediaLibraryCurrentSelection(isiTunesRadioPlaying);
                        } else {
                            ret = iAPPlayResume(m_MountPoint);
                        }
                    }
                    if(!remoteActivity_sent && !IsStreaming(m_MountPoint)) {
                        //enable streaming mode on LTY_CURRENTSELECTION
                        LocalSPM::GetIPODControl().SendRemoteActivity(m_MountPoint);
                        remoteActivity_sent = true;
                    }
                } else {
                    //batch playback list
                    if(LocalSPM::GetDataProvider().iPodControlIAP2BatchPlaying() && pbatchlist) {
                        ret = PlayMediaLibraryItems(uuid, pbatchlist, false);
                    } else {
                        tBatchPlaybackList bpl;
                        bpl.push_back(uuid);
                        ret = PlayMediaLibraryItems(uuid, &bpl, false);
                    }
                }

                if(!IsStreaming(m_MountPoint)) {
                    //seekTo position
                    if (position != PLAYTIME_NONE && (reselectItem || (/*LINT !reselectItem &&*/ position > 0))) {
                        //seekTo active
                        ETG_TRACE_USR3(("seeking to %d ms", position));
                        if (MP_NO_ERROR != iAP2_SeekTo(position)) {
                            ETG_TRACE_ERR(("seek to position failed"));
                            //ret = MP_ERR_IPOD_SEEK;
                        }
                    }
                    //compare uuid with NowPlayingUUID
                    sync_play_answer = ret == MP_NO_ERROR && ((!reselectUuid && nowPlaying_uuid > 0) || (!reselectItem && listType != LTY_PLAYLIST_SONG && validTitles));
                } else {
                    //compare uuid with NowPlayingUUID
                    sync_play_answer = ret == MP_NO_ERROR && (!reselectUuid && nowPlaying_uuid > 0 && isUpdateFromDeviceNeeded); //iOS8 only
                }
            }
        }
        if(ret == MP_NO_ERROR) {
            if(carPlayUserActionRestricted || keepPausedState) {
                m_HandleMap.SetPEPlaybackState(m_MountPoint, IPODPlayerState == IAP2_PLAYBACK_STATUS_PLAYING ? PE_PBS_PLAYINGSTATE : PE_PBS_PAUSEDSTATE);
            } else {
                m_HandleMap.SetPEPlaybackState(m_MountPoint, PE_PBS_PLAYINGSTATE);
            }
            m_HandleMap.SetPBPath(m_MountPoint, path);
        }
    } else { //IAP1

        //call RESUME IPOD if 3rd party communication is active
        if(LocalSPM::GetDataProvider().iPodControlIAP1AppControlEnabled()) {
            vector<string> activeSession;
            iAPGetActiveSessionList(activeSession, m_MountPoint);
            VARTRACE((int)activeSession.size());
            if(activeSession.size() > 0) {
                //Check focus app / resume iPod
                if (!IsStreaming(m_MountPoint) && !CheckFocusMusicApp()) {
                    ETG_TRACE_ERR(("CheckFocusMusicApp() failed"));
                }
            }
        }

        //resume audiobook if playtime is none
        if (position == PLAYTIME_NONE) {
            chapterID = -1;
        }

        if(!reselectItem) {
            //update nowplaying tags with next iPod update
            m_HandleMap.SetNowPlayingTags(m_MountPoint, MTY_UNKNOWN, NULL, NULL, NULL, NULL, NULL, NULL);
        }

        //set force Seek To Zero: case LTY_CURRENT_SELECTION
        //When recalling the currently playing song, iPod does not restart from position on its own
        const bool sameSongContinues = !path.IsDBPath() && (rowID == m_HandleMap.GetNowPlayingTrackIndex(m_MountPoint));
        VARTRACE(sameSongContinues);

        //SUZUKI-17727 track "remember Playback position" may be acitive
        //do a seekto + resume insteam PlaySelection
        const bool sameDBSongContinues = rowID >= 0 && path.IsDBPath() && path.IsSame(m_HandleMap.GetPBPath(m_MountPoint)) && (rowID == m_HandleMap.GetNowPlayingTrackIndex(m_MountPoint));
        VARTRACE(sameDBSongContinues);

        const bool hasChapters = chapterID >= 0;
        VARTRACE(hasChapters);

        const bool reselectAudioBookWithChaptersByUUID = hasChapters && validUuids && reselectUuid && LocalSPM::GetDataProvider().iPodControlIAP1ChapterStreaming();
        VARTRACE(reselectAudioBookWithChaptersByUUID);

        if (!path.IsValid() && LocalSPM::GetDataProvider().IsPermanentStreamingActive(DTY_IPOD)) {
            //JAC-10106
            ETG_TRACE_USR3(("iAP1 empty playback queue - shuffle all songs list"));
            iAPSetPlaybackMode(m_MountPoint, PBM_RANDOM);
            iPodControlMediaPath allSongs(LTY_SONG);
            if (!SelectRecord(allSongs)) {
               ETG_TRACE_ERR(("SelectRecord failed"));
               ret = MP_ERR_IPOD_SELECT;
            } else if (!PlayRecord(allSongs, 0, 0)) {
                ETG_TRACE_ERR(("PlayRecord failed"));
                ret = MP_ERR_IPOD_PLAY;
            }
        } else {
            tMetadata name = { 0 };
            if (!SelectRecord(path)) {
                ETG_TRACE_ERR(("SelectRecord failed"));
                ret = MP_ERR_IPOD_SELECT;
            } else if (!RetrieveName(path, rowID, name)) {
                ETG_TRACE_ERR(("RetrieveName failed"));
                ret = MP_ERR_IPOD_SELECT;
            } else if (0 != strncmp(title, name, strlen_r(title)) && strlen_r(title)!=strlen_r(name)) {
                ETG_TRACE_ERR(("strncmp failed"));
                VARTRACE(title);
                VARTRACE(name);
                ret = MP_ERR_IPOD_SELECT;
            } else if (!sameDBSongContinues && !reselectAudioBookWithChaptersByUUID && !PlayRecord(path, rowID, hasChapters ? uuid : 0)) {
                ETG_TRACE_ERR(("PlayRecord failed"));
                ret = MP_ERR_IPOD_PLAY;
            } else if (hasChapters && !PlayChapter(chapterID)) {
                ETG_TRACE_ERR(("PlayChapter failed"));
                //ret = MP_ERR_IPOD_PLAY; //audiobook playing - no dot error - CMG3GB-1956
            }
        }
        if(ret == MP_NO_ERROR){
            //sync play answer with track change
            //sync_play_answer = !reselectItem;

            //cached VT record for all live list types got invalid
            iAPClearLiveVTRecords(m_MountPoint);

            //initial assignment: set to ALL_TRACKS since it is needed to keep the last mode playing list
            if(!IsStreaming(m_MountPoint) || listType != LTY_CURRENT_SELECTION) {
                //JAC-10002 - iTunesRadio
                if(/*LINT !remoteActivity_sent &&*/ (listType == LTY_PLAYLIST_SONG || LocalSPM::GetDataProvider().IsPermanentStreamingActive(DTY_IPOD))) {
                    //enable streaming mode on LTY_PLAYLIST_SONG
                    LocalSPM::GetIPODControl().SendRemoteActivity(m_MountPoint);
                    m_HandleMap.SetPBTrackIndex(m_MountPoint, -1);
                    remoteActivity_sent = true;
                }
            }

            //update playback state
            m_HandleMap.SetPEPlaybackState(mountPoint, PE_PBS_PLAYINGSTATE);

            //seekTo position
            if (position != PLAYTIME_NONE &&
                (((sameSongContinues || sameDBSongContinues) && chapterID < 0 && (int)variance > LocalSPM::GetDataProvider().iPodControlResumePositionVarianceMS()) ||
                (!sameSongContinues && position > 0))) {
                //seekTo active
                ETG_TRACE_USR3(("seeking to %d ms", position));
                if (!iAP1_SeekTo(position)) {
                    ETG_TRACE_ERR(("seek to position failed"));
                    ret = MP_ERR_IPOD_SEEK;
                }
            }

            if(sameDBSongContinues || sameSongContinues || reselectItem) {
                if(!keepPausedState) {
                    ret = iAPPlayResume(mountPoint);
                    if (ret != MP_NO_ERROR) {
                        ETG_TRACE_ERR(("resume after selection failed"));
                    }

                } else {
                    //update playback state
                    m_HandleMap.SetPEPlaybackState(mountPoint, IPODPlayerState == IPOD_PLAYER_STATE_PLAYING ? PE_PBS_PLAYINGSTATE : PE_PBS_PAUSEDSTATE);
                }
            }

            //save last iPod PB selection
            m_HandleMap.SetPBPath(m_MountPoint, path);
        }
    }
    //new selection done, clear finished state
    //this allows further finished signals to PlayerManager
    m_HandleMap.SetTrackFinished(m_MountPoint, false);

    if(ignoreLastModePause)
    {
        LocalSPM::GetDataProvider().RemoveDeviceFromLastModePauseList(IN deviceID);
    }

    return ret;
}

tResult iPodControlIAP::iAPPlayNext(const tMountPoint mountPoint, const tNextPrevSkipCount skipcount)
{
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(skipcount);
    tResult ret = MP_NO_ERROR;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else if(IsIAP2(mountPoint)) {
        for (tUInt i = 0; i < skipcount; i++) {
            if(!SendMediaPlaybackHIDReport(IPOD_HID_REPORT_SCAN_NEXT_TRACK)) {
                ETG_TRACE_ERR(("SendMediaPlaybackHIDReport failed"));
                ret = MP_ERR_IPOD_PLAY;
            } else if(!SendMediaPlaybackHIDReport(IPOD_HID_REPORT_BUTTON_RELEASED)) {
                ETG_TRACE_ERR(("SendMediaPlaybackHIDReport failed"));
                ret = MP_ERR_IPOD_PLAY;
            }
        }
    } else {
        for (tUInt i = 0; i < skipcount; i++) {
            if (!PlayControl(NEXT)) {
                //NEXT command failed, try legacy command
                ETG_TRACE_USR3(("PlayControl(NEXT) failed"));
                ret = PlayControl(NEXT_TRACK);
                if (!ret) {
                    ETG_TRACE_ERR(("PlayControl(NEXT_TRACK) failed"));
                }
            }
        }
    }
    return ret;
}

tResult iPodControlIAP::iAPPlayPrev(const tMountPoint mountPoint, const tNextPrevSkipCount skipcount)
{
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(skipcount);
    tResult ret = MP_NO_ERROR;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else if(IsIAP2(mountPoint)) {
        for (tUInt i = 0; i < skipcount; i++) {
            if(!SendMediaPlaybackHIDReport(IPOD_HID_REPORT_SCAN_PREVIOUS_TRACK)) {
                ETG_TRACE_ERR(("SendMediaPlaybackHIDReport failed"));
                ret = MP_ERR_IPOD_PLAY;
            } else if(!SendMediaPlaybackHIDReport(IPOD_HID_REPORT_BUTTON_RELEASED)) {
                ETG_TRACE_ERR(("SendMediaPlaybackHIDReport failed"));
                ret = MP_ERR_IPOD_PLAY;
            }
        }
    } else {
        for (tUInt i = 0; i < skipcount; i++) {
            if (!PlayControl(PREVIOUS)) {
                //NEXT command failed, try legacy command
                ETG_TRACE_USR3(("PlayControl(PREVIOUS) failed"));
                ret = PlayControl(PREV_TRACK);
                if (!ret) {
                    ETG_TRACE_ERR(("PlayControl(PREV_TRACK) failed"));
                }
            }
        }
    }
    return ret;
}

tResult iPodControlIAP::iAPPlayPause(const tMountPoint mountPoint) {
    ENTRY;
    VARTRACE(mountPoint);
    tResult ret = MP_NO_ERROR;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else if(IsIAP2(mountPoint)) {
        if(!SendMediaPlaybackHIDReport(IPOD_HID_REPORT_PAUSE)) {
            ETG_TRACE_ERR(("SendMediaPlaybackHIDReport failed"));
            ret = MP_ERR_IPOD_PLAY;
        } else if(!SendMediaPlaybackHIDReport(IPOD_HID_REPORT_BUTTON_RELEASED)) {
            ETG_TRACE_ERR(("SendMediaPlaybackHIDReport failed"));
            ret = MP_ERR_IPOD_PLAY;
        }
    } else {
        if (m_HandleMap.GetOption(mountPoint, hasPlayPauseOption)) {
            if (!PlayControl(PAUSE)) {
                ETG_TRACE_ERR(("iPodControlIAP::iAPPlayPause() - pause failed"));
                ret = MP_ERR_IPOD_PLAY;
            }
        } else {
            //legacy iPods do not support explicit PAUSE/PLAY command
            UpdatePlayStatus();
            if (m_HandleMap.GetPlayerState(mountPoint)
                    == IPOD_PLAYER_STATE_PLAYING) {
                if (!PlayControl(TOGGLE)) {
                    ETG_TRACE_USR3(("iPodControlIAP::iAPPlayPause() - toggle play failed"));
                    ret = MP_ERR_IPOD_PLAY;
                } else {
                    //usleep(500000); //debouncing iPod TOGGLE
                }
            } else {
                ETG_TRACE_USR3(("iPodControlIAP::iAPPlayPause() - not playing, no toggle to pause"));
            }
        }
    }
    if (ret == MP_NO_ERROR) {
        //update playback state
        m_HandleMap.SetPEPlaybackState(mountPoint, PE_PBS_PAUSEDSTATE);
    }
    return ret;
}

tResult iPodControlIAP::iAPPlayResume(const tMountPoint mountPoint) {
    ENTRY;
    VARTRACE(mountPoint);
    tResult ret = MP_NO_ERROR;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else if(IsIAP2(mountPoint)) {
        if(!SendMediaPlaybackHIDReport(IPOD_HID_REPORT_PLAY)) {
            ETG_TRACE_ERR(("SendMediaPlaybackHIDReport failed"));
            ret = MP_ERR_IPOD_PLAY;
        } else if(!SendMediaPlaybackHIDReport(IPOD_HID_REPORT_BUTTON_RELEASED)) {
            ETG_TRACE_ERR(("SendMediaPlaybackHIDReport failed"));
            ret = MP_ERR_IPOD_PLAY;
        }
    } else {
        if (m_HandleMap.GetOption(mountPoint, hasPlayPauseOption)) {
            if (!PlayControl(PLAY)) {
                ETG_TRACE_USR3(("iPodControlIAP::iAPPlayResume() - resume failed"));
                ret = MP_ERR_IPOD_PLAY;
            }
        } else {
            UpdatePlayStatus();
            //legacy iPods do not support explicit PAUSE/PLAY command
            if (m_HandleMap.GetPlayerState(mountPoint)
                    == IPOD_PLAYER_STATE_PAUSED) {
                if (!PlayControl(TOGGLE)) {
                    ETG_TRACE_USR3(("iPodControlIAP::iAPPlayResume() - toggle play failed"));
                    ret = MP_ERR_IPOD_PLAY;
                }
            } else {
                ETG_TRACE_USR3(("iPodControlIAP::iAPPlayResume() - not paused, no toggle to play"));
            }
        }
    }
    if (ret == MP_NO_ERROR) {
        //update playback state
        m_HandleMap.SetPEPlaybackState(mountPoint, PE_PBS_PLAYINGSTATE);
    }
    return ret;
}

tResult iPodControlIAP::iAPPlayFFStart(const tMountPoint mountPoint) {
    ENTRY;
    VARTRACE(mountPoint);
    tResult ret = MP_NO_ERROR;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else if(IsIAP2(mountPoint)) {
        if(!SendMediaPlaybackHIDReport(IPOD_HID_REPORT_SCAN_NEXT_TRACK)) {
            ETG_TRACE_ERR(("SendMediaPlaybackHIDReport failed"));
            ret = MP_ERR_IPOD_PLAY;
        } else {
            m_HandleMap.ResetElapsedTime(mountPoint, hidSeekLead);
            m_HandleMap.SetPEPlaybackState(mountPoint, PE_PBS_FASTFORWARDSTATE);
        }
    } else {
        if (!PlayControl(START_FF)) {
            ETG_TRACE_USR3(("iPodControlIAP::iAPPlayFFStart() - fast forward failed"));
            ret = MP_ERR_IPOD_PLAY;
        } else {
            //update playback state
            m_HandleMap.SetPEPlaybackState(mountPoint, PE_PBS_FASTFORWARDSTATE);
        }
    }
    return ret;
}

tResult iPodControlIAP::iAPPlayREWStart(const tMountPoint mountPoint) {
    ENTRY;
    VARTRACE(mountPoint);
    tResult ret = MP_NO_ERROR;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else if(IsIAP2(mountPoint)) {
        if(!SendMediaPlaybackHIDReport(IPOD_HID_REPORT_SCAN_PREVIOUS_TRACK)) {
            ETG_TRACE_ERR(("SendMediaPlaybackHIDReport failed"));
            ret = MP_ERR_IPOD_PLAY;
        } else {
            m_HandleMap.ResetElapsedTime(mountPoint, hidSeekLead);
            m_HandleMap.SetPEPlaybackState(mountPoint, PE_PBS_FASTREVERSESTATE);
        }
    } else {
        if (!PlayControl(START_REW)) {
            ETG_TRACE_USR3(("iPodControlIAP::iAPPlayREVStart() - fast rewind failed"));
            ret = MP_ERR_IPOD_PLAY;
        } else {
            //update playback state
            m_HandleMap.SetPEPlaybackState(mountPoint, PE_PBS_FASTREVERSESTATE);
        }
    }
    return ret;
}

tResult iPodControlIAP::iAPPlayFFREWStop(const tMountPoint mountPoint) {
    ENTRY;
    VARTRACE(mountPoint);
    tResult ret = MP_NO_ERROR;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else if(IsIAP2(mountPoint)) {
        //fast forward/rewind detection via hid commands requires a time slice on iPod side (~1 second)
        m_HandleMap.SuspendRemainingTime(mountPoint, hidSeekLead, LocalSPM::GetDataProvider().iPodControlHIDSeekLeadMS());
        if(!SendMediaPlaybackHIDReport(IPOD_HID_REPORT_BUTTON_RELEASED)) {
            ETG_TRACE_ERR(("SendMediaPlaybackHIDReport failed"));
            ret = MP_ERR_IPOD_PLAY;
        } else {
            m_HandleMap.SetPEPlaybackState(mountPoint, PE_PBS_PLAYINGSTATE);
        }
    } else {
        if (!PlayControl(END_FF_REW)) {
            ETG_TRACE_USR3(("iPodControlIAP::iAPPlayFFREVStop() - fast forward/rewind stop failed"));
            ret = MP_ERR_IPOD_PLAY;
        } else {
            //update playback state
            m_HandleMap.SetPEPlaybackState(mountPoint, PE_PBS_PLAYINGSTATE);
        }
    }
    return ret;
}

tResult iPodControlIAP::iAPSeekTo(const tMountPoint mountPoint,
        const tPlaytime position) {
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(position);
    tResult ret = MP_NO_ERROR;

    //limit playtime to total -1
    tPlaytime seekPos = position;
    tPlaytime totalTime = m_HandleMap.GetTotalPlaytime(mountPoint);
    if(totalTime && totalTime != PLAYTIME_NONE && seekPos != PLAYTIME_NONE && seekPos >= totalTime) {
        seekPos = totalTime -1; //ms
    }
    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else if(IsIAP2(mountPoint)) {
        ret = iAP2_SeekTo(seekPos);
    } else {
        if (!iAP1_SeekTo(seekPos)) {
            ETG_TRACE_USR3(("iPodControlIAP::iAPSeekTo() - seek to failed"));
            ret = MP_ERR_IPOD_PLAY;
        } else {
            //update playback state
            m_HandleMap.SetPEPlaybackState(mountPoint, PE_PBS_PLAYINGSTATE);
        }
    }
    return ret;
}

//Private
void iPodControlIAP::PushVTRecord(const tMountPoint mountPoint, const iPodControlVTRecordKey key, const string value)
{
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(value.c_str());

    Locker locker(&mVTCacheMutex);
    mVTCache[string(mountPoint)].insert(make_pair(key, value));
}

//Private
void iPodControlIAP::iAPClearAllVTRecords(const tMountPoint mountPoint, const int limit)
{
    ENTRY;
    VARTRACE(mountPoint);

    Locker locker(&mVTCacheMutex);
    int count = mVTCache[string(mountPoint)].size();

    if(limit < count) {
    mVTCache[string(mountPoint)].clear();
        ETG_TRACE_USR2(("VTCACHE[%d/%d]: all %d items cleared", mVTCache[string(mountPoint)].size(), limit, count));
    }
}

void iPodControlIAP::iAPClearLiveVTRecords(const tMountPoint mountPoint)
{
    ENTRY;
    VARTRACE(mountPoint);

    //reset
    m_HandleMap.SetDBPath(mountPoint, iPodControlMediaPath());

    Locker locker(&mVTCacheMutex);
    int count = 0;
    for(tIPODVTDeviceCache::iterator it = mVTCache[string(mountPoint)].begin(); it != mVTCache[string(mountPoint)].end();) {
        if(it->first.mListType == LTY_CURRENT_SELECTION || it->first.mListType == LTY_CURRENT_SELECTION_COUNT ||
           it->first.mListType == LTY_PLAYLIST_SONG || it->first.mListType == LTY_PLAYLIST_SONG_COUNT) {
            //it = mVTCache[string(mountPoint)].erase(it); //C++11 iterator erase (iterator position);
            mVTCache[string(mountPoint)].erase(it++); //C++98 void erase (iterator position);
            count++;
        } else {
            ++it;
        }
    }
    ETG_TRACE_USR2(("VTCACHE[%d]: %d live items cleared", mVTCache[string(mountPoint)].size(), count));
}

tResult iPodControlIAP::iAPGetVTRecord(const tMountPoint mountPoint, const iPodControlVTRecordKey key, string &rValue) {

    ENTRY;
    VARTRACE(mountPoint);

    Locker locker(&mVTCacheMutex);
    tResult ret =  MP_ERR_IPOD_METADATA;
    tIPODVTDeviceCache::iterator it = mVTCache[string(mountPoint)].find(key);
    if (it != mVTCache[string(mountPoint)].end()) {
        rValue = it->second;
        ret = MP_NO_ERROR;
    }

    ETG_TRACE_USR2(("VTCACHE[%d]: item %8sfound", mVTCache[string(mountPoint)].size(), !ret ? "" : "not " ));

    VARTRACE(rValue.c_str());
    VARTRACE(ret);
    return ret;
}

tResult iPodControlIAP::iAPRetrieveVTRecord(const tMountPoint mountPoint,
        const tListType listType, const tFilterTag tag1, const tFilterTag tag2,
        const tFilterTag tag3, const tFilterTag tag4, const int rowID, const tLimit limit, const tOffset offset) {

    ENTRY;
    VARTRACE(mountPoint);
    tResult ret = MP_NO_ERROR;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else if(IsIAP2(mountPoint)) {
        ret = iAP2_RetrieveVTRecord(mountPoint, listType, tag1, tag2, tag3, tag4, rowID, limit, offset);
    } else {
        ret = iAP1_RetrieveVTRecord(mountPoint, listType, tag1, tag2, tag3, tag4, rowID, limit, offset);
    }

    VARTRACE(ret);
    return ret;
}

tResult iPodControlIAP::iAP2_RetrieveVTRecord(const tMountPoint mountPoint,
        const tListType listType, const tFilterTag tag1, const tFilterTag tag2,
        const tFilterTag tag3, const tFilterTag tag4, const int rowID, const tLimit limit, const tOffset offset) {

    ENTRY;

    VARTRACE(mountPoint);
    VARTRACE(listType);
    VARTRACE(tag1);
    VARTRACE(tag2);
    VARTRACE(tag3);
    VARTRACE(tag4);
    VARTRACE(rowID);
    VARTRACE(limit);
    VARTRACE(offset);

    tResult ret = MP_NO_ERROR;
    tVirtualID rID = 0; //default
    tVirtualCount rCount = 0;
    tVirtualName rName = {0};
    tVirtualURL rURL = {0};
    tUUID rUUID = {0};
    int rActive = 0;
    const int index = rowID + offset;
    tTrackNumber rTrackNumber = 0;

    //limit number of cache entries - GMMY16-20057
    iAPClearAllVTRecords(mountPoint, LocalSPM::GetDataProvider().iPodControlVTCacheLimit());

     // ************ IAP2 only ************

    iPodControlMediaPath path(listType, tag1 - 1, tag2 - 1, tag3 - 1, tag4 - 1); //-1: convert tags from sql range
    iPodControlVTRecordKey key(listType, tag1, tag2, tag3, tag4, index);

    if(!IsIAP2(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else if (path.IsDBPath()) {
        ETG_TRACE_ERR(("Unsupported parameter"));
        ret = MP_ERR_IPOD_SELECT;
    } else {
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        m_HandleMap.LockIAP2(mountPoint); //start critical section

        const int nowplayingTrackCount = m_HandleMap.GetNowPlayingTrackCount(mountPoint);
        VARTRACE(nowplayingTrackCount);
        const int nowplayingTrackIndex = m_HandleMap.GetNowPlayingTrackIndex(mountPoint);
        VARTRACE(nowplayingTrackIndex);

        const int albumArtID = m_HandleMap.GetAlbumArtID(mountPoint);
        VARTRACE(albumArtID);

        tMediaObject mediaObject;
        InitMediaObject(mediaObject);
        m_HandleMap.GetNowPlayingMediaObject(mediaObject, mountPoint);
        VARTRACE(mediaObject.title);

        if(nowplayingTrackCount <= 0 && mediaObject.title[0] == 0) {
            ETG_TRACE_USR3(("Empty IAP2 playback queue"));
            ret = MP_ERR_IPOD_SELECT;
        } else {

            bool isQueueListValid = false;
            //check for queue list
            const int queueListID = iAPGetQueueListID(mountPoint);
            VARTRACE(queueListID);
            tFileXferBuf * pQueueListBuf = (tFileXferBuf *)iAPGetQueueListBuffer(mountPoint);
            if(queueListID > 0 && pQueueListBuf && pQueueListBuf->buffer && pQueueListBuf->transferID == queueListID) {
                VARTRACE(pQueueListBuf->transferID);
                VARTRACE(pQueueListBuf->size);
                VARTRACE(pQueueListBuf->rxLen);
                //check queue list consistency with nowplaying info
                isQueueListValid = pQueueListBuf->rxLen == (8*nowplayingTrackCount); //BLOB U64
            }
            VARTRACE(isQueueListValid);

            rCount = isQueueListValid ? nowplayingTrackCount : 1; //single nowplaying item

            if (path.IsLTYCount()) {
                if (rowID == 0) {
                    rID = 1;
                }
                //push to VT cache
                SMF::Marshal(parameterString, size - 1, IPODCONTROL_MARSHAL_FORMAT_VTRECORD, rCount, rID, NULL, NULL, NULL, 0, 0);
                PushVTRecord(mountPoint, key, string(parameterString));
                VARTRACE(rCount);
                VARTRACE(rID);
                VARTRACE(parameterString);
            } else if (rCount > 0 && ((index < (int)rCount) || (!isQueueListValid && index == nowplayingTrackIndex) )) {
                //in range of rCount OR matching the current nowplaying item

                rID = index + 1;
                tU64 uuid = 0;
                rActive = nowplayingTrackIndex;

                if(isQueueListValid) {
                    if(pQueueListBuf) {
                        uuid = __builtin_bswap64(*((tU64*)(pQueueListBuf->buffer + 8*index))); //lint !e826 size checked before
                        VARTRACE(uuid);
                    }
                    //snprintf(rName, sizeof(rName), "#%04d", index+1); //Test
                    snprintf(rUUID, sizeof(rUUID), IPODCONTROL_UUID_FORMAT, uuid);
                    rTrackNumber = index;
                    iPodControlMediaPath queueListPath(LTY_IPOD_QUEUE_LIST, tag1 - 1, tag2 - 1, tag3 - 1, tag4 - 1); //-1: convert tags from sql range
                    queueListPath.GetURL(rURL, index, -1, uuid, 0ULL, rName, index==rActive ? albumArtID : 0);
                } else {
                    strncpy_r(rName, mediaObject.title, sizeof(rName));
                    strncpy_r(rUUID, mediaObject.UUID, sizeof(rUUID));
                    tU64 uuid = (tU64)strtoull((char *)rUUID, NULL, 16); //Hex
                    rTrackNumber = mediaObject.trackNumber;
                    path.GetURL(rURL, index, -1, uuid, 0ULL, rName, albumArtID); //use specialID to generate a unique albumArt string, see CarPlayLogo as albumArt
                }


                //push to VT cache
                SMF::Marshal(parameterString, size - 1, IPODCONTROL_MARSHAL_FORMAT_VTRECORD, rCount, rID, rName, rURL, rUUID, rActive, rTrackNumber);
                PushVTRecord(mountPoint, key, string(parameterString));

                VARTRACE(rCount);
                VARTRACE(rID);
                VARTRACE(rName);
                VARTRACE(rURL);
                VARTRACE(rUUID);
                VARTRACE(rActive);
                VARTRACE(rTrackNumber);
                VARTRACE(parameterString);
            } else {
                ETG_TRACE_ERR(("Invalid parameter"));
                ret = MP_ERR_IPOD_SELECT;
            }
        }
        m_HandleMap.UnlockIAP2(mountPoint); //end critical section
    }

    VARTRACE(ret);
    return ret;
}

tResult iPodControlIAP::iAP1_RetrieveVTRecord(const tMountPoint mountPoint,
        const tListType listType, const tFilterTag tag1, const tFilterTag tag2,
        const tFilterTag tag3, const tFilterTag tag4, const int rowID, const tLimit limit, const tOffset offset) {

    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(listType);
    VARTRACE(tag1);
    VARTRACE(tag2);
    VARTRACE(tag3);
    VARTRACE(tag4);
    VARTRACE(rowID);
    VARTRACE(limit);
    VARTRACE(offset);

    tResult ret = MP_NO_ERROR;
    tBoolean res = true;
    tVirtualID rID = 0; //default
    tVirtualCount rCount = 0;
    tVirtualName rName = {0};
    tVirtualURL rURL = {0};
    tUUID rUUID = {0};
    int rActive = 0;
    const int index = rowID + offset;
    tTrackNumber rTrackNumber = 0;

    //limit number of cache entries - GMMY16-20057
    iAPClearAllVTRecords(mountPoint, LocalSPM::GetDataProvider().iPodControlVTCacheLimit());

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else if(IsIAP2(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        //*********** IAP1 only *************
        //assign iPodMediaPath
        iPodControlMediaPath path(listType, tag1 - 1, tag2 - 1, tag3 - 1, tag4 - 1); //-1: convert tags from sql range
        iPodControlVTRecordKey key(listType, tag1, tag2, tag3, tag4, index);
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        //SelectRecord (check last select)
        if (!SelectRecord(path)) {
            ETG_TRACE_ERR(("%s - SelectRecord failed", __PRETTY_FUNCTION__));
            ret = MP_ERR_IPOD_SELECT;
        } else {

            rCount = path.GetCurrentCount();

            if (path.IsLTYCount()) {
                if (rowID == 0) {
                    rID = 1;
                }
                if (path.IsLTYChapter()) {
                    rCount = 1; //chapter handling: browse single chapter only
                }
                if (rCount > 0 && path.IsPlaylistList()) {
                    rCount--; //skip default playlist
                }
                //push to VT cache
                SMF::Marshal(parameterString, size - 1, IPODCONTROL_MARSHAL_FORMAT_VTRECORD, rCount, rID, NULL, NULL, NULL, 0, 0);
                PushVTRecord(mountPoint, key, string(parameterString));
                VARTRACE(rCount);
                VARTRACE(rID);
                VARTRACE(parameterString);
            } else if (rCount > 0 && index < (int)rCount) {
                //Retrieve list slice
                if(limit == 0) {
                    ETG_TRACE_USR3(("%s - limit == 0", __PRETTY_FUNCTION__));
                }
                int length = limit > 0 && limit < (rCount - index)? limit - rowID : rCount - index;
                int iapIndex = index; //tag2: chapter handling
                if(length > LocalSPM::GetDataProvider().iPodControlVTChunkMax()) {
                    length = LocalSPM::GetDataProvider().iPodControlVTChunkMax();
                }

                //improve performance for streaming mode requests, Roadmap 130010
                //if (!path.IsDBPath()) {
                //  length = 1;
                //}
                if (path.IsLTYChapter()) {
                    rCount = 1; //chapter handling: browse single chapter only
                    length = 1;
                    iapIndex = tag2 - 1;
                }
                if (rCount > 0 && path.IsPlaylistList()) {
                    rCount--; //skip default playlist
                    iapIndex++;
                }
                //retrieve UUID
                tIPODTrackInfos trackInfos;
                //Enable UUID extraction for VTIPOD below
                const bool uuid_avail = (path.GetCurrentIPODCategory() == IPOD_CAT_TRACK) && m_HandleMap.GetOption(m_MountPoint, hasTrackInfoOption);
                if (uuid_avail) {
                    IPOD_TRACK_INFORMATION_BITFIELD bitfield = { 0 };
                    bitfield.track_info.UID = 1;
                    bitfield.track_info.ALBUM_TRACK_INDEX = 1;
                    res = GetTrackInfo(&trackInfos, bitfield, iapIndex, length, path.IsDBPath());
                    if (!res) {
                        ETG_TRACE_ERR(("%s - GetTrackInfo failed", __PRETTY_FUNCTION__));
                        ret = MP_ERR_IPOD_METADATA;
                    }
                }

                //retrieve name
                tIPODDBRecords dbrecords;
                tMetadata meta = { 0 };
                if (path.IsDBPath()) {
                    //from DB
                    res = RetrieveCategorizedDBRecords(&dbrecords,
                            path.GetCurrentIPODCategory(), iapIndex, length);
                    if (!res) {
                        ETG_TRACE_ERR(("%s - RetrieveCategorizedDBRecords failed", __PRETTY_FUNCTION__));
                        ret = MP_ERR_IPOD_METADATA;
                    }
                }

                //retieve active item
                if (!path.IsDBPath()) {
                    //LTY_CURRENT_SELECTION
                    rActive = (int) iPodGetCurrentPlayingTrackIndex(IPODCONTROL_ID_ONLY);
                    ETG_TRACE_USR3(("iPodGetCurrentPlayingTrackIndex returned %d", rActive));
                    if (rActive < IPOD_OK) {
                        ret = MP_ERR_IPOD_METADATA;
                    }
                }
                if (ret == MP_NO_ERROR) {
                    for (int i = 0; res && i < length; i++) {

                        //set name
                        rName[0] = 0;
                        if (path.IsDBPath()) {
                            map<int, string>::iterator it = dbrecords.find(
                                    iapIndex + i);
                            if (it == dbrecords.end()) {
                                ETG_TRACE_ERR(("%s - No entry", __PRETTY_FUNCTION__));
                                res = false;
                            } else {
                                strncpy_r(rName, it->second.c_str(), sizeof(rName));
                            }
                        } else {
                            //from PB
                            res = GetPlayingTitle(meta, iapIndex + i);
                            if (!res) {
                                ETG_TRACE_ERR(("%s - GetPlayingTitle failed", __PRETTY_FUNCTION__));
                            } else {
                                strncpy_r(rName, meta, sizeof(rName));
                            }
                        }

                        if (res) {
                            //set uuid
                            rUUID[0] = 0;
                            tU64 uuid = 0;
                            if (uuid_avail) {
                                pair<tIPODTrackInfos::const_iterator, tIPODTrackInfos::const_iterator> pr = trackInfos.equal_range(iapIndex + i);
                                for (tIPODTrackInfos::const_iterator it = pr.first; it != pr.second; ++it) {
                                    if (it->second.type == UID) {
                                        if(it->second.data.trackUID > 0) {
                                            uuid = it->second.data.trackUID;
                                            snprintf(rUUID, sizeof(rUUID), IPODCONTROL_UUID_FORMAT, it->second.data.trackUID);
                                        }
                                    } else if (it->second.type == ALBUM_TRACK_INDEX) {
                                        rTrackNumber = it->second.data.albumTrackIndex;
                                    }
                                }
                            }

                            //set URL
                            rURL[0] = 0;
                            path.GetURL(rURL, iapIndex + i, -1, uuid, 0ULL, rName);

                            //increment rowID on success, id is non zero
                            rID = index + i + 1;

                            //push to VT cache
                            iPodControlVTRecordKey key_i(listType, tag1, tag2, tag3, tag4, index + i);
                            SMF::Marshal(parameterString, size - 1, IPODCONTROL_MARSHAL_FORMAT_VTRECORD, rCount, rID, rName, rURL, rUUID, rActive, rTrackNumber);
                            PushVTRecord(mountPoint, key_i, string(parameterString));

                            VARTRACE(rCount);
                            VARTRACE(rID);
                            VARTRACE(rName);
                            VARTRACE(rURL);
                            VARTRACE(rUUID);
                            VARTRACE(rActive);
                            VARTRACE(rTrackNumber);
                            VARTRACE(parameterString);
                        }
                    }
                    if (!res) {
                        ret = MP_ERR_IPOD_METADATA;
                    }
                }
            } else {
                ETG_TRACE_ERR(("%40s - Invalid parameter: rCount=%d, index=%d", __PRETTY_FUNCTION__, rCount, index));
                ret = MP_ERR_IPOD_SELECT;
            }
        }
    }

    VARTRACE(ret);
    return ret;
}

tResult iPodControlIAP::iAPGetNumberOfFiles(const tDeviceID deviceID, tNumberOfFiles &numberOfFiles) {
    ENTRY;
    VARTRACE(deviceID);

    //defaults
    tResult ret = MP_NO_ERROR;
    numberOfFiles = 0;
    tMountPoint mountPoint = {0};
    m_HandleMap.GetMountPointFromDeviceID(mountPoint, deviceID);
    VARTRACE(mountPoint);

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else if(IsIAP2(mountPoint)) {
        ret = MP_ERR_IPOD_COMMAND; //not implemented for iAP2. Get value from DB
    } else {
        iPodControlMediaPath tracks(LTY_SONG);
        if (!SelectRecord(tracks)) {
            ETG_TRACE_ERR(("SelectRecord(LTY_SONG) failed"));
        } else {
            numberOfFiles = tracks.GetCurrentCount();
        }
    }
    VARTRACE(numberOfFiles);
    VARTRACE(ret);
    return ret;
}

tResult iPodControlIAP::iAP1_CalcFingerPrint(tFingerprint &fingerprint,
        tFingerprintStatus &fingerprintStatus, tNumberOfFiles &numberOfFiles,
        const tMountPoint mountPoint, const tFingerprint lastFingerprint) {
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(lastFingerprint);

    //defaults
    tResult ret = MP_NO_ERROR;
    fingerprintStatus = FPS_ERROR;
    numberOfFiles = 0;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else if(IsIAP2(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        //get and init indexer context
        m_HandleMap.LockIndexer(m_MountPoint);
        iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(m_MountPoint);
        if(!pcontext) {
            ETG_TRACE_ERR(("GetIndexerContext failed"));
            ret = MP_ERR_IPOD_NO_ACCESS;
        } else {
            if (pcontext->GetStrategy() == IPOD_INDEXER_STRATEGY_UNKNOWN) {
                if (m_HandleMap.GetOption(m_MountPoint, hasTrackInfoOption)) {
                    pcontext->SetStrategy(IPOD_INDEXER_STRATEGY_IAP1_TRACKINFO);
                    //check last sync data/time with iTunes
                    IPOD_ITUNES_METADATA_INFO iTunesInfo = {0};
                    int res = iPodGetDBiTunesInfo( IPODCONTROL_ID_FRONT IPOD_ITUNES_LAST_SYNC, &iTunesInfo);
                    if (IPOD_OK != res) {
                        ETG_TRACE_ERR(("iPodControlIAP::iAPCalcFingerPrint() - iPodGetDBiTunesInfo failed"));
                        UpdateIpodCommunicationError(res);
                        ret = MP_ERR_IPOD_METADATA;
                    }
                    snprintf(fingerprint, sizeof(fingerprint), "%04d/%02d/%02d %02d:%02d:%02d",
                    iTunesInfo.lastSync.year, iTunesInfo.lastSync.month,
                    iTunesInfo.lastSync.day, iTunesInfo.lastSync.hour,
                    iTunesInfo.lastSync.min, iTunesInfo.lastSync.sec);
                    pcontext->SetFingerprint(fingerprint);
                    pcontext->GetPath() = iPodControlMediaPath(LTY_SONG);
                } else {
                    pcontext->SetStrategy(IPOD_INDEXER_STRATEGY_IAP1_LEGACY);
                    pcontext->GetPath() = iPodControlMediaPath(LTY_GENRE_ARTIST_ALBUM_SONG, 0, 0, -1, 0);
                }
            }

            if (pcontext->GetStrategy() == IPOD_INDEXER_STRATEGY_IAP1_TRACKINFO) {
                //update fingerprint from context, case reindexing, strategy already set in first loop.
                pcontext->GetFingerprint(fingerprint);
                if (fingerprint[0] != 0) {
                    fingerprintStatus = FPS_OK;
                } else {
                    ETG_TRACE_ERR(("iPodControlIAP::iAPCalcFingerPrint() - invalid iTunes sync date failed"));
                    ret = MP_ERR_IPOD_METADATA;
                }
            } else {
                fingerprintStatus = FPS_NOT_AVAIL; // default
            }

            //count number of tracks
            iPodControlMediaPath tracks(LTY_SONG);
            if (!SelectRecord(tracks)) {
                ETG_TRACE_ERR(("iPodControlIAP::iAPCalcFingerPrint() - SelectRecord(LTY_SONG) failed"));
                ret = MP_ERR_IPOD_SELECT;
            } else {
                ETG_TRACE_USR3(("iPodControlIAP::iAPCalcFingerPrint() - TRACKS %d", tracks.GetCurrentCount()));
                numberOfFiles += tracks.GetCurrentCount();
                    pcontext->SetTrackCount(tracks.GetCurrentCount());
            }

            //count number of playlists
            iPodControlMediaPath playlst(LTY_PLAYLIST);
            if (!SelectRecord(playlst)) {
                ETG_TRACE_ERR(("iPodControlIAP::iAPCalcFingerPrint() - SelectRecord(LTY_PLAYLIST) failed"));
                ret = MP_ERR_IPOD_SELECT;
            } else {
                ETG_TRACE_USR3(("iPodControlIAP::iAPCalcFingerPrint() - PLAYLISTS %d", playlst.GetCurrentCount()));
                numberOfFiles += playlst.GetCurrentCount();
                pcontext->SetPlaylistCount(playlst.GetCurrentCount());
                pcontext->SetPlaylistIndex(1); //skip default playlist
            }

            //count number of videos
            if (m_HandleMap.GetOption(m_MountPoint, hasVideoOption)) {
                iPodControlMediaPath videos(LTY_VIDEO_EPISODE);
                if (!SelectRecord(videos)) {
                    ETG_TRACE_ERR(("iPodControlIAP::iAPCalcFingerPrint() - SelectRecord(LTY_VIDEO_EPISODE) failed"));
                    ret = MP_ERR_IPOD_SELECT;
                } else {
                    ETG_TRACE_USR3(("iPodControlIAP::iAPCalcFingerPrint() - VIDEOS %d", videos.GetCurrentCount()));
                    numberOfFiles += videos.GetCurrentCount();
                    pcontext->SetVideoCount(videos.GetCurrentCount());
                }
            }
        }
        m_HandleMap.UnlockIndexer(m_MountPoint);
    }
    VARTRACE(fingerprint);
    VARTRACE(fingerprintStatus);
    VARTRACE(numberOfFiles);
    VARTRACE(ret);
    return ret;
}

tResult iPodControlIAP::iAP2_CalcFingerPrint(const tMountPoint mountPoint, const tFingerprint lastFingerprint) {
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(lastFingerprint);

    //defaults
    tResult ret = MP_NO_ERROR;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else if(!IsIAP2(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else if(!LocalSPM::GetDataProvider().iPodControlIAP2CarPlayModeEnabled() && IsIAP2CarPlayMode(mountPoint)) {
        ret = MP_ERR_IPOD_COMMAND; //SUZUKI-28419
    } else {
#ifdef IPODCONTROL_IAP2_PF_AVAIL

        m_HandleMap.LockIAP2(mountPoint); //start critical section

        //get and init indexer context
        m_HandleMap.LockIndexer(m_MountPoint);
        iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(m_MountPoint);
        if(!pcontext) {
            ETG_TRACE_ERR(("GetIndexerContext failed"));
            ret = MP_ERR_IPOD_NO_ACCESS;
        } else {
            tDeviceInfo deviceInfo;
            m_HandleMap.GetDeviceInfo(m_MountPoint, deviceInfo);

            //media library
            tFingerprint mediaLibraryUID = {0};
            pcontext->GetMediaLibraryUID(mediaLibraryUID);
            VARTRACE(mediaLibraryUID);

            tFingerprint iTunesRadioLibraryUID = {0};
            pcontext->GetiTunesRadioLibraryUID(iTunesRadioLibraryUID);
            VARTRACE(iTunesRadioLibraryUID);

            //Check for valid last finger print and db ID
            tFingerprint lastMediaLibraryUID = "";
            tFingerprint lastMediaRevision = "";
            tFingerprint lastiTunesRadioLibraryUID = "";
            tFingerprint lastiTunesRadioRevision = "";
            SMF::UnMarshal(lastFingerprint, IPODCONTROL_MARSHAL_SEPARATOR, IPODCONTROL_MARSHAL_FORMAT_FINGERPRINT_IAP2, lastMediaLibraryUID, lastMediaRevision, lastiTunesRadioLibraryUID, lastiTunesRadioRevision);
            VARTRACE(lastMediaLibraryUID);
            VARTRACE(lastMediaRevision);
            VARTRACE(lastiTunesRadioLibraryUID);
            VARTRACE(lastiTunesRadioRevision);

            if(mediaLibraryUID[0] == 0) {
                ETG_TRACE_ERR(("mediaLibraryUID failed"));
                ret = MP_ERR_IPOD_NO_ACCESS;
            } else {
                iAP2Device_t * iap2Device = (iAP2Device_t *)m_HandleMap.GetIAP2Device(m_MountPoint);
                if(iap2Device) {

                    bool resyncdeltaindexing = !LocalSPM::GetDataProvider().iPodControlIAP2DeltaIndexing(); //recync == no DELTA indexing

                    VARTRACE(deviceInfo.connectionCount);
                    if(!resyncdeltaindexing && LocalSPM::GetDataProvider().iPodControlIAP2DeltaIndexingSyncCount() && !(deviceInfo.connectionCount % (unsigned int)LocalSPM::GetDataProvider().iPodControlIAP2DeltaIndexingSyncCount())) {
                        //refresh all iPod content after 10 connections
                        resyncdeltaindexing = true;
                    }
                    //do not resync on remume indexing.
                    resyncdeltaindexing = resyncdeltaindexing && !pcontext->IsPaused();

                    VARTRACE(resyncdeltaindexing);

                    //start media library update
                    iAP2StartMediaLibraryUpdatesParameter mediaLibraryUpdatesParameter;
                    memset(&mediaLibraryUpdatesParameter, 0, sizeof(iAP2StartMediaLibraryUpdatesParameter));

                    /* set mediaLibraryUpdatesParameter properties which we want to receive */
                    mediaLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier = new U8*[sizeof(U8*)];
                    if(mediaLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier != NULL) {
                        mediaLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier_count++;
                        mediaLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier[0] = 0;
                        size_t size = strnlen(mediaLibraryUID, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
                        mediaLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier[0] = new U8[size];
                        if(mediaLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier[0] != NULL) {
                            strncpy_r((char*)mediaLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier[0], mediaLibraryUID, size);
                        }

                        /* set MediaItem properties which you want to receive */
                        mediaLibraryUpdatesParameter.iAP2MediaItemProperties = new iAP2MediaItemProperties;
                        if(mediaLibraryUpdatesParameter.iAP2MediaItemProperties != NULL) {
                            memset(mediaLibraryUpdatesParameter.iAP2MediaItemProperties, 0, sizeof(iAP2MediaItemProperties));
                            mediaLibraryUpdatesParameter.iAP2MediaItemProperties_count++;
                            mediaLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyPersistentIdentifier_count++;
                            //mediaLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyAlbumPersistentIdentifier_count++;
                            mediaLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyAlbumTitle_count++;
                            //mediaLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyAlbumTrackCount_count++;
                            mediaLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyAlbumTrackNumber_count++;
                            mediaLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyArtist_count++;
                            //mediaLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyArtistPersistentIdentifier_count++;
                            mediaLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyComposer_count++;
                            //mediaLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyComposerPersistentIdentifier_count++;
                            mediaLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyGenre_count++;
                            //mediaLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyGenrePersistenIdentifier_count++;
                            mediaLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyIsResidentOndevice_count++;
                            mediaLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyMediaType_count++;
                            mediaLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyPlaybackDurationInMilliseconds_count++;
                            mediaLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyTitle_count++;
                            mediaLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyIsPartOfCompilation_count++;
                        }
                        mediaLibraryUpdatesParameter.iAP2MediaLibraryUpdateProgress_count++;
                        mediaLibraryUpdatesParameter.iAP2MediaLibraryIsHidingRemoteItems_count++;

                        if(!resyncdeltaindexing) {
                            if(!strcmp(mediaLibraryUID, lastMediaLibraryUID) && lastMediaRevision[0] != 0) {
                                mediaLibraryUpdatesParameter.iAP2LastKnownMediaLibraryRevision = new U8*[sizeof(U8*)];
                                if(mediaLibraryUpdatesParameter.iAP2LastKnownMediaLibraryRevision != NULL) {
                                    mediaLibraryUpdatesParameter.iAP2LastKnownMediaLibraryRevision_count++;
                                    mediaLibraryUpdatesParameter.iAP2LastKnownMediaLibraryRevision[0] = 0;
                                    size = strnlen(lastMediaRevision, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
                                    mediaLibraryUpdatesParameter.iAP2LastKnownMediaLibraryRevision[0] = new U8[size];
                                    if(mediaLibraryUpdatesParameter.iAP2LastKnownMediaLibraryRevision[0] != NULL) {
                                        strncpy_r((char*)mediaLibraryUpdatesParameter.iAP2LastKnownMediaLibraryRevision[0], lastMediaRevision, size);
                                    }
                                }
                            } else {
                                ETG_TRACE_USR1(("Last Fingerprint invalid - full indexing (MediaLibrary) required"));
                            }
                        } else {
                            ETG_TRACE_USR1(("Delta indexing disabled by configuration - full indexing (MediaLibrary) required"));
                        }

                        /* set PlaylistItem properties which you want to receive */
                        mediaLibraryUpdatesParameter.iAP2MediaPlaylistProperties = new iAP2MediaPlaylistProperties;
                        if(mediaLibraryUpdatesParameter.iAP2MediaPlaylistProperties != NULL) {
                            memset(mediaLibraryUpdatesParameter.iAP2MediaPlaylistProperties, 0, sizeof(iAP2MediaPlaylistProperties));
                            mediaLibraryUpdatesParameter.iAP2MediaPlaylistProperties_count++;
                            mediaLibraryUpdatesParameter.iAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyPersistentIdentifier_count++;
                            mediaLibraryUpdatesParameter.iAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyName_count++;
                            mediaLibraryUpdatesParameter.iAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyParentPersistentIdentifier_count++;
                            mediaLibraryUpdatesParameter.iAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyPropertyIsGeniusMix_count++;
                            mediaLibraryUpdatesParameter.iAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyIsFolder_count++;
#ifdef IPODCONTROL_IAP2_PF_R22
                            mediaLibraryUpdatesParameter.iAP2MediaPlaylistProperties->iAP2MediaPlayListContainedMediaItemsFileTransferIdentifier_count++;
#else
                            mediaLibraryUpdatesParameter.iAP2MediaPlaylistProperties->iAP2MediaPlayListContainedMediaItems_count++;
#endif
                            mediaLibraryUpdatesParameter.iAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyIsiTunesRadioStation_count++;
                        }

                        int res = iAP2StartMediaLibraryUpdates(iap2Device, &mediaLibraryUpdatesParameter);
                        ETG_TRACE_USR3(("iAP2StartMediaLibraryUpdates returned %d", res));
                        iAP2FreeiAP2StartMediaLibraryUpdatesParameter(&mediaLibraryUpdatesParameter);

                        if(res != IAP2_OK) {
                            ret = MP_ERR_IPOD_COMMAND;
                            UpdateIpodCommunicationError(res);
                        } else {
                            pcontext->SetStrategy(IPOD_INDEXER_STRATEGY_IAP2);
                            pcontext->SetFingerprint(lastFingerprint); //store last fingerprint, db content reference
                            pcontext->SetPaused(false);
                        }
                    }

                    //iTunes library
                    if(LocalSPM::GetDataProvider().iPodControlIAP2iTunesRadioEnabled()) {
                        if(iTunesRadioLibraryUID[0] == 0) {
                            ETG_TRACE_USR3(("iTunesRadioLibraryUID == 0"));
                        } else {
                            //start iTUnes Radio library update
                            iAP2StartMediaLibraryUpdatesParameter iTunesRadioLibraryUpdatesParameter;
                            memset(&iTunesRadioLibraryUpdatesParameter, 0, sizeof(iAP2StartMediaLibraryUpdatesParameter));

                            /* set iTunesRadioLibraryUpdatesParameter properties which we want to receive */
                            iTunesRadioLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier = new U8*[sizeof(U8*)];
                            if(iTunesRadioLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier != NULL) {
                                iTunesRadioLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier_count++;
                                iTunesRadioLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier[0] = 0;
                                size_t size = strnlen(iTunesRadioLibraryUID, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
                                iTunesRadioLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier[0] = new U8[size];
                                if(iTunesRadioLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier[0] != NULL) {
                                    strncpy_r((char*)iTunesRadioLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier[0], iTunesRadioLibraryUID, size);
                                }

                                /* set MediaItem properties which you want to receive */
                                iTunesRadioLibraryUpdatesParameter.iAP2MediaItemProperties = new iAP2MediaItemProperties;
                                if(iTunesRadioLibraryUpdatesParameter.iAP2MediaItemProperties != NULL) {
                                    memset(iTunesRadioLibraryUpdatesParameter.iAP2MediaItemProperties, 0, sizeof(iAP2MediaItemProperties));
                                    iTunesRadioLibraryUpdatesParameter.iAP2MediaItemProperties_count++;
                                    iTunesRadioLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyPersistentIdentifier_count++;
                                    //iTunesRadioLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyAlbumPersistentIdentifier_count++;
                                    iTunesRadioLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyAlbumTitle_count++;
                                    //iTunesRadioLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyAlbumTrackCount_count++;
                                    iTunesRadioLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyAlbumTrackNumber_count++;
                                    iTunesRadioLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyArtist_count++;
                                    //iTunesRadioLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyArtistPersistentIdentifier_count++;
                                    iTunesRadioLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyComposer_count++;
                                    //iTunesRadioLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyComposerPersistentIdentifier_count++;
                                    iTunesRadioLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyGenre_count++;
                                    //iTunesRadioLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyGenrePersistenIdentifier_count++;
                                    iTunesRadioLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyIsResidentOndevice_count++;
                                    iTunesRadioLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyMediaType_count++;
                                    iTunesRadioLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyPlaybackDurationInMilliseconds_count++;
                                    iTunesRadioLibraryUpdatesParameter.iAP2MediaItemProperties->iAP2MediaItemPropertyTitle_count++;
                                }
                                iTunesRadioLibraryUpdatesParameter.iAP2MediaLibraryUpdateProgress_count++;
                                iTunesRadioLibraryUpdatesParameter.iAP2MediaLibraryIsHidingRemoteItems_count++;

                                if(!resyncdeltaindexing ) {
                                    if(!strcmp(iTunesRadioLibraryUID, lastiTunesRadioLibraryUID) && lastiTunesRadioRevision[0] != 0) {
                                        iTunesRadioLibraryUpdatesParameter.iAP2LastKnownMediaLibraryRevision = new U8*[sizeof(U8*)];
                                        if(iTunesRadioLibraryUpdatesParameter.iAP2LastKnownMediaLibraryRevision != NULL) {
                                            iTunesRadioLibraryUpdatesParameter.iAP2LastKnownMediaLibraryRevision_count++;
                                            iTunesRadioLibraryUpdatesParameter.iAP2LastKnownMediaLibraryRevision[0] = 0;
                                            size = strnlen(lastiTunesRadioRevision, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
                                            iTunesRadioLibraryUpdatesParameter.iAP2LastKnownMediaLibraryRevision[0] = new U8[size];
                                            if(iTunesRadioLibraryUpdatesParameter.iAP2LastKnownMediaLibraryRevision[0] != NULL) {
                                                strncpy_r((char*)iTunesRadioLibraryUpdatesParameter.iAP2LastKnownMediaLibraryRevision[0], lastiTunesRadioRevision, size);
                                            }
                                        }
                                    } else {
                                        ETG_TRACE_USR1(("Last Fingerprint invalid - full indexing (iTunesRadioLibrary) required"));
                                    }
                                } else {
                                    ETG_TRACE_USR1(("Delta indexing disabled by configuration - full indexing (iTunesRadioLibrary) required"));
                                }

                                /* set PlaylistItem properties which you want to receive */
                                iTunesRadioLibraryUpdatesParameter.iAP2MediaPlaylistProperties = new iAP2MediaPlaylistProperties;
                                if(iTunesRadioLibraryUpdatesParameter.iAP2MediaPlaylistProperties != NULL) {
                                    memset(iTunesRadioLibraryUpdatesParameter.iAP2MediaPlaylistProperties, 0, sizeof(iAP2MediaPlaylistProperties));
                                    iTunesRadioLibraryUpdatesParameter.iAP2MediaPlaylistProperties_count++;
                                    iTunesRadioLibraryUpdatesParameter.iAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyPersistentIdentifier_count++;
                                    iTunesRadioLibraryUpdatesParameter.iAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyName_count++;
                                    iTunesRadioLibraryUpdatesParameter.iAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyParentPersistentIdentifier_count++;
                                    iTunesRadioLibraryUpdatesParameter.iAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyPropertyIsGeniusMix_count++;
                                    iTunesRadioLibraryUpdatesParameter.iAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyIsFolder_count++;
#ifdef IPODCONTROL_IAP2_PF_R22
                                    iTunesRadioLibraryUpdatesParameter.iAP2MediaPlaylistProperties->iAP2MediaPlayListContainedMediaItemsFileTransferIdentifier_count++;
#else
                                    iTunesRadioLibraryUpdatesParameter.iAP2MediaPlaylistProperties->iAP2MediaPlayListContainedMediaItems_count++;
#endif
                                    iTunesRadioLibraryUpdatesParameter.iAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyIsiTunesRadioStation_count++;
                                }

                                int res = iAP2StartMediaLibraryUpdates(iap2Device, &iTunesRadioLibraryUpdatesParameter);
                                ETG_TRACE_USR3(("iAP2StartMediaLibraryUpdates returned %d", res));
                                iAP2FreeiAP2StartMediaLibraryUpdatesParameter(&iTunesRadioLibraryUpdatesParameter);

                                if(res != IAP2_OK) {
                                    ret = MP_ERR_IPOD_COMMAND;
                                    UpdateIpodCommunicationError(res);
                                }
                            }
                        }
                    }
                }
            }
        }
        m_HandleMap.UnlockIndexer(m_MountPoint);

        m_HandleMap.UnlockIAP2(mountPoint); //end critical section
#endif
    }
    VARTRACE(ret);
    return ret;
}

tResult iPodControlIAP::iAPIndexerIsNextMetadataAvailable(const tMountPoint mountPoint, bool &avail)
{
    ENTRY;
    VARTRACE(mountPoint);

    tResult ret = MP_NO_ERROR;
    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        m_HandleMap.LockIndexer(m_MountPoint);
        iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(m_MountPoint);
        if(!pcontext) {
            ETG_TRACE_ERR(("GetIndexerContext failed"));
            ret = MP_ERR_IPOD_NO_ACCESS;
        } else {
            //check item cache
            avail = !pcontext->IsEmptyCache();
            //IAP2 playlist special
            if(!avail && IsIAP2(mountPoint)) {
                //check item progress
                if(pcontext->GetMediaLibraryUpdateProgress() >= 100 &&
                  !(IsIAP2iTunesRadioLibrarySupported(m_MountPoint) && pcontext->GetiTunesRadioLibraryUpdateProgress() < 100)) {
                    //check playlist items
                    avail = !pcontext->IsEmptyPlaylistCache();
                }
            }
        }
        m_HandleMap.UnlockIndexer(m_MountPoint);
    }

    VARTRACE(avail);
    VARTRACE(ret);
    return ret;
}

tResult iPodControlIAP::iAPIndexerGetNextMediaObject(
        tMetadataStatus &metadataStatus, tMediaObjectPtr &nextMediaObject,
        const tMountPoint mountPoint, const tReadPosition readPosition) {
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(readPosition);

    //defaults
    tResult ret = MP_NO_ERROR;
    metadataStatus = MDS_DEVICE_ERROR;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        //get and init indexer context
        m_HandleMap.LockIndexer(m_MountPoint);
        iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(m_MountPoint);
        if(!pcontext) {
            ETG_TRACE_ERR(("GetIndexerContext failed"));
            ret = MP_ERR_IPOD_NO_ACCESS;
        } else {
            if(!pcontext->PopObject(nextMediaObject, metadataStatus)) {
                if(IsIAP2(m_MountPoint) && !pcontext->GetMediaLibraryItemsCompleted() && pcontext->GetMediaLibraryUpdateProgress() >= 100 &&
                  (!pcontext->IsEmptyPlaylistCache() || pcontext->GetPlaylistFileTransferObjectListSize())) {
                    pcontext->SetMediaLibraryItemsCompleted(true);
                    //trigger Indexer flush
                    metadataStatus = MDS_FLUSH;
                } else {
                    metadataStatus = MDS_SUCCESS;
                    if(!pcontext->PopPlaylistObject(nextMediaObject, m_HandleMap.GetDeviceID(m_MountPoint), m_MountPoint)) {
                        //empty cache - FINISHED
                        tFingerprint fingerprint = {0};
                        pcontext->GetFingerprint(fingerprint);
                        VARTRACE(fingerprint);
                        //Fingerprint is required
                        //triggered by iAP2StartMediaLibraryUpdates
                        //check for pending Metadata requests during roleswitch.
                        if(pcontext->IsRetrievError()) {
                            metadataStatus = MDS_DEVICE_ERROR;
                        } else if(fingerprint[0] == 0 && IsIAP2(mountPoint)) {
                            metadataStatus = MDS_ERROR_RESTART; //restart indexing [GMMY16-24058]
                        } else {
                            metadataStatus = MDS_FINISHED;
                        }
                        //reset completed flag for new reindex run
                        pcontext->SetMediaLibraryItemsCompleted(false);
                        pcontext->TraceOut();
                    }
                }
            }
        }
        m_HandleMap.UnlockIndexer(m_MountPoint);
    }
    VARTRACE(metadataStatus);
    if (nextMediaObject) {
        VARTRACE(*nextMediaObject);
    }
    return ret;
}

tResult iPodControlIAP::iAPIndexerRetrieveMetadataFromDevice(
        const tMountPoint mountPoint, const tReadPosition readPosition,
        const tDeviceID deviceID) {
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(readPosition);
    VARTRACE(deviceID);

    //defaults
    tResult ret = MP_NO_ERROR;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        //get and init indexer context
        m_HandleMap.LockIndexer(m_MountPoint);
        iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(m_MountPoint);
        if(!pcontext) {
            ETG_TRACE_ERR(("GetIndexerContext failed"));
            ret = MP_ERR_IPOD_NO_ACCESS;
        } else {
            pcontext->OnBeginCaching();

            switch (pcontext->GetStrategy()) {
            case IPOD_INDEXER_STRATEGY_IAP1_LEGACY:
                ret = IndexerStrategy1(pcontext);
                if (MP_NO_ERROR != ret) {
                    ETG_TRACE_ERR(("%s - IndexerStrategy1 failed", __PRETTY_FUNCTION__));
                }
                break;
            case IPOD_INDEXER_STRATEGY_IAP1_TRACKINFO:
                ret = IndexerStrategy2(pcontext);
                if (MP_NO_ERROR != ret) {
                    ETG_TRACE_ERR(("%s - IndexerStrategy2 failed", __PRETTY_FUNCTION__));
                }
                break;
            default:
                ETG_TRACE_ERR(("%s - INVALID STRATEGY", __PRETTY_FUNCTION__));
                break;
            }

            //calculate next chunk size
            pcontext->OnEndCaching();

            if(ret != MP_NO_ERROR) {
                //check iPod connection: 1:= extended mode
                int res = iPodGetRemoteUIMode(IPODCONTROL_ID_ONLY);
                const bool connection_check = res == 1;
                ETG_TRACE_USR2(("CONNECTION CHECK returned %s", connection_check ? "ok" : "false"));
                if(IPOD_OK != res) {
                    UpdateIpodCommunicationError(res);
                }
                pcontext->SetRetrievError(!connection_check);
            }
        }
        m_HandleMap.UnlockIndexer(m_MountPoint);
    }

    VARTRACE(ret);
    return ret;
}

tResult iPodControlIAP::IndexerStrategy1(iPodControlIndexerContext *pcontext) {
    ENTRY;
    ETG_TRACE_USR3(("%s", __PRETTY_FUNCTION__));
    //STRATEGY 1 (iAP1 - Legacy, no trackinfos)

    tResult ret = MP_NO_ERROR;
    tBoolean res = true;
    int count = 0;

    while(count == 0 && ret == MP_NO_ERROR) {
        if (pcontext && pcontext->GetPath().IsValid()) {
            if (!SelectRecord(pcontext->GetPath())) {
                ETG_TRACE_ERR(("%s - SelectRecord() failed", __PRETTY_FUNCTION__));
                ret = MP_ERR_IPOD_SELECT;
            } else {
                //retrieve metadata
                count = pcontext->GetPath().GetCount(pcontext->GetPath().IsPlaylist() ? IPOD_CAT_PLAYLIST : IPOD_CAT_TRACK);
                VARTRACE(count);
                if(count == 0) {
                    ETG_TRACE_USR3(("Skipping empty category for indexing"));
                } else {
                    int index = pcontext->GetTrackIndex();
                    int chunk = (count - index) > pcontext->GetChunkSize() ? pcontext->GetChunkSize() : count - index;

                    tIPODDBRecords dbrecords;
                    res = RetrieveCategorizedDBRecords(&dbrecords,
                            pcontext->GetPath().GetCurrentIPODCategory(), index, chunk);
                    if (!res) {
                        ETG_TRACE_ERR(("%s - RetrieveCategorizedDBRecords failed", __PRETTY_FUNCTION__));
                        ret = MP_ERR_IPOD_METADATA;
                    } else {
                        //push to object to cache
                        for (int i = 0; i < chunk; i++) {

                            res = MediaObjectFromDBRecord(pcontext, dbrecords, pcontext->GetPath(), index);

                            //increment for next call
                            index++;

                            if (!res) {
                                ETG_TRACE_ERR(("%s - MDS_FILE_ERROR", __PRETTY_FUNCTION__));
                                ret = MP_ERR_IPOD_METADATA;
                                break;
                            }
                        }
                        //update context track index
                        pcontext->SetTrackIndex(index);
                    }
                }
            }
            //increment path for next call
            pcontext->IncrementPath(ret);

        } else {
            ETG_TRACE_USR3(("%s - NO MORE TRACKS", __PRETTY_FUNCTION__));
            break;
        }
    }
    VARTRACE(ret);
    return ret;
}

tBoolean iPodControlIAP::MediaObjectFromDBRecord(iPodControlIndexerContext * pcontext,
        const tIPODDBRecords dbrecords, const iPodControlMediaPath path,
        const int trackIndex) {
    ENTRY;
    VARTRACE(trackIndex);
    tBoolean ret = true;

    //get the metadata
    string trackname;
    string albumname;
    string artistname;
    string genrename;
    string composername;
    tU64 uuid = 0;

    tIPODDBRecords::const_iterator it = dbrecords.find(trackIndex);
    if (it == dbrecords.end()) {
        ETG_TRACE_ERR(("%s - NO ENTRY", __PRETTY_FUNCTION__));
        ret = false;
    } else {
        trackname = it->second;
        albumname    = path.GetName(IPOD_CAT_ALBUM);
        artistname   = path.GetName(IPOD_CAT_ARTIST);
        genrename    = path.GetName(IPOD_CAT_GENRE);
        composername = path.GetName(IPOD_CAT_COMPOSER);

        //set the mediaobject
        tMediaObjectPtr mediaObjectPtr = new tMediaObject; //Attention: Has to be deleted by Indexer::CheckMetadata
        if (!mediaObjectPtr) {
            ETG_TRACE_ERR(("%s - NULL Pointer", __PRETTY_FUNCTION__));
            return false;
        }
        //set general parameter
        InitMediaObject(OUT *mediaObjectPtr);
        strncpy_r(mediaObjectPtr->mountPoint, m_MountPoint, sizeof(mediaObjectPtr->mountPoint));
        mediaObjectPtr->deviceID = m_HandleMap.GetDeviceID(m_MountPoint);

        path.GetURL(mediaObjectPtr->fileName, trackIndex, -1, uuid, 0ULL, trackname.c_str());
        strncpy_r(mediaObjectPtr->albumArtString, mediaObjectPtr->fileName, sizeof(mediaObjectPtr->albumArtString));
        mediaObjectPtr->fileFormat = FFT_UNKNOWN;

        if (path.IsVideo()) {
            mediaObjectPtr->catType = CTY_VIDEO;
            mediaObjectPtr->mediaType = MTY_VIDEO;
            mediaObjectPtr->fileType = FT_VIDEO;
              if(strcmp(genrename.c_str(),"") == 0){
                strncpy_r(mediaObjectPtr->MetadataField1,trackname.c_str(),sizeof(mediaObjectPtr->MetadataField1));
            }else{
                strncpy_r(mediaObjectPtr->MetadataField1,genrename.c_str(),sizeof(mediaObjectPtr->MetadataField1));
            }
            strncpy_r(mediaObjectPtr->title, trackname.c_str(),sizeof(mediaObjectPtr->title));
        } else if (path.IsPlaylist()) {
            mediaObjectPtr->catType = CTY_PLAYLIST;
            mediaObjectPtr->mediaType = MTY_PLAYLIST;
            mediaObjectPtr->fileType = FT_AUDIO;
            strncpy_r(mediaObjectPtr->MetadataField1, trackname.c_str(),
                    sizeof(mediaObjectPtr->MetadataField1));
            strncpy_r(mediaObjectPtr->title, trackname.c_str(),
                    sizeof(mediaObjectPtr->title));
        } else if ((genrename == "Audiobooks") || (genrename == "Audiobook")) {
            mediaObjectPtr->catType = CTY_AUDIOBOOK;
            mediaObjectPtr->mediaType = MTY_AUDIOBOOK;
            mediaObjectPtr->fileType = FT_AUDIO;
            strncpy_r(mediaObjectPtr->MetadataField1, artistname.c_str(),
                    sizeof(mediaObjectPtr->MetadataField1));
            strncpy_r(mediaObjectPtr->MetadataField2, albumname.c_str(),
                    sizeof(mediaObjectPtr->MetadataField2));
            strncpy_r(mediaObjectPtr->title, trackname.c_str(),
                    sizeof(mediaObjectPtr->title));

        } else if (genrename == "Podcast") {
            mediaObjectPtr->catType = CTY_PODCAST;
            mediaObjectPtr->mediaType = MTY_PODCAST;
            mediaObjectPtr->fileType = FT_AUDIO;
            strncpy_r(mediaObjectPtr->MetadataField1, albumname.c_str(),
                    sizeof(mediaObjectPtr->MetadataField1));
            strncpy_r(mediaObjectPtr->title, trackname.c_str(),
                    sizeof(mediaObjectPtr->title));
        } else {
            //song
            mediaObjectPtr->catType = CTY_SONG;
            mediaObjectPtr->mediaType = MTY_MUSIC_FILE;
            mediaObjectPtr->fileType = FT_AUDIO;
            strncpy_r(mediaObjectPtr->MetadataField1, genrename.c_str(),
                    sizeof(mediaObjectPtr->MetadataField1));
            strncpy_r(mediaObjectPtr->MetadataField2, artistname.c_str(),
                    sizeof(mediaObjectPtr->MetadataField2));
            strncpy_r(mediaObjectPtr->MetadataField3, composername.c_str(),
                    sizeof(mediaObjectPtr->MetadataField3));
            strncpy_r(mediaObjectPtr->MetadataField4, albumname.c_str(),
                    sizeof(mediaObjectPtr->MetadataField4));
            strncpy_r(mediaObjectPtr->title, trackname.c_str(),
                    sizeof(mediaObjectPtr->title));
        }
        //push back to indexer context cache
        if(pcontext) {
            pcontext->PushObject(mediaObjectPtr, MDS_SUCCESS);
        }
    } //lint !e429 deleted by Indexer::CheckMetadata
    return ret;
}

tResult iPodControlIAP::IndexerStrategy2(iPodControlIndexerContext * pcontext) {
    ENTRY;
    //STRATEGY 2 (iAP1 - Trackinfo support)

    tResult ret = MP_NO_ERROR;

    if(!pcontext) {
        ETG_TRACE_ERR(("!pcontext"));
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {

        //TRACKS
        if (/*ret == MP_NO_ERROR &&*/ pcontext->IsEmptyCache()) {
            ret = IndexerStrategy2Tracks(pcontext);
        }
        //VIDEOS
        if (ret == MP_NO_ERROR && pcontext->IsEmptyCache()) {
            ret = IndexerStrategy2Videos(pcontext);
        }
        //PLAYLISTS
        if (ret == MP_NO_ERROR && pcontext->IsEmptyCache()) {
            ret = IndexerStrategy2Playlists(pcontext);
        }
    }
    VARTRACE(ret);
    return ret;
}

tResult iPodControlIAP::IndexerStrategy2Tracks(
        iPodControlIndexerContext * pcontext) {
    ENTRY;
    //STRATEGY 2 (iAP1 - Trackinfo support)

    tResult ret = MP_NO_ERROR;
    if(!pcontext) {
        ETG_TRACE_ERR(("!pcontext"));
        return MP_ERR_IPOD_NO_ACCESS;
    }
    //TRACKS:
    int count = pcontext->GetTrackCount();
    int index = pcontext->GetTrackIndex();
    if (count > 0 && index >= 0 && index < count) {
        //Indexer based on all songs list
        iPodControlMediaPath tracks(LTY_SONG);
        if (!SelectRecord(tracks)) {
            ETG_TRACE_ERR(("%s - SelectRecord(LTY_SONG) failed", __PRETTY_FUNCTION__));
            ret = MP_ERR_IPOD_SELECT;
        } else {

            int chunk = (count - index) > pcontext->GetChunkSize() ? pcontext->GetChunkSize() : count - index;

            IPOD_TRACK_INFORMATION_BITFIELD bitfield = { 0 };
            bitfield.track_info.CAPABILITIES = 1;
            bitfield.track_info.TRACK_NAME = 1;
            bitfield.track_info.ALBUM_NAME = 1;
            bitfield.track_info.ARTIST_NAME = 1;
            bitfield.track_info.GENRE_NAME = 1;
            bitfield.track_info.COMPOSER_NAME = 1;
            bitfield.track_info.DURATION = 1;
            bitfield.track_info.UID = 1;
            bitfield.track_info.CHAPTER_NAMES = 1;
            bitfield.track_info.ALBUM_TRACK_INDEX = 1;

            tIPODTrackInfos trackInfos;
            tBoolean res = GetTrackInfo(&trackInfos, bitfield, index, chunk,
                    tracks.IsDBPath());
            if (!res) {
                ETG_TRACE_ERR(("%s - GetTrackInfo failed", __PRETTY_FUNCTION__));
                ret = MP_ERR_IPOD_METADATA;
            } else {

                for (int i = 0; i < chunk; i++) {

                    //check for cached entries
                    res = MediaObjectFromTrackInfo(pcontext, trackInfos,
                            tracks, index);

                    //increment for next call
                    index++;

                    if (!res) {
                        ETG_TRACE_ERR(("%s - MDS_FILE_ERROR", __PRETTY_FUNCTION__));
                        ret = MP_ERR_IPOD_METADATA;
                        break;
                    }
                }
            }
        }
    } else {
        ETG_TRACE_USR3(("%s - NO MORE TRACKS", __PRETTY_FUNCTION__));
    }
    //update context track index
    pcontext->SetTrackIndex(index);

    VARTRACE(ret);
    return ret;
}

tResult iPodControlIAP::IndexerStrategy2Videos(
        iPodControlIndexerContext * pcontext) {
    ENTRY;
    ETG_TRACE_USR3(("%s", __PRETTY_FUNCTION__));
    //STRATEGY 2 (iAP1 - Trackinfo support)

    tResult ret = MP_NO_ERROR;
    if(!pcontext) {
        ETG_TRACE_ERR(("!pcontext"));
        return MP_ERR_IPOD_NO_ACCESS;
    }
    if (m_HandleMap.GetOption(m_MountPoint, hasVideoOption)) {
        //Videos:
        int count = pcontext->GetVideoCount();
        int index = pcontext->GetVideoIndex();
        if (count > 0 && index >= 0 && index < count) {

            //Indexer based on all songs list
            iPodControlMediaPath videos(LTY_VIDEO_EPISODE);
            if (!SelectRecord(videos)) {
                ETG_TRACE_ERR(("%s - SelectRecord(videos) failed", __PRETTY_FUNCTION__));
                ret = MP_ERR_IPOD_SELECT;
            } else {

                int chunk = (count - index) > pcontext->GetChunkSize() ? pcontext->GetChunkSize() : count - index;

                IPOD_TRACK_INFORMATION_BITFIELD bitfield = { 0 };
                bitfield.track_info.CAPABILITIES = 1;
                bitfield.track_info.TRACK_NAME = 1;
                bitfield.track_info.ALBUM_NAME = 1;
                bitfield.track_info.ARTIST_NAME = 1;
                bitfield.track_info.GENRE_NAME = 1;
                bitfield.track_info.COMPOSER_NAME = 1;
                bitfield.track_info.DURATION = 1;
                bitfield.track_info.UID = 1;
                bitfield.track_info.ALBUM_TRACK_INDEX = 1;

                tIPODTrackInfos trackInfos;
                tBoolean res = GetTrackInfo(&trackInfos, bitfield, index,
                        chunk, videos.IsDBPath());
                if (!res) {
                    ETG_TRACE_ERR(("%s - GetTrackInfo failed", __PRETTY_FUNCTION__));
                    ret = MP_ERR_IPOD_METADATA;
                } else {

                    for (int i = 0; i < chunk; i++) {

                        res = MediaObjectFromTrackInfo(pcontext,
                                trackInfos, videos, index);

                        //increment for next call
                        index++;

                        if (!res) {
                            ETG_TRACE_ERR(("%s - MDS_FILE_ERROR", __PRETTY_FUNCTION__));
                            ret = MP_ERR_IPOD_METADATA;
                            break;
                        }
                    }
                }
            }
        } else {
            ETG_TRACE_USR3(("%s - NO MORE VIDEOS", __PRETTY_FUNCTION__));
        }
        //update context track index
        pcontext->SetVideoIndex(index);
    }

    VARTRACE(ret);
    return ret;
}

tResult iPodControlIAP::IndexerStrategy2Playlists(
        iPodControlIndexerContext * pcontext) {
    ENTRY;
    ETG_TRACE_USR3(("%s", __PRETTY_FUNCTION__));
    //STRATEGY 2 (iAP1 - Trackinfo support)

    tResult ret = MP_NO_ERROR;
    if(!pcontext) {
        ETG_TRACE_ERR(("!pcontext"));
        return MP_ERR_IPOD_NO_ACCESS;
    }

    //PLAYLISTS:
    int count = pcontext->GetPlaylistCount();
    int index = pcontext->GetPlaylistIndex();
    if (count > 0 && index >= 0 && index < count) {

        //Indexer based on all songs list
        iPodControlMediaPath playlists(LTY_PLAYLIST);
        if (!SelectRecord(playlists)) {
            ETG_TRACE_ERR(("%s - SelectRecord(LTY_PLAYLIST) failed", __PRETTY_FUNCTION__));
            ret = MP_ERR_IPOD_SELECT;
        } else {

            int chunk = (count - index) > pcontext->GetChunkSize() ? pcontext->GetChunkSize() : count - index;

            tIPODDBRecords records;
            tBoolean res = RetrieveCategorizedDBRecords(&records, IPOD_CAT_PLAYLIST, index, chunk);
            if (!res) {
                ETG_TRACE_ERR(("%s - RetrieveCategorizedDBRecords failed", __PRETTY_FUNCTION__));
                ret = MP_ERR_IPOD_METADATA;
            } else {

                const tDeviceID deviceID = m_HandleMap.GetDeviceID(m_MountPoint);
                tU64 uuid = 0;
                for (int i = 0; i < chunk; i++) {

                    tMediaObjectPtr mediaObjectPtr = new tMediaObject; //Attention: Has to be deleted by Indexer::CheckMetadata
                    if(!mediaObjectPtr) {
                        ETG_TRACE_ERR(("Out of memory"));
                    } else {
                        InitMediaObject(OUT *mediaObjectPtr);

                        //set general parameter
                        mediaObjectPtr->deviceID = deviceID;
                        strncpy_r(mediaObjectPtr->mountPoint, m_MountPoint,
                                sizeof(mediaObjectPtr->mountPoint));

                        //set the mediaobject, playlist
                        map<int, string>::iterator it = records.find(index);
                        if (it == records.end()) {
                            ETG_TRACE_ERR(("%s - NO ENTRY", __PRETTY_FUNCTION__));
                            res = false;
                        } else {
                            strncpy_r(mediaObjectPtr->MetadataField1, it->second.c_str(), sizeof(mediaObjectPtr->MetadataField1));
                            strncpy_r(mediaObjectPtr->title, it->second.c_str(), sizeof(mediaObjectPtr->title));
                            playlists.GetURL(mediaObjectPtr->fileName, index, -1, uuid, 0ULL, it->second.c_str());
                            strncpy_r(mediaObjectPtr->albumArtString, mediaObjectPtr->fileName, sizeof(mediaObjectPtr->albumArtString));
                            mediaObjectPtr->fileFormat = FFT_UNKNOWN;
                            mediaObjectPtr->catType = CTY_PLAYLIST;
                            mediaObjectPtr->mediaType = MTY_PLAYLIST;
                        }
                    }
                    //increment for next call
                    pcontext->PushObject(mediaObjectPtr, MDS_SUCCESS);
                    index++;

                    if (!res) {
                        ETG_TRACE_ERR(("%s - MDS_FILE_ERROR", __PRETTY_FUNCTION__));
                        ret = MP_ERR_IPOD_METADATA;
                        break;
                    }
                } //lint !e429 deleted by Indexer
            }
        }
    } else {
        ETG_TRACE_USR3(("%s - NO MORE PLAYLISTS TO INDEX", __PRETTY_FUNCTION__));
    }
    //update context track index
    pcontext->SetPlaylistIndex(index);

    VARTRACE(ret);
    return ret;
}

tBoolean iPodControlIAP::MediaObjectFromTrackInfo(iPodControlIndexerContext * pcontext,
        const tIPODTrackInfos trackInfos, const iPodControlMediaPath path,
        const int trackIndex) {
    ENTRY;
    ETG_TRACE_USR3(("%s", __PRETTY_FUNCTION__));
    VARTRACE(trackIndex);
    tBoolean ret = false;

    //get the metadata
    IPOD_TRACK_INFORMATION_DATA::_CAPABILITIES caps = { 0 };
    string trackname;
    string albumname;
    string artistname;
    string genrename;
    string composername;
    tPlaytime totalPlaytime = 0;
    tU64 trackUid = 0;
    //int chapterCount;
    tIPODChapterInfos chapterList;
    tTrackNumber trackNumber = 0;

    pair<tIPODTrackInfos::const_iterator, tIPODTrackInfos::const_iterator> pr;
    pr = trackInfos.equal_range(trackIndex);

    for (tIPODTrackInfos::const_iterator it = pr.first; it != pr.second; ++it) {
        if (it->second.type == CAPABILITIES) {
            ret = true; //entry found
            caps = it->second.data.caps;
        } else if (it->second.type == TRACK_NAME) {
            trackname = it->second.str;
        } else if (it->second.type == ALBUM_NAME) {
            albumname = it->second.str;
        } else if (it->second.type == ARTIST_NAME) {
            artistname = it->second.str;
        } else if (it->second.type == GENRE_NAME) {
            genrename = it->second.str;
        } else if (it->second.type == COMPOSER_NAME) {
            composername = it->second.str;
        } else if (it->second.type == DURATION) {
            totalPlaytime = it->second.data.duration;
        } else if (it->second.type == UID) {
            trackUid = it->second.data.trackUID;
        //} else if (it->second.type == CHAPTER_COUNT) {
        //  chapterCount = it->second.data.chapterCount;
        } else if (it->second.type == CHAPTER_NAMES && it->second.data.chapterNames.totalCount) {
            chapterList.insert(make_pair((int)it->second.data.chapterNames.chapterIndex, it->second.str));
        } else if (it->second.type == ALBUM_TRACK_INDEX) {
            trackNumber = it->second.data.albumTrackIndex;
        }
    }

    if (!ret) {
        ETG_TRACE_ERR(("%s - NO ENTRY", __PRETTY_FUNCTION__));
        return false;
    } else {
        //set the mediaobject
        tMediaObjectPtr mediaObjectPtr = new tMediaObject; //Attention: Has to be deleted by Indexer::CheckMetadata
        if (!mediaObjectPtr) {
            ETG_TRACE_ERR(("%s - NULL Pointer", __PRETTY_FUNCTION__));
            return false;
        }
        //set general parameter
        InitMediaObject(OUT *mediaObjectPtr);
        strncpy_r(mediaObjectPtr->mountPoint, m_MountPoint, sizeof(mediaObjectPtr->mountPoint));
        mediaObjectPtr->deviceID = m_HandleMap.GetDeviceID(m_MountPoint);

        path.GetURL(mediaObjectPtr->fileName, trackIndex, -1, trackUid, 0ULL, trackname.c_str());
        strncpy_r(mediaObjectPtr->albumArtString, mediaObjectPtr->fileName,
                sizeof(mediaObjectPtr->albumArtString));
        mediaObjectPtr->fileFormat = FFT_UNKNOWN;
        mediaObjectPtr->totalPlaytime = totalPlaytime;
        if(trackUid > 0) {
            snprintf(mediaObjectPtr->UUID, sizeof(mediaObjectPtr->UUID), IPODCONTROL_UUID_FORMAT, trackUid);
        }
        mediaObjectPtr->trackNumber = trackNumber;

        if ((caps.isAudiobook) || (genrename == "Audiobooks") || (genrename == "Audiobook")) {
            mediaObjectPtr->catType = CTY_AUDIOBOOK;
            mediaObjectPtr->mediaType = MTY_AUDIOBOOK;
            mediaObjectPtr->fileType = FT_AUDIO;
            //AUTHOR
            strncpy_r(mediaObjectPtr->MetadataField1, artistname.c_str(),
                    sizeof(mediaObjectPtr->MetadataField1));
            if (caps.hasChapter && !chapterList.empty()) {
                //Embedded Audiobook Chapters
                tMediaObjectPtr chapterObjectPtr = NULL;
                for (tIPODChapterInfos::iterator it = chapterList.begin(); it
                        != chapterList.end(); ++it) {
                    if (++it != chapterList.end()) {
                        chapterObjectPtr = new tMediaObject; //Attention: Has to be deleted by Indexer::CheckMetadata
                        if (!chapterObjectPtr) {
                            ETG_TRACE_ERR(("%s - NULL Pointer", __PRETTY_FUNCTION__));
                            delete mediaObjectPtr;
                            return false;
                        }
                        *chapterObjectPtr = *mediaObjectPtr; //inherit general audiobook parameters
                    } else {
                        chapterObjectPtr = mediaObjectPtr; //Kludge: Use common mediaObjectPtr on last loop item to match overall processing schema
                    }
                    --it;
                    path.GetURL(chapterObjectPtr->fileName, trackIndex, it->first, trackUid, 0ULL, trackname.c_str());
                    strncpy_r(chapterObjectPtr->albumArtString, chapterObjectPtr->fileName,
                                    sizeof(chapterObjectPtr->albumArtString));
                    chapterObjectPtr->trackNumber = it->first;
                    //strncpy_r(chapterObjectPtr->MetadataField2, trackname.c_str(),
                    //        sizeof(chapterObjectPtr->MetadataField2));
                    strncpy_r(chapterObjectPtr->MetadataField2, albumname.c_str(),
                            sizeof(chapterObjectPtr->MetadataField2));
                    strncpy_r(chapterObjectPtr->title, it->second.c_str(),
                            sizeof(chapterObjectPtr->title));
                    if (chapterObjectPtr != mediaObjectPtr) {
                        //push back to indexer context cache
                        if(pcontext) {
                            pcontext->PushObject(chapterObjectPtr, MDS_SUCCESS);
                        }
                    }
                }
            } else {
                //Simple Audiobook Track
                mediaObjectPtr->trackNumber = 0;
                strncpy_r(mediaObjectPtr->MetadataField2, albumname.c_str(),
                        sizeof(mediaObjectPtr->MetadataField2));
                strncpy_r(mediaObjectPtr->title, trackname.c_str(),
                        sizeof(mediaObjectPtr->title));
            }
        } else if (caps.isVideo && path.IsVideo()) {
            mediaObjectPtr->catType = CTY_VIDEO;
            mediaObjectPtr->mediaType = MTY_VIDEO;
            mediaObjectPtr->fileType = FT_VIDEO;
              if(strcmp(genrename.c_str(),"") == 0){
                strncpy_r(mediaObjectPtr->MetadataField1,trackname.c_str(),sizeof(mediaObjectPtr->MetadataField1));
            }else{
                strncpy_r(mediaObjectPtr->MetadataField1,genrename.c_str(),sizeof(mediaObjectPtr->MetadataField1));
            }
            strncpy_r(mediaObjectPtr->title, trackname.c_str(),sizeof(mediaObjectPtr->title));
        } else if (caps.isPodcastEpi || genrename == "Podcast") {
            mediaObjectPtr->catType = CTY_PODCAST;
            mediaObjectPtr->mediaType = MTY_PODCAST;
            mediaObjectPtr->fileType = FT_AUDIO;
            strncpy_r(mediaObjectPtr->MetadataField1, albumname.c_str(),
                    sizeof(mediaObjectPtr->MetadataField1));
            strncpy_r(mediaObjectPtr->title, trackname.c_str(),
                    sizeof(mediaObjectPtr->title));
        } else {
            mediaObjectPtr->catType = CTY_SONG;
            mediaObjectPtr->mediaType = MTY_MUSIC_FILE;
            mediaObjectPtr->fileType = FT_AUDIO;
            strncpy_r(mediaObjectPtr->MetadataField1, genrename.c_str(),
                    sizeof(mediaObjectPtr->MetadataField1));
            strncpy_r(mediaObjectPtr->MetadataField2, artistname.c_str(),
                    sizeof(mediaObjectPtr->MetadataField2));
            strncpy_r(mediaObjectPtr->MetadataField3, composername.c_str(),
                    sizeof(mediaObjectPtr->MetadataField3));
            strncpy_r(mediaObjectPtr->MetadataField4, albumname.c_str(),
                    sizeof(mediaObjectPtr->MetadataField4));
            strncpy_r(mediaObjectPtr->title, trackname.c_str(),
                    sizeof(mediaObjectPtr->title));
        }
        //push back to indexer context cache
        if(pcontext) {
            pcontext->PushObject(mediaObjectPtr, MDS_SUCCESS);
        }
    }
    return ret;
}

tResult iPodControlIAP::iAP1_GetAlbumArt(const tMountPoint mountPoint, const int track, const tU64 uuid) {
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(track);
    VARTRACE(uuid);

    tResult ret = MP_NO_ERROR;
    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else if(IsIAP2(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        int formatID = m_HandleMap.GetAlbumArtID(m_MountPoint);
        if (formatID < 0) {
            ETG_TRACE_USR3(("iPodControlIAP::iAPGetAlbumArt() No AlbumArt support"));
            ret = MP_ERR_IPOD_NO_ALBUMART;
        } else {
            //get current playing track index
            int trackIndex = (int) m_HandleMap.GetNowPlayingTrackIndex(m_MountPoint);
            VARTRACE(trackIndex);
            bool sameUuid = false;
            if(uuid > 0) {
                //check for same uuid being played
                tMediaObject mediaObject;
                InitMediaObject(mediaObject);
                m_HandleMap.GetNowPlayingMediaObject(mediaObject, mountPoint);
                VARTRACE(mediaObject.UUID);
                tU64 nowPlaying_uuid = (tU64)strtoull((char *)mediaObject.UUID, NULL, 16); //Hex
                const bool validUuids = nowPlaying_uuid > 0 && uuid > 0;
                sameUuid = validUuids && nowPlaying_uuid == uuid;
            }
            VARTRACE(sameUuid);
            if (trackIndex < 0 || (trackIndex != track && !sameUuid)) {
                ETG_TRACE_ERR(("iPodControlIAP::iAPGetAlbumArt() current track (%d) does not match albumart request (%d)", trackIndex, track));
                ret = MP_ERR_IPOD_SELECT;
            } else {
                //get album art count
                tIPODPlayingTrackInfo trackInfo;
                trackInfo.type = IPOD_TRACK_ARTWORK_COUNT;
                trackInfo.artworkFormatID = formatID;
                if (!GetPlayingTrackInfo(&trackInfo, trackIndex)) {
                    ETG_TRACE_ERR(("iPodControlIAP::iAPGetAlbumArt() GetPlayingTrackInfo failed"));
                    ret = MP_ERR_IPOD_METADATA;
                } else if (trackInfo.artworkCount <= 0) {
                    ETG_TRACE_USR3(("iPodControlIAP::iAPGetAlbumArt() album art count zero"));
                    ret = MP_ERR_IPOD_NO_ALBUMART;
                } else {
                    //check artwork times
                    U16 timesCount;
                    U32 timesBuffer;
                    if (!GetTrackArtworkTimes(trackIndex, formatID, 0, 1,
                            &timesCount, &timesBuffer)) {
                        ETG_TRACE_ERR(("iPodControlIAP::iAPGetAlbumArt() GetTrackArtworkTimes failed"));
                        ret = MP_ERR_IPOD_METADATA;
                    } else if (timesCount == 0) {
                        ETG_TRACE_ERR(("iPodControlIAP::iAPGetAlbumArt() album art times zero"));
                        ret = MP_ERR_IPOD_NO_ALBUMART;
                    } else {
                        //get the album art data
                        if (!GetTrackArtworkData(trackIndex, formatID,
                                timesBuffer)) {
                            ETG_TRACE_ERR(("iPodControlIAP::iAPGetAlbumArt() GetTrackArtworkData failed"));
                            ret = MP_ERR_IPOD_METADATA;
                        } else {
                            //success
                            ETG_TRACE_USR3(("iPodControlIAP::iAPGetAlbumArt() set async album art request, waiting for answer..."));
                        }
                    }
                }
            }
        }
    }
    return ret;
}

tResult iPodControlIAP::iAP2_GetAlbumArt(const tMountPoint mountPoint, const tMetadata title, const tU64 uuid,
        tAlbumArtObjectPtr &ptrToAlbumArtObject)
{
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(title);
    VARTRACE(uuid);
    tResult ret = MP_ERR_IPOD_FILE_ACCESS;

    if(!IsIAP2(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        tMediaObject mediaObject;
        InitMediaObject(mediaObject);
        m_HandleMap.GetNowPlayingMediaObject(mediaObject, mountPoint);
        VARTRACE(mediaObject.title);
        const int len = strlen_r(title);
        const int titleLen = strlen_r(mediaObject.title);
        const bool validTitles = (len > 0 && (len == titleLen) && !strncmp(title, mediaObject.title, len));
        VARTRACE(validTitles);

        VARTRACE(mediaObject.UUID);
        tU64 nowPlaying_uuid = (tU64)strtoull((char *)mediaObject.UUID, NULL, 16); //Hex
        const bool validUuids = nowPlaying_uuid > 0 && nowPlaying_uuid == uuid;
        VARTRACE(validUuids);

        if (!validUuids && !validTitles){
            ETG_TRACE_USR3(("No AlbumArt - Title/UUID mismatch"));
            ret = MP_ERR_IPOD_NO_ALBUMART;
        } else {
            int transferID = m_HandleMap.GetAlbumArtID(mountPoint);
            VARTRACE(transferID);
            if (transferID < 0) {
                ETG_TRACE_USR3(("No AlbumArt support"));
                ret = MP_ERR_IPOD_NO_ALBUMART;
            } else {
                m_HandleMap.LockIAP2(mountPoint); //start critical section
                tFileXferBuf * pBuf = (tFileXferBuf *)m_HandleMap.GetIAP2AlbumArtBuffer(mountPoint);
                if(pBuf) {
                    VARTRACE(pBuf->transferID);
                    VARTRACE(pBuf->size);
                    VARTRACE(pBuf->rxLen);

                    if(pBuf->transferID == transferID) {
                        if(pBuf->buffer && pBuf->size == pBuf->rxLen) {
                            ptrToAlbumArtObject = new tAlbumArtObject;  //Attention: Has to be deleted by DataProvider
                            if(ptrToAlbumArtObject) {
                                strncpy_r(ptrToAlbumArtObject->albumArtString, mediaObject.albumArtString, sizeof(ptrToAlbumArtObject->albumArtString));
                                ptrToAlbumArtObject->mimeType = MMT_JPG;
                                ptrToAlbumArtObject->sizeX = 1; //size is unknown at this time
                                ptrToAlbumArtObject->sizeY = 1;
                                ptrToAlbumArtObject->imageSize = pBuf->size;
                                ptrToAlbumArtObject->imageData = new unsigned char[(unsigned int)pBuf->size];
                                if(ptrToAlbumArtObject->imageData) {
                                    memcpy(ptrToAlbumArtObject->imageData, pBuf->buffer, (unsigned int)pBuf->size);
                                    ret = MP_NO_ERROR; //success - valid albumart ptr!
                                } else {
                                    delete ptrToAlbumArtObject;
                                    ptrToAlbumArtObject = NULL;
                                    ETG_TRACE_ERR(("No memory"));
                                }
                            } else {
                                ETG_TRACE_ERR(("No memory"));
                            }
                        } else {
                            ETG_TRACE_USR3(("Incomplete file transfer - waiting for more data"));
                            ret = MP_ERR_IPOD_NO_ACCESS;
                        }
                    } else {
                        ETG_TRACE_USR3(("No matching transfer ID - no album art data"));
                        ret = MP_ERR_IPOD_NO_ACCESS;
                    }
                } else {
                    ETG_TRACE_USR3(("No buffer - no album art data"));
                }

                //Apple Carplay logo as album art
                if(ret == MP_ERR_IPOD_FILE_ACCESS) {
                    if(LocalSPM::GetDataProvider().iPodControlIAP2CarPlayAlbumArtEnabled() && IsIAP2CarPlayMode(mountPoint)) {
                        ETG_TRACE_USR3(("Apple Carplay logo as album art"));

                        /* get the file size */
                        struct stat statBuffer;
                        if(!stat(LocalSPM::GetDataProvider().iPodControlIAP2CarPlayIcon().c_str(), &statBuffer)) {
                            VARTRACE((int)statBuffer.st_size);
                            /* read in the file */
                            FILE *fpImage = fopen(LocalSPM::GetDataProvider().iPodControlIAP2CarPlayIcon().c_str(), "rb");
                            if (fpImage) {

                                ptrToAlbumArtObject = new tAlbumArtObject;  //Attention: Has to be deleted by DataProvider
                                if(ptrToAlbumArtObject) {
                                    strncpy_r(ptrToAlbumArtObject->albumArtString, mediaObject.albumArtString, sizeof(ptrToAlbumArtObject->albumArtString));
                                    ptrToAlbumArtObject->mimeType = MMT_PNG;
                                    ptrToAlbumArtObject->sizeX = 1; //size is unknown at this time
                                    ptrToAlbumArtObject->sizeY = 1;
                                    ptrToAlbumArtObject->imageSize = statBuffer.st_size;
                                    ptrToAlbumArtObject->imageData = (tImageData)malloc(statBuffer.st_size);
                                    if(ptrToAlbumArtObject->imageData) {
                                        size_t readbytes = fread(ptrToAlbumArtObject->imageData, 1, statBuffer.st_size, fpImage);
                                        VARTRACE(readbytes);
                                        ret = MP_NO_ERROR; //success - valid albumart ptr!
                                    } else {
                                        delete ptrToAlbumArtObject;
                                        ptrToAlbumArtObject = NULL;
                                        ETG_TRACE_ERR(("No memory"));
                                    }
                                }
                                fclose(fpImage);
                            }
                        } else {
                            ETG_TRACE_ERR(("No file"));
                        }
                    }
                }
                m_HandleMap.UnlockIAP2(mountPoint); //end critical section
            }
        }
    }
    return ret;
}

tBoolean iPodControlIAP::iAPIsAlbumArtAvailable(const tMountPoint mountPoint)
{
    ENTRY;
    VARTRACE(mountPoint);
    tResult ret = MP_ERR_IPOD_FILE_ACCESS;

    if(!IsIAP2(mountPoint)) {
        const int trackIndex = (int) m_HandleMap.GetNowPlayingTrackIndex(mountPoint);
        VARTRACE(trackIndex);
        if (trackIndex >= 0 ) {
            ret = MP_NO_ERROR; //IAP1: always available
        }
    } else {
        int transferID = m_HandleMap.GetAlbumArtID(mountPoint);
        VARTRACE(transferID);



        if (transferID < 0) {
            ETG_TRACE_USR3(("No AlbumArt support"));
            ret = MP_ERR_IPOD_NO_ALBUMART;
        } else {

            m_HandleMap.LockIAP2(mountPoint); //start critical section
            tFileXferBuf * pBuf = (tFileXferBuf *)m_HandleMap.GetIAP2AlbumArtBuffer(mountPoint);
            if(pBuf) {
                VARTRACE(pBuf->transferID);
                VARTRACE(pBuf->size);
                VARTRACE(pBuf->rxLen);

                if(pBuf->transferID == transferID) {
                    if(pBuf->buffer && pBuf->size == pBuf->rxLen) {
                        ret = MP_NO_ERROR;
                    } else {
                        ETG_TRACE_USR3(("Incomplete file transfer - waiting for more data"));
                        ret = MP_ERR_IPOD_NO_ACCESS;
                    }
                } else {
                    ETG_TRACE_USR3(("No matching transfer ID - no album art data"));
                    ret = MP_ERR_IPOD_NO_ACCESS;
                }
            } else {
                ETG_TRACE_USR3(("No buffer - no album art data"));
            }
            //Apple Carplay logo as album art
            if(ret == MP_ERR_IPOD_FILE_ACCESS) {
                if(LocalSPM::GetDataProvider().iPodControlIAP2CarPlayAlbumArtEnabled() && IsIAP2CarPlayMode(mountPoint)) {
                    ETG_TRACE_USR3(("Apple Carplay logo as album art"));
                    ret = MP_NO_ERROR;
                }
            }
            m_HandleMap.UnlockIAP2(mountPoint); //end critical section
        }
    }
    return (ret == MP_NO_ERROR);
}

tResult iPodControlIAP::iAPTransferTag(tTagTransferStatus &status,
        const tMountPoint mountPoint, const tFilename tagfile) {
    ENTRY;
    ETG_TRACE_USR3(("%s", __PRETTY_FUNCTION__));
    VARTRACE(mountPoint);
    VARTRACE(tagfile);

    //defaults
    tResult ret = MP_NO_ERROR;
    status = TAG_TRANSFER_COMM_ERROR;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else if (IsIAP2(mountPoint) || !m_HandleMap.GetOption(m_MountPoint, hasPlayPauseOption)) {
        status = TAG_TRANSFER_NOT_SUPPORTED;
    } else {
        //check tag file
        struct stat statBuffer;
        if (0 != stat(tagfile, &statBuffer)) {
            ETG_TRACE_ERR(("%s - Cannot stat tag file", __PRETTY_FUNCTION__));
            ret = MP_ERR_IPOD_FILE_ACCESS;
        } else if (statBuffer.st_size <= 0) {
            ETG_TRACE_ERR(("%s - invalid file size", __PRETTY_FUNCTION__));
            ret = MP_ERR_IPOD_FILE_ACCESS;
        } else {
            VARTRACE((int)statBuffer.st_size);
            //check iPod free space
            U64 iPodFreeBytes = 0;
            int res = iPodGetiPodFreeSpace(IPODCONTROL_ID_FRONT &iPodFreeBytes);
            ETG_TRACE_USR3(("iPodGetiPodFreeSpace returned %d", res));
            if (IPOD_OK != res || iPodFreeBytes
                    < (unsigned int) statBuffer.st_size) {
                ETG_TRACE_ERR(("%s - no free space", __PRETTY_FUNCTION__));
                if(IPOD_OK != res) {
                    UpdateIpodCommunicationError(res);
                }
                status = TAG_TRANSFER_DEVICE_FULL;
            } else {
                VARTRACE((int)(iPodFreeBytes>>32));
                VARTRACE((int)iPodFreeBytes);
                //read data from file
                FILE *fpTag = fopen(tagfile, "rb");
                if (!fpTag) {
                    ETG_TRACE_ERR(("%s - invalid file handle", __PRETTY_FUNCTION__));
                    ret = MP_ERR_IPOD_FILE_ACCESS;
                } else {
                    unsigned char * tagData = new unsigned char[statBuffer.st_size + 1];
                    if (!tagData) {
                        ETG_TRACE_ERR(("%s - null pointer", __PRETTY_FUNCTION__));
                        ret = MP_ERR_IPOD_NO_MEM;
                    } else {
                        memset(tagData, 0, statBuffer.st_size);
                        if (statBuffer.st_size != (int) fread(tagData, 1,
                                statBuffer.st_size, fpTag)) {
                            ETG_TRACE_ERR(("%s - invalid read data", __PRETTY_FUNCTION__));
                            ret = MP_ERR_IPOD_FILE_ACCESS;
                        } else {
                            //open iPod file
                            IPOD_FILE_OPTIONS_MASK bitMask = { 0, 0, 0, 0, 0 };
                            unsigned char fileAppendix = 0;
                            unsigned char fileHandle = 0xFF;
                            res = iPodOpeniPodFeatureFile(
                                    IPODCONTROL_ID_FRONT IPOD_RADIO_TAGGING,
                                    &bitMask, &fileAppendix, 0, &fileHandle);
                            ETG_TRACE_USR3(("iPodOpeniPodFeatureFile returned %d", res));
                            if (IPOD_OK != res) {
                                UpdateIpodCommunicationError(res);
                                ret = MP_ERR_IPOD_NO_FREE_SPACE;
                                status = TAG_TRANSFER_DEVICE_FULL;
                            } else {
                                //write data to iPod in chunks of 100 char
                                int writeOffset = 0;
                                int writeLen = statBuffer.st_size;
                                if (writeLen > IPODCONTROL_FILE_WRITE_CHUNK) {
                                    writeLen = IPODCONTROL_FILE_WRITE_CHUNK;
                                }
                                while (IPOD_OK == res && writeOffset
                                        < statBuffer.st_size) {
                                    //dump xml
                                    ETG_TRACE_USR3(("TRANSFER TAG\n\n%100s\n\n", (char *)(tagData + writeOffset)));
                                    res = iPodWriteiPodFileData(
                                            IPODCONTROL_ID_FRONT writeOffset,
                                            fileHandle, tagData + writeOffset,
                                            writeLen);
                                    ETG_TRACE_USR3(("iPodWriteiPodFileData returned %d", res));
                                    if (IPOD_OK != res) {
                                        UpdateIpodCommunicationError(res);
                                        ret = MP_ERR_IPOD_NO_FREE_SPACE;
                                        status = TAG_TRANSFER_DEVICE_FULL;
                                    }
                                    writeOffset += writeLen;
                                    writeLen = statBuffer.st_size - writeOffset;
                                    if (writeLen > IPODCONTROL_FILE_WRITE_CHUNK) {
                                        writeLen = IPODCONTROL_FILE_WRITE_CHUNK;
                                    }
                                }
                                VARTRACE(writeOffset);

                                //close iPod file
                                int resClose = iPodCloseiPodFile(
                                        IPODCONTROL_ID_FRONT fileHandle);
                                ETG_TRACE_USR3(("iPodCloseiPodFile returned %d", resClose));
                                if (IPOD_OK != resClose) {
                                    UpdateIpodCommunicationError(resClose);
                                    ret = MP_ERR_IPOD_NO_FREE_SPACE;
                                    status = TAG_TRANSFER_DEVICE_FULL;
                                } else if (res == IPOD_OK) {
                                    //success
                                    status = TAG_TRANSFER_SUCCESS;
                                }
                            }
                        }
                        delete [] tagData;
                    }
                    fclose(fpTag);
                }
            }
        }
    }
    VARTRACE(ret);
    return ret;
}

tResult iPodControlIAP::iAPAddAppControlInfo(const tMountPoint mountPoint,
        const tProtocolName protocol, const tBundleSeedID bundleSeedID,
        const tAppName appName, bool &added) {
    ENTRY;
    ETG_TRACE_USR3(("%s", __PRETTY_FUNCTION__));
    VARTRACE(mountPoint)
    VARTRACE(protocol)
    VARTRACE(bundleSeedID)
    VARTRACE(appName)

    added = m_HandleMap.AddAppInfo(mountPoint, protocol, bundleSeedID, appName);

    VARTRACE(added);
    return MP_NO_ERROR;
}

tResult iPodControlIAP::iAPRemoveAppControlInfo(const tMountPoint mountPoint,
        const tAppName appName, const tSessionID sessionID, bool &removed) {
    ENTRY;
    ETG_TRACE_USR3(("%s", __PRETTY_FUNCTION__));
    VARTRACE(mountPoint)
    VARTRACE(appName)
    VARTRACE(sessionID)

    tSessionID sessionIDRemoved = 0;
    removed = m_HandleMap.RemoveAppInfo(mountPoint, appName, sessionIDRemoved);
    VARTRACE(sessionIDRemoved);
    if (sessionIDRemoved != sessionID) {
        ETG_TRACE_ERR(("%s invalid session id", __PRETTY_FUNCTION__));
    }
    //check if active session
    if (sessionIDRemoved > 0) {
        //update property
        LocalSPM::GetOutputWrapper().AppControlClose(mountPoint, appName,
                sessionIDRemoved);
    }
    VARTRACE(removed);
    return MP_NO_ERROR;
}

tResult iPodControlIAP::iAPAddAppControlInfoFromSPI(const tMountPoint mountPoint,
        const tProtocolName protocol, const tBundleSeedID bundleSeedID,
        const tAppName appName, bool &added) {
    ENTRY;
    ETG_TRACE_USR3(("%s", __PRETTY_FUNCTION__));
    VARTRACE(mountPoint)
    VARTRACE(protocol)
    VARTRACE(bundleSeedID)
    VARTRACE(appName)
    added = m_HandleMap.AddAppInfoFromSPI(mountPoint, protocol, bundleSeedID, appName);
    VARTRACE(added);
    return MP_NO_ERROR;
}
tResult iPodControlIAP::iAPClearAppInfofromSPI(const tMountPoint mountPoint) {
    ENTRY;
    m_HandleMap.ClearAppInfofromSPI(mountPoint);
    return MP_NO_ERROR;
}
tResult iPodControlIAP::iAPAppControlCommand(const tMountPoint mountPoint,
        const tAppName appName, const tSessionID sessionID,
        const tSize sizeOfBuffer, const tCommandBufferPtr commandBuffer) {
    ENTRY;
    ETG_TRACE_USR3(("%s", __PRETTY_FUNCTION__));
    VARTRACE(mountPoint)
    VARTRACE(appName)
    VARTRACE(sessionID)
    VARTRACE(sizeOfBuffer)
    iAPTraceData(commandBuffer, sizeOfBuffer);

    //defaults
    tResult ret = MP_NO_ERROR;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
#if 0
        //verifiy sessionID
        tSessionID sessionIDfromApp = m_HandleMap.GetSessionIDFromAppName(m_MountPoint, appName);
        VARTRACE(sessionIDfromApp);
        if (sessionID == 0 || sessionID != sessionIDfromApp) {
            ETG_TRACE_ERR(("%s invalid session id", __PRETTY_FUNCTION__));
            ret = MP_ERR_IPOD_INVALID_PARAM;
        } else
#endif
        if(IsIAP2(mountPoint)) {
            ret = MP_ERR_IPOD_NO_ACCESS;
#ifdef IPODCONTROL_IAP2_PF_AVAIL
            m_HandleMap.LockIAP2(m_MountPoint); //start critical section
            iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(m_MountPoint);
            if(!iap2Device) {
                ETG_TRACE_ERR(("!iap2Device"));
            } else {
                unsigned int protocolID = m_HandleMap.GetProtocolIDFromAppName(m_MountPoint, appName);
                VARTRACE(protocolID);
                if(protocolID > 0) {
                    int res = iAP2SendEAPSessionMessage(iap2Device, commandBuffer, sizeOfBuffer, protocolID);
                    ETG_TRACE_USR3(("iAP2SendEAPSessionMessage returned %d", res));
                    if(IAP2_OK == res) {
                        ret = MP_NO_ERROR;
                    }
                    else {
                        UpdateIpodCommunicationError(res);
                    }
                }
            }
            m_HandleMap.UnlockIAP2(m_MountPoint); //end critical section
#endif
        } else {

            int res = iPodDevDataTransfer(IPODCONTROL_ID_FRONT sessionID,
                    commandBuffer, (U16) sizeOfBuffer);
            ETG_TRACE_USR3(("iPodDevDataTransfer() return %d", res));
            if (IPOD_OK != res) {
                ret = MP_ERR_IPOD_COMMAND;
                UpdateIpodCommunicationError(res);
            }
        }
    }
    VARTRACE(ret);
    return ret;
}

tResult iPodControlIAP::iAPLaunchApp(const tMountPoint mountPoint, const tAppName appName, const tAppLaunchOption launchOption) {
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(appName);
    VARTRACE(launchOption);
    tResult retVal = MP_NO_ERROR;

    if (!SelectDevice(mountPoint)) {
        retVal = MP_ERR_IPOD_NO_ACCESS;
    } else if(IsIAP2(mountPoint)) {
        if(!m_HandleMap.GetOption(m_MountPoint, hasAppLaunchOption)) {
            ETG_TRACE_ERR(("application launch not supported"));
            retVal = MP_ERR_IPOD_COMMAND;
        } else {
            retVal = MP_ERR_IPOD_NO_ACCESS;
#ifdef IPODCONTROL_IAP2_PF_AVAIL
            m_HandleMap.LockIAP2(m_MountPoint); //start critical section
            iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(m_MountPoint);
            if(!iap2Device) {
                ETG_TRACE_ERR(("!iap2Device"));
            } else {
                iAP2RequestAppLaunchParameter requestAppLaunchParameter;
                memset(&requestAppLaunchParameter, 0, sizeof(iAP2RequestAppLaunchParameter));
                requestAppLaunchParameter.iAP2AppBundleID = new U8*[1];
                if(requestAppLaunchParameter.iAP2AppBundleID) {
                    size_t size = strnlen(appName, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
                    requestAppLaunchParameter.iAP2AppBundleID[0] = new U8[size];
                    if(requestAppLaunchParameter.iAP2AppBundleID[0]) {
                        strncpy_r((char *)requestAppLaunchParameter.iAP2AppBundleID[0], appName, size);
                        requestAppLaunchParameter.iAP2AppBundleID_count = 1;

                        requestAppLaunchParameter.iAP2LaunchAlert = new iAP2AppLaunchMethod[1];
                        if(requestAppLaunchParameter.iAP2LaunchAlert) {
                            requestAppLaunchParameter.iAP2LaunchAlert[0] = (launchOption == ALO_LAUNCH_WITHOUT_USER_ALERT) ? IAP2_LAUNCH_WITHOUT_USER_ALERT : IAP2_LAUNCH_WITH_USER_ALERT;
                            requestAppLaunchParameter.iAP2LaunchAlert_count = 1;
                            int res = iAP2RequestAppLaunch(iap2Device, &requestAppLaunchParameter);
                            ETG_TRACE_USR3(("iAP2RequestAppLaunch returned %d", res));
                            if(IAP2_OK == res) {
                                retVal = MP_NO_ERROR;
                            }
                            else {
                                UpdateIpodCommunicationError(res);
                            }
                        }
                    }
                    iAP2FreeiAP2RequestAppLaunchParameter(&requestAppLaunchParameter);
                }
            }
            m_HandleMap.UnlockIAP2(m_MountPoint); //end critical section
        }
#endif
    } else {
        int retLaunched = IPOD_ERROR;
        //evaluate sessionID
        tSessionID sessionID = m_HandleMap.GetSessionIDFromAppName(m_MountPoint,
                appName);
        VARTRACE(sessionID);

        if (sessionID > 0) {
            ETG_TRACE_USR3(("%s session already open", __PRETTY_FUNCTION__));
        } else if (m_HandleMap.GetOption(m_MountPoint, hasAppLaunchOption)) {
            retLaunched = iPodRequestAppLaunch(
                    IPODCONTROL_ID_FRONT (U8*) appName, strlen_r(appName) + 1); //lint !e1773 iap1 methode syntax issue //+1 is an ADIT issue
            ETG_TRACE_USR3(("iPodRequestAppLaunch() return %d", retLaunched));
            if(IPOD_OK != retLaunched) {
                UpdateIpodCommunicationError(retLaunched);
            }
        } else {
            ETG_TRACE_ERR(("%s application launch not supported", __PRETTY_FUNCTION__));
        }
        VARTRACE(retLaunched);
        if (retLaunched != IPOD_OK) {
            //send property update
            tProtocolName protocolName = { 0 };
            unsigned int protocolID = m_HandleMap.GetProtocolIDFromAppName(m_MountPoint, appName);
            VARTRACE(protocolID);
            iAPGetProtocolNameByProtocolID(mountPoint,protocolID, protocolName);
            VARTRACE(protocolName);

            retVal = LocalSPM::GetOutputWrapper().AppControlConnect(mountPoint,
                    appName, sessionID,protocolName);
        }
    }

    VARTRACE(retVal);
    return retVal;
}

tResult iPodControlIAP::iAPCurrentSelectionChanged(tBoolean &changed, const tDeviceID deviceID)
{
    ENTRY;
    VARTRACE(deviceID);

    tMountPoint mountPoint = {0};
    m_HandleMap.GetMountPointFromDeviceID(mountPoint, deviceID);

    if (!iAP_IsDeviceHandleAvail(mountPoint)) {
        ETG_TRACE_ERR(("iPod not accessible"));
        return MP_ERR_IPOD_NO_ACCESS;
    }

    //Deliver flag if selection was changed via IAP since device connection on specific device
    //check if iPod playing list has been changed to a new selection from iPodDB (DBPath)
    iPodControlMediaPath pbpath = m_HandleMap.GetPBPath(mountPoint);
    changed = pbpath.IsValid() && pbpath.IsDBPath();

    //TODO: IAP2
    return MP_NO_ERROR;
}

//********************* PRIVATE ***********************************************
//**************************** init *******************************************

void iPodControlIAP::iAP1_IdentifyDevice() {
    ENTRY;

    //send iAP command, notifications expected
    m_HandleMap.ResetElapsedTime(m_MountPoint, iapInitElapsed);
    m_HandleMap.ResetElapsedTime(m_MountPoint, pbNotifications);

    int res = iPodSetEventNotification(IPODCONTROL_ID_FRONT m_NotificationMask);
    ETG_TRACE_USR3(("iPodSetEventNotification returned %d", res));
#ifdef TARGET_BUILD_GEN3
    res = iPodSetRemoteEventNotification(IPODCONTROL_ID_FRONT m_RemoteEventNotificationMask);
    ETG_TRACE_USR3(("iPodSetRemoteEventNotification returned %d", res));
#endif
    res = iPodEnterExtendedInterfaceMode(IPODCONTROL_ID_ONLY);
    ETG_TRACE_USR3(("iPodEnterExtendedInterfaceMode returned %d", res));

    //ATS requirement: GetPlayStatus need to be first call after entering into extended mode
    if (!UpdatePlayStatus()) {
        ETG_TRACE_ERR(("UpdatePlayStatus failed"));
        //res = IPOD_ERROR;
    }

    //get the initial shuffle and repeat mode
    //initial update for playback mode
    res = iPodGetShuffleMode(IPODCONTROL_ID_ONLY);
    ETG_TRACE_USR3(("iPodGetShuffleMode returned %d", res));
    iAPSetPlaybackModeFromIPOD(m_MountPoint, res);

    //initial update for playback mode
    res = iPodGetRepeatMode(IPODCONTROL_ID_ONLY);
    ETG_TRACE_USR3(("iPodGetRepeatMode returned %d", res));
    bool repeatInitFlag = iAPGetRepeatInitFlag(m_MountPoint);
    if( LocalSPM::GetDataProvider().SetDefaultRepeatModeToRPTListAppleDevice() && repeatInitFlag && (RPT_NONE == res) )
    {
        tRepeatMode repeatMode = RPT_LIST;
        LocalSPM::GetIPODControl().SendSetRepeatMode(m_MountPoint,repeatMode);
        iAPSetRepeatInitFlag(m_MountPoint,false);
    }
    else
    {
        iAPSetRepeatModeFromIPOD(m_MountPoint, res);
    }

    //get current track index and metadata
    m_HandleMap.SetNowPlayingTrackIndex(m_MountPoint, -1);

    //If Required: Check for number of playing track, if zero select ALL_SONGS_PLYLST track 0 here
    if (!UpdateNowPlaying(false)) {
        ETG_TRACE_ERR(("UpdateNowPlaying failed"));
    }

    //Get iPod name
    U8 utf8_iPodStr[IPOD_RESPONSE_BUF_SIZE] = { 0 };
    res = iPodGetIPodName(IPODCONTROL_ID_FRONT utf8_iPodStr);
    if (IPOD_OK != res) {
        ETG_TRACE_ERR(("iPodGetIPodName failed %d", res));
    } else {
        //validate metadata
        LocalSPM::GetDataProvider().ImportAndCut(
                INOUT (FastUTF8::tString) utf8_iPodStr, sizeof(utf8_iPodStr));
        ETG_TRACE_USR3(("*** IPOD NAME: '%s'", (char*)utf8_iPodStr));
        m_HandleMap.SetDeviceName(m_MountPoint, (char*) utf8_iPodStr);
    }

    //get focus app
    U8 focusApp[IPOD_RESPONSE_BUF_SIZE] = { 0 };
    res = iPodGetNowPlayingFocusApp(IPODCONTROL_ID_FRONT focusApp, sizeof(focusApp));
    ETG_TRACE_USR3(("iPodGetNowPlayingFocusApp returned %d", res));
    if (IPOD_OK == res) {
        ETG_TRACE_USR3(("*** FOCUS APP: '%s'", (char*)focusApp));
        m_HandleMap.SetFocusApp(m_MountPoint, (char*)focusApp);
    }

    //get options
    U8 utf8_iPodModel[IPOD_RESPONSE_BUF_SIZE] = { 0 };
    m_HandleMap.SetOption(m_MountPoint, hasAlbumArtOption, true); //default ok, suppressed for certain devices see below

    //GENERAL LINGO
    U64 generalLingoOptionBits = 0;
    res = iPodGetiPodOptionsForLingo(IPODCONTROL_ID_FRONT IPOD_LINGO_GENERAL,
            &generalLingoOptionBits);
    if (IPOD_OK != res) {
        ETG_TRACE_USR3(("iPodGetiPodOptionsForLingo(IPOD_LINGO_GENERAL) returned %d", res));
    } else {
        ETG_TRACE_USR3(("*** GENERAL LINGO OPTIONS 0x%08x%08x", (U32)(generalLingoOptionBits>>32), (U32)(generalLingoOptionBits&0xffffffff)));
        m_HandleMap.SetOption(m_MountPoint, hasAppLaunchOption,
                generalLingoOptionBits & 0x1000000); //general lingo option bit 24 "Request Application launch",
    }

    //EXTENDED INTERFACE LINGO
    U64 extendedLingoOptionBits = 0;
    res = iPodGetiPodOptionsForLingo(
            IPODCONTROL_ID_FRONT IPOD_LINGO_EXTENDED_INTERFACE,
            &extendedLingoOptionBits);
    if (IPOD_OK == res) {
        ETG_TRACE_USR3(("*** EXTENDED INTERFACE LINGO OPTIONS 0x%08x%08x", (U32)(extendedLingoOptionBits>>32), (U32)(extendedLingoOptionBits&0xffffffff)));
        m_HandleMap.SetOption(m_MountPoint, hasVideoOption, extendedLingoOptionBits
                & 0x01); //extended lingo option bit 00,
        m_HandleMap.SetOption(m_MountPoint, hasTrackInfoOption,
                extendedLingoOptionBits & 0x02); //extended lingo option bit 01,
        m_HandleMap.SetOption(m_MountPoint, hasDisplayImageOption,
                extendedLingoOptionBits & 0x10); //extended lingo option bit 04,
        m_HandleMap.SetOption(m_MountPoint, hasPlayPauseOption,
                extendedLingoOptionBits & 0x40); //extended lingo option bit 06,
    } else {
        ETG_TRACE_USR3(("iPodGetiPodOptionsForLingo(IPOD_LINGO_EXTENDED_INTERFACE) returned %d", res));
        //ATS: options not available, so we are allowed to check features by comparing version numbers
        U8 extendedLingoMajorVer = 0;
        U8 extendedLingoMinorVer = 0;
        res = iPodGetLingoProtocolVersion(
                IPODCONTROL_ID_FRONT IPOD_LINGO_EXTENDED_INTERFACE,
                &extendedLingoMajorVer, &extendedLingoMinorVer);
        if (IPOD_OK != res) {
            ETG_TRACE_ERR(("iPodGetLingoProtocolVersion(IPOD_LINGO_EXTENDED_INTERFACE) failed %d", res));
        } else {
            ETG_TRACE_USR3(("*** EXTENDED INTERFACE LINGO VERSION %u.%u", extendedLingoMajorVer, extendedLingoMinorVer));
        }

        U64 optionBits = 0;
        res = iPodGetiPodOptions(
                IPODCONTROL_ID_FRONT (IPOD_OPTIONS_BIT*) &optionBits);
        if (IPOD_OK != res) {
            ETG_TRACE_ERR(("iPodGetiPodOptions() failed %d", res));
        } else {
            ETG_TRACE_USR3(("*** IPOD OPTION BITS 0x%08x%08x", (U32)(optionBits>>32), (U32)(optionBits&0xffffffff)));
        }
        //video browsing has been introduced with Extended Lingo Version 1.11, check in combination with videoOut option
        m_HandleMap.SetOption(m_MountPoint, hasVideoOption, (optionBits & 0x01)
                && (extendedLingoMajorVer > 2 || (extendedLingoMajorVer == 1
                        && extendedLingoMinorVer >= 11)));
        //get track info calls have been introduced with Extended Lingo Version 1.13
        m_HandleMap.SetOption(m_MountPoint, hasTrackInfoOption,
                extendedLingoMajorVer > 2 || (extendedLingoMajorVer == 1
                        && extendedLingoMinorVer >= 13));
        //support for Play and Pause commands have been introduced with Extended Lingo Version 1.13
        m_HandleMap.SetOption(m_MountPoint, hasPlayPauseOption,
                extendedLingoMajorVer > 2 || (extendedLingoMajorVer == 1
                        && extendedLingoMinorVer >= 13));

        //set display image (colored) has been introduced with Extended Lingo Version 1.09
        m_HandleMap.SetOption(m_MountPoint, hasDisplayImageOption, true);

        //Handle albumart suppression: Apple Bug ID# 10662453
        //Freeze of iPod nano 3G when requesting AlbumArt Data
        res = iPodGetModelNum(IPODCONTROL_ID_FRONT utf8_iPodModel);
        if (IPOD_OK > res) {
            ETG_TRACE_ERR(("iPodGetModelNum() failed %d", res));
        } else {
            ETG_TRACE_USR3(("*** IPOD MODEL '%s'", (char*)utf8_iPodModel));
            utf8_iPodModel[5] = '\0'; //cut optional model info
            m_HandleMap.SetOption(m_MountPoint, hasAlbumArtOption,
                    !IsModeliPodNano3G((const char *) utf8_iPodModel));
        }
    }

    if (m_HandleMap.GetOption(m_MountPoint, hasTrackInfoOption)) {
        //use iPodPlayCurrentSelection for nano 3G and classic 80GB, see shuffle issue "NIKAI-1923 Wrong track is played"
        m_HandleMap.SetOption(
                m_MountPoint,
                hasPlaySelectionOption,
                IsModeliPodNano3G((const char *) utf8_iPodModel)
                        || IsModeliPodClassic80GB((const char *) utf8_iPodModel));

        //Testing feature DBTrackInfo (iOS 5, iPod nano 3 and more)
        //Issue on iPod nano 5G, returning wrong transaction number so iPodGetDBTrackInfo fails
        //validating feature dynamically once:
        iPodControlMediaPath tracks(LTY_SONG);
        if (!SelectRecord(tracks)) {
            ETG_TRACE_ERR(("SelectRecord(LTY_SONG) failed"));
        } else {
            ETG_TRACE_USR3(("*** TOTAL TRACKS %d", tracks.GetCurrentCount()));
            if (tracks.GetCurrentCount() > 0) {
                //dummy call to check DBTrackInfo feature on first track
                IPOD_TRACK_INFORMATION_BITFIELD bitfield = { 0 };
                bitfield.track_info.CAPABILITIES = 1;
                tIPODTrackInfos dummyMap;
                if (!GetTrackInfo(&dummyMap, bitfield, 0, 1, true)) {
                    m_HandleMap.SetOption(m_MountPoint, hasTrackInfoOption, false);
                    ETG_TRACE_ERR(("TrackInfo test failed."));
                }
            }
        }
    } else { //LEGACY
        //Indexing feature
        //iPod touch 1st generation needs call s32IpodReturnToPreviousDBRecordSelection when parsing DB
        //new iPods that support DBTrackinfo, do not have this limitation anymore
        m_HandleMap.SetOption(m_MountPoint, hasDeselectDBOption, true);

        //older Ipods (e.g. Ipod Video) needs the call of iPodPlayCurrentSelection to start playing
        //on the other hand we have to avoid the call of iPodPlayCurrentSelection because
        //its deprecated (ATS warning)
        m_HandleMap.SetOption(m_MountPoint, hasPlaySelectionOption, true);

    }

    //STORAGE LINGO
    U64 storageLingoOptionBits = 0;
    res = iPodGetiPodOptionsForLingo(IPODCONTROL_ID_FRONT IPOD_LINGO_STORAGE,
            &storageLingoOptionBits);
    if (IPOD_OK == res) {
        ETG_TRACE_USR3(("*** STORAGE LINGO OPTIONS 0x%08x%08x", (U32)(storageLingoOptionBits>>32), (U32)(storageLingoOptionBits&0xffffffff)));
        m_HandleMap.SetOption(m_MountPoint, hasTaggingOption,
                storageLingoOptionBits & 0x01); //iTune tagging storage lingo option bit 00,
    } else {
        ETG_TRACE_USR3(("iPodGetiPodOptionsForLingo(IPOD_LINGO_STORAGE) returned %d", res));
        //ATS: options not available, so we are allowed to check features by comparing version numbers
        U8 storageLingoMajorVer = 0;
        U8 storageLingoMinorVer = 0;
        res = iPodGetLingoProtocolVersion(
                IPODCONTROL_ID_FRONT IPOD_LINGO_STORAGE, &storageLingoMajorVer,
                &storageLingoMinorVer);
        if (IPOD_OK != res) {
            ETG_TRACE_ERR(("iPodGetLingoProtocolVersion(IPOD_LINGO_STORAGE) failed %d", res));
        } else {
            ETG_TRACE_USR3(("*** STORAGE LINGO VERSION %u.%u", storageLingoMajorVer, storageLingoMinorVer));
        }
        //support for iTunes tagging has been introduced with Storage Lingo Version 1.01
        m_HandleMap.SetOption(m_MountPoint, hasTaggingOption, storageLingoMajorVer
                > 2 || (storageLingoMajorVer == 1 && storageLingoMinorVer >= 1));
    }

    //configure play status notification
    IPOD_EXTENDED_STATUS_CHANGE_NOTIFICATION nexmode = {0};
    nexmode.basicPlay = 1;
    nexmode.extendedPlay = 1;
    nexmode.trackIndex = 1;
    nexmode.trackTimeMs = 1;

    nexmode.trackTimeSec = 0;
    nexmode.chapterIndex = 1;
    nexmode.chapterTimeMs = 1;
    nexmode.chapterTimeSec = 0;

    nexmode.trackUID = 1;
    nexmode.trackMediaType = 1;
    nexmode.trackLyrics = 0;
    nexmode.capChanges = 1;
    nexmode.pbChange = 1;

    res = iPodExtendedSetPlayStatusChangeNotification(IPODCONTROL_ID_FRONT nexmode);
    ETG_TRACE_USR3(("iPodExtendedSetPlayStatusChangeNotification() returned %d", res));

    if (IPOD_OK != res) {
        res = iPodSetPlayStatusChangeNotification(IPODCONTROL_ID_FRONT
        IPOD_STATUS_CHANGE_NOTIFICATION_ENABLE);
        ETG_TRACE_USR3(("iPodSetPlayStatusChangeNotification() returned %d", res));
    } else {
        m_HandleMap.SetOption(m_MountPoint, hasExtPlayStatusOption, true);
    }

    //Remote Control: bind to iOS devices, AppLaunch option
    m_HandleMap.SetOption(m_MountPoint, hasRemoteControlOption, m_HandleMap.GetOption(m_MountPoint, hasAppLaunchOption));

    //get album art formats
    if (!m_HandleMap.GetOption(m_MountPoint, hasAlbumArtOption)) {
        ETG_TRACE_USR3(("No albumart supported"));
    } else {

        //read out iPod supported albumart format
        //only once required per connection cycle
        U16 artworkFormatCount = IPODCONTROL_ARTWORK_MAX;
        IPOD_ARTWORK_FORMAT pArtworkFormat[IPODCONTROL_ARTWORK_MAX];
        res = iPodGetArtworkFormats(IPODCONTROL_ID_FRONT pArtworkFormat,
                &artworkFormatCount);
        ETG_TRACE_USR3(("iPodGetArtworkFormats returned %d", res));
        if (res == IPOD_OK) {
            int awindex = -1;
            int widthLast = 0;
            VARTRACE(artworkFormatCount);

            const int widthMin = LocalSPM::GetDataProvider().iPodControlAlbumArtWidthMin();
            const int widthMax = LocalSPM::GetDataProvider().iPodControlAlbumArtWidthMax();

            for (tU16 u16count = 0; u16count < artworkFormatCount; u16count++) {
                ETG_TRACE_USR1(("Format #%d", u16count));
                VARTRACE(pArtworkFormat[u16count].formatID);
                VARTRACE(pArtworkFormat[u16count].imageHeight);
                VARTRACE(pArtworkFormat[u16count].imageWidth);
                VARTRACE(pArtworkFormat[u16count].pixelFormat);

                //check for valid formats (rgb 160x160)
                if (pArtworkFormat[u16count].pixelFormat == 2) { //rgb565
                    int widthNew = pArtworkFormat[u16count].imageWidth;
                    if (!widthLast
                            || (widthLast > widthMax && widthLast > widthNew)
                            || (widthLast < widthMin && widthLast < widthNew)
                            || (widthNew >= widthMin && widthNew <= widthMax
                                    && widthLast > widthNew)) {
                        awindex = u16count;
                        widthLast = widthNew;
                    }
                }
            }
            if (awindex < 0) {
                ETG_TRACE_ERR(("No valid artwork format found"));
            } else {
                m_HandleMap.SetAlbumArtID(m_MountPoint,
                        pArtworkFormat[awindex].formatID);
                ETG_TRACE_USR3(("Selected #%d formatID=%d (%dx%d@rgb565)",
                                awindex,
                                pArtworkFormat[awindex].formatID,
                                pArtworkFormat[awindex].imageWidth,
                                pArtworkFormat[awindex].imageHeight));
            }
        }
    }

    //upload display image
    if(m_HandleMap.GetOption(m_MountPoint, hasDisplayImageOption) && !LocalSPM::GetDataProvider().iPodControlDisplayImage().empty()) {
        VARTRACE(LocalSPM::GetDataProvider().iPodControlDisplayImage().c_str());
        IPOD_DISPLAY_IMAGE_LIMITS pResultBuf[2];
        U16 resultCount = 2;

         res = iPodGetColorDisplayImageLimits(IPODCONTROL_ID_FRONT pResultBuf, &resultCount);
         ETG_TRACE_USR3(("iPodGetColorDisplayImageLimits returned %d", res));
         VARTRACE(resultCount);
         for(unsigned int i = 0; i < resultCount && res == IPOD_OK; i++) {
             ETG_TRACE_USR3((" IPOD_DISPLAY_IMAGE_LIMITS #%d: x=%u", i, pResultBuf[i].width));
             ETG_TRACE_USR3((" IPOD_DISPLAY_IMAGE_LIMITS #%d: y=%u", i, pResultBuf[i].height));
             ETG_TRACE_USR3((" IPOD_DISPLAY_IMAGE_LIMITS #%d: format=%u", i, pResultBuf[i].pixelFormat));
         }
         if(resultCount > 0) {
             res = iPodSetDisplayImageBMP(IPODCONTROL_ID_FRONT (const tU8*)LocalSPM::GetDataProvider().iPodControlDisplayImage().c_str());
             ETG_TRACE_USR3(("iPodSetDisplayImageBMP returned %d", res));
         }
    }

    m_HandleMap.TraceOptions(m_MountPoint);
}

tResult iPodControlIAP::iAP2_IdentifyDevice() {
    ENTRY;
    tResult ret = MP_NO_ERROR;
#ifdef IPODCONTROL_IAP2_PF_AVAIL
    int res = IAP2_CTL_ERROR;

    const tBoolean hostMode = IsIAP2HostMode(m_MountPoint);
    VARTRACE(hostMode);

    const tBoolean carPlay = IsIAP2CarPlayMode(m_MountPoint);
    const tBoolean wirelessCarplay = IsIAP2WirelessCarPlayMode(m_MountPoint);
    const tBoolean isCPWActive = m_HandleMap.GetIsCPWActiveForUSBMountPoint(m_MountPoint);
    const tBoolean nativeTransport = IsIAP2NativeTransportMode(m_MountPoint);
    const tBoolean carLife =  IsIAP2NativeTransportCarlifeMode(m_MountPoint);
    const tBoolean mySpin =  (nativeTransport && !carLife) ? true:false;
    VARTRACE(carPlay);
    VARTRACE(wirelessCarplay);
    VARTRACE(isCPWActive);
    VARTRACE(nativeTransport);
    VARTRACE(carLife);
    VARTRACE(mySpin);

    //standard IAP2 features
    m_HandleMap.ResetElapsedTime(m_MountPoint, iapInitElapsed);
    m_HandleMap.ResetElapsedTime(m_MountPoint, pbNotifications);
    m_HandleMap.SetOption(m_MountPoint, hasRemoteControlOption, true);
    m_HandleMap.SetOption(m_MountPoint, hasPlayPauseOption, true);
    m_HandleMap.SetOption(m_MountPoint, hasExtPlayStatusOption, true);
    m_HandleMap.SetOption(m_MountPoint, hasAlbumArtOption, true);

    m_HandleMap.LockIAP2(m_MountPoint); //start critical section
    iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(m_MountPoint);
    iAP2InitParam_t * iap2InitParameter = (iAP2InitParam_t *)m_HandleMap.GetIAP2InitParameter(m_MountPoint);
    if(!iap2Device || !iap2InitParameter) {
        ETG_TRACE_ERR(("!iap2Device || !iap2InitParameter"));
    } else {

        tDeviceInfo deviceInfo;
        m_HandleMap.GetDeviceInfo(m_MountPoint, deviceInfo);

        // Power source update (for USB connection)
        if(DCT_USB == deviceInfo.connectionType)
        {
            //SUZUKI-16626
            //PowerSourceUpdate must be send after the authentication certificate was granted. Otherwise, the iPhone would ignore all iAP traffic.
            iAP2PowerSourceUpdateParameter powerSourceUpdateParameter;
            memset(&powerSourceUpdateParameter, 0, sizeof(iAP2PowerSourceUpdateParameter));
            powerSourceUpdateParameter.iAP2AvailableCurrentForDevice = new U16;
            if(powerSourceUpdateParameter.iAP2AvailableCurrentForDevice)
            {
                tPath hubVendorID = {0};
                m_HandleMap.GetHubVendorID(hubVendorID, m_MountPoint);
                tPath hubProductID = {0};
                m_HandleMap.GetHubProductID(hubProductID, m_MountPoint);
                const int portNumber = m_HandleMap.GetOTGPortNumber(m_MountPoint);

                *(powerSourceUpdateParameter.iAP2AvailableCurrentForDevice) = LocalSPM::GetDataProvider().GetAvailableCurrentForDevice(hubVendorID, hubProductID, portNumber);
                powerSourceUpdateParameter.iAP2AvailableCurrentForDevice_count++;
            }
            powerSourceUpdateParameter.iAP2DeviceBatteryShouldChargeIfPowerIsPresent = new U8;
            if(powerSourceUpdateParameter.iAP2DeviceBatteryShouldChargeIfPowerIsPresent)
            {
                *(powerSourceUpdateParameter.iAP2DeviceBatteryShouldChargeIfPowerIsPresent) = 1; //ON
                powerSourceUpdateParameter.iAP2DeviceBatteryShouldChargeIfPowerIsPresent_count++;
            }
            res = iAP2PowerSourceUpdate(iap2Device, &powerSourceUpdateParameter);
            ETG_TRACE_USR3(("iAP2PowerSourceUpdate returned %d", res));
            iAP2FreeiAP2PowerSourceUpdateParameter(&powerSourceUpdateParameter);
        }

        // Start Power updates
        if(DCT_USB == deviceInfo.connectionType || DCT_WIFI == deviceInfo.connectionType)
        {
            iAP2StartPowerUpdatesParameter startPowerUpdatesParameter;
            memset(&startPowerUpdatesParameter, 0, sizeof(iAP2StartPowerUpdatesParameter));

            if(DCT_USB == deviceInfo.connectionType)
            {
                startPowerUpdatesParameter.iAP2MaximumcurrentDrawnFromAccessory_count++;
                startPowerUpdatesParameter.iAP2DeviceBatteryWillChargeIfPowerIsPresent_count++;
                startPowerUpdatesParameter.iAP2BatteryChargingState_count++;
                startPowerUpdatesParameter.iAP2IsExternalChargerConnected_count++;
            }

            // BatteryChargeLevel is expected for both USB connection and CPW
            startPowerUpdatesParameter.iAP2BatteryChargeLevel_count++;

            res = iAP2StartPowerUpdates(iap2Device, &startPowerUpdatesParameter);
            ETG_TRACE_USR3(("iAP2StartPowerUpdates returned %d", res));

            iAP2FreeiAP2StartPowerUpdatesParameter(&startPowerUpdatesParameter);
        }

        if((!carPlay && !wirelessCarplay && !mySpin && !carLife)|| LocalSPM::GetDataProvider().iPodControlIAP2CarPlayModeEnabled()) {
            if(LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp() && deviceInfo.connectionType != DCT_BLUETOOTH){
                //start media library information
                iAP2StartMediaLibraryInformationParameter mediaLibraryInformationParameter;
                memset(&mediaLibraryInformationParameter, 0, sizeof(iAP2StartMediaLibraryInformationParameter));
                res = iAP2StartMediaLibraryInformation(iap2Device, &mediaLibraryInformationParameter);
                ETG_TRACE_USR3(("iAP2StartMediaLibraryInformation returned %d", res));
                if(res != IAP2_OK) {
                    UpdateIpodCommunicationError(res);
                }
                //iAP2FreeiAP2StartMediaLibraryInformationParameter(&mediaLibraryInformationParameter); //no parameters no free
            }
            else if(!LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp()){
                //start media library information
                iAP2StartMediaLibraryInformationParameter mediaLibraryInformationParameter;
                memset(&mediaLibraryInformationParameter, 0, sizeof(iAP2StartMediaLibraryInformationParameter));
                res = iAP2StartMediaLibraryInformation(iap2Device, &mediaLibraryInformationParameter);
                ETG_TRACE_USR3(("iAP2StartMediaLibraryInformation returned %d", res));
                if(res != IAP2_OK) {
                    UpdateIpodCommunicationError(res);
                }
                //iAP2FreeiAP2StartMediaLibraryInformationParameter(&mediaLibraryInformationParameter); //no parameters no free
            }
        }
        //Start list Updates
        if((wirelessCarplay || carPlay) && !mySpin && !carLife && LocalSPM::GetDataProvider().iPodControlIAP2ListUpdateEnabled()) {

            iAP2StartListUpdatesParameter listUpdateParameter;
            memset(&listUpdateParameter, 0, sizeof(iAP2StartListUpdatesParameter));

            listUpdateParameter.iAP2RecentsListMax_count++;
            listUpdateParameter.iAP2RecentsListMax = new U16;
            *(listUpdateParameter.iAP2RecentsListMax) = 0;

            listUpdateParameter.iAP2RecentListCombine_count++;
            listUpdateParameter.iAP2RecentListCombine = new U8;
            *(listUpdateParameter.iAP2RecentListCombine) = 1;


            listUpdateParameter.iAP2RecentListProperties = new iAP2RecentsListProperties;
            if(listUpdateParameter.iAP2RecentListProperties != NULL){
                memset(listUpdateParameter.iAP2RecentListProperties, 0, sizeof(iAP2RecentsListProperties));
                ETG_TRACE_USR3(("Entrerd"));
                listUpdateParameter.iAP2RecentListProperties_count++;

                listUpdateParameter.iAP2RecentListProperties->iAP2AddressBookID_count++;
                listUpdateParameter.iAP2RecentListProperties->iAP2DisplayName_count++;
                listUpdateParameter.iAP2RecentListProperties->iAP2Duration_count++;
                listUpdateParameter.iAP2RecentListProperties->iAP2Index_count++;
                listUpdateParameter.iAP2RecentListProperties->iAP2Label_count++;
                listUpdateParameter.iAP2RecentListProperties->iAP2Occurrences_count++;
                listUpdateParameter.iAP2RecentListProperties->iAP2RemoteID_count++;
                listUpdateParameter.iAP2RecentListProperties->iAP2Service_count++;
                listUpdateParameter.iAP2RecentListProperties->iAP2Type_count++;
                listUpdateParameter.iAP2RecentListProperties->iAP2UnixTimestamp_count++;
            }

            res = iAP2StartListUpdates(iap2Device, &listUpdateParameter);
            ETG_TRACE_USR3(("iAP2StartListUpdates returned %d", res));
            if(res != IAP2_OK) {
                UpdateIpodCommunicationError(res);
            }
            iAP2FreeiAP2StartListUpdatesParameter(&listUpdateParameter);

        }

        if(!mySpin && !carLife)
        {
            //start now playing updates
            iAP2StartNowPlayingUpdatesParameter nowPlayingUpdatesParameter;
            memset(&nowPlayingUpdatesParameter, 0, sizeof(iAP2StartNowPlayingUpdatesParameter));

            /* set MediaItemAttributes properties which we want to receive */
            nowPlayingUpdatesParameter.iAP2MediaItemAttributes = new iAP2MediaItemAttributes;
            if(nowPlayingUpdatesParameter.iAP2MediaItemAttributes != NULL) {
                memset(nowPlayingUpdatesParameter.iAP2MediaItemAttributes, 0, sizeof(iAP2MediaItemAttributes));
                nowPlayingUpdatesParameter.iAP2MediaItemAttributes_count++;
                nowPlayingUpdatesParameter.iAP2MediaItemAttributes->iAP2MediaItemPersistentIdentifier_count++;
                nowPlayingUpdatesParameter.iAP2MediaItemAttributes->iAP2MediaItemTitle_count++;
                nowPlayingUpdatesParameter.iAP2MediaItemAttributes->iAP2MediaItemPlaybackDurationInMilliseconds_count++;
                nowPlayingUpdatesParameter.iAP2MediaItemAttributes->iAP2MediaItemAlbumTitle_count++;
                nowPlayingUpdatesParameter.iAP2MediaItemAttributes->iAP2MediaItemAlbumTrackNumber_count++;
                nowPlayingUpdatesParameter.iAP2MediaItemAttributes->iAP2MediaItemAlbumTrackCount_count++;
                nowPlayingUpdatesParameter.iAP2MediaItemAttributes->iAP2MediaItemAlbumDiscNumber_count++;
                nowPlayingUpdatesParameter.iAP2MediaItemAttributes->iAP2MediaItemAlbumDiscCount_count++;
                nowPlayingUpdatesParameter.iAP2MediaItemAttributes->iAP2MediaItemArtist_count++;
                nowPlayingUpdatesParameter.iAP2MediaItemAttributes->iAP2MediaItemGenre_count++;
                nowPlayingUpdatesParameter.iAP2MediaItemAttributes->iAP2MediaItemComposer_count++;
                nowPlayingUpdatesParameter.iAP2MediaItemAttributes->iAP2MediaItemArtworkFileTransferIdentifier_count++; //artworkSupport
                //nowPlayingUpdatesParameter.iAP2MediaItemAttributes->iAP2MediaItemChapterCount_count++;
            }

            if(LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp() && deviceInfo.connectionType != DCT_BLUETOOTH){
                /* enable information about shuffle mode and repeat mode */
                nowPlayingUpdatesParameter.iAP2PlaybackAttributes = new iAP2StartNowPlayingPlaybackAttributes;
                if(nowPlayingUpdatesParameter.iAP2PlaybackAttributes != NULL) {
                    memset(nowPlayingUpdatesParameter.iAP2PlaybackAttributes, 0, sizeof(iAP2StartNowPlayingPlaybackAttributes));
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackAppName_count++; //mandatory
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackStatus_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackElapsedTimeInMilliseconds_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackMediaLibraryUniqueIdentifier_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackRepeatMode_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackShuffleMode_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackQueueCount_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackQueueIndex_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackQueueChapterIndex_count++;
                    if(LocalSPM::GetDataProvider().iPodControlIAP2iTunesRadioEnabled()) {
                        nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PBiTunesRadioAd_count++;
                        nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PBiTunesStationMediaPlaylistPersistentID_count++;
                        nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PBiTunesStationName_count++;
                    }
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackAppBundleID_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackQueueListAvail_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackQueueListTransferID_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackSpeed_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2SetElapsedTimeAvailable_count++;
                }
                res = iAP2StartNowPlayingUpdates(iap2Device, &nowPlayingUpdatesParameter);
                ETG_TRACE_USR3(("iAP2StartNowPlayingUpdates returned %d", res));
                if(res != IAP2_OK) {
                    UpdateIpodCommunicationError(res);
                }
                iAP2FreeiAP2StartNowPlayingUpdatesParameter(&nowPlayingUpdatesParameter);
            }
            else if(!LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp()){
                /* enable information about shuffle mode and repeat mode */
                nowPlayingUpdatesParameter.iAP2PlaybackAttributes = new iAP2StartNowPlayingPlaybackAttributes;
                if(nowPlayingUpdatesParameter.iAP2PlaybackAttributes != NULL) {
                    memset(nowPlayingUpdatesParameter.iAP2PlaybackAttributes, 0, sizeof(iAP2StartNowPlayingPlaybackAttributes));
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackAppName_count++; //mandatory
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackStatus_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackElapsedTimeInMilliseconds_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackMediaLibraryUniqueIdentifier_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackRepeatMode_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackShuffleMode_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackQueueCount_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackQueueIndex_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackQueueChapterIndex_count++;
                    if(LocalSPM::GetDataProvider().iPodControlIAP2iTunesRadioEnabled()) {
                        nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PBiTunesRadioAd_count++;
                        nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PBiTunesStationMediaPlaylistPersistentID_count++;
                        nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PBiTunesStationName_count++;
                    }
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackAppBundleID_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackQueueListAvail_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackQueueListTransferID_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2PlaybackSpeed_count++;
                    nowPlayingUpdatesParameter.iAP2PlaybackAttributes->iAP2SetElapsedTimeAvailable_count++;
                }
                res = iAP2StartNowPlayingUpdates(iap2Device, &nowPlayingUpdatesParameter);
                ETG_TRACE_USR3(("iAP2StartNowPlayingUpdates returned %d", res));
                if(res != IAP2_OK) {
                    UpdateIpodCommunicationError(res);
                }
                iAP2FreeiAP2StartNowPlayingUpdatesParameter(&nowPlayingUpdatesParameter);
            }

            if(!wirelessCarplay && !isCPWActive) // Disable BluetoothConnectionUpdates for CarPlay Wireless
            {
                if(LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp() && deviceInfo.connectionType != DCT_BLUETOOTH){
                    if(LocalSPM::GetDataProvider().iPodControlIAP2BTConnectionUpdatesEnabled()) {
                        //start BT updates
                        iAP2StartBluetoothConnectionUpdatesParameter startBluetoothConnectionUpdatesParameter;
                        memset(&startBluetoothConnectionUpdatesParameter, 0, sizeof(startBluetoothConnectionUpdatesParameter));
                        startBluetoothConnectionUpdatesParameter.iAP2BluetoothTransportComponentIdentifier = new U16;
                        if(startBluetoothConnectionUpdatesParameter.iAP2BluetoothTransportComponentIdentifier) {
                            *(startBluetoothConnectionUpdatesParameter.iAP2BluetoothTransportComponentIdentifier) = 0;
                            startBluetoothConnectionUpdatesParameter.iAP2BluetoothTransportComponentIdentifier_count++;
                            res = iAP2StartBluetoothConnectionUpdates(iap2Device, &startBluetoothConnectionUpdatesParameter);
                            ETG_TRACE_USR3(("iAP2StartBluetoothConnectionUpdates returned %d", res));
                            if(res != IAP2_OK) {
                                UpdateIpodCommunicationError(res);
                            }
                            iAP2FreeiAP2StartBluetoothConnectionUpdatesParameter(&startBluetoothConnectionUpdatesParameter);
                        }
                    }
                }
                else if(!LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp()){
                    if(LocalSPM::GetDataProvider().iPodControlIAP2BTConnectionUpdatesEnabled()) {
                        //start BT updates
                        iAP2StartBluetoothConnectionUpdatesParameter startBluetoothConnectionUpdatesParameter;
                        memset(&startBluetoothConnectionUpdatesParameter, 0, sizeof(startBluetoothConnectionUpdatesParameter));
                        startBluetoothConnectionUpdatesParameter.iAP2BluetoothTransportComponentIdentifier = new U16;
                        if(startBluetoothConnectionUpdatesParameter.iAP2BluetoothTransportComponentIdentifier) {
                            *(startBluetoothConnectionUpdatesParameter.iAP2BluetoothTransportComponentIdentifier) = 0;
                            startBluetoothConnectionUpdatesParameter.iAP2BluetoothTransportComponentIdentifier_count++;
                            res = iAP2StartBluetoothConnectionUpdates(iap2Device, &startBluetoothConnectionUpdatesParameter);
                            ETG_TRACE_USR3(("iAP2StartBluetoothConnectionUpdates returned %d", res));
                            if(res != IAP2_OK) {
                                UpdateIpodCommunicationError(res);
                            }
                            iAP2FreeiAP2StartBluetoothConnectionUpdatesParameter(&startBluetoothConnectionUpdatesParameter);
                        }
                    }
                }
            }
        }

        if((wirelessCarplay || hostMode) && !mySpin && !carLife && LocalSPM::GetDataProvider().iPodControlIAP2CallStateUpdateEnabled()) {
            //start telephone call state updates
#ifdef IPODCONTROL_IAP2_PF_R22
            iAP2StartCallStateUpdatesParameter startCallStateUpdatesParameter;
            memset(&startCallStateUpdatesParameter, 0, sizeof(iAP2StartCallStateUpdatesParameter));
            startCallStateUpdatesParameter.iAP2RemoteID_count++;
            startCallStateUpdatesParameter.iAP2DisplayName_count++;
            startCallStateUpdatesParameter.iAP2Status_count++;
            startCallStateUpdatesParameter.iAP2Direction_count++;
            startCallStateUpdatesParameter.iAP2CallUUID_count++;
            startCallStateUpdatesParameter.iAP2AddressBookID_count++;
            startCallStateUpdatesParameter.iAP2Label_count++;
            startCallStateUpdatesParameter.iAP2Service_count++;
            startCallStateUpdatesParameter.iAP2IsConferenced_count++;
            startCallStateUpdatesParameter.iAP2ConferenceGroup_count++;
            startCallStateUpdatesParameter.iAP2DisconnectReason_count++;
            startCallStateUpdatesParameter.iAP2StartTimestamp_count++;
            res = iAP2StartCallStateUpdates(iap2Device, &startCallStateUpdatesParameter);
            ETG_TRACE_USR3(("iAP2StartCallStateUpdates returned %d", res));
            if(res != IAP2_OK) {
                UpdateIpodCommunicationError(res);
            }
            iAP2FreeiAP2StartCallStateUpdatesParameter(&startCallStateUpdatesParameter);
#else
            iAP2StartTelephonyCallStateInformationParameter startTelephonyCallStateInformationParameter;
            memset(&startTelephonyCallStateInformationParameter, 0, sizeof(iAP2StartTelephonyCallStateInformationParameter));
            //startTelephonyCallStateInformationParameter.iAP2CallStatevCardFileTransferIdentifier_count++; //deprecated
            res = iAP2StartTelephonyCallStateInformation(iap2Device, &startTelephonyCallStateInformationParameter);
            ETG_TRACE_USR3(("iAP2StartTelephonyCallStateInformation returned %d", res));
            if(res != IAP2_OK) {
                UpdateIpodCommunicationError(res);
            }
            iAP2FreeiAP2StartTelephonyCallStateInformationParameter(&startTelephonyCallStateInformationParameter);
#endif
        }

        if((wirelessCarplay || hostMode) && !mySpin && !carLife && LocalSPM::GetDataProvider().iPodControlIAP2CommunicationsUpdateEnabled()) {
            //start telephone updates
#ifdef IPODCONTROL_IAP2_PF_R22
            iAP2StartCommunicationsUpdatesParameter startCommunicationsUpdatesParameter;
            memset(&startCommunicationsUpdatesParameter, 0, sizeof(iAP2StartCommunicationsUpdatesParameter));
            startCommunicationsUpdatesParameter.iAP2SignalStrength_count++;
            startCommunicationsUpdatesParameter.iAP2RegistrationStatus_count++;
            startCommunicationsUpdatesParameter.iAP2AirplaneModeStatus_count++;
            startCommunicationsUpdatesParameter.iAP2CarrierName_count++;
            startCommunicationsUpdatesParameter.iAP2CellularSupported_count++;
            startCommunicationsUpdatesParameter.iAP2TelephonyEnabled_count++;
            startCommunicationsUpdatesParameter.iAP2FaceTimeAudioEnabled_count++;
            startCommunicationsUpdatesParameter.iAP2FaceTimeVideoEnabled_count++;
            startCommunicationsUpdatesParameter.iAP2MuteStatus_count++;
            startCommunicationsUpdatesParameter.iAP2CurrentCallCount_count++;
            startCommunicationsUpdatesParameter.iAP2NewVoiceMailCount_count++;
            startCommunicationsUpdatesParameter.iAP2InitiateCallAvailable_count++;
            startCommunicationsUpdatesParameter.iAP2EndAndAcceptAvailable_count++;
            startCommunicationsUpdatesParameter.iAP2HoldAndAcceptAvailable_count++;
            startCommunicationsUpdatesParameter.iAP2SwapAvailable_count++;
            startCommunicationsUpdatesParameter.iAP2MergeAvailable_count++;
            startCommunicationsUpdatesParameter.iAP2HoldAvailable_count++;
            res = iAP2StartCommunicationsUpdates(iap2Device, &startCommunicationsUpdatesParameter);
            ETG_TRACE_USR3(("iAP2StartCommunicationsUpdates returned %d", res));
            if(res != IAP2_OK) {
                UpdateIpodCommunicationError(res);
            }
            iAP2FreeiAP2StartCommunicationsUpdatesParameter(&startCommunicationsUpdatesParameter);
#else
            iAP2StartTelephonyUpdatesParameter startTelephonyUpdatesParameter;
            memset(&startTelephonyUpdatesParameter, 0, sizeof(iAP2StartTelephonyUpdatesParameter));
            startTelephonyUpdatesParameter.iAP2TelephonySignalStrength_count++;
            startTelephonyUpdatesParameter.iAP2TelephonyRegistrationStatus_count++;
            startTelephonyUpdatesParameter.iAP2TelephonyAirplaneModeStatus_count++;
            startTelephonyUpdatesParameter.iAP2TelephonyMobileOperator_count++;
            res = iAP2StartTelephonyUpdates(iap2Device, &startTelephonyUpdatesParameter);
            ETG_TRACE_USR3(("iAP2StartTelephonyUpdates returned %d", res));
            if(res != IAP2_OK) {
                UpdateIpodCommunicationError(res);
            }
            iAP2FreeiAP2StartTelephonyUpdatesParameter(&startTelephonyUpdatesParameter);
#endif
        }

        if((!carPlay && !wirelessCarplay && !mySpin && !carLife) || LocalSPM::GetDataProvider().iPodControlIAP2CarPlayModeEnabled()) {
            if(LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp() && deviceInfo.connectionType != DCT_BLUETOOTH){
                //start HID
                iAP2StartHIDParameter startHIDParameter;
                memset(&startHIDParameter, 0, sizeof(startHIDParameter) );
                startHIDParameter.iAP2HIDComponentIdentifier = new U16[1];
                if(startHIDParameter.iAP2HIDComponentIdentifier != NULL) {
                    startHIDParameter.iAP2HIDComponentIdentifier[0] = IAP2_HID_COMPONENT_IDENTIFIER;
                    startHIDParameter.iAP2HIDComponentIdentifier_count++;
                }
                startHIDParameter.iAP2VendorIdentifier = new U16[1];
                if(startHIDParameter.iAP2VendorIdentifier != NULL) {
                    startHIDParameter.iAP2VendorIdentifier[0] = IAP2_APPLE_VENDOR_IDENTIFIER; //Apple vendor
                    startHIDParameter.iAP2VendorIdentifier_count++;
                }

            //get productId from Device table
            U16 productID = deviceInfo.productID;
            if(!productID) {
                //set another default than 0
                productID = IAP2_APPLE_PRODUCT_IDENTIFIER;
            }
            VARTRACE(productID);
            startHIDParameter.iAP2ProductIdentifier = new U16[1];
            if(startHIDParameter.iAP2ProductIdentifier != NULL) {
                startHIDParameter.iAP2ProductIdentifier[0] = productID; //Apple product
                startHIDParameter.iAP2ProductIdentifier_count++;
            }
            startHIDParameter.iAP2HIDReportDescriptor = new iAP2Blob[sizeof(iAP2Blob)];
            if(startHIDParameter.iAP2HIDReportDescriptor != NULL) {
                memset(startHIDParameter.iAP2HIDReportDescriptor, 0, sizeof(iAP2Blob) );
                startHIDParameter.iAP2HIDReportDescriptor_count++;

                const U8 * pHIDDescriptor = NULL;
                size_t size = 0;
                if(LocalSPM::GetDataProvider().iPodControlIAP2RepeatDisabled()) {
                    pHIDDescriptor = sHIDReportDescriptor_NoRepeat;
                    size = sizeof(sHIDReportDescriptor_NoRepeat);
                } else {
                    pHIDDescriptor = sHIDReportDescriptor;
                    size = sizeof(sHIDReportDescriptor);
                }
                startHIDParameter.iAP2HIDReportDescriptor[0].iAP2BlobData = new U8[size];
                if(startHIDParameter.iAP2HIDReportDescriptor[0].iAP2BlobData != NULL) {
                    memcpy(startHIDParameter.iAP2HIDReportDescriptor[0].iAP2BlobData, pHIDDescriptor, size);
                    startHIDParameter.iAP2HIDReportDescriptor[0].iAP2BlobLength = size;
                }
            }
            res = iAP2StartHID(iap2Device, &startHIDParameter);
            ETG_TRACE_USR3(("iAP2StartHID returned %d", res));
            if(res != IAP2_OK) {
                UpdateIpodCommunicationError(res);
            }
            iAP2FreeiAP2StartHIDParameter(&startHIDParameter);
            }
            else if(!LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp()){
                //start HID
                iAP2StartHIDParameter startHIDParameter;
                memset(&startHIDParameter, 0, sizeof(startHIDParameter) );
                startHIDParameter.iAP2HIDComponentIdentifier = new U16[1];
                if(startHIDParameter.iAP2HIDComponentIdentifier != NULL) {
                    startHIDParameter.iAP2HIDComponentIdentifier[0] = IAP2_HID_COMPONENT_IDENTIFIER;
                    startHIDParameter.iAP2HIDComponentIdentifier_count++;
                }
                startHIDParameter.iAP2VendorIdentifier = new U16[1];
                if(startHIDParameter.iAP2VendorIdentifier != NULL) {
                    startHIDParameter.iAP2VendorIdentifier[0] = IAP2_APPLE_VENDOR_IDENTIFIER; //Apple vendor
                    startHIDParameter.iAP2VendorIdentifier_count++;
                }

                //get productId from Device table
                U16 productID = deviceInfo.productID;
                if(!productID) {
                    //set another default than 0
                    productID = IAP2_APPLE_PRODUCT_IDENTIFIER;
                }
                VARTRACE(productID);
                startHIDParameter.iAP2ProductIdentifier = new U16[1];
                if(startHIDParameter.iAP2ProductIdentifier != NULL) {
                    startHIDParameter.iAP2ProductIdentifier[0] = productID; //Apple product
                    startHIDParameter.iAP2ProductIdentifier_count++;
                }
                startHIDParameter.iAP2HIDReportDescriptor = new iAP2Blob[sizeof(iAP2Blob)];
                if(startHIDParameter.iAP2HIDReportDescriptor != NULL) {
                    memset(startHIDParameter.iAP2HIDReportDescriptor, 0, sizeof(iAP2Blob) );
                    startHIDParameter.iAP2HIDReportDescriptor_count++;

                    const U8 * pHIDDescriptor = NULL;
                    size_t size = 0;
                    if(LocalSPM::GetDataProvider().iPodControlIAP2RepeatDisabled()) {
                        pHIDDescriptor = sHIDReportDescriptor_NoRepeat;
                        size = sizeof(sHIDReportDescriptor_NoRepeat);
                    } else {
                        pHIDDescriptor = sHIDReportDescriptor;
                        size = sizeof(sHIDReportDescriptor);
                    }
                    startHIDParameter.iAP2HIDReportDescriptor[0].iAP2BlobData = new U8[size];
                    if(startHIDParameter.iAP2HIDReportDescriptor[0].iAP2BlobData != NULL) {
                        memcpy(startHIDParameter.iAP2HIDReportDescriptor[0].iAP2BlobData, pHIDDescriptor, size);
                        startHIDParameter.iAP2HIDReportDescriptor[0].iAP2BlobLength = size;
                    }
                }
                res = iAP2StartHID(iap2Device, &startHIDParameter);
                ETG_TRACE_USR3(("iAP2StartHID returned %d", res));
                if(res != IAP2_OK) {
                    UpdateIpodCommunicationError(res);
                }
                iAP2FreeiAP2StartHIDParameter(&startHIDParameter);
            }
        }
    }
    m_HandleMap.UnlockIAP2(m_MountPoint); //end critical section
    m_HandleMap.TraceOptions(m_MountPoint);


    tDeviceName deviceName = {0};
    tFingerprint mediaLibraryUID = {0};
    m_HandleMap.GetDeviceName(deviceName, m_MountPoint);
    VARTRACE(deviceName);
    iAPGetMediaLibraryUID(m_MountPoint, mediaLibraryUID);
    VARTRACE(mediaLibraryUID);
    tConnectionState connectionState = m_HandleMap.GetConnectionState(m_MountPoint);
    VARTRACE(connectionState);

    //RTC-722759 Fix to avoid syncing with mediaLibraryInfo callback for CP & CPW
    const bool check_medialibraryUUID = (!carPlay && !wirelessCarplay && !mySpin && !carLife) || LocalSPM::GetDataProvider().iPodControlIAP2CarPlayModeEnabled();

    //sync with mediaLibraryInfo callback and HID class initialization
    int maxTime = LocalSPM::GetDataProvider().iPodControlIAP2InitCallbacksMS();
    while(maxTime > 0 && connectionState == CS_CONNECTED && (deviceName[0] == 0 || (check_medialibraryUUID && mediaLibraryUID[0] == 0)) ) {
        ETG_TRACE_USR3(("Syncing to IAP2 callbacks ..."));
        usleep(100000);
        maxTime -= 100;
        //updates values
        m_HandleMap.GetDeviceName(deviceName, m_MountPoint);
        iAPGetMediaLibraryUID(m_MountPoint, mediaLibraryUID);
        connectionState = m_HandleMap.GetConnectionState(m_MountPoint);
    }

    VARTRACE(deviceName);
    VARTRACE(mediaLibraryUID);
    VARTRACE(connectionState);

    tDiPOCaps diPOCaps = iAP2_GetDiPOCaps(m_MountPoint);
    //SUZUKI-15487
    if(connectionState != CS_CONNECTED &&
            (!LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp() && DIPO_CAP_CARPLAY_WIFI_FEASIBLE != diPOCaps)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    }
#endif
    return ret;
}


//**************************** callbacks **************************************
void iPodControlIAP::CBIAP1_USBDetach(const IPODCONTROL_ID_TYPE iPodID) {
    ENTRY_INTERNAL; //callback USB detach
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP1_USBDetach(iPodID);
}
#ifndef TARGET_BUILD_GEN3
void iPodControlIAP::CBIAP1_USBAttach(const S32 success,
        const IPODCONTROL_ID_TYPE iPodID) {
    ENTRY_INTERNAL; //callback USB attach
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP1_USBAttach(success, iPodID);
}
#else
void iPodControlIAP::CBIAP1_USBAttach(const S32 success, IPOD_CONNECTION_TYPE /*connection*/, const IPODCONTROL_ID_TYPE iPodID) {
    ENTRY_INTERNAL; //callback USB attach
        //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP1_USBAttach(success, iPodID);
}
#endif

void iPodControlIAP::CBIAP1_Notification(IPOD_NOTIFY_TYPE type,
        IPOD_NOTIFY_STATUS status, const IPODCONTROL_ID_TYPE iPodID) {
    ENTRY_INTERNAL; //callback event notification

    switch (type) {
    case IPOD_EVT_FLOW_CTRL:
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_EVT_FLOW_CTRL %u", iPodID, status.waitMs));
        break;
    case IPOD_EVT_RADIO_TAG_STATUS:
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_EVT_RADIO_TAG_STATUS %d", iPodID, status.notifyStatus));
        break;
    case IPOD_EVT_CAMERA_STATUS:
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_EVT_CAMERA_STATUS %d", iPodID, status.notifyStatus));
        break;
    case IPOD_EVT_CHARGING:
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_EVT_CHARGING %d", iPodID, status.availableCurrent));
        break;
    case IPOD_EVT_DB_CHANGED:
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_EVT_DB_CHANGED %d", iPodID, status.notifyStatus));
        break;
    case IPOD_EVT_NOW_FOCUS_APP:
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_EVT_NOW_FOCUS_APP '%s'", iPodID, status.focusApp ? (char*)status.focusApp : "<null>"));
        break;
    case IPOD_EVT_SESSION:
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_EVT_SESSION %d", iPodID, status.sessionId));
        break;
    case IPOD_EVT_CMD_COMPLETE:
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_EVT_CMD_COMPLETE", iPodID));
        break;
    case IPOD_EVT_IPOD_OUT:
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_EVT_IPOD_OUT %d", iPodID, status.notifyStatus));
        break;
    case IPOD_EVT_BT_STATUS:
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_EVT_BT_STATUS", iPodID));
        break;
    case IPOD_EVT_APP_DISPLAY_NAME:
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_EVT_APP_DISPLAY_NAME '%s'", iPodID, status.focusApp ? (char*)status.focusApp : "<null>"));
        break;
    case IPOD_EVT_ASSIST_TOUCH:
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_EVT_ASSIST_TOUCH %d", iPodID, status.notifyStatus));
        break;
    default:
        ETG_TRACE_ERR(("CALLBACK[%d] UNKNOWN IPOD_NOTIFY_TYPE %u", iPodID, (U32)type));
        break;
    }

    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP1_Notification(type, status, iPodID);
}

#ifdef TARGET_BUILD_GEN3
void iPodControlIAP::CBIAP1_RemoteEventNotification(IPOD_STATE_INFO_TYPE eventNum, IPOD_REMOTE_EVENT_NOTIFY_STATUS eventData, const U32 iPodID)
{
    ENTRY_INTERNAL; //callback event notification

    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP1_RemoteEventNotification(eventNum, eventData, iPodID);
}
#endif

void iPodControlIAP::CBIAP1_NotifyStatus(IPOD_CHANGED_PLAY_STATUS status,
        U64 param, const IPODCONTROL_ID_TYPE iPodID) {
    ENTRY_INTERNAL; //callback play status change notification
    //VARTRACE((int)status);
    //VARTRACE((int)param);
    //VARTRACE(iPodID);

    tU32 param32 = (tU32) param;

    switch (status) {
    case IPOD_STATUS_PLAYBACK_STOPPED: /*!< Status of playback stopped */
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_STATUS_PLAYBACK_STOPPED %u", iPodID, param32));
        break;
    case IPOD_STATUS_TRACK_CHANGED: /*!< Status of track index. Currentry version of spec is Track index. */
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_STATUS_TRACK_CHANGED %u", iPodID, param32));
        break;
    case IPOD_STATUS_FWD_SEEK_STOP: /*!< Status of Fastforward seek stop */
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_STATUS_FWD_SEEK_STOP %u", iPodID, param32));
        break;
    case IPOD_STATUS_BWD_SEEK_STOP: /*!< Status of FastBackward seek stop */
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_STATUS_BWD_SEEK_STOP %u", iPodID, param32));
        break;
    case IPOD_STATUS_TRACK_POSITION: /*!< Status of track position(ms)  */
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_STATUS_TRACK_POSITION %02d:%02d.%03d", iPodID, (tS32)param/60000, (tS32)((param/1000)%60), (tS32)(param%1000)));
        break;
    case IPOD_STATUS_CHAPTER_CHANGED: /*!< Status of chapter index.Currentry version of spec is Chapter index*/
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_STATUS_CHAPTER_CHANGED %u", iPodID, param32));
        break;
    case IPOD_STATUS_PLAYBACK_EXTENDED: /*!< Status of playback(e.g. stopped,playing,paused etc) */
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_STATUS_PLAYBACK_EXTENDED %u", iPodID, param32));
        break;
    case IPOD_STATUS_TRACK_TIME_OFFSET: /*!< Status of track time offset(s) */
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_STATUS_TRACK_TIME_OFFSET %u", iPodID, param32));
        break;
    case IPOD_STATUS_CHAPTER_MS_OFFSET: /*!< Status of chapter time offset(ms) */
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_STATUS_CHAPTER_MS_OFFSET %u", iPodID, param32));
        break;
    case IPOD_STATUS_CHAPTER_SEC_OFFSET: /*!< Status of chapter time offset(s) */
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_STATUS_CHAPTER_SEC_OFFSET %u", iPodID, param32));
        break;
    case IPOD_STATUS_TRACK_UID: /*!< Status of track unique identifier */
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_STATUS_TRACK_UID %u", iPodID, param32));
        break;
    case IPOD_STATUS_TRACK_PLAYBACK_MODE: /*!< Status of track playback mode */
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_STATUS_TRACK_PLAYBACK_MODE %u", iPodID, param32));
        break;
    case IPOD_STATUS_TRACK_LYRICS_READY: /*!< status of lyrics for the currently playing track are available for download */
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_STATUS_TRACK_LYRICS_READY %u", iPodID, param32));
        break;
    case IPOD_STATUS_TRACK_CAPABILITIES_CHANGED: /*!< Status of track capabilities changed */
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_STATUS_TRACK_CAPABILITIES_CHANGED %u", iPodID, param32));
        break;
    case IPOD_STATUS_PLAYBACK_CONTENT_CHANGED: /*!< New number of tracks in playlist */
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_STATUS_PLAYBACK_CONTENT_CHANGED %u", iPodID, param32));
        break;
    default:
        ETG_TRACE_USR3(("CALLBACK[%d] UNKNONW IPOD_STATUS %u", iPodID, (tU32)status));
        break;
    }

    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP1_NotifyStatus(status, param, iPodID);
}

void iPodControlIAP::CBIAP1_NotifyStateChange(IPOD_STATE_CHANGE stateChange,
        const IPODCONTROL_ID_TYPE iPodID) {
    ENTRY_INTERNAL; //callback power status change notification
    VARTRACE((int)stateChange);
    VARTRACE(iPodID);

    switch (stateChange) {
    case IPOD_STATE_NO_STATE_CHANGE: /*!< No state change.                                                     */
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_STATE_NO_STATE_CHANGE", iPodID));
        break;
    case IPOD_STATE_GOING_TO_DEEP_SLEEP: /*!< Accessory power going to Deep Sleep state (no power).                */
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_STATE_GOING_TO_DEEP_SLEEP", iPodID));
        break;
    case IPOD_STATE_GOING_TO_HIBERNATE: /*!< Accessory power going to Hibernate state (no power).                 */
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_STATE_GOING_TO_HIBERNATE", iPodID));
        break;
    case IPOD_STATE_GOING_TO_LIGHT_SLEEP: /*!< Accessory power going to Light Sleep state (less than 5 mA current). */
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_STATE_GOING_TO_LIGHT_SLEEP", iPodID));
        break;
    case IPOD_STATE_GOING_TO_POWER_ON: /*!< Accessory power going to the Power On state.                         */
        ETG_TRACE_USR3(("CALLBACK[%d] IPOD_STATE_GOING_TO_POWER_ON", iPodID));
        break;
    default:
        ETG_TRACE_ERR(("CALLBACK[%d] UNKNOWN IPOD_STATE", iPodID));
        break;
    }

    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP1_NotifyStateChange(stateChange, iPodID);
}

void iPodControlIAP::CBIAP1_NewiPodTrackInfo(U32 uNewSampleRate,
        S32 sNewSoundCheckValue, S32 sNewTrackVolAdjustment,
        const IPODCONTROL_ID_TYPE iPodID) {
    ENTRY_INTERNAL; //callback new audio track info
    ETG_TRACE_USR3(("iPodControlIAP::CBIAP1_NewiPodTrackInfo(%d) samplerate=%u, soundvalue=%d, volumeadjust=%d", iPodID, uNewSampleRate, sNewSoundCheckValue, sNewTrackVolAdjustment));

    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP1_NewiPodTrackInfo(uNewSampleRate, iPodID);

    //return Ack as soon as possible (500ms max)
    iPodAccAckDevice(IPOD_ACC_ACK_STATUS_SUCCESS, iPodID);
}

S32 iPodControlIAP::CBIAP1_OpenDataSession(U8 protocolIndex, U16 sessionId,
        const IPODCONTROL_ID_TYPE iPodID) {
    ENTRY_INTERNAL; //callback opened session to app info
    ETG_TRACE_USR3(("iPodControlIAP::CBIAP1_OpenDataSession(%d) protocolIndex=%d, sessionId=%d", iPodID, (int)protocolIndex, (int)sessionId));

    //forward to iPodControl class
    return LocalSPM::GetIPODControl().OnCBIAP1_OpenDataSession(protocolIndex,
            sessionId, iPodID);
}

void iPodControlIAP::CBIAP1_CloseDataSession(U16 sessionId,
        const IPODCONTROL_ID_TYPE iPodID) {
    ENTRY_INTERNAL; //callback closed session to app
    ETG_TRACE_USR3(("iPodControlIAP::CBIAP1_CloseDataSession(%d) sessionId=%d", iPodID, (int)sessionId));

    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP1_CloseDataSession(sessionId, iPodID);
}

S32 iPodControlIAP::CBIAP1_DataTransfer(U16 sessionId, U8 *data, U16 length,
        const IPODCONTROL_ID_TYPE iPodID) {
    ENTRY_INTERNAL; //callback app sent data
    ETG_TRACE_USR3(("iPodControlIAP::CBIAP1_DataTransfer(%d) sessionId=%d, datalength=%d", iPodID, (int)sessionId, (int)length));

    //forward to iPodControl class
    return LocalSPM::GetIPODControl().OnCBIAP1_DataTransfer(sessionId, data, length,
            iPodID);
}

void iPodControlIAP::CBIAP1_RetrieveCategorizedDBRecord(U32 index, U8* str IPODCONTROL_ID_END_PARAM) {
    ENTRY_INTERNAL; //callback DB Record
    ETG_TRACE_USR3(("DBRECORD #%04d '%s'", index, str));

    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP1_RetrieveCategorizedDBRecord(index, str IPODCONTROL_ID_END);
}

void iPodControlIAP::CBIAP1_TrackInfo(U64 index,
        IPOD_TRACK_INFORMATION_TYPE infoType,
        IPOD_TRACK_INFORMATION_DATA *infoData IPODCONTROL_ID_END_PARAM) {
    ENTRY_INTERNAL; //callback DB Record

    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP1_TrackInfo(index, infoType, infoData IPODCONTROL_ID_END);
}

void iPodControlIAP::CBIAP1_PlayingTrackInfo(IPOD_TRACK_INFO_TYPE infoType,
        const IPOD_TRACK_CAP_INFO_DATA *capData,
        const IPOD_TRACK_RELEASE_DATE_DATA *releaseData,
        const IPOD_TRACK_ARTWORK_COUNT_DATA *artworkCountData, U8* stringBuf IPODCONTROL_ID_END_PARAM) {
    ENTRY_INTERNAL; //callback indexed playing track info

    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP1_PlayingTrackInfo(infoType, capData,
            releaseData, artworkCountData, stringBuf IPODCONTROL_ID_END);
}

void iPodControlIAP::CBIAP1_ArtworkData(IPOD_ALBUM_ARTWORK *artworkData,
        const IPODCONTROL_ID_TYPE iPodID) {
    ENTRY_INTERNAL; //callback artwork data

    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP1_ArtworkData(artworkData, iPodID);
}

//IAP2 Callbacks
#ifdef IPODCONTROL_IAP2_PF_AVAIL
S32 iPodControlIAP::CBIAP2_AuthenticationFailed(iAP2Device_t* /*iap2Device*/, iAP2AuthenticationFailedParameter* /*authParameter*/, void* /*context*/)
{
    ENTRY;
    S32 rc = IAP2_OK;

    return rc;
}

S32 iPodControlIAP::CBIAP2_AuthenticationSucceeded(iAP2Device_t* /*iap2Device*/, iAP2AuthenticationSucceededParameter* /*authParameter*/, void* /*context*/)
{
    ENTRY;
    S32 rc = IAP2_OK;

    return rc;
}

S32 iPodControlIAP::CBIAP2_IdentificationAccepted(iAP2Device_t* iap2Device, iAP2IdentificationAcceptedParameter* idParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_IdentificationAccepted(iap2Device, idParameter, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_IdentificationRejected(iAP2Device_t* /*iap2Device*/, iAP2IdentificationRejectedParameter* idParameter, void* /*context*/)
{
    ENTRY;
    S32 rc = IAP2_OK;

    if(idParameter) {
        ETG_TRACE_USR3(("iAP2AccessoryFirmwareVersion_count %d", idParameter->iAP2AccessoryFirmwareVersion_count));
        ETG_TRACE_USR3(("iAP2AccessoryHardwareVersion_count %d", idParameter->iAP2AccessoryHardwareVersion_count));
        ETG_TRACE_USR3(("iAP2AccessoryManufacturer_count %d", idParameter->iAP2AccessoryManufacturer_count));
        ETG_TRACE_USR3(("iAP2AccessoryModelIdentifier_count %d", idParameter->iAP2AccessoryModelIdentifier_count));
        ETG_TRACE_USR3(("iAP2AccessoryName_count %d", idParameter->iAP2AccessoryName_count));
        ETG_TRACE_USR3(("iAP2AccessorySerialNumber_count %d", idParameter->iAP2AccessorySerialNumber_count));
        ETG_TRACE_USR3(("iAP2BluetoothTransportComponent_count %d", idParameter->iAP2BluetoothTransportComponent_count));
        ETG_TRACE_USR3(("iAP2CurrentLanguage_count %d", idParameter->iAP2CurrentLanguage_count));
        ETG_TRACE_USR3(("iAP2iAP2HIDComponent_count %d", idParameter->iAP2iAP2HIDComponent_count));
        ETG_TRACE_USR3(("iAP2LocationInformationComponent_count %d", idParameter->iAP2LocationInformationComponent_count));
        ETG_TRACE_USR3(("iAP2MaximumCurrentDrawnFromDevice_count %d", idParameter->iAP2MaximumCurrentDrawnFromDevice_count));
        ETG_TRACE_USR3(("iAP2MessagesRecievedfromDevice_count %d", idParameter->iAP2MessagesRecievedfromDevice_count));
        ETG_TRACE_USR3(("iAP2MessagesSentByAccessory_count %d", idParameter->iAP2MessagesSentByAccessory_count));
        ETG_TRACE_USR3(("iAP2PowerSourceType_count %d", idParameter->iAP2PowerSourceType_count));
        ETG_TRACE_USR3(("iAP2PreferredAppBundleSeedIdentifier_count %d", idParameter->iAP2PreferredAppBundleSeedIdentifier_count));
        ETG_TRACE_USR3(("iAP2SerialTransportComponent_count %d", idParameter->iAP2SerialTransportComponent_count));
        ETG_TRACE_USR3(("iAP2SupportedExternalAccessoryProtocol_count %d", idParameter->iAP2SupportedExternalAccessoryProtocol_count));
        ETG_TRACE_USR3(("iAP2SupportedLanguage_count %d", idParameter->iAP2SupportedLanguage_count));
        ETG_TRACE_USR3(("iAP2USBDeviceTransportComponent_count %d", idParameter->iAP2USBDeviceTransportComponent_count));
        ETG_TRACE_USR3(("iAP2USBHostHIDComponent_count %d", idParameter->iAP2USBHostHIDComponent_count));
        ETG_TRACE_USR3(("iAP2USBHostTransportComponent_count %d", idParameter->iAP2USBHostTransportComponent_count));
        ETG_TRACE_USR3(("iAP2VehicleInformationComponent_count %d", idParameter->iAP2VehicleInformationComponent_count));
        ETG_TRACE_USR3(("iAP2VehicleStatusComponent_count %d", idParameter->iAP2VehicleStatusComponent_count));
        ETG_TRACE_USR3(("iAP2WirelessCarPlayTransportComponent_count %d",idParameter->iAP2WirelessCarPlayTransportComponent_count));
    }
    return rc;
}

#ifdef IPODCONTROL_IAP2_PF_R26
#ifdef TARGET_BUILD
S32 iPodControlIAP::CBIAP2_RouteGuidanceUpdate(iAP2Device_t* iap2Device, iAP2RouteGuidanceUpdateParameter* RouteGuidanceUpdateParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_RouteGuidanceUpdate(iap2Device, RouteGuidanceUpdateParameter, context);
    return IAP2_OK;
}


S32 iPodControlIAP::CBIAP2_RouteGuidanceManeuverUpdate(iAP2Device_t* iap2Device, iAP2RouteGuidanceManeuverUpdateParameter* RouteGuidanceManeuverUpdateParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_RouteGuidanceManeuverUpdate(iap2Device, RouteGuidanceManeuverUpdateParameter, context);
    return IAP2_OK;
}
#endif
#endif
S32 iPodControlIAP::CBIAP2_PowerUpdate(iAP2Device_t* iap2Device, iAP2PowerUpdateParameter* powerupdateParameter, void* context)
{
    ENTRY_INTERNAL;

    LocalSPM::GetIPODControl().OnCBIAP2_PowerUpdate(iap2Device, powerupdateParameter, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_MediaLibraryInfo(iAP2Device_t* iap2Device, iAP2MediaLibraryInformationParameter* mediaLibraryInfoParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_MediaLibraryInfo(iap2Device, mediaLibraryInfoParameter, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_MediaLibraryUpdates(iAP2Device_t* iap2Device, iAP2MediaLibraryUpdateParameter* mediaLibraryUpdateParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_MediaLibraryUpdates(iap2Device, mediaLibraryUpdateParameter, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_NowPlayingUpdate(iAP2Device_t* iap2Device, iAP2NowPlayingUpdateParameter* nowPlayingUpdateParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_NowPlayingUpdate(iap2Device, nowPlayingUpdateParameter, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_USBDeviceModeAudioInformation(iAP2Device_t* iap2Device, iAP2USBDeviceModeAudioInformationParameter* usbDeviceModeAudioInformationParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_USBDeviceModeAudioInformation(iap2Device, usbDeviceModeAudioInformationParameter, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_StartExternalAccessoryProtocolSession(iAP2Device_t* iap2Device, iAP2StartExternalAccessoryProtocolSessionParameter* startExternalAccessoryProtocolSessionParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_StartExternalAccessoryProtocolSession(iap2Device, startExternalAccessoryProtocolSessionParameter, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_StopExternalAccessoryProtocolSession(iAP2Device_t* iap2Device, iAP2StopExternalAccessoryProtocolSessionParameter* stopExternalAccessoryProtocolSessionParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_StopExternalAccessoryProtocolSession(iap2Device, stopExternalAccessoryProtocolSessionParameter, context);
    return IAP2_OK;
}
//CARPLAY WIFI:
S32 iPodControlIAP::CBIAP2_DeviceUUIDUpdate(iAP2Device_t *iap2Device, iAP2DeviceUUIDUpdateParameter* deviceUUIDUpdateParameter, void* context)
{
    ENTRY;
    LocalSPM::GetIPODControl().OnCBIAP2_DeviceUUIDUpdate(iap2Device, deviceUUIDUpdateParameter, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_WirelessCarPlayUpdate(iAP2Device_t *iap2Device, iAP2WirelessCarPlayUpdateParameter* wirelessCarPlayUpdateParameter, void* context)
{
    ENTRY;
    LocalSPM::GetIPODControl().OnCBIAP2_WirelessCarPlayUpdate(iap2Device, wirelessCarPlayUpdateParameter, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_RequestAccessoryWiFiConfigurationInformation(iAP2Device_t* iap2Device, iAP2RequestAccessoryWiFiConfigurationInformationParameter *requestAccessoryWiFiConfigurationInformationParameter, void* context)
{
    ENTRY;
    LocalSPM::GetIPODControl().OnCBIAP2_RequestAccessoryWiFiConfigurationInformation(iap2Device, requestAccessoryWiFiConfigurationInformationParameter, context);
    return IAP2_OK;
}

#ifdef IPODCONTROL_IAP2_PF_R26
#ifdef TARGET_BUILD
S32 iPodControlIAP::CBIAP2_DeviceTransportIdentifierNotification(iAP2Device_t* iap2Device, iAP2DeviceTransportIdentifierNotificationParameter *deviceTransportIdentifierNotificationParameter, void* context)
{
    ENTRY;
    LocalSPM::GetIPODControl().OnCBIAP2_DeviceTransportIdentifierNotification(iap2Device, deviceTransportIdentifierNotificationParameter, context);
    return IAP2_OK;
}
#endif
#endif

S32 iPodControlIAP::CBIAP2_StartEANativeTransport(iAP2Device_t* iap2Device, U8 iAP2iOSAppIdentifier, U8 sinkEndpoint, U8 sourceEndpoint, void* context)
{
   ENTRY_INTERNAL;
   //forward to iPodControl class
   LocalSPM::GetIPODControl().OnCBIAP2_StartEANativeTransport(iap2Device, iAP2iOSAppIdentifier, sinkEndpoint, sourceEndpoint, context);
   return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_StopEANativeTransport(iAP2Device_t* iap2Device, U8 iAP2iOSAppIdentifier, U8 sinkEndpoint, U8 sourceEndpoint, void* context)
{
   ENTRY_INTERNAL;
   //forward to iPodControl class
   LocalSPM::GetIPODControl().OnCBIAP2_StopEANativeTransport(iap2Device, iAP2iOSAppIdentifier, sinkEndpoint, sourceEndpoint, context);
   return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_iOSAppDataReceived(iAP2Device_t* iap2Device, U8 iAP2iOSAppIdentifier, U8* iAP2iOSAppDataRxd, U16 iAP2iOSAppDataLength, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_iOSAppDataReceived(iap2Device, iAP2iOSAppIdentifier, iAP2iOSAppDataRxd, iAP2iOSAppDataLength, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_FileTransferSetup(iAP2Device_t* iap2Device, iAP2FileTransferSession_t* iAP2FileXferSession, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    //cancel file transfer on error, e.g. exceeding data size limit
    tResult ret = LocalSPM::GetIPODControl().OnCBIAP2_FileTransferSetup(iap2Device, iAP2FileXferSession, context);
    return (ret == MP_NO_ERROR) ? IAP2_OK : IAP2_CTL_ERROR;
}

S32 iPodControlIAP::CBIAP2_FileTransferDataRcvd(iAP2Device_t* iap2Device, iAP2FileTransferSession_t* iAP2FileXferSession, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_FileTransferDataRcvd(iap2Device, iAP2FileXferSession, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_FileTransferSuccess(iAP2Device_t* iap2Device, iAP2FileTransferSession_t* iAP2FileXferSession, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_FileTransferSuccess(iap2Device, iAP2FileXferSession, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_FileTransferFailure(iAP2Device_t* iap2Device, iAP2FileTransferSession_t* iAP2FileXferSession, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_FileTransferFailure(iap2Device, iAP2FileXferSession, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_FileTransferCancel(iAP2Device_t* iap2Device, iAP2FileTransferSession_t* iAP2FileXferSession, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_FileTransferCancel(iap2Device, iAP2FileXferSession, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_FileTransferPause(iAP2Device_t* iap2Device, iAP2FileTransferSession_t* iAP2FileXferSession, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_FileTransferPause(iap2Device, iAP2FileXferSession, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_FileTransferResume(iAP2Device_t* iap2Device, iAP2FileTransferSession_t* iAP2FileXferSession, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_FileTransferResume(iap2Device, iAP2FileXferSession, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_DeviceState(iAP2Device_t* iap2Device, iAP2DeviceState_t dState, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_DeviceState(iap2Device, dState, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_DeviceInformationUpdate(iAP2Device_t* iap2Device, iAP2DeviceInformationUpdateParameter *deviceInformationUpdateParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_DeviceInformationUpdate(iap2Device, deviceInformationUpdateParameter, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_DeviceLanguageUpdate(iAP2Device_t* iap2Device, iAP2DeviceLanguageUpdateParameter *deviceLanguageUpdateParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_DeviceLanguageUpdate(iap2Device, deviceLanguageUpdateParameter, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_DeviceTimeUpdate(iAP2Device_t* iap2Device, iAP2DeviceTimeUpdateParameter *deviceTimeUpdateParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_DeviceTimeUpdate(iap2Device, deviceTimeUpdateParameter, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_DeviceHIDReport(iAP2Device_t* /*iap2Device*/, iAP2DeviceHIDReportParameter* /*reportParameter*/, void* /*context*/)
{
    ENTRY;
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_StartLocationInformation(iAP2Device_t* iap2Device, iAP2StartLocationInformationParameter* startLocationInformationParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_StartLocationInformation(iap2Device, startLocationInformationParameter, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_StopLocationInformation(iAP2Device_t* iap2Device, iAP2StopLocationInformationParameter* stopLocationInformationParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_StopLocationInformation(iap2Device, stopLocationInformationParameter, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_GPRMCDataStatusValuesNotification(iAP2Device_t* iap2Device, iAP2GPRMCDataStatusValuesNotificationParameter* GPRMCDataStatusValuesNotificationParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_GPRMCDataStatusValuesNotification(iap2Device, GPRMCDataStatusValuesNotificationParameter, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_BluetoothConnectionUpdate(iAP2Device_t* iap2Device, iAP2BluetoothConnectionUpdateParameter* bluetoothConnectionUpdateParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_BluetoothConnectionUpdate(iap2Device, bluetoothConnectionUpdateParameter, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_StartVehicleStatusUpdates(iAP2Device_t* iap2Device, iAP2StartVehicleStatusUpdatesParameter* startVehicleStatusUpdatesParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_StartVehicleStatusUpdates(iap2Device, startVehicleStatusUpdatesParameter, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_StopVehicleStatusUpdates(iAP2Device_t* iap2Device, iAP2StopVehicleStatusUpdatesParameter* stopVehicleStatusUpdatesParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_StopVehicleStatusUpdates(iap2Device, stopVehicleStatusUpdatesParameter, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_ListUpdate(iAP2Device_t* iap2Device, iAP2ListUpdateParameter* listUpdateParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_ListUpdate(iap2Device, listUpdateParameter, context);
    return IAP2_OK;
}

#ifdef IPODCONTROL_IAP2_PF_R22
S32 iPodControlIAP::CBIAP2_CallStateUpdate(iAP2Device_t* iap2Device, iAP2CallStateUpdateParameter* callStateUpdateParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_CallStateUpdate(iap2Device, callStateUpdateParameter, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_CommunicationsUpdate(iAP2Device_t* iap2Device, iAP2CommunicationsUpdateParameter* communicationsUpdateParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_CommunicationsUpdate(iap2Device, communicationsUpdateParameter, context);
    return IAP2_OK;
}
#else
S32 iPodControlIAP::CBIAP2_TelephonyCallStateInformation(iAP2Device_t* iap2Device, iAP2TelephonyCallStateInformationParameter* telephonyCallStateInformationParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_TelephonyCallStateInformation(iap2Device, telephonyCallStateInformationParameter, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_TelephonyUpdate(iAP2Device_t* iap2Device, iAP2TelephonyUpdateParameter* telephonyUpdateParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_TelephonyUpdate(iap2Device, telephonyUpdateParameter, context);
    return IAP2_OK;
}

#endif

#ifdef IPODCONTROL_IAP2_PF_OOBBT_AVAIL
#ifdef TARGET_BUILD
S32 iPodControlIAP::CBIAP2_StartOOBBTPairing(iAP2Device_t* iap2Device, iAP2StartOOBBTPairingParameter* startOOBBTPairingParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_StartOOBBTPairing(iap2Device, startOOBBTPairingParameter, context);
    return IAP2_OK;
}

S32 iPodControlIAP::CBIAP2_OOBBTPairingLinkKeyInformation(iAP2Device_t* iap2Device, iAP2OOBBTPairingLinkKeyInformationParameter* oobBTPairingLinkKeyInformationParameter, void* context)
{
    ENTRY_INTERNAL;
    //forward to iPodControl class
    LocalSPM::GetIPODControl().OnCBIAP2_OOBBTPairingLinkKeyInformation(iap2Device, oobBTPairingLinkKeyInformationParameter, context);
    return IAP2_OK;
}
#endif
#endif //IPODCONTROL_IAP2_PF_OOBBT_AVAIL
#endif

//**************************** multiple support *******************************
tBoolean iPodControlIAP::SelectDevice(const tMountPoint mountPoint)
{
    ENTRY;
    VARTRACE(mountPoint);
    tBoolean ret = true;

    if(IsIAP2(mountPoint)) {
        const void * pIAP2Device = m_HandleMap.GetIAP2Device(mountPoint);
        if (NULL == pIAP2Device) {
            ETG_TRACE_ERR(("iPodControlIAP::SelectDevice - invalid mp_IAP2Device"));
            ret = false;
        }
    } else {
        if (IPOD_OK != m_IAP1Init) {
            ETG_TRACE_ERR(("iPodControlIAP::SelectDevice - iAP not initialized"));
            ret = false;
        } else {
            const int iPodID = m_HandleMap.GetiPodID(mountPoint);
            if (0 >= iPodID) {
                ETG_TRACE_ERR(("iPodControlIAP::SelectDevice - invalid iPodID"));
                ret = false;
            }
#ifndef TARGET_BUILD_GEN3
            else {
                int res = iPodSelectDevice((S32) iPodID);
                if (IPOD_OK != res) {
                    ETG_TRACE_ERR(("iPodControlIAP::SelectDevice(iPodID=%d) failed %d')", iPodID, res));
                    UpdateIpodCommunicationError(res);
                    ret = false;
                }
            }
#endif
        }
    }

    if(!ret) {
        m_MountPoint[0] = 0;
    } else {
        strncpy_r(m_MountPoint, mountPoint, sizeof(m_MountPoint));
    }

    VARTRACE(m_MountPoint);
    return ret;
}

//**************************** general ***************************************

tBoolean iPodControlIAP::IsIAP2(const tMountPoint mountPoint)
{
    ENTRY_INTERNAL;
    return m_HandleMap.GetOption(mountPoint, hasIAP2Option);
}

tBoolean iPodControlIAP::IsIAP2HostMode(const tMountPoint mountPoint)
{
    ENTRY_INTERNAL;
    tBoolean hostMode = false;
    if(iAPGetConnectionType(mountPoint) == DCT_USB){
#ifdef IPODCONTROL_IAP2_PF_AVAIL
        m_HandleMap.LockIAP2(mountPoint); //start critical section
        iAP2InitParam_t * iAP2InitParameter = (iAP2InitParam_t *)m_HandleMap.GetIAP2InitParameter(mountPoint);
        if(iAP2InitParameter && iAP2InitParameter->p_iAP2AccessoryConfig ) {
            hostMode = ( (iAP2InitParameter->p_iAP2AccessoryConfig->iAP2TransportType == iAP2USBHOSTMODE) ||
                         (iAP2InitParameter->p_iAP2AccessoryConfig->iAP2TransportType == iAP2MULTIHOSTMODE) );
        }
        m_HandleMap.UnlockIAP2(mountPoint); //end critical section
#endif
    }
    return hostMode;
}

tBoolean iPodControlIAP::IsIAP2CarPlayMode(const tMountPoint mountPoint)
{
    ENTRY_INTERNAL;
    tBoolean carPlayMode = false;
    if(iAPGetConnectionType(mountPoint) == DCT_USB){
#ifdef IPODCONTROL_IAP2_PF_AVAIL
        m_HandleMap.LockIAP2(mountPoint); //start critical section
        iAP2InitParam_t * iAP2InitParameter = (iAP2InitParam_t *)m_HandleMap.GetIAP2InitParameter(mountPoint);
        if(iAP2InitParameter && iAP2InitParameter->p_iAP2AccessoryConfig ) {
            carPlayMode = ( (iAP2InitParameter->p_iAP2AccessoryConfig->iAP2TransportType == iAP2USBHOSTMODE) ||
                            (iAP2InitParameter->p_iAP2AccessoryConfig->iAP2TransportType == iAP2MULTIHOSTMODE) ) &&
                           (iAP2InitParameter->p_iAP2AccessoryConfig->iAP2iOSintheCar);
        }
        m_HandleMap.UnlockIAP2(mountPoint); //end critical section
#endif
    }
    return carPlayMode;
}

tBoolean iPodControlIAP::IsIAP2WirelessCarPlayMode(const tMountPoint mountPoint)
{
    ENTRY_INTERNAL;
    tBoolean wirelessCarPlayMode = false;
    if(iAPGetConnectionType(mountPoint) == DCT_WIFI){
#ifdef IPODCONTROL_IAP2_PF_IAP2OVERCARPLAY_AVAIL
#ifdef TARGET_BUILD
        m_HandleMap.LockIAP2(mountPoint); //start critical section
        iAP2InitParam_t * iAP2InitParameter = (iAP2InitParam_t *)m_HandleMap.GetIAP2InitParameter(mountPoint);
        if(iAP2InitParameter && iAP2InitParameter->p_iAP2AccessoryConfig ) {
            wirelessCarPlayMode = (iAP2InitParameter->p_iAP2AccessoryConfig->iAP2TransportType == iAP2OVERCARPLAY) &&
                    iAP2InitParameter->p_iAP2AccessoryConfig->iAP2iOSintheCar;
        }


        m_HandleMap.UnlockIAP2(mountPoint); //end critical section
#endif
#endif
    }
    return wirelessCarPlayMode;
}

tBoolean iPodControlIAP::IsIAP2NativeTransportMode(const tMountPoint mountPoint)
{
    ENTRY_INTERNAL;
    tBoolean nativeTransport = false;
    if(iAPGetConnectionType(mountPoint) == DCT_USB){
#ifdef IPODCONTROL_IAP2_PF_AVAIL
        m_HandleMap.LockIAP2(mountPoint); //start critical section
        iAP2InitParam_t * iAP2InitParameter = (iAP2InitParam_t *)m_HandleMap.GetIAP2InitParameter(mountPoint);
        if(iAP2InitParameter && iAP2InitParameter->p_iAP2AccessoryConfig ) {
            nativeTransport = (iAP2InitParameter->p_iAP2AccessoryConfig->iAP2TransportType == iAP2USBHOSTMODE) &&
                              iAP2InitParameter->p_iAP2AccessoryConfig->iAP2EANativeTransport;
        }
        m_HandleMap.UnlockIAP2(mountPoint); //end critical section
    }
#endif
    return nativeTransport;
}
tBoolean iPodControlIAP::IsIAP2NativeTransportCarlifeMode(const tMountPoint mountPoint)
{
    ENTRY_INTERNAL;
    tBoolean nativeTransport = false;
    tBoolean carLife = false;

    nativeTransport = IsIAP2NativeTransportMode(mountPoint);
    VARTRACE(nativeTransport)

    if(nativeTransport)
    {
        vector<tIPODAppInfo> appInfoList  = m_HandleMap.GetAppInfosFromSPI(mountPoint);

        if(appInfoList.size() > 0)
        {
            for(int i = 0 ; i< appInfoList.size() ;i++)
            {
               if(!strcmp(appInfoList[i].protocol ,"com.baidu.CarLifeVehicleProtocol"))
               {
                   carLife = true;
                   break;
               }
            }
        }
    }

    return (nativeTransport && carLife);
}

tBoolean iPodControlIAP::IsIAP2iTunesRadioPlaying(const tMountPoint mountPoint)
{
    ENTRY_INTERNAL;
    tBoolean iTunesRadioIsPlaying = false;

   m_HandleMap.LockIndexer(mountPoint);
   iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
   if(!pcontext) {
       ETG_TRACE_ERR(("GetIndexerContext failed"));
   } else {
       tFingerprint iTunesRadioLibraryUID = {0};
       tFingerprint nowPlayingLibraryUID = {0};
       pcontext->GetiTunesRadioLibraryUID(iTunesRadioLibraryUID);
       pcontext->GetNowPlayingLibraryUID(nowPlayingLibraryUID);

       iTunesRadioIsPlaying = (nowPlayingLibraryUID[0] != 0) && !strcmp(iTunesRadioLibraryUID, nowPlayingLibraryUID);
   }
   m_HandleMap.UnlockIndexer(mountPoint);

   VARTRACE(iTunesRadioIsPlaying);
   return iTunesRadioIsPlaying;
}

tBoolean iPodControlIAP::IsIAP2iTunesRadioLibrarySupported(const tMountPoint mountPoint)
{
    ENTRY_INTERNAL;
    tBoolean iTunesRadioLibrarySupported = false;

   m_HandleMap.LockIndexer(mountPoint);
   iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
   if(!pcontext) {
       ETG_TRACE_ERR(("GetIndexerContext failed"));
   } else {
       tFingerprint iTunesRadioLibraryUID = {0};
       pcontext->GetiTunesRadioLibraryUID(iTunesRadioLibraryUID);

       iTunesRadioLibrarySupported = iTunesRadioLibraryUID[0] != 0;
   }
   m_HandleMap.UnlockIndexer(mountPoint);

   VARTRACE(iTunesRadioLibrarySupported);
   return iTunesRadioLibrarySupported;
}

tBoolean iPodControlIAP::IsIAP2HostModePossible(const tMountPoint mountPoint)
{
    ENTRY;

    // call iAP2HasOTGPort only in device mode to keep the OTG parameters - GMMY17-2635
    if(IsIAP2HostMode(mountPoint)) {
        ETG_TRACE_USR3(("Host mode already active on this device"));
        return TRUE;
    }

    //check for OTG port available
    tBoolean possible = iAP2HasOTGPort(mountPoint);

    if(!possible) {
        ETG_TRACE_USR3(("iAP2HasOTGPort return false"));
    } else {
        possible = false;
        //get host mode connection config
        const int hostConnectionsMax = LocalSPM::GetDataProvider().iPodControlSupportIAP2HostModeConnectionsMax();
        VARTRACE(hostConnectionsMax);
        if(hostConnectionsMax > 0) {
            //check error timeout
            const bool restHostModeErrors = m_HandleMap.IsTimeElapsed(IN mountPoint, IN iap2LastHostModeError, IN LocalSPM::GetDataProvider().iPodControlIAP2HostModeErrorResetMS());
            VARTRACE(mHostModeErrorCount[mountPoint]);
            VARTRACE(restHostModeErrors);
            if(restHostModeErrors || mHostModeErrorCount[mountPoint] == 0) {
                mHostModeErrorCount[mountPoint] = 0;
                //check for already active Host modes
                if(GetNumberOfActiveHostModeConnections() < hostConnectionsMax) {
                    //host mode is possible
                    possible = true;
                } else {
                    ETG_TRACE_USR3(("Host mode already active on another device"));
                }
            } else {
                ETG_TRACE_USR3(("Blocked by previous host mode errors"));
            }
        }
    }
    VARTRACE(possible);
    return possible;
}

vector<string> iPodControlIAP::iAPGetMountPoints()
{
    ENTRY_INTERNAL;
    return m_HandleMap.GetAll();
}

int iPodControlIAP::GetNumberOfActiveHostModeConnections()
{
    ENTRY_INTERNAL;
    int count = 0;

    vector<string> mountPoints = m_HandleMap.GetAll();
    for(unsigned int i = 0; i < mountPoints.size(); i++) {
        if(IsIAP2(mountPoints[i].c_str()) && IsIAP2HostMode(mountPoints[i].c_str())) {
            count++;
        }
    }
    return count;
}

vector<string> iPodControlIAP::iAPGetNumberOfiAP2Link()
{
    ENTRY_INTERNAL;

    vector<string> btmountPoints;
    vector<string> mountPoints = m_HandleMap.GetAll();
    for(unsigned int i = 0; i < mountPoints.size(); i++) {
        if(m_HandleMap.GetOption(mountPoints[i].c_str(), hasBluetoothiAP2Link)) {
            btmountPoints.push_back(mountPoints[i]);
        }
    }
    return btmountPoints;
}

tBoolean iPodControlIAP::CheckFocusMusicApp() {
    ENTRY;

    tBoolean ret = IsFocusMusicApp();
    if (!ret) {
        //This function resumes ipod app from e.g. pandora app.
        //NOTE! supported since iOS 5.1, related tickets GMNGA-37363, GMNGA-38965

        //send iAP playback command, notifications expected
        m_HandleMap.ResetElapsedTime(m_MountPoint, pbNotifications);

        int res = iPodPlayControl(IPODCONTROL_ID_FRONT (IPOD_PLAY_CONTROL) IPODCONTROL_RESUME_IPOD);
        ETG_TRACE_USR3(("iPodControlIAP::CheckFocusMusicApp() iPodPlayControl(IPODCONTROL_RESUME_IPOD) returned %d", res));

        if (IPOD_OK == res) {
            //pause initial ipod music playout
            res = iPodPlayToggle(IPODCONTROL_ID_ONLY);
            ETG_TRACE_USR3(("iPodControlIAP::CheckFocusMusicApp() iPodPlayToggle returned %d", res));
            if(IPOD_OK != res) {
                UpdateIpodCommunicationError(res);
            }

            //sync with ipod app focus
            ret = IsFocusMusicApp();

            //wait for focus change, this may take several seconds, e.g. for youtube to music app 1.2 seconds on iPhone 4S
            //see FOCUSAPP_RETRYS * FOCUSAPP_RETRY_TIME for current max wait interval
            for (int i = 0; !ret && i < IPODCONTROL_FOCUSAPP_RETRYS; i++) {
                ETG_TRACE_USR3(("iPodControlIAP::CheckFocusMusicApp() waiting for focus on iPod music..."));
                usleep(IPODCONTROL_FOCUSAPP_RETRY_TIME * 1000);
                //sync with ipod app focus
                ret = IsFocusMusicApp();
            }
        }
        else {
            UpdateIpodCommunicationError(res);
        }
    }
    return ret;
}

tBoolean iPodControlIAP::IsFocusMusicApp() {
    ENTRY;

    tBoolean isInIpodMode = true; //default: true for all devices not supporting iPodGetNowPlayingFocusApp
    tAppName focusApp = { 0 };
    const char MobileIpodID1[] = "com.apple.mobileipod";
    const char MobileIpodID2[] = "com.apple.Music";

    m_HandleMap.GetFocusApp(focusApp, m_MountPoint);
    VARTRACE(focusApp);
    if (focusApp[0] == 0 || !strncmp(focusApp, MobileIpodID1, strlen_r(MobileIpodID1))
            || !strncmp(focusApp, MobileIpodID2, strlen_r(MobileIpodID2))) {
        ETG_TRACE_USR3(("iPodControlIAP::IsFocusMusicApp() FOCUS MUSIC APP"));
    } else {
        isInIpodMode = false;
        ETG_TRACE_USR3(("iPodControlIAP::IsFocusMusicApp() NOT FOCUS MUSIC APP"));
    }

    VARTRACE(isInIpodMode);
    return isInIpodMode;
}

tBoolean iPodControlIAP::SetConfiOSApp(const tMountPoint mountPoint) {
    ENTRY;

    IPOD_IOS_APP * pApps = NULL;
    int numApps = m_HandleMap.CreateConfiOSApp(pApps, mountPoint);
    VARTRACE(numApps);

    //dump iOS configuration
    for (int i = 0; pApps && i < numApps; i++) {
        VARTRACE((char*)pApps[i].protocol);
        VARTRACE((char*)pApps[i].bundle);
        VARTRACE(pApps[i].metaData);
    }
    int res = iPodSetConfiOSApp((U8*) mountPoint, pApps, (S8) numApps); //lint !e1773 iap1 methode syntax issue
    ETG_TRACE_USR3(("iPodSetConfiOSApp() returned %d", res));
    if(IPOD_OK != res) {
        UpdateIpodCommunicationError(res);
    }

    iPodControlHandle::DeleteConfiOSApp(pApps, numApps);

    return (res == IPOD_OK);
}

//**************************** playback ***************************************
tBoolean iPodControlIAP::PlayControl(const IPOD_PLAY_CONTROL control) {
    ENTRY;
    VARTRACE((int)control);
    //send iAP playback command, notifications expected
    m_HandleMap.ResetElapsedTime(m_MountPoint, pbNotifications);

    int res = iPodPlayControl(IPODCONTROL_ID_FRONT control);
    if (IPOD_OK != res) {
        ETG_TRACE_ERR(("iPodControlIAP::PlayControl(%d) failed %d", control, res));
        UpdateIpodCommunicationError(res);
    }
    VARTRACE(res);
    return (IPOD_OK == res);
}

tBoolean iPodControlIAP::iAP1_SeekTo(const tPlaytime position) {
    ENTRY;
    //send iAP playback command, notifications expected
    //m_HandleMap.ResetElapsedTime(m_MountPoint, pbNotifications);

    int res = iPodSetTrackPosition(IPODCONTROL_ID_FRONT (U32) position);
    if (IPOD_OK != res) {
        ETG_TRACE_ERR(("iPodControlIAP::iAP1_SeekTo(pos=%u) failed %d", position, res));
        UpdateIpodCommunicationError(res);
    }
    return (IPOD_OK == res);
}

tBoolean iPodControlIAP::PlayRecord(iPodControlMediaPath &path, int const trackIndex, const U64 uuid) {
    ENTRY;
    VARTRACE(uuid);
    int index = trackIndex;
    tBoolean ret = true;
    m_HandleMap.SetPBTrackIndex(m_MountPoint, -1);
    m_HandleMap.SetNowPlayingTrackIndex(m_MountPoint, -1);

    int count = path.GetCurrentCount();
    if (count > 0 && index >= 0 && index < count) {

        //send iAP playback command, notifications expected
        m_HandleMap.ResetElapsedTime(m_MountPoint, pbNotifications);
#if 0
        //WORKAROUND: Pausing current playback before selection avoids audio issue on samplerate changes
        if (iAPPlayPause(m_MountPoint) != MP_NO_ERROR) {
            ETG_TRACE_ERR(("Pause before selection failed"));
        }
#endif
        if(uuid > 0 && LocalSPM::GetDataProvider().iPodControlIAP1ChapterStreaming()) {
            //create playlist for audiobook
            index = 0; //singel item in UUIDList
            m_HandleMap.SetDBPath(m_MountPoint, iPodControlMediaPath()); // reset path
#ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT
            U64 uuid64[1]; //to match to existing iap function
#else
            tU64 uuid64[1];
#endif
            uuid64[0] = uuid;

            int res = iPodPrepareUIDList(IPODCONTROL_ID_FRONT uuid64, 1);

            ETG_TRACE_USR3(("iPodPrepareUIDList returned %d", res));
            if(res != IPOD_OK) {
                UpdateIpodCommunicationError(res);
                ret = false;
            } else {
                res = iPodPlayPreparedUIDList(IPODCONTROL_ID_FRONT uuid64[0]);
                ETG_TRACE_USR3(("iPodPlayPreparedUIDList returned %d", res));
                if(res != IPOD_OK) {
                    UpdateIpodCommunicationError(res);
                    ret = false;
                }
            }
        } else if (path.IsDBPath()) {
            int cat = path.GetCurrentIPODCategory();
            if (cat != IPOD_CAT_TRACK && cat != IPOD_CAT_AUDIOBOOK) {
                ETG_TRACE_ERR(("iPodControlIAP::PlayRecord() invalid category for playback"));
                ret = false;
            } else if (!SelectDBRecord(cat, index)) {
                ETG_TRACE_ERR(("iPodControlIAP::PlayRecord() SelectDBRecord failed"));
                ret = false;
            }
        } else {
            int currentIndex = (int) iPodGetCurrentPlayingTrackIndex(IPODCONTROL_ID_ONLY);
            VARTRACE(currentIndex);

            if(currentIndex == index) {
                ETG_TRACE_USR3(("iPodControlIAP::PlayRecord() continue current track index %d", index));
#if 0 //CMG3GB-2902
            } else if(currentIndex >= 0 && (index-1 == currentIndex)) {
                ETG_TRACE_USR3(("iPodControlIAP::PlayRecord() call next track index %d", index));
                if (!PlayControl(NEXT)) {
                    //NEXT command failed, try legacy command
                    ETG_TRACE_USR3(("iPodControlIAP::PlayRecord() PlayControl(NEXT_TRACK) failed"));
                    ret = PlayControl(NEXT_TRACK);
                    if (!ret) {
                        ETG_TRACE_ERR(("iPodControlIAP::PlayRecord() PlayControl(NEXT_TRACK) failed"));
                    }
                }
#endif
            } else {
                int res = iPodSetCurrentPlayingTrack(IPODCONTROL_ID_FRONT index);
                ETG_TRACE_USR3(("iPodControlIAP::PlayRecord() iPodSetCurrentPlayingTrack(%d of %d) returned %d", index, count, res));
                if (IPOD_OK != res) {
                    ETG_TRACE_ERR(("iPodControlIAP::PlayRecord() iPodSetCurrentPlayingTrack failed"));
                    UpdateIpodCommunicationError(res);
                    ret = false;
                }
            }
        }

    } else {
        ETG_TRACE_USR3(("iPodControlIAP::PlayRecord() invalid parameter, index %d, count %d", index, count));
        ret = false;
    }

    if (ret) {
        int selectedPBIndex = index;//uses as DB index, shuffle always OFF! //(int) iPodGetCurrentPlayingTrackIndex(IPODCONTROL_ID_ONLY);
        ETG_TRACE_USR3(("iPodControlIAP::PlayRecord() iPodGetCurrentPlayingTrackIndex returned %d", selectedPBIndex));
        m_HandleMap.SetPBTrackIndex(m_MountPoint, selectedPBIndex);
    }

    return ret;
}

tBoolean iPodControlIAP::PlayChapter(int const chapter) {
    ENTRY;
    tBoolean ret = false;
    VARTRACE(chapter);

    if(chapter >= 0) {
        //check current chapter
        int currentChapterIndex = -1;
        int currentChapterCount = -1;
        int res = (int) iPodGetCurrentPlayingTrackChapterInfo(IPODCONTROL_ID_FRONT &currentChapterIndex, &currentChapterCount);
        ETG_TRACE_USR3(("iPodGetCurrentPlayingTrackChapterInfo() returned %d", res));
        if(res < IPOD_OK) {
            UpdateIpodCommunicationError(res);
        }
        VARTRACE(currentChapterIndex);
        VARTRACE(currentChapterCount);

        //Woraround: Audiobook may take time to get active after SelecDBRecord
        if(currentChapterCount == 0) {
            const __useconds_t retryAfterUS = LocalSPM::GetDataProvider().iPodControlChapterSelectMS() * 1000;
            VARTRACE(retryAfterUS);
            usleep(retryAfterUS);
            res = (int) iPodGetCurrentPlayingTrackChapterInfo(IPODCONTROL_ID_FRONT &currentChapterIndex, &currentChapterCount);
            ETG_TRACE_USR3(("iPodGetCurrentPlayingTrackChapterInfo() returned %d", res));
            if(res < IPOD_OK) {
                UpdateIpodCommunicationError(res);
            }
            VARTRACE(currentChapterIndex);
            VARTRACE(currentChapterCount);
        }

        if(IPOD_OK == res && currentChapterCount > 0 && currentChapterCount > chapter) {
            if(currentChapterIndex != chapter) {
                //send iAP playback command, notifications expected
                m_HandleMap.ResetElapsedTime(m_MountPoint, pbNotifications);

                //select chapter index
                res = iPodSetCurrentPlayingTrackChapter(IPODCONTROL_ID_FRONT chapter);
                ETG_TRACE_USR3(("iPodSetCurrentPlayingTrackChapter(%d) returned %d", chapter, res));
                if(IPOD_OK != res) {
                    UpdateIpodCommunicationError(res);
                }
                ret = IPOD_OK == res;
            } else {
                //already current chapter
                ret = true;
            }
        }
    }

    return ret;
}

tBoolean iPodControlIAP::GetPlayingTitle(tMetadata &metadata,
        const int index) {
    ENTRY;
    VARTRACE(index);
    U8 utf8_iPodStr[IPOD_RESPONSE_BUF_SIZE] = { 0 };
    int res = index < 0 ? IPOD_ERROR : iPodGetIndexedPlayingTrackTitle(
            IPODCONTROL_ID_FRONT
            (U32) index, utf8_iPodStr);
    if (IPOD_OK != res) {
        ETG_TRACE_ERR(("iPodControlIAP::GetPlayingTitle() failed %d", res));
        UpdateIpodCommunicationError(res);
    } else {
        ETG_TRACE_USR3(("iPodControlIAP::GetPlayingTitle() '%s'", (char*) utf8_iPodStr));
        //validate metadata
        strncpy_r(metadata, (char*) utf8_iPodStr, sizeof(metadata));
        LocalSPM::GetDataProvider().ImportAndCut(
                INOUT (FastUTF8::tString) metadata, sizeof(metadata));
    }
    return (IPOD_OK == res);
}

tBoolean iPodControlIAP::GetPlayingAlbum(tMetadata &metadata,
        const int index) {
    ENTRY;
    U8 utf8_iPodStr[IPOD_RESPONSE_BUF_SIZE] = { 0 };
    int res = index < 0 ? IPOD_ERROR : iPodGetIndexedPlayingTrackAlbumName(
            IPODCONTROL_ID_FRONT
            (U32) index, utf8_iPodStr);
    if (IPOD_OK != res) {
        ETG_TRACE_ERR(("iPodControlIAP::GetPlayingAlbum() failed %d", res));
        UpdateIpodCommunicationError(res);
    } else {
        ETG_TRACE_USR3(("iPodControlIAP::GetPlayingAlbum() '%s'", (char*) utf8_iPodStr));

        //validate metadata
        strncpy_r(metadata, (char*) utf8_iPodStr, sizeof(metadata));
        LocalSPM::GetDataProvider().ImportAndCut(
                INOUT (FastUTF8::tString) metadata, sizeof(metadata));
    }
    return (IPOD_OK == res);
}

tBoolean iPodControlIAP::GetPlayingArtist(tMetadata &metadata,
        const int index) {
    ENTRY;
    U8 utf8_iPodStr[IPOD_RESPONSE_BUF_SIZE] = { 0 };
    int res = index < 0 ? IPOD_ERROR : iPodGetIndexedPlayingTrackArtistName(
            IPODCONTROL_ID_FRONT
            (U32) index, utf8_iPodStr);
    if (IPOD_OK != res) {
        ETG_TRACE_ERR(("iPodControlIAP::GetPlayingArtist() failed %d", res));
        UpdateIpodCommunicationError(res);
    } else {
        ETG_TRACE_USR3(("iPodControlIAP::GetPlayingArtist() '%s'", (char*) utf8_iPodStr));

        //validate metadata
        strncpy_r(metadata, (char*) utf8_iPodStr, sizeof(metadata));
        LocalSPM::GetDataProvider().ImportAndCut(
                INOUT (FastUTF8::tString) metadata, sizeof(metadata));
    }
    return (IPOD_OK == res);
}

tBoolean iPodControlIAP::GetPlayingGenre(tMetadata &metadata,
        const int index) {
    ENTRY;
    U8 utf8_iPodStr[IPOD_RESPONSE_BUF_SIZE] = { 0 };
    int res = IPOD_ERROR;

    if (index >= 0) {
        m_HandleMap.SuspendRemainingTime(m_MountPoint, atsPlayingTrackInfo, LocalSPM::GetDataProvider().iPodControlATSDelayMS());
        res = iPodGetIndexedPlayingTrackGenre(IPODCONTROL_ID_FRONT (U32) index,
                0, utf8_iPodStr);
        m_HandleMap.ResetElapsedTime(m_MountPoint, atsPlayingTrackInfo);
        if(IPOD_OK != res) {
            UpdateIpodCommunicationError(res);
        }
    }

    if (IPOD_OK != res) {
        ETG_TRACE_ERR(("iPodControlIAP::GetPlayingGenre() failed %d", res));
    } else {
        ETG_TRACE_USR3(("iPodControlIAP::GetPlayingGenre() '%s'", (char*) utf8_iPodStr));

        //validate metadata
        strncpy_r(metadata, (char*) utf8_iPodStr, sizeof(metadata));
        LocalSPM::GetDataProvider().ImportAndCut(
                INOUT (FastUTF8::tString) metadata, sizeof(metadata));
    }
    return (IPOD_OK == res);
}

tBoolean iPodControlIAP::GetPlayingChapter(tMetadata &metadata,
        const int index) {
    ENTRY;
    U8 utf8_iPodStr[IPOD_RESPONSE_BUF_SIZE] = { 0 };
    int res = index < 0 ? IPOD_ERROR : iPodGetCurrentPlayingTrackChapterName(
            IPODCONTROL_ID_FRONT
            (U32) index, utf8_iPodStr);
    if (IPOD_OK != res) {
        ETG_TRACE_ERR(("iPodControlIAP::GetPlayingChapter() failed %d", res));
        UpdateIpodCommunicationError(res);
    } else {
        ETG_TRACE_USR3(("iPodControlIAP::GetPlayingChapter() '%s'", (char*) utf8_iPodStr));
        //validate metadata
        strncpy_r(metadata, (char*) utf8_iPodStr, sizeof(metadata));
        LocalSPM::GetDataProvider().ImportAndCut(
                INOUT (FastUTF8::tString) metadata, sizeof(metadata));
    }
    return (IPOD_OK == res);
}

tBoolean iPodControlIAP::GetPlayingTrackInfo(tIPODPlayingTrackInfo *pTrackInfo,
        const int index, const int chapter) {
    ENTRY;
    int res = IPOD_ERROR;

    ETG_TRACE_USR3(("iPodControlIAP::GetPlayingTrackInfo()"));
    VARTRACE(index);
    VARTRACE(chapter);

    if (pTrackInfo && index >= 0 && chapter >= 0) {
#ifndef TARGET_BUILD_GEN3
        const U32 iPodID = 1; //only one single entry in Gen2 PF possible
#else
        const U32 iPodID = (U32)m_HandleMap.GetiPodID(m_MountPoint);
#endif
        mMapMutex.lock();
        mPlayingTrackInfoPtrMap[iPodID] = pTrackInfo;
        mMapMutex.unlock();

        m_HandleMap.SuspendRemainingTime(m_MountPoint, atsPlayingTrackInfo, LocalSPM::GetDataProvider().iPodControlATSDelayMS());
        res = iPodGetIndexedPlayingTrackInfo(
                IPODCONTROL_ID_FRONT pTrackInfo->type, (U32) index,
                (U16) chapter, CBIAP1_PlayingTrackInfo);
        m_HandleMap.ResetElapsedTime(m_MountPoint, atsPlayingTrackInfo);

        if(IPOD_OK != res) {
            UpdateIpodCommunicationError(res);
        }

        mMapMutex.lock();
        mPlayingTrackInfoPtrMap[iPodID] = 0;
        mMapMutex.unlock();
    }

    ETG_TRACE_USR3(("iPodControlIAP::GetPlayingTrackInfo() iPodGetIndexedPlayingTrackInfo returned %d", res));
    return (IPOD_OK == res);
}

tBoolean iPodControlIAP::GetTrackArtworkTimes(U32 trackIndex, U16 formatId,
        U16 artworkIndex, U16 artworkCount, U16* resultCount, U32* buffer) {
    ENTRY;
    ETG_TRACE_USR3(("iPodControlIAP::GetTrackArtworkTimes()"));
    VARTRACE(trackIndex);
    VARTRACE(formatId);
    VARTRACE(artworkIndex);
    VARTRACE(artworkCount);

    int ret = iPodGetTrackArtworkTimes(IPODCONTROL_ID_FRONT trackIndex,
            formatId, artworkIndex, artworkCount, resultCount, buffer);

    if (IPOD_OK == ret && buffer) {
        VARTRACE(*resultCount);
        for (tU16 u16count = 0; u16count < *resultCount; u16count++) {
            ETG_TRACE_USR3(("iPodControlIAP::GetTrackArtworkTimes() ARTWORK TIMES[%i] = %d ", u16count, buffer[u16count]));
        }
    }

    ETG_TRACE_USR3(("iPodControlIAP::GetTrackArtworkTimes() iPodGetTrackArtworkTimes returned %d", ret));

    if(IPOD_OK != ret) {
        UpdateIpodCommunicationError(ret);
    }

    return (IPOD_OK == ret);
}

tBoolean iPodControlIAP::GetTrackArtworkData(U32 trackIndex, U16 formatId,
        U32 timeOffset) {
    ENTRY;
    ETG_TRACE_USR3(("iPodControlIAP::GetTrackArtworkData()"));
    VARTRACE(trackIndex);
    VARTRACE(formatId);
    VARTRACE(timeOffset);

    int res = iPodGetTrackArtworkData(IPODCONTROL_ID_FRONT trackIndex,
            formatId, timeOffset, CBIAP1_ArtworkData);
    ETG_TRACE_USR3(("iPodControlIAP::GetTrackArtworkData() iPodGetTrackArtworkData returned %d", res));
    if(IPOD_OK != res) {
        UpdateIpodCommunicationError(res);
    }
    return (IPOD_OK == res);
}

tBoolean iPodControlIAP::UpdatePlayStatus()
{
    ENTRY;
    IPOD_PLAYER_STATE state;
    tPlaytime total;
    tPlaytime elapsed;

    //ATS - delay call by 1000ms
    m_HandleMap.SuspendRemainingTime(m_MountPoint, atsPlayStatus, LocalSPM::GetDataProvider().iPodControlATSDelayMS());
    int res = iPodGetPlayStatus(IPODCONTROL_ID_FRONT &state, &total, &elapsed);
    m_HandleMap.ResetElapsedTime(m_MountPoint, atsPlayStatus);

    if (IPOD_OK != res) {
        ETG_TRACE_ERR(("iPodGetPlayStatus failed %d", res));
        UpdateIpodCommunicationError(res);
    } else {
        ETG_TRACE_USR3(("*** IPOD_PLAYER_STATE: %d, TIME: %d/%d ms", state, elapsed, total));
        m_HandleMap.SetPlayerState(m_MountPoint, state);
        m_HandleMap.SetElapsedPlaytime(m_MountPoint, elapsed);
        m_HandleMap.SetTotalPlaytime(m_MountPoint, total);
    }
    return (IPOD_OK == res);
}

tBool iPodControlIAP::UpdateNowPlaying(const bool updatePlayStatus)
{
    ENTRY;
    VARTRACE(updatePlayStatus);
    int res = IPOD_OK;

    //defaults
    tMediaType mediatype = MTY_UNKNOWN;
    tMetadata genre = { 0 };
    tMetadata artist = { 0 };
    tMetadata composer = { 0 };
    tMetadata album = { 0 };
    tMetadata title = { 0 };
    tMetadata chapter = { 0 };
    bool useChapterName = false;
    tUUID uuid = { 0 };

    //UpdatePlayStatus: Calling iPodGetPlayStatus has an ATS restriction (1 call per second only)
    //to increase processing speed we avoid calling iPodGetPlayStatus
    //instead we rely iPod playback state on the extented play status updates/callbacks and retrieve the total playtime
    //by calling GetTrackInfo
    //So for new iPods (IAP1) UpdatePlayStatus is called only once after entering extend mode
    const bool extPlayStatusUpdated = updatePlayStatus && m_HandleMap.GetOption(m_MountPoint, hasExtPlayStatusOption) && m_HandleMap.GetOption(m_MountPoint, hasTrackInfoOption);
    VARTRACE(extPlayStatusUpdated);

    if (updatePlayStatus && !extPlayStatusUpdated && !UpdatePlayStatus()) {
        ETG_TRACE_ERR(("UpdatePlayStatus failed"));
        res = IPOD_ERROR;
    } else {
        res = (int) iPodGetCurrentPlayingTrackIndex(IPODCONTROL_ID_ONLY);
        if (res < IPOD_OK) {
            ETG_TRACE_ERR(("iPodGetCurrentPlayingTrackIndex failed %d", res));
        } else {
            ETG_TRACE_USR3(("iPodGetCurrentPlayingTrackIndex %d", res));
            int trackid = res;
            m_HandleMap.SetNowPlayingTrackIndex(m_MountPoint, trackid);

            res = IPOD_OK;
            tPlaytime duration = 0;

            if (!GetPlayingTitle(title, trackid)) {
                ETG_TRACE_ERR(("get playing metadata failed"));
                res = IPOD_ERROR;
            } else if (!GetPlayingAlbum(album, trackid)) {
                ETG_TRACE_USR3(("get playing metadata failed"));
                res = IPOD_ERROR;
            } else if (!GetPlayingArtist(artist, trackid)) {
                ETG_TRACE_USR3(("get playing metadata failed"));
                res = IPOD_ERROR;
            } else if (!GetPlayingGenre(genre, trackid)) {
                ETG_TRACE_USR3(("get playing metadata failed"));
                res = IPOD_ERROR;
            } else {
                //Retrieve media type
                IPOD_TRACK_INFORMATION_DATA::_CAPABILITIES caps = { 0 };
                if (m_HandleMap.GetOption(m_MountPoint, hasTrackInfoOption)) {

                    IPOD_TRACK_INFORMATION_BITFIELD bitfield = { 0 };
                    bitfield.track_info.CAPABILITIES = 1;
                    bitfield.track_info.DURATION = 1;
                    bitfield.track_info.UID = 1;

                    tIPODTrackInfos trackInfos;
                    if (!GetTrackInfo(&trackInfos, bitfield, trackid, 1, false)) { //call GetPBTrackInfo
                        ETG_TRACE_USR3(("get playing CAPABILITIES failed"));
                        res = IPOD_ERROR;
                    } else {
                        pair<tIPODTrackInfos::const_iterator, tIPODTrackInfos::const_iterator> pr = trackInfos.equal_range(trackid);
                        for (tIPODTrackInfos::const_iterator it = pr.first; it != pr.second; ++it) {
                            if (it->second.type == CAPABILITIES) {
                                caps = it->second.data.caps;
                            } else if (it->second.type == DURATION) {
                                duration = it->second.data.duration;
                                VARTRACE(duration);
                            } else if (it->second.type == UID) {
                                if(it->second.data.trackUID > 0) {
                                    snprintf(uuid, sizeof(uuid), IPODCONTROL_UUID_FORMAT, it->second.data.trackUID);
                                }
                                VARTRACE(uuid);
                            }
                        }
                    }
                }
                VARTRACE((int)caps.hasArtwork);
                VARTRACE((int)caps.hasChapter);
                VARTRACE((int)caps.isAudiobook);
                VARTRACE((int)caps.isPodcastEpi);
                VARTRACE((int)caps.isVideo);
                //get proper MTY, changes for special media types like audiobooks needed
                if (caps.isAudiobook || !strcmp(genre,"Audiobooks") || !strcmp(genre,"Audiobook")) {
                    ETG_TRACE_USR3(("*** NowPlaying *** MTY_AUDIOBOOK"));
                    if (caps.hasChapter) {
                        //Embedded Audiobook Chapters
                        int chapterIndex = -1;
                        int chapterCount = -1;
                        res = (int) iPodGetCurrentPlayingTrackChapterInfo(IPODCONTROL_ID_FRONT &chapterIndex, &chapterCount);
                        if (res < IPOD_OK) {
                            ETG_TRACE_ERR(("iPodGetCurrentPlayingTrackChapterInfo failed %d", res));
                            UpdateIpodCommunicationError(res);
                        } else {
                            ETG_TRACE_USR3(("iPodGetCurrentPlayingTrackChapterInfo index %d, count %d", chapterIndex, chapterCount));
                            if(!GetPlayingChapter(chapter, chapterIndex)) {
                                ETG_TRACE_USR3(("get playing chapter failed"));
                                snprintf(chapter, sizeof(chapter), "%d/%d", chapterIndex+1, chapterCount);
                            }
                        }
                    }
                    useChapterName = chapter[0] != 0;
                    mediatype = MTY_AUDIOBOOK;
                } else if (caps.isPodcastEpi || !strcmp(genre,"Podcast")) {
                    ETG_TRACE_USR3(("*** NowPlaying *** MTY_PODCAST"));
                    mediatype = MTY_PODCAST;
                } else if (caps.isVideo) {
                    ETG_TRACE_USR3(("*** NowPlaying *** MTY_VIDEO"));
                    mediatype = MTY_VIDEO;
                    //NOTE: For videos iPodGetIndexedPlayingTrackGenre returns a different metadata than selected, e.g. 'Movie'
                    strncpy_r(genre, m_HandleMap.GetPBPath(m_MountPoint).GetName(IPOD_CAT_GENRE).c_str(), sizeof(genre));
                } else {
                    ETG_TRACE_USR3(("*** NowPlaying *** MTY_MUSIC_FILE"));
                    mediatype = MTY_MUSIC_FILE;
                }

            }
            if(extPlayStatusUpdated) {
                m_HandleMap.SetTotalPlaytime(m_MountPoint, duration);
            }
        }
    }

    //store nowplaying metadata
    if(mediatype == MTY_AUDIOBOOK) {
        //m_HandleMap.SetNowPlayingTags(m_MountPoint, mediatype, artist, useChapterName ? title : album, NULL, NULL, useChapterName ? chapter : title);
        m_HandleMap.SetNowPlayingTags(m_MountPoint, mediatype, artist, album, NULL, NULL, useChapterName ? chapter : title, uuid);
    } else if(mediatype == MTY_VIDEO) {
        m_HandleMap.SetNowPlayingTags(m_MountPoint, mediatype, genre, NULL, NULL, NULL, title, uuid);
    } else if(mediatype == MTY_PODCAST) {
        m_HandleMap.SetNowPlayingTags(m_MountPoint, mediatype, album, artist, NULL, NULL, title, uuid);
    } else if(mediatype == MTY_MUSIC_FILE) {
        m_HandleMap.SetNowPlayingTags(m_MountPoint, mediatype, genre, artist, composer, album, title, uuid);
    } else {
        m_HandleMap.SetNowPlayingTags(m_MountPoint, mediatype, NULL, NULL, NULL, NULL, NULL, uuid);
    }

    VARTRACE(mediatype);
    VARTRACE(genre);
    VARTRACE(artist);
    VARTRACE(composer);
    VARTRACE(album);
    VARTRACE(title);
    VARTRACE(chapter);

    return (IPOD_OK == res);
}

tBoolean iPodControlIAP::SelectRecord(iPodControlMediaPath &path) {
    ENTRY;
    tBoolean res = true;

    if (!path.IsLTYSupported()) {
        ETG_TRACE_ERR(("iPodControlIAP::SelectDBRecord() LTY not supported"));
        return false;
    }

    if ((path.IsDBPath() || !IsStreaming(m_MountPoint)) && path.ReuseList(m_HandleMap.GetDBPath(m_MountPoint))) {
        ETG_TRACE_USR3(("iPodControlIAP::SelectDBRecord() reused last selection"));
    } else {
        m_HandleMap.SetDBPath(m_MountPoint, iPodControlMediaPath()); // reset path, default for all error cases
        if (path.IsDBPath()) {
            res = ResetDBSelection(path);
            if (!res) {
                ETG_TRACE_ERR(("iPodControlIAP::SelectDBRecord() ResetDBSelection failed"));
                return false;
            }
            res = SelectDBRecordCategory(path, IPOD_CAT_PLAYLIST);
            if (!res) {
                ETG_TRACE_ERR(("iPodControlIAP::SelectDBRecord() SelectDBRecordCategory IPOD_CAT_PLAYLIST failed"));
                return false;
            }

            res = SelectDBRecordCategory(path, IPOD_CAT_GENRE);
            if (!res) {
                ETG_TRACE_ERR(("iPodControlIAP::SelectDBRecord() SelectDBRecordCategory IPOD_CAT_GENRE failed"));
                return false;
            }

            res = SelectDBRecordCategory(path, IPOD_CAT_PODCAST);
            if (!res) {
                ETG_TRACE_ERR(("iPodControlIAP::SelectDBRecord() SelectDBRecordCategory IPOD_CAT_PODCAST failed"));
                return false;
            }
            res = SelectDBRecordCategory(path, IPOD_CAT_ARTIST);
            if (!res) {
                ETG_TRACE_ERR(("iPodControlIAP::SelectDBRecord() SelectDBRecordCategory IPOD_CAT_ARTIST failed"));
                return false;
            }
            if (path.GetIndexOfIPODCategory(IPOD_CAT_ARTIST) < 0) {
                res = SelectDBRecordCategory(path, IPOD_CAT_COMPOSER);
                if (!res) {
                    ETG_TRACE_ERR(("iPodControlIAP::SelectDBRecord() SelectDBRecordCategory IPOD_CAT_COMPOSER failed"));
                    return false;
                }
            }
            res = SelectDBRecordCategory(path, IPOD_CAT_ALBUM);
            if (!res) {
                ETG_TRACE_ERR(("iPodControlIAP::SelectDBRecord() SelectDBRecordCategory IPOD_CAT_ALBUM failed"));
                return false;
            }

            //set row count
            const int currentCat = path.GetCurrentIPODCategory();
            VARTRACE(currentCat);
            int count = GetNumberCategorizedDBRecords(currentCat);
            VARTRACE(count);
            if (count < 0) {
                ETG_TRACE_ERR(("iPodControlIAP::SelectDBRecord() GetNumberCategorizedDBRecord failed %d", count));
                return false;
            } else {
                path.SetCurrentCount(count);
            }
        } else {
            //PB list
            int count = iPodGetNumPlayingTracks(IPODCONTROL_ID_ONLY);
            VARTRACE(count);
            if (count < 0) {
                ETG_TRACE_ERR(("iPodControlIAP::SelectDBRecord() iPodGetNumPlayingTracks failed %d", count));
                return false;
            } else {
                path.SetCurrentCount(count);
            }
        }
        //save last iPod DB selection
        m_HandleMap.SetDBPath(m_MountPoint, path);
    }
    return res;
}

tBoolean iPodControlIAP::SelectDBRecordCategory(iPodControlMediaPath &path,
        const int cat) {
    ENTRY;
    VARTRACE(cat);
    tBoolean res = true;

    int index = path.GetIndexOfIPODCategory(cat);
    if (index >= 0) {
        int count = GetNumberCategorizedDBRecords(cat);
        if (count == 0) {
            ETG_TRACE_USR3(("%s - No selection possible for count == 0", __PRETTY_FUNCTION__));
        } else if (count < 0) {
            res = false;
            ETG_TRACE_ERR(("iPodControlIAP::SelectDBRecordCategory() GetNumberCategorizedDBRecord failed %d", count));
        } else if (index >= count) {
            res = false;
            ETG_TRACE_ERR(("iPodControlIAP::SelectDBRecordCategory() index %d out of range %d failed", index, count));
        } else {
            tIPODDBRecords records;
            res = RetrieveCategorizedDBRecords(&records, cat, index, 1);
            if (!res) {
                ETG_TRACE_ERR(("%s - RetrieveCategorizedDBRecords failed", __PRETTY_FUNCTION__));
            } else if (records.find(index) == records.end()) {
                ETG_TRACE_ERR(("%s - NO ENTRY", __PRETTY_FUNCTION__));
                res = false;
            } else {
                //store entries name of sub-selection
                path.SetName(cat, records[index]);
                res = SelectDBRecord(cat, index);
                if (res) {
                    //store number entries of sub-selection
                    path.SetCount(cat, count);
                }
            }
        }
    }

    return res;
}

tBoolean iPodControlIAP::SelectDBRecord(const int cat, const int index) {
    ENTRY;

    int res = IPOD_ERROR;
    if (index >= 0) {
        if (cat == IPOD_CAT_TRACK && m_HandleMap.GetOption(m_MountPoint,
                hasPlaySelectionOption)) {
            res = iPodPlayCurrentSelection(IPODCONTROL_ID_FRONT index);
            ETG_TRACE_USR3(("iPodControlIAP::SelectDBRecord() iPodPlayCurrentSelection(%d) returned %d", index, res));
        } else {
            res = iPodSelectDBRecord(IPODCONTROL_ID_FRONT (IPOD_CATEGORY) cat,
                    (U32) index);

            ETG_TRACE_USR3(("iPodControlIAP::SelectDBRecord() iPodSelectDBRecord(cat %d, index %d) returned %d", cat, index, res));
        }
        if(IPOD_OK != res) {
            UpdateIpodCommunicationError(res);
        }
    } else {
        ETG_TRACE_USR3(("iPodControlIAP::SelectDBRecord() invalid parameter, index %d", index));
    }
    return (IPOD_OK == res);
}

tBoolean iPodControlIAP::RetrieveName(const iPodControlMediaPath path,
        const int index, tMetadata &name) {
    ENTRY;
    VARTRACE(index);

    tBoolean res = true;

    int count = path.GetCurrentCount();
    if (count > 0 && index >= 0 && index < count) {

        if (path.IsDBPath()) {
            tIPODDBRecords dbrecords;

            res = RetrieveCategorizedDBRecords(&dbrecords,
                    path.GetCurrentIPODCategory(), index, 1);
            if (!res) {
                ETG_TRACE_ERR(("%s - RetrieveCategorizedDBRecords failed", __PRETTY_FUNCTION__));
            } else {
                map<int, string>::iterator it = dbrecords.find(index);
                if (it == dbrecords.end()) {
                    ETG_TRACE_ERR(("%s - No entry", __PRETTY_FUNCTION__));
                    res = false;
                } else {
                    strncpy_r(name, it->second.c_str(), sizeof(name));
                }
            }
        } else {
            tMetadata meta = { 0 };
            res = GetPlayingTitle(meta, index);
            if (!res) {
                ETG_TRACE_ERR(("%s - GetPlayingTitle failed", __PRETTY_FUNCTION__));
            } else {
                strncpy_r(name, meta, sizeof(name));
            }
        }
    } else {
        res = false;
        ETG_TRACE_ERR(("%40s - invalid parameter: count=%d, index=%d", __PRETTY_FUNCTION__, count, index));
    }
    VARTRACE(name);
    return res;
}

tBoolean iPodControlIAP::RetrieveCategorizedDBRecords(tIPODDBRecords *pRecords,
        const int cat, const int index, const int count) {
    ENTRY;
    VARTRACE(cat);
    VARTRACE(index);
    VARTRACE(count);

    int res = IPOD_ERROR;

    if (pRecords && cat > 0 && count > 0 && index >= 0) {
        pRecords->clear();
#ifndef TARGET_BUILD_GEN3
        const U32 iPodID = 1; //only one single entry in Gen2 PF possible
#else
        const U32 iPodID = (U32)m_HandleMap.GetiPodID(m_MountPoint);
#endif
        mMapMutex.lock();
        mDBRecordPtrMap[iPodID] = pRecords;
        mMapMutex.unlock();

        res = iPodRetrieveCategorizedDBRecords(
                IPODCONTROL_ID_FRONT (IPOD_CATEGORY) cat, (U32) index,
                (S32) count, CBIAP1_RetrieveCategorizedDBRecord);

        if(IPOD_OK != res) {
            UpdateIpodCommunicationError(res);
        }

        mMapMutex.lock();
        mDBRecordPtrMap[iPodID] = 0;
        mMapMutex.unlock();
    }

    ETG_TRACE_USR3(("iPodControlIAP::RetrieveCategorizedDBRecords() iPodRetrieveCategorizedDBRecords returned %d", res));
    return (IPOD_OK == res);
}

tBoolean iPodControlIAP::GetTrackInfo(tIPODTrackInfos *pTrackInfos,
        const IPOD_TRACK_INFORMATION_BITFIELD bitfield, const int index,
        const int count, const bool fromDB) {
    ENTRY;
    int res = IPOD_ERROR;

    ETG_TRACE_USR3(("GetTrackInfo() BITFIELD=0x%08x INDEX=%d COUNT=%d", (U32)bitfield.bitmask, index, count));

    if (pTrackInfos && bitfield.bitmask > 0 && count > 0 && index >= 0) {
        pTrackInfos->clear();
#ifndef TARGET_BUILD_GEN3
        const U32 iPodID = 1; //only one single entry in Gen2 PF possible
#else
        const U32 iPodID = (U32)m_HandleMap.GetiPodID(m_MountPoint);
#endif
        mMapMutex.lock();
        mTrackInfoPtrMap[iPodID] = pTrackInfos;
        mMapMutex.unlock();

        if (fromDB) {
            res = iPodGetBulkDBTrackInfo(IPODCONTROL_ID_FRONT (U32) index,
                    (S32) count, bitfield, CBIAP1_TrackInfo);
        } else {
            res = iPodGetBulkPBTrackInfo(IPODCONTROL_ID_FRONT (U32) index,
                    (S32) count, bitfield, CBIAP1_TrackInfo);
        }

        if(IPOD_OK != res) {
            UpdateIpodCommunicationError(res);
        }

        mMapMutex.lock();
        mTrackInfoPtrMap[iPodID] = 0;
        mMapMutex.unlock();
    }

    ETG_TRACE_USR3(("iPodControlIAP::GetTrackInfo() iPodGetBulkXBTrackInfo returned %d", res));
    return (IPOD_OK == res);
}

tBoolean iPodControlIAP::ResetDBSelection(iPodControlMediaPath &path) {
    ENTRY;
    int res = IPOD_ERROR;
    tIPODDBHierarchy hierarchy = path.IsVideo() ? IPOD_DB_HIERARCHY_VIDEO : IPOD_DB_HIERARCHY_AUDIO;
    if (m_HandleMap.GetOption(m_MountPoint, hasVideoOption)) {
        res = iPodResetDBSelectionHierarchy(IPODCONTROL_ID_FRONT (U8) hierarchy);
        ETG_TRACE_USR3(("iPodControlIAP::ResetDBSelection() iPodResetDBSelectionHierarchy(%d) returned %d", hierarchy, res));
    } else if (IPOD_DB_HIERARCHY_VIDEO == hierarchy) {
        ETG_TRACE_ERR(("iPodControlIAP::ResetDBSelection() video not supported"));
    } else {
        res = iPodResetDBSelection(IPODCONTROL_ID_ONLY);
        ETG_TRACE_USR3(("iPodControlIAP::ResetDBSelection() iPodResetDBSelection returned %d", res));
    }

    if(IPOD_OK != res) {
        UpdateIpodCommunicationError(res);
    }
    path.ResetSelection();
    return (IPOD_OK == res);
}

int iPodControlIAP::GetNumberCategorizedDBRecords(const int cat) {
    ENTRY;
    int res = IPOD_ERROR;
    //ATS 3.1.1 - not requires a delay call by 1000ms
    res = iPodGetNumberCategorizedDBRecords(
            IPODCONTROL_ID_FRONT (IPOD_CATEGORY) cat);

    ETG_TRACE_USR3(("iPodControlIAP::GetNumberCategorizedDBRecords() iPodGetNumberCategorizedDBRecords returned %d", res));
    return res;
}

void iPodControlIAP::iAPSetPlaybackModeFromIPOD(const tMountPoint mountPoint, const int playbackMode)
{
    ENTRY;
    //private: map playbackMode to IPOD_SHUFFLE_MODE
    VARTRACE(mountPoint);
    VARTRACE(playbackMode);

    switch(playbackMode) {
    case IPOD_SHUFFLE_OFF:
    //case IAP2_SHUFFLE_OFF:
        m_HandleMap.SetPlaybackMode(mountPoint, PBM_NORMAL);
        break;
    case IPOD_SHUFFLE_TRACKS:
    case IPOD_SHUFFLE_ALBUMS:
    //case IAP2_SHUFFLE_SONGS:
    //case IAP2_SHUFFLE_ALBUMS:
    default:
        m_HandleMap.SetPlaybackMode(mountPoint, PBM_RANDOM);
        break;
    }
}

void iPodControlIAP::iAPSetRepeatModeFromIPOD(const tMountPoint mountPoint, const int repeatMode)
{
    ENTRY;
    //private: map repeatMode mode to IPOD_REPEAT_MODE
    VARTRACE(mountPoint);
    VARTRACE(repeatMode);

    switch(repeatMode) {
    case IPOD_REPEAT_OFF:
    //case IAP2_REPEAT_OFF:
        m_HandleMap.SetRepeatMode(mountPoint, RPT_NONE);
        break;
    case IPOD_REPEAT_ONE_TRACK:
    //case IAP2_REPEAT_ONE:
        m_HandleMap.SetRepeatMode(mountPoint, RPT_ONE);
        break;
    case IPOD_REPEAT_ALL_TRACKS:
    //case IAP2_REPEAT_ALL:
    default:
        m_HandleMap.SetRepeatMode(mountPoint, RPT_LIST);
        break;
    }
}

void iPodControlIAP::iAPSetRepeatInitFlag(const tMountPoint mountPoint,const bool repeatInitFlag)
{
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(repeatInitFlag);

    m_HandleMap.SetRepeatInitFlag(mountPoint,repeatInitFlag);
}

tResult iPodControlIAP::iAPSetPlaybackMode(const tMountPoint mountPoint, const tPlaybackMode playbackMode)
{
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(playbackMode);
    tResult ret = MP_NO_ERROR;

    if(m_HandleMap.GetPlaybackMode(mountPoint) == playbackMode) {
        ETG_TRACE_USR3(("PlaybackMode no change"));
    } else if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        //send iAP command, notifications expected
        m_HandleMap.ResetElapsedTime(m_MountPoint, pbNotifications);
        int res = IPOD_OK;
        if(IsIAP2(mountPoint)) {
            if(!SendMediaPlaybackHIDReport(IPOD_HID_REPORT_SHUFFLE)) {
                ETG_TRACE_ERR(("SendMediaPlaybackHIDReport failed"));
                ret = MP_ERR_IPOD_COMMAND;
            } else if(!SendMediaPlaybackHIDReport(IPOD_HID_REPORT_BUTTON_RELEASED)) {
                ETG_TRACE_ERR(("SendMediaPlaybackHIDReport failed"));
                ret = MP_ERR_IPOD_COMMAND;
            }
        } else {
            switch(playbackMode) {
            case PBM_NORMAL:
                res = iPodShuffleOff(IPODCONTROL_ID_ONLY);
                break;
            case PBM_RANDOM:
                res = iPodShuffleOnSongs(IPODCONTROL_ID_ONLY);
                break;
            default:
                ETG_TRACE_ERR(("Unsupported playback mode"));
                ret = MP_ERR_IPOD_INVALID_PARAM;
                break;
            }
        }
        if (IPOD_OK != res) {
            ETG_TRACE_ERR(("iPodControlIAP::iAPSetPlaybackMode() failed with IPOD ERROR %d", res));
            ret = MP_ERR_IPOD_COMMAND;
            UpdateIpodCommunicationError(res);
        }
    }
    return ret;
}

tPlaybackMode iPodControlIAP::iAPGetPlaybackMode(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetPlaybackMode(mountPoint);
}

tResult iPodControlIAP::iAPSetRepeatMode(const tMountPoint mountPoint, const tRepeatMode repeatMode)
{
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(repeatMode);
    tResult ret = MP_NO_ERROR;

    tRepeatMode last_repeatMode = m_HandleMap.GetRepeatMode(mountPoint);
    VARTRACE(last_repeatMode);
    if(last_repeatMode == repeatMode) {
        ETG_TRACE_USR3(("iPodControlIAP::iAPSetRepeatMode() no change"));
    } else if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        //send iAP command, notifications expected
        m_HandleMap.ResetElapsedTime(m_MountPoint, pbNotifications);
        int res = IPOD_OK;
        if(IsIAP2(mountPoint)) {

            if(LocalSPM::GetDataProvider().iPodRepeatModeSequence_1()){                    // For all other projects
                //The order of the repeat mode is changed. Also only three states are there
                //One button, but three states: RPT_NONE, RPT_LIST, RPT_ONE
                //Toggle through the values

                const int buttonClicks[][5] = { {0,2,1,2,2},
                                                {1,0,2,1,1},
                                                {2,1,0,0,0},
                                                {1,2,0,0,0},
                                                {1,2,0,0,0}};
                if(!LocalSPM::GetDataProvider().iPodControlIAP2RepeatDisabled() && last_repeatMode < 5 && repeatMode < 5) {
                    VARTRACE(buttonClicks[last_repeatMode][repeatMode]);
                    for(int i = 0; i < buttonClicks[last_repeatMode][repeatMode]; i++) {
                        if(!SendMediaPlaybackHIDReport(IPOD_HID_REPORT_REPEAT)) {
                            ETG_TRACE_ERR(("SendMediaPlaybackHIDReport failed"));
                            ret = MP_ERR_IPOD_COMMAND;
                        } else if(!SendMediaPlaybackHIDReport(IPOD_HID_REPORT_BUTTON_RELEASED)) {
                            ETG_TRACE_ERR(("SendMediaPlaybackHIDReport failed"));
                            ret = MP_ERR_IPOD_COMMAND;
                        }
                    }
                } else {
                    ETG_TRACE_ERR(("Unsupported repeat mode"));
                    ret = MP_ERR_IPOD_INVALID_PARAM;
                }
            }
            else if(LocalSPM::GetDataProvider().iPodRepeatModeSequence_2()){                 // PSA

                //One button, but three states: RPT_NONE, RPT_ONE, RPT_LIST
                //Toggle thru the values

                const int buttonClicks[][5] = { {0,1,2,2,2},
                                                {2,0,1,1,1},
                                                {1,2,0,0,0},
                                                {1,2,0,0,0},
                                                {1,2,0,0,0}};
                if(!LocalSPM::GetDataProvider().iPodControlIAP2RepeatDisabled() && last_repeatMode < 5 && repeatMode < 5) {
                    VARTRACE(buttonClicks[last_repeatMode][repeatMode]);
                    for(int i = 0; i < buttonClicks[last_repeatMode][repeatMode]; i++) {
                        if(!SendMediaPlaybackHIDReport(IPOD_HID_REPORT_REPEAT)) {
                            ETG_TRACE_ERR(("SendMediaPlaybackHIDReport failed"));
                            ret = MP_ERR_IPOD_COMMAND;
                        } else if(!SendMediaPlaybackHIDReport(IPOD_HID_REPORT_BUTTON_RELEASED)) {
                            ETG_TRACE_ERR(("SendMediaPlaybackHIDReport failed"));
                            ret = MP_ERR_IPOD_COMMAND;
                        }
                    }
                } else {
                    ETG_TRACE_ERR(("Unsupported repeat mode"));
                    ret = MP_ERR_IPOD_INVALID_PARAM;
                }
            }

        } else {
            switch(repeatMode) {
            case RPT_NONE:
                res = iPodRepeatOff(IPODCONTROL_ID_ONLY);
                break;
            case RPT_ONE:
                res = iPodRepeatCurrentSong(IPODCONTROL_ID_ONLY);
                break;
            case RPT_LIST:
            case RPT_LIST_WITH_SUBLISTS:
            case RPT_ALL:
                res = iPodRepeatAllSongs(IPODCONTROL_ID_ONLY);
                break;
            default:
                ETG_TRACE_ERR(("Unsupported repeat mode"));
                ret = MP_ERR_IPOD_INVALID_PARAM;
                break;
            }
        }
        if (IPOD_OK != res) {
            ETG_TRACE_ERR(("iPodControlIAP::iAPSetRepeatMode() failed with IPOD ERROR %d", res));
            ret = MP_ERR_IPOD_COMMAND;
            UpdateIpodCommunicationError(res);
        }
    }
    return ret;
}

tRepeatMode iPodControlIAP::iAPGetRepeatMode(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetRepeatMode(mountPoint);
}

bool iPodControlIAP::iAPGetRepeatInitFlag(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetRepeatInitFlag(mountPoint);
}

tDiPOCallState iPodControlIAP::iAPGetCallState(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetCallState(mountPoint);
}

tDiPOCallStateItem iPodControlIAP::iAP2GetCallStateByUUID(const tMountPoint mountPoint, tGeneralString const callUUID)
{
    ENTRY_INTERNAL;
    return m_HandleMap.GetCallStateByUUID(mountPoint, callUUID);
}

void iPodControlIAP::iAP2UpdateOrInsertCallState(const tMountPoint mountPoint, tDiPOCallStateItem const callStateItem)
{
    ENTRY_INTERNAL;
    if(callStateItem.callUUID[0] != 0) { //filter emtpy CallUUIDs
        m_HandleMap.UpdateOrInsertCallState(mountPoint, callStateItem);
    }
}

void iPodControlIAP::iAP2UpdateCallDuration(const tMountPoint mountPoint, const U32 callDuration)
{
    ENTRY_INTERNAL;
    m_HandleMap.UpdateCallDuration(mountPoint, callDuration);
}
U32 iPodControlIAP::iAPGetCallDuration(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetCallDuration(mountPoint);
}

void iPodControlIAP::iAP2RemoveDisconnectedCallState(const tMountPoint mountPoint)
{
    ENTRY_INTERNAL;
    m_HandleMap.RemoveDisconnectedCallState(mountPoint);
}


tDiPOCommunications iPodControlIAP::iAPGetCommunications(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetCommunications(mountPoint);
}

void iPodControlIAP::iAPSetCommunications(const tMountPoint mountPoint, const tDiPOCommunications comm) {
    ENTRY_INTERNAL;
    m_HandleMap.SetCommunications(mountPoint, comm);
}

tBTProfile iPodControlIAP::iAPGetBTProfile(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetBTProfile(mountPoint);
}

void iPodControlIAP::iAPSetBTProfile(const tMountPoint mountPoint, const tBTProfile btProfile) {
    ENTRY_INTERNAL;
    m_HandleMap.SetBTProfile(mountPoint, btProfile);
}

tBoolean iPodControlIAP::iAPIsStreaming(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return IsStreaming(mountPoint);
}

tPEHandle iPodControlIAP::iAPGetPEHandle(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetPEHandle(mountPoint);
}

tBoolean iPodControlIAP::iAPIsRCSupported(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetOption(mountPoint, hasRemoteControlOption);
}

void iPodControlIAP::iAPSetStreaming(const tMountPoint mountPoint, const tBoolean set) {
    ENTRY_INTERNAL;
    m_HandleMap.SetStreamingMode(mountPoint, set);
}

void iPodControlIAP::iAPSetPEHandle(const tMountPoint mountPoint, const tPEHandle handle) {
    ENTRY_INTERNAL;
    m_HandleMap.SetPEHandle(mountPoint, handle);
}

tBoolean iPodControlIAP::IsStreaming(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return (m_HandleMap.GetStreamingMode(mountPoint)/* || LocalSPM::GetDataProvider().IsPermanentStreamingActive(DTY_IPOD)*/);
}

tBoolean iPodControlIAP::SendMediaPlaybackHIDReport(const IPOD_HID_REPORT report) {
    ENTRY;
    VARTRACE((int)report);
    tBoolean ret = false;
#ifdef IPODCONTROL_IAP2_PF_AVAIL

    //check for redundant button release reports
    IPOD_HID_REPORT lastReport = m_HandleMap.GetLastHIDReport(m_MountPoint);
    VARTRACE(lastReport);
    if(lastReport == IPOD_HID_REPORT_BUTTON_RELEASED && report == IPOD_HID_REPORT_BUTTON_RELEASED) {
        ETG_TRACE_USR3(("Skipping redundant IPOD_HID_REPORT_BUTTON_RELEASED"));
        return true;
    }
    m_HandleMap.LockIAP2(m_MountPoint); //start critical section
    iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(m_MountPoint);
    if(!iap2Device) {
        ETG_TRACE_ERR(("!iap2Device"));
    } else {
        //send accessory HID report
        iAP2AccessoryHIDReportParameter accessoryHIDReportParameter;
        memset(&accessoryHIDReportParameter, 0, sizeof(iAP2AccessoryHIDReportParameter));
        accessoryHIDReportParameter.iAP2HIDComponentIdentifier = new U16[1];
        if(accessoryHIDReportParameter.iAP2HIDComponentIdentifier != NULL) {
            accessoryHIDReportParameter.iAP2HIDComponentIdentifier[0] = IAP2_HID_COMPONENT_IDENTIFIER;
            accessoryHIDReportParameter.iAP2HIDComponentIdentifier_count++;
        }
        accessoryHIDReportParameter.iAP2HIDReport = new iAP2Blob[sizeof(iAP2Blob)];
        if(accessoryHIDReportParameter.iAP2HIDReport != NULL) {
            memset(accessoryHIDReportParameter.iAP2HIDReport, 0, sizeof(iAP2Blob) );
            accessoryHIDReportParameter.iAP2HIDReport_count++;

            size_t size = 1; //1-Byte form for media playback commands
            accessoryHIDReportParameter.iAP2HIDReport[0].iAP2BlobData = new U8[size];
            if(accessoryHIDReportParameter.iAP2HIDReport[0].iAP2BlobData != NULL) {
                memset(accessoryHIDReportParameter.iAP2HIDReport[0].iAP2BlobData, 0, size);
                accessoryHIDReportParameter.iAP2HIDReport[0].iAP2BlobData[0] = report;
                accessoryHIDReportParameter.iAP2HIDReport[0].iAP2BlobLength = size;
            }
        }
        //send iAP2 HID command, notifications expected
        m_HandleMap.ResetElapsedTime(m_MountPoint, pbNotifications);

        int res = iAP2AccessoryHIDReport(iap2Device, &accessoryHIDReportParameter);
        ETG_TRACE_USR3(("iAP2AccessoryHIDReport returned %d", res));
        iAP2FreeiAP2AccessoryHIDReportParameter(&accessoryHIDReportParameter);
        if(IAP2_OK != res) {
            UpdateIpodCommunicationError(res);
        }
        ret = (IAP2_OK == res);

        //store last HID command
        m_HandleMap.SetLastHIDReport(m_MountPoint, report);
    }
    m_HandleMap.UnlockIAP2(m_MountPoint); //end critical section
#endif
    return ret;
}

void iPodControlIAP::iAPSetMediaLibraryUID(const tMountPoint mountPoint, const char * uid) {
    ENTRY_INTERNAL;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        pcontext->SetMediaLibraryUID(uid);
    }
    m_HandleMap.UnlockIndexer(mountPoint);
}

void iPodControlIAP::iAPGetMediaLibraryUID(const tMountPoint mountPoint, tFingerprint &mediaLibraryUID) {
    ENTRY_INTERNAL;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        pcontext->GetMediaLibraryUID(mediaLibraryUID);
    }
    m_HandleMap.UnlockIndexer(mountPoint);
}

void iPodControlIAP::iAPSetiTunesRadioLibraryUID(const tMountPoint mountPoint, const char * uid) {
    ENTRY_INTERNAL;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        pcontext->SetiTunesRadioLibraryUID(uid);
    }
    m_HandleMap.UnlockIndexer(mountPoint);
}

void iPodControlIAP::iAPGetiTunesRadioLibraryUID(const tMountPoint mountPoint, tFingerprint &iTunesRadioLibraryUID) {
    ENTRY_INTERNAL;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        pcontext->GetiTunesRadioLibraryUID(iTunesRadioLibraryUID);
    }
    m_HandleMap.UnlockIndexer(mountPoint);
}

void iPodControlIAP::iAPSetNowPlayingLibraryUID(const tMountPoint mountPoint, const char * uid) {
    ENTRY_INTERNAL;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        pcontext->SetNowPlayingLibraryUID(uid);
    }
    m_HandleMap.UnlockIndexer(mountPoint);
}

void iPodControlIAP::iAPGetNowPlayingLibraryUID(const tMountPoint mountPoint, tFingerprint &NowPlayingLibraryUID) {
    ENTRY_INTERNAL;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        pcontext->GetNowPlayingLibraryUID(NowPlayingLibraryUID);
    }
    m_HandleMap.UnlockIndexer(mountPoint);
}

void iPodControlIAP::iAPSetMediaLibraryRevision(const tMountPoint mountPoint, const char * Revision) {
    ENTRY_INTERNAL;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        pcontext->SetMediaLibraryRevision(Revision);
    }
    m_HandleMap.UnlockIndexer(mountPoint);
}

void iPodControlIAP::iAPGetMediaLibraryRevision(const tMountPoint mountPoint, tFingerprint &mediaLibraryRevision) {
    ENTRY_INTERNAL;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        pcontext->GetMediaLibraryRevision(mediaLibraryRevision);
    }
    m_HandleMap.UnlockIndexer(mountPoint);
}

void iPodControlIAP::iAPSetiTunesRadioLibraryRevision(const tMountPoint mountPoint, const char * Revision) {
    ENTRY_INTERNAL;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        pcontext->SetiTunesRadioLibraryRevision(Revision);
    }
    m_HandleMap.UnlockIndexer(mountPoint);
}

void iPodControlIAP::iAPGetiTunesRadioLibraryRevision(const tMountPoint mountPoint, tFingerprint &iTunesRadioLibraryRevision) {
    ENTRY_INTERNAL;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        pcontext->GetiTunesRadioLibraryRevision(iTunesRadioLibraryRevision);
    }
    m_HandleMap.UnlockIndexer(mountPoint);
}

void iPodControlIAP::iAPSetMediaLibraryReset(const tMountPoint mountPoint, const bool isReset)
{
    ENTRY_INTERNAL;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        pcontext->SetMediaLibraryReset(isReset);
    }
    m_HandleMap.UnlockIndexer(mountPoint);
}

bool iPodControlIAP::iAPGetMediaLibraryReset(const tMountPoint mountPoint)
{
    ENTRY_INTERNAL;
    bool isReset = false;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        isReset = pcontext->IsMediaLibraryReset();
    }
    m_HandleMap.UnlockIndexer(mountPoint);
    return isReset;
}

void iPodControlIAP::iAPSetMediaLibraryUpdateProgress(const tMountPoint mountPoint, const int progress) {
    ENTRY_INTERNAL;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        pcontext->SetMediaLibraryUpdateProgress(progress);
    }
    m_HandleMap.UnlockIndexer(mountPoint);
}

int iPodControlIAP::iAPGetMediaLibraryUpdateProgress(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    int progress = 0;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        progress = pcontext->GetMediaLibraryUpdateProgress();
    }
    m_HandleMap.UnlockIndexer(mountPoint);
    return progress;
}

void iPodControlIAP::iAPSetiTunesRadioLibraryUpdateProgress(const tMountPoint mountPoint, const int progress) {
    ENTRY_INTERNAL;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        pcontext->SetiTunesRadioLibraryUpdateProgress(progress);
    }
    m_HandleMap.UnlockIndexer(mountPoint);
}

int iPodControlIAP::iAPGetiTunesRadioLibraryUpdateProgress(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    int progress = 0;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        progress = pcontext->GetiTunesRadioLibraryUpdateProgress();
    }
    m_HandleMap.UnlockIndexer(mountPoint);
    return progress;
}

tBoolean iPodControlIAP::iAPIsMediaLibraryUpdateCompleted(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    tBoolean ret = true;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        ret = pcontext->GetPlaylistFileTransferObjectListSize() == 0 && pcontext->GetMediaLibraryUpdateProgress() >= 100;
    }
    m_HandleMap.UnlockIndexer(mountPoint);
    return ret;
}

int iPodControlIAP::iAPIndexerGetTrackCount(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    int count = 0;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        count = pcontext->GetTrackCount();
    }
    m_HandleMap.UnlockIndexer(mountPoint);
    return count;
}

int iPodControlIAP::iAPIndexerGetVideoCount(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    int count = 0;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        count = pcontext->GetVideoCount();
    }
    m_HandleMap.UnlockIndexer(mountPoint);
    return count;
}

int iPodControlIAP::iAPIndexerGetPlaylistCount(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    int count = 0;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        count = pcontext->GetPlaylistCount();
    }
    m_HandleMap.UnlockIndexer(mountPoint);
    return count;
}

int iPodControlIAP::iAPIndexerGetChunkSize(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    int count = 0;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        count = pcontext->GetChunkSize();
    }
    m_HandleMap.UnlockIndexer(mountPoint);
    return count;
}

void iPodControlIAP::iAPIndexerSetFingerprint(const tMountPoint mountPoint, const char * fingerprint) {
    ENTRY_INTERNAL;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        pcontext->SetFingerprint(fingerprint);
    }
    m_HandleMap.UnlockIndexer(mountPoint);
}

void iPodControlIAP::iAPIndexerGetFingerprint(const tMountPoint mountPoint, tFingerprint &fingerprint) {
    ENTRY_INTERNAL;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        pcontext->GetFingerprint(fingerprint);
    }
    m_HandleMap.UnlockIndexer(mountPoint);
}

int iPodControlIAP::iAPIndexerGetCacheCount(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    int ret = 0;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        ret = pcontext->GetTotalCacheCount();
    }
    m_HandleMap.UnlockIndexer(mountPoint);
    return ret;
}

bool iPodControlIAP::iAPIndexerIsPaused(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    bool ret = false;
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
    } else {
        ret = pcontext->IsPaused();
    }
    m_HandleMap.UnlockIndexer(mountPoint);
    return ret;
}

void iPodControlIAP::iAPIndexerCheckResume(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    if(IsIAP2(mountPoint)) {
        m_HandleMap.LockIndexer(mountPoint);
        iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
        if(!pcontext) {
            ETG_TRACE_ERR(("GetIndexerContext failed"));
        } else {
            if(pcontext->IsPaused() && pcontext->GetTotalCacheCount() < LocalSPM::GetDataProvider().iPodControlIAP2IndexingCacheFloor()) {
                tFingerprint lastFingerprint = {0};
                pcontext->GetFingerprint(lastFingerprint);
                iAP2_CalcFingerPrint(mountPoint, lastFingerprint);
            }
        }
        m_HandleMap.UnlockIndexer(mountPoint);
    }
}

#ifdef IPODCONTROL_IAP2_PF_AVAIL
tBoolean iPodControlIAP::iAP2_PushMediaLibraryUpdate(const tMountPoint mountPoint, const iAP2MediaLibraryUpdateParameter *mediaLibraryUpdateParameter, const bool isiTunesRadioUpdate)
{
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(isiTunesRadioUpdate);
    tBoolean ret = true;

    if(!mediaLibraryUpdateParameter) {
        ETG_TRACE_ERR(("Invalid parameter"));
        return false;
    }

    const tDeviceID deviceID = m_HandleMap.GetDeviceID(mountPoint);

    //get and init indexer context
    m_HandleMap.LockIndexer(mountPoint);
    iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
    if(!pcontext) {
        ETG_TRACE_ERR(("GetIndexerContext failed"));
        ret = false;
    } else {
        bool isMediaLibraryReset = pcontext->IsMediaLibraryReset();
        VARTRACE(isMediaLibraryReset);
        //media items to be deleted
        VARTRACE(mediaLibraryUpdateParameter->iAP2MediaItemDeletePersistentIdentifier_count);
        if (!isMediaLibraryReset) {
            for(int i = 0; i < mediaLibraryUpdateParameter->iAP2MediaItemDeletePersistentIdentifier_count; i++) {
                VARTRACE(mediaLibraryUpdateParameter->iAP2MediaItemDeletePersistentIdentifier[i]);
                //set the mediaobject
                tMediaObjectPtr mediaObjectPtr = new tMediaObject; //Attention: Has to be deleted by Indexer::CheckMetadata
                if (!mediaObjectPtr) {
                    ETG_TRACE_ERR(("No memory"));
                    ret = false;
                    break;
                }
                //set general parameter
                InitMediaObject(OUT *mediaObjectPtr);
                snprintf(mediaObjectPtr->UUID, sizeof(mediaObjectPtr->UUID), IPODCONTROL_UUID_FORMAT, mediaLibraryUpdateParameter->iAP2MediaItemDeletePersistentIdentifier[i]);
                //push back to indexer context cache
                pcontext->PushObject(mediaObjectPtr, MDS_REMOVED);
            } //lint !e429 deleted by Indexer
        }

        //playlist items to be deleted
        VARTRACE(mediaLibraryUpdateParameter->iAP2MediaPlaylistDeletePersistentIdentifier_count);
        if (!isMediaLibraryReset) {
            for(int i = 0; i < mediaLibraryUpdateParameter->iAP2MediaPlaylistDeletePersistentIdentifier_count; i++) {
                VARTRACE(mediaLibraryUpdateParameter->iAP2MediaPlaylistDeletePersistentIdentifier[i]);
                //set the mediaobject
                tMediaObjectPtr mediaObjectPtr = new tMediaObject; //Attention: Has to be deleted by Indexer::CheckMetadata
                if (!mediaObjectPtr) {
                    ETG_TRACE_ERR(("No memory"));
                    ret = false;
                    break;
                }
                //set general parameter
                InitMediaObject(OUT *mediaObjectPtr);
                snprintf(mediaObjectPtr->UUID, sizeof(mediaObjectPtr->UUID), IPODCONTROL_UUID_FORMAT, mediaLibraryUpdateParameter->iAP2MediaPlaylistDeletePersistentIdentifier[i]);
                //push back to indexer context cache
                pcontext->PushObject(mediaObjectPtr, MDS_REMOVED);
            } //lint !e429 deleted by Indexer
        }

        //media items to be added
        iPodControlMediaPath path(LTY_SONG);
        int trackIndex = pcontext->GetTrackIndex();
        pcontext->SetTrackCount(pcontext->GetTrackCount() + mediaLibraryUpdateParameter->iAP2MediaItem_count);
        VARTRACE(mediaLibraryUpdateParameter->iAP2MediaItem_count);

        iAP2MediaItem* mup = mediaLibraryUpdateParameter->iAP2MediaItem;
        for(int i = 0; ret && i < mediaLibraryUpdateParameter->iAP2MediaItem_count && mup; i++, trackIndex++) {

            //gather information
            if(!(mup[i].iAP2MediaItemPersistentIdentifier_count && mup[i].iAP2MediaItemPersistentIdentifier)) { //mandatory! [GMMY16-27627, GMMY17-12314]
                ETG_TRACE_ERR(("iAP2MediaItemPersistentIdentifier is invalid"));
            } else {
                VARTRACE(mup[i].iAP2MediaItemPersistentIdentifier[0]);

                //set the mediaobject
                tMediaObjectPtr mediaObjectPtr = new tMediaObject; //Attention: Has to be deleted by Indexer::CheckMetadata
                if (!mediaObjectPtr) {
                    ETG_TRACE_ERR(("No memory"));
                    ret = false;
                    break;
                }
                //set general parameter
                InitMediaObject(OUT *mediaObjectPtr);
                strncpy_r(mediaObjectPtr->mountPoint, mountPoint, sizeof(mediaObjectPtr->mountPoint));
                mediaObjectPtr->deviceID = deviceID;

                path.GetURL(mediaObjectPtr->fileName, -1, -1, mup[i].iAP2MediaItemPersistentIdentifier[0], 0ULL, mup[i].iAP2MediaItemTitle_count ? (const char *)mup[i].iAP2MediaItemTitle[0] : "");
                strncpy_r(mediaObjectPtr->albumArtString, mediaObjectPtr->fileName, sizeof(mediaObjectPtr->albumArtString));
                if(mup[i].iAP2MediaItemPersistentIdentifier[0] > 0) {
                    snprintf(mediaObjectPtr->UUID, sizeof(mediaObjectPtr->UUID), IPODCONTROL_UUID_FORMAT, mup[i].iAP2MediaItemPersistentIdentifier[0]);
                }

                mediaObjectPtr->fileFormat = FFT_UNKNOWN;
                mediaObjectPtr->mediaType = MTY_UNKNOWN;
                mediaObjectPtr->fileType = FT_UNKNOWN;
                mediaObjectPtr->catType = CTY_NONE;
                for(int j = 0; j < mup[i].iAP2MediaItemMediaType_count; j++) {
                    VARTRACE((int)mup[i].iAP2MediaItemMediaType[j]);
                    if(mediaObjectPtr->mediaType == MTY_UNKNOWN) { //process first valid media type
                        switch(mup[i].iAP2MediaItemMediaType[j] & 0xff) {
                        case IAP2_MEDIA_TYPE_PODCAST:
                            mediaObjectPtr->mediaType = MTY_PODCAST;
                            mediaObjectPtr->fileType = FT_AUDIO;
                            mediaObjectPtr->catType = CTY_PODCAST;
                            break;
                        case IAP2_MEDIA_TYPE_AUDIOBOOK:
                            mediaObjectPtr->mediaType = MTY_AUDIOBOOK;
                            mediaObjectPtr->fileType = FT_AUDIO;
                            mediaObjectPtr->catType = CTY_AUDIOBOOK;
                            break;
                        case IAP2_MEDIA_TYPE_MUSIC:
                        case IAP2_MEDIA_TYPE_ITUNES_U:
                        default:
                            mediaObjectPtr->mediaType = MTY_MUSIC_FILE;
                            mediaObjectPtr->fileType = FT_AUDIO;
                            mediaObjectPtr->catType = CTY_SONG;
                            break;
                        }
                    }
                }

                if(mup[i].iAP2MediaItemTitle_count) {
                    VARTRACE(mup[i].iAP2MediaItemTitle[0]);
                    strncpy_r(mediaObjectPtr->title, (const char*)mup[i].iAP2MediaItemTitle[0], sizeof(mediaObjectPtr->title));
                }

                if(mup[i].iAP2MediaItemRating_count) {
                    VARTRACE(mup[i].iAP2MediaItemRating[0]);
                }
                if(mup[i].iAP2MediaItemPlaybackDurationInMilliseconds_count) {
                    VARTRACE(mup[i].iAP2MediaItemPlaybackDurationInMilliseconds[0]);
                    mediaObjectPtr->totalPlaytime = (tPlaytime)mup[i].iAP2MediaItemPlaybackDurationInMilliseconds[0];
                }
                if(mup[i].iAP2MediaItemAlbumPersistentIdentifier_count) {
                    VARTRACE(mup[i].iAP2MediaItemAlbumPersistentIdentifier[0]);
                }
                if(mup[i].iAP2MediaItemAlbumTitle_count) {
                    VARTRACE(mup[i].iAP2MediaItemAlbumTitle[0]);
                    switch(mediaObjectPtr->mediaType) {
                    case MTY_PODCAST:
                        strncpy_r(mediaObjectPtr->MetadataField1, (const char*)mup[i].iAP2MediaItemAlbumTitle[0], sizeof(mediaObjectPtr->MetadataField1));
                        break;
                    case MTY_AUDIOBOOK:
                        strncpy_r(mediaObjectPtr->MetadataField2, (const char*)mup[i].iAP2MediaItemAlbumTitle[0], sizeof(mediaObjectPtr->MetadataField2));
                        break;
                    default: //MTY_MUSIC_FILE
                        strncpy_r(mediaObjectPtr->MetadataField4, (const char*)mup[i].iAP2MediaItemAlbumTitle[0], sizeof(mediaObjectPtr->MetadataField4));
                        break;
                    }
                }
                if(mup[i].iAP2MediaItemAlbumTrackNumber_count) {
                    VARTRACE(mup[i].iAP2MediaItemAlbumTrackNumber[0]);
                    mediaObjectPtr->trackNumber = (tTrackNumber)mup[i].iAP2MediaItemAlbumTrackNumber[0];
                }
                if(mup[i].iAP2MediaItemAlbumTrackCount_count) {
                    VARTRACE(mup[i].iAP2MediaItemAlbumTrackCount[0]);
                }
                if(mup[i].iAP2MediaItemAlbumDiscNumber_count) {
                    VARTRACE(mup[i].iAP2MediaItemAlbumDiscNumber[0]);
                }
                if(mup[i].iAP2MediaItemAlbumDiscCount_count) {
                    VARTRACE(mup[i].iAP2MediaItemAlbumDiscCount[0]);
                }
                if(mup[i].iAP2MediaItemArtistPersistentIdentifier_count) {
                    VARTRACE(mup[i].iAP2MediaItemArtistPersistentIdentifier[0]);
                }
                if(mup[i].iAP2MediaItemArtist_count) {
                    VARTRACE(mup[i].iAP2MediaItemArtist[0]);
                    switch(mediaObjectPtr->mediaType) {
                    case MTY_PODCAST:
                        break;
                    case MTY_AUDIOBOOK:
                        strncpy_r(mediaObjectPtr->MetadataField1, (const char*)mup[i].iAP2MediaItemArtist[0], sizeof(mediaObjectPtr->MetadataField1));
                        break;
                    default: //MTY_MUSIC_FILE
                        strncpy_r(mediaObjectPtr->MetadataField2, (const char*)mup[i].iAP2MediaItemArtist[0], sizeof(mediaObjectPtr->MetadataField2));
                        break;
                    }
                }
                if(mup[i].iAP2MediaItemAlbumArtistPersistentIdentifier_count) {
                    VARTRACE(mup[i].iAP2MediaItemAlbumArtistPersistentIdentifier[0]);
                }
                if(mup[i].iAP2MediaItemAlbumArtist_count) {
                    VARTRACE(mup[i].iAP2MediaItemAlbumArtist[0]);
                }
                if(mup[i].iAP2MediaItemGenrePersistentIdentifier_count) {
                    VARTRACE(mup[i].iAP2MediaItemGenrePersistentIdentifier[0]);
                }
                if(mup[i].iAP2MediaItemGenre_count) {
                    VARTRACE(mup[i].iAP2MediaItemGenre[0]);
                    switch(mediaObjectPtr->mediaType) {
                    case MTY_PODCAST:
                        break;
                    case MTY_AUDIOBOOK:
                        break;
                    default: //MTY_MUSIC_FILE
                        strncpy_r(mediaObjectPtr->MetadataField1, (const char*)mup[i].iAP2MediaItemGenre[0], sizeof(mediaObjectPtr->MetadataField1));
                        break;
                    }
                }
                if(mup[i].iAP2MediaItemComposerPersistentIdentifier_count) {
                    VARTRACE(mup[i].iAP2MediaItemComposerPersistentIdentifier[0]);
                }
                if(mup[i].iAP2MediaItemComposer_count) {
                    VARTRACE(mup[i].iAP2MediaItemComposer[0]);
                    switch(mediaObjectPtr->mediaType) {
                    case MTY_PODCAST:
                        break;
                    case MTY_AUDIOBOOK:
                        break;
                    default: //MTY_MUSIC_FILE
                        strncpy_r(mediaObjectPtr->MetadataField3, (const char*)mup[i].iAP2MediaItemComposer[0], sizeof(mediaObjectPtr->MetadataField3));
                        break;
                    }
                }
                if(mup[i].iAP2MediaItemIsPartOfCompilation_count) {
                    VARTRACE(mup[i].iAP2MediaItemIsPartOfCompilation[0]);
                    mediaObjectPtr->compilationFlag=mup[i].iAP2MediaItemIsPartOfCompilation[0];
                }
                if(mup[i].iAP2MediaItemIsLikeSupported_count) {
                    VARTRACE(mup[i].iAP2MediaItemIsLikeSupported[0]);
                }
                if(mup[i].iAP2MediaItemIsBanSupported_count) {
                    VARTRACE(mup[i].iAP2MediaItemIsBanSupported[0]);
                }
                if(mup[i].iAP2MediaItemIsLiked_count) {
                    VARTRACE(mup[i].iAP2MediaItemIsLiked[0]);
                }
                if(mup[i].iAP2MediaItemIsBanned_count) {
                    VARTRACE(mup[i].iAP2MediaItemIsBanned[0]);
                }
                if(mup[i].iAP2MediaItemIsResidentOnDevice_count) {
                    VARTRACE(mup[i].iAP2MediaItemIsResidentOnDevice[0]);
                }
                if(mup[i].iAP2MediaItemArtworkFileTransferIdentifier_count) {
                    VARTRACE(mup[i].iAP2MediaItemArtworkFileTransferIdentifier[0]);
                }

                //push back to indexer context cache
                pcontext->PushObject(mediaObjectPtr, MDS_SUCCESS);
            } //lint !e429 deleted by Indexer
        }

        //playlist items to be added
        iPodControlMediaPath ppath(LTY_PLAYLIST);
        iPodControlMediaPath ippath(LTY_ITUNES_RADIO_STATION);
        int playlistIndex = pcontext->GetPlaylistIndex();
        pcontext->SetPlaylistCount(pcontext->GetPlaylistCount() + mediaLibraryUpdateParameter->iAP2MediaPlayList_count);
        VARTRACE(mediaLibraryUpdateParameter->iAP2MediaPlayList_count);

        iAP2MediaPlayList* mpp = mediaLibraryUpdateParameter->iAP2MediaPlayList;

        if(isiTunesRadioUpdate && mediaLibraryUpdateParameter->iAP2MediaLibraryReset_count) {
            //iTunesRadio full indexing: Reset Playlist entries, see DB trigger on CTY 11 for CTY 14
            //store a "Radio" dummy for all iTUnesRadio stations
            //set the mediaobject
            tMediaObjectPtr mediaObjectPtr = new tMediaObject; //Attention: Has to be deleted by Indexer::CheckMetadata
            if (!mediaObjectPtr) {
                ETG_TRACE_ERR(("No memory"));
                ret = false;
            } else {
                //set general parameter
                InitMediaObject(OUT *mediaObjectPtr);
                strncpy_r(mediaObjectPtr->mountPoint, mountPoint, sizeof(mediaObjectPtr->mountPoint));
                mediaObjectPtr->deviceID = deviceID;

                ppath.GetURL(mediaObjectPtr->fileName, -1, -1, IPODCONTROL_ITUNES_PLYLST_UUID, 0ULL, IPODCONTROL_ITUNES_PLYLST_NAME);
                strncpy_r(mediaObjectPtr->albumArtString, mediaObjectPtr->fileName, sizeof(mediaObjectPtr->albumArtString));
                snprintf(mediaObjectPtr->UUID, sizeof(mediaObjectPtr->UUID), IPODCONTROL_UUID_FORMAT, IPODCONTROL_ITUNES_PLYLST_UUID);

                mediaObjectPtr->fileFormat = FFT_UNKNOWN;
                mediaObjectPtr->catType = CTY_PLAYLIST;
                mediaObjectPtr->mediaType = MTY_PLAYLIST;
                mediaObjectPtr->fileType = FT_UNKNOWN;

                strncpy_r(mediaObjectPtr->MetadataField1, IPODCONTROL_ITUNES_PLYLST_NAME, sizeof(mediaObjectPtr->MetadataField1));
                strncpy_r(mediaObjectPtr->title, IPODCONTROL_ITUNES_PLYLST_NAME, sizeof(mediaObjectPtr->title));

                //push back to indexer context cache
                pcontext->PushObject(mediaObjectPtr, MDS_SUCCESS);
            }
        } //lint !e429 mediaObjectPtr Indexer::CheckMetadata

        for(int i = 0; ret && i < mediaLibraryUpdateParameter->iAP2MediaPlayList_count && mpp; i++, playlistIndex++) {

            //gather information
            if(mpp[i].iAP2MediaPlaylistPersistentIdentifier_count == 0) { //mandatory!
                ETG_TRACE_ERR(("iAP2MediaPlaylistPersistentIdentifier == 0"));
            } else {
                VARTRACE(mpp[i].iAP2MediaPlaylistPersistentIdentifier_count);
                VARTRACE(mpp[i].iAP2MediaPlaylistPersistentIdentifier[0]);

                //set the mediaobject
                tMediaObjectPtr mediaObjectPtr = new tMediaObject; //Attention: Has to be deleted by Indexer::CheckMetadata
                if (!mediaObjectPtr) {
                    ETG_TRACE_ERR(("No memory"));
                    ret = false;
                    break;
                }
                //set general parameter
                InitMediaObject(OUT *mediaObjectPtr);
                strncpy_r(mediaObjectPtr->mountPoint, mountPoint, sizeof(mediaObjectPtr->mountPoint));
                mediaObjectPtr->deviceID = deviceID;


                if(isiTunesRadioUpdate) {
                    ippath.GetURL(mediaObjectPtr->fileName, 0, -1, mpp[i].iAP2MediaPlaylistPersistentIdentifier[0], IPODCONTROL_ITUNES_PLYLST_UUID, mpp[i].iAP2MediaPlaylistName_count ? (const char *)mpp[i].iAP2MediaPlaylistName[0] : "");
                    snprintf(mediaObjectPtr->parentUUID, sizeof(mediaObjectPtr->parentUUID), IPODCONTROL_UUID_FORMAT, IPODCONTROL_ITUNES_PLYLST_UUID);
                    mediaObjectPtr->mediaType = MTY_UNKNOWN;
                    mediaObjectPtr->fileType = FT_AUDIO;
                    mediaObjectPtr->catType = CTY_PLAYLIST_ITEM;
                } else {
                    if(mpp[i].iAP2MediaPlaylistPersistentIdentifier[0] > 0) { // SUZUKI-27905
                       ppath.GetURL(mediaObjectPtr->fileName, -1, -1, mpp[i].iAP2MediaPlaylistPersistentIdentifier[0], 0ULL, "");
                    } else {
                       ppath.GetURL(mediaObjectPtr->fileName, -1, -1, mpp[i].iAP2MediaPlaylistPersistentIdentifier[0], 0ULL, mpp[i].iAP2MediaPlaylistName_count ? (const char *)mpp[i].iAP2MediaPlaylistName[0] : "");
                    }
                    mediaObjectPtr->catType = CTY_PLAYLIST;
                    mediaObjectPtr->mediaType = MTY_PLAYLIST;
                }

                strncpy_r(mediaObjectPtr->albumArtString, mediaObjectPtr->fileName, sizeof(mediaObjectPtr->albumArtString));
                if(mpp[i].iAP2MediaPlaylistPersistentIdentifier[0] > 0) {
                    snprintf(mediaObjectPtr->UUID, sizeof(mediaObjectPtr->UUID), IPODCONTROL_UUID_FORMAT, mpp[i].iAP2MediaPlaylistPersistentIdentifier[0]);
                }

                if(mpp[i].iAP2MediaPlaylistName_count) {
                    VARTRACE(mpp[i].iAP2MediaPlaylistName_count);
                    VARTRACE(mpp[i].iAP2MediaPlaylistName[0]);
                    strncpy_r(mediaObjectPtr->MetadataField1, (const char*)mpp[i].iAP2MediaPlaylistName[0], sizeof(mediaObjectPtr->MetadataField1));
                    strncpy_r(mediaObjectPtr->title, (const char*)mpp[i].iAP2MediaPlaylistName[0], sizeof(mediaObjectPtr->title));
                }

                if(mpp[i].iAP2MediaPlaylistParentPersistentIdentifer_count) {
                    VARTRACE(mpp[i].iAP2MediaPlaylistParentPersistentIdentifer_count);
                    VARTRACE(mpp[i].iAP2MediaPlaylistParentPersistentIdentifer[0]);
                }

                if(mpp[i].iAP2MediaPlaylistIsGeniusMix_count) {
                    VARTRACE(mpp[i].iAP2MediaPlaylistIsGeniusMix_count);
                    VARTRACE(mpp[i].iAP2MediaPlaylistIsGeniusMix[0]);
                }

                if(mpp[i].iAP2MediaPlaylistIsFolder_count) {
                    VARTRACE(mpp[i].iAP2MediaPlaylistIsFolder_count);
                    VARTRACE(mpp[i].iAP2MediaPlaylistIsFolder[0]);
                }

                if(mpp[i].iAP2MediaPlaylistContainedMediaItemsFileTransferIdentifier_count) {
                    VARTRACE(mpp[i].iAP2MediaPlaylistContainedMediaItemsFileTransferIdentifier_count);
                    VARTRACE(mpp[i].iAP2MediaPlaylistContainedMediaItemsFileTransferIdentifier[0]);
#if 1
                    if(!isiTunesRadioUpdate) {
                        //push back to indexer playlist cache
                        tPlaylistFileTransferObj obj;
                        obj.parentUUID = mpp[i].iAP2MediaPlaylistPersistentIdentifier[0];
                        obj.buffer = NULL;
                        obj.size = 0;
                        obj.rxLen = 0;
                        pcontext->PushPlaylistFileTransferObject(mpp[i].iAP2MediaPlaylistContainedMediaItemsFileTransferIdentifier[0], obj);
                    }
#endif
                }

                if(mpp[i].iAP2MediaPlaylistIsiTunesRadioStation_count) {
                    VARTRACE(mpp[i].iAP2MediaPlaylistIsiTunesRadioStation_count);
                    VARTRACE(mpp[i].iAP2MediaPlaylistIsiTunesRadioStation[0]);
                }

                //push back to indexer context cache
                pcontext->PushObject(mediaObjectPtr, MDS_SUCCESS);
            } //lint !e429 deleted by Indexer
        }

        pcontext->SetPlaylistIndex(playlistIndex);
        pcontext->SetTrackIndex(trackIndex);
        pcontext->SetRetrievError(!ret);

        if(mediaLibraryUpdateParameter->iAP2MediaLibraryUpdateProgress_count) {
            if(isiTunesRadioUpdate) {
                pcontext->SetiTunesRadioLibraryUpdateProgress(mediaLibraryUpdateParameter->iAP2MediaLibraryUpdateProgress[0]);
            } else {
                pcontext->SetMediaLibraryUpdateProgress(mediaLibraryUpdateParameter->iAP2MediaLibraryUpdateProgress[0]);
            }
        }
    }
    m_HandleMap.UnlockIndexer(mountPoint);

    return ret;
}
#endif

tResult iPodControlIAP::PlayMediaLibraryItems(const tU64 startuuid, const tBatchPlaybackList * batchlist, const bool isiTunesRadio)
{
    ENTRY;
    VARTRACE(startuuid);
    VARTRACE(isiTunesRadio);
    tListSize batchsize = 0;
    if(batchlist) {
        batchsize = batchlist->size();
    }
    VARTRACE(batchsize);

    tResult ret = MP_NO_ERROR;

#ifdef IPODCONTROL_IAP2_PF_AVAIL

    if(batchsize) {
        m_HandleMap.LockIAP2(m_MountPoint); //start critical section
        iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(m_MountPoint);
        if(!iap2Device) {
            ETG_TRACE_ERR(("!iap2Device"));
            ret = MP_ERR_IPOD_NO_ACCESS;
        } else {
            //get and init indexer context
            tFingerprint mediaLibraryUID = {0};
            m_HandleMap.LockIndexer(m_MountPoint);
            iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(m_MountPoint);
            if(!pcontext) {
                ETG_TRACE_ERR(("GetIndexerContext failed"));
                ret = MP_ERR_IPOD_NO_ACCESS;
            } else {
                if(isiTunesRadio) {
                   pcontext->GetiTunesRadioLibraryUID(mediaLibraryUID);
               } else {
                   pcontext->GetMediaLibraryUID(mediaLibraryUID);
               }
                if(mediaLibraryUID[0] == 0) {
                    ETG_TRACE_USR3(("mediaLibraryUID failed"));
                    ret = MP_ERR_IPOD_NO_ACCESS;
                } else {
                    //play media library item
                    iAP2PlayMediaLibraryItemsParameter playMediaLibraryItemsParameter;
                    memset(&playMediaLibraryItemsParameter, 0, sizeof(iAP2PlayMediaLibraryItemsParameter));

                        /* add MediaItemPersistentIdentifiers of the songs which should be played */
                    playMediaLibraryItemsParameter.MediaLibraryUniqueIdentifier = new U8*[sizeof(U8*)];
                    if(playMediaLibraryItemsParameter.MediaLibraryUniqueIdentifier == NULL) {
                        ETG_TRACE_USR3(("No Memory"));
                        ret = MP_ERR_IPOD_NO_MEM;
                    } else {
                        playMediaLibraryItemsParameter.MediaLibraryUniqueIdentifier_count++;
                        playMediaLibraryItemsParameter.MediaLibraryUniqueIdentifier[0] = 0;
                        size_t size = strnlen(mediaLibraryUID, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
                        playMediaLibraryItemsParameter.MediaLibraryUniqueIdentifier[0] = new U8[size];
                        if(playMediaLibraryItemsParameter.MediaLibraryUniqueIdentifier[0] == NULL) {
                            ETG_TRACE_USR3(("No Memory"));
                            ret = MP_ERR_IPOD_NO_MEM;
                        } else {
                            strncpy_r((char*)playMediaLibraryItemsParameter.MediaLibraryUniqueIdentifier[0], mediaLibraryUID, size);

                                //set uuid blob
                            playMediaLibraryItemsParameter.iAP2ItemsPersistentIdentifiers = new iAP2Blob[sizeof(iAP2Blob)];
                            if(playMediaLibraryItemsParameter.iAP2ItemsPersistentIdentifiers == NULL) {
                                ETG_TRACE_USR3(("No Memory"));
                                ret = MP_ERR_IPOD_NO_MEM;
                            } else {
                                memset(playMediaLibraryItemsParameter.iAP2ItemsPersistentIdentifiers, 0, sizeof(iAP2Blob) );
                                playMediaLibraryItemsParameter.iAP2ItemsPersistentIdentifiers_count++; //one item is mandatory

                                    //validate batch size
                                    tUInt itemCount = batchsize;
                                    tUInt itemStart = 0;
                                    if((int)itemCount > LocalSPM::GetDataProvider().iPodControlIAP2BatchLimit()) {
                                        itemCount = (tUInt)LocalSPM::GetDataProvider().iPodControlIAP2BatchLimit();
                                        //cut list, begin with starting uuid
                                        for(tUInt icut = 0; icut < batchsize; icut++) {
                                            if(batchlist && batchlist->at(icut) == startuuid) {
                                                itemStart = icut;
                                                break;
                                            }
                                        }
                                    }
                                    VARTRACE(itemCount);
                                    VARTRACE(itemStart);

                                size_t size = sizeof(tU64) * itemCount;
                                /* create array of ordered uint64 MediaItemPersistentIdentifiers */
                                playMediaLibraryItemsParameter.iAP2ItemsPersistentIdentifiers[0].iAP2BlobData = new U8[size];
                                if(playMediaLibraryItemsParameter.iAP2ItemsPersistentIdentifiers[0].iAP2BlobData == NULL) {
                                    ETG_TRACE_USR3(("No Memory"));
                                    ret = MP_ERR_IPOD_NO_MEM;
                                } else {
                                    memset(playMediaLibraryItemsParameter.iAP2ItemsPersistentIdentifiers[0].iAP2BlobData, 0, size);
                                    playMediaLibraryItemsParameter.iAP2ItemsPersistentIdentifiers[0].iAP2BlobLength = size;

                                        tUInt startingIndex = 0;
                                        //loop over vector
                                        tUInt writecount = 0;
                                        tUInt ipos = itemStart; //position in vector
                                        while(writecount < itemCount) {
                                            if(batchlist && batchlist->at(ipos) == startuuid) {
                                                startingIndex = writecount;
                                            }
                                            const tU64 uuid = batchlist->at(ipos);
                                            //VARTRACE(uuid);
                                            memcpy(playMediaLibraryItemsParameter.iAP2ItemsPersistentIdentifiers[0].iAP2BlobData + writecount*sizeof(tU64), &uuid, sizeof(tU64));
                                            writecount++;
                                            ipos++;
                                            if(ipos >= batchsize) {
                                                //wrap around
                                                ipos = 0;
                                            }
                                        }

                                        //set start index
                                        VARTRACE(startingIndex);
                                        playMediaLibraryItemsParameter.ItemsStartingIndex = new U32;
                                        if(playMediaLibraryItemsParameter.ItemsStartingIndex != NULL) {
                                          playMediaLibraryItemsParameter.ItemsStartingIndex[0] = startingIndex;
                                          playMediaLibraryItemsParameter.ItemsStartingIndex_count++;
                                        }

                                    //send iAP playback command, notifications expected
                                    m_HandleMap.ResetElapsedTime(m_MountPoint, pbNotifications);

                                    int res = iAP2PlayMediaLibraryItems(iap2Device, &playMediaLibraryItemsParameter);
                                    ETG_TRACE_USR3(("iAP2PlayMediaLibraryItems returned %d", res));
                                    if(res != IAP2_OK) {
                                        ret = MP_ERR_IPOD_COMMAND;
                                        UpdateIpodCommunicationError(res);
                                    }
                                }
                            }
                        }
                    iAP2FreeiAP2PlayMediaLibraryItemsParameter(&playMediaLibraryItemsParameter);
                    }
                }
            }
            m_HandleMap.UnlockIndexer(m_MountPoint);
        }
        m_HandleMap.UnlockIAP2(m_MountPoint); //end critical section
    }
#endif
    return ret;
}

tResult iPodControlIAP::PlayMediaLibraryCurrentSelection(const bool isiTunesRadio)
{
    ENTRY;
    VARTRACE(isiTunesRadio);
    tResult ret = MP_NO_ERROR;

#ifdef IPODCONTROL_IAP2_PF_AVAIL

    m_HandleMap.LockIAP2(m_MountPoint); //start critical section
    iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(m_MountPoint);
    if(!iap2Device) {
        ETG_TRACE_ERR(("!iap2Device"));
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        //get and init indexer context
        tFingerprint mediaLibraryUID = {0};
        m_HandleMap.LockIndexer(m_MountPoint);
        iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(m_MountPoint);
        if(!pcontext) {
            ETG_TRACE_ERR(("GetIndexerContext failed"));
            ret = MP_ERR_IPOD_NO_ACCESS;
        } else {
            if(isiTunesRadio) {
                pcontext->GetiTunesRadioLibraryUID(mediaLibraryUID);
            } else {
                pcontext->GetMediaLibraryUID(mediaLibraryUID);
            }
            if(mediaLibraryUID[0] == 0) {
                ETG_TRACE_USR3(("mediaLibraryUID failed"));
                ret = MP_ERR_IPOD_NO_ACCESS;
            } else {
                //play media library item
                iAP2PlayMediaLibraryCurrentSelectionParameter playMediaLibraryCurrentSelectionParameter;
                memset(&playMediaLibraryCurrentSelectionParameter, 0, sizeof(iAP2PlayMediaLibraryCurrentSelectionParameter));

                /* add MediaItemPersistentIdentifier of the songs which should be played */
                playMediaLibraryCurrentSelectionParameter.MediaLibraryUniqueIdentifier = new U8*[sizeof(U8*)];
                if(playMediaLibraryCurrentSelectionParameter.MediaLibraryUniqueIdentifier == NULL) {
                    ETG_TRACE_USR3(("No Memory"));
                    ret = MP_ERR_IPOD_NO_MEM;
                } else {
                    playMediaLibraryCurrentSelectionParameter.MediaLibraryUniqueIdentifier_count++;
                    playMediaLibraryCurrentSelectionParameter.MediaLibraryUniqueIdentifier[0] = 0;
                    size_t size = strnlen(mediaLibraryUID, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
                    playMediaLibraryCurrentSelectionParameter.MediaLibraryUniqueIdentifier[0] = new U8[size];
                    if(playMediaLibraryCurrentSelectionParameter.MediaLibraryUniqueIdentifier[0] == NULL) {
                        ETG_TRACE_USR3(("No Memory"));
                        ret = MP_ERR_IPOD_NO_MEM;
                    } else {
                        strncpy_r((char*)playMediaLibraryCurrentSelectionParameter.MediaLibraryUniqueIdentifier[0], mediaLibraryUID, size);

                        //send iAP playback command, notifications expected
                        m_HandleMap.ResetElapsedTime(m_MountPoint, pbNotifications);

                        int res = iAP2PlayMediaLibraryCurrentSelection(iap2Device, &playMediaLibraryCurrentSelectionParameter);
                        ETG_TRACE_USR3(("iAP2PlayMediaLibraryCurrentSelection returned %d", res));
                        if(res != IAP2_OK) {
                            ret = MP_ERR_IPOD_COMMAND;
                            UpdateIpodCommunicationError(res);
                        }
                    }
                    iAP2FreeiAP2PlayMediaLibraryCurrentSelectionParameter(&playMediaLibraryCurrentSelectionParameter);
                }
            }
        }
        m_HandleMap.UnlockIndexer(m_MountPoint);
    }
    m_HandleMap.UnlockIAP2(m_MountPoint); //end critical section
#endif
    return ret;
}

tResult iPodControlIAP::PlayMediaLibraryCollection(const tU64 collectionID, const iAP2MediaLibraryCollectionType collectionType, const int collectionStartIndex, const bool isiTunesRadio)
{
    ENTRY;
    VARTRACE(collectionID);
    VARTRACE(collectionType);
    VARTRACE(collectionStartIndex);
    VARTRACE(isiTunesRadio);
    tResult ret = MP_NO_ERROR;

#ifdef IPODCONTROL_IAP2_PF_AVAIL

    m_HandleMap.LockIAP2(m_MountPoint); //start critical section
    iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(m_MountPoint);
    if(!iap2Device) {
        ETG_TRACE_ERR(("!iap2Device"));
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        //get and init indexer context
        tFingerprint mediaLibraryUID = {0};
        m_HandleMap.LockIndexer(m_MountPoint);
        iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(m_MountPoint);
        if(!pcontext) {
            ETG_TRACE_ERR(("GetIndexerContext failed"));
            ret = MP_ERR_IPOD_NO_ACCESS;
        } else {
            if(isiTunesRadio) {
                pcontext->GetiTunesRadioLibraryUID(mediaLibraryUID);
            } else {
                pcontext->GetMediaLibraryUID(mediaLibraryUID);
            }

            if(mediaLibraryUID[0] == 0) {
                ETG_TRACE_USR3(("mediaLibraryUID failed"));
                ret = MP_ERR_IPOD_NO_ACCESS;
            } else {
                //play media library item
                iAP2PlayMediaLibraryCollectionParameter playMediaLibraryCollectionParameter;
                memset(&playMediaLibraryCollectionParameter, 0, sizeof(iAP2PlayMediaLibraryCollectionParameter));

                /* add MediaItemPersistentIdentifier of the songs which should be played */
                playMediaLibraryCollectionParameter.iAP2MediaLibraryUniqueIdentifier = new U8*[sizeof(U8*)];
                if(playMediaLibraryCollectionParameter.iAP2MediaLibraryUniqueIdentifier == NULL) {
                    ETG_TRACE_USR3(("No Memory"));
                    ret = MP_ERR_IPOD_NO_MEM;
                } else {
                    playMediaLibraryCollectionParameter.iAP2MediaLibraryUniqueIdentifier_count++;
                    playMediaLibraryCollectionParameter.iAP2MediaLibraryUniqueIdentifier[0] = 0;
                    size_t size = strnlen(mediaLibraryUID, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
                    playMediaLibraryCollectionParameter.iAP2MediaLibraryUniqueIdentifier[0] = new U8[size];
                    if(playMediaLibraryCollectionParameter.iAP2MediaLibraryUniqueIdentifier[0] == NULL) {
                        ETG_TRACE_USR3(("No Memory"));
                        ret = MP_ERR_IPOD_NO_MEM;
                    } else {
                        strncpy_r((char*)playMediaLibraryCollectionParameter.iAP2MediaLibraryUniqueIdentifier[0], mediaLibraryUID, size);

                        //set collection ID
                        playMediaLibraryCollectionParameter.iAP2CollectionPersistentIdentifier = new U64;
                        if(playMediaLibraryCollectionParameter.iAP2CollectionPersistentIdentifier == NULL) {
                            ETG_TRACE_USR3(("No Memory"));
                            ret = MP_ERR_IPOD_NO_MEM;
                        } else {
                            playMediaLibraryCollectionParameter.iAP2CollectionPersistentIdentifier[0] = collectionID;
                            playMediaLibraryCollectionParameter.iAP2CollectionPersistentIdentifier_count++;

                            //set collection starting index
                            playMediaLibraryCollectionParameter.iAP2CollectionStartingIndex = new U32;
                            if(playMediaLibraryCollectionParameter.iAP2CollectionStartingIndex == NULL) {
                                ETG_TRACE_USR3(("No Memory"));
                                ret = MP_ERR_IPOD_NO_MEM;
                            } else {
                                playMediaLibraryCollectionParameter.iAP2CollectionStartingIndex[0] = collectionStartIndex;
                                playMediaLibraryCollectionParameter.iAP2CollectionStartingIndex_count++;

                                //set collection type
                                playMediaLibraryCollectionParameter.iAP2CollectionType = new iAP2MediaLibraryCollectionType;
                                if(playMediaLibraryCollectionParameter.iAP2CollectionType == NULL) {
                                    ETG_TRACE_USR3(("No Memory"));
                                    ret = MP_ERR_IPOD_NO_MEM;
                                } else {
                                    playMediaLibraryCollectionParameter.iAP2CollectionType[0] = collectionType;
                                    playMediaLibraryCollectionParameter.iAP2CollectionType_count++;

                                    //send iAP playback command, notifications expected
                                    m_HandleMap.ResetElapsedTime(m_MountPoint, pbNotifications);

                                    int res = iAP2PlayMediaLibraryCollection(iap2Device, &playMediaLibraryCollectionParameter);
                                    ETG_TRACE_USR3(("iAP2PlayMediaLibraryCollection returned %d", res));
                                    if(res != IAP2_OK) {
                                        ret = MP_ERR_IPOD_COMMAND;
                                        UpdateIpodCommunicationError(res);
                                    }
                                }
                            }
                        }
                    }
                    iAP2FreeiAP2PlayMediaLibraryCollectionParameter(&playMediaLibraryCollectionParameter);
                }
            }
        }
        m_HandleMap.UnlockIndexer(m_MountPoint);
    }
    m_HandleMap.UnlockIAP2(m_MountPoint); //end critical section
#endif
    return ret;
}

tResult iPodControlIAP::iAP2_SeekTo(const tPlaytime position)
{
    ENTRY;
    VARTRACE(position);
    tResult ret = MP_NO_ERROR;
    m_HandleMap.LockIAP2(m_MountPoint); //start critical section
    iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(m_MountPoint);
    if(!iap2Device) {
        ETG_TRACE_ERR(("!iap2Device"));
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        //set nowplaying position
        iAP2SetNowPlayingInformationParameter setNowPlayingInformationParameter;
        memset(&setNowPlayingInformationParameter, 0, sizeof(iAP2SetNowPlayingInformationParameter));

        setNowPlayingInformationParameter.iAP2ElapsedTime = new U32;
        if(setNowPlayingInformationParameter.iAP2ElapsedTime == NULL) {
            ETG_TRACE_USR3(("No Memory"));
            ret = MP_ERR_IPOD_NO_MEM;
        } else {
            setNowPlayingInformationParameter.iAP2ElapsedTime_count++;
            setNowPlayingInformationParameter.iAP2ElapsedTime[0] = position;

            // //send iAP playback command, notifications expected
            // m_HandleMap.ResetElapsedTime(m_MountPoint, pbNotifications);

            int res = iAP2SetNowPlayingInformation(iap2Device, &setNowPlayingInformationParameter);
            ETG_TRACE_USR3(("iAP2SetNowPlayingInformation returned %d", res));
            if(res != IAP2_OK) {
                ret = MP_ERR_IPOD_COMMAND;
                UpdateIpodCommunicationError(res);
            }
            iAP2FreeiAP2SetNowPlayingInformationParameter(&setNowPlayingInformationParameter);
        }
    }
    m_HandleMap.UnlockIAP2(m_MountPoint); //end critical section

    return ret;
}

tResult iPodControlIAP::iAP2SetPlaybackQueueIndex(const int queueIndex)
{
    ENTRY;
    VARTRACE(queueIndex);
    tResult ret = MP_NO_ERROR;
    m_HandleMap.LockIAP2(m_MountPoint); //start critical section
    iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(m_MountPoint);
    if(!iap2Device) {
        ETG_TRACE_ERR(("!iap2Device"));
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        //set nowplaying position
        iAP2SetNowPlayingInformationParameter setNowPlayingInformationParameter;
        memset(&setNowPlayingInformationParameter, 0, sizeof(iAP2SetNowPlayingInformationParameter));

        setNowPlayingInformationParameter.iAP2PlaybackQueueIndex = new U32;
        if(setNowPlayingInformationParameter.iAP2PlaybackQueueIndex == NULL) {
            ETG_TRACE_USR3(("No Memory"));
            ret = MP_ERR_IPOD_NO_MEM;
        } else {
            setNowPlayingInformationParameter.iAP2PlaybackQueueIndex_count++;
            setNowPlayingInformationParameter.iAP2PlaybackQueueIndex[0] = queueIndex;

            // //send iAP playback command, notifications expected
            m_HandleMap.ResetElapsedTime(m_MountPoint, pbNotifications);

            int res = iAP2SetNowPlayingInformation(iap2Device, &setNowPlayingInformationParameter);
            ETG_TRACE_USR3(("iAP2SetNowPlayingInformation returned %d", res));
            if(res != IAP2_OK) {
                ret = MP_ERR_IPOD_COMMAND;
                UpdateIpodCommunicationError(res);
            }
            iAP2FreeiAP2SetNowPlayingInformationParameter(&setNowPlayingInformationParameter);
        }
    }
    m_HandleMap.UnlockIAP2(m_MountPoint); //end critical section

    return ret;
}

void iPodControlIAP::iAPGetMountPointFromDeviceID(const tDeviceID deviceID, tMountPoint &mountPoint)
{
    ENTRY_INTERNAL;
    mountPoint[0] = 0;
    m_HandleMap.GetMountPointFromDeviceID(mountPoint, deviceID);
}

bool iPodControlIAP::iAPGetMountOfFirstHostModeDevice(tMountPoint& mountPoint)
{
    ENTRY_INTERNAL;
    memset(mountPoint, 0, sizeof(mountPoint));
    bool ret = false;

    // Fix for NCG3D-196834: Metadata not updated once device is unplugged during active CPW session
    // Prioritize iAP Wifi over iAP USB session when device is connected over both USB and Wifi.

    // Get all devices from iPodControl handle map
    vector<string> mountPoints = m_HandleMap.GetAll();

    // First check for an active CPW device
    for(unsigned int i = 0; i < mountPoints.size(); i++)
    {
        if( ( IsIAP2(mountPoints[i].c_str()) )
                && ( IsIAP2WirelessCarPlayMode(mountPoints[i].c_str()) ))
        {
            ETG_TRACE_USR4((" CPW Device Found "));
            strncpy_r(OUT mountPoint, IN mountPoints[i].c_str(), IN sizeof(mountPoint));
            ret = true;
            break;
        }
    }

    // If CPW device is not found check for an active host mode device
    if( false == ret )
    {
        for(unsigned int i = 0; i < mountPoints.size(); i++)
        {
            if( (IsIAP2(mountPoints[i].c_str()))
                    && (IsIAP2HostMode(mountPoints[i].c_str()) ) )
            {
                ETG_TRACE_USR4((" CP USB Device Found "));
                strncpy_r(OUT mountPoint, IN mountPoints[i].c_str(), IN sizeof(mountPoint));
                ret = true;
                break;
            }
        }
    }

    return ret;
}

int iPodControlIAP::SwitchToHostMode(const tMountPoint mountPoint)
{
    ENTRY;
    VARTRACE(mountPoint);

    int res = IAP2_OK;

    const IPOD_OTG_TYPE otgType = m_HandleMap.GetOTGType(mountPoint);
    VARTRACE(otgType);

    iAP2USBRoleSwitchMode switchMode = IAP2_USB_ROLE_SWITCH_WITHOUT_DIGITAL_IPOD_OUT;
    if(LocalSPM::GetDataProvider().iPodControlSupportIAP2iOSInTheCar() && IsIAP2CarPlayMode(mountPoint))
    {
        switchMode = IAP2_USB_ROLE_SWITCH_WITH_DIGITAL_IPOD_OUT;
    }
    VARTRACE((int)switchMode);

    if(IPOD_OTG_MOLEX == otgType)
    {
        //Platform API(iap2SwitchToMultiHostMode) available for switching Molex hub to MultiHost Mode.
        //It also does the role switch of the connected Apple Device to CarPlay mode.

        //Find the vbus power path of the target vbus
        tPath vbusPower = {0};
        res = iap2findGlobPath(vbusPower, sizeof(vbusPower), STR_VBUS, STR_VBUS_GLOB);
        ETG_TRACE_USR3((" iap2findGlobPath returned %d", res));

        if(IAP2_OK == res)
        {
            //Form the vbus power path of the target vbus
            ///sys/class/udc/ci_hdrc.0/device/vbus
            strncat_r(vbusPower, "/", sizeof(vbusPower));
            strncat_r(vbusPower, STR_VBUS, sizeof(vbusPower));
            VARTRACE(vbusPower);

            //Get the port at which device is connected to
            const int otgPort = m_HandleMap.GetOTGPortNumber(mountPoint);
            VARTRACE(otgPort);

            //Fill the iAP2USBRoleSwitchInfo structure with the appropriate values
            iAP2USBRoleSwitchInfo info;
            memset(&info, 0, sizeof(info));

            info.vbusPower = vbusPower;
            info.vendorId = IAP2_APPLE_VENDOR_IDENTIFIER;
            info.productId = IAP2_APPLE_PRODUCT_IDENTIFIER;
            info.serialNumber = mountPoint;
            info.mode = switchMode;
            info.portnumber = (U8)otgPort;

            //Init the udcParamInfo_t structure
            udcParamInfo_t udcParam;
            memset(&udcParam, 0, sizeof(udcParam));

            //Request to switch to multihost mode
            tS32 status = iap2SwitchToMultiHostMode(&info, &udcParam);
            ETG_TRACE_USR3((" iap2SwitchToMultiHostMode returned %d", (int)status));
            if(0 == status)
            {
                //Apple vendor request ok, mark this device for required reverse role switch
                m_HandleMap.SetRoleSwitched(mountPoint, TRUE);
            }
            else
            {
                res = IAP2_CTL_ERROR;
            }
        }
    }
    else
    {
#ifdef VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
        CmdData result;
#endif

#if 0
        iAP2USBRoleSwitchInfo info;
        memset(&info, 0, sizeof(info));

        info.powerGPIO = 111;
        info.vbusPower = vbusPower;
        info.vendorId = 0x05ac;
        info.productId = 0x1200;
        info.serialNumber = NULL;
        info.otgGlob = STR_USB_ROLE_SWITCH_OTG_GLOB;
        info.mode = IAP2_USB_ROLE_SWITCH_WITHOUT_DIGITAL_IPOD_OUT;

        iAP2USBRoleSwitchStatus status = iAP2SwitchToHostMode(&info);
        ETG_TRACE_USR3(("iAP2SwitchToHostMode returned %d", (int)status));
#else
        //1.  iAP2USBVendorRequest_Send()
        //2.  iAP2InitDeviceStructure
        //3.  Disconnect trigger
        //4.  iap2SwitchOTG() - OTG Port set to â€žgadgetâ€œ
        //5.  iap2SwitchVbusPower() - VBUS â€žonâ€œ
        //6.  load_module() - Load Kernel Modules "libcomposite" and â€œg_ffâ€�
        //7.  mkdir and mount function_fs


        iAP2USBVendorRequestMonitor_t monitor;
        res = iap2VendorRequestMonitor_Begin(&monitor, IAP2_APPLE_VENDOR_IDENTIFIER, IAP2_APPLE_PRODUCT_IDENTIFIER, mountPoint);
        ETG_TRACE_USR3(("iAP2USBVendorRequestMonitor_Begin returned %d", res));

        if(res == IAP2_OK) {
            res = (int) iAP2USBVendorRequest_Send(IAP2_APPLE_VENDOR_IDENTIFIER, IAP2_APPLE_PRODUCT_IDENTIFIER, mountPoint, switchMode);
            ETG_TRACE_USR3(("iAP2USBVendorRequest_Send returned %d", res));

            if(IAP2_OK == res) {
                res = iap2VendorRequestMonitor_WaitAndEnd(&monitor);
                ETG_TRACE_USR3(("iAP2USBVendorRequestMonitor_WaitAndEnd returned %d", res));
            }
        }
        iap2VendorRequestMonitor_Release(&monitor);

        if(IAP2_OK == res) {

            //Apple vendor request ok, mark this device for required reverse role switch
            m_HandleMap.SetRoleSwitched(mountPoint, TRUE);

            //set default UDC
            tPath udcDevice = {0};
            m_HandleMap.GetUDCDevice(udcDevice, mountPoint);
            VARTRACE(udcDevice);

            // /sys/class/udc/udc_force set to ci_hdrc.0 (target OTG) or utbridge_udc.0 (unwired HUB #1) or utbridge_udc.1 (unwired HUB #2)
            res = iap2CommonWrite(STR_UDC_PATH, STR_FORCE_UDC, udcDevice);
            ETG_TRACE_USR3(("iap2SetUDC(STR_FORCES_UDC) returned %d", res));

            if(res != IAP2_OK) {
                //legacy - /sys/class/udc/defaultudc set to ci_hdrc.0 (target OTG) or utbridge_udc.0 (unwired HUB #1) or utbridge_udc.1 (unwired HUB #2)
                res = iap2CommonWrite(STR_UDC_PATH, STR_DEFAULT_UDC, udcDevice);
                ETG_TRACE_USR3(("iap2SetUDC(STR_DEFAULT_UDC) returned %d", res));
            }

            const int otgPort = m_HandleMap.GetOTGPortNumber(mountPoint);
            VARTRACE(otgPort);

            tPath otgPath = {0};
            if(otgType == IPOD_OTG_TARGET) { //target OTG
                res = iap2findGlobPath(otgPath, sizeof(otgPath), STR_GADGET, STR_USB_ROLE_SWITCH_OTG_GLOB2);
                VARTRACE(otgPath);
                ETG_TRACE_USR3(("iap2findGlobPath returned %d", res));

                if(res != IAP2_OK) {
                    res = iap2findGlobPath(otgPath, sizeof(otgPath), STR_GADGET, STR_USB_ROLE_SWITCH_OTG_GLOB);
                    VARTRACE(otgPath);
                    ETG_TRACE_USR3(("iap2findGlobPath returned %d", res));
                }

                if(res == IAP2_OK) {
#if 0 //Depricated vbus_auto
                    res = iap2CommonWrite(otgPath, STR_VBUS_AUTO, STR_DISABLE);
#else
                    res = iap2CommonWrite(otgPath, STR_VBUS_AUTO_USB1, STR_DISABLE);
#endif
                    ETG_TRACE_USR3(("iap2SwitchVbusAuto(disabled) returned %d", res));

                    res = iap2CommonWrite(otgPath, STR_ROLE, STR_GADGET);
                    ETG_TRACE_USR3(("iap2_switchOTG returned %d", res));
                }
            } else if(otgType == IPOD_OTG_UNWIRED) { //unwired
                m_HandleMap.GetOTGPath(otgPath, mountPoint);
                VARTRACE(otgPath);

                char bridgeport[128] = {0};
                itoa(otgPort, bridgeport, 10);
                VARTRACE(bridgeport);
                res = iap2CommonWrite(otgPath, STR_BRIDGE, bridgeport);
                ETG_TRACE_USR3(("iap2_switchOTG returned %d", res));
            } else if(otgType == IPOD_OTG_MICROCHIP) { //Microchip hub

                res = SwitchCarPlayMicroChipHub(mountPoint, otgPort);

                if(IAP2_OK == res) {
                    //switch target otg
                    res = iap2findGlobPath(otgPath, sizeof(otgPath), STR_GADGET, STR_USB_ROLE_SWITCH_OTG_GLOB2);
                    VARTRACE(otgPath);
                    ETG_TRACE_USR3(("iap2findGlobPath returned %d", res));
                    if(res == IAP2_OK) {
                        res = iap2CommonWrite(otgPath, STR_VBUS_AUTO_USB1, STR_DISABLE);
                        ETG_TRACE_USR3(("iap2SwitchVbusAuto(disabled) returned %d", res));

                        res = iap2CommonWrite(otgPath, STR_ROLE, STR_GADGET);
                        ETG_TRACE_USR3(("iap2_switchOTG returned %d", res));
                    }
                }
            }

            else if(otgType == IPOD_OTG_MITSUMI_PORT2ES2) { //Microchip hub (MITSUMI PORT2 ES2)

                res = SwitchCarPlayMicroChipMitsumiPort2ES2Hub(mountPoint, otgPort);

                if(IAP2_OK == res) {
                    //switch target otg
                    res = iap2findGlobPath(otgPath, sizeof(otgPath), STR_GADGET, STR_USB_ROLE_SWITCH_OTG_GLOB2);
                    VARTRACE(otgPath);
                    ETG_TRACE_USR3(("iap2findGlobPath returned %d", res));
                    if(res == IAP2_OK) {
                        res = iap2CommonWrite(otgPath, STR_VBUS_AUTO_USB1, STR_DISABLE);
                        ETG_TRACE_USR3(("iap2SwitchVbusAuto(disabled) returned %d", res));

                        res = iap2CommonWrite(otgPath, STR_ROLE, STR_GADGET);
                        ETG_TRACE_USR3(("iap2_switchOTG returned %d", res));
                    }
                }
            }

           else if(otgType == IPOD_OTG_MITSUMI_PORT2ES4) { //Microchip hub (MITSUMI PORT2 ES2)

                res = SwitchCarPlayMicroChipMitsumiPort2ES4Hub(mountPoint, otgPort);

                if(IAP2_OK == res) {
                    //switch target otg
                    res = iap2findGlobPath(otgPath, sizeof(otgPath), STR_GADGET, STR_USB_ROLE_SWITCH_OTG_GLOB2);
                    VARTRACE(otgPath);
                    ETG_TRACE_USR3(("iap2findGlobPath returned %d", res));
                    if(res == IAP2_OK) {
                        res = iap2CommonWrite(otgPath, STR_VBUS_AUTO_USB1, STR_DISABLE);
                        ETG_TRACE_USR3(("iap2SwitchVbusAuto(disabled) returned %d", res));

                        res = iap2CommonWrite(otgPath, STR_ROLE, STR_GADGET);
                        ETG_TRACE_USR3(("iap2_switchOTG returned %d", res));
                    }
                }
            }

            if(IAP2_OK == res) {

                if(otgType == IPOD_OTG_TARGET) { //target OTG, legacy (no vbus_auto support)
                    res = iap2CommonWrite(otgPath, STR_VBUS, STR_ON);
                    ETG_TRACE_USR3(("iap2_switchVbusPower(on) returned %d",res));
                }
                if(IAP2_OK == res) {
                    res = load_modules(switchMode == IAP2_USB_ROLE_SWITCH_WITH_DIGITAL_IPOD_OUT);
                    ETG_TRACE_USR3(("load_modules returned %d, errno %d",res, errno));

                    if(IAP2_OK == res){
                        if(LocalSPM::GetDataProvider().iPodControlIAP2ConfigFSEnabled()) {
                            tAllParameters parameters = {0};

#ifdef IPODCONTROL_IAP2_PF_CONFIGFS_NON_ROOT
                            //carPlayEnabled
                            strncpy_r(OUT parameters, IN IsIAP2CarPlayMode(mountPoint) ? "true" : "false", IN sizeof(parameters));
                            strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));
                            //nativeTransportEnabled
                            strncat_r(OUT parameters, IN iAP2_IsNativeTransportMode(mountPoint) ? "true" : "false", IN sizeof(parameters));
                            strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));

                            strncat_r(OUT parameters, IN IsIAP2NativeTransportCarlifeMode(mountPoint) ? "true" : "false", IN sizeof(parameters));
                            strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));

                            //deviceID
                            tPath tmpstr = {0};
                            snprintf(tmpstr, sizeof(tmpstr), "%d", iAPGetDeviceID(mountPoint));
                            strncat_r(OUT parameters, IN tmpstr, IN sizeof(parameters));
                            strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));
                            //name
                            strncat_r(OUT parameters, IN LocalSPM::GetDataProvider().iPodControlAccessoryInfoModelName().c_str(), IN sizeof(parameters));
                            strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));
                            //modelIdentifier
                            strncat_r(OUT parameters, IN LocalSPM::GetDataProvider().iPodControlAccessoryInfoModelNumber().c_str(), IN sizeof(parameters));
                            strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));
                            //manufacturer
                            strncat_r(OUT parameters, IN LocalSPM::GetDataProvider().iPodControlAccessoryInfoManufacturer().c_str(), IN sizeof(parameters));
                            strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));
                            //serialNumber
                            strncat_r(OUT parameters, IN LocalSPM::GetDataProvider().iPodControlAccessoryInfoSerialNumber().c_str(), IN sizeof(parameters));
                            strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));
                            //vendorID
                            strncat_r(OUT parameters, IN LocalSPM::GetDataProvider().iPodControlIAP2AccessoryVendorId().c_str(), IN sizeof(parameters));
                            strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));
                            //productID
                            strncat_r(OUT parameters, IN LocalSPM::GetDataProvider().iPodControlIAP2AccessoryProductId().c_str(), IN sizeof(parameters));
                            strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));
                            //BCDdevice
                            strncat_r(OUT parameters, IN LocalSPM::GetDataProvider().iPodControlIAP2AccessoryBcdDevice().c_str(), IN sizeof(parameters));
                            strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));
                            //UDC device name
                            tPath udcDevice = {0};
                            m_HandleMap.GetUDCDevice(udcDevice, mountPoint);
                            strncat_r(OUT parameters, IN udcDevice, IN sizeof(parameters));
                            strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));
                            //AppName
                            tPath appName = {0};
                            if(LocalSPM::GetDataProvider().iPodControlIAP2AppControlEnabled() && !IsIAP2CarPlayMode(mountPoint)) {
                                if(IsIAP2NativeTransportCarlifeMode(mountPoint))
                                {
                                    vector<tIPODAppInfo> appInfoList = m_HandleMap.GetAppInfosFromSPI(mountPoint);
                                    VARTRACE(appInfoList.size());
                                    for(unsigned int i = 0; i < appInfoList.size(); i++) {
                                       if(appInfoList[i].option == AIO_EA_NATIVE_TRANSPORT) {
                                           strncpy_r(OUT appName, IN appInfoList[0].protocol, IN sizeof(appName));
                                           VARTRACE(appName);
                                       }
                                   }
                                    strncpy_r(OUT appName, IN appInfoList[0].protocol, IN sizeof(appName));
                                    VARTRACE(appName);
                                }
                                else
                                {
                                    vector<tIPODAppInfo> appInfoList = m_HandleMap.GetAppInfos(mountPoint, true, true);
                                    for(unsigned int i = 0; i < appInfoList.size(); i++) {
                                       if(appInfoList[i].option == AIO_EA_NATIVE_TRANSPORT) {
                                           strncpy_r(OUT appName, IN appInfoList[0].protocol, IN sizeof(appName));
                                           VARTRACE(appName);
                                       }
                                   }
                                    strncpy_r(OUT appName, IN appInfoList[0].protocol, IN sizeof(appName));
                                    VARTRACE(appName);
                                }
                            }
                            strncat_r(OUT parameters, IN appName, IN sizeof(parameters));
                            strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));
                            VARTRACE(parameters);
#endif
#ifdef VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
                            result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_MOUNT_CONFIGFS, IN parameters);
                            if (ERR_NONE != result.errorNo) {
                                res = IAP2_CTL_ERROR;
                            }
#endif

                        } else {
#ifdef VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
                            result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_MOUNT);
                            if (ERR_NONE != result.errorNo) {
                                res = IAP2_CTL_ERROR;
                            }
#endif
                        }
                    }
                }
            }
        }
#endif
    }
    return res;
}

int iPodControlIAP::SwitchToDeviceMode(const tMountPoint mountPoint, const tConnectionState lastConnectionState)
{
    ENTRY;

    VARTRACE(mountPoint);
    VARTRACE(lastConnectionState);

    int res = IAP2_OK;

#ifdef VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
    CmdData result;
#endif

    const IPOD_OTG_TYPE otgType = m_HandleMap.GetOTGType(mountPoint);
    VARTRACE(otgType);

    if(IPOD_OTG_MOLEX == otgType)
    {
        //Platform API(iap2TerminateMultiHostMode) available for switching Molex hub to Device Mode.
        //It also brings connected Apple Device to Device mode.

        //Find the vbus power path of the target vbus
        tPath vbusPower = {0};
        res = iap2findGlobPath(vbusPower, sizeof(vbusPower), STR_VBUS, STR_VBUS_GLOB);
        ETG_TRACE_USR3((" iap2findGlobPath returned %d", res));

        if(IAP2_OK == res)
        {
            //Form the vbus power path of the target vbus
            ///sys/class/udc/ci_hdrc.0/device/vbus
            strncat_r(vbusPower, "/", sizeof(vbusPower));
            strncat_r(vbusPower, STR_VBUS, sizeof(vbusPower));
            VARTRACE(vbusPower);

            //Get the port at which device is connected to
            const int otgPort = m_HandleMap.GetOTGPortNumber(mountPoint);
            VARTRACE(otgPort);

            //Fill the iAP2USBRoleSwitchInfo structure with appropriate values
            iAP2USBRoleSwitchInfo info;
            memset(&info, 0, sizeof(info));

            info.vbusPower = vbusPower;
            info.vendorId = IAP2_APPLE_VENDOR_IDENTIFIER;
            info.productId = IAP2_APPLE_PRODUCT_IDENTIFIER;
            info.serialNumber = mountPoint;
            info.portnumber = (U8)otgPort;

            //Request to terminate multihost mode
            tS32 status = iap2TerminateMultiHostMode(&info);
            ETG_TRACE_USR3((" iap2TerminateMultiHostMode returned %d", (int)status));
            if(0 != status)
            {
                res = IAP2_CTL_ERROR;
            }
        }
        else
        {
            res = IAP2_CTL_ERROR;
        }
    }
    else
    {
        int32_t s32_umountRetryMaxwaitUs = 1000*1000*6; // Try to umount /dev/ffs for 6s
        int32_t s32_umountRetryWaitUs = 1000*100; // Wait 100ms between tries

        // Retry umount several times in case that other processes access files in /dev/ffs and need some
        // time to release those files on disconnect
        // This wait could be prevented (or at least shortened), if ai_mediaplayer would send the updated
        // DiPoDeviceConnections property before calling this function
        res = -1;
        while( ( 0 < s32_umountRetryMaxwaitUs ) && ( 0 != res ) ) {

            unload_modules_pre_umount();

#ifdef VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
                if(LocalSPM::GetDataProvider().iPodControlIAP2ConfigFSEnabled()) {

                    result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_UMOUNT_CONFIGFS);
                    VARTRACE(result.message[0]);
                    if (ERR_NONE != result.errorNo || ERR_NONE != result.message[0]) {
                        res = IAP2_CTL_ERROR; //returns errno
                    }
                    else {
                        res = ERR_NONE;
                    }

                } else {

                    result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_UMOUNT);
                    VARTRACE(result.message[0]);
                    if (ERR_NONE != result.errorNo || ERR_NONE != result.message[0]) {
                        res = IAP2_CTL_ERROR; //returns errno
                    }
                    else {
                        res = ERR_NONE;
                    }

                }
#endif
            ETG_TRACE_USR3(("RootDaemonCommand(GMP_IAP_UMOUNT) returned %d - %d us left", res, s32_umountRetryMaxwaitUs));

            // wait 100ms, when umount failed...
             if( 0 != res ) {
                usleep(s32_umountRetryWaitUs);
                s32_umountRetryMaxwaitUs -= s32_umountRetryWaitUs;
             }
        }

        unload_modules();

        tPath otgPath = {0};

        if(   (otgType == IPOD_OTG_TARGET)
            ||(otgType == IPOD_OTG_MICROCHIP)
            ||(otgType == IPOD_OTG_MITSUMI_PORT2ES2)
            ||(otgType == IPOD_OTG_MITSUMI_PORT2ES4))
          {
            res = iap2findGlobPath(otgPath, sizeof(otgPath), STR_GADGET, STR_USB_ROLE_SWITCH_OTG_GLOB2);
            VARTRACE(otgPath);
            ETG_TRACE_USR3(("iap2findGlobPath returned %d", res));

            if(res != IAP2_OK) {
                res = iap2findGlobPath(otgPath, sizeof(otgPath), STR_GADGET, STR_USB_ROLE_SWITCH_OTG_GLOB);
                VARTRACE(otgPath);
                ETG_TRACE_USR3(("iap2findGlobPath returned %d", res));
            }

            if(res == IAP2_OK) {
#if 0 //Depricated vbus_auto
                res = iap2CommonWrite(otgPath, STR_VBUS_AUTO, STR_ENABLE);
                ETG_TRACE_USR3(("iap2SwitchVbusAuto(enable) returned %d", res));
#endif
                tPath vbusPower = {0};
                res = iap2findGlobPath(vbusPower, sizeof(vbusPower), STR_VBUS, STR_VBUS_GLOB);
                VARTRACE(vbusPower);
                ETG_TRACE_USR3(("_iap2findVbusPower returned %d", res));

                if(lastConnectionState != CS_DISCONNECTED) {
                    //turn off VBUS if device is still present
                    res = iap2CommonWrite(vbusPower, STR_VBUS, STR_OFF);
                    ETG_TRACE_USR3(("iap2switchVbusPower(off) returned %d", res));
                    usleep(2000000); //iPhone need time to switch back role
                }
                res = iap2CommonWrite(otgPath, STR_ROLE, STR_HOST);
                ETG_TRACE_USR3(("iap2SwitchOTG to %40s returned %d",STR_HOST, res));

                //turn on VBUS if role switch fails
                if(res != IAP2_OK) {
                    res = iap2CommonWrite(vbusPower, STR_VBUS, STR_ON);
                    ETG_TRACE_USR3(("iap2switchVbusPower(ON) returned %d", res));
                }

                if(otgType == IPOD_OTG_MICROCHIP) {
                    if(lastConnectionState != CS_DISCONNECTED) {
                        InitCarPlayMicroChipHub();
                    } else {
                        usleep(1000000);
                        TerminateCarPlayMicroChipHub();
                    }
                }

                if(otgType == IPOD_OTG_MITSUMI_PORT2ES2) {
                    if(lastConnectionState != CS_DISCONNECTED) {
                        InitCarPlayMicroChipMitsumiPort2ES2();
                    } else {
                        usleep(1000000);
                        TerminateCarPlayMicroChipMitsumiPort2ES2();
                    }
                }

                if(otgType == IPOD_OTG_MITSUMI_PORT2ES4) {
                    if(lastConnectionState != CS_DISCONNECTED) {
                        InitCarPlayMicroChipMitsumiPort2ES4();
                    } else {
                        usleep(1000000);
                        TerminateCarPlayMicroChipMitsumiPort2ES4();
                    }
                }
            }

        } else if(otgType == IPOD_OTG_UNWIRED) { //unwired
            m_HandleMap.GetOTGPath(otgPath, mountPoint);
            VARTRACE(otgPath);

            tPath powerPortPath = {0};
            m_HandleMap.GetPowerPortPath(powerPortPath, mountPoint);
            VARTRACE(powerPortPath);

            const int otgPort = m_HandleMap.GetOTGPortNumber(mountPoint);
            VARTRACE(otgPort);

            char powerport[128] = {0};

            //turn off VBUS power
            snprintf(powerport, sizeof(powerport), "%s/port%d", powerPortPath, otgPort);
            VARTRACE(powerport);
            res = iap2CommonWrite(powerport, STR_CONTROL, STR_OFF);
            ETG_TRACE_USR3(("switch portX(off) returned %d", res));

            if(res != IAP2_OK) {
                //legacy
            snprintf(powerport, sizeof(powerport), "%d=0", otgPort);
                VARTRACE(powerport);
                res = iap2CommonWrite(otgPath, STR_PORTPOWER, powerport);
                ETG_TRACE_USR3(("iap2switchVbusPower(off) returned %d", res));
            }

            //switch back bridge
            res = iap2CommonWrite(otgPath, STR_BRIDGE, "0");
            ETG_TRACE_USR3(("iap2SwitchOTG to %40s returned %d",STR_HOST, res));

            if(lastConnectionState != CS_DISCONNECTED) {
                //wait for iPod restart
                usleep(2000000); //iPhone need time to switch back role
            }

            //turn on VBUS power
            snprintf(powerport, sizeof(powerport), "%s/port%d", powerPortPath, otgPort);
            VARTRACE(powerport);
            res = iap2CommonWrite(powerport, STR_CONTROL, STR_ON);
            ETG_TRACE_USR3(("switch portX(on) returned %d", res));

            if(res != IAP2_OK) {
                //legacy
                snprintf(powerport, sizeof(powerport), "%d=1", otgPort);
                VARTRACE(powerport);
                res = iap2CommonWrite(otgPath, STR_PORTPOWER, powerport);
                ETG_TRACE_USR3(("iap2switchVbusPower(off) returned %d", res));
            }
        }
    }

    VARTRACE(res);
    return res;
}

S32 iPodControlIAP::iap2VendorRequestMonitor_Begin(iAP2USBVendorRequestMonitor_t* thisPtr, U16 vid, U16 pid, const char* serial)
{
    ENTRY;
    S32 status = IAP2_OK;

    memset(thisPtr, 0, sizeof(iAP2USBVendorRequestMonitor_t));

    thisPtr->udev = udev_new();
    if (thisPtr->udev == NULL)
    {
        /* TODO error handling */
        status = IAP2_CTL_ERROR;
    }

    if (status == IAP2_OK)
    {
        status = _findDevice(thisPtr, vid, pid, serial);
        /* error logged and handled */
    }

    return status;
}

S32 iPodControlIAP::iap2VendorRequestMonitor_WaitAndEnd(iAP2USBVendorRequestMonitor_t* thisPtr)
{
    ENTRY;
    struct timeval timeout;
    S32 status = IAP2_OK;

    timeout.tv_sec = 1;
    timeout.tv_usec = 0;

    thisPtr->monitor = udev_monitor_new_from_netlink(thisPtr->udev, "udev");
    /* TODO error handling */

    udev_monitor_filter_add_match_subsystem_devtype(thisPtr->monitor, "usb", NULL); //"hidraw"
    /* TODO error handling */

    udev_monitor_enable_receiving(thisPtr->monitor);
    /* TODO error handling */

    int file = udev_monitor_get_fd(thisPtr->monitor);
    /* TODO error handling */

    BOOL deviceFound = FALSE;
    while (status == IAP2_OK && deviceFound == FALSE &&
            (timeout.tv_sec > 0 || timeout.tv_usec > 0))
    {
        fd_set fileSet;

        FD_ZERO(&fileSet);
        FD_SET(file, &fileSet);

        /* wait; timeout is modified to the remaining time */
        int ret = select(file + 1, &fileSet, NULL, NULL, &timeout);
        if (ret > 0)
        {
            /* got some notification */
            if (FD_ISSET(file, &fileSet))
            {
                status = _checkForDeviceRemoval(thisPtr, &deviceFound);
            }
        }
        else if (ret == 0)
        {
            ETG_TRACE_ERR(("vendor request to device vid:%04x pid:%04x serial:%s timed out",
                    thisPtr->deviceInfo.idVendor, thisPtr->deviceInfo.idProduct,
                    thisPtr->deviceInfo.serial));
            status = IAP2_OK;
        }
        else if (ret == EINTR)
        {
            /* interrupt, try again */
            /* TODO need counter for max retries? */
        }
        else
        {
            ETG_TRACE_USR3(("select: %d %s", errno, strerror(errno)));
            status = IAP2_CTL_ERROR;
        }
    }

    if (deviceFound == TRUE)
    {
        ETG_TRACE_USR3(("device disconnected after vendor request VID=%04x PID=%04x serial=%s",
                thisPtr->deviceInfo.idVendor, thisPtr->deviceInfo.idProduct,
                thisPtr->deviceInfo.serial));
    }

    return status;
}

void iPodControlIAP::iap2VendorRequestMonitor_Release(iAP2USBVendorRequestMonitor_t* thisPtr)
{
    ENTRY;
    if (thisPtr->monitor != NULL)
    {
        udev_monitor_unref(thisPtr->monitor);
    }

    if (thisPtr->udev != NULL)
    {
        udev_unref(thisPtr->udev);
    }
}

#if 0
S32 iPodControlIAP::_findDevice(iAP2USBVendorRequestMonitor_t* thisPtr, U16 vid, U16 pid,
        const char* serial)
{
    ENTRY;
    S32 status = IAP2_OK;
    struct udev_enumerate* enumerate;

    /* scan hidraw devices */
    enumerate = udev_enumerate_new(thisPtr->udev);
    if (enumerate == NULL)
    {
        ETG_TRACE_ERR(("udev_enumerate_new"));
        status = IAP2_CTL_ERROR;
    }

    if (status == IAP2_OK)
    {
        int ret;
        if (0 > (ret = udev_enumerate_add_match_subsystem(enumerate, "hidraw")))
        {
            ETG_TRACE_ERR(("udev_enumerate_add_match_subsystem failed: %d", ret));
            status = IAP2_CTL_ERROR;
        }

        if (0 > (ret = udev_enumerate_scan_devices(enumerate)))
        {
            ETG_TRACE_ERR(("udev_enumerate_scan_devices failed: %d", ret));
            status = IAP2_CTL_ERROR;
        }
    }

    if (status == IAP2_OK)
    {
        BOOL found = FALSE;
        struct udev_list_entry* deviceIterator = udev_enumerate_get_list_entry(enumerate);
        if (deviceIterator == NULL)
        {
            /* happens when no device was found */
            ETG_TRACE_ERR(("_findDevice():  enumerate list entry failed."));
        }

        while ((deviceIterator != NULL) && (found == FALSE))
        {
            const char* path = udev_list_entry_get_name(deviceIterator);
            struct udev_device* device = udev_device_new_from_syspath(thisPtr->udev, path);
            if (device != NULL)
            {
                struct udev_device* parent = udev_device_get_parent_with_subsystem_devtype(device,
                        "usb", "usb_device");
                if (parent != NULL)
                {
                    _compareDeviceIds(thisPtr, parent, path, vid, pid, serial, &found);
                    /* error logged and handled */
                }
                else
                {
                    ETG_TRACE_ERR(("could not get parent device for %s", path));
                    /* ignore error, handle next */
                }
                udev_device_unref(device);
            }
            else
            {
                ETG_TRACE_ERR(("could not get udev device from from syspath %s", path));
                /* ignore error, handle next */
            }

            deviceIterator = udev_list_entry_get_next(deviceIterator);
        }

        if (found == FALSE)
        {
            /* device not found */
            ETG_TRACE_ERR(("_findDevice():  USB device with VID=%04x, PID=%04x and serial=%s not found",
                    vid, pid, serial));
            status = IAP2_CTL_ERROR;
        }
    }

    if (enumerate != NULL)
    {
        udev_enumerate_unref(enumerate);
    }

    return status;
}
#else
S32 iPodControlIAP::_findDevice(iAP2USBVendorRequestMonitor_t* thisPtr, U16 vid, U16 pid,
        const char* serial)
{
    ENTRY;
    S32 status = IAP2_OK;
    struct udev_enumerate* enumerate;
    char udev_vid[5];

    /* scan hidraw devices */
    enumerate = udev_enumerate_new(thisPtr->udev);
    if (enumerate == NULL)
    {
        ETG_TRACE_ERR(("udev_enumerate_new"));
        status = IAP2_CTL_ERROR;
    }

    if (status == IAP2_OK)
    {
        int ret;
        ret = udev_enumerate_add_match_subsystem(enumerate, "usb");
        if (0 != ret)
        {
            ETG_TRACE_ERR(("udev_enumerate_add_match_subsystem failed: %d", ret));
            status = IAP2_CTL_ERROR;
        }
        sprintf(udev_vid, "%04x", vid);

        ETG_TRACE_USR3((" vid: %d | 0x %X | %s", vid, vid, udev_vid));
        /* search only for Apple devices */
        ret = udev_enumerate_add_match_sysattr(enumerate, (const char*)"idVendor", (const char*)udev_vid);
        if(ret != 0)
        {
            ETG_TRACE_ERR(("udev_enumerate_add_match_sysattr failed: %d", ret));
            status = IAP2_CTL_ERROR;
        }

        if (0 > (ret = udev_enumerate_scan_devices(enumerate)))
        {
            ETG_TRACE_ERR(("udev_enumerate_scan_devices failed: %d", ret));
            status = IAP2_CTL_ERROR;
        }
    }

    if (status == IAP2_OK)
    {
        BOOL found = FALSE;
        struct udev_list_entry* deviceIterator = udev_enumerate_get_list_entry(enumerate);
        if (deviceIterator == NULL)
        {
            /* happens when no device was found */
            ETG_TRACE_ERR(("_findDevice():  enumerate list entry failed."));
        }

        while ((deviceIterator != NULL) && (found == FALSE))
        {
            const char* path = udev_list_entry_get_name(deviceIterator);
            if(path != NULL){
                ETG_TRACE_USR3(("_findDevice():  path: %s", path));
                struct udev_device* device = udev_device_new_from_syspath(thisPtr->udev, path);
                if (device != NULL){
                    _compareDeviceIds(thisPtr, device, path, vid, pid, serial, &found);
                    udev_device_unref(device);
                } else{
                    ETG_TRACE_ERR(("could not get udev device from from syspath %s", path));

                    /* ignore error, handle next */
                }

                deviceIterator = udev_list_entry_get_next(deviceIterator);
            }
        }

        if (found == FALSE)
        {
            /* device not found */
            ETG_TRACE_ERR(("_findDevice():  USB device with VID=%04x, PID=%04x and serial=%s not found",
                    vid, pid, serial));
            status = IAP2_CTL_ERROR;
        }
    }

    if (enumerate != NULL)
    {
        udev_enumerate_unref(enumerate);
    }

    return status;
}
#endif

S32 iPodControlIAP::_compareSysPath(struct udev_device* device, const char* sysPath,
        BOOL* matches /* out */)
{
    ENTRY;
    S32 status = IAP2_OK;
    const char* path = udev_device_get_syspath(device);
    if (path == NULL)
    {
        /* TODO error handling */
        status = IAP2_CTL_ERROR;
    }
    else
    {
        if (0 == strncmp(sysPath, path, strlen_r(sysPath)))
        {
            *matches = TRUE;
        }
        else
        {
            *matches = FALSE;
        }
    }

    return status;
}

S32 iPodControlIAP::_compareDeviceIds(iAP2USBVendorRequestMonitor_t* thisPtr,
        struct udev_device* device, const char* path, U16 vid, U16 pid, const char* serial,
        BOOL* found)
{
    ENTRY;
    S32 status = IAP2_OK;

    /* check vid, pid, serial */
    const char* device_vid = udev_device_get_sysattr_value(device, "idVendor");
    const char* device_pid = udev_device_get_sysattr_value(device, "idProduct");
    const char* device_serial = udev_device_get_sysattr_value(device, "serial");
    if ((device_vid != NULL) && (device_pid != NULL) && (device_serial != NULL))
    {
        /* convert ids to string for comparison */
        char _vid[5], _pid[5];
        sprintf(_vid, "%04x", vid);
        sprintf(_pid, "%04x", pid);

        int vid_cmp = -1;
        int pid_cmp = -1;
        int serial_cmp = -1;
        vid_cmp = strncmp(_vid, device_vid, 4);
        pid_cmp = strncmp(_pid, device_pid, 2);
        if (serial != NULL){
            serial_cmp = strncmp(serial, device_serial, strlen_r(serial));
        } else{
            serial_cmp = 0;
        }

        if ((0 == vid_cmp) && (0 == pid_cmp) && (serial_cmp == 0))
        {
            /* found the device; fill the structure */
            *found = TRUE;
            thisPtr->deviceInfo.idVendor = vid;
            thisPtr->deviceInfo.idProduct = pid;
            strncpy_r(thisPtr->deviceInfo.sysPath, path, sizeof(thisPtr->deviceInfo.sysPath));
            strncpy_r(thisPtr->deviceInfo.serial, device_serial, sizeof(thisPtr->deviceInfo.serial));
        }
    }
    else
    {
        ETG_TRACE_ERR(("failed to get device attributes"));
        status = IAP2_CTL_ERROR;
    }

    return status;
}

S32 iPodControlIAP::_checkForDeviceRemoval(iAP2USBVendorRequestMonitor_t* thisPtr,
        BOOL* deviceFound)
{
    ENTRY;
    S32 status = IAP2_OK;
    struct udev_device* device = udev_monitor_receive_device(thisPtr->monitor);

    if (device != NULL)
    {
        /* check if udev remove action */
        const char* action = udev_device_get_action(device);
        if (action != NULL)
        {
            if (0 == strncmp(action, "remove",
                    strlen_r("remove")))
            {
                status = _compareSysPath(device, thisPtr->deviceInfo.sysPath, deviceFound);
                /* error logged and handled */
            }
        }
        else
        {
            /* TODO more detailed error */
            ETG_TRACE_ERR(("udev_device_get_action failed"));
            status = IAP2_CTL_ERROR;
        }
        udev_device_unref(device);
    }
    else
    {
        /* TODO more detailed error */
        ETG_TRACE_ERR(("udev_monitor_receive_device failed"));
        status = IAP2_CTL_ERROR;
    }

    return status;
}

S32 iPodControlIAP::load_modules(const bool carPlay)
{
    ENTRY;
    VARTRACE(carPlay);

    char paramStr[256];
    memset(&paramStr[0], 0, 256);
    //Check for unsupported white spaces in config strings
    string iManufacturer = LocalSPM::GetDataProvider().iPodControlAccessoryInfoManufacturer();
    string iProduct = LocalSPM::GetDataProvider().iPodControlAccessoryInfoModelName();

    sprintf(&paramStr[0], "idVendor=%s idProduct=%s iManufacturer=%s iProduct=%s iSerialNumber=%s bcdDevice=%s qmult=1%s", //SUZUKI-15330
            LocalSPM::GetDataProvider().iPodControlIAP2AccessoryVendorId().c_str(), \
            LocalSPM::GetDataProvider().iPodControlIAP2AccessoryProductId().c_str(), \
            iManufacturer.substr(0, iManufacturer.find(' ')).c_str(), \
            iProduct.substr(0, iProduct.find(' ')).c_str(), \
            LocalSPM::GetDataProvider().iPodControlAccessoryInfoSerialNumber().c_str(), \
            LocalSPM::GetDataProvider().iPodControlIAP2AccessoryBcdDevice().c_str(),
            !carPlay ? LocalSPM::GetDataProvider().iPodControlIAP2GadgetAudioParams().c_str() : "");

    /* issue the init_module system call */
    VARTRACE(paramStr);

    int res = IAP2_OK;
#ifdef VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
    CmdData result;
#endif
    tAllParameters parameters;

    //DEPENDENCY ORDER
#ifdef VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
    //MODULE_NAME_CONFIGFS
    //if(IAP2_OK == res) {

        strncpy_r(OUT parameters, IN MODULE_NAME_CONFIGFS, IN sizeof(parameters));
        result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_LOAD_MODULE, IN parameters);
        if (ERR_NONE != result.errorNo) {
            res = IAP2_CTL_ERROR;
        }
        VARTRACE(res);
    //}

    //MODULE_NAME_LIBCOMPOSITE
    if(IAP2_OK == res) {
        strncpy_r(OUT parameters, IN MODULE_NAME_LIBCOMPOSITE, IN sizeof(parameters));
        result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_LOAD_MODULE, IN parameters);
        if (ERR_NONE != result.errorNo) {
            res = IAP2_CTL_ERROR;
        }
        VARTRACE(res);
    }

    if(!LocalSPM::GetDataProvider().iPodControlIAP2ConfigFSEnabled()) { //required for GadgetFS only

        //MODULE_NAME_USB_F_FS
        if(IAP2_OK == res) {
            strncpy_r(OUT parameters, IN MODULE_NAME_USB_F_FS, IN sizeof(parameters));
            result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_LOAD_MODULE, IN parameters);
            if (ERR_NONE != result.errorNo) {
                res = IAP2_CTL_ERROR;
            }
            VARTRACE(res);
            res = IAP2_OK; //error expected on old kernel 3.8
        }

        //MODULE_NAME_U_EITHER
        if(IAP2_OK == res) {
            strncpy_r(OUT parameters, IN MODULE_NAME_U_EITHER, IN sizeof(parameters));
            result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_LOAD_MODULE, IN parameters);
            if (ERR_NONE != result.errorNo) {
                res = IAP2_CTL_ERROR;
            }
            VARTRACE(res);
            res = IAP2_OK; //error expected on old kernel 3.8
        }
    #if 0 //implicite load from carplay daemon?
        //MODULE_NAME_USB_F_NCM
        if(IAP2_OK == res) {
            strncpy_r(OUT parameters, IN MODULE_NAME_USB_F_NCM, IN sizeof(parameters));
            result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_LOAD_MODULE, IN parameters);
            if (ERR_NONE != result.errorNo) {
                res = IAP2_CTL_ERROR;
            }
            VARTRACE(res);
            res = IAP2_OK; //error expected on old kernel 3.8
        }
    #endif
        //MODULE_NAME_G_FFS
        if(IAP2_OK == res) {
            strncpy_r(OUT parameters, IN MODULE_NAME_G_FFS, IN sizeof(parameters));
            strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));
            strncat_r(OUT parameters, IN paramStr, IN sizeof(parameters));
            result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_LOAD_MODULE, IN parameters);
            if (ERR_NONE != result.errorNo) {
                res = IAP2_CTL_ERROR;
            }
            VARTRACE(res);
        }
    }
#else //VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
    //MODULE_NAME_CONFIGFS
    //if(IAP2_OK == res) {
        strncpy_r(OUT parameters, IN MODULE_NAME_CONFIGFS, IN sizeof(parameters));
        res = LocalSPM::GetRootDaemon().Command(IN GMPCommands::GMP_IAP_LOAD_MODULE, IN parameters);
        VARTRACE(res);
    //}

    //MODULE_NAME_LIBCOMPOSITE
    if(IAP2_OK == res) {
        strncpy_r(OUT parameters, IN MODULE_NAME_LIBCOMPOSITE, IN sizeof(parameters));
        res = LocalSPM::GetRootDaemon().Command(IN GMPCommands::GMP_IAP_LOAD_MODULE, IN parameters);
        VARTRACE(res);
    }

    if(!LocalSPM::GetDataProvider().iPodControlIAP2ConfigFSEnabled()) { //required for GadgetFS only

        //MODULE_NAME_USB_F_FS
        if(IAP2_OK == res) {
            strncpy_r(OUT parameters, IN MODULE_NAME_USB_F_FS, IN sizeof(parameters));
            res = LocalSPM::GetRootDaemon().Command(IN GMPCommands::GMP_IAP_LOAD_MODULE, IN parameters);
            VARTRACE(res);
            res = IAP2_OK; //error expected on old kernel 3.8
        }

        //MODULE_NAME_U_EITHER
        if(IAP2_OK == res) {
            strncpy_r(OUT parameters, IN MODULE_NAME_U_EITHER, IN sizeof(parameters));
            res = LocalSPM::GetRootDaemon().Command(IN GMPCommands::GMP_IAP_LOAD_MODULE, IN parameters);
            VARTRACE(res);
            res = IAP2_OK; //error expected on old kernel 3.8
        }
    #if 0 //implicite load from carplay daemon?
        //MODULE_NAME_USB_F_NCM
        if(IAP2_OK == res) {
            strncpy_r(OUT parameters, IN MODULE_NAME_USB_F_NCM, IN sizeof(parameters));
            res = LocalSPM::GetRootDaemon().Command(IN GMPCommands::GMP_IAP_LOAD_MODULE, IN parameters);
            VARTRACE(res);
            res = IAP2_OK; //error expected on old kernel 3.8
        }
    #endif
        //MODULE_NAME_G_FFS
        if(IAP2_OK == res) {
            strncpy_r(OUT parameters, IN MODULE_NAME_G_FFS, IN sizeof(parameters));
            strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));
            strncat_r(OUT parameters, IN paramStr, IN sizeof(parameters));
            res = LocalSPM::GetRootDaemon().Command(IN GMPCommands::GMP_IAP_LOAD_MODULE, IN parameters);
            VARTRACE(res);
        }
    }

#endif //VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
    return res;
}

/* unload_module - unload kernel module */
S32 iPodControlIAP::unload_modules_pre_umount()
{
    ENTRY;

    int res = IAP2_OK;
#ifdef VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
    CmdData result;
#endif
    tAllParameters parameters;

    if(LocalSPM::GetDataProvider().iPodControlIAP2ConfigFSEnabled()) {
    //REVERSE ORDER
#ifndef IPODCONTROL_IAP2_PF_CONFIGFS_NON_ROOT

#ifdef VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
        //MODULE_NAME_USB_F_NCM
        strncpy_r(OUT parameters, IN MODULE_NAME_USB_F_NCM, IN sizeof(parameters));
        result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_UNLOAD_MODULE, IN parameters);
        if (ERR_NONE != result.errorNo) {
            res = IAP2_CTL_ERROR;
        }
        VARTRACE(res);

        //MODULE_NAME_U_EITHER
        strncpy_r(OUT parameters, IN MODULE_NAME_U_EITHER, IN sizeof(parameters));
        result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_UNLOAD_MODULE, IN parameters);
        if (ERR_NONE != result.errorNo) {
            res = IAP2_CTL_ERROR;
        }
        VARTRACE(res);

        //MODULE_NAME_USB_F_UAC2
        strncpy_r(OUT parameters, IN MODULE_NAME_USB_F_UAC2, IN sizeof(parameters));
        result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_UNLOAD_MODULE, IN parameters);
        if (ERR_NONE != result.errorNo) {
            res = IAP2_CTL_ERROR;
        }
        VARTRACE(res);
#else // VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
        //MODULE_NAME_USB_F_NCM
        strncpy_r(OUT parameters, IN MODULE_NAME_USB_F_NCM, IN sizeof(parameters));
        res = LocalSPM::GetRootDaemon().Command(IN GMPCommands::GMP_IAP_UNLOAD_MODULE, IN parameters);
        VARTRACE(res);

        //MODULE_NAME_U_EITHER
        strncpy_r(OUT parameters, IN MODULE_NAME_U_EITHER, IN sizeof(parameters));
        res = LocalSPM::GetRootDaemon().Command(IN GMPCommands::GMP_IAP_UNLOAD_MODULE, IN parameters);
        VARTRACE(res);

        //MODULE_NAME_USB_F_UAC2
        strncpy_r(OUT parameters, IN MODULE_NAME_USB_F_UAC2, IN sizeof(parameters));
        res = LocalSPM::GetRootDaemon().Command(IN GMPCommands::GMP_IAP_UNLOAD_MODULE, IN parameters);
        VARTRACE(res);
#endif// VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
#endif
    }
    return res;
}

S32 iPodControlIAP::unload_modules()
{
    ENTRY;

    int res = IAP2_OK;
#ifdef VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
    CmdData result;
#endif
    tAllParameters parameters;

    //REVERSE ORDER
#ifdef VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
    if(LocalSPM::GetDataProvider().iPodControlIAP2ConfigFSEnabled()) {
#ifdef IPODCONTROL_IAP2_PF_CONFIGFS_NON_ROOT
        //MODULE_NAME_USB_F_NCM
        strncpy_r(OUT parameters, IN MODULE_NAME_USB_F_NCM, IN sizeof(parameters));
        result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_UNLOAD_MODULE, IN parameters);
        if (ERR_NONE != result.errorNo) {
            res = IAP2_CTL_ERROR;
        }
        VARTRACE(res);

        //MODULE_NAME_U_EITHER
        strncpy_r(OUT parameters, IN MODULE_NAME_U_EITHER, IN sizeof(parameters));
        result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_UNLOAD_MODULE, IN parameters);
        if (ERR_NONE != result.errorNo) {
            res = IAP2_CTL_ERROR;
        }
        VARTRACE(res);

        //MODULE_NAME_USB_F_UAC2
        strncpy_r(OUT parameters, IN MODULE_NAME_USB_F_UAC2, IN sizeof(parameters));
        result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_UNLOAD_MODULE, IN parameters);
        if (ERR_NONE != result.errorNo) {
            res = IAP2_CTL_ERROR;
        }
        VARTRACE(res);
#endif //IPODCONTROL_IAP2_PF_CONFIGFS_NON_ROOT
        //MODULE_NAME_USB_F_FS
        strncpy_r(OUT parameters, IN MODULE_NAME_USB_F_FS, IN sizeof(parameters));
        result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_UNLOAD_MODULE, IN parameters);
        if (ERR_NONE != result.errorNo) {
            res = IAP2_CTL_ERROR;
        }
        VARTRACE(res);

        //MODULE_NAME_G_FFS
        strncpy_r(OUT parameters, IN MODULE_NAME_G_FFS, IN sizeof(parameters));
        result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_UNLOAD_MODULE, IN parameters);
        if (ERR_NONE != result.errorNo) {
            res = IAP2_CTL_ERROR;
        }
        VARTRACE(res);


    } else {

        //MODULE_NAME_G_FFS
        strncpy_r(OUT parameters, IN MODULE_NAME_G_FFS, IN sizeof(parameters));
        result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_UNLOAD_MODULE, IN parameters);
        if (ERR_NONE != result.errorNo) {
            res = IAP2_CTL_ERROR;
        }
        VARTRACE(res);

        //MODULE_NAME_USB_F_NCM
        strncpy_r(OUT parameters, IN MODULE_NAME_USB_F_NCM, IN sizeof(parameters));
        result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_UNLOAD_MODULE, IN parameters);
        if (ERR_NONE != result.errorNo) {
            res = IAP2_CTL_ERROR;
        }
        VARTRACE(res);

        //MODULE_NAME_U_EITHER
        strncpy_r(OUT parameters, IN MODULE_NAME_U_EITHER, IN sizeof(parameters));
        result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_UNLOAD_MODULE, IN parameters);
        if (ERR_NONE != result.errorNo) {
            res = IAP2_CTL_ERROR;
        }
        VARTRACE(res);

        //MODULE_NAME_USB_F_FS
        strncpy_r(OUT parameters, IN MODULE_NAME_USB_F_FS, IN sizeof(parameters));
        result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_UNLOAD_MODULE, IN parameters);
        if (ERR_NONE != result.errorNo) {
            res = IAP2_CTL_ERROR;
        }
        VARTRACE(res);
    }

    //MODULE_NAME_LIBCOMPOSITE
    strncpy_r(OUT parameters, IN MODULE_NAME_LIBCOMPOSITE, IN sizeof(parameters));
    result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_UNLOAD_MODULE, IN parameters);
    if (ERR_NONE != result.errorNo) {
        res = IAP2_CTL_ERROR;
    }
    VARTRACE(res);

    //MODULE_NAME_CONFIGFS
    strncpy_r(OUT parameters, IN MODULE_NAME_CONFIGFS, IN sizeof(parameters));
    result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_UNLOAD_MODULE, IN parameters);
    if (ERR_NONE != result.errorNo) {
        res = IAP2_CTL_ERROR;
    }
    VARTRACE(res);

#else //VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER

    if(LocalSPM::GetDataProvider().iPodControlIAP2ConfigFSEnabled()) {
#ifdef IPODCONTROL_IAP2_PF_CONFIGFS_NON_ROOT
        //MODULE_NAME_USB_F_NCM
        strncpy_r(OUT parameters, IN MODULE_NAME_USB_F_NCM, IN sizeof(parameters));
        res = LocalSPM::GetRootDaemon().Command(IN GMPCommands::GMP_IAP_UNLOAD_MODULE, IN parameters);
        VARTRACE(res);

        //MODULE_NAME_U_EITHER
        strncpy_r(OUT parameters, IN MODULE_NAME_U_EITHER, IN sizeof(parameters));
        res = LocalSPM::GetRootDaemon().Command(IN GMPCommands::GMP_IAP_UNLOAD_MODULE, IN parameters);
        VARTRACE(res);

        //MODULE_NAME_USB_F_UAC2
        strncpy_r(OUT parameters, IN MODULE_NAME_USB_F_UAC2, IN sizeof(parameters));
        res = LocalSPM::GetRootDaemon().Command(IN GMPCommands::GMP_IAP_UNLOAD_MODULE, IN parameters);
        VARTRACE(res);
#endif //IPODCONTROL_IAP2_PF_CONFIGFS_NON_ROOT
        //MODULE_NAME_USB_F_FS
        strncpy_r(OUT parameters, IN MODULE_NAME_USB_F_FS, IN sizeof(parameters));
        res = LocalSPM::GetRootDaemon().Command(IN GMPCommands::GMP_IAP_UNLOAD_MODULE, IN parameters);
        VARTRACE(res);

        //MODULE_NAME_G_FFS
        strncpy_r(OUT parameters, IN MODULE_NAME_G_FFS, IN sizeof(parameters));
        res = LocalSPM::GetRootDaemon().Command(IN GMPCommands::GMP_IAP_UNLOAD_MODULE, IN parameters);
        VARTRACE(res);


    } else {

        //MODULE_NAME_G_FFS
        strncpy_r(OUT parameters, IN MODULE_NAME_G_FFS, IN sizeof(parameters));
        res = LocalSPM::GetRootDaemon().Command(IN GMPCommands::GMP_IAP_UNLOAD_MODULE, IN parameters);
        VARTRACE(res);

        //MODULE_NAME_USB_F_NCM
        strncpy_r(OUT parameters, IN MODULE_NAME_USB_F_NCM, IN sizeof(parameters));
        res = LocalSPM::GetRootDaemon().Command(IN GMPCommands::GMP_IAP_UNLOAD_MODULE, IN parameters);
        VARTRACE(res);

        //MODULE_NAME_U_EITHER
        strncpy_r(OUT parameters, IN MODULE_NAME_U_EITHER, IN sizeof(parameters));
        res = LocalSPM::GetRootDaemon().Command(IN GMPCommands::GMP_IAP_UNLOAD_MODULE, IN parameters);
        VARTRACE(res);

        //MODULE_NAME_USB_F_FS
        strncpy_r(OUT parameters, IN MODULE_NAME_USB_F_FS, IN sizeof(parameters));
        res = LocalSPM::GetRootDaemon().Command(IN GMPCommands::GMP_IAP_UNLOAD_MODULE, IN parameters);
        VARTRACE(res);
    }

    //MODULE_NAME_LIBCOMPOSITE
    strncpy_r(OUT parameters, IN MODULE_NAME_LIBCOMPOSITE, IN sizeof(parameters));
    res = LocalSPM::GetRootDaemon().Command(IN GMPCommands::GMP_IAP_UNLOAD_MODULE, IN parameters);
    VARTRACE(res);

    //MODULE_NAME_CONFIGFS
    strncpy_r(OUT parameters, IN MODULE_NAME_CONFIGFS, IN sizeof(parameters));
    res = LocalSPM::GetRootDaemon().Command(IN GMPCommands::GMP_IAP_UNLOAD_MODULE, IN parameters);
    VARTRACE(res);

#endif //VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
    return res;
}

S32 iPodControlIAP::iap2CommonWrite(const char* otgPath, const char* key, const char* value)
{
    ENTRY;
    VARTRACE(otgPath);
    VARTRACE(key);
    VARTRACE(value);

    S32 status = IAP2_OK;
#ifdef VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
    CmdData result;
#endif

    tAllParameters parameters;
#ifdef VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
    strncpy_r(OUT parameters, IN otgPath, IN sizeof(parameters));
    strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));
    strncat_r(OUT parameters, IN key, IN sizeof(parameters));
    strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));
    strncat_r(OUT parameters, IN value, IN sizeof(parameters));
    result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_COMMON_WRITE, IN parameters);
    if (ERR_NONE != result.errorNo) {
        status = IAP2_CTL_ERROR;
    }
#else //VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
    strncpy_r(OUT parameters, IN otgPath, IN sizeof(parameters));
    strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));
    strncat_r(OUT parameters, IN key, IN sizeof(parameters));
    strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));
    strncat_r(OUT parameters, IN value, IN sizeof(parameters));
    status = LocalSPM::GetRootDaemon().Command(IN GMPCommands::GMP_IAP_COMMON_WRITE, IN parameters);
#endif //VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER

    if(status != IAP2_OK) {
        ETG_TRACE_ERR(("iap2CommonWrite():  writing %40s/%40s to %40s failed", otgPath, key, value));
    } else {
        ETG_TRACE_USR3(("iap2CommonWrite():  writing  %40s/%40s to %40s OK", otgPath, key, value));
    }
    return status;
}

S32 iPodControlIAP::iap2CommonRead(IN const char* path, IN const char* subPath, OUT char* value, OUT tSize &len)
{
    ENTRY;
    VARTRACE(path);
    VARTRACE(subPath);
    VARTRACE(len);

    S32 status = IAP2_CTL_ERROR;

    //clear buffer
    memset(value, 0, len);

    char valuePath[256];
    int ret = snprintf(valuePath, 256, "%s/%s", path, subPath);

    if (ret >= 0 && ret < 256) {
        int file = open(valuePath, O_RDONLY);
        if (file >= 0) {
            ret = read(file, value, len-1); //keep last byte for \0
            if (ret >= 0) {
                status = IAP2_OK;
                len = ret; //read bytes
                ETG_TRACE_USR3(("iAP2CommonRead():  read: %s", value));
            } else {
                ETG_TRACE_ERR(("iAP2CommonRead():  read: %d %s", errno, strerror(errno)));
            }
            close(file);
        } else {
            ETG_TRACE_ERR(("iAP2CommonRead():  open: %d %s", errno, strerror(errno)));
        }
    }
    return status;
}

S32 iPodControlIAP::iap2findGlobPath(char* otgPath, const tSize len, const char * key,
        const char* otgGlob)
{
    ENTRY;
    VARTRACE(len);
    VARTRACE(otgGlob);
    VARTRACE(key);

    strncpy_r(otgPath, otgGlob, len);
    strncat_r(otgPath, "/", len);
    strncat_r(otgPath, key, len);

    glob_t found;
    S32 ret;
    if (0 == (ret = glob(otgPath, 0, NULL, &found)) && found.gl_pathc > 0)
    {
        strncpy_r(otgPath, found.gl_pathv[0], len);
        otgPath[strlen_r(otgPath) - strlen_r(key) - 1] = 0; /* terminate string before "/key" string */

        if (found.gl_pathc > 1)
        {
            ETG_TRACE_ERR(("iap2findGlobPath():  more than one OTG device found; use: %s", otgPath));
        }

        globfree(&found);
    }
    else if (ret == GLOB_NOMATCH)
    {
        ETG_TRACE_ERR(("iap2findGlobPath():  could not find Glob at %s", otgPath));
        ret = IAP2_CTL_ERROR;
    }
    else
    {
        ETG_TRACE_ERR(("iap2findGlobPath():  Glob error = %d", ret));
        ret = IAP2_CTL_ERROR;
    }

    return ret;
}

tBoolean iPodControlIAP::iAP2HasOTGPort(const tMountPoint mountPoint)
{
    ENTRY;

    IPOD_OTG_TYPE otgType = IPOD_OTG_NONE;
    int otgPort = -1;
    tPath otgPath = {0};
    tPath powerPortPath = {0};
    tPath udcDevice = {0};
    tPath hubVendorID = {0};
    tPath hubProductID = {0};

    struct udev* pUdev = udev_new();

    if(!pUdev) {
        ETG_TRACE_ERR(("udev_new() returned NULL"));
    } else {
        struct udev_enumerate* enumerate = udev_enumerate_new(pUdev);
        if (enumerate == NULL) {
            ETG_TRACE_ERR(("udev_enumerate_new() returned NULL"));
        } else {
            int ret = udev_enumerate_add_match_subsystem(enumerate, "usb");
            if(0 != ret) {
                ETG_TRACE_ERR(("udev_enumerate_add_match_subsystem failed: %d", ret));
            } else {
                char udev_vid[5];
                sprintf(udev_vid, "%04x", IAP2_APPLE_VENDOR_IDENTIFIER);
                ret = udev_enumerate_add_match_sysattr(enumerate, (const char*)"idVendor", (const char*)udev_vid);
                if(ret != 0) {
                    ETG_TRACE_ERR(("udev_enumerate_add_match_sysattr failed: %d", ret));
                } else {
                    ret = udev_enumerate_add_match_sysattr(enumerate, (const char*)"serial", (const char*)mountPoint);
                    if(ret != 0) {
                        ETG_TRACE_ERR(("udev_enumerate_add_match_sysattr failed: %d", ret));
                    } else {
                        ret = udev_enumerate_scan_devices(enumerate);
                        if(ret != 0) {
                            ETG_TRACE_ERR(("udev_enumerate_scan_devices failed: %d", ret));
                        } else {
                            struct udev_list_entry *pDevices = udev_enumerate_get_list_entry(enumerate);

                            struct udev_list_entry *pDevListEntry;
                            udev_list_entry_foreach(pDevListEntry, pDevices) {
                                const char *pPath = udev_list_entry_get_name(pDevListEntry);
                                struct udev_device *pDevice = udev_device_new_from_syspath(pUdev, pPath);
                                if(!pDevice) {
                                    ETG_TRACE_ERR(("udev_device_new_from_syspath() returned NULL"));
                                } else {
                                    const char *pSysPath = udev_device_get_syspath (pDevice);
                                    // /sys/devices/soc.0/2100000.aips-bus/2184000.usb/ci_hdrc.0/usb1/1-1

                                    ETG_TRACE_USR3(("udev_device_get_syspath: %s", pSysPath));
                                    ETG_TRACE_USR3(("udev_device_get_sysattr_value[idVendor]:  %s", udev_device_get_sysattr_value (pDevice, "idVendor")));
                                    ETG_TRACE_USR3(("udev_device_get_sysattr_value[idProduct]: %s", udev_device_get_sysattr_value (pDevice, "idProduct")));
                                    ETG_TRACE_USR3(("udev_device_get_sysattr_value[serial]:    %s", udev_device_get_sysattr_value (pDevice, "serial")));

                                    //CHECK target OTG port
                                    if(otgType == IPOD_OTG_NONE) {
                                        if(iAP2HasTargetOTGPort(pSysPath, otgPort, otgPath, powerPortPath, udcDevice, hubVendorID, hubProductID)) {
                                            otgType = IPOD_OTG_TARGET;
                                        }
                                    }

                                    //CHECK Molex hub
                                    if(otgType == IPOD_OTG_NONE && LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaMolexHubEnabled()) {
                                        if(iAP2HasMolexHub(pSysPath, otgPort, otgPath, powerPortPath, udcDevice, hubVendorID, hubProductID)) {
                                            otgType = IPOD_OTG_MOLEX;
                                        }
                                    }

                                    //CHECK Unwired hub
                                    if(otgType == IPOD_OTG_NONE && LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaUnwiredHubEnabled()) {
                                        if(iAP2HasUnwiredHub(pSysPath, otgPort, otgPath, powerPortPath, udcDevice, hubVendorID, hubProductID)){
                                            otgType = IPOD_OTG_UNWIRED;
                                        }
                                    }

                                    //CHECK Microchip hub
                                    if(otgType == IPOD_OTG_NONE && LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaMicrochipHubEnabled()) {
                                        if(iAP2HasMicrochipHub(pSysPath, otgPort, otgPath, powerPortPath, udcDevice, hubVendorID, hubProductID)){
                                            otgType = IPOD_OTG_MICROCHIP;
                                            InitCarPlayMicroChipHub();
                                        }
                                    }

                                    //CHECK Microchip Mitsumi Port2 ES2 hub equals Microchip hub plus extra bcdDevice check
                                    if(otgType == IPOD_OTG_NONE && LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaMitsumi2PortES2HubEnabled()) {
                                        if(iAP2HasMitsumi2PortES2Hub(pSysPath, otgPort, otgPath, powerPortPath, udcDevice, hubVendorID, hubProductID)){
                                            otgType = IPOD_OTG_MITSUMI_PORT2ES2;
                                            InitCarPlayMicroChipMitsumiPort2ES2();
                                        }
                                    }

                                    //CHECK Microchip Mitsumi Port2 ES4 hub has different bcdDevice than ES2 version
                                    if(otgType == IPOD_OTG_NONE && LocalSPM::GetDataProvider().iPodControlIAP2CarPlayViaMitsumi2PortES4HubEnabled()) {
                                        if(iAP2HasMitsumi2PortES4Hub(pSysPath, otgPort, otgPath, powerPortPath, udcDevice, hubVendorID, hubProductID)){
                                            otgType = IPOD_OTG_MITSUMI_PORT2ES4;
                                            InitCarPlayMicroChipMitsumiPort2ES4();
                                        }
                                    }
                                    udev_device_unref(pDevice);
                                }
                            }
                        }
                    }
                }
            }
            udev_enumerate_unref(enumerate);
        }
        udev_unref(pUdev);
    }

    VARTRACE(otgType);
    m_HandleMap.SetOTGType(mountPoint, otgType);

    VARTRACE(otgPath);
    m_HandleMap.SetOTGPath(mountPoint, otgPath);

    VARTRACE(udcDevice);
    m_HandleMap.SetUDCDevice(mountPoint, udcDevice);

    VARTRACE(otgPort);
    m_HandleMap.SetOTGPortNumber(mountPoint, otgPort);

    VARTRACE(powerPortPath);
    m_HandleMap.SetPowerPortPath(mountPoint, powerPortPath);

    VARTRACE(hubVendorID);
    m_HandleMap.SetHubVendorID(mountPoint, hubVendorID);

    VARTRACE(hubProductID);
    m_HandleMap.SetHubProductID(mountPoint, hubProductID);

    return (otgType != IPOD_OTG_NONE);
}

tBoolean iPodControlIAP::iAP2HasTargetOTGPort(const char* pSysPath, int &otgPort, tPath &otgPath, tPath &powerPortPath, tPath &udcDevice, tPath &hubVendorID, tPath &hubProductID)
{
    ENTRY;
    tBoolean otg_port = false;
    otgPort = -1;
    otgPath[0] = 0;
    powerPortPath[0] = 0;
    udcDevice[0] = 0;
    hubVendorID[0] = 0;
    hubProductID[0] = 0;

    tPath gadgetPath = {0};
    snprintf(gadgetPath, sizeof(gadgetPath), "%s/../../%s", pSysPath, STR_GADGET);
    VARTRACE(gadgetPath);

    if (0 == access(gadgetPath, F_OK)) {

        snprintf(gadgetPath, sizeof(gadgetPath), "%s/../../../ci_hdrc*", pSysPath);
        glob_t found;
        if (0 == glob(gadgetPath, 0, NULL, &found) && found.gl_pathc > 0) {
            strncpy_r(gadgetPath, found.gl_pathv[0], sizeof(gadgetPath));
            VARTRACE(gadgetPath);
            if (found.gl_pathc > 1) {
                ETG_TRACE_ERR(("more than one OTG device found; use: %s", gadgetPath));
            }

            globfree(&found);

            //get udc device
            const char * p_udcDevice = strrchr(gadgetPath,'/');
            VARTRACE(p_udcDevice);
            if(p_udcDevice) {
                strncpy_r(udcDevice, p_udcDevice+1, sizeof(udcDevice)); //find last '/'
                strncpy_r(otgPath, gadgetPath, sizeof(otgPath));
                otg_port = true;
                ETG_TRACE_USR3(("---------------------"));
                ETG_TRACE_USR3(("Target OTG port found"));
                ETG_TRACE_USR3(("---------------------"));
            }

        }
    }
    VARTRACE(otg_port);
    return otg_port;
}


tBoolean iPodControlIAP::iAP2HasMitsumi2PortES4Hub(IN const char* pSysPath, OUT int &otgPort, OUT tPath &otgPath, OUT tPath &powerPortPath, OUT tPath &udcDevice, OUT tPath &hubVendorID, OUT tPath &hubProductID)
{
    ENTRY;

    ETG_TRACE_USR3(("iAP2HasMitsumi2PortES2Hub: AIVI-Project - 2nd used HUB"));
    ETG_TRACE_USR3(("iAP2HasMitsumi2PortES4Hub: uses iAP2HasMicrochipHub()"));
    tBoolean bRes= iAP2HasMicrochipHub(pSysPath, otgPort, otgPath, powerPortPath, udcDevice, hubVendorID, hubProductID);

    ETG_TRACE_USR3(("iAP2HasMitsumi2PortES4Hub: BcdDevice check: (Note: libusb uses expression 'bcdDevice' which equals 'ID_REVISION' for udev which equyls 'bcdDevice' for iapCommonRead"));

    if(bRes)
    {
        bRes = FALSE;
        ETG_TRACE_USR3(("iAP2HasMitsumi2PortES4Hub: additional check 'bcdDevice'"));

        tPath gadgetPath = {0};
        snprintf(gadgetPath, sizeof(gadgetPath), "%s/../%s", pSysPath, MITSUMIPORT2ES4_PATH);

        tSearchString hubBcdDevice,Mitsumi2PortES2bcdDev;

        //tSearchString ExpecedHubBcdDevice_A,ExpecedHubBcdDevice_B;

        tSize hubbcdDeviceLen = sizeof(hubBcdDevice);
        int ret = iap2CommonRead(gadgetPath, "bcdDevice", hubBcdDevice, hubbcdDeviceLen);

        if(ret == IAP2_OK) {
             VARTRACE(hubbcdDeviceLen);
             if(hubbcdDeviceLen > 0 && hubBcdDevice[hubbcdDeviceLen-1] == '\n')
             {
                 //trimm
                 hubBcdDevice[hubbcdDeviceLen-1] = '\0';
                 strncpy_r(Mitsumi2PortES2bcdDev, LocalSPM::GetDataProvider().iPodControlIAP2CarMitsumi2PortES2bcdDevice_A().c_str(), sizeof(tSearchString));


                 ETG_TRACE_USR3(("iAP2HasMitsumi2PortES4Hub: ->hubBcdDevice<-         : ->%s<-",hubBcdDevice));
                 ETG_TRACE_USR3(("iAP2HasMitsumi2PortES4Hub: ->Mitsumi2PortES2bcdDev<-: ->%s<-",Mitsumi2PortES2bcdDev));

                 if(0 == strcmp(hubBcdDevice,Mitsumi2PortES2bcdDev))
                 {
                     ETG_TRACE_USR3(("iAP2HasMitsumi2PortES4Hub: bcdDevice Mitsumi2PortES4Hub:  NO (but Mitsumi2PortES2bsdDev)"));
                 }
                 else
                 {
                     //--------
                     //FOUND
                     //--------
                     //i.e. unequal Mitsumi2PortES2Hub is treated as Mitsumi2PortES4Hub
                     ETG_TRACE_USR3(("-----------------------------------------------------------"));
                     ETG_TRACE_USR3(("iAP2HasMitsumi2PortES2Hub: MITSUMI-HUB 2PortES4: FOUND"));
                     ETG_TRACE_USR3(("-----------------------------------------------------------"));

                     bRes = TRUE;
                 }
             }
         }


         ETG_TRACE_USR3(("iAP2HasMitsumi2PortES4Hub: bRes= 0x%x, bcdDevice: %s ",bRes,hubBcdDevice));
     }

    return bRes;
}


tBoolean iPodControlIAP::iAP2HasMitsumi2PortES2Hub(IN const char* pSysPath, OUT int &otgPort, OUT tPath &otgPath, OUT tPath &powerPortPath, OUT tPath &udcDevice, OUT tPath &hubVendorID, OUT tPath &hubProductID)
{
    ENTRY;

    ETG_TRACE_USR3(("iAP2HasMitsumi2PortES2Hub: AIVI-Project - 1st used HUB"));
    ETG_TRACE_USR3(("iAP2HasMitsumi2PortES2Hub: uses iAP2HasMicrochipHub()"));
    tBoolean bRes= iAP2HasMicrochipHub(pSysPath, otgPort, otgPath, powerPortPath, udcDevice, hubVendorID, hubProductID);

    ETG_TRACE_USR3(("iAP2HasMitsumi2PortES2Hub: BcdDevice check: (Note: libusb uses expression 'bcdDevice' which equals 'ID_REVISION' for udev which equyls 'bcdDevice' for iapCommonRead"));

    if(bRes)
    {
        bRes = FALSE;
        ETG_TRACE_USR3(("iAP2HasMitsumi2PortES2Hub: additional check 'bcdDevice'"));

        tPath gadgetPath = {0};
        snprintf(gadgetPath, sizeof(gadgetPath), "%s/../%s", pSysPath, MITSUMIPORT2ES2_PATH);

        tSearchString hubBcdDevice, ExpecedHubBcdDevice_A;
        tSize hubbcdDeviceLen = sizeof(hubBcdDevice);
        int ret = iap2CommonRead(gadgetPath, "bcdDevice", hubBcdDevice, hubbcdDeviceLen);

        if(ret == IAP2_OK) {
             VARTRACE(hubbcdDeviceLen);
             if(hubbcdDeviceLen > 0 && hubBcdDevice[hubbcdDeviceLen-1] == '\n')
             {
                 //trimm
                 hubBcdDevice[hubbcdDeviceLen-1] = '\0';

                 strncpy_r(ExpecedHubBcdDevice_A, LocalSPM::GetDataProvider().iPodControlIAP2CarMitsumi2PortES2bcdDevice_A().c_str(), sizeof(tSearchString));

                 ETG_TRACE_USR3(("iAP2HasMitsumi2PortES2Hub: ->hubBcdDevice<-         : ->%s<- ",hubBcdDevice));
                 ETG_TRACE_USR3(("iAP2HasMitsumi2PortES2Hub: ->ExpecedHubBcdDevice_A<-: ->%s<-",ExpecedHubBcdDevice_A));

                 if(0 == strcmp(hubBcdDevice,ExpecedHubBcdDevice_A))
                 {
                     bRes = TRUE;
                     ETG_TRACE_USR3(("-----------------------------------------------------------"));
                     ETG_TRACE_USR3(("iAP2HasMitsumi2PortES2Hub: MITSUMI-HUB 2PortES2: FOUND"));
                     ETG_TRACE_USR3(("-----------------------------------------------------------"));
                 }
                 else
                 {
                     ETG_TRACE_USR3(("iAP2HasMitsumi2PortES2Hub: bcdDevice does not match"));
                 }
             }
         }

         ETG_TRACE_USR3(("iAP2HasMitsumi2PortES2Hub: bRes= 0x%x, bcdDevice: %s ",bRes,hubBcdDevice));
     }

    return bRes;
}


tBoolean iPodControlIAP::iAP2HasMicrochipHub(IN const char* pSysPath, OUT int &otgPort, OUT tPath &otgPath, OUT tPath &powerPortPath, OUT tPath &udcDevice, OUT tPath &hubVendorID, OUT tPath &hubProductID)
{
    ENTRY;
    tBoolean otg_port = false;

    otgPort = -1;
    otgPath[0] = 0;
    powerPortPath[0] = 0;
    udcDevice[0] = 0;
    hubVendorID[0] = 0;
    hubProductID[0] = 0;

    //check for Microchip hub
    tPath gadgetPath = {0};
    snprintf(gadgetPath, sizeof(gadgetPath), "%s/../%s", pSysPath, MICROCHIP_PATH);
    VARTRACE(gadgetPath);
    if (0 == access(gadgetPath, F_OK)) {

        //determin HUB ids
        tSize vendorLen = sizeof(hubVendorID);
        int ret = iap2CommonRead(gadgetPath, "idVendor", hubVendorID, vendorLen);
        ETG_TRACE_USR3(("iap2CommonRead returned %d", ret));
        if(ret == IAP2_OK) {
            VARTRACE(vendorLen);
            if(vendorLen > 0 && hubVendorID[vendorLen-1] == '\n') {
                //truncate trailing LF
                hubVendorID[vendorLen-1] = 0;
            }
        }
        VARTRACE(hubVendorID);

        tSize productLen = sizeof(hubProductID);
        ret = iap2CommonRead(gadgetPath, "idProduct", hubProductID, productLen);
        ETG_TRACE_USR3(("iap2CommonRead returned %d", ret));
        if(ret == IAP2_OK) {
            VARTRACE(productLen);
            if(productLen > 0 && hubProductID[productLen-1] == '\n') {
                //truncate trailing LF
                hubProductID[productLen-1] = 0;
            }
        }
        VARTRACE(hubProductID);

        //check Microchip IDs
        if(!strncmp(MICROCHIP_VID_STR, hubVendorID, vendorLen) && !strncmp(USB84604_PID_STR, hubProductID, productLen)) {

            //store hub port number
            tPath deviceSubAddr = {0};
            tPath devicePort = {0};

            const char * p_deviceSubAddr = strrchr(pSysPath,'/');
            VARTRACE(p_deviceSubAddr);
            if(p_deviceSubAddr) {
                strncpy_r(deviceSubAddr, p_deviceSubAddr+1, sizeof(deviceSubAddr)); //find last '/'
                VARTRACE(deviceSubAddr);

                const char * p_devicePort = strrchr(deviceSubAddr,'.');
                VARTRACE(p_devicePort);
                if(p_devicePort) {
                    strncpy_r(devicePort, p_devicePort+1, sizeof(devicePort)); //find last '.'
                    VARTRACE(devicePort);
                }
            }
            if(deviceSubAddr[0] != 0 && devicePort[0] != 0) {
                tSize syslen = strlen_r(pSysPath);
                tSize sublen = strlen_r(deviceSubAddr);
                tSize porlen = strlen_r(devicePort);

                if(syslen > sublen && sublen > (porlen+1)) {
                    deviceSubAddr[sublen-(porlen+1)] = 0; //cut port and '.'
                    VARTRACE(deviceSubAddr);
                    otgPort = strtol (devicePort,NULL,10);
                }
            }
            VARTRACE(otgPort);

            if(otgPort == 1 || otgPort == 2) {

                //check for target OTG port
                //J1 /sys/devices/soc0/soc.0/2100000.aips-bus/2184000.usb/ci_hdrc.0/usb1/1-1/1-1.1/../../gadget
                //J2 /sys/devices/soc0/soc.0/2100000.aips-bus/2184000.usb/ci_hdrc.0/usb1/1-1/1-1.2/../../gadget

                snprintf(gadgetPath, sizeof(gadgetPath), "%s/../../../%s", pSysPath, STR_GADGET);
                VARTRACE(gadgetPath);

                if (0 == access(gadgetPath, F_OK)) {

                    snprintf(gadgetPath, sizeof(gadgetPath), "%s/../../../../ci_hdrc*", pSysPath);
                    glob_t found;
                    if (0 == glob(gadgetPath, 0, NULL, &found) && found.gl_pathc > 0) {
                        strncpy_r(gadgetPath, found.gl_pathv[0], sizeof(gadgetPath));
                        VARTRACE(gadgetPath);
                        if (found.gl_pathc > 1) {
                            ETG_TRACE_ERR(("more than one OTG device found; use: %s", gadgetPath));
                        }

                        globfree(&found);

                        //get udc device
                        const char * p_udcDevice = strrchr(gadgetPath,'/');
                        VARTRACE(p_udcDevice);
                        if(p_udcDevice) {
                            strncpy_r(udcDevice, p_udcDevice+1, sizeof(udcDevice)); //find last '/'
                            strncpy_r(otgPath, gadgetPath, sizeof(otgPath));
                            otg_port = true;
                            ETG_TRACE_USR3(("- - - - - - - - - - - - - - - - - - - -"));
                            ETG_TRACE_USR3(("Microchip hub and target OTG port found"));
                            ETG_TRACE_USR3(("- - - - - - - - - - - - - - - - - - - -"));
                        }
                    }
                }
            }
        }
    }

    VARTRACE(otg_port);
    return otg_port;
}

tBoolean iPodControlIAP::iAP2HasUnwiredHub(IN const char* pSysPath, OUT int &otgPort, OUT tPath &otgPath, OUT tPath &powerPortPath, OUT tPath &udcDevice, OUT tPath &hubVendorID, OUT tPath &hubProductID)
{
    ENTRY;
    tBoolean otg_port = false;

    otgPort = -1;
    otgPath[0] = 0;
    powerPortPath[0] = 0;
    udcDevice[0] = 0;
    hubVendorID[0] = 0;
    hubProductID[0] = 0;

    // pSysPath     /sys/devices/soc.0/2100000.aips-bus/2184000.usb/ci_hdrc.0/usb1/1-1/1-1.3
    // gadgetPath   /sys/devices/soc.0/2100000.aips-bus/2184000.usb/ci_hdrc.0/usb1/1-1/1-1.5/1-1.5:1.0/bridgeport

    tPath deviceSubAddr = {0};
    tPath devicePort = {0};

    const char * p_deviceSubAddr = strrchr(pSysPath,'/');
    VARTRACE(p_deviceSubAddr);
    if(p_deviceSubAddr) {
        strncpy_r(deviceSubAddr, p_deviceSubAddr+1, sizeof(deviceSubAddr)); //find last '/'
        VARTRACE(deviceSubAddr);

        const char * p_devicePort = strrchr(deviceSubAddr,'.');
        VARTRACE(p_devicePort);
        if(p_devicePort) {
            strncpy_r(devicePort, p_devicePort+1, sizeof(devicePort)); //find last '.'
            VARTRACE(devicePort);
        }
    }
    if(deviceSubAddr[0] != 0 && devicePort[0] != 0) {
        tSize syslen = strlen_r(pSysPath);
        tSize sublen = strlen_r(deviceSubAddr);
        tSize porlen = strlen_r(devicePort);

        if(syslen > sublen && sublen > (porlen+1)) {
            deviceSubAddr[sublen-(porlen+1)] = 0; //cut port and '.'
            VARTRACE(deviceSubAddr);
            const int portNumber = strtol (devicePort,NULL,10);

            tPath otgBase = {0};
            strncpy_r(otgBase, pSysPath, sizeof(otgBase));
            if(p_deviceSubAddr) {
                otgBase[syslen - strlen_r(p_deviceSubAddr)] = 0; //cut sub path
            }
            VARTRACE(otgBase);

            //determin HUB id for charging configuration
            tSize vendorLen = sizeof(hubVendorID);
            int ret = iap2CommonRead(otgBase, "idVendor", hubVendorID, vendorLen);
            ETG_TRACE_USR3(("iap2CommonRead returned %d", ret));
            if(ret == IAP2_OK) {
                VARTRACE(vendorLen);
                if(vendorLen > 0 && hubVendorID[vendorLen-1] == '\n') {
                    //truncate trailing LF
                    hubVendorID[vendorLen-1] = 0;
                }
            }

            tSize productLen = sizeof(hubProductID);
            ret = iap2CommonRead(otgBase, "idProduct", hubProductID, productLen);
            ETG_TRACE_USR3(("iap2CommonRead returned %d", ret));
            if(ret == IAP2_OK) {
                VARTRACE(productLen);
                if(productLen > 0 && hubProductID[productLen-1] == '\n') {
                    //truncate trailing LF
                    hubProductID[productLen-1] = 0;
                }
            }

            //check for bridgeport
            tPath gadgetPath = {0};
            snprintf(gadgetPath, sizeof(gadgetPath), "%s/%s.5/%s.5:1.0/%s", otgBase, deviceSubAddr, deviceSubAddr, STR_BRIDGE);
            VARTRACE(gadgetPath);
            if (0 == access(gadgetPath, F_OK)) {

                //get UDC
                glob_t foundudc;
                tPath udcPath = {0};
                snprintf(udcPath, sizeof(udcPath), "%s/%s.5/%s.5:1.0/utbridge_udc*", otgBase, deviceSubAddr, deviceSubAddr);
                if (0 == glob(udcPath, 0, NULL, &foundudc) && foundudc.gl_pathc > 0) {
                    strncpy_r(udcPath, foundudc.gl_pathv[0], sizeof(udcPath));
                    VARTRACE(udcPath);
                    if (foundudc.gl_pathc > 1) {
                        ETG_TRACE_ERR(("more than one UDV device found; use: %s", udcPath));
                    }
                    globfree(&foundudc);
                    const char * p_udcDevice = strrchr(udcPath,'/');
                    VARTRACE(p_udcDevice);
                    if(p_udcDevice) {
                        strncpy_r(udcDevice, p_udcDevice+1, sizeof(udcDevice)); //find last '/'
                        snprintf(otgPath, sizeof(otgPath), "%s/%s.5/%s.5:1.0", otgBase, deviceSubAddr, deviceSubAddr);
                        otgPort = portNumber;
                        snprintf(powerPortPath, sizeof(powerPortPath), "%s/%s:1.0", otgBase, deviceSubAddr);
                        otg_port = true;
                        ETG_TRACE_USR3(("-----------------------------"));
                        ETG_TRACE_USR3(("UNWIRED port found"));
                        ETG_TRACE_USR3(("-----------------------------"));
                    }
                }
            }
        }
    }
    VARTRACE(otg_port);
    return otg_port;
}

tBoolean iPodControlIAP::iAP2HasMolexHub(IN const char* pSysPath, OUT int &otgPort, OUT tPath &otgPath, OUT tPath &powerPortPath, OUT tPath &udcDevice, OUT tPath &hubVendorID, OUT tPath &hubProductID)
{
    ENTRY;
    tBoolean otg_port = false;

    const char* MOLEX_PID_STR_1 = "4914";
    const char* MOLEX_PID_STR_2 = "4913"; //RTC-528893: Molex hub with Product ID 4913

    otgPort = -1;
    otgPath[0] = 0;
    powerPortPath[0] = 0;
    udcDevice[0] = 0;
    hubVendorID[0] = 0;
    hubProductID[0] = 0;

    // pSysPath     /sys/devices/soc.0/2100000.aips-bus/2184000.usb/ci_hdrc.0/usb1/1-1/1-1.1

    tPath deviceSubAddr = {0};
    tPath devicePort = {0};

    const char * p_deviceSubAddr = strrchr(pSysPath,'/');
    VARTRACE(p_deviceSubAddr);
    if(p_deviceSubAddr)
    {
        strncpy_r(deviceSubAddr, p_deviceSubAddr+1, sizeof(deviceSubAddr)); //find last '/'
        VARTRACE(deviceSubAddr);

        const char * p_devicePort = strrchr(deviceSubAddr,'.');
        VARTRACE(p_devicePort);
        if(p_devicePort) {
            strncpy_r(devicePort, p_devicePort+1, sizeof(devicePort)); //find last '.'
            VARTRACE(devicePort);
        }
    }
    if(deviceSubAddr[0] != 0 && devicePort[0] != 0)
    {
        tSize syslen = strlen_r(pSysPath);
        tSize sublen = strlen_r(deviceSubAddr);
        tSize portLength = strlen_r(devicePort);

        if(syslen > sublen && sublen > (portLength+1))
        {
            deviceSubAddr[sublen-(portLength+1)] = 0; //cut port and '.'
            VARTRACE(deviceSubAddr);
            otgPort = (int) strtol (devicePort,NULL,10);
            VARTRACE(otgPort);

            tPath otgBase = {0};
            strncpy_r(otgBase, pSysPath, sizeof(otgBase));
            if(p_deviceSubAddr) {
                otgBase[syslen - strlen_r(p_deviceSubAddr)] = 0; //cut sub path
            }
            VARTRACE(otgBase);

            //determin HUB id for charging configuration
            tSize vendorLen = sizeof(hubVendorID);
            int ret = iap2CommonRead(otgBase, "idVendor", hubVendorID, vendorLen);
            ETG_TRACE_USR3(("iap2CommonRead returned %d", ret));
            if(ret == IAP2_OK) {
                VARTRACE(vendorLen);
                if(vendorLen > 0 && hubVendorID[vendorLen-1] == '\n') {
                    //truncate trailing LF
                    hubVendorID[vendorLen-1] = 0;
                }
            }
            VARTRACE(hubVendorID);

            tSize productLen = sizeof(hubProductID);
            ret = iap2CommonRead(otgBase, "idProduct", hubProductID, productLen);
            ETG_TRACE_USR3(("iap2CommonRead returned %d", ret));
            if(ret == IAP2_OK) {
                VARTRACE(productLen);
                if(productLen > 0 && hubProductID[productLen-1] == '\n') {
                    //truncate trailing LF
                    hubProductID[productLen-1] = 0;
                }
            }
            VARTRACE(hubProductID);

            //check Microchip IDs
            if ((!strncmp(MICROCHIP_VID_STR, hubVendorID, vendorLen))
                    && ((!strncmp(MOLEX_PID_STR_1, hubProductID, productLen)) || (!strncmp(MOLEX_PID_STR_2, hubProductID, productLen))))
            {
                VARTRACE(otgPort);
                if (otgPort == 1 || otgPort == 2)
                {
                    //Only port 1 and 2 on Molex hub [USB4914] as Multihost ports. Others are standard.
                    otg_port = true;
                }
            }
        }
    }

    VARTRACE(otg_port);
    return otg_port;
}

tBoolean iPodControlIAP::iAP2HasCarPlayCapability(const tMountPoint mountPoint)
{
    ENTRY;
    VARTRACE(mountPoint);

    tBoolean res = false;
    //iOS9 feature

    int libusb_status = 0;
    libusb_device** devices = NULL;
    ssize_t device_count = 0;
    libusb_context *usb_context = NULL;
    libusb_device_handle* target_device_handle = NULL;

    if(0 == (libusb_status = libusb_init(&usb_context))) {

        device_count = libusb_get_device_list(usb_context, &devices);
        VARTRACE(device_count);
        if(device_count >= 0 && *devices != NULL) {

            unsigned char device_serial[IAP2_USB_MAX_STRING_DESCRIPTOR_LENGTH];

            /* go through all device descriptors */
            for (ssize_t i = 0; (i < device_count) && (devices[i] != NULL); i++) {
                struct libusb_device_descriptor descriptor;
                int status = libusb_get_device_descriptor(devices[i], &descriptor);
                //VARTRACE(status);
                if (status == 0) {
                    /* check vendor id and product id */
                    if (descriptor.idVendor == IAP2_APPLE_VENDOR_IDENTIFIER && ((descriptor.idProduct & 0xff00) == (IAP2_APPLE_PRODUCT_IDENTIFIER & 0xff00))) {
                        /* open device */
                        status = libusb_open(devices[i], &target_device_handle);
                        VARTRACE(status);

                        /* check serial number (if available) */
                        if (status == 0) {
                            status = libusb_get_string_descriptor_ascii(target_device_handle, descriptor.iSerialNumber, device_serial, IAP2_USB_MAX_STRING_DESCRIPTOR_LENGTH);
                            int serial_cmp = -1;
                            if ((mountPoint != NULL) && (status > 0)){
                                serial_cmp = strncmp(mountPoint, (const char*)&device_serial[0], strlen_r(mountPoint));
                            } else{
                                serial_cmp = 0;
                            }
                            if (0 == serial_cmp) {
                                /* serial match, do nothing */
                            } else {
                                /* wrong serial number, close device again */
                                libusb_close(target_device_handle);
                                target_device_handle = NULL;
                            }
                        }

                        /* device found */
                        if (target_device_handle != NULL) {
                            break;
                        }
                    }
                }
            }

            if (target_device_handle != NULL) {
                unsigned char dat[] = {0,0,0,0};
                int status = libusb_control_transfer(target_device_handle,
                                                  0xC0  /*RequestType*/,
                                                  0x53, /*Request*/
                                                  0x00, /*value*/
                                                  0x00, /*Index*/
                                                  dat, /*data*/
                                                  4, /*length*/
                                                  3000);
                VARTRACE(status);
                res = false;
                if(status == 4 && (dat[0] & 0x01)) {
                    VARTRACE(dat[0]);
                    res = true;
                } else {
                    res = false; //CarPlay not supported, iOS < 8.3
                }
            }
        }
    }

    if(target_device_handle != NULL) {
        libusb_close(target_device_handle);
        target_device_handle = NULL;
    }

    /* free device list */
    if(devices != NULL) {
        libusb_free_device_list(devices, 1 /* unref devices by 1 */);
        devices = NULL;
    }

    /* close libusb */
    if ((libusb_status == 0) && (usb_context)) {
        libusb_exit(usb_context);
        usb_context = NULL;
    }

    VARTRACE(res);
    return res;
}

tResult iPodControlIAP::iAP2_LocationInformation(const tMountPoint mountPoint,
        const tDiPOGPGGAData diPOGPGGAData,
        const tDiPOGPRMCData diPOGPRMCData,
        const tDiPOGPRMCData diPOGPGSVData,
        const tDiPOGPRMCData diPOGPHDTData,
        const tDiPOGPRMCData diPOPASCDData,
        const tDiPOGPRMCData diPOPAGCDData,
        const tDiPOGPRMCData diPOPAACDData)
{
    ENTRY;
    VARTRACE(mountPoint);
    tResult ret = MP_NO_ERROR;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else if(m_HandleMap.GetLocationInformationUpdate(mountPoint)){
        m_HandleMap.LockIAP2(mountPoint); //start critical section
        iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(mountPoint);
        if(iap2Device) {

            iAP2LocationInformationParameter locationInformationParameter;
            memset(&locationInformationParameter, 0, sizeof(iAP2LocationInformationParameter));
            locationInformationParameter.iAP2NMEASentence = new U8*[7];
            if(locationInformationParameter.iAP2NMEASentence) {

                int i = 0;
                //GPGGA
                if(diPOGPGGAData[0] != 0) {
                    size_t size = strnlen(diPOGPGGAData, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
                    locationInformationParameter.iAP2NMEASentence[i] = new U8[size];
                    if(locationInformationParameter.iAP2NMEASentence[i]) {
                        strncpy_r((char *)locationInformationParameter.iAP2NMEASentence[i], diPOGPGGAData, size);
                        locationInformationParameter.iAP2NMEASentence_count++;
                        i++;
                    }
                }
                //GPRMC
                if(diPOGPRMCData[0] != 0) {
                    size_t size = strnlen(diPOGPRMCData, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
                    locationInformationParameter.iAP2NMEASentence[i] = new U8[size];
                    if(locationInformationParameter.iAP2NMEASentence[i]) {
                        strncpy_r((char *)locationInformationParameter.iAP2NMEASentence[i], diPOGPRMCData, size);
                        locationInformationParameter.iAP2NMEASentence_count++;
                        i++;
                    }
                }
                //GPGSV
                if(diPOGPGSVData[0] != 0) {
                    size_t size = strnlen(diPOGPGSVData, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
                    locationInformationParameter.iAP2NMEASentence[i] = new U8[size];
                    if(locationInformationParameter.iAP2NMEASentence[i]) {
                        strncpy_r((char *)locationInformationParameter.iAP2NMEASentence[i], diPOGPGSVData, size);
                        locationInformationParameter.iAP2NMEASentence_count++;
                        i++;
                    }
                }
                //GPHDT
                if(diPOGPHDTData[0] != 0) {
                    size_t size = strnlen(diPOGPHDTData, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
                    locationInformationParameter.iAP2NMEASentence[i] = new U8[size];
                    if(locationInformationParameter.iAP2NMEASentence[i]) {
                        strncpy_r((char *)locationInformationParameter.iAP2NMEASentence[i], diPOGPHDTData, size);
                        locationInformationParameter.iAP2NMEASentence_count++;
                        i++;
                    }
                }
                //PASCD
                if(diPOPASCDData[0] != 0) {
                    size_t size = strnlen(diPOPASCDData, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
                    locationInformationParameter.iAP2NMEASentence[i] = new U8[size];
                    if(locationInformationParameter.iAP2NMEASentence[i]) {
                        strncpy_r((char *)locationInformationParameter.iAP2NMEASentence[i], diPOPASCDData, size);
                        locationInformationParameter.iAP2NMEASentence_count++;
                        i++;
                    }
                }
                //PAGCD
                if(diPOPAGCDData[0] != 0) {
                    size_t size = strnlen(diPOPAGCDData, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
                    locationInformationParameter.iAP2NMEASentence[i] = new U8[size];
                    if(locationInformationParameter.iAP2NMEASentence[i]) {
                        strncpy_r((char *)locationInformationParameter.iAP2NMEASentence[i], diPOPAGCDData, size);
                        locationInformationParameter.iAP2NMEASentence_count++;
                        i++;
                    }
                }
                //PAACD
                if(diPOPAACDData[0] != 0) {
                    size_t size = strnlen(diPOPAACDData, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
                    locationInformationParameter.iAP2NMEASentence[i] = new U8[size];
                    if(locationInformationParameter.iAP2NMEASentence[i]) {
                        strncpy_r((char *)locationInformationParameter.iAP2NMEASentence[i], diPOPAACDData, size);
                        locationInformationParameter.iAP2NMEASentence_count++;
                        i++;
                    }
                }

                if(locationInformationParameter.iAP2NMEASentence_count) {
                    int res = iAP2LocationInformation(iap2Device, &locationInformationParameter);
                    ETG_TRACE_USR3(("iAP2LocationInformation returned %d", res));
                    if(IAP2_OK != res) {
                        ret = MP_ERR_IPOD_COMMAND;
                        UpdateIpodCommunicationError(res);
                    }
                }

                iAP2FreeiAP2LocationInformationParameter(&locationInformationParameter);
            }
        }
        m_HandleMap.UnlockIAP2(mountPoint); //end critical section
    } else {
        ETG_TRACE_USR3(("LocationInformationUpdate ignored"));
    }
    return ret;
}

tResult iPodControlIAP::iAP2SetLocationInformationUpdate(const tMountPoint mountPoint, tBoolean enableUpdates)
{
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(enableUpdates);
    m_HandleMap.SetLocationInformationUpdate(mountPoint, enableUpdates);
    return MP_NO_ERROR;
}

tResult iPodControlIAP::iAP2_VehicleStatusUpdate(
        const tMountPoint mountPoint,
        const tOutsideTemperature outsideTemperature)
{
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(outsideTemperature);
    tResult ret = MP_NO_ERROR;

    if(outsideTemperature == INVALID_OUTSIDE_TEMPERATURE) {
        ret = MP_ERR_IPOD_INVALID_PARAM;
    } else if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else if(m_HandleMap.GetVehicleStatusUpdate(mountPoint)){
        m_HandleMap.LockIAP2(mountPoint); //start critical section
        iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(mountPoint);
        if(iap2Device) {

            iAP2VehicleStatusUpdateParameter vehicleStatusUpdateParameter;
            memset(&vehicleStatusUpdateParameter, 0, sizeof(iAP2VehicleStatusUpdateParameter));

            //outside temp
            vehicleStatusUpdateParameter.iAP2OutsideTemperature = new S16;
            if(vehicleStatusUpdateParameter.iAP2OutsideTemperature) {
                vehicleStatusUpdateParameter.iAP2OutsideTemperature_count++;
                vehicleStatusUpdateParameter.iAP2OutsideTemperature[0] = (S16)outsideTemperature;
            }

            //not set: inside temp, range, range warning, etc.

            int res = iAP2VehicleStatusUpdate(iap2Device, &vehicleStatusUpdateParameter);
            ETG_TRACE_USR3(("iAP2VehicleStatusUpdate returned %d", res));
            if(IAP2_OK != res) {
                ret = MP_ERR_IPOD_COMMAND;
                UpdateIpodCommunicationError(res);
            }
            iAP2FreeiAP2VehicleStatusUpdateParameter(&vehicleStatusUpdateParameter);
        }
        m_HandleMap.UnlockIAP2(mountPoint); //end critical section
    } else {
        ETG_TRACE_USR3(("VehicleStatusUpdate ignored"));
    }
    return ret;
}

tResult iPodControlIAP::iAP2SetVehicleStatusUpdate(const tMountPoint mountPoint, tBoolean enableUpdates)
{
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(enableUpdates);
    m_HandleMap.SetVehicleStatusUpdate(mountPoint, enableUpdates);
    return MP_NO_ERROR;
}

tResult iPodControlIAP::GetBTMAC(tDeviceAddress &deviceAddress)
{
    ENTRY;
    tDeviceSerialNumber btAdressString = {0};
#if 0 //legacy: read BT MAC address from file
    int fdBTAdressFile = open(LocalSPM::GetDataProvider().iPodControlBTMACAddressFile().c_str(), O_RDONLY);
    if (-1 == fdBTAdressFile) {
        ETG_TRACE_ERR(("Cannot open bt_address.txt file"));
        return MP_ERR_IPOD_COMMAND;
    }

    memset(btAdressString, 0, sizeof btAdressString);
    if (12 != read(fdBTAdressFile, btAdressString, 12)) {
        close(fdBTAdressFile);
        ETG_TRACE_ERR(("Cannot read 12 bytes from bt_address.txt file"));
        return MP_ERR_IPOD_COMMAND;
    } else {
        close(fdBTAdressFile);
    }
#else
    strncpy_r(btAdressString, LocalSPM::GetDataProvider().iPodControlBTMACAddress().c_str(), sizeof(btAdressString));
#endif
    VARTRACE(btAdressString);
    for (unsigned iter = 0; iter < 6; iter ++ ) {
        unsigned char sum;
        sum  = 16*BTDaemonProxy::getHexInDecimal( (unsigned char)(btAdressString[iter*2]) );
        sum += BTDaemonProxy::getHexInDecimal( (unsigned char)(btAdressString[(iter*2)+1]) );
        deviceAddress[iter] = sum;
    }
    VARTRACE(deviceAddress);

    return MP_NO_ERROR;
}

tResult iPodControlIAP::GetBTLimitationMode(const tMountPoint mountPoint, tBTLimitationActionState& btLimitationActionState)
{
    ENTRY;
    btLimitationActionState = m_HandleMap.GetBTLimitationActionState(mountPoint);
    return MP_NO_ERROR;
}

tResult iPodControlIAP::GetBTLimitationModeConnectionState(const tMountPoint mountPoint, tConnectionState& connectionState)
{
    ENTRY;
    connectionState = m_HandleMap.GetBTLimitationModeConnectionState(mountPoint);
    return MP_NO_ERROR;
}

tResult iPodControlIAP::GetIsCPWActiveForUSBMountPoint(const tMountPoint mountPoint, tBoolean& isCPWActive)
{
    ENTRY;
    isCPWActive = m_HandleMap.GetIsCPWActiveForUSBMountPoint(mountPoint);
    return MP_NO_ERROR;
}

tResult iPodControlIAP::GetCPWMountPointbyUSBMountPoint(const tMountPoint mountPoint, tMountPoint& CPWMountPoint)
{
    ENTRY;

    tResult ret = MP_NO_ERROR;
    m_HandleMap.GetCPWMountPointbyUSBMountPoint(mountPoint,CPWMountPoint);
    if (CPWMountPoint[0] == 0) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    }
    return ret;
}

tResult iPodControlIAP::GetUSBMountPointbyCPWMountPoint(const tMountPoint mountPoint, tMountPoint& USBMountPoint)
{
    ENTRY;

    tResult ret = MP_NO_ERROR;
    m_HandleMap.GetUSBMountPointbyCPWMountPoint(mountPoint, USBMountPoint);
    if (USBMountPoint[0] == 0)
    {
        ret = MP_ERR_IPOD_NO_ACCESS;
    }
    return ret;
}

void iPodControlIAP::SetBTLimitationMode(const tMountPoint mountPoint, tBTLimitationActionState btLimitationActionState)
{
    ENTRY;
    m_HandleMap.SetBTLimitationActionState(mountPoint, btLimitationActionState);
}

void iPodControlIAP::SetBTLimitationModeConnectionState(const tMountPoint mountPoint, tConnectionState connectionState)
{
    ENTRY;
    m_HandleMap.SetBTLimitationModeConnectionState(mountPoint, connectionState);
}

void iPodControlIAP::SetIsCPWActiveForUSBMountpoint(const tMountPoint mountPoint,const tBoolean isCPWActive)
{
    ENTRY;
    m_HandleMap.SetIsCPWActiveForUSBMountpoint(mountPoint, isCPWActive);
}

void iPodControlIAP::SetAppleDeviceTransportIdentifiers(const tMountPoint mountpoint,const tMACAddress appleDeviceMACAddress,const tUSBSerial appleDeviceUSBSerialNumber)
{
    ENTRY;
    m_HandleMap.SetAppleDeviceTransportIdentifiers(mountpoint, appleDeviceMACAddress,appleDeviceUSBSerialNumber);
}

void iPodControlIAP::iAPSetDeviceUUID(const tMountPoint mountPoint, const tUUID deviceUUID)
{
    ENTRY;
    m_HandleMap.SetDeviceUUID(mountPoint, deviceUUID);
}

void iPodControlIAP::iAPSetOption(const tMountPoint mountPoint, const tiPodOptions option, const bool set)
{
    ENTRY_INTERNAL;
    m_HandleMap.SetOption(mountPoint, option, set);
}

bool iPodControlIAP::iAPGetOption(const tMountPoint mountPoint, const tiPodOptions option)
{
    ENTRY_INTERNAL;
    return m_HandleMap.GetOption(mountPoint, option);
}

tBoolean iPodControlIAP::iAPSetupPlaylistItems(const tMountPoint mountPoint, const iAP2FileTransferSession_t *iAP2FileXferSession)
{
    ENTRY;
    VARTRACE(mountPoint);
    tBoolean ret = false;

    if(iAP2FileXferSession) {

        //get and init indexer context
        m_HandleMap.LockIndexer(mountPoint);
        iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
        if(!pcontext) {
            ETG_TRACE_ERR(("GetIndexerContext failed"));
        } else {
            tPlaylistFileTransferObj obj;
            ret = pcontext->PopPlaylistFileTransferObject(iAP2FileXferSession->iAP2FileTransferID, obj);
            if(ret) {
                //check playlist size, remove empty lists or allocate buffer
                if(iAP2FileXferSession->iAP2FileXferRxLen != 0) {
                    obj.rxLen = 0;
                    obj.size = 0;
                    obj.buffer = new U8[(unsigned int)iAP2FileXferSession->iAP2FileXferRxLen];
                    if(obj.buffer) {
                        obj.size = iAP2FileXferSession->iAP2FileXferRxLen;
                        memset(obj.buffer, 0, (unsigned int)obj.size);
                        pcontext->PushPlaylistFileTransferObject(iAP2FileXferSession->iAP2FileTransferID, obj);
                    } else {
                        ETG_TRACE_ERR(("No memory"));
                        ret = false;
                    }
                }
            }
        }
        m_HandleMap.UnlockIndexer(mountPoint);
    }
    return ret;
}

tBoolean iPodControlIAP::iAPDataRcvdPlaylistItems(const tMountPoint mountPoint, const iAP2FileTransferSession_t *iAP2FileXferSession)
{
    ENTRY;
    VARTRACE(mountPoint);
    tBoolean ret = false;

    if(iAP2FileXferSession) {
        //check playlist size, remove empty lists
        if(iAP2FileXferSession->iAP2FileXferRxLen > 0 && iAP2FileXferSession->iAP2FileXferRxBuf != NULL) {
            //get and init indexer context
            m_HandleMap.LockIndexer(mountPoint);
            iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
            if(!pcontext) {
                ETG_TRACE_ERR(("GetIndexerContext failed"));
            } else {
                tPlaylistFileTransferObj obj;
                ret = pcontext->PopPlaylistFileTransferObject(iAP2FileXferSession->iAP2FileTransferID, obj);
                if(ret) {
                    if(obj.buffer != NULL && (obj.rxLen + iAP2FileXferSession->iAP2FileXferRxLen) <= obj.size) {
                        memcpy(obj.buffer + obj.rxLen, iAP2FileXferSession->iAP2FileXferRxBuf, (unsigned int)iAP2FileXferSession->iAP2FileXferRxLen);
                        obj.rxLen += iAP2FileXferSession->iAP2FileXferRxLen;
                        pcontext->PushPlaylistFileTransferObject(iAP2FileXferSession->iAP2FileTransferID, obj);
                    } else {
                        delete [] obj.buffer;
                        ETG_TRACE_ERR(("Invalid FileTransfer buffer size"));
                        ret = false;
                    }
                }
            }
            m_HandleMap.UnlockIndexer(mountPoint);
        }
    }
    return ret;
}

tBoolean iPodControlIAP::iAPSuccessPlaylistItems(const tMountPoint mountPoint, const iAP2FileTransferSession_t *iAP2FileXferSession)
{
    ENTRY;
    VARTRACE(mountPoint);
    tBoolean ret = false;

    if(iAP2FileXferSession) {
        //remove playlist from cache
        //get and init indexer context
        m_HandleMap.LockIndexer(mountPoint);
        iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
        if(!pcontext) {
            ETG_TRACE_ERR(("GetIndexerContext failed"));
        } else {
            tPlaylistFileTransferObj obj;
            ret = pcontext->PopPlaylistFileTransferObject(iAP2FileXferSession->iAP2FileTransferID, obj);
            if(ret) {
                if(obj.buffer != NULL && obj.rxLen == obj.size) {

                    vector<tU64> uuidList;
                    for(unsigned int i = 0; i < obj.rxLen/8; i++) {
                        //swap byte order
                        tU64 uuid = __builtin_bswap64(*((tU64*)(obj.buffer + 8*i))); //lint !e826 size checked by for(...)
                        uuidList.push_back(uuid);
                    }
                    //push back to indexer context cache
                    pcontext->PushPlaylistObject(obj.parentUUID, uuidList);

                } else {
                    ETG_TRACE_ERR(("Invalid FileTransfer buffer size"));
                    ret = false;
                }
                delete [] obj.buffer;
            }
        }
        m_HandleMap.UnlockIndexer(mountPoint);
    }
    return ret;
}

tResult iPodControlIAP::iAP1_GetTrackUIDList(const tMountPoint mountPoint,const tIndex index,const tListSize chunk,tIPODTrackInfosPtr trackInfosPtr)
{
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(index);
    VARTRACE(chunk);
    tResult ret = MP_NO_ERROR;
    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    }else{
        m_HandleMap.LockIndexer(m_MountPoint);
        iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(m_MountPoint);
        if(!pcontext) {
            ETG_TRACE_ERR(("GetIndexerContext failed"));
            ret = MP_ERR_IPOD_NO_ACCESS;
        } else {
            pcontext->OnBeginCaching();
            if( NULL != trackInfosPtr){
                VARTRACE((tUInt)(unsigned long)trackInfosPtr); // thoemel: the additional casting is due to 64 bit compiler
                iPodControlMediaPath tracks(LTY_SONG);
                if (!SelectRecord(tracks)){
                            ETG_TRACE_ERR(("iPodControlIAP::iAPCalcFingerPrint() - SelectRecord(LTY_VIDEO_EPISODE) failed"));
                            ret = MP_ERR_IPOD_SELECT;
                }else {
                    IPOD_TRACK_INFORMATION_BITFIELD bitfield = { 0 };
                    bitfield.track_info.UID = 1;
                    int res = GetTrackInfo(trackInfosPtr, bitfield, index, chunk, tracks.IsDBPath());
                    if (!res) {
                        ETG_TRACE_ERR(("%s - GetTrackInfo failed", __PRETTY_FUNCTION__));
                        ret = MP_ERR_IPOD_METADATA;
                    }
                }
            }
            //calculate next chunk size
            if(trackInfosPtr) {
                pcontext->OnEndCaching(trackInfosPtr->size());
            }
        }
        m_HandleMap.UnlockIndexer(m_MountPoint);
    }
    return ret;
}

tResult iPodControlIAP::iAP1_GetVideoUIDList(const tMountPoint mountPoint,const tIndex index,const tListSize chunk,tIPODTrackInfosPtr trackInfosPtr)
{
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(index);
    VARTRACE(chunk);
    tResult ret = MP_NO_ERROR;
    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    }else{
        m_HandleMap.LockIndexer(m_MountPoint);
        iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(m_MountPoint);
        if(!pcontext) {
            ETG_TRACE_ERR(("GetIndexerContext failed"));
            ret = MP_ERR_IPOD_NO_ACCESS;
        } else {
            pcontext->OnBeginCaching();
            if( NULL != trackInfosPtr){
                VARTRACE((tUInt)(unsigned long)trackInfosPtr); // thoemel: the additional casting is due to 64 bit compiler
                iPodControlMediaPath videos(LTY_VIDEO_EPISODE);
                if (!SelectRecord(videos)){
                            ETG_TRACE_ERR(("iPodControlIAP::iAPCalcFingerPrint() - SelectRecord(LTY_VIDEO_EPISODE) failed"));
                            ret = MP_ERR_IPOD_SELECT;
                }else {
                    IPOD_TRACK_INFORMATION_BITFIELD bitfield = { 0 };
                    bitfield.track_info.UID = 1;
                    int res = GetTrackInfo(trackInfosPtr, bitfield, index, chunk, videos.IsDBPath());
                    if (!res) {
                        ETG_TRACE_ERR(("%s - GetTrackInfo failed", __PRETTY_FUNCTION__));
                        ret = MP_ERR_IPOD_METADATA;
                    }
                }
            }
            //calculate next chunk size
            if(trackInfosPtr) {
                pcontext->OnEndCaching(trackInfosPtr->size());
            }
        }
        m_HandleMap.UnlockIndexer(m_MountPoint);
    }
    return ret;
}

tResult iPodControlIAP::iAP1_GetPlaylistNameList(const tMountPoint mountPoint,const tIndex index,const tListSize chunk,tIPODDBRecordsPtr iPODDBRecordsPtr)
{
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(index);
    VARTRACE(chunk);
    tResult ret = MP_NO_ERROR;
    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    }else{
        m_HandleMap.LockIndexer(m_MountPoint);
        iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(m_MountPoint);
        if(!pcontext) {
            ETG_TRACE_ERR(("GetIndexerContext failed"));
            ret = MP_ERR_IPOD_NO_ACCESS;
        } else {
            pcontext->OnBeginCaching();
            if( NULL != iPODDBRecordsPtr){
                VARTRACE( (tUInt)(unsigned long)iPODDBRecordsPtr); // thoemel: the additional casting is due to 64 bit compiler
                iPodControlMediaPath playlist(LTY_PLAYLIST);
                if (!SelectRecord(playlist)) {
                    ETG_TRACE_ERR(("iPodControlIAP::iAPCalcFingerPrint() - SelectRecord(LTY_PLAYLIST) failed"));
                    ret = MP_ERR_IPOD_SELECT;
                }else {
                    int res = RetrieveCategorizedDBRecords(iPODDBRecordsPtr, IPOD_CAT_PLAYLIST, index, chunk);
                    if (!res) {
                        ETG_TRACE_ERR(("%s - RetrieveCategorizedDBRecords failed", __PRETTY_FUNCTION__));
                        ret = MP_ERR_IPOD_METADATA;
                    }
                }
            }
            //calculate next chunk size
            if(iPODDBRecordsPtr) {
                pcontext->OnEndCaching(iPODDBRecordsPtr->size());
            }
        }
        m_HandleMap.UnlockIndexer(mountPoint);
    }
    return ret;
}

tResult iPodControlIAP::iAP2_StartUSBDeviceModeAudio(const tMountPoint mountPoint)
{
    ENTRY;
    VARTRACE(mountPoint);
    tResult ret = MP_NO_ERROR;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        if(IsIAP2(m_MountPoint)) {
            m_HandleMap.LockIAP2(m_MountPoint); //start critical section
            iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(m_MountPoint);
            if(!iap2Device) {
                ETG_TRACE_ERR(("!iap2Device"));
                ret = MP_ERR_IPOD_NO_ACCESS;
            } else {
                const tConnectionType connectionType = m_HandleMap.GetConnectionType(m_MountPoint);

                //start USB device mode audio // do not start it if connectionType is bluetooth
                if(connectionType != DCT_BLUETOOTH && !IsIAP2HostMode(m_MountPoint) )  {
                    iAP2StartUSBDeviceModeAudioParameter usbDeviceModeAudioParameter;
                    memset(&usbDeviceModeAudioParameter, 0, sizeof(usbDeviceModeAudioParameter) );
                    ret = iAP2StartUSBDeviceModeAudio(iap2Device, &usbDeviceModeAudioParameter);
                    ETG_TRACE_USR3(("iAP2StartUSBDeviceModeAudio returned %d", ret));
                    if (IAP2_OK != ret) {
                        UpdateIpodCommunicationError(ret);
                    }
                }
            }
            m_HandleMap.UnlockIAP2(m_MountPoint); //end critical section
        }
    }
    return ret;
}

tResult iPodControlIAP::iAP2_StopUSBDeviceModeAudio(const tMountPoint mountPoint)
{
    ENTRY;
    VARTRACE(mountPoint);
    tResult ret = MP_NO_ERROR;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        if(IsIAP2(m_MountPoint)) {
            m_HandleMap.LockIAP2(m_MountPoint); //start critical section
            iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(m_MountPoint);
            if(!iap2Device) {
                ETG_TRACE_ERR(("!iap2Device"));
                ret = MP_ERR_IPOD_NO_ACCESS;
            } else {
                const tConnectionType connectionType = m_HandleMap.GetConnectionType(m_MountPoint);

                //stop usb device mode audio
                if(connectionType != DCT_BLUETOOTH && !IsIAP2HostMode(m_MountPoint)) {
                    iAP2StopUSBDeviceModeAudioParameter usbDeviceModeAudioParameter;
                    memset(&usbDeviceModeAudioParameter, 0, sizeof(usbDeviceModeAudioParameter) );
                    ret = iAP2StopUSBDeviceModeAudio(iap2Device, &usbDeviceModeAudioParameter);
                    ETG_TRACE_USR3(("iAP2StopUSBDeviceModeAudio returned %d", ret));
                    if(IAP2_OK != ret) {
                        UpdateIpodCommunicationError(ret);
                    }
                }
            }
            m_HandleMap.UnlockIAP2(m_MountPoint); //end critical section
        }
    }
    return ret;
}

tResult iPodControlIAP::iAP2_StopMediaLibraryUpdates(const tMountPoint mountPoint)
{
    ENTRY;
    VARTRACE(mountPoint);
    tResult ret = MP_NO_ERROR;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        if(IsIAP2(m_MountPoint)) {
            m_HandleMap.LockIAP2(m_MountPoint); //start critical section
            iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(m_MountPoint);
            if(!iap2Device) {
                ETG_TRACE_ERR(("!iap2Device"));
                ret = MP_ERR_IPOD_NO_ACCESS;
            } else {

                tFingerprint mediaLibraryUID = {0};
                m_HandleMap.LockIndexer(mountPoint);
                iPodControlIndexerContext * pcontext = m_HandleMap.GetIndexerContext(mountPoint);
                if(!pcontext) {
                    ETG_TRACE_USR3(("GetIndexerContext failed"));
                } else if(pcontext->IsPaused()){
                    ETG_TRACE_USR3(("Indexing already paused"));
                } else {
                    pcontext->GetMediaLibraryUID(mediaLibraryUID);
                    if(mediaLibraryUID[0] == 0) {
                        ETG_TRACE_USR3(("mediaLibraryUID failed"));
                    } else {
                        iAP2StopMediaLibraryUpdatesParameter mediaLibraryUpdatesParameter;
                        memset(&mediaLibraryUpdatesParameter, 0, sizeof(iAP2StopMediaLibraryUpdatesParameter));

                        /* set mediaLibraryUpdatesParameter properties which we want to receive */
                        mediaLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier = new U8*[sizeof(U8*)];
                        if(mediaLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier != NULL) {
                            ETG_TRACE_USR3(("calling iAP2StopMediaLibraryUpdates"));
                            VARTRACE(mediaLibraryUID);
                            mediaLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier_count++;
                            mediaLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier[0] = 0;
                            size_t size = strnlen(mediaLibraryUID, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
                            mediaLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier[0] = new U8[size];
                            if(mediaLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier[0] != NULL) {
                                strncpy_r((char*)mediaLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier[0], mediaLibraryUID, size);
                                int res = iAP2StopMediaLibraryUpdates(iap2Device, &mediaLibraryUpdatesParameter);
                                ETG_TRACE_USR3(("iAP2StopMediaLibraryUpdates returned %d", res));
                                if(res != IAP2_OK) {
                                    UpdateIpodCommunicationError(res);
                                }
                            }
                            iAP2FreeiAP2StopMediaLibraryUpdatesParameter(&mediaLibraryUpdatesParameter);
                        }

                        //iTunes Radio
                        tFingerprint iTunesRadioLibraryUID = {0};
                        pcontext->GetiTunesRadioLibraryUID(iTunesRadioLibraryUID);
                        if(iTunesRadioLibraryUID[0] != 0) {
                            memset(&mediaLibraryUpdatesParameter, 0, sizeof(iAP2StopMediaLibraryUpdatesParameter));
                            /* set mediaLibraryUpdatesParameter properties which we want to receive */
                            mediaLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier = new U8*[sizeof(U8*)];
                            if(mediaLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier != NULL) {
                                ETG_TRACE_USR3(("calling iAP2StopMediaLibraryUpdates"));
                                VARTRACE(iTunesRadioLibraryUID);
                                mediaLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier_count++;
                                mediaLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier[0] = 0;
                                size_t size = strnlen(iTunesRadioLibraryUID, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
                                mediaLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier[0] = new U8[size];
                                if(mediaLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier[0] != NULL) {
                                    strncpy_r((char*)mediaLibraryUpdatesParameter.iAP2MediaLibraryUniqueIdentifier[0], iTunesRadioLibraryUID, size);
                                    int res = iAP2StopMediaLibraryUpdates(iap2Device, &mediaLibraryUpdatesParameter);
                                    ETG_TRACE_USR3(("iAP2StopMediaLibraryUpdates returned %d", res));
                                    if(res != IAP2_OK) {
                                        UpdateIpodCommunicationError(res);
                                    }
                                }
                                iAP2FreeiAP2StopMediaLibraryUpdatesParameter(&mediaLibraryUpdatesParameter);
                            }
                        }
                    }
                    pcontext->SetPaused(true);
                }
                m_HandleMap.UnlockIndexer(mountPoint);
            }
            m_HandleMap.UnlockIAP2(m_MountPoint); //end critical section
        }
    }
    return ret;
}

//CARPLAY WIFI:
tResult iPodControlIAP::iAP2_AccessoryWiFiConfigurationInformation(const tMountPoint mountPoint, tWiFiAPCredentials wifiCredentials)
{
    ENTRY;
    VARTRACE(mountPoint);
    tResult ret = MP_NO_ERROR;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        if(IsIAP2(m_MountPoint)) {
            m_HandleMap.LockIAP2(m_MountPoint); //start critical section
            iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(m_MountPoint);
            if(!iap2Device) {
                ETG_TRACE_ERR(("!iap2Device"));
                ret = MP_ERR_IPOD_NO_ACCESS;
            }
            else
            {
                ETG_TRACE_USR4(("AccessoryWiFiConfigurationInformation credentials"));

                iAP2AccessoryWiFiConfigurationInformationParameter iAP2AccessoryWiFiConfigurationInformationParameter;
                memset(&iAP2AccessoryWiFiConfigurationInformationParameter, 0, sizeof(iAP2AccessoryWiFiConfigurationInformationParameter));

                iAP2AccessoryWiFiConfigurationInformationParameter.iAP2Channel = new U8;
                if(NULL != iAP2AccessoryWiFiConfigurationInformationParameter.iAP2Channel) {
                    iAP2AccessoryWiFiConfigurationInformationParameter.iAP2Channel[0] = wifiCredentials.channelNumber;
                    iAP2AccessoryWiFiConfigurationInformationParameter.iAP2Channel_count++;
                }

                iAP2AccessoryWiFiConfigurationInformationParameter.iAP2Passphrase = new U8*[sizeof(U8*)];
                if(NULL != iAP2AccessoryWiFiConfigurationInformationParameter.iAP2Passphrase) {
                    size_t size = strnlen(wifiCredentials.passPhrase, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
                    iAP2AccessoryWiFiConfigurationInformationParameter.iAP2Passphrase[0] = new U8[size];
                    strncpy_r((char*)iAP2AccessoryWiFiConfigurationInformationParameter.iAP2Passphrase[0],wifiCredentials.passPhrase,size);
                    iAP2AccessoryWiFiConfigurationInformationParameter.iAP2Passphrase_count++;
                }

                iAP2AccessoryWiFiConfigurationInformationParameter.iAP2SecurityType = new iAP2WiFiSecurityType;
                if(NULL != iAP2AccessoryWiFiConfigurationInformationParameter.iAP2SecurityType) {
                    iAP2WiFiSecurityType wifiSecurityType = IAP2_WIFI_SECURITY_NONE;

                    switch(wifiCredentials.securityType)
                    {
                        case WIFI_SECURITY_NONE:
                            wifiSecurityType = IAP2_WIFI_SECURITY_NONE;
                            break;
                        case WIFI_SECURITY_WEP:
                            wifiSecurityType = IAP2_WIFI_SECURITY_WEP_NEW;
                            break;
                        case WIFI_SECURITY_WPA_PERSONAL:
                        case WIFI_SECURITY_WPA2_PERSONAL:
                            wifiSecurityType = IAP2_WIFI_SECURITY_WPA_WPA2;
                            break;
                        default:
                            wifiSecurityType = IAP2_WIFI_SECURITY_NONE;
                            break;
                    }

                    VARTRACE(wifiSecurityType);

                    iAP2AccessoryWiFiConfigurationInformationParameter.iAP2SecurityType[0] = wifiSecurityType;
                    iAP2AccessoryWiFiConfigurationInformationParameter.iAP2SecurityType_count++;
                }

                iAP2AccessoryWiFiConfigurationInformationParameter.iAP2WiFiSSID = new U8*[sizeof(U8*)];
                if(NULL != iAP2AccessoryWiFiConfigurationInformationParameter.iAP2WiFiSSID) {
                    size_t size = strnlen(wifiCredentials.ssid,IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
                    iAP2AccessoryWiFiConfigurationInformationParameter.iAP2WiFiSSID[0] = new U8[size];
                    strncpy_r((char*)iAP2AccessoryWiFiConfigurationInformationParameter.iAP2WiFiSSID[0],wifiCredentials.ssid,size);
                    iAP2AccessoryWiFiConfigurationInformationParameter.iAP2WiFiSSID_count++;
                }

                // get the Wifi Config info from SPI & update it to device.
#ifdef TARGET_BUILD
                int res;
                res = iAP2AccessoryWiFiConfigurationInformation(iap2Device, &iAP2AccessoryWiFiConfigurationInformationParameter);
                ETG_TRACE_USR3(("iAP2_AccessoryWiFiConfigurationInformation returned %d", res));
                iAP2FreeiAP2AccessoryWiFiConfigurationInformationParameter(&iAP2AccessoryWiFiConfigurationInformationParameter);
                ret = (IAP2_OK == res);
#endif
            }
            m_HandleMap.UnlockIAP2(m_MountPoint);
        }
    }

    return ret;
}

tResult iPodControlIAP::iAP2_OOBTBTPairingAccessoryInformation(const tMountPoint mountPoint)
{
    ENTRY;
    VARTRACE(mountPoint);
    tResult ret = MP_NO_ERROR;
#ifdef IPODCONTROL_IAP2_PF_OOBBT_AVAIL
#ifdef TARGET_BUILD
    //Get init parameters
    iAP2InitParam_t * iAP2InitParameter = (iAP2InitParam_t *)m_HandleMap.GetIAP2InitParameter(mountPoint);

    iAP2OOBBTPairingAccessoryInformationParameter iAP2OOBBTPairingAccessoryInformationParameter;
    memset(&iAP2OOBBTPairingAccessoryInformationParameter, 0, sizeof(iAP2OOBBTPairingAccessoryInformationParameter));

    if(iAP2InitParameter) {
        if(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent->iAP2TransportComponentIdentifier_count) {
            iAP2OOBBTPairingAccessoryInformationParameter.iAP2BluetoothTransportComponentIdentifier_count = iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent->iAP2TransportComponentIdentifier_count;
        }
        if(iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent->iAP2TransportComponentIdentifier) {
            iAP2OOBBTPairingAccessoryInformationParameter.iAP2BluetoothTransportComponentIdentifier = iAP2InitParameter->p_iAP2AccessoryInfo->iAP2BluetoothTransportComponent->iAP2TransportComponentIdentifier;
        }
    }

    iAP2OOBBTPairingAccessoryInformationParameter.iAP2DeviceClass = new U32;

    if(iAP2OOBBTPairingAccessoryInformationParameter.iAP2DeviceClass != NULL) {

        iAP2OOBBTPairingAccessoryInformationParameter.iAP2DeviceClass[0] = 0;
        iAP2OOBBTPairingAccessoryInformationParameter.iAP2DeviceClass_count++;
    }

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        if(IsIAP2(m_MountPoint)) {
            m_HandleMap.LockIAP2(m_MountPoint); //start critical section
            iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(m_MountPoint);
            if(!iap2Device) {
                ETG_TRACE_ERR(("!iap2Device"));
                ret = MP_ERR_IPOD_NO_ACCESS;
            } else {
                ret = iAP2OOBBTPairingAccessoryInformation(iap2Device, &iAP2OOBBTPairingAccessoryInformationParameter);
                ETG_TRACE_USR3(("iAP2OOBBTPairingAccessoryInformation returned %d", ret));
                if (IAP2_OK != ret) {
                    UpdateIpodCommunicationError(ret);
                }
            }
            m_HandleMap.UnlockIAP2(m_MountPoint);
        }
    }
#endif
#endif //#ifdef IPODCONTROL_IAP2_PF_OOBBT_AVAIL
    return ret;
}

tResult iPodControlIAP::iAP2_OOBTBTPairingCompletionInformation(const tMountPoint mountPoint,const bool result)
{
    ENTRY;
    VARTRACE(mountPoint);
    tResult ret = MP_NO_ERROR;
#ifdef IPODCONTROL_IAP2_PF_OOBBT_AVAIL
#ifdef TARGET_BUILD
    iAP2OOBBTPairingCompletionInformationParameter iAP2OOBBTPairingCompletionInformationParameter;
    memset(&iAP2OOBBTPairingCompletionInformationParameter, 0, sizeof(iAP2OOBBTPairingCompletionInformationParameter));

    iAP2OOBBTPairingCompletionInformationParameter.iAP2ResultCode = new U8[1];
    if(iAP2OOBBTPairingCompletionInformationParameter.iAP2ResultCode != NULL)
    {
        if(result)
        {
            iAP2OOBBTPairingCompletionInformationParameter.iAP2ResultCode[0] = 0;
        }
        else
        {
            iAP2OOBBTPairingCompletionInformationParameter.iAP2ResultCode[0] = 1;
        }

        iAP2OOBBTPairingCompletionInformationParameter.iAP2ResultCode_count++;
    }

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        if(IsIAP2(m_MountPoint)) {
            m_HandleMap.LockIAP2(m_MountPoint); //start critical section
            iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(m_MountPoint);
            if(!iap2Device) {
                ETG_TRACE_ERR(("!iap2Device"));
                ret = MP_ERR_IPOD_NO_ACCESS;
            } else {
                ret = iAP2OOBBTPairingCompletionInformation(iap2Device, &iAP2OOBBTPairingCompletionInformationParameter);
                ETG_TRACE_USR3(("iAP2OOBBTPairingCompletionInformation returned %d", ret));
                if (IAP2_OK != ret) {
                    UpdateIpodCommunicationError(ret);
                }
            }
            m_HandleMap.UnlockIAP2(m_MountPoint);
        }
    }
#endif
#endif //IPODCONTROL_IAP2_PF_OOBBT_AVAIL
    return ret;
}

tResult iPodControlIAP::iAP2_StartRouteGuidance(const tMountPoint mountPoint,tUInt RouteGuidanceDisplayComponentID, tBoolean SourceName, tBoolean SourceSupportsRouteGuidance) {
    ENTRY;
    VARTRACE(mountPoint);
    tResult ret = MP_NO_ERROR;
    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        if(IsIAP2(m_MountPoint)) {
            m_HandleMap.LockIAP2(m_MountPoint); //start critical section
            iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(m_MountPoint);
            if(!iap2Device) {
                ETG_TRACE_ERR(("!iap2Device"));
                ret = MP_ERR_IPOD_NO_ACCESS;
            } else {
                const tBoolean carPlay = IsIAP2CarPlayMode(m_MountPoint) || IsIAP2WirelessCarPlayMode(m_MountPoint);
                VARTRACE(carPlay);
                if(carPlay)
                {
                    ETG_TRACE_USR3(("calling iAP2StartRouteGuidanceUpdate"));
#ifdef IPODCONTROL_IAP2_PF_R26
#ifdef TARGET_BUILD
                    iAP2StartRouteGuidanceUpdateParameter StartRouteGuidanceUpdateParameter;
                    memset(&StartRouteGuidanceUpdateParameter, 0, sizeof(iAP2StartRouteGuidanceUpdateParameter));
                    StartRouteGuidanceUpdateParameter.iAP2RouteGuidanceDisplayComponentID = new U16[1];
                    if(StartRouteGuidanceUpdateParameter.iAP2RouteGuidanceDisplayComponentID != NULL){
                        StartRouteGuidanceUpdateParameter.iAP2RouteGuidanceDisplayComponentID[0] = RouteGuidanceDisplayComponentID;
                        VARTRACE(StartRouteGuidanceUpdateParameter.iAP2RouteGuidanceDisplayComponentID[0]);
                    }

                    StartRouteGuidanceUpdateParameter.iAP2RouteGuidanceDisplayComponentID_count = 1;
                    VARTRACE(StartRouteGuidanceUpdateParameter.iAP2RouteGuidanceDisplayComponentID_count);
                    StartRouteGuidanceUpdateParameter.iAP2SourceName = new U8[1];
                    if(StartRouteGuidanceUpdateParameter.iAP2SourceName != NULL){
                        if(SourceName){
                            StartRouteGuidanceUpdateParameter.iAP2SourceName[0] = 1;
                            StartRouteGuidanceUpdateParameter.iAP2SourceName_count = 1;
                        }
                        VARTRACE(StartRouteGuidanceUpdateParameter.iAP2SourceName[0]);
                        VARTRACE(StartRouteGuidanceUpdateParameter.iAP2SourceName_count);
                    }
                    StartRouteGuidanceUpdateParameter.iAP2SourceSupportsRouteGuidance = new U8[1];
                    if(StartRouteGuidanceUpdateParameter.iAP2SourceSupportsRouteGuidance != NULL){
                        if(SourceSupportsRouteGuidance){
                            StartRouteGuidanceUpdateParameter.iAP2SourceSupportsRouteGuidance[0] = 1;
                            StartRouteGuidanceUpdateParameter.iAP2SourceSupportsRouteGuidance_count = 1;
                        }
                        VARTRACE(StartRouteGuidanceUpdateParameter.iAP2SourceSupportsRouteGuidance[0]);
                        VARTRACE(StartRouteGuidanceUpdateParameter.iAP2SourceSupportsRouteGuidance_count);
                    }
                    ret = iAP2StartRouteGuidanceUpdate(iap2Device,&StartRouteGuidanceUpdateParameter);
                    ETG_TRACE_USR3(("iAP2StartRouteGuidanceUpdate returned %d", ret));
                    iAP2FreeiAP2StartRouteGuidanceUpdateParameter(&StartRouteGuidanceUpdateParameter);
#endif
#endif
                }
            }
            m_HandleMap.UnlockIAP2(m_MountPoint);
        }
    }
    return ret;
}

tResult iPodControlIAP::iAP2_StopRouteGuidance(const tMountPoint mountPoint,tUInt RouteGuidanceDisplayComponentID) {
    ENTRY;
    VARTRACE(mountPoint);
    tResult ret = MP_NO_ERROR;
    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        if(IsIAP2(m_MountPoint)) {
            m_HandleMap.LockIAP2(m_MountPoint); //start critical section
            iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(m_MountPoint);
            if(!iap2Device) {
                ETG_TRACE_ERR(("!iap2Device"));
                ret = MP_ERR_IPOD_NO_ACCESS;
            } else {
                const tBoolean carPlay = IsIAP2CarPlayMode(m_MountPoint) || IsIAP2WirelessCarPlayMode(m_MountPoint);;
                VARTRACE(carPlay);
                if(carPlay)
                {
                    ETG_TRACE_USR3(("calling iAP2StopRouteGuidanceUpdate"));
#ifdef IPODCONTROL_IAP2_PF_R26
#ifdef TARGET_BUILD
                    iAP2StopRouteGuidanceUpdateParameter StopRouteGuidanceUpdateParameter;
                    memset(&StopRouteGuidanceUpdateParameter, 0, sizeof(iAP2StopRouteGuidanceUpdateParameter));
                    StopRouteGuidanceUpdateParameter.iAP2RouteGuidanceDisplayComponentID = new U16[1];
                    if(StopRouteGuidanceUpdateParameter.iAP2RouteGuidanceDisplayComponentID != NULL){
                        StopRouteGuidanceUpdateParameter.iAP2RouteGuidanceDisplayComponentID[0] = RouteGuidanceDisplayComponentID;
                        VARTRACE(StopRouteGuidanceUpdateParameter.iAP2RouteGuidanceDisplayComponentID[0]);
                    }

                    StopRouteGuidanceUpdateParameter.iAP2RouteGuidanceDisplayComponentID_count = 1;
                    VARTRACE(StopRouteGuidanceUpdateParameter.iAP2RouteGuidanceDisplayComponentID_count);
                    ret = iAP2StopRouteGuidanceUpdate(iap2Device,&StopRouteGuidanceUpdateParameter);
                    ETG_TRACE_USR3(("iAP2StopRouteGuidanceUpdate returned %d", ret));
                    iAP2FreeiAP2StopRouteGuidanceUpdateParameter(&StopRouteGuidanceUpdateParameter);
#endif
#endif
                }
            }
            m_HandleMap.UnlockIAP2(m_MountPoint);
        }
    }
    return ret;
}

tResult iPodControlIAP::iAP2_InitiateCall(const tMountPoint mountPoint, const tDiPOInitiateCall initiateCall)
{
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(initiateCall);

    tResult ret = MP_NO_ERROR;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        if(IsIAP2(m_MountPoint)) {
            m_HandleMap.LockIAP2(m_MountPoint); //start critical section
            iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(m_MountPoint);
            if(!iap2Device) {
                ETG_TRACE_ERR(("!iap2Device"));
                ret = MP_ERR_IPOD_NO_ACCESS;
            } else {

                iAP2InitiateCallParameter initiateCallParameter;
                memset(&initiateCallParameter, 0, sizeof(initiateCallParameter) );
                initiateCallParameter.iAP2Type = new iAP2InitiateCallType;
                if(initiateCallParameter.iAP2Type != NULL)
                {
                    switch(initiateCall.type)
                    {
                        case DIPO_INITIATECALLTYPE_DESTINATION:
                            initiateCallParameter.iAP2Type[0] = IAP2_INITIATE_CALL_TYPE_DESTINATION;
                            break;
                        case DIPO_INITIATECALLTYPE_VOICEMAIL:
                            initiateCallParameter.iAP2Type[0] = IAP2_INITIATE_CALL_TYPE_VOICEMAIL;
                            break;
                        case DIPO_INITIATECALLTYPE_REDIAL:
                            initiateCallParameter.iAP2Type[0] = IAP2_INITIATE_CALL_TYPE_REDIAL;
                            break;
                        default:
                            initiateCallParameter.iAP2Type[0] = IAP2_INITIATE_CALL_TYPE_DESTINATION;
                            break;
                    }
                    VARTRACE(initiateCallParameter.iAP2Type[0]);
                    initiateCallParameter.iAP2Type_count = TRUE;
                }

                initiateCallParameter.iAP2DestinationID = new U8*[1];
                if(initiateCallParameter.iAP2DestinationID != NULL)
                {
                    size_t size = strnlen(initiateCall.destinationID, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
                    initiateCallParameter.iAP2DestinationID[0] = new U8[size];
                    strncpy_r((char*)initiateCallParameter.iAP2DestinationID[0],initiateCall.destinationID,size);
                    initiateCallParameter.iAP2DestinationID_count = TRUE;
                }

                initiateCallParameter.iAP2Service = new iAP2InitiateCallService;
                if(initiateCallParameter.iAP2Service != NULL)
                {
                    iAP2InitiateCallService initiateCallservice;
                    switch(initiateCall.service)
                    {
                        case DIPO_INITIATECALLSERVICE_TELEPHONY:
                            initiateCallParameter.iAP2Service[0] = IAP2_INITIATE_CALL_SERVICE_TELEPHONY;
                            break;
                        case DIPO_INITIATECALLSERVICE_FACE_TIME_AUDIO:
                            initiateCallParameter.iAP2Service[0] = IAP2_INITIATE_CALL_SERVICE_FACETIME_AUDIO;
                            break;
                        case DIPO_INITIATECALLSERVICE_FACE_TIME_VIDEO:
                            initiateCallParameter.iAP2Service[0] = IAP2_INITIATE_CALL_SERVICE_FACETIME_VIDEO;
                            break;
                        default:
                            initiateCallParameter.iAP2Service[0] = IAP2_INITIATE_CALL_SERVICE_TELEPHONY;
                            break;
                    }

                    VARTRACE(initiateCallParameter.iAP2Service[0]);
                    initiateCallParameter.iAP2Service_count = TRUE;
                }

                initiateCallParameter.iAP2AddressBookID = new U8*[1];
                if(initiateCallParameter.iAP2AddressBookID != NULL)
                {
                    size_t size = strnlen(initiateCall.addressBookID, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
                    initiateCallParameter.iAP2AddressBookID[0] = new U8[size];
                    strncpy_r((char*)initiateCallParameter.iAP2AddressBookID[0],initiateCall.addressBookID,size);
                    initiateCallParameter.iAP2AddressBookID_count = TRUE;
                }


                ret = iAP2InitiateCall(iap2Device, &initiateCallParameter);
                ETG_TRACE_USR3(("iAP2InitiateCall returned %d", ret));
                if (IAP2_OK != ret) {
                    UpdateIpodCommunicationError(ret);
                }
                iAP2FreeiAP2InitiateCallParameter(&initiateCallParameter);
            }
            m_HandleMap.UnlockIAP2(m_MountPoint); //end critical section
        }
    }

    return ret;
}

tResult iPodControlIAP::iAP2_AcceptCall(const tMountPoint mountPoint, const tDiPOAcceptCall acceptCall)
{
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(acceptCall);

    tResult ret = MP_NO_ERROR;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        if(IsIAP2(m_MountPoint)) {
            m_HandleMap.LockIAP2(m_MountPoint); //start critical section
            iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(m_MountPoint);
            if(!iap2Device) {
                ETG_TRACE_ERR(("!iap2Device"));
                ret = MP_ERR_IPOD_NO_ACCESS;
            } else {

                iAP2AcceptCallParameter acceptCallParameter;
                memset(&acceptCallParameter, 0, sizeof(acceptCallParameter) );

                acceptCallParameter.iAP2AcceptAction = new iAP2AcceptCallAcceptAction;
                if(acceptCallParameter.iAP2AcceptAction != NULL)
                {
                    switch(acceptCall.acceptAction)
                    {
                        case DIPO_ACCEPTACTION_ACCEPT_OR_HOLD_AND_ACCEPT:
                            acceptCallParameter.iAP2AcceptAction[0] = IAP2_ACCEPT_CALL_ACCEPT;
                            break;
                        case DIPO_ACCEPTACTION_END_AND_ACCEPT:
                            acceptCallParameter.iAP2AcceptAction[0] = IAP2_ACCEPT_CALL_END_AND_ACCEPT;
                            break;
                        default:
                            acceptCallParameter.iAP2AcceptAction[0] = IAP2_ACCEPT_CALL_ACCEPT;
                            break;
                    }

                    VARTRACE(acceptCallParameter.iAP2AcceptAction[0]);
                    acceptCallParameter.iAP2AcceptAction_count = TRUE;
                }

                acceptCallParameter.iAP2CallUUID = new U8*[1];

                if(acceptCallParameter.iAP2CallUUID != NULL)
                {
                    size_t size = strnlen(acceptCall.callUUID, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
                    acceptCallParameter.iAP2CallUUID[0] = new U8[size];
                    strncpy_r((char*)acceptCallParameter.iAP2CallUUID[0],acceptCall.callUUID,size);
                    acceptCallParameter.iAP2CallUUID_count = TRUE;
                }

                ret = iAP2AcceptCall(iap2Device, &acceptCallParameter);
                ETG_TRACE_USR3(("iAP2SwapCalls returned %d", ret));
                if (IAP2_OK != ret) {
                    UpdateIpodCommunicationError(ret);
                }
                iAP2FreeiAP2AcceptCallParameter(&acceptCallParameter);

            }
            m_HandleMap.UnlockIAP2(m_MountPoint); //end critical section
        }
    }

    return ret;
}
tResult iPodControlIAP::iAP2_EndCall(const tMountPoint mountPoint, const tDiPOEndCall endCall)
{
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(endCall);

    tResult ret = MP_NO_ERROR;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        if(IsIAP2(m_MountPoint)) {
            m_HandleMap.LockIAP2(m_MountPoint); //start critical section
            iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(m_MountPoint);
            if(!iap2Device) {
                ETG_TRACE_ERR(("!iap2Device"));
                ret = MP_ERR_IPOD_NO_ACCESS;
            } else {
                iAP2EndCallParameter endCallParameter;
                memset(&endCallParameter, 0, sizeof(endCallParameter));

                endCallParameter.iAP2EndAction = new iAP2EndCallEndAction;
                if(endCallParameter.iAP2EndAction != NULL)
                {
                    switch(endCall.endAction)
                    {
                        case DIPO_ENDACTION_END_OR_DECLINE:
                            endCallParameter.iAP2EndAction[0] = IAP2_END;
                            break;
                        case DIPO_ENDACTION_END_ALL:
                            endCallParameter.iAP2EndAction[0] = IAP2_END_ALL;
                            break;
                        default:
                            endCallParameter.iAP2EndAction[0] = IAP2_END;
                            break;
                    }

                    VARTRACE(endCallParameter.iAP2EndAction[0]);
                    endCallParameter.iAP2EndAction_count = TRUE;
                }

                endCallParameter.iAP2CallUUID = new U8*[1];

                if(endCallParameter.iAP2CallUUID != NULL)
                {
                    size_t size = strnlen(endCall.callUUID, IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
                    endCallParameter.iAP2CallUUID[0] = new U8[size];
                    strncpy_r((char*)endCallParameter.iAP2CallUUID[0],endCall.callUUID,size);
                    endCallParameter.iAP2CallUUID_count = TRUE;
                }
                ret = iAP2EndCall(iap2Device, &endCallParameter);
                ETG_TRACE_USR3(("iAP2SwapCalls returned %d", ret));
                if (IAP2_OK != ret) {
                    UpdateIpodCommunicationError(ret);
                }
                iAP2FreeiAP2EndCallParameter(&endCallParameter);
            }
            m_HandleMap.UnlockIAP2(m_MountPoint); //end critical section
        }
    }

    return ret;
}

tResult iPodControlIAP::iAP2_SwapCalls(const tMountPoint mountPoint)
{
    ENTRY;
    VARTRACE(mountPoint);
    tResult ret = MP_NO_ERROR;

    if (!SelectDevice(mountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        if(IsIAP2(m_MountPoint)) {
            m_HandleMap.LockIAP2(m_MountPoint); //start critical section
            iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(m_MountPoint);
            if(!iap2Device) {
                ETG_TRACE_ERR(("!iap2Device"));
                ret = MP_ERR_IPOD_NO_ACCESS;
            } else {
#ifdef TARGET_BUILD
                iAP2SwapCallsParameter swapCallsParameter;
                memset(&swapCallsParameter, 0, sizeof(swapCallsParameter) );
                ret = iAP2SwapCalls(iap2Device, &swapCallsParameter);
                ETG_TRACE_USR3(("iAP2SwapCalls returned %d", ret));
                if (IAP2_OK != ret) {
                    UpdateIpodCommunicationError(ret);
                }
#endif
            }
            m_HandleMap.UnlockIAP2(m_MountPoint); //end critical section
        }
    }

    return ret;
}

tResult iPodControlIAP::iAPUpdateCloseAllActiveSessions(const tMountPoint mountPoint)
{
    ENTRY;
    VARTRACE(mountPoint);
    tResult ret = MP_NO_ERROR;

    //notify app control clients about data session end
    vector<string> activeSession;
    m_HandleMap.GetActiveSessionList(activeSession, mountPoint);
    VARTRACE((int)activeSession.size());

    for (unsigned int i = 0; i < activeSession.size(); i++) {
        //send property update
        tAppName close_appName;
        strncpy_r(close_appName, activeSession[i].c_str(), sizeof(close_appName));
        VARTRACE(close_appName);

        tSessionID close_sessionID = m_HandleMap.GetSessionIDFromAppName(mountPoint, close_appName);
        VARTRACE(close_sessionID);

        LocalSPM::GetOutputWrapper().AppControlClose(mountPoint, close_appName, close_sessionID);

        iAPClearSessionID(mountPoint, close_sessionID, close_appName);
    }
    return ret;
}

tResult iPodControlIAP::iAP2UpdateAllAppControlProperties(const tMountPoint mountPoint)
{
    ENTRY;
    VARTRACE(mountPoint);
    tResult ret = MP_NO_ERROR;
    //LocalSPM::GetOutputWrapper().UpdateBTProfileInfo();
    //LocalSPM::GetOutputWrapper().UpdateDiPONowPlaying();
    //LocalSPM::GetOutputWrapper().UpdateDiPOPlaytime();
    //LocalSPM::GetOutputWrapper().UpdateDiPOPlaybackStatus();
    //LocalSPM::GetOutputWrapper().UpdateDiPOPlaybackShuffleMode();
    //LocalSPM::GetOutputWrapper().UpdateDiPOPlaybackRepeatMode();
    LocalSPM::GetOutputWrapper().UpdateDiPOCallState(); // NCG3D-10790
    LocalSPM::GetOutputWrapper().UpdateDiPOCommunications();

    return ret;
}

bool iPodControlIAP::iAPIsKnownUSBiAP1Device(const tMountPoint mountPoint)
{
    ENTRY;
    VARTRACE(mountPoint);
    bool isKnown = false;
    vector<string> knownUSBiAP1Devices;

    for(unsigned int i = 0; i < mKnownUSBiAP1Devices.size(); i++) {
        if(!strcmp(mKnownUSBiAP1Devices[i].c_str(), mountPoint)) {
            isKnown = true;
        } else {
            knownUSBiAP1Devices.push_back(mKnownUSBiAP1Devices[i]);
        }
    }

    //remove entry if consumed (SUZUKI-19609)
    mKnownUSBiAP1Devices = knownUSBiAP1Devices;
    VARTRACE((int)(long)mKnownUSBiAP1Devices.size()); // thoemel: the additional casting is due to 64 bit compiler

    VARTRACE(isKnown);
    return isKnown;
}


tResult iPodControlIAP::InitCarPlayMicroChipMitsumiPort2ES2()
{
    ENTRY
    ETG_TRACE_USR3(("InitCarPlayMicroChipMitsumiPort2ES2: uses InitCarPlayMicroChipHub()"));
    tResult res=InitCarPlayMicroChipHub();
    ETG_TRACE_USR3(("InitCarPlayMicroChipMitsumiPort2ES2: used InitCarPlayMicroChipHub(): res:%d ",res));
    return res;
}

tResult iPodControlIAP::InitCarPlayMicroChipMitsumiPort2ES4()
{
    ENTRY

    tResult res = IAP2_CTL_ERROR;

    tBool bOk = TRUE;
    unsigned char dat[2];
    uint16_t wLength;
    int ret = 0;

    //Reference see: https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-911362/CarPlay_Sequence_Ver0.93_Mitsumi_CMI-BD004-ES4_20161104.xlsx
    /*Init sequence*/
    /* 1. ISSUE DID check */
    /* 2. ISSUE Register Write Setup command for GPIO1 output setting*/
    /* 3. ISSUE USB to GPIO bridge command (PIO1) for enabling I2C bridging - PIO should be changed to HIGH for I2C communication */
    /* 3.1 Wait more than 5msec. For UCS2112 stable */
    /* 4. ISSUE Enable I2C Pass - through interface command*/
    /* 5. Add1 Issue "USB to GPIO bridge command" (PIO20) to switch state of CTL_SW signal Low level, this sequence connect logical Port1 to Physical port1 */
    /* 6. Add2 Issue Register Write Setup command for GPIO20 output setting*/
    /* 7. modify1 Issue USB to I2C bridge command for UCS Current limit setting (USB port1 and port2: Up to 1600mA)*/
    /* 8. modify2 Issue USB to I2C bridge command for UCS charger setting (Auto -> Latch) */
    /* 9. modify3 Issue USB to I2C bridge command for UCS charger setting (Port1:Power enable)*/
    /* 10. modify4 Issue USB to I2C bridge command for UCS charger setting (Port1 and 2:setting Pin_IGN,)
       /* 11. modify5 Issue USB to I2C bridge command for UCS charger setting (Port2:Power enab)*/
    /* Head Unit enumerates with Device1(if attached)*/
    /* Head Unit enumerates with Device2(if attached)*/

    //------------------------------------------------------------
    ETG_TRACE_USR3(("InitCarPlayMicroChipMitsumiPort2ES4:Init last step is 11."))
    //------------------------------------------------------------

    //switch hub
    libusb_device_handle* hndlToHub = libusb_open_device_with_vid_pid(NULL, MICROCHIP_VID, USB84604_PID);
    if(hndlToHub != NULL)
    {
        bOk = TRUE;
        //------------------------------------------------------------
        ETG_TRACE_USR3(("1/14 InitCarPlayMicroChipMitsumiPort2ES4:ISSUE DID check: successfull"))
        //------------------------------------------------------------
    }
    else
    {
        bOk = FALSE;
        ETG_TRACE_USR1(("[ERROR]: InitCarPlayMicroChipMitsumiPort2ES4 not found"));
    }

    if(bOk)
    {
        //-----------------------------------------------------------------------------------------
        ETG_TRACE_USR3(("2/14 InitCarPlayMicroChipMitsumiPort2ES4:ISSUE Register Write Setup command for GPIO1 output setting"))
        //-----------------------------------------------------------------------------------------
        dat[0] = 0x02; //data: (#GPIO1 is set Output)
        wLength = 0x01; //wLength (#1Byte Write )
        ret = send_libusb_control_transfer(hndlToHub,
          0x41,    // bmRequestType (#Host to device, vendor class, targeted to device )
          0x03,    // bRequest (#Register Write)
          0x0833,  // wValue (#GPIO 0-7 DIRECTION CONTROL REGISTER )
          0x0000,  // wIndex (#Reserved)
          dat,     // *data
          wLength, //wLength
          500);    // timeout
          VARTRACE(ret);
        if (ret != wLength)
        {
            bOk = FALSE;
            ETG_TRACE_ERR(("[ERROR]: InitCarPlayMicroChipMitsumiPort2ES4:ISSUE Register Write Setup command for GPIO1 output setting"));
        }
    }
    if(bOk)
    {
        //------------------------------------------------------------------------------------------------------------------------------------------------
        ETG_TRACE_USR3(("3/14 InitCarPlayMicroChipMitsumiPort2ES4:Issue USB to GPIO bridge command (PIO1) for enabling I2C bridging - PIO should be changed to HIGH for I2C communication"));
        //------------------------------------------------------------------------------------------------------------------------------------------
        /* GPIO1 is set High level */
        dat[0] = 0x02; //data (#GPIO1 is set High level)
        wLength = 0x01; //wLength (#1Byte Write )
        ret = send_libusb_control_transfer(hndlToHub,
          0x41,   // bmRequestType (#Host to device, vendor class, targeted to device )
          0x03,   // bRequest (#Register Write)
          0x0837, // wValue (#GPIO 0-7 OUTPUT REGISTER)
          0x0000, // wIndex (#Reserved )
          dat,    // *data
          wLength,// wLength
          500);   // timeout
        VARTRACE(ret);
        if (ret != wLength)
        {
            bOk = FALSE;
            ETG_TRACE_ERR(("[ERROR]: InitCarPlayMicroChipMitsumiPort2ES4:Issue USB to GPIO bridge command (PIO1)...."));
        }
    }

    if(bOk)
    {
        //------------------------------------------------------------------------------------------------------------------------------------------------
        ETG_TRACE_USR3(("4/14 InitCarPlayMicroChipMitsumiPort2ES4 Wait more than 5msec. For UCS2112 stable "));
        //------------------------------------------------------------------------------------------------------------------------------------------
        usleep(5000);
    }

    if(bOk)
    {
        //---------------------------------------------------------------------------------
        ETG_TRACE_USR3(("5/14 InitCarPlayMicroChipMitsumiPort2ES4:ISSUE Enable I2C Pass - through interface command"));
        //---------------------------------------------------------------------------------
        wLength = 0x00; //wLength (# 0 byte data )
        ret = send_libusb_control_transfer(hndlToHub,
          0x41,   // bmRequestType (#Host to device, vendor class, targeted to device)
          0x70,   // bRequest (#CMD_I2C_ENTER_PASSTHRU)
          0x0000, // wValue
          0x0000, // wIndex
          NULL,   // *data
          0x00,   // wLength
          500);   // timeout
        VARTRACE(ret);

        if (ret != wLength)
        {
            bOk = FALSE;
            ETG_TRACE_ERR(("[ERROR]: InitCarPlayMicroChipMitsumiPort2ES4:ISSUE Enable I2C Pass - through interface command"));
        }
    }

    if(bOk)
    {
        //---------------------------------------------------------------------------------
        ETG_TRACE_USR3(("6/14 InitCarPlayMicroChipMitsumiPort2ES4:Add1 Issue 'USB to GPIO bridge command' (PIO20) to switch state of CTL_SW signal Low level, this sequence connect logical Port1 to Physical port1"));
        //---------------------------------------------------------------------------------
        dat[0] = 0x00; //Data (#GPIO20 is set Low level.  Connect Logical port 1 to Physical port 1)
        wLength = 0x01; //wLength (#1Byte Write )
        ret = send_libusb_control_transfer(hndlToHub,
        0x41,   // bmRequestType  (#Host to device, vendor class, targeted to device)
        0x03,   // bRequest (#Register Write)
        0x0835, // wValue (#GPIO 17-20 OUTPUT REGISTER)
        0x0000, // wIndex (#Reserved)
        dat,   // *data
        wLength,// wLength
        500);   // timeout
        VARTRACE(ret);

        if (ret != wLength)
        {
         bOk = FALSE;
         ETG_TRACE_ERR(("[ERROR]: Add1 Issue 'USB to GPIO bridge command' (PIO20) to switch state"));
        }
    }

    if(bOk)
    {
         //---------------------------------------------------------------------------------------
         ETG_TRACE_USR3(("7/14 MInitCarPlayMicroChipMitsumiPort2ES4:Add2 Issue Register Write Setup command for GPIO20 output setting"));
         //---------------------------------------------------------------------------------------
         dat[0] = 0x10; //Data (#GPIO 20 is set Output mode)
         wLength = 0x01; //wLength (#1Byte Write )
         ret = send_libusb_control_transfer(hndlToHub,
           0x41,   // bmRequestType  (#Host to device, vendor class, targeted to device)
           0x03,   // bRequest (#Register Write)
           0x0831, // wValue (#GPIO 17-20 DIRECTION CONTROL REGISTER)
           0x0000, // wIndex (#Reserved)
           dat,   // *data
           wLength,   // wLength
           500);   // timeout
         VARTRACE(ret);

         if (ret != wLength)
         {
             bOk = FALSE;
             ETG_TRACE_ERR(("[ERROR]: MInitCarPlayMicroChipMitsumiPort2ES4: Add2 Issue Register Write Setup command for GPIO20 output setting"));
         }
     }

     if(bOk)
     {
         //---------------------------------------------------------------------------------------
         ETG_TRACE_USR3(("8/14 InitCarPlayMicroChipMitsumiPort2ES4: modify1 Issue USB to I2C bridge command for UCS Current limit setting (USB port1 and port2: Up to 1600mA)"));
         //---------------------------------------------------------------------------------------

         int iRetrialCount = 0;
         int iMaxRetrials  = 5;
         while(iRetrialCount < iMaxRetrials)
         {
             //0x1424; //Data (#Setting current limit. Pyhgical Port2:1600mA , Port1:1600mA)
             dat[0] = 0x14; //highByte
             dat[1] = 0x24;
             wLength = 0x02; //wLength (#2Byte Write )

             ret = send_libusb_control_transfer(hndlToHub,
               0x41,   // bmRequestType  (#Vender specific command, Host-to-device data transfer)
               0x71,   // bRequest (#CMD_I2C_WRITE)
               0x07AE, // wValue (#I2C Control flag 0x07, I2C address 0x57(1010_111b) + (r/w) b)
               0x0000, // wIndex (#Reserved)
               dat,   // *data
               wLength,   // wLength
               500);   // timeout
             VARTRACE(ret);

             if(ret != wLength)
             {
                 iRetrialCount++;
                 ETG_TRACE_USR2(("[WARNING]: InitCarPlayMicroChipMitsumiPort2ES4: Could not set UCS current limit (trial (%d/%d))",iRetrialCount,iMaxRetrials));
                 usleep(5000);
             }
             else
             {
                 ETG_TRACE_USR2(("InitCarPlayMicroChipMitsumiPort2ES4: set UCS current limit - ok"));
                 break;
             }
         }
         if (ret != wLength)
         {
             bOk = FALSE;
             ETG_TRACE_ERR(("[ERROR]: InitCarPlayMicroChipMitsumiPort2ES4: modify1 Issue USB to I2C bridge command for UCS Current limit setting (USB port1 and port2: Up to 1600mA)"));
         }
     }

     if(bOk)
     {
         //---------------------------------------------------------------------------------------
         ETG_TRACE_USR3(("9/14 InitCarPlayMicroChipMitsumiPort2ES4: modify2 Issue USB to I2C bridge command for UCS charger setting (Auto -> Latch mode)"));
         //---------------------------------------------------------------------------------------
         //0x1581; //Data (#Set Latch bit "1" (bit7))
         dat[0]  = 0x15;
         dat[1]  = 0x81;
         wLength = 0x02; //wLength (#2 Byte of Data(Register Address + 1 Byte of Data) )

         ret = send_libusb_control_transfer(hndlToHub,
           0x41,   // bmRequestType  (#Vender specific command, Host-to-device data transfer)
           0x71,   // bRequest (#CMD_I2C_WRITE)
           0x07AE, // wValue (#I2C Control flag 0x07, I2C address 0x57(1010_111b) + (r/w) b)
           0x0000, // wIndex (#Reserved)
           dat,   // *data
           wLength,   // wLength (#2 Byte of Data(Register Address + 1 Byte of Data))
           500);   // timeout
         VARTRACE(ret);

         if (ret != wLength)
         {
             bOk = FALSE;
             ETG_TRACE_ERR(("[ERROR]: InitCarPlayMicroChipMitsumiPort2ES4:modify2 Issue USB to I2C bridge command for UCS charger setting (Auto -> Latch)"));
         }
     }


    if(bOk)
    {
     //---------------------------------------------------------------------------------------
     ETG_TRACE_USR3(("10/14 InitCarPlayMicroChipMitsumiPort2ES4:modify3 Issue USB to I2C bridge command for UCS charger setting (Port1:Power enable)"));
     //---------------------------------------------------------------------------------------
     //0x111F; //Data  (#ALERT_MASK:0,ALERT1_LINK:0,DSCHG1:0,PWR_EN1S:1,DISCHG_TIME:11,ATT1_TH1:11)
     dat[0] = 0x11; //highByte
     dat[1] = 0x1F;      //lowByte
     wLength = 0x02; //wLength (#2 Byte of Data(Register Address + 1 Byte of Data))

     ret = send_libusb_control_transfer(hndlToHub,
       0x41,   // bmRequestType  (#Vender specific command, Host-to-device data transfer)
       0x71,   // bRequest (#CMD_I2C_WRITE)
       0x07AE, // wValue (#I2C Control flag 0x07, I2C address 0x57(1010_111b) + (r/w) b)
       0x0000, // wIndex (#Reserved)
       dat,   // *data
       wLength,// wLength
       500);   // timeout
     VARTRACE(ret);

     if (ret != wLength)
     {
         bOk = FALSE;
         ETG_TRACE_ERR(("[ERROR]: InitCarPlayMicroChipMitsumiPort2ES4: modify3 Issue USB to I2C bridge command for UCS charger setting (Port1:Power enable)"));
     }
    }

    if(bOk)
    {
      //---------------------------------------------------------------------------------------
      ETG_TRACE_USR3(("11/14 InitCarPlayMicroChipMitsumiPort2ES4: modify4 Issue USB to I2C bridge command for UCS charger setting (Port1 and 2:setting Pin_IGN,))"));
      //---------------------------------------------------------------------------------------
      //0x13E0; //Data (#PIN_IGN:1 , ATT_DIS:1, and DIS_TO:1,PWR_STATE<1:0>:00))
      dat[0] = 0x13; //highByte
      dat[1] = 0xE0;      //lowByte

      wLength = 0x02; //wLength (#2 Byte of Data(Register Address + 1 Byte of Data))

      ret = send_libusb_control_transfer(hndlToHub,
        0x41,   // bmRequestType  (#Host to device, vendor class, targeted to device)
        0x71,   // bRequest (#CMD_I2C_WRITE)
        0x07AE, // wValue (#I2C Control flag 0x07, I2C address 0x57(1010_111b) + (r/w) b)
        0x0000, // wIndex (#Reserved)
        dat,   // *data
        wLength,// wLength
        500);   // timeout
      VARTRACE(ret);

      if (ret != wLength)
      {
          bOk = FALSE;
          ETG_TRACE_ERR(("[ERROR]: InitCarPlayMicroChipMitsumiPort2ES4: modify4 Issue USB to I2C bridge command for UCS charger setting (Port1 and 2:setting Pin_IGN,)"));
      }
    }

    if(bOk)
    {
      //---------------------------------------------------------------------------------------
      ETG_TRACE_USR3(("12/14 MicroChipMitsumiPort2ES4: modify5 Issue USB to I2C bridge command for UCS charger setting (Port2:Power enab)"));
      //---------------------------------------------------------------------------------------
      //0x1213; //Data (#ALERT_MASK:0,ALERT2_LINK:0,DSCHG2:0,PWR_EN2S:1,ATT_TH2:11))
      dat[0] = 0x12; //highByte
      dat[1] = 0x13;      //lowByte

      wLength = 0x02; //wLength (#2 Byte of Data(Register Address + 1 Byte of Data))

      ret = send_libusb_control_transfer(hndlToHub,
        0x41,   // bmRequestType  (#Vender specific command, Host-to-device data transfer)
        0x71,   // bRequest (#CMD_I2C_WRITE)
        0x07AE, // wValue (#I2C Control flag 0x07, I2C address 0x57(1010_111b) + (r/w) b)
        0x0000, // wIndex (#Reserved)
        dat,   // *data
        wLength,// wLength (#2 Byte of Data(Register Address + 1 Byte of Data))
        500);   // timeout
      VARTRACE(ret);

      if (ret != wLength)
      {
          bOk = FALSE;
          ETG_TRACE_ERR(("[ERROR]: InitCarPlayMicroChipMitsumiPort2ES4: modify5 Issue USB to I2C bridge command for UCS charger setting (Port2:Power enab)"));
      }
      else
      {
          /*====SUCCESS========*/
          res = IAP2_OK;
          /*==================*/
          ETG_TRACE_USR1(("13/14 [RESULT:OK]: InitCarPlayMicroChipMitsumiPort2ES4: Initial_sequence Mitsumi HUB ok"))
      }
    }

    //close handle if open
    if(hndlToHub != NULL)
    {
        ETG_TRACE_USR4(("14/14 InitCarPlayMicroChipMitsumiPort2ES4:libusb_close"))
        libusb_close(hndlToHub);
    }


    return res;

}


tResult iPodControlIAP::InitCarPlayMicroChipHub()
{
    ENTRY;
    tResult res = IAP2_CTL_ERROR;

    //switch hub
    libusb_device_handle* hndlToHub = libusb_open_device_with_vid_pid(NULL, MICROCHIP_VID, USB84604_PID);
    if(hndlToHub != NULL) {

        unsigned char dat[2];
        int ret = 0;

        /* set GPIO1 high for I2C SDA/SCL pull-up resistors */

        ETG_TRACE_USR3(("InitCarPlayMicroChipHub: Issue Register Write Setup command for GPIO1 output setting"));
        /* GPIO1 is set Output */
        dat[0] = 0x02;
        ret = libusb_control_transfer(hndlToHub,
          /* Host to device, vendor class, targeted to device */
          0x41,   // bmRequestType
          /* Register Write */
          0x03,   // bRequest
          /* GPIO 0-7 DIRECTION CONTROL REGISTER */
          0x0833, // wValue
          /* Reserved */
          0x0000, // wIndex
          dat,    // *data
          /* 1Byte Write */
          0x01,   // wLength
          500);   // timeout
        VARTRACE(ret);
        if (ret != 1) {
            ETG_TRACE_ERR(("[ERROR]: InitCarPlayMicroChipHub: Could not set GPIO1 to output"));
        } else {

            ETG_TRACE_USR3(("InitCarPlayMicroChipHub: :Issue USB to GPIO bridge command (PIO1) for enabling I2C bridging"));
            /* GPIO1 is set High level */
            dat[0] = 0x02;
            ret = libusb_control_transfer(hndlToHub,
              /* Host to device, vendor class, targeted to device */
              0x41,   // bmRequestType
              /* Register Write */
              0x03,   // bRequest
              /* GPIO 0-7 OUTPUT REGISTER */
              0x0837, // wValue
              /* Reserved */
              0x0000, // wIndex
              dat,    // *data
              /* 1Byte Write */
              0x01,   // wLength
              500);   // timeout
            VARTRACE(ret);
            if (ret != 1) {
                ETG_TRACE_ERR(("[ERROR]: InitCarPlayMicroChipHub: Could not set GPIO1 to high"));
            } else {

                ETG_TRACE_USR3(("InitCarPlayMicroChipHub: Issue Enable I2C pass-through interface command"));
                ret = libusb_control_transfer(hndlToHub,
                  /* Host to device, vendor class, targeted to device */
                  0x41,   // bmRequestType
                  /* CMD_I2C_ENTER_PASSTHRU */
                  0x70,   // bRequest
                  0x0000, // wValue
                  0x0000, // wIndex
                  NULL,   // *data
                  0x00,   // wLength
                  500);   // timeout
                VARTRACE(ret);

                if (ret != 0) {
                    ETG_TRACE_ERR(("[ERROR]:InitCarPlayMicroChipHub:  Could not set I2C to pass-through"));
                } else {

                    int retry = 0;
                    int done = 0;
                    while (retry++ < 3 && done == 0) {
                        ETG_TRACE_USR3(("InitCarPlayMicroChipHub: Issue USB to I2C bridge command for UCS setting (Port1: current limit setting)"));
                        /* Setting current limit 1680mA */
                        dat[0] = 0x19;
                        dat[1] = 0x04;
                        ret = libusb_control_transfer(hndlToHub,
                          /* Host to device, vendor class, targeted to device */
                          0x41,   // bmRequestType
                          /* CMD_I2C_WRITE */
                          0x71,   // bRequest
                          /* I2C Control flag 0x07, I2C address 0x66(0110_0110b). For port1 control */
                          0x0766, // wValue
                          0x0000, // wIndex
                          /* 2 Byte of Data (Register Address + 1 Byte of Data) */
                          dat,    // *data
                          0x02,   // wLength
                          500);   // timeout
                        VARTRACE(ret);
                        if (ret == 2) {
                            done = 1;
                        } else {
                            ETG_TRACE_ERR(("InitCarPlayMicroChipHub: Warning: Port1: Could not send I2C bridge command, retry (%d)", retry));
                        }
                    }
                    if (retry > 4) {
                      ETG_TRACE_ERR(("[ERROR]: InitCarPlayMicroChipHub: Port1: Could not send I2C bridge command"));
                    } else {

                        ETG_TRACE_USR3(("InitCarPlayMicroChipHub: Issue USB to I2C bridge command for UCS setting (Port2: current limit setting)"));
                        /* Setting current limit 1680mA */
                        dat[0] = 0x19;
                        dat[1] = 0x04;
                        ret = libusb_control_transfer(hndlToHub,
                          /* Host to device, vendor class, targeted to device */
                          0x41,   // bmRequestType
                          /* CMD_I2C_WRITE */
                          0x71,   // bRequest
                          /* I2C Control flag 0x07, I2C address 0x64(0110_0100b). For port2 control */
                          0x0764, // wValue
                          0x0000, // wIndex
                          /* 2 Byte of Data (Register Address + 1 Byte of Data) */
                          dat,    // *data
                          0x02,   // wLength
                          500);   // timeout
                        VARTRACE(ret);
                        if (ret != 2) {
                            ETG_TRACE_ERR(("[ERROR]: InitCarPlayMicroChipHub: Port2: Could not send I2C bridge command"));
                        } else {

                            ETG_TRACE_USR3(("InitCarPlayMicroChipHub: Issue USB to I2C bridge command for UCS charger setting (Port1: Only changing Auto recovery -> Latch)"));
                            /* Set Latch bit "1" (bit0) */
                            dat[0] = 0x17;
                            dat[1] = 0x3D;
                            ret = libusb_control_transfer(hndlToHub,
                              /* Host to device, vendor class, targeted to device */
                              0x41,   // bmRequestType
                              /* CMD_I2C_WRITE */
                              0x71,   // bRequest
                              /* I2C Control flag 0x07, I2C address 0x66(0110_0110b). For port1 control */
                              0x0766, // wValue
                              0x0000, // wIndex
                              /* 2 Byte of Data (Register Address + 1 Byte of Data) */
                              dat,    // *data
                              0x02,   // wLength
                              500);   // timeout
                            VARTRACE(ret);
                            if (ret != 2) {
                                ETG_TRACE_ERR(("[ERROR]: InitCarPlayMicroChipHub: Could not set charger setting"));
                            } else {

                                ETG_TRACE_USR3(("Issue USB to I2C bridge command for UCS charger setting (Port2: Only changing Auto recovery -> Latch)"));
                                /* Set Latch bit "1" (bit0) */
                                dat[0] = 0x17;
                                dat[1] = 0x3D;
                                ret = libusb_control_transfer(hndlToHub,
                                  /* Host to device, vendor class, targeted to device */
                                  0x41,   // bmRequestType
                                  /* CMD_I2C_WRITE */
                                  0x71,   // bRequest
                                  /* I2C Control flag 0x07, I2C address 0x64(0110_0100b). For port2 control */
                                  0x0764, // wValue
                                  0x0000, // wIndex
                                  /* 2 Byte of Data (Register Address + 1 Byte of Data) */
                                  dat,    // *data
                                  0x02,   // wLength
                                  500);   // timeout
                                VARTRACE(ret);
                                if (ret != 2) {
                                    ETG_TRACE_ERR(("[ERROR]: InitCarPlayMicroChipHub: Could not set charger setting"));
                                } else {

                                    ETG_TRACE_USR3(("InitCarPlayMicroChipHub: Issue USB to I2C bridge command for UCS charger setting (Port1: setting Pin_IGN, Power enable, CDP)"));
                                    /* PIN_IGN set "1" , PWR_EN set "1", and Set CDP mode */
                                    dat[0] = 0x17;
                                    dat[1] = 0xBF;
                                    ret = libusb_control_transfer(hndlToHub,
                                      /* Host to device, vendor class, targeted to device */
                                      0x41,   // bmRequestType
                                      /* CMD_I2C_WRITE */
                                      0x71,   // bRequest
                                      /* I2C Control flag 0x07, I2C address 0x66(0110_0110b). For port1 control */
                                      0x0766, // wValue
                                      0x0000, // wIndex
                                      /* 2 Byte of Data (Register Address + 1 Byte of Data) */
                                      dat,    // *data
                                      0x02,   // wLength
                                      500);   // timeout
                                    VARTRACE(ret);
                                    if (ret != 2) {
                                        ETG_TRACE_ERR(("[ERROR]: InitCarPlayMicroChipHub: Could not set PIO_20"));
                                    } else {

                                        ETG_TRACE_USR3(("InitCarPlayMicroChipHub: Issue USB to I2C bridge command for UCS charger setting (Port2: setting Pin_IGN, Power enable, CDP)"));
                                        /* PIN_IGN set "1" , PWR_EN set "1", and Set CDP mode */
                                        dat[0] = 0x17;
                                        dat[1] = 0xBF;
                                        ret = libusb_control_transfer(hndlToHub,
                                          /* Host to device, vendor class, targeted to device */
                                          0x41,   // bmRequestType
                                          /* CMD_I2C_WRITE */
                                          0x71,   // bRequest
                                          /* I2C Control flag 0x07, I2C address 0x64(0110_0100b). For port2 control */
                                          0x0764, // wValue
                                          0x0000, // wIndex
                                          /* 2 Byte of Data (Register Address + 1 Byte of Data) */
                                          dat,    // *data
                                          0x02,   // wLength
                                          500);   // timeout
                                        VARTRACE(ret);
                                        if (ret != 2) {
                                            ETG_TRACE_ERR(("[ERROR]: InitCarPlayMicroChipHub: Could not set PIO_20"));
                                        } else {
                                            /*====SUCCESS========*/
                                            res = IAP2_OK;
                                            /*==================*/
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        ETG_TRACE_USR4(("InitCarPlayMicroChipHub:libusb_close"))
        libusb_close(hndlToHub);
    } else {
        ETG_TRACE_USR1(("InitCarPlayMicroChipHub: MCH not found"));
    }

    ETG_TRACE_USR2(("InitCarPlayMicroChipHub: res:0x%x (IAP2_OK:0x%x,IAP2_CTL_ERROR=0x%x)",res,IAP2_OK,IAP2_CTL_ERROR));
    return res;
}

tResult iPodControlIAP::SwitchCarPlayMicroChipMitsumiPort2ES2Hub(const tMountPoint mountPoint, const int port)
{
    ENTRY

    ETG_TRACE_USR4(("SwitchCarPlayMicroChipMitsumiPort2ES2Hub: uses SwitchCarPlayMicroChipHub(...)"));
    tResult res = SwitchCarPlayMicroChipHub(mountPoint, port);
    ETG_TRACE_USR4(("SwitchCarPlayMicroChipMitsumiPort2ES2Hub: used SwitchCarPlayMicroChipHub(...) res=%d",res));

    return res;
}



tResult iPodControlIAP::SwitchCarPlayMicroChipMitsumiPort2ES4Hub(const tMountPoint mountPoint, const int port)
{
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(port);

    tResult  res= IAP2_CTL_ERROR;

    tBool bOk = TRUE;
    uint16_t wLength;
    unsigned char dat[2];
    int ret;

    ETG_TRACE_USR4(("SwitchCarPlayMicroChipMitsumiPort2ES4Hub: carplay start sequence"));
    ETG_TRACE_USR4(("SwitchCarPlayMicroChipMitsumiPort2ES4Hub: ref Ver0.93 from 04-NOV-2016"));

    //switch hub
    libusb_device_handle* hndlToHub = libusb_open_device_with_vid_pid(NULL, MICROCHIP_VID, USB84604_PID);
    if(hndlToHub != NULL)
    {
        bOk = TRUE;
        //------------------------------------------------------------
        ETG_TRACE_USR3(("1. MicroChipMitsumiPort2ES4:ISSUE DID check: successfull"))
        //------------------------------------------------------------
    }
    else
    {
        bOk = FALSE;
        ETG_TRACE_USR1(("[ERROR]: 1.MicroChipMitsumiPort2ES4 not found"));
    }

    //------------------
    //PORT1
    //------------------
    if(port == 1)
    {
        if (bOk)
        {
            /* add1 */
            ETG_TRACE_USR4(("SwitchCarPlayMicroChipMitsumiPort2ES4Hub: Issue USB to I2C bridge command for UCS charger setting (Port 2:Power disable)"));
            /* ALERT_MASK:0,ALERT2_LINK:0,DSCHG2:0,PWR_EN2S:1,ATT_TH2:11 */
            dat[0] = 0x12;
            dat[1] = 0x03;
            wLength = 2;
            ret = send_libusb_control_transfer(hndlToHub,
            /* Host to device, vendor class, targeted to device */
            0x41,   // bmRequestType
            /* CMD_I2C_WRITE */
            0x71,   // bRequest
            /* I2C Control flag 0x07, I2C address 0x57(1010_111b) + (r/w) b */
            0x07AE, // wValue
            /* Reserved */
            0x0000, // wIndex
            dat,    // *data
            /* 2 Byte Write */
            wLength,   // wLength
            500);   // timeout
            if (ret != wLength)
            {
                ETG_TRACE_USR4(("[ERROR]:SwitchCarPlayMicroChipMitsumiPort2ES4Hub: Error: Could not set UCS current limit (%d)", ret));
                bOk = FALSE;
            }
        }


        if(bOk)
        {
            /* add2 */
            ETG_TRACE_USR4(("SwitchCarPlayMicroChipMitsumiPort2ES4Hub: Issue USB to I2C bridge command for UCS Current limit setting (USB port1: Up to 2670mA, port2: Up to 1600mA)"));
            /* Current Limit register */
            dat[0] = 0x14;
            /* Setting current limit, bit 5-3: 100 = 1.6A; bit 2-0: 110 = 2.67A */
            dat[1] = 0x26;
            wLength = 2;
            ret = send_libusb_control_transfer(hndlToHub,
            /* Host to device, vendor class, targeted to device */
            0x41,   // bmRequestType
            /* CMD_I2C_WRITE */
            0x71,   // bRequest
            /* I2C Control flag 0x07, I2C address 0x57(1010_111b) + (r/w) b */
            0x07AE, // wValue
            /* Reserved */
            0x0000, // wIndex
            dat,    // *data
            /* 2 Byte Write */
            wLength,   // wLength
            500);   // timeout

            if (ret != wLength)
            {
              ETG_TRACE_USR4(("[ERROR]:SwitchCarPlayMicroChipMitsumiPort2ES4Hub: Error: Could not set UCS current limit (%d)", ret));
              bOk = FALSE;
            }
        }

        ETG_TRACE_USR4(("SwitchCarPlayMicroChipMitsumiPort2ES4Hub: Issue iAP2 command to iPhone (For allowing 2.4A charging)")); //unclear
        ETG_TRACE_USR4(("SwitchCarPlayMicroChipMitsumiPort2ES4Hub: Issue CarPlay command to iPhone by iAP2")); //unclear


        if(bOk)
        {
            ETG_TRACE_USR4(("SwitchCarPlayMicroChipMitsumiPort2ES4Hub: Issue Register Write Setup command for GPIO20 output setting"));
            /* GPIO 20 is set to Output mode */
            dat[0] = 0x10;
            wLength = 1;
            ret = send_libusb_control_transfer(hndlToHub,
              /* Host to device, vendor class, targeted to device */
              0x41,   // bmRequestType
              /* Register Write */
              0x03,   // bRequest
              /* GPIO 17-20 DIRECTION CONTROL REGISTER */
              0x0831, // wValue
              /* Reserved */
              0x0000, // wIndex
              dat,    // *data
              /* 1Byte Write */
              wLength,   // wLength
              500);   // timeout
              if (ret != wLength)
              {
                  ETG_TRACE_USR4(("[ERROR]:SwitchCarPlayMicroChipMitsumiPort2ES4Hub: Error: Could not set GPIO20 to output (%d)", ret));
                  bOk = FALSE;
              }
        }


        if(bOk)
        {
            /* add3 */
            ETG_TRACE_USR4(("SwitchCarPlayMicroChipMitsumiPort2ES4Hub: Issue USB to I2C bridge command for UCS charger setting (Port 2: Start Discharge timer)"));
            /* ALERT_MASK:0,ALERT2_LINK:0,DSCHG2:1,PWR_EN2S:1,ATT_TH2:11 */
            dat[0] = 0x12;
            dat[1] = 0x33;
            wLength = 2;
            ret = send_libusb_control_transfer(hndlToHub,
            /* Host to device, vendor class, targeted to device */
            0x41,   // bmRequestType
            /* CMD_I2C_WRITE */
            0x71,   // bRequest
            /* I2C Control flag 0x07, I2C address 0x57(1010_111b) + (r/w) b */
            0x07AE, // wValue
            /* Reserved */
            0x0000, // wIndex
            dat,    // *data
            /* 2 Byte Write */
            wLength,   // wLength
            500);   // timeout
            if (ret != wLength)
            {
                ETG_TRACE_USR4(("[ERROR]:SwitchCarPlayMicroChipMitsumiPort2ES4Hub: Error: Could not set UCS discharge timer (%d)", ret));
                bOk = FALSE;
            }
        }
    }//port1

    //------------------
    //PORT2
    //------------------
    if (port == 2)
    {
        if (bOk)
        {
            /* add4 */
            ETG_TRACE_USR4(("SwitchCarPlayMicroChipMitsumiPort2ES4Hub: Issue USB to I2C bridge command for UCS charger setting (Port 1: Power disable)"));
            /* ALERT_MASK:0,ALERT1_LINK:0,DSCHG1:0,PWR_EN1S:0,DISCHG_TIME:11,ATT1_TH1:11*/
            dat[0] = 0x11;
            dat[1] = 0x0F;
            wLength = 2;
            ret = send_libusb_control_transfer(hndlToHub,
            /* Host to device, vendor class, targeted to device */
            0x41,   // bmRequestType
            /* CMD_I2C_WRITE */
            0x71,   // bRequest
            /* I2C Control flag 0x07, I2C address 0x57(1010_111b) + (r/w) b */
            0x07AE, // wValue
            /* Reserved */
            0x0000, // wIndex
            dat,    // *data
            /* 2 Byte Write */
            wLength,   // wLength
            500);   // timeout
            if (ret != wLength)
            {
                ETG_TRACE_USR4(("[ERROR] SwitchCarPlayMicroChipMitsumiPort2ES4Hub: Error: Could not set UCS current limit (%d)", ret));
               bOk = FALSE;
            }
        }

        if (bOk)
        {
            /* add5 */
            ETG_TRACE_USR4(("SwitchCarPlayMicroChipMitsumiPort2ES4Hub: Issue USB to I2C bridge command for UCS Current limit setting (USB port1: Up to 1600mA, port2: Up to 2670mA)"));
            /* Current Limit register */
            dat[0] = 0x14;
            /* Setting current limit, bit 5-3: 110 = 2.67A; bit 2-0: 100 = 1.6A */
            dat[1] = 0x34;
             wLength = 2;
            ret = send_libusb_control_transfer(hndlToHub,
            /* Host to device, vendor class, targeted to device */
            0x41,   // bmRequestType
            /* CMD_I2C_WRITE */
            0x71,   // bRequest
            /* I2C Control flag 0x07, I2C address 0x57(1010_111b) + (r/w) b */
            0x07AE, // wValue
            /* Reserved */
            0x0000, // wIndex
            dat,    // *data
            /* 2 Byte Write */
            wLength,   // wLength
            500);   // timeout
            if (ret != wLength)
            {
                ETG_TRACE_USR4(("[ERROR]:SwitchCarPlayMicroChipMitsumiPort2ES4Hub: Error: Could not set UCS current limit (%d)", ret));
                //errors[15]++;
                bOk = FALSE;
            }
        }

        ETG_TRACE_USR4(("SwitchCarPlayMicroChipMitsumiPort2ES4Hub: Issue iAP2 command to iPhone (For allowing 2.4A charging)"));
        ETG_TRACE_USR4(("SwitchCarPlayMicroChipMitsumiPort2ES4Hub: Issue CarPlay command to iPhone by iAP2"));

        ETG_TRACE_USR4(("SwitchCarPlayMicroChipMitsumiPort2ES4Hub: Issue Register Write Setup command for GPIO20 output setting"));

        if (bOk)
        {
            /* GPIO 20 is set to Output mode */
            dat[0] = 0x10;
            wLength = 1;
            ret = send_libusb_control_transfer(hndlToHub,
            /* Host to device, vendor class, targeted to device */
            0x41,   // bmRequestType
            /* Register Write */
            0x03,   // bRequest
            /* GPIO 17-20 DIRECTION CONTROL REGISTER */
            0x0831, // wValue
            /* Reserved */
            0x0000, // wIndex
            dat,    // *data
            /* 1Byte Write */
            wLength,   // wLength
            500);   // timeout
            if (ret != wLength)
            {
              ETG_TRACE_USR4(("[ERROR]:SwitchCarPlayMicroChipMitsumiPort2ES4Hub: Error: Could not set GPIO20 to output (%d)", ret));

              bOk = FALSE;
            }
        }

        if (bOk)
        {
            ETG_TRACE_USR4(("SwitchCarPlayMicroChipMitsumiPort2ES4Hub:Issue USB to GPIO bridge command (PIO20) to switch state of CTL_SW signal and connect iPhone to logical Port 1 (Physical port 2)"));
            /* GPIO20 is set High level. Connect Logical port 1 to Physical port 2 */
            dat[0] = 0x10;
            wLength = 0x01;
            ret = send_libusb_control_transfer(hndlToHub,
            /* Host to device, vendor class, targeted to device */
            0x41,   // bmRequestType
            /* Register Write */
            0x03,   // bRequest
            /* GPIO 17-20 OUTPUT REGISTER */
            0x0835, // wValue
            /* Reserved */
            0x0000, // wIndex
            dat,    // *data
            /* 1Byte Write */
            wLength,   // wLength
            500);   // timeout
            if (ret != wLength)
            {
                ETG_TRACE_USR4(("[ERROR]: SwitchCarPlayMicroChipMitsumiPort2ES4Hub:Error: Could not set GPIO20 (%d)", ret));
                bOk = FALSE;
            }
        }

        if (bOk)
        {

            /* add6 */
            ETG_TRACE_USR4(("SwitchCarPlayMicroChipMitsumiPort2ES4Hub: Issue USB to I2C bridge command for UCS charger setting (Port 1: Start Discharge timer)"));
            /* ALERT_MASK:0,ALERT1_LINK:0,DSCHG1:1,PWR_EN1S:1,DISCHG_TIME:11,ATT1_TH1:11 */
            dat[0] = 0x11;
            dat[1] = 0x3F;
            wLength = 0x02;
            ret = send_libusb_control_transfer(hndlToHub,
            /* Host to device, vendor class, targeted to device */
            0x41,   // bmRequestType
            /* CMD_I2C_WRITE */
            0x71,   // bRequest
            /* I2C Control flag 0x07, I2C address 0x57(1010_111b) + (r/w) b */
            0x07AE, // wValue
            /* Reserved */
            0x0000, // wIndex
            dat,    // *data
            /* 2 Byte Write */
            wLength,   // wLength
            500);   // timeout
            if (ret != 2)
            {
                ETG_TRACE_USR4(("[ERROR]: SwitchCarPlayMicroChipMitsumiPort2ES4Hub::Error: Could not set UCS discharge timer (%d)", ret));
                bOk = FALSE;
            }
        }
    }//port2 related


    if (bOk)
    {
        ETG_TRACE_USR4(("SwitchCarPlayMicroChipMitsumiPort2ES4Hub: Issue USB to GPIO bridge command (Set GPIO1 is low) for preparing FlexConnect mode. *Also this command affects disabling I2C bridging. (Port1, Port2 common command)"));
        /* GPIO1 is set Low level */
        dat[0] = 0x00;
        wLength = 1;
        ret = send_libusb_control_transfer(hndlToHub,
          /* Host to device, vendor class, targeted to device */
          0x41,   // bmRequestType
          /* Register Write */
          0x03,   // bRequest
          /* GPIO 0-7 OUTPUT REGISTER */
          0x0837, // wValue
          /* Reserved */
          0x0000, // wIndex
          dat,    // *data
          /* 1Byte Write */
          wLength,   // wLength
          500);   // timeout
        if (ret != wLength)
        {
          ETG_TRACE_USR4(("[ERROR]:SwitchCarPlayMicroChipMitsumiPort2ES4Hub: Error: Could not set GPIO1 to low (%d)", ret));
          //errors[18]++;
          bOk = FALSE;
        }
    }

    if (bOk)
    {
        /* here the role switch CarPlay command would be issued */
        ETG_TRACE_USR4(("SwitchCarPlayMicroChipMitsumiPort2ES4Hub: The CarPlay role switch would happen here"));

        /* modify1 */
        wLength = 0;
        ETG_TRACE_USR4(("SwitchCarPlayMicroChipMitsumiPort2ES4Hub: Issue FlexConnect command"));
        ret = send_libusb_control_transfer(hndlToHub,
          /* Host to device, vendor class, targeted to device */
          0x41,   // bmRequestType
          /* FlexConnect Command */
          0x08,   // bRequest
          /* see table */
          0xC47C,    // wValue
          0x0000, // wIndex
          NULL,   // *data
          wLength,   // wLength
          500);   // timeout
        if (ret != wLength)
        {
            ETG_TRACE_USR4(("[ERROR]:SwitchCarPlayMicroChipMitsumiPort2ES4Hub: Error: Could not issue FlexConnect (%d)", ret));
            bOk = FALSE;
        }
        else
        {
          /*====SUCCESS========*/
          res = IAP2_OK;
          /*==================*/
          ETG_TRACE_USR1(("[RESULT:OK]: SwitchCarPlayMicroChipMitsumiPort2ES4Hub: OK"))
        }

    }

    if(hndlToHub != NULL)
    {
        ETG_TRACE_USR4(("SwitchCarPlayMicroChipMitsumiPort2ES4Hub:libusb_close"))
        libusb_close(hndlToHub);
    }

    ETG_TRACE_USR2(("SwitchCarPlayMicroChipMitsumiPort2ES4Hub: bOk:0x%x, res:0x%x (IAP2_OK:0x%x,IAP2_CTL_ERROR=0x%x)",bOk,res,IAP2_OK,IAP2_CTL_ERROR));

    return res;

}


tResult iPodControlIAP::SwitchCarPlayMicroChipHub(const tMountPoint mountPoint, const int port)
{
    ENTRY;
    VARTRACE(mountPoint);
    VARTRACE(port);

    tResult res = IAP2_CTL_ERROR;

    //switch hub
    libusb_device_handle* hndlToHub = libusb_open_device_with_vid_pid(NULL, MICROCHIP_VID, USB84604_PID);
    if(hndlToHub != NULL) {

        unsigned char dat[2];
        int ret = 0;
        unsigned short wValue = 0;

         /* short Vbus on->off->on at OTHER port */
         ETG_TRACE_USR3(("SwitchCarPlayMicroChipHub: Issue USB to I2C bridge command for UCS setting (Port: CDP => DCP)"));
         if (port == 1) {
             /* I2C Control flag 0x07, I2C address 0x64(0110_0100b). For port2 control */
             wValue = 0x0764;
         } else {
             /* I2C Control flag 0x07, I2C address 0x66(0110_0110b). For port1 control */
             wValue = 0x0766;
         }
         int retry = 0;
         int done = 0;
         while (retry++ < 3 && done == 0) {
             /* PIN_IGN set "1" and Set CDP -> DCP mode */
             dat[0] = 0x17;
             dat[1] = 0xB7;
             ret = libusb_control_transfer(hndlToHub,
               /* Host to device, vendor class, targeted to device */
               0x41,   // bmRequestType
               /* CMD_I2C_WRITE */
               0x71,   // bRequest
               wValue, // wValue
               0x0000, // wIndex
               /* 2 Byte of Data (Register Address + 1 Byte of Data) */
               dat,    // *data
               0x02,   // wLength
               500);   // timeout
             VARTRACE(ret);
             if (ret == 2) {
                 done = 1;
             } else {
                 ETG_TRACE_ERR(("[Warning]: SwitchCarPlayMicroChipHub: Port1: Could not set Port%d: CDP => DCP, retry (%d)", port, retry));
             }
         }
         if (retry > 4) {
             ETG_TRACE_ERR(("[ERROR]: SwitchCarPlayMicroChipHub: Could not set Port%d: CDP => DCP", port));
         } else {

             ETG_TRACE_USR3(("SwitchCarPlayMicroChipHub: Issue Register Write Setup command for GPIO20 output setting"));
             /* GPIO 20 is set Output mode */
             dat[0] = 0x10;
             ret = libusb_control_transfer(hndlToHub,
               /* Host to device, vendor class, targeted to device */
               0x41,   // bmRequestType
               /* Register Write */
               0x03,   // bRequest
               /* GPIO 17-20 DIRECTION CONTROL REGISTER */
               0x0831, // wValue
               /* Reserved */
               0x0000, // wIndex
               dat,    // *data
               /* 1Byte Write */
               0x01,   // wLength
               500);   // timeoutETG_TRACE_USR3
             VARTRACE(ret);
             if (ret != 1) {
                 ETG_TRACE_ERR(("[ERROR]:SwitchCarPlayMicroChipHub:  Could not set GPIO20 to output"));
             } else {

                 ETG_TRACE_USR3(("SwitchCarPlayMicroChipHub: Issue USB to GPIO bridge command (PIO20) to switch state of CTL_SW signal and connect iPhone to logical Port 1 (Physical port %d)", port));
                 if (port == 1) {
                   /* GPIO20 is set Low level.  Connect Logical port 1 to Physical port 1 */
                   dat[0] = 0x00;
                 } else {
                   /* GPIO20 is set Low level.  Connect Logical port 1 to Physical port 2 */
                   dat[0] = 0x10;
                 }
                 ret = libusb_control_transfer(hndlToHub,
                   /* Host to device, vendor class, targeted to device */
                   0x41,   // bmRequestType
                   /* Register Write */
                   0x03,   // bRequest
                   /* GPIO 17-20 DIRECTION OUTPUT REGISTER */
                   0x0835, // wValue
                   /* Reserved */
                   0x0000, // wIndex
                   dat,    // *data
                   /* 1Byte Write */
                   0x01,   // wLength
                   500);   // timeout
                 VARTRACE(ret);
                 if (ret != 1) {
                     ETG_TRACE_ERR(("[ERROR]:SwitchCarPlayMicroChipHub:  Could not set GPIO20"));
                 } else {

                     ETG_TRACE_USR3(("SwitchCarPlayMicroChipHub: Issue USB to GPIO bridge command (PIO1) for disabling I2C bridging"));
                     /* GPIO1 is set High level */
                     dat[0] = 0x00;
                     ret = libusb_control_transfer(hndlToHub,
                       /* Host to device, vendor class, targeted to device */
                       0x41,   // bmRequestType
                       /* Register Write */
                       0x03,   // bRequest
                       /* GPIO 0-7 OUTPUT REGISTER */
                       0x0837, // wValue
                       /* Reserved */
                       0x0000, // wIndex
                       dat,    // *data
                       /* 1Byte Write */
                       0x01,   // wLength
                       500);   // timeout
                     VARTRACE(ret);
                     if (ret != 1) {
                         ETG_TRACE_ERR(("[ERROR]:SwitchCarPlayMicroChipHub:  Could not set GPIO1 to low"));
                     } else {
#if 0
                         ETG_TRACE_USR3(("Issue Register Write Setup command for GPIO1 input setting"));
                         /* GPIO1 is set Output */
                         dat[0] = 0x00;
                         ret = libusb_control_transfer(hndlToHub,
                           /* Host to device,InitMicroChipHub vendor class, targeted to device */
                           0x41,   // bmRequestType
                           /* Register Write */
                           0x03,   // bRequest
                           /* GPIO 0-7 DIRECTION CONTROL REGISTER */
                           0x0833, // wValue
                           /* Reserved */
                           0x0000, // wIndex
                           dat,    // *data
                           /* 1Byte Write */
                           0x01,   // wLength
                           500);   // timeout
                         VARTRACE(ret);
#endif
                         if (ret != 1) {
                             ETG_TRACE_ERR(("[ERROR]:SwitchCarPlayMicroChipHub:  Could not set GPIO1 to input"));
                         } else {

                             ETG_TRACE_USR3(("SwitchCarPlayMicroChipHub: Issue FlexConnect command"));
                             ret = libusb_control_transfer(hndlToHub,
                               /* Host to device, vendor class, targeted to device */
                               0x41,   // bmRequestType
                               /* FlexConnect Command */
                               0x08,   // bRequest
                               /* see table */
                               MICROCHIP_CMD,    // wValue
                               0x0000, // wIndex
                               NULL,   // *data
                               0x00,   // wLength
                               500);   // timeout
                             VARTRACE(ret);
                             if (ret != 0) {
                                 ETG_TRACE_ERR(("[ERROR]:SwitchCarPlayMicroChipHub:  Could not issue FlexConnect"));
                             } else {
                                 //success!
                                 res = IAP2_OK;
                             }
                         }
                     }
                }
            }
        }

        ETG_TRACE_USR4(("SwitchCarPlayMicroChipHub:libusb_close"))
        libusb_close(hndlToHub);
    }


    ETG_TRACE_USR2(("SwitchCarPlayMicroChipHub: res:0x%x (IAP2_OK:0x%x,IAP2_CTL_ERROR=0x%x)",res,IAP2_OK,IAP2_CTL_ERROR));
    return res;
}


tResult iPodControlIAP::TerminateCarPlayMicroChipMitsumiPort2ES2()
{
    ENTRY
    ETG_TRACE_USR3(("TerminateCarPlayMicroChipMitsumiPort2ES2: uses TerminateCarPlayMicroChipHub(...)"));
    tResult res=TerminateCarPlayMicroChipHub();
    ETG_TRACE_USR3(("TerminateCarPlayMicroChipMitsumiPort2ES2: used TerminateCarPlayMicroChipHub(...) res=%d (IAP2_OK:0x%x,IAP2_CTL_ERROR=0x%x)",res,IAP2_OK,IAP2_CTL_ERROR));

    return res;
}


tResult iPodControlIAP::TerminateCarPlayMicroChipMitsumiPort2ES4()
{
    ENTRY;
    tResult res = IAP2_CTL_ERROR;

    int iData = 0;
    tBool bOk = FALSE;
    uint16_t wLength;
    int ret = 0;
    tBool bClearErrorBit = FALSE;

    unsigned char dat[2];



    //switch hub
    libusb_device_handle* hndlToHub = libusb_open_device_with_vid_pid(NULL, MICROCHIP_VID, USB84604_PID);
    if(hndlToHub != NULL)
    {
        bOk = TRUE;
        //------------------------------------------------------------------------------
        ETG_TRACE_USR3(("1/15 TerminateCarPlayMicroChipMitsumiPort2ES4: libusb open done ok"))
        //-----------------------------------------------------------------------
    }
    else
    {
        bOk = FALSE;
        ETG_TRACE_USR1(("[ERROR]:TerminateCarPlayMicroChipMitsumiPort2ES4; HUB not found"));
    }

    ETG_TRACE_USR4(("TerminateCarPlayMicroChipMitsumiPort2ES4: carplay termination sequence, iPhone detached by user"));
    ETG_TRACE_USR4(("TerminateCarPlayMicroChipMitsumiPort2ES4: ref CarPlay_Sequence_Ver0.93_Mistumi_20161104 from 26-DEC-2016"));

    if(bOk)
    {
        ETG_TRACE_USR4(("2/15 TerminateCarPlayMicroChipMitsumiPort2ES4: Issue Register Write Setup command for GPIO1 output setting"));
        /* GPIO1 is set to Output */
        dat[0] = 0x02;
        wLength = 1;
        ret = send_libusb_control_transfer(hndlToHub,
          /* Host to device, vendor class, targeted to device */
          0x41,   // bmRequestType
          /* Register Write */
          0x03,   // bRequest
          /* GPIO 0-7 DIRECTION CONTROL REGISTER */
          0x0833, // wValue
          /* Reserved */
          0x0000, // wIndex
          dat,    // *data
          /* 1Byte Write */
          wLength,   // wLength
          500);   // timeout
        if (ret != wLength)
        {
          ETG_TRACE_USR4(("[ERROR]:TerminateCarPlayMicroChipMitsumiPort2ES4:  Could not set GPIO1 to output (%d)", ret));
          bOk = FALSE;
        }
    }

    if(bOk)
    {
        ETG_TRACE_USR4(("3/15 TerminateCarPlayMicroChipMitsumiPort2ES4: Issue USB to GPIO bridge command (PIO1) for enabling I2C bridging. PIO1 should be changed to HIGH for I2C communication starting of HUB."));
        /* GPIO1 is set to High level */
        dat[0]  = 0x02;
        wLength = 1;
        ret = send_libusb_control_transfer(hndlToHub,
        /* Host to device, vendor class, targeted to device */
        0x41,   // bmRequestType
        /* Register Write */
        0x03,   // bRequest
        /* GPIO 0-7 OUTPUT REGISTER */
        0x0837, // wValue
        /* Reserved */
        0x0000, // wIndex
        dat,    // *data
        /* 1Byte Write */
        wLength,   // wLength
        500);   // timeout
        if (ret != wLength)
        {
            ETG_TRACE_USR4(("[ERROR]:TerminateCarPlayMicroChipMitsumiPort2ES4:  Could not set GPIO1 to high (%d)", ret));
            bOk = FALSE;
        }
    }


    if(bOk)
    {
        ETG_TRACE_USR4(("4/15 TerminateCarPlayMicroChipMitsumiPort2ES4: adding 5ms delay as requested in email from 31-MAR-2017"));
        /* wait 5ms to wait for UCS2112 to stabilize */
        usleep(5000);
        ETG_TRACE_USR4(("5/15TerminateCarPlayMicroChipMitsumiPort2ES4: Issue Enable I2C pass-through interface command"));
        wLength = 0;
        ret = send_libusb_control_transfer(hndlToHub,
        /* Host to device, vendor class, targeted to device */
        0x41,   // bmRequestType
        /* CMD_I2C_ENTER_PASSTHRU */
        0x70,   // bRequest
        0x0000, // wValue
        0x0000, // wIndex
        NULL,   // *data
        wLength,   // wLength
        500);   // timeout
        if (ret != wLength)
        {
            ETG_TRACE_USR4(("[Error]: TerminateCarPlayMicroChipMitsumiPort2ES4: Could not set I2C to pass-through (%d)", ret));
            bOk = FALSE;
        }
    }

    if(bOk)
    {
        int iRetrialCount = 0;
        int iMaxRetrials  = 5;
        while(iRetrialCount < iMaxRetrials)
        {
          ETG_TRACE_USR4(("6/15 TerminateCarPlayMicroChipMitsumiPort2ES4: Issue USB to I2C bridge command for UCS Status check phese1 (Port1)"));
          /* Interrupt Status register */
          dat[0] = 0x03;
          wLength = 1;
          ret = send_libusb_control_transfer(hndlToHub,
            /* Host to device, vendor class, targeted to device */
            0x41,   // bmRequestType
            /* CMD_I2C_WRITE */
            0x71,   // bRequest
            /* I2C Control flag 0x07, I2C address 0x57(1010_111b) + (r/w) b */
            0x07AE, // wValue
            0x0000, // wIndex
            /* 1 Byte of Data */
            dat,    // *data
            wLength,   // wLength
            500);   // timeout
          if (ret != wLength)
          {
            iRetrialCount++;
            ETG_TRACE_USR4(("[ERROR]: TerminateCarPlayMicroChipMitsumiPort2ES4: Port1: Could not send I2C bridge command (%d)  (Retrial:iRetrialCount:%d/%d)", ret,iRetrialCount,iMaxRetrials));
            usleep(5000);
          }
          else
          {
              ETG_TRACE_USR4(("TerminateCarPlayMicroChipMitsumiPort2ES4: Port1: I2C bridge command send ok"));
              break;
          }
        }

        if (ret != wLength)
        {
             bOk = FALSE;
        }
    }


    if(bOk)
    {
        dat[0] = 0x00; //this time not command will be filled by below call
        wLength = 1;
        ETG_TRACE_USR4(("7/15 TerminateCarPlayMicroChipMitsumiPort2ES4: Issue USB to I2C bridge command for UCS Status check phase2 (Port1)"));
        ret = send_libusb_control_transfer(hndlToHub,
        /* Device to Host, vendor class, targeted to host */
        0xC1,   // bmRequestType
        /* CMD_I2C_READ */
        0x72,   // bRequest
        /* I2C Control flag 0x07, I2C address 0x57(1010_111b) + (r/w) b */
        0x07AF, // wValue
        0x0000, // wIndex
        /* 1 Byte of Data */
        dat,    // *data
        wLength,   // wLength
        500);   // timeout
        if (ret != wLength)
        {
            ETG_TRACE_USR4(("[ERROR]: TerminateCarPlayMicroChipMitsumiPort2ES4: Port1: check phase2 (%d)", ret));
            bOk = FALSE;
        }
        ETG_TRACE_USR4(("Status = 0x%02X", (unsigned char) dat[0]));
        if ((dat[0] & 0x80) == 0x80)
        {
            ETG_TRACE_USR4(("[ERROR - UNEXPECTED]TerminateCarPlayMicroChipMitsumiPort2ES4: FIXME: Need to clear status?!"));
            bOk = FALSE;
        }

    }



    if(bOk)
    {
        ETG_TRACE_USR4(("8/15 TerminateCarPlayMicroChipMitsumiPort2ES4: Issue USB to I2C bridge command for UCS Status check phese1 (Port2)"));
        /* Interrupt Status register */
        dat[0] = 0x04;
        wLength = 1;
        ret = send_libusb_control_transfer(hndlToHub,
        /* Host to device, vendor class, targeted to device */
        0x41,   // bmRequestType
        /* CMD_I2C_WRITE */
        0x71,   // bRequest
        /* I2C Control flag 0x07, I2C address 0x57(1010_111b) + (r/w) b */
        0x07AE, // wValue
        0x0000, // wIndex
        dat,    // *data
        wLength,   // wLength
        500);   // timeout
        if (ret != wLength)
        {
            ETG_TRACE_USR4(("[ERROR]: Port2: check phase1 (%d)", ret));
            bOk = FALSE;
        }
    }


    if(bOk)
    {
        ETG_TRACE_USR4(("9/15 TerminateCarPlayMicroChipMitsumiPort2ES4: Issue USB to I2C bridge command for UCS Status check phese2 (Port2)"));
        dat[0] = 0x00; //not input but will be filled by call of below function
        wLength = 1;
        ret = send_libusb_control_transfer(hndlToHub,
        /* Device to host, vendor class, targeted to host */
        0xC1,   // bmRequestType
        /* CMD_I2C_READ */
        0x72,   // bRequest
        /* I2C Control flag 0x07, I2C address 0x57(1010_111b) + (r/w) b */
        0x07AF, // wValue
        0x0000, // wIndex
        dat,    // *data
        wLength,   // wLength
        500);   // timeout
        if (ret != wLength)
        {
            ETG_TRACE_USR4(("[ERROR]: TerminateCarPlayMicroChipMitsumiPort2ES4: Port2: check phese2 (%d)", ret));
            bOk = FALSE;
        }

        ETG_TRACE_USR4(("TerminateCarPlayMicroChipMitsumiPort2ES4: Status = 0x%02X", (unsigned char) dat[0]));
        if ((dat[0] & 0x80) == 0x80)
        {
            ETG_TRACE_USR4(("[ERROR- UNEXPECTED] TerminateCarPlayMicroChipMitsumiPort2ES4: FIXME: Need to clear status?!"));
            bOk = FALSE;
        }
    }

    if(bOk)
    {
        /* modify1 */
        ETG_TRACE_USR4(("10/15 TerminateCarPlayMicroChipMitsumiPort2ES4: Issue USB to I2C bridge command for UCS charger setting (Port 1, 2: disable Pin_IGN,))"));
        /* PIN_IGN:0 , ATT_DIS:1, and DIS_TO:1 */
        dat[0] = 0x13;
        dat[1] = 0x70;
        wLength = 2;
        ret = send_libusb_control_transfer(hndlToHub,
        /* Host to device, vendor class, targeted to device */
        0x41,   // bmRequestType
        /* CMD_I2C_WRITE */
        0x71,   // bRequest
        /* I2C Control flag 0x07, I2C address 0x57(1010_111b) + (r/w) b */
        0x07AE, // wValue
        0x0000, // wIndex
        /* 2 Byte of Data (Register Address + 1 Byte of Data) */
        dat,    // *data
        wLength,   // wLength
        500);   // timeout
        if (ret != wLength)
        {
            ETG_TRACE_USR4(("[ERROR]: TerminateCarPlayMicroChipMitsumiPort2ES4: (Port 1, 2: disable Pin_IGN (%d)", ret));
            bOk = FALSE;
        }
    }

    if(bOk)
    {
        /* modify2 */
        ETG_TRACE_USR4(("11/15 TerminateCarPlayMicroChipMitsumiPort2ES4: Issue USB to I2C bridge command for UCS charger setting (Port 1: Power disable)"));
        /* ALERT_MASK:0,ALERT1_LINK:0,DSCHG1:0,PWR_EN1S:0,DISCHG_TIME:11,ATT1_TH1:11 */
        dat[0] = 0x11;
        dat[1] = 0x0F;
        wLength = 2;
        ret = send_libusb_control_transfer(hndlToHub,
        /* Host to device, vendor class, targeted to device */
        0x41,   // bmRequestType
        /* CMD_I2C_WRITE */
        0x71,   // bRequest
        /* I2C Control flag 0x07, I2C address 0x57(1010_111b) + (r/w) b */
        0x07AE, // wValue
        0x0000, // wIndex
        /* 2 Byte of Data (Register Address + 1 Byte of Data) */
        dat,    // *data
        wLength,   // wLength
        500);   // timeout
        if (ret != wLength)
        {
            ETG_TRACE_USR4(("[ERROR]: TerminateCarPlayMicroChipMitsumiPort2ES4: Port 1: Power disable (%d)", ret));
            bOk = FALSE;
        }
    }

    if(bOk)
    {
        /* modify3 */
        ETG_TRACE_USR4(("12/15 TerminateCarPlayMicroChipMitsumiPort2ES4: Issue USB to I2C bridge command for UCS charger setting (Port 2: Power disable)"));
        /* ALERT_MASK:0,ALERT2_LINK:0,DSCHG2:0,PWR_EN2S:0,ATT1_TH1:11 */
        dat[0] = 0x12;
        dat[1] = 0x03;
        wLength = 2;
        ret = send_libusb_control_transfer(hndlToHub,
        /* Host to device, vendor class, targeted to device */
        0x41,   // bmRequestType
        /* CMD_I2C_WRITE */
        0x71,   // bRequest
        /* I2C Control flag 0x07, I2C address 0x57(1010_111b) + (r/w) b */
        0x07AE, // wValue
        0x0000, // wIndex
        /* 2 Byte of Data (Register Address + 1 Byte of Data) */
        dat,    // *data
        wLength,   // wLength
        500);   // timeout
        if (ret != wLength)
        {
            ETG_TRACE_USR4(("[ERROR]: TerminateCarPlayMicroChipMitsumiPort2ES4: Port 2: Power disable (%d)", ret));
            bOk = FALSE;
        }
    }

    if(bOk)
    {
        ETG_TRACE_USR4(("13/15 TerminateCarPlayMicroChipMitsumiPort2ES4: Issue USB to GPIO bridge command (Set GPIO1 is low) for VBUS off (Port 1: Power disable)"));
        /* GPIO1 is set Low level */
        dat[0] = 0x00;
        wLength = 1;
        ret = send_libusb_control_transfer(hndlToHub,
        /* Host to device, vendor class, targeted to device */
        0x41,   // bmRequestType
        /* Register Write */
        0x03,   // bRequest
        /* GPIO 0-7 OUTPUT REGISTER */
        0x0837, // wValue
        /* Reserved */
        0x0000, // wIndex
        dat,    // *data
        /* 1Byte Write */
        wLength,   // wLength
        500);   // timeout
        if (ret != wLength)
        {
            ETG_TRACE_USR4(("[ERROR]: TerminateCarPlayMicroChipMitsumiPort2ES4: Could not set GPIO1 to low (%d)", ret));
            bOk = FALSE;
        }
        else
        {
            /*====SUCCESS========*/
            res = IAP2_OK;
            /*==================*/
            ETG_TRACE_USR1(("14/15 [RESULT:OK]: TerminateCarPlayMicroChipMitsumiPort2ES4: OK"))
        }
    }

    //close handle if open
    if(hndlToHub != NULL)
    {
        ETG_TRACE_USR4(("15/15 TerminateCarPlayMicroChipMitsumiPort2ES4:libusb_close"));
        libusb_close(hndlToHub);
    }

    /*  Wait 1000msec (VBUS off time). For reenumeration usb device */
    sleep(1);

    ETG_TRACE_USR2(("TerminateCarPlayMicroChipMitsumiPort2ES4: bOk=0x%x,res:0x%x (IAP2_OK:0x%x,IAP2_CTL_ERROR=0x%x)",bOk,res,IAP2_OK,IAP2_CTL_ERROR));


    return res;
}


tResult iPodControlIAP::TerminateCarPlayMicroChipHub()
{
    ENTRY;
    tResult res = IAP2_CTL_ERROR;

    //switch hub
    libusb_device_handle* hndlToHub = libusb_open_device_with_vid_pid(NULL, MICROCHIP_VID, USB84604_PID);
    if(hndlToHub != NULL) {

        unsigned char dat[2];
        int ret = 0;

        /* set GPIO1 high for I2C SDA/SCL pull-up resistors */

        ETG_TRACE_USR3(("TerminateCarPlayMicroChipHub: Issue Register Write Setup command for GPIO1 output setting"));
        /* GPIO1 is set Output */
        dat[0] = 0x02;
        ret = libusb_control_transfer(hndlToHub,
          /* Host to device, vendor class, targeted to device */
          0x41,   // bmRequestType
          /* Register Write */
          0x03,   // bRequest
          /* GPIO 0-7 DIRECTION CONTROL REGISTER */
          0x0833, // wValue
          /* Reserved */
          0x0000, // wIndex
          dat,    // *data
          /* 1Byte Write */
          0x01,   // wLength
          500);   // timeout
        VARTRACE(ret);
        if (ret != 1) {
            ETG_TRACE_ERR(("[ERROR]: TerminateCarPlayMicroChipHub: Could not set GPIO1 to output"));
        } else {

            ETG_TRACE_USR3(("TerminateCarPlayMicroChipHubIssue USB to GPIO bridge command (PIO1) for enabling I2C bridging. PIO1 should be changed to HIGH for I2C communication starting of HUB."));
            /* GPIO1 is set High level */
            dat[0] = 0x02;
            ret = libusb_control_transfer(hndlToHub,
              /* Host to device, vendor class, targeted to device */
              0x41,   // bmRequestType
              /* Register Write */
              0x03,   // bRequest
              /* GPIO 0-7 OUTPUT REGISTER */
              0x0837, // wValue
              /* Reserved */
              0x0000, // wIndex
              dat,    // *data
              /* 1Byte Write */
              0x01,   // wLength
              500);   // timeout
            VARTRACE(ret);
            if (ret != 1) {
                ETG_TRACE_ERR(("[ERROR]: TerminateCarPlayMicroChipHubCould not set GPIO1 to high"));
            } else {

                ETG_TRACE_USR3(("TerminateCarPlayMicroChipHubIssue Enable I2C pass-through interface command"));
                ret = libusb_control_transfer(hndlToHub,
                  /* Host to device, vendor class, targeted to device */
                  0x41,   // bmRequestType
                  /* CMD_I2C_ENTER_PASSTHRU */
                  0x70,   // bRequest
                  0x0000, // wValue
                  0x0000, // wIndex
                  NULL,   // *data
                  0x00,   // wLength
                  500);   // timeout
                VARTRACE(ret);

                if (ret != 0) {
                    ETG_TRACE_ERR(("[ERROR]: TerminateCarPlayMicroChipHubCould not set I2C to pass-through"));
                } else {

                    int retry = 0;
                    int done = 0;
                    while (retry++ < 3 && done == 0) {
                        ETG_TRACE_USR3(("TerminateCarPlayMicroChipHubIssue USB to I2C bridge command for UCS Status check phase1 (Port1)"));
                        dat[0] = 0x10;
                        ret = libusb_control_transfer(hndlToHub,
                          /* Host to device, vendor class, targeted to device */
                          0x41,   // bmRequestType
                          /* CMD_I2C_WRITE */
                          0x71,   // bRequest
                          /* I2C Control flag 0x07, I2C address 0x66(0110_0110b). For port1 control */
                          0x0766, // wValue
                          0x0000, // wIndex
                          /* 2 Byte of Data (Register Address + 1 Byte of Data) */
                          dat,    // *data
                          0x01,   // wLength
                          500);   // timeout
                        VARTRACE(ret);
                        if (ret == 1) {
                            done = 1;
                        } else {
                            ETG_TRACE_ERR(("[Warning]: TerminateCarPlayMicroChipHub: Port1: Could not send I2C bridge command, retry (%d)", retry));
                        }
                    }
                    if (retry > 4) {
                      ETG_TRACE_ERR(("Error: Port1: Could not send I2C bridge command"));
                    } else {

                        retry = 0;
                        done = 0;
                        while (retry++ < 3 && done == 0) {
                            ETG_TRACE_USR3(("TerminateCarPlayMicroChipHub: Issue USB to I2C bridge command for UCS Status check phase2 (Port1)"));
                            /* Setting current limit 1680mA */
                            dat[0] = 0x00;
                            ret = libusb_control_transfer(hndlToHub,
                              /* Host to device, vendor class, targeted to device */
                              0xC1,   // bmRequestType
                              /* CMD_I2C_WRITE */
                              0x72,   // bRequest
                              /* I2C Control flag 0x07, I2C address 0x64(0110_0100b). For port2 control */
                              0x0767, // wValue
                              0x0000, // wIndex
                              /* 2 Byte of Data (Register Address + 1 Byte of Data) */
                              dat,    // *data
                              0x01,   // wLength
                              500);   // timeout
                            VARTRACE(ret);
                            if (ret == 1) {
                                done = 1;
                            } else {
                                ETG_TRACE_ERR(("[Warning]:TerminateCarPlayMicroChipHub Port1: Could not send I2C bridge command, retry (%d)", retry));
                            }
                        }
                        if (retry > 4) {
                          ETG_TRACE_ERR(("Error: Port1: Could not send I2C bridge command"));
                        } else {

                            retry = 0;
                            done = 0;
                            while (retry++ < 3 && done == 0) {
                                ETG_TRACE_USR3(("Issue USB to I2C bridge command for UCS Status check phase1 (Port2)"));
                                /* Set Latch bit "1" (bit0) */
                                dat[0] = 0x10;
                                ret = libusb_control_transfer(hndlToHub,
                                  /* Host to device, vendor class, targeted to device */
                                  0x41,   // bmRequestType
                                  /* CMD_I2C_WRITE */
                                  0x71,   // bRequest
                                  /* I2C Control flag 0x07, I2C address 0x66(0110_0110b). For port1 control */
                                  0x0764, // wValue
                                  0x0000, // wIndex
                                  /* 2 Byte of Data (Register Address + 1 Byte of Data) */
                                  dat,    // *data
                                  0x01,   // wLength
                                  500);   // timeout
                                VARTRACE(ret);
                                if (ret == 1) {
                                    done = 1;
                                } else {
                                    ETG_TRACE_ERR(("[Warning]:TerminateCarPlayMicroChipHub Port1: Could not send I2C bridge command, retry (%d)", retry));
                                }
                            }
                            if (retry > 4) {
                              ETG_TRACE_ERR(("[ERROR]:TerminateCarPlayMicroChipHub: Port1: Could not send I2C bridge command"));
                            } else {

                                retry = 0;
                                done = 0;
                                while (retry++ < 3 && done == 0) {
                                    ETG_TRACE_USR3(("TerminateCarPlayMicroChipHub: Issue USB to I2C bridge command for UCS Status check phase2 (Port2)"));
                                    dat[0] = 0x00;
                                    ret = libusb_control_transfer(hndlToHub,
                                      /* Host to device, vendor class, targeted to device */
                                      0xC1,   // bmRequestType
                                      /* CMD_I2C_WRITE */
                                      0x72,   // bRequest
                                      /* I2C Control flag 0x07, I2C address 0x64(0110_0100b). For port2 control */
                                      0x0765, // wValue
                                      0x0000, // wIndex
                                      /* 2 Byte of Data (Register Address + 1 Byte of Data) */
                                      dat,    // *data
                                      0x01,   // wLength
                                      500);   // timeout
                                    VARTRACE(ret);
                                    if (ret == 1) {
                                        done = 1;
                                    } else {
                                        ETG_TRACE_ERR(("[Warning]:TerminateCarPlayMicroChipHub Port1: Could not send I2C bridge command, retry (%d)", retry));
                                    }
                                }
                                if (retry > 4) {
                                  ETG_TRACE_ERR(("[ERROR]:TerminateCarPlayMicroChipHub Port1: Could not send I2C bridge command"));
                                } else {

                                    retry = 0;
                                    done = 0;
                                    while (retry++ < 3 && done == 0) {
                                        ETG_TRACE_USR3(("TerminateCarPlayMicroChipHubIssue USB to I2C bridge command for UCS charger setting (Port1: setting Pin_IGN, Power disable, CDP)"));
                                        /* PIN_IGN set "1" , PWR_EN set "0", and Set CDP mode */
                                        dat[0] = 0x17;
                                        dat[1] = 0xBD;
                                        ret = libusb_control_transfer(hndlToHub,
                                          /* Host to device, vendor class, targeted to device */
                                          0x41,   // bmRequestType
                                          /* CMD_I2C_WRITE */
                                          0x71,   // bRequest
                                          /* I2C Control flag 0x07, I2C address 0x64(0110_0100b). For port2 control */
                                          0x0766, // wValue
                                          0x0000, // wIndex
                                          /* 2 Byte of Data (Register Address + 1 Byte of Data) */
                                          dat,    // *data
                                          0x02,   // wLength
                                          500);   // timeout
                                        VARTRACE(ret);
                                        if (ret == 2) {
                                            done = 1;
                                        } else {
                                            ETG_TRACE_ERR(("[Warning]:TerminateCarPlayMicroChipHub Port1: Could not send I2C bridge command, retry (%d)", retry));
                                        }
                                    }
                                    if (retry > 4) {
                                      ETG_TRACE_ERR(("[ERROR]:TerminateCarPlayMicroChipHub: Port1: Could not send I2C bridge command"));
                                    } else {

                                        retry = 0;
                                        done = 0;
                                        while (retry++ < 3 && done == 0) {
                                            ETG_TRACE_USR3(("Issue USB to I2C bridge command for UCS charger setting (Port2: setting Pin_IGN, Power disable, CDP)"));
                                            /* PIN_IGN set "1" , PWR_EN set "0", and Set CDP mode */
                                            dat[0] = 0x17;
                                            dat[1] = 0xBD;
                                            ret = libusb_control_transfer(hndlToHub,
                                              /* Host to device, vendor class, targeted to device */
                                              0x41,   // bmRequestType
                                              /* CMD_I2C_WRITE */
                                              0x71,   // bRequest
                                              /* I2C Control flag 0x07, I2C address 0x64(0110_0100b). For port2 control */
                                              0x0764, // wValue
                                              0x0000, // wIndex
                                              /* 2 Byte of Data (Register Address + 1 Byte of Data) */
                                              dat,    // *data
                                              0x02,   // wLength
                                              500);   // timeout
                                            VARTRACE(ret);
                                            if (ret == 2) {
                                                done = 1;
                                            } else {
                                                ETG_TRACE_ERR(("[Warning]:TerminateCarPlayMicroChipHub Port1: Could not send I2C bridge command, retry (%d)", retry));
                                            }
                                        }
                                        if (retry > 4) {
                                          ETG_TRACE_ERR(("[ERROR]:TerminateCarPlayMicroChipHub Port1: Could not send I2C bridge command"));
                                        } else {

                                            ETG_TRACE_USR3(("TerminateCarPlayMicroChipHubIssue USB to I2C bridge command for UCS charger setting (Port1: setting Pin_IGN, Power enable, CDP)"));
                                            /* PIN_IGN set "1" , PWR_EN set "1", and Set CDP mode */
                                            dat[0] = 0x17;
                                            dat[1] = 0xBF;
                                            ret = libusb_control_transfer(hndlToHub,
                                              /* Host to device, vendor class, targeted to device */
                                              0x41,   // bmRequestType
                                              /* CMD_I2C_WRITE */
                                              0x71,   // bRequest
                                              /* I2C Control flag 0x07, I2C address 0x64(0110_0100b). For port2 control */
                                              0x0766, // wValue
                                              0x0000, // wIndex
                                              /* 2 Byte of Data (Register Address + 1 Byte of Data) */
                                              dat,    // *data
                                              0x02,   // wLength
                                              500);   // timeout
                                            VARTRACE(ret);
                                            if (ret != 2) {
                                                ETG_TRACE_ERR(("[ERROR]:TerminateCarPlayMicroChipHub Could not send I2C bridge command"));
                                            } else {

                                                ETG_TRACE_USR3(("TerminateCarPlayMicroChipHubIssue USB to I2C bridge command for UCS charger setting (Port2: setting Pin_IGN, Power enable, CDP)"));
                                                /* PIN_IGN set "1" , PWR_EN set "1", and Set CDP mode */
                                                dat[0] = 0x17;
                                                dat[1] = 0xBF;
                                                ret = libusb_control_transfer(hndlToHub,
                                                  /* Host to device, vendor class, targeted to device */
                                                  0x41,   // bmRequestType
                                                  /* CMD_I2C_WRITE */
                                                  0x71,   // bRequest
                                                  /* I2C Control flag 0x07, I2C address 0x64(0110_0100b). For port2 control */
                                                  0x0764, // wValue
                                                  0x0000, // wIndex
                                                  /* 2 Byte of Data (Register Address + 1 Byte of Data) */
                                                  dat,    // *data
                                                  0x02,   // wLength
                                                  500);   // timeout
                                                VARTRACE(ret);
                                                if (ret != 2) {
                                                    ETG_TRACE_ERR(("[ERROR]:TerminateCarPlayMicroChipHub Could not send I2C bridge command"));
                                                } else {
                                                    /*====SUCCESS========*/
                                                    res = IAP2_OK;
                                                    /*==================*/
                                                    ETG_TRACE_USR1(("[RESULT:OK]: TerminateCarPlayMicroChipHub: OK"))
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        libusb_close(hndlToHub);
    } else {
        ETG_TRACE_USR1(("TerminateCarPlayMicroChipHub NUB not found"));
    }
    return res;
}


void iPodControlIAP::UpdateIpodCommunicationError(tResult res)
{
    ENTRY;
    if(LocalSPM::GetDataProvider().iPodCommunicationError()) {
        VARTRACE(res);
        tIpodCommError iPodCommError = IPOD_NO_ERROR;
        const tDeviceID deviceID = iAPGetDeviceID(m_MountPoint);
        VARTRACE(deviceID);
        if(res != IPOD_BAD_PARAMETER && res != IAP2_BAD_PARAMETER) {
            iPodCommError = IPOD_COMM_ERROR;
            LocalSPM::GetOutputWrapper().UpdateIpodCommunicationError(deviceID, iPodCommError);
        }
    }
}
void iPodControlIAP::iAPSetDiPOLocationInfo(const tMountPoint mountPoint, const tBool startStopLocationInfo, const tDiPOLocationInfoType locationInfoType) {
    ENTRY_INTERNAL;
    m_HandleMap.SetDiPOLocationInfo(mountPoint, startStopLocationInfo,locationInfoType);
}
void iPodControlIAP::iAPGetDiPOLocationInfo(const tMountPoint mountPoint,tBool &startStopLocationInfo, tDiPOLocationInfoType &locationInfoType) {
    ENTRY_INTERNAL;
    m_HandleMap.GetDiPOLocationInfo(mountPoint, startStopLocationInfo,locationInfoType);
}

void iPodControlIAP::iAPSetDiPOGPRMCDataStatusValues(const tMountPoint mountPoint,const tDiPOGPRMCDataStatusValues GPRMCDataStatusValues) {
    ENTRY_INTERNAL;
    m_HandleMap.SetDiPOGPRMCDataStatusValues(mountPoint, GPRMCDataStatusValues);
}
void iPodControlIAP::iAPGetDiPOGPRMCDataStatusValues(const tMountPoint mountPoint,tDiPOGPRMCDataStatusValues &GPRMCDataStatusValues) {
    ENTRY_INTERNAL;
    m_HandleMap.GetDiPOGPRMCDataStatusValues(mountPoint, GPRMCDataStatusValues);
}

tDiPOPower iPodControlIAP::iAP2GetPowerUpdate(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetPowerUpdate(mountPoint);
}

void iPodControlIAP::iAP2SetPowerUpdate(const tMountPoint mountPoint, const tDiPOPower power) {
    ENTRY_INTERNAL;
    m_HandleMap.SetPowerUpdate(mountPoint, power);
}
tDiPORouteGuidanceUpdate iPodControlIAP::iAP2GetRGUpdate(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetRGUpdate(mountPoint);
}

tDiPORouteGuidanceUpdate iPodControlIAP::iAP2PullRGUpdate(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.PullRGUpdate(mountPoint);
}

void iPodControlIAP::iAP2PushRGUpdate(const tMountPoint mountPoint, const tDiPORouteGuidanceUpdate RGUpdate) {
    ENTRY_INTERNAL;
    m_HandleMap.PushRGUpdate(mountPoint, RGUpdate);
}

void iPodControlIAP::iAP2SetRGUpdate(const tMountPoint mountPoint, const tDiPORouteGuidanceUpdate RGUpdate) {
    ENTRY_INTERNAL;
    m_HandleMap.SetRGUpdate(mountPoint, RGUpdate);
}

tDiPORouteGuidanceManeuverUpdate iPodControlIAP::iAP2GetRGManeuverUpdate(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.GetRGManeuverUpdate(mountPoint);
}

tDiPORouteGuidanceManeuverUpdate iPodControlIAP::iAP2PullRGManeuverUpdate(const tMountPoint mountPoint) {
    ENTRY_INTERNAL;
    return m_HandleMap.PullRGManeuverUpdate(mountPoint);
}

void iPodControlIAP::iAP2PushRGManeuverUpdate(const tMountPoint mountPoint, const tDiPORouteGuidanceManeuverUpdate RGManeuverUpdate) {
    ENTRY_INTERNAL;
    m_HandleMap.PushRGManeuverUpdate(mountPoint, RGManeuverUpdate);
}

void iPodControlIAP::iAP2SetRGManeuverUpdate(const tMountPoint mountPoint, const tDiPORouteGuidanceManeuverUpdate RGManeuverUpdate) {
    ENTRY_INTERNAL;
    m_HandleMap.SetRGManeuverUpdate(mountPoint, RGManeuverUpdate);
}

tDiPODeviceTime iPodControlIAP::iAP2GetDeviceTimeUpdate(const tMountPoint mountPoint)
{
    ENTRY_INTERNAL;
    return m_HandleMap.GetDeviceTimeUpdate(mountPoint);
}

void iPodControlIAP::iAP2SetDeviceTimeUpdate(const tMountPoint mountPoint, const tDiPODeviceTime deviceTime)
{
    ENTRY_INTERNAL;
    m_HandleMap.SetDeviceTimeUpdate(mountPoint, deviceTime);
}

int iPodControlIAP::send_libusb_control_transfer(libusb_device_handle *dev_handle,uint8_t request_type, uint8_t bRequest, uint16_t wValue, uint16_t wIndex, unsigned char *data, uint16_t wLength, unsigned int timeout, uint8_t numOfRetrials)
{
    int     iRet  = 0;
    uint8_t retry = 0;
    int     done  = 0;

    while ((retry <= numOfRetrials) && (done == 0))
    {
        iRet = libusb_control_transfer(dev_handle,request_type, bRequest, wValue, wIndex, data, wLength, timeout );
        if (iRet == wLength)
        {
            done = 1;
        }
        else
        {
            ETG_TRACE_ERR(("[Warning]: do retry (%d)", retry));
        }
        retry++;

    }
    return iRet;
}

tResult iPodControlIAP::iAP2_IdentificationInformationUpdate()
{
    ENTRY;
    tResult ret = MP_NO_ERROR;
    size_t size = 0;
    iAP2IdentificationInformationUpdateParameter iAP2IdentificationInformationUpdateParameter;
    memset(&iAP2IdentificationInformationUpdateParameter, 0, sizeof(iAP2IdentificationInformationUpdateParameter));

    size = strnlen(LocalSPM::GetDataProvider().iPodControlAccessoryInfoBTName().c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
    iAP2IdentificationInformationUpdateParameter.iAP2AccessoryName = new U8*[sizeof(U8*)];
    if(!iAP2IdentificationInformationUpdateParameter.iAP2AccessoryName)  return NULL; //lint !e429 deleted by IAP2_Disconnect
    iAP2IdentificationInformationUpdateParameter.iAP2AccessoryName[0] = new U8[size];
    if(iAP2IdentificationInformationUpdateParameter.iAP2AccessoryName[0] != NULL){
        strncpy_r((char *)iAP2IdentificationInformationUpdateParameter.iAP2AccessoryName[0], LocalSPM::GetDataProvider().iPodControlAccessoryInfoBTName().c_str(), size);
    }
    iAP2IdentificationInformationUpdateParameter.iAP2AccessoryName_count++;

    size = strnlen(LocalSPM::GetDataProvider().iPodControlAccessoryInfoModelName().c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
    iAP2IdentificationInformationUpdateParameter.iAP2AccessoryModelIdentifier = new U8*[sizeof(U8*)];
    if(!iAP2IdentificationInformationUpdateParameter.iAP2AccessoryModelIdentifier)   return NULL; //lint !e429 deleted by IAP2_Disconnect
    iAP2IdentificationInformationUpdateParameter.iAP2AccessoryModelIdentifier[0] = new U8[size];
    if(iAP2IdentificationInformationUpdateParameter.iAP2AccessoryModelIdentifier){
        strncpy_r((char *)iAP2IdentificationInformationUpdateParameter.iAP2AccessoryModelIdentifier[0], LocalSPM::GetDataProvider().iPodControlAccessoryInfoModelName().c_str(), size);
    }
    iAP2IdentificationInformationUpdateParameter.iAP2AccessoryModelIdentifier_count++;

    size = strnlen(LocalSPM::GetDataProvider().iPodControlAccessoryInfoManufacturer().c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
    iAP2IdentificationInformationUpdateParameter.iAP2AccessoryManufacturer = new U8*[sizeof(U8*)];
    if(!iAP2IdentificationInformationUpdateParameter.iAP2AccessoryManufacturer)  return NULL; //lint !e429 deleted by IAP2_Disconnect
    iAP2IdentificationInformationUpdateParameter.iAP2AccessoryManufacturer[0] = new U8[size];
    if(iAP2IdentificationInformationUpdateParameter.iAP2AccessoryManufacturer[0]){
        strncpy_r((char *)iAP2IdentificationInformationUpdateParameter.iAP2AccessoryManufacturer[0], LocalSPM::GetDataProvider().iPodControlAccessoryInfoManufacturer().c_str(), size);
    }
    iAP2IdentificationInformationUpdateParameter.iAP2AccessoryManufacturer_count++;

    size = strnlen(LocalSPM::GetDataProvider().iPodControlAccessoryInfoSerialNumber().c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
    iAP2IdentificationInformationUpdateParameter.iAP2AccessorySerialNumber = new U8*[sizeof(U8*)];
    if(!iAP2IdentificationInformationUpdateParameter.iAP2AccessorySerialNumber)  return NULL; //lint !e429 deleted by IAP2_Disconnect
    iAP2IdentificationInformationUpdateParameter.iAP2AccessorySerialNumber[0] = new U8[size];
    if(iAP2IdentificationInformationUpdateParameter.iAP2AccessorySerialNumber[0] != NULL){
        strncpy_r((char *)iAP2IdentificationInformationUpdateParameter.iAP2AccessorySerialNumber[0], LocalSPM::GetDataProvider().iPodControlAccessoryInfoSerialNumber().c_str(), size);
    }
    iAP2IdentificationInformationUpdateParameter.iAP2AccessorySerialNumber_count++;

    size = strnlen(LocalSPM::GetDataProvider().iPodControlAccessoryInfoFWVersion().c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
    iAP2IdentificationInformationUpdateParameter.iAP2AccessoryFirmwareVersion = new U8*[sizeof(U8*)];
    if(!iAP2IdentificationInformationUpdateParameter.iAP2AccessoryFirmwareVersion)   return NULL; //lint !e429 deleted by IAP2_Disconnect
    iAP2IdentificationInformationUpdateParameter.iAP2AccessoryFirmwareVersion[0] = new U8[size];
    if(iAP2IdentificationInformationUpdateParameter.iAP2AccessoryFirmwareVersion[0] != NULL){
        strncpy_r((char *)iAP2IdentificationInformationUpdateParameter.iAP2AccessoryFirmwareVersion[0], LocalSPM::GetDataProvider().iPodControlAccessoryInfoFWVersion().c_str(), size);
    }
    iAP2IdentificationInformationUpdateParameter.iAP2AccessoryFirmwareVersion_count++;

    size = strnlen(LocalSPM::GetDataProvider().iPodControlAccessoryInfoHWVersion().c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
    iAP2IdentificationInformationUpdateParameter.iAP2AccessoryHardwareVersion = new U8*[sizeof(U8*)];
    if(!iAP2IdentificationInformationUpdateParameter.iAP2AccessoryHardwareVersion)   return NULL; //lint !e429 deleted by IAP2_Disconnect
    iAP2IdentificationInformationUpdateParameter.iAP2AccessoryHardwareVersion[0] = new U8[size];
    if(iAP2IdentificationInformationUpdateParameter.iAP2AccessoryHardwareVersion[0] != NULL){
        strncpy_r((char *)iAP2IdentificationInformationUpdateParameter.iAP2AccessoryHardwareVersion[0], LocalSPM::GetDataProvider().iPodControlAccessoryInfoHWVersion().c_str(), size);
    }
    iAP2IdentificationInformationUpdateParameter.iAP2AccessoryHardwareVersion_count++;

    size = strnlen(LocalSPM::GetDataProvider().iPodControlAccessoryInfoCurrentLanguage().c_str(), IAP2_STRING_MAX) + IAP2_NULL_CHAR_LEN;
    iAP2IdentificationInformationUpdateParameter.iAP2CurrentLanguage = new U8*[sizeof(U8*)];
    if(!iAP2IdentificationInformationUpdateParameter.iAP2CurrentLanguage)   return NULL; //lint !e429 deleted by IAP2_Disconnect
    iAP2IdentificationInformationUpdateParameter.iAP2CurrentLanguage[0] = new U8[size];
    if(iAP2IdentificationInformationUpdateParameter.iAP2CurrentLanguage[0] != NULL){
        strncpy_r((char *)iAP2IdentificationInformationUpdateParameter.iAP2CurrentLanguage[0], LocalSPM::GetDataProvider().iPodControlAccessoryInfoCurrentLanguage().c_str(), size);
    }
    iAP2IdentificationInformationUpdateParameter.iAP2CurrentLanguage_count++;

    if (!SelectDevice(m_MountPoint)) {
        ret = MP_ERR_IPOD_NO_ACCESS;
    } else {
        if(IsIAP2(m_MountPoint)) {
            m_HandleMap.LockIAP2(m_MountPoint); //start critical section
            iAP2Device_t* iap2Device = (iAP2Device_t*) m_HandleMap.GetIAP2Device(m_MountPoint);
            if(!iap2Device) {
                ETG_TRACE_ERR(("!iap2Device"));
                ret = MP_ERR_IPOD_NO_ACCESS;
            } else {
                ret = iAP2IdentificationInformationUpdate(iap2Device, &iAP2IdentificationInformationUpdateParameter);
                ETG_TRACE_USR3(("iAP2IdentificationInformationUpdate returned %d", ret));
                if (IAP2_OK != ret) {
                    UpdateIpodCommunicationError(ret);
                }
            }
            m_HandleMap.UnlockIAP2(m_MountPoint);
        }
    }

    iAP2FreeiAP2IdentificationInformationUpdateParameter(&iAP2IdentificationInformationUpdateParameter);

    return ret;
}

tResult iPodControlIAP::iAP2_PlaybackHIDCommand(const tPlaybackHIDCommand playbackHIDCommand, const tBTButtonEvent keyEvent, const tMountPoint mountPoint)
{
    ENTRY;
    VARTRACE(mountPoint);
    IPOD_HID_REPORT playbackHIDReport = IPOD_HID_REPORT_PLAY;
    tPEPlaybackState playbackState = iAPGetCurrentPlaybackState(mountPoint);
    VARTRACE(playbackState);
    tResult ret = MP_NO_ERROR;

    switch(playbackHIDCommand)
    {
        case HID_PLAY:
            playbackHIDReport = IPOD_HID_REPORT_PLAY;
            playbackState = PE_PBS_PLAYINGSTATE;
            break;
        case HID_PAUSE:
            playbackHIDReport = IPOD_HID_REPORT_PAUSE;
            playbackState = PE_PBS_PAUSEDSTATE;
            break;
        case HID_SCAN_NEXT_TRACK:
            playbackHIDReport = IPOD_HID_REPORT_SCAN_NEXT_TRACK;
            break;
        case HID_SCAN_PREV_TRACK:
            playbackHIDReport = IPOD_HID_REPORT_SCAN_PREVIOUS_TRACK;
            break;
        case HID_RANDOM:
            playbackHIDReport = IPOD_HID_REPORT_SHUFFLE;
            m_HandleMap.ResetElapsedTime(m_MountPoint, pbNotifications);
            break;
        case HID_REPEAT:
            playbackHIDReport = IPOD_HID_REPORT_REPEAT;
            m_HandleMap.ResetElapsedTime(m_MountPoint, pbNotifications);
            break;
        default:
            break;
    }
    VARTRACE(playbackHIDReport);

    if (!SelectDevice(mountPoint))
    {
        ret = MP_ERR_IPOD_NO_ACCESS;
    }
    else if(IsIAP2(mountPoint))
    {
        if(BUTTON_PRESS == keyEvent)
        {
            if(!SendMediaPlaybackHIDReport(playbackHIDReport))
            {
                ETG_TRACE_ERR(("SendMediaPlaybackHIDReport failed"));
                ret = MP_ERR_IPOD_PLAY;
            }
        }
        else
        {
            if(!SendMediaPlaybackHIDReport(IPOD_HID_REPORT_BUTTON_RELEASED))
            {
                ETG_TRACE_ERR(("SendMediaPlaybackHIDReport failed"));
                ret = MP_ERR_IPOD_PLAY;
            }
        }
    }

    if (MP_NO_ERROR == ret)
    {
        //update playback state
        m_HandleMap.SetPEPlaybackState(mountPoint, playbackState);
    }
    return ret;
}
