#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_USB_CONTROL
#ifdef TARGET_BUILD
#include "trcGenProj/Header/USBControl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_USB_CONTROL
#endif
#endif

#include "LocalSPM.h"
#include "Dispatcher.h"
#include "FunctionTracer.h"
#include "MediaPlayer_ErrorCodes.h"
#include <sys/types.h>
#include <dirent.h>
#include <signal.h>
#include "FastUTF8.h"
#include "VarTrace.h"
#include "TimeTrace.h"
#include <fstream>

#ifdef VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
#ifndef _FC_MEDIAPLAYER_ROOTDAEMON_CLIENT_H_
#include "FC_MediaPlayer_rootdaemon_client.h"
#endif
#endif

#include "VideoTagInfo.h"
#define USE_VIDEO_METADATA_READ_PROCESS 1
#define DEFAULT_STACKSIZE 0x100000 //1MB
#define CDROM_METADATA_TIME_OUT 10
#define CDROM_METADATA_MAX_COUNT 5
#define USE_VIDEO_THUMBNAIL_TIMEOUT 10

/*TagLib header includes*/
#include <taglib/fileref.h>
#include <taglib/vorbisfile.h>  //ogg file
#include <taglib/mpegfile.h>    //mp3 file
#include <taglib/rifffile.h>    //riff file
#include <taglib/wavfile.h>     //wave file
#include <taglib/aifffile.h>    //aiff file
#include <taglib/asffile.h>     //asf file
#include <taglib/mp4file.h>     //mp4 file
#include <taglib/mp4tag.h>      //mp4tag
#include <taglib/id3v2tag.h>    //id3 tag
#include <taglib/id3v2frame.h>  //id3 frame
#include <taglib/attachedpictureframe.h>
#include <taglib/id3v2header.h>
#include <taginfo.h>
using namespace std;
using namespace TagInfo;

//Umount
#include <sys/mount.h>
#include <sys/syscall.h>
#include <errno.h>

#include "USBControl.h"
#include "RequestResponseSM.h"
#ifdef USE_FREEIMAGE
#include "FreeImage.h"
#endif
#include <sys/statvfs.h>
#include <regex.h>

class recursionEmergencyBreak
{
public:
    recursionEmergencyBreak(int *_depth)
{
        depth = _depth;
        (*depth)++;
}
    ~recursionEmergencyBreak()
    {
        (*depth)--;
        depth = NULL;
    }
    bool doBreak()
    {
        return ((*depth) > 500 ? 1 : 0);
    }

private:
    int *depth;
};

Lock fingerprintLock;
static bool stopFingerprint = false;
static int recursionEmergencyBreakDepth = 0;

#define RECURSION_EMERGENCY_BREAK() recursionEmergencyBreak rb(&recursionEmergencyBreakDepth);
#define IS_RECURSION_EMERGENCY_BREAK() (rb.doBreak())

#define FUNCTION_ID_CALCFINGERPRINT    1
#define FUNCTION_ID_ALBUMART           2
#define FUNCTION_ID_READMETADATA_FOR_PLAYBACK       3
#define FUNCTION_ID_READMETADATA_FOR_INDEXING       4

void USBControl::Create()
{
    ENTRY

    /* Create the state machine */
    USBControlSM::Create();

    CreateDone(0);
}

tResult USBControl::Init(tInitReason reason)
{
    ENTRY
    VARTRACE(reason);

    /* Init the state machine */
    USBControlSM::Init();
    SetAnswerTimeout(USB_CTRL_SM_ANSWER_TIMEOUT_MS); // Set answer timeout

    /* Register state machine with dispatcher */
    Dispatcher::GetInstance().Register(IN this);
    m_response = REASON_OK;
    return InitDone(0);
}

tResult USBControl::InitSM()
{
    ENTRY

    /* Initialize variables */
    m_ScanMethod = (tScanMethod)LocalSPM::GetDataProvider().ScanMethod();
    //m_ScanContext.clear();
    if( 0 < m_ScanContext.capacity() )
    {
        vector<tScanContext>().swap(m_ScanContext); //used instead of clear to guarantee a memory reallocation
    }
    InitMediaObject(INOUT m_ScanMediaObject);

    m_Mutex.lock();
    InitMediaObject(INOUT m_PlayMediaObject);
    m_FingerprintMountPoint[0] = '\0';
    m_Mutex.unlock();

    m_StartPosition = 0;
    m_AudioOutputDevice[0] = '\0';

    /* Fill codec restriction table from calibration */
    LocalSPM::GetDataProvider().FillCodecRestrictionTable();

    m_ScanMode = false;

    m_NumberOfSupportedFiles = 0;

    // to check whether /tmp/usb directory exists
    if (exists_directory(m_FingerprintStorePath.c_str()) == 0)
    {
        int res = 0;
        res = mkdir(m_FingerprintStorePath.c_str(),S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH);
        if(res != 0)
        {
            ETG_TRACE_ERR(("Cannot create /tmp/usb directory: %s",strerror(errno)));
        }
    }
    else
    {
        ETG_TRACE_ERR(("directory(/tmp/usb) already exists"));
    }
    ResetStopFingerprint();

    return MP_NO_ERROR;
}

tResult USBControl::Run()
{
    ENTRY

    /*Create and start threads */
    LocalSPM::GetThreadFactory().Do(IN this, 0, NULL); //USBControl inclusive state machine

    return RunDone(0);
}

void USBControl::Do(int functionID, void *ptr)
{
    ENTRY

    //set the threads name
    LocalSPM::GetThreadFactory().SetName(USBControlSM::GetSMNameFull());

    switch(functionID)
    {
        case 0:
        {
            while(USBControlSM::STATE_MACHINE_FINISHED != USBControlSM::StateMachine_Main()){}
            break;
        }
        case FUNCTION_ID_CALCFINGERPRINT:
        {
            LocalSPM::GetThreadFactoryLowprio().SetName("CalcFingerprint");
            SetThreadNiceProperty(syscall(SYS_gettid), LocalSPM::GetDataProvider().FingerprintThreadNiceValue());

            /* Do fingerprint calculation only one by one (not in parallel) */
            //m_FingerprintLock.lock();
            DoCalcFingerprintThread((const char *)ptr);
            //m_FingerprintLock.unlock();

            LocalSPM::GetUSBControl().ResetFingerprintMountPoint();
            break;
        }
        case FUNCTION_ID_ALBUMART:
        {
            LocalSPM::GetThreadFactory().SetName("FetchAlbumArt");

            DoGetAlbumArtThread((const char *)ptr);
            break;
        }
        case FUNCTION_ID_READMETADATA_FOR_PLAYBACK:
        {
            LocalSPM::GetThreadFactory().SetName("FetchMetaData");

            /* Do metadata reading for playback only one by one (not in parallel) */
            m_ReadMetadataForPlaybackLock.lock();
            DoReadMetadataForPlaybackThread((const char *)ptr);
            m_ReadMetadataForPlaybackLock.unlock();
            break;
        }
        case FUNCTION_ID_READMETADATA_FOR_INDEXING:
        {
            if(LocalSPM::GetDataProvider().ControlCPUThtreadLoad()){
                LocalSPM::GetThreadFactoryLowprio().SetName("Indexer");
                SetThreadNiceProperty(syscall(SYS_gettid), LocalSPM::GetDataProvider().IndexerThreadNiceValue());
            }
            else
            {
                LocalSPM::GetThreadFactory().SetName("Indexer");
            }

            DoReadMetadataForIndexing();
            break;
        }
        default:
        {
            ETG_TRACE_ERR(("USBControl::Do: No thread defined for functionID: %d", functionID));
            break;
        }
    }
}

tResult USBControl::Stop()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    SetStopFingerprint();

    /* Send STOP message to own SM */
    ret = SendForceEvent(STOP_SM, (char *)NULL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult USBControl::StopEventProcessed()
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    int retValue = 0;
    retValue = RemoveDirectory(m_FingerprintStorePath, true);
    if (0 != retValue)
    {
        ETG_TRACE_ERR(("Error in Deletion(/tmp/usb): %d",retValue));
    }

    if(!LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Unregister for further playback events */
        ret = LocalSPM::GetIPCProvider().UnregisterObserver(IN this);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::UnregisterObserver (ErrorCode:%s)", errorString(ret)));
        }
    }

    /* Store last mode of scan context for each device in DB */
    tUInt size = m_ScanContext.size();
    if(0 < size)
    {
        //Remark: Do it in opposite order because the vector can be erased by an element defined by index
        for(int i = size-1; i>=0; i--)
        {
#if 0 //Do not use stored scan context because feature ContinueIndexing is not working at all
            ret = LocalSPM::GetDBManager().RemoveScanContext(IN m_ScanContext[i].deviceID);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while removing scan context in DB for deviceID:%u (ErrorCode:%s)", m_ScanContext[i].deviceID, errorString(ret)));
            }

            ret = LocalSPM::GetDBManager().StoreScanContext(IN m_ScanContext[i]);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while storing scan context in DB for deviceID:%u (ErrorCode:%s)", m_ScanContext[i].deviceID, errorString(ret)));
            }
#endif
            /* Release temporary lists and remove device from internal scan context */
            ret = RemoveDeviceFromContext(i);
        }
    }

    /* Send stop done to SPM in the transition to final state in state machine */
    return StopDone(0);
}

tResult USBControl::Done()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Deregister state machine with dispatcher */
    Dispatcher::GetInstance().DeRegister(IN this);

    /* Send DONE message to own SM */
    ret = SendForceEvent(DONE, (char *)NULL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult USBControl::DoneEventProcessed()
{
    ENTRY

    //Cleanup threads
    LocalSPM::GetThreadFactory().CleanUpThreads(this);

    /* Send done done to SPM in the transition to final state in state machine */
    return DoneDone(0);
}

char *USBControl::GetSMStateName(tGeneralString stateName, size_t size)
{
    GetCurrentState((char *)stateName, size);
    return stateName;
}


//Playback control part

tResult USBControl::StartAllocateAudioInput(const tDeviceID /*deviceID*/, const tMountPoint /*mountPoint*/)
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    /* For USB no need to assign audio input device */
#if 0
    tAudioInputDevice audioInputDevice = NULL;

    /* Send AssignAudioInputDevice to PlayerEngine via DBUS */
    RegisterReleaseEvent(METHOD_RETURN);
    ret = LocalSPM::GetIPCProvider().AssignAudioInputDevice(IN this, IN audioInputDevice);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while using IPCProvider::AssignAudioInputDevice (ErrorCode:%s)", errorString(ret)));
    }
#endif

    /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tReturnValue returnValue = true;

    ret = ParameterMETHOD_RETURN(OUT parameterString, IN size, IN returnValue);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(METHOD_RETURN, IN parameterString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::StartDeAllocateAudioInput()
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    /* For USB no need to deallocate audio input device */
#if 0
    /* Send DeAllocateInDevice to PlayerEngine via DBUS */
    RegisterReleaseEvent(METHOD_RETURN);
    ret = LocalSPM::GetIPCProvider().DeAllocateInDevice(IN this);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while using IPCProvider::DeAllocateInDevice (ErrorCode:%s)", errorString(ret)));
    }
#endif

    /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tReturnValue returnValue = true;

    ret = ParameterMETHOD_RETURN(OUT parameterString, IN size, IN returnValue);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(METHOD_RETURN, IN parameterString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::StartSwitchObserver(const tDeviceID /*deviceID*/, const tMountPoint /*mountPoint*/)
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Switch the observer to this state machine */
#if 1
        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::SWITCH_OBSERVER", "USBControlSM", "USBControlSM::METHOD_RETURN");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
#else
        Dispatcher::GetInstance().SendMessage("MediaEngineSM::SWITCH_OBSERVER", "USBControlSM");

        /* MediaEngine will not answer, so fake the answer */
        ret = SendEvent(METHOD_RETURN, IN "0");
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
#endif
    }
    else
    {
        /* Send SwitchObserver to PlayerEngine via DBUS */
        RegisterReleaseEvent(METHOD_RETURN);
        ret = LocalSPM::GetIPCProvider().SwitchObserver(IN this);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::SwitchObserver (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::StartStreaming(const tDeviceID /*deviceID*/, const tMountPoint /*mountPoint*/)
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    tPEPlaybackState status = PE_PBS_LOADINGSTATE;

    /* For USB no need to start streaming */
    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Fake MediaEngine response: Send expected event to waiting state machine immediately */
        me::reason_e reason = REASON_OK;
        me::speed_e speed = ME_SPEED_NORMAL;

        m_Mutex.lock();
        tPEHandle handle = (tPEHandle)m_PlayMediaObject.objectID;
        m_Mutex.unlock();

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = ParameterSTART_STREAMING_ANSWER(OUT parameterString, IN size, IN handle, IN status, IN reason, IN speed);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(START_STREAMING_ANSWER, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
        tMetadata metadata = { 0 };

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        tObjectID ObjectID = OBJECT_ID_NONE;
        ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN status, IN metadata, IN metadata, IN metadata, IN metadata,IN ObjectID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::StartStopStreaming()
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    /* For USB no need to stop streaming
     * Send STOP_STREAMING_ANSWER message to release own waiting state */
    ret = ParameterSTOP_STREAMING_ANSWER(OUT parameterString, IN size, IN deviceID);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(STOP_STREAMING_ANSWER, IN parameterString);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::StopStreamingAnswer(tDeviceID deviceID)
{
    ENTRY
    (void)deviceID;
    tPEPlaybackState status = PE_PBS_STOPPEDSTATE;

    /* Send answer to waiting state machine */
    if( LocalSPM::GetDataProvider().UseMediaEngine() )
    {
        m_Mutex.lock();
        tPEHandle handle = (tPEHandle)m_PlayMediaObject.objectID;
        m_Mutex.unlock();

        PlaybackStatusNew(IN handle, IN status, IN REASON_OK, IN ME_SPEED_NORMAL);
    }
    else
    {
        tMetadata metadata = { 0 };

        PlaybackStatus(IN status, IN metadata, IN metadata, IN metadata, IN metadata);
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::StartPlay(const tDeviceType deviceType,
        const tDeviceID deviceID,
        const tURL URL,
        const tMountPoint mountPoint,
        const tUUID uuid,
        const tPEHandle handle,
        const tPlaytime position,
        const tStreaming streaming)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);
    (void)uuid;
    VARTRACE(handle);
    VARTRACE(position);
    VARTRACE(streaming);

    /* Update media object to play */
    m_Mutex.lock();
    InitMediaObject(OUT m_PlayMediaObject);
    m_PlayMediaObject.objectID = (tObjectID)handle;
    m_PlayMediaObject.deviceID = deviceID;
    //strncpy_r(OUT m_PlayMediaObject.fileName, IN URL, IN sizeof(m_PlayMediaObject.fileName));
    strncpy_r(OUT m_PlayMediaObject.mountPoint, IN mountPoint, IN sizeof(m_PlayMediaObject.mountPoint));
    m_Mutex.unlock();

    m_StartPosition = position;

    /* Put complete path together (mount point + relative path of the URL)*/
    tURL mountPointURL;
    strncpy_r(OUT mountPointURL, IN mountPoint, IN sizeof(mountPointURL));
    strncat_r(OUT mountPointURL, IN URL, IN sizeof(mountPointURL));

#if 1

    char *pMountPointURL = new char[sizeof(tURL)];      // will be deleted by the thread function
    strncpy_r(OUT pMountPointURL, IN mountPointURL, IN sizeof(tURL));

    /*Create a worker thread to read metadata from file */
    RegisterReleaseEvent(METADATA_FOR_PLAYBACK);
    LocalSPM::GetThreadFactory().Do(IN this, FUNCTION_ID_READMETADATA_FOR_PLAYBACK, (void*)pMountPointURL); //lint -e429 freed by calling thread

#else

    tResult ret = MP_NO_ERROR;

    ret = LocalSPM::GetDBManager().GetFileFormat(OUT m_PlayMediaObject.fileFormat, OUT m_PlayMediaObject.fileType, IN URL);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("unable to get file format for the url : %s", URL));

        /* Send action error to own state machine */
        ActionError(REASON_FORMAT_ERROR);

        return MP_NO_ERROR;
    }
    else
    {
        if(FT_VIDEO == m_PlayMediaObject.fileType ) /*Read video metadata*/
        {
            if(!ReadVideoMetadataFromFile(INOUT m_PlayMediaObject, IN mountPointURL))
            {
                ETG_TRACE_ERR(("Skip playback of video file because it is codec restricted %s", mountPointURL));

                /* Send action error to own state machine */
                ActionError(REASON_FORMAT_ERROR);

                return MP_NO_ERROR;
            }
        }
        else /*Read audio metadata*/
        {
            ReadAudioMetadataFromFile(INOUT m_PlayMediaObject, IN mountPointURL);
        }
    }

    /* Send METADATA_FOR_PLAYBACK message to own SM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = ParameterMETADATA_FOR_PLAYBACK(OUT parameterString, IN size, IN handle, IN mountPointURL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(METADATA_FOR_PLAYBACK, IN parameterString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

#endif

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::StartPlayWithMetadata(const tPEHandle handle, const tURL mountPointURL)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(mountPointURL);

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();
    tObjectID objectID = m_PlayMediaObject.objectID;
    tNotPlayable notPlayable = m_PlayMediaObject.notPlayable;
    m_Mutex.unlock();

    if((tObjectID)handle != objectID)
    {
        ETG_TRACE_ERR(("Received metadata of wrong object (objectID (received/expected):%u/%u)", (tObjectID)handle, objectID));

        /* Send action error to own state machine */
        ActionError(REASON_ERROR);
        return MP_NO_ERROR;
    }

    /* In case of file is DRM protected send action error */
    if(FNP_DRM_PROTECTED == notPlayable)
    {
        ETG_TRACE_ERR(("Skip playback of file since it is DRM protected (%s)", mountPointURL));

        /* Send action error to own state machine */
        ActionError(REASON_DRM_ERROR);
        return MP_NO_ERROR;
    }
    else if(FNP_PLAY_RESTRICTION == notPlayable)
    {
        ETG_TRACE_ERR(("Skip playback of file since it is Codec restricted (%s)", mountPointURL));

        /* Send action error to own state machine */
        ActionError(REASON_CODEC_ERROR);
        return MP_NO_ERROR;
    }
    else if(FNP_FORMAT_ERROR == notPlayable)
    {
        ETG_TRACE_ERR(("Skip playback of file since it is not readable (%s)", mountPointURL));

        /* Send action error to own state machine */
        ActionError(REASON_FORMAT_ERROR);
        return MP_NO_ERROR;
    }
    else if(FNP_READ_ERROR == notPlayable)
    {
        ETG_TRACE_ERR(("Skip playback of file since file does not exist (%s)", mountPointURL));

        /* Send action error to own state machine */
        ActionError(REASON_URL_ERROR);
        return MP_NO_ERROR;
    }
    else
    {
        if(LocalSPM::GetDataProvider().UseMediaEngine())
        {
            tPEStateString args;


            me::vprops_t meVideoProperties;
            if (MTY_VIDEO == m_PlayMediaObject.mediaType)
            {
                ret = LocalSPM::GetDBManager().GetVideoProperties(meVideoProperties);
                if(MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while getting video properties from dbmanager"));
                }
            }
            VARTRACE(meVideoProperties);
            SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiiltliiiiiiil",
                    mountPointURL, (int)ME_SPEED_NORMAL, m_StartPosition,
                    handle, m_AudioOutputDevice, samplerate_i_none,
                    (int)meVideoProperties.brightness(), (int)meVideoProperties.hue(),
                    (int)meVideoProperties.saturation(), (int)meVideoProperties.contrast(),
                    (int)meVideoProperties.brightnessoffset(), (int)meVideoProperties.saturationoffset(),
                    (int)meVideoProperties.hueoffset(),ME_SPEEDSTATE_OFF);

            ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::PLAY", args, "USBControlSM::PLAY_ANSWER");
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
            }
            RegisterNoResponseEvent(PLAY_ANSWER,REASON_STREAM_INPROGRESS,PLAYBACK_RESPONSE_TIMEOUT);
        }
        else
        {
            tPlaypointFormat playpointFormat = PPF_ABSOLUTE; //absolute time in milliseconds
            tURL mountPointURL2PE;
            // thm4hi: problem is: the player engine in ubuntu does not react as the one in the target.

#if TARGET_BUILD
            /* thm4hi: for old player engine: do a fake conversion to utf8 */
            toUtf8Fake(OUT mountPointURL2PE, IN sizeof(mountPointURL2PE), IN mountPointURL);
#else
            strncpy_r(OUT mountPointURL2PE, IN mountPointURL, IN sizeof(mountPointURL2PE));
#endif

            /* Send NewPlaySlot to PlayerEngine via DBUS */
            RegisterReleaseEvent(PLAYBACK_STATUS_RESPONSE);
            ret = LocalSPM::GetIPCProvider().NewPlaySlot(IN this, IN mountPointURL2PE, IN m_StartPosition, IN playpointFormat);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while using IPCProvider::NewPlaySlot (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::StartStop(const tDeviceType deviceType,
        const tDeviceID deviceID,
        const tURL URL,
        const tMountPoint mountPoint)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::STOP", NULL, "USBControlSM::STOP_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send StopSlot to PlayerEngine via DBUS */
        RegisterReleaseEvent(STOP_ANSWER);
        ret = LocalSPM::GetIPCProvider().StopSlot(IN this);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::StopSlot (ErrorCode:%s)", errorString(ret)));
        }
    }

    /* Reset media object to play */
    ETG_TRACE_USR3(("Reset media object to play"));
    m_Mutex.lock();
    InitMediaObject(OUT m_PlayMediaObject);
    m_Mutex.unlock();

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::StartPause(const tDeviceType deviceType,
        const tDeviceID deviceID,
        const tURL URL,
        const tMountPoint mountPoint)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);

    tResult ret = MP_NO_ERROR;

    /* Put complete path together (mount point + relative path of the URL)*/
    tURL mountPointURL;
    strncpy_r(OUT mountPointURL, IN mountPoint, IN sizeof(mountPointURL));
    strncat_r(OUT mountPointURL, IN URL, IN sizeof(mountPointURL));

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        tPEStateString args;
        SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiilt", mountPointURL, (int)ME_SPEED_NONE, POSITION_NOT_SET, HANDLE_NONE, m_AudioOutputDevice);
        /* explanation: the gcc seems to find a wrong method without a second elipsis parameter.
         * It find the va_list version of this method which is private to SMF. */

        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::PAUSE", args, "USBControlSM::PAUSE_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send PauseSlot to PlayerEngine via DBUS */
        tPlaytime position = 0; //dummy position, only used in case of being not in state playing
        tPlaypointFormat playpointFormat = PPF_ABSOLUTE; //absolute time in milliseconds

        tURL mountPointURL2PE;
        // thm4hi: problem is: the player engine in ubuntu does not react as the one in the target.
#ifdef TARGET_BUILD
        /* thm4hi: for old player engine: do a fake conversion to utf8 */
        toUtf8Fake(OUT mountPointURL2PE, IN sizeof(mountPointURL2PE), IN mountPointURL);
#else
        strncpy_r(OUT mountPointURL2PE, IN mountPointURL, IN sizeof(mountPointURL2PE));
#endif

        RegisterReleaseEvent(PLAYBACK_STATUS_RESPONSE);
        ret = LocalSPM::GetIPCProvider().PauseSlot(IN this, IN mountPointURL2PE, IN position, IN playpointFormat);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::PauseSlot (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::StartResume(const tDeviceType deviceType,
        const tDeviceID deviceID,
        const tURL URL,
        const tMountPoint mountPoint)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Put complete path together (mount point + relative path of the URL)*/
        tURL mountPointURL;
        strncpy_r(OUT mountPointURL, IN mountPoint, IN sizeof(mountPointURL));
        strncat_r(OUT mountPointURL, IN URL, IN sizeof(mountPointURL));

        tPEStateString args;
        SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiilt", mountPointURL, (int)ME_SPEED_NORMAL, POSITION_NOT_SET, HANDLE_NONE, m_AudioOutputDevice);

        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::PLAY", args, "USBControlSM::RESUME_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send ResumePlaySlot to PlayerEngine via DBUS */
        RegisterReleaseEvent(PLAYBACK_STATUS_RESPONSE);
        ret = LocalSPM::GetIPCProvider().ResumePlaySlot(IN this);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::ResumePlaySlot (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::StartFfwdStart(const tDeviceType deviceType,
        const tDeviceID deviceID,
        const tURL URL,
        const tMountPoint mountPoint,
        const tCueingRate rate,
        const speedstate_e IsPlaybackSpeed)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);
    VARTRACE(rate);
    VARTRACE(IsPlaybackSpeed);

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Put complete path together (mount point + relative path of the URL)*/
        tURL mountPointURL;
        strncpy_r(OUT mountPointURL, IN mountPoint, IN sizeof(mountPointURL));
        strncat_r(IN mountPointURL, IN URL, IN sizeof(mountPointURL));

        tPEStateString args;
        me::vprops_t meVideoProperties;
        if (MTY_VIDEO == m_PlayMediaObject.mediaType)
        {
            ret = LocalSPM::GetDBManager().GetVideoProperties(meVideoProperties);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while getting video properties from dbmanager"));
            }
        }
        VARTRACE(meVideoProperties);


        SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiiltliiiiiiil", mountPointURL,
                (int)rate, POSITION_NOT_SET, HANDLE_NONE, m_AudioOutputDevice,samplerate_i_none,
                (int)meVideoProperties.brightness(), (int)meVideoProperties.hue(),
                (int)meVideoProperties.saturation(), (int)meVideoProperties.contrast(),
                (int)meVideoProperties.brightnessoffset(), (int)meVideoProperties.saturationoffset(),
                (int)meVideoProperties.hueoffset(),IsPlaybackSpeed);



        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::PLAY", args, "USBControlSM::FFWD_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send StartFfwdSlot to PlayerEngine via DBUS */
        //RegisterReleaseEvent(PLAYBACK_STATUS_RESPONSE);
        ret = LocalSPM::GetIPCProvider().StartFfSlot(IN this, IN rate);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::StartFfSlot (ErrorCode:%s)", errorString(ret)));
        }

        /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
        tPEPlaybackState status = PE_PBS_FASTFORWARDSTATE;
        tMetadata metadata1 = {0};
        strncpy_r(OUT metadata1, IN URL, IN sizeof(metadata1));
        tMetadata metadata = {0};

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        tObjectID ObjectID = OBJECT_ID_NONE;
        ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN status, IN metadata1, IN metadata, IN metadata, IN metadata,IN ObjectID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::StartFfwdStop(const tDeviceType deviceType,
        const tDeviceID deviceID,
        const tURL URL,
        const tMountPoint mountPoint,
        const speedstate_e IsPlaybackSpeed)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Put complete path together (mount point + relative path of the URL)*/
        tURL mountPointURL;
        strncpy_r(OUT mountPointURL, IN mountPoint, IN sizeof(mountPointURL));
        strncat_r(OUT mountPointURL, IN URL, IN sizeof(mountPointURL));

        tPEStateString args;

        me::vprops_t meVideoProperties;
        if (MTY_VIDEO == m_PlayMediaObject.mediaType)
        {
            ret = LocalSPM::GetDBManager().GetVideoProperties(meVideoProperties);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while getting video properties from dbmanager"));
            }
        }
        VARTRACE(meVideoProperties);


        SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiiltliiiiiiil", mountPointURL,
                (int)ME_SPEED_NORMAL, POSITION_NOT_SET, HANDLE_NONE, m_AudioOutputDevice,samplerate_i_none,
                (int)meVideoProperties.brightness(), (int)meVideoProperties.hue(),
                (int)meVideoProperties.saturation(), (int)meVideoProperties.contrast(),
                (int)meVideoProperties.brightnessoffset(), (int)meVideoProperties.saturationoffset(),
                (int)meVideoProperties.hueoffset(),IsPlaybackSpeed);




        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::PLAY", args, "USBControlSM::FFWD_STOP_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send StopFfwdSlot to PlayerEngine via DBUS */
        //RegisterReleaseEvent(PLAYBACK_STATUS_RESPONSE);
        ret = LocalSPM::GetIPCProvider().StopFfSlot(IN this);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::StopFfSlot (ErrorCode:%s)", errorString(ret)));
        }

        /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
        tPEPlaybackState status = PE_PBS_PLAYINGSTATE;
        tMetadata metadata1 = {0};
        strncpy_r(OUT metadata1, IN URL, IN sizeof(metadata1));
        tMetadata metadata = {0};

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        tObjectID ObjectID = OBJECT_ID_NONE;
        ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN status, IN metadata1, IN metadata, IN metadata, IN metadata,IN ObjectID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::StartFrevStart(const tDeviceType deviceType,
        const tDeviceID deviceID,
        const tURL URL,
        const tMountPoint mountPoint,
        const tCueingRate rate,
        const speedstate_e IsPlaybackSpeed)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);
    VARTRACE(rate);
    VARTRACE(IsPlaybackSpeed);

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Put complete path together (mount point + relative path of the URL)*/
        tURL mountPointURL;
        strncpy_r(OUT mountPointURL, IN mountPoint, IN sizeof(mountPointURL));
        strncat_r(OUT mountPointURL, IN URL, IN sizeof(mountPointURL));

        tPEStateString args;
        me::vprops_t meVideoProperties;
        if (MTY_VIDEO == m_PlayMediaObject.mediaType)
        {
            ret = LocalSPM::GetDBManager().GetVideoProperties(meVideoProperties);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while getting video properties from dbmanager"));
            }
        }
        VARTRACE(meVideoProperties);


        SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiiltliiiiiiil", mountPointURL,
                -(int)rate, POSITION_NOT_SET, HANDLE_NONE, m_AudioOutputDevice,samplerate_i_none,
                (int)meVideoProperties.brightness(), (int)meVideoProperties.hue(),
                (int)meVideoProperties.saturation(), (int)meVideoProperties.contrast(),
                (int)meVideoProperties.brightnessoffset(), (int)meVideoProperties.saturationoffset(),
                (int)meVideoProperties.hueoffset(),IsPlaybackSpeed);

        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::PLAY", args, "USBControlSM::FREV_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send StartFrevSlot to PlayerEngine via DBUS */
        //RegisterReleaseEvent(PLAYBACK_STATUS_RESPONSE);
        ret = LocalSPM::GetIPCProvider().StartFrevSlot(IN this, IN rate);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::StartFrevSlot (ErrorCode:%s)", errorString(ret)));
        }

        /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
        tPEPlaybackState status = PE_PBS_FASTREVERSESTATE;
        tMetadata metadata1 = {0};
        strncpy_r(OUT metadata1, IN URL, IN sizeof(metadata1));
        tMetadata metadata = {0};

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        tObjectID ObjectID = OBJECT_ID_NONE;
        ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN status, IN metadata1, IN metadata, IN metadata, IN metadata,IN ObjectID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::StartFrevStop(const tDeviceType deviceType,
        const tDeviceID deviceID,
        const tURL URL,
        const tMountPoint mountPoint,
        const speedstate_e IsPlaybackSpeed)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Put complete path together (mount point + relative path of the URL)*/
        tURL mountPointURL;
        strncpy_r(OUT mountPointURL, IN mountPoint, IN sizeof(mountPointURL));
        strncat_r(OUT mountPointURL, IN URL, IN sizeof(mountPointURL));

        tPEStateString args;
        me::vprops_t meVideoProperties;
        if (MTY_VIDEO == m_PlayMediaObject.mediaType)
        {
            ret = LocalSPM::GetDBManager().GetVideoProperties(meVideoProperties);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while getting video properties from dbmanager"));
            }
        }
        VARTRACE(meVideoProperties);


        SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiiltliiiiiiil", mountPointURL,
                (int)ME_SPEED_NORMAL, POSITION_NOT_SET, HANDLE_NONE, m_AudioOutputDevice,samplerate_i_none,
                (int)meVideoProperties.brightness(), (int)meVideoProperties.hue(),
                (int)meVideoProperties.saturation(), (int)meVideoProperties.contrast(),
                (int)meVideoProperties.brightnessoffset(), (int)meVideoProperties.saturationoffset(),
                (int)meVideoProperties.hueoffset(),IsPlaybackSpeed);



        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::PLAY", args, "USBControlSM::FREV_STOP_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send StopFrevSlot to PlayerEngine via DBUS */
        //RegisterReleaseEvent(PLAYBACK_STATUS_RESPONSE);
        ret = LocalSPM::GetIPCProvider().StopFrevSlot(IN this);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::StopFrevSlot (ErrorCode:%s)", errorString(ret)));
        }

        /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
        tPEPlaybackState status = PE_PBS_PLAYINGSTATE;
        tMetadata metadata1 = {0};
        strncpy_r(OUT metadata1, IN URL, IN sizeof(metadata1));
        tMetadata metadata = {0};

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        tObjectID ObjectID = OBJECT_ID_NONE;
        ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN status, IN metadata1, IN metadata, IN metadata, IN metadata,IN ObjectID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::StartSeekTo(const tDeviceType deviceType,
        const tDeviceID deviceID,
        const tURL URL,
        const tMountPoint mountPoint,
        const tPlaytime position)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);
    VARTRACE(position);

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Put complete path together (mount point + relative path of the URL)*/
        tURL mountPointURL;
        strncpy_r(OUT mountPointURL, IN mountPoint, IN sizeof(mountPointURL));
        strncat_r(OUT mountPointURL, IN URL, IN sizeof(mountPointURL));

        m_Mutex.lock();
        tPEHandle handle = (tPEHandle)m_PlayMediaObject.objectID;
        m_Mutex.unlock();

        tPEStateString args;
        SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiil", mountPointURL, (int)ME_SPEED_NONE, position, handle);

        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::SEEK_TO", args, "USBControlSM::SEEK_TO_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send SeekToSlot to PlayerEngine via DBUS */
        tPlaypointFormat playpointFormat = PPF_ABSOLUTE; //absolute time in milliseconds

        //RegisterReleaseEvent(TICK_TIME_ELAPSED);
        ret = LocalSPM::GetIPCProvider().SeekToSlot(IN this, IN position, IN playpointFormat);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::SeekToSlot (ErrorCode:%s)", errorString(ret)));
        }

        /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
        tPlaytime elapsedPlaytime = position;
        tPlaytime totalPlaytime = PLAYTIME_NONE;

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = ParameterTICK_TIME_ELAPSED(OUT parameterString, IN size, IN elapsedPlaytime, IN totalPlaytime);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(TICK_TIME_ELAPSED, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::StartBuffer(const tDeviceType deviceType,
        const tDeviceID deviceID,
        const tURL URL,
        const tMountPoint mountPoint,
        const tPEHandle handle)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);
    VARTRACE(handle);

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Put complete path together (mount point + relative path of the URL)*/
        tURL mountPointURL;
        strncpy_r(OUT mountPointURL, IN mountPoint, IN sizeof(mountPointURL));
        strncat_r(OUT mountPointURL, IN URL, IN sizeof(mountPointURL));

        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::BUFFER", mountPointURL, "USBControlSM::BUFFER_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        ETG_TRACE_ERR(("Old PlayerEngine does not know this command - faking BUFFER_ANSWER"));

        /* Send answer to waiting state machine */
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        tSuccess success = SC_YES;

        ret = ParameterBUFFER_ANSWER(OUT parameterString, IN size, IN success);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(BUFFER_ANSWER, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::DiscardBuffer()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::FLUSH", NULL, "USBControlSM::FLUSH_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        ETG_TRACE_ERR(("Old PlayerEngine does not know this command"));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return ret;
}

tResult USBControl::ActionStatus(const tReturnValue returnValue)
{
    ENTRY
    VARTRACE(returnValue);

    tResult ret = MP_NO_ERROR;

    /* Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetDeviceDispatcher().ParameterMETHOD_RETURN(OUT parameterString, IN size, IN returnValue);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::BufferStatus(const tSuccess success)
{
    ENTRY
    VARTRACE(success);

    tResult ret = MP_NO_ERROR;

    /* Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

#if 0
    /* map reason to success */
    tSuccess success = SC_NO;
    if (reason >= REASON_OK) {
        success = SC_YES;
    }
#endif

    ret = LocalSPM::GetPlayerManager().ParameterBUFFER_ANSWER(OUT parameterString, IN size, IN success);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::PlaybackStatus(const tPEPlaybackState status,
        const tMetadata metadata1,
        const tMetadata metadata2,
        const tMetadata metadata3,
        const tMetadata metadata4,
        const tObjectID ObjectID)
{
    ENTRY
    VARTRACE6(status, metadata1, metadata2, metadata3, metadata4, MTY_UNKNOWN);

    tResult ret = MP_NO_ERROR;
    m_Mutex.lock();
    tMediaObject mediaObject =  m_PlayMediaObject;
    m_Mutex.unlock();

    /* Send answer to waiting state machine */
    if( PE_PBS_ERRORSTATE == status )
    {
        /* Validate error code */
        me::reason_e reason;
        ret = ValidateErrorCode(OUT reason, IN metadata2, IN mediaObject.mountPoint);

        /* Send action error instead of answer to waiting state machine */
        HandleActionError(IN reason);
    }
    else
    {
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = LocalSPM::GetDeviceDispatcher().ParameterPLAY_ANSWER(OUT parameterString,
                IN size,
                IN status,
                IN mediaObject.MetadataField1,
                IN mediaObject.MetadataField2,
                IN mediaObject.MetadataField3,
                IN mediaObject.MetadataField4,
                IN mediaObject.title,
                IN mediaObject.mediaType,
                IN mediaObject.metadataConvertFlag,
                IN mediaObject.UUID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendAnswer(IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::ForwardPlaybackStatus(const tPEPlaybackState status,
        const tMetadata metadata1,
        const tMetadata metadata2,
        const tMetadata metadata3,
        const tMetadata metadata4,
        const tObjectID ObjectID)
{
    ENTRY
    VARTRACE6(status, metadata1, metadata2, metadata3, metadata4, MTY_UNKNOWN);

    tResult ret = MP_NO_ERROR;
    m_Mutex.lock();
    tMediaObject mediaObject =  m_PlayMediaObject;
    m_Mutex.unlock();

    if( PE_PBS_ERRORSTATE == status )
    {
        /* Validate error code */
        me::reason_e reason;
        ret = ValidateErrorCode(OUT reason, IN metadata2, IN mediaObject.mountPoint);

        /* Forward stream error */
        ForwardStreamError(IN reason);
    }
    else
    {
        /* Send PLAYBACK_STATUS_RESPONSE message to PlayerManger to update playback state */
        char messageString[64];
        strncpy_r(OUT messageString, IN "PlayerManagerSM::PLAYBACK_STATUS_RESPONSE", IN sizeof(messageString));

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        tObjectID ObjectID = OBJECT_ID_NONE;

        ret = LocalSPM::GetPlayerManager().ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString,
                IN size,
                IN status,
                IN mediaObject.MetadataField1,
                IN mediaObject.MetadataField2,
                IN mediaObject.MetadataField3,
                IN mediaObject.MetadataField4,
                IN mediaObject.title,
                IN mediaObject.mediaType,
                IN mediaObject.metadataConvertFlag,
                IN mediaObject.UUID,
                IN ObjectID);

        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult USBControl::PlaytimeStatus(const tPlaytime elapsedPlaytime, const tPlaytime totalPlaytime)
{
    ENTRY
    VARTRACE2(elapsedPlaytime, totalPlaytime);

#if 0
    tResult ret = MP_NO_ERROR;

    /* Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetPlayerManager().ParameterSEEK_TO_ANSWER(OUT parameterString, IN size, IN elapsedPlaytime, IN totalPlaytime);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }
#else
    m_Mutex.lock();
    tPEHandle handle = (tPEHandle)m_PlayMediaObject.objectID;
    m_Mutex.unlock();

    tPETimeInfoStruct timeInfoStruct;
    InitPETimeInfoStruct(timeInfoStruct);
    timeInfoStruct.position.ms = (tPEMilliseconds)elapsedPlaytime;
    timeInfoStruct.duration.ms = (tPEMilliseconds)totalPlaytime;

    /* Marshal struct of timeInfo into a string */
    tPETimeInfo timeInfoString;
    size_t size = sizeof(timeInfoString);
    SMF::Marshal(OUT timeInfoString,
            IN size-1,
            IN DOUBLE_MARSHAL_SEPARATOR,
            IN tPEBytes_format tPEPercentage_format tPEMilliseconds_format tPEBytes_format tPEMilliseconds_format,
            IN timeInfoStruct.position.bytes,
            IN timeInfoStruct.position.pct,
            IN timeInfoStruct.position.ms,
            IN timeInfoStruct.duration.bytes,
            IN timeInfoStruct.duration.ms);

    PlaytimeStatusNew(IN handle, IN timeInfoString);
#endif

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::ForwardPlaytimeStatus(const tPlaytime elapsedPlaytime, const tPlaytime totalPlaytime)
{
    ENTRY
    VARTRACE2(elapsedPlaytime, totalPlaytime);

    tResult ret = MP_NO_ERROR;

#if 0
    /* Send TICK_TIME_ELAPSED message to PlayerManger to update playtime */
    char messageString[64];
    strncpy_r(OUT messageString, IN "PlayerManagerSM::TICK_TIME_ELAPSED", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetPlayerManager().ParameterTICK_TIME_ELAPSED(OUT parameterString, IN size, IN elapsedPlaytime, IN totalPlaytime);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }
    /*If the device is in scanning Mode and the elapsed crossed to configured scan time,
      then inform PlayerManagerSM as if the track is finished.
      Thus tracks will be scanned*/
    if(m_ScanMode && elapsedPlaytime > (tUInt)LocalSPM::GetDataProvider().TrackScanTime())
    {
        m_Mutex.lock();
        tMediaObject mediaObject = m_PlayMediaObject;
        m_Mutex.unlock();

        tAllParameters parameterString_1;
        size_t size_1 = sizeof(parameterString_1);

        /* Send PLAYBACK_STATUS_RESPONSE message to PlayerManger to update playback state */
        char messageString_1[64];
        strncpy_r(OUT messageString_1, IN "PlayerManagerSM::PLAYBACK_STATUS_RESPONSE", IN sizeof(messageString_1));

        tObjectID ObjectID = OBJECT_ID_NONE;
        ret = LocalSPM::GetPlayerManager().ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString_1,
                IN size_1,
                IN PE_PBS_FINISHEDSTATE,
                IN mediaObject.MetadataField1,
                IN mediaObject.MetadataField2,
                IN mediaObject.MetadataField3,
                IN mediaObject.MetadataField4,
                IN mediaObject.title,
                IN mediaObject.mediaType,
                IN mediaObject.metadataConvertFlag,
                IN mediaObject.UUID,
                IN ObjectID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        }
        else
        {
            ret = Dispatcher::GetInstance().SendMessage(IN messageString_1, IN parameterString_1);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
    }
#else
    m_Mutex.lock();
    tPEHandle handle = (tPEHandle)m_PlayMediaObject.objectID;
    m_Mutex.unlock();

    tPETimeInfoStruct timeInfoStruct;
    InitPETimeInfoStruct(timeInfoStruct);
    timeInfoStruct.position.ms = (tPEMilliseconds)elapsedPlaytime;
    timeInfoStruct.duration.ms = (tPEMilliseconds)totalPlaytime;

    /* Marshal struct of timeInfo into a string */
    tPETimeInfo timeInfoString;
    size_t size = sizeof(timeInfoString);
    SMF::Marshal(OUT timeInfoString,
            IN size-1,
            IN DOUBLE_MARSHAL_SEPARATOR,
            IN tPEBytes_format tPEPercentage_format tPEMilliseconds_format tPEBytes_format tPEMilliseconds_format,
            IN timeInfoStruct.position.bytes,
            IN timeInfoStruct.position.pct,
            IN timeInfoStruct.position.ms,
            IN timeInfoStruct.duration.bytes,
            IN timeInfoStruct.duration.ms);

    ret = ForwardPlaytimeStatusNew(IN handle, IN timeInfoString);
#endif

    return ret;
}

tResult USBControl::HandleActionError(const me::reason_e reason)
{
    ENTRY_INTERNAL

    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    /* Send action error instead of answer to waiting state machine */
    ret = LocalSPM::GetDeviceDispatcher().ParameterACTION_ERROR(OUT parameterString, IN size, IN reason);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendActionError(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending action error via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult USBControl::ActionError(const me::reason_e reason)
{
    ENTRY_INTERNAL

    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    /* Send action error to own state machine*/
    ret = ParameterACTION_ERROR(OUT parameterString, IN size, IN reason);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(ACTION_ERROR ,IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending action error via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult USBControl::ForwardStreamError(const me::reason_e reason) const
{
    ENTRY_INTERNAL

    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    /* Send STREAM_ERROR message to PlayerManger */
    char messageString[64];
    strncpy_r(OUT messageString, IN "PlayerManagerSM::STREAM_ERROR", IN sizeof(messageString));

    ret = LocalSPM::GetPlayerManager().ParameterSTREAM_ERROR(OUT parameterString, IN size, IN reason);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult USBControl::PlaybackStatusNew(const tPEHandle handle, const tPEPlaybackState playbackState, const me::reason_e reason, const me::speed_e speed)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(playbackState);
    VARTRACE(reason);
    VARTRACE(speed);

    tResult ret = MP_NO_ERROR;

    if(REASON_OK > reason)
    {
        me::reason_e localReason = reason;
        tMountPoint mountPoint;

        m_Mutex.lock();
        strncpy_r(OUT mountPoint, IN m_PlayMediaObject.mountPoint, IN sizeof(mountPoint));
        m_Mutex.unlock();

        if(REASON_URL_ERROR == localReason)
        {
            /*check if read request on device related to this mount point is possible*/
            if(!LocalSPM::GetDataProvider().checkIfDeviceConnected(mountPoint))
            {
                localReason = REASON_DEVICE_ERROR;
            }
        }

        /* Send action error instead of answer to waiting state machine */
        HandleActionError(IN localReason);
    }
    else
    {
        /* Send answer to waiting state machine */
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = LocalSPM::GetDeviceDispatcher().ParameterPLAY_ANSWER_NEW(OUT parameterString, IN size, IN handle, IN playbackState, IN reason, IN speed);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendAnswer(IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::ForwardPlaybackStatusNew(const tPEHandle handle, const tPEPlaybackState playbackState, const me::reason_e reason, const me::speed_e speed)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(playbackState);
    VARTRACE(reason);
    VARTRACE(speed);

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();
    tObjectID objectID = m_PlayMediaObject.objectID;
    m_Mutex.unlock();

    if(((tObjectID)handle != objectID)
            &&
            (PE_PBS_STOPPEDSTATE != playbackState))
    {
        ETG_TRACE_ERR(("Obsolete playback status -> Do not forward objectID:%u", (tObjectID)handle));
    }
    else
    {
        //Remark: Interpretation of non error reasons is done in PlayerManager::ForwardPlaybackStatusNew
        if(REASON_OK > reason)
        {
            me::reason_e localReason = reason;
            tMountPoint mountPoint;

            m_Mutex.lock();
            strncpy_r(OUT mountPoint, IN m_PlayMediaObject.mountPoint, IN sizeof(mountPoint));
            m_Mutex.unlock();

            if(REASON_URL_ERROR == localReason)
            {
                /*check if read request on device related to this mount point is possible*/
                if(!LocalSPM::GetDataProvider().checkIfDeviceConnected(mountPoint))
                {
                    localReason = REASON_DEVICE_ERROR;
                }
            }

            /* Forward stream error */
            ForwardStreamError(IN localReason);
        }
        else
        {
            /* Send PLAYBACK_STATUS message to PlayerManger to update playback status */
            char messageString[64];
            strncpy_r(OUT messageString, IN "PlayerManagerSM::PLAYBACK_STATUS", IN sizeof(messageString));
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);

            ret = LocalSPM::GetPlayerManager().ParameterPLAYBACK_STATUS(OUT parameterString, IN size, IN handle, IN playbackState, IN reason, IN speed);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                parameterString[0] = '\0';
            }

            ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
        SendNoResponseMsg(reason);
    }

    return ret;
}

tResult USBControl::ForwardNowPlayingStatus(const tPEHandle handle, const tURL mountPointURL)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(mountPointURL);

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();
    tMediaObject mediaObject = m_PlayMediaObject;
    m_Mutex.unlock();

    if((tObjectID)handle != mediaObject.objectID)
    {
        if( !LocalSPM::GetDataProvider().GaplessPlay() )
        {
            ETG_TRACE_ERR(("Obsolete nowPlaying status -> Do not forward objectID:%u", (tObjectID)handle));
        }
        else
        {
            ETG_TRACE_USR1(("Received nowPlaying status of a new object (objectID (received/last):%u/%u)", (tObjectID)handle, mediaObject.objectID));
#if 1
            /* Update media object to update */
            m_Mutex.lock();
            InitMediaObject(OUT m_PlayMediaObject);
            m_PlayMediaObject.objectID = (tObjectID)handle;
            m_PlayMediaObject.deviceID = mediaObject.deviceID;
            strncpy_r(OUT m_PlayMediaObject.mountPoint, IN mediaObject.mountPoint, IN sizeof(m_PlayMediaObject.mountPoint));
            m_Mutex.unlock();

            char *pMountPointURL = new char[sizeof(tURL)];      // will be deleted by the thread function
            strncpy_r(OUT pMountPointURL, IN mountPointURL, IN sizeof(tURL));

            /*Create a worker thread to read metadata from file */
            LocalSPM::GetThreadFactory().Do(IN this, FUNCTION_ID_READMETADATA_FOR_PLAYBACK, (void*)pMountPointURL); //lint -e429 freed by calling thread
#else
            /* Update media object to play */
            InitMediaObject(OUT mediaObject);
            mediaObject.objectID = (tObjectID)handle;

            ret = LocalSPM::GetDBManager().GetFileFormat(OUT mediaObject.fileFormat, OUT mediaObject.fileType, IN mountPointURL);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("unable to get file format for the url : %s", mountPointURL));
            }
            else
            {
                if(FT_VIDEO == mediaObject.fileType ) /*Read video metadata*/
                {
                    ReadVideoMetadataFromFile(INOUT mediaObject, IN mountPointURL);
                }
                else /*Read audio metadata*/
                {
                    ReadAudioMetadataFromFile(INOUT mediaObject, IN mountPointURL);
                }
            }

            /* Send METADATA_FOR_PLAYBACK message to own SM */
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);

            ret = ParameterMETADATA_FOR_PLAYBACK(OUT parameterString, IN size, IN handle, IN mountPointURL);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                parameterString[0] = '\0';
            }

            ret = SendEvent(METADATA_FOR_PLAYBACK, IN parameterString);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
#endif
        }
    }
    else
    {
        /* Send NOW_PLAYING_STATUS message to PlayerManger to update nowPlaying info of object */
        char messageString[64];
        strncpy_r(OUT messageString, IN "PlayerManagerSM::NOW_PLAYING_STATUS", IN sizeof(messageString));
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = LocalSPM::GetPlayerManager().ParameterNOW_PLAYING_STATUS(OUT parameterString,
                IN size,
                IN handle,
                IN mediaObject.MetadataField1,
                IN mediaObject.MetadataField2,
                IN mediaObject.MetadataField3,
                IN mediaObject.MetadataField4,
                IN mediaObject.title,
                IN mediaObject.mediaType,
                IN mediaObject.bitRate,
                IN mediaObject.sampleRate,
                IN mediaObject.audioChannelFormat,
                IN mediaObject.metadataConvertFlag,
                IN NULL,
                IN NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult USBControl::ForwardNowPlayingStatusWithMetadata(const tPEHandle handle, const tURL mountPointURL)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(mountPointURL);

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();
    tMediaObject mediaObject = m_PlayMediaObject;
    m_Mutex.unlock();

    if((tObjectID)handle != mediaObject.objectID)
    {
        ETG_TRACE_ERR(("Received metadata of wrong object (objectID (received/expected):%u/%u)", (tObjectID)handle, mediaObject.objectID));
        return MP_NO_ERROR;
    }

    /* Send NOW_PLAYING_STATUS message to PlayerManger to update nowPlaying info of object */
    char messageString[64];
    strncpy_r(OUT messageString, IN "PlayerManagerSM::NOW_PLAYING_STATUS", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetPlayerManager().ParameterNOW_PLAYING_STATUS(OUT parameterString,
            IN size,
            IN handle,
            IN mediaObject.MetadataField1,
            IN mediaObject.MetadataField2,
            IN mediaObject.MetadataField3,
            IN mediaObject.MetadataField4,
            IN mediaObject.title,
            IN mediaObject.mediaType,
            IN mediaObject.bitRate,
            IN mediaObject.sampleRate,
            IN mediaObject.audioChannelFormat,
            IN mediaObject.metadataConvertFlag,
            IN NULL,
            IN NULL);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult USBControl::PlaytimeStatusNew(const tPEHandle handle, const tPETimeInfo timeInfo)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(timeInfo);

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();
    tDeviceID deviceID = m_PlayMediaObject.deviceID;
    m_Mutex.unlock();

    /* Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetDeviceDispatcher().ParameterPLAYTIME_STATUS(OUT parameterString, IN size, IN handle, IN deviceID, IN timeInfo);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::ForwardPlaytimeStatusNew(const tPEHandle handle, const tPETimeInfo timeInfo)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(timeInfo);

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();
    tObjectID objectID = m_PlayMediaObject.objectID;
    tDeviceID deviceID = m_PlayMediaObject.deviceID;
    m_Mutex.unlock();

    if ((tObjectID)handle != objectID)
    {
        ETG_TRACE_ERR(("Obsolete playtime status -> Do not forward objectID:%u", (tObjectID)handle));
    }
    else
    {
        /* Send PLAYTIME_STATUS message to PlayerManger to update playtime */
        char messageString[64];
        strncpy_r(OUT messageString, IN "PlayerManagerSM::PLAYTIME_STATUS", IN sizeof(messageString));
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = LocalSPM::GetPlayerManager().ParameterPLAYTIME_STATUS(OUT parameterString, IN size, IN handle, IN deviceID, IN timeInfo);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    /*If the device is in scanning Mode and the elapsed crossed to configured scan time,
      then inform PlayerManagerSM as if the track is finished.
      Thus tracks will be scanned*/
    if(m_ScanMode)
    {
        /* Unmarshal string of timeInfo into the corresponding struct */
        tPETimeInfoStruct timeInfoStruct;
        SMF::UnMarshal(IN timeInfo,
                IN DOUBLE_MARSHAL_SEPARATOR,
                IN tPEBytes_format tPEPercentage_format tPEMilliseconds_format tPEBytes_format tPEMilliseconds_format,
                OUT &timeInfoStruct.position.bytes,
                OUT &timeInfoStruct.position.pct,
                OUT &timeInfoStruct.position.ms,
                OUT &timeInfoStruct.duration.bytes,
                OUT &timeInfoStruct.duration.ms);

        if(timeInfoStruct.position.ms > (tPEMilliseconds)LocalSPM::GetDataProvider().TrackScanTime())
        {
            tAllParameters parameterString_1;
            size_t size_1 = sizeof(parameterString_1);

            /* Send PLAYBACK_STATUS message to PlayerManger to update playback status */
            char messageString_1[64];
            strncpy_r(OUT messageString_1, IN "PlayerManagerSM::PLAYBACK_STATUS", IN sizeof(messageString_1));

            ret = LocalSPM::GetPlayerManager().ParameterPLAYBACK_STATUS(OUT parameterString_1, IN size_1, IN handle, IN PE_PBS_FINISHEDSTATE, IN REASON_NONE, IN ME_SPEED_NORMAL);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            }
            else
            {
                ret = Dispatcher::GetInstance().SendMessage(IN messageString_1, IN parameterString_1);
                if (MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
                }
            }
        }
    }

    return ret;
}

tResult USBControl::HandleAnswerTimeout()
{
    ENTRY
    ETG_TRACE_ERR(("USBControl::HandleAnswerTimeout"));

    tResult ret = MP_NO_ERROR;

    /* Send releasing event to own waiting state machine */
    ret = ReleaseWaiting();
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while releasing waiting via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult USBControl::MessageNotConsumed()
{
    ENTRY
    ETG_TRACE_ERR(("USBControl::MessageNotConsumed"));
#if 0 //Do not SendAnswer without reason, it may cause failure within communication to DeviceDispatcher
    /* Send answer to possible waiting state machine to release own SM in case of message answer pair*/
    tResult ret = SendAnswer(NULL);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }
#endif
    return MP_NO_ERROR;
}

tResult USBControl::ValidateErrorCode(me::reason_e &reason, const tMetadata errorCode, const tMountPoint mountPoint) const
{
    ENTRY_INTERNAL

    tUInt errorEnum = atoi(errorCode);

    switch(errorEnum)
    {
        case MEDIAPLAYER_ERROR_DEVICE_NOT_FOUND:
        case MEDIAPLAYER_ERROR_AUDIO_DEVICE_ALREADY_IN_USE:
            reason = REASON_DEVICE_ERROR;
            break;
        case MEDIAPLAYER_ERROR_FILE_DOES_NOT_EXISTS:
        case MEDIAPLAYER_ERROR_CANNOT_DECODE_MEDIA:
        case MEDIAPLAYER_ERROR_UNKNOWN_ERROR:
        default:
            reason = REASON_FORMAT_ERROR;
            break;
    }

    if(REASON_FORMAT_ERROR == reason)
    {
        /*check if read request on device related to this mount point is possible*/
        if(!LocalSPM::GetDataProvider().checkIfDeviceConnected(mountPoint))
        {
            reason = REASON_DEVICE_ERROR;
        }
    }

    return MP_NO_ERROR;
}

tResult USBControl::SetOutputDevice(const tAudioOutputDevice audioOutputDevice)
{
    ENTRY
    VARTRACE(audioOutputDevice);

    /* Store audio output device (alsa device name) internally */
    strncpy_r(OUT m_AudioOutputDevice, IN audioOutputDevice, IN sizeof(m_AudioOutputDevice));

    return MP_NO_ERROR;
}

tResult USBControl::SendPlaybackStatus(const tPEHandle handle, const tPEPlaybackState playbackState, const me::reason_e reason, const me::speed_e speed)
{
    ENTRY
    //VARTRACE(handle);
    //VARTRACE(playState);
    //VARTRACE(reason);
    //VARTRACE(speed);

    tResult ret = MP_NO_ERROR;

    /* Send PLAYBACK_STATUS event to own state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
#if 0
    tPEPlaybackState playbackState;
    switch(playState)
    {
        case PE_PS_STOP:
            playbackState = PE_PBS_STOPPEDSTATE;
            break;
        case PE_PS_PAUSE:
            playbackState = PE_PBS_PAUSEDSTATE;
            break;
        case PE_PS_PLAY:
            if(0 > speed)
            {
                playbackState = PE_PBS_FASTREVERSESTATE;
            }
            else if(1 < speed)
            {
                playbackState = PE_PBS_FASTFORWARDSTATE;
            }
            else
            {
                playbackState = PE_PBS_PLAYINGSTATE;
            }
            break;
        case PE_PS_NOP:
        default:
            playbackState = PE_PBS_ERRORSTATE;
            break;
    }
#endif

    ret = ParameterPLAYBACK_STATUS(OUT parameterString, IN size, IN handle, IN playbackState, IN reason, IN speed);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(PLAYBACK_STATUS, IN parameterString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult USBControl::SendNowPlayingStatus(const tPEHandle handle, const tURL mountPointURL)
{
    ENTRY
    //VARTRACE(handle);
    //VARTRACE(mountPointURL);

    tResult ret = MP_NO_ERROR;

    /* Send NOW_PLAYING_STATUS event to own state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    ret = ParameterNOW_PLAYING_STATUS(OUT parameterString, IN size, IN handle, IN mountPointURL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(NOW_PLAYING_STATUS, IN parameterString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult USBControl::SendPlaytimeStatus(const tPEHandle handle, const tPETimeInfoStruct timeInfoStruct)
{
    ENTRY
    //VARTRACE(handle);
    //VARTRACE(timeInfoStruct);

    tResult ret = MP_NO_ERROR;

    /* Marshal struct of timeInfo into a string */
    tPETimeInfo timeInfoString;
    size_t size = sizeof(timeInfoString);
    SMF::Marshal(OUT timeInfoString,
            IN size-1,
            IN DOUBLE_MARSHAL_SEPARATOR,
            IN tPEBytes_format tPEPercentage_format tPEMilliseconds_format tPEBytes_format tPEMilliseconds_format,
            IN timeInfoStruct.position.bytes,
            IN timeInfoStruct.position.pct,
            IN timeInfoStruct.position.ms,
            IN timeInfoStruct.duration.bytes,
            IN timeInfoStruct.duration.ms);

    /* Send PLAYTIME_STATUS event to own state machine */
    tAllParameters parameterString;
    size = sizeof(parameterString);
    ret = ParameterPLAYTIME_STATUS(OUT parameterString, IN size, IN handle, IN timeInfoString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(PLAYTIME_STATUS, IN parameterString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}


//Indexing part

tResult USBControl::IsInitRequired(const tDeviceInfoString deviceInfoString)
{
    ENTRY;
    tDeviceInfo deviceInfo;
    DataProvider::UnMarshalDeviceInfo(deviceInfoString, deviceInfo);
    VARTRACE2(deviceInfo.mountPoint, deviceInfo.deviceID);
    VARTRACE(deviceInfo.numberOfAudioFiles);

    /* Search for scan context of device */
    for( tUInt i = 0; i < m_ScanContext.size(); i++ )
    {
        if( deviceInfo.deviceID == m_ScanContext[i].deviceID )
        {
            ETG_TRACE_ERR(("Error: We should not get an INIT event for an already known device"));

            /* Release temporary lists and remove device from internal scan context */
            RemoveDeviceFromContext(i);
            break;
        }
    }

    /* Create new context for current device*/
    tScanContext scanContextElem;
    InitScanContext(OUT scanContextElem);
    scanContextElem.deviceID = deviceInfo.deviceID;


    //1st audio file scan needed only for MassStorageDevices.Reason-Videos,images possible only in such devices.MusicBox donot have it
    //Note:
    //If DBFileListWhileIndexing is enabled,then deviceInfo.numberOfAudioFiles is based on FingerPrint result also i.e  not ONLY based on mediaobject flush.
    //Hence,though no flush occured,if count is valid,we donot search for 1st audio Item
    if(IsMassStorageDevice(deviceInfo.deviceType))
    {
        if(deviceInfo.numberOfAudioFiles == NUMBER_OF_FILES_NONE)
        {
            scanContextElem.firstAudioFileScanStatus = AVAILABILITY_UNKNOWN;
        }
        else
        {
            scanContextElem.firstAudioFileScanStatus = AVAILABLE;
        }
    }
    //else By default firstAudioFileScanStatus is IGNORE_AVAILABILITY_CHECK

    m_ScanContext.push_back(scanContextElem);

    /* In case of USB no initialization is necessary -> return NoInitAnswer (former false case) */
    return NoInitAnswer(IN deviceInfoString);
}

tResult USBControl::SendInitInit(const tDeviceInfoString deviceInfoString)
{
    ENTRY;
    tDeviceInfo deviceInfo;
    DataProvider::UnMarshalDeviceInfo(deviceInfoString, deviceInfo);
    VARTRACE2(deviceInfo.mountPoint, deviceInfo.deviceID);

    //tResult ret = MP_NO_ERROR;

    /* For USB no implementation */
#if 0
    /* Send INIT_DEVICE event to own state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = ParameterINIT_DEVICE(OUT parameterString, IN size, IN deviceInfo.mountPoint);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(INIT_DEVICE, IN parameterString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }
#endif

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::NoInitAnswer(const tDeviceInfoString deviceInfoString)
{
    ENTRY;
    tDeviceInfo deviceInfo;
    DataProvider::UnMarshalDeviceInfo(deviceInfoString, deviceInfo);
    VARTRACE2(deviceInfo.mountPoint, deviceInfo.deviceID);

    tResult ret = MP_NO_ERROR;

    /* Send INIT_DEVICE_CONNECTION message to IndexerSM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tConnectionState connectionState = CS_CONNECTED;

    ret = LocalSPM::GetIndexer().ParameterDEVICE_INITIALIZED(OUT parameterString, IN size, IN deviceInfo.deviceName, IN deviceInfo.deviceID, IN connectionState);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = LocalSPM::GetIndexer().SendEventByName("DEVICE_INITIALIZED", IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult USBControl::IsInitDeviceConnection(const tMountPoint mountPoint) const
{
    ENTRY
    VARTRACE(mountPoint);

    /* For USB no implementation -> return false */
    return false;
}

tResult USBControl::Disconnect(const tMountPoint mountPoint) const
{
    ENTRY
    VARTRACE(mountPoint);

    /* For USB no implementation */
    return MP_NO_ERROR;
}

tResult USBControl::OnDeviceInitialized(const tMountPoint mountPoint, const tConnectionState connectionState) const
{
    ENTRY
    VARTRACE(mountPoint);
    VARTRACE(connectionState);

    /* For USB no implementation */
    return MP_NO_ERROR;
}

tResult USBControl::GetNumberOfFiles(const tDeviceID deviceID)
{
    //Device type is not supported for indexing, nevertheless indexer requires the total number of playable files from this device
    //Added for VAG iPod streaming

    ENTRY;
    VARTRACE(deviceID);

    tNumberOfFiles numberOfFiles = 0; //TODO: return total number of files here

    /* Send ANSWER message to IndexerSM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    if( deviceID == MUSICBOX_DEVICE_ID)
    {
        LocalSPM::GetDBManager().GetNumberOfAudioFiles(OUT numberOfFiles, IN deviceID);
    }
    LocalSPM::GetIndexer().ParameterNUMBER_OF_FILES_ANSWER(OUT parameterString, IN size, IN deviceID, IN numberOfFiles);
    SendAnswer(IN parameterString);

    return MP_NO_ERROR;
}

tResult USBControl::CalcFingerprint(const tMountPoint mountPoint, const tDeviceID deviceID, const tFingerprint lastFingerprint)
{
    ENTRY
    VARTRACE2(mountPoint, deviceID);
    VARTRACE(lastFingerprint);

    tResult ret = MP_NO_ERROR;

    ResetStopFingerprint();

    tFingerprint fingerprint = {0};
    tFingerprintStatus fingerprintStatus = FPS_NOT_AVAIL;
    tNumberOfFiles numberOfFiles = NUMBER_OF_FILES_NONE;

    /* Get fingerprint from scan context if available */
    for( tUInt i = 0; i < m_ScanContext.size(); i++ )
    {
        if( deviceID == m_ScanContext[i].deviceID )
        {
            //store last fingerprint from DB
            strncpy_r(OUT m_ScanContext[i].lastFingerprint, IN lastFingerprint, IN sizeof(m_ScanContext[i].lastFingerprint));

            //get the current parameter from context
            strncpy_r(OUT fingerprint, IN m_ScanContext[i].fingerprint, IN sizeof(fingerprint));
            fingerprintStatus = m_ScanContext[i].fingerprintStatus;
            numberOfFiles = m_ScanContext[i].numberOfFiles;
            break;
        }
    }

    if(FPS_OK != fingerprintStatus)
    {
        /* Start fingerprint calculation thread only if no calculation for the same mount point is running */
        m_Mutex.lock();
        tMountPoint currentMountPoint;
        strncpy_r(OUT currentMountPoint, IN m_FingerprintMountPoint, IN sizeof(currentMountPoint));
        m_Mutex.unlock();

        if(0 != strcmp(currentMountPoint, mountPoint))
        {
            /* Use helper function to marshal parameters */
            //string length = length of mount point + separator + max int length + separator + length of fingerprint + separator + null termination
            tUInt stringLen = strlen_r(mountPoint)+1+16+1+strlen_r(lastFingerprint)+1+1;
            char *parameterString = new char[stringLen];
            parameterString[0] = 0;

            ret = ParameterGET_FINGERPRINT(OUT parameterString, IN stringLen, IN mountPoint, IN deviceID, IN lastFingerprint);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            }

            /* Store  mount point used for fingerprint calculation */
            m_Mutex.lock();
            strncpy_r(OUT m_FingerprintMountPoint, IN mountPoint, IN sizeof(m_FingerprintMountPoint));
            m_Mutex.unlock();

            /* Spawn worker thread for fingerprint calculation */
            LocalSPM::GetThreadFactory().Do(this, FUNCTION_ID_CALCFINGERPRINT, (void *)parameterString, this); //lint -e429 freed by calling thread
        }
        else
        {
            ETG_TRACE_USR3(("Fingerprint calculation is already running for same moint point: %s", currentMountPoint));
        }
    }

    //Dennis Xu:If no fingerprint stored in DB, indexing will do anyway
    //Send an invalid fingerprint to Indexer will wake up the indexing, song list could start to show immediately
    //Later when fingerprint is calculated, it will be sent to Indexer through OnFingerprintUpdate
    tFingerprint storedFingerprint = {0};
    ret = LocalSPM::GetDBManager().GetFingerprint(OUT storedFingerprint, IN deviceID);
    VARTRACE(storedFingerprint);

    tNumberOfFiles numberOfPlayableFiles = 0;
    ret = LocalSPM::GetDBManager().GetNumberOfPlayableFiles(OUT numberOfPlayableFiles, IN deviceID);
    VARTRACE(numberOfPlayableFiles);

    //TODO(pee1cob):condition numberOfPlayableFiles <= 0 used below.
    //If SeperateMediaContent Enabled,consider video,image file count too.If video,image are also invalid,ONLY then go for "Blind ReIndexing"
    if (FPS_OK == fingerprintStatus || strcmp(storedFingerprint, FINGERPRINT_INVALID) == 0 || (int)numberOfPlayableFiles <= 0)
    {
        /* Send PUT_FINGERPRINT event to own state machine */
       SendPutFingerprint(IN fingerprint, IN fingerprintStatus, IN numberOfFiles, IN deviceID);
    }

    return ret;
}

tResult USBControl::ResetFingerprintMountPoint()
{
    ENTRY

    m_Mutex.lock();
    m_FingerprintMountPoint[0] = '\0';
    m_Mutex.unlock();

    return MP_NO_ERROR;
}

void USBControl::ResetStopFingerprint()
{
    ENTRY

    fingerprintLock.lock();
    stopFingerprint = false;
    fingerprintLock.unlock();
}

void USBControl::SetStopFingerprint()
{
    ENTRY

    fingerprintLock.lock();
    stopFingerprint = true;
    fingerprintLock.unlock();
}

tResult USBControl::OnFingerprint(const tFingerprint fingerprint,
        const tFingerprintStatus fingerprintStatus,
        const tNumberOfFiles numberOfFiles,
        const tDeviceID deviceID)
{
    ENTRY
    VARTRACE(fingerprint);
    VARTRACE(fingerprintStatus);
    VARTRACE(numberOfFiles);
    VARTRACE(deviceID);

    tResult ret = MP_NO_ERROR;

    /* Store fingerprint in scan context */
    for( tUInt i = 0; i < m_ScanContext.size(); i++ )
    {
        if( deviceID == m_ScanContext[i].deviceID )
        {
            strncpy_r(OUT m_ScanContext[i].fingerprint, IN fingerprint, IN sizeof(m_ScanContext[i].fingerprint));
            m_ScanContext[i].fingerprintStatus = fingerprintStatus;
            m_ScanContext[i].numberOfFiles = numberOfFiles;

            /* check for matching fingerprint */
#if 0 //Do not use stored scan context because feature ContinueIndexing is not working at all
            if(fingerprint[0] != 0 && !strcmp(fingerprint, m_ScanContext[i].lastFingerprint))
            {
                /* Load last mode of scan context for device from DB */
                ret = LocalSPM::GetDBManager().GetScanContext(OUT m_ScanContext[i], IN deviceID);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while getting scan context from DB for deviceID:%u (ErrorCode:%s)", deviceID , errorString(ret)));
                }
            }
            else
            {
#endif
                /* Different fingerprint - remove obsolete last mode of scan context for a given device in DB */
                ret = LocalSPM::GetDBManager().RemoveScanContext(IN deviceID);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while removing scan context in DB for deviceID:%u (ErrorCode:%s)", m_ScanContext[i].deviceID, errorString(ret)));
                }
                //            }
                break;
            }
        }

        /* Send FINGERPRINT_AVAIL message to IndexerSM */
        char messageString[64];
        strncpy(messageString, "IndexerSM::FINGERPRINT_AVAIL", sizeof(messageString) - 1);
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = LocalSPM::GetIndexer().ParameterFINGERPRINT_AVAIL(OUT parameterString,
                IN size,
                IN fingerprint,
                IN fingerprintStatus,
                IN numberOfFiles,
                IN deviceID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        //ret = SendAnswer(IN parameterString);
        ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }

        //Don't return an error in a transaction because we will not switch to new state even though we already did the action
        return MP_NO_ERROR;
    }

    tResult USBControl::IsNextMetadataAvailable(const tMountPoint mountPoint, const tReadPosition readPosition, const tDeviceID deviceID)
    {
        ENTRY
        VARTRACE2(mountPoint, deviceID);
        VARTRACE(readPosition);

        /* Return false always because we have no metadata cache */
        return false;
    }

    tResult USBControl::RetrieveMetadataFromDevice(const tMountPoint mountPoint, const tReadPosition readPosition, const tDeviceID deviceID)
    {
        ENTRY
        //VARTRACE2(mountPoint, deviceID);
        (void)readPosition;

        tResult ret = MP_NO_ERROR;
        tMetadataStatus metadataStatus = MDS_SUCCESS;

        tReadPosition localReadPosition = {0};
#if 0
        if(0 < strlen_r(readPosition))
        {
            /* Take only path of filename as read position */
            FastUTF8::tString localPath;
            FastUTF8::tString fileName;

            localPath = (FastUTF8::tString)strdup(readPosition);
            FastUTF8::Split(OUT fileName, INOUT localPath); //Split full name into filename and path
            strncpy_r(OUT localReadPosition, IN (const char *)localPath, IN sizeof(localReadPosition));
            free(localPath);
        }
#endif

        /* Check if scan context of device is available */
        tIndex deviceIndex = INDEX_NONE;
        for( tUInt i = 0; i < m_ScanContext.size(); i++ )
        {
            if( deviceID == m_ScanContext[i].deviceID )
            {
                deviceIndex = i;
                break;
            }
        }
        if( INDEX_NONE != deviceIndex )
        {
            if(LocalSPM::GetDataProvider().CollectMetadata())
            {
                tBoolean isScanForAnyFileTypeNeeded = true;

                //If device scanning for 1 audioItem not yet done,then scan for it and index the same
                if(AVAILABILITY_UNKNOWN == m_ScanContext[deviceIndex].firstAudioFileScanStatus)
                {
                    ETG_TRACE_USR3(("Scan for 1st Audio File"));

                    /* Get audio object to Index from virtual file list */
                    ret = GetNextObjectToIndex(OUT metadataStatus, IN deviceIndex, IN mountPoint, IN localReadPosition,IN FT_AUDIO);

                    if((MP_NO_ERROR == ret) && (MDS_SUCCESS == metadataStatus)) //AudioItem is ready as m_scanMediaObject.
                    {
                        //Launch Worker thread to collect Metadata
                        CollectData(IN mountPoint);

                        //Upon scanning,1 audio item found.Remember it
                        m_ScanContext[deviceIndex].firstAudioFileScanStatus = AVAILABLE;

                        tMediaObject mediaObject =  GetScanMediaObject();
                        strncpy_r(OUT m_ScanContext[deviceIndex].firstScannedAudioFileName, IN mediaObject.fileName, IN sizeof(m_ScanContext[deviceIndex].firstScannedAudioFileName));

                        ETG_TRACE_USR3(("1st Audio Item found in device Scanning is set for indexing:"));
                        VARTRACE(m_ScanContext[deviceIndex].firstScannedAudioFileName);

                        //Forget scan done now.Reason-To Restart Indexing of the Device for all FileTypes upon next GET_METADATA request
                        ForgetScan(IN deviceIndex);

                        isScanForAnyFileTypeNeeded = false;
                    }
                    else if(MDS_FINISHED == metadataStatus)
                    {
                        //Upon scanning,no audio item found.i.e Device Has no audio content in it
                        ETG_TRACE_USR3(("No Audio Item Available in device Scanning.Begine Scanning for any FileType"));

                        m_ScanContext[deviceIndex].firstAudioFileScanStatus = NOT_AVAILABLE;


                        //Forget scan done now.Reason-To Restart Indexing of the Device for all FileTypes for this GET_METADATA request
                        ForgetScan(IN deviceIndex);
                    }
                    else
                    {
                        //Error occured while searching for an Audio Item in device:It may be
                        //If MDS_DEVICE_ERROR,then Resume 1 audio file search upon next GET_METADATA request
                        //If MDS_FILE_ERROR,then Resume 1 audio file search upon next GET_METADATA request
                        //If MDS_FINISHED_RECURSIVE_EMERGENCY_BREAK,then Device Indexing considered as FINISHED!
                        isScanForAnyFileTypeNeeded = false;
                    }

                    VARTRACE(ret);
                    VARTRACE(metadataStatus);
                    VARTRACE(m_ScanContext[deviceIndex].firstAudioFileScanStatus);
                }

                if(true == isScanForAnyFileTypeNeeded)
                {
                    /* Get next media object from virtual file list */
                    ret = GetNextObjectToIndex(OUT metadataStatus, IN deviceIndex, IN mountPoint, IN localReadPosition);

                    if((MP_NO_ERROR == ret) && (MDS_SUCCESS == metadataStatus)) //Audio/Video/Image is ready as m_scanMediaObject.how playlist treated ?!
                    {
                        //Skip to Next item,if it is same as the First Audio File Indexed
                        tMediaObject mediaObject = GetScanMediaObject();
                        if((mediaObject.fileType == FT_AUDIO) && (0 == strncmp(m_ScanContext[deviceIndex].firstScannedAudioFileName,mediaObject.fileName,sizeof(mediaObject.fileName))))
                        {
                            ETG_TRACE_USR4(("Next Object to Index == 1st Audio Item Already Indexed.Skip its Indexing"));

                            /* Get next media object from virtual file list */
                            ret = GetNextObjectToIndex(OUT metadataStatus, IN deviceIndex, IN mountPoint, IN localReadPosition);

                            if((MP_NO_ERROR == ret) && (MDS_SUCCESS == metadataStatus)) //Audio/Video/Image is ready as m_scanMediaObject.how playlist treated ?!
                            {
                                CollectData(IN mountPoint);
                            }
                        }
                        else
                        {
                            CollectData(IN mountPoint);
                        }
                    }
                }
                VARTRACE(ret);
            }
            else
            {
                ETG_TRACE_USR4(("Metadata Extraction is disabled"));
                metadataStatus = MDS_FINISHED;
            }
        }
        else
        {
            ETG_TRACE_ERR(("No scan context for deviceID: %u", deviceID));
            metadataStatus = MDS_DEVICE_ERROR;
        }

        if((MDS_DEVICE_ERROR == metadataStatus)||
                (MDS_FILE_ERROR == metadataStatus)||
                (MDS_FINISHED == metadataStatus)||
                (MDS_FINISHED_RECURSIVE_EMERGENCY_BREAK == metadataStatus)||
                (MP_NO_ERROR != ret)/*this occurs only when recursionEmergencyBreakDepth goes above 1)*/)
        {
            //If MDS_FINISHED,then Device Scanning is completed for all fileTypes.
            //If MDS_FINISHED_RECURSIVE_EMERGENCY_BREAK,then Device Scanning is ended forcefully.
            //Both cases "Do not try to Scan the Device ANYMORE in this connection" - Hence remove device from Context
            if((MDS_FINISHED == metadataStatus) || (MDS_FINISHED_RECURSIVE_EMERGENCY_BREAK == metadataStatus))
            {
                RemoveDeviceFromContext(deviceIndex);
            }

            /* Send PUT_METADATA to own SM */
            tMediaObjectPtr mediaObjectPtr = NULL;
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);

            ret = ParameterPUT_METADATA(OUT parameterString, IN size, IN metadataStatus, IN mediaObjectPtr);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                parameterString[0] = '\0';
            }

            ret = SendEvent(PUT_METADATA, IN parameterString);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
        //Don't return an error in a transaction because we will not switch to new state even though we already did the action
        return MP_NO_ERROR;
    }

    tResult USBControl::SendPutMetadata(const tMountPoint mountPoint, const tReadPosition readPosition, const tDeviceID deviceID)
    {
        ENTRY
        VARTRACE2(mountPoint, deviceID);
        VARTRACE(readPosition);

        tResult ret = MP_NO_ERROR;

        /* Send PUT_METADATA message to own SM */
        tMetadataStatus metadataStatus = MDS_SUCCESS;
        tMediaObjectPtr mediaObjectPtr = NULL;

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = ParameterPUT_METADATA(OUT parameterString, IN size, IN metadataStatus, IN mediaObjectPtr);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(PUT_METADATA, IN parameterString);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }

        //Don't return an error in a transaction because we will not switch to new state even though we already did the action
        return MP_NO_ERROR;
    }

    tResult USBControl::SendPutMetadata(const tMetadataStatus metadataStatus,const tMediaObjectPtr mediaObjectPtr)
    {
        ENTRY

        tResult ret = MP_NO_ERROR;

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = ParameterPUT_METADATA(OUT parameterString, IN size, IN metadataStatus, IN mediaObjectPtr);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("SendPutMetadata:Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(PUT_METADATA, IN parameterString);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("SendPutMetadata:Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }

        return MP_NO_ERROR;
    }

    tResult USBControl::AnswerMetadata(const tMetadataStatus metadataStatus, tMediaObjectPtr mediaObjectPtr)
    {
        ENTRY
        VARTRACE(metadataStatus);

        tResult ret = MP_NO_ERROR;

        /* Copy media object */
        if(MDS_SUCCESS == metadataStatus)
        {
            if(NULL == mediaObjectPtr)
            {
                mediaObjectPtr = new tMediaObject; //Attention: Has to be deleted by Indexer::CheckMetadata
            }
            if(NULL != mediaObjectPtr)
            {
                InitMediaObject(OUT *mediaObjectPtr);
                *mediaObjectPtr = GetScanMediaObject();
            }
        }

        /* Send answer to waiting state machine */
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = LocalSPM::GetIndexer().ParameterMETADATA_ANSWER(OUT parameterString,
                IN size,
                IN mediaObjectPtr, //lint -e429 freed by calling thread
                IN metadataStatus);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
            if(NULL != mediaObjectPtr)
            {
                delete mediaObjectPtr;
            }
        }

        ret = SendAnswer(IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
        }

        //Don't return an error in a transaction because we will not switch to new state even though we already did the action
        return MP_NO_ERROR;
    }

    tResult USBControl::RetrieveMetadataFromCache(tMetadata &metadata) const
    {
        /* Obsolete: DeviceControl is sending a media object instead of a metatdata string so an assembly is not necessary */
        ENTRY
        (void)metadata;
        return MP_NO_ERROR;
    }

    tResult USBControl::RemoveDeviceConnection(const tMountPoint mountPoint, const tDeviceID deviceID)
    {
        ENTRY
        VARTRACE2(mountPoint, deviceID);

        tResult ret = MP_NO_ERROR;

        SetStopFingerprint();

        /* Delete related VTFile cache */
        ret = LocalSPM::GetDBManager().DeleteVTFileCache(IN deviceID);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while deleting VTFile cache for deviceID:%u (ErrorCode:%s)", deviceID, errorString(ret)));
        }

        /* Store last mode of scan context for a given device in DB */
        for( tUInt i = 0; i < m_ScanContext.size(); i++ )
        {
            if( deviceID == m_ScanContext[i].deviceID )
            {
#if 0 //Do not use stored scan context because feature ContinueIndexing is not working at all
                ret = LocalSPM::GetDBManager().RemoveScanContext(IN m_ScanContext[i].deviceID);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while removing scan context in DB for deviceID:%u (ErrorCode:%s)", m_ScanContext[i].deviceID, errorString(ret)));
                }

                ret = LocalSPM::GetDBManager().StoreScanContext(IN m_ScanContext[i]);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while storing scan context in DB for deviceID:%u (ErrorCode:%s)", m_ScanContext[i].deviceID, errorString(ret)));
                }
#endif
                /* Release temporary lists and remove device from internal scan context */
                ret = RemoveDeviceFromContext(i);
                break;
            }
        }

        return ret;
    }

    //AlbumArt part
    tMimeType ConvertMimeType(const char* mimeType)
    {
        if((!strcmp(mimeType,"image/png")) || (!strcmp(mimeType,".png")))
            return MMT_PNG;

        if((!strcmp(mimeType,"image/x-ms-bmp")) || (!strcmp(mimeType,".bmp")))
            return MMT_BMP;

        if((!strcmp(mimeType,"image/gif")) || (!strcmp(mimeType,".gif")))
            return MMT_GIF;

        if((!strcmp(mimeType,"image/jpeg")) || (!strcmp(mimeType,".jpg")))
            return MMT_JPG;

        ETG_TRACE_ERR(("Unknown mime type (%s)",mimeType));

        return MMT_PNG;
    }

    tResult USBControl::GetAlbumArt(const tAlbumArt albumArtString)
    {
        ENTRY
        VARTRACE(albumArtString);

        char *pAlbumArtString = new char[sizeof(tAlbumArt)];      // will be deleted by the thread function
        strncpy_r(OUT pAlbumArtString, IN albumArtString, IN sizeof(tAlbumArt));

        /*Create a worker thread to extract the album art */
        LocalSPM::GetThreadFactory().Do(IN this, FUNCTION_ID_ALBUMART, (void*)pAlbumArtString, this); //lint -e429 freed by calling thread

        //Don't return an error in a transaction because we will not switch to new state even though we already did the action
        return MP_NO_ERROR;
    }

    tResult USBControl::HandleGetAlbumArtAnswer(const tAlbumArtObjectPtr ptrToAlbumArtObject)
    {
        ENTRY

        tResult ret = MP_NO_ERROR;

        /*Send the album art data as answer to request GetAlbumArt (Note : requested from DataProvider)*/
        tAllParameters parameterString = {0};
        SMF::Marshal(IN parameterString, sizeof(parameterString)-1, "p",IN ptrToAlbumArtObject);

        ret = SendAnswer(IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
            if (ptrToAlbumArtObject)
            {
                if (ptrToAlbumArtObject->imageData)
                {
                    free(ptrToAlbumArtObject->imageData);
                }
                delete ptrToAlbumArtObject;
                ETG_TRACE_USR3(("AlbumArt buffer cleared"));
            }
        }

        //Don't return an error in a transaction because we will not switch to new state even though we already did the action
        return MP_NO_ERROR;
    }

    tResult USBControl::AlbumArtAnswerNotConsumed(const tAlbumArtObjectPtr ptrToAlbumArtObject)
    {
        ENTRY;

        if (ptrToAlbumArtObject)
        {
            if (ptrToAlbumArtObject->imageData)
            {
                free(ptrToAlbumArtObject->imageData);
            }
            delete ptrToAlbumArtObject;
            ETG_TRACE_USR3(("AlbumArt buffer cleared"));
        }

        return MP_NO_ERROR;
    }

    tResult USBControl::SendAlbumArtAnswer(const tAlbumArtObjectPtr ptrToAlbumArtObject)
    {
        ENTRY_INTERNAL;

        tResult ret = MP_NO_ERROR;

        /* Send GET_ALBUM_ART_ANSWER message to own SM */
        tAllParameters parameterString = {0};
        SMF::Marshal(IN parameterString, sizeof(parameterString)-1, "p", IN ptrToAlbumArtObject);

        ret = SendEvent(GET_ALBUM_ART_ANSWER, IN parameterString);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            if (ptrToAlbumArtObject)
            {
                if (ptrToAlbumArtObject->imageData)
                {
                    free(ptrToAlbumArtObject->imageData);
                }
                delete ptrToAlbumArtObject;
                ETG_TRACE_USR3(("AlbumArt buffer cleared"));
            }
        }

        return ret;
    }

    tResult USBControl::Umount(const tDeviceID deviceID, const tMountPoint mountPoint)
    {
        ENTRY;
        VARTRACE2(mountPoint, deviceID);

        tResult ret = MP_NO_ERROR;
        tErrorCode errorCode = MP_ERR_UMOUNT_ERROR;

        if(0 < strlen_r(mountPoint))
        {
#ifdef VARIANT_S_FTR_ENABLE_ROOTDAEMON_SERVER
            CmdData result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_CMD_UNMOUNT, IN mountPoint);
            ETG_TRACE_USR3(("Umount returned errno %d", result.errorNo));
            if(result.errorNo == ERR_NONE) {
                //success
                errorCode = MP_NO_ERROR;
            } else {
                //any other error on umount
                errorCode = MP_ERR_UMOUNT_ERROR;
            }
#endif
        }
        else
        {
            //umount for device is not required. Directly send MP_ERR_UMOUNT_ERROR as answer.
            ETG_TRACE_ERR(("mountPoint:%s is not valid",mountPoint));
        }

        /* Send answer to waiting state machine */
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        SMF::Marshal(parameterString, size - 1, "i", errorCode);

        ret = SendAnswer(IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
        }

        return ret;
    }

    tBoolean USBControl::IsBatchPlayable(const tDeviceID deviceID)
    {
        ENTRY;
        VARTRACE(deviceID);
        return 0;
    }

    void USBControl::SendPutFingerprint(const tFingerprint fingerprint, const tFingerprintStatus fingerprintStatus, const tNumberOfFiles numberOfFiles, const tDeviceID deviceID)
    {
        ENTRY
        VARTRACE(fingerprint);
        VARTRACE(fingerprintStatus);
        VARTRACE(numberOfFiles);
        VARTRACE(deviceID);

        ResetStopFingerprint();

        /* Send PUT_FINGERPRINT event to own state machine */
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        tResult ret = MP_NO_ERROR;

        ret = ParameterPUT_FINGERPRINT(OUT parameterString, IN size, IN fingerprint, IN fingerprintStatus, IN numberOfFiles, IN deviceID);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            memset(parameterString, 0, sizeof(parameterString));
        }

        ret = SendEvent(PUT_FINGERPRINT, IN parameterString);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    void USBControl::DoCalcFingerprintThread(const char *parameterString)
    {
        ENTRY
        ETG_TRACE_USR3(("Calculate fingerprint for USB in own thread"));

        tResult ret = MP_NO_ERROR;
        tFingerprint fingerprint = {0};
        tFingerprintStatus fingerprintStatus = FPS_NOT_AVAIL;
        tNumberOfFiles numberOfFiles = NUMBER_OF_FILES_NONE;
        tDeviceID deviceID = DEVICE_ID_NOT_SET;
        tReturnValue returnValue = TRUE;

        tAllParameters parameters;
        if(parameterString)
        {
            /* Unmarshal parameter string */
            tMountPoint mountPoint = {0};
            tFingerprint lastFingerprint = {0};

            SMF::UnMarshal(IN parameterString, tMountPoint_format tDeviceID_format tFingerprint_format, mountPoint , &deviceID, lastFingerprint);
            delete[] parameterString;

#ifdef TARGET_BUILD
            returnValue = CalculateQuickFingerprint(IN mountPoint, IN deviceID, IN lastFingerprint);
#else
            returnValue  = false;
#endif

            if (returnValue == TRUE)
            {
                ETG_TRACE_USR3(("Quick fingerprint is not changed, hence passed with Quick fingerprint"));
                // get the number of files from database and update the same
                ret = LocalSPM::GetDBManager().GetNumberOfPlayableFiles(OUT numberOfFiles, IN deviceID);
                fingerprintStatus = FPS_OK;
                VARTRACE(numberOfFiles);
            }
            else
            {
                ETG_TRACE_USR3(("Quick fingerprint is changed, hence complete fingerprint calculation is required"));

                /* Create temporary files */
                tFilename tmpFilenameInterim = {0};
                tFilename tmpFilenameResult = {0};

                if (exists_directory(m_FingerprintStorePath.c_str()) == 1)
                {
                    if(0 > GenerateTempFileName(tmpFilenameInterim, "FP_I", m_FingerprintStorePath.c_str()))
                    {
                        ETG_TRACE_ERR(("Cannot create temp file: %s", tmpFilenameInterim));
                    }
                    if(0 > GenerateTempFileName(tmpFilenameResult, "FP_R", m_FingerprintStorePath.c_str()))
                    {
                        ETG_TRACE_ERR(("Cannot create temp file: %s", tmpFilenameResult));
                    }
                }
                else
                {
                    ETG_TRACE_ERR(("USBControl::DoCalcFingerprintThread: m_FingerprintStorePath(/tmp/usb) doesn't exist"));
                }

                if((0 < strlen_r(tmpFilenameInterim)) && (0 < strlen_r(tmpFilenameResult)))
                {
                    /* Start time measurement */
                    timeval startTime;
                    timeval endTime;
                    unsigned long durationMS = 0L;
                    gettimeofday(&startTime, NULL);

                    /* Calculate free disk space */
                    TimeTrace ticks("CalcFingerprint");

                    char *commandStr[3] = {(char *)"/bin/df",mountPoint,NULL};
                    ETG_TRACE_USR4(("USBControl::DoCalcFingerprintThread: calling executeCommand() for df"));
                    int retStatus = executeCommand(commandStr,string(tmpFilenameInterim));
                    if(0 != retStatus)
                    {
                        ETG_TRACE_ERR(("USBControl::DoCalcFingerprintThread: executeCommand() failed for df. Error:%s",strerror(retStatus)));
                    }
                    else
                    {
                        ETG_TRACE_USR3(("USBControl::DoCalcFingerprintThread: executeCommand() success for df"));
                    }

                    ticks.elapsed();

                    /* Check used memory size on device */
                    tMemorySize usedMemory = 0; //1024-blocks -> 1GB = 976562
                    FILE * pFileInterim = fopen (tmpFilenameInterim, "r");
                    if(NULL == pFileInterim)
                    {
                        ETG_TRACE_ERR(("Cannot open file: %20s", tmpFilenameInterim));
                    }
                    else
                    {
                        char buffer[100];
                        if(NULL != fgets(buffer, sizeof(buffer), pFileInterim)) //read over the first line
                        {
                            if(NULL != fgets(buffer, sizeof(buffer), pFileInterim))
                            {
                                tPath filesystem;
                                tMemorySize totalMemory = 0;
                                tMemorySize freeMemory = 0;
                                sscanf(buffer,"%s %u %u %u", filesystem, &totalMemory, &usedMemory, &freeMemory);
                                ETG_TRACE_USR3(("totalMemory: %u, usedMemory: %u, freeMemory: %u, filesystem: %s", totalMemory, usedMemory, freeMemory, filesystem));
                            }
                            else
                            {
                                ETG_TRACE_ERR(("Cannot open string from stream to read first line: %s", tmpFilenameInterim));
                            }
                        }
                        else
                        {

                            ETG_TRACE_ERR(("Cannot open string from stream to read memory size: %s", tmpFilenameInterim));
                        }
                        fclose(pFileInterim);
                    }

                    /* Compare used memory of last fingerprint with new calculated one */
                    tMemorySize maxMemory = (tMemorySize)LocalSPM::GetDataProvider().IndexingFingerprintMaxMemory();
                    tFingerprint fingerprintShortcut = FINGERPRINT_SHORTCUT;
                    char *startPtr = strstr(lastFingerprint, fingerprintShortcut);
                    if( startPtr )
                    {
                        tMemorySize lastUsedMemory = atoi(startPtr + strlen_r(fingerprintShortcut));
                        if( lastUsedMemory == usedMemory ) //memory usage does not change
                        {
                            maxMemory = 0; //use shortcut again
                        }
                    }

                    /* If used memory is too large skip fingerprint calculation via "ls" */
                    if( maxMemory <= usedMemory )
                    {
                        if(0 == LocalSPM::GetDataProvider().SearchForFirstPlayableFile())
                        {
                            numberOfFiles = (tNumberOfFiles)LocalSPM::GetDataProvider().LimitNumberObjectsPerDevice();
                        }
                        fingerprintStatus = FPS_OK;
                        snprintf(fingerprint, sizeof(fingerprint)-1, "%s%u", fingerprintShortcut, usedMemory);
                        ETG_TRACE_USR3(("Fingerprint shortcut: numberOfFiles: %u, fingerprint: %s", numberOfFiles, fingerprint));
                    }
                    else
                    {
                        /* Calculate number of supported files on current device */
                        ticks.restart();

                        ret = ReadFilesForFingerprintCalc(tmpFilenameInterim, mountPoint);

                        fingerprintLock.lock();
                        bool stopCalcFingerprint = stopFingerprint;
                        fingerprintLock.unlock();

                        if((stopCalcFingerprint) || (ret == MP_ABORTED_CALCFINGERPRINT))
                        {
                            // Sending ABORT_INDEXING event to indexer SM to exit the waitingFor_checking state.
                            char msgToSendString[32];
                            strncpy_r(OUT msgToSendString, IN "IndexerSM::ABORT_INDEXING", IN sizeof(msgToSendString));
                            ret = Dispatcher::GetInstance().SendMessage(IN msgToSendString, (char *)NULL);
                            if (MP_NO_ERROR != ret)
                            {
                                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
                            }
                            int retValue = 0;
                            retValue = remove(tmpFilenameInterim);
                            if (0 != retValue)
                            {
                                ETG_TRACE_ERR(("Error in Deletion(tmpFilenameInterim): %s",strerror(errno)));
                            }
                            ticks.elapsed();
                            return;
                        }
                        ticks.elapsed();
                   }

                    commandStr[0]=(char *)"/usr/bin/md5sum";
                    commandStr[1]=tmpFilenameInterim;
                    commandStr[2]=NULL;
                    /* Calculate a hash value -> fingerprint */
                    ticks.restart();

                    ETG_TRACE_USR4(("USBControl::DoCalcFingerprintThread: calling executeCommand() for md5sum"));
                    retStatus = executeCommand(commandStr,string(tmpFilenameResult));

                    ticks.elapsed();

                    if(0 == retStatus)
                    {
                        ETG_TRACE_USR3(("USBControl::DoCalcFingerprintThread: executeCommand() success for md5sum"));
                        FILE * pFileResult = fopen (tmpFilenameResult, "r");
                        if(NULL == pFileResult)
                        {
                            ETG_TRACE_ERR(("Cannot open file: %20s", tmpFilenameResult));
                        }
                        else
                        {
                            /* NCG3D-103083: If used memory is too large fingerprint calculation via "ls" is skipped
                             * number of files taken from tmpFilenameResult will be 0.
                             * In this case, set the number of files to unknown -1.
                             * When first playable file is indexed, number of files will get updated to 1.
                             * Audio will be notified about the USB device with palayable content.
                             * Playabk will start if auto play is enabled.
                             */

                            if( maxMemory <= usedMemory )
                            {
                                numberOfFiles = -1; //set the number of files to unknown
                            }
                            else
                            {
                                numberOfFiles = m_NumberOfSupportedFiles;
                            }
                            VARTRACE(numberOfFiles);

                            if(NULL != fgets(fingerprint, sizeof(fingerprint), pFileResult))
                            {
                                /* Remove "  -" from fingerprint string */
                                char *pdest = strstr(fingerprint, " ");
                                if(pdest)
                                {
                                    *pdest = 0;
                                }
                                fingerprintStatus = FPS_OK;
                                VARTRACE(fingerprint);
                            }
                            else
                            {
                                ETG_TRACE_ERR(("Cannot open string from stream to read fingerprint: %s", tmpFilenameResult));
                            }
                            fclose(pFileResult);
                        }
                    }
                    else
                    {
                        ETG_TRACE_ERR(("USBControl::DoCalcFingerprintThread: executeCommand() failed for md5sum. Error:%s",strerror(retStatus)));
                    }

                    int retValue = 0;
                    retValue = remove(tmpFilenameInterim);
                    if (0 != retValue)
                    {
                        ETG_TRACE_ERR(("Error in Deletion(tmpFilenameInterim): %s",strerror(errno)));
                    }
                    retValue = remove(tmpFilenameResult);
                    if (0 != retValue)
                    {
                        ETG_TRACE_ERR(("Error in Deletion(tmpFilenameResult): %s",strerror(errno)));
                    }

                    /* Stop time measurement */
                    gettimeofday(&endTime, NULL);

                    /* Calculate the duration and sum it up */
                    durationMS += ((endTime.tv_usec - startTime.tv_usec)/1000L) + ((endTime.tv_sec - startTime.tv_sec)*1000L);
                    ETG_TRACE_USR4(("Duration of fingerprint calculation: %lums", durationMS));

                    if( (unsigned long)LocalSPM::GetDataProvider().IndexerFingerprintTimeoutMS() < durationMS )
                    {
                        snprintf(fingerprint, sizeof(fingerprint)-1, "%s%u", fingerprintShortcut, usedMemory);
                        ETG_TRACE_USR3(("Use fingerprint shortcut values because calcualtion lasted too long: fingerprint: %s", fingerprint));
                    }
                }
            }
        }

        /* Send PUT_FINGERPRINT event to own state machine */
        SendPutFingerprint(IN fingerprint, IN fingerprintStatus, IN numberOfFiles, IN deviceID);
    }

    tResult USBControl::GetNextObjectToIndex(tMetadataStatus &metadataStatus,
            const tIndex deviceIndex,
            const tMountPoint mountPoint,
            const tReadPosition readPosition,
            const tFileType fileType/* = FT_UNKNOWN*/)
    {
        ENTRY_INTERNAL
        VARTRACE2(mountPoint, deviceIndex);
        VARTRACE(readPosition);
        RECURSION_EMERGENCY_BREAK();

        tResult ret = MP_NO_ERROR;
        metadataStatus = MDS_SUCCESS;

        /* Check given DeviceIndex is within Range*/
        if(deviceIndex >= m_ScanContext.size())
        {
            ETG_TRACE_ERR(("Invalid deviceIndex"));
            metadataStatus = MDS_DEVICE_ERROR;
            return MP_NO_ERROR;
        }

        /* Search for last scan position of device */
        size_t deep = 0;
        tURL path;
        strncpy_r(OUT path, IN readPosition, IN sizeof(path));
        tListID dbListID = LIST_ID_NONE;

        deep = m_ScanContext[deviceIndex].deep;
        if(deep < m_ScanContext[deviceIndex].dirContext.size())
        {
            strncpy_r(OUT path, IN m_ScanContext[deviceIndex].dirContext[deep].path, IN sizeof(path));
            dbListID = m_ScanContext[deviceIndex].dirContext[deep].listID;
        }
        else if(deep > m_ScanContext[deviceIndex].dirContext.size())
        {
            ETG_TRACE_FATAL(("Deep level is bigger than size of directory context vector"));
            deep = m_ScanContext[deviceIndex].dirContext.size();
        }
        //else: Normal use case -> directory context for this level is not available yet

        /* Create a temporary list (virtual file list) for this directory */
        if( LIST_ID_NONE == dbListID )
        {
            tListType listType = LTY_FILELIST_UNSORTED;
            tFileTypeSelection fileTypeSelection = FTS_ALL;
            tStreaming streaming = false;

            //If interested to index "AudioItem",then create a List having ONLY audio Files + Folders,
            if(FT_AUDIO == fileType)
            {
                listType = LTY_FILELIST_SORTED_FOR_INDEXING;
                fileTypeSelection = FTS_AUDIO;
            }

            ret = LocalSPM::GetDBManager().CreateMediaPlayerFileList(INOUT dbListID, INOUT listType, IN path, IN m_ScanContext[deviceIndex].deviceID,IN streaming,IN fileTypeSelection);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while creating an unsorted file list (ErrorCode:%s)", errorString(ret)));

                if( 0 < deep )
                {
                    /* Go back one level/subdirectory*/
                    m_ScanContext[deviceIndex].deep--;
                    //strncpy_r(OUT path, IN m_ScanContext[deviceIndex].dirContext[deep-1].path, IN sizeof(path));
                    //return GetNextObjectToIndex(OUT metadataStatus, IN deviceID, IN mountPoint, IN path);
                    metadataStatus = MDS_FILE_ERROR;
                    return MP_NO_ERROR;
                }
                else
                {
                    ETG_TRACE_ERR(("Cannot create file list of root"));
                    metadataStatus = MDS_DEVICE_ERROR;
                    return MP_NO_ERROR;
                }
            }

            if(deep < m_ScanContext[deviceIndex].dirContext.size()) //Directory context is already available
            {
                m_ScanContext[deviceIndex].dirContext[deep].listID = dbListID;
            }
            else
            {
                /* Create directory context entry */
                tDirectoryContext directoryContextElem;
                strncpy_r(OUT directoryContextElem.path, IN path, IN sizeof(directoryContextElem.path));
                directoryContextElem.listID = dbListID;
                directoryContextElem.row = 0;
                m_ScanContext[deviceIndex].dirContext.push_back(directoryContextElem);

                if( m_ScanContext[deviceIndex].dirContext.size() != (deep+1) )
                {
                    ETG_TRACE_FATAL(("Size of directory context vector is unexpected"));
                }
            }
        }

        do //while( ret != MP_NO_ERROR )
        {
            ETG_TRACE_USR3(("m_ScanMethod:%u, deviceIndex:%u, deep:%u, dbListID:%u, row:%u, path:%s",
                    m_ScanMethod, deviceIndex, deep, m_ScanContext[deviceIndex].dirContext[deep].listID,
                    m_ScanContext[deviceIndex].dirContext[deep].row, m_ScanContext[deviceIndex].dirContext[deep].path));

            // thm3hi: additional traces to find a serious Suzuki problem: 18690 */
            ETG_TRACE_USR3(("Recurse return check, firstElementRow:%u, firstPath:%s",
                    m_ScanContext[deviceIndex].firstElementRow, m_ScanContext[deviceIndex].firstPath));

            /* Finish scanning if we reach first element again */
            if((0 == strcmp(m_ScanContext[deviceIndex].firstPath, m_ScanContext[deviceIndex].dirContext[deep].path))
                    &&
                    (m_ScanContext[deviceIndex].firstElementRow == m_ScanContext[deviceIndex].dirContext[deep].row))
            {
                ETG_TRACE_USR3(("Reach first element again while scanning for FileType:%u - exit scanning",fileType));

                metadataStatus = MDS_FINISHED;
                return MP_NO_ERROR;
            }

            // thm3hi: brett
            if (IS_RECURSION_EMERGENCY_BREAK())
            {
                ETG_TRACE_ERR(("RecursionBreak - exit scanning"));

                metadataStatus = MDS_FINISHED_RECURSIVE_EMERGENCY_BREAK;
                return MP_NO_ERROR;
            }

            /* Store first element of scanning */
            if(ROW_NUMBER_NONE == m_ScanContext[deviceIndex].firstElementRow)
            {
                strncpy_r(OUT m_ScanContext[deviceIndex].firstPath, IN m_ScanContext[deviceIndex].dirContext[deep].path, IN sizeof(m_ScanContext[deviceIndex].firstPath));
                m_ScanContext[deviceIndex].firstElementRow = m_ScanContext[deviceIndex].dirContext[deep].row;

                ETG_TRACE_USR3(("Store first element of scanning: firstElementRow:%u, firstPath:%s",
                        m_ScanContext[deviceIndex].firstElementRow, m_ScanContext[deviceIndex].firstPath));
            }

            /* Get next media object from virtual file list */
            tMediaObject localScanMediaObject;
            ret = LocalSPM::GetDBManager().GetMediaObjectDoStep(OUT localScanMediaObject, IN m_ScanContext[deviceIndex].dirContext[deep].listID, IN m_ScanContext[deviceIndex].dirContext[deep].row);

            LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(localScanMediaObject.title), sizeof(localScanMediaObject.title));
            SetScanMediaObject(IN localScanMediaObject);
            uint32_t currentRowNumber = m_ScanContext[deviceIndex].dirContext[deep].row++; //Increase index for next object
            if( MP_NO_ERROR != ret ) //Error case
            {
                if(MP_ERR_DB_END_OF_LIST != ret)
                {
                    if(LocalSPM::GetDataProvider().checkIfDeviceConnected(mountPoint))
                    {
                        const string dirPath = m_ScanContext[deviceIndex].dirContext[deep].path;
                        bool isOpenable = isDirOpenable(dirPath.c_str());
                        // For checking the non Openable Folder MP_ERR_DB_SELECT_FAILED,currentRowNumber (NCG3D-264588)
                        if ((0 == currentRowNumber) && (MP_ERR_DB_SELECT_FAILED == ret) && (!isOpenable))
                        {
                            ret = MP_ERR_DB_END_OF_LIST; //Overwrite the error code when directory is not openable
                            ETG_TRACE_ERR(("Not openable Folder found during indexing: %s",m_ScanContext[deviceIndex].dirContext[deep].path));

                        }
                        else
                        {
                             metadataStatus = MDS_FILE_ERROR;
                             ret = MP_NO_ERROR; //to exit Loop
                            //both mountpoint and folder are readable, device error or file error will be treated below
                        }
                    }
                    else
                    {
                        metadataStatus = MDS_DEVICE_ERROR;
                        ret = MP_NO_ERROR; //To exit Loop
                        ETG_TRACE_ERR(("Cannot get next media object"));
                    }

                } //Else case is not introduced, since if there is any non readable fodler it wont skip that
                if(MP_ERR_DB_END_OF_LIST == ret)//Reach end of list
                {
                    if( 0 < deep )
                    {
                        /* Release temporary list of this directory */
                        if( LIST_ID_NONE != m_ScanContext[deviceIndex].dirContext[deep].listID )
                        {
                            LocalSPM::GetDBManager().ReleaseAccess(IN m_ScanContext[deviceIndex].dirContext[deep].listID);

                            tResult ret2 = LocalSPM::GetDBManager().ReleaseDBList(IN m_ScanContext[deviceIndex].dirContext[deep].listID);
                            if (MP_NO_ERROR != ret2)
                            {
                                ETG_TRACE_ERR(("Error while releasing old list (ErrorCode:%s)", errorString(ret)));
                            }
                        }
                        /* Remove directory context entry */
                        m_ScanContext[deviceIndex].dirContext.erase(m_ScanContext[deviceIndex].dirContext.begin() + deep);

                        /* Go back one level/subdirectory*/
                        m_ScanContext[deviceIndex].deep--;
                        deep--;
                        //strncpy_r(OUT path, IN m_ScanContext[deviceIndex].dirContext[deep-1].path, IN sizeof(path));
                        //return GetNextObjectToIndex(OUT metadataStatus, IN deviceID, IN mountPoint, IN path);
                        if( 1 < recursionEmergencyBreakDepth ) //already called twice due to recursion by finding a folder
                        {
                            return ret;
                        }
                        else //first call of this function
                        {
                            continue;
                        }
                    }
                    else
                    {
                        /*check if read request on device related to this mount point is possible*/
                        if(LocalSPM::GetDataProvider().checkIfDeviceConnected(mountPoint))
                        {
                            /* Normal use case (be at the end of the list) */
                            /* Restart at beginning */
                            m_ScanContext[deviceIndex].dirContext[deep].row = 0;
                            //return GetNextObjectToIndex(OUT metadataStatus, IN deviceID, IN mountPoint, IN readPosition);
                            continue;
                        }
                        else
                        {
                            ETG_TRACE_ERR(("Cannot get next media object from root"));
                            metadataStatus = MDS_DEVICE_ERROR;
                            ret = MP_NO_ERROR; //Leave do while loop
                        }
                    }
                }
            }
            else //Got next media object
            {
                /* Analyse type of file */
                switch(m_ScanMediaObject.fileType)
                {
                    case FT_FOLDER:
                    {
                        /* Scan next level/subdirectory*/
                        m_ScanContext[deviceIndex].deep++;
                        //return GetNextObjectToIndex(OUT metadataStatus, IN deviceID, IN mountPoint, IN m_ScanMediaObject.fileName);
                        ret = GetNextObjectToIndex(OUT metadataStatus, IN deviceIndex, IN mountPoint, IN m_ScanMediaObject.fileName,IN fileType);
                        /* or Add folder (completeFileName = next read position) to queue */
                        break;
                    }
                    case FT_AUDIO:
                    case FT_VIDEO:
                    case FT_PLAYLIST:
                    case FT_IMAGE:
                    {
                        //Success!-Next object to Index is identified!
                        break;
                    }
                    default:        // unknown file type
                    {
                        /* Skip file and take next one */
                        //return GetNextObjectToIndex(OUT metadataStatus, IN deviceID, IN mountPoint, IN readPosition);
                        ret = MP_ERR_DB_END_OF_LIST; //Continue do while loop
                        break;
                    }
                }
            }
        } while( ret != MP_NO_ERROR );

        ETG_TRACE_USR2(("m_ScanMediaObject metadataStatus=%d, fileType=%d, title=%40s, MetadataField1=%40s",
                metadataStatus, m_ScanMediaObject.fileType, m_ScanMediaObject.title, m_ScanMediaObject.MetadataField1));

        return ret;
    }

    void USBControl::TransferMetaTags(void *_info, tMediaObject &mediaObject)
    {
        Info* info = (Info *)_info;

        static FILE *logFile = NULL;
#if 0 // for testting - please keep this
        if (!logFile) {
            logFile = fopen("/tmp/TransferMetaTags.txt", "w");
        }
#endif

        int convertMetadataField1toUniCode = 1;
        int convertMetadataField2toUniCode = 1;
        int convertMetadataField3toUniCode = 1;
        int convertMetadataField4toUniCode = 1;
        int convertTitletoUniCode = 1;

        /* only for GBK and Korean: */
        if (LocalSPM::GetDataProvider().ARABICSupported() ||
                LocalSPM::GetDataProvider().GBKSupported() ||
                LocalSPM::GetDataProvider().EUC_KRSupported()) {
            if (logFile) { // for testing
                fprintf(logFile, "Special handling\n");
            }
            convertMetadataField1toUniCode = !info->get_genre().isLatin1();
            convertMetadataField2toUniCode = !info->get_artist().isLatin1();
            convertMetadataField3toUniCode = !info->get_composer().isLatin1();
            convertMetadataField4toUniCode = !info->get_album().isLatin1();
            convertTitletoUniCode = !info->get_title().isLatin1();
            if (logFile) { // for testing
                fprintf(logFile, "convertTitletoUniCode(!isLatin1())=%d\n", convertTitletoUniCode);
            }
        } else { /* all others: if no UTF8 */
            //convertMetadataField1toUniCode = !g_utf8_validate((gchar *)info->get_genre().toCString(false) , -1, NULL);
            //convertMetadataField2toUniCode = !g_utf8_validate((gchar *)info->get_artist().toCString(false) , -1, NULL);
            //convertMetadataField3toUniCode = !g_utf8_validate((gchar *)info->get_composer().toCString(false) , -1, NULL);
            //convertMetadataField4toUniCode = !g_utf8_validate((gchar *)info->get_album().toCString(false) , -1, NULL);
            //convertTitletoUniCode = !g_utf8_validate((gchar *)info->get_title().toCString(false) , -1, NULL);
            if (logFile) { // for testing
                fprintf(logFile, "convertTitletoUniCode(!g_utf8_validate)=%d\n", convertTitletoUniCode);
            }
        }

        if (logFile) { // for testing
            //fprintf(logFile, "info->get_title()=%s\n", info->get_title());
            //hexDump(logFile, (char *)"info->get_title()", info->get_title(), strlen_r(info->get_title()));
            fprintf(logFile, "info->get_title().toCString(false)=%s\n", info->get_title().toCString(false));
            hexDump(logFile, const_cast<char *>("info->get_title().toCString(false)"), (void*)(const_cast<char*>(info->get_title().toCString(false))), strlen_r(info->get_title().toCString(false)));
        }

        if(LocalSPM::GetDataProvider().CodeSetConversionSupported())
        {
            /*Invoked to find and Convert the Non UTF-8 metadata strings(given by LibTagInfo) to valid UTF-8 Metadata - RoadMap:15004*/
            LocalSPM::GetDataProvider().FindAndConvertLatin1MetadataEntries(INOUT mediaObject,IN (void*)info);
        }
        else
        {
            mediaObject.metadataConvertFlag = 0;
            /* this is the newer version of handling Latin1 characters for meta tags */
            /* get the tag information */
            strncpy_r(OUT mediaObject.MetadataField1, IN info->get_genre().toCString(convertMetadataField1toUniCode), IN sizeof(mediaObject.MetadataField1));
            strncpy_r(OUT mediaObject.MetadataField2, IN info->get_artist().toCString(convertMetadataField2toUniCode), IN sizeof(mediaObject.MetadataField2));
            strncpy_r(OUT mediaObject.MetadataField3, IN info->get_composer().toCString(convertMetadataField3toUniCode), IN sizeof(mediaObject.MetadataField3));
            strncpy_r(OUT mediaObject.MetadataField4, IN info->get_album().toCString(convertMetadataField4toUniCode), IN sizeof(mediaObject.MetadataField4));
            strncpy_r(OUT mediaObject.title, IN info->get_title().toCString(convertTitletoUniCode), IN sizeof(mediaObject.title));

        }
        if (logFile) { // for testing
            fprintf(logFile, "convertTitletoUniCode=%d\n", convertTitletoUniCode);
            hexDump(logFile, (const char *)"mediaObject.title (after toCString)", mediaObject.title, strlen_r(mediaObject.title));
        }

        /* If genre is empty , then read the GenreID to select the genre names*/
#if 0
        LocalSPM::GetDataProvider().VerifyGenreName(IN info->get_genreNr(), OUT mediaObject.MetadataField1);
#else
        LocalSPM::GetDataProvider().VerifyGenreName(IN 255, OUT mediaObject.MetadataField1);
#endif

        if(LocalSPM::GetDataProvider().CodeSetConversionSupported())
        {
            //No need to Call Convert2UTF8 as it is already converted to UTF8 by USBControl::FindAndConvertLatin1MetadataEntries
        }
        else
        {
            /* if it was NOT converted to unicode, it must be reconverted to UTF-8 if it is not UTF8 */
            if (!convertMetadataField1toUniCode) {
                LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(mediaObject.MetadataField1), sizeof(mediaObject.MetadataField1));
            }
            if (!convertMetadataField2toUniCode) {
                LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(mediaObject.MetadataField2), sizeof(mediaObject.MetadataField2));
            }
            if (!convertMetadataField3toUniCode) {
                LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(mediaObject.MetadataField3), sizeof(mediaObject.MetadataField3));
            }
            if (!convertMetadataField4toUniCode) {
                LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(mediaObject.MetadataField4), sizeof(mediaObject.MetadataField4));
            }
            if (!convertTitletoUniCode) {
                LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(mediaObject.title), sizeof(mediaObject.title));
            }

            if (logFile) { // for testing
                hexDump(logFile, (const char *)"mediaObject.title (after Convert2UTF8)", mediaObject.title, strlen_r(mediaObject.title));
            }
        }

        /* cut metadata */
        LocalSPM::GetDataProvider().CutMetadata((FastUTF8::tString)(mediaObject.MetadataField1), sizeof(mediaObject.MetadataField1));
        LocalSPM::GetDataProvider().CutMetadata((FastUTF8::tString)(mediaObject.MetadataField2), sizeof(mediaObject.MetadataField2));
        LocalSPM::GetDataProvider().CutMetadata((FastUTF8::tString)(mediaObject.MetadataField3), sizeof(mediaObject.MetadataField3));
        LocalSPM::GetDataProvider().CutMetadata((FastUTF8::tString)(mediaObject.MetadataField4), sizeof(mediaObject.MetadataField4));
        LocalSPM::GetDataProvider().CutMetadata((FastUTF8::tString)(mediaObject.title), sizeof(mediaObject.title));

        if (logFile) { // for testing
            hexDump(logFile, (const char *)"mediaObject.title (after CutMetadata)", mediaObject.title, strlen_r(mediaObject.title));
        }

        if(LocalSPM::GetDataProvider().YearMetadataSupported())
        {
            mediaObject.year=info->get_year();
            VARTRACE(mediaObject.year);
        }
    }

    void USBControl::DoReadMetadataForPlaybackThread(const char *completeFileName)
    {
        ENTRY

        tResult ret = MP_NO_ERROR;
        tReturnValue returnValue = TRUE;
        tURL mountPointURL;

        /* Get metadata of media object for playback */
        tMediaObject mediaObject;
        InitMediaObject(OUT mediaObject);

        m_Mutex.lock();
        tMediaObjectID mediaObjectID = m_PlayMediaObject.objectID;
        tDeviceID deviceID = m_PlayMediaObject.deviceID;
        m_Mutex.unlock();
        if(completeFileName)
        {
            VARTRACE(completeFileName);

            ret = LocalSPM::GetDBManager().GetFileFormat(OUT mediaObject.fileFormat, OUT mediaObject.fileType, IN completeFileName);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("unable to get file format for the url: %s", completeFileName));
                returnValue = FALSE;
            }
            else
            {
                tDeviceInfo deviceInfo;
                tMediaObject tempMediaObject;

                ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo,IN deviceID);

                if(FT_VIDEO == mediaObject.fileType )
                {
                    //For DTY_CDROM,if indexing completed,then read metadata from DB instead of extracting from File header - NCG3D-35767
                    if(IsMassStorageDevice(IN deviceInfo.deviceType) && LocalSPM::GetDataProvider().DBFileBrowsingByDB())
                    {
                        ret = LocalSPM::GetDBManager().GetMediaObject(OUT tempMediaObject, INOUT mediaObjectID);
                        if(MP_NO_ERROR == ret)
                        {
                            mediaObject = tempMediaObject;
                        }
                        else
                        {
                            ETG_TRACE_USR4(("Could not read Video metadata from database"));
                            /* Read video metadata */
                            returnValue = ReadVideoMetadataFromFile(INOUT mediaObject, IN completeFileName);
                        }
                    }
                    else
                    {
                        /* Read video metadata */
                        returnValue = ReadVideoMetadataFromFile(INOUT mediaObject, IN completeFileName);
                    }
                }
                else
                {
                    if(DTY_CDROM == deviceInfo.deviceType)
                    {
                        /* Read audio metadata */
                        tBoolean isAvailabe = FALSE;
                        ret = LocalSPM::GetDBManager().GetMediaObject(OUT tempMediaObject, INOUT mediaObjectID);
                        if(MP_NO_ERROR == ret)
                        {
                            mediaObject = tempMediaObject;
                            isAvailabe = strncmp(mediaObject.MetadataField1,LocalSPM::GetDataProvider().DBUnknownText().c_str(),sizeof(mediaObject.MetadataField1))
                                        || strncmp(mediaObject.MetadataField2,LocalSPM::GetDataProvider().DBUnknownText().c_str(),sizeof(mediaObject.MetadataField2))
                                        || strncmp(mediaObject.MetadataField3,LocalSPM::GetDataProvider().DBUnknownText().c_str(),sizeof(mediaObject.MetadataField3))
                                        || strncmp(mediaObject.MetadataField4,LocalSPM::GetDataProvider().DBUnknownText().c_str(),sizeof(mediaObject.MetadataField3));
                        }
                        if(!isAvailabe) // If Metadata already available no needs to read from file.
                        {
                            ETG_TRACE_USR4(("Read Metadata from CDROM"));
                            returnValue = ReadAudioMetadataFromCdRom(INOUT mediaObject, IN completeFileName);
                            /* Store media object in DB */
                            ret = LocalSPM::GetDBManager().StoreMediaObject(IN mediaObject);
                            if(MP_NO_ERROR != ret)
                            {
                                ETG_TRACE_ERR(("Error while storing media object in DB (ErrorCode:%s)", errorString(ret)));
                            }
                        }
                        else
                        {
                            ETG_TRACE_USR4(("Read Metadata from CDROM from DB"));
                        }
                    }
                    else
                    {
                        /* Read audio metadata */
                        returnValue = ReadAudioMetadataFromFile(INOUT mediaObject, IN completeFileName);
                    }

                }
            }

            strncpy_r(OUT mountPointURL, IN completeFileName, IN sizeof(mountPointURL));
            delete[] completeFileName;
        }
        else
        {
            mountPointURL[0] = '\0';
        }

        m_Mutex.lock();

        tPEHandle handle = (tPEHandle)m_PlayMediaObject.objectID;
        m_PlayMediaObject.notPlayable = mediaObject.notPlayable;

        if(returnValue)
        {
            /* Copy metadata */
            m_PlayMediaObject.mediaType = mediaObject.mediaType;
            strncpy_r(OUT m_PlayMediaObject.title, IN mediaObject.title, IN sizeof(m_PlayMediaObject.title));
            strncpy_r(OUT m_PlayMediaObject.MetadataField1, IN mediaObject.MetadataField1, IN sizeof(m_PlayMediaObject.MetadataField1));
            strncpy_r(OUT m_PlayMediaObject.MetadataField2, IN mediaObject.MetadataField2, IN sizeof(m_PlayMediaObject.MetadataField2));
            strncpy_r(OUT m_PlayMediaObject.MetadataField3, IN mediaObject.MetadataField3, IN sizeof(m_PlayMediaObject.MetadataField3));
            strncpy_r(OUT m_PlayMediaObject.MetadataField4, IN mediaObject.MetadataField4, IN sizeof(m_PlayMediaObject.MetadataField4));
            m_PlayMediaObject.totalPlaytime = mediaObject.totalPlaytime;
            m_PlayMediaObject.trackNumber = mediaObject.trackNumber;
            m_PlayMediaObject.metadataConvertFlag = mediaObject.metadataConvertFlag;
        }

        m_Mutex.unlock();

        if(handle != OBJECT_ID_NONE) { //GMMY17-15590

            /* Send METADATA_FOR_PLAYBACK message to own SM */
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);

            ret = ParameterMETADATA_FOR_PLAYBACK(OUT parameterString, IN size, IN handle, IN mountPointURL);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                parameterString[0] = '\0';
            }

            ret = SendEvent(METADATA_FOR_PLAYBACK, IN parameterString);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    void USBControl::DoReadMetadataForIndexing()
    {
        ENTRY

        tResult ret = MP_NO_ERROR;
        tReturnValue returnValue = TRUE;

        tMetadataStatus metadataStatus = MDS_SUCCESS;

        tMediaObject mediaObject;
        InitMediaObject(OUT mediaObject);
        mediaObject =  GetScanMediaObject();

        tURL completeFileName;
        tURL originalcompleteFileName;
        if((mediaObject.deviceType == DTY_MUSICBOX) && (MTY_MUSIC_FILE == mediaObject.mediaType))
        {


            strncpy_r(OUT originalcompleteFileName, IN mediaObject.mountPoint, IN sizeof(originalcompleteFileName));
            strncat_r(OUT originalcompleteFileName, IN mediaObject.fileName, IN sizeof(originalcompleteFileName));
            /* set URL of media object without additional slash in front*/
            /*  filepath ==> /edb238602c27b232985144e990e8de85/Track_3.mp3 , filepath ==>edb238602c27b232985144e990e8de85/Track_3.mp3
             *  CDID/UUID ==>edb238602c27b232985144e990e8de85 */
            tURL fullName;
            unsigned char *pureFile = NULL;
            unsigned char *CDIDpath = NULL;
            VARTRACE(mediaObject.fileName)
            strncpy_r(OUT fullName, IN mediaObject.fileName, IN sizeof(fullName));
            FastUTF8::Split(OUT pureFile, INOUT (unsigned char *)fullName);
            if (pureFile) // Purfile -- Track_3.mp3 , fullName -->/edb238602c27b232985144e990e8de85
            {
                VARTRACE(pureFile)
                            FastUTF8::Split(OUT CDIDpath, INOUT (unsigned char *)fullName);
                if (CDIDpath) //CDIDpath -- edb238602c27b232985144e990e8de85
                {
                    VARTRACE(CDIDpath)
                            strncpy_r(OUT (char *)mediaObject.UUID, IN (const char *)CDIDpath, IN sizeof(mediaObject.UUID));
                    strncpy_r(OUT mediaObject.fileName, IN (const char *)CDIDpath, IN sizeof(completeFileName));
                    strncat_r(OUT mediaObject.fileName, "/", IN sizeof(completeFileName));
                    strncat_r(OUT mediaObject.fileName, (const char *)pureFile, IN sizeof(completeFileName));
                    VARTRACE(mediaObject.fileName)
                }
            }
        }


        strncpy_r(OUT completeFileName, IN mediaObject.mountPoint, IN sizeof(completeFileName));
        strncat_r(OUT completeFileName, IN mediaObject.fileName, IN sizeof(completeFileName));


        if(MTY_MUSIC_FILE == mediaObject.mediaType)
        {

            if(DTY_CDROM != mediaObject.deviceType)
            {
                ReadAudioMetadataFromFile(INOUT mediaObject, IN completeFileName);
            }
            if(LocalSPM::GetDataProvider().IsAlbumArtSupported(IN mediaObject.deviceType))
            {
                /*overwrite the albumart string as filename (without mountpoint) for storing in DB, else it is with mountpoint*/
                strncpy_r(OUT mediaObject.albumArtString, IN mediaObject.fileName, IN sizeof(mediaObject.albumArtString));
            }
            if(mediaObject.deviceType == DTY_MUSICBOX)
            {
                strncpy_r(OUT completeFileName, IN originalcompleteFileName, IN sizeof(completeFileName));
            }
        }
        else if(MTY_VIDEO == mediaObject.mediaType)
        {
            returnValue = ReadVideoMetadataFromFile(INOUT mediaObject, IN completeFileName);

            if(LocalSPM::GetDataProvider().IsAlbumArtSupported(IN mediaObject.deviceType))
            {
                /*overwrite the albumart string as filename (without mountpoint) for storing in DB, else it is with mountpoint*/
                strncpy_r(OUT mediaObject.albumArtString, IN mediaObject.fileName, IN sizeof(mediaObject.albumArtString));
            }
        }
        else if(MTY_IMAGE == mediaObject.mediaType)
        {
            returnValue = ReadImageMetadataFromFile(INOUT mediaObject, IN completeFileName);
        }
        else if (MTY_PLAYLIST == mediaObject.mediaType)
        {
            /* Set the playlist name in tag1 to the title without extension*/
            FastUTF8::tString extension;
            FastUTF8::tString fileName = (FastUTF8::tString)strdup(mediaObject.title);
            if(fileName){
                FastUTF8::SplitExtension(OUT extension, INOUT fileName);
                strncpy_r(OUT mediaObject.MetadataField1, IN(char*)fileName, IN sizeof(mediaObject.MetadataField1));
                free(fileName);
            }
        }
        else
        {
            ETG_TRACE_ERR(("DoReadMetadataForIndexing -> Cannot extract meta data because of wrong media type"));
        }


        tMediaObject afterScanMediaObject;
        InitMediaObject(OUT afterScanMediaObject);
        afterScanMediaObject =  GetScanMediaObject();
        tURL CurrentFileNameToScan;
        strncpy_r(OUT CurrentFileNameToScan, IN afterScanMediaObject.mountPoint, IN sizeof(CurrentFileNameToScan));
        strncat_r(OUT CurrentFileNameToScan, IN afterScanMediaObject.fileName, IN sizeof(CurrentFileNameToScan));


        /*NOTE: Check whether the current Item to Scan in USBControlSM is same as the one Extracted,If not,then USBControl doesn't need this update anymore!
    i.e Indexer already SKIP for this file & decremented total number of files.
    Info:Instead of SKIP,Even if we do SendPutMetadata,
    If USBControlSM was in any state other than "loadMetadata" state,it will not consume it.
    If USBControlSM was in "loadMetadata" state(i.e for next file or worst case for someother device),
    it will consume it & it may lead to loss of metadata for file for whose answer USBControlSM is really waiting
         */
        if(!strncmp(CurrentFileNameToScan,completeFileName,sizeof(tURL)))
        {

            SetScanMediaObject(IN mediaObject);
            if(false == returnValue)
            {
                metadataStatus = MDS_FILE_SKIP;
            }

            tMediaObjectPtr mediaObjectPtr = NULL;
            /* Send PUT_METADATA message to USBControlSM */
            SendPutMetadata(IN metadataStatus,IN mediaObjectPtr); //Metadata is made ready from the m_ScanMediaObject.Hence Passed NULL ptr

        }
    }

#define PERF_MEAS 1

    tReturnValue USBControl::ReadAudioMetadataFromFile(tMediaObject &mediaObject, const tURL completeFileName)
    {
        ENTRY
        VARTRACE(completeFileName);

        tReturnValue returnValue = TRUE;

        mediaObject.mediaType = MTY_MUSIC_FILE;

#if PERF_MEAS
        TimeTrace ticks("ReadAudioMetadataFromFile");
#endif

        string target((const char *)completeFileName);
        Info *info = Info::create_tag_info(IN target);

        if(info)
        {
            if(info->read())
            {
                /* transfer the meta info to the meta gats of the media object */
                TransferMetaTags(IN (void *)info, OUT mediaObject);

                if(0 == strlen_r(mediaObject.title))
                {
                    ETG_TRACE_USR1(("No title available -> use filename instead"));

                    tURL fullName;
                    unsigned char *pureFile;
                    strncpy_r(OUT fullName, IN completeFileName, IN sizeof(fullName));
                    FastUTF8::Split(OUT pureFile, INOUT (unsigned char *)fullName);

                    if (pureFile)
                    {
                        /* Remove the extension, if wanted */
                        if (LocalSPM::GetDataProvider().DBRemoveExtensionFromFilename())
                        {
                            unsigned char *extension;
                            FastUTF8::SplitExtension(OUT extension, INOUT (unsigned char *)pureFile);
                        }

                        strncpy_r(OUT mediaObject.title, IN (const char *)pureFile, IN sizeof(mediaObject.title));
                        LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(mediaObject.title), sizeof(mediaObject.title));
                    }
                }

                mediaObject.totalPlaytime = info->get_length_seconds() * 1000; //length is in seconds, totalPlaytime is in milliseconds
                mediaObject.trackNumber = info->get_tracknumber();

                /* Collect file attributes  */
                struct stat attribut;
                struct tm *timeinfo;
                if (-1 != stat (completeFileName, &attribut))
                {
                    timeinfo = localtime(&attribut.st_mtim.tv_sec);
                    strftime(mediaObject.dateTime, sizeof(mediaObject.dateTime), "%Y:%m:%d %H:%M:%S", timeinfo);
                }

                /* Check if file is encrypted (DRM protected) */
                if(info->get_encrypted())
                {
                    mediaObject.notPlayable = FNP_DRM_PROTECTED;
                }
            }
            else
            {
                //mediaObject.notPlayable = FNP_FORMAT_ERROR; //Do not set FNP here because audio files will be indexed/played anyhow
                returnValue = FALSE;
            }

            delete info;
        }
        else
        {
            //mediaObject.notPlayable = FNP_FORMAT_ERROR; //Do not set FNP here because audio files will be indexed/played anyhow
            returnValue = FALSE;
        }

#if PERF_MEAS
        ticks.elapsed();
#endif

        if(FALSE == returnValue)
        {
            if(m_PlayMediaObject.deviceID == MUSICBOX_DEVICE_ID)
            {
                //if device type is MusicBox, Check if file exists and update mediaobject.notplayable
                ifstream myfile(completeFileName);
                if(!myfile)
                {
                    ETG_TRACE_USR4(("USBControl::ReadAudioMetadataFromFile -> File does not exist %s", completeFileName));
                    mediaObject.notPlayable = FNP_READ_ERROR;
                }
                else
                {
                    ETG_TRACE_ERR(("USBControl::ReadAudioMetadataFromFile -> metadata could not be retrieved for file : %s , But file exists!!",completeFileName));
                }
            }
            else
            {
                ETG_TRACE_ERR(("USBControl::ReadAudioMetadataFromFile -> metadata could not be retrieved for file : %s",completeFileName));
            }
        }
        else
        {
            VARTRACE5(mediaObject.title, mediaObject.MetadataField1, mediaObject.MetadataField2, mediaObject.MetadataField3, mediaObject.MetadataField4);
            VARTRACE(mediaObject.totalPlaytime);
            VARTRACE(mediaObject.trackNumber);
            VARTRACE(mediaObject.notPlayable);
        }

        return returnValue;
    }
    tReturnValue USBControl::ReadAudioMetadataFromFile(tMediaObject &mediaObject, const tURL completeFileName, const void *pInfo)
    {
        ENTRY
        VARTRACE(completeFileName);
        tReturnValue returnValue = TRUE;

        mediaObject.mediaType = MTY_MUSIC_FILE;

#if PERF_MEAS
        TimeTrace ticks("ReadAudioMetadataFromFile");
#endif
        Info *info = (Info *)pInfo;

        if(info)
        {
            if(info->read())
            {
                /* transfer the meta info to the meta gats of the media object */
                TransferMetaTags(IN (void *)info, OUT mediaObject);

                if(0 == strlen_r(mediaObject.title))
                {
                    ETG_TRACE_USR1(("No title available -> use filename instead"));

                    tURL fullName;
                    unsigned char *pureFile;
                    strncpy_r(OUT fullName, IN completeFileName, IN sizeof(fullName));
                    FastUTF8::Split(OUT pureFile, INOUT (unsigned char *)fullName);

                    if (pureFile)
                    {
                        /* Remove the extension, if wanted */
                        if (LocalSPM::GetDataProvider().DBRemoveExtensionFromFilename())
                        {
                            unsigned char *extension;
                            FastUTF8::SplitExtension(OUT extension, INOUT (unsigned char *)pureFile);
                        }

                        strncpy_r(OUT mediaObject.title, IN (const char *)pureFile, IN sizeof(mediaObject.title));
                        LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(mediaObject.title), sizeof(mediaObject.title));
                    }
                }

                mediaObject.totalPlaytime = info->get_length_seconds() * 1000; //length is in seconds, totalPlaytime is in milliseconds
                mediaObject.trackNumber = info->get_tracknumber();

                /* Check if file is encrypted (DRM protected) */
                if(info->get_encrypted())
                {
                    mediaObject.notPlayable = FNP_DRM_PROTECTED;
                }
            }
            else
            {
                //mediaObject.notPlayable = FNP_FORMAT_ERROR; //Do not set FNP here because audio files will be indexed/played anyhow
                returnValue = FALSE;
            }
        }
        else
        {
            //mediaObject.notPlayable = FNP_FORMAT_ERROR; //Do not set FNP here because audio files will be indexed/played anyhow
            returnValue = FALSE;
        }

#if PERF_MEAS
        ticks.elapsed();
#endif

        if(FALSE == returnValue)
        {
            ETG_TRACE_ERR(("USBControl::ReadAudioMetadataFromFile -> metadata could not be retrieved for file : %s",completeFileName));
        }
        else
        {
            VARTRACE5(mediaObject.title, mediaObject.MetadataField1, mediaObject.MetadataField2, mediaObject.MetadataField3, mediaObject.MetadataField4);
            VARTRACE(mediaObject.totalPlaytime);
            VARTRACE(mediaObject.trackNumber);
            VARTRACE(mediaObject.notPlayable);
        }

        return returnValue;
    }

    tResult USBControl::ReadOneVideoMetaData(IN FILE *fpInput, IN char *tmpFileName, const char *format, ...)
    {
        ENTRY

        tGeneralString buffer;

        /* read one line */
        char *cerr;
        cerr = fgets(buffer, sizeof(tGeneralString), fpInput);

        if (cerr != buffer) {
            fclose(fpInput);
            if(0 != remove(tmpFileName))
            {
                ETG_TRACE_ERR(("Cannot delete temp file: %s", tmpFileName));
            }
            return -1;
        }

        /* look for the '=' and read the item */
        char *cEqualSign = strstr(buffer, "=");
        if (!cEqualSign) {
            fclose(fpInput);

            if(0 != remove(tmpFileName))
            {
                ETG_TRACE_ERR(("Cannot delete temp file: %s", tmpFileName));
            }
            return -1;
        }
        cEqualSign++; // now pointing to value
        va_list vl;
        va_start(vl, format);
        vsscanf(cEqualSign, format, vl);
        va_end(vl);

        return MP_NO_ERROR;
    }

    tReturnValue USBControl::ReadVideoMetadataFromFile(tMediaObject &mediaObject, const tURL completeFileName)
    {
        ENTRY
        VARTRACE(completeFileName);
        tReturnValue returnValue = TRUE;

        /* only if video indexing enabled and Video file is not treated as Audio */
        if ((LocalSPM::GetDataProvider().VideoIndexingOn() == 0) && (LocalSPM::GetDataProvider().InformVideoFileAsAudio() == 0)) {
            return FALSE;
        }

#if PERF_MEAS
        TimeTrace ticks("ReadVideoMetadataFromFile");
#endif

        mediaObject.mediaType = MTY_VIDEO;


#if USE_VIDEO_METADATA_READ_PROCESS
        VideoTagInfo *info = new VideoTagInfo(IN completeFileName, USB_CTRL_SM_ANSWER_TIMEOUT_MS-100);
#else
        string target((const char *)completeFileName);
        Info *info = Info::create_tag_info(IN target);
#endif

        if(info)
        {
            if(info->read())
            {
                tGeneralString codecString="NULL";
                tVideoProfileName profile="NULL";
                tVideoProfileLevel level=0.0;
                tSize width=0;
                tSize height=0;
                tBitRate bitRate=0;
                tFrameRate frameRate=0;
                tCodec codec = CDC_OTHER;
                unsigned long long int durationInNanoSec;
                //tFileFormat format;

                strncpy_r(OUT codecString, IN info->get_videocodec().toCString(true), IN sizeof(codecString));
                CodecStandardisation(OUT codec, IN codecString);
                ETG_TRACE_USR3(("USBControl::CodecStandardisation codecName:%20s -> codecEnum:%d", codecString, codec));
                strncpy_r(OUT profile, IN info->get_profile().toCString(true), IN sizeof(profile));
                strupper(profile);
                level=info->get_level();
                width=(tSize)info->get_width();
                height=(tSize)info->get_height();
                bitRate=(tBitRate)info->get_bitrate();
                frameRate=(tFrameRate)info->get_framerate();

                if(LocalSPM::GetDataProvider().IsVideoPlayable(IN codec, IN profile, IN level, IN width, IN height, IN frameRate, IN bitRate))
                {
                    /* if title is Latin1 encoded, do not convert to Unicode in all the next steps */
                    /* thm3hi: I assume that all tags are coded uniquely */
                    bool convertToUnicode = true;
                    if (info->get_title().isLatin1()) {
                        convertToUnicode = false;
                    }
                    /*extract all other video metadata */
                    tURL fullName;
                    unsigned char *pureFile;
                    strncpy_r(OUT fullName, IN completeFileName, IN sizeof(fullName));
                    FastUTF8::Split(OUT pureFile, INOUT (unsigned char *)fullName);

                    if (pureFile)
                    {
                        /* Remove the extension, if wanted */
                        if (LocalSPM::GetDataProvider().DBRemoveExtensionFromFilename())
                        {
                            unsigned char *extension;
                            FastUTF8::SplitExtension(OUT extension, INOUT (unsigned char *)pureFile);
                        }

                        strncpy_r(OUT mediaObject.title, IN (const char *)pureFile, IN sizeof(mediaObject.title));
                    }

                    strncpy_r(mediaObject.MetadataField1, info->get_title().toCString(convertToUnicode), sizeof(mediaObject.MetadataField1));

                    if(0 == strlen_r(mediaObject.MetadataField1))
                    {
                        ETG_TRACE_USR1(("No title available -> use filename as video name instead"));
                        strncpy_r(OUT mediaObject.MetadataField1, IN mediaObject.title, IN sizeof(mediaObject.MetadataField1));
                    }
                    else
                    {
                        //If Codesetconversion is supported,Latin1 MetadataField1 should be converted to UTF-8 and remembered
                        if(LocalSPM::GetDataProvider().CodeSetConversionSupported())
                        {
                            mediaObject.metadataConvertFlag = 0;

                            if(false == convertToUnicode)
                            {
                                mediaObject.metadataConvertFlag |= BITFLAG_METADATAFIELD1;

                                //Check whether the Latin1 title is a invalid UTF-8 String
                                LocalSPM::GetDataProvider().FindNonUTF8Latin1Metadata(INOUT mediaObject);

                                //If non-UTF8,then Title Converted to UTF-8 from Latin1
                                if(mediaObject.metadataConvertFlag) LocalSPM::GetDataProvider().ConvertNonUTF8Latin1Metadata2UTF8(INOUT mediaObject,IN (void*)info);
                            }
                            LocalSPM::GetDataProvider().CutMetadata(INOUT (FastUTF8::tString)(mediaObject.MetadataField1), IN sizeof(mediaObject.MetadataField1));
                        }
                        /* if it was NOT converted to unicode (when CodeSetConversionSupported being false), it must be reconverted to UTF-8 */
                        else if (!convertToUnicode)
                        {
                            /* change string to GBK and cut them */
                            LocalSPM::GetDataProvider().ImportAndCut(INOUT (FastUTF8::tString)mediaObject.MetadataField1, IN sizeof(mediaObject.MetadataField1));
                        }
                    }

                    /* Store resolution (Roadmap 16011) */
                    snprintf(mediaObject.MetadataField2, sizeof(mediaObject.MetadataField2)-1, "%dx%d", width, height);

                    durationInNanoSec = info->get_duration();
                    mediaObject.totalPlaytime = (durationInNanoSec/1000000);
                    mediaObject.trackNumber = (tTrackNumber)info->get_tracknumber();

                    // PSA requiremetn to play MP4 file with only having audio data ( MP4 with AAC data)
                    // this is not a very clean solution. This configuration will only be enabled for PSA
                    if (LocalSPM::GetDataProvider().InformVideoFileAsAudio())
                    {
                        mediaObject.mediaType = MTY_MUSIC_FILE;
                        mediaObject.fileType = FT_AUDIO;
                        mediaObject.catType = CTY_SONG;
                    }

                    /* Check if file is encrypted (DRM protected) */
                    if(info->get_encrypted())
                    {
                        mediaObject.notPlayable = FNP_DRM_PROTECTED;
                    }

                    /* Collect file attributes (Roadmap 16011) */
                    struct stat attribut;
                    struct tm *timeinfo;
                    if (-1 != stat (completeFileName, &attribut))
                    {
                        mediaObject.fileMode = attribut.st_mode;
                        mediaObject.userID = attribut.st_uid;
                        mediaObject.groupID = attribut.st_gid;
                        mediaObject.fileSize = attribut.st_size; //in Bytes
                        timeinfo = localtime(&attribut.st_mtim.tv_sec);
                        strftime(mediaObject.dateTime, sizeof(mediaObject.dateTime), "%Y:%m:%d %H:%M:%S", timeinfo);

                        /* Get read only flag */
                        tBoolean bReadOnlyFlag;
                        LocalSPM::GetDataProvider().GetReadOnlyFlag(OUT bReadOnlyFlag, IN mediaObject.fileMode, IN mediaObject.userID, IN mediaObject.groupID);
                        VARTRACE(bReadOnlyFlag);
                    }

                }
                else
                {
                    mediaObject.notPlayable = FNP_PLAY_RESTRICTION;
                    returnValue = FALSE;
                }
            }
            else
            {
                mediaObject.notPlayable = FNP_FORMAT_ERROR;
                returnValue = FALSE;
            }

            delete info;
        }
        else
        {
            mediaObject.notPlayable = FNP_FORMAT_ERROR;
            returnValue = FALSE;
        }

#if PERF_MEAS
        ticks.elapsed();
#endif

        if(FALSE == returnValue)
        {
            //>--Roadmap CMG3G-10221 : 'Scene Recorder '
            /* Collect file attributes for Scene Recorder folder Info
         even if metadata is not available */
            struct stat attribut;
            struct tm *timeinfo;
            if (-1 != stat (completeFileName, &attribut))
            {
                mediaObject.fileMode = attribut.st_mode;
                mediaObject.userID = attribut.st_uid;
                mediaObject.groupID = attribut.st_gid;
                mediaObject.fileSize = attribut.st_size; //in Bytes
                timeinfo = localtime(&attribut.st_mtim.tv_sec);
                strftime(mediaObject.dateTime, sizeof(mediaObject.dateTime), "%Y:%m:%d %H:%M:%S", timeinfo);

                /* Get read only flag */
                tBoolean bReadOnlyFlag;
                LocalSPM::GetDataProvider().GetReadOnlyFlag(OUT bReadOnlyFlag, IN mediaObject.fileMode, IN mediaObject.userID, IN mediaObject.groupID);
                VARTRACE(bReadOnlyFlag);
            }
            //<--Roadmap CMG3G-10221 : 'Scene Recorder '
            ETG_TRACE_ERR(("USBControl::ReadVideoMetadataFromFile -> metadata could not be retrieved for file : %s", completeFileName));
            VARTRACE(mediaObject.notPlayable);
        }
        else
        {
            VARTRACE(mediaObject.title);
            VARTRACE(mediaObject.MetadataField1);
            VARTRACE(mediaObject.totalPlaytime);
            VARTRACE(mediaObject.trackNumber);
            VARTRACE(mediaObject.notPlayable);
            VARTRACE(mediaObject.metadataConvertFlag);
        }

        return returnValue;
    }

    tReturnValue USBControl::ReadImageMetadataFromFile(tMediaObject &mediaObject, const tURL completeFileName)
    {
        ENTRY
        VARTRACE(completeFileName);

        tReturnValue returnValue = TRUE;

        mediaObject.mediaType = MTY_IMAGE;
        mediaObject.notPlayable = FNP_NOT_PLAYABLE;

#if PERF_MEAS
        TimeTrace ticks("ReadImageMetadataFromFile");
#endif

        string target((const char *)completeFileName);
        /* Collect file attributes  */
        struct stat attribut;
        struct tm *timeinfo = NULL;
        int retStat = stat (completeFileName, &attribut);
        if(attribut.st_size < (tUInt)LocalSPM::GetDataProvider().MaxImageSize())
        {
            FREE_IMAGE_FORMAT fif = FIF_UNKNOWN;
            fif = FreeImage_GetFileType(target.c_str(), 0);
            FIBITMAP *dib = FreeImage_Load(fif, target.c_str());

            if((NULL != dib) && (NULL != dib->data))
            {

                // Get the file attributes such as size data time dimension and resolution.
                if(-1 != retStat) timeinfo = localtime(&attribut.st_mtim.tv_sec);
                else ETG_TRACE_USR3(("Stat not reading the file Attributes"));

                unsigned short xDensity = (unsigned short) (0.5 + 0.0254 * FreeImage_GetDotsPerMeterX(dib));
                unsigned short yDensity = (unsigned short) (0.5 + 0.0254 * FreeImage_GetDotsPerMeterY(dib));
#if IMAGE_ATTRIBUTES_IN_METADATA
                if(-1 != retStat) snprintf(mediaObject.MetadataField1, sizeof(mediaObject.MetadataField1)-1, "%d", attribut.st_size);
                if(NULL != timeinfo) strftime(OUT mediaObject.MetadataField2, sizeof(mediaObject.MetadataField2), "%Y:%m:%d %H:%M:%S", timeinfo);
                snprintf(mediaObject.MetadataField3, sizeof(mediaObject.MetadataField3)-1, "%dx%d", FreeImage_GetHeight(dib), FreeImage_GetWidth(dib));
                snprintf(mediaObject.MetadataField4, sizeof(mediaObject.MetadataField4)-1, "%dx%d", xDensity, yDensity);

#else
                if(-1 != retStat) mediaObject.fileSize = attribut.st_size; //in Bytes
                if(NULL != timeinfo) strftime(OUT mediaObject.dateTime, sizeof(mediaObject.dateTime), "%Y:%m:%d %H:%M:%S", timeinfo);
                snprintf(mediaObject.MetadataField2, sizeof(mediaObject.MetadataField2)-1, "%dx%d", FreeImage_GetHeight(dib), FreeImage_GetWidth(dib));
                snprintf(mediaObject.MetadataField1, sizeof(mediaObject.MetadataField1)-1, "%dx%d", xDensity, yDensity);
#endif
                mediaObject.notPlayable = FNP_PLAYABLE;

                FreeImage_Unload(dib);
            }
            else
            {
                ETG_TRACE_USR3(("USBControl::ReadImageMetadataFromFile -> loading failed"));
                returnValue = FALSE;
            }

        }
        else
        {

            ETG_TRACE_USR3(("USBControl::ReadImageMetadataFromFile -> Size more than configured limit"));
            returnValue = FALSE;
        }



#if PERF_MEAS
        ticks.elapsed();
#endif

        if(FALSE == returnValue)
        {
            ETG_TRACE_ERR(("USBControl::ReadImageMetadataFromFile -> metadata could not be retrieved for file : %s", completeFileName));
        }
        else
        {
            FastUTF8::tString extension;
            FastUTF8::tString fileName = (FastUTF8::tString)strdup(mediaObject.title);
            FastUTF8::SplitExtension(OUT extension, INOUT fileName);
            if (extension) //extension found
            {
                strncpy_r(OUT mediaObject.title, IN (const char *)fileName, IN sizeof(mediaObject.title));
            }
            free(fileName);

            VARTRACE5(mediaObject.title, mediaObject.MetadataField1, mediaObject.MetadataField2, mediaObject.MetadataField3, mediaObject.MetadataField4);
        }

        return returnValue;
    }
#if 0 //NCG3D-52258
    tReturnValue USBControl::CollectData(const tMountPoint mountPoint)
    {
        ENTRY_INTERNAL
        VARTRACE(mountPoint);

        tReturnValue returnValue = TRUE;

        if(0 == LocalSPM::GetDataProvider().CollectMetadata())
        {
            //ETG_TRACE_USR1(("No metadata extraction configured"));
            return TRUE;
        }

        /* Collect data together */
        /* Only a few parts of the media object are filled if it is taken from a LTY_FILELIST_UNSORTED list
         * mediaObject.objectID
         * mediaObject.fileName
         * mediaObject.fileType
         * mediaObject.fileFormat
         * mediaObject.title (= mediaObject.fileName without path but with extension)
         * mediaObject.deviceID
         * mediaObject.deviceType
         * mediaObject.deviceVersion
         * mediaObject.mountPoint
         * mediaObject.catType
         * mediaObject.mediaType
         * mediaObject.albumArtString
         *
         * The rest has to be added here
         */

        //tph: TODO ReadMetadata in thread

        tURL completeFileName;
        strncpy_r(OUT completeFileName, IN m_ScanMediaObject.mountPoint, IN sizeof(completeFileName));
        strncat_r(OUT completeFileName, IN m_ScanMediaObject.fileName, IN sizeof(completeFileName));

        m_ScanMediaObject.metadataConvertFlag = 0;
        if(MTY_MUSIC_FILE == m_ScanMediaObject.mediaType)
        {
            ReadAudioMetadataFromFile(INOUT m_ScanMediaObject, IN completeFileName);

            if(LocalSPM::GetDataProvider().IsAlbumArtSupported(IN m_ScanMediaObject.deviceType))
            {
                /*overwrite the albumart string as filename (without mountpoint) for storing in DB, else it is with mountpoint*/
                strncpy_r(OUT m_ScanMediaObject.albumArtString, IN m_ScanMediaObject.fileName, IN sizeof(m_ScanMediaObject.albumArtString));
            }
        }
        else if(MTY_VIDEO == m_ScanMediaObject.mediaType)
        {
            returnValue = ReadVideoMetadataFromFile(INOUT m_ScanMediaObject, IN completeFileName);

            if(LocalSPM::GetDataProvider().IsAlbumArtSupported(IN m_ScanMediaObject.deviceType))
            {
                /*overwrite the albumart string as filename (without mountpoint) for storing in DB, else it is with mountpoint*/
                strncpy_r(OUT m_ScanMediaObject.albumArtString, IN m_ScanMediaObject.fileName, IN sizeof(m_ScanMediaObject.albumArtString));
            }
        }
        else if(MTY_IMAGE == m_ScanMediaObject.mediaType)
        {
            returnValue = ReadImageMetadataFromFile(INOUT m_ScanMediaObject, IN completeFileName);
        }
        else if (MTY_PLAYLIST == m_ScanMediaObject.mediaType)
        {
            /* Set the playlist name in tag1 to the title without extension*/
            FastUTF8::tString extension;
            FastUTF8::tString fileName = (FastUTF8::tString)strdup(m_ScanMediaObject.title);
            FastUTF8::SplitExtension(OUT extension, INOUT fileName);
            strncpy_r(OUT m_ScanMediaObject.MetadataField1, IN(char*)fileName, IN sizeof(m_ScanMediaObject.MetadataField1));
            free(fileName);
        }
        else
        {
            ETG_TRACE_ERR(("USBControl::CollectData -> Cannot extract meta data because of wrong media type"));
        }

        return returnValue;
    }
#endif

    void USBControl::CollectData(const tMountPoint mountPoint)
    {
        ENTRY_INTERNAL
        VARTRACE(mountPoint);

        RegisterReleaseEvent(PUT_METADATA,(char *)NULL,USB_CTRL_SM_METADATA_ANSWER_TIMEOUT_MS);

        if(LocalSPM::GetDataProvider().ControlCPUThtreadLoad()){
            LocalSPM::GetThreadFactoryLowprio().Do(IN this, FUNCTION_ID_READMETADATA_FOR_INDEXING, NULL);
        }
        else
        {
            /*Create a worker thread to read metadata from file */
            LocalSPM::GetThreadFactory().Do(IN this, FUNCTION_ID_READMETADATA_FOR_INDEXING, NULL);
        }
    }

    void USBControl::RemoveDirectoriesFromContext(const tIndex deviceIndex)
    {
        ENTRY

        /* Release temporary lists of each directory */
        tListID dbListID = LIST_ID_NONE;
        for( tUInt i = 0; i < m_ScanContext[deviceIndex].dirContext.size(); i++ )
        {
            dbListID = m_ScanContext[deviceIndex].dirContext[i].listID;

            if( LIST_ID_NONE != dbListID )
            {
                LocalSPM::GetDBManager().ReleaseAccess(IN dbListID);

                tResult ret = LocalSPM::GetDBManager().ReleaseDBList(IN dbListID);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while releasing old list (ErrorCode:%s)", errorString(ret)));
                }
            }
        }

        if( 0 < m_ScanContext[deviceIndex].dirContext.capacity() )
        {
            vector<tDirectoryContext>().swap(m_ScanContext[deviceIndex].dirContext); //used instead of clear to guarantee a memory reallocation
        }
    }

    void USBControl::ForgetScan(const tIndex deviceIndex)
    {
        RemoveDirectoriesFromContext(deviceIndex);

        m_ScanContext[deviceIndex].firstPath[0] = 0;
        m_ScanContext[deviceIndex].deep = 0;
        m_ScanContext[deviceIndex].firstElementRow = ROW_NUMBER_NONE;
    }

    tResult USBControl::RemoveDeviceFromContext(const tIndex deviceIndex)
    {
        ENTRY
        VARTRACE(deviceIndex);

        /* Remove scan context entry for this device */
        //m_ScanContext[deviceIndex].dirContext.clear();
        RemoveDirectoriesFromContext(deviceIndex);

        m_ScanContext.erase(m_ScanContext.begin() + deviceIndex);

        return MP_NO_ERROR;
    }

#if 0
    tBoolean ExtractAlbumArtFromMP4(const tAlbumArt albumArtString, tAlbumArtObjectPtr &albumArtObjectPtr)
    {
        ENTRY_INTERNAL
        VARTRACE(albumArtString);

        TagLib::MP4::File mp4File(albumArtString);

        if(!mp4File.isValid())
            return false;

        TagLib::MP4::Tag* tag = mp4File.tag();

        TagLib::MP4::CoverArtList coverArtList = tag->itemListMap()["covr"].toCoverArtList();
        if((coverArtList.isEmpty()) || (coverArtList.size() == 0))
        {
            ETG_TRACE_USR3(("ExtractAlbumArtFromMP4 -> Cover Art list is empty for url: %s", albumArtString));
            return false;
        }

        TagLib::MP4::CoverArt coverArt = coverArtList.front();
        if(coverArt.data().isNull() || coverArt.data().isEmpty())
            return false;

        albumArtObjectPtr = new tAlbumArtObject;    //Has to be deleted by the user i.e DataProvider
        albumArtObjectPtr->imageSize = coverArt.data().size();
        albumArtObjectPtr->imageData = (tImageData)malloc(albumArtObjectPtr->imageSize);
        if(albumArtObjectPtr->imageData) memcpy ( albumArtObjectPtr->imageData, coverArt.data().data(), albumArtObjectPtr->imageSize );

        albumArtObjectPtr->sizeX = 256;//TODO :Not available via taglib ??;
        albumArtObjectPtr->sizeY = 256;//Not available via taglib ??;

        if(coverArt.format() == TagLib::MP4::CoverArt::JPEG)
            albumArtObjectPtr->mimeType = MMT_JPG;
        else if(coverArt.format() == TagLib::MP4::CoverArt::PNG)
            albumArtObjectPtr->mimeType = MMT_PNG;

        return true;
    }
#endif

#if 0
    tBoolean ExtractAlbumArtFromWMA(const tAlbumArt albumArtString, tAlbumArtObjectPtr &albumArtObjectPtr)
    {
        ENTRY_INTERNAL
        VARTRACE(albumArtString);

        //TODO : Use latest TagLib v1.8 which has more improved API for reading the Picture for WMA format
        //        and enable the below code section
#if 0
        TagLib::ASF::File  wmaFile(albumArtString);

        if(wmaFile.isValid())
        {
            TagLib::ASF::Tag* tag = wmaFile.tag();

            TagLib::ASF::AttributeList attributeList;

            if(!tag->isEmpty())
            {
                attributeList = tag->attributeListMap()["WM/Picture"];

                if(!attributeList.isEmpty() && (0 < attributeList.size()))
                {
                    TagLib::ASF::Attribute attribute = attributeList.front();
                    TagLib::ASF::Picture picture = attribute.toPicture();
                    if(picture.isValid())
                    {
                        albumArtObjectPtr = new tAlbumArtObject;    //Has to be deleted by the user i.e DataProvider
                        albumArtObjectPtr->mimeType = ConvertMimeType(picture.mimeType().toCString());
                        albumArtObjectPtr->imageSize = picture.picture().size();
                        albumArtObjectPtr->imageData = (tImageData)malloc(albumArtObjectPtr->imageSize);
                        if(albumArtObjectPtr->imageData) memcpy ( albumArtObjectPtr->imageData, picture.picture().data(), albumArtObjectPtr->imageSize ) ;
                        albumArtObjectPtr->sizeX = 256;//TODO :Not available via taglib ??;
                        albumArtObjectPtr->sizeY = 256;//Not available via taglib ??;
                        return true;
                    }
                }
            }
        }
#else
        (void)albumArtObjectPtr;
#endif

        return false;
    }
#endif

#if 0
    tBoolean ExtractAlbumArtFromID3v2(const TagLib::ID3v2::Tag *id3v2tag, tAlbumArtObjectPtr &albumArtObjectPtr)
    {
        albumArtObjectPtr = 0;
        if ( !id3v2tag || id3v2tag->isEmpty() )
        {
            ETG_TRACE_USR3(("ExtractAlbumArtFromID3v2 -> No id3v2tag available"));
            return 0;
        }

        TagLib::ID3v2::FrameList frameList ;
        TagLib::ID3v2::AttachedPictureFrame *pictureFrame ;
        frameList = id3v2tag->frameListMap()["APIC"] ;

        if (!frameList.isEmpty() )
        {
            for(TagLib::ID3v2::FrameList::ConstIterator it = frameList.begin(); it != frameList.end(); ++it)
            {
                // extract the image
                pictureFrame = static_cast<TagLib::ID3v2::AttachedPictureFrame *>(*it); //lint -e1774 cannot use dynamic_cast because RTTI is not enabled

                if(pictureFrame->picture().isEmpty())
                    continue;

                //create album art object from the extracted image information
                albumArtObjectPtr = new tAlbumArtObject;    //Has to be deleted by the user i.e DataProvider
                albumArtObjectPtr->mimeType = ConvertMimeType(pictureFrame->mimeType().toCString());
                albumArtObjectPtr->imageSize = pictureFrame->picture().size() ;
                albumArtObjectPtr->imageData = (tImageData)malloc(albumArtObjectPtr->imageSize);
                if(albumArtObjectPtr->imageData) memcpy ( albumArtObjectPtr->imageData, pictureFrame->picture().data(), albumArtObjectPtr->imageSize ) ;
                albumArtObjectPtr->sizeX = 256;//TODO :Not available via taglib ??;
                albumArtObjectPtr->sizeY = 256;//Not available via taglib ??;
                break;
            }
        }
        else
        {
            ETG_TRACE_USR3(("ExtractAlbumArtFromID3v2 -> frameList is empty"));
        }
        return (albumArtObjectPtr != 0);
    }
#endif

    void USBControl::DoGetAlbumArtThread(const char *albumArtString)
    {
        ENTRY

        if(albumArtString)
        {
            tAlbumArtObjectPtr albumArtObjectPtr = NULL;
            ReadAlbumArtFromFile(OUT albumArtObjectPtr, IN albumArtString);

            SendAlbumArtAnswer(albumArtObjectPtr);

            delete[] albumArtString;
        }
    }

    tReturnValue USBControl::ReadAlbumArtFromFile(tAlbumArtObjectPtr &albumArtObjectPtr, const tAlbumArt albumArtString)
    {
        ENTRY
        VARTRACE(albumArtString);

        tReturnValue returnValue = FALSE;
        tResult res = MP_NO_ERROR;
        Info *info;
        string target((const char *)albumArtString);

        tDeviceID deviceID;
        tDeviceInfo deviceInfo;
        /* get the device id out of the album art string */
        res = LocalSPM::GetDBManager().GetDeviceFromAlbumArtString(OUT deviceID, IN albumArtString);
        if(MP_NO_ERROR ==  res)
        {
            /* get device infos to get the device type */
            res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
            if(DTY_MUSICBOX != deviceInfo.deviceType)
            {
                //info = Info::create_tag_info(IN target);
                if(LocalSPM::GetDataProvider().FirstAvailableCoverArtSupport())
                {
                    info = Info::create_tag_info_for_cover_art(IN target, IN true /*allCoverType*/);
                }
                else
                {
                    info = Info::create_tag_info_for_cover_art(IN target);
                }

                if(info)
                {
                    int imageSize = 0;
                    char *imageData = NULL;
                    ImageType imageType = IMAGE_TYPE_UNKNOWN;

                    if(info->read())
                    {
                        if(!info->get_image(OUT imageData, OUT imageSize, OUT imageType))
                        {
                            ETG_TRACE_ERR(("USBControl::DoGetAlbumArtThread error getting image for %s", albumArtString));
                        }
                        else if(imageSize <= 0)
                        {
                            ETG_TRACE_ERR(("USBControl::DoGetAlbumArtThread error albumart size is 0"));
                        }
                        else if(imageSize > (LocalSPM::GetDataProvider().MaximumAlbumArtSizeInMB() * 1024 * 1024))
                        {
                            ETG_TRACE_ERR(("USBControl::DoGetAlbumArtThread error albumart size is above the configured limit %d>%d", imageSize, (LocalSPM::GetDataProvider().MaximumAlbumArtSizeInMB() * 1024 * 1024)));
                        }
                        else
                        {
                            if (!albumArtObjectPtr) albumArtObjectPtr = new tAlbumArtObject;    //Has to be deleted by the user i.e DataProvider

                            switch(imageType)
                            {
                                case IMAGE_TYPE_PNG:
                                    albumArtObjectPtr->mimeType = MMT_PNG;
                                    break;
                                case IMAGE_TYPE_JPEG:
                                    albumArtObjectPtr->mimeType = MMT_JPG;
                                    break;
                                case IMAGE_TYPE_GIF:
                                    albumArtObjectPtr->mimeType = MMT_GIF;
                                    break;
                                case IMAGE_TYPE_BMP:
                                    albumArtObjectPtr->mimeType = MMT_BMP;
                                    break;
                                default:
                                    ETG_TRACE_ERR(("taginfo reading albumart returns mimetype as IMAGE_TYPE_UNKNOWN"));
                                    albumArtObjectPtr->mimeType = MMT_PNG;
                                    break;
                            }

                            albumArtObjectPtr->imageSize = imageSize;
                            albumArtObjectPtr->imageData = (tImageData)malloc(imageSize);
                            if(albumArtObjectPtr->imageData) memcpy ( albumArtObjectPtr->imageData, imageData, albumArtObjectPtr->imageSize ) ;

                            albumArtObjectPtr->sizeX = 256;//Not available via taglib/MediaInfo/TagInfo ??;
                            albumArtObjectPtr->sizeY = 256;
                        }
                    }
                    else
                    {
                        ETG_TRACE_ERR(("taginfo error reading tag for ->(%s)",albumArtString));
                    }
                    delete info;

                    // free the allocated image data (is not part of info object)
                    if (imageData)
                    {
                        delete [] imageData;
                        //free(imageData);
                    }
                }
            }
            if(((LocalSPM::GetDataProvider().AlbumArtFromFromSeparateFile())
                    &&
                    (!albumArtObjectPtr)) || (DTY_MUSICBOX == deviceInfo.deviceType))
            {
                ETG_TRACE_USR1(("Either album art not found for file (%s) or album art size might exceeded Maximum size of 4MB. Look for image file in the folder or its musicbox source", albumArtString));
                ReadAlbumArtFromSeparateFile(OUT albumArtObjectPtr, IN albumArtString);
            }
        }

        if(albumArtObjectPtr)
        {
            strncpy_r(OUT albumArtObjectPtr->albumArtString, IN albumArtString, IN sizeof(albumArtObjectPtr->albumArtString));
            returnValue = TRUE;
        }

        return returnValue;
    }

    tResult USBControl::ReadAlbumArtFromSeparateFile(tAlbumArtObjectPtr &albumArtObjectPtr, const tAlbumArt albumArtString) const
    {
        ENTRY
        tBoolean found = FALSE;
        FastUTF8::tString folderPath;
        FastUTF8::tString fileName;
        if(!strlen_r(albumArtString)) return -1;

        folderPath = (FastUTF8::tString)strdup(albumArtString);
        FastUTF8::Split(OUT fileName, INOUT folderPath); //Split full name into filename and path

        DIR *pDIR = opendir((const char *)folderPath);
        struct dirent *entry;
        if( pDIR )
        {
            entry = readdir(pDIR);
            FILE *fpImage = NULL;
            size_t result = 0;
            while( entry && !found )
            {
                if( strcmp(entry->d_name, ".") != 0 && strcmp(entry->d_name, "..") != 0 )
                {
                    //check for file extension
                    const char* imageExtensions[] = {".png",".jpg",".gif",".bmp"};

                    for(tUInt iter = 0 ; iter < sizeof(imageExtensions)/sizeof(imageExtensions[0]); iter++)
                    {
                        if (FastUTF8::EndsWith((const FastUTF8::tString)(entry->d_name), (const FastUTF8::tString)(imageExtensions[iter]))) //lint -e1773
                        {
                            tURL fullpath;
                            strncpy_r(OUT fullpath, IN (const char *)folderPath, IN sizeof(fullpath));
                            strncat_r(OUT fullpath, IN "/", IN sizeof(fullpath));
                            strncat_r(OUT fullpath, IN entry->d_name, IN sizeof(fullpath));

                            /* get the file size */
                            struct stat statBuffer;
                            tUInt imageSize = 0;
                            if ( stat(fullpath, &statBuffer) ) break;

                            imageSize = (tUInt)statBuffer.st_size;
                            if(imageSize <= 0) break;
                            else if(imageSize > (LocalSPM::GetDataProvider().MaximumAlbumArtSizeInMB() * 1024 * 1024)) break;

                            /* read in the file */
                            fpImage = fopen(fullpath, "rb");
                            if (!fpImage) break;

                            /* allocate memory */
                            /* allocate memory */
                            if (!albumArtObjectPtr)
                            {
                                albumArtObjectPtr = new tAlbumArtObject;    //Has to be deleted by the user i.e DataProvider
                                if(NULL == albumArtObjectPtr)
                                {
                                    ETG_TRACE_ERR((" Memory allocation failed! "));
                                    break;
                                }
                            }
                            strncpy_r(OUT albumArtObjectPtr->albumArtString, IN albumArtString, IN sizeof(albumArtObjectPtr->albumArtString));
                            albumArtObjectPtr->imageSize = imageSize;
                            albumArtObjectPtr->mimeType = ConvertMimeType(imageExtensions[iter]);
                            albumArtObjectPtr->sizeX = 256;//Todo : how to get the size info (width * height)
                            albumArtObjectPtr->sizeY = 256;

                            albumArtObjectPtr->imageData = (tImageData)malloc(imageSize);
                            if (!albumArtObjectPtr->imageData)
                            {
                                delete albumArtObjectPtr;
                                albumArtObjectPtr = NULL;
                                break;
                            }
                            result = fread(albumArtObjectPtr->imageData, 1, imageSize, fpImage);
                            if(result != imageSize)
                            {
                                ETG_TRACE_ERR((" Reading error! "));
                                VARTRACE(result);
                            }
                            VARTRACE(entry->d_name);
                            VARTRACE(imageSize);
                            found = TRUE;
                            break;
                        }
                    }
                }
                entry = readdir(pDIR);
            }
            if(NULL != fpImage)
            {
                fclose(fpImage);
                fpImage = NULL;
            }
            closedir(pDIR);
        }
        free(folderPath);

        if(!albumArtObjectPtr)
        {
            ETG_TRACE_USR1(("No album art information found for file (%s)", albumArtString));
        }

        return MP_NO_ERROR;
    }

    tResult USBControl::SetScanMode(const tDeviceType deviceType, const tDeviceID deviceID, const tScanMode scanMode)
    {
        ENTRY
        VARTRACE(deviceType);
        VARTRACE(deviceID);
        VARTRACE(scanMode);

        tResult ret = MP_NO_ERROR;

        if((LocalSPM::GetDataProvider().TrackScanningSupported())
                &&
                (LocalSPM::GetDataProvider().IsDeviceSupportTrackScanning(deviceType)))
        {
            m_ScanMode = scanMode;

            char messageString[64];
            strncpy_r(messageString, "PlayerManagerSM::SCAN_MODE_STATUS", sizeof(messageString));
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);

            ret = LocalSPM::GetPlayerManager().ParameterSCAN_MODE_STATUS( OUT parameterString, IN size, IN deviceID, IN m_ScanMode);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            }
            else
            {
                ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
                }
            }
        }
        else
        {
            ETG_TRACE_ERR(("Scan Not Supported"));
        }
        return ret;
    }

    tResult USBControl::SendVideoProperty()
    {
        ENTRY

        tResult ret = MP_NO_ERROR;
        me::vprops_t meVideoProperties;

        ret = LocalSPM::GetDBManager().GetVideoProperties(meVideoProperties);
        if(MP_NO_ERROR == ret)
        {
            VARTRACE(meVideoProperties);
            /* send the ME event to set the video properties here */
            char messageString[64];
            strncpy_r(OUT messageString, IN "MediaEngineSM::SET_VIDEO_PROPERTIES", IN sizeof(messageString));

            tPEStateString args;

            SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "iiiiiii", (int)meVideoProperties.brightness(),
                    (int)meVideoProperties.hue(), (int)meVideoProperties.saturation(),
                    (int)meVideoProperties.contrast(), (int)meVideoProperties.brightnessoffset(),
                    (int)meVideoProperties.saturationoffset(), (int)meVideoProperties.hueoffset());

            ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN args);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
        else
        {
            ETG_TRACE_ERR(("Error while retrieving video properties from DB "));
        }
        return ret;
    }
    tResult USBControl::SendNoResponseMsg(const tResponseMsg response)
    {
        ENTRY
        tResult ret = MP_NO_ERROR;
        ETG_TRACE_USR3(("USBControl::SendNoResponseMsg %d", response));
        if(m_response != response)
        {
            ret = LocalSPM::GetOutputWrapper().UpdateStreamingInfo();
        }
        m_response = response;
        return ret;
    }
    tResult USBControl::getStreamingInfo(OUT tResponseMsg &info)
    {
        ENTRY
        info = m_response;
        return MP_NO_ERROR;
    }

    tResult USBControl::ReadVideoThumbnailFromFile(OUT tAlbumArtObjectPtr &ThumbNailObjectPtr, IN tAlbumArt ThumbNailString, IN tSize Width, IN tSize Height, IN tMimeType MimeType)
    {
        ENTRY
        VARTRACE(ThumbNailString);
        ETG_TRACE_USR1(("USBControl::ReadVideoThumbnailFromFile ThumbNailString=%s",ThumbNailString));
        tResult retval = MP_NO_ERROR;
        string path(ThumbNailString);
        tThumbnailImage image;
        image.imageBlob.imageData = NULL;
        image.imageBlob.imageSize = 0;
        image.sizeX = 0;
        image.sizeY = 0;
        FastUTF8::tString filename = (FastUTF8::tString) ThumbNailString;
        FastUTF8::tString absolutefilename;

        FastUTF8::Split(OUT absolutefilename,INOUT filename);
        Info *info = Info::create_tag_info_for_video_thumbnail();
        if(info)
        {
            if(!info->read(path, LocalSPM::GetDataProvider().VideoThumbnailDuration(), USE_VIDEO_THUMBNAIL_TIMEOUT))
            {
                retval = info->GetThumbnailBuf(&image.imageBlob.imageData,image.imageBlob.imageSize,image.sizeX,image.sizeY);

                if(!retval && image.imageBlob.imageData)
                {
                    strncpy_r(OUT image.string,IN ThumbNailString,IN strlen_r(ThumbNailString));
                    if(LocalSPM::GetDataProvider().GetThumbNailObject(ThumbNailObjectPtr, image, Width, Height, MimeType,(const char*)absolutefilename))
                    {
                        ETG_TRACE_ERR(("Error ReadVideoThumbnailFromFile Save image"));
                    }
                    if(image.imageBlob.imageData)
                        free(image.imageBlob.imageData);
                }
            }
            else{
                retval = -1;
            }
            delete info;
        }
        VARTRACE(retval);
        return retval;
    }
    tReturnValue USBControl::ReadAudioMetadataFromCdRom(tMediaObject &mediaObject, const tURL completeFileName)
    {
        ENTRY
        tArg arg;
        arg.pObj = this;
        arg.FileName = completeFileName;
        arg.mediaObject = mediaObject;
        pthread_t ThreadHandle;
        pthread_attr_t ThreadAttr;
        struct timespec ts;
        tResult res = MP_NO_ERROR;
        tReturnValue returnValue = TRUE;
        bool bNeedsToSkip = true;

        // set the default thread attributes
        if(pthread_attr_init(&ThreadAttr) != 0)
        {
            ETG_TRACE_ERR(("pthread_attr_init: err" ));
            return false;
        }

        // set the size of the stack. Default stack size is too small.
        pthread_attr_setstacksize(&ThreadAttr, DEFAULT_STACKSIZE);
        /** Below line is corrently commented because Scope2 skip to next track always     */
        //bNeedsToSkip = (mThreadCount < CDROM_METADATA_MAX_COUNT);

        if(!bNeedsToSkip)
        {
            ETG_TRACE_ERR(("Count already reached to max %d",mThreadCount));
            /*Remove CDROM from Audio if Maximum try read is getting failed*/
            mThreadCount = 0;
            HandleActionError(REASON_DEVICE_ERROR);
        }
        else
        {
            string target((const char *)completeFileName);
            Info *info = Info::create_tag_info(IN target);
            if(info)
            {
                arg._info = (void*)info;
                // create the thread
                res = pthread_create(&ThreadHandle, &ThreadAttr, &USBControl::startFunction, (void*)&arg);
                if (res)
                {
                    ETG_TRACE_FATAL(("pthread_create: err=%d", res));
                    delete info;
                    return false;
                }
                if (clock_gettime(CLOCK_REALTIME, &ts) == -1) {
                    /* Handle error */
                    ETG_TRACE_ERR(("clock_gettime: err"));
                }
                else
                {
                    ts.tv_sec += CDROM_METADATA_TIME_OUT;
                    if((res = pthread_timedjoin_np(ThreadHandle, NULL, &ts)) != 0) // non blocking wait
                    {
                        ETG_TRACE_ERRMEM(("pthread_timedjoin_np: err %d",res));
                        delete info;
                        ForwardStreamError(REASON_READ_ERROR);  // skip to next playble track
                        mThreadCount++; // Increase error counter
                        returnValue = FALSE;
                        ETG_TRACE_ERRMEM(("pthread_timedjoin_np: cancel thread"));
                        pthread_detach(ThreadHandle);
                        pthread_cancel(ThreadHandle); // cancel thread for abnornmal exit
                        ETG_TRACE_ERRMEM(("pthread_timedjoin_np: end"));
                        ETG_TRACE_ERR(("pthread_timedjoin_np: err %d",res));
                    }
                    else
                    {
                        mThreadCount = 0; // reset counter for discontinious error
                    }
                }
                if(returnValue)
                {
                    delete info; //delete Info
                    memcpy(&mediaObject, &mMediaObjectCd, sizeof(mMediaObjectCd));// copy the metadata Saved in new thread
                    VARTRACE5(mediaObject.title, mediaObject.MetadataField1, mediaObject.MetadataField2, mediaObject.MetadataField3, mediaObject.MetadataField4);
                }
            }
        }
        //  destroy attribute
        pthread_attr_destroy ( &ThreadAttr);
        return returnValue;
    }
    void *USBControl::startFunction(void *context) // Thread function call to read metadata
    {
        ENTRY
        tArg *ctx = (tArg *)context;

        if(ctx == NULL)
        {
            return NULL;
        }

        LocalSPM::GetThreadFactory().SetName("USBControl_CdRom_1");
        // set the thread property to enable the cancellation later on
        pthread_setcancelstate(PTHREAD_CANCEL_ENABLE ,NULL);
        pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS ,NULL);
        USBControl *Obj = ctx->pObj;
        tMediaObject mediaObject = ctx->mediaObject;
        if(Obj && ctx->FileName)
        {
            Obj->ReadAudioMetadataFromFile(mediaObject, ctx->FileName,ctx->_info);
            VARTRACE5(mediaObject.title, mediaObject.MetadataField1, mediaObject.MetadataField2, mediaObject.MetadataField3, mediaObject.MetadataField4);
            memcpy(&Obj->mMediaObjectCd,&mediaObject,sizeof(mediaObject));
        }
        else{
            ETG_TRACE_ERR(("startFunction: Argument err "));
        }
        // end of thread
        ETG_TRACE_USR1(("thread : stopping"));
        return NULL;
    }

    tFileOperationErrorCodes USBControl::EditMetadataOfURL(IN tEditMetaDataByUrl &editMetaDataByUrl)
    {
        ENTRY
        VARTRACE(editMetaDataByUrl);
        tFileOperationErrorCodes ret = FILE_OPERATION_OK;
        tMediaObject mediaObject;
        tDeviceInfo deviceInfo;
        tObjectID MediaObjectTag = OBJECT_ID_NONE;
        tYomiMetadata yomiMetadata;

        tResult result = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN editMetaDataByUrl.deviceID);
        if(result)
        {
            ETG_TRACE_USR4(("EditMetadata device not found %d ",editMetaDataByUrl.deviceID));
            ret = DEVICE_NOT_EXISITS;
        }
        else
        {
            tURL completeFileName;
            strncpy_r(OUT completeFileName, IN deviceInfo.mountPoint, IN sizeof(completeFileName));
            strncat_r(OUT completeFileName, IN editMetaDataByUrl.MediaObjectUrl, IN sizeof(completeFileName));
            ETG_TRACE_USR4(("EditMetadataOfURL need to edit the file %s", completeFileName));
            Info *info = Info::create_tag_info(IN string(completeFileName));
            if(info)
            {
                info->read();
                if(LocalSPM::GetDataProvider().CodeSetConversionSupported())
                {
                    /*Invoked to find and Convert the Non UTF-8 metadata strings(given by LibTagInfo) to valid UTF-8 Metadata - RoadMap:15004*/
                    LocalSPM::GetDataProvider().FindAndConvertLatin1MetadataEntries(INOUT mediaObject,IN (void*)info);
                }
                else
                {
                    strncpy_r(OUT mediaObject.MetadataField1, IN info->get_genre().toCString(true), IN sizeof(mediaObject.MetadataField1));
                    strncpy_r(OUT mediaObject.MetadataField2, IN info->get_artist().toCString(true), IN sizeof(mediaObject.MetadataField2));
                    strncpy_r(OUT mediaObject.MetadataField3, IN info->get_composer().toCString(true), IN sizeof(mediaObject.MetadataField3));
                    strncpy_r(OUT mediaObject.MetadataField4, IN info->get_album().toCString(true), IN sizeof(mediaObject.MetadataField4));
                    strncpy_r(OUT mediaObject.title, IN info->get_title().toCString(true), IN sizeof(mediaObject.title));
                }

                if(strlen_r(editMetaDataByUrl.GenreField))
                {
                    ETG_TRACE_USR4(("EditMetadataOfURL need to set GenreField"));
                    info->set_genre(editMetaDataByUrl.GenreField);
                }
                else
                {
                    ETG_TRACE_USR4(("EditMetadataOfURL need to get GenreField"));
                    strncpy_r(editMetaDataByUrl.GenreField,mediaObject.MetadataField1,sizeof(editMetaDataByUrl.GenreField));
                }
                if(strlen_r(editMetaDataByUrl.AlbumField))
                {
                    ETG_TRACE_USR4(("EditMetadataOfURL need to set AlbumField"));
                    info->set_album(editMetaDataByUrl.AlbumField);
                }
                else
                {
                    ETG_TRACE_USR4(("EditMetadataOfURL need to get AlbumField"));
                    strncpy_r(editMetaDataByUrl.AlbumField,mediaObject.MetadataField4,sizeof(editMetaDataByUrl.AlbumField));
                }
                if(strlen_r(editMetaDataByUrl.ArtistField))
                {
                    ETG_TRACE_USR4(("EditMetadataOfURL need to set ArtistField"));
                    info->set_artist(editMetaDataByUrl.ArtistField);
                }
                else
                {
                    ETG_TRACE_USR4(("EditMetadataOfURL need to get ArtistField"));
                    strncpy_r(editMetaDataByUrl.ArtistField,mediaObject.MetadataField2,sizeof(editMetaDataByUrl.ArtistField));
                }
                if(strlen_r(editMetaDataByUrl.TitleField))
                {
                    ETG_TRACE_USR4(("EditMetadataOfURL need to set TitleField"));
                    info->set_title(editMetaDataByUrl.TitleField);
                }
                else
                {
                    ETG_TRACE_USR4(("EditMetadataOfURL need to get TitleField"));
                    strncpy_r(editMetaDataByUrl.TitleField,mediaObject.title,sizeof(editMetaDataByUrl.TitleField));
                }
                if(strlen_r(editMetaDataByUrl.ComposerField))
                {
                    ETG_TRACE_USR4(("EditMetadataOfURL need to set ComposerField"));
                    info->set_composer(editMetaDataByUrl.ComposerField);
                }
                else
                {
                    ETG_TRACE_USR4(("EditMetadataOfURL need to get ComposerField"));
                    strncpy_r(editMetaDataByUrl.ComposerField,mediaObject.MetadataField3,sizeof(editMetaDataByUrl.ComposerField));
                }
                if(editMetaDataByUrl.YearField)
                {
                    info->set_year(editMetaDataByUrl.YearField);
                }
                else
                {
                    editMetaDataByUrl.YearField=(tU16)info->get_year();
                }
                /* Yomi Metadata Edit*/
                if(strlen_r(editMetaDataByUrl.yomiMetaData.YomiTitle))
                {
                    strncpy_r(yomiMetadata.YomiTitle,editMetaDataByUrl.yomiMetaData.YomiTitle,sizeof(tMetadata));
                }
                if(strlen_r(editMetaDataByUrl.yomiMetaData.YomiArtist))
                {
                    strncpy_r(yomiMetadata.YomiArtist,editMetaDataByUrl.yomiMetaData.YomiArtist,sizeof(tMetadata));
                }
                if(strlen_r(editMetaDataByUrl.yomiMetaData.YomiAlbum))
                {
                    strncpy_r(yomiMetadata.YomiAlbum,editMetaDataByUrl.yomiMetaData.YomiAlbum,sizeof(tMetadata));
                }

                result = LocalSPM::GetDBManager().GetObjectID(IN MediaObjectTag, MUSICBOX_DEVICE_ID, editMetaDataByUrl.MediaObjectUrl);
                ETG_TRACE_USR4(("Media Object Tag : %d" , MediaObjectTag));
                if(result != MP_NO_ERROR)
                {
                    ret = DATABASE_ERROR;
                }
                else
                {
                    result = LocalSPM::GetDBManager().UpdateYomiMetadata(IN MediaObjectTag, IN yomiMetadata);
                    if(result)
                    {
                        ret = DATABASE_ERROR;
                    }
                }

                if(!info->write())
                {
                    ret = FILEPERM_ISSUE;
                }
                else
                {
                    AssignUnknownText(editMetaDataByUrl.GenreField);
                    AssignUnknownText(editMetaDataByUrl.ArtistField);
                    AssignUnknownText(editMetaDataByUrl.TitleField);
                    AssignUnknownText(editMetaDataByUrl.ComposerField);
                    AssignUnknownText(editMetaDataByUrl.AlbumField);
                }
            }
            else
            {
                ret = TAG_EDIT_ERROR;
            }
        }
        return ret;
    }

    tReturnValue USBControl::CalculateQuickFingerprint(IN tMountPoint mountPoint, IN tDeviceID deviceID, IN tFingerprint lastFingerprint)
    {
        ENTRY
        ETG_TRACE_USR1(("USBControl::CalculateShortFingerprint Entry"));
        VARTRACE(mountPoint);
        VARTRACE(deviceID);
        VARTRACE(lastFingerprint);

        tResult res = MP_NO_ERROR;
        tReturnValue returnValue = TRUE;

        char* commandStr[3]={NULL};
        tFingerprint quickFingerprint = {0};

        tFilename tmpFilenameInterimStat = {0};
        tFilename tmpFilenameInterimStat_md5Sum = {0};
        if(0 > GenerateTempFileName(tmpFilenameInterimStat, "FP_STAT"))
        {
            ETG_TRACE_ERR(("CalculateQuickFingerprint: Cannot construct temp filename with prefix FP_STAT"));
        }
        if(0 > GenerateTempFileName(tmpFilenameInterimStat_md5Sum, "FP_STAT_MD5"))
        {
            ETG_TRACE_ERR(("CalculateQuickFingerprint: Cannot construct temp filename with prefix FP_STAT_MD5"));
        }

        if(0 < strlen_r(tmpFilenameInterimStat))
        {
            FILE * pFileStat = fopen(tmpFilenameInterimStat, "w");
            if (NULL == pFileStat)
            {
                ETG_TRACE_ERR(("CalculateQuickFingerprint: Cannot open file: %s", tmpFilenameInterimStat));
            }
            else
            {
                struct statvfs buffer;
                int ret = statvfs(mountPoint, &buffer);
                if (!ret)
                {
                    fprintf(pFileStat, "Filesystem block size: %ld\n", buffer.f_bsize);
                    fprintf(pFileStat, "Fragment size: %ld\n", buffer.f_frsize);
                    fprintf(pFileStat, "Size of fs in f_frsize units: %ld\n", buffer.f_blocks);
                    fprintf(pFileStat, "Number of free blocks: %ld\n", buffer.f_bfree);
                    fprintf(pFileStat, "Number of free blocks for unprivileged users : %ld\n", buffer.f_bavail);
                    fprintf(pFileStat, "Number of inodes: %ld\n", buffer.f_files);
                    fprintf(pFileStat, "Number of free inodes: %ld\n", buffer.f_ffree);
                    fprintf(pFileStat, "Number of free inodes for unprivileged users: %ld\n", buffer.f_favail);
                    fprintf(pFileStat, "Filesystem ID: %ld\n", buffer.f_fsid);
                    fprintf(pFileStat, "Mount flags: %ld\n", buffer.f_flag);
                    fprintf(pFileStat, "Maximum filename length: %ld\n", buffer.f_namemax);
                    commandStr[0] = (char *)"/usr/bin/md5sum";
                    commandStr[1] = tmpFilenameInterimStat;
                    commandStr[2] = NULL;
                }
                else
                {
                    ETG_TRACE_ERR(("CalculateQuickFingerprint: statvfs failed"));
                }
                fclose(pFileStat);
            }
        }

        //If commandStr to calculate quickFingerprint is setup,then execute it
        if(commandStr[0])
        {
            ETG_TRACE_USR4(("USBControl::CalculateQuickFingerprint: calling executeCommand() for md5sum"));
            int retStatus = executeCommand(commandStr,string(tmpFilenameInterimStat_md5Sum));
            if(0 == retStatus)
            {
                ETG_TRACE_USR3(("USBControl::CalculateQuickFingerprint: executeCommand() success for md5sum"));
                // open and read the checksum
                FILE * pFileResult = fopen (tmpFilenameInterimStat_md5Sum, "r");
                if(NULL == pFileResult)
                {
                    ETG_TRACE_ERR(("Cannot open file: %20s", tmpFilenameInterimStat_md5Sum));
                }
                else
                {
                    if(NULL != fgets(quickFingerprint, sizeof(quickFingerprint), pFileResult))
                    {
                        char *pdest = strstr(quickFingerprint, " ");
                        if(pdest)
                        {
                            *pdest = 0;
                        }
                        VARTRACE(quickFingerprint);
                    }
                    else
                    {
                        ETG_TRACE_ERR(("Cannot open string from stream to read fingerprint: %s", tmpFilenameInterimStat_md5Sum));
                    }
                    fclose(pFileResult);
                }
            }
            else
            {
                ETG_TRACE_ERR(("USBControl::CalculateQuickFingerprint: executeCommand() failed for md5sum. Error:%s",strerror(retStatus)));
            }
        }
        else
        {
            ETG_TRACE_ERR(("command not prepared to do md5sum on the statvfs result.Cannot calculatequickFingerprint"));
        }

        // Compare with the available quick fingerprint in database
        tFingerprint storedQuickFingerprint = {0};
        res = LocalSPM::GetDBManager().GetQuickFingerprint(OUT storedQuickFingerprint, IN deviceID);
        VARTRACE(storedQuickFingerprint);

        // if quick fingerprint is invalid, return false to perfrom complete fingerprinting
        if((strcmp(storedQuickFingerprint, "invalid") == 0) || \
            (strcmp(storedQuickFingerprint, quickFingerprint) != 0) || \
            (strcmp(lastFingerprint, "invalid") == 0))
        {
            returnValue = FALSE;
            res = LocalSPM::GetDBManager().SetQuickFingerprint(IN deviceID, IN quickFingerprint);
            if (MP_NO_ERROR != res)
            {
                ETG_TRACE_ERR(("Error while updating fingerprint at DataProvider (ErrorCode:%s)", errorString(res)));
            }
        }

        if(0 != remove(tmpFilenameInterimStat))
        {
            ETG_TRACE_ERR(("Cannot delete temp file: %s", tmpFilenameInterimStat));
        }
        if(0 != remove(tmpFilenameInterimStat_md5Sum))
        {
            ETG_TRACE_ERR(("Cannot delete temp file: %s", tmpFilenameInterimStat_md5Sum));
        }

        VARTRACE(returnValue);
        return returnValue;
    }

    tResult USBControl::ReadFilesForFingerprintCalc(const tFilename& tmpFilenameInterim, const tMountPoint& mountPoint)
    {
        ENTRY
        VARTRACE(tmpFilenameInterim);
        VARTRACE(mountPoint);

        tResult ret = MP_NO_ERROR;
        ReadSupportedFilesFromDevice readFilesObject;

        tUInt mountPointLen = strlen_r(mountPoint);
        if((0 < strlen_r(tmpFilenameInterim)) && (0 < mountPointLen))
        {
            tFileExtensions fileExtensions;
            fileExtensions = LocalSPM::GetDataProvider().GetSupportedFileExtensions();

            tFileExtensions fileFilters;
            fileFilters = LocalSPM::GetDataProvider().GetSupportedFileFilters();

            bool stopFingerprintCalc = false;
            fingerprintLock.lock();
            stopFingerprintCalc = stopFingerprint;
            fingerprintLock.unlock();

            if(stopFingerprintCalc)
            {
                ETG_TRACE_ERR(("shutdown request received, setting error code"));
                return MP_ABORTED_CALCFINGERPRINT;
            }
            ret = readFilesObject.Initialize(fileExtensions,tmpFilenameInterim,fileFilters,mountPoint);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("USBControl::ReadFilesForFingerprintCalc: Failed to initialize member variables:%s", errorString(ret)));
                readFilesObject.CloseFileObject();
                return ret;
            }
            else
            {
                ret = readFilesObject.ScanDirectory(mountPoint);
                if (MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("USBControl::ReadFilesForFingerprintCalc: ScanDirectory() failed with error:%s", errorString(ret)));
                    readFilesObject.CloseFileObject();
                    return ret;
                }
                else
                {
                    readFilesObject.CloseFileObject();
                    m_NumberOfSupportedFiles = readFilesObject.GetFileCounter();
                    VARTRACE(m_NumberOfSupportedFiles);
                    if (0 == m_NumberOfSupportedFiles)
                    {
                        ETG_TRACE_ERR(("USBControl::ReadFilesForFingerprintCalc: No supported media files found in USB device"));
                    }
                }
            }
        }
        else
        {
            ETG_TRACE_ERR(("USBControl::ReadFilesForFingerprintCalc: input parameters(mountpoint/filename) are NULL"));
            ret = MP_ABORTED_CALCFINGERPRINT;
        }
        return ret;
    }

    ReadSupportedFilesFromDevice::ReadSupportedFilesFromDevice(void)
    {
         ENTRY

         m_FileCounter = 0;
         m_Extensions.clear();
         m_FileFilters.clear();
    }

    void ReadSupportedFilesFromDevice::CloseFileObject()
    {
        ENTRY
        if(m_FileObject.is_open())
        {
            m_FileObject.close();
        }
        else
        {
            ETG_TRACE_ERR(("ReadSupportedFilesFromDevice::CloseFileObject: file is not open"));
        }
    }

    tU64 ReadSupportedFilesFromDevice::GetFileCounter()
    {
        ENTRY

        VARTRACE(m_FileCounter);
        return m_FileCounter;
    }

    tUInt ReadSupportedFilesFromDevice::GetMountPointLen()
    {
        ENTRY

        VARTRACE(m_MountPointLen);
        return m_MountPointLen;
    }

    tResult ReadSupportedFilesFromDevice::Initialize(tFileExtensions &extensions, const string& tmpFileName, tFileExtensions &fileFilters, const tMountPoint& mountPoint)
    {
        ENTRY
        VARTRACE(tmpFileName.c_str());
        tResult result = MP_NO_ERROR;

        if(!tmpFileName.empty())
        {
           m_FileObject.open(tmpFileName.c_str());
           if (!m_FileObject)
           {
               ETG_TRACE_ERR(("ReadSupportedFilesFromDevice::Initialize: cannot open temp file %s",tmpFileName.c_str()));
               result = MP_ABORTED_CALCFINGERPRINT;
           }
           else
           {
               if(0 < extensions.capacity())
               {
                   m_Extensions.clear();
                   m_Extensions = extensions;
                   if(0 < fileFilters.capacity())
                   {
                       m_FileFilters.clear();
                       m_FileFilters = fileFilters;
                       uint16_t mountPointLen = strlen_r(mountPoint);
                       if (0 < mountPointLen)
                       {
                           m_MountPointLen = mountPointLen;
                           strncpy_r(OUT m_MountPoint, IN mountPoint, IN sizeof(mountPoint));
                           VARTRACE(m_MountPointLen);
                           VARTRACE(m_MountPoint);
                       }
                       else
                       {
                           ETG_TRACE_ERR(("ReadSupportedFilesFromDevice::Initialize: mountpoint length is zero"));
                           result = MP_ABORTED_CALCFINGERPRINT;
                       }
                   }
                   else
                   {
                       ETG_TRACE_ERR(("ReadSupportedFilesFromDevice::Initialize: File filters are not copied to m_FileFilters"));
                       result = MP_ABORTED_CALCFINGERPRINT;
                   }
               }
               else
               {
                   ETG_TRACE_ERR(("ReadSupportedFilesFromDevice::Initialize: File extensions are not copied to m_Extensions"));
                   result = MP_ABORTED_CALCFINGERPRINT;
               }
           }
       }
       else
       {
           ETG_TRACE_ERR(("ReadSupportedFilesFromDevice::Initialize: temp file name is empty"));
           result = MP_ABORTED_CALCFINGERPRINT;
       }
       return result;
    }

    tResult ReadSupportedFilesFromDevice::ScanDirectory(const string& absolutePath)
    {
         ENTRY
         tResult result = MP_NO_ERROR;
         bool stopFingerprintCalc = false;
         fingerprintLock.lock();
         stopFingerprintCalc = stopFingerprint;
         fingerprintLock.unlock();

         if((stopFingerprintCalc) || (absolutePath.empty()))
         {
             ETG_TRACE_ERR(("shutdown request received, setting error code"));
             return MP_ABORTED_CALCFINGERPRINT;
         }
         DIR* dir=opendir(absolutePath.c_str());
         if (dir)
         {
             result = ReadFilesFromDirectory(absolutePath,dir);
             if (0 != closedir(dir))
             {
                 ETG_TRACE_ERR(("Failed to close directory: error code=%s)", strerror(errno)));
                 return MP_ABORTED_CALCFINGERPRINT;
             }
         }
         else
         {
            ETG_TRACE_ERR(("opendir failed.errno:%d errmsg:%s",errno,strerror(errno)));
            if((!strcmp(m_MountPoint,absolutePath.c_str())) || ((EACCES != errno) && (EIO != errno))) //Fixed for NCG3D-264588
            {
                result = MP_ABORTED_CALCFINGERPRINT;
            }
            else
            {
                result = MP_ERR_ACTION_ERROR;
            }
         }
         return result;
    }

    tBoolean ReadSupportedFilesFromDevice::isMatchingExtension(const string& extension)
    {
         ENTRY
         if (extension.empty())
         {
             return false;
         }
         if (m_Extensions.empty())
         {
             return true;
         }
         if ( std::find(m_Extensions.begin(), m_Extensions.end(), extension) != m_Extensions.end() )
         {
             return true;
         }
         return false;
    }

    tBoolean ReadSupportedFilesFromDevice::isMatchingFileFilter(const char* fileFilter)
    {
         ENTRY
         if (!fileFilter)
         {
             return false;
         }
         if (m_FileFilters.empty())
         {
             return true;
         }
         int retValue = 0;
         regex_t regex;
         for(unsigned int iter=0; iter < m_FileFilters.size(); iter++)
         {
             if(regcomp(&regex,m_FileFilters[iter].c_str(),REG_ICASE|REG_NOSUB) == 0)
             {
                 retValue = regexec(&regex,fileFilter, 0, NULL, 0);
                 regfree(&regex);
                 if(retValue == 0)
                 {
                     return true;
                 }
             }
         }
         return false;
    }

    tResult ReadSupportedFilesFromDevice::ReadFilesFromDirectory(const string& absolutePath, DIR *dir)
    {
         ENTRY
         std::string extension;
         if (absolutePath.empty() || !dir )
         {
             return MP_ABORTED_CALCFINGERPRINT;
         }
         struct dirent *entry = NULL;
         do
         {
             bool stopFingerprintCalc = false;
             fingerprintLock.lock();
             stopFingerprintCalc = stopFingerprint;
             fingerprintLock.unlock();

             if(stopFingerprintCalc)
             {
                 ETG_TRACE_ERR(("shutdown request received, setting error code"));
                 return MP_ABORTED_CALCFINGERPRINT;
             }
             errno=0;
             entry=readdir(dir);
             if (entry)
             {
                 if (entry->d_type==DT_REG)
                 {
                     bool isMatching=false;
                     extension = entry->d_name;
                     std::size_t pos = extension.find_last_of('.');
                     if (std::string::npos != pos)
                     {
                         extension = extension.substr(pos);
                     }
                     std::transform(extension.begin(), extension.end(), extension.begin(), ::tolower);
                     isMatching = isMatchingExtension(extension);
                     extension.clear();
                     if (isMatching)
                     {
                         std::string filepath;
                         tU32 size=0;
                         tU32 mtime=0;
                         filepath = absolutePath;
                         if (absolutePath[absolutePath.length()-1]!='/')
                         {
                             filepath += "/";
                         }
                         filepath += string(entry->d_name);
                         if (!filepath.empty())
                         {
                             struct stat st = {};
                             if (stat(filepath.c_str(), &st)==0)
                             {
                                 mtime=st.st_mtim.tv_sec;
                                 size=st.st_size;
                             }
                             tUInt slashCount = 1;
                             filepath = filepath.substr(GetMountPointLen() + slashCount);
                             m_FileObject << size << " " << mtime << " " << filepath.c_str() << endl;
                             m_FileCounter++;
                         }
                     }
                 }
                 else if (entry->d_type==DT_DIR)
                 {
                     if (!isMatchingFileFilter(entry->d_name))
                     {
                         string directoryPath=absolutePath + "/" + string(entry->d_name);
                         if (!directoryPath.empty())
                         {
                             tResult result =  ScanDirectory(directoryPath);
                             if(MP_ABORTED_CALCFINGERPRINT == result)
                             {
                                 ETG_TRACE_ERR(("ReadSupportedFilesFromDevice::ReadFilesFromDirectory: ScanDirectory() failed"));
                                 return MP_ABORTED_CALCFINGERPRINT;
                             }
                             else if(MP_NO_ERROR != result)
                             {
                                 ETG_TRACE_ERR(("ReadSupportedFilesFromDevice::ReadFilesFromDirectory: Scandirectory passed with Error %s", strerror(errno)));
                             }
                        }
                    }
                }
            }
            else if (0 != errno)
            {
                ETG_TRACE_ERR(("ReadSupportedFilesFromDevice::ReadFilesFromDirectory: readdir() failed with error %s", strerror(errno)));
                return MP_ABORTED_CALCFINGERPRINT;
             }
         } while ((entry!=NULL) || (entry==NULL && errno!=0));

         return MP_NO_ERROR;
     }
