#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"
//#include "TraceDefinitions.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_DVD_CONTROL
#ifdef TARGET_BUILD
#include "trcGenProj/Header/TouchEventHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_DVD_CONTROL
#endif
#endif

#include "TraceDefinitions.h"

#include "TouchEventHandler.h"
#include <linux/version.h>
#include <linux/input.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <dirent.h>
#include <pthread.h>
#include <string.h>
#include <iostream>
#include <errno.h>
#include "FunctionTracer.h"
using namespace std;




struct query_mode {
    const char *name;
    int event_type;
    int max;
    unsigned int rq;
} query_modes[] = {
        { "EV_ABS", EV_ABS, LED_MAX, EVIOCGLED(LED_MAX) }, //Will be given by Paritosh (EV_ABS)
};

unsigned char toucheventhandler_connected = 0;
unsigned char runMonitor = 1;
pthread_t toucheventhandlerThreadId;
pthread_t *toucheventhandlerThreadPtr;
char *toucheventhandler_device_path = NULL;  
TouchEventListener* TouchEventHandler::m_listener = NULL;


/*******************************************************************************
 *
 * FUNCTION: TouchEventHandler::TouchEventHandler()
 *
 * DESCRIPTION: Constructor.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
TouchEventHandler::TouchEventHandler()
{

    m_bInputPresent = false;
    m_bMonitorThreadStarted = false;
    m_listener = NULL ;
    if(toucheventhandler_device_path == NULL)
    {
        toucheventhandler_device_path = find_input_device(TOUCHEVENT_DEVNAME, TOUCHEVENT_DEVNAME_MATCH_LEN);
    }

}
/*******************************************************************************
 *
 * FUNCTION: TouchEventHandler::~TouchEventHandler(tVoid)
 *
 * DESCRIPTION: Destructor.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
TouchEventHandler::~TouchEventHandler()
{

    m_bInputPresent = false;
    m_bMonitorThreadStarted = false;
    if(toucheventhandler_device_path)
    {
        free(toucheventhandler_device_path);
    }
    m_listener = NULL ;

}
/*******************************************************************************
 *
 * FUNCTION: TouchEventHandler::setEventListener(TouchEventListener* listener)
 *
 * DESCRIPTION: Sets the listener to which the touch events must be passed
 *
 * PARAMETER: TouchEventListener.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/

void TouchEventHandler::setEventListener(TouchEventListener* listener)
{

    m_listener =  listener;
}

/*******************************************************************************
 *
 * FUNCTION: TouchEventHandler::toucheventhandler_monitor_start(tVoid)
 *
 * DESCRIPTION: Starts monitoring the touch event status on another thread
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/


int TouchEventHandler::toucheventhandler_monitor_start(void)
{
    ENTRY
    int fd;
    pthread_attr_t attr;
    if(toucheventhandler_device_path == NULL)
    {
        toucheventhandler_device_path = find_input_device(TOUCHEVENT_DEVNAME, TOUCHEVENT_DEVNAME_MATCH_LEN);
    }
    if(!toucheventhandler_device_path)
    {
        return -1;
    }

    runMonitor = 1;
    pthread_attr_init (&attr);
    ETG_TRACE_USR4(("toucheventhandler_monitor_start: device_path = %s", toucheventhandler_device_path));

    // check if /dev/input/eventX file is available. If not, retry with 200 ms delay
    // it may take 200 ms to populate event file after detection
    if ((fd = open(toucheventhandler_device_path, O_RDONLY)) < 0)
    {
        ETG_TRACE_ERR(("TouchEventHandler::toucheventhandler_monitor_start open = %s failed", toucheventhandler_device_path));
        if (errno == EACCES && getuid() != 0)
        {
            ETG_TRACE_ERR(("TouchEventHandler::toucheventhandler_monitor_start No access for = %s", toucheventhandler_device_path));
        }
        // wait for 200 ms and retry
        usleep(200 * 1000);

        if ((fd = open(toucheventhandler_device_path, O_RDONLY)) < 0)
        {
            ETG_TRACE_ERR(("TouchEventHandler::toucheventhandler_monitor_start open = %s retry failed", toucheventhandler_device_path));
            if (errno == EACCES && getuid() != 0)
            {
                ETG_TRACE_ERR(("TouchEventHandler::toucheventhandler_monitor_start No access for = %s", toucheventhandler_device_path));
            }
        }
        else
        {
            m_bInputPresent = true;
            close(fd);
        }
    }
    else
    {
        m_bInputPresent = true;
        close(fd);
    }


    if(true == m_bInputPresent)
    {
        if(pthread_create(&toucheventhandlerThreadId, &attr, &TouchEventHandler::toucheventhandler_monitor_thread, (void *)toucheventhandler_device_path) < 0)
        {
            runMonitor = 0;
            ETG_TRACE_ERR(("TouchEventHandler::toucheventhandler_monitor_start ->Could not create touch event monitor thread"));
            return -1;
        }
        toucheventhandlerThreadPtr = &toucheventhandlerThreadId;
    }

    return 0;
}


void TouchEventHandler::toucheventhandler_monitor_stop(void)
{
    ENTRY
    runMonitor = 0;
    if(toucheventhandlerThreadPtr)
    {
        pthread_join(toucheventhandlerThreadId, NULL);
        toucheventhandlerThreadPtr = NULL;
    }

}


char* TouchEventHandler::find_input_device(const char* matchName, int matchlen) 
{
    ENTRY

    int fd = -1, index;
    const char *dirname = "/dev/input";
    char devpath[PATH_MAX];
    char* touchdevpath = NULL;
    char name[256];
    char *filename;
    DIR *dir;
    struct dirent *de;

    // try opening directory /dev/input 3 times
    ETG_TRACE_USR4(("TouchEventHandler::find_input_device ##dirname## = %s", dirname));
    for (index = 0; index < EVENT_MAX_RETRY; index ++)
    {
        // Wait for 200 ms and everytime before opening the folder
        usleep(200 * 1000);
        dir = opendir(dirname);
        ETG_TRACE_USR4(("TouchEventHandler::find_input_device open dir ##dir## = %s", dir));
        if(dir == NULL)
        {
            ETG_TRACE_ERR(("TouchEventHandler::find_input_device --> retry opening dir %s", dirname));
            if (index == (EVENT_MAX_RETRY)-1)
            {
                ETG_TRACE_ERR(("TouchEventHandler::find_input_device --> opening dir %s failed", dirname));
                return NULL;
            }
        }
        else
        {
            break;
        }
    }

    strcpy(devpath, dirname);
    ETG_TRACE_USR4(("TouchEventHandler::find_input_device ##devpath## = %s", devpath));
    filename = devpath + strlen(devpath);
    *filename++ = '/';
    ETG_TRACE_USR4(("TouchEventHandler::find_input_device --> Filename = %s", filename));
    while((de = readdir(dir))) 
    {
        ETG_TRACE_USR4(("TouchEventHandler::find_input_device(inside while) --> dir = %s", dir));
        if(strncmp("event", de->d_name, 5) != 0)
        {
            ETG_TRACE_USR4(("TouchEventHandler::find_input_device ##de->d_name## = %s", de->d_name));
            continue;
        }

        strcpy(filename, de->d_name);
        fd = open(devpath, O_RDONLY);
        if (fd < 0)
        {
            ETG_TRACE_USR4(("TouchEventHandler::find_input_device ##error opening file ## = %s", devpath));
            ETG_TRACE_ERR(("TouchEventHandler::find_input_device ##error opening file ## = %s", strerror(errno)));
            continue;
        }

        if (ioctl(fd, EVIOCGNAME(sizeof(name) - 1), &name) < 1) 
        {
            name[0] = '\0';
        }
        close(fd);
        ETG_TRACE_USR4(("TouchEventHandler::find_input_device --> name %s", name));
        ETG_TRACE_USR4(("TouchEventHandler::find_input_device -->devpath %s ", devpath));
        if (!strncmp(name, matchName, matchlen)) 
        {
            if(touchdevpath != NULL)
            {
                free(touchdevpath);
                touchdevpath = NULL;
            }
            touchdevpath =strdup(devpath);
            // TODO both upper display and lowerdisplay have the same , need a differentiation factor , ask project team	
            //	removed break because of this . this reads in reverse order from event16 to 1		
        }
        fd = -1;
    }
    closedir(dir);
    if(touchdevpath == NULL) 
    {
        ETG_TRACE_ERR(("TouchEventHandler::find_input_device --> couldn't find input device = %s", matchName));
        return NULL;
    }
    return touchdevpath;
}

void * TouchEventHandler::toucheventhandler_monitor_thread(void *device)
{

    ENTRY
    char* device_path = toucheventhandler_device_path;
    (void)device ;
    if(device_path != NULL)
    {
        struct input_event ev[64];
        int fd = -1;
        ssize_t rd = -1;

        int CoordinateX = 0;
        int CoordinateY = 0;
        int	TrackingID = -1;
        unsigned int i = 0;

        bool CoordinateXrecv = false;
        bool CoordinateYrecv = false;
        bool bEndOfPacket = false;
        bool bStartOfPacket = true;
        int Xcount = 0;
        int Ycount = 0;

        if ((fd = open((char *)device_path, O_RDONLY)) < 0)
        {
            ETG_TRACE_ERR(("TouchEventHandler::toucheventhandler_monitor_thread --> open = %s failed", device_path));
            if (errno == EACCES && getuid() != 0)
            {
                ETG_TRACE_ERR(("TouchEventHandler::toucheventhandler_monitor_thread --> No access for = %s", device_path));
            }
            runMonitor = 0;
        }

        int ret = fcntl(fd, F_SETFL, fcntl(fd, F_GETFL, 0) | O_NONBLOCK);
        ETG_TRACE_USR4(("TouchEventHandler::toucheventhandler_monitor_thread RET = %d", ret));

        if(ret >= 0)
        {
            while(runMonitor)
            {
                rd = read(fd, ev, (sizeof(struct input_event) * 64));
                if(rd < 0 && errno == EAGAIN)
                {
                    usleep(200 * 1000);
                    continue;
                }
                if (rd <  (ssize_t) sizeof(struct input_event))
                {
                    ETG_TRACE_ERR(("TouchEventHandler::toucheventhandler_monitor_thread --> Error reading  input_event"));
                    runMonitor = 0;
                    break;
                }
                for (i = 0; i < rd / sizeof(struct input_event); i++)
                {
                    //ETG_TRACE_USR4(("toucheventhandler_monitor_thread --> Index = %d, Type = %d, Code = %d, Value = %d", i, ev[i].type, ev[i].code, ev[i].value);
                    if(ev[i].type != EV_SYN)
                    {
                        if(ev[i].type == EV_ABS && ev[i].code == ABS_MT_POSITION_X)
                        {
                            CoordinateX =  CoordinateX + ev[i].value;
                            Xcount++ ;
                            CoordinateXrecv = true;

                        }
                        else if(ev[i].type == EV_ABS && ev[i].code == ABS_MT_POSITION_Y)
                        {
                            CoordinateY = CoordinateY + ev[i].value;
                            Ycount++ ;
                            CoordinateYrecv = true;
                        }
                        else if(ev[i].type == EV_ABS && ev[i].code == ABS_MT_TRACKING_ID)
                        {
                            int currentTrackingID = ev[i].value;
                            if(currentTrackingID > 0)
                            {
                                bStartOfPacket = true;
                            }
                            if(currentTrackingID == -1 && TrackingID > 0)
                            {
                                bEndOfPacket = true ;
                            }
                            TrackingID = currentTrackingID;
                        }
                        else
                        {

                        }

                    }
                    else
                    {

                        if(ev[i].type == EV_SYN && ev[i].code == SYN_REPORT)
                        {

                            if( CoordinateXrecv && CoordinateYrecv && bStartOfPacket)
                            {
                                CoordinateX = CoordinateX/Xcount ;
                                CoordinateY = CoordinateY/Ycount ;
                                ETG_TRACE_USR4(("toucheventhandler_monitor_thread -->LAUNCH EVENT START CoordinateX  = %d , CoordinateY = %d xCount = %d  , yCount = %d " , CoordinateX,CoordinateY,Xcount,Ycount));
                                if(m_listener != NULL )
                                {
                                    m_listener->SendTouchCommand(TOUCH_ACTION_ON,(unsigned short)CoordinateX,(unsigned short)CoordinateY , MAXXCOORDINATE , MAXYCOORDINATE);
                                }
                                bStartOfPacket = false;
                            }

                            if( CoordinateXrecv && CoordinateYrecv && bEndOfPacket)
                            {
                                CoordinateX = CoordinateX/Xcount ;
                                CoordinateY = CoordinateY/Ycount ;
                                ETG_TRACE_USR4(("toucheventhandler_monitor_thread -->LAUNCH EVENT END oordinateX  = %d , CoordinateY = %d xCount = %d  , yCount = %d " , CoordinateX,CoordinateY,Xcount,Ycount));
                                if(m_listener != NULL )
                                {
                                    m_listener->SendTouchCommand(TOUCH_ACTION_OFF,(unsigned short)CoordinateX,(unsigned short)CoordinateY , MAXXCOORDINATE , MAXYCOORDINATE);
                                }
                                CoordinateXrecv = false;
                                CoordinateYrecv = false;
                                bEndOfPacket = false;
                                CoordinateX = 0;
                                CoordinateY = 0;
                                TrackingID = -1;
                                bStartOfPacket = false;
                                Xcount = 0 ;
                                Ycount = 0;
                            }
                        }
                    }
                }
            }
            if(fd >= 0)
            {
                close(fd);
            }
        }
        else
        {
            if(fd >= 0)
            {
                close(fd);
            }
            ETG_TRACE_ERR(("TouchEventHandler::toucheventhandler_monitor_thread error %s", strerror(errno)));
        }
    }
    else
    {
        ETG_TRACE_ERR(("TouchEventHandler::toucheventhandler_monitor_thread devicepath NULL"));
    }
    return NULL;
}



