/*-----------------------------------------------------------------------------*
 * ETG Tracing                                                                 *
 *-----------------------------------------------------------------------------*/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_MTP_CONTROL
#ifdef TARGET_BUILD
#include "trcGenProj/Header/MTPLibWrapper.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_MTP_CONTROL
#endif
#endif

#include "LocalSPM.h"
#include "Dispatcher.h"
#include "FunctionTracer.h"
#include "VarTrace.h"
#include "MediaPlayer_ErrorCodes.h"

#include <dirent.h>
#include "src/libmtp.h"
#include "MTPLibWrapper.h"

static Lock m_MTPReadFolderLock;

MTPLibWrapper::MTPLibWrapper()
{
    ENTRY_INTERNAL
    m_bInitialised = false;
}

MTPLibWrapper::~MTPLibWrapper()
{
    ENTRY_INTERNAL
}

void MTPLibWrapper::wLIBMTP_INIT(void)
{
    ENTRY_INTERNAL
    if(FALSE == m_bInitialised)
    {
        LIBMTP_Init(); //allowed to be called once only
        m_bInitialised = true;
        ETG_TRACE_USR4(("MTPLibWrapper::wLIBMTP_INIT: Real mtplib initialised"));
    }
}

const char* MTPLibWrapper::wLIBMTP_Get_Filetype_Description(LIBMTP_filetype_t const intype )
{
    ETG_TRACE_USR4(("MTPLibWrapper::wLIBMTP_Get_Filetype_Description:%d" , intype));
    return  LIBMTP_Get_Filetype_Description(intype);
}

void MTPLibWrapper::wLIBMTP_SetDebug(IN int const level)
{
    ETG_TRACE_USR4(("MTPLibWrapper::wLIBMTP_SetDebug :%d", level));
    (void)level;
    //LIBMTP_SetDebug(level); //@todo
}
LIBMTP_track_t* MTPLibWrapper::wLIBMTP_Get_Trackmetadata(IN LIBMTP_mtpdevice_t *device, IN uint32_t const trackid)
{
    ETG_TRACE_USR4(("MTPLibWrapper::wLIBMTP_Get_Trackmetadata:%d", trackid));
    LIBMTP_track_t *pTrack = NULL ;
    m_MTPWrapperLock.lock();
    if(NULL != device)
    {
        pTrack = LIBMTP_Get_Trackmetadata (device, trackid);
    }
    m_MTPWrapperLock.unlock();

    return pTrack;
}
LIBMTP_error_number_t MTPLibWrapper::wLIBMTP_Get_Connected_Devices(INOUT LIBMTP_mtpdevice_t **  device_list)
{
    ENTRY_INTERNAL
    LIBMTP_error_number_t ret = LIBMTP_ERROR_NONE;
    m_MTPWrapperLock.lock();
    if(NULL != device_list)
    {
        ret = LIBMTP_Get_Connected_Devices(device_list);
    }
    m_MTPWrapperLock.unlock();
    return ret;
}

void MTPLibWrapper::wLIBMTP_destroy_track_t(LIBMTP_track_t * track)
{
    ENTRY_INTERNAL
    m_MTPWrapperLock.lock();
    if(NULL != track)
    {
        LIBMTP_destroy_track_t(track);
    }
    m_MTPWrapperLock.unlock();

}

char* MTPLibWrapper::wLIBMTP_Get_Modelname(IN LIBMTP_mtpdevice_t *pDevice)
{
    ENTRY_INTERNAL
    char* pName = NULL;
    m_MTPWrapperLock.lock();
    if(NULL != pDevice)
    {
        pName = LIBMTP_Get_Modelname(pDevice);
    }
    m_MTPWrapperLock.unlock();
    return pName;
}

char* MTPLibWrapper::wLIBMTP_Get_Friendlyname(IN LIBMTP_mtpdevice_t *pDevice)
{
    ENTRY_INTERNAL
    char* pName = NULL;
    m_MTPWrapperLock.lock();
    if(NULL != pDevice)
    {
        pName = LIBMTP_Get_Friendlyname(pDevice);
    }
    m_MTPWrapperLock.unlock();
    return pName;
}

char* MTPLibWrapper::wLIBMTP_Get_Serialnumber(IN LIBMTP_mtpdevice_t *pDevice)
{
    ENTRY_INTERNAL
    char* pName = NULL;
    m_MTPWrapperLock.lock();
    if(NULL != pDevice)
    {
        pName = LIBMTP_Get_Serialnumber(pDevice);
    }
    m_MTPWrapperLock.unlock();
    return pName;
}

char* MTPLibWrapper::wLIBMTP_Get_Deviceversion(IN LIBMTP_mtpdevice_t *pDevice)
{
    ENTRY_INTERNAL
    char* pName = NULL;
    m_MTPWrapperLock.lock();
    if(NULL != pDevice)
    {
        pName = LIBMTP_Get_Deviceversion(pDevice);
    }
    m_MTPWrapperLock.unlock();
    return pName;
}

char* MTPLibWrapper::wLIBMTP_Get_Manufacturername(IN LIBMTP_mtpdevice_t *pDevice)
{
    ENTRY_INTERNAL
    char* pName = NULL;
    m_MTPWrapperLock.lock();
    if(NULL != pDevice)
    {
        pName = LIBMTP_Get_Manufacturername(pDevice);
    }
    m_MTPWrapperLock.unlock();
    return pName;
}

int MTPLibWrapper::wLIBMTP_Get_Track_To_File (LIBMTP_mtpdevice_t *pDevice, uint32_t const id, char const *const path, LIBMTP_progressfunc_t const callback, void const *const  data)
{
    ENTRY_INTERNAL
    int ret = -1;
    m_MTPWrapperLock.lock();
    if(NULL != pDevice)
    {
        ret = LIBMTP_Get_Track_To_File(pDevice,id,path,callback,data);
    }
    m_MTPWrapperLock.unlock();
    return ret;
}


tFileFormat  MTPLibWrapper::ConvertMTPFileType( LIBMTP_filetype_t const intype )
{
    ETG_TRACE_USR4(("MTPLibWrapper::ConvertMTPFileType: %d", intype ));
    tFileFormat ret;
    switch(intype)
    {
        //case LIBMTP_FILETYPE_FOLDER:
        case LIBMTP_FILETYPE_WAV:
            ret = FFT_WAV;
            break;
        case LIBMTP_FILETYPE_MP3:
            ret = FFT_MP3;
            break;
        case LIBMTP_FILETYPE_WMA:
            ret = FFT_WMA;
            break;
        case LIBMTP_FILETYPE_OGG:
            ret = FFT_OGG;
            break;
        case LIBMTP_FILETYPE_MP4:
            ret = FFT_MP4;
            break;
        case LIBMTP_FILETYPE_UNDEF_AUDIO:
        case LIBMTP_FILETYPE_WMV:
            ret = FFT_WMV;
            break;
        case LIBMTP_FILETYPE_AVI:
            ret = FFT_AVI;
            break;
        case LIBMTP_FILETYPE_MPEG:
            ret = FFT_MPEG;
            break;
        case LIBMTP_FILETYPE_ASF:
        case LIBMTP_FILETYPE_QT:
            ret = FFT_MOV;  //@todo check if mapping is ok
            break;
        case LIBMTP_FILETYPE_AAC:
            ret = FFT_AAC;
            break;
        case LIBMTP_FILETYPE_AUDIBLE:
        case LIBMTP_FILETYPE_UNDEF_VIDEO:
        case LIBMTP_FILETYPE_JPEG:
        case LIBMTP_FILETYPE_JFIF:
        case LIBMTP_FILETYPE_TIFF:
        case LIBMTP_FILETYPE_BMP:
        case LIBMTP_FILETYPE_GIF:
        case LIBMTP_FILETYPE_PICT:
        case LIBMTP_FILETYPE_PNG:
        case LIBMTP_FILETYPE_VCALENDAR1:
        case LIBMTP_FILETYPE_VCALENDAR2:
        case LIBMTP_FILETYPE_VCARD2:
        case LIBMTP_FILETYPE_VCARD3:
        case LIBMTP_FILETYPE_WINDOWSIMAGEFORMAT:
        case LIBMTP_FILETYPE_WINEXEC:
        case LIBMTP_FILETYPE_TEXT:
        case LIBMTP_FILETYPE_HTML:
        case LIBMTP_FILETYPE_FIRMWARE:
        case LIBMTP_FILETYPE_MEDIACARD:
        case LIBMTP_FILETYPE_FLAC:
        case LIBMTP_FILETYPE_MP2:
        case LIBMTP_FILETYPE_M4A:
        case LIBMTP_FILETYPE_DOC:
        case LIBMTP_FILETYPE_XML:
        case LIBMTP_FILETYPE_XLS:
        case LIBMTP_FILETYPE_PPT:
        case LIBMTP_FILETYPE_MHT:
        case LIBMTP_FILETYPE_JP2:
        case LIBMTP_FILETYPE_JPX:
        case LIBMTP_FILETYPE_ALBUM:
        case LIBMTP_FILETYPE_PLAYLIST:
        case LIBMTP_FILETYPE_UNKNOWN:
            ret = FFT_UNKNOWN;
            break;
        default:
            ret = FFT_UNKNOWN;
            break;
    }

    return ret;

}


LIBMTP_mtpdevice_t *MTPLibWrapper::matchDevice2MountPoint(IN char* serialNumber,IN char* deviceVersion, IN char* deviceName)
{
    ENTRY_INTERNAL;

    LIBMTP_mtpdevice_t *pRet = NULL ;
    ETG_TRACE_USR4(("MTPLibWrapper::matchDevice2MountPoint: deviceName   : %s",deviceName));
    ETG_TRACE_USR4(("MTPLibWrapper::matchDevice2MountPoint: deviceVersion: %s",deviceVersion));
    ETG_TRACE_USR4(("MTPLibWrapper::matchDevice2MountPoint: serialNumber : %s",serialNumber));

    int   ifound = 0;
    char *strSerialnumber;
    char *strDeviceversion;
    //char *strManufacturername;
    LIBMTP_error_number_t ret;
    LIBMTP_mtpdevice_t *pDevice;
    LIBMTP_raw_device_t *devices;
    int numdevs;

    ret = LIBMTP_Detect_Raw_Devices(&devices, &numdevs);

    if (LIBMTP_ERROR_NONE == ret)
    {
        ETG_TRACE_USR4(("MTPLibWrapper::matchDevice2MountPoint(): LIBMTP_ERROR_NONE == ret"));

        for(int index = 0; index < numdevs; index++)
        {
            pDevice = LIBMTP_Open_Raw_Device_Uncached(&devices[index]);
            if(NULL != pDevice)
            {
                ETG_TRACE_USR4(("MTPLibWrapper::matchDevice2MountPoint(): pDevice      =%p",pDevice));

                strSerialnumber     = wLIBMTP_Get_Serialnumber(pDevice);
                strDeviceversion    = wLIBMTP_Get_Deviceversion(pDevice);

                if(NULL != strSerialnumber) {ETG_TRACE_USR4(("LIBMTP_Get_Serialnumber  : %s",strSerialnumber));}
                if(NULL != strDeviceversion) {ETG_TRACE_USR4(("LIBMTP_Get_Deviceversion: %s",strDeviceversion));}

                ifound = 0;

                // Check Serial number and Device Version, these fields will be present always
                if((NULL !=strSerialnumber) && (NULL != strDeviceversion))
                {
                    if(ISEQUAL == strcmp(strSerialnumber,serialNumber))    //1.
                    {
                       ifound++;
                       ETG_TRACE_USR4(("MTPLibWrapper::matchDevice2MountPoint: %d/3 serialNumber matches (%s)",ifound,strSerialnumber));
                       free(strSerialnumber);
                    }
                    if( ISEQUAL == strcmp(strDeviceversion,deviceVersion)) //2.
                    {
                        ifound++;
                        ETG_TRACE_USR4(("MTPLibWrapper::matchDevice2MountPoint: %d/3 deviceVersion matches (%s)",ifound,strDeviceversion));
                        free(strDeviceversion);
                    }
                }
                if(ifound==2)
                {
                    pRet = pDevice;
                    ETG_TRACE_USR4(("MTPLibWrapper::matchDevice2MountPoint: ok (pDevice=%p)",pDevice));
                    break;
                }
            }

            if(ifound !=2)
            {
                pRet = NULL;
                ETG_TRACE_USR4(("MTPLibWrapper::matchDevice2MountPoint:  pRet = NULL"));
            }
        }
    }
    else
    {
        ETG_TRACE_FATAL(("MTPLibWrapper::matchDevice2MountPoint: ret != LIBMTP_ERROR_NONE"));
    }

    return pRet;
}


void MTPLibWrapper::wLIBMTP_destroy_file_t(LIBMTP_file_t *file)
{
    ENTRY_INTERNAL;
    m_MTPWrapperLock.lock();
    if(NULL != file)
    {
        LIBMTP_destroy_file_t(file);
    }
    m_MTPWrapperLock.unlock();

}

int MTPLibWrapper::wLIBMTP_Get_Storage(IN LIBMTP_mtpdevice_t* device, IN int const sortby)
{
     ENTRY_INTERNAL;
     int result = -1;
     m_MTPWrapperLock.lock();
     if(NULL != device)
     {
         result = LIBMTP_Get_Storage(device, sortby);
     }
     m_MTPWrapperLock.unlock();
     return result;
}

void MTPLibWrapper::wLIBMTP_Release_Device(IN LIBMTP_mtpdevice_t* device)
{
     ENTRY_INTERNAL;
     m_MTPWrapperLock.lock();
     if(device != NULL)
     {
         LIBMTP_Release_Device(device);
     }
     m_MTPWrapperLock.unlock();// NCG3D-164108 and NCG3D-164063
}

LIBMTP_file_t* MTPLibWrapper::wLIBMTP_Get_Item(IN LIBMTP_mtpdevice_t* device, IN uint32_t const storageid, IN uint32_t const parentid,IN int32_t *readindex)
{
     ENTRY_INTERNAL;
     LIBMTP_file_t* pFile = NULL ;
     m_MTPWrapperLock.lock();
     if(NULL != device)
     {
         pFile = LIBMTP_Get_Item(device, storageid, parentid,readindex);
     }
     m_MTPWrapperLock.unlock();
     return pFile;
}

tU16 MTPLibWrapper::wLIBMTP_ReadFiles(IN LIBMTP_mtpdevice_t* device, IN uint32_t const storageid, IN uint32_t const parentid)
{
     ENTRY_INTERNAL;
     tU16 ret = 0;
     m_MTPWrapperLock.lock();
     if(NULL != device)
     {
         ret = LIBMTP_ReadFiles(device, storageid, parentid);
     }
     m_MTPWrapperLock.unlock();
     return ret;
}
