///@todo there might be MTP devices which are not recognized by mtplib care for using libusb for getting device address etc.
///@todo check for memory leaks espcially with usage of libmtp

/*-----------------------------------------------------------------------------*
 * ETG Tracing                                                                 *
 *-----------------------------------------------------------------------------*/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_MTP_CONTROL
#ifdef TARGET_BUILD
#include "trcGenProj/Header/MTPControl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_MTP_CONTROL
#endif
#endif



/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "LocalSPM.h"
#include "Dispatcher.h"
#include "FunctionTracer.h"
#include "VarTrace.h"
#include "MediaPlayer_ErrorCodes.h"


#include <cstdlib>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <iostream>
#include <fstream>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <ctype.h>


//planned for Getalbum Art
#include <taglib/fileref.h>
#include <taglib/vorbisfile.h> //ogg file
#include <taglib/mpegfile.h>    //mp3 file
#include <taglib/rifffile.h>    //riff file
#include <taglib/wavfile.h>     //wave file
#include <taglib/aifffile.h>    //aiff file
#include <taglib/asffile.h>     //asf file
#include <taglib/mp4file.h>     //mp4 file
#include <taglib/mp4tag.h>      //mp4tag
#include <taglib/id3v2tag.h>    //id3 tag
#include <taglib/id3v2frame.h>  //id3 frame
#include <taglib/attachedpictureframe.h>
#include <taglib/id3v2header.h>
#include <libgen.h>
#include <taginfo.h>
#include <regex.h>
using namespace std;
using namespace TagInfo;
#include "VideoTagInfo.h"
#define USE_VIDEO_METADATA_READ_PROCESS 1


#include <openssl/md5.h>
#include "src/libmtp.h"   // use mediaplayer specific libmtp
 //#include "src/ptp.h"

#include "TimeTrace.h"
#include "MTPControlCommon.h"
#include "MTPControl.h"
#include "MTPLibWrapper.h"
#include "../test/MTPLibWrapperTest.h"
#include "MTPCache.h"

/*-----------------------------------------------------------------------------*
 * Defines                                                                     *
 *-----------------------------------------------------------------------------*/
#define SEPERATOR  '/'
#define EOF_STRING '\0'
#define ELEMS_IN_MOUNTPOINT 3
#define MTP_OK    ( 0)
#define MTP_NOK   (-1)
#define LINUX_OK  ( 0)
#define LINUX_NOX (-1)

#define EQUAL 0

#define THREAD_MTPCONTROL  (unsigned int)0
#define THREAD_ALBUMART    (unsigned int)1
#define THREAD_FINGERPRINT (unsigned int)2
#define THREAD_READFILES  (unsigned int)3

/*-----------------------------------------------------------------------------*
 * static functions                                                            *
 *-----------------------------------------------------------------------------*/



//---------------------------------Helper functions-------------------------------------------------------



static int callbackCopyFile(uint64_t const sent, uint64_t const total, void const *const data)
{
    ENTRY_INTERNAL;
    (void)data;

    ETG_TRACE_USR4(("callbackCopyFile: bytes send: %d total:%d",sent,total));

    return MTP_OK;
}



//SPM part
void MTPControl::Create() // finished: 100%
{
    ENTRY;

    DIR* tmpDir;
    /* Create the state machine */
    MTPControlSM::Create();

    devTblDeleteAll();

    tmpDir = opendir(LOCAL_MTPFILE_PATH_TARGET);
    if(NULL == tmpDir)
    {
        mkdir(LOCAL_MTPFILE_PATH_TARGET,S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH);
        ETG_TRACE_COMP(("Create: create directory for tmp loaded mtp-files: %s",LOCAL_MTPFILE_PATH_TARGET));
    }
    else
    {
        closedir(tmpDir);
    }

    CreateDone(0);
}

tResult MTPControl::Init(tInitReason reason) // finished: 100%
{
    ENTRY;
    VARTRACE(reason);

    /* Init the state machine */
    MTPControlSM::Init();
    SetAnswerTimeout(MTP_CTRL_SM_ANSWER_TIMEOUT_MS); // Set answer timeout

    /* Register state machine with dispatcher */
    Dispatcher::GetInstance().Register(IN this);

    LoadFilterConfiguration();
    m_response = REASON_OK;
    return InitDone(0);
}

tResult MTPControl::InitSM() // finished: 100%
{
    ENTRY

    InitMediaObject(OUT m_PlayMediaObject);

    m_AudioOutputDevice[0] = '\0';

    /* Fill codec restriction table from calibration */
    LocalSPM::GetDataProvider().FillCodecRestrictionTable();

    //own variables should be initialised here otherwhise the state machine does not get it

    return MP_NO_ERROR;
}

tResult MTPControl::Run() // finished: 100%
{
    ENTRY;

    /*Create and start threads */
    LocalSPM::GetThreadFactory().Do(IN this, THREAD_MTPCONTROL, NULL); //MTPControl inclusive state machine

    return RunDone(0);
}

void MTPControl::Do(int functionID, void *ptr) // finished: 100%
{
    ENTRY

    switch(functionID)
    {
        case THREAD_MTPCONTROL:
        {
            //set the threads name
            LocalSPM::GetThreadFactory().SetName(MTPControlSM::GetSMNameFull());
            while(MTPControlSM::STATE_MACHINE_FINISHED != MTPControlSM::StateMachine_Main()){}
            break;
        }
        case THREAD_ALBUMART:
        {
              LocalSPM::GetThreadFactory().SetName("MTPControl_1");
              DoGetAlbumArtThread((const char *)ptr);
              break;
        }
        case THREAD_FINGERPRINT:
        {
            LocalSPM::GetThreadFactory().SetName("MTPControl_2");
            DoCalcFingerprintThread((const char *)ptr);
            break;
        }

        case THREAD_READFILES:
        {
            LocalSPM::GetThreadFactory().SetName("MTPControl_3");
            DoReadFilesFromDeviceThread((const char *)ptr);
            break;
        }

        default:
            ETG_TRACE_ERR(("MTPControl::Do: Wrond thread case"));
            break;

    }
}

tResult MTPControl::Stop() // finished: 100%
{
    ENTRY;

    tResult ret = MP_NO_ERROR;

    /* Send STOP message to own SM */
    ret = SendForceEvent(STOP_SM, (char *)NULL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF"));
    }

    return ret;
}

//?
tResult MTPControl::StopEventProcessed() // finished: 100%
{
    ENTRY;

    tResult ret = MP_NO_ERROR;

    if(!LocalSPM::GetDataProvider().UseMediaEngine()) { //pip2hi

        /* unregister for further playback events */
        ret = LocalSPM::GetIPCProvider().UnregisterObserver(IN this);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::UnregisterObserver (ErrorCode:%s)", errorString(ret)));
        }
    }

    /* Send stop done to SPM in the transition to final state in state machine */
    return StopDone(0);
}


tResult MTPControl::Done() // finished: 100%
{
    ENTRY;

    tResult ret = MP_NO_ERROR;

    /* Deregister state machine with dispatcher */
    Dispatcher::GetInstance().DeRegister(IN this);

    /* Send DONE message to own SM */
    ret = SendForceEvent(DONE, (char *)NULL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF"));
    }

    return ret;
}

tResult MTPControl::DoneEventProcessed() // finished: 100%
{
    ENTRY

    //Cleanup threads
    LocalSPM::GetThreadFactory().CleanUpThreads(this);

    /* Send done done to SPM in the transition to final state in state machine */
    return DoneDone(0);
}

char *MTPControl::GetSMStateName(OUT tGeneralString stateName, size_t size)
{
    GetCurrentState((char *)stateName, size);
    return stateName;
}

tResult MTPControl::GenerateMountPoint(INOUT tDeviceInfo &deviceInfo) // finished: 100%
{
    ENTRY;
    (void)deviceInfo;
   //ret = encodeMountPoint(deviceInfo);
   return MP_NO_ERROR;
}

tResult MTPControl::StartAllocateAudioInput(const tDeviceID /*deviceID*/, const tMountPoint mountPoint) // finished: 100%
{
    ENTRY;
    (void)mountPoint;

    tResult ret = MP_NO_ERROR;

    /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tReturnValue returnValue = true;

    ret = ParameterMETHOD_RETURN(OUT parameterString, IN size, IN returnValue);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string"));
    }
    else
    {
        ret = SendEvent(METHOD_RETURN, IN parameterString);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF"));
        }
    }
    return MP_NO_ERROR;
}

tResult MTPControl::StartDeAllocateAudioInput() // finished: 100%
{
    ENTRY;

    tResult ret = MP_NO_ERROR;

    /* For MTP no need to assign audio input device */
    /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tReturnValue returnValue = true;

    ret = ParameterMETHOD_RETURN(OUT parameterString, IN size, IN returnValue);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string"));
    }
    else
    {
        ret = SendEvent(METHOD_RETURN, IN parameterString);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF"));
        }
    }
    return MP_NO_ERROR;
}

/*first solution: no streaming as we do it in Gen2*/
tResult MTPControl::StartStreaming(const tDeviceID /*deviceID*/, const tMountPoint mountPoint)
{
    ENTRY;
    (void)mountPoint;

    tResult ret = MP_NO_ERROR;
    tPEPlaybackState status = PE_PBS_LOADINGSTATE;

    /* For MTP no need to start streaming */
    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Fake MediaEngine response: Send expected event to waiting state machine immediately */
        me::reason_e reason = REASON_OK;
        me::speed_e speed = ME_SPEED_NORMAL;

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = ParameterSTART_STREAMING_ANSWER(OUT parameterString, IN size, IN (tPEHandle)m_PlayMediaObject.objectID, IN status, IN reason, IN speed);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(START_STREAMING_ANSWER, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
        tMetadata metadata = { 0 };

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        tObjectID ObjectID = OBJECT_ID_NONE;
        ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN status, IN metadata, IN metadata, IN metadata, IN metadata,IN ObjectID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    return MP_NO_ERROR;
}

tResult MTPControl::StartStopStreaming()
{
    ENTRY;

    tResult ret = MP_NO_ERROR;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    /* For MTP no need to stop streaming
     * Send STOP_STREAMING_ANSWER message to release own waiting state */
    ret = ParameterSTOP_STREAMING_ANSWER(OUT parameterString, IN size, IN deviceID);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(STOP_STREAMING_ANSWER, IN parameterString);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }
    return MP_NO_ERROR;
}

tResult MTPControl::StopStreamingAnswer(tDeviceID deviceID)
{
    ENTRY
    (void)deviceID;
    tPEPlaybackState status = PE_PBS_STOPPEDSTATE;

    /* Send answer to waiting state machine */
    if( LocalSPM::GetDataProvider().UseMediaEngine() )
    {
        PlaybackStatusNew(IN (tPEHandle)m_PlayMediaObject.objectID, IN status, IN REASON_OK, IN ME_SPEED_NORMAL);
    }
    else
    {
        tMetadata metadata = { 0 };

        PlaybackStatus(IN status, IN metadata, IN metadata, IN metadata, IN metadata);
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

/*'tell player engine who is observing e.g. playtime - hence it'*/
tResult MTPControl::StartSwitchObserver(const tDeviceID /*deviceID*/, const tMountPoint /*mountPoint*/) // finished: 100%
{
    ENTRY;

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine()) { //pip2hi

        /* Switch the observer to this state machine */
#if 1
        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::SWITCH_OBSERVER", "MTPControlSM", "MTPControlSM::METHOD_RETURN");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
#else
        Dispatcher::GetInstance().SendMessage("MediaEngineSM::SWITCH_OBSERVER", "MTPControlSM");

        /* MediaEngine will not answer, so fake the answer */
        ret = SendEvent(METHOD_RETURN, IN "0");
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
#endif
    } else {

        RegisterReleaseEvent(METHOD_RETURN); //set up a timer - state machine waits for METHOD_RETURN which will be send by the PlayEngine
        ret = LocalSPM::GetIPCProvider().SwitchObserver(IN this); //tell PlayerEngine to switch observer
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::SwitchObserver (ErrorCode:%s)", errorString(ret)));
        }
    }
    return MP_NO_ERROR;
}

//* Send NewPlaySlot to PlayerEngine via DBUS */


//------------------------------------------
//copy track from MTP-device to target
//------------------------------------------
//1) tMediaObject contains tUrl filename and has been given to Indexer in context of 'loadMetadata'
// check if URL = trackID is good? Or what do you propose?
//#datapool - wert maximale Größe beachten und mit filegröße beachten - File error schicken, wenn zu groß (Playbackstatus response mit )
//#erst Mal mit einem file arbeiten
//#tempname - Thomas fragen und und postfix - Verzeichnisname von Nils holen   #/media/tmp ich mache tmpfilename
//#für last tracks selber ein Mapping bauen
//#löschen steuern - beim Aufruf checken, ob dasselbe file gespielt wird oder nicht...
// check if mountPoint is the directory plus filename on the target where track from MTP_device should be copied to
// since the file name has been part of the Metadata received before it could be not a default name but exact name of the file to be played
// plus uniqueTrackID
// this eases in some scenarios debugging

//2) get filename - if not delivered with mount point as suggested before
//LIBMTP_track_t* LIBMTP_Get_Trackmetadata  ( LIBMTP_mtpdevice_t *  device, uint32_t const   trackid
// char *  filename, uint64_t  filesize , LIBMTP_filetype_t  filetype  would be gained from that call
// how about a check if there is enough space on the target for such a file? To prevent unnesessary coping


//3) delete old local file which has been copied due to previous StartPlay command
//   does it make sense to keep last 1..3 files to support previous and next in a quick way?
//   in such case it would be good to know how much size is available at the target
//   if the Unique Track ID is part of the name it would help to use already copied files

/*4) copy track from MTP device to a file at the target*/
//how long does it take to copy a file
tResult MTPControl::StartPlay(const tDeviceType deviceType,
        const tDeviceID deviceID,
        const tURL URL,
        const tMountPoint mountPoint,
        const tUUID uuid,
        const tPEHandle handle,
        const tPlaytime position,
        const tStreaming streaming)
{
    ENTRY;

    tResult ret = MP_NO_ERROR;

    tU32 trackID = 0;

    LIBMTP_mtpdevice_t *device = NULL;

    VARTRACE(deviceType);
    VARTRACE(deviceID);
    VARTRACE(URL);
    VARTRACE(mountPoint);
    VARTRACE(uuid);
    VARTRACE(handle);
    VARTRACE(position);
    VARTRACE(streaming);


    /* Send METADATA_FOR_PLAYBACK message to own SM */
    SendEvent(METADATA_FOR_PLAYBACK, NULL);

    ETG_TRACE_USR4(("StartPlay:exact path  : %s",URL));

    tPath lastModePath;
    string playURL = URL;
    size_t pos = playURL.find_last_of("#");
    if(pos){
        string tempURL = playURL.substr(0,pos);
        strcpy((char*)URL,tempURL.c_str());
        playURL = playURL.substr(pos+1);
        strcpy(lastModePath,playURL.c_str());
        ETG_TRACE_USR4(("StartPlay:lastmodepath: %s",lastModePath));
    }

    /* Update media object to play */
    InitMediaObject(OUT m_PlayMediaObject);
    m_PlayMediaObject.objectID = (tObjectID)handle;
    m_PlayMediaObject.deviceID = deviceID;
    strncpy_r(OUT m_PlayMediaObject.fileName, IN URL, IN sizeof(m_PlayMediaObject.fileName));
    strncpy_r(OUT m_PlayMediaObject.mountPoint, IN mountPoint, IN sizeof(m_PlayMediaObject.mountPoint));
    strncpy_r(OUT m_PlayMediaObject.UUID, IN uuid, IN sizeof(m_PlayMediaObject.UUID));
    trackID = (uint32_t)std::atoi(uuid);
    ETG_TRACE_USR4(("StartPlay:trackID: %d",trackID));

    //-----------------------------------------------------------
    //get from mount point the already opened device handle
    //MAP mountPoint/DeviceID to device
    //-----------------------------------------------------------

    device = devTblFind(mountPoint);
    if(NULL == device)
    {
        ETG_TRACE_ERR(("StartPlay: No device matches mountPoint"));
        ret = MP_ERR_MTP_NODEVICE;
        sendPlaybackstatus(PE_PBS_ERRORSTATE);
    }
    if((MP_NO_ERROR == ret) && (MP_NO_ERROR == deleteTmpFile(m_PlayFileTmp)))
    {
        if(!LocalSPM::GetDataProvider().UseMediaEngine()) { //pip2hi

            tURL fullName;
            tU8 *pureFile = NULL;
            tU8 *extension = NULL;

            strncpy_r(OUT fullName, IN URL, IN sizeof(fullName));
            FastUTF8::Split(OUT pureFile, INOUT (unsigned char *)fullName);
            if(pureFile)
            {
                FastUTF8::SplitExtension(OUT extension, INOUT (unsigned char *)pureFile);
                snprintf(m_PlayFileTmp, sizeof (m_PlayFileTmp),"%s/%s.%s",LOCAL_MTPFILE_PATH_TARGET,LOCAL_MTPFILE,extension);
            }
            ETG_TRACE_USR4(("StartPlay:path :%s",fullName));
        }
        else
        {
            string url = URL;
            size_t pos = url.find_last_of('/');
            url = url.substr(pos + 1);
            snprintf(m_PlayFileTmp, sizeof (m_PlayFileTmp),"%s/%s",LOCAL_MTPFILE_PATH_TARGET, url.c_str());
        }

        ETG_TRACE_USR4(("StartPlay:load track from MTP device to tmp-file:%s",m_PlayFileTmp));

        tS32 res = 0;
        res = m_pMTPLibWrapper->wLIBMTP_Get_Track_To_File(device,trackID,m_PlayFileTmp,callbackCopyFile,NULL);
        if(0 != res)
        {
            ETG_TRACE_ERR(("Libmtp_Get_Track_To_File: MP_ERR_MTP_GENERAL_ERROR:%d",res));
            readRecursiveFolder(lastModePath,deviceID,mountPoint);
            res = m_pMTPLibWrapper->wLIBMTP_Get_Track_To_File(device,trackID,m_PlayFileTmp,callbackCopyFile,NULL);
            if(0 != res){
                ret = MP_ERR_MTP_LIBMTP_GETFILE;
                sendPlaybackstatus(PE_PBS_ERRORSTATE);
            }
        }
        else
        {
            ret = writeID(LOCAL_MTPFILE_PATH_TARGET,LOCAL_MTPFILE_INFO,deviceID,URL);
            // provide file permission to user also
            if (chmod(m_PlayFileTmp, S_IRWXU|S_IRWXO) != 0)
            {
                ETG_TRACE_USR3(("StartPlay: permission denied for owner and other"));
            }
            else
            {
                ETG_TRACE_USR3(("StartPlay: permission set success for owner and other"));
            }

            ret = MP_NO_ERROR;
        }

    }
    //-----------------------------------------------------------------
    // get metadata
    //-----------------------------------------------------------------
    if(MP_NO_ERROR == ret)
    {

        // Do not use GetDBManager().GetMediaObject() to get the metadata
        // MTPControl is also a VT component and it is possible to produce a deadlock while accessing MediaObjects table
        ETG_TRACE_USR4(("StartPlay: get Metadata using taginfo"));

        ret = LocalSPM::GetDBManager().GetFileFormat(OUT m_PlayMediaObject.fileFormat, OUT m_PlayMediaObject.fileType, IN m_PlayFileTmp);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("unable to get file format for the url : %s", m_PlayFileTmp));
            /* Send action error to own state machine */
            ActionError(REASON_FORMAT_ERROR);
        }
        else
        {
            /* TODO(pee1cob):MTPVideoSupport() check is not necessary.Reason GetDBManager().GetFileFormat(..) will be success only
             * if the File is "supported FileFormat".Thus play the video file.no more checking need
             */
            if((LocalSPM::GetDataProvider().MTPVideoSupport()) && (FT_VIDEO == m_PlayMediaObject.fileType )) /*Read video metadata*/
            {
                if(!ReadVideoMetadataFromFile(INOUT m_PlayMediaObject, IN m_PlayFileTmp))
                {
                    ETG_TRACE_ERR(("Skip playback of video file because it is codec restricted %s", m_PlayFileTmp));

                    /* Send action error to own state machine */
                    ActionError(REASON_FORMAT_ERROR);

                    return MP_NO_ERROR;
                }
            }
            else /*Read audio metadata*/
            {
                string target(m_PlayFileTmp);
                Info * info = Info::create_tag_info(target);

                if(info )
                {
                    if(info->read())
                    {
                        if (LocalSPM::GetDataProvider().CodeSetConversionSupported())
                        {
                            /*Invoked to find  and convert Non UTF-8 metadata strings(given by LibTagInfo)*/
                            LocalSPM::GetDataProvider().FindAndConvertLatin1MetadataEntries(INOUT m_PlayMediaObject ,IN (void*)info);
                        }
                        else
                        {
                            if((info->get_genre().toCString(TRUE)) != NULL) strncpy_r(m_PlayMediaObject.MetadataField1, info->get_genre().toCString(TRUE), sizeof(m_PlayMediaObject.MetadataField1));
                            if((info->get_artist().toCString(TRUE)) != NULL)strncpy_r(m_PlayMediaObject.MetadataField2, info->get_artist().toCString(TRUE), sizeof(m_PlayMediaObject.MetadataField2));
                            if((info->get_composer().toCString(TRUE)) != NULL)strncpy_r(m_PlayMediaObject.MetadataField3, info->get_composer().toCString(TRUE), sizeof(m_PlayMediaObject.MetadataField3));
                            if((info->get_album().toCString(TRUE)) != NULL)strncpy_r(m_PlayMediaObject.MetadataField4, info->get_album().toCString(TRUE), sizeof(m_PlayMediaObject.MetadataField4));
                            if((info->get_title().toCString(TRUE)) != NULL)strncpy_r(m_PlayMediaObject.title, info->get_title().toCString(TRUE), sizeof(m_PlayMediaObject.title));
                            m_PlayMediaObject.metadataConvertFlag = 0;
                        }
                        if(!strlen_r(m_PlayMediaObject.title))
                        {
                            ETG_TRACE_USR3(("StartPlay: No title available, use filename instead"));
                            tURL fullName;
                            unsigned char *pureFile;
                            strncpy_r(OUT fullName, IN URL, IN sizeof(fullName));
                            FastUTF8::Split(OUT pureFile, INOUT (unsigned char *)fullName);

                            if (pureFile)
                            {
                                /* Remove the extension */
                                if (LocalSPM::GetDataProvider().DBRemoveExtensionFromFilename())
                                {
                                    unsigned char *extension;
                                    FastUTF8::SplitExtension(OUT extension, INOUT (unsigned char *)pureFile);
                                }
                                strncpy_r(OUT m_PlayMediaObject.title, IN (const char *)pureFile, IN sizeof(m_PlayMediaObject.title));
                            }
                        }
                    }
                    delete info;
                    ret = MP_NO_ERROR;
                }
                else
                {
                    ETG_TRACE_ERR(("StartPlay: Taginfo failed to read metadata"));
                    strncpy_r(m_PlayMediaObject.MetadataField1, LocalSPM::GetDataProvider().DBUnknownText().c_str(), sizeof(m_PlayMediaObject.MetadataField1));
                    strncpy_r(m_PlayMediaObject.MetadataField2, LocalSPM::GetDataProvider().DBUnknownText().c_str(), sizeof(m_PlayMediaObject.MetadataField2));
                    strncpy_r(m_PlayMediaObject.MetadataField3, LocalSPM::GetDataProvider().DBUnknownText().c_str(), sizeof(m_PlayMediaObject.MetadataField3));
                    strncpy_r(m_PlayMediaObject.MetadataField4, LocalSPM::GetDataProvider().DBUnknownText().c_str(), sizeof(m_PlayMediaObject.MetadataField4));
                    strncpy_r(m_PlayMediaObject.title, LocalSPM::GetDataProvider().DBUnknownText().c_str(),  sizeof(m_PlayMediaObject.title));
                    m_PlayMediaObject.metadataConvertFlag = 0;
                    ret = MP_ERR_MTP_LIBMTP_TRACKNULL;
                    sendPlaybackstatus(PE_PBS_ERRORSTATE);
                }
            }
        }
    }
    //------------------------------------------------------------------------------------------------
    //play song
    //-------------------------------------------------------------------------------------------------
    if(MP_NO_ERROR == ret)
    {
        strncpy_r(m_LastPlayedPath,URL,sizeof(m_LastPlayedPath));

        if(LocalSPM::GetDataProvider().UseMediaEngine()) { //pip2hi

            tPEStateString args;
            me::vprops_t meVideoProperties;
            if (MTY_VIDEO == m_PlayMediaObject.mediaType)
            {
                ret = LocalSPM::GetDBManager().GetVideoProperties(meVideoProperties);
                if(MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while getting video properties from dbmanager"));
                }
            }
            VARTRACE(meVideoProperties);
            SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiiltliiiiiiil",
               m_PlayFileTmp, (int)ME_SPEED_NORMAL, position,
               handle, m_AudioOutputDevice, samplerate_i_none,
               (int)meVideoProperties.brightness(), (int)meVideoProperties.hue(),
               (int)meVideoProperties.saturation(), (int)meVideoProperties.contrast(),
               (int)meVideoProperties.brightnessoffset(), (int)meVideoProperties.saturationoffset(),
               (int)meVideoProperties.hueoffset(),ME_SPEEDSTATE_OFF);

            ETG_TRACE_USR4(("StartPlay:mediaengine args:%s", args));
            ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::PLAY", args, "MTPControlSM::PLAY_ANSWER");
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
            }

        } else {

            /* Send NewPlaySlot to PlayerEngine via DBUS */
            tURL mountPointURL2PE;
            tPlaypointFormat playpointFormat = PPF_ABSOLUTE; //absolute time in milliseconds

            snprintf(mountPointURL2PE,sizeof(mountPointURL2PE),"%s",m_PlayFileTmp);

            ETG_TRACE_USR4(("StartPlay:mountPointURL2PE:%s",mountPointURL2PE));
            RegisterReleaseEvent(PLAYBACK_STATUS_RESPONSE);
            ret = LocalSPM::GetIPCProvider().NewPlaySlot(IN this, IN mountPointURL2PE, IN position, IN playpointFormat);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while using IPCProvider::NewPlaySlot (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    TestIF_sendTestResultMsgResult(IN ret); //only send if Test has connected a testResultMsgQ
    return MP_NO_ERROR;
}

tResult MTPControl::StartStop(const tDeviceType deviceType,
                              const tDeviceID deviceID,
                              const tURL URL,
                              const tMountPoint mountPoint) // finished: 100%
{
    ENTRY;
    ETG_TRACE_USR3(("MTPControl::StartStop deviceType:%u, deviceID:%u, URL:%40s, mountPoint:%s", deviceType, deviceID, URL, mountPoint));

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::STOP", NULL, "MTPControlSM::STOP_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }

    } else {

        /* Send StopSlot to PlayerEngine via DBUS */
        RegisterReleaseEvent(STOP_ANSWER); //GMMY16-24734
        ret = LocalSPM::GetIPCProvider().StopSlot(IN this);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::StopSlot (ErrorCode:%s)", errorString(ret)));
        }
    }

    /* Reset media object to play */
    ETG_TRACE_USR3(("Reset media object to play"));
    InitMediaObject(OUT m_PlayMediaObject);

    return MP_NO_ERROR;
}


tResult MTPControl::StartPause(const tDeviceType deviceType,
                               const tDeviceID deviceID,
                               const tURL URL,
                               const tMountPoint mountPoint) // finished: 100%
{
    ENTRY;

    //----------------------------------
    //Error check device availability
    //---------------------------------
    //note: mountpoint contains devicename, serailnumber and version hence is unique

    ETG_TRACE_USR3(("MTPControl::StartPause deviceType:%u, deviceID:%u, URL:%40s, mountPoint:%s",
               deviceType, deviceID, URL, mountPoint));

    tResult ret = MP_NO_ERROR;

    ret = errChkAvailable(mountPoint); //calls sendPlaybackstatus in error case

    if(MP_NO_ERROR == ret)
    {
       if(LocalSPM::GetDataProvider().UseMediaEngine()) // pip2hi
       {
           tPEStateString args;
           SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiilt", m_PlayFileTmp, (int)ME_SPEED_NONE, POSITION_NOT_SET, HANDLE_NONE, m_AudioOutputDevice);

           ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::PAUSE", args, "MTPControlSM::PAUSE_ANSWER");
           if(MP_NO_ERROR != ret)
           {
               ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
           }
       } else {

           /* Send PauseSlot to PlayerEngine via DBUS */
           tPlaytime position = 0; //dummy position, only used in case of being not in state playing
           tPlaypointFormat playpointFormat = PPF_ABSOLUTE; //absolute time in milliseconds

           /* Put complete path together (mount point + relative path of the URL)*/
           tURL mountPointURL;

           ETG_TRACE_USR4(("MTPControl::StartPause. ignore give mountpoint and URL replace with hard coded one of local copy"));

           strncpy_r(mountPointURL, m_PlayFileTmp/*mountPoint*/, sizeof(mountPointURL));
           tURL mountPointURL2PE;
           // thm4hi: problem is: the player engine in ubuntu does not react as the one in the target.
#ifdef TARGET_BUILD
           /* thm4hi: for old player engine: do a fake conversion to utf8 */
           toUtf8Fake(OUT mountPointURL2PE, IN sizeof(mountPointURL2PE), IN mountPointURL);
#else
           strncpy_r(OUT mountPointURL2PE, IN mountPointURL, IN sizeof(mountPointURL2PE));
#endif

           RegisterReleaseEvent(PLAYBACK_STATUS_RESPONSE);
           ret = LocalSPM::GetIPCProvider().PauseSlot(IN this, IN mountPointURL2PE, IN position, IN playpointFormat);
           if (MP_NO_ERROR != ret)
           {
                 ETG_TRACE_ERR(("Error while using IPCProvider::PauseSlot (ErrorCode:%s)", errorString(ret)));
           }
       }
   }

   return MP_NO_ERROR;
}

tResult MTPControl::StartResume(const tDeviceType deviceType,
                                const tDeviceID deviceID,
                                const tURL URL,
                                const tMountPoint mountPoint) // finished: 100%
{
    ENTRY
    ETG_TRACE_USR3(("MTPControl::StartResume deviceType:%u, deviceID:%u, URL:%40s, mountPoint:%40s, dev:%s", deviceType, deviceID, URL, mountPoint, m_AudioOutputDevice));

    tResult ret = MP_NO_ERROR;

    ret = errChkAvailable(mountPoint); //calls sendPlaybackstatus in error case

    if(MP_NO_ERROR == ret)
    {
        if(LocalSPM::GetDataProvider().UseMediaEngine())
        {
            tPEStateString args;
            SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiilt", m_PlayFileTmp, (int)ME_SPEED_NORMAL, POSITION_NOT_SET, HANDLE_NONE, m_AudioOutputDevice);

            ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::PLAY", args, "MTPControlSM::RESUME_ANSWER");
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
            }
        } else {

            /* Send ResumePlaySlot to PlayerEngine via DBUS */
            RegisterReleaseEvent(PLAYBACK_STATUS_RESPONSE);
            ret = LocalSPM::GetIPCProvider().ResumePlaySlot(IN this);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while using IPCProvider::ResumePlaySlot (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    return MP_NO_ERROR;
}

tResult MTPControl::StartFfwdStart(const tDeviceType deviceType, // finished: 100%
                                   const tDeviceID deviceID,
                                   const tURL URL,
                                   const tMountPoint mountPoint,
                                   const tCueingRate rate,
                                   const speedstate_e IsPlaybackSpeed)
{
    ENTRY;
    (void)IsPlaybackSpeed;
    ETG_TRACE_USR3(("MTPControl::StartFfwdStart deviceType:%u, deviceID:%u, URL:%40s, mountPoint:%40s, rate:%u, dev:%s",
            deviceType, deviceID, URL, mountPoint, rate, m_AudioOutputDevice));

    tResult ret = MP_NO_ERROR;

    ret = errChkAvailable(mountPoint); //calls sendPlaybackstatus in error case

    if(MP_NO_ERROR == ret)
    {
        if(LocalSPM::GetDataProvider().UseMediaEngine())
        {
            tPEStateString args;
            me::vprops_t meVideoProperties;
            if (MTY_VIDEO == m_PlayMediaObject.mediaType)
            {
                ret = LocalSPM::GetDBManager().GetVideoProperties(meVideoProperties);
                if(MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while getting video properties from dbmanager"));
                }
            }
            VARTRACE(meVideoProperties);
            SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiiltliiiiiiil", m_PlayFileTmp,
                    (int)rate, POSITION_NOT_SET, HANDLE_NONE, m_AudioOutputDevice,samplerate_i_none,
                    (int)meVideoProperties.brightness(), (int)meVideoProperties.hue(),
                    (int)meVideoProperties.saturation(), (int)meVideoProperties.contrast(),
                    (int)meVideoProperties.brightnessoffset(), (int)meVideoProperties.saturationoffset(),
                    (int)meVideoProperties.hueoffset(),IsPlaybackSpeed);

            ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::PLAY", args, "MTPControlSM::FFWD_ANSWER");
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
            }
        } else {

            /* Send StartFfwdSlot to PlayerEngine via DBUS */
            //RegisterReleaseEvent(PLAYBACK_STATUS_RESPONSE);
            ret = LocalSPM::GetIPCProvider().StartFfSlot(IN this, IN rate);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while using IPCProvider::StartFfSlot (ErrorCode:%s)", errorString(ret)));
            }

            /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
            tPEPlaybackState status = PE_PBS_FASTFORWARDSTATE;
            tMetadata metadata1 = {0};
            strncpy_r(metadata1, URL, sizeof(metadata1));
            tMetadata metadata = {0};

            tAllParameters parameterString;
            size_t size = sizeof(parameterString);

            tObjectID ObjectID = OBJECT_ID_NONE;
            ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN status, IN metadata1, IN metadata, IN metadata, IN metadata,IN ObjectID);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while preparing parameter string"));
                parameterString[0] = '\0';
            }
                ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
                if (MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while sending internal event via SMF"));
            }
        }
    }

    return MP_NO_ERROR;
}

tResult MTPControl::StartFfwdStop(const tDeviceType deviceType, // finished: 100%
                                  const tDeviceID deviceID,
                                  const tURL URL,
                                  const tMountPoint mountPoint,
                                  const speedstate_e IsPlaybackSpeed)
{
    ENTRY;
    ETG_TRACE_USR3(("MTPControl::StartFfwdStop deviceType:%u, deviceID:%u, URL:%40s, mountPoint:%40s, dev:%s",
            deviceType, deviceID, URL, mountPoint, m_AudioOutputDevice));

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        tPEStateString args;
        me::vprops_t meVideoProperties;
        if (MTY_VIDEO == m_PlayMediaObject.mediaType)
        {
            ret = LocalSPM::GetDBManager().GetVideoProperties(meVideoProperties);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while getting video properties from dbmanager"));
            }
        }
        VARTRACE(meVideoProperties);
            SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiiltliiiiiiil", m_PlayFileTmp,
                    (int)ME_SPEED_NORMAL, POSITION_NOT_SET, HANDLE_NONE, m_AudioOutputDevice,samplerate_i_none,
                    (int)meVideoProperties.brightness(), (int)meVideoProperties.hue(),
                    (int)meVideoProperties.saturation(), (int)meVideoProperties.contrast(),
                    (int)meVideoProperties.brightnessoffset(), (int)meVideoProperties.saturationoffset(),
                    (int)meVideoProperties.hueoffset(),IsPlaybackSpeed);

        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::PLAY", args, "MTPControlSM::FFWD_STOP_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    } else {

        /* Send StopFfwdSlot to PlayerEngine via DBUS */
        //RegisterReleaseEvent(PLAYBACK_STATUS_RESPONSE);
        ret = LocalSPM::GetIPCProvider().StopFfSlot(IN this);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::StopFfSlot (ErrorCode:%s)", errorString(ret)));
        }

        /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
        tPEPlaybackState status = PE_PBS_PLAYINGSTATE;
        tMetadata metadata1 = {0};
        strncpy_r(metadata1, URL, sizeof(metadata1));
        tMetadata metadata = {0};

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        tObjectID ObjectID = OBJECT_ID_NONE;
        ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN status, IN metadata1, IN metadata, IN metadata, IN metadata,IN ObjectID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string"));
            parameterString[0] = '\0';
        }

        ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF"));
        }
    }

    return MP_NO_ERROR;
}

tResult MTPControl::StartFrevStart(const tDeviceType deviceType, // finished: 100%
                                   const tDeviceID deviceID,
                                   const tURL URL,
                                   const tMountPoint mountPoint,
                                   const tCueingRate rate,
                                   const speedstate_e IsPlaybackSpeed)
{
    ENTRY;
    (void)IsPlaybackSpeed;
    ETG_TRACE_USR3(("MTPControl::StartFrevStart deviceType:%u, deviceID:%u, URL:%40s, mountPoint:%40s, rate:%u, dev:%s",
            deviceType, deviceID, URL, mountPoint, rate, m_AudioOutputDevice));

    tResult ret = MP_NO_ERROR;

    ret = errChkAvailable(mountPoint); //calls sendPlaybackstatus in error case

    if(MP_NO_ERROR == ret)
    {
        if(LocalSPM::GetDataProvider().UseMediaEngine())
        {
            tPEStateString args;
            me::vprops_t meVideoProperties;
            if (MTY_VIDEO == m_PlayMediaObject.mediaType)
            {
                ret = LocalSPM::GetDBManager().GetVideoProperties(meVideoProperties);
                if(MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while getting video properties from dbmanager"));
                }
            }
            VARTRACE(meVideoProperties);
            SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiiltliiiiiiil", m_PlayFileTmp,
                    -(int)rate, POSITION_NOT_SET, HANDLE_NONE, m_AudioOutputDevice,samplerate_i_none,
                    (int)meVideoProperties.brightness(), (int)meVideoProperties.hue(),
                    (int)meVideoProperties.saturation(), (int)meVideoProperties.contrast(),
                    (int)meVideoProperties.brightnessoffset(), (int)meVideoProperties.saturationoffset(),
                    (int)meVideoProperties.hueoffset(),IsPlaybackSpeed);

            ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::PLAY", args, "MTPControlSM::FREV_ANSWER");
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
            }
        } else {

            /* Send StartFrevSlot to PlayerEngine via DBUS */
            //RegisterReleaseEvent(PLAYBACK_STATUS_RESPONSE);
            ret = LocalSPM::GetIPCProvider().StartFrevSlot(IN this, IN rate);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while using IPCProvider::StartFrevSlot (ErrorCode:%s)", errorString(ret)));
            }

            /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
            tPEPlaybackState status = PE_PBS_FASTREVERSESTATE;
            tMetadata metadata1 = {0};
            strncpy_r(metadata1, URL, sizeof(metadata1));
            tMetadata metadata = {0};

            tAllParameters parameterString;
            size_t size = sizeof(parameterString);

            tObjectID ObjectID = OBJECT_ID_NONE;
            ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN status, IN metadata1, IN metadata, IN metadata, IN metadata,IN ObjectID);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while preparing parameter string"));
                parameterString[0] = '\0';
            }

            ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
            }
        }
    }
    return MP_NO_ERROR;
}

tResult MTPControl::StartFrevStop(const tDeviceType deviceType, // finished: 100%
                                  const tDeviceID deviceID,
                                  const tURL URL,
                                  const tMountPoint mountPoint,
                                  const speedstate_e IsPlaybackSpeed)
{
    ENTRY;
    ETG_TRACE_USR3(("MTPControl::StartFrevStop 1 deviceType:%u, deviceID:%u, URL:%40s, mountPoint:%40s, dev:%s",
            deviceType, deviceID, URL, mountPoint, m_AudioOutputDevice));

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        tPEStateString args;
        me::vprops_t meVideoProperties;
        if (MTY_VIDEO == m_PlayMediaObject.mediaType)
        {
            ret = LocalSPM::GetDBManager().GetVideoProperties(meVideoProperties);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while getting video properties from dbmanager"));
            }
        }
        VARTRACE(meVideoProperties);
        SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiiltliiiiiiil", m_PlayFileTmp,
                (int)ME_SPEED_NORMAL, POSITION_NOT_SET, HANDLE_NONE, m_AudioOutputDevice,samplerate_i_none,
                (int)meVideoProperties.brightness(), (int)meVideoProperties.hue(),
                (int)meVideoProperties.saturation(), (int)meVideoProperties.contrast(),
                (int)meVideoProperties.brightnessoffset(), (int)meVideoProperties.saturationoffset(),
                (int)meVideoProperties.hueoffset(),IsPlaybackSpeed);

        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::PLAY", args, "MTPControlSM::FREV_STOP_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    } else {

        /* Send StopFrevSlot to PlayerEngine via DBUS */
        //RegisterReleaseEvent(PLAYBACK_STATUS_RESPONSE);
        ret = LocalSPM::GetIPCProvider().StopFrevSlot(IN this);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::StopFrevSlot (ErrorCode:%s)", errorString(ret)));
        }

        /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
        tPEPlaybackState status = PE_PBS_PLAYINGSTATE;
        tMetadata metadata1 = {0};
        strncpy_r(metadata1, URL, sizeof(metadata1));
        tMetadata metadata = {0};

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        tObjectID ObjectID = OBJECT_ID_NONE;
        ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN status, IN metadata1, IN metadata, IN metadata, IN metadata,IN ObjectID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string"));
            parameterString[0] = '\0';
        }

        ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF"));
        }
    }

    return MP_NO_ERROR;
}
tResult MTPControl::SendVideoProperty()
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    me::vprops_t meVideoProperties;

    ret = LocalSPM::GetDBManager().GetVideoProperties(meVideoProperties);
    if(MP_NO_ERROR == ret)
    {
        VARTRACE(meVideoProperties);
        /* send the ME event to set the video properties here */
        char messageString[64];
        strncpy_r(OUT messageString, IN "MediaEngineSM::SET_VIDEO_PROPERTIES", IN sizeof(messageString));

        tPEStateString args;

        SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "iiiiiii", (int)meVideoProperties.brightness(),
        (int)meVideoProperties.hue(), (int)meVideoProperties.saturation(),
        (int)meVideoProperties.contrast(), (int)meVideoProperties.brightnessoffset(),
        (int)meVideoProperties.saturationoffset(), (int)meVideoProperties.hueoffset());

        ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN args);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        ETG_TRACE_ERR(("Error while retrieving video properties from DB "));
    }
    return ret;
}
tResult MTPControl::StartSeekTo(const tDeviceType deviceType, // finished: 100%
                                const tDeviceID deviceID,
                                const tURL URL,
                                const tMountPoint mountPoint,
                                const tPlaytime position)
{
    ENTRY;
    ETG_TRACE_USR3(("MTPControl::StartSeekTo deviceType:%u, deviceID:%u, URL:%40s, mountPoint:%40s, position:%ums",
            deviceType, deviceID, URL, mountPoint, position));

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        tPEStateString args;
        SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiil", m_PlayFileTmp, (int)ME_SPEED_NONE, position, (tPEHandle)m_PlayMediaObject.objectID);

        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::SEEK_TO", args, "MTPControlSM::SEEK_TO_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    } else {

        /* Send SeekToSlot to PlayerEngine via DBUS */
        tPlaypointFormat playpointFormat = PPF_ABSOLUTE; //absolute time in milliseconds

        //RegisterReleaseEvent(TICK_TIME_ELAPSED);
        ret = LocalSPM::GetIPCProvider().SeekToSlot(IN this, IN position, IN playpointFormat);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::SeekToSlot (ErrorCode:%s)", errorString(ret)));
        }

        /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
        tPlaytime elapsedPlaytime = position;
        tPlaytime totalPlaytime = PLAYTIME_NONE;

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = ParameterTICK_TIME_ELAPSED(OUT parameterString, IN size, IN elapsedPlaytime, IN totalPlaytime);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string"));
        }
        else
        {
            ret = SendEvent(TICK_TIME_ELAPSED, IN parameterString);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
            }
        }
    }

    return MP_NO_ERROR;
}

tResult MTPControl::ActionStatus(const tReturnValue returnValue) // finished: 100%
{
    ENTRY;
    ETG_TRACE_USR3(("MTPControl::ActionStatus returnValue:%u", returnValue));

    tResult ret = MP_NO_ERROR;

    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetDeviceDispatcher().ParameterMETHOD_RETURN(OUT parameterString, IN size, IN returnValue);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string"));
        parameterString[0] = '\0';
    }

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF"));
    }

    return MP_NO_ERROR;
}

/*
    Mediatype could be derived from URL=TrackID using StartPlayer
     and be transported in one of the metadata1...4 parameters or stored in this class if StartPlayer is called
*/
tResult MTPControl::PlaybackStatus(const tPEPlaybackState status,           // finished: 50%
                                   const tMetadata metadata1,
                                   const tMetadata metadata2,
                                   const tMetadata metadata3,
                                   const tMetadata metadata4,
                                   const tObjectID ObjectID)
{
    ENTRY;
    ETG_TRACE_USR3(("MTPControl::PlaybackStatus status:%u, metadata1:%40s, metadata2:%40s, metadata3:%40s, metadata4:%s",
            status, metadata1, metadata2, metadata3, metadata4));

    tResult ret = MP_NO_ERROR;

    /* Send answer to waiting state machine */
    if( PE_PBS_ERRORSTATE == status )
    {
        /* Validate error code */
        me::reason_e reason;
        ret = ValidateErrorCode(OUT reason, IN metadata2, IN m_PlayMediaObject.mountPoint);

        /* Send action error instead of answer to waiting state machine */
        HandleActionError(IN reason);
    }
    else
    {
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = LocalSPM::GetDeviceDispatcher().ParameterPLAY_ANSWER(OUT parameterString,
                IN size,
                IN status,
                IN m_PlayMediaObject.MetadataField1,
                IN m_PlayMediaObject.MetadataField2,
                IN m_PlayMediaObject.MetadataField3,
                IN m_PlayMediaObject.MetadataField4,
                IN m_PlayMediaObject.title,
                IN m_PlayMediaObject.mediaType,
                IN m_PlayMediaObject.metadataConvertFlag,
                IN m_PlayMediaObject.UUID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendAnswer(IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return MP_NO_ERROR;
}

tResult MTPControl::ForwardPlaybackStatus(const tPEPlaybackState status,           // finished: 100%
                                          const tMetadata metadata1,
                                          const tMetadata metadata2,
                                          const tMetadata metadata3,
                                          const tMetadata metadata4,
                                          const tObjectID ObjectID)
{
    ENTRY;
    ETG_TRACE_USR3(("MTPControl::ForwardPlaybackStatus status:%u, metadata1:%40s, metadata2:%40s, metadata3:%40s, metadata4:%s",
            status, metadata1, metadata2, metadata3, metadata4));

    tResult ret = MP_NO_ERROR;

    if( PE_PBS_ERRORSTATE == status )
    {
        /* Validate error code */
        me::reason_e reason;
        ret = ValidateErrorCode(OUT reason, IN metadata2, IN m_PlayMediaObject.mountPoint);

        /* Forward stream error */
        ForwardStreamError(IN reason);
    }
    else
    {
        /* Send PLAYBACK_STATUS_RESPONSE message to PlayerManger to update playback state */
        char messageString[64];
        strncpy_r(messageString, "PlayerManagerSM::PLAYBACK_STATUS_RESPONSE", sizeof(messageString));

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        tObjectID ObjectID = OBJECT_ID_NONE;
        ret = LocalSPM::GetPlayerManager().ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString,
                IN size,
                IN status,
                IN m_PlayMediaObject.MetadataField1,
                IN m_PlayMediaObject.MetadataField2,
                IN m_PlayMediaObject.MetadataField3,
                IN m_PlayMediaObject.MetadataField4,
                IN m_PlayMediaObject.title,
                IN m_PlayMediaObject.mediaType,
                IN m_PlayMediaObject.metadataConvertFlag,
                IN m_PlayMediaObject.UUID,
                IN ObjectID);

    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}
tResult MTPControl::PlaybackStatusNew(const tPEHandle handle, const tPEPlaybackState playbackState, const me::reason_e reason, const me::speed_e speed)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(playbackState);
    VARTRACE(reason);
    VARTRACE(speed);

    tResult ret = MP_NO_ERROR;

    if(REASON_OK > reason)
    {
        me::reason_e localReason = reason;

        if (REASON_URL_ERROR == localReason)
        {
            LIBMTP_mtpdevice_t     *pDevice = NULL;
            m_Mutex.lock();
            pDevice = devTblFind(IN m_PlayMediaObject.mountPoint);
            if(NULL == pDevice)
            {
                localReason = REASON_DEVICE_ERROR;
            }
            m_Mutex.unlock();
        }

        /* Send action error instead of answer to waiting state machine */
        HandleActionError(IN localReason);
    }
    else
    {
        /* Send answer to waiting state machine */
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = LocalSPM::GetDeviceDispatcher().ParameterPLAY_ANSWER_NEW(OUT parameterString, IN size, IN handle, IN playbackState, IN reason, IN speed);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendAnswer(IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return MP_NO_ERROR;
}

tResult MTPControl::ForwardPlaybackStatusNew(const tPEHandle handle, const tPEPlaybackState playbackState, const me::reason_e reason, const me::speed_e speed)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(playbackState);
    VARTRACE(reason);
    VARTRACE(speed);

    tResult ret = MP_NO_ERROR;

    if(((tObjectID)handle != m_PlayMediaObject.objectID)
       &&
       (PE_PBS_STOPPEDSTATE != playbackState))
    {
        ETG_TRACE_ERR(("Obsolete playback status -> Do not forward objectID:%u", (tObjectID)handle));
    }
    else
    {
        //Remark: Interpretation of non error reasons is done in PlayerManager::ForwardPlaybackStatusNew
        if(REASON_OK > reason)
        {
            me::reason_e localReason = reason;

            if (REASON_URL_ERROR == localReason)
            {
                LIBMTP_mtpdevice_t     *pDevice = NULL;
                m_Mutex.lock();
                pDevice = devTblFind(IN m_PlayMediaObject.mountPoint);
                if(NULL == pDevice)
                {
                    localReason = REASON_DEVICE_ERROR;
                }
                m_Mutex.unlock();
            }

            /* Forward stream error */
            ForwardStreamError(IN localReason);
        }
        else
        {
            /* Send PLAYBACK_STATUS message to PlayerManger to update playback status */
            char messageString[64];
            strncpy_r(messageString, "PlayerManagerSM::PLAYBACK_STATUS", sizeof(messageString));
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);

            ret = LocalSPM::GetPlayerManager().ParameterPLAYBACK_STATUS(OUT parameterString, IN size, IN handle, IN playbackState, IN reason, IN speed);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                parameterString[0] = '\0';
            }

            ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    return ret;
}

tResult MTPControl::HandleActionError(const me::reason_e reason)
{
    ENTRY_INTERNAL

    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    /* Send action error instead of answer to waiting state machine */
    ret = LocalSPM::GetDeviceDispatcher().ParameterACTION_ERROR(OUT parameterString, IN size, IN reason);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendActionError(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending action error via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult MTPControl::ForwardStreamError(const me::reason_e reason) const
{
    ENTRY_INTERNAL

    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    /* Send STREAM_ERROR message to DeviceDispatcher */
    char messageString[64];
    strncpy_r(messageString, "DeviceDispatcherSM::STREAM_ERROR", sizeof(messageString));

    ret = LocalSPM::GetDeviceDispatcher().ParameterSTREAM_ERROR(OUT parameterString, IN size, IN reason);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}


tResult MTPControl::ForwardNowPlayingStatus(const tPEHandle handle, const tURL URL)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(URL);

    tResult ret = MP_NO_ERROR;

    if((tObjectID)handle != m_PlayMediaObject.objectID)
    {
        ETG_TRACE_ERR(("Obsolete nowPlaying status -> Do not forward objectID:%u", (tObjectID)handle));
    }
    else
    {
        /* Update media object to play */
        InitMediaObject(OUT m_PlayMediaObject);
        m_PlayMediaObject.objectID = (tObjectID)handle;
        ret = LocalSPM::GetDBManager().GetFileFormat(OUT m_PlayMediaObject.fileFormat, OUT m_PlayMediaObject.fileType, IN URL);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("unable to get file format for the url : %s", URL));
        }
        else
        {
            if((LocalSPM::GetDataProvider().MTPVideoSupport()) && (FT_VIDEO == m_PlayMediaObject.fileType )) /*Read video metadata*/
                ReadVideoMetadataFromFile(INOUT m_PlayMediaObject, IN URL);
            else
                ReadMetadataFromFile(IN handle, IN URL);
        }

        /* Send NOW_PLAYING_STATUS message to PlayerManger to update nowPlaying info of object */
        char messageString[64];
        strncpy_r(messageString, "PlayerManagerSM::NOW_PLAYING_STATUS", sizeof(messageString));
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = LocalSPM::GetPlayerManager().ParameterNOW_PLAYING_STATUS(OUT parameterString,
                IN size,
                IN handle,
                IN m_PlayMediaObject.MetadataField1,
                IN m_PlayMediaObject.MetadataField2,
                IN m_PlayMediaObject.MetadataField3,
                IN m_PlayMediaObject.MetadataField4,
                IN m_PlayMediaObject.title,
                IN m_PlayMediaObject.mediaType,
                IN m_PlayMediaObject.bitRate,
                IN m_PlayMediaObject.sampleRate,
                IN m_PlayMediaObject.audioChannelFormat,
                IN m_PlayMediaObject.metadataConvertFlag,
                IN NULL,
                IN NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult MTPControl::ReadMetadataFromFile(const tPEHandle handle, const tURL URL)
{
    ENTRY_INTERNAL
    VARTRACE(handle);
    VARTRACE(URL);

    /* Update media object to play */
    InitMediaObject(OUT m_PlayMediaObject);
    m_PlayMediaObject.objectID = (tObjectID)handle;

    string target = URL;
    Info * info = Info::create_tag_info(target);
    if(info)
    {
        if(info->read())
    {
        /* transfer the meta info to the meta tags of the media object */
        TransferMetaTags(IN (void *)info, OUT m_PlayMediaObject);

        /* Check if file is encrypted (DRM protected) */
        if(info->get_encrypted())
        {
            m_PlayMediaObject.notPlayable = FNP_DRM_PROTECTED;
        }

        }
        delete info;
    }
    else
    {
        ETG_TRACE_ERR(("Error while reading TagInfo::Tag -> Use empty media object"));
    }

    if(!strlen_r(m_PlayMediaObject.title))
    {
        ETG_TRACE_USR1(("No title available -> use filename instead"));

        tURL fullName;
        unsigned char *pureFile;
        strncpy_r(OUT fullName, IN URL, IN sizeof(fullName));
        FastUTF8::Split(OUT pureFile, INOUT (unsigned char *)fullName);

        if (pureFile)
        {
            /* Remove the extension, if wanted */
            if (LocalSPM::GetDataProvider().DBRemoveExtensionFromFilename()) {

                unsigned char *extension;
                FastUTF8::SplitExtension(OUT extension, INOUT (unsigned char *)pureFile);
            }

            strncpy_r(OUT (char *)m_PlayMediaObject.title, IN (const char *)pureFile, IN sizeof(m_PlayMediaObject.title));
        }
    }

    VARTRACE5(m_PlayMediaObject.title, m_PlayMediaObject.MetadataField1, m_PlayMediaObject.MetadataField2, m_PlayMediaObject.MetadataField3, m_PlayMediaObject.MetadataField4);

    return MP_NO_ERROR;
}

void MTPControl::TransferMetaTags(void *_info, tMediaObject &mediaObject)
{
    Info* info = (Info *)_info;

#if 0 // for testting - pleaase keep this
    static FILE *logFile = NULL;
    //char tagDescriptor[20] =  "mediaObject.title"; //lint fix
    if (!logFile) {
        logFile = fopen("/tmp/TransferMetaTags.txt", "w");
    }
#endif

    int convertMetadataField1toUniCode = 0;
    int convertMetadataField2toUniCode = 0;
    int convertMetadataField3toUniCode = 0;
    int convertMetadataField4toUniCode = 0;
    int convertTitletoUniCode = 0;

    /* only for GBK and Korean: */
    if (LocalSPM::GetDataProvider().GBKSupported() || LocalSPM::GetDataProvider().EUC_KRSupported()) {
        convertMetadataField1toUniCode = !info->get_genre().isLatin1();
        convertMetadataField2toUniCode = !info->get_artist().isLatin1();
        convertMetadataField3toUniCode = !info->get_composer().isLatin1();
        convertMetadataField4toUniCode = !info->get_album().isLatin1();
        convertTitletoUniCode = !info->get_title().isLatin1();
    }else{/* all others(if CodeSetConversion not Supported): if no UTF8 */

        /*If CodeSetConversionSupported is TRUE,then the Validation of the metadata given by libTagInfo
        (whether in UTF8 encoding or not )will be checked in MTPControl::DoCodeSetConversionToUTF8*/
        if(!LocalSPM::GetDataProvider().CodeSetConversionSupported())
        {
            convertMetadataField1toUniCode = !g_utf8_validate((const gchar *)info->get_genre().toCString(false) , -1, NULL);
            convertMetadataField2toUniCode = !g_utf8_validate((const gchar *)info->get_artist().toCString(false) , -1, NULL);
            convertMetadataField3toUniCode = !g_utf8_validate((const gchar *)info->get_composer().toCString(false) , -1, NULL);
            convertMetadataField4toUniCode = !g_utf8_validate((const gchar *)info->get_album().toCString(false) , -1, NULL);
            convertTitletoUniCode = !g_utf8_validate((const gchar *)info->get_title().toCString(false) , -1, NULL);
        }
    }

    if(LocalSPM::GetDataProvider().CodeSetConversionSupported())
    {
        /*Invoked to find  and convert Non UTF-8 metadata strings(given by LibTagInfo)*/
        LocalSPM::GetDataProvider().FindAndConvertLatin1MetadataEntries(INOUT mediaObject ,IN (void*)info);
    }
    else
    {
    /* this is the newer version of handling Latin1 characters for meta tags */
        /* get the tag information */
    strncpy_r(mediaObject.MetadataField1, info->get_genre().toCString(convertMetadataField1toUniCode),
            sizeof(mediaObject.MetadataField1));
    strncpy_r(mediaObject.MetadataField2, info->get_artist().toCString(convertMetadataField2toUniCode),
            sizeof(mediaObject.MetadataField2));
    strncpy_r(mediaObject.MetadataField3, info->get_composer().toCString(convertMetadataField3toUniCode),
            sizeof(mediaObject.MetadataField3));
    strncpy_r(mediaObject.MetadataField4, info->get_album().toCString(convertMetadataField4toUniCode),
            sizeof(mediaObject.MetadataField4));
    strncpy_r(mediaObject.title, info->get_title().toCString(convertTitletoUniCode),
            sizeof(mediaObject.title));
    }
#if 0
    if (logFile) { // for testing
        fprintf(logFile, "convertTitletoUniCode=%d\n", convertTitletoUniCode);
        hexDump(logFile, (const char *)"mediaObject.title", mediaObject.title, strlen_r(mediaObject.title));
    }
#endif

    /* If genre is empty , then read the GenreID to select the genre names*/
#if 0
    LocalSPM::GetDataProvider().VerifyGenreName(info->get_genreNr(),mediaObject.MetadataField1);
#else
    LocalSPM::GetDataProvider().VerifyGenreName(255,mediaObject.MetadataField1);
#endif

    if(LocalSPM::GetDataProvider().CodeSetConversionSupported())
    {
        //No need to Call Convert2UTF8 as it is already converted to UTF8 by DataProvider::FindAndConvertLatin1MetadataEntries
    }
    else
    {
    /* if it was NOT converted to unicode, it must be reconverted to UTF-8 */
    if (!convertMetadataField1toUniCode) {
        LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(mediaObject.MetadataField1),
            sizeof(mediaObject.MetadataField1));
    }
    if (!convertMetadataField2toUniCode) {
        LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(mediaObject.MetadataField2),
            sizeof(mediaObject.MetadataField2));
    }
    if (!convertMetadataField3toUniCode) {
        LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(mediaObject.MetadataField3),
            sizeof(mediaObject.MetadataField3));
    }
    if (!convertMetadataField4toUniCode) {
        LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(mediaObject.MetadataField4),
            sizeof(mediaObject.MetadataField4));
    }
    if (!convertTitletoUniCode) {
        LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(mediaObject.title),
            sizeof(mediaObject.title));
        }

    }

#if 0
    if (logFile) { // for testing
        hexDump(logFile, (const char *)"mediaObject.title", mediaObject.title, strlen_r(mediaObject.title));
    }
#endif

    /* cut metadata */
    LocalSPM::GetDataProvider().CutMetadata((FastUTF8::tString)(mediaObject.MetadataField1), sizeof(mediaObject.MetadataField1));
    LocalSPM::GetDataProvider().CutMetadata((FastUTF8::tString)(mediaObject.MetadataField2), sizeof(mediaObject.MetadataField2));
    LocalSPM::GetDataProvider().CutMetadata((FastUTF8::tString)(mediaObject.MetadataField3), sizeof(mediaObject.MetadataField3));
    LocalSPM::GetDataProvider().CutMetadata((FastUTF8::tString)(mediaObject.MetadataField4), sizeof(mediaObject.MetadataField4));
    LocalSPM::GetDataProvider().CutMetadata((FastUTF8::tString)(mediaObject.title), sizeof(mediaObject.title));


#if 0
    /* if title is Latin1 encoded, do not convert to Unicode in all the next steps */
    /* thm3hi: I assume that all tags are coded uniquely */
    bool convertToUnicode;
    if (info->get_title().isLatin1()) {
        convertToUnicode = false;
    }
    else {
        convertToUnicode = true;
    }
        /* get the tag information */
    strncpy_r(mediaObject.MetadataField1, info->get_genre().toCString(convertToUnicode),
            sizeof(mediaObject.MetadataField1));
    strncpy_r(mediaObject.MetadataField2, info->get_artist().toCString(convertToUnicode),
            sizeof(mediaObject.MetadataField2));
    strncpy_r(mediaObject.MetadataField3, info->get_composer().toCString(convertToUnicode),
            sizeof(mediaObject.MetadataField3));
    strncpy_r(mediaObject.MetadataField4, info->get_album().toCString(convertToUnicode),
            sizeof(mediaObject.MetadataField4));
    strncpy_r(mediaObject.title, info->get_title().toCString(convertToUnicode), sizeof(mediaObject.title));

        /* If genre is empty , then read the GenreID to select the genre names*/
#if 0
    LocalSPM::GetDataProvider().VerifyGenreName(info->get_genreNr(),mediaObject.MetadataField1);
#else
    LocalSPM::GetDataProvider().VerifyGenreName(255,mediaObject.MetadataField1);
#endif

    /* if it was NOT converted to unicode, it must be reconverted to UTF-8 */
    if (!convertToUnicode) {
        /* change string to GBK and cut them */
        LocalSPM::GetDataProvider().ImportAndCut((FastUTF8::tString)(mediaObject.MetadataField1),
                sizeof(mediaObject.MetadataField1));
        LocalSPM::GetDataProvider().ImportAndCut((FastUTF8::tString)(mediaObject.MetadataField2),
                sizeof(mediaObject.MetadataField2));
        LocalSPM::GetDataProvider().ImportAndCut((FastUTF8::tString)(mediaObject.MetadataField3),
                sizeof(mediaObject.MetadataField3));
        LocalSPM::GetDataProvider().ImportAndCut((FastUTF8::tString)(mediaObject.MetadataField4),
                sizeof(mediaObject.MetadataField4));
        LocalSPM::GetDataProvider().ImportAndCut((FastUTF8::tString)(mediaObject.title),
                sizeof(mediaObject.title));
    }
#endif
}

tResult MTPControl::PlaytimeStatus(const tPlaytime elapsedPlaytime, const tPlaytime totalPlaytime) // finished: 100%
{
    ENTRY;
    ETG_TRACE_USR3(("MTPControl::PlaytimeStatus elapsedPlaytime:%u, totalPlaytime:%u", elapsedPlaytime, totalPlaytime));

    tPETimeInfoStruct timeInfoStruct;
    InitPETimeInfoStruct(timeInfoStruct);
    timeInfoStruct.position.ms = (tPEMilliseconds)elapsedPlaytime;
    timeInfoStruct.duration.ms = (tPEMilliseconds)totalPlaytime;

    /* Marshal struct of timeInfo into a string */
    tPETimeInfo timeInfoString;
    size_t size = sizeof(timeInfoString);
    SMF::Marshal(OUT timeInfoString,
                 IN size-1,
                 IN DOUBLE_MARSHAL_SEPARATOR,
                 IN tPEBytes_format tPEPercentage_format tPEMilliseconds_format tPEBytes_format tPEMilliseconds_format,
                 IN timeInfoStruct.position.bytes,
                 IN timeInfoStruct.position.pct,
                 IN timeInfoStruct.position.ms,
                 IN timeInfoStruct.duration.bytes,
                 IN timeInfoStruct.duration.ms);

    PlaytimeStatusNew(IN (tPEHandle)m_PlayMediaObject.objectID, IN timeInfoString);
    return MP_NO_ERROR;
}

tResult MTPControl::ForwardPlaytimeStatus(const tPlaytime elapsedPlaytime, const tPlaytime totalPlaytime) // finished: 100%
{
    ENTRY;
    ETG_TRACE_USR3(("MTPControl::ForwardPlaytimeStatus elapsedPlaytime:%u, totalPlaytime:%u", elapsedPlaytime, totalPlaytime));

    tResult ret = MP_NO_ERROR;


    tPETimeInfoStruct timeInfoStruct;
    InitPETimeInfoStruct(timeInfoStruct);
    timeInfoStruct.position.ms = (tPEMilliseconds)elapsedPlaytime;
    timeInfoStruct.duration.ms = (tPEMilliseconds)totalPlaytime;

    /* Marshal struct of timeInfo into a string */
    tPETimeInfo timeInfoString;
    size_t size = sizeof(timeInfoString);
    SMF::Marshal(OUT timeInfoString,
                 IN size-1,
                 IN DOUBLE_MARSHAL_SEPARATOR,
                 IN tPEBytes_format tPEPercentage_format tPEMilliseconds_format tPEBytes_format tPEMilliseconds_format,
                 IN timeInfoStruct.position.bytes,
                 IN timeInfoStruct.position.pct,
                 IN timeInfoStruct.position.ms,
                 IN timeInfoStruct.duration.bytes,
                 IN timeInfoStruct.duration.ms);

    ret = ForwardPlaytimeStatusNew(IN (tPEHandle)m_PlayMediaObject.objectID, IN timeInfoString);

    return ret;
}

tResult MTPControl::PlaytimeStatusNew(const tPEHandle handle, const tPETimeInfo timeInfo)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(timeInfo);

    tResult ret = MP_NO_ERROR;

    /* Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetDeviceDispatcher().ParameterPLAYTIME_STATUS(OUT parameterString, IN size, IN handle, IN m_PlayMediaObject.deviceID, IN timeInfo);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return MP_NO_ERROR;
}

tResult MTPControl::ForwardPlaytimeStatusNew(const tPEHandle handle, const tPETimeInfo timeInfo)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(timeInfo);

    tResult ret = MP_NO_ERROR;

    if ((tObjectID)handle != m_PlayMediaObject.objectID)
    {
        ETG_TRACE_ERR(("Obsolete playtime status -> Do not forward objectID:%u", (tObjectID)handle));
    }
    else
    {
        /* Send PLAYTIME_STATUS message to PlayerManger to update playtime */
        char messageString[64];
        strncpy_r(messageString, "PlayerManagerSM::PLAYTIME_STATUS", sizeof(messageString));
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = LocalSPM::GetPlayerManager().ParameterPLAYTIME_STATUS(OUT parameterString, IN size, IN handle, IN m_PlayMediaObject.deviceID, IN timeInfo);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}


/*
  used if commands towards MTP-device and player engine not acked in time?
  where is timout time set?
*/
tResult MTPControl::HandleAnswerTimeout() // finished: 100%
{
    ENTRY;
    ETG_TRACE_ERR(("MTPControl::HandleAnswerTimeout"));

    tResult ret = MP_NO_ERROR;

    /* Send releasing event to own waiting state machine */
    ret = ReleaseWaiting();
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while releasing waiting via SMF"));
    }

    return ret;
}

tResult MTPControl::SetOutputDevice(const tAudioOutputDevice audioOutputDevice)
{
    ENTRY
    VARTRACE(audioOutputDevice);

    /* Store audio output device (alsa device name) internally */
    strncpy_r(OUT m_AudioOutputDevice, IN audioOutputDevice, IN sizeof(m_AudioOutputDevice));

    return MP_NO_ERROR;
}

/*
need more understanding here is it to catch error callbacks of player engine
*/
tResult MTPControl::ValidateErrorCode(me::reason_e &reason, const tMetadata errorCode, const tMountPoint mountPoint)
{
    ENTRY

    tUInt errorEnum = atoi(errorCode);

    switch(errorEnum)
    {
    case MEDIAPLAYER_ERROR_DEVICE_NOT_FOUND:
    case MEDIAPLAYER_ERROR_AUDIO_DEVICE_ALREADY_IN_USE:
        reason = REASON_DEVICE_ERROR;
        break;
    case MEDIAPLAYER_ERROR_FILE_DOES_NOT_EXISTS:
    case MEDIAPLAYER_ERROR_CANNOT_DECODE_MEDIA:
    case MEDIAPLAYER_ERROR_UNKNOWN_ERROR:
    default:
        reason = REASON_FORMAT_ERROR;
        break;
    }

    if(REASON_FORMAT_ERROR == reason)
    {
        LIBMTP_mtpdevice_t     *pDevice = NULL;
        m_Mutex.lock();
        pDevice = devTblFind(IN mountPoint);
        if(NULL == pDevice)
        {
            reason = REASON_DEVICE_ERROR;
        }
        m_Mutex.unlock();
    }

    return MP_NO_ERROR;
}


tResult MTPControl::Umount(const tDeviceID deviceID, const tMountPoint mountPoint) // finished: 0%
{
    ENTRY;
    VARTRACE(deviceID);
    VARTRACE(mountPoint);

    tResult ret = MP_NO_ERROR;

    //NOT SUPPORTED BY MTP - send an answer back to DeviceDispatcher
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    SMF::Marshal(parameterString, size - 1, "i", MP_ERR_UMOUNT_NOT_SUPPORTED);

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

//BEGIN-------------------------------------------Connect device---------------------------------------------------------------------

//triggered: by connecting device
tResult MTPControl::IsInitRequired(const tDeviceInfoString deviceInfoString) // finished: 44%
{
    ENTRY;

    tDeviceInfo deviceInfo;
    DataProvider::UnMarshalDeviceInfo(deviceInfoString, deviceInfo);

    tResult ret = MP_NO_ERROR;


    //VARTRACE(deviceID);
    //VARTRACE(mountPoint);
    ETG_TRACE_USR3(("MTPControl::IsInitRequired deviceID:%u, mountPoint:%s", deviceInfo.deviceID, deviceInfo.mountPoint));

    //------------------------------------------------------------------
    // match mount point to device
    //-----------------------------------------------------------------
    LIBMTP_mtpdevice_t  *pDevice = devTblFind(deviceInfo.mountPoint);


    if(NULL != pDevice)
    {

        ETG_TRACE_USR4(("IsInitRequired: mountPoint: pDevice for mountPoint - already exists"));
        ETG_TRACE_USR4(("IsInitRequired: means device has been removed and connected again"));
        ret = devTbl_Del(IN deviceInfo.mountPoint);
        if(MP_NO_ERROR == ret)
        {
            ETG_TRACE_USR4(("IsInitRequired: deleted already removed device"));
            if(m_eTypeOfWrapper == eMTPWrapper_realLib) //if test is executed internal list of MTPControl has been already prepared with devices
            {
                pDevice = devTblFind(deviceInfo.mountPoint);
                if(pDevice != NULL)
                {
                   ETG_TRACE_ERR(("[ERROR] IsInitRequired:ERROR to delete device"));
                }
            }
        }
        else
        {
            ETG_TRACE_ERR(("[ERROR] IsInitRequired: could not delete device"));
            ret = MP_ERR_MTP_NODEVMATCH;
        }

    }

    if((NULL == pDevice) && (MP_NO_ERROR == ret))
    {
        ETG_TRACE_USR4(("IsInitRequired: mountPoint: pDevice for mountPoint not found"));

        //------------------------------------------------------------------
        //get list of connected MTP-devices
        //------------------------------------------------------------------

        tDeviceInfo deviceInfoMTP;
        ret = decodeMountPoint(IN deviceInfo.mountPoint, OUT deviceInfoMTP);
        if(MP_NO_ERROR == ret)
        {
             pDevice = m_pMTPLibWrapper->matchDevice2MountPoint(IN deviceInfoMTP.serialNumber,
                                                                IN deviceInfoMTP.deviceVersion,
                                                                IN deviceInfoMTP.deviceName);
             if(NULL != pDevice)
             {
                 //-----------------------------------------------------
                 //          add new device and mount point
                 //-----------------------------------------------------
                 ret = devTbl_Add(IN deviceInfo.mountPoint, IN pDevice, IN deviceInfo.deviceID);
             }
             else
             {
                 ret = MP_ERR_MTP_NODEVMATCH;
                 ETG_TRACE_ERR(("[ERROR] IsInitRequired: MP_ERR_MTP_NODEVMATCH"));
             }
        }
        else
        {
            ret = MP_ERR_MTP_DECODEMOUNTPOINT;
            ETG_TRACE_ERR(("[ERROR] IsInitRequired: MP_ERR_MTP_DECODEMOUNTPOINT"));
        }
    }

    return NoInitAnswer(IN deviceInfoString);
}

//triggered: by return value of IsInitRequired
tResult MTPControl::SendInitInit(const tDeviceInfoString deviceInfoString) // finished: 44%
{
    ENTRY;

    tDeviceInfo deviceInfo;
    DataProvider::UnMarshalDeviceInfo(deviceInfoString, deviceInfo);
    ETG_TRACE_USR3(("MTPControl::SendInitInit deviceID:%u, mountPoint:%s", deviceInfo.deviceID, deviceInfo.mountPoint));
   /* For MTP no implementation */
    return MP_NO_ERROR;
}

//triggered: by return value of previous called IsInitRequired
tResult MTPControl::NoInitAnswer(const tDeviceInfoString deviceInfoString) // finished: 100%
{
    ENTRY;

    tDeviceInfo deviceInfo;
    DataProvider::UnMarshalDeviceInfo(deviceInfoString, deviceInfo);
    ETG_TRACE_USR3(("MTPControl::NoInitAnswer deviceID:%u, mountPoint:%s", deviceInfo.deviceID, deviceInfo.mountPoint));
    tResult ret = MP_NO_ERROR;

    /* Send INIT_DEVICE_CONNECTION message to IndexerSM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tConnectionState connectionState = CS_CONNECTED;

    LIBMTP_mtpdevice_t *pDevice = NULL;
    m_Mutex.lock();
    pDevice = devTblFind(IN deviceInfo.mountPoint);

    if((NULL == pDevice) || (NULL == pDevice->storage))
    {
        connectionState = CS_ATTACHED;
    }
    m_Mutex.unlock();

    ret = LocalSPM::GetIndexer().ParameterDEVICE_INITIALIZED(OUT parameterString, IN size, IN deviceInfo.deviceName, IN deviceInfo.deviceID, IN connectionState);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string"));
        parameterString[0] = '\0';
    }

    ret = LocalSPM::GetIndexer().SendEventByName("DEVICE_INITIALIZED", IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF"));
        ret = LocalSPM::GetIndexer().SendEventByName("ON_DEVICE_INITIALIZED", IN parameterString);
    }

    return MP_NO_ERROR;
}

//END---------------------------------------------Connect device---------------------------------------------------------------------

//replaces isInitRequired
tResult MTPControl::IsInitDeviceConnection(const tMountPoint mountPoint) // // finished: 44%
{
    ENTRY;

    ETG_TRACE_USR3(("MTPControl::IsInitDeviceConnection mountPoint:%s", mountPoint));

   /* For MTP no implementation -> return false */
   return false;
}

tResult MTPControl::Disconnect(const tMountPoint mountPoint) // finished: 100%
{
   ENTRY
   ETG_TRACE_USR3(("MTPControl::Disconnect mountPoint:%s", mountPoint));

   /* For MTP no implementation */
   return MP_NO_ERROR;
}

tResult MTPControl::OnDeviceInitialized(const tMountPoint mountPoint, const tConnectionState connectionState) // finished: 100%
{
   ENTRY;
   VARTRACE(mountPoint);
   VARTRACE(connectionState);

   ETG_TRACE_ERR(("OnDeviceInitialized: connectionState: %d",connectionState));
   m_DeviceRemoved = false;
   return MP_NO_ERROR;
}

tResult MTPControl::GetNumberOfFiles(const tDeviceID deviceID)
{
    //Device type is not supported for indexing, nevertheless indexer requires the total number of playable files from this device
    //Added for VAG iPod streaming

    ENTRY;
    VARTRACE(deviceID);

    tNumberOfFiles numberOfFiles = 0;

    /* Send ANSWER message to IndexerSM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    LocalSPM::GetIndexer().ParameterNUMBER_OF_FILES_ANSWER(OUT parameterString, IN size, IN deviceID, IN numberOfFiles);
    SendAnswer(IN parameterString);

    return MP_NO_ERROR;
}

tResult MTPControl::CalcFingerprint(const tMountPoint mountPoint, const tDeviceID deviceID, const tFingerprint lastFingerprint) // finished: 100%
{
    ENTRY
    ETG_TRACE_USR3(("MTPControl::CalcFingerprint deviceID: %u, mountPoint:%s", deviceID, mountPoint));

    tResult ret = MP_NO_ERROR;

        /* Use helper function to marshal parameters */
        //string length = length of mountpoint + separator + max int length + separator + length of fingerprint + separator + null termination
        tUInt stringLen = strlen_r(mountPoint)+1+16+1+strlen_r(lastFingerprint)+1+1;
        char *parameterString = new char[stringLen];
        parameterString[0] = 0;

        ret = ParameterGET_FINGERPRINT(OUT parameterString, IN stringLen, IN mountPoint, IN deviceID, IN lastFingerprint);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        }

        /* Spawn worker thread for fingerprint calculation */
        LocalSPM::GetThreadFactory().Do(this, THREAD_FINGERPRINT, (void *)parameterString, this); //lint -e429 freed by calling thread

    return ret;
}
//triggered from outside
void MTPControl::DoCalcFingerprintThread(IN const char *parameterString)
{
    ENTRY;

    tFingerprint       fingerprint = {0};
    tNumberOfFiles     numberOfFiles = 0;
    LIBMTP_devicestorage_t *pStorage = NULL;
    const LIBMTP_mtpdevice_t     *pDevice = NULL;
    tDeviceID    deviceID        = DEVICE_ID_NOT_SET;
    tMountPoint  mountPoint      = {0};
    tFingerprint lastFingerprint = {0};
    tFingerprintStatus fingerprintStatus = FPS_NOT_AVAIL;

     if(parameterString)
     {
        SMF::UnMarshal(IN parameterString, tMountPoint_format tDeviceID_format tFingerprint_format, mountPoint , &deviceID, lastFingerprint);
        ETG_TRACE_USR3(("MTPControl::DoCalcFingerprintThread deviceID       : %u, mountPoint:%s", deviceID, mountPoint));
        ETG_TRACE_USR3(("MTPControl::DoCalcFingerprintThread lastFingerprint: %s", lastFingerprint));

        delete[] parameterString;
     }
     else
     {
         ETG_TRACE_ERR(("[ERROR]: MTPControl::DoCalcFingerprintThread: parameterString == NULL!"));
     }

    m_Mutex.lock();
    pDevice = devTblFind(IN mountPoint);
    int index = 0;
    if((NULL == pDevice) || (NULL == pDevice->storage))
    {
        fingerprintStatus = FPS_OK_SKIP_INDEXING;
        numberOfFiles = NUMBER_OF_FILES_NONE;
        m_Mutex.unlock();
    }
    else
    {
    //clear the cache
    MTPCache_ClearStorage(mountPoint);
    MTPCache_ClearCacheEntry(deviceID);
    MTPCache_StoreDeviceId(deviceID, mountPoint);

    pStorage = pDevice->storage;
    if(pStorage != NULL)
    {
        for (; pStorage != 0; pStorage = pStorage->next)
        {
            ETG_TRACE_USR4(("MTPControl::DoCalcFingerprintThread Storage Description: %s", pStorage->StorageDescription));
            ETG_TRACE_USR4(("MTPControl::DoCalcFingerprintThread Storage ID: %d", pStorage->id));
            MTPCache_WriteStorageEntry(mountPoint, index, pStorage);
            index++;
        }
    }
    m_Mutex.unlock();
    tResult result = MP_NO_ERROR;
    tDeviceInfo deviceInfo;
    result = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    if(MP_NO_ERROR == result)
    {
        numberOfFiles = deviceInfo.numberOfAudioFiles;
    }
    else
    {
        numberOfFiles = 0;
    }
    }
    ETG_TRACE_USR4(("MTPControl::DoCalcFingerprintThread: numberOfFiles: %d",numberOfFiles))

    //--------------------------------------------------------------------------------------------------------------------------------------------
    // Send PUT_FINGERPRINT event to own state machine as a result function OnFingerprint will be called - prease refer to corresponding uml-file
    //--------------------------------------------------------------------------------------------------------------------------------------------
    tResult ret = MP_NO_ERROR;
    tAllParameters l_parameterString;
    size_t size = sizeof(l_parameterString);

    ret = ParameterPUT_FINGERPRINT(OUT l_parameterString, IN size,
            IN fingerprint, IN fingerprintStatus, IN numberOfFiles, IN deviceID);

    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("MTPControl::CalcFingerprint - Error while preparing parameter string"));
        l_parameterString[0] = '\0';
    }

    ret = SendEvent(PUT_FINGERPRINT, IN l_parameterString);
    if( MP_NO_ERROR != ret )
    {
     ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }
}


//triggered by CalcFingerprint
tResult MTPControl::OnFingerprint(const tFingerprint fingerprint,             // finished: 100%
                                  const tFingerprintStatus fingerprintStatus,
                                  const tNumberOfFiles numberOfFiles,
                                  const tDeviceID deviceID)
{
    ENTRY;

    VARTRACE(fingerprint);
    VARTRACE(fingerprintStatus);
    VARTRACE(numberOfFiles);
    VARTRACE(deviceID);

    tResult ret = MP_NO_ERROR;

    mReadStatus = FOLDER_READ_NOT_STARTED;

    /* Send FINGERPRINT_AVAIL message to IndexerSM */
    char messageString[64];
    strncpy(messageString, "IndexerSM::FINGERPRINT_AVAIL",
            sizeof(messageString) - 1);

    tAllParameters parameterString;
    size_t size = sizeof(parameterString);


    ret = LocalSPM::GetIndexer().ParameterFINGERPRINT_AVAIL(OUT parameterString,
                                                             IN size,
                                                             IN fingerprint,
                                                             IN fingerprintStatus,
                                                             IN numberOfFiles,
                                                             IN deviceID);
    if (MP_NO_ERROR != ret) {
        ETG_TRACE_ERR(("MTPControl::OnFingerprint - Error while preparing parameter string"));
        parameterString[0] = '\0';
    }
    ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
    TestIF_sendTestResultMsg(IN fingerprint); //only send if Test has connected a testResultMsgQ

    return MP_NO_ERROR;
}


//BEGIN-----------------------------------------CARE FOR METADATA----------------------------------------------------------------------
// Triggered from outside
// This function will open folder one by one and store in the cache
tResult MTPControl::IsNextMetadataAvailable(const tMountPoint mountPoint, const tReadPosition readPosition, const tDeviceID deviceID) // finished: 44%
{
    ENTRY;

    ETG_TRACE_USR3(("MTPControl::IsNextMetadataAvailable deviceID: %u, mountPoint:%40s, readPosition:%s", deviceID, mountPoint, readPosition));
    /* Return false always because we use no metadata cache */
    return false; //to trigger RetrieveMetadataFromDevice
}


void MTPControl::DoReadFilesFromDeviceThread(IN const char *parameterString)
{

    ENTRY;
    tMountPoint mountPoint;
    uint32_t storageId,FolderId;
    tAvailable isFolderView = 0;

    LIBMTP_file_t *pFile = NULL;
    tPath parentpath;
    static tU32 index = 0;
    tS32 readindex = 0;

    SMF::UnMarshal(IN parameterString, tMountPoint_format tIndex_format  tIndex_format tAvailable_format , mountPoint , &storageId, &FolderId, &isFolderView);

    if(parameterString)
    {
        delete [] parameterString;
    }

    LIBMTP_mtpdevice_t     *pDevice = devTblFind(IN mountPoint);

    if(pDevice != NULL)
    {
        TimeTrace ticks("MTPControlFolderRead");
        pFile = m_pMTPLibWrapper->wLIBMTP_Get_Item(pDevice, storageId, FolderId,&readindex);
        ticks.elapsed();

        tDeviceID deviceId = 0;
        deviceId = MTPCache_GetDeviceId(mountPoint);

        if(pFile != NULL)
        {
            tMTPFile MTPFile; // Review comment <Following naming convensions> from tFile to MTPFile
            MTPFile.filesize  = pFile->filesize;
            MTPFile.filetype  = pFile->filetype;
            MTPFile.item_id   = pFile->item_id;

            if(NULL != pFile->filename)
            strncpy_r(MTPFile.filename, pFile->filename, sizeof(MTPFile.filename));

            m_pMTPLibWrapper->wLIBMTP_destroy_file_t(pFile);
            VARTRACE(MTPFile.filename);
            VARTRACE(MTPFile.filetype);
            VARTRACE(MTPFile.item_id);

            /* TODO(pee1cob):Need to verify the MTPFile's extension is Supported.Thus, they can be skipped from indexing if not supported.
             * currently e.g .mp2 extension is allowed to user to browse as it is indexed (LIBMTP_FILETYPE_IS_AUDIO)
             * but cannot be played as the file extension is not supported - BUG!
             * Revisit LIBMTP_FILETYPE_IS_AUDIO,LIBMTP_FILETYPE_IS_VIDEO to align with Mediaplayer configuration
             */
            if ((false == FolderFilterEntry((const char*)MTPFile.filename)) && \
                    ((LIBMTP_FILETYPE_FOLDER == MTPFile.filetype) || \
                        ((true == LIBMTP_FILETYPE_IS_AUDIO( MTPFile.filetype)) && ( MTPFile.filesize < (LocalSPM::GetDataProvider().MaximumMTPFileSizeInMB() * 1024 * 1024))) || \
                        ((LocalSPM::GetDataProvider().MTPVideoSupport()) && (true == LIBMTP_FILETYPE_IS_VIDEO( MTPFile.filetype)) && ( MTPFile.filesize < (LocalSPM::GetDataProvider().MaximumMTPVideoFileSizeInMB() * 1024 * 1024))))) //lint !e574
            {
                tPath fullPath;
                int slashCount = 0;
                if((int32_t)FolderId == MTP_ROOT_FOLDER_ID)  //root folder
                {
                    snprintf(parentpath, sizeof (parentpath),"%s/", MTPCache_GetStorageName(mountPoint,storageId));
                }

                else
                {
                    if(MTPCache_GetFolderCount(deviceId) > 0 )
                        snprintf(parentpath, sizeof (parentpath),"%s/", MTPCache_getFolderPath(deviceId,FolderId));
                }
                index++;
                if(LIBMTP_FILETYPE_FOLDER ==  MTPFile.filetype)
                {
                    // frame the full path
                    snprintf(fullPath, sizeof (fullPath),"%s%s",parentpath,  MTPFile.filename);
                    slashCount = FastUTF8::Count((unsigned char *)fullPath, (unsigned char *)"/");//lint !e1773
                    if (slashCount <= LocalSPM::GetDataProvider().DBMTPMaxDepthForScan())
                    {
                        // Store path in the cache; required for folderview
                        MTPCache_StorePath(fullPath,  MTPFile.item_id,deviceId);
                        MTPCache_StoreFolderID(deviceId,  MTPFile.item_id, fullPath,storageId);
                    }
                }

                if ((int32_t)FolderId == MTP_ROOT_FOLDER_ID)
                {
                    MTPCache_WriteBrowseEntry(storageId, index, MTPFile,deviceId);
                    ETG_TRACE_USR4(("MTPControl::DoReadFilesFromDeviceThread:Added item for Storage entry :%d", storageId));
                }
                else
                {
                    // write file info to cache
                    MTPCache_WriteBrowseEntry(FolderId, index, MTPFile,deviceId);
                    ETG_TRACE_USR4(("MTPControl::DoReadFilesFromDeviceThread:Added item for folder entry :%d", FolderId));
                }
                MTPCache_setReadIndex(deviceId, FolderId, index);
                MtpGetMetadata(deviceId,mountPoint);
            }
            else
            {
                SendMetadata(MDS_FILE_SKIP, NULL);
            }
        }
        else
        {
            if (-1 == readindex){
                ETG_TRACE_USR4(("MTPControl::DoReadFilesFromDeviceThread:numOfValidFiles :%d",index));
                MTPCache_setItemCountInFolder(deviceId, FolderId, index);
                index = 0 ;
                MTPCache_setReadIndex(deviceId, FolderId, index);
                MtpGetMetadata(deviceId,mountPoint);
            }
            else if (-2 == readindex)
            {
                // If folder read continuously fails, stop indexing
                SendMetadata(MDS_FINISHED, NULL);
            }
            else
            {
                ETG_TRACE_USR4(("MTPControl::Invalid state . Skip to next file"));
                SendMetadata(MDS_FILE_SKIP, NULL);
            }
        }
    }
    else {
        ETG_TRACE_ERR(("Error while fetching device from device table. Finishing indexing."));
        SendMetadata(MDS_FINISHED, NULL);
    }
}


tResult MTPControl::MtpGetMetadata(const tDeviceID deviceID,const tMountPoint mountPoint )
{
    ENTRY
    VARTRACE(deviceID);

    int readindex = 0;
    tMetadataStatus metadataStatus = MDS_FILE_SKIP;
    tMediaObjectPtr mediaObjectPtr = NULL; //in case of error we can send NULL this is ok for Indexer

    LIBMTP_mtpdevice_t     *pDevice = NULL;
    pDevice = devTblFind(IN mountPoint);

    if(pDevice != NULL)
    {
        int folderID = MTPCache_getNextParentFolderID(deviceID);
        // If folder is empty
        readindex = MTPCache_getReadIndex(deviceID,folderID);
        if (0 != readindex)
        {
            const tMTPFileElement *fileElement;
            mReadStatus = FOLDER_READ_SUBFOLDER_STARTED;

            if (folderID == MTP_ROOT_FOLDER_ID)
            {
                unsigned int storageId = MTPCache_getParentFolderStorageID(deviceID);
                fileElement = MTPCache_ReadBrowseEntry(storageId, readindex,deviceID);
            }
            else
            {
                fileElement = MTPCache_ReadBrowseEntry(folderID, readindex,deviceID);
            }

            if((fileElement != NULL) && (m_pMTPLibWrapper != NULL))
            {
                VARTRACE(readindex);
                VARTRACE(fileElement->item_id);
                VARTRACE(fileElement->parent_id);
                VARTRACE(fileElement->filename);
                VARTRACE(fileElement->filetype);

                tURL completeFileName;
                if((FT_AUDIO == fileElement->filetype) || (FT_VIDEO == fileElement->filetype))
                {
                    LIBMTP_track_t* pTrack = NULL;

                    pTrack = m_pMTPLibWrapper->wLIBMTP_Get_Trackmetadata(pDevice, fileElement->item_id);

                    if(NULL == pTrack)
                    {
                        ETG_TRACE_USR4(("MTPControl::MtpGetMetadata: Last track retrieved"));
                        metadataStatus = MDS_FINISHED;
                    }
                    else
                    {
                        mediaObjectPtr = new tMediaObject; //Attention: Has to be deleted by Indexer::CheckMetadata;
                        snprintf(completeFileName, sizeof (completeFileName),"%s/%s",MTPCache_getFolderPath(deviceID,folderID),fileElement->filename);
                        if(mediaObjectPtr != NULL)
                        {
                            InitMediaObject(OUT *mediaObjectPtr);
                            fillMediaObject(OUT mediaObjectPtr, IN pTrack, IN mountPoint,IN deviceID,IN completeFileName);
                            metadataStatus = MDS_SUCCESS;
                        }
                        dbgShowTrack(pTrack);
                        if(m_eTypeOfWrapper == eMTPWrapper_realLib) //not with stubbed version of libmtp during test
                        {
                            m_pMTPLibWrapper->wLIBMTP_destroy_track_t(pTrack);
                        }
                    }
                }
                else
                {
                    // File type is not an audio file.it is folder, video or unknown
                    metadataStatus = MDS_FILE_SKIP;
                    ETG_TRACE_USR4(("MTPControl::MtpGetMetadata: its a folder"));
                }
            }
            else
                  metadataStatus = MDS_FILE_ERROR;
        }
        else
        {
            ETG_TRACE_USR3(("MTPControl::MtpGetMetadata:readindex: folder read complete:%d", readindex));
            readindex = 0;
            mReadStatus = FOLDER_READ_SUBFOLDER_COMPLETE;
            MTPCache_DeleteParentFolderID(deviceID,folderID);
            // If all the folders are read
            if(0 == MTPCache_GetFolderCount(deviceID))
            {
                // all the storages are read
                if(0 == MTPCache_GetReadStorageCount(mountPoint))
                {
                    mReadStatus = FOLDER_READ_ALL_COMPLETE;
                    ETG_TRACE_USR3(("MTPControl::MtpGetMetadata: all folders are read"));
                    metadataStatus = MDS_FINISHED;
                }
                else
                    mReadStatus = FOLDER_READ_NEXT_STORAGE;
            }
        }
    }
    else
    {
        metadataStatus = MDS_FILE_ERROR;
    }
    SendMetadata(metadataStatus, mediaObjectPtr);
    return MP_NO_ERROR;
}


tResult MTPControl::ReadFolder(uint32_t storageID, uint32_t ReqFolderID,const tMountPoint mountPoint,tAvailable isFolderview) // finished: 100%
{
    ENTRY;

    LIBMTP_mtpdevice_t     *pDevice = devTblFind(IN mountPoint);

    if(pDevice != NULL)
    {
        const size_t size = sizeof(tAllParameters);
        char *parameterStringNew = new char[size]; //Cleared in DoReadFilesFromDeviceThread
        SMF::Marshal(parameterStringNew,size-1,tMountPoint_format tIndex_format tIndex_format tAvailable_format ,mountPoint,storageID,ReqFolderID,isFolderview);
        LocalSPM::GetThreadFactory().Do(this, THREAD_READFILES, IN parameterStringNew);
    }
    else
    {
        SendMetadata(MDS_FILE_ERROR, NULL);
    }
    return MP_NO_ERROR;
}


// Triggered by IsNextMetadataAvailable
// This function will perform the following tasks
// - Read the contents of the folder
//   -- if it contains subfolder call PUT_METADATA with MDS_FILE_SKIP to skip folder
//   -- if it containd files, get the track information and send to indexer
tResult MTPControl::RetrieveMetadataFromDevice(const tMountPoint mountPoint, const tReadPosition readPosition, const tDeviceID deviceID) // finished: 44%
{
    ENTRY;

    ETG_TRACE_USR3(("MTPControl::RetrieveMetadataFromDevice deviceID: %u, mountPoint:%40s, readPosition:%s", deviceID, mountPoint, readPosition));
    tMTPStorageElement *storageElement = NULL;
    const LIBMTP_mtpdevice_t  *pDevice = NULL;

    RegisterReleaseEvent(PUT_METADATA);

    pDevice = devTblFind(IN mountPoint);
    if((NULL == pDevice) || (NULL == pDevice->storage))
    {
        SendMetadata(MDS_ERROR_RESTART, NULL);
    }
    else
    {
        if ((0 == MTPCache_GetFolderCount(deviceID)) && ((mReadStatus == FOLDER_READ_NOT_STARTED) || (mReadStatus == FOLDER_READ_NEXT_STORAGE)))
        {
            storageElement = MTPCache_GetCurrentStorage(mountPoint);
            if(NULL != storageElement)
            {
                ETG_TRACE_USR4(("MTPControl::RetrieveMetadataFromDevice Cache is empty"));
                MTPCache_StoreFolderID(deviceID, MTP_ROOT_FOLDER_ID, storageElement->name,storageElement->item_id);
                mReadStatus = FOLDER_READ_PARTIAL;
                MTPCache_SetCurrentStorage(mountPoint,storageElement->item_id);
                SendMetadata(MDS_FILE_SKIP, NULL);
                return MP_NO_ERROR;
            }
        }

        if((mReadStatus == FOLDER_READ_PARTIAL)||(mReadStatus == FOLDER_READ_SUBFOLDER_COMPLETE) || (mReadStatus == FOLDER_READ_SUBFOLDER_STARTED))
        {
            ReadFolder(MTPCache_getParentFolderStorageID(deviceID), MTPCache_getNextParentFolderID(deviceID),mountPoint,false);
        }
    }
    return MP_NO_ERROR;
}

//not triggered since NextMetadata returns false hence RetrieveMetadataFromDevice is called
tResult MTPControl::SendPutMetadata(const tMountPoint mountPoint, const tReadPosition readPosition, const tDeviceID deviceID) // finished: 100%
{
    ENTRY;
    ETG_TRACE_USR3(("MTPControl::SendPutMetadata deviceID: %u, mountPoint:%40s, readPosition:%s", deviceID, mountPoint, readPosition));

    tResult ret = MP_NO_ERROR;

    /* Send PUT_METADATA message to own SM */
    tMetadataStatus metadataStatus = MDS_SUCCESS;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = ParameterPUT_METADATA(OUT parameterString, IN size, IN metadataStatus, IN NULL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string"));
    }
    else
    {
        ret = SendEvent(IN PUT_METADATA, IN parameterString);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF"));
        }
    }
    return MP_NO_ERROR;
}


tResult MTPControl::SendMetadata(const tMetadataStatus metadataStatus, const tMediaObjectPtr mediaObjectPtr) // finished: 100%
{
    ENTRY_INTERNAL;

    tAllParameters parameterString;
    tResult ret = MP_NO_ERROR;
    size_t size = sizeof(parameterString);

    ret = ParameterPUT_METADATA(OUT parameterString, IN size, IN metadataStatus, IN mediaObjectPtr);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string"));
        if(NULL != mediaObjectPtr)
        {
            delete mediaObjectPtr;
        }
    }
    else
    {
        //---------------------------------------------------------------------------------
        // Send PUT_METADATA message to own SM to trigger AnswerMetadata to be triggered
        //---------------------------------------------------------------------------------
        ret = SendEvent(IN PUT_METADATA, IN parameterString);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF"));
        }
    }
    return MP_NO_ERROR;
}


//triggered by RetrieveMetadataFromDevice
tResult MTPControl::AnswerMetadata(const tMetadataStatus metadataStatus, const tMediaObjectPtr mediaObjectPtr) // finished: 40%
{
    ENTRY;
    ETG_TRACE_USR3(("MTPControl::AnswerMetadata metadataStatus:%u", metadataStatus));

    tResult ret = MP_NO_ERROR;

    /* Send METADATA_ANSWER message to IndexerSM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetIndexer().ParameterMETADATA_ANSWER(OUT parameterString,
            IN size,
            IN mediaObjectPtr,
            IN metadataStatus);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string"));
        parameterString[0] = '\0';
    }

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF"));
    }
    return MP_NO_ERROR;
}


tResult MTPControl::RetrieveMetadataFromCache(tMetadata &metadata) // finished: 100%
{
    /* Obsolete: DeviceControl is sending a media object instead of a metatdata string so an assembly is not necessary */
    ENTRY;
    (void)metadata;
    return MP_NO_ERROR;
}

tResult MTPControl::RemoveDeviceConnection(const tMountPoint mountPoint, const tDeviceID deviceID) // finished: 100%
{
    ENTRY;
    ETG_TRACE_USR3(("MTPControl::RemoveDeviceConnection deviceID:%u, mountPoint:%s", deviceID, mountPoint));

    LIBMTP_mtpdevice_t     *pDevice = devTblFind(IN mountPoint);
    if(pDevice != NULL)
    {
        tResult ret = MP_NO_ERROR;
        m_Mutex.lock();
        m_pMTPLibWrapper->wLIBMTP_Release_Device(pDevice);
        ret = devTbl_Del(IN mountPoint);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("MTPControl::RemoveDeviceConnection: Error in removing device from device table"));
        }
        pDevice = NULL;
        m_Mutex.unlock();
    }
    else
    {
        ETG_TRACE_USR1(("MTPControl::RemoveDeviceConnection: device not found in device table"));
    }
    m_DeviceRemoved = true;
    return MP_NO_ERROR;
}

//---------------------------------
//DONE: MAPPED to LIBMTP-FUNCTIONS
// ->
//---------------------------------
tResult MTPControl::GetAlbumArt(const tAlbumArt albumArtString) // finished: 50%
{
    ENTRY;
    ETG_TRACE_USR3(("MTPControl::GetAlbumArt() -> %s",albumArtString));

    char *pAlbumArtString = new char[sizeof(tAlbumArt)];
    strncpy_r(pAlbumArtString,albumArtString,sizeof(tAlbumArt));

    /*Create a worker thread to extract the album art */
    LocalSPM::GetThreadFactory().Do(IN this, THREAD_ALBUMART, (void*)pAlbumArtString, this);

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}


tResult MTPControl::HandleGetAlbumArtAnswer(const tAlbumArtObjectPtr ptrToAlbumArtObject) // finished: 100%
{
    ENTRY;
    ETG_TRACE_USR3(("MTPControl::HandleGetAlbumArtAnswer()"));

    tResult ret = MP_NO_ERROR;

    /*Send the albumart data as answer to request GetAlbumArt (Note : requested from DataProvider)*/
    tAllParameters parameterString;
    SMF::Marshal(IN parameterString, sizeof(parameterString)-1, "p",IN ptrToAlbumArtObject);

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
        if (ptrToAlbumArtObject)
        {
            if (ptrToAlbumArtObject->imageData)
            {
                free(ptrToAlbumArtObject->imageData);
            }
            delete ptrToAlbumArtObject;
            ETG_TRACE_USR3(("AlbumArt buffer cleared"));
        }
    }

    return MP_NO_ERROR;
}

tResult MTPControl::AlbumArtAnswerNotConsumed(const tAlbumArtObjectPtr ptrToAlbumArtObject)
{
    ENTRY;

    if (ptrToAlbumArtObject)
    {
        if (ptrToAlbumArtObject->imageData)
        {
            free(ptrToAlbumArtObject->imageData);
        }
        delete ptrToAlbumArtObject;
        ETG_TRACE_USR3(("AlbumArt buffer cleared"));
    }

    return MP_NO_ERROR;
}

//----------------------------------private/protected functions------------------------------------------

tResult MTPControl::SendAlbumArtAnswer(const tAlbumArtObjectPtr ptrToAlbumArtObject)
{
    ENTRY_INTERNAL;
    ETG_TRACE_USR3(("MTPControl::SendAlbumArtAnswer()"));

    tResult ret = MP_NO_ERROR;

    /* Send GET_ALBUM_ART_ANSWER message to own SM */
    tAllParameters parameterString = {0};
    SMF::Marshal(IN parameterString, sizeof(parameterString)-1, "p", IN ptrToAlbumArtObject);

    ret = SendEvent(GET_ALBUM_ART_ANSWER, IN parameterString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        if (ptrToAlbumArtObject)
        {
            if (ptrToAlbumArtObject->imageData)
            {
                free(ptrToAlbumArtObject->imageData);
            }
            delete ptrToAlbumArtObject;
            ETG_TRACE_USR3(("AlbumArt buffer cleared"));
        }
    }
    return ret;
}

void MTPControl::DoGetAlbumArtThread(const tAlbumArt albumArtString)
{
    ENTRY_INTERNAL;

    ETG_TRACE_USR3(("MTPControl::DoGetAlbumArtThread (%s) \n",albumArtString));
    tAlbumArtObjectPtr albumArtObjectPtr = 0;
    Info * info;

    char     target[1024];
    tURL fullName;
    unsigned char *pureFile;
    unsigned char *extension = NULL;

    strncpy_r(OUT fullName, IN albumArtString, IN sizeof(fullName));
    FastUTF8::Split(OUT pureFile, INOUT (unsigned char *)fullName);
    if(pureFile)
    {
        FastUTF8::SplitExtension(OUT extension, INOUT (unsigned char *)pureFile);

    }

    if (checkRealDevicesUsed())
    {
        if(LocalSPM::GetDataProvider().UseMediaEngine())
        {
            //snprintf(target, sizeof (target),"%s/%s",LOCAL_MTPFILE_PATH_TARGET, pureFile);
            string url = albumArtString;
            size_t pos = url.find_last_of('/');
            url = url.substr(pos + 1);
            snprintf(target, sizeof (target),"%s/%s",LOCAL_MTPFILE_PATH_TARGET, url.c_str());
        }
        else
        {
            snprintf(target, sizeof (target),"%s/%s.%s",LOCAL_MTPFILE_PATH_TARGET,LOCAL_MTPFILE,extension);
        }
    }
    else
    {
        snprintf(target, sizeof (target),"%s", albumArtString);
    }

    if(LocalSPM::GetDataProvider().FirstAvailableCoverArtSupport())
    {
        info = Info::create_tag_info_for_cover_art(target,true);
    }
    else
    {
        info = Info::create_tag_info_for_cover_art(target);
    }

    if(info)
    {
        int   imageSize = 0;
        char* imageData = NULL;
        ImageType imageType   = IMAGE_TYPE_UNKNOWN;

        if(info->read())
        {
            if(!info->get_image(OUT imageData, OUT imageSize, OUT imageType))
            {
                ETG_TRACE_ERR(("MTPControl::DoGetAlbumArtThread error getting image for ->(%s) \n",target));
            }
            else if(imageSize <= 0)
            {
                ETG_TRACE_ERR(("MTPControl::DoGetAlbumArtThread error albumart size is 0 ->(%s) ",target));
            }
            else if(imageSize > (LocalSPM::GetDataProvider().MaximumAlbumArtSizeInMB() * 1024 * 1024))
            {
                ETG_TRACE_ERR(("MTPControl::DoGetAlbumArtThread error albumart size is above the configured limit ->(%s) ",target));
            }
            else
            {
                ETG_TRACE_USR3(("MTPControl::DoGetAlbumArtThread Inside else"));
                albumArtObjectPtr = new tAlbumArtObject;    //Has to be deleted by the user i.e DataProvider

                switch(imageType)
                {
                    case IMAGE_TYPE_PNG:
                        albumArtObjectPtr->mimeType = MMT_PNG;
                        break;
                    case IMAGE_TYPE_JPEG:
                        albumArtObjectPtr->mimeType = MMT_JPG;
                        break;
                    case IMAGE_TYPE_GIF:
                        albumArtObjectPtr->mimeType = MMT_GIF;
                        break;
                    case IMAGE_TYPE_BMP:
                        albumArtObjectPtr->mimeType = MMT_BMP;
                        break;
                    default:
                        ETG_TRACE_ERR(("taginfo reading albumart returns mimetype as IMAGE_TYPE_UNKNOWN for -> (%s)\n",target));
                        albumArtObjectPtr->mimeType = MMT_PNG;
                        break;
                }

                albumArtObjectPtr->imageSize = imageSize;
                albumArtObjectPtr->imageData = (tImageData)malloc(imageSize);
                if(albumArtObjectPtr->imageData) memcpy ( albumArtObjectPtr->imageData, imageData, albumArtObjectPtr->imageSize ) ;
                ETG_TRACE_USR3(("MTPControl::DoGetAlbumArtThread ImageSize = %d", albumArtObjectPtr->imageSize));
                albumArtObjectPtr->sizeX = 256;//Not available via taglib/MediaInfo/TagInfo ??;
                albumArtObjectPtr->sizeY = 256;
            }
        }
        else
        {
            ETG_TRACE_ERR(("taginfo error reading tag for ->(%s) \n",target));
        }
        delete info;

        // free the allocated image data (is not part of info object)
        if (imageData)
        {
            delete [] imageData;
            //free(imageData);
        }
    }

    if((LocalSPM::GetDataProvider().AlbumArtFromFromSeparateFile())
       &&
       (!albumArtObjectPtr))
    {
        ETG_TRACE_USR1(("Either album art not found for file (%s) or album art size might exceeded Maximum size of 4MB. Look for image file in the folder",albumArtString));
        //GetAlbumArtFromSeparateFile(OUT albumArtObjectPtr, IN albumArtString);
    }

    if(albumArtObjectPtr)
    {
        strncpy_r(OUT albumArtObjectPtr->albumArtString, IN albumArtString, IN sizeof(albumArtObjectPtr->albumArtString));
        ETG_TRACE_USR3(("MTPControl::DoGetAlbumArtThread Extraction successful"));
    }
    delete[] albumArtString;

    SendAlbumArtAnswer(albumArtObjectPtr);
}

//Input:
    //         deviceName    : SanDisk Sansa Clip+
    //         deviceVersion : aa8c
    //         serialNumber  : 051DF60B6527B8A80000000000000000#4
    //output:  m_cMountPoint = m_cDeviceName+"/"+m_cDeviceVersion+"/"+m_cSerialID+"/"
    //e.g.  : "SanDisk Sansa Clip+/aa8c/051DF60B6527B8A80000000000000000#4/"
tResult  MTPControl::encodeMountPoint(INOUT tDeviceInfo &deviceInfo)
{
    ENTRY_INTERNAL;
    tResult ret = MP_NO_ERROR;

    //variables
    tUInt uLen, uLenMax;
    char  cSeperator[2];
    char *cSeperatedElement[ELEMS_IN_MOUNTPOINT];

    deviceInfo.mountPoint[0] = EOF_STRING; //basis to use strcat
    cSeperator[0] = SEPERATOR;
    cSeperator[1] = EOF_STRING;
    cSeperatedElement[0] = deviceInfo.deviceName;
    cSeperatedElement[1] = deviceInfo.deviceVersion;
    cSeperatedElement[2] = deviceInfo.serialNumber;

    uLen = 0;
    uLenMax = sizeof(deviceInfo.mountPoint) -1 /* -1 to keep space for EOF_STRING*/;
    for(tUInt i = 0; i<ELEMS_IN_MOUNTPOINT; i++)
    {
        uLen = uLen + strlen_r(cSeperatedElement[i]);
        if(uLen <= uLenMax)
        {
            strcat(deviceInfo.mountPoint,cSeperatedElement[i]);
            strcat(deviceInfo.mountPoint,cSeperator);
        }
        else
        {
            ETG_TRACE_ERR(("encodeMountPoint: Name to long"));
            ret = MP_ERR_MTP_ENCODEMOUNT;
        }
    }

    ETG_TRACE_USR1(("encodeMountPoint: %s",deviceInfo.mountPoint));

   return ret;

}


//Example: seperate this:
//mountPoint = cDeviceName+"/"+cDeviceVersion+"/"+cSerialID+"/"
//e.g.: SanDisk Sansa Clip+/aa8c/051DF60B6527B8A80000000000000000#4/   //sperator at the end of each entry
// result: deviceName    : SanDisk Sansa Clip+
//         deviceVersion : aa8c
//         serialNumber  : 051DF60B6527B8A80000000000000000#4
tResult  MTPControl::decodeMountPoint(IN const tMountPoint mountPoint, OUT tDeviceInfo &deviceInfo)
{
    ENTRY_INTERNAL;
    tResult ret = MP_NO_ERROR;

    //variables
    tUInt i,k;
    tUInt uiIndex;

    char  c;
    char *cSeperatedElement[ELEMS_IN_MOUNTPOINT];

    //initialize
    cSeperatedElement[0] = deviceInfo.deviceName;
    cSeperatedElement[1] = deviceInfo.deviceVersion;
    cSeperatedElement[2] = deviceInfo.serialNumber;

    //seperate
    i       = 0;
    uiIndex = 0;
    tUInt lenOfMp = strlen_r(mountPoint); //without '\0'
    for(k = 0; k<lenOfMp; k++)     //iterate from index 0 to last letter before '\0' i.e. end of string
    {
        c = mountPoint[k];
        if(c == SEPERATOR)
        {
            cSeperatedElement[i][uiIndex] = EOF_STRING; //add eond of srting instead of seperator
            uiIndex = 0;                                //reset index for the next element
            i++;                                        //goto next element
        }
        else
        {
            if(uiIndex < (sizeof(tDeviceName)-1))
            {
                cSeperatedElement[i][uiIndex++] = mountPoint[k];
            }
        }
    }

    //error check
    if(ELEMS_IN_MOUNTPOINT != i)
    {
        ret = MP_ERR_MTP_DECODEMOUNT;
        ETG_TRACE_ERR(("decodeMountPoint:ELEMS_IN_MOUNTPOINT:%d i=%d",(int)ELEMS_IN_MOUNTPOINT,i));
    }

    return ret;
}




LIBMTP_mtpdevice_t* MTPControl::devTblFind(IN const tDeviceID deviceID,OUT int &index)
{
    ENTRY_INTERNAL;
    tUInt               uFound = 0;
    LIBMTP_mtpdevice_t *pDevice = NULL;

    vector<DevTable>::iterator iterDevTable = m_devTable.begin();

    index = 0;

    for (; iterDevTable != m_devTable.end(); ++iterDevTable)
    {
        if(deviceID == iterDevTable->deviceID)
        {
            uFound++;
            pDevice = iterDevTable->pDevice;
            break;
        }
        index++;
    }
    //care for result
    switch(uFound)
    {
        case 0:
            ETG_TRACE_USR4(("devTblFind:Device not found!"));
            index = -1;
            pDevice = NULL;
            break;
        case 1:
            ETG_TRACE_USR4(("devTblFind:device found"));
            break;
        default:
            ETG_TRACE_USR4(("[ERROR]: devTblFind:device found more than once!"));
            index = -1;
            pDevice = NULL;
            break;
    }

    return pDevice;
}


LIBMTP_mtpdevice_t* MTPControl::devTblFind(IN const tMountPoint mountPoint,OUT int &index)
{
    ENTRY_INTERNAL;

    tUInt               uFound  = 0;
    LIBMTP_mtpdevice_t *pDevice = NULL;

    vector<DevTable>::iterator iterDevTable = m_devTable.begin();
    index = 0;

    for (; iterDevTable != m_devTable.end(); ++iterDevTable)
        {
        if(0 == strcmp(iterDevTable->mountPoint, mountPoint))
        {
            uFound++;
            pDevice = iterDevTable->pDevice;
            break;
        }
        index++;
    }
    //care for result
    switch(uFound)
    {
        case 0:
            ETG_TRACE_USR4(("devTblFind:Device not found!"));   //@same part like in ftc. below ease it of shift in an extra function
            index = -1;
            pDevice = NULL;
            break;
        case 1:
            ETG_TRACE_USR4(("devTblFind:device found"));
            break;
        default:
            ETG_TRACE_USR4(("[ERROR]: devTblFind:device found more than once!"));
            index = -1;
            pDevice = NULL;
            break;
    }

    return pDevice;
}


tResult   MTPControl::devTbl_Add(IN const tMountPoint mountPoint,IN LIBMTP_mtpdevice_t  *pDevice, IN tDeviceID deviceID )
{
    ENTRY_INTERNAL;
    tResult ret = MP_ERR_MTP_GENERAL_ERROR;
    LIBMTP_mtpdevice_t  *pDeviceFound = NULL;
    DevTable lDevTable;

    if((mountPoint[0] != '\0') && (pDevice != NULL))
    {
        //check for double entry
        //if no add at the End of the table
        pDeviceFound = devTblFind(mountPoint);
        if(NULL == pDeviceFound)
        {
            lDevTable.iNextElemToScan = 0;
            lDevTable.pDevice         = pDevice;
            lDevTable.deviceID        = deviceID;
            strncpy_r(lDevTable.mountPoint,mountPoint,sizeof(tMountPoint));//CID 17331
            m_devTable.push_back(lDevTable);
            ETG_TRACE_USR4(("devTblFind:Device added at %d",(m_devTable.size()-1)));
            ret = MP_NO_ERROR;
        }
        else
        {
            ETG_TRACE_ERR(("[ERROR] devTbl_Add: could not add - device already in table"));
        }
    }
    else
    {
        ETG_TRACE_ERR(("[ERROR] devTbl_Add: mountPoint or device is NULL"));
    }

    return ret;
}

tResult   MTPControl::devTbl_Del(IN const tMountPoint mountPoint)
{
    ENTRY_INTERNAL;

    tResult ret = MP_NO_ERROR;
    int indexDelete = -1;
    LIBMTP_mtpdevice_t* pDevice;

    if((mountPoint[0] == '\0'))
    {
        ETG_TRACE_ERR(("[ERROR] devTbl_Del: MP_ERR_MTP_WRONGINPARAM"));
        ret = MP_ERR_MTP_WRONGINPARAM;
    }


    //-------------------------------------------
    //find device matching mountPoint
    //-------------------------------------------
    if((MP_NO_ERROR == ret))
    {
        pDevice = devTblFind(mountPoint, indexDelete);
        if(pDevice == NULL)
        {
            ETG_TRACE_ERR(("[ERROR] devTbl_Del: MP_ERR_MTP_NODEVMATCH (could not delete - device not in table)"));
            ret = MP_ERR_MTP_NODEVMATCH;
        }
    }

    //-------------------------------------------------------------
    //delete element and shift last element to new empty position
    //-------------------------------------------------------------
    if((MP_NO_ERROR == ret))
    {
        ret = MP_ERR_MTP_NODEVMATCH;

        vector<DevTable>::iterator iterDevTable = m_devTable.begin();

        for (; iterDevTable != m_devTable.end(); )
            {
            if(0 == strcmp(iterDevTable->mountPoint, mountPoint))
            {
                m_devTable.erase(iterDevTable);
                ETG_TRACE_USR4(("devTblFind:Device removed"));
                ret = MP_NO_ERROR;
                break;
            }
            iterDevTable ++;
        }
    }
    return ret;

}


tResult   MTPControl::devTbl_Del(IN const tMountPoint mountPoint,IN const tDeviceID deviceID)
{
    ENTRY_INTERNAL;

    tResult ret = MP_NO_ERROR;
    int indexDelete = 0;
    LIBMTP_mtpdevice_t* pDevice;

    if((mountPoint[0] == '\0'))
    {
        ETG_TRACE_ERR(("[ERROR] devTbl_Del: MP_ERR_MTP_WRONGINPARAM"));
        ret = MP_ERR_MTP_WRONGINPARAM;
    }

    //-------------------------------------------
    //find device matching mountPoint
    //-------------------------------------------
    if((MP_NO_ERROR == ret))
    {
        pDevice = devTblFind(mountPoint, indexDelete);
        if(pDevice == NULL)
        {
            ETG_TRACE_ERR(("[ERROR] devTbl_Del: MP_ERR_MTP_NODEVMATCH (could not delete - device not in table)"));
            ret = MP_ERR_MTP_NODEVMATCH;
        }
    }
    //extra check if deviceID matches too
    if((MP_NO_ERROR == ret))
    {
        if(m_devTable.at(indexDelete).deviceID != deviceID)
        {
            ETG_TRACE_ERR(("[ERROR] devTbl_Del: MP_ERR_MTP_NODEVMATCH (could not delete - device not in table)"));
            ret = MP_ERR_MTP_NODEVMATCH;
        }
    }

    //-------------------------------------------------------------
    //delete element and shift last element to new empty position
    //-------------------------------------------------------------
    if((MP_NO_ERROR == ret))
    {
        ret = MP_ERR_MTP_NODEVMATCH;

        vector<DevTable>::iterator iterDevTable = m_devTable.begin();

        for (; iterDevTable != m_devTable.end(); )
            {
            if(0 == strcmp(iterDevTable->mountPoint, mountPoint))
            {
                m_devTable.erase(iterDevTable);
                ETG_TRACE_USR4(("devTblFind:Device removed"));
                ret = MP_NO_ERROR;
                break;
            }
            iterDevTable ++;
        }
    }

    return ret;
}

tResult  MTPControl::devTblDeleteAll(void)
{
    ENTRY_INTERNAL;

    if(m_devTable.size() > 0)
        m_devTable.clear();

    return MP_NO_ERROR;
}

tResult MTPControl::fillMediaObject(OUT tMediaObjectPtr mediaObjectPtr, IN LIBMTP_track_t *pTrack, IN const tMountPoint mountPoint,IN tDeviceID deviceID,IN tURL fileName)
{
    ENTRY_INTERNAL;
    tResult ret =  MP_NO_ERROR;
    FastUTF8::tString pureFileName = NULL;

    mediaObjectPtr->deviceID      = deviceID;
    mediaObjectPtr->deviceType    = DTY_MTP;
    mediaObjectPtr->fileFormat = FFT_UNKNOWN;

    tDeviceInfo deviceInfo;
    decodeMountPoint(mountPoint, OUT deviceInfo);

    if(NULL != pTrack)
    {
        char cText[120];
        snprintf(cText,sizeof(cText),"fillMediaObject: pTrack->item_id:%d,pTrack->title:%20s,pTrack->fileName:%20s",pTrack->item_id,pTrack->title,pTrack->filename);
        bool isValidFileType = false;

        mediaObjectPtr->MetadataField1[0] = '\0';
        mediaObjectPtr->MetadataField2[0] = '\0';
        mediaObjectPtr->MetadataField3[0] = '\0';
        mediaObjectPtr->MetadataField4[0] = '\0';
        mediaObjectPtr->title[0]          = '\0';
        mediaObjectPtr->albumArtString[0] = '\0';

        if(LIBMTP_FILETYPE_IS_AUDIO(pTrack->filetype))
        {
            ETG_TRACE_USR4(("fillMediaObject [audio track]: %s",cText));

            mediaObjectPtr->mediaType     = MTY_MUSIC_FILE;
            mediaObjectPtr->fileType      = FT_AUDIO;
            mediaObjectPtr->catType       = CTY_SONG;

            if((pTrack->filesize) > (LocalSPM::GetDataProvider().MaximumMTPFileSizeInMB() * 1024 * 1024)) //lint !e574
                mediaObjectPtr->notPlayable = FNP_NOT_PLAYABLE ;

            if(NULL != fileName)
            {
                strncpy_r(mediaObjectPtr->fileName,fileName, sizeof(mediaObjectPtr->fileName));
                FastUTF8::Split(OUT pureFileName, INOUT (FastUTF8::tString)fileName);
                strncpy_r(mediaObjectPtr->path,fileName,sizeof(mediaObjectPtr->path));
            }
            else
                strncpy_r(mediaObjectPtr->fileName,pTrack->filename, sizeof(mediaObjectPtr->fileName));

            if(pTrack->genre    != NULL){strncpy_r(mediaObjectPtr->MetadataField1, pTrack->genre,    sizeof(mediaObjectPtr->MetadataField1));}
            if(pTrack->artist   != NULL){strncpy_r(mediaObjectPtr->MetadataField2, pTrack->artist,   sizeof(mediaObjectPtr->MetadataField2));}
            if(pTrack->composer != NULL){strncpy_r(mediaObjectPtr->MetadataField3, pTrack->composer, sizeof(mediaObjectPtr->MetadataField3));}
            if(pTrack->album    != NULL){strncpy_r(mediaObjectPtr->MetadataField4, pTrack->album,    sizeof(mediaObjectPtr->MetadataField4));}
            if(pTrack->title    != NULL){strncpy_r(mediaObjectPtr->title,          pTrack->title,    sizeof(mediaObjectPtr->title));}
            else
            {
                ETG_TRACE_USR3(("fillMediaObject: No title available, use filename instead"));
                if (pureFileName)
                {
                    /* Remove the extension */
                    if (LocalSPM::GetDataProvider().DBRemoveExtensionFromFilename())
                    {
                        unsigned char *extension;
                        FastUTF8::SplitExtension(OUT extension, INOUT pureFileName);
                    }
                    strncpy_r(OUT mediaObjectPtr->title, IN (const char*)pureFileName, IN sizeof(mediaObjectPtr->title));
                }
            }
            strncpy_r(mediaObjectPtr->albumArtString, mediaObjectPtr->fileName,sizeof(mediaObjectPtr->albumArtString));
            isValidFileType = true;
        }
        else if((LocalSPM::GetDataProvider().MTPVideoSupport()) && (LIBMTP_FILETYPE_IS_VIDEO(pTrack->filetype)))
        {
            ETG_TRACE_USR4(("fillMediaObject [video track]: %s",cText));

            mediaObjectPtr->mediaType     = MTY_VIDEO;
            mediaObjectPtr->fileType      = FT_VIDEO;
            mediaObjectPtr->catType       = CTY_VIDEO;

            if((pTrack->filesize) > (LocalSPM::GetDataProvider().MaximumMTPVideoFileSizeInMB() * 1024 * 1024)) //lint !e574
                mediaObjectPtr->notPlayable = FNP_NOT_PLAYABLE ;

            if(NULL != fileName)
            {
                strncpy_r(mediaObjectPtr->fileName,fileName, sizeof(mediaObjectPtr->fileName));
                FastUTF8::Split(OUT pureFileName, INOUT (FastUTF8::tString)fileName);
                strncpy_r(mediaObjectPtr->path,fileName,sizeof(mediaObjectPtr->path));
            }
            else
                strncpy_r(mediaObjectPtr->fileName,pTrack->filename, sizeof(mediaObjectPtr->fileName));

            if(pTrack->title != NULL)
            {
                strncpy_r(mediaObjectPtr->MetadataField1, pTrack->title,    sizeof(mediaObjectPtr->MetadataField1));
                strncpy_r(mediaObjectPtr->title,          pTrack->title,    sizeof(mediaObjectPtr->title));
            }

            if(0 == strlen_r(mediaObjectPtr->MetadataField1))
            {
                ETG_TRACE_USR3(("fillMediaObject: No title available, use filename instead"));
                if (pureFileName)
                {
                    /* Remove the extension */
                    if (LocalSPM::GetDataProvider().DBRemoveExtensionFromFilename())
                    {
                        unsigned char *extension;
                        FastUTF8::SplitExtension(OUT extension, INOUT pureFileName);
                    }
                    strncpy_r(OUT mediaObjectPtr->title, IN (const char*)pureFileName, IN sizeof(mediaObjectPtr->title));
                    strncpy_r(OUT mediaObjectPtr->MetadataField1, IN (const char*)pureFileName, IN sizeof(mediaObjectPtr->MetadataField1));
                }
            }
           isValidFileType = true;
        }
        else
        {
            ETG_TRACE_ERR(("fillMediaObject: Not supported "));
        }

        if(isValidFileType)
        {
            mediaObjectPtr->deviceID      = deviceID;
            mediaObjectPtr->deviceType    = DTY_MTP;
            mediaObjectPtr->totalPlaytime = pTrack->duration;
            mediaObjectPtr->trackNumber   = pTrack->tracknumber;
            mediaObjectPtr->fileSize      = pTrack->filesize;//in bytes
            struct tm *timeinfo;
            timeinfo = localtime(&pTrack->modificationdate);
            strftime(mediaObjectPtr->dateTime, sizeof(mediaObjectPtr->dateTime), "%Y:%m:%d %H:%M:%S", timeinfo);

            strncpy_r(mediaObjectPtr->deviceVersion,deviceInfo.deviceVersion,sizeof(mediaObjectPtr->deviceVersion));
            strncpy_r(mediaObjectPtr->mountPoint, mountPoint,  sizeof(mediaObjectPtr->mountPoint));

            snprintf(mediaObjectPtr->UUID,sizeof(mediaObjectPtr->UUID),"%d",pTrack->item_id);
            isValidFileType = false;
        }
    }
    else
    {
        ETG_TRACE_USR4(("fillMediaObject:file type:folder"));
        mediaObjectPtr->mediaType     = MTY_UNKNOWN;
        mediaObjectPtr->fileType      = FT_FOLDER;
        mediaObjectPtr->catType       = CTY_DIR;

        strncpy_r(mediaObjectPtr->deviceVersion,deviceInfo.deviceVersion,sizeof(mediaObjectPtr->deviceVersion));
        strncpy_r(mediaObjectPtr->mountPoint, mountPoint,  sizeof(mediaObjectPtr->mountPoint));

        strncpy_r(mediaObjectPtr->fileName,fileName, sizeof(mediaObjectPtr->fileName));
        FastUTF8::Split(OUT pureFileName, INOUT (FastUTF8::tString)fileName);
        strncpy_r(mediaObjectPtr->path,fileName,sizeof(mediaObjectPtr->path));

        strncpy_r(OUT mediaObjectPtr->title, IN (const char*)pureFileName, IN sizeof(mediaObjectPtr->title));
        mediaObjectPtr->notPlayable = FNP_NOT_PLAYABLE ;
    }
    return ret;
}


void MTPControl::dbgShowTrack(LIBMTP_track_t *track)
{
    ENTRY_INTERNAL;

    ETG_TRACE_USR4(("-----------------Track info----------------------------------------------------" ));
    ETG_TRACE_USR4(("uint32_t item_id;           < Unique item ID                                          :%d ",track->item_id));
    ETG_TRACE_USR4(("uint32_t parent_id;         < ID of parent folder                                     :%d ",track->parent_id));
    ETG_TRACE_USR4(("uint32_t storage_id;        < ID of storage holding this track                        :%d ",track->storage_id));
    if(track->title != NULL)
        ETG_TRACE_USR4(("char *title;                < Track title                                             :%s ",track->title));
    if(track->artist != NULL)
        ETG_TRACE_USR4(("char *artist;               < Name of recording artist                                :%s ",track->artist));
    if(track->composer != NULL)
        ETG_TRACE_USR4(("char *composer;             < Name of recording composer                              :%s",track->composer));
    if(track->genre != NULL)
        ETG_TRACE_USR4(("char *genre;                < Genre name for track                                    :%s",track->genre));
    if(track->album != NULL)
        ETG_TRACE_USR4(("char *album;                < Album name for track                                    :%s",track->album));
    if(track->date != NULL)
        ETG_TRACE_USR4(("char *date;                 < Date of original recording as a string                  :%s ",track->date));
    if(track->filename != NULL)
        ETG_TRACE_USR4(("char *filename;             < Original filename of this track                         : %s",track->filename));
    ETG_TRACE_USR4(("uint16_t tracknumber;       < Track number (in sequence on recording)                 :%d",track->tracknumber));
    ETG_TRACE_USR4(("uint32_t duration;          < Duration in milliseconds                                :%d",track->duration));
    ETG_TRACE_USR4(("uint32_t samplerate;        < Sample rate of orig file, min 0x1f80 max 0xbb80         :%d",track->samplerate));
    ETG_TRACE_USR4(("uint16_t nochannels;        < Num of channels in this recording 0 = unknown,1or2      :%d",track->nochannels));
    ETG_TRACE_USR4(("uint32_t wavecodec;         < FourCC wave codec name                                  :%d",track->wavecodec));
    ETG_TRACE_USR4(("uint32_t bitrate;           < (Average) bitrate for this file min=1 max=0x16e360      :%d",track->bitrate));
    ETG_TRACE_USR4(("uint16_t bitratetype;       < 0 = unused, 1 = constant, 2 = VBR, 3 = free             :%d",track->bitratetype));
    ETG_TRACE_USR4(("uint16_t rating;            < User rating 0-100 (0x00-0x64)                           :%d",track->rating));
    ETG_TRACE_USR4(("uint32_t usecount;          < Number of times used/played                             :%d",track->usecount));
    ETG_TRACE_USR4(("uint64_t filesize;          < Size of track file in bytes                             :%d",track->filesize));
    ETG_TRACE_USR4(("time_t modificationdate;    < Date of last alteration of the track                    :%d",track->modificationdate));
    ETG_TRACE_USR4(("LIBMTP_filetype_t filetype; < Filetype used for the current track                     :%d",track->filetype));


    ETG_TRACE_USR4((" track->filesize     : %d bytes",track->filesize));
    ETG_TRACE_USR4((" LOCAL_MTPFILE_RESERVEDSIZE  : %d bytes",LOCAL_MTPFILE_RESERVEDSIZE));

    ETG_TRACE_USR4((" LOCAL_MTPFILE_PATH_TARGET  : %s",LOCAL_MTPFILE_PATH_TARGET));
    ETG_TRACE_USR4((" LOCAL_MTPFILE_INFO         : %s",LOCAL_MTPFILE_INFO));
    ETG_TRACE_USR4((" LOCAL_MTPFILE              : %s",LOCAL_MTPFILE));

}


tResult MTPControl::deleteTmpFile(const char *cPath, const char *cfileName)
{
    ENTRY_INTERNAL;

    ifstream tmpFile;
    char l_cFileName[2048];

    snprintf(l_cFileName, sizeof (l_cFileName),"%s/%s",cPath,cfileName);

    tmpFile.open(l_cFileName,ifstream::in);
    if(tmpFile.good())
    {
        ETG_TRACE_USR4(("deleteTmpFile: File exists (ok)"))
        tmpFile.close();
        if(remove(l_cFileName) !=0)
        {
            ETG_TRACE_ERR(("[ERROR] deleteTmpFile: FAILED"));
        }
    }
    else
    {
        ETG_TRACE_USR4(("deleteTmpFile: File not exist (ok)"));
        //ret = MP_ERR_MTP_FILEEXISTS;
    }

    return MP_NO_ERROR;
}
tResult MTPControl::deleteTmpFile(char *fullName)
{
    ENTRY_INTERNAL;

    ifstream tmpFile;

    tmpFile.open(fullName,ifstream::in);

    if(tmpFile.good())  {

        ETG_TRACE_USR4(("deleteTmpFile: File exists (ok)"))
        tmpFile.close();

        if(remove(fullName) !=0) {

            ETG_TRACE_ERR(("[ERROR] deleteTmpFile: FAILED"));
        }
    } else {

        ETG_TRACE_USR4(("deleteTmpFile: File not exist (ok)"));
    }
    return MP_NO_ERROR;
}

tResult MTPControl::writeID(IN const char*cPath,IN const char*cfileName, IN tDeviceID deviceID, IN const tURL URL)
{
    ENTRY_INTERNAL;

    tResult ret = MP_ERR_MTP_GENERAL_ERROR;
    FILE *fp;
    char l_cFileName[2048];

    if((NULL != cPath) && (NULL !=cfileName))
    {
       snprintf(l_cFileName, sizeof (l_cFileName),"%s/%s",cPath,cfileName);
       fp = fopen(l_cFileName,"w");

       if(NULL != fp)
       {
           fprintf(fp,"%u\n",deviceID);
           fprintf(fp,"%s\n",URL);
           fclose(fp);
           ret = MP_NO_ERROR;
       }
    }

    return ret;
}

tResult MTPControl::writeAppendInfo(IN const char*cPath,
                                    IN const char*cfileName,
                                    IN LIBMTP_filetype_t filetype,
                                    IN const tMountPoint mountPoint,
                                    IN const tMetadata title,
                                    IN const tMetadata album,
                                    IN const tMetadata artist,
                                    IN const tMetadata genre)
{
    ENTRY_INTERNAL;

    tResult ret = MP_ERR_MTP_GENERAL_ERROR;
    FILE *fp;
    char l_cFileName[2048];
    const char *fileType = m_pMTPLibWrapper->wLIBMTP_Get_Filetype_Description(filetype);

    if((NULL != cPath) && (NULL !=cfileName) && (NULL != fileType))
    {
        snprintf(l_cFileName, sizeof (l_cFileName),"%s/%s",cPath,cfileName);
        fp = fopen(l_cFileName,"a");

        if(NULL != fp)
        {
           fprintf(fp,"%u\n",filetype);
           fprintf(fp,"(deviceID,URL,fileTypenum)");
           fprintf(fp,"\n\n========additional information===========\n");
           fprintf(fp,"mountPoint: %s\n",mountPoint);
           fprintf(fp,"filetype  : %s\n",fileType);
           fprintf(fp,"title     : %s\n",title);
           fprintf(fp,"album     : %s\n",album);
           fprintf(fp,"artist    : %s\n",artist);
           fprintf(fp,"genre     ; %s\n",genre);
           fclose(fp);
           ret = MP_NO_ERROR;
        }
    }
    return ret;
}

tUInt MTPControl::comparePreviousID(const char*cPath,const char*cfileName, tDeviceID deviceID, const tURL URL)
{
    ENTRY_INTERNAL;

    ETG_TRACE_USR4(("comparePreviousID path: %d",deviceID));
    ETG_TRACE_USR4(("comparePreviousID path: %s",URL));

    tResultID ret;
    FILE *fp;
    char l_cFileName[2048];

    tURL URL_prev;
    tDeviceID deviceID_prev;

    if((NULL != cPath) && (NULL !=cfileName))
    {
       snprintf(l_cFileName, sizeof (l_cFileName),"%s/%s",cPath,cfileName);

       fp = fopen(l_cFileName,"r");

       if(NULL != fp)
       {
          fscanf(fp,"%u\n",&deviceID_prev);
          fgets (URL_prev ,sizeof(URL_prev),fp);
          fclose(fp);

          ETG_TRACE_USR4(("comparePreviousID: deviceID_prev = %u",deviceID_prev));

          ret = enNotEqual;
          if (deviceID_prev == deviceID)
          {
              ETG_TRACE_USR4(("comparePreviousID: deviceID is equal"));
              if(0 == strncmp(URL_prev,URL,strlen_r(URL)))
              {
                  ETG_TRACE_USR4(("comparePreviousID: URL are same"));
                  ret = enEqual;
              }
          }
       }
       else
       {
           ret = enNotAvailable;
       }
    }
    else
    {
        ret = enWrongParameter;
    }

    return ret;
}

tResult MTPControl::GetFileFormat(tFileFormat &fileFormat,const tAlbumArt albumArtString)
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    /* init the return value */
    fileFormat = FFT_UNKNOWN;

    /* Get file extension */
    FastUTF8::tString localPath;
    FastUTF8::tString extension;
    localPath = (FastUTF8::tString)strdup(albumArtString);
    FastUTF8::SplitExtension(OUT extension, IN localPath);

    /* extension found */
    if (extension) {

        char c;
        int i=0;
        bool bRun = true;
        char fileFormatMp3[5]="mp3";
        char fileFormatMp4[5]="mp4";
        char fileFormatAif[5]="aif";
        char fileFormatAiff[5]="aiff";
        char fileFormatWav[5]="wav";
        char fileFormatWma[5]="wma";
        char fileFormatM4a[5]="m4a";
        while(bRun)
        {
          c = extension[i];
          if(c != '\0')
          {
              if(c<128 /*care for 7Bit ascii fits to below suffixes*/)
              {
                  extension[i] = tolower(c);
              }
              i++;
          }
          else
          {
              bRun = false;
          }
        }

        /* look for the file format */
        if (FastUTF8::EndsWith((const FastUTF8::tString)extension, (const FastUTF8::tString)fileFormatMp3))      fileFormat = FFT_MP3;
        else if (FastUTF8::EndsWith((const FastUTF8::tString)extension, (const FastUTF8::tString)fileFormatMp4)) fileFormat = FFT_MP4;
        else if (FastUTF8::EndsWith((const FastUTF8::tString)extension, (const FastUTF8::tString)fileFormatAif)) fileFormat = FFT_AIFF;
        else if (FastUTF8::EndsWith((const FastUTF8::tString)extension, (const FastUTF8::tString)fileFormatAiff))fileFormat = FFT_AIFF;
        else if (FastUTF8::EndsWith((const FastUTF8::tString)extension, (const FastUTF8::tString)fileFormatWav)) fileFormat = FFT_WAV;
        else if (FastUTF8::EndsWith((const FastUTF8::tString)extension, (const FastUTF8::tString)fileFormatWma)) fileFormat = FFT_WMA;
        else if (FastUTF8::EndsWith((const FastUTF8::tString)extension, (const FastUTF8::tString)fileFormatM4a)) fileFormat = FFT_MP4;
        else
        {
            ret = MP_ERR_MTP_UNKNOWNSUFFIX;
        }
    }
    else
    {
        ret = MP_ERR_MTP_GENERAL_ERROR;
    }

    free(localPath);

    return ret;
}


// Interface functions for folder view
tResult MTPControl::MtpGetFolderItem(const tMountPoint mountpoint, const char* path, unsigned int index)
{
    ENTRY_INTERNAL;

    ETG_TRACE_USR4(("MTPControl::MtpGetFolderItem: MountPoint = %s", mountpoint));
    ETG_TRACE_USR4(("MTPControl::MtpGetFolderItem: Path = %s", path));

    tResult ret = MP_NO_ERROR;
    char root[] = "/";
    bool bItemPresent = false;
    tFiles *filesPtr = NULL;

    tDeviceID deviceId = 0;
    deviceId = MTPCache_GetDeviceId(mountpoint);

    if ((!strcmp(path, root)) ||(!strcmp(path,"")))
    {
        ETG_TRACE_USR4(("MTPControl::MtpGetFolderItem: root folder, get the storage entry"));
        unsigned int storagecount = MTPCache_GetStorageCount(mountpoint);
        // If storage count =0; fingerprint is not yer read
        if (storagecount != 0)
        {
            ETG_TRACE_USR4(("MTPControl::MtpGetFolderItem: storage count = %d", storagecount));
            if((index-1) < storagecount)
            {
                filesPtr = CopyStorageElement(mountpoint,(index-1));
                bItemPresent = true;
            }
        }
    }
    else
    {
        uint32_t parentID = 0;
        parentID = MTPCache_GetItemID(path,deviceId);
        static bool readProgress = false;

        ETG_TRACE_USR4(("MTPControl::MtpGetFolderItem: Folder Path = %s", path));
        ETG_TRACE_USR4(("MTPControl::MtpGetFolderItem: ParentItemID= %d", parentID));

        //parentID = 0, means folder for requested path is not yet opened. so request the folder
        if(parentID != 0)
        {
            //get number of files
            uint32_t filecount = MTPCache_GetFileCount(parentID,deviceId);
            ETG_TRACE_USR4(("MTPControl::MtpGetFolderItem: Filecount = %d", filecount));

            if ((filecount != 0) && (false == readProgress))
            {
                //Folder is already read; read browse entry
                if(index <= filecount)
                {
                    filesPtr = CopyFileElement(parentID, index, deviceId);
                    bItemPresent = true;
                }
            }
            else if(FOLDER_READ_ALL_COMPLETE == mReadStatus)
            {
                 bItemPresent = false;
            }
            else
            {
                LIBMTP_file_t *pFile = NULL;
                tPath fullPath;
                uint32_t storageId = 0;
                tS32 readindex = 0;

                storageId =  MTPCache_GetStorageIDFromMountPoint(mountpoint, path);
                ETG_TRACE_USR4(("MTPControl::MtpGetFolderItem: storageId = %d", storageId));

                //get the device pointer
                LIBMTP_mtpdevice_t     *pDevice = devTblFind(IN mountpoint);
                if((NULL != pDevice ) && (0 != storageId))
                {
                    if(storageId == parentID)
                        pFile = m_pMTPLibWrapper->wLIBMTP_Get_Item(pDevice, storageId, MTP_ROOT_FOLDER_ID,&readindex);
                    else
                        pFile = m_pMTPLibWrapper->wLIBMTP_Get_Item(pDevice, storageId, parentID,&readindex);

                    if(pFile != NULL){
                        tMTPFile MTPFile; // Review comment <Following naming convensions> from tFile to MTPFile
                        MTPFile.filesize  = pFile->filesize;
                        MTPFile.filetype  = pFile->filetype;
                        MTPFile.item_id   = pFile->item_id;
                        if(NULL != pFile->filename)
                        strncpy_r(MTPFile.filename, pFile->filename, sizeof(MTPFile.filename));
                        m_pMTPLibWrapper->wLIBMTP_destroy_file_t(pFile);
                        if ((false == FolderFilterEntry((const char*) MTPFile.filename)) && \
                                ((LIBMTP_FILETYPE_FOLDER ==  MTPFile.filetype) ||
                                        ((true == LIBMTP_FILETYPE_IS_AUDIO( MTPFile.filetype)) && ( MTPFile.filesize < (LocalSPM::GetDataProvider().MaximumMTPFileSizeInMB() * 1024 * 1024))) || \
                                        ((LocalSPM::GetDataProvider().MTPVideoSupport()) && (true == LIBMTP_FILETYPE_IS_VIDEO( MTPFile.filetype)) && ( MTPFile.filesize < (LocalSPM::GetDataProvider().MaximumMTPVideoFileSizeInMB() * 1024 * 1024))))) //lint !e574
                        {
                            if(LIBMTP_FILETYPE_FOLDER ==  MTPFile.filetype){
                                snprintf(fullPath, sizeof (fullPath),"%s/%s",path,  MTPFile.filename);
                                MTPCache_StorePath(fullPath, MTPFile.item_id,deviceId);
                            }
                            MTPCache_WriteBrowseEntry(parentID, index, MTPFile,deviceId);
                        }
                        filesPtr = CopyFileElement(parentID, index, deviceId);
                        bItemPresent = readProgress = true;

                    }
                    else if (-1 == readindex){
                        bItemPresent = false;
                        readProgress = false;
                    }
                }
            }
        }
     }
    //}
    /* Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    if(true == bItemPresent)
    {
        SMF::Marshal(parameterString, size - 1, "p", filesPtr);
        TestIF_sendTestResultMsg(IN STRING_TRESULT_OK); //send to testResultMsgQ
    }
    else
    {
        SMF::Marshal(parameterString, size - 1, "p", NULL);
        TestIF_sendTestResultMsg(IN STRING_TRESULT_NOK); //send to testResultMsgQ
    }

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return MP_NO_ERROR;
}


tFiles* MTPControl::CopyFileElement(uint32_t parentID, uint32_t index,tDeviceID deviceId)
{
    ENTRY_INTERNAL;

    tFiles *files = NULL;
    files = (tFiles*)new tFiles;
    if(files)
    {
        InitFiles(*files);

        const tMTPFileElement *FileElement = MTPCache_ReadBrowseEntry(parentID, index,deviceId);
        if(NULL != FileElement)
        {
            ETG_TRACE_USR4(("MTPControl::CopyFileElement: filename= %s", FileElement->filename));
            ETG_TRACE_USR4(("MTPControl::CopyFileElement: item_id= %d", FileElement->item_id));
            ETG_TRACE_USR4(("MTPControl::CopyFileElement: parent_id= %d", FileElement->parent_id));
            ETG_TRACE_USR4(("MTPControl::CopyFileElement: filetype= %d", FileElement->filetype));
            //InitFiles(files);
            files->fileFormat = FileElement->fileFormat;
            strcpy(files->fileName, FileElement->filename);
            files->isPlaying = false;
            //files->notPlayable = FNP_NOT_PLAYABLE;
            files->trackNumber = FileElement->item_id; //item_id
            files->type = FileElement->filetype;
        }
    }
    return files;
}

tFiles* MTPControl::CopyStorageElement(const tMountPoint mountpoint, uint32_t index)
{
    ENTRY_INTERNAL;

    tFiles *files = NULL;
    files = (tFiles*)new tFiles;
    if(files)
    {
        InitFiles(*files);

        const tMTPStorageElement *storageElement = MTPCache_ReadStorageEntry(mountpoint,index);
        ETG_TRACE_USR4(("MTPControl::CopyStorageElement: ItemName= %s", storageElement->name));
        ETG_TRACE_USR4(("MTPControl::CopyStorageElement: ItemID= %d", storageElement->item_id));
        // put the data in tFiles
        //InitFiles(files);
        files->fileFormat = FFT_UNKNOWN;
        strcpy(files->fileName, &storageElement->name[1]); //storage name
        files->isPlaying = false;
        //files.notPlayable = FNP_NOT_PLAYABLE;
        files->trackNumber = storageElement->item_id; //item_id
        files->type = FT_FOLDER; //folder
    }
    return files;
}


MTPLibWrapper *MTPControl::GetpMTPLibWrapper()
{
    return m_pMTPLibWrapper;
}

bool MTPControl::checkRealDevicesUsed()
{
    bool         bUseRealMTP;
    switch (gMTPConnected)
    {
        case REALDEVICECONNECTED_YES:
            bUseRealMTP = true;
            break;
        case REALDEVICECONNECTED_NO:
            bUseRealMTP = false;
            break;
        default:
            ETG_TRACE_ERR(("[ERROR] :MTPControl::factoryGetLibMTPWrapper()"));
            bUseRealMTP = false;
            break;
    }
    return bUseRealMTP;
}

void MTPControl::factoryGetLibMTPWrapper()
{
    ENTRY_INTERNAL;

    bool bUseRealMTP;

    bUseRealMTP = checkRealDevicesUsed();

    if(true == bUseRealMTP)
    {
        if(NULL == m_pMTPLibWrapper)
        {
            m_pMTPLibWrapper = new MTPLibWrapper();
            m_eTypeOfWrapper = eMTPWrapper_realLib;
            ETG_TRACE_USR1(("factoryGetLibMTPWrapper: use real libMTP"));
            m_pMTPLibWrapper->wLIBMTP_INIT();
        }
    }
    else
    {
        if(NULL == m_pMTPLibWrapper)
        {
            m_pMTPLibWrapper = new MTPLibWrapperTest();
            m_eTypeOfWrapper = eMTPWrapper_stubLib;
            ETG_TRACE_USR1(("factoryGetLibMTPWrapper: use stubbed libMTP"));
            m_pMTPLibWrapper->wLIBMTP_INIT();
        }
    }
}


MTPControl::MTPControl(const tComponentID componentID):ILocalSPM(componentID)
{
    ENTRY_INTERNAL;

    m_device          = NULL;
    m_pMTPLibWrapper  = NULL;
    m_eTypeOfWrapper  = eMTPWrapper_undefined;
    m_pTestResultMsgQ = NULL;

    MTPControl::factoryGetLibMTPWrapper();
};

void MTPControl::sendPlaybackstatus(tPEPlaybackState status)
{
    ENTRY_INTERNAL;

    tResult ret;
    tAllParameters parameterString;

    tMetadata metadata = {0};

    tObjectID ObjectID = OBJECT_ID_NONE;
    ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString,
                                            IN sizeof(parameterString),
                                            IN status,
                                            IN metadata,
                                            IN metadata,
                                            IN metadata,
                                            IN metadata,
                                            IN ObjectID);

    if(MP_NO_ERROR == ret)
    {
        ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF"));
        }
    }
    else
    {
        ETG_TRACE_ERR(("Error while preparing parameter string"));
    }
 }

tResult MTPControl::errChkAvailable(const tMountPoint mountPoint)
{
    ENTRY_INTERNAL;

    tResult ret = MP_NO_ERROR;
    LIBMTP_mtpdevice_t *device;

    device = devTblFind(mountPoint);
    if(NULL == device)
    {
        ETG_TRACE_ERR(("StartPlay: No device matches mountPoint"));
        ret = MP_ERR_MTP_NODEVICE;
        sendPlaybackstatus(PE_PBS_ERRORSTATE);
    }

    return ret;
}

unsigned int MTPControl::TestIF_GetNumOfDevices(unsigned expectedNumOfDevices,unsigned timoutIntervall,unsigned numOfTrials)
{
    ENTRY_INTERNAL;
    ETG_TRACE_USR4(("MTPControlTestCombined::InitRemoveDeviceConnection: expectedNumOfDevices: %d timoutIntervall: %d, numOfTrials=%d",expectedNumOfDevices,timoutIntervall,numOfTrials));

    int res            = -1;
    unsigned int trialCount =  0;
    while(res != (int)expectedNumOfDevices)
    {
        sleep(timoutIntervall);

        res = m_devTable.size();

        if(++trialCount >= numOfTrials) break;

        ETG_TRACE_USR4(("MTPControlTestCombined::InitRemoveDeviceConnection: count: %d",trialCount));

    }

    if(res == -1) {res = 0;}
    ETG_TRACE_USR4(("MTPControlTestCombined::InitRemoveDeviceConnection: numOfConnectedDevices (ret): %d",res));
    return res;
}


void MTPControl::TestIF_setWrapper(eMtpWrapperType eTypeOfWrapper)
{
    ENTRY_INTERNAL;
    ETG_TRACE_USR4(("MTPControl::TestIF_setWrapper: 0x%x",eTypeOfWrapper));

    if(m_eTypeOfWrapper != eTypeOfWrapper)
    {
        ETG_TRACE_USR4(("MTPControl::TestIF_setWrapper:set new MTPLibWrapper"));

        switch(eTypeOfWrapper)
        {
            //------------------------------------
            case eMTPWrapper_realLib:
            //------------------------------------
                devTblDeleteAll(); //delete List of devices
                delete m_pMTPLibWrapper;
                m_pMTPLibWrapper = NULL;

                m_pMTPLibWrapper = new MTPLibWrapper();
                m_eTypeOfWrapper = eMTPWrapper_realLib;
                ETG_TRACE_USR1(("TestIF_setWrapper: use real libMTP"));
                break;
            //------------------------------------
            case eMTPWrapper_stubLib:
            //------------------------------------
                devTblDeleteAll(); //delete List of devices
                delete m_pMTPLibWrapper;
                m_pMTPLibWrapper = NULL;

                m_pMTPLibWrapper = new MTPLibWrapperTest();
                m_eTypeOfWrapper = eMTPWrapper_stubLib;
                ETG_TRACE_USR1(("TestIF_setWrapper: use stubbed libMTP"));
                break;
            //------------------------------------
            case eMTPWrapper_undefined:
            //------------------------------------
                ETG_TRACE_ERR(("TestIF_setWrapper:eMTPWrapper_undefined -do nothing"));
                break;
            //------------------------------------
            default:
            //------------------------------------
                ETG_TRACE_ERR(("TestIF_setWrapper:default -do nothing"));
                break;
        }
    }
    else
    {
        ETG_TRACE_USR4(("MTPControl::TestIF_setWrapper:demanded MTPLIBWrapper already in use"));
    }

}

void MTPControl::TestIF_setTestResultMsgQ(IN MessageQueue *pTestResultQ)
{
    ENTRY_INTERNAL;

    m_pTestResultMsgQ = pTestResultQ;
    if(NULL == m_pTestResultMsgQ)
    {
        ETG_TRACE_USR4(("MTPControl::TestIF_setTestResultMsgQ: OFF"));
    }
    else
    {
        ETG_TRACE_USR4(("MTPControl::TestIF_setTestResultMsgQ: ON"));
    }
}

void MTPControl::TestIF_sendTestResultMsgResult(IN tResult result)
{
    ENTRY_INTERNAL;

    if(MP_NO_ERROR == result)
    {
        TestIF_sendTestResultMsg(IN STRING_TRESULT_OK);
    }
    else
    {
        TestIF_sendTestResultMsg(IN STRING_TRESULT_NOK);
    }
}

void MTPControl::TestIF_sendTestResultMsgMediaStatus(IN tMetadataStatus metadataStatus)
{
    ENTRY_INTERNAL;

    switch(metadataStatus)
    {
        case MDS_SUCCESS:
            TestIF_sendTestResultMsg(IN STRING_MDS_SUCCESS);
            break;
        case MDS_FINISHED:
            TestIF_sendTestResultMsg(IN STRING_MDS_FINISHED);
            break;
        case MDS_FILE_SKIP:
            TestIF_sendTestResultMsg(IN STRING_MDS_FILE_SKIP);
            break;
        case MDS_FILE_ERROR:
            TestIF_sendTestResultMsg(IN STRING_MDS_FILE_ERROR);
            break;
        case MDS_DEVICE_ERROR:
            TestIF_sendTestResultMsg(IN STRING_MDS_DEVICE_ERROR);
            break;
        default:
            ETG_TRACE_ERR(("MTPControl::TestIF_sendTestResultMsgMediaStatus: value not supported"));
            break;
    }
}


void MTPControl::TestIF_sendTestResultMsg(const char* pMessage)
{
    ENTRY_INTERNAL;

    if(m_pTestResultMsgQ != NULL)
    {
        if(NULL != pMessage)
        {
            ETG_TRACE_USR3(("MTPControl::TestIF_sendTestResultMsg: pMessage:%s",pMessage));
            m_pTestResultMsgQ->Push(pMessage,strlen_r(pMessage)+1,3);
        }
        else
        {
            ETG_TRACE_ERR(("[ERROR] MTPControl::TestIF_sendTestResultMsg: pMessage==NULL!"));
        }
    }
    else
    {
        ETG_TRACE_ERR(("[ERROR] MTPControl::TestIF_sendTestResultMsg: m_pTestResultMsgQ==NULL!"));
    }
}

tBoolean MTPControl::IsBatchPlayable(const tDeviceID deviceID)
{
    ENTRY;
    VARTRACE(deviceID);
    return 0;
}

void MTPControl::LoadFilterConfiguration()
{
    /*push file pattern which need to be skipped by MTP Read folder*/
    for( int i=1; i<=LocalSPM::GetDataProvider().MTPFileFilterCount(); i++)
    {
        switch(i)
        {
            case 1:
                m_RegisteredFilterPatterns.push_back(LocalSPM::GetDataProvider().MTPFileFilter_01());
                break;
            case 2:
                m_RegisteredFilterPatterns.push_back(LocalSPM::GetDataProvider().MTPFileFilter_02());
                break;
            case 3:
                m_RegisteredFilterPatterns.push_back(LocalSPM::GetDataProvider().MTPFileFilter_03());
                break;
            case 4:
                m_RegisteredFilterPatterns.push_back(LocalSPM::GetDataProvider().MTPFileFilter_04());
                break;
            case 5:
                m_RegisteredFilterPatterns.push_back(LocalSPM::GetDataProvider().MTPFileFilter_05());
                break;
            case 6:
                m_RegisteredFilterPatterns.push_back(LocalSPM::GetDataProvider().MTPFileFilter_06());
                break;
            case 7:
                m_RegisteredFilterPatterns.push_back(LocalSPM::GetDataProvider().MTPFileFilter_07());
                break;
            case 8:
                m_RegisteredFilterPatterns.push_back(LocalSPM::GetDataProvider().MTPFileFilter_08());
                break;
            default:
                ETG_TRACE_ERR(("[ERROR] Check mediaplayer configuration (MTPFileFilterCount)"));
                break;
        }
    }
}

bool MTPControl::FolderFilterEntry(const char* entryName)
{
    int ret;

    regex_t regex;

    for(unsigned int iter=0; iter < m_RegisteredFilterPatterns.size() ; iter++)
    {
        if(!regcomp(&regex, m_RegisteredFilterPatterns[iter].c_str(),REG_ICASE|REG_NOSUB))
        {
            /*check if entryName matches with the pattern */
            ret = regexec(&regex,entryName, 0, NULL, 0);
            regfree(&regex);
            if(!ret)
            {
                return true;
            }
        }

    }
    return false;
}

tResult MTPControl::readRecursiveFolder(tURL URL,const tDeviceID deviceID,const tMountPoint mountPoint)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;
    tURL fullPath;
    tUInt indexElement=0,indexFullPath,indexPrintElement;
    tUInt uiIndex = 0;
    tU8 slashCount = 0;
    char seperatedElement[10][20],indexedChar;

    LIBMTP_mtpdevice_t     *pDevice = devTblFind(IN mountPoint);
    if(NULL != pDevice)
    {
        strncpy_r(OUT fullPath, IN URL, IN sizeof(fullPath));
        slashCount = FastUTF8::Count((unsigned char *)fullPath, (unsigned char *)"/");//lint !e1773
        ETG_TRACE_USR4(("MTPControl::slashCount : %d ",slashCount));

        tUInt lenOfMp = strlen_r(fullPath); //without '\0'
        for(indexFullPath = 1; indexFullPath < lenOfMp; indexFullPath++)     //iterate from index 0 to last letter before '\0' i.e. end of string
        {
            indexedChar = fullPath[indexFullPath];
            if(indexedChar == SEPERATOR)
            {
                seperatedElement[indexElement][uiIndex] = EOF_STRING; //add eond of srting instead of seperator
                uiIndex = 0;                                //reset index for the next element
                indexElement++;                                        //goto next element
            }
            else
            {
                seperatedElement[indexElement][uiIndex++] = fullPath[indexFullPath];
                ETG_TRACE_USR4(("MTPControl::uiIndex : %d ",uiIndex));
            }
        }
        seperatedElement[indexElement][uiIndex] = EOF_STRING;
        tU32 prevStoreId[12];
        tU32 storageId = 0;
        storageId =  MTPCache_GetStorageIDFromMountPoint(mountPoint, URL);
        for(indexPrintElement = 0;indexPrintElement < slashCount;indexPrintElement++)
        {
            ETG_TRACE_USR4(("MTPControl::readRecursiveFolder Elements[%d]:%s",indexPrintElement,seperatedElement[indexPrintElement]));
            prevStoreId[indexPrintElement] = (uint32_t)std::atoi(seperatedElement[indexPrintElement]);
            m_pMTPLibWrapper->wLIBMTP_ReadFiles(pDevice, storageId, prevStoreId[indexPrintElement]);
        }
    }
    return ret;
}

tResult MTPControl::GetLastPlayedPath(IN const tDeviceID deviceID, OUT tPath lastPlayedPath)
{
    ENTRY_INTERNAL

    tPath l_lastPlayedPath,l_tempPath;
    size_t pos = 0;
    tU8 slashCount,iter = 0, isCacheAvailable = true;
    int l_itemId = 0;

    string url = m_LastPlayedPath+1, url1;
    slashCount = FastUTF8::Count((unsigned char *)m_LastPlayedPath, (unsigned char *)"/");//lint !e1773

    for (iter= 0 ;iter < (slashCount-1); ++iter)
    {
        pos = url.find_first_of("/");
        if(pos){
            url1 = url.substr(0,pos);
            url = url.substr(pos+1);

            if(!iter){
                snprintf(l_lastPlayedPath, sizeof (l_lastPlayedPath),"/%s",url1.c_str());
                snprintf(lastPlayedPath, sizeof (tPath),"/%d",MTP_ROOT_FOLDER_ID);
            }
            else
            {
                strncat_r(l_lastPlayedPath,"/",sizeof(l_lastPlayedPath));
                strncat_r(l_lastPlayedPath,url1.c_str(),sizeof(l_lastPlayedPath));
                l_itemId = MTPCache_GetItemID(l_lastPlayedPath,deviceID);
                if(!l_itemId){
                    isCacheAvailable = false;
                    break;
                }
                snprintf(l_tempPath, sizeof (tPath),"/%u",l_itemId);
                strncat_r(lastPlayedPath,l_tempPath,sizeof(tPath));
            }
            ETG_TRACE_USR4(("MTPControl::GetLastPlayedPath path formed : %s ",lastPlayedPath));
        }
    }
    if(isCacheAvailable)
    {
        strncpy_r(m_LastStoredPath,lastPlayedPath,sizeof(tPath));
    }
    else
    {
        strncpy_r(lastPlayedPath,m_LastStoredPath,sizeof(tPath));
    }
    return MP_NO_ERROR;
}

tResult MTPControl::SendNoResponseMsg(const tResponseMsg response)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    ETG_TRACE_USR3(("USBControl::SendNoResponseMsg %d", response));
    if(m_response != response)
    {
        ret = LocalSPM::GetOutputWrapper().UpdateStreamingInfo();
    }
    m_response = response;
    return ret;
}
tResult MTPControl::getStreamingInfo(OUT tResponseMsg &info)
{
    ENTRY
    info = m_response;
    return MP_NO_ERROR;
}
tBoolean MTPControl::IsInitializingDevice(const tMountPoint mountPoint,tConnectionState connectionState,tInitDeviceProtocol protocol)
{
    return true;
}

tReturnValue MTPControl::ReadVideoMetadataFromFile(tMediaObject &mediaObject, const tURL completeFileName)
{
    ENTRY
    VARTRACE(completeFileName);
    tReturnValue returnValue = TRUE;

    /* only if video indexing enabled and Video file is not treated as Audio */
    if ((LocalSPM::GetDataProvider().VideoIndexingOn() == 0) && (LocalSPM::GetDataProvider().InformVideoFileAsAudio() == 0)) {
        return FALSE;
    }

#if PERF_MEAS
    TimeTrace ticks("ReadVideoMetadataFromFile");
#endif

    mediaObject.mediaType = MTY_VIDEO;


#if USE_VIDEO_METADATA_READ_PROCESS
    VideoTagInfo *info = new VideoTagInfo(IN completeFileName, MTP_CTRL_SM_ANSWER_TIMEOUT_MS-100);
#else
    string target((const char *)completeFileName);
    Info *info = Info::create_tag_info(IN target);
#endif

    if(info)
    {
        if(info->read())
        {
            tGeneralString codecString="NULL";
            tVideoProfileName profile="NULL";
            tVideoProfileLevel level=0.0;
            tSize width=0;
            tSize height=0;
            tBitRate bitRate=0;
            tFrameRate frameRate=0;
            tCodec codec = CDC_OTHER;
            unsigned long long int durationInNanoSec;

            strncpy_r(OUT codecString, IN info->get_videocodec().toCString(true), IN sizeof(codecString));
            CodecStandardisation(OUT codec, IN codecString);
            ETG_TRACE_USR3(("MTPControl::CodecStandardisation codecName:%20s -> codecEnum:%d", codecString, codec));
            strncpy_r(OUT profile, IN info->get_profile().toCString(true), IN sizeof(profile));
            strupper(profile);
            level=info->get_level();
            width=(tSize)info->get_width();
            height=(tSize)info->get_height();
            bitRate=(tBitRate)info->get_bitrate();
            frameRate=(tFrameRate)info->get_framerate();

            if(LocalSPM::GetDataProvider().IsVideoPlayable(IN codec, IN profile, IN level, IN width, IN height, IN frameRate, IN bitRate))
            {
                /* if title is Latin1 encoded, do not convert to Unicode in all the next steps */
                /* thm3hi: I assume that all tags are coded uniquely */
                bool convertToUnicode = true;
                if (info->get_title().isLatin1()) {
                    convertToUnicode = false;
                }
                /*extract all other video metadata */
                tURL fullName;
                unsigned char *pureFile;
                strncpy_r(OUT fullName, IN completeFileName, IN sizeof(fullName));
                FastUTF8::Split(OUT pureFile, INOUT (unsigned char *)fullName);

                if (pureFile)
                {
                    /* Remove the extension, if wanted */
                    if (LocalSPM::GetDataProvider().DBRemoveExtensionFromFilename())
                    {
                        unsigned char *extension;
                        FastUTF8::SplitExtension(OUT extension, INOUT (unsigned char *)pureFile);
                    }

                    strncpy_r(OUT mediaObject.title, IN (const char *)pureFile, IN sizeof(mediaObject.title));
                }

                strncpy_r(mediaObject.MetadataField1, info->get_title().toCString(convertToUnicode), sizeof(mediaObject.MetadataField1));

                if(0 == strlen_r(mediaObject.MetadataField1))
                {
                    ETG_TRACE_USR1(("No title available -> use filename as video name instead"));
                    strncpy_r(OUT mediaObject.MetadataField1, IN mediaObject.title, IN sizeof(mediaObject.MetadataField1));
                }
                else
                {
                    //If Codesetconversion is supported,Latin1 MetadataField1 should be converted to UTF-8 and remembered
                    if(LocalSPM::GetDataProvider().CodeSetConversionSupported())
                    {
                        mediaObject.metadataConvertFlag = 0;

                        if(false == convertToUnicode)
                        {
                            mediaObject.metadataConvertFlag |= BITFLAG_METADATAFIELD1;

                            //Check whether the Latin1 title is a invalid UTF-8 String
                            LocalSPM::GetDataProvider().FindNonUTF8Latin1Metadata(INOUT mediaObject);

                            //If non-UTF8,then Title Converted to UTF-8 from Latin1
                            if(mediaObject.metadataConvertFlag) LocalSPM::GetDataProvider().ConvertNonUTF8Latin1Metadata2UTF8(INOUT mediaObject,IN (void*)info);
                        }
                        LocalSPM::GetDataProvider().CutMetadata(INOUT (FastUTF8::tString)(mediaObject.MetadataField1), IN sizeof(mediaObject.MetadataField1));
                    }
                    /* if it was NOT converted to unicode (when CodeSetConversionSupported being false), it must be reconverted to UTF-8 */
                    else if (!convertToUnicode)
                    {
                        /* change string to GBK and cut them */
                        LocalSPM::GetDataProvider().ImportAndCut(INOUT (FastUTF8::tString)mediaObject.MetadataField1, IN sizeof(mediaObject.MetadataField1));
                    }
                }

                /* Store resolution (Roadmap 16011) */
                snprintf(mediaObject.MetadataField2, sizeof(mediaObject.MetadataField2)-1, "%dx%d", width, height);

                durationInNanoSec = info->get_duration();
                mediaObject.totalPlaytime = (durationInNanoSec/1000000);
                mediaObject.trackNumber = (tTrackNumber)info->get_tracknumber();

                // PSA requiremetn to play MP4 file with only having audio data ( MP4 with AAC data)
                // this is not a very clean solution. This configuration will only be enabled for PSA
                if (LocalSPM::GetDataProvider().InformVideoFileAsAudio())
                {
                    mediaObject.mediaType = MTY_MUSIC_FILE;
                    mediaObject.fileType = FT_AUDIO;
                    mediaObject.catType = CTY_SONG;
                }

                /* Check if file is encrypted (DRM protected) */
                if(info->get_encrypted())
                {
                    mediaObject.notPlayable = FNP_DRM_PROTECTED;
                }
            }
            else
            {
                mediaObject.notPlayable = FNP_PLAY_RESTRICTION;
                returnValue = FALSE;
            }
        }
        else
        {
            mediaObject.notPlayable = FNP_FORMAT_ERROR;
            returnValue = FALSE;
        }

        delete info;
    }
    else
    {
        mediaObject.notPlayable = FNP_FORMAT_ERROR;
        returnValue = FALSE;
    }

#if PERF_MEAS
    ticks.elapsed();
#endif
   return returnValue;
}

tResult MTPControl::ActionError(const me::reason_e reason)
{
    ENTRY_INTERNAL

    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    /* Send action error to own state machine*/
    ret = ParameterACTION_ERROR(OUT parameterString, IN size, IN reason);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(ACTION_ERROR ,IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending action error via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}
