/*
 * MTPVTCache.cpp
 *
 *  Created on: Dec 27, 2013
 *      Author: Dinesh
 */

/*-----------------------------------------------------------------------------*
 * ETG Tracing                                                                 *
 *-----------------------------------------------------------------------------*/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_MTP_CONTROL
#ifdef TARGET_BUILD
#include "trcGenProj/Header/MTPControl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_MTP_CONTROL
#endif
#endif

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "LocalSPM.h"
#include "Dispatcher.h"
#include "FunctionTracer.h"
#include "VarTrace.h"
#include "MediaPlayer_ErrorCodes.h"


#include <stdlib.h>
#include "MTPCache.h"
#include <map>
#include <vector>
#include <string>
#include <string.h>
#include <vector>
#include "FastUTF8.h"

using namespace std;

typedef struct _tMTPCache
{
    map <string, map <int,tMTPStorageElement > > mStorages;
    map <int, map <int, map <int,tMTPFileElement > > > mFiles;
    map <int, map <string, int > > mItemIDs;
    map <string,int > mdeviceList;
}tMTPCache;

Lock m_ReadFolderPathLock;
Lock m_MTPFileElementLock;
Lock m_MTPFolderElementLock;
Lock m_MTPStorageElementLock;

static tMTPCache self;

map <int, map <int,tMTPFolderElement > > mFoldersList ;

const tMTPStorageElement* MTPCache_ReadStorageEntry(const char* mountPoint,int index)
{
    m_MTPStorageElementLock.lock();
    map <string, map <int, tMTPStorageElement  > > ::iterator iter = self.mStorages.find(mountPoint);

    if(iter != self.mStorages.end())
    {
        map <int, tMTPStorageElement  > ::iterator innerIter = iter->second.find(index);

        if(innerIter != iter->second.end())
        {
            m_MTPStorageElementLock.unlock();
            return  &innerIter->second;
        }
    }
    m_MTPStorageElementLock.unlock();
    return NULL;
}


char*  MTPCache_GetStorageName(const char* mountPoint, unsigned int storageId)
{
    m_MTPStorageElementLock.lock();
    map <string, map <int, tMTPStorageElement  > > ::iterator iter = self.mStorages.find(mountPoint);
    if(iter != self.mStorages.end())
    {
        map <int, tMTPStorageElement  > ::iterator innerIter = iter->second.begin();
        for(;innerIter != iter->second.end(); innerIter++)
        {
            if(storageId == innerIter->second.item_id)
            {
                m_MTPStorageElementLock.unlock();
                return innerIter->second.name;
            }
        }
    }
    m_MTPStorageElementLock.unlock();
    return NULL;
}



int MTPCache_WriteStorageEntry(const char* mountPoint,int index ,LIBMTP_devicestorage_t *storage)
{
    tMTPStorageElement storageElem;
    memset(&storageElem,0x00, sizeof(tMTPStorageElement));

    if (storage != NULL)
    {
        /*fill unique id and name*/
        m_MTPStorageElementLock.lock();
        storageElem.item_id = storage->id;
        if(strlen_r(storage->StorageDescription) > 0)
            snprintf(storageElem.name , sizeof (storageElem.name ),"/%s",storage->StorageDescription);
        storageElem.isRead = false;

        /*insert storage item into the cache*/
        self.mStorages[mountPoint][index] = storageElem;
        m_MTPStorageElementLock.unlock();
        MTPCache_StorePath(storageElem.name,storage->id,MTPCache_GetDeviceId(mountPoint));
    }

    return 1;
}


int MTPCache_GetReadStorageCount(const char* mountPoint)
{
    int count = 0;
    count = MTPCache_GetStorageCount(mountPoint);

    m_MTPStorageElementLock.lock();
    map <string, map <int, tMTPStorageElement  > > ::iterator iter = self.mStorages.find(mountPoint);
    if(iter != self.mStorages.end())
    {
        map <int, tMTPStorageElement  > ::iterator innerIter = iter->second.begin();
        for(; innerIter != iter->second.end() ; innerIter++)
        {
            if(true == innerIter->second.isRead)
            {
                if(count > 0)
                    count--;
            }
        }
    }
    m_MTPStorageElementLock.unlock();
    return count;
}


int MTPCache_GetStorageCount(const char* mountPoint)
{
    m_MTPStorageElementLock.lock();
    map <string, map <int, tMTPStorageElement  > > ::iterator iter = self.mStorages.find(mountPoint);

    if(iter != self.mStorages.end())
    {
        m_MTPStorageElementLock.unlock();
        return iter->second.size();
    }
    m_MTPStorageElementLock.unlock();
    return 0;
}

const tMTPFileElement* MTPCache_ReadBrowseEntry(int parentID,int index,tDeviceID deviceId)
{
    m_MTPFileElementLock.lock();
    map <int, map <int, map <int,tMTPFileElement > > > ::iterator iter = self.mFiles.find(deviceId);
    if(iter != self.mFiles.end())
    {
        map <int, map <int,tMTPFileElement > > ::iterator nextIter = iter->second.find(parentID);
        if(nextIter != iter->second.end())
        {
            map <int,tMTPFileElement > ::iterator innerIter = nextIter->second.find(index);
            if(innerIter != nextIter->second.end())
            {
                m_MTPFileElementLock.unlock();
                return  &innerIter->second;
            }
        }
    }
    m_MTPFileElementLock.unlock();
    return NULL;
}

int MTPCache_WriteBrowseEntry(int parentID, int index, const tMTPFile file,tDeviceID deviceId)
{
    VARTRACE(file.filename);
    VARTRACE(file.filetype);

    m_MTPFileElementLock.lock();
    tMTPFileElement fileElem;
    memset(&fileElem,0x00, sizeof(tMTPFileElement));

    /*fill unique id*/
    fileElem.item_id = file.item_id;
    /*transform and udpate filetype*/
    if(file.filetype == LIBMTP_FILETYPE_FOLDER)
    {
        fileElem.filetype = FT_FOLDER;
    }
    else if(LIBMTP_FILETYPE_IS_AUDIO(file.filetype))
    {
        fileElem.filetype = FT_AUDIO;
    }
    else if(LIBMTP_FILETYPE_IS_VIDEO(file.filetype))
    {
        fileElem.filetype = FT_VIDEO;
    }
    else if(file.filetype  == LIBMTP_FILETYPE_PLAYLIST)
    {
        fileElem.filetype = FT_PLAYLIST;
    }
    else
    {
        fileElem.filetype = FT_UNKNOWN;
    }

    VARTRACE(file.filename);
    VARTRACE(file.filetype);

    /*transform and udpate formtat*/
    switch(file.filetype)
    {
        case LIBMTP_FILETYPE_WAV:
            fileElem.fileFormat = FFT_WAV;
            break;
        case LIBMTP_FILETYPE_MP3:
            fileElem.fileFormat = FFT_MP3;
            break;
        case LIBMTP_FILETYPE_WMA:
            fileElem.fileFormat = FFT_WMA;
            break;
        case LIBMTP_FILETYPE_OGG:
            fileElem.fileFormat = FFT_OGG;
            break;
        case LIBMTP_FILETYPE_MP4:
            fileElem.fileFormat = FFT_MP4;
            break;
        case LIBMTP_FILETYPE_WMV:
            fileElem.fileFormat = FFT_WMV;
            break;
        case LIBMTP_FILETYPE_AVI:
            fileElem.fileFormat = FFT_AVI;
            break;
        case LIBMTP_FILETYPE_MPEG:
            fileElem.fileFormat = FFT_MPEG;
            break;
        case LIBMTP_FILETYPE_ASF:
            fileElem.fileFormat = FFT_WMA;
            break;
        case LIBMTP_FILETYPE_AAC:
            fileElem.fileFormat = FFT_AAC;
            break;
        default:
            fileElem.fileFormat = FFT_UNKNOWN;
            break;
    }

    /*fill name*/
    if(NULL != file.filename)
        strncpy_r(fileElem.filename, file.filename, sizeof(fileElem.filename));

    /*insert storage item into the cache*/
    self.mFiles[deviceId][parentID][index] = fileElem;

    m_MTPFileElementLock.unlock();
    return 1;
}

int MTPCache_GetFileCount(int parentID,tDeviceID deviceId)
{
    m_MTPFileElementLock.lock();
    map <int, map <int, map <int,tMTPFileElement > > > ::iterator iter = self.mFiles.find(deviceId);
    if(iter != self.mFiles.end())
    {
        map <int, map <int, tMTPFileElement  > > ::iterator innerIter = iter->second.find(parentID);
        if(innerIter != iter->second.end())
        {
            m_MTPFileElementLock.unlock();
            return innerIter->second.size();
        }

    }
    m_MTPFileElementLock.unlock();
    return 0;
}

int MTPCache_StorePath(const char* path, int itemID,tDeviceID deviceId)
{
    m_ReadFolderPathLock.lock();
    self.mItemIDs[deviceId][path] = itemID;
    m_ReadFolderPathLock.unlock();
    return 1;
}

int MTPCache_GetItemID(const char* path,tDeviceID deviceId)
{
    m_ReadFolderPathLock.lock();
    map <int, map <string, int > > ::iterator iter = self.mItemIDs.find(deviceId);
    if(iter != self.mItemIDs.end())
    {
        map <string,int > ::iterator innerIter = iter->second.find(path);
        if(innerIter != iter->second.end())
        {
            m_ReadFolderPathLock.unlock();
            return innerIter->second;
        }
    }
    m_ReadFolderPathLock.unlock();
    return 0;
}

int MTPCache_GetFolderCount(tDeviceID deviceId)
{
    m_MTPFolderElementLock.lock();
    map <int, map <int,tMTPFolderElement> > :: iterator iter = mFoldersList.find(deviceId);
    if(iter != mFoldersList.end())
    {
        m_MTPFolderElementLock.unlock();
        return iter->second.size();
    }
    m_MTPFolderElementLock.unlock();
    return 0;
}

int MTPCache_StoreFolderID(tDeviceID deviceId,int folderID, char* path,unsigned int storageId)
{
    static int index = 0;
    m_MTPFolderElementLock.lock();
    tMTPFolderElement oMTPFolderElement;

    // Set the read status to READ_NOT_STARTED
    oMTPFolderElement.readstatus = 0;
    oMTPFolderElement.readindex = 0;
    oMTPFolderElement.totalitem = 0;
    oMTPFolderElement.folderid = folderID;
    oMTPFolderElement.storageId = storageId;

    snprintf(oMTPFolderElement.filepath, sizeof (oMTPFolderElement.filepath),"%s",path);
    // put the folder id in the map
    mFoldersList[deviceId][index] = oMTPFolderElement;
    index++;
    m_MTPFolderElementLock.unlock();
    return 1;
}

int MTPCache_getNextParentFolderID(tDeviceID deviceId)
{
    m_MTPFolderElementLock.lock();
    map <int, map <int,tMTPFolderElement > > ::iterator iter = mFoldersList.find(deviceId);
    if(iter != mFoldersList.end())
    {
        map <int,tMTPFolderElement >  ::iterator innerIter = iter->second.begin();
        if(innerIter != iter->second.end())
        {
            m_MTPFolderElementLock.unlock();
            return innerIter->second.folderid;
        }
    }
    m_MTPFolderElementLock.unlock();
    return 0;
}


int MTPCache_getParentFolderStorageID(tDeviceID deviceId)
{
    m_MTPFolderElementLock.lock();
    map <int, map <int,tMTPFolderElement > > ::iterator iter = mFoldersList.find(deviceId);
    if(iter != mFoldersList.end())
    {
        map <int,tMTPFolderElement >  ::iterator innerIter = iter->second.begin();
        if(innerIter != iter->second.end())
        {
            m_MTPFolderElementLock.unlock();
            return innerIter->second.storageId;
        }
    }
    m_MTPFolderElementLock.unlock();
    return 0;
}



int MTPCache_DeleteParentFolderID(tDeviceID deviceId ,int folderId)
{
    (void)folderId;

    m_MTPFolderElementLock.lock();
    map <int, map <int,tMTPFolderElement > > ::iterator iter = mFoldersList.find(deviceId);
    if(iter != mFoldersList.end())
    {
        map <int,tMTPFolderElement >  ::iterator innerIter = iter->second.begin();
        if(innerIter != iter->second.end())
        {
            iter->second.erase(innerIter);
        }
    }
    m_MTPFolderElementLock.unlock();
    return 1;
}

int MTPCache_getReadIndex(tDeviceID deviceId,int folderid)
{
    (void)folderid;
    m_MTPFolderElementLock.lock();
    map <int, map <int,tMTPFolderElement > > ::iterator iter = mFoldersList.find(deviceId);
    if(iter != mFoldersList.end())
    {
        map <int,tMTPFolderElement >  ::iterator innerIter = iter->second.begin();
        if(innerIter != iter->second.end())
        {
            m_MTPFolderElementLock.unlock();
            return innerIter->second.readindex;
        }
    }
    m_MTPFolderElementLock.unlock();
    return 0;
}

char* MTPCache_getFolderPath(tDeviceID deviceId,int folderid)
{
    char* path = NULL ;
    m_MTPFolderElementLock.lock();
    map <int, map <int,tMTPFolderElement > > :: iterator iter = mFoldersList.find(deviceId);
    if(iter != mFoldersList.end())
    {
        map <int,tMTPFolderElement >  ::iterator innerIter = iter->second.begin();
        for(;innerIter != iter->second.end();innerIter++)
        {
            if(folderid == innerIter->second.folderid )
            {
                path = innerIter->second.filepath;
                m_MTPFolderElementLock.unlock();
                return path;
            }
        }
    }
    m_MTPFolderElementLock.unlock();
    return path;
}


int MTPCache_setReadIndex(tDeviceID deviceId ,int folderid, uint32_t readindex)
{
    m_MTPFolderElementLock.lock();
    map <int, map <int,tMTPFolderElement > > :: iterator iter = mFoldersList.find(deviceId);
    if(iter != mFoldersList.end())
    {
        map <int,tMTPFolderElement >  ::iterator innerIter = iter->second.begin();
        for(;innerIter != iter->second.end();innerIter++)
        {
            if(innerIter->second.folderid == folderid)
            {
                innerIter->second.readindex = readindex;
                m_MTPFolderElementLock.unlock();
                return 1;
            }
        }
    }
    m_MTPFolderElementLock.unlock();
    return 0;
}

int MTPCache_setItemCountInFolder(tDeviceID deviceId,int folderid, uint32_t itemcount)
{
    m_MTPFolderElementLock.lock();
    map <int, map <int,tMTPFolderElement > > :: iterator iter = mFoldersList.find(deviceId);
    if(iter != mFoldersList.end())
    {
        map <int,tMTPFolderElement >  ::iterator innerIter = iter->second.begin();
        for(;innerIter != iter->second.end();innerIter++)
        {
            if(innerIter->second.folderid == folderid)
            {
                innerIter->second.totalitem = itemcount;
                m_MTPFolderElementLock.unlock();
                return 1;
            }
        }
    }
    m_MTPFolderElementLock.unlock();
    return 0;
}

tMTPStorageElement* MTPCache_GetCurrentStorage(const tMountPoint mountPoint)
{
    m_MTPStorageElementLock.lock();
    map <string, map <int, tMTPStorageElement  > > ::iterator iter = self.mStorages.find(mountPoint);
    if(iter != self.mStorages.end())
    {
        map <int, tMTPStorageElement  > ::iterator innerIter = iter->second.begin();
        for(; innerIter != iter->second.end() ; innerIter++)
        {
            if(true == innerIter->second.isRead)
                continue;
            m_MTPStorageElementLock.unlock();
            return &innerIter->second;
        }
    }
    m_MTPStorageElementLock.unlock();
    return NULL;
}

void MTPCache_SetCurrentStorage(const tMountPoint mountPoint,unsigned int storageId)
{
    m_MTPStorageElementLock.lock();
    map <string, map <int, tMTPStorageElement  > > ::iterator iter = self.mStorages.find(mountPoint);

    if(iter != self.mStorages.end())
    {
        map <int, tMTPStorageElement  > ::iterator innerIter = iter->second.begin();
        for(; innerIter != iter->second.end() ; innerIter++)
        {
            if(storageId == innerIter->second.item_id)
            {
                innerIter->second.isRead = true;
                break;
            }
        }
    }
    m_MTPStorageElementLock.unlock();
}

uint32_t MTPCache_GetStorageIDFromMountPoint(const tMountPoint mountpoint, const char* path)
{
    uint32_t storageID = 0;
    unsigned int count = MTPCache_GetStorageCount(mountpoint);

    if (count != 0)
    {
        for(uint8_t index = 0; index < count; index++)
        {
            const tMTPStorageElement *storageElement = MTPCache_ReadStorageEntry(mountpoint,index);

            const FastUTF8::tString internalPath = FastUTF8::StartsWith((const FastUTF8::tString)path, (const FastUTF8::tString)storageElement->name);//lint !e1773
            if(internalPath != NULL)
            {
                storageID = storageElement->item_id;
                break;
            }
        }
    }

    return storageID;
}

void MTPCache_ClearCacheEntry(tDeviceID deviceId)
{
    MTPCache_ClearBrowseEntry(deviceId);
    MTPCache_ClearItemId(deviceId);
    MTPCache_ClearFolderList(deviceId);
}


void MTPCache_ClearItemId(tDeviceID deviceID)
{
    m_ReadFolderPathLock.lock();
    map <int, map <string, int > > :: iterator iter = self.mItemIDs.find(deviceID);
    if(iter != self.mItemIDs.end())
    {
        iter->second.clear();
        self.mItemIDs.erase(iter);
    }
    m_ReadFolderPathLock.unlock();
}

void MTPCache_ClearBrowseEntry(tDeviceID deviceId)
{
    m_MTPFileElementLock.lock();
    map <int, map <int, map <int,tMTPFileElement > > > ::iterator iter = self.mFiles.find(deviceId);
    if(iter != self.mFiles.end())
    {
        map <int, map <int,tMTPFileElement > >:: iterator nextIter = iter->second.begin();
        for(; nextIter != iter->second.end() ; nextIter ++)
            nextIter->second.clear();
        iter->second.clear();
        self.mFiles.erase(iter);
    }
    m_MTPFileElementLock.unlock();
}

int MTPCache_ClearFolderList(tDeviceID deviceId)
{
    m_MTPFolderElementLock.lock();
    map <int, map <int,tMTPFolderElement > > :: iterator iter = mFoldersList.find(deviceId);
    if(iter != mFoldersList.end())
    {
        iter->second.clear();
        mFoldersList.erase(iter);
    }
    m_MTPFolderElementLock.unlock();
    return 1;
}

void MTPCache_StoreDeviceId(tDeviceID deviceId,const tMountPoint mountpoint)
{
    self.mdeviceList[mountpoint] = deviceId;
}

tDeviceID MTPCache_GetDeviceId(const tMountPoint mountpoint)
{
    map <string,int > :: iterator iter = self.mdeviceList.find(mountpoint);
    if(iter != self.mdeviceList.end())
    {
        return iter->second;
    }
    return 0;
}

int MTPCache_ClearStorage(const tMountPoint mountPoint)
{
    m_MTPStorageElementLock.lock();
    map <string, map <int, tMTPStorageElement  > > ::iterator iter = self.mStorages.find(mountPoint);
    if(iter != self.mStorages.end())
    {
        iter->second.clear();
        self.mStorages.erase(iter);
    }
    m_MTPStorageElementLock.unlock();
    return 1;
}
