#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_DVD_CONTROL
#ifdef TARGET_BUILD
#include "trcGenProj/Header/DVDControl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_DVD_CONTROL
#endif
#endif

#include "LocalSPM.h"
#include "Dispatcher.h"
#include "FunctionTracer.h"
#include "MediaPlayer_ErrorCodes.h"
#include <sys/types.h>
#include <signal.h>
#include "FastUTF8.h"
#include "VarTrace.h"
#include "TimeTrace.h"

#include "DVDControl.h"
#include "RequestResponseSM.h"
//SPM part


// variables shared between two threads
ResumeBuffer m_resumeBuffer;
bool m_bOnDeviceIntialize;
tDVDSetupInfo mDvdSetupInfo;
tMetadataAvailablefromGN m_bMetadataavailablefromGN;
Lock m_GNdatalock;
//
#define MAX_RESUME_COUNT 10
#define MAX_VIDEO_INTERFACE 5
#define V4LINTERFACEPATH  "/sys/class/video4linux/video"
#define V4LMOUNTPOINT "/dev/video"
#define MAXXCOD 3480
#define MAXYCOD 3480
tCDTOCInfo m_CDTOCInfo ;

void DVDControl::Create()
{
    ENTRY

    /* Create the state machine */
    DVDControlSM::Create();

    CreateDone(0);
}

tResult DVDControl::Init(tInitReason reason)
{
    ENTRY
    VARTRACE(reason);

    /* Init the state machine */
    DVDControlSM::Init();
    SetAnswerTimeout(DVD_CTRL_SM_ANSWER_TIMEOUT_MS); // Set answer timeout
    InitDeviceInfo(mDeviceInfo);
    /* Register state machine with dispatcher */
    Dispatcher::GetInstance().Register(IN this);

    InitFiles(mtocData);
    mTrackNo = 0;
    mPlaybackState = PE_PBS_UNKNOWN ;

    /*Derafult value for disk error*/
    mDvdDiscError.isError = false;
    mDvdDiscError.diskError = DISC_NO_ERROR;
    mDiscMechanicalInfo = 0xFF;
    mCMSkipAvailable =false;
    mMenuPlayback = false;
    mDirectSelectAvailable = false;
    mDVDAngleInfo.AngleNumber = 0;
    mDVDAngleInfo.TotalAngle = 0;
    mDVDAudioChannelInfo.totalChannels = 0;
    mDVDAudioChannelInfo.subWooferAvailable = false;
    mDVDAudioChannelInfo.currentAssignment = 0;
    mDVDSubtitleInfo.SubtitleStatus= false;
    mDVDSubtitleInfo.CurrentSubtitleNumber = 0;
    mDVDSubtitleInfo.TotalSubtitleNumber = 0;
    m_bSendSourceSwitchNowPlayingUpdate = false ;
    m_bOnDeviceIntialize = false;
    m_bAlreadyRipped = false;
    m_resumeCount = 0;
    m_bEjectAfterDoneRipping = false;
    m_bVideoStreaming = false;
    m_bResponseReceived = true;
    memset(m_resumeBuffer,0x00,sizeof(m_resumeBuffer));
    memset(&mDvdSetupInfo,0x00,sizeof(mDvdSetupInfo));
    m_bIsDVDControlActive = false;
    m_bIsDataDisc = false;
    m_dvdDriveMode = INVALID_MODE;
    InitUserContext(m_tempUserContext);
    m_bAutoReinsert = false;
    m_bdatadiscReinserted = false;
    m_bSourceStatePause = false;
    m_bMetadataavailablefromGN = false;
    memset(&m_CDTOCInfo,0,sizeof(m_CDTOCInfo));
    memset(m_Url,0x00,sizeof(tURL));
    m_bPlayfromPause = false;
    m_touchHandler.setEventListener(this);
    return InitDone(0);

}

tResult DVDControl::GetTrackTextInfoFromGN(tFilesPtr metadataGNcurrTrack, unsigned char index)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    VARTRACE(m_bMetadataavailablefromGN);
    std::map<unsigned int ,tRippedTrackInfo>::iterator it;
    it = mGNMetadata.find(index);
    if (it != mGNMetadata.end())
    {
        if((metadataGNcurrTrack != NULL) && (index > 0))
        {
            metadataGNcurrTrack->type = FT_AUDIO;
            metadataGNcurrTrack->trackNumber = (unsigned int)index;
            snprintf(metadataGNcurrTrack->fileName, sizeof(metadataGNcurrTrack->fileName), "file%d.cda", index);
            metadataGNcurrTrack->fileFormat = FFT_UNKNOWN;
            metadataGNcurrTrack->notPlayable = FNP_PLAYABLE;
            strncpy_r(metadataGNcurrTrack->metaData4,it->second.MetadataField4, sizeof(metadataGNcurrTrack->metaData4));
            LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(metadataGNcurrTrack->metaData4), sizeof(metadataGNcurrTrack->metaData4));
            strncpy_r(metadataGNcurrTrack->metaData2, it->second.MetadataField2, sizeof(metadataGNcurrTrack->metaData2));
            LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(metadataGNcurrTrack->metaData2), sizeof(metadataGNcurrTrack->metaData2));
            strncpy_r(metadataGNcurrTrack->metaData3, it->second.title, sizeof(metadataGNcurrTrack->metaData3));
            LocalSPM::GetDataProvider().Convert2UTF8((FastUTF8::tString)(metadataGNcurrTrack->metaData3), sizeof(metadataGNcurrTrack->metaData3));
        }
    }
    else
    {
        if(index > mGNMetadata.size())
        {
            VARTRACE("###EOF###");
            metadataGNcurrTrack->isEOF = 1;
        }
    }
    return ret;
}

tResult DVDControl::InitSM()
{
    ENTRY

    /* Initialize variables */
    m_Mutex.lock();
    InitMediaObject(OUT m_PlayMediaObject);
    m_Mutex.unlock();



    m_StartPosition = 0;
    mTocDataOneTrack = NULL;
    m_pDVDControlInterface = NULL;
    /* init the dvd device interface */
    m_pDVDControlInterface = new DVDControlInterface();

    if(m_pDVDControlInterface != NULL)
    {
        m_pDVDControlInterface->RegisterCallbacks(&mCallbacks);
    }
    else
    {
        ETG_TRACE_ERR(("DVDControl:: DVDControlINterface creation failed "));
    }

    return MP_NO_ERROR;
}


tResult DVDControl::Run()
{
    ENTRY

    /*Create and start threads */
    LocalSPM::GetThreadFactory().Do(IN this, 0, NULL); //DVDControl inclusive state machine

    return RunDone(0);
}

void DVDControl::Do(int functionID, void *ptr)
{
    ENTRY

    //set the threads name
    LocalSPM::GetThreadFactory().SetName(DVDControlSM::GetSMNameFull());

    switch(functionID)
    {
        case 0:
        {
            while(DVDControlSM::STATE_MACHINE_FINISHED != DVDControlSM::StateMachine_Main()){}
            break;
        }

        default:
        {
            ETG_TRACE_ERR(("DVDControl::Do: No thread defined for functionID: %d", functionID));
            break;
        }
    }
}

tResult DVDControl::Stop()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Send STOP message to own SM */
    ret = SendForceEvent(STOP_SM, (char *)NULL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult DVDControl::StopEventProcessed()
{
    ENTRY
    if(m_resumeBuffer[0] == BE_COMMAND_RESPONSE_INFO)
    {
        tDVDInfoBlob resumeblob;
        resumeblob.data = m_resumeBuffer;
        resumeblob.dataSize = sizeof(m_resumeBuffer);
        LocalSPM::GetDBManager().StoreDVDResumeInfo(resumeblob);
        ETG_TRACE_USR4(("\n resume data stored StopEventProcessed is : \n"));
        /*  for(unsigned int i=0 ; i< resumeblob.dataSize ;i++)
        {
            ETG_TRACE_USR4(("\t %x ",resumeblob.data[i]));
        }*/
    }
    //STORE SETUP INFO
    if(mDvdSetupInfo.RegionCode ==  DvdVideoRegionCodeArray[LocalSPM::GetDataProvider().DVDRegionCode()])
    {
        tDVDInfoBlob setupblob;
        setupblob.data = (tDVDInfoData)&mDvdSetupInfo;
        setupblob.dataSize = sizeof(mDvdSetupInfo);
        LocalSPM::GetDBManager().StoreDVDSetupInfo(setupblob);
        ETG_TRACE_USR4(("\n setup info data stored StopEventProcessed is : \n"));
        /* for(unsigned int i=0 ; i< setupblob.dataSize ;i++)
    {
        ETG_TRACE_USR4(("\t %x ",setupblob.data[i]));
    }*/
    }

    /* Send stop done to SPM in the transition to final state in state machine */
    return StopDone(0);
}

tResult DVDControl::Done()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Deregister state machine with dispatcher */
    Dispatcher::GetInstance().DeRegister(IN this);
    if( m_pDVDControlInterface )
    {
        m_pDVDControlInterface->DeInitialize();
    }
    /* Send DONE message to own SM */
    ret = SendForceEvent(DONE, (char *)NULL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult DVDControl::DoneEventProcessed()
{
    ENTRY
#if 0
    if( mTocDataOneTrack )
    {
        delete mTocDataOneTrack;
        mTocDataOneTrack = NULL;
    }
#endif
    if( m_pDVDControlInterface )
    {
        delete m_pDVDControlInterface;
        m_pDVDControlInterface = NULL;
    }


    //Cleanup threads
    LocalSPM::GetThreadFactory().CleanUpThreads(this);

    /* Send done done to SPM in the transition to final state in state machine */
    return DoneDone(0);
}

char *DVDControl::GetSMStateName(tGeneralString stateName, size_t size)
{
    GetCurrentState((char *)stateName, size);
    return stateName;
}


//Playback control part

tResult DVDControl::StartAllocateAudioInput(const tDeviceID /*deviceID*/, const tMountPoint /*mountPoint*/)
{
    ENTRY

    tResult ret = MP_NO_ERROR;
        //if in state ripping, respond to the waiting state machine immediately
    if(IsInState(Ripping)== 1)
    {
        ret = SendAnswer(NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    //if not in state ripping, trigger its own state machine event
    else
    {

        /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        tReturnValue returnValue = true;

        ret = ParameterMETHOD_RETURN(OUT parameterString, IN size, IN returnValue);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(METHOD_RETURN, IN parameterString);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::StartDeAllocateAudioInput()
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    /* For CDDA no need to deallocate audio input device */
    /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tReturnValue returnValue = true;

    ret = ParameterMETHOD_RETURN(OUT parameterString, IN size, IN returnValue);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(METHOD_RETURN, IN parameterString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::StartSwitchObserver(const tDeviceID /*deviceID*/, const tMountPoint /*mountPoint*/)
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    //if in state ripping, respond to the waiting state machine immediately
    if(IsInState(Ripping)== 1)
    {
        ret = SendAnswer(NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    //if not in state ripping, trigger its own state machine event
    else
    {
        /* nobody will not answer, so fake the answer */
        ret = SendEvent(METHOD_RETURN, IN "0");
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::StartStreaming(const tDeviceID /*deviceID*/, const tMountPoint /*mountPoint*/)
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tPEPlaybackState playbackState = PE_PBS_LOADINGSTATE;

    /* For CDDA no need to start streaming */
    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Fake MediaEngine response: Send expected event to waiting state machine immediately */
        me::reason_e reason = REASON_OK;
        me::speed_e speed = ME_SPEED_NORMAL;

        m_Mutex.lock();
        tPEHandle handle = (tPEHandle)m_PlayMediaObject.objectID;
        m_Mutex.unlock();
        //if in state ripping, respond to the waiting state machine immediately
        if(IsInState(Ripping)== 1)
        {
            ret = SendAnswer(NULL);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
       //if not in state ripping, trigger its own state machine event
        else
        {
            ret = ParameterSTART_STREAMING_ANSWER(OUT parameterString, IN size, IN handle, IN playbackState, IN reason, IN speed);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                parameterString[0] = '\0';
            }

            ret = SendEvent(START_STREAMING_ANSWER, IN parameterString);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
    }
    else
    {
        /* Fake PlayerEngine response: Send expected event to waiting state machine immediately */
        tMetadata metadata = { 0 };

        tObjectID ObjectID = OBJECT_ID_NONE;
        //if in state ripping, respond to the waiting state machine immediately
        if(IsInState(Ripping)== 1)
        {
            ret = SendAnswer(NULL);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
        //if not in state ripping, trigger its own state machine event
        else
        {
            ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN playbackState, IN metadata, IN metadata, IN metadata, IN metadata,IN ObjectID);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                parameterString[0] = '\0';
            }

            ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::StartStopStreaming()
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    /* For CDDA no need to stop streaming
     * Send STOP_STREAMING_ANSWER message to release own waiting state */
    ret = ParameterSTOP_STREAMING_ANSWER(OUT parameterString, IN size, IN deviceID);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(STOP_STREAMING_ANSWER, IN parameterString);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::StopStreamingAnswer(tDeviceID deviceID)
{
    ENTRY
    (void)deviceID;
    tPEPlaybackState playbackState = PE_PBS_STOPPEDSTATE;
    m_bVideoStreaming = false;
    /* Send answer to waiting state machine */
    if( LocalSPM::GetDataProvider().UseMediaEngine() )
    {
        m_Mutex.lock();
        tPEHandle handle = (tPEHandle)m_PlayMediaObject.objectID;
        m_Mutex.unlock();

        PlaybackStatusNew(IN handle, IN playbackState, IN REASON_OK, IN ME_SPEED_NORMAL);
    }
    else
    {
        tMetadata metadata = { 0 };

        PlaybackStatus(IN playbackState, IN metadata, IN metadata, IN metadata, IN metadata);
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::StartPlay(const tDeviceType deviceType,
        const tDeviceID deviceID,
        const tURL URL,
        const tMountPoint mountPoint,
        const tUUID uuid,
        const tPEHandle handle,
        const tPlaytime position,
        const tStreaming streaming)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);
    (void)uuid;
    VARTRACE(handle);
    VARTRACE(position);
    VARTRACE(streaming);

    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tPEHandle handleNew = 0;
    tPEPlaybackState playbackState = tPEPlaybackState::PE_PBS_LOADINGSTATE;
    me::reason_e reason =me::reason_e::REASON_OK;
    me::speed_e speed = (me::speed_e)0;
    tResult ret;
    /* Update media object to play */
    m_Mutex.lock();
    InitMediaObject(OUT m_PlayMediaObject);
    m_PlayMediaObject.objectID = (tObjectID)handle;
    m_PlayMediaObject.deviceID = deviceID;
    strncpy_r(OUT m_PlayMediaObject.fileName, IN URL, IN sizeof(m_PlayMediaObject.fileName));
    strncpy_r(OUT m_PlayMediaObject.mountPoint, IN mountPoint, IN sizeof(m_PlayMediaObject.mountPoint));
    m_Mutex.unlock();

    m_StartPosition = position;

    /* Put complete path together (mount point + relative path of the URL)*/
    tURL mountPointURL;
    memset(mountPointURL,0x00,sizeof(tURL));
    if(m_bIsDVDControlActive == false)
    {
        m_bIsDVDControlActive = true;
        m_bSendSourceSwitchNowPlayingUpdate = true;
        m_pDVDControlInterface->setDeviceActive(true ,LocalSPM::GetDataProvider().SetFPGARegistryforDVD());
        ETG_TRACE_USR4(("DEVICE : DVD Activated"));
        //Check if Drive is already in backend mode , i.e playback can happen else do a switch

        // m_pDVDControlInterface->SwitchtoBackendMode();


    }
    else if(m_bIsDVDControlActive == true && m_bSourceStatePause == true)
    {
        //if startplay comes after startpause , check for the url - if url is different play from beginning
        if(strcmp(m_Url,URL) != 0)
        {
            VARTRACE(URL);
            VARTRACE(m_Url);
            strncpy_r(OUT mountPointURL, IN mountPoint, IN sizeof(mountPointURL));
            strncat_r(OUT mountPointURL, IN URL, IN sizeof(mountPointURL));
            m_bPlayfromPause = true; //set false in forwardnowplayingstatus
        }
        m_bSendSourceSwitchNowPlayingUpdate = true;
        m_bSourceStatePause = false;
    }
    else
    {
        strncpy_r(OUT mountPointURL, IN mountPoint, IN sizeof(mountPointURL));
        strncat_r(OUT mountPointURL, IN URL, IN sizeof(mountPointURL));
    }

    ret = ParameterPLAY_ANSWER(OUT parameterString, IN size, IN handleNew, IN playbackState, IN reason, IN speed);
    if(IsInState(Ripping)== 1)
    {
        //ret = SendEvent(PLAY_ANSWER, IN parameterString);
        PlaybackStatusNew(handleNew,playbackState,reason,speed);
    }
    /* @@@ read metadata */

    /* Send METADATA_FOR_PLAYBACK message to own SM */

    ret = ParameterMETADATA_FOR_PLAYBACK(OUT parameterString, IN size, IN handle, IN mountPointURL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(METADATA_FOR_PLAYBACK, IN parameterString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::StartPlayWithMetadata(const tPEHandle handle, const tURL mountPointURL)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(mountPointURL);

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();
    tObjectID objectID = m_PlayMediaObject.objectID;
    tNotPlayable notPlayable = m_PlayMediaObject.notPlayable;
    m_Mutex.unlock();

    if((tObjectID)handle != objectID)
    {
        ETG_TRACE_ERR(("Received metadata of wrong object (objectID (received/expected):%u/%u)", (tObjectID)handle, objectID));

        /* Send action error to own state machine */
        ActionError(REASON_ERROR);
        return MP_NO_ERROR;
    }

    /* In case of file is DRM protected send action error */
    if(FNP_DRM_PROTECTED == notPlayable)
    {
        ETG_TRACE_ERR(("Skip playback of file since it is DRM protected (%s)", mountPointURL));

        /* Send action error to own state machine */
        ActionError(REASON_DRM_ERROR);
        return MP_NO_ERROR;
    }
    else if(FNP_PLAY_RESTRICTION == notPlayable)
    {
        ETG_TRACE_ERR(("Skip playback of file since it is Codec restricted (%s)", mountPointURL));

        /* Send action error to own state machine */
        ActionError(REASON_CODEC_ERROR);
        return MP_NO_ERROR;
    }
    else if(FNP_FORMAT_ERROR == notPlayable)
    {
        ETG_TRACE_ERR(("Skip playback of file since it is not readable (%s)", mountPointURL));

        /* Send action error to own state machine */
        ActionError(REASON_FORMAT_ERROR);
        return MP_NO_ERROR;
    }
    else
    {
        if(m_pDVDControlInterface != NULL)
        {
            /* start play for this song */
            m_pDVDControlInterface->play(IN mountPointURL, IN (me::speed_e)1, IN m_StartPosition, IN handle);
        }
        /* Send event to own waiting state machine */
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        tPEHandle handleNew = 0;
        tPEPlaybackState playbackState = tPEPlaybackState::PE_PBS_LOADINGSTATE;
        me::reason_e reason =me::reason_e::REASON_OK;
        me::speed_e speed = (me::speed_e)0;
        if(m_pDVDControlInterface != NULL)
        {
            m_pDVDControlInterface->getParameter(OUT handleNew, OUT playbackState, OUT reason, OUT speed);
        }
        if(LocalSPM::GetDataProvider().UseMediaEngine())
        {
            if(IsVideoDisc( mDeviceInfo.discType) && m_bVideoStreaming == false )
            {
                LocalSPM::GetOutputWrapper().UpdateDVDVideoSourceStatus(true);
            }

            /* Fake MediaEngine response: PLAY_ANSWER */
            ret = ParameterPLAY_ANSWER(OUT parameterString, IN size, IN handleNew, IN playbackState, IN reason, IN speed);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                parameterString[0] = '\0';
            }

            ret = SendEvent(PLAY_ANSWER, IN parameterString);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
        else
        {
            /* Fake PlayerEngine response: PLAYBACK_STATUS_RESPONSE */
            tMetadata metadata = { 0 };

            tObjectID ObjectID = OBJECT_ID_NONE;
            ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN playbackState, IN metadata, IN metadata, IN metadata, IN metadata,IN ObjectID);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                parameterString[0] = '\0';
            }

            ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::StartStop(const tDeviceType deviceType,
        const tDeviceID deviceID,
        const tURL URL,
        const tMountPoint mountPoint)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);

    tResult ret = MP_NO_ERROR;
    //If in state ripping stop streaming, startstop from state ripping
    if(IsInState(Ripping) != 1)
    {
        if(m_pDVDControlInterface != NULL)
        {
            m_pDVDControlInterface->pause();
        }

        LocalSPM::GetOutputWrapper().UpdateDVDVideoSourceStatus(false); //Irrespective of videoStreaming status DVD Video Source unavailability is updated to VideoManager
        if((LocalSPM::GetDataProvider().UseMediaEngine()) && (m_bVideoStreaming == true))
        {

            m_bVideoStreaming = false;
            ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::STOP", NULL, "DVDControlSM::STOP_ANSWER");
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
            }

        }
        else
        {
            /* fake STOP_ANSWER */
            ret = SendEvent(STOP_ANSWER, NULL); // internal event
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    else
    {
        StopStreamingAnswer(deviceID);
    }
    /* Reset media object to play */
    ETG_TRACE_USR3(("Reset media object to play"));
    m_Mutex.lock();
    InitMediaObject(OUT m_PlayMediaObject);
    m_Mutex.unlock();
    m_bIsDVDControlActive = false;
    m_pDVDControlInterface->setDeviceActive(false);
    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::StartPause(const tDeviceType deviceType,
        const tDeviceID deviceID,
        const tURL URL,
        const tMountPoint mountPoint)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);

    tResult ret = MP_NO_ERROR;
    /* Send event to own waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tPEHandle handle = 0;
    tPEPlaybackState playbackState = PE_PBS_PAUSEDSTATE;
    me::reason_e reason =me::reason_e::REASON_OK;
    me::speed_e speed = (me::speed_e)0;
    // If in state ripping , currently respond to waiting state machine that StartPause is success
    // call playbackstatusnew
    if(IsInState(Ripping)== 1)
    {
        ETG_TRACE_USR4(("In state ripping , currently respond to waiting state machine that StartPause is success"));
        PlaybackStatusNew(handle,playbackState,reason,speed);
    }
    else
    {
        m_bSourceStatePause = true;
        strncpy_r(OUT m_Url, IN URL, IN sizeof(m_Url));

        if(m_pDVDControlInterface != NULL)
        {
            m_pDVDControlInterface->pause();
        }
        if(m_pDVDControlInterface != NULL)
        {
            m_pDVDControlInterface->getParameter(OUT handle, OUT playbackState, OUT reason, OUT speed);
        }
        if(LocalSPM::GetDataProvider().UseMediaEngine())
        {
            /* Fake MediaEngine response: PAUSE_ANSWER */
            ret = ParameterPAUSE_ANSWER(OUT parameterString, IN size, IN handle, IN playbackState, IN reason, IN speed);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                parameterString[0] = '\0';
            }

            ret = SendEvent(PAUSE_ANSWER, IN parameterString);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
        else
        {
            /* Fake PlayerEngine response: PLAYBACK_STATUS_RESPONSE */
            tMetadata metadata = { 0 };

            tObjectID ObjectID = OBJECT_ID_NONE;
            ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN playbackState, IN metadata, IN metadata, IN metadata, IN metadata,IN ObjectID);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                parameterString[0] = '\0';
            }

            ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::StartResume(const tDeviceType deviceType,
        const tDeviceID deviceID,
        const tURL URL,
        const tMountPoint mountPoint)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);

    tResult ret = MP_NO_ERROR;
    if(m_pDVDControlInterface != NULL)
    {
        m_pDVDControlInterface->resume();
    }
    /* Send event to own waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tPEHandle handle = 0;
    tPEPlaybackState playbackState = tPEPlaybackState::PE_PBS_PLAYINGSTATE;
    me::reason_e reason =me::reason_e::REASON_OK;
    me::speed_e speed = (me::speed_e)0;
    if(m_pDVDControlInterface != NULL)
    {
        m_pDVDControlInterface->getParameter(OUT handle, OUT playbackState, OUT reason, OUT speed);
    }
    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Fake MediaEngine response: RESUME_ANSWER */
        ret = ParameterRESUME_ANSWER(OUT parameterString, IN size, IN handle, IN playbackState, IN reason, IN speed);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(RESUME_ANSWER, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Fake PlayerEngine response: PLAYBACK_STATUS_RESPONSE */
        tMetadata metadata = { 0 };

        tObjectID ObjectID = OBJECT_ID_NONE;
        ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN playbackState, IN metadata, IN metadata, IN metadata, IN metadata,IN ObjectID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

/* Convert the playback spped to Speed1 , speed2 and speed3 equivalent of dvd drive specification*/
/* dvd supports totally 3 speed formats in slow fwd and 3 speed formats in fast forward which takes the value 1,2,and 3 resp */
bool DVDControl::ConvertSpeedFormat(tPlaybackSpeed rate,tCueingRate& convertedRate)
{
    bool slowSpeed = false;
    switch(rate)
    {
        case PBK_SPEED_0_2X:
            convertedRate = 1;
            slowSpeed = true;
            break;
        case PBK_SPEED_0_5X:
            convertedRate = 2;
            slowSpeed = true;
            break;
        case PBK_SPEED_2X:
            convertedRate = 1;
            break;
        case PBK_SPEED_4X:
            convertedRate = 2;
            break;
        case PBK_SPEED_8X:
            convertedRate = 3;
            break;
        case PBK_SPEED_16X:
            convertedRate = 3;
            break;
        case PBK_SPEED_32X:
            convertedRate = 3;
            break;
        default:
            convertedRate = 0;
            break;
    }
    return slowSpeed;
}
bool DVDControl::ConvertSpeedFormat(tCueingRate rate,tCueingRate& convertedRate)
{

    bool slowSpeed = false;
    switch(rate)
    {
        case 200:
            convertedRate = 1;
            slowSpeed = true;
            break;
        case 500:
            convertedRate = 2;
            slowSpeed = true;
            break;
        case 1000:
            convertedRate = 0;
            break;
        case 2000:
            convertedRate = 1;
            break;
        case 4000:
            convertedRate = 2;
            break;
        case 8000:
            convertedRate = 3;
            break;
        case 16000:
            convertedRate = 3;
            break;
        case 32000:
            convertedRate = 3;
            break;
        default:
            convertedRate = 0;
            break;
    }
    return slowSpeed;
}
tResult DVDControl::StartFfwdStart(const tDeviceType deviceType,
        const tDeviceID deviceID,
        const tURL URL,
        const tMountPoint mountPoint,
        const tCueingRate rate,
        const speedstate_e IsPlaybackSpeed)
{
    ENTRY
    (void)IsPlaybackSpeed;
    VARTRACE4(deviceType, deviceID, URL, mountPoint);
    VARTRACE(rate);

    tResult ret = MP_NO_ERROR;

    tCueingRate converted_rate = 0;
    bool slowForward = ConvertSpeedFormat(rate,converted_rate);
    if(m_pDVDControlInterface != NULL)
    {
        if(slowForward)
        {
            m_pDVDControlInterface->sfwdStart(converted_rate);
        }
        else
        {
            m_pDVDControlInterface->ffwdStart(converted_rate);
        }
    }
    /* Send event to own waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tPEHandle handle = 0;
    tPEPlaybackState playbackState = tPEPlaybackState::PE_PBS_FASTFORWARDSTATE;
    me::reason_e reason =me::reason_e::REASON_OK;
    me::speed_e speed = (me::speed_e)0;
    if(m_pDVDControlInterface != NULL)
    {
        m_pDVDControlInterface->getParameter(OUT handle, OUT playbackState, OUT reason, OUT speed);
    }
    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Fake MediaEngine response: FFWD_ANSWER */
        ret = ParameterFFWD_ANSWER(OUT parameterString, IN size, IN handle, IN playbackState, IN reason, IN speed);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(FFWD_ANSWER, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Fake PlayerEngine response: PLAYBACK_STATUS_RESPONSE */
        tMetadata metadata = { 0 };

        tObjectID ObjectID = OBJECT_ID_NONE;
        ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN playbackState, IN metadata, IN metadata, IN metadata, IN metadata,IN ObjectID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::StartFfwdStop(const tDeviceType deviceType,
        const tDeviceID deviceID,
        const tURL URL,
        const tMountPoint mountPoint)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);

    tResult ret = MP_NO_ERROR;
    if(m_pDVDControlInterface != NULL)
    {
        m_pDVDControlInterface->ffwdStop();
    }
    /* Send event to own waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tPEHandle handle = 0;
    tPEPlaybackState playbackState = tPEPlaybackState::PE_PBS_PLAYINGSTATE;
    me::reason_e reason =me::reason_e::REASON_OK;
    me::speed_e speed = (me::speed_e)0;
    if(m_pDVDControlInterface != NULL)
    {
        m_pDVDControlInterface->getParameter(OUT handle, OUT playbackState, OUT reason, OUT speed);
    }
    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Fake MediaEngine response: FFWD_STOP_ANSWER */
        ret = ParameterFFWD_STOP_ANSWER(OUT parameterString, IN size, IN handle, IN playbackState, IN reason, IN speed);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(FFWD_STOP_ANSWER, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Fake PlayerEngine response: PLAYBACK_STATUS_RESPONSE */
        tMetadata metadata = { 0 };

        tObjectID ObjectID = OBJECT_ID_NONE;
        ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN playbackState, IN metadata, IN metadata, IN metadata, IN metadata,IN ObjectID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::StartFrevStart(const tDeviceType deviceType,
        const tDeviceID deviceID,
        const tURL URL,
        const tMountPoint mountPoint,
        const tCueingRate rate,
        const speedstate_e IsPlaybackSpeed)
{
    ENTRY
    (void)IsPlaybackSpeed;

    VARTRACE4(deviceType, deviceID, URL, mountPoint);
    VARTRACE(rate);

    tResult ret = MP_NO_ERROR;

    tCueingRate converted_rate = 0;
    bool slowReverse= ConvertSpeedFormat(rate,converted_rate);
    if(m_pDVDControlInterface != NULL)
    {
        if(slowReverse)
        {
            m_pDVDControlInterface->srevStart(converted_rate);
        }
        else
        {
            m_pDVDControlInterface->frevStart(converted_rate);
        }
    }
    /* Send event to own waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tPEHandle handle = 0;
    tPEPlaybackState playbackState = tPEPlaybackState::PE_PBS_FASTREVERSESTATE;
    me::reason_e reason =me::reason_e::REASON_OK;
    me::speed_e speed = (me::speed_e)0;
    if(m_pDVDControlInterface != NULL)
    {
        m_pDVDControlInterface->getParameter(OUT handle, OUT playbackState, OUT reason, OUT speed);
    }
    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Fake MediaEngine response: FREV_ANSWER */
        ret = ParameterFREV_ANSWER(OUT parameterString, IN size, IN handle, IN playbackState, IN reason, IN speed);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(FREV_ANSWER, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Fake PlayerEngine response: PLAYBACK_STATUS_RESPONSE */
        tMetadata metadata = { 0 };

        tObjectID ObjectID = OBJECT_ID_NONE;
        ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN playbackState, IN metadata, IN metadata, IN metadata, IN metadata,IN ObjectID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::StartFrevStop(const tDeviceType deviceType,
        const tDeviceID deviceID,
        const tURL URL,
        const tMountPoint mountPoint)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);

    tResult ret = MP_NO_ERROR;
    if(m_pDVDControlInterface != NULL)
    {
        m_pDVDControlInterface->frevStop();
    }
    /* Send event to own waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tPEHandle handle = 0;
    tPEPlaybackState playbackState = tPEPlaybackState::PE_PBS_PLAYINGSTATE;
    me::reason_e reason =me::reason_e::REASON_OK;
    me::speed_e speed = (me::speed_e)0;
    if(m_pDVDControlInterface != NULL)
    {
        m_pDVDControlInterface->getParameter(OUT handle, OUT playbackState, OUT reason, OUT speed);
    }
    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Fake MediaEngine response: FREV_STOP_ANSWER */
        ret = ParameterFREV_STOP_ANSWER(OUT parameterString, IN size, IN handle, IN playbackState, IN reason, IN speed);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(FREV_STOP_ANSWER, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Fake PlayerEngine response: PLAYBACK_STATUS_RESPONSE */
        tMetadata metadata = { 0 };

        tObjectID ObjectID = OBJECT_ID_NONE;
        ret = ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size, IN playbackState, IN metadata, IN metadata, IN metadata, IN metadata,IN ObjectID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendEvent(PLAYBACK_STATUS_RESPONSE, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::StartSeekTo(const tDeviceType deviceType,
        const tDeviceID deviceID,
        const tURL URL,
        const tMountPoint mountPoint,
        const tPlaytime position)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);
    VARTRACE(position);

    tResult ret = MP_NO_ERROR;
    if(m_pDVDControlInterface != NULL)
    {
        m_pDVDControlInterface->seek((me::speed_e)1, position);
    }
    /* Fake response: SEEK_TO_ANSWER */
    m_Mutex.lock();
    tPEHandle handle = (tPEHandle)m_PlayMediaObject.objectID;
    m_Mutex.unlock();

    tPETimeInfoStruct timeInfoStruct;
    InitPETimeInfoStruct(timeInfoStruct);
    timeInfoStruct.position.ms = (tPEMilliseconds)position;
    timeInfoStruct.duration.ms = (tPEMilliseconds)PLAYTIME_NONE;

    /* Marshal struct of timeInfo into a string */
    tPETimeInfo timeInfoString;
    size_t size = sizeof(timeInfoString);
    SMF::Marshal(OUT timeInfoString,
            IN size-1,
            IN DOUBLE_MARSHAL_SEPARATOR,
            IN tPEBytes_format tPEPercentage_format tPEMilliseconds_format tPEBytes_format tPEMilliseconds_format,
            IN timeInfoStruct.position.bytes,
            IN timeInfoStruct.position.pct,
            IN timeInfoStruct.position.ms,
            IN timeInfoStruct.duration.bytes,
            IN timeInfoStruct.duration.ms);

    /* Send SEEK_TO_ANSWER event to own waiting state machine */
    tAllParameters parameterString;
    size = sizeof(parameterString);
    ret = ParameterSEEK_TO_ANSWER(OUT parameterString, size, IN handle, IN timeInfoString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(SEEK_TO_ANSWER, IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::StartBuffer(const tDeviceType deviceType,
        const tDeviceID deviceID,
        const tURL URL,
        const tMountPoint mountPoint,
        const tPEHandle handle)
{
    ENTRY
    VARTRACE4(deviceType, deviceID, URL, mountPoint);
    VARTRACE(handle);

    //@@@ code?

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::DiscardBuffer()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    //@@ code??

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return ret;
}

tResult DVDControl::ActionStatus(const tReturnValue returnValue)
{
    ENTRY
    (void)returnValue;

    tResult ret = MP_NO_ERROR;

    ret = SendAnswer(NULL);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::BufferStatus(const tSuccess success)
{
    ENTRY
    VARTRACE(success);

    tResult ret = MP_NO_ERROR;

    /* Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

#if 0
    /* map reason to success */
    tSuccess success = SC_NO;
    if (reason >= REASON_OK) {
        success = SC_YES;
    }
#endif

    ret = LocalSPM::GetPlayerManager().ParameterBUFFER_ANSWER(OUT parameterString, IN size, IN success);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::PlaybackStatus(const tPEPlaybackState status,
        const tMetadata metadata1,
        const tMetadata metadata2,
        const tMetadata metadata3,
        const tMetadata metadata4,
        const tObjectID ObjectID)
{
    ENTRY
    VARTRACE6(status, metadata1, metadata2, metadata3, metadata4, MTY_UNKNOWN);

    tResult ret = MP_NO_ERROR;
    m_Mutex.lock();
    tMediaObject mediaObject =  m_PlayMediaObject;
    m_Mutex.unlock();

    /* Send answer to waiting state machine */
    if( PE_PBS_ERRORSTATE == status )
    {
        /* Validate error code */
        me::reason_e reason;
        ret = ValidateErrorCode(OUT reason, IN metadata2, IN mediaObject.mountPoint);

        /* Send action error instead of answer to waiting state machine */
        HandleActionError(IN reason);
    }
    else
    {
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = LocalSPM::GetDeviceDispatcher().ParameterPLAY_ANSWER(OUT parameterString,
                IN size,
                IN status,
                IN mediaObject.MetadataField1,
                IN mediaObject.MetadataField2,
                IN mediaObject.MetadataField3,
                IN mediaObject.MetadataField4,
                IN mediaObject.title,
                IN mediaObject.mediaType,
                IN mediaObject.metadataConvertFlag,
                IN mediaObject.UUID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendAnswer(IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::ForwardPlaybackStatus(const tPEPlaybackState status,
        const tMetadata metadata1,
        const tMetadata metadata2,
        const tMetadata metadata3,
        const tMetadata metadata4,
        const tObjectID ObjectID)
{
    ENTRY
    VARTRACE6(status, metadata1, metadata2, metadata3, metadata4, MTY_UNKNOWN);

    tResult ret = MP_NO_ERROR;
    m_Mutex.lock();
    tMediaObject mediaObject =  m_PlayMediaObject;
    m_Mutex.unlock();

    if( PE_PBS_ERRORSTATE == status )
    {
        /* Validate error code */
        me::reason_e reason;
        ret = ValidateErrorCode(OUT reason, IN metadata2, IN mediaObject.mountPoint);

        /* Forward stream error */
        ForwardStreamError(IN reason);
    }
    else
    {
        /* Send PLAYBACK_STATUS_RESPONSE message to PlayerManger to update playback state */
        char messageString[64];
        strncpy_r(OUT messageString, IN "PlayerManagerSM::PLAYBACK_STATUS_RESPONSE", IN sizeof(messageString));

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        tObjectID ObjectID = OBJECT_ID_NONE;

        ret = LocalSPM::GetPlayerManager().ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString,
                IN size,
                IN status,
                IN mediaObject.MetadataField1,
                IN mediaObject.MetadataField2,
                IN mediaObject.MetadataField3,
                IN mediaObject.MetadataField4,
                IN mediaObject.title,
                IN mediaObject.mediaType,
                IN mediaObject.metadataConvertFlag,
                IN mediaObject.UUID,
                IN ObjectID);

        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult DVDControl::PlaytimeStatus(const tPlaytime elapsedPlaytime, const tPlaytime totalPlaytime)
{
    ENTRY
    VARTRACE2(elapsedPlaytime, totalPlaytime);

#if 0
    tResult ret = MP_NO_ERROR;

    /* Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetPlayerManager().ParameterSEEK_TO_ANSWER(OUT parameterString, IN size, IN elapsedPlaytime, IN totalPlaytime);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }
#else
    m_Mutex.lock();
    tPEHandle handle = (tPEHandle)m_PlayMediaObject.objectID;
    m_Mutex.unlock();

    tPETimeInfoStruct timeInfoStruct;
    InitPETimeInfoStruct(timeInfoStruct);
    timeInfoStruct.position.ms = (tPEMilliseconds)elapsedPlaytime;
    timeInfoStruct.duration.ms = (tPEMilliseconds)totalPlaytime;

    /* Marshal struct of timeInfo into a string */
    tPETimeInfo timeInfoString;
    size_t size = sizeof(timeInfoString);
    SMF::Marshal(OUT timeInfoString,
            IN size-1,
            IN DOUBLE_MARSHAL_SEPARATOR,
            IN tPEBytes_format tPEPercentage_format tPEMilliseconds_format tPEBytes_format tPEMilliseconds_format,
            IN timeInfoStruct.position.bytes,
            IN timeInfoStruct.position.pct,
            IN timeInfoStruct.position.ms,
            IN timeInfoStruct.duration.bytes,
            IN timeInfoStruct.duration.ms);

    PlaytimeStatusNew(IN handle, IN timeInfoString);
#endif

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::ForwardPlaytimeStatus(const tPlaytime elapsedPlaytime, const tPlaytime totalPlaytime)
{
    ENTRY
    VARTRACE2(elapsedPlaytime, totalPlaytime);

    tResult ret = MP_NO_ERROR;

#if 0
    /* Send TICK_TIME_ELAPSED message to PlayerManger to update playtime */
    char messageString[64];
    strncpy_r(OUT messageString, IN "PlayerManagerSM::TICK_TIME_ELAPSED", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetPlayerManager().ParameterTICK_TIME_ELAPSED(OUT parameterString, IN size, IN elapsedPlaytime, IN totalPlaytime);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }
#else
    m_Mutex.lock();
    tPEHandle handle = (tPEHandle)m_PlayMediaObject.objectID;
    m_Mutex.unlock();

    tPETimeInfoStruct timeInfoStruct;
    InitPETimeInfoStruct(timeInfoStruct);
    timeInfoStruct.position.ms = (tPEMilliseconds)elapsedPlaytime;
    timeInfoStruct.duration.ms = (tPEMilliseconds)totalPlaytime;

    /* Marshal struct of timeInfo into a string */
    tPETimeInfo timeInfoString;
    size_t size = sizeof(timeInfoString);
    SMF::Marshal(OUT timeInfoString,
            IN size-1,
            IN DOUBLE_MARSHAL_SEPARATOR,
            IN tPEBytes_format tPEPercentage_format tPEMilliseconds_format tPEBytes_format tPEMilliseconds_format,
            IN timeInfoStruct.position.bytes,
            IN timeInfoStruct.position.pct,
            IN timeInfoStruct.position.ms,
            IN timeInfoStruct.duration.bytes,
            IN timeInfoStruct.duration.ms);

    ret = ForwardPlaytimeStatusNew(IN handle, IN timeInfoString);
#endif

    return ret;
}

tResult DVDControl::HandleActionError(const me::reason_e reason)
{
    ENTRY_INTERNAL

    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    /* Send action error instead of answer to waiting state machine */
    ret = LocalSPM::GetDeviceDispatcher().ParameterACTION_ERROR(OUT parameterString, IN size, IN reason);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendActionError(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending action error via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult DVDControl::ActionError(const me::reason_e reason)
{
    ENTRY_INTERNAL

    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    /* Send action error to own state machine*/
    ret = ParameterACTION_ERROR(OUT parameterString, IN size, IN reason);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(ACTION_ERROR ,IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending action error via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult DVDControl::ForwardStreamError(const me::reason_e reason) const
{
    ENTRY_INTERNAL

    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    /* Send STREAM_ERROR message to PlayerManger */
    char messageString[64];
    strncpy_r(OUT messageString, IN "PlayerManagerSM::STREAM_ERROR", IN sizeof(messageString));

    ret = LocalSPM::GetPlayerManager().ParameterSTREAM_ERROR(OUT parameterString, IN size, IN reason);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult DVDControl::PlaybackStatusNew(const tPEHandle handle, const tPEPlaybackState playbackState, const me::reason_e reason, const me::speed_e speed)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(playbackState);
    VARTRACE(reason);
    VARTRACE(speed);

    tResult ret = MP_NO_ERROR;

    if(REASON_OK > reason)
    {
        /* Send action error instead of answer to waiting state machine */
        HandleActionError(IN reason);
    }
    else
    {
        /* Send answer to waiting state machine */
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        ret = LocalSPM::GetDeviceDispatcher().ParameterPLAY_ANSWER_NEW(OUT parameterString, IN size, IN handle, IN playbackState, IN reason, IN speed);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = SendAnswer(IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::ForwardPlaybackStatusNew(const tPEHandle handle, const tPEPlaybackState playbackState, const me::reason_e reason, const me::speed_e speed)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(playbackState);
    VARTRACE(reason);
    VARTRACE(speed);

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();
    tObjectID objectID = m_PlayMediaObject.objectID;
    m_Mutex.unlock();

    if(((tObjectID)handle != objectID)
            &&
            (PE_PBS_STOPPEDSTATE != playbackState))
    {
        ETG_TRACE_ERR(("Obsolete playback status -> Do not forward objectID:%u", (tObjectID)handle));
    }
    else
    {
        //Remark: Interpretation of non error reasons is done in PlayerManager::ForwardPlaybackStatusNew
        if(REASON_OK > reason)
        {
            /* Forward stream error */
            ForwardStreamError(IN reason);
        }
        else
        {
            /* Send PLAYBACK_STATUS message to PlayerManger to update playback status */
            char messageString[64];
            strncpy_r(OUT messageString, IN "PlayerManagerSM::PLAYBACK_STATUS", IN sizeof(messageString));
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);

            ret = LocalSPM::GetPlayerManager().ParameterPLAYBACK_STATUS(OUT parameterString, IN size, IN handle, IN playbackState, IN reason, IN speed);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                parameterString[0] = '\0';
            }

            ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    return ret;
}

tResult DVDControl::ForwardNowPlayingStatus(const tPEHandle handle, const tURL mountPointURL)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(mountPointURL);

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();
    tMediaObject mediaObject = m_PlayMediaObject;
    m_Mutex.unlock();

    if((tObjectID)handle != mediaObject.objectID)
    {
        if( !LocalSPM::GetDataProvider().GaplessPlay() )
        {
            ETG_TRACE_ERR(("Obsolete nowPlaying status -> Do not forward objectID:%u", (tObjectID)handle));
        }
        else
        {
            ETG_TRACE_USR1(("Received nowPlaying status of a new object (objectID (received/last):%u/%u)", (tObjectID)handle, mediaObject.objectID));

            //@@@ code?? : get metadata from current track from toc
        }
    }
    else
    {
        /* Send NOW_PLAYING_STATUS message to PlayerManger to update nowPlaying info of object */
        char messageString[64];
        strncpy_r(OUT messageString, IN "PlayerManagerSM::NOW_PLAYING_STATUS", IN sizeof(messageString));
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        // Fill in the metadata information //

        tPEHandle currentHandle = handle ;

        if(mDeviceInfo.discType == DISC_AUDIO_CD)
        {
            currentHandle = (tPEHandle)mtocData.trackNumber;

        }
        // to prevent FillupMetaDataIDs from DB for syncing , this uses VT table and not mediaobject table
        mediaObject.mediaType = MTY_AUDIO_STREAM;
        ret = LocalSPM::GetPlayerManager().ParameterNOW_PLAYING_STATUS(OUT parameterString,
                IN size,
                IN currentHandle,
                IN mtocData.metaData1,
                IN mtocData.metaData2,
                IN mtocData.metaData3,
                IN mtocData.metaData4,
                IN mtocData.metaData3,
                IN mediaObject.mediaType,
                IN mediaObject.bitRate,
                IN mediaObject.sampleRate,
                IN mediaObject.audioChannelFormat,
                IN mediaObject.metadataConvertFlag,
                IN NULL,
                IN NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
        //if play comes after pause in one track play - trigger play
        if(m_bPlayfromPause == true)
        {
            tURL emptyURL = {0x00};
            m_pDVDControlInterface->play(emptyURL,(speed_e)1,m_StartPosition,m_PlayMediaObject.objectID );
            VARTRACE(mountPointURL);
            m_bPlayfromPause = false;
        }
    }

    return ret;
}

tResult DVDControl::ForwardNowPlayingStatusWithMetadata(const tPEHandle handle, const tURL mountPointURL)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(mountPointURL);

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();
    tMediaObject mediaObject = m_PlayMediaObject;
    m_Mutex.unlock();

    if((tObjectID)handle != mediaObject.objectID)
    {
        ETG_TRACE_ERR(("Received metadata of wrong object (objectID (received/expected):%u/%u)", (tObjectID)handle, mediaObject.objectID));
        return MP_NO_ERROR;
    }

    /* Send NOW_PLAYING_STATUS message to PlayerManger to update nowPlaying info of object */
    char messageString[64];
    strncpy_r(OUT messageString, IN "PlayerManagerSM::NOW_PLAYING_STATUS", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);


    tPEHandle currentHandle = handle ;

    if(mDeviceInfo.discType == DISC_AUDIO_CD)
    {
        currentHandle = (tPEHandle)mtocData.trackNumber;
    }
    // to prevent FillupMetaDataIDs from DB for syncing , this uses VT table and not mediaobject table
    mediaObject.mediaType = MTY_AUDIO_STREAM;
    ret = LocalSPM::GetPlayerManager().ParameterNOW_PLAYING_STATUS(OUT parameterString,
            IN size,
            IN currentHandle,
            IN mtocData.metaData1,
            IN mtocData.metaData2,
            IN mtocData.metaData3,
            IN mtocData.metaData4,
            IN mtocData.metaData3,
            IN mediaObject.mediaType,
            IN mediaObject.bitRate,
            IN mediaObject.sampleRate,
            IN mediaObject.audioChannelFormat,
            IN mediaObject.metadataConvertFlag,
            IN NULL,
            IN NULL);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult DVDControl::PlaytimeStatusNew(const tPEHandle handle, const tPETimeInfo timeInfo)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(timeInfo);

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();
    tDeviceID deviceID = m_PlayMediaObject.deviceID;
    m_Mutex.unlock();

    /* Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tPEHandle currentHandle = handle ;

    if(mDeviceInfo.discType == DISC_AUDIO_CD)
    {
        currentHandle = (tPEHandle)mtocData.trackNumber;
    }

    ret = LocalSPM::GetDeviceDispatcher().ParameterPLAYTIME_STATUS(OUT parameterString, IN size, IN currentHandle, IN deviceID, IN timeInfo);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::ForwardPlaytimeStatusNew(const tPEHandle handle, const tPETimeInfo timeInfo)
{
    ENTRY
    VARTRACE(handle);
    VARTRACE(timeInfo);

    tResult ret = MP_NO_ERROR;

    m_Mutex.lock();
    tObjectID objectID = m_PlayMediaObject.objectID;
    tDeviceID deviceID = m_PlayMediaObject.deviceID;
    m_Mutex.unlock();

    if ((tObjectID)handle != objectID)
    {
        ETG_TRACE_ERR(("Obsolete playtime status -> Do not forward objectID:%u", (tObjectID)handle));
    }
    else
    {
        /* Send PLAYTIME_STATUS message to PlayerManger to update playtime */
        char messageString[64];
        strncpy_r(OUT messageString, IN "PlayerManagerSM::PLAYTIME_STATUS", IN sizeof(messageString));
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        tPEHandle currentHandle = handle ;

        if(mDeviceInfo.discType == DISC_AUDIO_CD)
        {
            currentHandle = (tPEHandle)mtocData.trackNumber;
        }
        ret = LocalSPM::GetPlayerManager().ParameterPLAYTIME_STATUS(OUT parameterString, IN size, IN currentHandle, IN deviceID, IN timeInfo);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }

        ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult DVDControl::HandleAnswerTimeout()
{
    ENTRY
    ETG_TRACE_ERR(("DVDControl::HandleAnswerTimeout"));

    tResult ret = MP_NO_ERROR;

    /* Send releasing event to own waiting state machine */
    ret = ReleaseWaiting();
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while releasing waiting via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult DVDControl::MessageNotConsumed()
{
    ENTRY
    ETG_TRACE_ERR(("DVDControl::MessageNotConsumed"));
#if 0 //Do not SendAnswer without reason, it may cause failure within communication to DeviceDispatcher
    /* Send answer to possible waiting state machine to release own SM in case of message answer pair*/
    tResult ret = SendAnswer(NULL);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }
#endif
    return MP_NO_ERROR;
}

tResult DVDControl::ValidateErrorCode(me::reason_e &reason, const tMetadata errorCode, const tMountPoint mountPoint) const
{
    ENTRY_INTERNAL

    tUInt errorEnum = atoi(errorCode);

    switch(errorEnum)
    {
        case MEDIAPLAYER_ERROR_DEVICE_NOT_FOUND:
        case MEDIAPLAYER_ERROR_AUDIO_DEVICE_ALREADY_IN_USE:
            reason = REASON_DEVICE_ERROR;
            break;
        case MEDIAPLAYER_ERROR_FILE_DOES_NOT_EXISTS:
        case MEDIAPLAYER_ERROR_CANNOT_DECODE_MEDIA:
        case MEDIAPLAYER_ERROR_UNKNOWN_ERROR:
        default:
            reason = REASON_FORMAT_ERROR;
            break;
    }
    return MP_NO_ERROR;
}

tResult DVDControl::SetOutputDevice(const tAudioOutputDevice audioOutputDevice)
{
    ENTRY
    (void)audioOutputDevice;

    /* For CDDA no need to store audio output device */

    return MP_NO_ERROR;
}

tResult DVDControl::SendPlaybackStatus(const tPEHandle handle, const tPEPlaybackState playbackState, const me::reason_e reason, const me::speed_e speed)
{
    ENTRY
    //VARTRACE(handle);
    //VARTRACE(playState);
    //VARTRACE(reason);
    //VARTRACE(speed);

    tResult ret = MP_NO_ERROR;

    /* Send PLAYBACK_STATUS event to own state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = ParameterPLAYBACK_STATUS(OUT parameterString, IN size, IN handle, IN playbackState, IN reason, IN speed);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(PLAYBACK_STATUS, IN parameterString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult DVDControl::SendNowPlayingStatus(const tPEHandle handle, const tURL mountPointURL)
{
    ENTRY
    //VARTRACE(handle);
    //VARTRACE(mountPointURL);

    tResult ret = MP_NO_ERROR;

    /* Send NOW_PLAYING_STATUS event to own state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    ret = ParameterNOW_PLAYING_STATUS(OUT parameterString, IN size, IN handle, IN mountPointURL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(NOW_PLAYING_STATUS, IN parameterString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult DVDControl::SendPlaytimeStatus(const tPEHandle handle, const tPETimeInfoStruct timeInfoStruct)
{
    ENTRY
    //VARTRACE(handle);
    //VARTRACE(timeInfoStruct);

    tResult ret = MP_NO_ERROR;

    /* Marshal struct of timeInfo into a string */
    tPETimeInfo timeInfoString;
    size_t size = sizeof(timeInfoString);
    SMF::Marshal(OUT timeInfoString,
            IN size-1,
            IN DOUBLE_MARSHAL_SEPARATOR,
            IN tPEBytes_format tPEPercentage_format tPEMilliseconds_format tPEBytes_format tPEMilliseconds_format,
            IN timeInfoStruct.position.bytes,
            IN timeInfoStruct.position.pct,
            IN timeInfoStruct.position.ms,
            IN timeInfoStruct.duration.bytes,
            IN timeInfoStruct.duration.ms);

    /* Send PLAYTIME_STATUS event to own state machine */
    tAllParameters parameterString;
    size = sizeof(parameterString);
    ret = ParameterPLAYTIME_STATUS(OUT parameterString, IN size, IN handle, IN timeInfoString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(PLAYTIME_STATUS, IN parameterString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}


//Indexing part

tResult DVDControl::IsInitRequired(const tDeviceInfoString deviceInfoString)
{
    ENTRY;
    // tDeviceInfo deviceInfo;
    // already device is initialized , thi is an internal transition from disconnected to attached due to disc ejection
    m_bIsDVDControlActive = false;
    ETG_TRACE_USR4(("DEVICE : IsInitRequired DVD deActivated"));
    DataProvider::UnMarshalDeviceInfo(deviceInfoString, mDeviceInfo);
    if(m_bOnDeviceIntialize == true)
    {
        mDeviceInfo.connectionState = CS_ATTACHED;
        tAllParameters parameterString;
        tResult ret = MP_NO_ERROR;
        size_t size = sizeof(parameterString);
        ret = LocalSPM::GetIndexer().ParameterDEVICE_INITIALIZED(
                OUT parameterString, IN size, IN mDeviceInfo.deviceName, IN mDeviceInfo.deviceID,
                IN mDeviceInfo.connectionState);
        if (MP_NO_ERROR != ret) {
            ETG_TRACE_ERR(("DVDControl::SendDeviceInitialized() - Error while preparing parameter string"));
            parameterString[0] = '\0';
        }
        ret = LocalSPM::GetIndexer().SendEventByName("DEVICE_INITIALIZED", IN parameterString);
    }
    else
    {
        SendInitInit(deviceInfoString);
    }
#if 0
    VARTRACE2(deviceInfo.mountPoint, deviceInfo.deviceID);
    strncpy_r(mDeviceInfo.mountPoint,deviceInfo.mountPoint,sizeof(mDeviceInfo.mountPoint));
    mDeviceInfo.deviceID=deviceInfo.deviceID;
#endif

    /* In case of CDDA no initialization is necessary -> return NoInitAnswer (former false case) */
    // return NoInitAnswer(IN deviceInfoString);
    return MP_NO_ERROR;
}

tResult DVDControl::SendInitDevice(const tMountPoint mountPoint, const tInitDeviceProtocol protocol)
{

    ENTRY

    tResult ret = MP_NO_ERROR;

    /* Status response: Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = ParameterINIT_DEVICE(OUT parameterString, IN size, IN mountPoint, IN protocol);
    if (MP_NO_ERROR != ret) {
        ETG_TRACE_ERR(("DVDControl::SendInitDevice() - Error while preparing parameter string"));
    }
    return SendEvent(INIT_DEVICE, IN parameterString);
}

tResult DVDControl::SendInitInit(const tDeviceInfoString deviceInfoString)
{
    ENTRY;
    tDeviceInfo deviceInfo;
    DataProvider::UnMarshalDeviceInfo(deviceInfoString, deviceInfo);
    VARTRACE2(deviceInfo.mountPoint, deviceInfo.deviceID);
    // copy resume info
    tDVDInfoBlob blobInfo;
    blobInfo.data = m_resumeBuffer;
    blobInfo.dataSize = sizeof(m_resumeBuffer);
    LocalSPM::GetDBManager().GetDVDResumeInfo(blobInfo);
    //@@@ code?
    ETG_TRACE_USR4(("\n resume data stored SendInitInit is : \n"));
    for(unsigned int i=0 ; i< sizeof(m_resumeBuffer);i++)
    {
        ETG_TRACE_USR4(("\t %x ",m_resumeBuffer[i] ));
    }
    blobInfo.data = (unsigned char*)&mDvdSetupInfo;
    blobInfo.dataSize = sizeof(mDvdSetupInfo);
    LocalSPM::GetDBManager().GetDVDSetupInfo(blobInfo);
    ETG_TRACE_USR4(("\n setup data stored SendInitInit is : \n"));
    for(unsigned int i=0 ; i< blobInfo.dataSize ;i++)
    {
        ETG_TRACE_USR4(("\t %x ", blobInfo.data[i] ));
    }
    SendInitDevice(deviceInfo.mountPoint,tInitDeviceProtocol::IDP_DVD_BACKEND);

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::SendDeviceInitialized()
{
    ENTRY;
    tResult ret = MP_NO_ERROR;
    /* Send INIT_DEVICE_CONNECTION message to IndexerSM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tConnectionState connectionState = CS_CONNECTED;

    ret = LocalSPM::GetIndexer().ParameterDEVICE_INITIALIZED(OUT parameterString, IN size, IN mDeviceInfo.deviceName, IN mDeviceInfo.deviceID, IN connectionState);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = LocalSPM::GetIndexer().SendEventByName("DEVICE_INITIALIZED", IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::NoInitAnswer(const tDeviceInfoString deviceInfoString)
{
    ENTRY;
    tDeviceInfo deviceInfo;
    DataProvider::UnMarshalDeviceInfo(deviceInfoString, deviceInfo);
    VARTRACE2(deviceInfo.mountPoint, deviceInfo.deviceID);

    tResult ret = MP_NO_ERROR;

    /* Send INIT_DEVICE_CONNECTION message to IndexerSM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tConnectionState connectionState = CS_CONNECTED;
    if(m_pDVDControlInterface)
    {
        m_pDVDControlInterface->resetToc();    //NCG3D-16237
    }

    ret = LocalSPM::GetIndexer().ParameterDEVICE_INITIALIZED(OUT parameterString, IN size, IN deviceInfo.deviceName, IN deviceInfo.deviceID, IN connectionState);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = LocalSPM::GetIndexer().SendEventByName("DEVICE_INITIALIZED", IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending event via SMF (ErrorCode:%s)", errorString(ret)));
    }
    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::IsInitDeviceConnection(const tMountPoint mountPoint, const tInitDeviceProtocol protocol)
{
    ENTRY
    VARTRACE(mountPoint);
    if(m_pDVDControlInterface != NULL)
    {
        if(LocalSPM::GetDataProvider().UseResumeinfoFromDB())
        {
            if(mDvdSetupInfo.RegionCode == DvdVideoRegionCodeArray[LocalSPM::GetDataProvider().DVDRegionCode()])
            {
                m_pDVDControlInterface->StoreSetupInformationData(mDvdSetupInfo);
            }
            if(m_resumeBuffer[0] == BE_COMMAND_RESPONSE_INFO)
            {
                m_pDVDControlInterface->StoreResumeInformationData(m_resumeBuffer,sizeof(m_resumeBuffer),false);
            }
        }
        VARTRACE("DVD Region:")
        VARTRACE(LocalSPM::GetDataProvider().DVDRegionCode());
        tNumberOfDevices numberOfDevices = 0;
        vector<tDeviceInfo> deviceInfo;
        bool isDataDisc = false;
        LocalSPM::GetDBManager().GetMediaplayerDeviceConnections(OUT numberOfDevices, OUT deviceInfo, IN true/*allDevices*/);
        vector<tDeviceInfo>::iterator it;
        for(it = deviceInfo.begin(); it < deviceInfo.end(); it++)
        {
            if(it->deviceType == DTY_CDROM && it->formerConnectionState == CS_CONNECTED)//deviceInfo.connectionState == CS_CONNECTED
            {
                isDataDisc = true; //if data disc and former connection state is connected, do not switch to backend mode, flag sent to interface to notify that
                break;
            }
        }
        tResult ret=m_pDVDControlInterface->Initialize(mountPoint ,LocalSPM::GetDataProvider().SetFPGARegistryforDVD(), DvdVideoRegionCodeArray[LocalSPM::GetDataProvider().DVDRegionCode()], isDataDisc);

        if(ret == MP_NO_ERROR )
        {
            return true;
        }
    }
    return false;
}

tResult DVDControl::Disconnect(const tMountPoint mountPoint) const
{
    ENTRY
    VARTRACE(mountPoint);

    /* For CDDA no implementation */
    return MP_NO_ERROR;
}

tResult DVDControl::OnDeviceInitialized(const tMountPoint mountPoint, const tConnectionState connectionState,const tInitDeviceProtocol discType)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    VARTRACE(mountPoint);
    VARTRACE(connectionState);
    tDiscType disc = (tDiscType)discType;
    VARTRACE(disc);

    mDeviceInfo.discType = disc;
    mDeviceInfo.connectionState = connectionState;
    if(m_bOnDeviceIntialize == false)
    {
        m_bOnDeviceIntialize = true;
    }

    if(disc == DISC_DATA)
    {
        mDeviceInfo.connectionState = CS_ATTACHED;
        if(m_pDVDControlInterface != NULL)
        {
            m_pDVDControlInterface->SwitchtoMassStorageModeDisablePolling();
        }
        m_bIsDataDisc = true;
        VARTRACE(m_bIsDataDisc);
        LocalSPM::GetOutputWrapper().UpdateDVDProperty(DVDDRIVEINFO);
    }
    else if(disc == DISC_AUDIO_CD)
    {
        // do read toc , save it as a member variable
        m_pDVDControlInterface->readToc(m_CDTOCInfo);
        ETG_TRACE_USR4(("READTOC onDeviceInitialized"));
        if(checkRippingEnabled()) //(m_bAlreadyRipped == false) - to be replaced with checkRippingEnabled
        {
            ETG_TRACE_USR4(("START_RIPPING OnDeviceInitialized"));
            /* forward my own state machine */
            ret = DVDControlSM::SendEvent(START_RIPPING, NULL);
        }
        else
        {
            FetchedGNinfo(CDDA);
        }
    }

    if(CS_CONNECTED == mDeviceInfo.connectionState)
    {
        if(m_pDVDControlInterface != NULL)
        {
            tNumberOfFiles numberOfFiles = (tNumberOfFiles) (m_pDVDControlInterface->getNumberOfTracks()) ;

            LocalSPM::GetDBManager().SetNumberOfAudioFiles(mDeviceInfo.deviceID,numberOfFiles);
        }
        LocalSPM::GetDBManager().UpdateDiscType(mDeviceInfo.deviceID,mDeviceInfo.discType);

        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        ret = LocalSPM::GetIndexer().ParameterDEVICE_INITIALIZED(
                OUT parameterString, IN size, IN mDeviceInfo.deviceName, IN mDeviceInfo.deviceID,
                IN mDeviceInfo.connectionState);
        if (MP_NO_ERROR != ret) {
            ETG_TRACE_ERR(("DVDControl::SendDeviceInitialized() - Error while preparing parameter string"));
            parameterString[0] = '\0';
        }
        ret = LocalSPM::GetIndexer().SendEventByName("DEVICE_INITIALIZED", IN parameterString);
    }

    /*
   else
   {
       ret = LocalSPM::GetDBManager().SetConnectionState(mDeviceInfo.deviceID,mDeviceInfo.connectionState);
   }*/

    return ret;
}

tResult DVDControl::GetNumberOfFiles(const tDeviceID deviceID)
{
    //Device type is not supported for indexing, nevertheless indexer requires the total number of playable files from this device
    //Added for VAG iPod streaming

    ENTRY;
    VARTRACE(deviceID);

    //@@@ code
    tNumberOfFiles numberOfFiles = 0 ;
    if(m_pDVDControlInterface)
    {
        numberOfFiles = (tNumberOfFiles) (m_pDVDControlInterface->getNumberOfTracks()) ;
    }
    /* Send ANSWER message to IndexerSM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    LocalSPM::GetIndexer().ParameterNUMBER_OF_FILES_ANSWER(OUT parameterString, IN size, IN deviceID, IN numberOfFiles);
    SendAnswer(IN parameterString);

    return MP_NO_ERROR;
}

tResult DVDControl::CalcFingerprint(const tMountPoint mountPoint, const tDeviceID deviceID, const tFingerprint lastFingerprint)
{
    ENTRY
    VARTRACE2(mountPoint, deviceID);
    VARTRACE(lastFingerprint);

    tResult ret = MP_NO_ERROR;

    return ret;
}

tResult DVDControl::OnFingerprint(const tFingerprint fingerprint,
        const tFingerprintStatus fingerprintStatus,
        const tNumberOfFiles numberOfFiles,
        const tDeviceID deviceID)
{
    ENTRY
    VARTRACE(fingerprint);
    VARTRACE(fingerprintStatus);
    VARTRACE(numberOfFiles);
    VARTRACE(deviceID);

    tResult ret = MP_NO_ERROR;


    /* Send FINGERPRINT_AVAIL message to IndexerSM */
    char messageString[64];
    strncpy(messageString, "IndexerSM::FINGERPRINT_AVAIL", sizeof(messageString) - 1);
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetIndexer().ParameterFINGERPRINT_AVAIL(OUT parameterString,
            IN size,
            IN fingerprint,
            IN fingerprintStatus,
            IN numberOfFiles,
            IN deviceID);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    //ret = SendAnswer(IN parameterString);
    ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::IsNextMetadataAvailable(const tMountPoint mountPoint, const tReadPosition readPosition, const tDeviceID deviceID)
{
    ENTRY
    VARTRACE2(mountPoint, deviceID);
    VARTRACE(readPosition);

    /* Return false always because we have no metadata cache */
    return false;
}

tResult DVDControl::RetrieveMetadataFromDevice(const tMountPoint mountPoint, const tReadPosition readPosition, const tDeviceID deviceID)
{
    ENTRY
    VARTRACE2(mountPoint, deviceID);
    VARTRACE(readPosition);

    tResult ret = MP_NO_ERROR;
    tMetadataStatus metadataStatus = MDS_SUCCESS;

    /* Get next media object from virtual file list */
    //@@@code get next toc entry

    /* Send PUT_METADATA message to own SM */
    tMediaObjectPtr mediaObjectPtr = NULL;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = ParameterPUT_METADATA(OUT parameterString, IN size, IN metadataStatus, IN mediaObjectPtr);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(PUT_METADATA, IN parameterString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::SendPutMetadata(const tMountPoint mountPoint, const tReadPosition readPosition, const tDeviceID deviceID)
{
    ENTRY
    VARTRACE2(mountPoint, deviceID);
    VARTRACE(readPosition);

    tResult ret = MP_NO_ERROR;

    /* Send PUT_METADATA message to own SM */
    tMetadataStatus metadataStatus = MDS_SUCCESS;
    tMediaObjectPtr mediaObjectPtr = NULL;

    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = ParameterPUT_METADATA(OUT parameterString, IN size, IN metadataStatus, IN mediaObjectPtr);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(PUT_METADATA, IN parameterString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::AnswerMetadata(const tMetadataStatus metadataStatus, tMediaObjectPtr mediaObjectPtr)
{
    ENTRY
    VARTRACE(metadataStatus);

    tResult ret = MP_NO_ERROR;

    //@@@ add code for toc data??

    /* Copy media object */
    if(MDS_SUCCESS == metadataStatus)
    {
        if(NULL == mediaObjectPtr)
        {
            mediaObjectPtr = new tMediaObject; //Attention: Has to be deleted by Indexer::CheckMetadata
        }
        if(mediaObjectPtr)
        {
            InitMediaObject(OUT *mediaObjectPtr);
        }
        //*mediaObjectPtr = m_ScanMediaObject;
    }

    /* Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetIndexer().ParameterMETADATA_ANSWER(OUT parameterString,
            IN size,
            IN mediaObjectPtr, //lint -e429 freed by calling thread
            IN metadataStatus);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
        if (NULL != mediaObjectPtr)
        {
            delete mediaObjectPtr;
        }
    }

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::RetrieveMetadataFromCache(tMetadata &metadata) const
{
    /* Obsolete: DeviceControl is sending a media object instead of a metatdata string so an assembly is not necessary */
    ENTRY
    (void)metadata;
    return MP_NO_ERROR;
}

tResult DVDControl::RemoveDeviceConnection(const tMountPoint mountPoint, const tDeviceID deviceID)
{
    ENTRY
    VARTRACE2(mountPoint, deviceID);

    tResult ret = MP_NO_ERROR;

    //@@@ code

    return ret;
}

//AlbumArt part

tResult DVDControl::GetAlbumArt(const tAlbumArt albumArtString)
{
    ENTRY
    VARTRACE(albumArtString);

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::HandleGetAlbumArtAnswer(const tAlbumArtObjectPtr ptrToAlbumArtObject)
{
    ENTRY

    /*Send the album art data as answer to request GetAlbumArt (Note : requested from DataProvider)*/
    tAllParameters parameterString = {0};
    SMF::Marshal(IN parameterString, sizeof(parameterString)-1, "p",IN ptrToAlbumArtObject);

    SendAnswer(IN parameterString);

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::AlbumArtAnswerNotConsumed(const tAlbumArtObjectPtr ptrToAlbumArtObject)
{
    ENTRY;

    return MP_NO_ERROR;
}

tResult DVDControl::SendAlbumArtAnswer(const tAlbumArtObjectPtr ptrToAlbumArtObject)
{
    ENTRY_INTERNAL;

    tResult ret = MP_NO_ERROR;

    /* Send GET_ALBUM_ART_ANSWER message to own SM */
    tAllParameters parameterString = {0};
    SMF::Marshal(IN parameterString, sizeof(parameterString)-1, "p", IN ptrToAlbumArtObject);

    ret = SendEvent(GET_ALBUM_ART_ANSWER, IN parameterString);

    return ret;
}

tResult DVDControl::Umount(const tDeviceID deviceID, const tMountPoint mountPoint)
{
    ENTRY;
    VARTRACE2(mountPoint, deviceID);

    tResult ret = MP_NO_ERROR;

    /* Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    SMF::Marshal(parameterString, size - 1, "i", 0);

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tBoolean DVDControl::IsBatchPlayable(const tDeviceID deviceID)
{
    ENTRY;
    VARTRACE(deviceID);
    return 0;
}

tResult DVDControl::GetNextObjectToIndex(tMetadataStatus &metadataStatus,
        const tDeviceID deviceID,
        const tMountPoint mountPoint,
        const tReadPosition readPosition)
{
    ENTRY_INTERNAL
    VARTRACE2(mountPoint, deviceID);
    VARTRACE(readPosition);

    tResult ret = MP_NO_ERROR;
    metadataStatus = MDS_SUCCESS;

    //@@@ code

    return ret;
}

void DVDControl::TransferMetaTags(void *_info, tMediaObject &mediaObject)
{
    //@@@ nothing to do
}

void DVDControl::DoReadMetadataForPlaybackThread(const tURL completeFileName)
{
    ENTRY
    VARTRACE(completeFileName);

    tResult ret = MP_NO_ERROR;
    tReturnValue returnValue = TRUE;

    /* Get metadata of media object for playback */
    tMediaObject mediaObject;
    InitMediaObject(OUT mediaObject);

    ret = LocalSPM::GetDBManager().GetFileFormat(OUT mediaObject.fileFormat, OUT mediaObject.fileType, IN completeFileName);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("unable to get file format for the url: %s", completeFileName));
        returnValue = FALSE;
    }
    else
    {
        if(FT_VIDEO == mediaObject.fileType )
        {
            /* Read video metadata */
            returnValue = ReadVideoMetadataFromFile(INOUT mediaObject, IN completeFileName);
        }
        else
        {
            /* Read audio metadata */
            returnValue = ReadAudioMetadataFromFile(INOUT mediaObject, IN completeFileName);
        }
    }

    m_Mutex.lock();

    tPEHandle handle = (tPEHandle)m_PlayMediaObject.objectID;
    m_PlayMediaObject.notPlayable = mediaObject.notPlayable;

    if(returnValue)
    {
        /* Copy metadata */
        m_PlayMediaObject.mediaType = mediaObject.mediaType;
        strncpy_r(OUT m_PlayMediaObject.title, IN mediaObject.title, IN sizeof(m_PlayMediaObject.title));
        strncpy_r(OUT m_PlayMediaObject.MetadataField1, IN mediaObject.MetadataField1, IN sizeof(m_PlayMediaObject.MetadataField1));
        strncpy_r(OUT m_PlayMediaObject.MetadataField2, IN mediaObject.MetadataField2, IN sizeof(m_PlayMediaObject.MetadataField2));
        strncpy_r(OUT m_PlayMediaObject.MetadataField3, IN mediaObject.MetadataField3, IN sizeof(m_PlayMediaObject.MetadataField3));
        strncpy_r(OUT m_PlayMediaObject.MetadataField4, IN mediaObject.MetadataField4, IN sizeof(m_PlayMediaObject.MetadataField4));
        m_PlayMediaObject.totalPlaytime = mediaObject.totalPlaytime;
        m_PlayMediaObject.trackNumber = mediaObject.trackNumber;
        m_PlayMediaObject.metadataConvertFlag = mediaObject.metadataConvertFlag;
    }

    m_Mutex.unlock();

    /* Send METADATA_FOR_PLAYBACK message to own SM */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = ParameterMETADATA_FOR_PLAYBACK(OUT parameterString, IN size, IN handle, IN completeFileName);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendEvent(METADATA_FOR_PLAYBACK, IN parameterString);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    delete[] completeFileName;
}

#define PERF_MEAS 1

tReturnValue DVDControl::ReadAudioMetadataFromFile(tMediaObject &mediaObject, const tURL completeFileName)
{
    ENTRY
    VARTRACE(completeFileName);

    tReturnValue returnValue = TRUE;

    mediaObject.mediaType = MTY_MUSIC_FILE;

    //@@@: read toc data
#if 0
#if PERF_MEAS
    TimeTrace ticks("ReadAudioMetadataFromFile");
#endif


#if PERF_MEAS
    ticks.elapsed();
#endif

    if(FALSE == returnValue)
    {
        ETG_TRACE_ERR(("DVDControl::ReadAudioMetadataFromFile -> metadata could not be retrieved for file : %s",completeFileName));
    }
    else
    {
        VARTRACE5(mediaObject.title, mediaObject.MetadataField1, mediaObject.MetadataField2, mediaObject.MetadataField3, mediaObject.MetadataField4);
        VARTRACE(mediaObject.totalPlaytime);
        VARTRACE(mediaObject.trackNumber);
        VARTRACE(mediaObject.notPlayable);
    }
#endif
    return returnValue;
}

tReturnValue DVDControl::ReadVideoMetadataFromFile(tMediaObject &mediaObject, const tURL completeFileName)
{
    ENTRY
    VARTRACE(completeFileName);
    tReturnValue returnValue = TRUE;

    //@@@ no video data

    return returnValue;
}

tReturnValue DVDControl::ReadImageMetadataFromFile(tMediaObject &mediaObject, const tURL completeFileName)
{
    ENTRY
    VARTRACE(completeFileName);

    tReturnValue returnValue = TRUE;

    //@@@ no image

    return returnValue;
}

tReturnValue DVDControl::CollectData(const tMountPoint mountPoint)
{
    ENTRY_INTERNAL
    VARTRACE(mountPoint);

    tReturnValue returnValue = TRUE;

    if(0 == LocalSPM::GetDataProvider().CollectMetadata())
    {
        //ETG_TRACE_USR1(("No metadata extraction configured"));
        return TRUE;
    }

    /* Collect data together */
    /* Only a few parts of the media object are filled if it is taken from a LTY_FILELIST_UNSORTED list
     * mediaObject.objectID
     * mediaObject.fileName
     * mediaObject.fileType
     * mediaObject.fileFormat
     * mediaObject.title (= mediaObject.fileName without path but with extension)
     * mediaObject.deviceID
     * mediaObject.deviceType
     * mediaObject.deviceVersion
     * mediaObject.mountPoint
     * mediaObject.catType
     * mediaObject.mediaType
     * mediaObject.albumArtString
     *
     * The rest has to be added here
     */

    //tph: TODO ReadMetadata in thread

    //@@@: reduce code

    //tURL completeFileName;
    //strncpy_r(OUT completeFileName, IN m_ScanMediaObject.mountPoint, IN sizeof(completeFileName));
    //strncat_r(OUT completeFileName, IN m_ScanMediaObject.fileName, IN sizeof(completeFileName));

    return returnValue;
}

tResult DVDControl::CDDAGetFolderItem(const tMountPoint mountpoint, const tPath path, const tIndex index)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    (void)mountpoint;
    (void)path;
    (void)index;
    /* forward my own state machine */
    ret = DVDControlSM::SendEvent(CDDA_GET_FOLDER_ITEM_ANSWER, NULL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::DVDGetFolderItem(const tMountPoint mountpoint, const tPath path, const tIndex index)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    (void)mountpoint;
    (void)path;
    VARTRACE(index);
    tIndex indexValue = 0;

    /* create a memory object which holds the toc data */
    if( mTocDataOneTrack )
    {
        delete mTocDataOneTrack; //delete old one
    }
    mTocDataOneTrack = new tFiles();

    //sleep(1);
    /* get the toc data for one track */
    // m_pDVDControlInterface->getToc(mTocDataOneTrack, mountpoint, path, index);
    if(m_pDVDControlInterface)
    {
        indexValue = index+1;
        if(mDeviceInfo.discType == DISC_AUDIO_CD && getGNMetadataAvailable() == true)
        {
            GetTrackTextInfoFromGN(mTocDataOneTrack, (unsigned char)indexValue);
        }
        else
        {
            m_pDVDControlInterface->getTrackTextInfo(mTocDataOneTrack, (unsigned char)indexValue);
        }
    }

    /*SendAnswer to prevent SM getting locked in this state*/
    /* answer this request */
    tAllParameters parameters;
    SMF::Marshal(parameters, sizeof(parameters), "p", mTocDataOneTrack);
    ret = SendAnswer(parameters);

    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
        if( mTocDataOneTrack )
        {
            delete mTocDataOneTrack;
        }
    }
    mTocDataOneTrack = NULL;

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult DVDControl::CDDAGerFolderItemAnswer()
{
    ENTRY
    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

DVDControl::DVDCallbacks::DVDCallbacks()
{
    mResendPlaybackStatus = 0;
    mResendNowPlayingStatus = 0;
    mResendPlaybackStatus = 0;
    mResendNowPlayingStatus = 0;
    m_bFirstTimeSetupInfo = true;
    //InitPEState(mNotificationState);
    //InitPEState(mNotificationStateNew);
    strncpy_r(mObservingStateMachineName, "DVDControlSM", sizeof(mObservingStateMachineName));
}


int DVDControl::DVDCallbacks::ForwardPlaybackStatus(me::state_t currentState)
{
    ENTRY
#if 0
    //ETG_TRACE_USR2(("MediaEngine::ForwardPlaybackStatus"));

    /* no observer registered -> do not send status updates */
    if (mObservingStateMachineName[0] == 0) {
        return 0;
    }

    mNotificationStateNew = currentState;

    //ETG_TRACE_USR2(("MediaEngine::ForwardPlaybackStatus:state0:%s", state0.str().at()));
    //ETG_TRACE_USR2(("MediaEngine::ForwardPlaybackStatus:state1:%s", state1.str().at()));

    bool update = false;

    /* check the contents of the notification to figure out what event to send */

    // PLAYBACK_STATUS;
    if (mNotificationState.playstate != mNotificationStateNew.playstate ||
            mNotificationState.speed     != mNotificationStateNew.speed ||
            mNotificationState.reason    != mNotificationStateNew.reason ||
            mResendPlaybackStatus) {

        ETG_TRACE_USR2(("MediaEngine::ForwardPlaybackStatus:PLAYBACK_STATUS"));

        tPEPlaybackState playbackState;
        switch(mNotificationStateNew.playstate) {
            case PE_PS_STOP:
                playbackState = PE_PBS_STOPPEDSTATE;
                break;
            case PE_PS_PAUSE:
                playbackState = PE_PBS_PAUSEDSTATE;
                break;
            case PE_PS_PLAY:
                if(0 > mNotificationStateNew.speed) {
                    playbackState = PE_PBS_FASTREVERSESTATE;
                }
                else if(1 < mNotificationStateNew.speed) {
                    playbackState = PE_PBS_FASTFORWARDSTATE;
                }
                else {
                    playbackState = PE_PBS_PLAYINGSTATE;
                }
                break;
            case PE_PS_NOP:
                playbackState = PE_PBS_LOADINGSTATE;
                break;
            default:
                playbackState = PE_PBS_ERRORSTATE;
                break;
        }

        tGeneralString messageName;
        strncpy_r(OUT messageName, IN mObservingStateMachineName, IN sizeof(messageName));
        strncat_r(OUT messageName, "::PLAYBACK_STATUS", IN sizeof(messageName));

        tAllParameters args;
        Marshal((char *)args, sizeof(args)-1, "lill",
                (tU64)mNotificationStateNew.handle,
                (int)playbackState,
                mNotificationStateNew.reason,
                mNotificationStateNew.speed);

        /* send the PLAYBACK_STATUS to observer */
        Dispatcher::GetInstance().SendMessage(messageName, args);

        /* reset the extra trigger for sending playback status */
        mResendPlaybackStatus = 0;

        update = true; // save notification state as current;
    }

    // NOW_PLAYING_STATUS;
    if (strcmp(mNotificationState.url, mNotificationStateNew.url) || mResendNowPlayingStatus) {

        ETG_TRACE_USR2(("MediaEngine::ForwardPlaybackStatus:NOW_PLAYING_STATUS"));
        VARTRACE(mNotificationStateNew.url);
        VARTRACE(mNotificationState.url);
        VARTRACE(mResendNowPlayingStatus);

        tGeneralString messageName;
        strncpy_r(OUT messageName, IN mObservingStateMachineName, IN sizeof(messageName));
        strncat_r(OUT messageName, "::NOW_PLAYING_STATUS", IN sizeof(messageName));

        tAllParameters args;
        Marshal((char *)args, sizeof(args)-1, "lt", (tU64)mNotificationStateNew.handle, mNotificationStateNew.url);

        /* send the NOW_PLAYING_STATUS to observer */
        Dispatcher::GetInstance().SendMessage(messageName, args);

        /* reset the extra trigger for sending now playing status */
        mResendNowPlayingStatus = 0;

        update = true; // save notification state as current;
    }

    // PLAYTIME_STATUS;
    if (memcmp(&mNotificationState.pos, &mNotificationStateNew.pos, sizeof(mNotificationState.pos)) ||
            memcmp(&mNotificationState.dur, &mNotificationStateNew.dur, sizeof(mNotificationState.dur))) {

        //ETG_TRACE_USR2(("MediaEngine::ForwardPlaybackStatus:PLAYTIME_STATUS"));

        //#define MEDIA_ENGINE_USE_PLAYTIME_FILTER

#if defined(MEDIA_ENGINE_USE_PLAYTIME_FILTER)
        /* reduce the event rate */
        if (llabs(state1.pos.ms  - state0.pos.ms)  >  500 || // for every 500 ms change in current position or
                llabs(state1.pos.pct - state0.pos.pct) >=   2 || // for every 2 percent change in current position or
                state1.pos.ms                          <  500 || // if the current position is near the beginning or
                llabs(state1.dur.ms - state1.pos.ms)   <  500 || // if the current position is near the end of file or
                memcmp(&state0.dur, &state1.dur, sizeof(state0.dur))) // for every duration changes
        {
#endif
            tGeneralString messageName;
            strncpy_r(OUT messageName, IN mObservingStateMachineName, IN sizeof(messageName));
            strncat_r(OUT messageName, "::PLAYTIME_STATUS", IN sizeof(messageName));

            tPETimeInfo timeInfoString;
            SMF::Marshal(OUT timeInfoString, IN sizeof(timeInfoString)-1, IN DOUBLE_MARSHAL_SEPARATOR, "lllll",
                    IN mNotificationStateNew.pos.bytes,
                    IN mNotificationStateNew.pos.pct,
                    IN mNotificationStateNew.pos.ms,
                    IN mNotificationStateNew.dur.bytes,
                    IN mNotificationStateNew.dur.ms);

            //ETG_TRACE_USR2(("timeInfoString=%s", timeInfoString));

            tAllParameters args;
            Marshal((char *)args, sizeof(args)-1, "lt", (tU64)mNotificationStateNew.handle, IN timeInfoString);

            /* send the PLAYTIME_STATUS to observer */
            Dispatcher::GetInstance().SendMessage(messageName, args);

            update = true; // save notification state as current;

#if defined(MEDIA_ENGINE_USE_PLAYTIME_FILTER)
        } else {// reduce event rate
            ETG_TRACE_USR1(("PLAYTIME_STATUS filtered out"));
        }
#endif

        if(update) {
            mNotificationState = mNotificationStateNew;
        }
    }

    /* TODO: ACTIVITY_STATUS? */
    /* there is no activity status in the state */

#endif

    return 0;
}

void DVDControl::DVDCallbacks::update(me::state_t currentState)
{
    ENTRY
    ForwardPlaybackStatus(currentState);
}

void DVDControl::DVDCallbacks::resendNowPlaying(tBoolean resend)
{
    ENTRY
    mResendNowPlayingStatus = resend;
}

void DVDControl::DVDCallbacks::signalEvent(tDVDEventID dvdEventId , tU8 value)
{
    ENTRY
    ETG_TRACE_USR1(("SIGNAL EVENT %d -->  %x",dvdEventId, value ));
    switch(dvdEventId)
    {
        case DVD_EVENT_DISC_ERROR:
        {
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            const tUserDataType userDataType = USRDATA_DISKERROR_UPDATES;
            tUserData userData = {0};

            SMF::Marshal(userData, sizeof(userData) - 1,DOUBLE_MARSHAL_SEPARATOR, "i",(tUInt)value);

            LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
            LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
            break;
        }
        case DVD_EVENT_DRIVEMODE:
        {
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            const tUserDataType userDataType = USRDATA_DRIVEMODE_UPDATES;
            tUserData userData = {0};

            SMF::Marshal(userData, sizeof(userData) - 1,DOUBLE_MARSHAL_SEPARATOR, "i",(tUInt)value);

            LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
            LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
            break;
        }
        case DVD_EVENT_MECHANICAL_STATUS:
        {
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            const tUserDataType userDataType = USRDATA_MECHANICAL_STATUS_UPDATES;
            tUserData userData = {0};

            SMF::Marshal(userData, sizeof(userData) - 1,DOUBLE_MARSHAL_SEPARATOR, "i",(tUInt)value);

            LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
            LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
            break;
        }
        case DVD_EVENT_DISPLAY_MODE:
        {
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            const tUserDataType userDataType = USRDATA_DVD_DISPLAYMODE_UPDATES;
            tUserData userData = {0};

            SMF::Marshal(userData, sizeof(userData) - 1,DOUBLE_MARSHAL_SEPARATOR, "i",(tUInt)value);

            LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
            LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
            break;
        }
        case DVD_EVENT_SKIP_MODE:
        {
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            const tUserDataType userDataType = USRDATA_DVD_SKIP_UPDATES;
            tUserData userData = {0};

            SMF::Marshal(userData, sizeof(userData) - 1,DOUBLE_MARSHAL_SEPARATOR, "i",(tUInt)value);

            LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
            LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
            break;
        }
        case DVD_EVENT_ANGLE_MARK_SETTING:
        {
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            const tUserDataType userDataType = USRDATA_DVD_ANGLE_MARK_UPDATES;
            tUserData userData = {0};

            SMF::Marshal(userData, sizeof(userData) - 1,DOUBLE_MARSHAL_SEPARATOR, "i",(tUInt)value);

            LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
            LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
            break;
        }
        case DVD_EVENT_DIRECTSELECT_MODE:
        {
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            const tUserDataType userDataType = USRDATA_DVD_DIRECTSELECT_UPDATES;
            tUserData userData = {0};

            SMF::Marshal(userData, sizeof(userData) - 1,DOUBLE_MARSHAL_SEPARATOR, "i",(tUInt)value);

            LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
            LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
            break;
        }
        case DVD_EVENT_DRC_SETTINGS:
        {
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            const tUserDataType userDataType = USRDATA_DVD_DRC_SETTINGS_UPDATES;
            tUserData userData = {0};

            SMF::Marshal(userData, sizeof(userData) - 1,DOUBLE_MARSHAL_SEPARATOR, "i",(tUInt)value);

            LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
            LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
            break;
        }
        case DVD_EVENT_DISC_TYPE:
        {

            tConnectionState state = CS_ATTACHED;

            if((value != DISC_UNDECIDED) && (value != DISC_NONE) && (m_bOnDeviceIntialize == false))
            {
                state = CS_CONNECTED;
                tMountPoint mountPoint = "";
                tGeneralString messageName;
                strncpy_r(OUT messageName, IN mObservingStateMachineName, IN sizeof(messageName));
                strncat_r(OUT messageName, "::ON_DEVICE_ATTACH", IN sizeof(messageName));
                tAllParameters args;
                Marshal((char *)args, sizeof(args)-1, "tii",
                        mountPoint,
                        (int)state,
                        (int)value);
                Dispatcher::GetInstance().SendMessage(messageName, args);
            }
            else if(m_bOnDeviceIntialize == true)
            {
                tAllParameters parameterString;
                size_t size = sizeof(parameterString);
                const tUserDataType userDataType = USRDATA_DVD_DISC_DETERMINED;
                tUserData userData = {0};

                SMF::Marshal(userData, sizeof(userData) - 1,DOUBLE_MARSHAL_SEPARATOR, "i",(tUInt)value);

                LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
                LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
            }
            break;
        }

        case DVD_EVENT_KEY_RESPONSE:
        {
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            const tUserDataType userDataType = USRDATA_DVD_KEY_RESPONSE_UPDATES;
            tUserData userData = {0};

            SMF::Marshal(userData, sizeof(userData) - 1,DOUBLE_MARSHAL_SEPARATOR, "i",(tUInt)value);

            LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
            LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
            break;
        }
        case DVD_EVENT_PLAYBACK_MODE:
        {
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            const tUserDataType userDataType = USRDATA_PLAYBACK_MODE_UPDATES;
            tUserData userData = {0};

            SMF::Marshal(userData, sizeof(userData) - 1,DOUBLE_MARSHAL_SEPARATOR, "i",(tUInt)value);

            LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
            LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
            break;
        }
        case DVD_EVENT_MENUPLAYBACK_MODE:
        {
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            const tUserDataType userDataType = USRDATA_DVD_MENUPLAYBACK_MODE;
            tUserData userData = {0};

            SMF::Marshal(userData, sizeof(userData) - 1,DOUBLE_MARSHAL_SEPARATOR, "i",(tUInt)value);

            LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
            LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
            break;
        }
        case DVD_EVENT_TRACK_CHANGE:
        {
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            const tUserDataType userDataType = USRDATA_DVD_TRACK_CHANGE;
            tUserData userData = {0};
            SMF::Marshal(userData, sizeof(userData) - 1,DOUBLE_MARSHAL_SEPARATOR, "i",(tUInt)value);
            LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
            LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
            break;
        }
        default:
        {
            ETG_TRACE_USR1(("SIGNAL EVENT --> NOT HANDELED " ));
            break;
        }
    }
}
void DVDControl::DVDCallbacks::signalPlayBackState(tDVDPlayBackState& playbackInfo)
{

    ETG_TRACE_USR1(("SIGNAL EVENT --> play time updated , VD_EVENT_PLAYBACK_STATE  is %x ",playbackInfo.PBState));

    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    const tUserDataType userDataType = USRDATA_PLAYBACK_STATUS_UPDATES;
    tUserData userData = {0};

    VARTRACE(playbackInfo.PBState);
    VARTRACE(playbackInfo.speed);
    VARTRACE(playbackInfo.mCurrentTrackPlaying);
    VARTRACE(playbackInfo.mCurrentGroupPlaying);
    VARTRACE(playbackInfo.position.ms);
    VARTRACE(playbackInfo.duration.ms);


    SMF::Marshal(userData, sizeof(userData) - 1,DOUBLE_MARSHAL_SEPARATOR, "iiiiii",playbackInfo.PBState ,(tUInt)playbackInfo.speed,(tUInt)playbackInfo.mCurrentTrackPlaying,(tUInt)playbackInfo.mCurrentGroupPlaying,(tPlaytime)playbackInfo.position.ms,(tPlaytime)playbackInfo.duration.ms);

    LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
    LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
}
tResult DVDControl::StartPlaybackAction(const tDeviceType deviceType, const tDeviceID deviceID,
        const tURL URL, const tMountPoint mountPoint,const tPlaybackAction playbackAction, const tNextPrevSkipCount skipcount)
{
    ENTRY
    (void)deviceType;
    (void)deviceID;
    (void)URL;
    (void)mountPoint;
    (void)skipcount;
    //send empty URL , so that it does not perform one track play
    tURL emptyURL = {0x00};
    tPlaybackSpeed rate = (tPlaybackSpeed)skipcount;
    tCueingRate converted_rate = 0;
    bool slowSpeed = ConvertSpeedFormat(rate,converted_rate);
    if(m_pDVDControlInterface)
    {
        /* map to bt specific action*/
        switch(playbackAction)
        {
            case PBA_PLAY:
                m_pDVDControlInterface->play(emptyURL,(speed_e)1,m_StartPosition,m_PlayMediaObject.objectID );
                break;
            case PBA_PAUSE:
                m_pDVDControlInterface->pause();
                break;
            case PBA_NEXT:
                m_pDVDControlInterface->next();
                break;
            case PBA_PREV:
                m_pDVDControlInterface->previous();
                break;
            case PBA_STOP:
                m_pDVDControlInterface->stop();
                break;
            case PBA_FREV_START:
                if(slowSpeed)
                {
                    m_pDVDControlInterface->srevStart(converted_rate);
                }
                else
                {
                    m_pDVDControlInterface->frevStart(converted_rate);
                }
                break;
            case PBA_FREV_STOP:
                m_pDVDControlInterface->frevStop();
                break;
            case PBA_FFWD_START:
                if(slowSpeed)
                {
                    m_pDVDControlInterface->sfwdStart(converted_rate);
                }
                else
                {
                    m_pDVDControlInterface->ffwdStart(converted_rate);
                }
                break;
            case PBA_FFWD_STOP:
                m_pDVDControlInterface->ffwdStop();
                break;
            default:
                break;
        }
    }
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ParameterPLAYBACK_ACTION_ANSWER(OUT parameterString, IN size, IN (tPEHandle)0, IN mPlaybackState, IN (reason_e)0, IN (speed_e)0);
    SendEvent(PLAYBACK_ACTION_ANSWER, IN parameterString);

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}
tResult DVDControl::SignalUserData(const tDeviceID deviceID, const tUserDataType userDataType, const tUserData userData)
{
    ENTRY;
    VARTRACE(deviceID);
    VARTRACE(userDataType);
    tResult ret = MP_NO_ERROR;

    switch(userDataType)
    {

        case USRDATA_DVD_DISC_DETERMINED:
        {
            int value;
            tConnectionState  connectionState = CS_CONNECTED;
            SMF::UnMarshal(userData,DOUBLE_MARSHAL_SEPARATOR, "i",&value);
            mDeviceInfo.discType = (tDiscType)value;

            switch(value)
            {
                case DISC_DATA :
                {
                    connectionState = CS_DISCONNECTED;
                    if(m_pDVDControlInterface)
                    {
                        m_pDVDControlInterface->SwitchtoMassStorageModeDisablePolling();
                    }
                    m_bIsDataDisc = true;
                    VARTRACE(m_bIsDataDisc);
                    //update through outputwrapper
                    LocalSPM::GetOutputWrapper().UpdateDVDProperty(DVDDRIVEINFO);
                }
                break;
                case DISC_AUDIO_CD :
                {
                    // do read toc , save it as a member variable
                    m_pDVDControlInterface->readToc(m_CDTOCInfo);
                    ETG_TRACE_USR4(("READTOC SignalUserData"));

                    connectionState = CS_CONNECTED;

                    if(checkRippingEnabled())   //m_bAlreadyRipped == false) - to be replaced with checkRippingEnabled
                    {
                        /* forward my own state machine */
                        ETG_TRACE_USR4(("START_RIPPING SignalUserData"));

                        ret = DVDControlSM::SendEvent(START_RIPPING, NULL);

                    }
                    else
                    {
                        FetchedGNinfo(CDDA);
                    }
                }
                break;
                case DISC_NONE:
                case DISC_UNDECIDED:
                    connectionState = CS_DISCONNECTED;
                    break;
                default:
                    connectionState = CS_CONNECTED;
                    break;
            }
            if((connectionState == CS_DISCONNECTED ) && (mDeviceInfo.connectionState == CS_ATTACHED))
            {
                // DO NOTHING
            }
            else if(mDeviceInfo.connectionState != connectionState)
            {
                mDeviceInfo.connectionState = connectionState;
                ETG_TRACE_USR3((" DVD SIGNAL USER DATA -- connection state is %x disc type is %x \n",mDeviceInfo.connectionState,mDeviceInfo.discType));
                LocalSPM::GetDBManager().UpdateDiscType(mDeviceInfo.deviceID,mDeviceInfo.discType);
                VARTRACE(mDeviceInfo.deviceID);
                tDeviceInfo deviceInfo;
                LocalSPM::GetDBManager().GetDeviceInfo(deviceInfo,mDeviceInfo.deviceID);

                VARTRACE(deviceInfo);
                if( (mDeviceInfo.connectionState  == CS_CONNECTED) && (m_pDVDControlInterface))
                {
                    tNumberOfFiles numberOfFiles = (tNumberOfFiles) (m_pDVDControlInterface->getNumberOfTracks()) ;
                    if(deviceInfo.numberOfAudioFiles != numberOfFiles)
                    {
                        LocalSPM::GetDBManager().SetNumberOfAudioFiles(mDeviceInfo.deviceID,numberOfFiles);
                    }
                }
                ret = LocalSPM::GetDBManager().SetConnectionState(mDeviceInfo.deviceID,mDeviceInfo.connectionState,DR_INTERNALDISCONNECT);
                VARTRACE(deviceInfo);

                //Moved to attached state when CustomControl::HandleDeviceRemoved is completed to avoid delays in announcing the source availability  - REF:NCG3D-100247
                VARTRACE(deviceInfo);
            }
            break;
        }
        case USRDATA_PLAYBACK_STATUS_UPDATES:
        {
            if(m_bIsDVDControlActive)
            {

                tPEPlaybackState playbackState;
                int speed;
                tUInt currentTrackNo;
                tUInt currentGroupNo;
                tPlaytime elspsedTime;
                tPlaytime totalTime;

                SMF::UnMarshal(userData, DOUBLE_MARSHAL_SEPARATOR, "iiiiii" ,&playbackState,&speed,&currentTrackNo,&currentGroupNo,&elspsedTime,&totalTime);
                VARTRACE(playbackState);
                VARTRACE(speed);
                VARTRACE(currentTrackNo);
                VARTRACE(currentGroupNo);
                VARTRACE(elspsedTime);
                VARTRACE(totalTime);

                ret = UpdatePlaybackStatus(playbackState,speed,currentTrackNo,currentGroupNo,elspsedTime,totalTime);
            }
            break;
        }
        case USRDATA_DVD_RESUME_INFO_UPDATE:
        {
            m_resumeCount ++;
            if(m_resumeCount == MAX_RESUME_COUNT)
            {
                m_resumeCount = 0;
                if(m_resumeBuffer[0] == BE_COMMAND_RESPONSE_INFO)
                {
                    tDVDInfoBlob resumeblob;
                    resumeblob.data = m_resumeBuffer;
                    resumeblob.dataSize = sizeof(m_resumeBuffer);
                    LocalSPM::GetDBManager().StoreDVDResumeInfo(resumeblob);
                }
            }
            break;
        }
        case USRDATA_PLAYBACK_MODE_UPDATES:
        {
            if(m_bIsDVDControlActive)
            {
                int value;
                SMF::UnMarshal(userData,DOUBLE_MARSHAL_SEPARATOR, "i",&value);
                switch(value)
                {
                    case FUNCTION_OFF :
                        ForwardRepeatModeStatus(RPT_ALL);
                        ForwardPlaybackModeStatus(PBM_NORMAL);
                        break;
                    case DISC_REPEAT_ON :
                        ForwardRepeatModeStatus(RPT_ALL);
                        ForwardPlaybackModeStatus(PBM_NORMAL);
                        break;
                    case TRACK_CHAPTER_REPEAT:
                        ForwardRepeatModeStatus(RPT_ONE);
                        ForwardPlaybackModeStatus(PBM_NORMAL);
                        break;
                    case RANDOM :
                        ForwardPlaybackModeStatus(PBM_RANDOM);
                        ForwardRepeatModeStatus(RPT_NONE);
                        break;
                    case ONE_TRACK_PLAY :
                        ForwardPlaybackModeStatus(PBM_NORMAL);
                        ForwardRepeatModeStatus(RPT_ALL);
                        break;
                    case GROUP_TITLE_REPEAT:
                        ForwardRepeatModeStatus(RPT_LIST);
                        ForwardPlaybackModeStatus(PBM_NORMAL);
                        break;
                    default :
                        ETG_TRACE_USR1(("OperationInfoData:Playback Mode unidentified"));
                        break;
                }
            }
            break;
        }
        case USRDATA_DISKERROR_UPDATES:
        {
            tU8 value;
            SMF::UnMarshal(userData,DOUBLE_MARSHAL_SEPARATOR, "i",&value);
            if(DISC_NO_ERROR!=value)
            {
                mDvdDiscError.isError = true;
            }
            else
            {
                mDvdDiscError.isError = false;
            }
            mDvdDiscError.diskError = value;
            LocalSPM::GetOutputWrapper().UpdateDVDProperty(DISCERROR);
            break;
        }
        case USRDATA_DRIVEMODE_UPDATES:
        {
            tU8 value;
            SMF::UnMarshal(userData,DOUBLE_MARSHAL_SEPARATOR, "i",&value);

            m_dvdDriveMode = (tOperationModeStatus) value;
            LocalSPM::GetOutputWrapper().UpdateDVDProperty(DVDDRIVEINFO);
            break;
        }
        case USRDATA_MECHANICAL_STATUS_UPDATES:
        {
            tU8 value;
            SMF::UnMarshal(userData,DOUBLE_MARSHAL_SEPARATOR, "i",&value);
            mDiscMechanicalInfo = value;
            if(value == DURING_DISC_EJECT)
            {
                StopVideoStreaming(); /*Call stop video streaming since its ejection to stop the pipeline in advance*/
                VARTRACE(mDeviceInfo.discType);
                //check if the disc is data disc, on auto-reinsertion it has to be checked as device type DTY_CDROM
                if(mDeviceInfo.discType == DISC_DATA)
                {
                    m_bdatadiscReinserted = true;
                }

                // Code to determine auto insertion
                m_bAutoReinsert = true;
                LocalSPM::GetDBManager().setFormerConnectionState(mDeviceInfo.deviceID , CS_DISCONNECTED);
                VARTRACE(m_bdatadiscReinserted);
                VARTRACE(m_bAutoReinsert);
            }
            else if(value == DISC_EJECT_FINISH_NO_DISC)
            {
                m_bAutoReinsert = false;
                m_bdatadiscReinserted = false;
                VARTRACE(m_bAutoReinsert);
            }
            else if(value == DISC_CHUCKING)
            {
                if(m_bAutoReinsert == true)
                {
                    //if data disc, update the former connection state of DTY_CDROM
                    if(m_bdatadiscReinserted == true)
                    {
                        m_bdatadiscReinserted = false;
                        LocalSPM::GetDBManager().UpdateFormerConnectionState(IN DTY_CDROM,IN CS_AUTO_REINSERTED);
                        VARTRACE(m_bdatadiscReinserted);
                        VARTRACE(mDeviceInfo.formerConnectionState);
                    }
                    LocalSPM::GetDBManager().setFormerConnectionState(mDeviceInfo.deviceID , CS_CONNECTED);
                    m_bAutoReinsert = false;
                    VARTRACE(m_bAutoReinsert);
                }
            }
            LocalSPM::GetOutputWrapper().UpdateDVDProperty(DISCMECHANICALINFO);
            break;
        }
        case USRDATA_DVD_DISPLAYMODE_UPDATES:
        {
            LocalSPM::GetOutputWrapper().UpdateDVDProperty(DISPLAYMODE);
            break;
        }
        case USRDATA_DVD_SKIP_UPDATES:
        {
            tU8 value;
            SMF::UnMarshal(userData,DOUBLE_MARSHAL_SEPARATOR, "i",&value);
            mCMSkipAvailable = value;
            LocalSPM::GetOutputWrapper().UpdateDVDProperty(CMSKIPAVAILABLE);
            break;
        }
        case USRDATA_DVD_MENUPLAYBACK_MODE:
        {
            tU8 value;
            SMF::UnMarshal(userData,DOUBLE_MARSHAL_SEPARATOR, "i",&value);
            //Changed for touch screen  - direct touch control
            if(value == 1)
            {
                m_touchHandler.toucheventhandler_monitor_start();
            }
            else
            {
                m_touchHandler.toucheventhandler_monitor_stop();
            }
            mMenuPlayback = value;
            LocalSPM::GetOutputWrapper().UpdateDVDProperty(DVDMENUPLAYBACKONGOING);
            break;
        }
        case USRDATA_DVD_TRACK_CHANGE:
        {
            tU8 totalTrack = 0;
            SMF::UnMarshal(userData,DOUBLE_MARSHAL_SEPARATOR, "i",&totalTrack);
            VARTRACE(totalTrack);
            tDeviceInfo deviceInfo;
            LocalSPM::GetDBManager().GetDeviceInfo(deviceInfo,mDeviceInfo.deviceID);
            VARTRACE(deviceInfo);
            if((totalTrack > 0) && (mDeviceInfo.connectionState == CS_CONNECTED) &&  (mDeviceInfo.numberOfAudioFiles <= 0))
            {
                LocalSPM::GetDBManager().SetNumberOfAudioFiles(mDeviceInfo.deviceID,totalTrack);
            }
            break;
        }
        case USRDATA_DVD_ANGLE_MARK_UPDATES:
        {
            LocalSPM::GetOutputWrapper().UpdateDVDProperty(ANGLEMARKSETTING);
            break;
        }
        case USRDATA_DVD_PLAYER_LANGUAGE_UPDATES:
        {
            LocalSPM::GetOutputWrapper().UpdateDVDProperty(DVDPLAYERLANGSETTING);
            break;
        }
        case USRDATA_DVD_DIRECTSELECT_UPDATES:
        {
            tU8 value;
            SMF::UnMarshal(userData,DOUBLE_MARSHAL_SEPARATOR, "i",&value);
            mDirectSelectAvailable = value;
            LocalSPM::GetOutputWrapper().UpdateDVDProperty(DIRECTSELECTAVAILABLE);
            break;
        }
        case USRDATA_DVD_DRC_SETTINGS_UPDATES:
        {
            LocalSPM::GetOutputWrapper().UpdateDVDProperty(DRCSETTING);
            break;
        }
        case USRDATA_DVD_PLAYSTATUSSETTING_UPDATES:
        {
            LocalSPM::GetOutputWrapper().UpdateDVDProperty(PLAYSTATUSSETTING);
            break;
        }
        case USRDATA_DVD_ANGLEINFO_UPDATES:
        {
            tU8 AngleNumber;
            tU8 TotalAngle;
            SMF::UnMarshal(userData,DOUBLE_MARSHAL_SEPARATOR, "ii", &AngleNumber, &TotalAngle);
            mDVDAngleInfo.AngleNumber = AngleNumber;
            mDVDAngleInfo.TotalAngle = TotalAngle;
            LocalSPM::GetOutputWrapper().UpdateDVDProperty(DVDANGLEINFO);
            break;
        }
        case USRDATA_DVD_SUBTITLEINFO_UPDATES:
        {
            tBool subtitleState ;
            tU8 Currentsubtitle;
            tU8 Totalsubtitle;
            tU8 langcode0;
            tU8 langcode1;

            SMF::UnMarshal(userData,DOUBLE_MARSHAL_SEPARATOR, "iiiii", &subtitleState, &Currentsubtitle, &Totalsubtitle ,&langcode0 ,&langcode1 );
            VARTRACE(langcode0);
            VARTRACE(langcode1);
            mDVDSubtitleInfo.SubtitleStatus= subtitleState;
            mDVDSubtitleInfo.CurrentSubtitleNumber = Currentsubtitle;
            mDVDSubtitleInfo.TotalSubtitleNumber = Totalsubtitle;
            mDVDSubtitleInfo.SubtitleLangCode[0] = (unsigned char )langcode0;
            mDVDSubtitleInfo.SubtitleLangCode[1] = (unsigned char )langcode1;
            LocalSPM::GetOutputWrapper().UpdateDVDProperty(DVDSUBTITLEINFO);
            break;
        }
        case USRDATA_DVD_AUDIOCHANNEL_UPDATES:
        {
            tU8 totalChannels ;
            tBool SubWooferAvailable;
            tU8 currentAssignment;

            SMF::UnMarshal(userData,DOUBLE_MARSHAL_SEPARATOR, "iii", &totalChannels, &SubWooferAvailable, &currentAssignment);
            mDVDAudioChannelInfo.totalChannels = totalChannels;
            mDVDAudioChannelInfo.subWooferAvailable = SubWooferAvailable;
            mDVDAudioChannelInfo.currentAssignment = currentAssignment;
            LocalSPM::GetOutputWrapper().UpdateDVDProperty(DVDAUDIOCHANNELINFO);
            break;
        }
        case USRDATA_DVD_AUDIO_OUTPUT_UPDATES:
        {
            tU8 soundFormat;
            tU8 VcdAudio;
            tU8 DvdAudio;
            tU8 TotalAudio;
            tU8 langcode0;
            tU8 langcode1;
            SMF::UnMarshal(userData,DOUBLE_MARSHAL_SEPARATOR, "iiiiii", &TotalAudio, &soundFormat,&DvdAudio,&VcdAudio,&langcode0,&langcode1);
            VARTRACE(langcode0);
            VARTRACE(langcode1);
            mDVDAudioOutput.totalAudioChannels = TotalAudio;
            mDVDAudioOutput.SoundFormat = soundFormat;
            mDVDAudioOutput.AudioOutputVCD = VcdAudio;
            mDVDAudioOutput.AudioOutputDVD = DvdAudio;
            mDVDAudioOutput.AudioLangCode[0] = (unsigned char )langcode0;
            mDVDAudioOutput.AudioLangCode[1] = (unsigned char )langcode1;
            LocalSPM::GetOutputWrapper().UpdateDVDProperty(DVDCURRENTAUDIOINFO);
            // If Current State == Ripping , then forward the event AUDIO_FORMAT when it is != INVALID FORMAT
            if((IsInState(Ripping)== 1) && (mDVDAudioOutput.SoundFormat!= CD_AUDIO_INVALID))
            {

                tAllParameters parameterString;
                size_t size = sizeof(parameterString);
                ParameterAUDIO_FORMAT(OUT parameterString, IN size, IN (tAudioFormat)mDVDAudioOutput.SoundFormat);
                SendEvent(AUDIO_FORMAT, IN parameterString);

            }
            break;
        }
        case USRDATA_DVD_KEY_RESPONSE_UPDATES:
        {
            tU8 value;
            SMF::UnMarshal(userData,DOUBLE_MARSHAL_SEPARATOR, "i",&value);
            mKeyCommandResponse = value;
            if(m_bIsDVDControlActive)
            {
                m_bResponseReceived = true;
                LocalSPM::GetOutputWrapper().UpdateDVDProperty(KEYCOMMANDRESPONSE);
            }
            break;
        }
        case USRDATA_DVD_VIDEO_SOURCE_STATUS:
        {
            tU8 value;
            SMF::UnMarshal(userData,DOUBLE_MARSHAL_SEPARATOR, "i",&value);
            if(value == VIDEO_SOURCE_STATUS_ACTIVE)
            {
                StartVideoStreaming();
            }
            else if(value == VIDEO_SOURCE_STATUS_UNKNOWN)
            {
                VARTRACE("### UNKNOWN , do nothing ###");
            }
            else if((value != VIDEO_SOURCE_STATUS_ACTIVE)||(value != VIDEO_SOURCE_STATUS_ACTIVATING))
            {
                if((m_bVideoStreaming == false) && (value == VIDEO_SOURCE_STATUS_BLOCKED))
                {
                    VARTRACE("###BLOCKED , do nothing###");
                }
                else
                {
                StopVideoStreaming();
                }
            }
            break;
        }
        case USRDATA_DVD_EJECT:
        {
            tU8 value;
            SMF::UnMarshal(userData,DOUBLE_MARSHAL_SEPARATOR, "i",&value);
            tResult retVal= -1;
            if(m_pDVDControlInterface && tDiscMechanism::EJECT_DISC == value)
            {

                if(IsInState(Ripping)== 1) // Its in Ripping state , eject should happen only when RIPPERSM is informed & done ripping is called
                {
                    StopRipping();
                }
                else
                {
                    m_bAlreadyRipped = false; // disc is going to be ejected , change the state of Ripping
                    setGNMetadataAvailable(false);
                    retVal = ejectDisc();
                    clearTOC();
                }
            }
            break;
        }
        case USRDATA_DVD_TEMPERATURE_REQUEST:
        {
            if(m_pDVDControlInterface)
            {
                tResult ret = m_pDVDControlInterface->getTemperature();
            }
            break;
        }
        case USRDATA_DVD_TEMPERATURE_RESPONSE:
        {
            tU16 temperature;
            SMF::UnMarshal(userData,DOUBLE_MARSHAL_SEPARATOR, "i",&temperature);
            // UPDATE METHOD RESULT
            VARTRACE(temperature)
            LocalSPM::GetOutputWrapper().SendRequestDVDTemperatureAnswer(temperature,m_tempUserContext);
            break;
        }
        default:
        {
            ETG_TRACE_USR1(("SignalUserData:Not Handle"));
            break;
        }

    }

    return ret;
}

tResult DVDControl::FinishedGNfetch(tMetadataAvailablefromGN GNdataAvailable)
{
    ENTRY
    tResult res= MP_NO_ERROR;
    if(GNdataAvailable == true)
    {
        LocalSPM::GetCDRipperControl().GetGracenoteDatafromMap(mGNMetadata);
        //check for data availability in GN metadata map
        if(mGNMetadata.size() > 0)
        {
            setGNMetadataAvailable(true);
            //gracenote metadata received successfully. Update now playing metadata with gracenote
            m_bSendSourceSwitchNowPlayingUpdate = true;
        }
    }
    else
    {
        setGNMetadataAvailable(false);
    }
    return res;
}

tResult DVDControl::setGNMetadataAvailable(bool GNDataAvailable)
{
    ENTRY
    Locker locker(&m_GNdatalock);
    tResult ret = MP_NO_ERROR;
    VARTRACE(GNDataAvailable);
    m_bMetadataavailablefromGN = GNDataAvailable;
    VARTRACE(m_bMetadataavailablefromGN);

    return ret;
}

bool DVDControl::getGNMetadataAvailable()
{
    ENTRY
    Locker locker(&m_GNdatalock);
    VARTRACE(m_bMetadataavailablefromGN);
    bool GNDataAvailable = m_bMetadataavailablefromGN;
    return GNDataAvailable;
}

tResult DVDControl::UpdatePlaybackStatus(tPEPlaybackState playbackState,int speed,tUInt currentTrackNo,tUInt currentGroupNo,tPlaytime elspsedTime,tPlaytime totalTime)
{
    ENTRY
    tResult res = MP_NO_ERROR;
    tAllParameters args;

    if((mPlaybackState != playbackState)||(m_bSendSourceSwitchNowPlayingUpdate == true))
    {
        Marshal((char *)args, sizeof(args)-1, "lill",(tU64)m_PlayMediaObject.objectID,(int)playbackState, REASON_OK ,1);

        res = SendEvent(PLAYBACK_STATUS, IN args);

    }
    ETG_TRACE_USR4(("UpdatePlaybackStatus Track No:%x , Group No:%x ",currentTrackNo,currentGroupNo));

    if((mTrackNo != currentTrackNo)||(m_bSendSourceSwitchNowPlayingUpdate == true)||(mGroupNo != currentGroupNo))
    {
        if(m_pDVDControlInterface)
        {
            VARTRACE(mDeviceInfo.discType);
            VARTRACE(m_bMetadataavailablefromGN);
            if(mDeviceInfo.discType == DISC_AUDIO_CD && getGNMetadataAvailable() == true)
            {
                //If gracenote data available, get track info from gracenote
                GetTrackTextInfoFromGN(&mtocData, (unsigned char)currentTrackNo);
            }
            else
            {
                m_pDVDControlInterface->getTrackTextInfo(&mtocData,(unsigned char)currentTrackNo);
            }
        }
        /* Check the metadata values. Fill UNKNOWN text if value is empty. */
        if(0 == strlen_r(mtocData.metaData1))
        {
            strncpy_r(OUT mtocData.metaData1, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(tMetadata));
        }
        if(0 == strlen_r(mtocData.metaData2))
        {
            strncpy_r(OUT mtocData.metaData2, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(tMetadata));
        }
        if(0 == strlen_r(mtocData.metaData3))
        {
            strncpy_r(OUT mtocData.metaData3, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(tMetadata));
        }
        if(0 == strlen_r(mtocData.metaData4))
        {
            strncpy_r(OUT mtocData.metaData4, IN LocalSPM::GetDataProvider().DBUnknownText().c_str(), IN sizeof(tMetadata));
        }

        Marshal((char *)args, sizeof(args)-1, "lt", (tU64)m_PlayMediaObject.objectID, mtocData.fileName);
        res = SendEvent(NOW_PLAYING_STATUS, IN args);
        if(m_bSendSourceSwitchNowPlayingUpdate)
        {
            m_bSendSourceSwitchNowPlayingUpdate = false ;
        }
    }

    mPlaybackState = playbackState;
    mTrackNo = currentTrackNo;
    mGroupNo = currentGroupNo;


    if((PE_PBS_PLAYINGSTATE == playbackState) || (PE_PBS_FASTREVERSESTATE== playbackState) || (PE_PBS_FASTFORWARDSTATE == playbackState))
    {
        tPETimeInfoStruct timeInfoStruct;
        InitPETimeInfoStruct(timeInfoStruct);

        timeInfoStruct.position.ms = (tPEMilliseconds)elspsedTime;
        timeInfoStruct.duration.ms = (tPEMilliseconds)totalTime;


        tPETimeInfo timeInfoString;
        size_t size = sizeof(timeInfoString);
        SMF::Marshal(OUT timeInfoString,
                IN size-1,
                IN DOUBLE_MARSHAL_SEPARATOR,
                IN tPEBytes_format tPEPercentage_format tPEMilliseconds_format tPEBytes_format tPEMilliseconds_format,
                IN timeInfoStruct.position.bytes,
                IN timeInfoStruct.position.pct,
                IN timeInfoStruct.position.ms,
                IN timeInfoStruct.duration.bytes,
                IN timeInfoStruct.duration.ms);

        //tAllParameters args;
        Marshal((char *)args, sizeof(args)-1, "lt", (tU64)m_PlayMediaObject.objectID, IN timeInfoString);

        res = SendEvent(PLAYTIME_STATUS, IN args);

    }

    return res;
}

tResult DVDControl::SetPlaybackMode(const tDeviceType deviceType,const tDeviceID deviceID,
        const tMountPoint mountPoint,const tPlaybackMode playbackMode)
{
    ENTRY
    (void)deviceType;
    (void)deviceID;
    (void)mountPoint;

    tResult ret = MP_NO_ERROR;
    tPlaybackFunctionControl Value = FUNC_COMMAND_OFF;

    if(m_bResponseReceived)
    {
        switch(playbackMode)
        {
            case PBM_NORMAL:
                Value = FUNC_COMMAND_OFF;
                break;

            case PBM_RANDOM:
                Value = FUNC_COMMAND_RANDOM;
                break;

            default:
                break;
        }

        if(m_pDVDControlInterface)
        {
            m_pDVDControlInterface->setPlaybackMode(Value);
            m_bResponseReceived = false;
        }
    }
    else
    {
        ETG_TRACE_USR4(("SetPlaybackMode RANDOM not set - multiple requests"));
    }
    return ret;

}
tResult DVDControl::SetRepeatMode(const tDeviceType deviceType,const tDeviceID deviceID,
        const tMountPoint mountPoint,const tRepeatMode repeatMode)
{
    ENTRY
    (void)deviceType;
    (void)deviceID;
    (void)mountPoint;

    tResult ret = MP_NO_ERROR;
    tPlaybackFunctionControl Value = FUNC_COMMAND_OFF;
    if(m_bResponseReceived)
    {
        switch(repeatMode)
        {
            case RPT_NONE:
                Value = FUNC_COMMAND_OFF;
                break;

            case RPT_ONE:
                Value = FUNC_COMMAND_TRACK_REPEAT;
                break;

            case RPT_LIST:
                Value = FUNC_COMMAND_GROUP_REPEAT;
                break;

            case RPT_LIST_WITH_SUBLISTS:
            case RPT_ALL:
                Value = FUNC_COMMAND_OFF;
            default:
                break;
        }
        if(m_pDVDControlInterface)
        {
            m_pDVDControlInterface->setPlaybackMode(Value);
            m_bResponseReceived = false;
        }
    }
    else
    {
        ETG_TRACE_USR4(("SetRepeatMode REPEAT not set - multiple requests"));
    }
    return ret;
}
void DVDControl::ForwardRepeatModeStatus(tRepeatMode repeatMode)
{
    ENTRY
    VARTRACE(repeatMode);
    char messageString[64];
    strncpy_r(OUT messageString, IN "PlayerManagerSM::REPEAT_MODE_STATUS", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    LocalSPM::GetPlayerManager().ParameterREPEAT_MODE_STATUS( OUT parameterString, IN size, IN m_PlayMediaObject.deviceID, IN repeatMode);
    Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
}
void DVDControl::ForwardPlaybackModeStatus(tPlaybackMode playbackMode)
{
    ENTRY
    VARTRACE(playbackMode);
    char messageString[64];
    strncpy_r(OUT messageString, IN "PlayerManagerSM::PLAYBACK_MODE_STATUS", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    LocalSPM::GetPlayerManager().ParameterPLAYBACK_MODE_STATUS( OUT parameterString, IN size, IN m_PlayMediaObject.deviceID, IN playbackMode);
    Dispatcher::GetInstance().SendMessage(IN messageString, IN parameterString);
}

void DVDControl::DVDCallbacks::signalResumeInfo(ResumeBuffer& resumeBuffer)
{
    ENTRY

    ETG_TRACE_USR1((" DVDControl::DVDCallbacks::signalResumeInfo"));
    memcpy(m_resumeBuffer,resumeBuffer,sizeof(ResumeBuffer));
    /*
    ETG_TRACE_USR4(("\n resume data stored signalResumeInfo is : \n"));
    for(unsigned int i=0 ; i< sizeof(m_resumeBuffer);i++)
    {
        ETG_TRACE_USR4(("\t %x ",m_resumeBuffer[i] ));
    }*/

    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    const tUserDataType userDataType = USRDATA_DVD_RESUME_INFO_UPDATE;
    tUserData userData = {0};

    LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
    LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
    return;
}


void DVDControl::DVDCallbacks::signalEventAngleChange(tDVDAngleInfo& angleInfo)
{
    ENTRY
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    const tUserDataType userDataType = USRDATA_DVD_ANGLEINFO_UPDATES;
    tUserData userData = {0};

    SMF::Marshal(userData, sizeof(userData) - 1,DOUBLE_MARSHAL_SEPARATOR, "ii",
            (tUInt)angleInfo.AngleNumber,(tUInt)angleInfo.TotalAngle);

    LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
    LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
}

void DVDControl::DVDCallbacks::signalEventSubtitleChange(tDVDSubtitleInfo& subtitle)
{
    ENTRY
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    const tUserDataType userDataType = USRDATA_DVD_SUBTITLEINFO_UPDATES;
    tUserData userData = {0};

    SMF::Marshal(userData, sizeof(userData) - 1,DOUBLE_MARSHAL_SEPARATOR, "iiiii",
            (tUInt)subtitle.SubtitleStatus,(tUInt)subtitle.CurrentSubtitleNumber,(tUInt)subtitle.TotalSubtitleNumber,(tUInt)subtitle.SubtitleLangCode[0],(tUInt)subtitle.SubtitleLangCode[1]);
    VARTRACE(subtitle.SubtitleLangCode[0]);
    VARTRACE(subtitle.SubtitleLangCode[1]);
    LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
    LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
}

void DVDControl::DVDCallbacks::signalEventAudioInfoChange(tDVDAudioChannelInfo& audioChannel)
{
    ENTRY
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    const tUserDataType userDataType = USRDATA_DVD_AUDIOCHANNEL_UPDATES;
    tUserData userData = {0};

    SMF::Marshal(userData, sizeof(userData) - 1,DOUBLE_MARSHAL_SEPARATOR, "iii",
            (tUInt)audioChannel.totalChannels,(tUInt)audioChannel.subWooferAvailable,(tUInt)audioChannel.currentAssignment);

    LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
    LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);

}
void DVDControl::DVDCallbacks::signalEventCurrentAudioChange(tDVDAudioOutputInfo& audioOutputInfo)
{
    ENTRY
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    const tUserDataType userDataType = USRDATA_DVD_AUDIO_OUTPUT_UPDATES;
    tUserData userData = {0};

    SMF::Marshal(userData, sizeof(userData) - 1,DOUBLE_MARSHAL_SEPARATOR, "iiiiii",
            audioOutputInfo.totalAudioChannels,(tUInt)audioOutputInfo.SoundFormat,(tUInt)audioOutputInfo.AudioOutputDVD,(tUInt)audioOutputInfo.AudioOutputVCD,(tUInt)audioOutputInfo.AudioLangCode[0] ,(tUInt)audioOutputInfo.AudioLangCode[1] );
    VARTRACE(audioOutputInfo.AudioLangCode[0]);
    VARTRACE(audioOutputInfo.AudioLangCode[1]);
    LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
    LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);

}
void DVDControl::DVDCallbacks::signalEventSetupInfoChange(tDVDSetupInfo& setupInfo)
{
    ENTRY
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tUserDataType userDataType;
    tUserData userData = {0};

    if((setupInfo.AngleMark != mDvdSetupInfo.AngleMark)||(m_bFirstTimeSetupInfo == true))
    {
        mDvdSetupInfo.AngleMark = setupInfo.AngleMark;
        userDataType =  USRDATA_DVD_ANGLE_MARK_UPDATES;
        LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
        LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
    }
    if((setupInfo.DRCSetting != mDvdSetupInfo.DRCSetting)||(m_bFirstTimeSetupInfo == true))
    {
        mDvdSetupInfo.DRCSetting = setupInfo.DRCSetting;
        userDataType = USRDATA_DVD_DRC_SETTINGS_UPDATES;
        LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
        LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
    }
    if((setupInfo.PlayStatus != mDvdSetupInfo.PlayStatus)||(m_bFirstTimeSetupInfo == true))
    {
        mDvdSetupInfo.PlayStatus = setupInfo.PlayStatus;
        userDataType = USRDATA_DVD_PLAYSTATUSSETTING_UPDATES ;
        LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
        LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
    }
    if((setupInfo.DisplayMode != mDvdSetupInfo.DisplayMode)||(m_bFirstTimeSetupInfo == true))
    {
        mDvdSetupInfo.DisplayMode = setupInfo.DisplayMode;
        userDataType = USRDATA_DVD_DISPLAYMODE_UPDATES;
        LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
        LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
    }
    if((memcmp(&setupInfo ,&mDvdSetupInfo,6) != 0)||(m_bFirstTimeSetupInfo == true))
    {
        memcpy(&mDvdSetupInfo,&setupInfo,6);
        userDataType = USRDATA_DVD_PLAYER_LANGUAGE_UPDATES;
        LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
        LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
    }
    if(m_bFirstTimeSetupInfo)
    {
        memcpy(&mDvdSetupInfo,&setupInfo,sizeof(mDvdSetupInfo));
        m_bFirstTimeSetupInfo = false;
    }
}

tResult DVDControl::GetDiskError(OUT tBool& isError, OUT tU8& diskError)
{
    ENTRY
    isError = mDvdDiscError.isError;
    diskError = mDvdDiscError.diskError;
    ETG_TRACE_USR1(("iserror = %x - diskerror = %x", isError, diskError));
    return MP_NO_ERROR;
}
tResult DVDControl::GetDiskMechanicalInfo(OUT tU8& mechanicalInfo)
{
    ENTRY
    mechanicalInfo = mDiscMechanicalInfo;
    ETG_TRACE_USR1(("MechanicalInfo = %d", mechanicalInfo));
    return MP_NO_ERROR;
}
tResult DVDControl::GetDVDDriveInfo(OUT tU8& disctype,tU8& drivemode)
{
    ENTRY
    disctype = m_bIsDataDisc;
    drivemode = m_dvdDriveMode;
    ETG_TRACE_USR1(("DiscType = %x - DriveMode = %x", disctype, m_dvdDriveMode));
    return MP_NO_ERROR;
}
tResult DVDControl::GetSkipInfo(OUT tBool& skip)
{
    ENTRY
    skip = mCMSkipAvailable;
    ETG_TRACE_USR4(("GetDvdSkipInfo = %d", skip));
    return MP_NO_ERROR;
}
tResult DVDControl::GetMenuPlaybackOngoing(OUT tBool& menuOngoing)
{
    ENTRY
    menuOngoing = mMenuPlayback;
    ETG_TRACE_USR4(("GetMenuPlaybackOngoing = %d", menuOngoing));
    return MP_NO_ERROR;
}
tResult DVDControl::GetDirectSelectInfo(OUT tBool& dirceSelect)
{
    ENTRY
    dirceSelect = mDirectSelectAvailable;
    ETG_TRACE_USR4(("GetDvdDirectSelectInfo = %d", dirceSelect));
    return MP_NO_ERROR;
}
tResult DVDControl::GetKeyCommandResponse(OUT tU8& responseInfo)
{
    ENTRY
    responseInfo = mKeyCommandResponse;
    ETG_TRACE_USR1(("GetKeyCommandResponse = %d", responseInfo));
    return MP_NO_ERROR;
}

tResult DVDControl::GetAngleInfo(OUT tU8& angleTrack, tU8& totalAngle)
{
    ENTRY
    angleTrack = mDVDAngleInfo.AngleNumber;
    totalAngle = mDVDAngleInfo.TotalAngle;

    ETG_TRACE_USR1(("GetDvdAngleInfoInfo = %d ::: %d", angleTrack, totalAngle));
    return MP_NO_ERROR;
}

tResult DVDControl::GetSubtitleInfo(OUT tBool &state, OUT tU8& current, tU8& total , tU16& subtitleLang)
{
    ENTRY
    state = mDVDSubtitleInfo.SubtitleStatus;
    current = mDVDSubtitleInfo.CurrentSubtitleNumber;
    total = mDVDSubtitleInfo.TotalSubtitleNumber;
    subtitleLang = CD_8TO16(mDVDSubtitleInfo.SubtitleLangCode[0], mDVDSubtitleInfo.SubtitleLangCode[1]);

    ETG_TRACE_USR1(("GetDvdSubtitleInfo = %d ::: %d  ::: %d ::: %d" , state, current, total ,subtitleLang));
    return MP_NO_ERROR;
}

tResult DVDControl::GetAudioChannelInfo(OUT tU8& totalChannels, OUT tBool& subWoofer, tU8& Assignment)
{
    ENTRY
    totalChannels = mDVDAudioChannelInfo.totalChannels;
    subWoofer = mDVDAudioChannelInfo.subWooferAvailable;
    Assignment = mDVDAudioChannelInfo.currentAssignment;

    ETG_TRACE_USR1(("GetDvdAudioChannelInfo = %d ::: %d  ::: %d", totalChannels, subWoofer, Assignment));

    return MP_NO_ERROR;
}

tResult DVDControl::GetDisplayMode(OUT tU8& displayMode)
{
    ENTRY
    displayMode = mDvdSetupInfo.DisplayMode;
    ETG_TRACE_USR1(("GetDvdDisplayMode = %d ", displayMode));

    return MP_NO_ERROR;
}

tResult DVDControl::SetDisplayMode(IN tU8 displayMode)
{
    ENTRY
    tDVDSetupInfo setupInfo;
    if(m_pDVDControlInterface)
    {
        m_pDVDControlInterface->GetSetupInformationData(setupInfo);
        setupInfo.DisplayMode = (tDisplaySetting)displayMode;
        ETG_TRACE_USR1(("GetDvdDisplayMode = %d ", displayMode));
        m_pDVDControlInterface->ChangeSetupInformationData(setupInfo);
    }
    return MP_NO_ERROR;
}

tResult DVDControl::GetPlayStatusSetting(OUT tBool& playStatus)
{
    ENTRY
    playStatus = mDvdSetupInfo.PlayStatus;

    ETG_TRACE_USR1(("GetDvdPlayStatusSetting = %d ", playStatus));

    return MP_NO_ERROR;
}

tResult DVDControl::SetPlayStatusSetting(IN tBool playStatus)
{
    ENTRY
    tDVDSetupInfo setupInfo;
    if(m_pDVDControlInterface)
    {
        m_pDVDControlInterface->GetSetupInformationData(setupInfo);
        setupInfo.PlayStatus = playStatus;
        ETG_TRACE_USR1(("SetDvdPlayStatusSetting = %d ", playStatus));
        m_pDVDControlInterface->ChangeSetupInformationData(setupInfo);
    }
    return MP_NO_ERROR;
}

tResult DVDControl::GetDRCSetting(OUT tU8& drc)
{
    ENTRY
    drc = mDvdSetupInfo.DRCSetting;

    ETG_TRACE_USR1(("GetDvdDRCSetting = %d ", drc));

    return MP_NO_ERROR;
}

tResult DVDControl::SetAngleMarkSetting(IN tBool AngleMark)
{
    ENTRY
    tDVDSetupInfo setupInfo;
    if(m_pDVDControlInterface)
    {
        m_pDVDControlInterface->GetSetupInformationData(setupInfo);
        setupInfo.AngleMark = AngleMark;
        ETG_TRACE_USR1(("AngleMarkSetting = %d ", AngleMark));
        m_pDVDControlInterface->ChangeSetupInformationData(setupInfo);
    }
    return MP_NO_ERROR;
}

tResult DVDControl::GetAngleMarkSetting(OUT tBool& AngleMark)
{
    ENTRY
    AngleMark = mDvdSetupInfo.AngleMark ;
    ETG_TRACE_USR1(("AngleMarkSetting = %d ", AngleMark));
    return MP_NO_ERROR;
}
tResult DVDControl::SetLanguageSetting(IN tU16 AudioLang, IN tU16 SubLang, IN tU16 MenuLang)
{
    ENTRY
    tDVDSetupInfo setupInfo;
    if(m_pDVDControlInterface)
    {
        m_pDVDControlInterface->GetSetupInformationData(setupInfo);
        setupInfo.DVDVideoAudioLang[0] = (unsigned char)(AudioLang >> 8);
        setupInfo.DVDVideoAudioLang[1] = (unsigned char)(AudioLang & 0xff);
        setupInfo.DVDVideoSubtitleLang[0] = (unsigned char)(SubLang >> 8);
        setupInfo.DVDVideoSubtitleLang[1] = (unsigned char)(SubLang & 0xff);
        setupInfo.DVDVideoMenuLang[0] = (unsigned char)(MenuLang >> 8);
        setupInfo.DVDVideoMenuLang[1] = (unsigned char)(MenuLang & 0xff);
        ETG_TRACE_USR1(("SetLanguageSetting = %d - %d - %d ", AudioLang, SubLang, MenuLang));
        m_pDVDControlInterface->ChangeSetupInformationData(setupInfo);
    }
    return MP_NO_ERROR;
}

tResult DVDControl::GetLanguageSetting(OUT tU16& AudioLang, OUT tU16& SubLang, OUT tU16& MenuLang)
{
    ENTRY
    AudioLang = CD_8TO16(mDvdSetupInfo.DVDVideoAudioLang[0], mDvdSetupInfo.DVDVideoAudioLang[1]);
    SubLang = CD_8TO16(mDvdSetupInfo.DVDVideoSubtitleLang[0], mDvdSetupInfo.DVDVideoSubtitleLang[1]);
    MenuLang = CD_8TO16(mDvdSetupInfo.DVDVideoMenuLang[0], mDvdSetupInfo.DVDVideoMenuLang[1]);
    ETG_TRACE_USR1(("GetLanguageSetting = %d - %d - %d ", AudioLang, SubLang, MenuLang));
    return MP_NO_ERROR;
}

tResult DVDControl::SetDRCSetting(IN tU8 drc)
{
    ENTRY
    tDVDSetupInfo setupInfo;
    if(m_pDVDControlInterface)
    {
        m_pDVDControlInterface->GetSetupInformationData(setupInfo);
        setupInfo.DRCSetting = (tDRC)drc;
        ETG_TRACE_USR1(("mDRCSetting = %d ", drc));
        m_pDVDControlInterface->ChangeSetupInformationData(setupInfo);
    }
    return MP_NO_ERROR;
}

tResult DVDControl::GetCurrentAudioInfo(OUT tU8& soundformat, OUT tU8& VcdAudio, OUT tU8& DvdAudio,OUT tU8& totalOutput,OUT tU16& Audiolang)
{
    ENTRY

    soundformat = mDVDAudioOutput.SoundFormat;
    VcdAudio = mDVDAudioOutput.AudioOutputVCD;
    DvdAudio = mDVDAudioOutput.AudioOutputDVD;
    totalOutput = mDVDAudioOutput.totalAudioChannels;
    Audiolang = CD_8TO16(mDVDAudioOutput.AudioLangCode[0], mDVDAudioOutput.AudioLangCode[1]);

    ETG_TRACE_USR1(("GetCurrentAudioInfo = %d :: %d :: %d :: %d :: %d", soundformat, VcdAudio, DvdAudio, totalOutput , Audiolang ));

    return MP_NO_ERROR;
}

tResult  DVDControl::StartRipping(tAudioFormat format)
{
    ENTRY
    VARTRACE(mDeviceInfo.connectionState);
    tResult ret = MP_NO_ERROR;
    if(m_pDVDControlInterface)
    {
        m_bAlreadyRipped = false;
        if( mDeviceInfo.connectionState  !=  CS_CONNECTED)
        {
            VARTRACE(mDeviceInfo.connectionState);
            mDeviceInfo.connectionState = CS_CONNECTED;
            LocalSPM::GetDBManager().SetConnectionState(mDeviceInfo.deviceID,mDeviceInfo.connectionState);
        }

        ETG_TRACE_USR4(("Inside StartRipping Before Audio Format Check"));
        if(format != CD_AUDIO_CD_DTS)
        {
            tCDTOCInfo* ptCDTOCInfo = new (tCDTOCInfo); // will be freed in ripper SM
            if(ptCDTOCInfo != NULL)
            {
                memset(ptCDTOCInfo,0,sizeof(tCDTOCInfo));
                memcpy(ptCDTOCInfo,&m_CDTOCInfo,sizeof(tCDTOCInfo));// copy from member variable
            }
            // call switch to mass storage mode and disable polling
            m_pDVDControlInterface->SwitchtoMassStorageModeDisablePolling();
            ETG_TRACE_USR4(("Inside StartRipping"));
            char messageString[64];
            strncpy_r(OUT messageString, IN "RipperSM::AUDIO_DISC_DETECTED ", IN sizeof(messageString));

            ETG_TRACE_USR1(("############# TOC BUffer: ###################"));
            ETG_TRACE_USR1(("TOC Buffer :: "));
            ETG_TRACE_USR1(("TOC mountPoint: %s ",ptCDTOCInfo->m_MountPoint));
            ETG_TRACE_USR1(("TOC mintrack:%x maxtrack %x ",ptCDTOCInfo->u8MinTrack,ptCDTOCInfo->u8MaxTrack));
            ETG_TRACE_USR1(("TOC albumname %s ",ptCDTOCInfo->albumName));

            for(int i = 0 ; i < ptCDTOCInfo->u8MaxTrack ;i++)
            {
                ETG_TRACE_USR1(("Track index : %x address %x title %s ",i,ptCDTOCInfo->arTrack[i].u32StartZLBA ,ptCDTOCInfo->arTrack[i].title ));
                ETG_TRACE_USR1(("Track index : %x performer %s ",i,ptCDTOCInfo->arTrack[i].performer));
            }
            //Cancel fetching of Gracenote data when ripping request comes, Ripping gets priority
            LocalSPM::GetCDRipperControl().CancelGNFetchIfInProgress();

            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            ret = LocalSPM::GetCDRipperControl().ParameterAUDIO_DISC_DETECTED(OUT parameterString,
                    IN size, IN ptCDTOCInfo);
            ret = LocalSPM::GetCDRipperControl().SendEventByName("AUDIO_DISC_DETECTED", IN parameterString);
        }
        else
        {
            tDoneRippingAnswerRequired isRippingAnswerRequired = 0;
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            ret = DVDControlSM::ParameterDONE_RIPPING(OUT parameterString, IN size, IN isRippingAnswerRequired);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                parameterString[0] = '\0';
            }
            else
            {
                ret = SendEvent(DONE_RIPPING, parameterString);
            }

        }
    }
    return ret;
}

tResult  DVDControl::StopRipping()
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    LocalSPM::GetCDRipperControl().SendEventByName("STOP_RIPPING", IN NULL);
    m_bEjectAfterDoneRipping = true;
    return 0;
}

tResult  DVDControl::DoneRipping(const tDoneRippingAnswerRequired isRippingAnswerRequired)
{

    ENTRY

    if(m_bEjectAfterDoneRipping == true)
    {
        if(m_pDVDControlInterface)
        {
            tResult retval = ejectDisc();
            if(retval != MP_NO_ERROR)
            {
                m_bAlreadyRipped = true; // disc unable to eject , at least let it start playback & while detecting disc again , do not call Ripper
            }
            else
            {
                clearTOC();
                m_bAlreadyRipped = false; // disc is ejected , change the state of Ripping so it will start ripping for next CD
            }
        }
        m_bEjectAfterDoneRipping = false;
    }
    else
    {
        if(m_pDVDControlInterface)
        {
            m_bAlreadyRipped = true; // disc ripping done , while detecting disc again , do not call Ripper
            //Drive is already in backend mode , i.e switchtomassstorage failed and ripping was not successful
            if(m_pDVDControlInterface->getDriveMode() == BACKEND_MODE)
            {
                m_pDVDControlInterface->revertModetoBackend();

            }
            else
            {
                m_pDVDControlInterface->SwitchtoBackendMode();
            }
        }

    }

    if(1 == isRippingAnswerRequired)
    {
        ETG_TRACE_USR3(("Send message answer to cdripper SM"));
        SendAnswer(NULL);
    }
    return MP_NO_ERROR;
}

tResult DVDControl::RequestDiscOperation(tU8 Operation)
{
    ENTRY
    tResult result = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    const tUserDataType userDataType = USRDATA_DVD_EJECT;
    tUserData userData = {0};

    SMF::Marshal(userData, sizeof(userData) - 1,DOUBLE_MARSHAL_SEPARATOR, "i",(tUInt)Operation);

    LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
    result = LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
    return result;

}
tResult DVDControl:: ejectDisc()
{
    ENTRY
    tResult retVal =  m_pDVDControlInterface->SwitchtoBackendMode();
    if(retVal == MP_NO_ERROR)
    {
        retVal =  m_pDVDControlInterface->ejectDisc();
        if(retVal == MP_NO_ERROR)
        {
            ETG_TRACE_USR1(("CD Ejected"));
        }
        else
        {
            retVal =  m_pDVDControlInterface->ejectDisc();
            if(retVal == MP_NO_ERROR)
            {
                ETG_TRACE_USR1(("CD Eject Command successful"));
            }
            else
            {
                ETG_TRACE_USR1(("CD Not Ejected"));
            }
        }
        if(m_bIsDataDisc == true)
        {
            m_bIsDataDisc = false;
            VARTRACE(m_bIsDataDisc);
            LocalSPM::GetOutputWrapper().UpdateDVDProperty(DVDDRIVEINFO);
            ETG_TRACE_USR1(("Non-Data Disc Update to Output Wrapper"));
        }
        //if DVD_VIDEO, update source unavailability to videomanager during disc eject - NCG3D-100247
        if(m_bVideoStreaming == true)
        {
            LocalSPM::GetOutputWrapper().UpdateDVDVideoSourceStatus(false);
        }
    }
    return retVal;
}

tResult DVDControl::StartRippingByUser()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    if(mDVDAudioOutput.SoundFormat!= CD_AUDIO_INVALID)
    {

        ret = DVDControlSM::SendEvent(START_RIPPING, NULL);
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        ParameterAUDIO_FORMAT(OUT parameterString, IN size, IN (tAudioFormat)mDVDAudioOutput.SoundFormat);
        SendEvent(AUDIO_FORMAT, IN parameterString);

    }
    else
    {
        ret = MEDIAPLAYER_ERROR_UNKNOWN_ERROR;
    }
    return ret;
}

tResult DVDControl::RequestVCDAudioChannel(tU8 SelectionType, tU8 AudioMode)
{
    ENTRY
    //LOCK
    tResult retVal= -1;
    if(m_pDVDControlInterface)
    {
        retVal =  m_pDVDControlInterface->setAudioChannel(SelectionType, AudioMode);
    }
    VARTRACE(SelectionType)
    VARTRACE(AudioMode)
    VARTRACE(retVal)
    return retVal;
}

tResult DVDControl::RequestDVDAudioChannel(tU8 SelectionType, tU8 AudioMode)
{
    ENTRY
    //LOCK

    tResult retVal= -1;
    if(m_pDVDControlInterface)
    {
        retVal =m_pDVDControlInterface->setAudioChannel(SelectionType, AudioMode);

    }
    VARTRACE(SelectionType)
    VARTRACE(AudioMode)
    VARTRACE(retVal)
    return retVal;
}

tResult DVDControl::SendNavigationKey(tU8 Action)
{
    ENTRY

    tResult retVal= -1;
    if(m_pDVDControlInterface)
    {
        retVal =m_pDVDControlInterface->sendNavigationCommand(Action);
    }
    VARTRACE(Action)
    VARTRACE(retVal)
    return retVal;
}

tResult DVDControl::SendTouchCommand(tU8 Action, tU16 Xcod, tU16 Ycod, tU16 maxXcod, tU16 maxYcod)
{
    ENTRY
    //LOCK

    tResult retVal= -1;
    TouchInput touchInput;

    if(m_pDVDControlInterface)
    {
        touchInput.CurrentX = Xcod;
        touchInput.CurrentY = Ycod;
        touchInput.OverallX = maxXcod;
        touchInput.OverallY = maxYcod;
        touchInput.touchCommand = (tTouchControl)Action;
        retVal =m_pDVDControlInterface->sendTouchCommand(touchInput);
    }
    VARTRACE(Action)
    VARTRACE(Xcod)
    VARTRACE(Ycod)
    VARTRACE(maxXcod)
    VARTRACE(maxYcod)
    VARTRACE(retVal)
    return retVal;
}

tResult DVDControl::RequestDirectSearch(tU32 titel, tU32 chapter)
{
    ENTRY
    //LOCK

    tResult retVal= -1;

    if(m_pDVDControlInterface)
    {
        retVal =m_pDVDControlInterface->directSearch(titel, chapter);
    }
    // VARTRACE(vv/*titel*/)
    //VARTRACE(chapter)
    VARTRACE(retVal)
    return retVal;
}

tResult DVDControl::RequestAngleChange(tU8 SelectionType, tU8 Angle)
{
    ENTRY
    //LOCK

    tResult retVal= -1;
    if(m_pDVDControlInterface)
    {
        retVal =m_pDVDControlInterface->setAngle(SelectionType, Angle);
    }
    VARTRACE(SelectionType)
    VARTRACE(Angle)
    VARTRACE(retVal)
    return retVal;
}

tResult DVDControl::SetMenuPlayBackControl(tU8 MenuControl)
{
    ENTRY
    //LOCK

    tResult retVal= -1;
    if(m_pDVDControlInterface)
    {
        retVal =m_pDVDControlInterface->setMenuPlayback((tMenuControl)MenuControl);
    }
    VARTRACE(MenuControl)
    VARTRACE(retVal)
    return retVal;
}

tResult DVDControl::SelectDirectNumber(tU32 number)
{
    ENTRY

    tResult retVal= -1;
    if(m_pDVDControlInterface)
    {
        retVal =m_pDVDControlInterface->directNumber(number);
    }

    VARTRACE(retVal)
    return retVal;
}

tResult DVDControl::RequestTitleSearch(tU32 number)
{
    ENTRY
    //LOCK

    tResult retVal= -1;
    if(m_pDVDControlInterface)
    {
        retVal =m_pDVDControlInterface->titleSearch(number);
    }
    //VARTRACE(number)
    VARTRACE(retVal)
    return retVal;
}

tResult DVDControl::RequestSubtitleChange(tBool state, tU8  selectionType , tU8 Subtitle)
{
    ENTRY
    //LOCK

    tResult retVal= -1;
    if(m_pDVDControlInterface)
    {
        if(state == true)
        {
            selectionType = tSubtitleControl::SUB_ON_OFF;
        }
        retVal = m_pDVDControlInterface->setSubtitle((tSubtitleControl)selectionType, Subtitle);
    }
    VARTRACE(state)
    VARTRACE(selectionType)
    VARTRACE(Subtitle)
    VARTRACE(retVal)
    return retVal;
}

tResult DVDControl::RequestCMSkip(tU8 SkipValue)
{
    ENTRY
    //LOCK

    tResult retVal= -1;
    if(m_pDVDControlInterface)
    {
        retVal =m_pDVDControlInterface->CMSkip((tSkipTiming)SkipValue);
    }

    VARTRACE(SkipValue)
    VARTRACE(retVal)
    return retVal;
}

tResult DVDControl::FetchDVDVideoInterface(OUT tDeviceName& devicename)
{
    ENTRY

    tPath videoSourcePath = V4LINTERFACEPATH;
    for(tU8 count = 0; count <= MAX_VIDEO_INTERFACE-1 ; count++)
    {
        tDeviceName videoInterfaceName;
        snprintf(videoInterfaceName, sizeof(tDeviceName), "%s%d/name",videoSourcePath,count);
        FILE* fp = fopen(videoInterfaceName, "r");
        if(NULL != fp)
        {
            tDeviceName videoDeviceName;
            fgets(videoDeviceName, sizeof(tDeviceName), fp);
            fclose(fp);
            tResult res = strncmp(LocalSPM::GetDataProvider().V4lInterfaceName().c_str(), videoDeviceName,strlen(LocalSPM::GetDataProvider().V4lInterfaceName().c_str()));
            if (0 == res)
            {
                snprintf(devicename, sizeof(devicename), "%s%d",V4LMOUNTPOINT,count);
                break;
            }
        }
        else
        {
            break;
        }
    }
    return MP_NO_ERROR;
}
tResult  DVDControl::DVDVideoSourceUpdate(tVideoSourceState status)
{
    ENTRY
    VARTRACE(status)
    tResult result = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    const tUserDataType userDataType = USRDATA_DVD_VIDEO_SOURCE_STATUS;
    tUserData userData = {0};

    SMF::Marshal(userData, sizeof(userData) - 1,DOUBLE_MARSHAL_SEPARATOR, "i",(tUInt)status);

    LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
    result = LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
    return result;
}
tResult DVDControl::StartVideoStreaming()
{
    ENTRY
    VARTRACE(mDeviceInfo.discType)
    VARTRACE(m_bIsDVDControlActive)
    tResult  ret = MP_NO_ERROR;
    tBoolean bVideo = false;
    bVideo = IsVideoDisc( mDeviceInfo.discType);
    // If DVD Disc is the current disc type and if DVD_DRIVE Is the active device then do this
    if((bVideo) && (m_bIsDVDControlActive))
    {
        tURL URL;
        tDeviceName videoDeviceNode;
        m_bVideoStreaming = true;
        FetchDVDVideoInterface(videoDeviceNode);
        if(bVideo)
        {
            snprintf(URL, sizeof(tURL), "%s.dvd",  videoDeviceNode);
        }
        else
        {
            snprintf(URL, sizeof(tURL), "%s.cdda",  videoDeviceNode);
        }
        ETG_TRACE_USR3(("video device interface : %s",URL));
        tPEStateString args;
        me::vprops_t meVideoProperties;
        if (MTY_VIDEO == m_PlayMediaObject.mediaType)
        {
            ret = LocalSPM::GetDBManager().GetVideoProperties(meVideoProperties);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while getting video properties from dbmanager"));
            }
        }
        VARTRACE(meVideoProperties);
        SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiiltliiiiiiil",
                URL, (int)ME_SPEED_NONE, 0,
                HANDLE_NONE, NULL, samplerate_i_none,
                (int)meVideoProperties.brightness(), (int)meVideoProperties.hue(),
                (int)meVideoProperties.saturation(), (int)meVideoProperties.contrast(),
                (int)meVideoProperties.brightnessoffset(), (int)meVideoProperties.saturationoffset(),
                (int)meVideoProperties.hueoffset(),ME_SPEEDSTATE_OFF);


        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::PLAY", args, "DVDControlSM::PLAY_VIDEO_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        ret = MP_ERR_DVD_PLAYBACK;
    }
    // Failure case
    if(MP_NO_ERROR != ret)
    {
        // Acknowledge with State RESTRICTED if devciecontrolactive IS TRUE
        if(m_bIsDVDControlActive == true)
        {
            LocalSPM::GetOutputWrapper().vSendVideoStateAcknowledgement(tVideoSourceState::VIDEO_SOURCE_STATUS_RESTRICTED_AUDIO_ONLY);
        }
        else
        {
            // Acknowledge with State INACTIVE if devciecontrolactive is FALSE
            LocalSPM::GetOutputWrapper().vSendVideoStateAcknowledgement(tVideoSourceState::VIDEO_SOURCE_STATUS_INACTIVE );
        }
    }
    return ret;
}

tResult DVDControl::StartVideoStreamingAnswer(const tPEHandle handle, const tPEPlaybackState playbackState, const me::reason_e reason, const me::speed_e speed)
{
    ENTRY
    (void)handle;
    (void)playbackState;
    (void)speed;
    if(REASON_OK > reason) /*Failure*/
    {
        // Acknowledge with State RESTRICTED if devciecontrolactive IS TRUE
        if(m_bIsDVDControlActive == false)
        {
            LocalSPM::GetOutputWrapper().vSendVideoStateAcknowledgement(tVideoSourceState::VIDEO_SOURCE_STATUS_INACTIVE);
        }
        else
        {
            // Acknowledge with State INACTIVE if devciecontrolactive is FALSE
            LocalSPM::GetOutputWrapper().vSendVideoStateAcknowledgement(tVideoSourceState::VIDEO_SOURCE_STATUS_RESTRICTED_AUDIO_ONLY);
        }
    }
    else
    {
        //Success
        // Acknowledge ACTIVE state as Success
        ETG_TRACE_USR3(("StartVideoStreamingAnswer : Sending video state acknowledgement VIDEO_SOURCE_STATUS_ACTIVE"));
        LocalSPM::GetOutputWrapper().vSendVideoStateAcknowledgement(tVideoSourceState::VIDEO_SOURCE_STATUS_ACTIVE);
    }
    return MP_NO_ERROR;
}

tResult DVDControl::StopVideoStreaming()
{
    ENTRY
    VARTRACE(m_bVideoStreaming)
    VARTRACE(m_bIsDVDControlActive)
    tResult  ret = MP_NO_ERROR;
    if(m_bVideoStreaming)
    {
        m_bVideoStreaming = false;
        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineSM::STOP", NULL, "DVDControlSM::STOP_VIDEO_ANSWER");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
            // Acknowledge with State ACTIVE
            LocalSPM::GetOutputWrapper().vSendVideoStateAcknowledgement(tVideoSourceState::VIDEO_SOURCE_STATUS_ACTIVE);
            m_bVideoStreaming = true;
        }
    }
    else
    {
        if(m_bIsDVDControlActive == false)
        {
            // Acknowledge INACTIVE state as devciecontrolactive IS FALSE
            ETG_TRACE_USR3(("StopVideoStreaming : Sending video state acknowledgement VIDEO_SOURCE_STATUS_INACTIVE"));
            LocalSPM::GetOutputWrapper().vSendVideoStateAcknowledgement(tVideoSourceState::VIDEO_SOURCE_STATUS_INACTIVE);
        }
        else
        {
            // Acknowledge RESTRICTED state as devciecontrolactive IS TRUE
            ETG_TRACE_USR3(("StopVideoStreaming: Sending video state acknowledgement  VIDEO_SOURCE_STATUS_RESTRICTED_AUDIO_ONLY"));
            LocalSPM::GetOutputWrapper().vSendVideoStateAcknowledgement(tVideoSourceState::VIDEO_SOURCE_STATUS_RESTRICTED_AUDIO_ONLY);
        }
    }
    return ret;
}

tResult DVDControl::StopVideoStreamingAnswer(const tPEHandle handle, const tPEPlaybackState playbackState, const me::reason_e reason, const me::speed_e speed)
{
    ENTRY
    (void)handle;
    (void)playbackState;
    (void)speed;
    if(REASON_OK > reason) /*Failure*/
    {
        // Acknowledge with State UNKNOWN
        LocalSPM::GetOutputWrapper().vSendVideoStateAcknowledgement(tVideoSourceState::VIDEO_SOURCE_STATUS_UNKNOWN);
    }
    else //Success
    {
        if(m_bIsDVDControlActive == false)
        {
            // Acknowledge INACTIVE state as devciecontrolactive IS FALSE
            LocalSPM::GetOutputWrapper().vSendVideoStateAcknowledgement(tVideoSourceState::VIDEO_SOURCE_STATUS_INACTIVE);
            ETG_TRACE_USR3(("StopVideoStreamingAnswer : Sending video state acknowledgement VIDEO_SOURCE_STATUS_INACTIVE"));
        }
        else
        {
            // Acknowledge RESTRICTED state as devciecontrolactive IS TRUE
            LocalSPM::GetOutputWrapper().vSendVideoStateAcknowledgement(tVideoSourceState::VIDEO_SOURCE_STATUS_RESTRICTED_AUDIO_ONLY);
            ETG_TRACE_USR3(("StopVideoStreamingAnswer : Sending video state acknowledgement VIDEO_SOURCE_STATUS_RESTRICTED_AUDIO_ONLY"));
        }
    }
    return MP_NO_ERROR;
}
tResult DVDControl::SendVideoProperty()
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    me::vprops_t meVideoProperties;

    ret = LocalSPM::GetDBManager().GetVideoProperties(meVideoProperties);
    if(MP_NO_ERROR == ret)
    {
        VARTRACE(meVideoProperties);
        /* send the ME event to set the video properties here */
        char messageString[64];
        strncpy_r(OUT messageString, IN "MediaEngineSM::SET_VIDEO_PROPERTIES", IN sizeof(messageString));

        tPEStateString args;

        SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "iiiiiii", (int)meVideoProperties.brightness(),
                (int)meVideoProperties.hue(), (int)meVideoProperties.saturation(),
                (int)meVideoProperties.contrast(), (int)meVideoProperties.brightnessoffset(),
                (int)meVideoProperties.saturationoffset(), (int)meVideoProperties.hueoffset());

        ret = Dispatcher::GetInstance().SendMessage(IN messageString, IN args);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        ETG_TRACE_ERR(("Error while retrieving video properties from DB "));
    }
    return ret;
}
// dummy function --> in return calls onDeviceInitialized
tBoolean DVDControl::IsInitializingDevice(const tMountPoint mountPoint,tConnectionState connectionState,tInitDeviceProtocol protocol)
{

    return true;
}

//Checks whether the disc has video content

bool DVDControl::IsVideoDisc( tDiscType discType)
{
    ENTRY
    bool bVideoDisc = false ;
    switch(discType)
    {
        case DISC_VCD_VER_1:
        case DISC_VCD_VER_2_PBC_OFF:
        case DISC_SUPER_VCD_PBC_OFF:
        case DISC_VCD_VER_2_PBC_ON:
        case DISC_SUPER_VCD_PBC_ON:
        case DISC_DVD_VIDEO:
        case DISC_DVD_VR:
        {
            bVideoDisc = true;
            break;
        }

        default:
        {
            break;
        }
    }
    return bVideoDisc;
}
bool DVDControl::checkRippingEnabled()
{
    ENTRY
    tBoolean autoRipping;
    tUInt RippingState = RIPPING_NOT_SUPPORTED;
    LocalSPM::GetCDRipperControl().GetAutoRippingStatus(autoRipping);
    if((LocalSPM::GetDataProvider().CDRippingSupport() == 1)
            && ((m_CDTOCInfo.u8MaxTrack) > 0)&&((m_CDTOCInfo.u8MaxTrack) <= CD_MAX_TRACK_NUMBER )
            && autoRipping == true && m_bAlreadyRipped == false)
    {
        ETG_TRACE_USR4(("Inside CheckRippingEnabled"));
        VARTRACE(autoRipping);
        VARTRACE(m_bAlreadyRipped);
        if(autoRipping == true)
        {
            tCDTOCInfoPtr ptrCDTOCInfo;
            ptrCDTOCInfo = getCDTOC();
            LocalSPM::GetCDRipperControl().IsRippingCompleted(ptrCDTOCInfo,RippingState);
            if(RippingState == RIPPING_COMPLETED)
            {
                return false;
            }
            else
            {
                return true;
            }
        }

    }
    else
    {
        if(autoRipping == false)
        {
            tCDTOCInfoPtr ptrCDTOCInfo;
            ptrCDTOCInfo = getCDTOC();
            LocalSPM::GetCDRipperControl().IsRippingCompleted(ptrCDTOCInfo,RippingState);
        }
        return false;
    }
    return false;
}

tResult DVDControl::FetchedGNinfo(const tGNRequestType GNReqType)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    VARTRACE(GNReqType);
    /*Send event to RipperSM*/
    char messageString[64];
    strncpy_r(OUT messageString, IN "RipperSM::FETCHED_GNINFO ", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    ret = LocalSPM::GetCDRipperControl().ParameterFETCHED_GNINFO(OUT parameterString, IN size, IN GNReqType);
    ret = LocalSPM::GetCDRipperControl().SendEventByName("FETCHED_GNINFO", IN parameterString);
    return ret;
}

tCDTOCInfo* DVDControl::getCDTOC()
{
    ENTRY
    return &m_CDTOCInfo;
}

void DVDControl::clearTOC()
{
    memset(&m_CDTOCInfo,0,sizeof(m_CDTOCInfo));
}

tResult DVDControl::RequestDVDTemperature(tUserContext userContext)
{
    ENTRY
    tAllParameters parameterString;
    InitUserContext(m_tempUserContext);
    m_tempUserContext = userContext;
    size_t size = sizeof(parameterString);
    const tUserDataType userDataType = USRDATA_DVD_TEMPERATURE_REQUEST;
    tUserData userData = {0};
    LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
    tResult ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
    return ret;
}

void DVDControl::DVDCallbacks::signalEventTemperatureChange(tU16 temperature)
{
    ENTRY
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    const tUserDataType userDataType = USRDATA_DVD_TEMPERATURE_RESPONSE;
    tUserData userData = {0};

    SMF::Marshal(userData, sizeof(userData) - 1,DOUBLE_MARSHAL_SEPARATOR, "i",
            (tUInt)temperature);

    LocalSPM::GetUSBControl().ParameterSIGNAL_USERDATA(OUT parameterString, IN size, IN 0, IN userDataType, IN userData);
    LocalSPM::GetDeviceDispatcher().RouteMessage(IN DTY_DVD_DRIVE, IN "SIGNAL_USERDATA", IN parameterString);
}

tResult DVDControl::PlaybackAction(tDeviceType, tDeviceID, const char* mountpoint, const char* url, tPlaybackAction playbackaction, tNextPrevSkipCount prevCount)
{

    tResult ret = MP_NO_ERROR;
    (void)mountpoint;
    (void)url;
    (void)playbackaction;
    (void)prevCount;

    /* Send answer to waiting state machine */
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    ret = LocalSPM::GetDeviceDispatcher().ParameterPLAY_ANSWER_NEW(OUT parameterString, IN size , (tPEHandle)0  , IN mPlaybackState , IN (reason_e)0, IN (speed_e)0);
    VARTRACE("#### play answer sent ####");
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }

    ret = SendAnswer(IN parameterString);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending answer via SMF (ErrorCode:%s)", errorString(ret)));
    }
    return MP_NO_ERROR;

}
