#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_CDRIPPER_CONTROL
#ifdef TARGET_BUILD
#include "trcGenProj/Header/CDRipperControl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_CDRIPPER_CONTROL
#endif
#endif

#define GNDATAFETCH_RETRY_COUNT 4
#define GNDATAFETCH_TIMEOUT 250000
#include "LocalSPM.h"
#include "Dispatcher.h"
#include "FunctionTracer.h"
#include "MediaPlayer_ErrorCodes.h"
#include <sys/types.h>
#include <dirent.h>
#include <signal.h>
#include "FastUTF8.h"
#include "VarTrace.h"
#include "TimeTrace.h"

#include "GracenoteProxy.h"

/*TagLib header includes*/
#include <taglib/fileref.h>
#include <taglib/vorbisfile.h>  //ogg file
#include <taglib/mpegfile.h>    //mp3 file
#include <taglib/rifffile.h>    //riff file
#include <taglib/wavfile.h>     //wave file
#include <taglib/aifffile.h>    //aiff file
#include <taglib/asffile.h>     //asf file
#include <taglib/mp4file.h>     //mp4 file
#include <taglib/mp4tag.h>      //mp4tag
#include <taglib/id3v2tag.h>    //id3 tag
#include <taglib/id3v2frame.h>  //id3 frame
#include <taglib/attachedpictureframe.h>
#include <taglib/id3v2header.h>
#include <taginfo.h>
using namespace std;
using namespace TagInfo;

//Umount
#include <sys/mount.h>
#include <sys/syscall.h>
#include <errno.h>

#include "CDRipperControl.h"
#include "RequestResponseSM.h"
#include "CDRipperControlSM.h"

//SPM part



void CDRipperControl::Create() //100%
{
    ENTRY

    /* Create the state machine */
    CDRipperControlSM::Create();

    CreateDone(0);
}

tResult CDRipperControl::Init(tInitReason reason) //100%
{
    ENTRY
    VARTRACE(reason);

    /* Init the state machine */
    CDRipperControlSM::Init();
    SetAnswerTimeout(RIPPER_CTRL_SM_ANSWER_TIMEOUT_MS); // Set answer timeout

    /* Register state machine with dispatcher */
    Dispatcher::GetInstance().Register(IN this);
    m_bAutoRipping = false;
    m_bRippedTracksExists = false;
    m_CDTrackInfo.clear();
    m_trackNumberList.clear();
    LocalSPM::GetDBManager().GetMusicBoxAutoRipping(m_bAutoRipping);
    tU32 rippingEncodingQuality = 0;
    LocalSPM::GetDBManager().GetMusicBoxEncodingQuality(rippingEncodingQuality);
    if( rippingEncodingQuality == 0)
    {
        m_rippingEncodingQuality = (tEncodingQuality) LocalSPM::GetDataProvider().CDRippingEncodingQuality();
    }
    else
    {
        m_rippingEncodingQuality = (tEncodingQuality)rippingEncodingQuality;
    }
    //Set mountpoint in device table using dataprovider value
    tMountPoint mountPoint;
    strncpy_r(OUT mountPoint, IN (const char *)LocalSPM::GetDataProvider().RippedFilePath().c_str(), IN sizeof(tRippedFilePath));
    LocalSPM::GetDBManager().SetDeviceTypeAndMountPoint(MUSICBOX_DEVICE_ID,DTY_MUSICBOX,IN mountPoint);
    /* start a timer to reset the former connection state column */
    long timeoutInMS =   LocalSPM::GetDataProvider().ReconnectMusicBoxTimeout() ; //Addition of 10 seconds

    mTimerReconnectDevice.StartTimer(OUT mTimerIDReconnectDevice, timeoutInMS, 0L, (void*)this,&TimerCallBack, (char *)"ResetFormerConnectionTimer");  //lint !e1773
    //REgister Gracenote proxy

    LocalSPM::GetInstance().GetIPCProvider().RegisterListener(&GracenoteProxy::GetInstance());

    m_bRippingStoppedByUser = false;
    return InitDone(0);
}

tResult CDRipperControl::InitSM() //100%
{
    ENTRY

    /* Initialize variables */

    return MP_NO_ERROR;
}

tResult CDRipperControl::Run() //100%
{
    ENTRY

    /*Create and start threads */
    LocalSPM::GetThreadFactory().Do(IN this, 0, NULL); //CDRipperControl inclusive state machine

    return RunDone(0);
}

void CDRipperControl::Do(int functionID, void *ptr) //100%
{
    ENTRY

    //set the threads name
    LocalSPM::GetThreadFactory().SetName(CDRipperControlSM::GetSMNameFull());

    switch(functionID)
    {
        case 0:
        {
            while(CDRipperControlSM::STATE_MACHINE_FINISHED != CDRipperControlSM::StateMachine_Main()){}
            break;
        }

        default:
        {
            ETG_TRACE_ERR(("CDRipperControl::Do: No thread defined for functionID: %d", functionID));
            break;
        }
    }
}
bool CDRipperControl::TimerCallBack(timer_t timerID , void* instance ,const void *userData)
{
    ENTRY
    (void)timerID;
    (void)userData;
    tResult res;
    CDRipperControl *ripperControl = (CDRipperControl*)instance;
    res = ripperControl->SendResetFormerConnection();
    if (res) {
        ETG_TRACE_ERR(("TimerCallBack: SendResetFormerConnection returned %d", res));
    }

    return MP_NO_ERROR;
}

tResult CDRipperControl::SendResetFormerConnection(void)
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Send the RESET_FORMER_CONNECTION event */
    ret = SendEvent(RESET_FORMER_CONNECTION, NULL);

    return ret;
}

tResult CDRipperControl::ResetFormerConnection()
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tDeviceInfo deviceInfo;
    ret = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN MUSICBOX_DEVICE_ID);
    VARTRACE(deviceInfo);
    if(deviceInfo.deviceType == DTY_MUSICBOX)
    {

        if(deviceInfo.connectionState != CS_CONNECTED)
        {
            tNumberOfFiles numberOfPlayableFiles = 0;
            bool bIsFileAvailableInFlash = true ;

            if( m_e8GracenoteInitialized ==  GRACENOTE_INIT_NOT_DONE)
            {
                // ipc client INITIALIZE GRACENOTE
                ret = GracenoteProxy::GetInstance().InitSettingsMethodCall(m_e8GDBlookupMode);
                if(!ret)
                {
                    ETG_TRACE_ERR(("Could not initialize gracenote(ErrorCode:%s)", errorString(ret)));
                }
            }

            ret = NumberOfTotalFilesRipped(OUT numberOfPlayableFiles);
            if(numberOfPlayableFiles == 0)
            {
                //check if there are any file sin musicbox folder
                bIsFileAvailableInFlash = CheckMusicBoxFileAvailability((char*)LocalSPM::GetDataProvider().RippedFilePath().c_str());

            }

            unsigned int indexingcase = 0;

            //CHECK WHETHER DEVICE HAS TO BE INDEXED , SCENARIOS OF DATABASE CLEARING BUT FILE AVAILABLE IN FLASH
            //case 1: number of files in db is 0 , no files in flash
            if((numberOfPlayableFiles == 0)&&(bIsFileAvailableInFlash == false))
            {
                indexingcase = 1;
                LocalSPM::GetDataProvider().IndexingSupportDeviceType_7 = DTY_UNKNOWN;
                LocalSPM::GetDBManager().SetIndexingState(MUSICBOX_DEVICE_ID,IDS_NOT_SUPPORTED,0);
            }
            //case 2: number of files in db is 0 ,  files in flash are present
            else if((numberOfPlayableFiles == 0)&&(bIsFileAvailableInFlash == true))
            {
                indexingcase = 2;
                LocalSPM::GetDataProvider().IndexingSupportDeviceType_7 = DTY_MUSICBOX;
                LocalSPM::GetDBManager().SetIndexingState(MUSICBOX_DEVICE_ID,IDS_NOT_STARTED,0);
            }

            else if((numberOfPlayableFiles > 0)&&(bIsFileAvailableInFlash == true))
            {
                tIndexingState indexingState = IDS_NOT_SUPPORTED ;
                LocalSPM::GetDBManager().GetIndexingState(indexingState,MUSICBOX_DEVICE_ID);
                //case 3: number of files in db is x ,  files in flash are present , Indexing is partial
                if(indexingState == IDS_PARTIAL)
                {
                    indexingcase = 3;
                    LocalSPM::GetDataProvider().IndexingSupportDeviceType_7 = DTY_MUSICBOX;
                }
                //case 4: number of files in db is x ,  files in flash are present , Indexing is completed
                else
                {
                    indexingcase = 4;
                    LocalSPM::GetDataProvider().IndexingSupportDeviceType_7 = DTY_UNKNOWN;
                    LocalSPM::GetDBManager().SetIndexingState(MUSICBOX_DEVICE_ID,IDS_NOT_SUPPORTED,0);
                }
            }
            else
            {
                LocalSPM::GetDataProvider().IndexingSupportDeviceType_7 = DTY_UNKNOWN;
                LocalSPM::GetDBManager().SetIndexingState(MUSICBOX_DEVICE_ID,IDS_NOT_SUPPORTED,0);
            }
            VARTRACE(indexingcase);
            VARTRACE(deviceInfo);
            //SET NUMBER OF FILES IN MUSICBOX
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while reading number of files at DBManager (ErrorCode:%s)", errorString(ret)));
            }
            ret = LocalSPM::GetDBManager().SetNumberOfAudioFiles(IN MUSICBOX_DEVICE_ID, IN numberOfPlayableFiles);

            VARTRACE(numberOfPlayableFiles);

            // move to connected state
            // set connection state of the device to connected
            ret = LocalSPM::GetDBManager().SetConnectionState(MUSICBOX_DEVICE_ID,CS_ATTACHED);
            if (ret)
            {
                ETG_TRACE_ERR(("Error while moving to attached state for Music Box"));
            }
            ret = LocalSPM::GetDBManager().SetConnectionState(MUSICBOX_DEVICE_ID,CS_CONNECTED);
            if (ret)
            {
                ETG_TRACE_ERR(("Error while moving to Connected state for Music Box"));
            }
            LocalSPM::GetOutputWrapper().UpdateGracenoteVersion();
            LocalSPM::GetOutputWrapper().UpdateGracenoteLookupMode();
        }
    }
    return ret;
}

tResult CDRipperControl::Stop() //100%
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    mTimerReconnectDevice.CancelTimer(IN mTimerIDReconnectDevice);
    if(m_RippingState == RIPPING_PARTIAL)
    {
        StopRippingByUser();
    }
    /* Send STOP message to own SM */
    ret = SendForceEvent(STOP_SM, (char *)NULL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult CDRipperControl::StopEventProcessed() //100%
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    ret = LocalSPM::GetDBManager().SetMusicBoxAutoRipping(m_bAutoRipping);
    if(MP_NO_ERROR != ret) {
        ETG_TRACE_ERR(("StopEventProcessed:saving auto ripping status failed"));
    }
    ret = LocalSPM::GetDBManager().SetMusicBoxEncodingQuality((unsigned int)m_rippingEncodingQuality);
    if(MP_NO_ERROR != ret) {
        ETG_TRACE_ERR(("StopEventProcessed:saving  encoding quality failed"));
    }

    /* Send stop done to SPM in the transition to final state in state machine */
    return StopDone(0);
}

tResult CDRipperControl::Done() //100%
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Deregister state machine with dispatcher */
    Dispatcher::GetInstance().DeRegister(IN this);

    /* Send DONE message to own SM */
    ret = SendForceEvent(DONE, (char *)NULL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult CDRipperControl::DoneEventProcessed() //100%
{
    ENTRY

    //Cleanup threads
    LocalSPM::GetThreadFactory().CleanUpThreads(this);

    /* Send done done to SPM in the transition to final state in state machine */
    return DoneDone(0);
}

char *CDRipperControl::GetSMStateName(tGeneralString stateName, size_t size) //100%
{
    GetCurrentState((char *)stateName, size);
    return stateName;
}


//Playback control part

tResult CDRipperControl::StartAllocateAudioInput(const tDeviceID /*deviceID*/, const tMountPoint /*mountPoint*/) //100%
{
    ENTRY

    //tResult ret = MP_NO_ERROR;



    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CDRipperControl::StartDeAllocateAudioInput() //100%
{
    ENTRY

    //tResult ret = MP_NO_ERROR;



    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CDRipperControl::StartSwitchObserver(void) //100%
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    if(LocalSPM::GetDataProvider().UseMediaEngine())
    {
        /* Switch the observer to this state machine */
        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineRipperSM::SWITCH_OBSERVER", "CDRipperControlSM", "CDRipperControlSM::METHOD_RETURN");
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while calling SendMessageAnswer of MediaEngine (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        /* Send SwitchObserver to PlayerEngine via DBUS */
        //RegisterReleaseEvent(METHOD_RETURN);
        ret = LocalSPM::GetIPCProvider().SwitchObserver(IN this);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while using IPCProvider::SwitchObserver (ErrorCode:%s)", errorString(ret)));
        }
    }

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CDRipperControl::MessageNotConsumed() //100%
{
    ENTRY
    ETG_TRACE_ERR(("CDRipperControl::MessageNotConsumed"));

    return MP_NO_ERROR;
}

tResult CDRipperControl::SetOutputDevice(const tAudioOutputDevice audioOutputDevice) //100%
{
    ENTRY
    VARTRACE(audioOutputDevice);


    return MP_NO_ERROR;
}


//Indexing part

tResult CDRipperControl::IsInitRequired(const tDeviceInfoString deviceInfoString) //100%
{
    ENTRY;

    /* In case of USB no initialization is necessary -> return NoInitAnswer (former false case) */
    return NoInitAnswer(IN deviceInfoString);
}

tResult CDRipperControl::SendInitInit(const tDeviceInfoString deviceInfoString) //100%
{
    ENTRY;
    tDeviceInfo deviceInfo;
    DataProvider::UnMarshalDeviceInfo(deviceInfoString, deviceInfo);
    VARTRACE2(deviceInfo.mountPoint, deviceInfo.deviceID);

    //tResult ret = MP_NO_ERROR;

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CDRipperControl::NoInitAnswer(const tDeviceInfoString deviceInfoString) //100%
{
    ENTRY;

    //Don't return an error in a transaction because we will not switch to new state even though we already did the action
    return MP_NO_ERROR;
}

tResult CDRipperControl::CalculateCDIDHash(const tCDTOCInfoPtr CDTOCInfoPtr) //100%
{
    ENTRY;
    (void)CDTOCInfoPtr;
    tResult ret = MP_NO_ERROR;
    // create a file, copy TOC data and calculate hash id
    FILE *fp;
    //opening a file to write
    fp = fopen(RIPPER_TOC_FILE_PATH,"w");
    if(fp == NULL)
    {
        return -1;
    }
    fprintf(fp,"%s", m_CDTOCData.TOC);
    fclose(fp);

    char *commandStr[] = {(char *)"/usr/bin/md5sum",(char *)(RIPPER_TOC_FILE_PATH),NULL};
    ETG_TRACE_USR4(("CDRipperControl::CalculateCDIDHash: calling executeCommand() for md5sum"));
    int retStatus = executeCommand(commandStr,string(RIPPER_HASH_FILE_PATH));

    if(0 == retStatus)
    {
        ETG_TRACE_USR3(("CDRipperControl::CalculateCDIDHash: executeCommand() success for md5sum"));
        FILE * pFileResult = fopen (RIPPER_HASH_FILE_PATH, "r");

        if(NULL == pFileResult)
        {
            ETG_TRACE_ERR(("Cannot open file: %20s", RIPPER_HASH_FILE_PATH));
        }
        else
        {
            tTOC hashID;
            if(NULL != fgets(hashID, sizeof(hashID), pFileResult))
            {
                /* Remove "  -" from hashID string */
                char *pdest = strstr(hashID, " ");
                if(pdest)
                {
                    *pdest = 0;
                }
                VARTRACE(hashID);
            }
            else
            {
                ETG_TRACE_ERR(("Cannot open string from stream: %s", RIPPER_HASH_FILE_PATH));
            }
            fclose(pFileResult);
            ETG_TRACE_USR4(("CalculateCDIDHash: HashID = %s", hashID));
            strncpy_r(OUT m_CDTOCData.HashID, IN hashID, IN sizeof(m_CDTOCData.HashID));
        }
    }
    else
    {
        ETG_TRACE_ERR(("CDRipperControl::CalculateCDIDHash: executeCommand() failed for md5sum. Error:%s",strerror(retStatus)));
    }

    if(0 != remove(RIPPER_HASH_FILE_PATH))
    {
        ETG_TRACE_ERR(("Cannot delete temp file: %s", RIPPER_HASH_FILE_PATH));
    }

    if(0 != remove(RIPPER_TOC_FILE_PATH))
    {
        ETG_TRACE_ERR(("Cannot delete temp file: %s", RIPPER_TOC_FILE_PATH));
    }

    VARTRACE(m_CDTOCData.HashID);
    return MP_NO_ERROR;
}

void CDRipperControl::InsertTracksInMediaObjectTable(bool bGracenote)
{
    ENTRY;
    //enter all the files in Database
    vector<tCDTrackInfo>::iterator iterTrackInfo = m_CDTrackInfo.begin();
    tUInt index = 1;
    tResult ret = MP_NO_ERROR;
    vector<string> trackFileNames;
    for (; iterTrackInfo != m_CDTrackInfo.end(); ++iterTrackInfo)
    {

        tMediaObject mediaObject;
        InitMediaObject(OUT mediaObject);
        char data[8] = {0};
        tRippedFilePath FilePath;

        ETG_TRACE_USR4(("CalculateCDIDHash: Push data in Database"));

        mediaObject.deviceID = MUSICBOX_DEVICE_ID;
        strncpy_r(OUT mediaObject.MetadataField1, IN iterTrackInfo->genre, IN sizeof(tMetadata));
        strncpy_r(OUT mediaObject.MetadataField4, IN m_CDTOCData.albumName, IN sizeof(mediaObject.MetadataField4));
        strncpy_r(OUT mediaObject.UUID, IN m_CDTOCData.HashID, IN sizeof(m_CDTOCData.HashID));

        // strncpy_r(OUT FilePath, IN (const char *)LocalSPM::GetDataProvider().RippedFilePath().c_str(), IN sizeof(tRippedFilePath));
        strncpy_r(OUT FilePath, IN m_CDTOCData.HashID, IN sizeof(tRippedFilePath));
        strncat_r(OUT FilePath, IN "/Track_", IN sizeof(tRippedFilePath));
        snprintf(data, sizeof(data), "%d", index);
        strncat_r(OUT FilePath, IN data, IN sizeof(tRippedFilePath));
        strncat_r(OUT FilePath, IN ".mp3", IN sizeof(tRippedFilePath));

        //ret = GetRippedFilePath(mediaObject.fileName, m_CDTOCData.HashID, index);

        strncpy_r(OUT mediaObject.fileName, IN FilePath, IN sizeof(mediaObject.fileName));
        trackFileNames.push_back(mediaObject.fileName);
        strncpy_r(OUT mediaObject.MetadataField2, IN iterTrackInfo->performer, IN sizeof(mediaObject.MetadataField2));
        strncpy_r(OUT mediaObject.title, IN iterTrackInfo->title, IN sizeof(mediaObject.title));
        mediaObject.catType = CTY_RIPPING;
        mediaObject.year = m_CDTOCData.u32RecordingYear ;

        mediaObject.trackNumber = index;
        if(bGracenote)
        {
            mediaObject.compilationFlag = 1; // If TOC info is filled from Gracenote DB ,set it to 1
        }

        ret = LocalSPM::GetDBManager().StoreMediaObject(IN mediaObject);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while storing media object in DB (ErrorCode:%s)", errorString(ret)));
        }
        index++;
    }

    ret = LocalSPM::GetDBManager().StoreMediaObjectEnd();
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while storing media object in DB (ErrorCode:%s)", errorString(ret)));
    }
    ret = LocalSPM::GetDBManager().WaitForUpdateMyMediaFinished();
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while storing media object in DB (ErrorCode:%s)", errorString(ret)));
    }
    else if(LocalSPM::GetDataProvider().YomiMetadataSupport())
    {
        ETG_TRACE_USR4(("Trying to insert the yomi metadata in database"));
        int index = 0;
        for (iterTrackInfo = m_CDTrackInfo.begin(); iterTrackInfo != m_CDTrackInfo.end(); ++iterTrackInfo,++index)
        {
            tObjectID objectID;
            tURL url;
            strncpy_r(url,trackFileNames[index].c_str(),sizeof(tURL));

            tResult ret =  LocalSPM::GetDBManager().GetObjectID(objectID,MUSICBOX_DEVICE_ID,url);
            if(MP_NO_ERROR == ret)
            {
                tYomiMetadata yomiMetadata;
                strncpy_r(yomiMetadata.YomiTitle,iterTrackInfo->YomiTitle,sizeof(tMetadata));
                strncpy_r(yomiMetadata.YomiArtist,iterTrackInfo->YomiArtist,sizeof(tMetadata));
                strncpy_r(yomiMetadata.YomiAlbum,iterTrackInfo->YomiAlbum,sizeof(tMetadata));
                VARTRACE(yomiMetadata);
                LocalSPM::GetDBManager().AddYomiMetadata(objectID, yomiMetadata);

            }
            else
            {
                ETG_TRACE_ERR(("Error while fetching the object id from the media object table"));

            }

        }
    }
}

tResult CDRipperControl::FetchCDMetadataInfo(const tGNRequestType GNReqType)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;
    VARTRACE(m_e8GracenoteInitialized);
    GNdataReqType = GNReqType;
    VARTRACE(GNdataReqType);
    //If GNreqType is CDDA fill the starting address array for fetchAlbumInfoMethodCall
    if(CDDA == GNdataReqType)
    {
        //FILL STARTING ADDRESS
        memset(m_startingAddressArray,0,STARTING_ADDRESS_ARRAY_SIZE);
        m_CDTOCData.u32TotalTracks = 0;
        // Store all the TOC information locally
        tCDTOCInfo* ptrCDTOCInfo;
        ptrCDTOCInfo =  LocalSPM::GetDVDControl().getCDTOC();
        if(ptrCDTOCInfo != NULL)
        {
            for(int index = 0; index < ptrCDTOCInfo->u8MaxTrack; index++)
            {
                m_startingAddressArray[index] = ptrCDTOCInfo->arTrack[index].u32StartZLBA;
                VARTRACE(m_startingAddressArray[index]);
            }
            m_startingAddressArray[ptrCDTOCInfo->u8MaxTrack] = ptrCDTOCInfo->u32LastZLBA;
            // Set the total number of tracks
            m_CDTOCData.u32TotalTracks = ptrCDTOCInfo->u8MaxTrack;
            VARTRACE(m_CDTOCData.u32TotalTracks);
        }
        else
        {
            ret = SendEvent(FINISHED_GNFETCHDATA,IN "0");
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    if(m_e8GracenoteInitialized == GRACENOTE_INIT_OK )
    {
        //ipc client fetch album info for TOC
        if((CDDB_ONDEMAND == GNdataReqType) && (mToCString.length() > 0))
        {
            ret = GracenoteProxy::GetInstance().FetchAlbumInfoMethodCall((const char*)mToCString.c_str());
        }
        else
        {
            ret = GracenoteProxy::GetInstance().FetchAlbumInfoMethodCall(m_CDTOCData.u32TotalTracks,m_startingAddressArray);
        }
    }
    else if( m_e8GracenoteInitialized ==  GRACENOTE_INIT_NOT_DONE)
    {
        // ipc client INITIALIZE GRACENOTE
        ret = GracenoteProxy::GetInstance().InitSettingsMethodCall(m_e8GDBlookupMode);
        m_bRequestMetadataFromGracenote = true;
    }
    else
    {
        ret = MP_ERR_DBUS;
    }

    if(ret != MP_NO_ERROR)
    {
        if(GNdataReqType == RIPPING)
        {
            ETG_TRACE_ERR(("FetchCDInfofromGN: Error fetching metadata from gracenote"));
            TriggerRipping();
        }
        else if(GNdataReqType == CDDA)
        {
            ret = SendEvent(FINISHED_GNFETCHDATA,IN "0");
        }
        else
        {
            ETG_TRACE_ERR(("FetchCDInfofromGN: CDDB_ONDEMAND"));
            m_gnmetadataExtractionResult = GNMETADATA_NOMATCH_FOUND;
            LocalSPM::GetOutputWrapper().UpdateGNdataforAlbumOnUserDemand();
            ret = SendEvent(FINISHED_GNFETCHDATA,IN "0");
        }
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    return ret;
}

tResult CDRipperControl::albumInfoFetched(const tAlbumCount totalAlbums, const tAlbumInfo albumInfoString , const tGracenoteMediaErrorCodes errorcode)
{
    ENTRY;
    m_currentAlbumIndex = 0;
    tResult ret = MP_NO_ERROR;
    if(totalAlbums > 1)
    {
        ETG_TRACE_USR4(("Total Albums: %d",totalAlbums));
        //for multiple album user selection, get the album name and fill the map data with tracks of that album index
        if(GNdataReqType == CDDB_ONDEMAND)
        {
            // Get input from user
            char * pAlbum = NULL;
            unsigned int index = 0;
            m_mapAlbumString.clear();
            if(albumInfoString)
            {
                pAlbum = strtok (albumInfoString,":");
                while (pAlbum != NULL)
                {
                    index++;
                    ETG_TRACE_USR4(("albumInfoFetched : index %d , AlbumString  %s", index,pAlbum));
                    std::string albumStr(pAlbum);
                    m_mapAlbumString.insert( std::pair<std::string,unsigned int >(albumStr,index));
                    pAlbum = strtok (NULL, ":");
                }
                free(albumInfoString);
                // Update the FI
                LocalSPM::GetOutputWrapper().UpdateGraceNoteResolveAmbiguity();
            }
            else
            {
                m_gnmetadataExtractionResult = GNMETADATA_NOMATCH_FOUND;
                LocalSPM::GetOutputWrapper().UpdateGNdataforAlbumOnUserDemand();
                ret = SendEvent(FINISHED_GNFETCHDATA,IN "0");
                if (MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
                }
            }
        }
        //For CDDA or Ripping, even for multiple albums, take default selection of 1
        else
        {
            ETG_TRACE_USR4(("Multiple albums- default selection of index 1 for request type %d",GNdataReqType));
            albumSelectionfromUser(1);
        }
    }
    else if (totalAlbums == 1)
    {
        albumSelectionfromUser(totalAlbums);
    }
    else
    {
        if(GNdataReqType == RIPPING)
        {
            TriggerRipping();
        }
        else if(GNdataReqType == CDDA)
        {
            ret = SendEvent(FINISHED_GNFETCHDATA,IN "0");
        }
        else
        {
            m_gnmetadataExtractionResult = GNMETADATA_NOMATCH_FOUND;
            LocalSPM::GetOutputWrapper().UpdateGNdataforAlbumOnUserDemand();
            ret = SendEvent(FINISHED_GNFETCHDATA,IN "0");
        }
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    return MP_NO_ERROR;
}

tResult CDRipperControl::albumSelectionfromUser(const tAlbumIndex albumIndex)
{

    ENTRY;
    tResult ret = MP_NO_ERROR;
    m_currentAlbumIndex = albumIndex;
    if(m_e8GracenoteInitialized == GRACENOTE_INIT_OK )
    {
        //ipc client fetch album info for TOC
        ret = GracenoteProxy::GetInstance().FetchMetadataInfoMethodCall(albumIndex-1);
        if(ret == MP_ERR_DBUS)
        {
            if(GNdataReqType == RIPPING)
            {
                TriggerRipping();
            }
            else if(GNdataReqType == CDDA)
            {
                ret = SendEvent(FINISHED_GNFETCHDATA,IN "0");
            }
            else
            {
                m_gnmetadataExtractionResult = GNMETADATA_NOMATCH_FOUND;
                LocalSPM::GetOutputWrapper().UpdateGNdataforAlbumOnUserDemand();
                ret = SendEvent(FINISHED_GNFETCHDATA,IN "0");
            }
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
    }
    return ret;
}

tResult CDRipperControl::GetAlbumStringsforGracenote(vector<string> &albumStringVector)
{

    ENTRY;
    tResult ret = MP_NO_ERROR;
    std::map<std::string,unsigned int >::iterator it = m_mapAlbumString.begin();
    for (; it!=m_mapAlbumString.end(); it++)
    {
        (albumStringVector).push_back(it->first);
    }
    return ret;
}

tResult CDRipperControl::ExtractGracenoteMetadata(string albumTitle, tBool multipleAlbumSelection)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;
    tMetadata albumName = {0};
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    VARTRACE(multipleAlbumSelection);
    if(multipleAlbumSelection == true)
    {
        tAlbumIndex albumIndex = 0;

        std::map<std::string,unsigned int >::iterator it ;

        VARTRACE(albumTitle.c_str());

        it = m_mapAlbumString.find(albumTitle);
        if(it != m_mapAlbumString.end())
        {
            albumIndex  = it->second;

        }

        /* Send GRACENOTE_ALBUM_SELECT_ID message to own SM */




        ret = CDRipperControlSM::ParameterGRACENOTE_ALBUM_SELECT_ID(OUT parameterString, IN size, IN albumIndex);
        VARTRACE(albumIndex);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }
        else
        {
            ret = SendEvent(GRACENOTE_ALBUM_SELECT_ID,IN parameterString);
        }
    }
    else
    {
        strncpy_r(OUT albumName, IN albumTitle.c_str(), IN sizeof(tMetadata));
        VARTRACE(albumName);
        ret = CDRipperControlSM::ParameterGRACENOTE_ALBUM_USERSELECT(OUT parameterString, IN size, IN albumName);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }
        else
        {
            ret = SendEvent(GRACENOTE_ALBUM_USERSELECT,IN parameterString);
        }
    }
    return ret;
}
tResult CDRipperControl::GetGNMetadataExtractionStatus(tGNmetadataExtractionResult& GNmetadataExtractionResult)
{
    GNmetadataExtractionResult = m_gnmetadataExtractionResult;
    return MP_NO_ERROR;
}

tResult CDRipperControl::RefillTOCDatafromDB()
{
    ENTRY;
    tRippedTrackInfo trackInfo;
    //enter all the files in Database
    vector<tCDTrackInfo>::iterator iterTrackInfo = m_CDTrackInfo.begin();
    tUInt index = 1;
    tResult ret = MP_NO_ERROR;
    for (; iterTrackInfo != m_CDTrackInfo.end(); ++iterTrackInfo)
    {
        memset(&trackInfo , 0 ,sizeof(tRippedTrackInfo));
        ret = LocalSPM::GetDBManager().GetMetadataOfRippedFile(trackInfo, MUSICBOX_DEVICE_ID, m_CDTOCData.HashID, index);
        if(ret != MP_NO_ERROR)
        {
            ETG_TRACE_ERR(("GetMetadataOfRippedFile:Error while fetching meta data from DB for track %d", index));
            break;
        }
        if(index == 1)
        {
            // check for compilation flag 1 , if yes refill TOC else just return
            if(trackInfo.CompilationFlag == 1)
            {
                strncpy_r(OUT m_CDTOCData.albumName, IN trackInfo.MetadataField4, IN sizeof(tMetadata));
                m_CDTOCData.u32RecordingYear =  trackInfo.Year ;
            }
            else
            {
                ETG_TRACE_USR4(("RefillTOCDatafromDB:Metadata not from gracenote, use existing TOC"));
                break;
            }
        }

        strncpy_r(OUT iterTrackInfo->performer, IN trackInfo.MetadataField2, IN sizeof(tMetadata));
        strncpy_r(OUT iterTrackInfo->genre, IN trackInfo.MetadataField1, IN sizeof(tMetadata));
        strncpy_r(OUT iterTrackInfo->title, IN trackInfo.title, IN sizeof(tMetadata));
        index++;
    }
    return ret;
}


tResult CDRipperControl::gracenoteInitialized(const tGracenoteInitStatus status)
{
    ENTRY;
    tResult res = MP_NO_ERROR;
    m_e8GracenoteInitialized = status;
    GracenoteProxy::GetInstance().GetGracenoteVersion(m_gracenoteVersion);
    VARTRACE(m_gracenoteVersion);
    LocalSPM::GetOutputWrapper().UpdateGracenoteVersion();
    if((m_e8GracenoteInitialized == GRACENOTE_INIT_OK ) && (m_bRequestMetadataFromGracenote == true))
    {
        //ipc client fetch album info for TOC
        res  = GracenoteProxy::GetInstance().FetchAlbumInfoMethodCall(m_CDTOCData.u32TotalTracks,m_startingAddressArray);
        if(res == MP_ERR_DBUS)
        {
            if(GNdataReqType == RIPPING)
            {
                TriggerRipping();
            }
            else if(GNdataReqType == CDDA)
            {
                res = SendEvent(FINISHED_GNFETCHDATA,IN "0");
            }
            else
            {
                m_gnmetadataExtractionResult = GNMETADATA_NOMATCH_FOUND;
                LocalSPM::GetOutputWrapper().UpdateGNdataforAlbumOnUserDemand();
                res = SendEvent(FINISHED_GNFETCHDATA,IN "0");
            }
            if (MP_NO_ERROR != res)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(res)));
            }
        }
        m_bRequestMetadataFromGracenote = false ;
    }
    else
    {
        if(GNdataReqType == RIPPING)
        {
            TriggerRipping();
        }
        else if(GNdataReqType == CDDA)
        {
            res = SendEvent(FINISHED_GNFETCHDATA,IN "0");
        }
        else
        {
            m_gnmetadataExtractionResult = GNMETADATA_NOMATCH_FOUND;
            LocalSPM::GetOutputWrapper().UpdateGNdataforAlbumOnUserDemand();
            res = SendEvent(FINISHED_GNFETCHDATA,IN "0");
        }
        if (MP_NO_ERROR != res)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(res)));
        }
    }
    return MP_NO_ERROR;
}

tResult CDRipperControl::GetRippedFilePath(OUT tRippedFilePath RippedFilePath, IN tTOC HashID, IN tUInt RippedIndex) //100%
{
    ENTRY;

    char data[8] = {0};
    strncpy_r(OUT RippedFilePath, IN (const char *)LocalSPM::GetDataProvider().RippedFilePath().c_str(), IN sizeof(tRippedFilePath));
    strncat_r(OUT RippedFilePath, IN HashID, IN sizeof(tRippedFilePath));
    strncat_r(OUT RippedFilePath, IN "/Track_", IN sizeof(tRippedFilePath));
    snprintf(data, sizeof(data), "%d", RippedIndex);
    strncat_r(OUT RippedFilePath, IN data, IN sizeof(tRippedFilePath));

    return MP_NO_ERROR;
}

tResult CDRipperControl::CancelRipping(void) //100%
{
    ENTRY;

    // event to mediaengine
    StopRipping();

    //Event to DVD control
    //FinishedRipping();

    return MP_NO_ERROR;
}
tResult CDRipperControl::CheckIfDeviceRipped() //100%
{
    ENTRY;
    tResult ret = MP_NO_ERROR;
    tNumberOfMediaObjects rippedfilecount = 0;
    tNumberOfMediaObjects notrippedfilecount = 0;
    tIndexingState indexingState = IDS_NOT_SUPPORTED ;
    m_bRippedTracksExists = false;
    m_CDTOCData.CurrentRippedIndex = 0;
    m_trackNumberList.clear();
    LocalSPM::GetDBManager().GetIndexingState(indexingState,MUSICBOX_DEVICE_ID);


    if((DTY_MUSICBOX == LocalSPM::GetDataProvider().IndexingSupportDeviceType_7()) && (indexingState == IDS_PARTIAL))
    {
        // indexing of files in musicbox folder in progress , ripping cannot be done.Inform DVD Drive to play
        ETG_TRACE_ERR(("Indexing In Progress , cannot be ripped"));
        ret = SendEvent(FINISHED, IN "0");
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
        return ret;

    }

    // check how many files are stored in database
    ret = NumberOfFilesRipped(rippedfilecount, m_CDTOCData.HashID);
    ret = NumberOfFilesNotRipped(notrippedfilecount, m_CDTOCData.HashID);
    //check if all the CD tracks related info is present in DB for partially ripped CD, if not it should be like ripping from beginning
    if(m_CDTOCData.u32TotalTracks != (rippedfilecount+notrippedfilecount))
    {

        m_bRippedTracksExists = true;
        GetTracksAvailableInFlash();
        //delete album

        /*tDeviceID deviceID;
        for(unsigned int trackIndex = 1;trackIndex <= m_CDTOCData.u32TotalTracks;trackIndex++)
        {

            //if(IsRippedTrackExistsInFlash(trackIndex) == true)
            {
                tRippedFilePath RippedFilePath;
                char data[8] = {0};
                strncpy_r(OUT RippedFilePath, IN m_CDTOCData.HashID, IN sizeof(RippedFilePath));
                strncat_r(OUT RippedFilePath, IN "/Track_", IN sizeof(RippedFilePath));
                snprintf(data, sizeof(data), "%d", trackIndex);
                strncat_r(OUT RippedFilePath, IN data, IN sizeof(RippedFilePath));
                strncat_r(OUT RippedFilePath, IN ".mp3", IN sizeof(RippedFilePath));
                ETG_TRACE_USR4(("DeleteRippedFile for partially ripped CD : Ripped file path = %s",RippedFilePath));
            }
        }*/

        rippedfilecount = 0;
    }
    if((rippedfilecount == 0 ) && (m_CDTOCData.u32TotalTracks > 0))
    {
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        ret = CDRipperControlSM::ParameterFETCHED_GNINFO(OUT parameterString, IN size, IN RIPPING);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }
        else
        {
            ret = SendEvent(FETCHED_GNINFO,IN parameterString);
        }
    }
    else if (m_CDTOCData.u32TotalTracks > (rippedfilecount))
    {
        // The TOC has CD text info which will be written using taglib , replace it with gracenote metadata incase available
        RefillTOCDatafromDB();
        m_CDTOCData.CurrentRippedIndex = rippedfilecount;
        ret = SendEvent(CHECK_SPACE, IN "0");
    }
    else
    {
        // ripping is already done for this disk. please inform DVD component
        m_CDTOCData.CurrentRippedIndex = m_CDTOCData.u32TotalTracks;
        ret = SendEvent(FINISHED, IN "0");
    }
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }
    //whether the cd is partially ripped or fully ripped or not ripped , the initial ripping status has to be informed
    ret = LocalSPM::GetOutputWrapper().UpdateRippingStatus();
    return ret;
}

tResult CDRipperControl::ForwardRipperStatus(const tPEHandle handle, const  tPEPlaybackState playbackstate, const reason_e reason)
{
    ENTRY;
    ETG_TRACE_USR1(("CDRipperControl::ForwardRipperStatus Entry"));
    tResult ret = MP_NO_ERROR;


    ETG_TRACE_USR4(("ForwardRipperStatus: Reason = %d", reason));
    // check how many files are stored in database

    if (reason == REASON_EMPTY)
    {
        //File is successfully ripped. Hence increment the Current ripped index
        m_CDTOCData.CurrentRippedIndex++;
        ret = SendEvent(WRITE, IN "0");
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else if(reason == REASON_END_OF_STREAM)
    {
        //Do nothing
    }
    else
    {
        //Ripping failed. handle with error code
        m_RippingError = RIPPING_TRACK_READ_ERROR;
        LocalSPM::GetOutputWrapper().UpdateRippingErrors();
        //pkv5cob update ripping error
        ret = SendEvent(ERROR, IN "0");
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }

    }
    return ret;
}


tResult CDRipperControl::CheckRippingContext(void) //100%
{
    ENTRY;
    tResult ret = MP_NO_ERROR;
    if (m_CDTOCData.CurrentRippedIndex < m_CDTOCData.u32TotalTracks)
    {
        // check free space of the drive
        ret = SendEvent(GO_ON, IN "0");
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else
    {
        // check free space of the drive
        ret = SendEvent(FINISHED, IN "0");
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

    return ret;
}

tResult CDRipperControl::FinishedRipping(void) //100%
{
    ENTRY;
    tResult ret = MP_NO_ERROR;

    tDoneRippingAnswerRequired isRippingAnswerRequired = 1;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    ret = LocalSPM::GetDVDControl().ParameterDONE_RIPPING(OUT parameterString, IN size, IN isRippingAnswerRequired);
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
        parameterString[0] = '\0';
    }
    else
    {
        ret = Dispatcher::GetInstance().SendMessageAnswer(IN "DVDControlSM::DONE_RIPPING", IN parameterString, "CDRipperControlSM::RELEASE_WAIT");
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    return ret;
}

tResult CDRipperControl::FreeSpace(void) //100%
{
    ENTRY;
    tResult ret = MP_NO_ERROR;
    tMemorySize MemoryOnFlashKB = 0;

    StartSwitchObserver();

    // check free space of the drive
    ret = GetUsedMemoryOnFlash(MemoryOnFlashKB);

    if (ret == MP_NO_ERROR)
    {
        if ((LocalSPM::GetDataProvider().LimitRippingMemoryOnFlashKB() - MemoryOnFlashKB) > \
                LocalSPM::GetDataProvider().MinimumMemoryRequiredForRippingKB())
        {
            ret = SendEvent(START_RIPPING, IN "0");
            ret = LocalSPM::GetOutputWrapper().UpdateRippingStatus();
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
        else
        {
            // memory full, Ripping is not possible
            ETG_TRACE_USR1(("No free space available for ripping. used memory = %d", MemoryOnFlashKB));
            ret = SendEvent(CANCEL_RIPPING, IN "0");
            m_RippingError = RIPPING_DISC_FULL_ERROR;
            LocalSPM::GetOutputWrapper().UpdateRippingErrors();
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
            }
        }
    }

    return ret;
}

tResult CDRipperControl::IsRippingEnabled(const tCDTOCInfoPtr ptrCDTOCInfo) //80%
{
    ENTRY;
    ETG_TRACE_USR4(("CDRipperControl::IsRippingEnabled Entry"));

    tResult ret = MP_NO_ERROR;

    // if (ptrCDTOCInfo->u8Valid == INVALID) return -1;

    // Check for ripping state
    // 1. Region is Japan. Data provider CDRippingSupport is enabled only if the region is Japan
    // 2. DVD drive is available. Event AUDIO_DISC_DETECTED will be triggered if DVD drive is connected and CDDA is inserted
    // 3. 8 GB partition. Check the size of the partition mentioned in data provider RippedFilePath

    ret = LocalSPM::GetDataProvider().CDRippingSupport();



    // if ripping mode is not set, inform DVD control to set to CD device
    if (ret)
    {

        m_RippingState = RIPPING_NOT_STARTED;

        // set connection state of the device to connected , and the number of files
        ResetFormerConnection();

        ret = FillTOCBuffer(ptrCDTOCInfo); //fill m_CDTOCData
        if(ret != 1)
        {
            m_RippingState = RIPPING_NOT_SUPPORTED; // Corrupt TOC
        }
    }
    else
    {
        m_RippingState = RIPPING_NOT_SUPPORTED;
    }
    if(ptrCDTOCInfo != NULL)
    {
        delete ptrCDTOCInfo;
    }
    return ret;
}
tResult CDRipperControl::FillTOCBuffer(tCDTOCInfoPtr ptrCDTOCInfo)
{
    ENTRY;
    m_CDTrackInfo.clear();
    memset(&m_CDTOCData, 0, sizeof(tCDTOCData));
    if (ptrCDTOCInfo)
    {
        if((ptrCDTOCInfo->u8MaxTrack) > CD_MAX_TRACK_NUMBER)
        {
            //corrupt TOC - update ripping error
            m_RippingError = RIPPING_TRACK_READ_ERROR;
            LocalSPM::GetOutputWrapper().UpdateRippingErrors();
            return 0;
        }
        memset(m_startingAddressArray,0,STARTING_ADDRESS_ARRAY_SIZE);
        // Store all the TOC information locally
        for(int index = 0; index < ptrCDTOCInfo->u8MaxTrack; index++)
        {
            tCDTrackInfo CDTrackInfo;
            memset(&CDTrackInfo,0,sizeof(tCDTrackInfo));
            char data[32] = {0};
            CDTrackInfo.u32SectorPosition = ptrCDTOCInfo->arTrack[index].u32StartZLBA;
            if(strlen((const char *)ptrCDTOCInfo->arTrack[index].performer))
            {
                strncpy_r(OUT CDTrackInfo.performer, IN (const char *)ptrCDTOCInfo->arTrack[index].performer, IN sizeof(CDTrackInfo.performer));
            }
            else
            {
                strncpy_r(OUT CDTrackInfo.performer,"Unknown", sizeof(tMetadata));
            }

            if (strlen((const char *)ptrCDTOCInfo->arTrack[index].title))
            {
                strncpy_r(OUT CDTrackInfo.title, IN (const char *)ptrCDTOCInfo->arTrack[index].title, IN sizeof(CDTrackInfo.title));
            }
            else
            {
                // Default Text
                char trackno[5] = {0};
                strncpy_r(OUT CDTrackInfo.title, IN "Title ", IN sizeof(tMetadata));
                snprintf(trackno, sizeof(trackno), "%d", (index+1));
                strncat_r(OUT CDTrackInfo.title, IN trackno, IN sizeof(tMetadata));
            }


            strncpy_r(OUT CDTrackInfo.genre, IN "Unknown", IN sizeof(tMetadata));
            strncpy_r(OUT CDTrackInfo.YomiAlbum, IN "Unknown", IN sizeof(tMetadata));
            strncpy_r(OUT CDTrackInfo.YomiArtist, IN "Unknown", IN sizeof(tMetadata));
            strncpy_r(OUT CDTrackInfo.YomiTitle, IN "Unknown", IN sizeof(tMetadata));


            ETG_TRACE_USR4(("IsRippingEnabled: Index = %d, u32SectorPosition = %d", index, CDTrackInfo.u32SectorPosition));
            ETG_TRACE_USR4(("IsRippingEnabled: Index = %d, Performer = %s", index, CDTrackInfo.performer));
            ETG_TRACE_USR4(("IsRippingEnabled: Index = %d, Title = %s", index, CDTrackInfo.title));

            m_CDTrackInfo.push_back(CDTrackInfo);

            // create TOC string with the help if all the track starting sectors
            snprintf(data, sizeof(data), "%d", ptrCDTOCInfo->arTrack[index].u32StartZLBA);
            m_startingAddressArray[index] = ptrCDTOCInfo->arTrack[index].u32StartZLBA;
            strncat_r(OUT m_CDTOCData.TOC, IN data, IN sizeof(m_CDTOCData.TOC));
        }
        m_startingAddressArray[ptrCDTOCInfo->u8MaxTrack] = ptrCDTOCInfo->u32LastZLBA;
        //Form the TOCstring from starting address array - used later to fetch gracenote metadata
        mToCString.clear();
        for(unsigned int i = 0; i <= ptrCDTOCInfo->u8MaxTrack ; i++)
        {
            if(i != 0)
            {
                mToCString += " ";
            }
            else
            {
                m_startingAddressArray[i] = 150;
            }
            mToCString += std::to_string((m_startingAddressArray[i]));
        }

        // get recording time infotmation
        tDateTime dateTime;
        time_t rawtime;
        time(&rawtime);
        struct tm *timeinfo;
        timeinfo = localtime(&rawtime);
        strftime(dateTime, sizeof(dateTime), "%Y.%m.%d, %H:%M", timeinfo);
        m_CDTOCData.u32RecordingYear = 1900 + timeinfo->tm_year;
        //strftime(dateTime, sizeof(dateTime), "%Y", timeinfo);
        //strncpy_r(OUT m_CDTOCData.RecordingYear, IN dateTime, IN sizeof(tMetadata));

        if (strlen((const char *)ptrCDTOCInfo->albumName))
        {
            strncpy_r(OUT m_CDTOCData.albumName, IN (const char *)ptrCDTOCInfo->albumName, IN sizeof(m_CDTOCData.albumName));
        }
        else
        {
            strncpy_r(OUT m_CDTOCData.albumName, IN dateTime, IN sizeof(m_CDTOCData.albumName));
        }

        m_CDTOCData.u32TotalTracks = ptrCDTOCInfo->u8MaxTrack;
        //m_CDTOCData.CurrentRippedIndex = ptrCDTOCInfo->u8MinTrack;
        strncpy_r(OUT m_CDTOCData.MountPoint , IN (const char *)ptrCDTOCInfo->m_MountPoint, IN sizeof(m_CDTOCData.MountPoint));
        strncat_r(OUT m_CDTOCData.MountPoint , IN ".rip", IN sizeof(m_CDTOCData.MountPoint));

        ETG_TRACE_USR4(("IsRippingEnabled: TotalTracks = %d, Album Name = %s",m_CDTOCData.u32TotalTracks, m_CDTOCData.albumName));

        return 1;
    }

    else
    {
        m_RippingError = RIPPING_TRACK_READ_ERROR;
        LocalSPM::GetOutputWrapper().UpdateRippingErrors();
        return 0;
    }
}

tResult CDRipperControl::IsRippingCompleted(tCDTOCInfoPtr ptrCDTOCInfo, tUInt &RippingState)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;
    RippingState = RIPPING_NOT_SUPPORTED;
    ret = FillTOCBuffer(ptrCDTOCInfo);
    if(ret)
    {
        ret = CalculateCDIDHash(ptrCDTOCInfo);
        if(ret == MP_NO_ERROR)
        {
            tNumberOfMediaObjects rippedfilecount = 0;
            tNumberOfMediaObjects notrippedfilecount = 0;
            // check how many files are stored in database
            ret = NumberOfFilesRipped(rippedfilecount, m_CDTOCData.HashID);
            ret = NumberOfFilesNotRipped(notrippedfilecount, m_CDTOCData.HashID);
            if(ret)
            {
                VARTRACE(rippedfilecount);
            }
            //check if all the CD tracks related info is present in DB for partially ripped CD, if not it should be like ripping from beginning
            if(m_CDTOCData.u32TotalTracks != (rippedfilecount+notrippedfilecount))
            {
                m_bRippedTracksExists = true;
                rippedfilecount = 0;
                RippingState = RIPPING_NOT_STARTED;
            }
            if((rippedfilecount == 0 ) && (m_CDTOCData.u32TotalTracks > 0))
            {
                //Ripping not started
                m_CDTOCData.CurrentRippedIndex = 0;
            }
            else if (m_CDTOCData.u32TotalTracks > (rippedfilecount))
            {
                // The TOC has CD text info which will be written using taglib , replace it with gracenote metadata incase available
                //RefillTOCDatafromDB();
                m_CDTOCData.CurrentRippedIndex = rippedfilecount;
                RippingState = RIPPING_PARTIAL;
                //Ripping in progress
            }
            else
            {
                // ripping is already done for this disk. please inform DVD component
                m_CDTOCData.CurrentRippedIndex = m_CDTOCData.u32TotalTracks;
                RippingState = RIPPING_COMPLETED;
            }
        }
        else
        {
            ETG_TRACE_ERR(("CalculateCDHashID failed"));
        }
    }
    else
    {
        ETG_TRACE_ERR(("Fill TOC buffer failed"));
    }
    ret = LocalSPM::GetOutputWrapper().UpdateRippingStatus();
    return ret;
}

tResult CDRipperControl::StartRipping(void) //100%
{
    ENTRY;
    tResult ret = MP_NO_ERROR;

    char data[8] = {0};
    tRippedFilePath RippedFilePath;
    tURL URL;

    //prepare folder path
    strncpy_r(OUT RippedFilePath, IN (const char *)LocalSPM::GetDataProvider().RippedFilePath().c_str(), IN sizeof(RippedFilePath));


    // Create a folder if not exists
    if(! exists_directory(RippedFilePath))
    {

        /* Create directory with read, write, execute permission for owner and read, execute permission for group = 0750 */
        if(0 != mkdir(RippedFilePath, S_IRWXU | S_IRGRP | S_IXGRP))
        {
            ETG_TRACE_ERR(("mkdir: error: %d/%s", errno, strerror(errno)));
            ETG_TRACE_USR4(("StartRipping: Folder creation failed: %s",RippedFilePath));
            ret = MP_ERR_NO_SPACE;
        }
        else
        {
        }
    }


    strncat_r(OUT RippedFilePath, IN m_CDTOCData.HashID, IN sizeof(RippedFilePath));
    // Create a folder if not exists
    if(! exists_directory(RippedFilePath))
    {
        if(0 != mkdir(RippedFilePath, S_IRWXU | S_IRGRP | S_IXGRP))
        {
            ETG_TRACE_ERR(("mkdir: error: %d/%s", errno, strerror(errno)));
            ETG_TRACE_USR4(("StartRipping: Folder creation failed: %s",RippedFilePath));
            ret = MP_ERR_NO_SPACE;
        }
        else
        {
            ETG_TRACE_USR4(("StartRipping: created folder to store ripped file: %s",RippedFilePath));
        }
    }
    if(ret == MP_NO_ERROR)
    {
        m_RippingState = RIPPING_PARTIAL;
        tEncodingQuality rippingEncodingQuality;
        GetRippingEncodingQuality(rippingEncodingQuality);

        tUInt FileIndextobeRipped = m_CDTOCData.CurrentRippedIndex+1;
        if((m_bRippedTracksExists ) && (IsRippedTrackExistsInFlash(FileIndextobeRipped)))
        {
            //File is already ripped. Hence increment the Current ripped index
            m_CDTOCData.CurrentRippedIndex++;
            //already track available in memory , just rewrite the metadata info
            ret = SendEvent(WRITE, IN "0");
        }
        else
        {

            //send event to mediaengine
            strncpy_r(OUT URL, IN m_CDTOCData.MountPoint, IN sizeof(URL));
            tPEStateString args;
            SMF::Marshal((char *)args, sizeof(args), DOUBLE_MARSHAL_SEPARATOR, "tiiltliiii", URL, (int)ME_SPEED_NONE, 0, HANDLE_NONE, RippedFilePath, samplerate_i_none, 0, FileIndextobeRipped, 0, rippingEncodingQuality);
            ret = Dispatcher::GetInstance().SendMessageAnswer(IN "MediaEngineRipperSM::PLAY", args, "CDRipperControlSM::RIPPING_ANSWER");

        }

        //Frame the path to send to MediaEngine
        strncat_r(OUT RippedFilePath, IN "/Track_", IN sizeof(RippedFilePath));
        snprintf(data, sizeof(data), "%d", FileIndextobeRipped);
        strncat_r(OUT RippedFilePath, IN data, IN sizeof(RippedFilePath));
        strncat_r(OUT RippedFilePath, IN ".mp3", IN sizeof(RippedFilePath));
        strncpy_r(OUT m_CDTOCData.RippedFilePath, IN RippedFilePath, IN sizeof(tRippedFilePath));
        ETG_TRACE_USR4(("StartRipping: Ripped file path = %s",RippedFilePath));
    }
    else
    {
        // mkdir failure, Ripping is not possible
        ETG_TRACE_USR1(("No free space available for ripping. Cannot create directory "));
        ret = SendEvent(CANCEL_RIPPING, IN "0");
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
        m_RippingError = RIPPING_DISC_FULL_ERROR;
        LocalSPM::GetOutputWrapper().UpdateRippingErrors();
    }

    return ret;
}

tResult CDRipperControl::UpdateMediaCategory(void)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;
    tIndexingState indexingState = IDS_COMPLETE;
    tUInt indexingPercentage = 100;
    tUInt totaMemorylSize = 0;
    tUInt freeMemorySize = 0;
    tUInt numberOfRippedFile = 0;
    tMemorySize MemoryOnFlashKB = 0;

    // check free space of the drive
    ret = GetUsedMemoryOnFlash(MemoryOnFlashKB);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while collecting used space in for Musicbox"));
    }

    // indexingState = (m_CDTOCData.CurrentRippedIndex == m_CDTOCData.u32TotalTracks) ? IDS_COMPLETE: IDS_PARTIAL;
    // indexingPercentage = m_CDTOCData.CurrentRippedIndex/m_CDTOCData.u32TotalTracks*100;
    totaMemorylSize = LocalSPM::GetDataProvider().LimitRippingMemoryOnFlashKB();
    freeMemorySize = totaMemorylSize - MemoryOnFlashKB;
    numberOfRippedFile = m_CDTOCData.CurrentRippedIndex;
    //get used space

    ret = LocalSPM::GetDBManager().UpdateMusicBoxDevice(MUSICBOX_DEVICE_ID, numberOfRippedFile, indexingState, indexingPercentage, totaMemorylSize, freeMemorySize);
    if(MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while updating indexing state in DBManager (ErrorCode:%s)", errorString(ret)));
    }


    //fill the toc uuid table for just once as there is only one toc for one CD and the first track is ripped now
    if(numberOfRippedFile == 1)
    {
        ret = LocalSPM::GetDBManager().AddMusicBoxToC((char*)mToCString.c_str(),m_CDTOCData.HashID);
        if(!ret)
        {
            ETG_TRACE_ERR(("Error while adding values to MusicBoxToC(ErrorCode:%s)", errorString(ret)));
        }
    }

    // Send update of the ripped track
    ret = LocalSPM::GetOutputWrapper().UpdateRippingStatus();
    return ret;
}

tResult CDRipperControl::WriteTagtoFile(void)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;
    VARTRACE(m_CDTOCData.CurrentRippedIndex);

    Info *info = Info::create_tag_info(IN m_CDTOCData.RippedFilePath);
    if(info)
    {
        info->set_album(m_CDTOCData.albumName);
        info->set_artist(m_CDTrackInfo[m_CDTOCData.CurrentRippedIndex-1].performer);
        info->set_genre(m_CDTrackInfo[m_CDTOCData.CurrentRippedIndex-1].genre);
        info->set_title(m_CDTrackInfo[m_CDTOCData.CurrentRippedIndex-1].title);
        info->set_year(m_CDTOCData.u32RecordingYear);
        info->set_tracknumber(m_CDTOCData.CurrentRippedIndex);
        if(!info->write())
        {
            ret = -1;
        }
        delete info;

        //Form URL
        tRippedFilePath RippedFilePath;
        char data[8] = {0};
        strncpy_r(OUT RippedFilePath, IN m_CDTOCData.HashID, IN sizeof(RippedFilePath));
        strncat_r(OUT RippedFilePath, IN "/Track_", IN sizeof(RippedFilePath));
        snprintf(data, sizeof(data), "%d", m_CDTOCData.CurrentRippedIndex);
        strncat_r(OUT RippedFilePath, IN data, IN sizeof(RippedFilePath));
        strncat_r(OUT RippedFilePath, IN ".mp3", IN sizeof(RippedFilePath));
        ETG_TRACE_USR4(("UpdateRippedFileCategory: Ripped file path = %s",RippedFilePath));
        // update ripped track as an audio tag
        ret = LocalSPM::GetDBManager().UpdateRippedFileCategory(1, RippedFilePath, CTY_SONG);
    }
    else
    {
        ret = -1;
    }

    // check free space of the drive
    ret = SendEvent(NEXT, IN "0");
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return ret;
}

tResult CDRipperControl::StopRipping(void)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;

    if(m_RippingState == RIPPING_PARTIAL)
    {
        ret = Dispatcher::GetInstance().SendMessageAnswer("MediaEngineRipperSM::STOP", NULL, "CDRipperControlSM::STOP_ANSWER");
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    else //when cd is ejected while ripping state is not moved to partial but it is pre-processing(like fetching data from GN) , we still have to send done ripping to DVD state machine
    {
        tDoneRippingAnswerRequired isRippingAnswerRequired = 0;
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        ret = LocalSPM::GetDVDControl().ParameterDONE_RIPPING(OUT parameterString, IN size, IN isRippingAnswerRequired);
        if(MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
            parameterString[0] = '\0';
        }
        ret = LocalSPM::GetDVDControl().SendEventByName("DONE_RIPPING", IN parameterString);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while sending event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }
    return MP_NO_ERROR;
}

/* Media engine is done with ripping pipeline , now trigger DONE_RIPPING to DVD Control */
/* STOP_ANSWER hits here */

tResult CDRipperControl::StopRippingAnswer(void)
{
    ENTRY;
    if(m_RippingState == RIPPING_PARTIAL)
    {
        // check currentRippedFile , If present , then delete.

        if(0 != remove(m_CDTOCData.RippedFilePath))
        {
            ETG_TRACE_ERR(("Cannot delete partially ripped file: %s", m_CDTOCData.RippedFilePath));
        }
        m_RippingState = RIPPING_NOT_STARTED;

    }
    //Event to DVD control
    FinishedRipping();

    return MP_NO_ERROR;
}

tResult CDRipperControl::RippingStatus(tUInt &RippingState, tUInt &TotalTracks, tUInt &CurrentRippingIndex, tUInt &Percentage)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;

    if (LocalSPM::GetDataProvider().CDRippingSupport()) // && (TRUE == m_bAutoRipping))
    {
        TotalTracks = m_CDTOCData.u32TotalTracks;
        CurrentRippingIndex = m_CDTOCData.CurrentRippedIndex;
        if (m_CDTOCData.u32TotalTracks != 0)
        {
            Percentage = (m_CDTOCData.CurrentRippedIndex*100)/m_CDTOCData.u32TotalTracks;
            VARTRACE(Percentage);
        }
        if (m_CDTOCData.CurrentRippedIndex == m_CDTOCData.u32TotalTracks)
        {
            RippingState = RIPPING_COMPLETED;

            // update file count in database
            tNumberOfFiles numberOfPlayableFiles = 0;
            ret = LocalSPM::GetDBManager().GetNumberOfAudioFiles(OUT numberOfPlayableFiles, IN MUSICBOX_DEVICE_ID);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while reading number of files at DBManager (ErrorCode:%s)", errorString(ret)));
            }
            VARTRACE(numberOfPlayableFiles);

            //Add the newly ripped files
            numberOfPlayableFiles = numberOfPlayableFiles + m_CDTOCData.u32TotalTracks;

            //update new file count in database
            ret = LocalSPM::GetDBManager().SetNumberOfAudioFiles(IN MUSICBOX_DEVICE_ID, IN numberOfPlayableFiles);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while updating number of files at DBManager (ErrorCode:%s)", errorString(ret)));
            }
        }
        else if(m_CDTOCData.CurrentRippedIndex < m_CDTOCData.u32TotalTracks)
        {
            RippingState = RIPPING_PARTIAL;

            // update first ripped file in database if no file is still ripped
            tNumberOfFiles numberOfPlayableFiles = 0;
            ret = LocalSPM::GetDBManager().GetNumberOfAudioFiles(OUT numberOfPlayableFiles, IN MUSICBOX_DEVICE_ID);
            if(MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while reading number of files at DBManager (ErrorCode:%s)", errorString(ret)));
            }
            VARTRACE(numberOfPlayableFiles);
            if (numberOfPlayableFiles <= 0)
            {
                //update first file count in database
                ret = LocalSPM::GetDBManager().SetNumberOfAudioFiles(IN MUSICBOX_DEVICE_ID, IN (numberOfPlayableFiles+CurrentRippingIndex));
                if(MP_NO_ERROR != ret)
                {
                    ETG_TRACE_ERR(("Error while updating number of files at DBManager (ErrorCode:%s)", errorString(ret)));
                }
            }
        }
        else
        {
            RippingState = RIPPING_NOT_STARTED;
        }
    }
    else
    {
        // Ripping is not enabled
        RippingState = RIPPING_NOT_SUPPORTED;
        TotalTracks = 0;
        CurrentRippingIndex = 0;
        Percentage = 0;
    }
    VARTRACE(RippingState);
    m_RippingState = RippingState;
    return ret;
}
tResult CDRipperControl::GetRippingError(tResult &RippingError)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;
    RippingError = m_RippingError;
    return ret;
}

tResult CDRipperControl::GetAutoRippingStatus(tBoolean &AutoRippingMode)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;

    AutoRippingMode = m_bAutoRipping;

    return ret;
}


tResult CDRipperControl::SetAutoRippingMode(tBoolean AutoRippingMode)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;

    m_bAutoRipping = AutoRippingMode;
    ret = LocalSPM::GetOutputWrapper().UpdateAutoRipping();

    return MP_NO_ERROR;
}

tResult CDRipperControl::NumberOfFilesRipped(OUT tNumberOfMediaObjects &CountRippedFiles, IN tTOC HashID)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;

    ret = LocalSPM::GetDBManager().GetNumberOfRippedFile(CountRippedFiles, MUSICBOX_DEVICE_ID, HashID, CTY_SONG);

    return ret;
}

tResult CDRipperControl::NumberOfFilesNotRipped(OUT tNumberOfMediaObjects &CountRippedFiles, IN tTOC HashID)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;

    ret = LocalSPM::GetDBManager().GetNumberOfRippedFile(CountRippedFiles, MUSICBOX_DEVICE_ID, HashID, CTY_RIPPING);

    return ret;
}

tResult CDRipperControl::NumberOfTotalFilesRipped(OUT tNumberOfMediaObjects &totalRippedFileCount)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;

    ret = LocalSPM::GetDBManager().GetNumberOfTotalRippedFile(totalRippedFileCount, MUSICBOX_DEVICE_ID, CTY_SONG);

    return ret;
}

tResult CDRipperControl::ClearAllRippedContent(void)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;

    ret = RemoveDirectory(LocalSPM::GetDataProvider().RippedFilePath(),false);
    if(0 == ret)
    {
        ETG_TRACE_USR3(("CDRipperControl::ClearAllRippedContent: RemoveDirectory() success"));
    }
    else
    {
        ETG_TRACE_ERR(("CDRipperControl::ClearAllRippedContent: RemoveDirectory() failed"));
    }

    m_bAutoRipping = false;
    ret = LocalSPM::GetOutputWrapper().UpdateAutoRipping();
    return ret;
}

tResult CDRipperControl::ClearRippedContentOfDevice(IN tTOC HashID)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;


    return ret;
}


tResult CDRipperControl::GetUsedMemoryOnFlash(tMemorySize &MemoryOnFlashKB)
{
    ENTRY;
    MemoryOnFlashKB = 0;

    tFilename tmpFileName = {0};
    if(0 > GenerateTempFileName(OUT tmpFileName, IN "RippedFileStorage"))
    {
        ETG_TRACE_ERR(("Cannot create temp file name: %s", tmpFileName));
    }
    else
    {
        /* Make "du -s" on ripped file path to estimate file space usage and pipe the result into a temp file */
        string cdripperFilePath = LocalSPM::GetDataProvider().RippedFilePath();
        char *commandStr[4]={(char *)"/usr/bin/du",(char *)("-s"),(char *)cdripperFilePath.c_str(),NULL};
        ETG_TRACE_USR4(("CDRipperControl::GetUsedMemoryOnFlash: calling executeCommand() for du -s %s",commandStr[2]));
        int retStatus = executeCommand(commandStr,string(tmpFileName));
        if(0 == retStatus)
        {
            ETG_TRACE_USR3(("CDRipperControl::GetUsedMemoryOnFlash: executeCommand() success for du -s"));
            /* Read temp file to get file space usage */
            FILE *fp;
            fp = fopen(tmpFileName, "r");
            if (!fp)
            {
                ETG_TRACE_ERR(("fopen: error: %d/%s", errno, strerror(errno)));
            }
            else
            {
                char buffer[32];
                if(NULL != fgets(buffer, sizeof(buffer), fp))
                {
                    MemoryOnFlashKB = atoi(buffer);
                }
                fclose(fp);
            }
        }
        else
        {
            ETG_TRACE_ERR(("CDRipperControl::GetUsedMemoryOnFlash: executeCommand() failed for du -s. Error:%s",strerror(retStatus)));
        }

        if(0 != remove(tmpFileName))
        {
            ETG_TRACE_ERR(("Cannot delete temp file: %s", tmpFileName));
        }
    }

    VARTRACE(MemoryOnFlashKB);
    return MP_NO_ERROR;
}

tResult CDRipperControl::UpdateRippedFileCategory(tDeviceID deviceID, tRippedFilePath filepath, tCategoryType CategoryType)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;
    // update status in database
    ret = LocalSPM::GetDBManager().UpdateRippedFileCategory(deviceID, filepath, CategoryType);

    return ret;
}


tResult CDRipperControl::StartRippingByUser()
{
    ENTRY;
    tResult ret = MP_NO_ERROR;

    ret = LocalSPM::GetCDRipperControl().SendEventByName("RESTART_RIPPING", IN NULL);

    return ret;
}

tResult CDRipperControl::ReleaseWait(void)
{
    ENTRY;
    if(true == m_bRippingStoppedByUser)
    {
        sem_post(&m_Semaphore);
        m_bRippingStoppedByUser = false;
    }
    return MP_NO_ERROR;
}

tResult CDRipperControl::StopRippingByUser()
{
    ENTRY;
    tResult ret = MP_NO_ERROR;

    ret = LocalSPM::GetCDRipperControl().SendEventByName("STOP_RIPPING", IN NULL);

    if (sem_init(&m_Semaphore, 0, 0) != -1)
    {
        struct timespec semTime;
        if (clock_gettime(CLOCK_REALTIME, &semTime) != -1)
        {
            semTime.tv_sec += 2 ; // maximum timeout 2s
            //semaphore wait , wait till the ripping is completely stopped
            m_bRippingStoppedByUser =  true;
            sem_timedwait(&m_Semaphore,&semTime);
        }
    }
    else
    {
        ETG_TRACE_ERR(("\n Semaphore not initialized \n"));
    }
    return ret;
}


tResult CDRipperControl::RestartRipping()
{
    ENTRY;
    tResult ret = MP_NO_ERROR;

    if (LocalSPM::GetDataProvider().CDRippingSupport() || (TRUE == m_bAutoRipping))
    {
        return true;
    }

    return false;
}


tResult CDRipperControl::GetRippingEncodingQuality(OUT tEncodingQuality &rippingEncodingQuality)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    rippingEncodingQuality = m_rippingEncodingQuality;
    VARTRACE(rippingEncodingQuality);
    return ret;
}

tResult CDRipperControl::SetRippingEncodingQuality(IN tEncodingQuality rippingEncodingQuality)
{
    ENTRY
    VARTRACE(rippingEncodingQuality);
    tResult ret = MP_NO_ERROR;
    //Locker rippingEncodingQualityLocker(&m_rippingEncodingQualityLock);
    m_rippingEncodingQuality = rippingEncodingQuality;
    ret = LocalSPM::GetOutputWrapper().UpdateRippingEncodingQuality();
    return ret;
}

void CDRipperControl::TriggerRipping(bool bGracenote)
{
    //send event CHECK_SPACE
    ENTRY;

    InsertTracksInMediaObjectTable(bGracenote);
    //move to next state , check space and start ripping
    tResult ret = SendEvent(CHECK_SPACE, IN "0");
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }

    return;
}

tResult CDRipperControl::FinishedFetchGNData(tMetadataAvailablefromGN GNmetadataAvailable)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    char messageString[64];
    strncpy_r(OUT messageString, IN "DVDControlSM::FINISHED_GN", IN sizeof(messageString));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    if(GNdataReqType == CDDB_ONDEMAND)
    {
        //check data available in map and if GN metadata available
        if(GNmetadataAvailable == 1 && m_mapMetadataInfo.size() > 0)
        {
            UpdateGNdataInMediaObjectTable();
            m_gnmetadataExtractionResult = GNMETADATA_EXTRACTION_SUCCESS;;
        }
        else
        {
            m_gnmetadataExtractionResult = GNMETADATA_NOMATCH_FOUND;
        }
        ret = LocalSPM::GetOutputWrapper().UpdateGNdataforAlbumOnUserDemand();
    }
    else if(GNdataReqType == CDDA)
    {
        if(GNmetadataAvailable == 1 && m_mapMetadataInfo.size() > 0)
        {
            ret = LocalSPM::GetDVDControl().ParameterFINISHED_GN(OUT parameterString, IN size, IN 1);
            ret = LocalSPM::GetDVDControl().SendEventByName("FINISHED_GN", IN parameterString);
        }
        else
        {
            //Respond Failure to DVD Control SM - Null value failure response
            ret = LocalSPM::GetDVDControl().ParameterFINISHED_GN(OUT parameterString, IN size, IN 0);
            ret = LocalSPM::GetDVDControl().SendEventByName("FINISHED_GN", IN parameterString);
        }
    }
    return ret;
}

void CDRipperControl::GetGracenoteDatafromMap(std::map<unsigned int ,tRippedTrackInfo> &mGNdatamap)
{
    ENTRY
    mGNdatamap = m_mapMetadataInfo;
}
tResult CDRipperControl::UpdateGNdataInMediaObjectTable()
{
    ENTRY;
    tResult ret = MP_NO_ERROR;
    tUInt index = 1;
    VARTRACE(m_mapMetadataInfo.size());
    std::map<unsigned int ,tRippedTrackInfo>::iterator it = m_mapMetadataInfo.begin();

    //Update all the tracks in Database with gracenote data - multiple album name(selected album name)
    for(; it != m_mapMetadataInfo.end() ; ++it)
    {
        tRippedTrackInfo rippedTrackData;
        char data[8]={0};

        ETG_TRACE_USR4(("UpdateGNdataInMediaObjectTable: Push data in Database"));
        strncpy_r(OUT rippedTrackData.MetadataField4, IN it->second.MetadataField4, IN sizeof(tMetadata));
        strncpy_r(OUT rippedTrackData.MetadataField1, IN it->second.MetadataField1, IN sizeof(tMetadata));
        strncpy_r(OUT rippedTrackData.MetadataField2, IN it->second.MetadataField2, IN sizeof(tMetadata));
        rippedTrackData.CompilationFlag = 1;
        //TODO update for yomi metadata in database
        /*strncpy_r(OUT rippedTrackData.YomiAlbum, IN it->second.YomiAlbum, IN sizeof(tMetadata));
        strncpy_r(OUT rippedTrackData.YomiArtist, IN it->second.YomiArtist, IN sizeof(tMetadata));
        strncpy_r(OUT rippedTrackData.YomiTitle, IN it->second.YomiTitle, IN sizeof(tMetadata));*/

        strncpy_r(OUT rippedTrackData.title, IN it->second.title, IN sizeof(tTitle));

        ret = LocalSPM::GetDBManager().UpdateGNmetadatainMediaObject(IN rippedTrackData, IN MUSICBOX_DEVICE_ID, IN mUUIDforGNalbum, IN index);
        if(ret)
        {
            VARTRACE("ERROR IN UPDATING DB");
        }

        //Frame the file path to the track
        tRippedFilePath FilePath;
        strncpy_r(OUT FilePath, IN "/var/opt/bosch/musicbox/", IN sizeof(tRippedFilePath));
        strncat_r(OUT FilePath, IN mUUIDforGNalbum, IN sizeof(tRippedFilePath));
        strncat_r(OUT FilePath, IN "/Track_", IN sizeof(tRippedFilePath));
        snprintf(data, sizeof(data), "%d", index);
        strncat_r(OUT FilePath, IN data, IN sizeof(tRippedFilePath));
        strncat_r(OUT FilePath, IN ".mp3", IN sizeof(tRippedFilePath));
        VARTRACE(FilePath);

        //write the fetched gracenote metadata to tag info
        Info *info = Info::create_tag_info(IN FilePath);
        if(info)
        {
            info->set_album(it->second.MetadataField4);
            info->set_artist(it->second.MetadataField2);
            info->set_genre(it->second.MetadataField1);
            info->set_title(it->second.title);
            // info->set_year(it->second.Year);
            // info->set_tracknumber(index);
            if(!info->write())
            {
                ret = -1;
            }
            delete info;
        }
        index++;
    }
    if (MP_NO_ERROR != ret)
    {
        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
    }
    return MP_NO_ERROR;
}

void CDRipperControl::UpdateTOCBufferFromGraceNote()
{

    ENTRY;

    //enter all the files in Database
    vector<tCDTrackInfo>::iterator iterTrackInfo = m_CDTrackInfo.begin();
    tUInt index = 1;
    tResult ret = MP_NO_ERROR;
    std::map<unsigned int ,tRippedTrackInfo>::iterator it;
    for (; iterTrackInfo != m_CDTrackInfo.end(); ++iterTrackInfo)
    {

        it = m_mapMetadataInfo.find(index);
        if (it != m_mapMetadataInfo.end())
        {
            if(index == 1)
            {
                strncpy_r(OUT m_CDTOCData.albumName, IN it->second.MetadataField4, IN sizeof(tMetadata));
            }
            strncpy_r(OUT iterTrackInfo->performer, IN it->second.MetadataField2, IN sizeof(tMetadata));
            strncpy_r(OUT iterTrackInfo->genre, IN it->second.MetadataField1, IN sizeof(tMetadata));
            strncpy_r(OUT iterTrackInfo->title, IN it->second.title, IN sizeof(tMetadata));
            strncpy_r(OUT iterTrackInfo->YomiTitle, IN it->second.YomiTitle, IN sizeof(tMetadata));
            strncpy_r(OUT iterTrackInfo->YomiArtist, IN it->second.YomiArtist, IN sizeof(tMetadata));
            strncpy_r(OUT iterTrackInfo->YomiAlbum, IN it->second.YomiAlbum, IN sizeof(tMetadata));
        }
        else
        {
            break;
        }
        index++;

    }
    //  TriggerRipping();
    return;

}

tResult CDRipperControl::metadataInfoFetchedGN( const tMetadataInfo metadataString,const tGracenoteMediaErrorCodes errorCode)
{

    ENTRY;
    tResult res = MP_NO_ERROR;
    if(metadataString != NULL)
    {
        xmlDocPtr doc;  // pointer to parse xml Document
        xmlNodePtr cur; // node pointer. It interacts with individual node
        VARTRACE(metadataString);
        VARTRACE((unsigned int)strlen(metadataString));
        doc = xmlParseDoc((const xmlChar *)metadataString);
        // Check to see that the document was successfully parsed.
        if (doc == NULL ) {
            ETG_TRACE_ERR(("metadataInfoFetched: Error!. metadataString is not parsed successfully"));
            res = MP_XML_PARSE_ERR;
        }
        if(res == MP_NO_ERROR)
        {
            // Retrieve the document's root element.
            cur = xmlDocGetRootElement(doc);

            // Check to make sure the document actually contains something
            if (cur == NULL) {
                ETG_TRACE_ERR(("metadataInfoFetched: metadataString is Empty"));
                xmlFreeDoc(doc);
                res = MP_XML_PARSE_ERR;
            }
            /* We need to make sure the document is the right type.
             * "album" is the root type of the documents used in user Config XML file
             */
            if(res == MP_NO_ERROR)
            {
                if(xmlStrcmp(cur->name, (const xmlChar *) "album")) {
                    ETG_TRACE_ERR(("metadataInfoFetched: metadataString is of the wrong type, root node != album"));
                    xmlFreeDoc(doc);
                    res = MP_XML_PARSE_ERR;
                }

                /* Get the first child node of cur.
                 * At this point, cur points at the document root,
                 * which is the element "album"
                 */
                if(res == MP_NO_ERROR)
                {
                    res = parseAlbumMetadataInfo (doc, cur);
                    /*free the document */
                    xmlFreeDoc(doc);
                    /*
                     * Free the global variables that may
                     * have been allocated by the parser.
                     */
                    xmlCleanupParser();
                }

            }
        }

        free(metadataString);

    }// end of XMLParseDoc function
    else
    {
        res = MP_ERR_DBUS;

    }

    if(res == MP_NO_ERROR)
    {
        if(GNdataReqType == RIPPING)
        {
            UpdateTOCBufferFromGraceNote();
            tAlbumArtPath albumArtPath = "/tmp";//kmv5cob : TODO : This path has to be changed as per discussion with architect
            //Extract Album Art
            res = GracenoteProxy::GetInstance().FetchAlbumArtInfoMethodCall(albumArtPath,(m_currentAlbumIndex-1));
            TriggerRipping(true);
        }
        else if(GNdataReqType == CDDB_ONDEMAND)
        {
            tAlbumArtPath albumArtPath = "/tmp";//kmv5cob : TODO : This path has to be changed as per discussion with architect
            //Extract Album Art
            GracenoteProxy::GetInstance().FetchAlbumArtInfoMethodCall(albumArtPath,(m_currentAlbumIndex-1));
            res = SendEvent(FINISHED_GNFETCHDATA,IN "1");
        }
        else if(GNdataReqType == CDDA)
        {
            res = SendEvent(FINISHED_GNFETCHDATA,IN "1");
        }

        if( MP_NO_ERROR != res )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(res)));
        }

    }
    else
    {
        if(GNdataReqType == RIPPING)
        {
            TriggerRipping(false);
        }
        else if(GNdataReqType == CDDA || GNdataReqType == CDDB_ONDEMAND)
        {
            res = SendEvent(FINISHED_GNFETCHDATA,IN "0");
            if( MP_NO_ERROR != res )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(res)));
            }
        }
    }

    //TriggerRipping(true);
    return res;
}

/*
 * Parse album Element Node in XML file
 * <album name="abi" year="1989" artist="a123" genre="rock2" yomiartist="aym123" yomititle="alym123">
 *    <trackInfo title="a12345678" yomiartist="aym123" yomialbum="alym123" yomititle="tlym121" index="1" artist="a123" genre="rock2"/>
 *    <trackInfo title="b12345678" yomiartist="aym123" yomialbum="alym123" yomititle="tlym122" index="2" artist="a123" genre="rock2"/>
 *    <trackInfo title="c12345678" yomiartist="aym123" yomialbum="alym123" yomititle="tlym123" index="3" artist="a123" genre="rock2"/>
 *    <trackInfo title="d12345678" yomiartist="aym123" yomialbum="alym123" yomititle="tlym124" index="4" artist="a123" genre="rock2"/>
 *  </album>
 */
tResult CDRipperControl::parseAlbumMetadataInfo (xmlDocPtr doc, xmlNodePtr cur)
{
    ENTRY;
    m_mapMetadataInfo.clear();

    tResult res = MP_NO_ERROR;
    xmlChar *key;
    xmlAttrPtr attr;
    tRippedTrackInfo trackInfo;
    xmlChar defaultvalue[10] = "Unknown";
    tMetadata MetadataField_artist = "Unknown";
    tMetadata MetadataField_genre = "Unknown";
    tMetadata MetadataField_Yomiartist = "Unknown";
    memset(OUT trackInfo.YomiAlbum, 0, IN sizeof(tMetadata));

    // search for "name" attribute in the "album" node
    attr = xmlHasProp(cur, (const xmlChar*)"name");

    // if attr is not found then set it to  default
    if(attr == NULL){
        //set default value
        key = defaultvalue;
        res = MP_XML_PARSE_ERR;
    }
    else{
        /* Attribute is available
         * Just retrieve the value and display it
         */
        key = xmlGetProp(cur, (const xmlChar*)"name");
        strncpy_r(OUT trackInfo.MetadataField4, IN (char*)key, IN sizeof(tMetadata));
        ETG_TRACE_USR4(("CDRipperControl::parseAlbumMetadataInfo --name: %s\n", key));
        xmlFree(key);
    }
    // search for "year" attribute in the "album" node
    attr = xmlHasProp(cur, (const xmlChar*)"year");

    // if attr is not found then set it to  default
    if(attr == NULL){

        //set default value
        trackInfo.Year = 0;
    }
    else{
        /* Attribute is available
         * Just retrieve the value and display it
         */
        key = xmlGetProp(cur, (const xmlChar*)"year");
        trackInfo.Year = atoi((char*)key);
        ETG_TRACE_USR4(("CDRipperControl::parseAlbumMetadataInfo -- year: %s\n", key));
        xmlFree(key);
    }
    // search for "artist" attribute in the "album" node
    attr = xmlHasProp(cur, (const xmlChar*)"artist");

    // if attr is not found then set it to  default
    if(attr != NULL){

        /* Attribute is available
         * Just retrieve the value and display it
         */
        key = xmlGetProp(cur, (const xmlChar*)"artist");
        if(key != NULL)
        {
            ETG_TRACE_USR4(("CDRipperControl::parseAlbumMetadataInfo -- artist: %s\n", key));
            strncpy_r(OUT MetadataField_artist, IN (char*)key, IN sizeof(tMetadata));
            xmlFree(key);
        }
    }

    // search for "yomiartist" attribute in the "album" node
    attr = xmlHasProp(cur, (const xmlChar*)"yomiartist");

    // if attr is not found then set it to  default
    if(attr != NULL){

        /* Attribute is available
         * Just retrieve the value and display it
         */
        key = xmlGetProp(cur, (const xmlChar*)"yomiartist");
        if(key != NULL)
        {
            ETG_TRACE_USR4(("CDRipperControl::parseAlbumMetadataInfo -- YomiArtist: %s\n", key));
            strncpy_r(OUT MetadataField_Yomiartist, IN (char*)key, IN sizeof(tMetadata));
            xmlFree(key);
        }
    }

    // search for "yomititle" attribute in the "album" node
    attr = xmlHasProp(cur, (const xmlChar*)"yomititle");

    strncpy_r(OUT trackInfo.YomiAlbum,"Unknown",sizeof(tMetadata));
    // if attr is not found then set it to  default
    if(attr != NULL){

        /* Attribute is available
         * Just retrieve the value and display it
         */
        key = xmlGetProp(cur, (const xmlChar*)"yomititle");
        if(key != NULL)
        {
            ETG_TRACE_USR4(("CDRipperControl::parseAlbumMetadataInfo -- YomiAlbum: %s\n", key));
            strncpy_r(OUT trackInfo.YomiAlbum, IN (char*)key, IN sizeof(tMetadata));
            xmlFree(key);
        }
    }

    // search for "genre" attribute in the "album" node
    attr = xmlHasProp(cur, (const xmlChar*)"genre");

    // if attr is not found then set it to  default
    if(attr != NULL)
    {
        /* Attribute is available
         * Just retrieve the value and display it
         */
        key = xmlGetProp(cur, (const xmlChar*)"genre");
        if(key != NULL)
        {
            ETG_TRACE_USR4(("CDRipperControl::parseAlbumMetadataInfo -- genre: %s\n", key));
            strncpy_r(OUT MetadataField_genre, IN (char*)key, IN sizeof(tMetadata));
            xmlFree(key);
        }
    }
    // Get the childern Element Node of "MetadataInfo" node
    cur = cur->xmlChildrenNode;

    while (cur != NULL) {

        memset(OUT trackInfo.title, 0, IN sizeof(tMetadata));
        memset(OUT trackInfo.MetadataField1, 0, IN sizeof(tMetadata));
        memset(OUT trackInfo.MetadataField2, 0, IN sizeof(tMetadata));
        memset(OUT trackInfo.YomiTitle, 0, IN sizeof(tMetadata));
        memset(OUT trackInfo.YomiArtist, 0, IN sizeof(tMetadata));

        strncpy_r(OUT trackInfo.YomiTitle,"Unknown",sizeof(tMetadata)); // YomiTitle will be assigned default value "Unknown"
        strncpy_r(OUT trackInfo.YomiArtist, IN MetadataField_Yomiartist, IN sizeof(tMetadata));// Track YomiArtist will be assigned default value - yomiartist of the album node
        strncpy_r(OUT trackInfo.MetadataField2, IN MetadataField_artist, IN sizeof(tMetadata));// Track artist will be assigned default value - artist of album node
        strncpy_r(OUT trackInfo.MetadataField1, IN MetadataField_genre, IN sizeof(tMetadata));// Track Genre will be assigned default value - genre of album node
        // check for "trackInfo" childern element node of "album" node
        if ((!xmlStrcmp(cur->name, (const xmlChar *)"trackInfo")))
        {


            // search for "title" attribute in the "trackInfo" node
            attr = xmlHasProp(cur, (const xmlChar*)"title");

            // if attr is not found then set it to  default
            if(attr == NULL){
                //set default value
                key = defaultvalue;
                strncpy_r(OUT trackInfo.title, IN (char*)key, IN sizeof(tMetadata));
            }
            else{
                /* Attribute is available
                 * Just retrieve the value and display it
                 */
                key = xmlGetProp(cur, (const xmlChar*)"title");
                ETG_TRACE_USR4(("CDRipperControl::parseAlbumMetadataInfo --title: %s\n", key));
                strncpy_r(OUT trackInfo.title, IN (char*)key, IN sizeof(tMetadata));
                xmlFree(key);
            }
            // search for "artist" attribute in the "album" node
            attr = xmlHasProp(cur, (const xmlChar*)"artist");

            // if attr is not found then set it to  default
            if(attr != NULL){

                /* Attribute is available
                 * Just retrieve the value and display it
                 */
                key = xmlGetProp(cur, (const xmlChar*)"artist");
                if(key != NULL)
                {
                    ETG_TRACE_USR4(("CDRipperControl::parseAlbumMetadataInfo -- artist: %s\n", key));
                    strncpy_r(OUT trackInfo.MetadataField2, IN (char*)key, IN sizeof(tMetadata));
                    xmlFree(key);
                }
            }

            // search for "genre" attribute in the "album" node
            attr = xmlHasProp(cur, (const xmlChar*)"genre");

            // if attr is not found then set it to  default
            if(attr != NULL)
            {
                /* Attribute is available
                 * Just retrieve the value and display it
                 */
                key = xmlGetProp(cur, (const xmlChar*)"genre");
                if(key != NULL)
                {
                    ETG_TRACE_USR4(("CDRipperControl::parseAlbumMetadataInfo -- genre: %s\n", key));
                    strncpy_r(OUT trackInfo.MetadataField1, IN (char*)key, IN sizeof(tMetadata));
                    xmlFree(key);
                }
            }
            if(LocalSPM::GetDataProvider().YomiMetadataSupport())
            {

                // search for "yomititle" attribute in the "album" node
                attr = xmlHasProp(cur, (const xmlChar*)"yomititle");

                // if attr is not found then set it to  default
                if(attr != NULL)
                {
                    /* Attribute is available
                     * Just retrieve the value and display it
                     */
                    key = xmlGetProp(cur, (const xmlChar*)"yomititle");
                    if(key != NULL)
                    {
                        ETG_TRACE_USR4(("CDRipperControl::parseAlbumMetadataInfo -- yomititle: %s\n", key));
                        strncpy_r(OUT trackInfo.YomiTitle, IN (char*)key, IN sizeof(tMetadata));
                        xmlFree(key);
                    }
                }

                // search for "YomiArtist" attribute in the "album" node
                attr = xmlHasProp(cur, (const xmlChar*)"yomiartist");

                // if attr is not found then set it to  default
                if(attr != NULL)
                {
                    /* Attribute is available
                     * Just retrieve the value and display it
                     */
                    key = xmlGetProp(cur, (const xmlChar*)"yomiartist");
                    if(key != NULL)
                    {
                        ETG_TRACE_USR4(("CDRipperControl::parseAlbumMetadataInfo -- YomiArtist: %s\n", key));
                        strncpy_r(OUT trackInfo.YomiArtist, IN (char*)key, IN sizeof(tMetadata));
                        xmlFree(key);
                    }
                }

            }//(LocalSPM::GetDataProvider().YomiMetadataSupport())

            // search for "index" attribute in the "trackInfo" node
            attr = xmlHasProp(cur, (const xmlChar*)"index");
            unsigned int trackIndex = 0;
            // if attr is not found then set it to  default
            if(attr == NULL){
                res = MP_XML_PARSE_ERR;
            }
            else{
                /* Attribute is available
                 * Just retrieve the value and display it
                 */
                key = xmlGetProp(cur, (const xmlChar*)"index");
                ETG_TRACE_USR4(("CDRipperControl::parseAlbumMetadataInfo -- index: %s\n", key));
                trackIndex = atoi((char*)key);
                xmlFree(key);
            }

            if(res != MP_XML_PARSE_ERR)
            {
                // Add to map
                ETG_TRACE_USR4(("CDRipperControl::parseAlbumMetadataInfo -- Inserted in Map For index: %s\n", key));
                m_mapMetadataInfo.insert( std::pair<unsigned int ,tRippedTrackInfo>(trackIndex,trackInfo));

            }
            else
            {
                break;
            }
        } // end of IF loop " trackInfo"

        cur = cur->next;
    } // end of While loop

    return res;

} // end of parse function()

tResult CDRipperControl::GetGracenoteVersion(tGracenoteVersion GracenoteVersion)
{
    ENTRY
    if(m_e8GracenoteInitialized != GRACENOTE_INIT_OK )
    {
        GracenoteProxy::GetInstance().GetGracenoteVersion(m_gracenoteVersion);
    }
    strncpy_r(GracenoteVersion,m_gracenoteVersion,sizeof(tGracenoteVersion));
    VARTRACE(m_gracenoteVersion);
    return MP_NO_ERROR;
}

tResult CDRipperControl::SetGracenoteDBLookupMode(tGracenoteLookupMode lookupMode)
{
    ENTRY;
    //ipc client fetch album info for TOC
    GracenoteProxy::GetInstance().SetGracenoteDatabseLookUpMode(lookupMode);
    VARTRACE(lookupMode);
    LocalSPM::GetOutputWrapper().UpdateGracenoteLookupMode();
    return MP_NO_ERROR;
}

tGracenoteLookupMode CDRipperControl::GetGracenoteDBLookupMode()
{
    ENTRY;
    tGracenoteLookupMode lookupMode = GRACENOTE_ONLINE;
    GracenoteProxy::GetInstance().GetGracenoteDatabseLookUpMode(lookupMode);
    VARTRACE(lookupMode);
    return lookupMode;
}

int CDRipperControl::AlbumArtFetchedGN(const tAlbumArtDownload status,const tGNAlbumArtFilename gnAlbumArtString, const tGNAlbumArtFilesize fileSize)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;
    std::string albumArtString;
    std::string completeFileName;
    VARTRACE(status);
    VARTRACE(gnAlbumArtString);
    VARTRACE((int)fileSize);
    FastUTF8::tString folderPath;
    FastUTF8::tString fileName;
    if(GNdataReqType == CDDB_ONDEMAND)
    {
        strncpy_r(OUT m_CDTOCData.HashID, IN mUUIDforGNalbum, IN sizeof(tTOC));
    }
    if(gnAlbumArtString != NULL)
    {
        /*split image filename from folderpath*/
        folderPath = (FastUTF8::tString)strdup(gnAlbumArtString);
        FastUTF8::Split(OUT fileName, INOUT folderPath); //Split full name into filename and path
        VARTRACE(fileName);
        albumArtString.clear();
        /*generate albumartpath from hashid and albumart filename(ex: xxx/yyy.jpg)*/
        albumArtString += m_CDTOCData.HashID;
        albumArtString += "/";
        albumArtString += (char*)fileName;
        /*Add mount point to Generate complete albumart filename (ex: /var/opt/bosch/musicbox/xxx/yyy.jpg)*/
        completeFileName = LocalSPM::GetDataProvider().RippedFilePath().c_str() + albumArtString;
        //albumArtString += ".jpg";
        VARTRACE(completeFileName.c_str());
        if (status == GRACENOTE_ALBUM_ART_SUCCESS)
        {
            FILE *fpImage;
            fpImage = fopen(gnAlbumArtString, "rb");
            if (fpImage)
            {
                tImageData imageData= (tImageData)malloc(fileSize);
                if (!imageData)
                {
                    fclose(fpImage);
                    if(folderPath)
                    {
                        free(folderPath);
                        folderPath = NULL;
                    }
                    return -1;
                }
                /*Read image data from /tmp/yyy.jpg and write in /var/opt/bosch/musicbox/xxx/yyy.jpg*/
                size_t bytes_read;
                if ((bytes_read = fread(imageData, sizeof(char),fileSize,fpImage)))
                {
                    /*write the image data under musicbox albumid folder*/
                    FILE *handle = fopen(completeFileName.c_str(), "wb+");
                    if (handle)
                    {
                        if(fwrite(imageData, sizeof(char),fileSize,handle))
                        {
                            ETG_TRACE_USR4(("CDRipperControl::AlbumArtFetchedGN: successfully written image data to file %s\n",completeFileName.c_str()));
                        }
                        else
                        {
                            ret = MP_ERR_GN_ALBUMART_FAILURE;
                            ETG_TRACE_ERR(("CDRipperControl::AlbumArtFetchedGN: Failed to write image data to file %s\n",completeFileName.c_str()));
                        }
                        fclose(handle);
                    }
                    else
                    {
                        ret = MP_ERR_GN_ALBUMART_FAILURE;
                        ETG_TRACE_ERR(("CDRipperControl::AlbumArtFetchedGN: Failed to open file %s for writing image data\n",completeFileName.c_str()));
                    }
                }
                else
                {
                    ret = MP_ERR_GN_ALBUMART_FAILURE;
                    ETG_TRACE_ERR(("CDRipperControl::AlbumArtFetchedGN: Failed to read image data from file %s\n",gnAlbumArtString));
                }
                if(imageData)
                {
                    free(imageData);
                }
                fclose(fpImage);

                if(folderPath)
                {
                    free(folderPath);
                    folderPath = NULL;
                }

                if(ret == MP_NO_ERROR)
                {
                    if(GNdataReqType == CDDB_ONDEMAND)
                    {
                        DeleteAlbumArtImage(mUUIDforGNalbum,albumArtString);
                    }
                    ret = LocalSPM::GetDBManager().UpdateAlbumArtStringForTocHash(MUSICBOX_DEVICE_ID, (char *)albumArtString.c_str(), m_CDTOCData.HashID);
                }
                else
                {
                    ETG_TRACE_ERR(("CDRipperControl::AlbumArtFetchedGN: Failed to update AlbumArt string in db (ErrorCode:%d)", ret));
                }
            }
            else
            {
                ret = MP_ERR_GN_ALBUMART_FAILURE;
                ETG_TRACE_ERR(("CDRipperControl::AlbumArtFetchedGN: Failed to open file %s for reading image data\n",gnAlbumArtString));
            }
        }
        if(folderPath)
        {
            free(folderPath);
            folderPath = NULL;
        }
    }
    else        //No album Art for the particular album
    {
        if(GNdataReqType == CDDB_ONDEMAND) // multiple album user selection
        {
            DeleteAlbumArtImage(mUUIDforGNalbum,albumArtString);
        }
        albumArtString.clear();
        ret = LocalSPM::GetDBManager().UpdateAlbumArtStringForTocHash(MUSICBOX_DEVICE_ID, (char *)albumArtString.c_str(), m_CDTOCData.HashID);
        if(!ret)
        {
            ETG_TRACE_ERR(("Database Error"));
        }
        ETG_TRACE_ERR(("CDRipperControl::AlbumArtFetchedGN: No Album Art"));
    }
    return 0;
}


tResult CDRipperControl::DeleteAlbumArtImage(tTOC HashID,std::string &newAlbumArtStr)
{
    ENTRY;
    tResult ret = MP_NO_ERROR;
    std::string albumArtStringfromDB;
    std::string completeFileNametoRemove;

    ret = LocalSPM::GetDBManager().GetAlbumArtStringForTocHash(HashID,albumArtStringfromDB);
    if((!ret) && (albumArtStringfromDB.length() > 0))
    {
        if(newAlbumArtStr != albumArtStringfromDB)
        {
            completeFileNametoRemove = LocalSPM::GetDataProvider().RippedFilePath().c_str() +albumArtStringfromDB;
            ret = remove(completeFileNametoRemove.c_str());

            if(!ret)
            {
                ETG_TRACE_ERR(("CDRipperControl::AlbumArtFetchedGN: Failed to remove file %s \n",albumArtStringfromDB.c_str()));
            }
        }
        else
        {
            ETG_TRACE_USR4(("AlbumArtString is same, no need to remove"));

        }
    }
    return ret;
}

bool CDRipperControl::CheckMusicBoxFileAvailability( char* rootDir )
{

    ENTRY ;
    bool bFileAvailable = false;
    DIR *dir;
    struct dirent *entry;
    //  char* rootDir  = LocalSPM::GetDataProvider().RippedFilePath().c_str();
    if (!(dir = opendir(rootDir)))
        return bFileAvailable;

    while ((entry = readdir(dir)) != NULL)
    {
        if (entry->d_type == DT_DIR) {
            char path[1024];
            if (strcmp(entry->d_name, ".") == 0 || strcmp(entry->d_name, "..") == 0)
                continue;
            snprintf(path, sizeof(path), "%s/%s", rootDir, entry->d_name);
            bFileAvailable = CheckMusicBoxFileAvailability(path);
        }
        else
        {
            //check for .mp3 , if true read values and update DB
            std::string filename(entry->d_name);
            std::size_t foundmp3 = filename.find(".mp3");
            std::size_t foundm3u = filename.find(".m3u");
            if((foundmp3!=std::string::npos) ||  (foundm3u!=std::string::npos))
            {
                //METADATA , URL , UID etc to be extracted
                //  File available
                bFileAvailable = true;

            }
        }
        if(bFileAvailable)
        {
            break;
        }
    }
    closedir(dir);
    VARTRACE(bFileAvailable);
    return bFileAvailable;
}

bool CDRipperControl::IsRippedTrackExistsInFlash(unsigned int trackNumber)
{
    ENTRY
    std::vector<tU16>::iterator it;

    it = find (m_trackNumberList.begin(), m_trackNumberList.end(), trackNumber);
    if (it != m_trackNumberList.end())
        return true;
    else
        return false;

}

void CDRipperControl::GetTracksAvailableInFlash()
{

    ENTRY
    m_trackNumberList.clear();
    tResult ret = LocalSPM::GetDBManager().GetTrackNumbersByUUID(m_trackNumberList, MUSICBOX_DEVICE_ID, m_CDTOCData.HashID);
}

tResult CDRipperControl::RequestGNdataforAlbum(const tMetadata albumName)
{
    ENTRY
    tResult ret =  MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    if(IsInState(notStarted) == 1)
    {
        memset(mUUIDforGNalbum,0x00,sizeof(tUUID));
        ret = LocalSPM::GetDBManager().GetUUIDfromAlbumName(IN albumName,OUT mUUIDforGNalbum);
        VARTRACE(ret);
        VARTRACE(mUUIDforGNalbum);
        if(ret == MP_NO_ERROR)
        {
            ret = LocalSPM::GetDBManager().GetMusicBoxToC(IN mUUIDforGNalbum,OUT mToCString);
            VARTRACE(mToCString.c_str());
            if((mToCString.length() > 0) && (ret == MP_NO_ERROR))
            {
                ret = CDRipperControlSM::ParameterFETCHED_GNINFO(OUT parameterString, IN size, IN CDDB_ONDEMAND);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while preparing parameter string (ErrorCode:%s)", errorString(ret)));
                    parameterString[0] = '\0';
                }
                else
                {
                    ret = SendEvent(FETCHED_GNINFO,IN parameterString);
                    if( MP_NO_ERROR != ret )
                    {
                        ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
                    }
                }
            }
            else
            {
                ret = MP_ERR_DB_SELECT_FAILED;
            }
        }
    }
    else
    {
        ret = MP_ERR_RIPPERSM_BUSY;
    }
    if(ret !=MP_NO_ERROR)
    {
        m_gnmetadataExtractionResult = GNMETADATA_NOMATCH_FOUND;
        ret = LocalSPM::GetOutputWrapper().UpdateGNdataforAlbumOnUserDemand();
    }
    return ret;
}
void CDRipperControl::CancelGNFetchIfInProgress()
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    int timecount = 0;
    //Timeout of one second to fetch gracenote data, if GN fetch not done even after a second, exit the state
    while(timecount < GNDATAFETCH_RETRY_COUNT)
    {
        ret = IsInState(FetchGracenoteData);
        VARTRACE(ret);
        if(ret == 1)
        {
            usleep(GNDATAFETCH_TIMEOUT);
            timecount++;
        }
        else
            break;
    }
    if(ret ==1)
    {
        ret = SendEvent(FINISHED_GNFETCHDATA,IN "0");
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF (ErrorCode:%s)", errorString(ret)));
        }
    }

}
