/*
 * BTDaemonProxy.cpp
 *
 *  Created on: Oct 16, 2013
 *      Author: din3kor , Reenuhaa
 */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"
#include "Dispatcher.h"

#define EVENTS_SUPPORTED 1
#define MEDIAPLAYER 1
#define FEATURE_BIT_MASK_EIGTH_BYTE 18
#define BROWSE_SUPPORT_BIT  0x08
#define SIZE_OF_ITEM_TYPE_CUM_LENGTH 3
#define ABSOLUTE_VOLUME_WAIT_TIME_INTERVAL 3000
#define INVALID_VOLUME -1
#define RESET_WAIT 0
#define SET_WAIT 1

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_BT_CONTROL
#ifdef TARGET_BUILD
#include "trcGenProj/Header/BTDaemonProxy.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_BT_CONTROL
#endif
#endif
#include "FunctionTracer.h"
#include "VarTrace.h"

#include <netinet/in.h>
#include <errno.h>

#include "BTDaemonProxy.h"
#include "BTDaemonIpcIF.h"
#include "LocalSPM.h"

//#define MAX_CHAR_COUNT_PARAM_STATUS 1
//#define MAX_CHAR_COUNT_PARAM_SCOPE 1
//#define MAX_CHAR_COUNT_PARAM_NETWORK_ORDER 1
//#define MAX_CHAR_COUNT_PARAM_ARRAY_LENGTH 10
//#define MAX_CHAR_COUNT_PARAM_BYTE_DATA 3
//#define MAX_CHAR_COUNT_PARAM_NUM_ATTR 1

#define EVENT_PLAYBACK_STATUS_CHANGED_ARRAY_LENGTH  1
#define EVENT_ADDRESSED_PLAYER_CHANGED_ARRAY_LENGTH 2
//#define EVENT_TRACK_CHANGED_ARRAY_LENGTH  8
//#define EVENT_PLAYBACK_POS_CHANGED_ARRAY_LENGTH  4
#define EVENT_APPLICATION_SETTING_CHANGED_ARRAY_LENGTH  2
#define ATTRIBUTES_COUNT 4
#define MAX_NUM_OF_ATTRIBUTES 6
#define UIDS_CHANGED_EXPECTED_VALUE 1
const tU16 BT_RESPONSETIMEOUT = 3000;
const tU16 BT_INITRESPONSE_PLAY = 500;
const tU16 BT_INITRESPONSE_NEXT = 1000;
BTDaemonProxy& BTDaemonProxy::GetInstance(void)
{
    static BTDaemonProxy instance;
    return instance;
}

BTDaemonProxy::BTDaemonProxy(void)
{
    setPlaybackState(PE_PBS_LOADINGSTATE);
    mBTActivePlaybackstate = PE_PBS_LOADINGSTATE;
    mLatestPlaybackStateFromDevice = PE_PBS_LOADINGSTATE;
    mStatusBeforeForwardRewind = PE_PBS_UNKNOWN;
    mEventsSupported = 0;
    //mIsPauseSent = false;
    mMessageHandlersMutex.lock();
    mMessageHandlers.clear();
    mMessageHandlersMutex.unlock();

    mSignalHandlers.clear();

    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        mSignalHandlers["AvpNotifySetComplete"] = &BTDaemonProxy::AvpNotifySetCompleteSignal;
        mSignalHandlers["AvpNotifyChg"] = &BTDaemonProxy::AvpNotifyChgSignal;
        mSignalHandlers["AvpPlayStatus"] = &BTDaemonProxy::AvpPlayStatusSignal;
        mSignalHandlers["AvpCtrlCmdInd"] = &BTDaemonProxy::AvpCtrlCmdIndSignal;
    }
    else
    {
        mSignalHandlers["PropertiesChanged"] = &BTDaemonProxy::propertiesChangedSignal;
       // mSignalHandlers["PlayerAdded"] = &BTDaemonProxy::playerAddedSignal;
        mSignalHandlers["TrackChanged"] = &BTDaemonProxy::AvpTrackChangedSignal;
        mSignalHandlers["NowPlayingContent"] = &BTDaemonProxy::NowPlayingContentSignal;
        mSignalHandlers["PlayerRemoved"] = &BTDaemonProxy::AvpPlayerRemovedSignal;
        mSignalHandlers["UIDsChanged"] = &BTDaemonProxy::AvpUIDsChangedSignal;
        mSignalHandlers["AvailablePlayerChange"] = &BTDaemonProxy::AvpAvailablePlayerChangedSignal;
    }

    mSMObserver = DTY_BLUETOOTH;
    mIsBTDeviceControlActive = false;
    mTimerAlreadyRunning = false;
    mold_elapsedPlayTime = 0;
    CleanupNowPlayingMetadata();
    sem_init(&m_GetFolderItemSyncSem, 0, 0);
    sem_init(&m_ChangeFolderSyncSem, 0, 0);
    //Property Interface Names
    mInterfacenames.push_back("org.bluez.MediaPlayer");
    mInterfacenames.push_back("org.bluez.MediaFolder");
    mInterfacenames.push_back("org.bluez.MediaItem");
    mInterfacenames.push_back("org.bluez.MediaTransport");
    mInterfacenames.push_back("org.bluez.evo.AVP");
    mInterfacenames.push_back("org.freedesktop.DBus.Properties");
    mInterfacenames.push_back("com.alps.bt.Audio");
    mInterfacenames.push_back("com.alps.bt.Audiovisual");
    mObjectPathForAbsoluteVolume = "";
    tAbsoluteVolumeSupportVariables absoluteVolumeSupportVariables = SET_ALL_TO_DEFAULT;
    int Volume = INVALID_VOLUME;
    SetAbsoluteVolumeSupportValues(absoluteVolumeSupportVariables,Volume);
    LocalSPM::GetDataProvider().AbsoluteVolumeSupportForBTDevice = 0;
    _oldReason = REASON_OK;
    mGetImageReqInProgress = false;
}

bool BTDaemonProxy::belongs(const char* messageName, const char* params)
{
    //ENTRY
    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        if( (!strcmp(messageName,"AvpNotifySetComplete")) ||
                (!strcmp(messageName,"AvpNotifyChg")) ||
                (!strcmp(messageName,"AvpPlayStatus")) ||
                (!strcmp(messageName,"AvpCtrlCmdInd")))
        {
            return true;
        }
    }
    else
    {
            if( (!strcmp(messageName,"PropertiesChanged")))
                {
            tInterfaceName interfacename;
            LocalSPM::GetIPCProvider().GetInterfaceName(OUT interfacename, IN params);

            if (std::find(mInterfacenames.begin(), mInterfacenames.end(), interfacename) != mInterfacenames.end())
                    {
                ETG_TRACE_USR4(("Property found for BTDaemon"));
                return true;
                    }
                    }
        else if(/*(!strcmp(messageName,"PlayerAdded")) ||*/
                (!strcmp(messageName,"TrackChanged")) ||
                (!strcmp(messageName,"NowPlayingContent")) ||
                (!strcmp(messageName,"UIDsChanged")) ||
                (!strcmp(messageName,"AvailablePlayerChange")) ||
                (!strcmp(messageName,"PlayerRemoved")))
                        {
            return true;
        }
    }
    return false;
}

bool BTDaemonProxy::belongs(tU32 serial)
{
    mMessageHandlersMutex.lock();

    if(mMessageHandlers.empty())
    {
        mMessageHandlersMutex.unlock();
        return false;
    }

    if (mMessageHandlers.find(serial) == mMessageHandlers.end())
    {
        mMessageHandlersMutex.unlock();
        return false;
    }
    else
    {
        mMessageHandlersMutex.unlock();
        return true;
    }
}

void BTDaemonProxy::RouteSignal(const char* name, const char* params)
{
    ENTRY

    ETG_TRACE_USR1(("BTDaemonProxy signal received %128s:%s",name,params));
    if(!IsAppleDevice(mSMObserver))
    {
        if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
        {

            if( (!strcmp(name,"AvpNotifySetComplete")) ||
                    (!strcmp(name,"AvpNotifyChg")) ||
                    (!strcmp(name,"AvpPlayStatus")) ||
                    (!strcmp(name,"AvpCtrlCmdInd")))
            {
                (this->*mSignalHandlers[name])(params);
            }
        }
        else
        {
            if((!strcmp(name,"PropertiesChanged")) ||
                    (!strcmp(name,"PlayerAdded")) ||
                    (!strcmp(name,"TrackChanged")) ||
                    (!strcmp(name,"NowPlayingContent")) ||
                    (!strcmp(name,"UIDsChanged")) ||
                    (!strcmp(name,"AvailablePlayerChange")) ||
                    (!strcmp(name,"PlayerRemoved")))
            {
                (this->*mSignalHandlers[name])(params);
            }
        }
    }
}

void BTDaemonProxy::RouteMethodAnswer(tU32 serial, const char* params)
{
    ENTRY

    mMessageHandlersMutex.lock();
    (this->*mMessageHandlers[serial])(params,false);

    //Erase the Entry giving the Key as it is no more needed
    mMessageHandlers.erase(serial);
    mMessageHandlersMutex.unlock();
}

void BTDaemonProxy::RouteMethodRequest(tU32 serial, const char* name, const char* params)
{
    (void)serial;
    (void)name;
    (void)params;
}

void BTDaemonProxy::RouteError(tU32 serial, const char* error)
{
    ENTRY

    mMessageHandlersMutex.lock();
    (this->*mMessageHandlers[serial])(error,true);

    //Erase the Entry giving the Key as it is no more needed
    mMessageHandlers.erase(serial);
    mMessageHandlersMutex.unlock();
}

tResult BTDaemonProxy::AvpGetMediaPlayerItem(const tNumOfPlayers maxNumber)
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    tInteger serial = 0;
    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        /* Send AvpGetMediaPlayerItem to Alps-bt-daemon via DBUS */
        serial = LocalSPM::GetIPCProvider().MethodCall(ipc_AlpsBTDaemon_AvpGetMediaPlayerItem, IN (unsigned char)maxNumber);
        if(0 > serial)
        {
            ETG_TRACE_ERR(("Error while sending message via DBus"));
            ret = MP_ERR_DBUS;
        }
        else
        {
            mMessageHandlersMutex.lock();
            mMessageHandlers[serial] = &BTDaemonProxy::GetMediaPlayerItemMethodReturn;
            mMessageHandlersMutex.unlock();
        }
    }
    else
    {
        tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
        //Requesting stack for player information if Mediaplayer missed PropertiesChanged signal for AddressedPlayer
        if(mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint) == std::string::npos)
        {
            ret = GetAddressedPlayer();
            if(MP_NO_ERROR != ret)
            {
                GetMediaPlayerItemMethodReturn(NULL,true);
                return ret;
            }
        }

        VARTRACE(LocalSPM::GetDataProvider().EnableBTNowPlayingCoverArt());
        if(LocalSPM::GetDataProvider().EnableBTNowPlayingCoverArt())
        {
           GetCoverArtConStatus();
        }

        SupportAbsoluteVolume();
        if(LocalSPM::GetDataProvider().AbsoluteVolumeSupportFeatureBT() && LocalSPM::GetDataProvider().AbsoluteVolumeSupportForBTDevice())
        {
            GetObjectPathForAbsoluteVolume();
            GetVolumeFromDevice();
        }
        OverrideEvoObjectPaths(mPlayerInfo.objectPath);
        LocalSPM::GetBTControl().SetCurrentPlayer(mPlayerInfo.objectPath);
        setPlaybackState(GetNowPlayingStatus());
        GetMediaPlayerItemMethodReturn(NULL,false);
    }
    return ret;

}
void BTDaemonProxy::GetMediaPlayerItemMethodReturn(const char* params,bool isError)
{
    ENTRY

    //Variable to Send via AVP_GET_MEDIAPLAYERITEM_METHOD_RETURN Event to BTControl Component
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tBTMethodRequestStatus status = REQ_NOT_OK;
    tNetworkOrder networkOrder = FALSE;
    tArrayLength arrayLength = 0;
    tByteArray pData = NULL;

    if(isError)
    {
        ETG_TRACE_ERR(("AvpGetMediaPlayerItem Failed with error %s",params));
    }
    //Pointers for the Null terminated Char array received

    //Variables to Parse and retrieve the variables from the Null terminated Char array received

    //Find the Status of Response
    else
    {
        if(LocalSPM::GetDataProvider().UseEvolutionBtStack())
        {
            status = REQ_OK;
        }
        else if(strlen_r(params))
        {
            ETG_TRACE_USR4(("params:%s",params));
            sscanf(params,"%u,%u,%u,%p",&status,&networkOrder,&arrayLength,&pData);
            ETG_TRACE_USR4(("Status:%d",status));
            //Find the NetworkOrder of Response
            ETG_TRACE_USR4(("NetworkOrder:%d",networkOrder));

            // Find the Array Length
            ETG_TRACE_USR4(("ArrayLength:%d",arrayLength));

            //Allocate Memory for Array of [Byte]Data

            //Find the ArrayLength of Response

            //Retrieving the Array of [Byte]Data from char array received
            ETG_TRACE_USR4(("pData is %p",pData));
            //Decrement the ByteCount
            //Make the pointer ByteArray_Parser to point to the parse and Find the Next byte
        }
        else
        {
            //Do Nothing
        }
    }

    tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_GET_MEDIAPLAYERITEM_METHOD_RETURN(OUT parameterString,IN size,IN status,IN networkOrder,IN pData,IN arrayLength,IN (tErrorMessage)NULL);

    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string"));
    }
    else
    {
        ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_GET_MEDIAPLAYERITEM_METHOD_RETURN", IN parameterString);

        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF"));
        }
    }
}

tResult BTDaemonProxy::AvpGetFolderItem(const tScope scope,const tStartItem startItem,const tEndItem endItem)
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    tInteger serial=0;
    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        const tNumAttributes numOfAttributes = 0xFF;//If this value is set to 0xFF, none of the additional attribute information will be retrieved
        const dbus_uint32_t attr_Array_With_Length[2] = {0,0};

        ETG_TRACE_USR3(("IPCProvider::AvpGetFolderItem Scope:%d, StartItem:%d, EndItem:%d,NumOfAttributes:%d",scope, startItem, endItem, numOfAttributes));

        /* Send AvpGetFolderItem to Alps-bt-daemon via DBUS */
        serial = LocalSPM::GetIPCProvider().MethodCall(ipc_AlpsBTDaemon_AvpGetFolderItem,
                //IN (unsigned char)Scope,
                IN (unsigned char)0x01,
                IN (unsigned int)startItem,
                IN (unsigned int)endItem,
                IN (unsigned char)numOfAttributes,
                IN attr_Array_With_Length);
    }
    else
    {
        map<string,unsigned int> listItemArgs;
        listItemArgs["Start"]=startItem;
        listItemArgs["End"]=endItem;
        if(mPlayerInfo.isBrowsable)
        {
            tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
            if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint) != string::npos))
            {
                serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Evolution_ListItems,listItemArgs);
            }
        }
        else
        {
            ETG_TRACE_USR3(("BTDaemonProxy::AvpGetFolderItem player not browsable , hence list items cannot be requested" ));
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            tBTMethodRequestStatus status = REQ_NOT_OK;
            tScope scope = SCOPE_INVALID;
            tNetworkOrder networkOrder = FALSE;
            tArrayLength arrayLength = 0;
            tByteArray pData = NULL;
            tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_GET_FOLDER_ITEM_METHOD_RETURN(OUT parameterString,IN size,IN status,IN scope,IN networkOrder,IN pData,IN arrayLength,IN (tErrorMessage)NULL);

            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while preparing parameter string"));
            }
            else
            {
                ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_GET_FOLDER_ITEM_METHOD_RETURN", IN parameterString);

                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                }
            }
        }

    }
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }
    else
    {
        mMessageHandlersMutex.lock();
        mMessageHandlers[serial] = &BTDaemonProxy::AvpGetFolderItemMethodReturn;
        mMessageHandlersMutex.unlock();
    }
    return ret;
}

tResult BTDaemonProxy::AvpSetPlayer(const  tPlayerId playerId,const tPlayerMode playerMode)
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    ETG_TRACE_USR3(("PlayerId :%d PlayerMode:%d",playerId,playerMode));
    tInteger serial=0;
    if(LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        ETG_TRACE_USR3(("AvpSetPlayer UseEvolutionBtStack"));
        tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
        if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint) != string::npos) && (false == mPlayerInfo.isSetBrowsedPlayerSuccess))
        {
            serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Evolution_SetBrowsedPlayer);
            mPlayerInfo.isSetBrowsedPlayerSuccess = true;
        }
    }
    else
    {
        /* Send AvpSetPlayer to Alps-bt-daemon via DBUS */
        serial = LocalSPM::GetIPCProvider().MethodCall(ipc_AlpsBTDaemon_AvpSetPlayer,IN (unsigned int)playerId,IN (unsigned char)playerMode);
    }
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }
    else
    {
        mMessageHandlersMutex.lock();
        mMessageHandlers[serial] = &BTDaemonProxy::AvpSetPlayerMethodReturn;
        mMessageHandlersMutex.unlock();
    }
    return ret;
}

tResult BTDaemonProxy::AvpGetNumberOfItemsInCurrentFolder()
{
    ENTRY
    tResult ret = MP_NO_ERROR;


    tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
    if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint) != string::npos))
    {
        int serial = LocalSPM::GetIPCProvider().MethodCall( IN ipc_Evolution_Getall,IPC_EVOLUTION_MEDIAFOLER_INTERFACE);


        if (0 > serial)
        {
            ETG_TRACE_ERR(("Error while sending message via DBus"));
            tAllParameters parameterString="";
            tPath pathToMove = {0};
            size_t size = sizeof(parameterString);
            tBTMethodRequestStatus status = REQ_NOT_OK;
            tNumOfItems numOfItems = 0 ;
            tErrorMessage errorMessage = NULL;
            LocalSPM::GetBTControl().ParameterAVP_CHANGE_PATH_METHOD_RETURN(OUT parameterString,IN size,IN status,IN numOfItems,IN errorMessage,IN pathToMove);
            //Send event to move BTControlSm to idle state.
            ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_CHANGE_PATH_METHOD_RETURN", IN parameterString);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
            }
        }
        else
        {
            mMessageHandlersMutex.lock();
            mMessageHandlers[serial] = &BTDaemonProxy::AvpGetNumberOfItemsInCurrentFolderMethodReturn;
            mMessageHandlersMutex.unlock();
        }
    }
    else
    {
        tAllParameters parameterString="";
        tPath pathToMove = {0};
        size_t size = sizeof(parameterString);
        tBTMethodRequestStatus status = REQ_NOT_SENT_TO_DEVICE;
        tNumOfItems numOfItems = 0 ;
        tErrorMessage errorMessage = NULL;
        LocalSPM::GetBTControl().ParameterAVP_CHANGE_PATH_METHOD_RETURN(OUT parameterString,IN size,IN status,IN numOfItems,IN errorMessage,IN pathToMove);

        //Send event to make BTControlSm to idle state.
        ETG_TRACE_ERR(("AvpGetNumberOfItemsInCurrentFolder else case"));
        ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_CHANGE_PATH_METHOD_RETURN", IN parameterString);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF"));
        }
    }
    return ret;
}
void BTDaemonProxy::AvpGetNumberOfItemsInCurrentFolderMethodReturn(const char* params,bool isError)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tNumOfItems numberOfItems = 0;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tBTMethodRequestStatus status = REQ_NOT_OK;
    if(params!=NULL && !isError)
    {
        std::string strFromChar;
        strFromChar.append(params);
        ETG_TRACE_USR3(("AvpGetNumberOfItemsInCurrentFolderMethodReturn :%s",params));
        std::istringstream ss(strFromChar);
        std::string token1,token2, token3;


        std::getline(ss, token2, IPC_DBUS_PARAM_DELIMITER_CHAR);
        ETG_TRACE_USR3(("AvpGetNumberOfItemsInCurrentFolderMethodReturn token2 :%s",token2.c_str()));
        if(token2.compare("Name") == 0)
        {
            string itemName;
            std::getline(ss, itemName, IPC_DBUS_PARAM_DELIMITER_CHAR);
            std::getline(ss, token3, IPC_DBUS_PARAM_DELIMITER_CHAR);
            ETG_TRACE_USR3(("AvpGetNumberOfItemsInCurrentFolderMethodReturn token3 :%s",token3.c_str()));
            if(token3.compare("NumberOfItems") == 0)
            {
                string strNumberofItems;
                std::getline(ss, strNumberofItems,IPC_DBUS_PARAM_DELIMITER_CHAR);
                sscanf(strNumberofItems.c_str(), "%u", &numberOfItems);
                status = REQ_OK;
                ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_CHANGE_PATH_METHOD_RETURN(OUT parameterString,IN size,IN status,IN numberOfItems,IN (tErrorMessage)NULL, IN itemName.c_str());
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while preparing parameter string"));
                }
                else
                {
                    ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_CHANGE_PATH_METHOD_RETURN", IN parameterString);
                    if( MP_NO_ERROR != ret )
                    {
                        ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                    }
                }
            }
        }

    }
    else
    {
        ETG_TRACE_USR3(("Error while getting Number of Items"));
        ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_CHANGE_PATH_METHOD_RETURN(OUT parameterString,IN size,IN status,IN numberOfItems,IN (tErrorMessage)NULL, IN NULL);
        ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_CHANGE_PATH_METHOD_RETURN", IN parameterString);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF"));
        }
    }
}
tResult BTDaemonProxy::AvpChangePath(const tDirection direction,const tItemUID itemUID,const tBoolean isPlayerChanged,string PlayerName)
{
    ENTRY
    tInteger serial=0;
    tResult ret = MP_NO_ERROR;
    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        unsigned char itemUID_With_Length[9] = {8,0,0,0,0,0,0,0,0};
        if(itemUID)
        {
            memcpy(&itemUID_With_Length[1],itemUID,8);
        }

        ETG_TRACE_USR3(("Direction :%d",direction));
        tUInt itr ;

        for(itr =0;itr<9;itr++)
        {
            ETG_TRACE_USR3(("ItemUID_With_Length[%d] is %d",itr,itemUID_With_Length[itr]));
        }

        /* Send AvpChangePath to Alps-bt-daemon via DBUS */
        serial = LocalSPM::GetIPCProvider().MethodCall( IN ipc_AlpsBTDaemon_AvpChangePath,
                IN (unsigned char)direction,
                IN itemUID_With_Length);
    }
    else
    {
        string objectPath((char*)itemUID);
        ETG_TRACE_USR3(("Object Path for Change Path %s",objectPath.c_str()));
        tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
        if((mPlayerInfo.isBrowsable) && ((objectPath.find(PlayerName) != string::npos)))
        {
            if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (objectPath.find(connectedDeviceInfo.mountPoint) != string::npos))
            {
                serial = LocalSPM::GetIPCProvider().MethodCall(IN ipc_Evolution_ChangeFolder,IN objectPath);
            }
            if(0 > serial)
            {
                ETG_TRACE_ERR(("Error while sending message via DBus"));
                ret = MP_ERR_DBUS;
            }
        }
        else
        {
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            tBTMethodRequestStatus status = REQ_NOT_OK;
            tNumOfItems numOfItems = 0;
            status = REQ_NOT_OK;
            tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_CHANGE_PATH_METHOD_RETURN(OUT parameterString,IN size,IN status,IN numOfItems,IN (tErrorMessage)NULL, IN NULL);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while preparing parameter string"));
            }
            else
            {
                ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_CHANGE_PATH_METHOD_RETURN", IN parameterString);

                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                }
            }
            return ret;
        }
    }

    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }
    else
    {
        if(isPlayerChanged)
        {
            mMessageHandlersMutex.lock();
            mMessageHandlers[serial] = &BTDaemonProxy::AvpChangePathToRootMethodReturn;
            mMessageHandlersMutex.unlock();
        }
        else
        {
            mMessageHandlersMutex.lock();
            mMessageHandlers[serial] = &BTDaemonProxy::AvpChangePathMethodReturn;
            mMessageHandlersMutex.unlock();
        }
    }
    return ret;
}

tResult BTDaemonProxy::StartAudioPipe(const tMountPoint mountPoint)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        unsigned char deviceAddress_With_Length[7] = {6,0,0,0,0,0,0};
        memcpy(&deviceAddress_With_Length[1],mountPoint,6);  //In fusion stack,Device Address will be used instead of mountpoint

        tUInt itr ;
        for(itr =0; itr<7 ; itr++)
        {
            ETG_TRACE_USR3(("DeviceAddress_With_Length[%d] is %d",itr,deviceAddress_With_Length[itr]));
        }

        /* Send StartAudioPipe to Alps-bt-daemon via DBUS */
        tInteger serial = LocalSPM::GetIPCProvider().MethodCall(ipc_AlpsBTDaemon_StartAudioPipe,
                IN deviceAddress_With_Length);

        if(0 > serial)
        {
            ETG_TRACE_ERR(("Error while sending message via DBus"));
            ret = MP_ERR_DBUS;
        }
        else
        {
            mMessageHandlersMutex.lock();
            mMessageHandlers[serial] = &BTDaemonProxy::StartAudioPipeMethodReturn;
            mMessageHandlersMutex.unlock();
        }
    }
    else
    {
        string dbusObjectPath = "/org/bluez/hci1/" + string(mountPoint);

        IpcMessageInfo ipcEvolutionAvpGetall;
        ipcEvolutionAvpGetall.destination = strdup(IPC_EVOLUTION_SERVICE);
        ipcEvolutionAvpGetall.interface_name = strdup(IPC_EVOLUTION_PROPERTY_INTERFACE);
        ipcEvolutionAvpGetall.object_path = strdup(dbusObjectPath.c_str());
        ipcEvolutionAvpGetall.message_name = strdup("GetAll");
        tInteger serial = LocalSPM::GetIPCProvider().MethodCallNoOverride(ipcEvolutionAvpGetall,IPC_EVOLUTION_AVP_INTERFACE);
        if(0 > serial)
        {
            ETG_TRACE_ERR(("Error while sending message via DBus"));
            ret = MP_ERR_DBUS;
        }
        else
        {
            mMessageHandlersMutex.lock();
            mMessageHandlers[serial] = &BTDaemonProxy::StartAudioPipeMethodReturn;
            mMessageHandlersMutex.unlock();
        }
        if(ipcEvolutionAvpGetall.destination != NULL){
            delete ipcEvolutionAvpGetall.destination; }
        if(ipcEvolutionAvpGetall.destination != NULL){
            delete ipcEvolutionAvpGetall.interface_name ;}
        if(ipcEvolutionAvpGetall.destination != NULL){
            delete ipcEvolutionAvpGetall.object_path ;}
        if(ipcEvolutionAvpGetall.destination != NULL){
            delete ipcEvolutionAvpGetall.message_name;}
    }

    return ret;
}

tResult BTDaemonProxy::AvpCtrlCmd(const tBTControlCmd command,const tBTButtonEvent buttonAction)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tDeviceInfo connectedDeviceInfo;
    InitDeviceInfo(OUT connectedDeviceInfo);
    tInteger serial = 0;

    if (!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {

        /* Send AvpCtrlCmd to Alps-bt-daemon via DBUS */
        serial = LocalSPM::GetIPCProvider().MethodCall(ipc_AlpsBTDaemon_AvpCtrlCmd, IN (unsigned char) command,
                IN (unsigned char)buttonAction);
    }
    else
    {
        connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
        if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint) != string::npos))
        {
            //In case of any action send OK to HMI streaming process NCG3D-83950
            SendNoResponseMsg(REASON_OK);
            switch (command)
            {
                case BT_CMD_PLAY:
                    ETG_TRACE_USR1(("BT CMD: PLAY"));
                    if(getPlaybackState() != PE_PBS_PLAYINGSTATE)
                    {
                        serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Evolution_MediaPlay);
                    }
                    else
                    {
                        //BTControlSM should be moved to idle state if play is not sent
                        tAllParameters parameterString;
                        size_t size = sizeof(parameterString);
                        tPEPlaybackState PlaybackState = LocalSPM::GetInstance().GetBTControl().GetCurrentPlaybackState();
                        LocalSPM::GetInstance().GetBTControl().ParameterPLAYBACK_ACTION_ANSWER(OUT parameterString, IN size, IN (tPEHandle)0, IN PlaybackState, IN (me::reason_e)0, IN (me::speed_e)0);
                        LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "PLAYBACK_ACTION_ANSWER", IN parameterString);
                    }
                    break;
                case BT_CMD_STOP:
                    ETG_TRACE_USR1(("BT CMD: STOP"));
                    serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Evolution_MediaStop);
                    stopTimer();
                    break;
                case BT_CMD_PAUSE:
                    ETG_TRACE_USR1(("BT CMD: PAUSE"));
                    if(getPlaybackState() != PE_PBS_PAUSEDSTATE)
                    {
                        serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Evolution_MediaPause);
                    }
                    else
                    {
                        //BTControlSM should be moved to idle state if pause is not sent
                        tAllParameters parameterString;
                        size_t size = sizeof(parameterString);
                        tPEPlaybackState PlaybackState = LocalSPM::GetInstance().GetBTControl().GetCurrentPlaybackState();
                        LocalSPM::GetInstance().GetBTControl().ParameterPLAYBACK_ACTION_ANSWER(OUT parameterString, IN size, IN (tPEHandle)0, IN PlaybackState, IN (me::reason_e)0, IN (me::speed_e)0);
                        LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "PLAYBACK_ACTION_ANSWER", IN parameterString);
                    }
                    stopTimer();
                    break;
                case BT_CMD_NEXTTRACK:
                    ETG_TRACE_USR1(("BT CMD: NEXTTRACK"));
                    serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Evolution_MediaNext);
                    break;
                case BT_CMD_PREVTRACK:
                    ETG_TRACE_USR1(("BT CMD: PREVTRACK"));
                    serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Evolution_MediaPrevious);
                    break;
                case BT_CMD_FORWARD:
                    if(BUTTON_PRESS == buttonAction)
                    {
                        mStatusBeforeForwardRewind = getPlaybackState();
                        ETG_TRACE_USR1(("BT CMD: FORWARD"));
                        serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Evolution_MediaFastForward);
                    }
                    else if(BUTTON_RELEASE == buttonAction)
                    {
                        if(PE_PBS_PAUSEDSTATE != mStatusBeforeForwardRewind)
                        {
                            ETG_TRACE_USR1(("BT CMD: PLAY sent for FORWARD_STOP"));
                            serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Evolution_MediaPlay);
                        }
                        else
                        {
                            ETG_TRACE_USR1(("BT CMD: PAUSE sent for FORWARD_STOP"));
                            serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Evolution_MediaPause);
                        }
                        mStatusBeforeForwardRewind = PE_PBS_UNKNOWN;
                    }
                    break;
                case BT_CMD_REWIND:
                    if(BUTTON_PRESS == buttonAction)
                    {
                        mStatusBeforeForwardRewind = mPlaybackState;
                        ETG_TRACE_USR1(("BT CMD: REWIND"));
                        serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Evolution_MediaRewind);
                    }
                    else if(BUTTON_RELEASE == buttonAction)
                    {
                        if(PE_PBS_PAUSEDSTATE != mStatusBeforeForwardRewind)
                        {
                            ETG_TRACE_USR1(("BT CMD: PLAY sent for REWIND_STOP"));
                            serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Evolution_MediaPlay);
                        }
                        else
                        {
                            ETG_TRACE_USR1(("BT CMD: PAUSE sent for REWIND_STOP"));
                            serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Evolution_MediaPause);
                        }
                        mStatusBeforeForwardRewind = PE_PBS_UNKNOWN;
                    }
                    break;
                default:
                    ETG_TRACE_USR1(("Invalid command!!"));
                    break;
            }
        }
        else
        {
            //BTControlSM should be moved to idle state when the BT CMD is not sent
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            tPEPlaybackState PlaybackState = LocalSPM::GetInstance().GetBTControl().GetCurrentPlaybackState();
            LocalSPM::GetInstance().GetBTControl().ParameterPLAYBACK_ACTION_ANSWER(OUT parameterString, IN size, IN (tPEHandle)0, IN PlaybackState, IN (me::reason_e)0, IN (me::speed_e)0);
            LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "PLAYBACK_ACTION_ANSWER", IN parameterString);
            ret = MP_ERR_ACTION_ERROR;
        }
    }
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }
    else
    {
        mMessageHandlersMutex.lock();
        mMessageHandlers[serial] = &BTDaemonProxy::AvpCtrlCmdMethodReturn;
        mMessageHandlersMutex.unlock();
    }

    if(LocalSPM::GetDataProvider().AVRCPLowerProfileSupported())
    {
        connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
    }
    if(BT_CMD_PLAY == command && (string(connectedDeviceInfo.deviceVersion)) != "1.0")
    {
        RequestMetadata();
    }
    else
    {
    }
    return ret;
}

tResult BTDaemonProxy::RequestMetadata(void)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        //Parameters to Invoke AvpGetMetadataAttr
        tScope scope = NOW_PLAYING;
        tItemUID itemUID = new unsigned char[SIZE_OF_ITEM_UID];
        tAttributeArray attributeArray = new unsigned int[SIZE_OF_ATTRIBUTE_ARRAY-3];
        if(itemUID && attributeArray)
        {
            //Item UID
            itemUID[0] = 0;
            itemUID[1] = 0;
            itemUID[2] = 0;
            itemUID[3] = 0;
            itemUID[4] = 0;
            itemUID[5] = 0;
            itemUID[6] = 0;
            itemUID[7] = 0;

            //AttributeArray
            attributeArray[0]= BT_ATTRIBUTE_GENRE;        //genre
            attributeArray[1]= BT_ATTRIBUTE_ARTIST;        //artist
            attributeArray[2]= BT_ATTRIBUTE_TITLE;        //title
            attributeArray[3]= BT_ATTRIBUTE_ALBUM;        //album

            ret = AvpGetMetadataAttr(scope,itemUID,attributeArray);

            delete[] itemUID;
            delete[] attributeArray;
        }
    }
    else
    {
        tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();

        if((DEVICE_ID_NOT_SET != connectedDeviceInfo.deviceID) && (mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint) != string::npos) && (mPlayerInfo.objectPath.find("/dev_")  !=  string::npos) && (connectedDeviceInfo.connected))
        {
            tInteger serial  = LocalSPM::GetIPCProvider().MethodCall(ipc_Evolution_Get, IN IPC_EVOLUTION_INTERFACE,IN (char *)"Track");

            if (0 > serial)
            {
                ETG_TRACE_ERR(("RequestMetadata: Error while sending message via DBus"));
                ret = MP_ERR_DBUS;
            }
            else
            {
                ETG_TRACE_USR3(("RequestMetadata: sending message via DBus success"));
                mMessageHandlersMutex.lock();
                mMessageHandlers[serial] = &BTDaemonProxy::RequestMetadataMethodReturn;
                mMessageHandlersMutex.unlock();
            }
        }
    }
    return ret;
}

tResult BTDaemonProxy::StopAudioPipe()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Send StartAudioPipe to Alps-bt-daemon via DBUS */
    tInteger serial = LocalSPM::GetIPCProvider().MethodCall(ipc_AlpsBTDaemon_StopAudioPipe);

    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }
    else
    {
        mMessageHandlersMutex.lock();
        mMessageHandlers[serial] = &BTDaemonProxy::StopAudioPipeMethodReturn;
        mMessageHandlersMutex.unlock();
    }
    return ret;
}

tResult BTDaemonProxy::AvpGetCapabilities(const tCapabilityId capabilityId)
{

    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Send AvpGetCapabilities to Alps-bt-daemon via DBUS */
    tInteger serial = LocalSPM::GetIPCProvider().MethodCall(ipc_AlpsBTDaemon_AvpGetCapabilities,
            IN (unsigned char)capabilityId);
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }
    else
    {
        mMessageHandlersMutex.lock();
        mMessageHandlers[serial] = &BTDaemonProxy::AvpGetCapabilitiesMethodReturn;
        mMessageHandlersMutex.unlock();
    }

    return ret;
}

tResult BTDaemonProxy::AvpConfigNotify(const tEventsSupported eventId)
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Send AvpGetCapabilities to Alps-bt-daemon via DBUS */
    tInteger serial = LocalSPM::GetIPCProvider().MethodCall(ipc_AlpsBTDaemon_AvpConfigNotify,
            IN (unsigned int)eventId);
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }
    return ret;
}

tResult BTDaemonProxy::AvpSetPlaybackModeVal(const tBTPlayerSettingAttributeMode mode,const tBTShuffleMode value)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tInteger serial = 0;

    if(! LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        /* Send AvpSetVal to Alps-bt-daemon via DBUS */
        serial = LocalSPM::GetIPCProvider().MethodCall(ipc_AlpsBTDaemon_AvpSetVal,
                IN (unsigned char)mode,
                IN (unsigned char)value);
    }
    else
    {
        char playBackMode[16]={0};
        switch(value)
        {
            case ALPS_SHUFFLE_OFF:
                strncpy(playBackMode,"Off",sizeof(playBackMode));
                break;
            case ALPS_SHUFFLE_ALL:
                strncpy(playBackMode,"Alltracks",sizeof(playBackMode));
                break;
            default:
                strncpy(playBackMode,"Off",sizeof(playBackMode));
                break;
        }
        list<string> repeatParamValues;
        repeatParamValues.push_back(string((char*)IPC_EVOLUTION_INTERFACE));
        repeatParamValues.push_back(string((char*)"Shuffle"));
        repeatParamValues.push_back(string(playBackMode));
        tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
        if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint) != string::npos))
        {
            serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Evolution_Set,repeatParamValues);
        }
    }
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }
    else
    {
        mMessageHandlersMutex.lock();
        mMessageHandlers[serial] = &BTDaemonProxy::AvpSetPlaybackModeValMethodReturn;
        mMessageHandlersMutex.unlock();
    }
    return ret;
}

tResult BTDaemonProxy::AvpSetRepeatModeVal(const tBTPlayerSettingAttributeMode mode,const tBTRepeatMode value)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tInteger serial=0;

    if(! LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        /* Send AvpSetVal to Alps-bt-daemon via DBUS */
        serial = LocalSPM::GetIPCProvider().MethodCall(ipc_AlpsBTDaemon_AvpSetVal,
                IN (unsigned char)mode,
                IN (unsigned char)value);
    }
    else
    {
        char repeatMode[16]={0};
        switch(value)
        {
            case ALPS_REPEAT_OFF:
                strncpy(repeatMode,"Off",sizeof(repeatMode));
                break;
            case ALPS_REPEAT_SINGLE:
                strncpy(repeatMode,"Singletrack",sizeof(repeatMode));
                break;
            case ALPS_REPEAT_ALL:
                strncpy(repeatMode,"Alltracks",sizeof(repeatMode));
                break;
            default:
                strncpy(repeatMode,"Off",sizeof(repeatMode));
                break;
        }
        list<string> repeatParamValues;
        repeatParamValues.push_back(string((char*)IPC_EVOLUTION_INTERFACE));
        repeatParamValues.push_back(string((char*)"Repeat"));
        repeatParamValues.push_back(string(repeatMode));
        tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
        if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint) != string::npos))
        {
            serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Evolution_Set,repeatParamValues);
        }
    }
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }
    else
    {
        mMessageHandlersMutex.lock();
        mMessageHandlers[serial] = &BTDaemonProxy::AvpSetRepeatModeValMethodReturn;
        mMessageHandlersMutex.unlock();
    }
    return ret;
}

tResult BTDaemonProxy::AvpGetMetadataAttr(tScope scope,tItemUID &itemUID,tAttributeArray &attributeArray)
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    /* Save pointer to observer */
    int iter_1,iter_2= 1,iter_3=1;
    unsigned char itemUID_With_Length[9] ={8,0,0,0,0,0,0,0,0};
    unsigned int attr_array_With_Length[5] = {4,0,0,0,0};

    for(iter_1 = 0;iter_1< 8;iter_1++)
    {
        itemUID_With_Length[iter_2] = itemUID[iter_1];
        iter_2++;
    }

    for(iter_1 = 0;iter_1< 4;iter_1++)
    {
        attr_array_With_Length[iter_3] = attributeArray[iter_1];
        iter_3++;
    }

    /* Send AvpCtrlCmd to Alps-bt-daemon via DBUS */
    tInteger serial = LocalSPM::GetIPCProvider().MethodCall(ipc_AlpsBTDaemon_AvpGetMetadataAttr,
            IN (unsigned char)scope,
            IN itemUID_With_Length,
            IN attr_array_With_Length);
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }
    else
    {
        mMessageHandlersMutex.lock();
        mMessageHandlers[serial] = &BTDaemonProxy::AvpGetMetadataAttrMethodReturn;
        mMessageHandlersMutex.unlock();
    }
    return ret;
}

tResult BTDaemonProxy::AvpListAttr()
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tInteger serial = 0;
    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        /* Send AvpSetVal to Alps-bt-daemon via DBUS */
        serial = LocalSPM::GetIPCProvider().MethodCall(ipc_AlpsBTDaemon_AvpListAttr);
    }
    else
    {
        tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
        if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint) != string::npos))
        {
            string dbusObjectPath;
            dbusObjectPath = IPC_EVOLUTION_INTERFACE;
            serial = LocalSPM::GetIPCProvider().MethodCall( IN ipc_Evolution_Getall, dbusObjectPath.c_str());
        }
    }
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }
    else
    {
        mMessageHandlersMutex.lock();
        mMessageHandlers[serial] = &BTDaemonProxy::AvpListAttrMethodReturn;
        mMessageHandlersMutex.unlock();
    }
    return ret;
}

tResult BTDaemonProxy::AvpListVal(tBTPlayerSettingAttributeMode attributeId)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tInteger serial = 0;

    if(ALPS_ATTR_SHUFFEL == attributeId)
    {
        if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
        {
            /* Send AvpListVal to Alps-bt-daemon via DBUS */
            serial = LocalSPM::GetIPCProvider().MethodCall(ipc_AlpsBTDaemon_AvpListVal,
                    IN (unsigned char)attributeId);
        }
        else
        {
            tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
            if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint) != string::npos))
            {
                serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Evolution_Get,IPC_EVOLUTION_INTERFACE,"Shuffle");
            }
        }
        if(0 > serial)
        {
            ETG_TRACE_ERR(("Error while sending message via DBus"));
            ret = MP_ERR_DBUS;
        }
        else
        {
            mMessageHandlersMutex.lock();
            mMessageHandlers[serial] = &BTDaemonProxy::AvpListShuffleModeValMethodReturn;
            mMessageHandlersMutex.unlock();
        }
    }
    else if(ALPS_ATTR_REPEAT == attributeId)
    {
        if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
        {
            /* Send AvpListVal to Alps-bt-daemon via DBUS */
            serial = LocalSPM::GetIPCProvider().MethodCall(ipc_AlpsBTDaemon_AvpListVal,
                    IN (unsigned char)attributeId);
        }
        else
        {
            tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
            if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint) != string::npos))
            {
            serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Evolution_Get,IPC_EVOLUTION_INTERFACE,"Repeat");
            }
        }
        if(0 > serial)
        {
            ETG_TRACE_ERR(("Error while sending message via DBus"));
            ret = MP_ERR_DBUS;
        }
        else
        {
            mMessageHandlersMutex.lock();
            mMessageHandlers[serial] = &BTDaemonProxy::AvpListRepeatModeValMethodReturn;
            mMessageHandlersMutex.unlock();
        }
    }
    return ret;
}

void BTDaemonProxy::AvpGetFolderItemMethodReturn(const char* params,bool isError)
{
    ENTRY
    //Variable to Send via AVP_GET_FOLDER_ITEM_METHOD_RETURN Event to BTControl Component
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tBTMethodRequestStatus status = REQ_NOT_OK;
    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        tScope scope = SCOPE_INVALID;
        tNetworkOrder networkOrder = FALSE;
        tArrayLength arrayLength = 0;
        tByteArray pData = NULL;

        ETG_TRACE_USR4(("params:%s",params));
        if(isError)
        {
            ETG_TRACE_ERR(("AvpGetFolderItem Failed with error %s",params));
        }
        //Variable used to find the ',' in the Char array received
        //pointer used to parse the Char array received
        //and prepare the argument

        //Making pointer "ByteArray_Parser" to point to the params Received

        //Find the Status of Response
        else
        {
            if(strlen_r(params))
            {
                sscanf(params,"%u,%u,%u,%u,%p",&status,&scope,&networkOrder,&arrayLength,&pData);
                ETG_TRACE_USR4(("status:%d",status));

                //Find the Scope of Response
                ETG_TRACE_USR4(("scope:%d",scope));

                //Find the NetworkOrder of Response
                ETG_TRACE_USR4(("networkOrder:%d",networkOrder));

                // Find the Array Length
                ETG_TRACE_USR4(("arrayLength:%d",arrayLength));

                //Allocate Memory for Array of [Byte]Data

                //Find the ArrayLength of Response

                //Retrieving the Array of [Byte]Data from char array received
                ETG_TRACE_USR4(("pData is %p",pData));

                //Decrement the ByteCount

                //Make the pointer ByteArray_Parser to point to the parse and Find the Next byte

            }
            else
            {
                //do nothing
            }
        }


        tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_GET_FOLDER_ITEM_METHOD_RETURN(OUT parameterString,IN size,IN status,IN scope,IN networkOrder,IN pData,IN arrayLength,IN (tErrorMessage)NULL);

        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string"));
        }
        else
        {
            ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_GET_FOLDER_ITEM_METHOD_RETURN", IN parameterString);

            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
            }
            else
            {
            }
        }
    }
    else
    {
        if(params)
        {
            VARTRACE(params);
        }
        status = REQ_OK;
        tScope scope = SCOPE_INVALID;
        tNetworkOrder networkOrder = FALSE;
        unsigned int paramLength = 0;
        if(params)
        {
            paramLength = strlen_r(params);
        }
        tByteArray pData = (unsigned char*) new char[paramLength];
        if(isError)
        {
            ETG_TRACE_ERR(("AvpGetFolderItem Failed with error %s",params));
            status = REQ_NOT_OK;
            pData = NULL;
        }
        if(pData)
        {
            strncpy_r((char*) pData, params, paramLength);
        }
        tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_GET_FOLDER_ITEM_METHOD_RETURN(
                OUT parameterString, IN size, IN status, IN scope, IN networkOrder, IN pData, IN paramLength,
                IN (tErrorMessage) NULL);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string"));
        }
        else
        {
            ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_GET_FOLDER_ITEM_METHOD_RETURN",
                    IN parameterString);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
            }
        }
        //  delete[] pData;
    }
}
void BTDaemonProxy::AvpSetPlayerMethodReturn(const char* params,bool isError)
{

    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    //Variables to send via AVP_SET_PLAYER_METHOD_RETURN event
    tBTMethodRequestStatus status = REQ_NOT_SUPPORT;
    tNumOfItems numOfItems = 0;
    tDBAware dBAware = 0;

    //Pointer to the null Terminated char array received

    if(isError)
    {
        ETG_TRACE_ERR(("AvpSetPlayer Failed with error %s",params));
    }

    //Find the Status of Response
    else
    {
        if(strlen_r(params))
        {
            sscanf(params,"%u,%u,%u",&status,&numOfItems,&dBAware);

            ETG_TRACE_USR1(("Status is %s",status==REQ_OK?"REQ_OK":"REQ_NOT_OK"));
            ETG_TRACE_USR1(("NumOfItems is %d",numOfItems));
            ETG_TRACE_USR1(("DBAware is %d",dBAware));
        }
        else
        {
            if (LocalSPM::GetDataProvider().UseEvolutionBtStack())
            {
                status = REQ_OK; //Do Nothing
            }
        }
    }

    tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_SET_PLAYER_METHOD_RETURN(OUT parameterString,IN size,IN status,IN numOfItems,IN dBAware,IN (tErrorMessage)NULL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string"));
    }
    else
    {
        ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_SET_PLAYER_METHOD_RETURN", IN parameterString);

        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF"));
        }
        else
        {
        }
    }
}

void BTDaemonProxy::ChangeFolderMethodReturn(const char* params,bool isError)
{
    ENTRY
    string dbusObjectPath;
    dbusObjectPath = IPC_EVOLUTION_MEDIAFOLER_INTERFACE;

    tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
    if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint) != string::npos))
    {
        int serial = LocalSPM::GetIPCProvider().MethodCall( IN ipc_Evolution_Getall, dbusObjectPath.c_str());

        if (0 > serial)
        {
            ETG_TRACE_ERR(("Error while sending message via DBus"));
        }
        else
        {
            mMessageHandlersMutex.lock();
            mMessageHandlers[serial] = &BTDaemonProxy::AvpChangePathMethodReturn;
            mMessageHandlersMutex.unlock();
        }
    }
}
void BTDaemonProxy::AvpChangePathMethodReturn(const char* params,bool isError)
{
    if (!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        //Input arguments for AvpChangePathMethodReturn
        tBTMethodRequestStatus status = REQ_NOT_OK;
        tNumOfItems numOfItems = 0;

        if(isError)
        {
            ETG_TRACE_ERR(("AvpChangePath Failed with error %s",params));
        }
        else
        {
            if(strlen_r(params))
            {
                //Find the Status of Response
                sscanf(params,"%u,%u",&status,&numOfItems);
                //Find the NumOfItem
            }
            else
            {
                //Do Nothing
            }
        }

        tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_CHANGE_PATH_METHOD_RETURN(OUT parameterString,IN size,IN status,IN numOfItems,IN (tErrorMessage)NULL, IN NULL);

        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string"));
        }
        else
        {
            ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_CHANGE_PATH_METHOD_RETURN", IN parameterString);

            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
            }
            else
            {
            }
        }
    }
    else
    {

        if(isError)
        {
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);

            //Input arguments for AvpChangePathMethodReturn
            tBTMethodRequestStatus status = REQ_NOT_OK;
            tNumOfItems numOfItems = 0;
            ETG_TRACE_ERR(("AvpChangePath Failed with error %s",params));
            tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_CHANGE_PATH_METHOD_RETURN(OUT parameterString,IN size,IN status,IN numOfItems,IN (tErrorMessage)NULL, IN NULL);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while preparing parameter string"));
            }
            else
            {
                ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_CHANGE_PATH_METHOD_RETURN", IN parameterString);

                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                }
                else
                {
                }
            }
        }
    }
}
void BTDaemonProxy::AvpChangePathToRootMethodReturn(const char* params,bool isError)
{
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    //Input arguments for AvpChangePathMethodReturn
    tBTMethodRequestStatus status = REQ_NOT_OK;
    tNumOfItems numOfItems = 0;

    if(isError)
    {
        ETG_TRACE_ERR(("AvpChangePath Failed with error %s",params));
    }
    else
    {
        if(params && strlen_r(params))
        {
            //Find the Status of Response
            sscanf(params,"%u,%u",&status,&numOfItems);
            //Find the NumOfItem
        }
        else
        {
            //Do Nothing
        }
    }

    tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_CHANGE_PATH_TO_ROOT_METHOD_RETURN(OUT parameterString,IN size,IN status,IN numOfItems,IN (tErrorMessage)NULL);

    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string"));
    }
    else
    {
        ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_CHANGE_PATH_TO_ROOT_METHOD_RETURN", IN parameterString);

        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF"));
        }
        else
        {
        }
    }
}

void BTDaemonProxy::StartAudioPipeMethodReturn(const char* params,bool isError)
{
    ENTRY
    //variables to Send the StartAudioPipeMethodReturn
    tPipeName pipeName = NULL;
    tCodecType codecType = CODEC_TYPE_INVALID;
    tBitRate bitRate = 0;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        string token = "";
        //variables to Parse and Retrieve the the data from the variable "params"
        char seperator = ',';
        int iter=0;

        if(isError)
        {
            ETG_TRACE_ERR(("StartAudioPipe Failed with error %s",params));
        }
        else
        {
            //Find the ByteCount
            if(strlen_r(params))
            {
                string paramString = string(params);
                istringstream paramsStream(paramString);
                while(getline(paramsStream,token,seperator))
                {
                    if(iter == 0)
                    {
                        //Find the PipeName
                        pipeName = new unsigned char[255];
                        if(pipeName != NULL)
                        {
                            memset(pipeName,0,255);
                            strncpy_r((char*)pipeName,token.c_str(),255);
                        }
                        iter++;
                        ETG_TRACE_USR1(("PipeName is %s",pipeName));
                    }
                    else if(iter == 1)
                    {
                        //Find the CodecType
                        codecType = (tCodecType)atoi(token.c_str());
                        iter++;
                        ETG_TRACE_USR1(("CodecType is %d",codecType));
                    }
                    else if(iter == 2)
                    {
                        //Find the BitRate
                        bitRate = (tBitRate)atoi(token.c_str());
                        iter++;
                        ETG_TRACE_USR1(("BitRate is %d",bitRate));
                    }
                    else
                    {
                    }
                }
            }
            else
            {
            }
        }

        tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterSTART_AUDIO_PIPE_METHOD_RETURN(OUT parameterString,IN size,IN pipeName,IN codecType,IN bitRate,IN (tErrorMessage)NULL);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string"));
        }
        else
        {
            ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "START_AUDIO_PIPE_METHOD_RETURN", IN parameterString);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
            }
            else
            {
            }
        }
    }
    else
    {
        if(params!=NULL)
        {
            tMetadata CodecPipeName,CodecType;
            int literalCount = 0;
            char *ptr = (char*) strchr(params,IPC_DBUS_PARAM_DELIMITER_INT);
            ETG_TRACE_USR4(("ptr:%p",ptr));
            while (ptr != NULL)
            {
                ptr = strchr(ptr + 1,IPC_DBUS_PARAM_DELIMITER_INT);
                literalCount++;
            }
            std::string strFromChar;
            strFromChar.append(params);
            std::istringstream ss(strFromChar);
            std::string token[literalCount];
            for (int index = 0; index < literalCount; index++)
            {
                std::getline(ss, token[index], IPC_DBUS_PARAM_DELIMITER_CHAR);
            }
            for (int index = 0; index < literalCount; index ++)
            {
                if (token[index].compare("CodecBitrate") == 0)
                {
                    sscanf(token[index + 1].c_str(), "%u", &bitRate);
                    ETG_TRACE_USR4(("CodecBitrate :%s",token[index + 1].c_str()));
                    ETG_TRACE_USR4(("bitRate :%d",bitRate));
                    index ++;
                }
                else if (token[index].compare("CodecPipeName") == 0)
                {
                    snprintf(CodecPipeName, sizeof(CodecPipeName), "%s", token[index + 1].c_str());
                    if(token[index + 1].c_str()!=NULL)
                    {
                        pipeName = new unsigned char[255];
                        if(pipeName != NULL)
                        {
                            memset(pipeName,0,255);
                            strncpy_r((char*)pipeName,token[index + 1].c_str(),255);
                        }
                    }
                    ETG_TRACE_USR4(("CodecPipeName :%s",token[index + 1].c_str()));
                    ETG_TRACE_USR4(("pipeName :%s",pipeName));
                    index ++;
                }
                else if (token[index].compare("CodecType") == 0)
                {
                    snprintf(CodecType, sizeof(CodecType), "%s", token[index + 1].c_str());
                    ETG_TRACE_USR4(("CodecType :%s",token[index + 1].c_str()));
                    codecType = CODEC_TYPE_SBC;
                    if(token[index + 1].compare("SBC") == 0)
                    {
                        codecType = CODEC_TYPE_SBC;
                    }
                    else if(token[index + 1].compare("AAC") == 0)
                    {
                        codecType = CODEC_TYPE_MPEG24AAC;
                    }
                    ETG_TRACE_USR4(("codecType :%d",codecType));
                    index ++;
                }
            }
            if((codecType != CODEC_TYPE_INVALID) && (pipeName != NULL)&& (strlen_r((const char*)pipeName) > 1))
            {
                tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterSTART_AUDIO_PIPE_METHOD_RETURN(OUT parameterString,IN size,IN pipeName,IN codecType,IN bitRate,IN (tErrorMessage)NULL);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while preparing parameter string"));
                }
                else
                {
                    ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "START_AUDIO_PIPE_METHOD_RETURN", IN parameterString);
                    if( MP_NO_ERROR != ret )
                    {
                        ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                    }
                    else
                    {
                    }
                }
            }
        }
    }
} //lint !e429  To suprress LintWarning 429 as the Custodial pointer 'pipeName' will be freed by BTControl::StartAudioPipeMethodReturn

void BTDaemonProxy::AvpCtrlCmdMethodReturn(const char* params,bool isError)
{
    ENTRY
    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        tResult ret;

        /*Parameters received from CtrlCmd MethodReturn */
        tBTControlCmd command = BT_CMD_UNUSED;
        tBTButtonEvent buttonAction = BUTTON_PRESS;
        tBTMethodRequestStatus status = REQ_NOT_OK;


        /*frame command response and send it to sender:BTControlSM*/
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        if(isError)
        {
            ETG_TRACE_ERR(("AvpCtrlCmd Failed with error %s",params));
        }
        else
        {
            if(strlen_r(params))
            {
                /*parse the response data into variables*/
                sscanf(params, "%u,%u,%u", &command, &buttonAction,&status);
                ETG_TRACE_USR1(("AvpCtrlCmdMethodReturn command:%d ,ButtonAction:%d,status:%d",command, buttonAction, status));
            }
            else
            {
            }
        }
        if(LocalSPM::GetDataProvider().AVRCPLowerProfileSupported() && REQ_OK == status
                && !(mEventsSupported & ALPS_EVENT_PLAYBACK_STATUS_CHANGED))
        {
            /*update the playback status*/
            if(BT_CMD_PLAY == command)
            {
                mPlaybackState = PE_PBS_PLAYINGSTATE;
            }
            else if(BT_CMD_PAUSE == command)
            {
                mPlaybackState = PE_PBS_PAUSEDSTATE;
            }
            else if(BT_CMD_STOP == command)
            {
                mPlaybackState = PE_PBS_STOPPEDSTATE;
            }
        }
        ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_CTRL_CMD_METHOD_RETURN(OUT parameterString,IN size,IN command,IN buttonAction,IN status,IN (tErrorMessage)NULL);

        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string"));
        }
        else
        {
            ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_CTRL_CMD_METHOD_RETURN", IN parameterString);
            //ret = LocalSPM::GetInstance().GetBTControl().SendEventByName("AVP_CTRL_CMD_METHOD_RETURN", IN parameterString);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
            }
            else
            {
            }
        }
        /*The Below lines commented for GMMY16-17238*/
#if 0
        if( REQ_OK == status)
        {
            /*update the playback status*/
            if(BT_CMD_PLAY == command)
            {
                mPlaybackState = PE_PBS_PLAYINGSTATE;
            }
            else if(BT_CMD_PAUSE == command)
            {
                mPlaybackState = PE_PBS_PAUSEDSTATE;
            }
            else if(BT_CMD_FORWARD == command)
            {
                mPlaybackState = PE_PBS_FASTFORWARDSTATE;
            }
            else if(BT_CMD_REWIND == command)
            {
                mPlaybackState = PE_PBS_FASTREVERSESTATE;
            }
        }
#endif
    }
    else
    {
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        tPEPlaybackState PlaybackState = LocalSPM::GetInstance().GetBTControl().GetCurrentPlaybackState();
        LocalSPM::GetInstance().GetBTControl().ParameterPLAYBACK_ACTION_ANSWER(OUT parameterString, IN size, IN (tPEHandle)0, IN PlaybackState, IN (me::reason_e)0, IN (me::speed_e)0);
        LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "PLAYBACK_ACTION_ANSWER", IN parameterString);
        if(isError)
        {
            ETG_TRACE_ERR(("AvpCtrlCmd Failed with error"));
        }
        if(PLAY_SENT == LocalSPM::GetInstance().GetBTControl().GetStateOfPlayinStartPlay())
        {
            LocalSPM::GetInstance().GetBTControl().SetStateOfPlayinStartPlay(PLAY_REPLY_RECEIVED);
        }
    }
}
void BTDaemonProxy::StopAudioPipeMethodReturn(const char* params,bool isError)
{
    ENTRY

    if(isError)
    {
        ETG_TRACE_ERR(("StopAudioPipe Failed with error %s",params));
    }
}

void BTDaemonProxy::AvpGetCapabilitiesMethodReturn(const char* params,bool isError)
{
    ENTRY

    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    //Variables Needed to Prepare Parameter String
    tBTMethodRequestStatus status = REQ_NOT_OK;
    tCapabilityId capabilityId = 0;

    if(isError)
    {
        ETG_TRACE_ERR(("AvpGetCapabilities Failed with error %s",params));
    }
    else
    {
        if(strlen_r(params))
        {
            sscanf(params,"%u,%u,%u",&status,&capabilityId,&mEventsSupported);
        }
        else
        {
            //Do nothing
        }
    }
    tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_GET_CAPABILITIES_METHOD_RETURN(OUT parameterString,IN size,IN status,IN capabilityId,IN mEventsSupported,IN (tErrorMessage)NULL);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string"));
    }
    else
    {
        ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_GET_CAPABILITIES_METHOD_RETURN", IN parameterString);

        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF"));
        }
        else
        {
        }
    }
}

void BTDaemonProxy::AvpSetPlaybackModeValMethodReturn(const char* params,bool isError)
{

    //Update to BTControl is not required for projects with evolution stack, as the shuffle value should be updated only based on the proprty "Shuffle" update from stack : NCG3D-98011
    if(! LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        //Variables Needed to Prepare Parameter String
        tBTMethodRequestStatus status =REQ_NOT_OK;

        if(isError)
        {
            ETG_TRACE_ERR(("AvpSetPlaybackMode Failed with error %s",params));
        }
        else
        {
            //Find the Status of Response
            status =(tBTMethodRequestStatus)atoi(params);
            ETG_TRACE_USR1(("Status is %d",status));
        }
        tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_SET_PLAYBACK_METHOD_RETURN(OUT parameterString,IN size,IN status,IN (tErrorMessage)NULL);

        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string"));
        }
        else
        {
            ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_SET_PLAYBACK_METHOD_RETURN", IN parameterString);

            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
            }
            else
            {
            }
        }
    }
}

void BTDaemonProxy::AvpSetRepeatModeValMethodReturn(const char* params,bool isError)
{

    if(! LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        //Variables Needed to Prepare Parameter String
        tBTMethodRequestStatus status =REQ_NOT_OK;

        if(isError)
        {
            ETG_TRACE_ERR(("AvpSetRepeatMode Failed with error %s",params));

        }
        else
        {
            //Find the Status of Response
            status =(tBTMethodRequestStatus)atoi(params);
            ETG_TRACE_USR1(("status is %d",status));
        }
        tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_SET_REPEAT_METHOD_RETURN(OUT parameterString,IN size,IN status,IN (tErrorMessage)NULL);

        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string"));
        }
        else
        {
            ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_SET_REPEAT_METHOD_RETURN", IN parameterString);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
            }
            else
            {
            }
        }
    }
}

void BTDaemonProxy::AvpGetMetadataAttrMethodReturn(const char* params,bool isError)
{
    ENTRY

    //Variable to Send via PLAYBACK_STATUS_RESPONSE Event to BTControl Component
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    if(isError)
    {
        ETG_TRACE_ERR(("AvpGetMetadataAttr Failed with error %s",params));
    }
    else
    {
        if(params && strlen_r(params))
        {
            //Variables to Store the Status,NumOfAttributes,NetworkOrder and arrayLength
            tBTMethodRequestStatus status = REQ_NOT_OK;
            tNumAttributes numOfAttributes = 0;
            tNetworkOrder networkOrder = FALSE;
            tArrayLength arrayLength = 0;

            //Pointer to the ByteArray received
            tByteArray pData = NULL;

            //Pointer to the Store the StartAddress of ByteArray received
            tByteArray pDataAddr = NULL;

            ETG_TRACE_USR4(("params:%s",params));
            sscanf(params,"%u,%u,%u,%u,%p",&status,&numOfAttributes,&networkOrder,&arrayLength,&pData);

            ETG_TRACE_USR4(("status:%d",status));
            ETG_TRACE_USR4(("numOfAttributes:%d",numOfAttributes));
            ETG_TRACE_USR4(("networkOrder:%d",networkOrder));
            ETG_TRACE_USR4(("arrayLength:%d",arrayLength));
            ETG_TRACE_USR4(("pData is:%p",pData));

            pDataAddr = pData;
            if(REQ_NOT_OK == status)
            {
                ETG_TRACE_USR3(("Error : BTDaemonProxy::AvpGetMetadataAttrMethodReturn has returned status REQ_NOT_OK "));
                if(pDataAddr)
                {
                    delete[] pDataAddr;
                }
                return;
            }
            unsigned int iter;
#if 0
            for(iter =0;iter<arrayLength;iter++)
            {
                ETG_TRACE_USR3(("pData[%d] is %d",iter,pData[iter]));
            }
#endif
            //Finding Metadata Attributes
            unsigned int attributeId = 0;
            //unsigned short charSetId[6] = {0};    /*Commented as it is unused*/
            unsigned short attributeValueLen = 0;
            unsigned short attributeValueLenOriginal = 0;

            CleanupNowPlayingMetadata();

            //GMMY17-13817
            if(numOfAttributes > MAX_NUM_OF_ATTRIBUTES) numOfAttributes = MAX_NUM_OF_ATTRIBUTES;

            //gathering the Metadata
            for(iter = 0; iter < numOfAttributes; iter++)
            {
                //if arrayLength is zero,Donot Access pData,
                if(arrayLength)
                {
                attributeId  = *((unsigned int*)pData); //lint !e826  To suprress LintInfo 826 as the conversion is purposefully done
                pData += sizeof(unsigned int);
                    arrayLength -= sizeof(unsigned int);

                //charSetId[iter] = *((unsigned short*)pData); /*Parsing Commented as it is  unused*/
                pData += sizeof(unsigned short);
                    arrayLength -= sizeof(unsigned short);

                    attributeValueLen = *((unsigned short*)pData); //lint !e826  To suprress LintInfo 826 as the conversion is purposefully done
                pData += sizeof(unsigned short);
                    arrayLength -= sizeof(unsigned short);

                    if(networkOrder)
                {
                    attributeId =  ntohl(attributeId);
                        attributeValueLen = ntohs(attributeValueLen);
                    }

                    ETG_TRACE_USR1(("attributeId is %d",attributeId));
                    ETG_TRACE_USR1(("attributeValueLen is %d",attributeValueLen));

                    /*attributeValueLen may be forcefully reduced if it exceeds sizeof(mNowPlayingMetadata1).
                    Hence store the original Length*/
                    attributeValueLenOriginal = attributeValueLen;

                    if(attributeValueLen >= sizeof(mNowPlayingMetadata1))
                    {
                        attributeValueLen = sizeof(mNowPlayingMetadata1) -1;
                }

                switch(attributeId)
                {
                    case BT_ATTRIBUTE_GENRE:
                            memcpy(mNowPlayingMetadata1,pData,attributeValueLen);
                            mNowPlayingMetadata1[attributeValueLen] = '\0';
                        break;
                    case BT_ATTRIBUTE_ARTIST:
                            memcpy(mNowPlayingMetadata2,pData,attributeValueLen);
                            mNowPlayingMetadata2[attributeValueLen] = '\0';
                        break;
                    case BT_ATTRIBUTE_TITLE:
                            memcpy(mNowPlayingMetadata3,pData,attributeValueLen);
                            mNowPlayingMetadata3[attributeValueLen] = '\0';
                        break;
                    case BT_ATTRIBUTE_ALBUM:
                            memcpy(mNowPlayingMetadata4,pData,attributeValueLen);
                            mNowPlayingMetadata4[attributeValueLen] = '\0';
                        break;
                    default:
                        break;
                }

                    ETG_TRACE_USR1(("Incrementing DataPtr "));
                    pData += attributeValueLenOriginal;
                    arrayLength -= attributeValueLenOriginal;
                }
            }

            delete[] pDataAddr;
        }
        else
        {
            //AvpGetMetadataAttrMethodReturn is seen to get called with No-Metadata in windows Phone but request being REQ_OK
        }

        tObjectID ObjectID = OBJECT_ID_NONE;
        /* issue:User is not in MediaPlayer.Playback is statted in the BT connected Windows Phone.hence it is playing but not the active source in HMI.
         * Now if SS Done & if it is made active,the Device audio is heared But HMI Shows PAUSED State.*/
        tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString,IN size,IN mPlaybackState,IN mNowPlayingMetadata1,IN mNowPlayingMetadata2,IN mNowPlayingMetadata3,IN mNowPlayingMetadata4,IN ObjectID);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string"));
        }
        else
        {
            ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "PLAYBACK_STATUS_RESPONSE", IN parameterString);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
            }
            else
            {
            }
        }
    }
}

void BTDaemonProxy::RequestMetadataMethodReturn(const char* params,bool isError)
{
    ENTRY
    if(isError)
    {
        ETG_TRACE_ERR(("BTEvolutionProxy::RequestMetadataMethodReturn Failed with error %s",params));
    }
    else
    {
        ETG_TRACE_USR4(("IPC_DBUS_PARAM_DELIMITER_CHAR:%d",IPC_DBUS_PARAM_DELIMITER_CHAR));
        int literalCount = 0;
        char *ptr = (char*) strchr(params,IPC_DBUS_PARAM_DELIMITER_INT);
        ETG_TRACE_USR4(("ptr:%p",ptr));
        while (ptr != NULL)
        {
            ptr = strchr(ptr + 1,IPC_DBUS_PARAM_DELIMITER_INT);
            literalCount++;
        }
        ETG_TRACE_USR4(("literalCount:%d",literalCount));


        std::string strFromChar;
        strFromChar.append(params);
        std::istringstream ss(strFromChar);

        tBoolean CoverArtHandleAvailable = false;
        std::vector<std::string> tokenVector;

        for (int index = 0; index < literalCount; index++)
        {
            string token;
            std::getline(ss, token, IPC_DBUS_PARAM_DELIMITER_CHAR);
            tokenVector.push_back(token);
        }

        CleanupNowPlayingMetadata();

        StoreNowPlayingMetadata(IN tokenVector);

        ETG_TRACE_USR1(("BTEvolutionProxy::RequestMetadataMethodReturn mNowPlayingMetadata1 = %s ",mNowPlayingMetadata1));
        ETG_TRACE_USR1(("BTEvolutionProxy::RequestMetadataMethodReturn mNowPlayingMetadata2 = %s ",mNowPlayingMetadata2));
        ETG_TRACE_USR1(("BTEvolutionProxy::RequestMetadataMethodReturn mNowPlayingMetadata3 = %s ",mNowPlayingMetadata3));
        ETG_TRACE_USR1(("BTEvolutionProxy::RequestMetadataMethodReturn mNowPlayingMetadata4 = %s ",mNowPlayingMetadata4));

        ETG_TRACE_USR1(("BTEvolutionProxy::RequestMetadataMethodReturn mNowPlayingAlbumArtHandle = %s ",mNowPlayingAlbumArtHandle.c_str()));
        ETG_TRACE_USR1(("BTEvolutionProxy::RequestMetadataMethodReturn mNowPlayingObjectPath = %s ",mNowPlayingObjectPath.c_str()));
    }
}

void BTDaemonProxy::AvpListAttrMethodReturn(const char* params,bool isError)
{
    ENTRY
    ETG_TRACE_USR3(("BTDaemonProxy::AvpListAttrMethodReturn %s ",params));
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    //Variables Needed to Prepare Parameter String
    tBTMethodRequestStatus status = REQ_NOT_OK;
    tAttributesBit attributesBit = 0;

    if(isError &&  params!=NULL)
    {
        ETG_TRACE_ERR(("AvpListAttr Failed with error %s",params));
    }
    else if(params!=NULL)
    {
        if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
        {
            if(strlen_r(params))
            {
                sscanf(params,"%u,%u",&status,&attributesBit);
            }
            else
            {
            }
        }
        else
        {
            status = REQ_OK;
            int literalCount = 0;
            char *ptr = (char*) strchr(params,IPC_DBUS_PARAM_DELIMITER_INT);
            while (ptr != NULL)
            {
                ptr = strchr(ptr + 1,IPC_DBUS_PARAM_DELIMITER_INT);
                literalCount++;
            }
            std::string strFromChar;
            strFromChar.append(params);
            std::istringstream ss(strFromChar);
            std::string token[literalCount];
            for (int index = 0; index < literalCount; index++)
            {
                std::getline(ss, token[index], IPC_DBUS_PARAM_DELIMITER_CHAR);
            }
            for (int index = 0; index < literalCount; index ++)
            {
                if (token[index].compare("Repeat") == 0)
                {
                    attributesBit = attributesBit | (1 << (ALPS_ATTR_REPEAT - 1));
                    cout << token[index] << endl;
                    index ++;
                }
                else if ((token[index].compare("Shuffle") == 0))
                {
                    cout << token[index] << endl;
                    attributesBit = attributesBit | (1 << (ALPS_ATTR_SHUFFEL - 1));
                    index ++;
                }
                else if ((token[index].compare("track") == 0))
                {
                    index ++;
                    break;
                }
            }
        }
    }
    tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_LIST_ATTR_METHOD_RETURN(OUT parameterString,IN size,IN status,IN attributesBit,IN (tErrorMessage)NULL);

    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string"));
    }
    else
    {
        ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_LIST_ATTR_METHOD_RETURN", IN parameterString);

        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF"));
        }
        else
        {
        }
    }
}

void BTDaemonProxy::AvpNotifySetCompleteSignal(const char* params)
{
    ENTRY

    //Find the EventId
    tEventId eventID ;
    sscanf(params, "%u",&eventID);
    ETG_TRACE_USR1(("AvpNotifySetCompleteSignal eventId is %d",eventID));

    // AvpNotifySetCompleteSignal is not used by BTControl
    return;

#if 0
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_NOTIFY_SET_COMPLETE_IND(OUT parameterString,IN size,IN eventID);

    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string"));
    }
    else
    {
        ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_NOTIFY_SET_COMPLETE_IND", IN parameterString);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF"));
        }
        else
        {
        }
    }
#endif
}
#if 0
void BTDaemonProxy::playerAddedSignal(const char* params)
{
    ENTRY
    if (params != NULL)
    {
        ETG_TRACE_USR3(("BTDaemonProxy::playerAddedSignal received string :%s",params));
        int literalCount = 0;
        char *ptr = (char*) strchr(params,IPC_DBUS_PARAM_DELIMITER_INT);
        while (ptr != NULL)
        {
            ptr = strchr(ptr + 1,IPC_DBUS_PARAM_DELIMITER_INT);
            literalCount++;
        }
        std::string strFromChar;
        strFromChar.append(params);
        std::istringstream ss(strFromChar);
        std::string token[literalCount];
        for (int index = 0; index < literalCount; index++)
        {
            std::getline(ss, token[index], IPC_DBUS_PARAM_DELIMITER_CHAR);
        }
        InitBTPlayerInfo(mPlayerInfo);
        mPlayerInfo.objectPath = token[0];

        for(int index = 0; index < literalCount - 1; index ++)
        {
            if (token[index].compare("Browsable") == 0)
            {
                if(token[index+1] == "1")
                    mPlayerInfo.isBrowsable = true;
                ETG_TRACE_USR4(("Token :Browsable : %d",mPlayerInfo.isBrowsable));
                index++;
            }
            else if (token[index].compare("Searchable") == 0)
            {
                if(token[index+1] == "1")
                    mPlayerInfo.isSearchable = true;
                ETG_TRACE_USR4(("Token :Searchable : %d",mPlayerInfo.isSearchable));
                index++;
            }
            else if (token[index].compare("DBAware") == 0)
            {
                if(token[index+1] == "1")
                    mPlayerInfo.isDBAware = true;
                ETG_TRACE_USR4(("Token :DBAware : %d",mPlayerInfo.isDBAware));
                index++;
            }
        }

        OverrideEvoObjectPaths(mPlayerInfo.objectPath);
        #if 0
        if(mPlayerInfo.isBrowsable)
        {
            LocalSPM::GetIPCProvider().MethodCall(ipc_Evolution_SetBrowsedPlayer);
            mPlayerInfo.isSetBrowsedPlayerSuccess = true;
        }
        else
        {
        }
        #endif
        if(mPlayerInfo.isBrowsable)
        {
            tNumOfItems numOfItems;
            tResult ret = SetupPlayerForBrowsing(IN mPlayerInfo.objectPath.c_str(),OUT numOfItems);
            if( MP_NO_ERROR == ret )
            {
                LocalSPM::GetInstance().GetBTControl().UpdateDeviceVersion(AVRCP_BROWSING);
            }
            else
            {
                LocalSPM::GetInstance().GetBTControl().UpdateDeviceVersion(AVRCP_METADATA);
            }
        }
        else
        {
            LocalSPM::GetInstance().GetBTControl().UpdateDeviceVersion(AVRCP_METADATA);
        }
        tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();

        if(connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET)
        {
            if (mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint)!= std::string::npos)
            {

                LocalSPM::GetBTControl().SetCurrentPlayer(mPlayerInfo.objectPath);
                if(connectedDeviceInfo.connected)
                {
                    tAllParameters parameterString;
                    size_t size = sizeof(parameterString);
                    tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_CHANGE_BROWSE_PLAYER(OUT parameterString, IN size, IN mPlayerInfo.objectPath.c_str());
                    if( MP_NO_ERROR != ret )
                    {
                        ETG_TRACE_ERR(("Error while preparing parameter string"));
                    }
                    else
                    {
                        ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_CHANGE_BROWSE_PLAYER", IN parameterString);
                        if( MP_NO_ERROR != ret )
                        {
                            ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                        }
                    }
                }
                else
                {
                    GetMediaPlayerItemMethodReturn(NULL,false);
                }
            }
        }

    }
}
#endif

void BTDaemonProxy::AddressedPlayerChanged(string playername)
{
    ENTRY

    tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
    if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (playername.find(connectedDeviceInfo.mountPoint) != string::npos)
            && mPlayerInfo.objectPath.compare(playername) != 0)
    {
        InitBTPlayerInfo(mPlayerInfo);
        if(connectedDeviceInfo.connected)
        {
            tAllParameters parameterString;
            size_t size = sizeof(parameterString);
            tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_CHANGE_BROWSE_PLAYER(OUT parameterString, IN size, IN playername.c_str());
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while preparing parameter string"));
            }
            else
            {
                ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_CHANGE_BROWSE_PLAYER", IN parameterString);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                }
            }
        }
        else
        {
            LocalSPM::GetBTControl().SetCurrentPlayer(mPlayerInfo.objectPath);
            mPlayerInfo.objectPath = playername;
            OverrideEvoObjectPaths(playername);
            GetMediaPlayerItemMethodReturn(NULL,false);
        }
    }
}
void BTDaemonProxy::propertiesChangedSignal(const char* params)
{
    ENTRY
    if (params != NULL)
    {
       // ETG_TRACE_USR3(("BTDaemonProxy::propertiesChangedSignal received string :%s",params));
        //tBTPlayStatus btPlayStatus = BT_PS_ERROR;
        tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
        std::string strFromChar;
        strFromChar.append(params);
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
       // tEventId eventId = 0;
        std::istringstream ss(strFromChar);
        std::string token1,token2, token3;
        std::getline(ss, token1, IPC_DBUS_PARAM_DELIMITER_CHAR);
        if(token1.compare(IPC_EVOLUTION_MEDIAFOLER_INTERFACE)==0)
        {

            std::getline(ss, token2, IPC_DBUS_PARAM_DELIMITER_CHAR);
            if(token2.compare("Name") == 0)
            {
                // GetTaskSyncSemWaitChangeFolder is true while changefolder request is made from worker thread for nowplaying list,
                //in this state (doTask_Idle) BTControlSM will not consume AVP_CHANGE_PATH_METHOD_RETURN
                if(GetTaskSyncSemWaitChangeFolder())
                {
                    sem_post(&m_ChangeFolderSyncSem);
                }
                else
                {
                    string itemName;
                    std::getline(ss, itemName, IPC_DBUS_PARAM_DELIMITER_CHAR);
                    std::getline(ss, token3, IPC_DBUS_PARAM_DELIMITER_CHAR);
                    if(token3.compare("NumberOfItems") == 0)
                    {
                        string strNumberofItems;
                        std::getline(ss, strNumberofItems, IPC_DBUS_PARAM_DELIMITER_CHAR);

                        tNumOfItems numberOfItems;
                        sscanf(strNumberofItems.c_str(), "%u", &numberOfItems);
                        //Input arguments for AvpChangePathMethodReturn
                        tBTMethodRequestStatus status = REQ_OK;

                        tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_CHANGE_PATH_METHOD_RETURN(OUT parameterString,IN size,IN status,IN numberOfItems,IN (tErrorMessage)NULL, IN itemName.c_str());

                        if( MP_NO_ERROR != ret )
                        {
                            ETG_TRACE_ERR(("Error while preparing parameter string"));
                        }
                        else
                        {
                            ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_CHANGE_PATH_METHOD_RETURN", IN parameterString);

                            if( MP_NO_ERROR != ret )
                            {
                                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                            }
                        }
                    }
                }
            }

        }
        else if(token1.compare(IPC_EVOLUTION_AVP_INTERFACE)==0)
        {
            tPipeName pipeName = NULL;
            tCodecType codecType = CODEC_TYPE_INVALID;
            tBitRate bitRate = 0;
            tMetadata CodecPipeName,CodecType;
            int literalCount = 0;
            std::string temp(ss.str());
            const char* tempParam = temp.c_str();

            char *ptr = (char*) strchr(tempParam,IPC_DBUS_PARAM_DELIMITER_INT);
            ETG_TRACE_USR4(("ptr:%p",ptr));
            while (ptr != NULL)
            {
                ptr = strchr(ptr + 1,IPC_DBUS_PARAM_DELIMITER_INT);
                literalCount++;
            }

            std::string token[literalCount];
            for (int index = 0; index < literalCount; index++)
            {
                std::getline(ss, token[index], IPC_DBUS_PARAM_DELIMITER_CHAR);
                ETG_TRACE_USR4(("Token :%s",token[index].c_str()));
            }
            for (int index = 0; index < literalCount; index++)
            {
                if (token[index].compare("CodecBitrate") == 0)
                {
                    sscanf(token[index + 1].c_str(), "%u", &bitRate);
                    ETG_TRACE_USR4(("CodecBitrate :%s",token[index + 1].c_str()));
                    ETG_TRACE_USR4(("bitRate :%d",bitRate));
                }
                else if (token[index].compare("CodecPipeName") == 0)
                {
                    snprintf(CodecPipeName, sizeof(CodecPipeName), "%s", token[index + 1].c_str());
                    if(token[index + 1].c_str()!=NULL)
                    {
                        pipeName = new unsigned char[255];
                        if(pipeName != NULL)
                        {
                            memset(pipeName,0,255);
                            strncpy_r((char*)pipeName,token[index + 1].c_str(),255);
                        }
                    }
                    ETG_TRACE_USR4(("CodecPipeName :%s",token[index + 1].c_str()));
                    ETG_TRACE_USR4(("pipeName :%s",pipeName));
                }
                else if(token[index].compare("CodecType") == 0)
                {
                    snprintf(CodecType, sizeof(CodecType), "%s", token[index + 1].c_str());
                    ETG_TRACE_USR4(("CodecType :%s",token[index + 1].c_str()));
                    codecType = CODEC_TYPE_SBC;
                    if(token[index + 1].compare("SBC") == 0)
                    {
                        codecType = CODEC_TYPE_SBC;
                    }
                    else if(token[index + 1].compare("AAC") == 0)
                    {
                        codecType = CODEC_TYPE_MPEG24AAC;
                    }
                    ETG_TRACE_USR4(("codecType :%d",codecType));
                }
                else if(token[index].compare("Addressedplayer") == 0)
                {
                    AddressedPlayerChanged(token[index + 1]);
                }
                else if (token[index].compare("SupportShuffle") == 0)
                {
                    tPlayerAttributes SupportedAttributes;
                    InitPlayerAttributes(SupportedAttributes);
                    int playbackMode = PBM_INVALID;
                    //SupportShuffle should support two values Off and Alltracks
                    if((index+2) < literalCount)
                    {
                        if (((token[index+1].compare("Off") == 0) || (token[index+1].compare("Alltracks") == 0)) && ((token[index+2].compare("Off") == 0) || (token[index+2].compare("Alltracks") == 0)))
                        {
                            SupportedAttributes.Shuffle.AttributeSupported = true;
                            playbackMode = AvpGetShuffleValue();
                            ETG_TRACE_USR4(("SupportShuffle changed with shuffle value : %d",playbackMode));
                            index=index+2;
                        }
                    }
                    tResult ret = LocalSPM::GetInstance().GetBTControl().UpdateShuffleSupportToDB((int)SupportedAttributes.Shuffle.AttributeSupported);
                    if( MP_NO_ERROR != ret )
                    {
                        ETG_TRACE_ERR(("Error while updating shufflesupport to db"));
                    }
                    if(SupportedAttributes.Shuffle.AttributeSupported)
                    {
                        LocalSPM::GetInstance().GetBTControl().ForwardPlaybackModeStatus((tPlaybackMode)playbackMode);
                    }
                }
                else if (token[index].compare("SupportRepeat") == 0)
                {
                    tPlayerAttributes SupportedAttributes;
                    InitPlayerAttributes(SupportedAttributes);
                    int repeatMode = RPT_INVALID;
                    //SupportRepeat should support three values Off and Alltracks and Single track
                    if((index+3) < literalCount)
                    {
                        if (((token[index+1].compare("Off") == 0) || (token[index+1].compare("Singletrack") == 0) || (token[index+1].compare("Alltracks") == 0)) && ((token[index+2].compare("Off") == 0) || (token[index+2].compare("Singletrack") == 0) || (token[index+2].compare("Alltracks") == 0)) && ((token[index+3].compare("Off") == 0) || (token[index+3].compare("Singletrack") == 0) || (token[index+3].compare("Alltracks") == 0)))
                        {
                            SupportedAttributes.Repeat.AttributeSupported = true;
                            repeatMode = AvpGetRepeatValue();
                            ETG_TRACE_USR4(("SupportRepeat changed with Repeat value : %d",repeatMode));
                            index=index+3;
                        }
                    }
                    tResult ret = LocalSPM::GetInstance().GetBTControl().UpdateRepeatSupportToDB((int)SupportedAttributes.Repeat.AttributeSupported);
                    if( MP_NO_ERROR != ret )
                    {
                        ETG_TRACE_ERR(("Error while updating SupportRepeat to db"));
                    }
                    if(SupportedAttributes.Repeat.AttributeSupported)
                    {
                        LocalSPM::GetInstance().GetBTControl().ForwardRepeatModeStatus((tRepeatMode)repeatMode);
                    }
                }
                else if(token[index].compare("SupportAbsoluteVolume") == 0)
                {
                    if((index+1) < literalCount)
                    {
                        if (token[index+1].compare("Supported") == 0)
                        {
                            LocalSPM::GetDataProvider().AbsoluteVolumeSupportForBTDevice = 1;
                            GetObjectPathForAbsoluteVolume();
                            GetVolumeFromDevice();

                            //Get Current Head unit Volume from Audio Component .
                            char msgToSendString[64];
                            strncpy_r(OUT msgToSendString, IN "CustomControlSM::GET_VOLUME_FROM_AUDIO", IN sizeof(msgToSendString));

                            tResult ret = Dispatcher::GetInstance().SendMessage(IN msgToSendString, NULL);
                            if (MP_NO_ERROR != ret)
                            {
                                ETG_TRACE_ERR(("Error while sending message via SMF (ErrorCode:%s)", errorString(ret)));
                            }
                        }
                        else if(token[index+1].compare("NotSupported") == 0)
                        {
                            LocalSPM::GetDataProvider().AbsoluteVolumeSupportForBTDevice = 0;
                        }
                    }
                }
                else if(token[index].compare("CoverArtConStatus") == 0) /* Task 317554 Album art extraction from BT device supporting AVRCP1.6 */
                {
                    ETG_TRACE_USR4((" CoverArtConStatus entered "));
                    if(LocalSPM::GetDataProvider().EnableBTNowPlayingCoverArt())
                    {
                        if((index+1) < literalCount)
                        {
                            tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
                            if ((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint) != string::npos))
                            {
                                if (token[index+1].compare("Connected") == 0)
                                {
                                    LocalSPM::GetInstance().GetBTControl().SetCoverArtConStatus(CONNECTED);

                                    // Create a folder to store coverarts
                                    DIR* tmpDir = opendir(BT_COVERART_PATH);
                                    if(NULL == tmpDir)
                                    {
                                        if(0 == mkdir(BT_COVERART_PATH,S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH))
                                        {
                                            ETG_TRACE_USR4((" Created folder in tmp for bt coverarts as: %s",BT_COVERART_PATH));
                                        }
                                        else
                                        {
                                            ETG_TRACE_ERR(("mkdir: error: %d/%s", errno, strerror(errno)));
                                        }
                                    }
                                    else
                                    {
                                        closedir(tmpDir);
                                    }
                               }
                               else if(token[index+1].compare("NotConnected") == 0)
                               {
                                   LocalSPM::GetInstance().GetBTControl().SetCoverArtConStatus(NOTCONNECTED);
                               }
                               else if(token[index + 1].compare("Unknown") == 0)
                               {
                                   LocalSPM::GetInstance().GetBTControl().SetCoverArtConStatus(UNKNOWN);
                               }
                               ETG_TRACE_USR4((" CoverArtConStatus : %d", connectedDeviceInfo.coverArtConStatus));
                           }
                       }
                    }
                }
            }
            if((codecType != CODEC_TYPE_INVALID) && (pipeName != NULL) && (strlen_r((const char*)pipeName) > 1))
            {
                tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterSTART_AUDIO_PIPE_METHOD_RETURN(OUT parameterString,IN size,IN pipeName,IN codecType,IN bitRate,IN (tErrorMessage)NULL);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while preparing parameter string"));
                }
                else
                {
                    ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "START_AUDIO_PIPE_METHOD_RETURN", IN parameterString);
                    if( MP_NO_ERROR != ret )
                    {
                        ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                    }
                    else
                    {
                    }
                }
            }
        }
        else if(token1.compare(IPC_EVOLUTION_INTERFACE)==0)
        {
            int literalCount = 0;
            std::string temp(ss.str());
            const char* tempParam = temp.c_str();
            char *ptr = (char*) strchr(tempParam,IPC_DBUS_PARAM_DELIMITER_INT);
            ETG_TRACE_USR4(("ptr:%p",ptr));
            while (ptr != NULL)
            {
                ptr = strchr(ptr + 1,IPC_DBUS_PARAM_DELIMITER_INT);
                literalCount++;
            }
            std::string token[literalCount];
            for (int index = 0; index < literalCount; index++)
            {
                std::getline(ss, token[index], IPC_DBUS_PARAM_DELIMITER_CHAR);
                ETG_TRACE_USR4(("Token :%s",token[index].c_str()));
            }
            tBoolean bSupportedEvent = false;
            for (int index = 0; index < literalCount; index++)
            {
                if (token[index].compare("Status") == 0)
                {
                    //eventId = ALPS_EVENT_PLAYBACK_STATUS_CHANGED;
                    ETG_TRACE_USR1(("Received ALPS_EVENT_PLAYBACK_STATUS_CHANGED event"));
                    if (token[index+1].compare("Playing") == 0)
                    {
                       //btPlayStatus = BT_PS_PLAYING;
                        ETG_TRACE_USR1(("BTDaemonProxy::propertiesChangedSignal Playing"));
                        ETG_TRACE_USR1(("BTPlayStatus is BT_PS_PLAYING"));
                        setPlaybackState(PE_PBS_PLAYINGSTATE);
                        index++;
                        //Device has updated that the playback state is playing , so stop the play retrial timer, to avoid retrial play command to device.
                        LocalSPM::GetInstance().GetBTControl().StopRetryPlayTimer();
                        /*Since the playback has started , timer should be intiated to check playtime updates at regular intervals.
                        If playtime updates are not recieved error msg to be shown in HMI.*/
                        startTimer(BT_INITRESPONSE_PLAY, BT_RESPONSETIMEOUT);
                    }
                    else if (token[index+1].compare("Paused") == 0)
                    {
                       // btPlayStatus = BT_PS_PAUSED;
                        ETG_TRACE_USR1(("BTDaemonProxy::propertiesChangedSignal Paused"));
                        ETG_TRACE_USR1(("BTPlayStatus is BT_PS_PAUSED"));
                        setPlaybackState(PE_PBS_PAUSEDSTATE);
                        index++;
                        stopTimer();
                    }
                    else if (token[index+1].compare("Stopped") == 0)
                    {
                        //btPlayStatus = BT_PS_STOPPED;
                        ETG_TRACE_USR1(("BTDaemonProxy::propertiesChangedSignal stopped"));
                        ETG_TRACE_USR1(("BTPlayStatus is BT_PS_STOPPED"));
                        setPlaybackState(PE_PBS_STOPPEDSTATE);
                        index++;
                        stopTimer();
                    }
                    else if(token[index+1].compare("Forward-seek") == 0)
                    {
                        //btPlayStatus = BT_PS_FWDSEEK;
                        ETG_TRACE_USR1(("BTDaemonProxy::propertiesChangedSignal forward-seek"));
                        ETG_TRACE_USR1(("BTPlayStatus is BT_PS_FWDSEEK"));
                        setPlaybackState(PE_PBS_FASTFORWARDSTATE);
                        index++;
                        stopTimer();

                    }
                    else if(token[index+1].compare("Reverse-seek") == 0)
                    {
                        // btPlayStatus = BT_PS_REVSEEK;
                        ETG_TRACE_USR1(("BTDaemonProxy::propertiesChangedSignal reverse-seek"));
                        ETG_TRACE_USR1(("BTPlayStatus is BT_PS_REVSEEK"));
                        setPlaybackState(PE_PBS_FASTREVERSESTATE);
                        index++;
                        stopTimer();
                    }
                    else if(token[index+1].compare("Error") == 0)
                    {
                        //btPlayStatus = BT_PS_ERROR;
                        ETG_TRACE_USR1(("BTDaemonProxy::propertiesChangedSignal error"));
                        ETG_TRACE_USR1(("BTPlayStatus is BT_PS_ERROR"));
                        setPlaybackState(PE_PBS_ERRORSTATE);
                        index++;
                    }

                    if(mIsBTDeviceControlActive)
                    {
                        mBTActivePlaybackstate = getPlaybackState();
                    }
                    //Store the latest playback state received from the device.Which will helps to avoid sending PLAY command to device if it is already in playing state.
                    mLatestPlaybackStateFromDevice = getPlaybackState();

                    tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterPLAYBACK_STATUS_RESPONSE(
                            OUT parameterString, IN size, IN getPlaybackState(), IN mNowPlayingMetadata1,
                            IN mNowPlayingMetadata2, IN mNowPlayingMetadata3, IN mNowPlayingMetadata4,IN mObjectID);

                    if (MP_NO_ERROR != ret)
                    {
                        ETG_TRACE_ERR(("Error while preparing parameter string"));
                    }

                    ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "PLAYBACK_STATUS_RESPONSE",
                            IN parameterString);

                    if (MP_NO_ERROR != ret)
                    {
                        ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                    }
                    bSupportedEvent = true;

                }
                else if (token[index].compare("Position") == 0)
                {
                    std::getline(ss, token[index+1],IPC_DBUS_PARAM_DELIMITER_CHAR);
                   // eventId = ALPS_EVENT_PLAYBACK_POS_CHANGED;
                    SetElapsedPlayTime((tPlaytime) atoi(token[index+1].c_str()));
                    ETG_TRACE_USR1(("BTDaemonProxy::propertiesChangedSignal Position : %d",GetElapsedPlayTime()));
                    ETG_TRACE_USR1(("ElapsedPlaytime is %u ms %u sec\n",GetElapsedPlayTime(), GetElapsedPlayTime()/1000));
                    tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterTICK_TIME_ELAPSED(OUT parameterString,
                            IN size, IN GetElapsedPlayTime(), IN mtotalPlayTime/*IN totalPlayTime*/);
                    if (MP_NO_ERROR != ret)
                    {
                        ETG_TRACE_ERR(("Error while preparing parameter string"));
                    }
                    else
                    {
                        ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "TICK_TIME_ELAPSED",
                                IN parameterString);
                        if (MP_NO_ERROR != ret)
                        {
                            ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                        }
                    }
                    index++;
                    bSupportedEvent = true;
                }
                else if (token[index].compare("Track") == 0)
                {
                    //eventId = ALPS_EVENT_TRACK_CHANGED;
                    ETG_TRACE_USR1(("Received ALPS_EVENT_TRACK_CHANGED event"));
                    std::vector<std::string> tokenVector;
                    for(int startIdx = index+1; startIdx< literalCount;  startIdx++)
                    {
                        tokenVector.push_back(token[startIdx]);
                    }

                    StoreNowPlayingMetadata(IN tokenVector);
                    bSupportedEvent = true;
                }
                else if (token[index].compare("Repeat") == 0)
                {
                    //eventId = ALPS_EVENT_REPEAT_CHANGED;

                    tRepeatMode repeatMode=RPT_NONE;
                    if (token[index+1].compare("Off") == 0)
                    {
                        repeatMode = RPT_NONE;

                    }else if(token[index+1].compare("Singletrack") == 0)
                    {
                        repeatMode = RPT_ONE;

                    }else if((token[index+1].compare("Alltracks") == 0) ||(token[index+1].compare("Group") == 0) )
                    {
                        repeatMode = RPT_LIST;
                    }
                    LocalSPM::GetInstance().GetBTControl().ForwardRepeatModeStatus(repeatMode);
                    index++;
                    bSupportedEvent = true;
                }
                else if (token[index].compare("Shuffle") == 0)
                {
                   // eventId = ALPS_EVENT_SHUFFLE_CHANGED;
                    tPlaybackMode playbackMode =PBM_NORMAL;
                    if (token[index+1].compare("Off") == 0)
                    {

                        playbackMode = PBM_NORMAL;

                    }else if((token[index+1].compare("Alltracks") == 0) ||(token3.compare("Group") == 0) )
                    {

                        playbackMode = PBM_RANDOM;
                    }

                    LocalSPM::GetInstance().GetBTControl().ForwardPlaybackModeStatus(playbackMode);
                    index++;
                    bSupportedEvent = true;
                }
                else if (token[index].compare("Browsable") == 0)
                {
                    if (token[index+1].compare("1") == 0)
                    {
                        mPlayerInfo.isBrowsable = true;
                        tNumOfItems numOfItems;
                        tResult ret = SetupPlayerForBrowsing(IN mPlayerInfo.objectPath.c_str(),OUT numOfItems);
                        if( MP_NO_ERROR == ret )
                        {
                            LocalSPM::GetInstance().GetBTControl().UpdateDeviceVersion(AVRCP_BROWSING);
                        }
                        else
                        {
                            LocalSPM::GetInstance().GetBTControl().UpdateDeviceVersion(AVRCP_METADATA);
                        }
                    }
                    index++;
                    bSupportedEvent = true;
                }
            }
            if(!bSupportedEvent)
            {
                ETG_TRACE_USR1(("BTDaemonProxy::propertiesChangedSignal Event not supported"));
            }
        }
        else if(token1.compare(IPC_EVOLUTION_MEDIATRANSPORT_INTERFACE)==0)
        {
            if(LocalSPM::GetDataProvider().AbsoluteVolumeSupportFeatureBT() && LocalSPM::GetDataProvider().AbsoluteVolumeSupportForBTDevice())
            {
                int literalCount = 0;
                std::string temp(ss.str());
                const char* tempParam = temp.c_str();
                char *ptr = (char*) strchr(tempParam,IPC_DBUS_PARAM_DELIMITER_INT);
                ETG_TRACE_USR4(("ptr:%p",ptr));
                while (ptr != NULL)
                {
                    ptr = strchr(ptr + 1,IPC_DBUS_PARAM_DELIMITER_INT);
                    literalCount++;
                }
                std::string token[literalCount];
                if(literalCount > 1)
                {
                    for (int index = 0; index < literalCount; index++)
                    {
                        std::getline(ss, token[index], IPC_DBUS_PARAM_DELIMITER_CHAR);
                        ETG_TRACE_USR4(("Token :%s",token[index].c_str()));
                    }
                    for (int index = 0; index < literalCount; index++)
                    {
                        if ((token[index].compare("Volume") == 0) && (literalCount > (index + 1)) && ((connectedDeviceInfo.activeSource)))
                        {
                            int Volume;
                            sscanf(token[index+1].c_str(), "%u", &Volume);
                            ETG_TRACE_USR4(("Volume has changed in device with value : %d",Volume));
                            tAbsoluteVolumeSupportVariables absoluteVolumeSupportVariables = CURRENT_VOLUME_IN_DEVICE;
                            SetAbsoluteVolumeSupportValues(absoluteVolumeSupportVariables,Volume);
                            //Update Volume to Audio , only when there is no update to device pending
                            tAbsoluteVolumeSupportValues absoluteVolumeSupportValues;
                            absoluteVolumeSupportValues = GetAbsoluteVolumeSupportValues();
                            if(Volume == absoluteVolumeSupportValues.volumeSentToDevice)
                            {
                                StopAbsoluteVolumeWaitTimer();
                                absoluteVolumeSupportVariables = VOLUME_SENT_TO_DEVICE;
                                int setValue = INVALID_VOLUME;
                                SetAbsoluteVolumeSupportValues(absoluteVolumeSupportVariables,setValue);
                                absoluteVolumeSupportVariables = WAITING_FOR_VOLUME_UPDATE;
                                setValue = RESET_WAIT;
                                SetAbsoluteVolumeSupportValues(absoluteVolumeSupportVariables,setValue);
                            }
                            VARTRACE(absoluteVolumeSupportValues.waitingForVolumeUpdate);
                            VARTRACE(absoluteVolumeSupportValues.currentVolumeReceivedFromAudio);
                            if((!absoluteVolumeSupportValues.waitingForVolumeUpdate) && (absoluteVolumeSupportValues.currentVolumeReceivedFromAudio == -1))
                            {
                                tAllParameters parameterStringforVolume;
                                size_t size1 = sizeof(parameterStringforVolume);
                                tResult Result = LocalSPM::GetInstance().GetBTControl().ParameterUPDATE_VOLUME_TO_AUDIO(OUT parameterStringforVolume, IN size1, IN Volume);
                                if( MP_NO_ERROR != Result )
                                {
                                    ETG_TRACE_ERR(("Error while preparing parameter string"));
                                }
                                else
                                {
                                    Result = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "UPDATE_VOLUME_TO_AUDIO", IN parameterStringforVolume);
                                    if( MP_NO_ERROR != Result )
                                    {
                                        ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                                    }
                                }
                            }
                            //We have received the Volume for which the request was sent and there is a volume pending to be sent to device from audio.
                            else if ((absoluteVolumeSupportValues.waitingForVolumeUpdate) && (Volume == absoluteVolumeSupportValues.volumeSentToDevice) && (absoluteVolumeSupportValues.currentVolumeReceivedFromAudio != -1))
                            {
                                tAllParameters parameterStringforVolume;
                                size_t size1 = sizeof(parameterStringforVolume);
                                tResult Result = LocalSPM::GetInstance().GetBTControl().ParameterUPDATE_VOLUME_TO_DEVICE(OUT parameterStringforVolume, IN size1, IN (absoluteVolumeSupportValues.currentVolumeReceivedFromAudio));
                                if( MP_NO_ERROR != Result )
                                {
                                    ETG_TRACE_ERR(("Error while preparing parameter string"));
                                }
                                else
                                {
                                    Result = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "UPDATE_VOLUME_TO_DEVICE", IN parameterStringforVolume);
                                    if( MP_NO_ERROR != Result )
                                    {
                                        ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    else
    {
        ETG_TRACE_USR1(("Error :Empty String"));
    }

}

void BTDaemonProxy::AvpNotifyChgSignal(const char* params)
{
    ENTRY
    if(strlen_r(params))
    {
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);

        //Find the EventId
        tEventId eventId = 0;
        tArrayLength arrayLength = 0;

        //Find the NetworkOrder
        tNetworkOrder networkOrder = FALSE;

        //Variables to Parse the String
        tByteArray pData = NULL;
        tByteArray pDataAddr = NULL;

        //Find the Array Length
        ETG_TRACE_USR4(("params:%s",params));

        sscanf(params,"%u,%u,%u,%p",&eventId,&networkOrder,&arrayLength,&pData);
        pDataAddr = pData;

        switch(eventId)
        {
            case ALPS_EVENT_PLAYBACK_STATUS_CHANGED:
            {
                ETG_TRACE_USR1(("Received ALPS_EVENT_PLAYBACK_STATUS_CHANGED event"));

                if(EVENT_PLAYBACK_STATUS_CHANGED_ARRAY_LENGTH  == arrayLength)
                {
                    ETG_TRACE_USR1(("EVENT_PLAYBACK_STATUS_CHANGED_ARRAY_LENGTH  == arrayLength"));
                    //Parameter to Get Current BT Playback State
                    tBTPlayStatus btPlayStatus = BT_PS_ERROR;

                    btPlayStatus = (tBTPlayStatus)*pData;

                    switch(btPlayStatus)
                    {
                        case BT_PS_STOPPED:
                            ETG_TRACE_USR1(("BTPlayStatus is BT_PS_STOPPED"));
                            mPlaybackState = PE_PBS_STOPPEDSTATE;
                            break;

                        case BT_PS_PLAYING:
                            ETG_TRACE_USR1(("BTPlayStatus is BT_PS_PLAYING"));
                            mPlaybackState = PE_PBS_PLAYINGSTATE;
                            break;

                        case BT_PS_PAUSED:
                            ETG_TRACE_USR1(("BTPlayStatus is BT_PS_PAUSED"));
                            mPlaybackState = PE_PBS_PAUSEDSTATE;
                            break;

                        case BT_PS_ERROR:
                            ETG_TRACE_USR1(("BTPlayStatus is BT_PS_ERROR"));
                            mPlaybackState = PE_PBS_ERRORSTATE ;
                            break;
                        case  BT_PS_FWDSEEK:
                            ETG_TRACE_USR1(("BTPlayStatus is BT_PS_FWDSEEK"));
                            mPlaybackState = PE_PBS_FASTFORWARDSTATE ;
                            break;
                        case  BT_PS_REVSEEK:
                            ETG_TRACE_USR1(("BTPlayStatus is BT_PS_REVSEEK"));
                            mPlaybackState = PE_PBS_FASTREVERSESTATE;
                            break;
                        default:
                            break;

                    }

                    tObjectID ObjectID = OBJECT_ID_NONE;
                    tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString,IN size,IN mPlaybackState, IN mNowPlayingMetadata1,IN mNowPlayingMetadata2,IN mNowPlayingMetadata3,IN mNowPlayingMetadata4,IN ObjectID);

                    if( MP_NO_ERROR != ret )
                    {
                        ETG_TRACE_ERR(("Error while preparing parameter string"));
                    }

                    ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "PLAYBACK_STATUS_RESPONSE", IN parameterString);

                    if( MP_NO_ERROR != ret )
                    {
                        ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                    }
                }
                else
                {
                    ETG_TRACE_USR1(("EVENT_PLAYBACK_STATUS_CHANGED_ARRAY_LENGTH  != arrayLength"));
                }
                DeleteMemoryAllocated(pDataAddr,arrayLength);

                if(mIsBTDeviceControlActive)
                {
                    mBTActivePlaybackstate = mPlaybackState;
                }
                //Store the latest playback state received from the device.Which will helps to avoid sending PLAY command to device if it is already in playing state.
                mLatestPlaybackStateFromDevice = mPlaybackState;
            }
            break;
            case ALPS_EVENT_TRACK_CHANGED:
            {
                ETG_TRACE_USR1(("Received ALPS_EVENT_TRACK_CHANGED event"));
                DeleteMemoryAllocated(pDataAddr,arrayLength);

                /*1.To avoid REMOTE_ACTIVITY if TRACK_CHANGE Happened
                 *      & metadata being updated to BTControl Statemachine
                 *      while a Playing BT Device Connected over BT & Current Source being FM
                 *2.Avoid Metadata retrieval on TRACK_CHANGED while BT Not Being active source*/
                if(!mIsBTDeviceControlActive) return;
                RequestMetadata();
            }
            break;
#if 0
            case  ALPS_EVENT_PLAYBACK_POS_CHANGED:
            {
                if(EVENT_PLAYBACK_POS_CHANGED_ARRAY_LENGTH == arrayLength)
                {
                    tPlaytime elapsedPlayTime = 0;
                    tPlaytime totalPlayTime = 0;
                    char *Byte = NULL;

                    //This looping happens for 4 times until the Elapsed time U32 retrieved
                    for(itr =0;itr < EVENT_PLAYBACK_POS_CHANGED_ARRAY_LENGTH ;itr++)
                    {
                        match = strchr(Array_Parser,',');
                        if(match != NULL)
                        {
                            //Parsing the string and push the byte prepared into the ByteArray
                            Byte= new char[(match-Array_Parser)+1];
                            memset(Byte,0,(match-Array_Parser)+1);
                            memcpy(Byte,Array_Parser,(match-Array_Parser));
                            memset(&Byte[match-Array_Parser],'\0',1);
                            ETG_TRACE_USR1(("atoi is %d",atoi(Byte)));
                            NowPlayingItemUID[itr] =(unsigned char)atoi(Byte);

                            //Make the pointer ByteArray_Parser to point to the parse and Find the Next byte
                            Array_Parser += (match-Array_Parser+1);
                            delete[] Byte;
                        }
                        else
                        {
                            ETG_TRACE_USR1(("match is NULL"));
                            return;
                        }

                        match = NULL;
                    }
                    elapsedPlaytime = (tPlaytime)atoi(params);
                    ETG_TRACE_USR1(("ElapsedPlaytime is %d sec\n",elapsedPlaytime/1000));

                    tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterTICK_TIME_ELAPSED(OUT parameterString, IN size, IN elapsedPlaytime, IN totalPlaytime);
                    if( MP_NO_ERROR != ret )
                    {
                        ETG_TRACE_ERR(("Error while preparing parameter string"));
                    }
                    else
                    {
                        //ret = LocalSPM::GetInstance().GetBTControl().SendEventByName("TICK_TIME_ELAPSED", IN parameterString);
                        ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "TICK_TIME_ELAPSED", IN parameterString);
                        if( MP_NO_ERROR != ret )
                        {
                            ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                        }
                    }
                }
                else
                {
                    DeleteMemoryAllocated(pDataAddr,arrayLength);
                    return;
                }
            }
            break;
#endif
            case  ALPS_EVENT_PLAYER_APPLICATION_SETTING_CHANGED: //todo:Complete Forwarding the AttributeMode & its current Value
            {
                ETG_TRACE_USR1(("Received ALPS_EVENT_PLAYER_APPLICATION_SETTING_CHANGED event"));
                if(!mIsBTDeviceControlActive)
                {
                    DeleteMemoryAllocated(pDataAddr,arrayLength);
                    return;
                }

                //Number of Attributes
                tNumAttributes numAttributes = 0;
                numAttributes =(tNumAttributes)*pData;
                ETG_TRACE_USR1(("numAttributes is %d",numAttributes));
                pData++;

                //Decrement the ArrayLength as NumAttributes is retrieved
                tArrayLength remainingLength = arrayLength - 1;

                tArrayLength arrayLengthExpected = numAttributes * EVENT_APPLICATION_SETTING_CHANGED_ARRAY_LENGTH;

                if(numAttributes < 1 || numAttributes > ATTRIBUTES_COUNT)
                {
                    ETG_TRACE_USR1(("numAttributes is not within range"));
                    DeleteMemoryAllocated(pDataAddr,arrayLength);
                    return;
                }
                else
                {
                    if(arrayLengthExpected == remainingLength)
                    {
                        ETG_TRACE_USR1(("arrayLengthExpected == remainingLength"));

                        char *attributeId = NULL;
                        char *attributeValue = NULL;
                        int idIndex     = 0;
                        int valueIndex = 0;

                        attributeId =     new char[numAttributes];
                        attributeValue =  new char[numAttributes];

                        tPlaybackMode playbackMode = PBM_INVALID;
                        tRepeatMode repeatMode = RPT_INVALID;
                        if(attributeId != NULL)
                        {
                            memset(attributeId,0,numAttributes);
                        }
                        if(attributeValue != NULL)
                        {
                            memset(attributeValue,0,numAttributes);
                        }

                        unsigned int itr;
                        for(itr =0;itr< remainingLength;itr++)
                        {
                            //Parsing the string and push the byte prepared into the ByteArray

                            if(itr%2)
                            {
                                attributeValue[valueIndex] = *pData;
                                valueIndex++;
                                pData++;
                            }
                            else
                            {
                                attributeId[idIndex] = *pData;
                                idIndex++;
                                pData++;
                                //Make the pointer ByteArray_Parser to point to the parse and Find the Next byte

                            }
                        }
                        for(itr =0;itr < numAttributes;itr++)
                        {
                            ETG_TRACE_USR1(("attributeId[%d] is %d\n",itr,attributeId[itr]));
                            ETG_TRACE_USR1(("attributeValue[%d] is %d\n",itr,attributeValue[itr]));

                            if((LocalSPM::GetDataProvider().AVRCPLowerProfileSupported()) &&
                                    ALPS_ATTR_REPEAT ==(tBTPlayerSettingAttributeMode)attributeId[itr])
                            {
                                switch(attributeValue[itr])
                                {
                                    case ALPS_REPEAT_OFF:
                                        repeatMode = RPT_NONE;
                                        break;
                                    case ALPS_REPEAT_SINGLE:
                                        repeatMode = RPT_ONE;
                                        break;

                                    case ALPS_REPEAT_ALL:
                                        repeatMode = RPT_LIST;
                                        break;

                                    case ALPS_REPEAT_GROUP: //Currently Devices doesnt support this value
                                    default:
                                        break;
                                }
                                if(repeatMode != RPT_INVALID)
                                {
                                    LocalSPM::GetInstance().GetBTControl().ForwardRepeatModeStatus(repeatMode);
                                }
                            }
                            else if(ALPS_ATTR_SHUFFEL ==(tBTPlayerSettingAttributeMode)attributeId[itr]) //lint !e826  To suprress LintInfo 826 as the conversion is purposefully done
                            {
                                switch(attributeValue[itr])
                                {
                                    case ALPS_SHUFFLE_OFF:
                                        playbackMode = PBM_NORMAL;
                                        break;

                                    case ALPS_SHUFFLE_ALL:
                                        playbackMode = PBM_RANDOM;
                                        break;

                                    case ALPS_SHUFFLE_GROUP: //Currently Devices doesnt support this value
                                    default:
                                        break;
                                }
                                if(playbackMode != PBM_INVALID)
                                {
                                    LocalSPM::GetInstance().GetBTControl().ForwardPlaybackModeStatus(playbackMode);
                                }
                            }
                        }
                        delete[] attributeValue;
                        delete[] attributeId;
                        DeleteMemoryAllocated(pDataAddr,arrayLength);
                    }
                    else
                    {
                        ETG_TRACE_USR1(("ArrayLength_Expected != arrayLength"));
                        DeleteMemoryAllocated(pDataAddr,arrayLength);
                        return;
                    }
                }
            }
            break;
            case ALPS_EVENT_ADDRESSED_PLAYER_CHANGED :
            {
                if(EVENT_ADDRESSED_PLAYER_CHANGED_ARRAY_LENGTH  == arrayLength)
                {
                    ETG_TRACE_USR1(("EVENT_ADDRESSED_PLAYER_CHANGED_ARRAY_LENGTH  == arrayLength"));
                    tPlayerId playerId = (tPlayerId)(*((short*)pData)); //lint !e826  To suprress LintInfo 826 as the conversion is purposefully done
                    playerId = ntohs(playerId);

                    // Avoid sending  AVP_CHANGE_BROWSE_PLAYER if the new playerid is same as currentPlayerId.
                    tPlayerId currentPlayerId = 0;
                    LocalSPM::GetInstance().GetBTControl().GetPlayerId(OUT currentPlayerId);
                    if(currentPlayerId != playerId)
                    {
                        std::string Temp;
                        stringstream ss;
                        ss << playerId;
                        Temp=ss.str();
                        tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_CHANGE_BROWSE_PLAYER(OUT parameterString, IN size, IN Temp.c_str());
                        if( MP_NO_ERROR != ret )
                        {
                            ETG_TRACE_ERR(("Error while preparing parameter string"));
                        }
                        else
                        {
                            ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_CHANGE_BROWSE_PLAYER", IN parameterString);
                            if( MP_NO_ERROR != ret )
                            {
                                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                            }
                        }
                    }
                }
                else
                {
                    ETG_TRACE_USR1(("EVENT_ADDRESSED_PLAYER_CHANGED_ARRAY_LENGTH  != arrayLength"));
                }
                DeleteMemoryAllocated(pDataAddr,arrayLength);
            }
            break;
            default:
                break;
        }
    }
    else
    {
        ETG_TRACE_USR1(("Empty String"));
    }
}

void BTDaemonProxy::AvpPlayStatusSignal(const char* params)
{
    ENTRY

    tBTMethodRequestStatus status;
    tPlaytime elapsedTime;
    tPlaytime totalTime;
    tBTPlayStatus playStatus = BT_PS_ERROR;
    tResult ret = MP_NO_ERROR;

    //Variable to Send via PLAYBACK_STATUS_RESPONSE Event to BTControl Component
    tAllParameters parameterString_1;
    size_t size_1 = sizeof(parameterString_1);

    /*Send TickTime update**/
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    sscanf(params, "%u,%u,%u,%u", &status, &totalTime, &elapsedTime ,&playStatus);
    ETG_TRACE_USR1(("AvpPlayStatusSignal status:%d,totalTime:%d,elapsedTime:%d,playStatus:%d",status,totalTime,elapsedTime,playStatus));

    if((mPlaybackState!= PE_PBS_PLAYINGSTATE) && (BT_PS_PLAYING == playStatus))
    {
        mPlaybackState = PE_PBS_PLAYINGSTATE;
        mLatestPlaybackStateFromDevice = PE_PBS_PLAYINGSTATE;

        /*HMI Showing Paused State.But tick time gets updated.When reconnecting a Phone which is already playing over its speakers.
        ,very first AvpPlayStatus Received after AvpGetmetadataAttrMethodReturn Called.*/
        if(mIsBTDeviceControlActive)
        {
            tObjectID ObjectID = OBJECT_ID_NONE;
            ret = LocalSPM::GetInstance().GetBTControl().ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString_1,IN size_1,IN mPlaybackState,IN mNowPlayingMetadata1,IN mNowPlayingMetadata2,IN mNowPlayingMetadata3,IN mNowPlayingMetadata4,IN ObjectID);
            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while preparing parameter string"));
            }
            else
            {
                ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "PLAYBACK_STATUS_RESPONSE", IN parameterString_1);
                if( MP_NO_ERROR != ret )
                {
                    ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                }
                else
                {
                }
            }
        }
        else
        {
            //Do Nothing
        }
    }
    else
    {
        //Do Nothing
    }
#if 0
    /*The Phone playing via its Speaker if connected via BT,then it should be paused*/
    if(mPlaybackState != PE_PBS_PLAYINGSTATE && BT_PS_PLAYING == playStatus && false == mIsPauseSent)
    {
        AvpCtrlCmd(BT_CMD_PAUSE,BUTTON_CLICK);
        mIsPauseSent = true;
        return;
    }
#endif

    ret = LocalSPM::GetInstance().GetBTControl().ParameterTICK_TIME_ELAPSED(OUT parameterString, IN size, IN elapsedTime, IN totalTime);
    if( MP_NO_ERROR != ret )
    {
        ETG_TRACE_ERR(("Error while preparing parameter string"));
    }
    else
    {
        //ret = LocalSPM::GetInstance().GetBTControl().SendEventByName("TICK_TIME_ELAPSED", IN parameterString);
        ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "TICK_TIME_ELAPSED", IN parameterString);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while sending internal event via SMF"));
        }
        else
        {
        }
    }
}

void BTDaemonProxy::AvpCtrlCmdIndSignal(const char* params)
{
    ENTRY

    tBTControlCmd command;
    sscanf(params, "%u",&command);
    ETG_TRACE_USR1(("AvpCtrlCmdIndSignal command is %d",command));
#if 0
    switch(command)
    {
        case BT_CMD_MEDIASUSPEND:
            mPlaybackState = PE_PBS_PAUSEDSTATE;
            break;
        case BT_CMD_MEDIARESUME:
            mPlaybackState = PE_PBS_PLAYINGSTATE;
            break;
        case BT_CMD_UNUSED:
        case BT_CMD_STOP:
        case BT_CMD_PLAY:
        case BT_CMD_PAUSE:
        case BT_CMD_NEXTTRACK:
        case BT_CMD_PREVTRACK:
        case BT_CMD_FORWARD:
        case BT_CMD_REWIND:
        case BT_CMD_RESERVED1:
        case BT_CMD_RESERVED2:
            break;
        default:
            break;
    }
#endif

}
void BTDaemonProxy::AvpPlayItem(tScope scope,tItemUID itemUID)
{
    ENTRY;
    tInteger serial = 0;
    if (!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        tUInt itr ;
        unsigned char itemUID_With_Length[9] = {8,0,0,0,0,0,0,0,0};

        memcpy(&itemUID_With_Length[1],itemUID,8);

        for(itr =0;itr<9;itr++)
        {
            ETG_TRACE_USR3(("itemUID_With_Length[%d] is %d",itr,itemUID_With_Length[itr]));
        }

        /* Send AvpChangePath to Alps-bt-daemon via DBUS */
        serial = LocalSPM::GetIPCProvider().MethodCall(ipc_AlpsBTDaemon_AvpPlayItem, IN (unsigned char) scope,
                IN itemUID_With_Length);
    }
    else
    {
        tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
        if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint) != string::npos))
        {
            serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Evolution_PlayItem);
        }
    }
    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
    }
    else
    {
        mMessageHandlersMutex.lock();
        mMessageHandlers[serial] = &BTDaemonProxy::AvpPlayItemMethodReturn;
        mMessageHandlersMutex.unlock();
    }
}

void BTDaemonProxy::AvpPlayItemMethodReturn(const char* params,bool isError)
{
    ENTRY;
    tBTMethodRequestStatus status = REQ_NOT_OK;

    if(isError)
    {
        ETG_TRACE_ERR(("AvpPlayItem Failed with error %s",params));
    }
    else
    {
        if(LocalSPM::GetDataProvider().UseEvolutionBtStack()) //Fix for NCG3D-41571 - Not getting TrackChanged update always.So RequestMetadata.
        {
            RequestMetadata();
        }
        else if(strlen_r(params))
        {
            //Find the Status of Response
            status =(tBTMethodRequestStatus)atoi(params);
            ETG_TRACE_USR1(("status is %d",status));
            if(REQ_OK == status)
            {
                RequestMetadata();
            }
        }
        else
        {
            //Do Nothing
        }
    }
    LocalSPM::GetInstance().GetBTControl().AvpPlayItemMethodReturn(status); //FIXME or remove?: BTControl dependencies
}

tResult BTDaemonProxy::RegisterForBTSignals()
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    if(LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        ret = LocalSPM::GetIPCProvider().IpcClient::SetFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.freedesktop.DBus.Properties'");
    }
    else{
        ret = LocalSPM::GetIPCProvider().IpcClient::SetFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='com.alps.bt.Audiovisual'");
    }
    return ret;
}

tResult BTDaemonProxy::UnRegisterForBTSignals()
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    setPlaybackState(PE_PBS_LOADINGSTATE);
    mBTActivePlaybackstate = PE_PBS_LOADINGSTATE;
    mLatestPlaybackStateFromDevice = PE_PBS_LOADINGSTATE;
    mStatusBeforeForwardRewind = PE_PBS_UNKNOWN;
    //mIsPauseSent = false;
    if(LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        ret = LocalSPM::GetIPCProvider().IpcClient::RemoveFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.freedesktop.DBus.Properties'");
    }else
    {
        ret = LocalSPM::GetIPCProvider().IpcClient::RemoveFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='com.alps.bt.Audiovisual'");
    }
    return ret;
}

tResult BTDaemonProxy::SwitchObserver(const tDeviceType smName)
{
    ENTRY;
    VARTRACE(smName);

    tResult ret = MP_NO_ERROR;

    if(mSMObserver != smName)
    {
        mSMObserver = smName;
    }

    return ret;
}

unsigned char BTDaemonProxy::getHexInDecimal( unsigned char ch )
{
    if ( ch >= 'A' && ch <= 'F' )
        return( ch - 55 );

    if ( ch >= 'a' && ch <= 'f' )
        return( ch - 87 );

    if ( ch >= '0' && ch <= '9' )
        return( ch - 48 );

    return 0;

}
void BTDaemonProxy::GetNowPlayingMetadata(tMetadata &metadata1,tMetadata &metadata2,tMetadata &metadata3,tMetadata &metadata4)
{
    ENTRY;
    strncpy_r(metadata1,mNowPlayingMetadata1,sizeof(metadata1));
    strncpy_r(metadata2,mNowPlayingMetadata2,sizeof(metadata2));
    strncpy_r(metadata3,mNowPlayingMetadata3,sizeof(metadata3));
    strncpy_r(metadata4,mNowPlayingMetadata4,sizeof(metadata4));
}
void BTDaemonProxy::AvpListShuffleModeValMethodReturn(const char* params,bool isError)
{
    ENTRY
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    tBTMethodRequestStatus status = REQ_NOT_OK;
    tArrayLength arrayLength = 0;
    tByteArray pData = NULL;
    tCurrentValue currentValue = 0;
    if(isError)
    {
        ETG_TRACE_ERR(("AvpListVal-Shuffle Failed with error %s",params));
    }
    else
    {
        if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
        {
            sscanf(params,"%u,%u,%p,%u",&status,&arrayLength,&pData,&currentValue);
        }
        else
        {
            status = REQ_OK;
            std::string strFromChar;
            strFromChar.append(params);
            std::istringstream ss(strFromChar);
            std::string token1;
            currentValue = ALPS_SHUFFLE_OFF;
            std::getline(ss, token1, IPC_DBUS_PARAM_DELIMITER_CHAR);
            //std::getline(ss, token1, IPC_DBUS_PARAM_DELIMITER_CHAR);
            if(0==token1.compare("Alltracks"))
            {
                currentValue=ALPS_SHUFFLE_ALL;
            }else if(0==token1.compare("Off"))
            {
                currentValue=ALPS_SHUFFLE_OFF;
            }
        }
    }
        tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_LIST_VAL_METHOD_RETURN(OUT parameterString,IN size,IN status,IN ALPS_ATTR_SHUFFEL, IN pData,IN arrayLength,IN currentValue,IN (tErrorMessage)NULL);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string"));
        }
        else
        {
            ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_LIST_VAL_METHOD_RETURN", IN parameterString);

            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
            }
        }
    }
void BTDaemonProxy::AvpListRepeatModeValMethodReturn(const char* params,bool isError)
{
    ENTRY

    tBTMethodRequestStatus status = REQ_NOT_OK;
    tArrayLength arrayLength = 0;
    tByteArray pData = NULL;
    tCurrentValue currentValue = 0;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);
    if(params!=NULL && isError)
    {
        ETG_TRACE_ERR(("AvpListVal-Repeat Failed with error %s",params));
    }
    else
    {

        if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
        {
            sscanf(params,"%u,%u,%p,%u",&status,&arrayLength,&pData,&currentValue);
        }
        else
        {
            status = REQ_OK;
            std::string strFromChar;
            strFromChar.append(params);
            std::istringstream ss(strFromChar);
            std::string token1;
            std::getline(ss, token1, IPC_DBUS_PARAM_DELIMITER_CHAR);
            //std::getline(ss, token1, IPC_DBUS_PARAM_DELIMITER_CHAR);
            currentValue = ALPS_REPEAT_OFF;
            if(0==token1.compare("Alltracks"))
            {
                currentValue=ALPS_REPEAT_GROUP;
            }else if(0==token1.compare("Singletrack"))
            {
                currentValue=ALPS_REPEAT_SINGLE;
            }else if(0==token1.compare("Off"))
            {
                currentValue=ALPS_REPEAT_OFF;
            }
        }
    }
        tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterAVP_LIST_VAL_METHOD_RETURN(OUT parameterString,IN size,IN status,IN ALPS_ATTR_REPEAT,IN pData,IN arrayLength,IN currentValue,IN (tErrorMessage)NULL);
        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string"));
        }
        else
        {
            ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "AVP_LIST_VAL_METHOD_RETURN", IN parameterString);

            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
            }
        }
    }
void BTDaemonProxy::UpdateBTDeviceControlState(tBoolean IsActive)
{
    ENTRY
    mIsBTDeviceControlActive = IsActive;
}

void BTDaemonProxy::CleanupNowPlayingMetadata()
{
    ENTRY
    /*clean up previous metadata*/
    memset(mNowPlayingMetadata1,0,sizeof(mNowPlayingMetadata1));
    memset(mNowPlayingMetadata2,0,sizeof(mNowPlayingMetadata2));
    memset(mNowPlayingMetadata3,0,sizeof(mNowPlayingMetadata3));
    memset(mNowPlayingMetadata4,0,sizeof(mNowPlayingMetadata4));
    mtotalPlayTime = PLAYTIME_NONE;
    SetElapsedPlayTime(PLAYTIME_NONE);
    mObjectID = OBJECT_ID_NONE;
    mNowPlayingAlbumArtHandle.clear();
    mNowPlayingObjectPath.clear();
}

void BTDaemonProxy::DeleteMemoryAllocated(tByteArray &pDataAddr,tArrayLength &arrayLength)
{
    //ENTRY
    if (pDataAddr != NULL && arrayLength > 0)
    {
        delete[] pDataAddr;
    }
    else
    {
        //Do nothing
    }
}

void BTDaemonProxy::ClearDeviceInfoflags()
{
    ENTRY

    setPlaybackState(PE_PBS_LOADINGSTATE);
    mBTActivePlaybackstate = PE_PBS_LOADINGSTATE;
    mLatestPlaybackStateFromDevice = PE_PBS_LOADINGSTATE;
    mStatusBeforeForwardRewind = PE_PBS_UNKNOWN;
    mEventsSupported = 0;
    CleanupNowPlayingMetadata();
    InitBTPlayerInfo(mPlayerInfo);
    if(GetTaskSyncSemWaitFolderItem())
    {
        sem_post(&m_GetFolderItemSyncSem);
    }
    if(GetTaskSyncSemWaitChangeFolder())
    {
        sem_post(&m_ChangeFolderSyncSem);
    }
    LocalSPM::GetDataProvider().AbsoluteVolumeSupportForBTDevice = 0;
    mObjectPathForAbsoluteVolume = "";
    tAbsoluteVolumeSupportValues absoluteVolumeSupportValues;
    absoluteVolumeSupportValues = GetAbsoluteVolumeSupportValues();
    if(absoluteVolumeSupportValues.waitingForVolumeUpdate)
    {
        StopAbsoluteVolumeWaitTimer();
    }
    tAbsoluteVolumeSupportVariables absoluteVolumeSupportVariables = SET_ALL_TO_DEFAULT;
    int Volume = INVALID_VOLUME;
    SetAbsoluteVolumeSupportValues(absoluteVolumeSupportVariables,Volume);
}

void BTDaemonProxy::AvpTrackChangedSignal(const char* params)
{
    ENTRY

    if (params != NULL)
    {
        ETG_TRACE_USR3(("BTDaemonProxy::AvpTrackChangedSignal received string :%s",params));
        RequestMetadata();

        /* Task 317554 Album art extraction from BT device supporting AVRCP1.6 */
        if(LocalSPM::GetDataProvider().EnableBTNowPlayingCoverArt())
        {
            LocalSPM::GetInstance().GetBTControl().ClearCoverArtInfo();
            LocalSPM::GetInstance().GetBTControl().SendEventByName("TRACK_CHANGED", IN NULL);
        }
    }
}
void BTDaemonProxy::GetLastActivePlaybackState(tPEPlaybackState &Playbackstate)
{
    ENTRY
    Playbackstate = mBTActivePlaybackstate;
}
void BTDaemonProxy::SetLastActivePlaybackState(tPEPlaybackState Playbackstate)
{
    ENTRY
    mBTActivePlaybackstate = Playbackstate;

}
void BTDaemonProxy::GetLatestPlaybackStateFromDevice(tPEPlaybackState &Playbackstate)
{
    ENTRY
    Playbackstate = mLatestPlaybackStateFromDevice;
}
void BTDaemonProxy::OverrideEvoObjectPaths(string playerName)
{
    ENTRY
    LocalSPM::GetIPCProvider().OverridePath(IPC_EVOLUTION_INTERFACE,playerName.c_str());
    LocalSPM::GetIPCProvider().OverridePath(IPC_EVOLUTION_MEDIAFOLER_INTERFACE,playerName.c_str());
    LocalSPM::GetIPCProvider().OverridePath(IPC_EVOLUTION_PROPERTY_INTERFACE,playerName.c_str());
}
void BTDaemonProxy::NowPlayingContentSignal(const char* params)
{
    ENTRY

    //Avoid sending the event to BTControlSM if the device is connected via IAP2BT.
    tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
    if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (params != NULL))
    {
        ETG_TRACE_USR3(("BTDaemonProxy::NowPlayingContentSignal received string :%s",params));
        LocalSPM::GetInstance().GetBTControl().SendEventByName("NOW_PLAYING_CONTENT_CHANGED", IN NULL);
#if 0
        //Clear the NowPlaying path in the Cache.
        extern void BTCacheEraseNowplaying();
        BTCacheEraseNowplaying();
#endif
    }
}
tPEPlaybackState BTDaemonProxy::GetNowPlayingStatus()
{
    ENTRY
    tPEPlaybackState CurrentPlaybackState =  PE_PBS_LOADINGSTATE;
    bool isSystemBus =1;
    int reply_timeout = 2000;
    bool isError;
    string result = "";
    DbusParam interfaceNameParam;
    interfaceNameParam.type = DBUS_TYPE_STRING;
    interfaceNameParam.value.append(IPC_EVOLUTION_INTERFACE);
    DbusParam propertyNameParam;
    propertyNameParam.type = DBUS_TYPE_STRING;
    propertyNameParam.value.append("Status");

    DbusParamList dbusParamList;
    dbusParamList.push_back(interfaceNameParam);
    dbusParamList.push_back(propertyNameParam);
    tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
    if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint) != string::npos) && (mPlayerInfo.objectPath.find("/dev_") != string::npos))
    {
        LocalSPM::GetIPCProvider().MethodCallWaitForReply(ipc_Evolution_Get, IN dbusParamList,isSystemBus,reply_timeout,isError,result);
    }
    else
    {
        ETG_TRACE_USR3(("BTDaemonProxy::GetNowPlayingStatus NowPlaying status cannot be requested with invalid object path"));
    }
    if(result.find("Playing")!= string::npos)
    {
        CurrentPlaybackState = PE_PBS_PLAYINGSTATE;
    }
    else if(result.find("Paused")!= string::npos)
    {
        CurrentPlaybackState = PE_PBS_PAUSEDSTATE;
    }
    VARTRACE(result.c_str());
    return CurrentPlaybackState;
}

tResult BTDaemonProxy::GetPlayerAttributes(tBTMethodRequestStatus &status,tPlayerAttributes &SupportedAttributes)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    bool isError=false;
    string result;
    int reply_timeout = 500;
    bool isSystemBus = true;

    InitPlayerAttributes(SupportedAttributes);

    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        DbusParamList dbusParamList1;

        const IpcMessageInfo ipcMessageInfo = {"com.alps.bt",IPC_ALPS_BTDAEMON_PATH,IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE,"AvpListAttr"};
        LocalSPM::GetIPCProvider().MethodCallWaitForReply(ipcMessageInfo, IN dbusParamList1,isSystemBus,reply_timeout,isError,result,true);

        if(isError || result.empty())
            return MP_ERR_DBUS;

        const char* tempParam = result.c_str();

        status = REQ_NOT_OK;
        tAttributesBit attributesBit = 0;

        if(tempParam!=NULL && strlen_r(tempParam))
        {
            sscanf(tempParam,"%u,%u",&status,&attributesBit);
        }

        if(REQ_NOT_OK == status)
        {
            return -1;
        }
        if(BITFLAG_SHUFFEL & attributesBit)
        {
            SupportedAttributes.Shuffle.AttributeSupported = true;
            ret = GetAttributeValue(ALPS_ATTR_SHUFFEL,SupportedAttributes.Shuffle.value);
        }
        if(BITFLAG_REPEAT & attributesBit)
        {
            SupportedAttributes.Repeat.AttributeSupported = true;
            ret = GetAttributeValue(ALPS_ATTR_REPEAT,SupportedAttributes.Repeat.value);

        }
    }
    else
    {
        tBoolean IsShuffleSupported = AvpIsShuffleSupported();
        if(IsShuffleSupported)
        {
            SupportedAttributes.Shuffle.AttributeSupported = true;
            int playbackMode = AvpGetShuffleValue();
            SupportedAttributes.Shuffle.value = playbackMode;
            ETG_TRACE_USR4(("ShuffleValue is : %d",SupportedAttributes.Shuffle.value ));
        }

        tBoolean IsRepeatSupported = AvpIsRepeatSupported();
        if(IsRepeatSupported)
        {


            SupportedAttributes.Repeat.AttributeSupported = true;
            int repeatMode = AvpGetRepeatValue();
            SupportedAttributes.Repeat.value = repeatMode;
            ETG_TRACE_USR4(("RepeatValue is : %d",SupportedAttributes.Repeat.value ));
        }
    }
    return ret;
}


tResult BTDaemonProxy::GetSupportedAvpNotifications(tCapabilityId capabilityId,tBTMethodRequestStatus &status,tEventsSupported &EventsSupported)
{

    ENTRY
    tResult ret = MP_NO_ERROR;


    bool isError=false;
    string result;
    int reply_timeout = 500;
    bool isSystemBus = true;


    DbusParam dbusPa;
    DbusParamList dbusParamList1;


    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        dbusPa.type = DBUS_TYPE_BYTE;
        std::stringstream ss;
        ss<<EVENTS_SUPPORTED;
        dbusPa.value.append(ss.str());
        dbusParamList1.push_back(dbusPa);

        const IpcMessageInfo ipcMessageInfo = {"com.alps.bt",IPC_ALPS_BTDAEMON_PATH,IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE,"AvpGetCapabilities"};
        LocalSPM::GetIPCProvider().MethodCallWaitForReply(ipcMessageInfo, IN dbusParamList1,isSystemBus,reply_timeout,isError,result,true);

    }
    else
    {

    }
    if(isError || result.empty())
    {
        ETG_TRACE_ERR(("AvpGetCapabilities Failed with error"));
        return MP_ERR_DBUS;
    }
    const char* tempParam = result.c_str();

    status = REQ_NOT_OK;
    capabilityId = 0;


    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        if(strlen_r(tempParam))
        {
            sscanf(tempParam,"%u,%u,%u",&status,&capabilityId,&EventsSupported);
        }
        else
        {
            //Do nothing
        }
    }
    else
    {

    }

    return ret;
}


tResult BTDaemonProxy::SetupPlayerForBrowsing(string playerName , tNumOfItems &numOfItems)
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    //VARTRACE(playerName);

    numOfItems = 0;
    bool isError=false;
    string result;
    int reply_timeout = 4000;
    bool isSystemBus = true;

    if(playerName.empty())
        return -1;

    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        tPlayerId playerId = (tPlayerId)stoi(playerName);
        tPlayerMode PlayerMode = BROWSED_PLAYER;

        DbusParam dbusPa1,dbusPa2;

        dbusPa1.type = DBUS_TYPE_UINT32;
        std::stringstream ss1;
        ss1<<playerId;
        dbusPa1.value.append(ss1.str());

        dbusPa2.type = DBUS_TYPE_BYTE;
        std::stringstream ss2;
        ss2<<PlayerMode;
        dbusPa2.value.append(ss2.str());


        DbusParamList dbusParamList1;
        dbusParamList1.push_back(dbusPa1);
        dbusParamList1.push_back(dbusPa2);

        const IpcMessageInfo ipcMessageInfo1 = {"com.alps.bt",IPC_ALPS_BTDAEMON_PATH,IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE,"AvpSetPlayer"};
        LocalSPM::GetIPCProvider().MethodCallWaitForReply(ipcMessageInfo1, IN dbusParamList1,isSystemBus,reply_timeout,isError,result,true);

        if(isError || result.empty())
            return MP_ERR_DBUS;

        const char* tempParam = result.c_str();

        tBTMethodRequestStatus status = REQ_NOT_SUPPORT;
        tDBAware dBAware = 0;

        if(strlen_r(tempParam))
        {
            sscanf(tempParam,"%u,%u,%u",&status,&numOfItems,&dBAware);
        }
    }
    else
    {
        DbusParamList dbusParamList1;

        ETG_TRACE_USR4(("object path %s",playerName.c_str()));
        tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
        if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (playerName.find(connectedDeviceInfo.mountPoint) != std::string::npos) && (false == mPlayerInfo.isSetBrowsedPlayerSuccess))
        {
        const IpcMessageInfo ipcMessageInfo1 = {"org.bluez",playerName.c_str(),IPC_EVOLUTION_INTERFACE,"SetBrowsedPlayer"};
        LocalSPM::GetIPCProvider().MethodCallWaitForReply(ipcMessageInfo1, IN dbusParamList1,isSystemBus,reply_timeout,isError,result);

        //Don't check result because SetBrowsedPlayer will not return anything.
        if(isError )
        {
            return MP_ERR_DBUS;
        }
        mPlayerInfo.isSetBrowsedPlayerSuccess = true;
        }

    }
    return ret;
}
tResult BTDaemonProxy::IsPlayerBrowsable(string playerName,tBoolean &isBrowsable)
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    // VARTRACE(playerName);
    isBrowsable = false;

    bool isError=false;
    string result;
    int reply_timeout = 1000;
    bool isSystemBus = true;

    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        tPlayerId playerId = (tPlayerId)stoi(playerName);

        DbusParam dbusPa;

        dbusPa.type = DBUS_TYPE_BYTE;
        std::stringstream ss;
        ss<<255;
        dbusPa.value.append(ss.str());


        DbusParamList dbusParamList1;
        dbusParamList1.push_back(dbusPa);

        const IpcMessageInfo ipcMessageInfo1 = {"com.alps.bt",IPC_ALPS_BTDAEMON_PATH,IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE,"AvpGetMediaPlayerItem"};
        LocalSPM::GetIPCProvider().MethodCallWaitForReply(ipcMessageInfo1, IN dbusParamList1,isSystemBus,reply_timeout,isError,result,true);

        if(isError || result.empty())
        {
            ETG_TRACE_USR4(("Error occurred while getting AvpGetMediaPlayerItem"));
            return MP_ERR_DBUS;
        }

        ETG_TRACE_USR4(("Result:%s",result.c_str()));

        const char* tempParam = result.c_str();

        tBTMethodRequestStatus status = REQ_NOT_OK;
        tNetworkOrder networkOrder= FALSE;
        tByteArray byteArray = NULL;
        tArrayLength arrayLength  = 0;

        sscanf(tempParam,"%u,%u,%u,%p",&status,&networkOrder,&arrayLength,&byteArray);

        ETG_TRACE_USR4(("Status:%d",status));
        ETG_TRACE_USR4(("NetworkOrder:%d",networkOrder));
        ETG_TRACE_USR4(("ArrayLength:%d",arrayLength));
        ETG_TRACE_USR4(("byteArray is %p",byteArray));


        if(REQ_OK == status)
        {
            if(arrayLength != 0)
            {
                struct MediaPlayer_Item_info *pMediaPlayerItemData = NULL;

                //Going to Find the Player Supports Browsing.
                do
                {
                    pMediaPlayerItemData = (struct MediaPlayer_Item_info*)byteArray; //lint !e826  To suprress LintInfo 826 as the conversion is purposefully done

                    if (MEDIAPLAYER == pMediaPlayerItemData->Item_Type)
                    {
                        ETG_TRACE_USR4(("MEDIAPLAYER Item found"));
                        if(networkOrder)
                        {
                            pMediaPlayerItemData->Item_Length = ntohs (pMediaPlayerItemData->Item_Length);
                            pMediaPlayerItemData->Player_ID   = ntohs (pMediaPlayerItemData->Player_ID);
                            pMediaPlayerItemData->Player_Sub_Type = ntohl(pMediaPlayerItemData->Player_Sub_Type);
                        }

                        if(playerId == pMediaPlayerItemData->Player_ID)
                        {
                            isBrowsable = *(byteArray + FEATURE_BIT_MASK_EIGTH_BYTE ) & BROWSE_SUPPORT_BIT;
                            break;
                        }
                    }
                    //Points to next item
                    byteArray = byteArray +SIZE_OF_ITEM_TYPE_CUM_LENGTH +pMediaPlayerItemData->Item_Length;
                    //Decrement the Length Param
                    arrayLength =arrayLength - (SIZE_OF_ITEM_TYPE_CUM_LENGTH + pMediaPlayerItemData->Item_Length);

                }while(arrayLength != 0);
            }

        }
    }
    else
    {
        string dbusObjectPath;
        dbusObjectPath = IPC_EVOLUTION_INTERFACE;
        DbusParam dbusParam;
        dbusParam.type = DBUS_TYPE_STRING;
        dbusParam.value.append(dbusObjectPath.c_str());
        DbusParamList dbusParamList;
        dbusParamList.push_back(dbusParam);

        tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();

        if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint) != string::npos) && (mPlayerInfo.objectPath.find("/dev_") != string::npos))
        {
            LocalSPM::GetIPCProvider().MethodCallWaitForReply(ipc_Evolution_Getall, IN dbusParamList,isSystemBus,reply_timeout,isError,result);
        }

        if(isError || result.empty())
        {
            ETG_TRACE_USR4(("Error occurred while getting AvpGetMediaPlayerItem"));
            return MP_ERR_DBUS;
        }

        ETG_TRACE_USR4(("Return result ptr:%s",result.c_str()));
        int literalCount = 0;
        const char* tempParam = result.c_str();

        char* ptr = (char*) strchr(tempParam,IPC_DBUS_PARAM_DELIMITER_INT);
        while (ptr != NULL)
        {
            ptr = strchr(ptr + 1,IPC_DBUS_PARAM_DELIMITER_INT);
            literalCount++;
        }
        std::istringstream ss1(result);

        std::string token1[literalCount];
        for (int index = 0; index < literalCount; index++)
        {
                std::getline(ss1, token1[index], IPC_DBUS_PARAM_DELIMITER_CHAR);
                ETG_TRACE_USR4(("Token :%s",token1[index].c_str()));
        }
        for (int index = 0; index < literalCount; index++)
        {
            if (token1[index].compare("Browsable") == 0)
            {

                if(token1[index+1] == "1")
                {
                    mPlayerInfo.isBrowsable = true;
                    isBrowsable = true;
                    index++;
                }
            }
            else if (token1[index].compare("Searchable") == 0)
            {
                if(token1[index+1] == "1")
                {
                    mPlayerInfo.isSearchable = true;
                }
                index++;
            }
            else if (token1[index].compare("DBAware") == 0)
            {
                if(token1[index+1] == "1")
                {
                    mPlayerInfo.isDBAware = true;
                }
                index++;
            }
        }
    }

    return ret;

}
tBoolean BTDaemonProxy::ResetBrowsePathToRoot(unsigned int numOfLevelUpNeeded)
{
    ENTRY

    tBTMethodRequestStatus status = REQ_NOT_OK;
    bool isSuccess =false;

    VARTRACE(numOfLevelUpNeeded);

    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        unsigned char itemUID_With_Length[9] = {8,0,0,0,0,0,0,0,0};
        bool isError= false;
        string result;
        int reply_timeout = 500;
        bool isSystemBus = true;

        DbusParam dbusPa1,dbusPa2;

        dbusPa1.type = DBUS_TYPE_BYTE ;
        std::stringstream ss;
        ss<<FOLDER_UP;
        dbusPa1.value.append(ss.str());

        dbusPa2.type = DBUS_TYPE_STRING;
        dbusPa2.value.append((const char*)itemUID_With_Length);

        DbusParamList dbusParamList1;
        dbusParamList1.push_back(dbusPa1);
        dbusParamList1.push_back(dbusPa2);

        // tStatus status = REQ_NOT_OK;
        tNumOfItems numberofitems = tNumOfItems_init;

        for(numOfLevelUpNeeded; numOfLevelUpNeeded > 0 ; numOfLevelUpNeeded--)
        {
            const IpcMessageInfo ipcMessageInfo1 = {"com.alps.bt",IPC_ALPS_BTDAEMON_PATH,IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE,"AvpChangePath"};
            LocalSPM::GetIPCProvider().MethodCallWaitForReply(ipcMessageInfo1, IN dbusParamList1,isSystemBus,reply_timeout,isError,result,true);
            const char *tempParam = result.c_str();

            if(isError){
                ETG_TRACE_ERR(("AvpChangePath Failed with error %s",tempParam));
                break;
            }
            else if(strlen_r(tempParam))
            {
                //Parse the Result to find Status & NumberOfItems in the new path
                sscanf(tempParam,"%u,%u",&status,&numberofitems);

                VARTRACE(status);
                VARTRACE(numberofitems);

                if(REQ_NOT_OK == status)
                    break;

            }
            else
            {
                break;
            }
        }

        if(!numOfLevelUpNeeded){
            isSuccess = true;
        }
    }
    else
    {
        //Evolution stack implementation needed
    }

    VARTRACE(isSuccess);

    return isSuccess;
}

tResult BTDaemonProxy::GetAttributeValue(tBTPlayerSettingAttributeMode attributeId, int& attributeValue)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    DbusParam dbusPa;
    DbusParamList dbusParamList1;

    //Assign default invalid value for the attribute.
    if(ALPS_ATTR_SHUFFEL == attributeId)
    {
        attributeValue = PBM_INVALID;
    }
    else  if(ALPS_ATTR_REPEAT == attributeId)
    {
        attributeValue = RPT_INVALID;
    }
    bool isError= false;
    string result;
    int reply_timeout = 500;
    bool isSystemBus = true;


    dbusPa.type = DBUS_TYPE_BYTE;
    std::stringstream ss;
    ss<<attributeId;
    dbusPa.value.append(ss.str());

    dbusParamList1.push_back(dbusPa);

    const IpcMessageInfo ipcMessageInfo1 = {"com.alps.bt",IPC_ALPS_BTDAEMON_PATH,IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE,"AvpListVal"};
    LocalSPM::GetIPCProvider().MethodCallWaitForReply(ipcMessageInfo1, IN dbusParamList1,isSystemBus,reply_timeout,isError,result,true);

    if(isError || result.empty())
        return MP_ERR_DBUS;

    tBTMethodRequestStatus status = REQ_NOT_OK;
    tArrayLength arrayLength = 0;
    tByteArray pData = NULL;
    tCurrentValue currentValue = 0;

    const char *tempParam = result.c_str();

    sscanf(tempParam,"%u,%u,%p,%u",&status,&arrayLength,&pData,&currentValue);

    if(REQ_OK == status)
    {

        if(ALPS_ATTR_SHUFFEL == attributeId)
        {

            tPlaybackMode playbackMode = PBM_INVALID;
            switch(currentValue)
            {
            case ALPS_SHUFFLE_OFF:
                playbackMode = PBM_NORMAL;
                break;
            case ALPS_SHUFFLE_ALL:
                playbackMode = PBM_RANDOM;
                break;
            case ALPS_SHUFFLE_GROUP:  //Currently BT Devices doesnt support this value.
            default:
                break;
            }

            attributeValue = (int)playbackMode;

        }
        else if(ALPS_ATTR_REPEAT == attributeId)
        {

            tRepeatMode repeatMode = RPT_INVALID;
            switch(currentValue)
            {
            case ALPS_REPEAT_OFF:
                repeatMode = RPT_NONE;
                break;
            case ALPS_REPEAT_SINGLE:
                repeatMode = RPT_ONE;
                break;
            case ALPS_REPEAT_ALL:
                repeatMode = RPT_LIST;
                break;
            case ALPS_REPEAT_GROUP: //Currently BT Devices doesnt support this value.
            repeatMode = RPT_LIST;
            break;
            default:
                break;
            }
            attributeValue = (int)repeatMode;

        }
    }
    else
    {
        return -1;
    }
    return ret;
}

tResult BTDaemonProxy::GetFolderItems(const tScope scope,const tStartItem startItem,const tEndItem endItem,string &resultParams)
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    tInteger serial=0;
    string result;
    VARTRACE(startItem);
    VARTRACE(endItem);
    resultParams.clear();

    ClearResultGetFolderItemsMethodReturn();

    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {


        const tNumAttributes numOfAttributes = 0xFF;//If this value is set to 0xFF, none of the additional attribute information will be retrieved
        const dbus_uint32_t attr_Array_With_Length[2] = {0,0};
        tScope scope = NOW_PLAYING;

        ETG_TRACE_USR3(("IPCProvider::AvpGetFolderItem Scope:%d, StartItem:%d, EndItem:%d,NumOfAttributes:%d",scope, startItem, endItem, numOfAttributes));

        /* Send AvpGetFolderItem to Alps-bt-daemon via DBUS */
        serial = LocalSPM::GetIPCProvider().MethodCall(ipc_AlpsBTDaemon_AvpGetFolderItem,
                //IN (unsigned char)Scope,
                IN (unsigned char)scope,
                IN (unsigned int)startItem,
                IN (unsigned int)endItem,
                IN (unsigned char)numOfAttributes,
                IN attr_Array_With_Length);

    }
    else
    {
        map<string,unsigned int> listItemArgs;
        listItemArgs["Start"]=startItem;
        listItemArgs["End"]=endItem;
        tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
        if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint) != string::npos))
        {
            serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Evolution_ListItems,listItemArgs);
        }
        else
        {
            return MP_ERR_DEVICE_NOT_EXIST;
        }
    }

    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending message via DBus"));
        ret = MP_ERR_DBUS;
    }
    else
    {
        mMessageHandlersMutex.lock();
        mMessageHandlers[serial] = &BTDaemonProxy::GetFolderItemsMethodReturn;
        mMessageHandlersMutex.unlock();
        SetTaskSyncSemWaitFolderItem(true);
        /* wait on counting semaphore */
        struct timespec timeToWait;
        /*get current time*/
        if(clock_gettime(CLOCK_REALTIME , &timeToWait) != -1)
        {
            /*update timeToWait with wait duration */
            timeToWait.tv_sec += 7;
            /* wait for semaphore */
            while(1)
            {
                ret = sem_timedwait(&m_GetFolderItemSyncSem, &timeToWait);
                if (!ret) break; // no error
                ret = errno; // get the last error
                if (ret != EINTR) break;

            }
            VARTRACE(ret);
            if (ret != ETIMEDOUT && ret) {
                ETG_TRACE_ERR (("error on sem_timedwait"));
            }
            if(ret)
            {
                ret = MP_ERR_DBUS;
            }
        }
        else
        {
            ETG_TRACE_ERR (("error on sem_timedwait : Real time not obtained"));
        }
        SetTaskSyncSemWaitFolderItem(false);

    }

    ETG_TRACE_USR4(("m_ResultGetFolderItemsMethodReturn : %s",m_ResultGetFolderItemsMethodReturn.c_str()));

    if( m_ResultGetFolderItemsMethodReturn.empty() )
    {

        return MP_ERR_FILE_NOT_EXIST;
    }

    if(LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
    //Some times the result is like "0,0". For avoiding this scenario checking the string contains the Player name.
        if(m_ResultGetFolderItemsMethodReturn.find(mPlayerInfo.objectPath) == std::string::npos )
    {
        return MP_ERR_FILE_NOT_EXIST;
    }
    }
    else
    {

        tNetworkOrder NetworkOrder = false;
        tByteArray ByteArray = NULL;
        tArrayLength ArrayLength = 0;
        tBTMethodRequestStatus status = REQ_NOT_OK;
        tScope scope = SCOPE_INVALID;

        const char* param = m_ResultGetFolderItemsMethodReturn.c_str();


        sscanf(param,"%u,%u,%u,%u,%p",&status,&scope,&NetworkOrder,&ArrayLength,&ByteArray);
        if(0 == ArrayLength)
        {
            return MP_ERR_FILE_NOT_EXIST;
        }
    }

        resultParams = m_ResultGetFolderItemsMethodReturn;

    return ret;
}


void BTDaemonProxy::GetFolderItemsMethodReturn(const char* params,bool isError)
{
    ENTRY
    //Set the value before sem_post as the value set using  SetResultGetFolderItemsMethodReturn will be validated only after sem_post.
    //So if sem_post is done before the Set it will validate a wrong value.
    if(!isError)
    {
        SetResultGetFolderItemsMethodReturn(params);
    }
    if(GetTaskSyncSemWaitFolderItem())
    {
        sem_post(&m_GetFolderItemSyncSem);
    }
}

void BTDaemonProxy::SetResultGetFolderItemsMethodReturn(const char* params)
{
    ENTRY
    m_ResultGetFolderItemsMethodReturn=string(params);
}
void BTDaemonProxy::ClearResultGetFolderItemsMethodReturn()
{
    ENTRY
    m_ResultGetFolderItemsMethodReturn.clear();
}


tResult BTDaemonProxy::ChangeFolderPath(const tDirection direction,const tItemUID itemUID)
{
    ENTRY

    tResult ret = MP_NO_ERROR;
    tResult res = MP_NO_ERROR;

    bool isError= false;
    string result;
    int reply_timeout = 7000;
    bool isSystemBus = true;


    if(!LocalSPM::GetDataProvider().UseEvolutionBtStack())
    {
        //TODO: Need to implement Fusion stack support
    }
    else
    {
        tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();

        string objectPath((char*)itemUID);

        if((mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint) != string::npos) && (connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET)
                && (mPlayerInfo.objectPath.find("/dev_") != string::npos) && (mPlayerInfo.isBrowsable) && (objectPath.find("/dev_") != string::npos)
                && ((objectPath.find("/Filesystem") != string::npos) || (objectPath.find("/NowPlaying") != string::npos)))
        {

            DbusParam dbusPa;
            DbusParamList dbusParamList;

            dbusPa.type = DBUS_TYPE_OBJECT_PATH;
            dbusPa.value.append(objectPath);

            dbusParamList.push_back(dbusPa);


            const IpcMessageInfo ipcMessageInfo = {"org.bluez",mPlayerInfo.objectPath.c_str(),IPC_EVOLUTION_MEDIAFOLER_INTERFACE,"ChangeFolder"};
            LocalSPM::GetIPCProvider().MethodCallWaitForReply(ipcMessageInfo, IN dbusParamList ,isSystemBus,reply_timeout,isError,result);
        }
        else
        {
            isError= true;
            ETG_TRACE_USR4(("BTDaemonProxy::ChangeFolderPath : Request to Change folder is not sent to the device"));
        }
    }

    if(isError)
    {
        return MP_ERR_DBUS;
    }
    /* wait on counting semaphore */
    struct timespec timeToWait;
    /*get current time*/
    if(clock_gettime(CLOCK_REALTIME , &timeToWait) != -1)
    {
        SetTaskSyncSemWaitChangeFolder(true);
        /*update timeToWait with wait duration */
        timeToWait.tv_sec += 3;
        /* wait for semaphore */
        while(1)
        {
            res = sem_timedwait(&m_ChangeFolderSyncSem, &timeToWait);
            if (!res) break; // no error
            res = errno; // get the last error
            if (res != EINTR) break;

        }
        VARTRACE(res);
        if (res != ETIMEDOUT && res) {
            ETG_TRACE_ERR (("error on sem_timedwait"));
        }
        SetTaskSyncSemWaitChangeFolder(false);
        if(res)
        {
            ret = MP_ERR_DBUS;
        }
    }
    else
    {
        ETG_TRACE_ERR (("error on sem_timedwait : Real time not obtained"));
    }
    return ret;
}
tResult BTDaemonProxy::GetAddressedPlayer()
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
    bool isError=false;
    string playerName;
    int reply_timeout = 1000;
    bool isSystemBus = true;

    DbusParam dbusParam;
    dbusParam.type = DBUS_TYPE_STRING;
    dbusParam.value.append(IPC_EVOLUTION_AVP_INTERFACE);
    DbusParam dbusParam1;
    dbusParam1.type = DBUS_TYPE_STRING;
    dbusParam1.value.append("Addressedplayer");
    DbusParamList dbusParamList;
    dbusParamList.push_back(dbusParam);
    dbusParamList.push_back(dbusParam1);

    string objectPath;
    objectPath.append(IPC_EVOLUTION_OBJECT_PATH);
    objectPath.append(connectedDeviceInfo.mountPoint);
    ETG_TRACE_USR4(("Objectpath for GetAddressedPlayer %s",objectPath.c_str()));

    if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (objectPath.find(connectedDeviceInfo.mountPoint) != string::npos) && (objectPath.find("/dev_") != string::npos))
    {
        const IpcMessageInfo ipcMessageInfo = {"org.bluez",objectPath.c_str(),IPC_EVOLUTION_PROPERTY_INTERFACE,"Get"};

        LocalSPM::GetIPCProvider().MethodCallWaitForReplyNoOverride(ipcMessageInfo, IN dbusParamList,isSystemBus,reply_timeout,isError,playerName);

        if(isError)
        {
            return MP_ERR_DBUS;
        }
        else if(playerName.empty())
        {
            return MP_ERR_NO_PLAYER;
        }
        ETG_TRACE_USR4(("Return playerName ptr:%s",playerName.c_str()));
        InitBTPlayerInfo(mPlayerInfo);
        int literalCount = 0;
        const char* tempParam = playerName.c_str();
        char *ptr = (char*) strchr(tempParam,IPC_DBUS_PARAM_DELIMITER_INT);
        while (ptr != NULL)
        {
            ptr = strchr(ptr + 1,IPC_DBUS_PARAM_DELIMITER_INT);
            literalCount++;
        }
        std::istringstream ss1(playerName);

        std::string token1[literalCount];
        for (int index = 0; index < literalCount; index++)
        {
            std::getline(ss1, token1[index], IPC_DBUS_PARAM_DELIMITER_CHAR);
            ETG_TRACE_USR4(("Return Value Token :%s",token1[index].c_str()));
        }
        for (int index = 0; index < literalCount; index++)
        {
            if(0 == index)
                mPlayerInfo.objectPath = token1[index];
        }
        ETG_TRACE_USR4(("mPlayerInfo.objectPath :%s",mPlayerInfo.objectPath.c_str()));
        //OverrideEvoObjectPaths(mPlayerInfo.objectPath);
    }
    else
    {
        ETG_TRACE_USR4(("Empty Object Path"));
    }
    return ret;
}
void BTDaemonProxy::SetTaskSyncSemWaitFolderItem(tBoolean Value)
{
    // ENTRY
    Locker locker(&m_TaskSyncSemFolderItemMutex);
    m_TaskSyncSemWaitFolderItem = Value;
}
tBoolean BTDaemonProxy::GetTaskSyncSemWaitFolderItem()
{
    // ENTRY
    Locker locker(&m_TaskSyncSemFolderItemMutex);
    return m_TaskSyncSemWaitFolderItem;
}

void BTDaemonProxy::startTimer(const int timeoutValue, const int timeInterval)
{
    ENTRY
    if (mTimerAlreadyRunning) {
        return;
    }
    mTimerAlreadyRunning = true;
    mUpdateTimer.StartTimer(OUT mUpdateTimerID, IN timeoutValue, timeInterval, IN this, IN &TimerCallBack, IN (void *)NULL);
    ETG_TRACE_USR4(("startUpdateTimer: mUpdateTimerID=%ld", mUpdateTimerID));
}
void BTDaemonProxy::stopTimer()
{
    ENTRY
    if (!mTimerAlreadyRunning) {
        return;
    }
    mTimerAlreadyRunning = false;
    mUpdateTimer.CancelTimer(IN mUpdateTimerID);
    mold_elapsedPlayTime = 0;
    SendNoResponseMsg(REASON_OK);
}
bool BTDaemonProxy::TimerCallBack(timer_t /*timerID*/ , void *instance,const void */*userData*/)
{
    ENTRY
    BTDaemonProxy *_this = (BTDaemonProxy *)instance;
    ETG_TRACE_USR4(("old time = %d new time = %d", _this->GetOldElapsedPlayTime(), _this->GetElapsedPlayTime()));
    //calling statemachine event rather than calling the original function to delegate to BTControlSM thread.
    me::reason_e reason = REASON_OK;

    if(_this->GetOldElapsedPlayTime() != _this->GetElapsedPlayTime())
    {
        _this->SendNoResponseMsg(REASON_OK);
    }
    else
    {
        _this->SendNoResponseMsg( REASON_STREAM_INPROGRESS);

    }
    _this->SetOldElapsedPlayTime(_this->GetElapsedPlayTime());
    return true;
}

void BTDaemonProxy::SendNoResponseMsg(const me::reason_e reason)
{
    ENTRY
    //calling statemachine event rather than calling the original function to delegate to BTControlSM thread.
    ETG_TRACE_USR4(("old reason %d and new reason %d",_oldReason,reason));
    if(_oldReason != reason) // Send evenet if incase any reason change .
    {
        tAllParameters parameterString;
        size_t size = sizeof(parameterString);
        tResult ret = LocalSPM::GetInstance().GetBTControl().ParameterNO_RESPONSE_MSG(OUT parameterString,IN size,IN reason);

        if( MP_NO_ERROR != ret )
        {
            ETG_TRACE_ERR(("Error while preparing parameter string NO_RESPONSE_MSG"));
        }
        else
        {
            ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "NO_RESPONSE_MSG", IN parameterString);

            if( MP_NO_ERROR != ret )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF NO_RESPONSE_MSG"));
            }
        }
        _oldReason = reason;
    }
}

void BTDaemonProxy::SetElapsedPlayTime(tPlaytime time)
{
    ENTRY
    Locker locker(&melapsedPlayTimeMutex);
    melapsedPlayTime = time;
}

tPlaytime BTDaemonProxy::GetElapsedPlayTime()
{
    Locker locker(&melapsedPlayTimeMutex);
    return melapsedPlayTime;
}
void BTDaemonProxy::SetOldElapsedPlayTime(tPlaytime time)
{
    ENTRY
    Locker locker(&melapsedPlayTimeMutex);
    mold_elapsedPlayTime = time;
}
tPlaytime BTDaemonProxy::GetOldElapsedPlayTime()
{
    Locker locker(&melapsedPlayTimeMutex);
    return mold_elapsedPlayTime;
}
tBTPlayerInfo BTDaemonProxy::GetPlayerInfo()
{
    return mPlayerInfo;
}
void BTDaemonProxy::SetTaskSyncSemWaitChangeFolder(tBoolean Value)
{

    Locker locker(&m_TaskSyncSemChangeFolderMutex);
    m_TaskSyncSemWaitChangeFolder = Value;
}
tBoolean BTDaemonProxy::GetTaskSyncSemWaitChangeFolder()
{

    Locker locker(&m_TaskSyncSemChangeFolderMutex);
    return m_TaskSyncSemWaitChangeFolder;
}
tPEPlaybackState BTDaemonProxy::getPlaybackState()
{
    Locker locker(&m_PlaybackStateMutex);
    return mPlaybackState;
}

void BTDaemonProxy::setPlaybackState(tPEPlaybackState playbackState)
{
    Locker locker(&m_PlaybackStateMutex);
    mPlaybackState = playbackState;
}

tBoolean BTDaemonProxy::AvpIsShuffleSupported()
{
    ENTRY
    bool isError=false;
    int reply_timeout = 1500;
    bool isSystemBus = true;
    tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
    string objectPath;
    objectPath.append(IPC_EVOLUTION_OBJECT_PATH);
    objectPath.append(connectedDeviceInfo.mountPoint);
    ETG_TRACE_USR4(("Objectpath for GetSupportShuffle is : %s",objectPath.c_str()));
    if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (objectPath.find(connectedDeviceInfo.mountPoint) != string::npos) && (objectPath.find("/dev_") != string::npos))
    {
        DbusParam dbusParam;
        dbusParam.type = DBUS_TYPE_STRING;
        dbusParam.value.append(IPC_EVOLUTION_AVP_INTERFACE);
        DbusParam dbusParam1;
        dbusParam1.type = DBUS_TYPE_STRING;
        dbusParam1.value.append("SupportShuffle");
        DbusParamList dbusParamList;
        dbusParamList.push_back(dbusParam);
        dbusParamList.push_back(dbusParam1);
        string SupportShuffle;

        const IpcMessageInfo ipcMessageInfo = {"org.bluez",objectPath.c_str(),IPC_EVOLUTION_PROPERTY_INTERFACE,"Get"};

        LocalSPM::GetIPCProvider().MethodCallWaitForReplyNoOverride(ipcMessageInfo, IN dbusParamList,isSystemBus,reply_timeout,isError,SupportShuffle);

        if(isError || SupportShuffle.empty())
        {
            if (!isError)
            {
                ETG_TRACE_USR4(("SupportShuffle is empty,  SupportShuffle : %s",SupportShuffle.c_str()));
            }
            return false;
        }

        ETG_TRACE_USR4(("SupportShuffle is not empty,  SupportShuffle : %s",SupportShuffle.c_str()));
        int literalCount = 0;
        const char* tempParam = SupportShuffle.c_str();
        char* ptr = (char*) strchr(tempParam,IPC_DBUS_PARAM_DELIMITER_INT);
        while (ptr != NULL)
        {
            ptr = strchr(ptr + 1,IPC_DBUS_PARAM_DELIMITER_INT);
            literalCount++;
        }
        //Support should support minimum two values (Off and Alltracks) , so literaCount should be greater than 1
        if(1<literalCount)
        {
            return true;
        }
    }
    return false;
}

int BTDaemonProxy::AvpGetShuffleValue()
{
    ENTRY
    bool isError=false;
    int reply_timeout = 1500;
    bool isSystemBus = true;
    tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
    DbusParam dbusParam2;
    dbusParam2.type = DBUS_TYPE_STRING;
    dbusParam2.value.append(IPC_EVOLUTION_INTERFACE);
    DbusParam dbusParam3;
    dbusParam3.type = DBUS_TYPE_STRING;
    dbusParam3.value.append("Shuffle");
    DbusParamList dbusParamList1;
    dbusParamList1.push_back(dbusParam2);
    dbusParamList1.push_back(dbusParam3);
    string ShuffleValue;
    tPlaybackMode playbackMode =PBM_NORMAL;

    if((mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint) != string::npos) && (connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (mPlayerInfo.objectPath.find("/dev_") != string::npos))
    {
        const IpcMessageInfo ipcMessageInfo1 = {"org.bluez",mPlayerInfo.objectPath.c_str(),IPC_EVOLUTION_PROPERTY_INTERFACE,"Get"};

        LocalSPM::GetIPCProvider().MethodCallWaitForReply(ipcMessageInfo1, IN dbusParamList1,isSystemBus,reply_timeout,isError,ShuffleValue);

        if(isError || ShuffleValue.empty())
        {
            playbackMode = PBM_INVALID;
        }
        else
        {
            ETG_TRACE_USR4(("ShuffleValue is not empty,  ShuffleValue : %s",ShuffleValue.c_str()));
            int literalCount1 = 0;
            const char* tempParam1 = ShuffleValue.c_str();
            char* ptr1 = (char*) strchr(tempParam1,IPC_DBUS_PARAM_DELIMITER_INT);
            while (ptr1 != NULL)
            {
                ptr1 = strchr(ptr1 + 1,IPC_DBUS_PARAM_DELIMITER_INT);
                literalCount1++;
            }
            std::istringstream ss2(ShuffleValue);

            std::string token1[literalCount1];
            for (int index = 0; index < literalCount1; index++)
            {
                std::getline(ss2, token1[index], IPC_DBUS_PARAM_DELIMITER_CHAR);
                ETG_TRACE_USR4(("Return Value Token :%s",token1[index].c_str()));
            }
            if (token1[0].compare("Off") == 0)
            {
                playbackMode = PBM_NORMAL;
            }
            else if((token1[0].compare("Alltracks") == 0) ||(token1[0].compare("Group") == 0) )
            {

                playbackMode = PBM_RANDOM;
            }
        }
    }
    return (int)playbackMode;
}

tBoolean BTDaemonProxy::AvpIsRepeatSupported()
{
    ENTRY
    tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
    bool isError=false;
    int reply_timeout = 1500;
    bool isSystemBus = true;
    string objectPath;
    objectPath.append(IPC_EVOLUTION_OBJECT_PATH);
    objectPath.append(connectedDeviceInfo.mountPoint);
    ETG_TRACE_USR4(("Objectpath for GetSupportRepeat is  : %s",objectPath.c_str()));

    if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (objectPath.find(connectedDeviceInfo.mountPoint) != string::npos) && (objectPath.find("/dev_") != string::npos))
    {
        DbusParam dbusParam4;
        dbusParam4.type = DBUS_TYPE_STRING;
        dbusParam4.value.append(IPC_EVOLUTION_AVP_INTERFACE);
        DbusParam dbusParam5;
        dbusParam5.type = DBUS_TYPE_STRING;
        dbusParam5.value.append("SupportRepeat");
        DbusParamList dbusParamList2;
        dbusParamList2.push_back(dbusParam4);
        dbusParamList2.push_back(dbusParam5);
        string SupportRepeat;

        const IpcMessageInfo ipcMessageInfo2 = {"org.bluez",objectPath.c_str(),IPC_EVOLUTION_PROPERTY_INTERFACE,"Get"};

        LocalSPM::GetIPCProvider().MethodCallWaitForReplyNoOverride(ipcMessageInfo2, IN dbusParamList2,isSystemBus,reply_timeout,isError,SupportRepeat);

        if(isError || SupportRepeat.empty())
        {
            if (!isError)
            {
                ETG_TRACE_USR4(("SupportRepeat is empty,  SupportRepeat : %s",SupportRepeat.c_str()));
            }
            return false;
        }

        ETG_TRACE_USR4(("SupportRepeat is not empty,  SupportRepeat : %s",SupportRepeat.c_str()));
        int literalCount2 = 0;
        const char* tempParam2 = SupportRepeat.c_str();
        char* ptr2 = (char*) strchr(tempParam2,IPC_DBUS_PARAM_DELIMITER_INT);
        while (ptr2 != NULL)
        {
            ptr2 = strchr(ptr2 + 1,IPC_DBUS_PARAM_DELIMITER_INT);
            literalCount2++;
        }
        //three modes of repeat will be supported hence literalCount2 should be greater than 2
        if(2<literalCount2)
        {
            return true;
        }
    }
    return false;
}

int BTDaemonProxy::AvpGetRepeatValue()
{
    ENTRY
    bool isError=false;
    int reply_timeout = 1500;
    bool isSystemBus = true;
    tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
    DbusParam dbusParam6;
    dbusParam6.type = DBUS_TYPE_STRING;
    dbusParam6.value.append(IPC_EVOLUTION_INTERFACE);
    DbusParam dbusParam7;
    dbusParam7.type = DBUS_TYPE_STRING;
    dbusParam7.value.append("Repeat");
    DbusParamList dbusParamList3;
    dbusParamList3.push_back(dbusParam6);
    dbusParamList3.push_back(dbusParam7);
    string RepeatValue;
    tRepeatMode repeatMode=RPT_NONE;

    if((mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint) != string::npos) && (connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (mPlayerInfo.objectPath.find("/dev_") != string::npos))
    {
        const IpcMessageInfo ipcMessageInfo3 = {"org.bluez",mPlayerInfo.objectPath.c_str(),IPC_EVOLUTION_PROPERTY_INTERFACE,"Get"};

        LocalSPM::GetIPCProvider().MethodCallWaitForReply(ipcMessageInfo3, IN dbusParamList3,isSystemBus,reply_timeout,isError,RepeatValue);

        if(isError || RepeatValue.empty())
        {
            repeatMode = RPT_INVALID;
        }
        else
        {
            ETG_TRACE_USR4(("RepeatValue is not empty,  RepeatValue : %s",RepeatValue.c_str()));
            int literalCount4 = 0;
            const char* tempParam4 = RepeatValue.c_str();
            char* ptr4 = (char*) strchr(tempParam4,IPC_DBUS_PARAM_DELIMITER_INT);
            while (ptr4 != NULL)
            {
                ptr4 = strchr(ptr4 + 1,IPC_DBUS_PARAM_DELIMITER_INT);
                literalCount4++;
            }
            std::istringstream ss4(RepeatValue);

            std::string token4[literalCount4];
            for (int index = 0; index < literalCount4; index++)
            {
                std::getline(ss4, token4[index], IPC_DBUS_PARAM_DELIMITER_CHAR);
                ETG_TRACE_USR4(("Return Value Token :%s",token4[index].c_str()));
            }
            if (token4[0].compare("Off") == 0)
            {
                repeatMode = RPT_NONE;

            }else if(token4[0].compare("Singletrack") == 0)
            {
                repeatMode = RPT_ONE;

            }else if((token4[0].compare("Alltracks") == 0) ||(token4[0].compare("Group") == 0))
            {
                repeatMode = RPT_LIST;
            }
        }
    }
    return (int)repeatMode;
}
void BTDaemonProxy::SupportAbsoluteVolume()
{
    ENTRY
    tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
    string objectPath;
    objectPath.append(IPC_EVOLUTION_OBJECT_PATH);
    objectPath.append(connectedDeviceInfo.mountPoint);
    if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (objectPath.find(connectedDeviceInfo.mountPoint) != string::npos) && (objectPath.find("/dev_") != string::npos))
    {
        bool isError=false;
        string AbsoluteVolumeSupport;
        int reply_timeout = 3000;
        bool isSystemBus = true;

        DbusParam dbusParam;
        dbusParam.type = DBUS_TYPE_STRING;
        dbusParam.value.append(IPC_EVOLUTION_AVP_INTERFACE);
        DbusParam dbusParam1;
        dbusParam1.type = DBUS_TYPE_STRING;
        dbusParam1.value.append("SupportAbsoluteVolume");
        DbusParamList dbusParamList;
        dbusParamList.push_back(dbusParam);
        dbusParamList.push_back(dbusParam1);


        ETG_TRACE_USR4(("BTDaemonProxy::SupportAbsoluteVolume Objectpath for SupportAbsoluteVolume %s",objectPath.c_str()));

        const IpcMessageInfo ipcMessageInfo = {"org.bluez",objectPath.c_str(),IPC_EVOLUTION_PROPERTY_INTERFACE,"Get"};

        LocalSPM::GetIPCProvider().MethodCallWaitForReplyNoOverride(ipcMessageInfo, IN dbusParamList,isSystemBus,reply_timeout,isError,AbsoluteVolumeSupport);

        if(isError || AbsoluteVolumeSupport.empty())
        {
            ETG_TRACE_USR4(("BTDaemonProxy::SupportAbsoluteVolume Error in getting AbsoluteVolumeSupport for device"));
        }
        else
        {
            int literalCount = 0;
            const char* tempParam = AbsoluteVolumeSupport.c_str();
            char* ptr = (char*) strchr(tempParam,IPC_DBUS_PARAM_DELIMITER_INT);
            while (ptr != NULL)
            {
                ptr = strchr(ptr + 1,IPC_DBUS_PARAM_DELIMITER_INT);
                literalCount++;
            }
            if(literalCount)
            {
                std::istringstream ss(AbsoluteVolumeSupport);
                std::string token[literalCount];
                for (int index = 0; index < literalCount; index++)
                {
                    std::getline(ss, token[index], IPC_DBUS_PARAM_DELIMITER_CHAR);
                    ETG_TRACE_USR4(("BTDaemonProxy::SupportAbsoluteVolume  :AbsoluteVolumeSupport Value Token :%s",token[index].c_str()));
                }
                if (token[0].compare("Supported") == 0)
                {
                    LocalSPM::GetDataProvider().AbsoluteVolumeSupportForBTDevice = 1;
                }
                else
                {
                    LocalSPM::GetDataProvider().AbsoluteVolumeSupportForBTDevice = 0;
                }
            }
        }

    }
}
void BTDaemonProxy::GetObjectPathForAbsoluteVolume()
{
    ENTRY
    tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
    string objectPath="/";
    if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (LocalSPM::GetDataProvider().AbsoluteVolumeSupportFeatureBT()) && (LocalSPM::GetDataProvider().AbsoluteVolumeSupportForBTDevice()))
    {
        bool isError=false;
        string Result;
        int reply_timeout = 3000;
        bool isSystemBus = true;
        DbusParamList dbusParamList;

        const IpcMessageInfo ipcMessageInfo = {"org.bluez",objectPath.c_str(),"org.freedesktop.DBus.ObjectManager","GetManagedObjects"};

        LocalSPM::GetIPCProvider().MethodCallWaitForReplyNoOverride(ipcMessageInfo, IN dbusParamList,isSystemBus,reply_timeout,isError,Result);

        if(isError || Result.empty())
        {
            ETG_TRACE_USR4(("BTDaemonProxy::GetObjectPathForAbsoluteVolume Error in getting ObjectPath for AbsoluteVolume"));
        }
        else
        {
            int literalCount = 0;
            const char* tempParam = Result.c_str();
            char* ptr = (char*) strchr(tempParam,IPC_DBUS_PARAM_DELIMITER_INT);
            while (ptr != NULL)
            {
                ptr = strchr(ptr + 1,IPC_DBUS_PARAM_DELIMITER_INT);
                literalCount++;
            }
            if(literalCount)
            {
                std::istringstream ss(Result);
                std::string token[literalCount];
                for (int index = 0; index < literalCount; index++)
                {
                    std::getline(ss, token[index], IPC_DBUS_PARAM_DELIMITER_CHAR);
                }
                string Path;
                Path.append(IPC_EVOLUTION_OBJECT_PATH);
                Path.append(connectedDeviceInfo.mountPoint);
                Path.append("/fd");
                for (int index = 0; index < literalCount; index++)
                {
                    if (token[index].find(Path) != string::npos)
                    {
                        mObjectPathForAbsoluteVolume = token[index];
                        ETG_TRACE_USR4(("BTDaemonProxy::GetObjectPathForAbsoluteVolume Value mObjectPathForAbsoluteVolume :%s",mObjectPathForAbsoluteVolume.c_str()));
                        break;
                    }
                }

            }
        }
    }
}

void BTDaemonProxy::UpdateVolumeToDevice(int Volume , int HeadUnitVolume)
{
    ENTRY
    bool isSameVolume = 0; /* if the current volume was sent to Audio and volume in the same range is received, it should not be sent to device */
    /*Volume is CurrentVolumeinDevice with value since every 3 values in devicevoulme corresponds to a value in audiovolume, eg 1, 2, 3 values corresponds to 1 in audiovolume
               whereas 1 in audiovolume is converted to 3 in devicevolume, which could be 1, 2, 3 from the device volume */
    tAbsoluteVolumeSupportValues absoluteVolumeSupportValues;
    absoluteVolumeSupportValues = GetAbsoluteVolumeSupportValues();
    if(Volume < 115)
    {
        isSameVolume = ((absoluteVolumeSupportValues.currentVolumeinDevice) > (Volume-3)) && ((absoluteVolumeSupportValues.currentVolumeinDevice) < (Volume+1));
    }
    /* above 114 , 115 -> 120 is 39 and 121 -> 127 is 40 . */
    else if(Volume <= 120)
    {
        isSameVolume = ((absoluteVolumeSupportValues.currentVolumeinDevice) > (Volume-6)) && ((absoluteVolumeSupportValues.currentVolumeinDevice) < (Volume+1));
    }
    else if(Volume <= 127)
    {
        isSameVolume = ((absoluteVolumeSupportValues.currentVolumeinDevice) > (Volume-7));
    }
    VARTRACE(isSameVolume);
    if(!(isSameVolume))
    {
        tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
        string objectPath=mObjectPathForAbsoluteVolume;
        if(!(absoluteVolumeSupportValues.waitingForVolumeUpdate)&& (connectedDeviceInfo.activeSource))
        {
            if((connectedDeviceInfo.connected) && (LocalSPM::GetDataProvider().AbsoluteVolumeSupportFeatureBT()) && (LocalSPM::GetDataProvider().AbsoluteVolumeSupportForBTDevice()))
            {
                if((objectPath.find(connectedDeviceInfo.mountPoint) != string::npos) && (objectPath.find("/dev_") != string::npos))
                {
                    bool isError=false;
                    string Result;
                    int reply_timeout = 3000;
                    bool isSystemBus = true;
                    //Convert Volume to string
                    stringstream ss;
                    ss << Volume;
                    string VolumeString = ss.str();

                    DbusParam dbusParam;
                    dbusParam.type = DBUS_TYPE_STRING;
                    dbusParam.value.append(IPC_EVOLUTION_MEDIATRANSPORT_INTERFACE);
                    DbusParam dbusParam1;
                    dbusParam1.type = DBUS_TYPE_STRING;
                    dbusParam1.value.append("Volume");
                    DbusParam dbusParam2;
                    dbusParam2.type = DBUS_TYPE_UINT16;
                    dbusParam2.value.append(VolumeString);
                    DbusParamList dbusParamList;
                    dbusParamList.push_back(dbusParam2);
                    DbusParam dbusParam3;
                    dbusParam3.type = DBUS_TYPE_VARIANT;
                    dbusParam3.ParamList = dbusParamList;
                    DbusParamList dbusParamList1;
                    dbusParamList1.push_back(dbusParam);
                    dbusParamList1.push_back(dbusParam1);
                    dbusParamList1.push_back(dbusParam3);
                    const IpcMessageInfo ipcMessageInfo = {"org.bluez",objectPath.c_str(),IPC_EVOLUTION_PROPERTY_INTERFACE,"Set"};

                    LocalSPM::GetIPCProvider().MethodCallWaitForReplyNoOverride(ipcMessageInfo, IN dbusParamList1,isSystemBus,reply_timeout,isError,Result);

                    if(isError)
                    {
                        ETG_TRACE_USR4(("BTDaemonProxy::UpdateVolumeToDevice error in updating volume to device"));
                    }
                    else
                    {
                        tAbsoluteVolumeSupportVariables absoluteVolumeSupportVariables = VOLUME_SENT_TO_DEVICE;
                        SetAbsoluteVolumeSupportValues(absoluteVolumeSupportVariables,Volume);
                        absoluteVolumeSupportVariables = WAITING_FOR_VOLUME_UPDATE;
                        int Value = SET_WAIT;
                        SetAbsoluteVolumeSupportValues(absoluteVolumeSupportVariables,Value);
                        absoluteVolumeSupportVariables = CURRENT_VOLUME_RECEIVED_FROM_AUDIO;
                        Value = INVALID_VOLUME;
                        SetAbsoluteVolumeSupportValues(absoluteVolumeSupportVariables,Value);
                        StartAbsoluteVolumeWaitTimer();

                    }
                }
            }
        }
        else
        {
            ETG_TRACE_USR4(("BTDaemonProxy::UpdateVolumeToDevice do not send volume to device , set variable 'CURRENT_VOLUME_RECEIVED_FROM_AUDIO' %d",HeadUnitVolume));
            tAbsoluteVolumeSupportVariables absoluteVolumeSupportVariables = CURRENT_VOLUME_RECEIVED_FROM_AUDIO;
            SetAbsoluteVolumeSupportValues(absoluteVolumeSupportVariables,HeadUnitVolume);
        }
    }
}

void BTDaemonProxy::GetVolumeFromDevice()
{
    ENTRY
    tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
    string objectPath=mObjectPathForAbsoluteVolume;
    if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (LocalSPM::GetDataProvider().AbsoluteVolumeSupportFeatureBT()) && (LocalSPM::GetDataProvider().AbsoluteVolumeSupportForBTDevice())  && (objectPath.find(connectedDeviceInfo.mountPoint) != string::npos) && (objectPath.find("/dev_") != string::npos) && (objectPath.find("/fd") != string::npos))
    {
        bool isError=false;
        string Result;
        int reply_timeout = 2000;
        bool isSystemBus = true;

        DbusParam dbusParam;
        dbusParam.type = DBUS_TYPE_STRING;
        dbusParam.value.append(IPC_EVOLUTION_MEDIATRANSPORT_INTERFACE);
        DbusParam dbusParam1;
        dbusParam1.type = DBUS_TYPE_STRING;
        dbusParam1.value.append("Volume");
        DbusParamList dbusParamList1;
        dbusParamList1.push_back(dbusParam);
        dbusParamList1.push_back(dbusParam1);

        const IpcMessageInfo ipcMessageInfo = {"org.bluez",objectPath.c_str(),IPC_EVOLUTION_PROPERTY_INTERFACE,"Get"};

        LocalSPM::GetIPCProvider().MethodCallWaitForReplyNoOverride(ipcMessageInfo, IN dbusParamList1,isSystemBus,reply_timeout,isError,Result);

        if(isError || Result.empty())
        {
            ETG_TRACE_USR4(("BTDaemonProxy::GetVolumeFromDevice error in getting volume from device"));
        }
        else
        {
            int literalCount = 0;
            const char* tempParam = Result.c_str();
            char* ptr = (char*) strchr(tempParam,IPC_DBUS_PARAM_DELIMITER_INT);
            while (ptr != NULL)
            {
                ptr = strchr(ptr + 1,IPC_DBUS_PARAM_DELIMITER_INT);
                literalCount++;
            }
            std::istringstream ss(Result);
            std::string token;
            std::getline(ss, token, IPC_DBUS_PARAM_DELIMITER_CHAR);
            int Volume;
            sscanf(token.c_str(), "%u", &Volume);
            ETG_TRACE_USR4(("BTDaemonProxy::GetVolumeFromDevice Volume in device : %d",Volume));
            tAbsoluteVolumeSupportVariables absoluteVolumeSupportVariables = CURRENT_VOLUME_IN_DEVICE;
            SetAbsoluteVolumeSupportValues(absoluteVolumeSupportVariables,Volume);
        }
    }
}

void BTDaemonProxy::AvpPlayerRemovedSignal(const char* params)
{
    ENTRY
    if(NULL != params)
    {
        std::string strFromChar ="";
        strFromChar.append(params);
        std::istringstream ss(strFromChar);
        std::string token;
        std::getline(ss, token, IPC_DBUS_PARAM_DELIMITER_CHAR);
        string player;
        player = token;
        ETG_TRACE_USR4(("BTDaemonProxy::AvpPlayerRemovedSignal player that is removed is : %s",player.c_str()));
        ETG_TRACE_USR4(("BTDaemonProxy::AvpPlayerRemovedSignal mPlayerInfo.objectPath that is removed is : %s",mPlayerInfo.objectPath.c_str()));
        if (("" != player) && (player == mPlayerInfo.objectPath))
        {
            ETG_TRACE_USR4(("Entered "));
            //Init mPlayerInfo before over ride the object path.
            InitBTPlayerInfo(mPlayerInfo);
            //NCG3D-105859: Set default path instead of of empty (or null).
            OverrideEvoObjectPaths(IPC_EVOLUTION_OBJECT_DUMMY_PATH);
            CleanupNowPlayingMetadata();
            setPlaybackState(PE_PBS_LOADINGSTATE);
            mBTActivePlaybackstate = PE_PBS_LOADINGSTATE;
            mStatusBeforeForwardRewind = PE_PBS_UNKNOWN;
            if(GetTaskSyncSemWaitFolderItem())
            {
                sem_post(&m_GetFolderItemSyncSem);
            }
            if(GetTaskSyncSemWaitChangeFolder())
            {
                sem_post(&m_ChangeFolderSyncSem);
                ClearResultGetFolderItemsMethodReturn();
            }
            //Active player is removed , so stop the play retrial timer, to avoid retrial play command to device.
            LocalSPM::GetInstance().GetBTControl().StopRetryPlayTimer();
        }
    }
}
void BTDaemonProxy::AvpUIDsChangedSignal(const char* params)
{
    ENTRY
    if(NULL != params)
    {
        std::string strFromChar ="";
        strFromChar.append(params);
        std::istringstream ss(strFromChar);
        std::string token;
        std::getline(ss, token, IPC_DBUS_PARAM_DELIMITER_CHAR);
        int Value;
        sscanf(token.c_str(), "%d", &Value);
        VARTRACE(Value);
        if(UIDS_CHANGED_EXPECTED_VALUE == Value)
        {
            tResult Result = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "MOVE_TO_ROOT_AND_CLEAR_BT_CACHE", IN NULL);
            if( MP_NO_ERROR != Result )
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
            }
        }
        else
        {
            ETG_TRACE_ERR(("BTDaemonProxy::AvpUIDsChangedSignal params is not = %d",UIDS_CHANGED_EXPECTED_VALUE));
        }
    }
    else
    {
        ETG_TRACE_ERR(("BTDaemonProxy::AvpUIDsChangedSignal params is empty"));
    }
}

void BTDaemonProxy::SetAbsoluteVolumeSupportValues(tAbsoluteVolumeSupportVariables Variable,int Value)
{
    Locker locker(&m_AbsoluteVolumeSupportValueMutex);
    switch(Variable)
    {
        case VOLUME_SENT_TO_DEVICE:
            mAbsoluteVolumeSupport.volumeSentToDevice = Value;
            break;
        case CURRENT_VOLUME_RECEIVED_FROM_AUDIO:
            mAbsoluteVolumeSupport.currentVolumeReceivedFromAudio = Value;
            break;
        case WAITING_FOR_VOLUME_UPDATE:
            mAbsoluteVolumeSupport.waitingForVolumeUpdate = bool(Value);
            break;
        case CURRENT_VOLUME_IN_DEVICE:
            mAbsoluteVolumeSupport.currentVolumeinDevice = Value;
            break;
        case SET_ALL_TO_DEFAULT:
        default:
            mAbsoluteVolumeSupport.volumeSentToDevice = INVALID_VOLUME;
            mAbsoluteVolumeSupport.currentVolumeReceivedFromAudio = INVALID_VOLUME;
            mAbsoluteVolumeSupport.waitingForVolumeUpdate = RESET_WAIT;
            mAbsoluteVolumeSupport.currentVolumeinDevice = INVALID_VOLUME;
            break;
    }
}

tAbsoluteVolumeSupportValues BTDaemonProxy::GetAbsoluteVolumeSupportValues()
{
    Locker locker(&m_AbsoluteVolumeSupportValueMutex);
    return mAbsoluteVolumeSupport;
}

tResult BTDaemonProxy::StartAbsoluteVolumeWaitTimer()
{
    ENTRY
    long timerMS = ABSOLUTE_VOLUME_WAIT_TIME_INTERVAL;

    /* create AbsoluteVolume wait timer */
    mAbsoluteVolumeWaitTimer.StartTimer(OUT mAbsoluteVolumeWaitTimerID, IN timerMS, IN timerMS, IN this, IN &AbsoluteVolumeWaitTimerCallBack, IN (void *)NULL);

    return MP_NO_ERROR;
}

tResult BTDaemonProxy::StopAbsoluteVolumeWaitTimer()
{
    ENTRY

    /* delete AbsoluteVolume wait timer */
    if(mAbsoluteVolumeWaitTimerID)
    {
        mAbsoluteVolumeWaitTimer.CancelTimer(IN mAbsoluteVolumeWaitTimerID);
        mAbsoluteVolumeWaitTimerID = 0;
    }

    return MP_NO_ERROR;
}

bool BTDaemonProxy::AbsoluteVolumeWaitTimerCallBack(timer_t timerID , void* instance, const void *userData)
{
    ENTRY
    BTDaemonProxy *self = (BTDaemonProxy *)instance;
    if(self != NULL)
    {
        self->StopAbsoluteVolumeWaitTimer();
        tAbsoluteVolumeSupportVariables absoluteVolumeSupportVariables = VOLUME_SENT_TO_DEVICE;
        int setValue = INVALID_VOLUME;
        self->SetAbsoluteVolumeSupportValues(absoluteVolumeSupportVariables,setValue);
        absoluteVolumeSupportVariables = WAITING_FOR_VOLUME_UPDATE;
        setValue = RESET_WAIT;
        self->SetAbsoluteVolumeSupportValues(absoluteVolumeSupportVariables,setValue);
        tAbsoluteVolumeSupportValues absoluteVolumeSupportValues;
        absoluteVolumeSupportValues = self->GetAbsoluteVolumeSupportValues();
        if((absoluteVolumeSupportValues.currentVolumeReceivedFromAudio) != -1)
        {
            tAllParameters parameterStringforVolume;
            size_t size1 = sizeof(parameterStringforVolume);
            tResult Result = LocalSPM::GetInstance().GetBTControl().ParameterUPDATE_VOLUME_TO_DEVICE(OUT parameterStringforVolume, IN size1, IN (absoluteVolumeSupportValues.currentVolumeReceivedFromAudio));
            if( MP_NO_ERROR != Result )
            {
                ETG_TRACE_ERR(("Error while preparing parameter string"));
            }
            else
            {
                Result = LocalSPM::GetDeviceDispatcher().RouteMessage(IN self->mSMObserver, IN "UPDATE_VOLUME_TO_DEVICE", IN parameterStringforVolume);
                if( MP_NO_ERROR != Result )
                {
                    ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                }
            }
            setValue = INVALID_VOLUME;
            tAbsoluteVolumeSupportVariables absoluteVolumeSupportVariables = CURRENT_VOLUME_RECEIVED_FROM_AUDIO;
            self->SetAbsoluteVolumeSupportValues(absoluteVolumeSupportVariables,setValue);
        }
    }
    return MP_NO_ERROR;
}

void BTDaemonProxy::AvpGetImage(const tBTCoverArtInfo coverArtInfo)
{
    ENTRY;

    InitBTCoverArtInfo(mCoverArtInfoGetImagePending);

    if(mGetImageReqInProgress)
    {
        if(coverArtInfo.coverArthandle.compare(mCoverArtInfoGetImageIsInProgress.coverArthandle) == 0)
        {
            ETG_TRACE_USR4((" AvpGetImage is in progress for the requested coverart handle  : %s", coverArtInfo.coverArthandle.c_str()));
        }
        else
        {
            mCoverArtInfoGetImagePending = coverArtInfo;
            AvpCancelGettingImage(mCoverArtInfoGetImageIsInProgress.coverArthandle.c_str());
        }
    }
    else
    {
        tInteger serial = -1;

        // Currently image is returned only on empty filter.
        map<string, unsigned int> getImage_ImageFilter;

        stringstream ss;
        ss << coverArtInfo.objectID;
        string imagePath(BT_COVERART_PATH);
        imagePath = imagePath + "/nowplaying_"+ss.str()+ "_" +coverArtInfo.coverArthandle;
        VARTRACE(imagePath.c_str());

        tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();

        VARTRACE(connectedDeviceInfo.coverArtConStatus);
        VARTRACE(mPlayerInfo.objectPath.c_str());
        if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint) != string::npos) && (CONNECTED == connectedDeviceInfo.coverArtConStatus) && (mPlayerInfo.objectPath.find("/dev_") != string::npos))
        {
            LocalSPM::GetIPCProvider().OverridePath(IPC_EVOLUTION_MEDIAITEM_INTERFACE,coverArtInfo.mediaItemObjectPath.c_str());
            serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Evolution_GetImage, IN coverArtInfo.coverArthandle.c_str(), IN imagePath.c_str(), IN getImage_ImageFilter);
        }

        if(0 > serial)
        {
            ETG_TRACE_ERR(("Error while sending AvpGetImage message via DBus"));
            mGetImageReqInProgress = false;
        }
        else
        {
            mGetImageReqInProgress = true;
            mCoverArtInfoGetImageIsInProgress = coverArtInfo;

            ETG_TRACE_USR4((" AvpGetImage Message posted to DBus "));
            mMessageHandlersMutex.lock();
            mMessageHandlers[serial] = &BTDaemonProxy::AvpGetImageMethodReturn;
            mMessageHandlersMutex.unlock();
        }
    }
}

void BTDaemonProxy::AvpGetImageMethodReturn(const char* params,bool isError)
{
    ENTRY;

    if(isError)
    {
        ETG_TRACE_ERR(("AvpGetImage Failed with error %s",params));
    }
    else
    {
        if(strlen_r(params))
        {
            tURL fullpath;
            sscanf(params, "%s", fullpath);
            ETG_TRACE_USR1((" Fullpath (%s)", fullpath));

            LocalSPM::GetInstance().GetBTControl().AvpGetImageMethodReturn(fullpath);
        }
    }

    InitBTCoverArtInfo(mCoverArtInfoGetImageIsInProgress);
    mGetImageReqInProgress = false;
}

void BTDaemonProxy::AvpCancelGettingImage(const char *albumArtHandle)
{
    ENTRY;
    tInteger serial = 0;

    tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
    if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint) != string::npos) && (CONNECTED == connectedDeviceInfo.coverArtConStatus))
    {
        serial = LocalSPM::GetIPCProvider().MethodCall(ipc_Evolution_CancelGettingImage, IN albumArtHandle);
    }

    if(0 > serial)
    {
        ETG_TRACE_ERR(("Error while sending AvpCancelGettingImage message via DBus"));
    }
    else
    {
        mMessageHandlersMutex.lock();
        mMessageHandlers[serial] = &BTDaemonProxy::AvpCancelGettingImageMethodReturn;
        mMessageHandlersMutex.unlock();
    }
}

void BTDaemonProxy::AvpCancelGettingImageMethodReturn(const char* params,bool isError)
{
    ENTRY;

    mGetImageReqInProgress = false;
    InitBTCoverArtInfo(mCoverArtInfoGetImageIsInProgress);

    if(isError)
    {
        ETG_TRACE_ERR(("AvpCancelGettingImage Failed with error %s",params));
    }
    else
    {
        ETG_TRACE_ERR(("AvpCancelGettingImage SUCCESS"));
        if(!mCoverArtInfoGetImagePending.coverArthandle.empty())
        {
            AvpGetImage(IN mCoverArtInfoGetImagePending);
        }
    }
}


//At times PropertyChanged is received in BtDaemonProxy before device gets connected.
//In that case actual value of CoverArtConStatus will not be available in BtDaemonProxy.
//Then get the CoverArtConStatus separately after device connection.
void BTDaemonProxy::GetCoverArtConStatus()
{
    ENTRY
    tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
    string objectPath;
    objectPath.append(IPC_EVOLUTION_OBJECT_PATH);
    objectPath.append(connectedDeviceInfo.mountPoint);
    if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (objectPath.find(connectedDeviceInfo.mountPoint) != string::npos) && (objectPath.find("/dev_") != string::npos))
    {
        bool isError=false;
        string CoverArtConStatus;
        int reply_timeout = 3000;
        bool isSystemBus = true;

        DbusParam dbusParam;
        dbusParam.type = DBUS_TYPE_STRING;
        dbusParam.value.append(IPC_EVOLUTION_AVP_INTERFACE);
        DbusParam dbusParam1;
        dbusParam1.type = DBUS_TYPE_STRING;
        dbusParam1.value.append("CoverArtConStatus");
        DbusParamList dbusParamList;
        dbusParamList.push_back(dbusParam);
        dbusParamList.push_back(dbusParam1);

        ETG_TRACE_USR4(("BTDaemonProxy::CoverArtConStatus Objectpath for CoverArtConStatus %s",objectPath.c_str()));

        const IpcMessageInfo ipcMessageInfo = {"org.bluez",objectPath.c_str(),IPC_EVOLUTION_PROPERTY_INTERFACE,"Get"};

        LocalSPM::GetIPCProvider().MethodCallWaitForReplyNoOverride(ipcMessageInfo, IN dbusParamList,isSystemBus,reply_timeout,isError,CoverArtConStatus);

        if(isError || CoverArtConStatus.empty())
        {
            ETG_TRACE_USR4(("BTDaemonProxy::CoverArtConStatus Error in getting CoverArtConStatus for device"));
        }
        else
        {
            int literalCount = 0;
            const char* tempParam = CoverArtConStatus.c_str();
            char* ptr = (char*) strchr(tempParam,IPC_DBUS_PARAM_DELIMITER_INT);
            while (ptr != NULL)
            {
                ptr = strchr(ptr + 1,IPC_DBUS_PARAM_DELIMITER_INT);
                literalCount++;
            }
            if(literalCount)
            {
                std::istringstream ss(CoverArtConStatus);
                std::string token[literalCount];
                for (int index = 0; index < literalCount; index++)
                {
                    std::getline(ss, token[index], IPC_DBUS_PARAM_DELIMITER_CHAR);
                    ETG_TRACE_USR4(("BTDaemonProxy::CoverArtConStatus  :CoverArtConStatus Value Token :%s",token[index].c_str()));
                }
                if (token[0].compare("Connected") == 0)
                {
                    LocalSPM::GetInstance().GetBTControl().SetCoverArtConStatus(CONNECTED);

                    //Create a folder to store coverarts
                    DIR* tmpDir = opendir(BT_COVERART_PATH);
                    if(NULL == tmpDir)
                    {
                        if(0 == mkdir(BT_COVERART_PATH,S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH))
                        {
                            ETG_TRACE_USR4((" Created folder in tmp for bt coverarts as: %s",BT_COVERART_PATH));
                        }
                        else
                        {
                            ETG_TRACE_ERR(("mkdir: error: %d/%s", errno, strerror(errno)));
                        }
                    }
                    else
                    {
                        closedir(tmpDir);
                    }
                }
                else if(token[0].compare("NotConnected") == 0)
                {
                    LocalSPM::GetInstance().GetBTControl().SetCoverArtConStatus(NOTCONNECTED);
                }
                else if(token[0].compare("Unknown") == 0)
                {
                    LocalSPM::GetInstance().GetBTControl().SetCoverArtConStatus(UNKNOWN);
                }
            }
        }
    }
}


tNumOfItems BTDaemonProxy::GetNumberOfItemsInCurrentPath()
{
    ENTRY

    tNumOfItems numberOfItems = 0;
    tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
    if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (mPlayerInfo.objectPath.find(connectedDeviceInfo.mountPoint) != string::npos))
    {
        bool isError=false;
        string NumberOfItems;
        int reply_timeout = 3000;
        bool isSystemBus = true;

        DbusParam dbusParam;
        dbusParam.type = DBUS_TYPE_STRING;
        dbusParam.value.append(IPC_EVOLUTION_MEDIAFOLER_INTERFACE);
        DbusParam dbusParam1;
        dbusParam1.type = DBUS_TYPE_STRING;
        dbusParam1.value.append("NumberOfItems");
        DbusParamList dbusParamList;
        dbusParamList.push_back(dbusParam);
        dbusParamList.push_back(dbusParam1);

        const IpcMessageInfo ipcMessageInfo = {"org.bluez",mPlayerInfo.objectPath.c_str(),IPC_EVOLUTION_PROPERTY_INTERFACE,"Get"};

        LocalSPM::GetIPCProvider().MethodCallWaitForReplyNoOverride(ipcMessageInfo, IN dbusParamList,isSystemBus,reply_timeout,isError,NumberOfItems);

        if(isError || NumberOfItems.empty())
        {
            ETG_TRACE_USR4(("BTDaemonProxy::GetNumberOfItemsInPath Error in getting NumberOfItems for device"));
        }
        else
        {
            int literalCount = 0;
            const char* tempParam = NumberOfItems.c_str();
            char* ptr = (char*) strchr(tempParam,IPC_DBUS_PARAM_DELIMITER_INT);
            while (ptr != NULL)
            {
                ptr = strchr(ptr + 1,IPC_DBUS_PARAM_DELIMITER_INT);
                literalCount++;
            }
            if(literalCount)
            {
                std::istringstream ss(NumberOfItems);
                std::string token[literalCount];
                for (int index = 0; index < literalCount; index++)
                {
                    std::getline(ss, token[index], IPC_DBUS_PARAM_DELIMITER_CHAR);
                    ETG_TRACE_USR4(("BTDaemonProxy::GetNumberOfItemsInPath  :NumberOfItems Value Token :%s",token[index].c_str()));
                    sscanf(token[index].c_str(), "%u", &numberOfItems);
                }
            }
        }
    }
    return numberOfItems;
}

void BTDaemonProxy::AvpAvailablePlayerChangedSignal(const char* params)
{
    ENTRY

    //Avoid sending NOW_PLAYING_CONTENT_CHANGED if the BT device is not connected via AVRCP.
    //The signal will come if the device is connected for IAP2BT also.
    tDeviceInfo connectedDeviceInfo = LocalSPM::GetInstance().GetBTControl().GetConnectedDeviceInfo();
    if((connectedDeviceInfo.deviceID != DEVICE_ID_NOT_SET) && (NULL != params))
    {
        ETG_TRACE_USR3(("BTDaemonProxy::AvpAvailablePlayerChangedSignal is received"));
        //Available Player Change signal indicates the now-playing list should be cleared and recreated NCG3D-63081.
        LocalSPM::GetInstance().GetBTControl().SendEventByName("NOW_PLAYING_CONTENT_CHANGED", IN NULL);
    }
}
void BTDaemonProxy::StoreNowPlayingMetadata(std::vector<std::string>& tokens)
{
    ENTRY;

    tBoolean bMetadataChanged = false;
    tBoolean bMediaLengthChanged= false;

    unsigned int limit = static_cast<unsigned int>(tokens.size());
    VARTRACE(limit);

    for (unsigned int index = 0; index < limit; index++)
    {
        if (tokens[index].compare("CoverArtHandle") == 0)
        {
            if((index+1) < limit)
            {
                if(mNowPlayingAlbumArtHandle.compare(tokens[index + 1]) != 0)
                {
                    mNowPlayingAlbumArtHandle = tokens[index + 1];
                    bMetadataChanged = true;
                }
                index++;
            }
        }
        else if(tokens[index].compare("Item") == 0)
        {
            if((index+1) < limit)
            {
                if(mNowPlayingObjectPath.compare(tokens[index + 1]) != 0)
                {
                    mNowPlayingObjectPath = tokens[index + 1];
                    bMetadataChanged = true;
                }
                index++;
            }
        }
        else if (tokens[index].compare("Title") == 0)
        {
            if((index+1) < limit)
            {
                if(strcmp(mNowPlayingMetadata3,tokens[index + 1].c_str()))
                {
                    snprintf(mNowPlayingMetadata3, sizeof(mNowPlayingMetadata3), "%s", tokens[index + 1].c_str());
                    bMetadataChanged = true;
                }
                index ++;
            }
        }
        else if (tokens[index].compare("Artist") == 0)
        {
            if((index+1) < limit)
            {
                if(strcmp(mNowPlayingMetadata2,tokens[index + 1].c_str()))
                {
                    snprintf(mNowPlayingMetadata2, sizeof(mNowPlayingMetadata2), "%s", tokens[index + 1].c_str());
                    bMetadataChanged = true;
                }
                index ++;
            }
        }
        else if (tokens[index].compare("Album") == 0)
        {
            if((index+1) < limit)
            {
                if(strcmp(mNowPlayingMetadata4,tokens[index + 1].c_str()))
                {
                    snprintf(mNowPlayingMetadata4, sizeof(mNowPlayingMetadata4), "%s", tokens[index + 1].c_str());
                    bMetadataChanged = true;
                }
                index ++;
            }
        }
        else if (tokens[index].compare("Genre") == 0)
        {
            if((index+1) < limit)
            {
                if(strcmp(mNowPlayingMetadata1,tokens[index + 1].c_str()))
                {
                    snprintf(mNowPlayingMetadata1, sizeof(mNowPlayingMetadata1), "%s", tokens[index + 1].c_str());
                    bMetadataChanged = true;
                }
                index ++;
            }
        }
        else if (tokens[index].compare("Medialength") == 0)
        {
            if((index+1) < limit)
            {
                mtotalPlayTime = (tPlaytime) atoi(tokens[index + 1].c_str());
                bMediaLengthChanged = true;
                index ++;
            }
            ETG_TRACE_USR1(("BTEvolutionProxy::StoreNowPlayingMetadata mtotalPlayTime = %d ",mtotalPlayTime));
        }
        else if (tokens[index].compare("TrackNumber") == 0)
        {
            if((index+1) < limit)
            {
                tObjectID tempobjectID = (tObjectID) atoi(tokens[index + 1].c_str());
                if(tempobjectID != mObjectID)
                {
                    mObjectID = tempobjectID;
                    bMetadataChanged = true;
                }

                index ++;
            }
            ETG_TRACE_USR1(("BTEvolutionProxy::StoreNowPlayingMetadata mObjectID = %d ",mObjectID));
        }
    }

    tResult ret = MP_NO_ERROR;
    tAllParameters parameterString;
    size_t size = sizeof(parameterString);

    if(bMetadataChanged)
    {
        //Set CoverArtInfo if EnableBTNowPlayingCoverArt is enabled.
        if(LocalSPM::GetDataProvider().EnableBTNowPlayingCoverArt() && !mNowPlayingAlbumArtHandle.empty())
        {
            tBTCoverArtInfo coverArtInfo;
            coverArtInfo.objectID = mObjectID;
            coverArtInfo.coverArthandle = mNowPlayingAlbumArtHandle;
            coverArtInfo.mediaItemObjectPath = mNowPlayingObjectPath;
            LocalSPM::GetInstance().GetBTControl().SetCoverArtInfo(IN coverArtInfo);
        }

        ret = LocalSPM::GetInstance().GetBTControl().ParameterPLAYBACK_STATUS_RESPONSE(OUT parameterString, IN size,
                IN getPlaybackState(), IN mNowPlayingMetadata1, IN mNowPlayingMetadata2, IN mNowPlayingMetadata3,
                IN mNowPlayingMetadata4,IN mObjectID);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string"));
        }
        else
        {
            ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "PLAYBACK_STATUS_RESPONSE",
                    IN parameterString);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
            }
        }
    }
    else
    {
        ETG_TRACE_USR4(("BTEvolutionProxy::StoreNowPlayingMetadata Metadata not changed"));
    }

    if(bMediaLengthChanged)
    {
        ret = LocalSPM::GetInstance().GetBTControl().ParameterTICK_TIME_ELAPSED(OUT parameterString, IN size,
                IN GetElapsedPlayTime(), IN mtotalPlayTime);
        if (MP_NO_ERROR != ret)
        {
            ETG_TRACE_ERR(("Error while preparing parameter string"));
        }
        else
        {
            ret = LocalSPM::GetDeviceDispatcher().RouteMessage(IN mSMObserver, IN "TICK_TIME_ELAPSED",
                    IN parameterString);
            if (MP_NO_ERROR != ret)
            {
                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
            }
        }
    }
    else
    {
        ETG_TRACE_USR4(("BTEvolutionProxy::StoreNowPlayingMetadata MediaLength not changed"));
    }

}

void BTDaemonProxy::setPlayerObjectPath(string objectPath)
{
    ENTRY

    mPlayerInfo.objectPath = objectPath;

}
