/**
 * @addtogroup iPodControl
 * @author Ulrich Deuper
 *
 * iPod media path class
 * @{
 */

#ifndef IPODCONTROLMEDIAPATH_H_
#define IPODCONTROLMEDIAPATH_H_

//includes
#include "iPodControlCommon.h"

/** 
 * iPod control handle class
 */
class iPodControlMediaPath
{

public:
    iPodControlMediaPath();
    iPodControlMediaPath(const tListType listType, const int tag1 = -1,
            const int tag2 = -1, const int tag3 = -1, const int tag4 = -1); /**< constructor */

    iPodControlMediaPath& operator=(const iPodControlMediaPath &other);     /**< operator */
    tBoolean IsSame(const iPodControlMediaPath &other);                     /**< operator */

    bool ReuseList(const iPodControlMediaPath &other);                      /**< and reuse selection, compare list */

    tBoolean IsValid() const;                                               /**< is a valid path */
    tBoolean IsDBPath() const;                                              /**< is a database record or playback */
    tBoolean IsVideo() const;                                               /**< is a database record representing video content */
    tBoolean IsPlaylist() const;                                            /**< is a database record representing playlist */
    tBoolean IsPlaylistList() const;                                        /**< is a database record representing playlist */
    tBoolean IsLTYChapter() const;                                          /**< is a chapter list type */
    tBoolean IsLTYCount() const;                                            /**< is a count list type */
    tBoolean IsLTYSupported() const;                                        /**< is a supported LTY */
    tBoolean IsLTYRemoteActivity() const;                                   /**< is a remote activity LTY */

    int GetIndexOfIPODCategory(const int cat) const;                        /**< convert lists type to IPOD_CATEGORY index*/
    int GetCurrentIPODCategory() const;                                     /**< return top iPod category selection*/

    int GetCurrentCount() const;                                            /**< return current count */
    void SetCurrentCount(const int count);                                  /**< set current count */

    int GetCount(const int category) const;                                 /**< return current count */
    void SetCount(const int category, const int count);                     /**< set current count */

    string GetName(const int category) const;                               /**< return current name */
    void SetName(const int category, const string str);                     /**< set current name */

    void ResetSelection();                                                  /**< reset all count */

    void GetURL(tURL &url, const int trackIndex, const int chapterIndex,
            const tU64 uuid, const tU64 parentUuid, const char* name, const int specialID = 0) const;         /**< return value for filename url */

    tBoolean Increment();                                                   /**< set next valid path */

private:
    tListType ConvertLTYCountToLTY(const tListType listType) const;         /**< convert LTY_COUNT to matching LTY */
    tListType ConvertLTYToLTYCount(const tListType listType) const;         /**< convert LTY_COUNT to matching LTY */

    tListType mListType;
    int mTag1;
    int mTag2;
    int mTag3;
    int mTag4;
    tIPODCategoryCounts mCounts;
    tIPODCategoryNames mNames;
};

#endif /*IPODCONTROLMEDIAPATH_H_*/

/** @} */
