#ifndef  _TOUCHEVENTHANDLER_H_
#define  _TOUCHEVENTHANDLER_H_


#define TOUCHEVENT_DEVNAME            "Atmel maXTouch Touchscreen"
#define TOUCHEVENT_DEVNAME_MATCH_LEN  26

#define BITS_PER_LONG 	(sizeof(long) * 8)
#define NBITS(x) 		((((x)-1)/BITS_PER_LONG)+1)
#define OFF(x)  		((x)%BITS_PER_LONG)
#define BIT(x)  		(1UL<<OFF(x))
#define LONG(x) 		((x)/BITS_PER_LONG)
#define test_bit(bit, array)	((array[LONG(bit)] >> OFF(bit)) & 1)
#define KEYCODE 		8


#define EVENT_MAX_RETRY	3
#define TOUCH_ACTION_ON 0
#define TOUCH_ACTION_OFF 1
#define MAXXCOORDINATE 1280
#define MAXYCOORDINATE 768



class TouchEventListener
{

public:
    virtual int SendTouchCommand(unsigned char Action, unsigned short Xcod, unsigned short Ycod, unsigned short maxXcod, unsigned short maxYcod) = 0;
};


class TouchEventHandler
{

public:
    int toucheventhandler_monitor_start(void);
    void toucheventhandler_monitor_stop(void);
    TouchEventHandler();
    ~TouchEventHandler();
    void setEventListener(TouchEventListener* listener);
private:
    char* find_input_device(const char* matchName, int matchlen);
    static void *toucheventhandler_monitor_thread(void *device_path);
    bool m_bInputPresent;
    bool m_bMonitorThreadStarted;
    static TouchEventListener* m_listener;
};



#endif
