/*
 * MTPVTCache.h
 *
 *  Created on: Dec 27, 2013
 *      Author: Dinesh
 */

#ifndef MTPCACHE_H_
#define MTPCACHE_H_
#include "libmtp.h"   // use mediaplayer specific libmtp
#include <TypeDefinitions.h>
#include "Lock.h"


typedef struct
{
    uint32_t item_id;       /**< Unique item ID */
    uint32_t parent_id;     /**< ID of parent folder */
    uint32_t storage_id;    /**< ID of storage holding this file */
    tURL filename;    /**< Filename of this file */
    tFileType filetype; /**< Filetype used for the current file */
    tFileFormat fileFormat; /**< Format used for the current file */
}tMTPFileElement;

typedef struct
{
    uint32_t    item_id;       /**< Unique item ID */
    char        name[1024];    /**< Filename of this file */
    bool        isRead;
}tMTPStorageElement;

typedef struct
{
    int         folderid;
    int         readindex;  /**< index of the element read*/
    int         totalitem;  /**< Number of items present in the folder*/
    int         readstatus; /**< read status of the folder*/
    char        filepath[1024];
    unsigned int storageId;
}tMTPFolderElement;

typedef struct {
    uint32_t item_id; /**< Unique item ID */
    char filename[1024]; /**< Filename of this file */
    uint64_t filesize; /**< Size of file in bytes */
    LIBMTP_filetype_t filetype; /**< Filetype used for the current file */
}tMTPFile;

const tMTPStorageElement* MTPCache_ReadStorageEntry(const char* mountPoint,int index);
int MTPCache_WriteStorageEntry(const char* mountPoint,int index ,LIBMTP_devicestorage_t *storage);
int MTPCache_GetStorageCount(const char* mountPoint);
int MTPCache_GetReadStorageCount(const char* mountPoint);
char*  MTPCache_GetStorageName(const char* mountPoint, unsigned int storageId);

const tMTPFileElement* MTPCache_ReadBrowseEntry(int parentID,int index,tDeviceID deviceId);
int MTPCache_WriteBrowseEntry(int parentID, int index, const tMTPFile file,tDeviceID deviceId);
int MTPCache_GetFileCount(int parentID,tDeviceID deviceId);

int MTPCache_StorePath(const char* path, int itemID, tDeviceID deviceId);
int MTPCache_GetItemID(const char* path,tDeviceID deviceId);
int MTPCache_GetFolderCount(tDeviceID deviceId);
//int MTPCache_StoreFolderID(int index, int folderID);
int MTPCache_StoreFolderID(tDeviceID deviceId,int folderID, char* path,unsigned int storageId);
int MTPCache_getNextParentFolderID(tDeviceID deviceId);
int MTPCache_getParentFolderStorageID(tDeviceID deviceId);
int MTPCache_DeleteParentFolderID(tDeviceID deviceId,int folderId);
int MTPCache_getReadIndex(tDeviceID deviceId , int folderid);
char* MTPCache_getFolderPath(tDeviceID deviceId,int folderid);
int MTPCache_setReadIndex(tDeviceID deviceId ,int folderid, uint32_t readindex);
int MTPCache_setFolderReadingStatus(int readstatus);
int MTPCache_setItemCountInFolder(tDeviceID deviceId,int folderid, uint32_t itemcount);
int MTPCache_getFolderReadingStatus(void);
int MTPCache_ClearFolderList(tDeviceID deviceId);
int MTPCache_SetStorageID(int storageid, char* path);
int MTPCache_GetStorageID(void);
int MTPCache_DeleteStorageID(void);
int MTPCache_ClearStorage(const tMountPoint mountPoint);
tMTPStorageElement* MTPCache_GetCurrentStorage(const tMountPoint mountPoint);
void MTPCache_SetCurrentStorage(const tMountPoint mountPoint,unsigned int storageId);
uint32_t MTPCache_GetStorageIDFromMountPoint(const tMountPoint mountpoint, const char* path);
void MTPCache_StoreDeviceId(tDeviceID deviceId, const tMountPoint mountpoint);
tDeviceID MTPCache_GetDeviceId(const tMountPoint mountpoint);
void MTPCache_ClearBrowseEntry(tDeviceID deviceId);
void MTPCache_ClearItemPath(tDeviceID deviceID);
void MTPCache_ClearItemId(tDeviceID deviceId );
void MTPCache_ClearCacheEntry(tDeviceID deviceId);
#endif /* MTPCACHE_H_ */
