#ifndef DVDCONTROLINTERFACE_H
#define DVDCONTROLINTERFACE_H

#include "TypeDefinitions.h"
#include <sys/ioctl.h>
#include <scsi/sg.h> /* take care: fetches glibc's /usr/include/scsi/sg.h */
#include <scsi/scsi.h>
#include <semaphore.h>
#include "ThreadFactory.h"
#include "Lock.h"
#include "DVDBackendCMD.h"

#define CD_MAX_TRACK_NUMBER         99
#define CD_SCSI_IF_TOC_ENTRY_LEN           8
#define CD_SECONDS_PER_MINUTE       60
#define CD_SECTORS_PER_SECOND       75
#define CDAUDIO_CDTEXT_TEXT_BUFFER_LEN      256 /*255 bytes text+trailing zero*/
#define DVD_SCSI_IF_SG_CMD_TIMEOUT_MS       10000
#define DATA_BUFFER_LENGTH 256
#define CD_8TO16(_HI_,_LO_)   ((((unsigned short)(_HI_)) << 8) | ((unsigned short)(_LO_)&0xFF))
#define CD_MSF2ZLBA(M,S,F)     (((unsigned int)(M) * CD_SECONDS_PER_MINUTE  \
                               + (unsigned int)(S)) * CD_SECTORS_PER_SECOND \
                               + (unsigned int)(F))

#define RESPONSE_ON true
#define RESPONSE_OFF false

#define CD_SCSI_IF_SG_TOC_BUFFER_LEN       1200
#define CDAUDIO_ATA_CDTEXT_RAW_BUFFER_LEN  5000

using namespace std;
#pragma pack(1)

struct command_packet{
    unsigned char opcode;
    unsigned char direction;
    unsigned char reserved[5];
    unsigned short len;
    unsigned char reserved2[3];
};
#pragma pack()

typedef struct
{
    unsigned char* p_CommandBuffer;
    unsigned char commandLength;
    unsigned char senseBuffer[18];
    unsigned char* p_ResponseBuffer;
    short responseBufferLength;
}tScsiCmd;

typedef struct
{
    unsigned char totalTrack;
    unsigned char trackTimeMinutes;
    unsigned char trackTimeSeconds;
    unsigned char discIDCodeLower;
    unsigned char discIDCodeUpper;
}tDiscInfo;

typedef struct
{
    unsigned char u8Title[DATA_BUFFER_LENGTH];
    unsigned char u8Performer[DATA_BUFFER_LENGTH];
    unsigned char u8LanguageIndex;
    unsigned char u8CharacterCode;
    bool valid;
}tCDText;

typedef struct
{
    tU16 CurrentX;
    tU16 CurrentY;
    tU16 OverallX;
    tU16 OverallY;
    tTouchControl touchCommand;
}TouchInput;

typedef struct
{
    unsigned char PTimeHours;
    unsigned char PTimeMinutes;
    unsigned char PTimeSeconds;
    unsigned char ATimeHours;
    unsigned char ATimeMinutes;
    unsigned char ATimeSeconds;
    unsigned char RTimeHours;
    unsigned char RTimeMinutes;
    unsigned char RTimeSeconds;
    unsigned char currentTrackTotalHours;
    unsigned char currentTrackTotalMinutes;
    unsigned char currentTrackTotalSeconds;
    unsigned char currentChapterRemHours;
    unsigned char currentChapterRemMinutes;
    unsigned char currentChapterRemSeconds;
    unsigned char currentTrackIndex;
    tU16 mCurrentTrackPlaying;
    tU16 mCurrentGroupPlaying;
    tU16 totalChapter;
    tPEPlaybackState PBState;
    me::speed_e speed;
    tPEPosition position;
    tPEDuration duration;
    tPEHandle m_PEhandle;
    tU8 m_playBackMode;
    tU8 m_playbackState;
}tPLayBackInfo;

typedef unsigned char TOCTextBuffer[CDAUDIO_ATA_CDTEXT_RAW_BUFFER_LEN] ;
typedef unsigned char ResumeBuffer[256] ;



typedef enum
{
    DVD_EVENT_DISC_TYPE = 0,
    DVD_EVENT_DISC_ERROR,
    DVD_EVENT_MECHANICAL_STATUS,
    DVD_EVENT_CD_TEXT,
    DVD_EVENT_PLAYBACK_STATE,
    DVD_EVENT_PLAYTIME,
    DVD_EVENT_PLAYBACK_MODE,
    DVD_EVENT_DISPLAY_MODE,
    DVD_EVENT_SKIP_MODE,
    DVD_EVENT_DIRECTSELECT_MODE,
    DVD_EVENT_DRC_SETTINGS,
    DVD_EVENT_ANGLE_MARK_SETTING,
    DVD_EVENT_DVD_LANGUAGE_SETTING,
    DVD_EVENT_KEY_RESPONSE,
    DVD_EVENT_MENUPLAYBACK_MODE,
    DVD_EVENT_DRIVEMODE,
    DVD_EVENT_TRACK_CHANGE
}tDVDEventID;
typedef enum
{
FUNC_COMMAND_OFF = 0x00,
FUNC_COMMAND_TRACK_SCAN = 0x01,
FUNC_COMMAND_TRACK_REPEAT= 0x02,
FUNC_COMMAND_RANDOM = 0x03,
FUNC_COMMAND_GROUP_REPEAT= 0x05,
FUNC_COMMAND_ONE_TRACK_PLAY = 0x06,
FUNC_COMMAND_CYCLIC_REPEAT = 0x07
}tPlaybackFunctionControl;

typedef struct
{
tU16 mCurrentTrackPlaying;
tU16 mCurrentGroupPlaying;
tPEPlaybackState PBState;
me::speed_e speed;
tPEPosition position;
tPEDuration duration;
tPEHandle m_PEhandle;
}tDVDPlayBackState;

typedef struct
{
    unsigned char AngleNumber;
    unsigned char TotalAngle;
    bool bCommandEnable;
}tDVDAngleInfo;

typedef struct
{
    bool SubtitleStatus;
    unsigned char CurrentSubtitleNumber;
    unsigned char TotalSubtitleNumber;
    unsigned char SubtitleLangCode[2]; //ASCII value of the language
    bool bCommandEnable;
}tDVDSubtitleInfo;

typedef struct
{
    tU16 totalAudioChannels;
    tU8 SoundFormat;
    tU16 AudioOutputDVD;
    tU16 AudioOutputDVDVR;
    tU16 AudioOutputVCD;
    unsigned char  AudioLangCode[2];
    bool bCommandEnable;
}tDVDAudioOutputInfo;

typedef struct
{
    tU8  totalChannels;
    bool subWooferAvailable;
    tU8 frequency;
    tU8 currentAssignment;
}tDVDAudioChannelInfo;

typedef struct
{
    unsigned char DVDVideoAudioLang[2];
    unsigned char DVDVideoSubtitleLang[2];
    unsigned char DVDVideoMenuLang[2];
    tDvdVideoRegionCode  RegionCode;
    tDisplaySetting DisplayMode;
    bool AngleMark;
    bool PlayStatus;
    tVideoOutputMode VideoOutputmode;
    tComponentVideoMode ComponentVideo;
    tAudioChannelDownMixing downMixing;
    tDRC DRCSetting;
}tDVDSetupInfo;

class DVDControlInterfaceCallback {
public:
    virtual void update(me::state_t currentState) { };
    virtual void resendNowPlaying(tBoolean resend) { };
    virtual void signalEvent(tDVDEventID dvdEventId , tU8 value){ };
    virtual void signalPlayBackState(tDVDPlayBackState&){ };
    virtual void signalResumeInfo(ResumeBuffer& resumeBuffer){ };
    virtual void signalEventSubtitleChange(tDVDSubtitleInfo&){ };
    virtual void signalEventAngleChange(tDVDAngleInfo&){ };
    virtual void signalEventCurrentAudioChange(tDVDAudioOutputInfo&){ };
    virtual void signalEventAudioInfoChange(tDVDAudioChannelInfo&){ };
    virtual void signalEventSetupInfoChange(tDVDSetupInfo&){ };
    virtual void signalEventTemperatureChange(tU16){};
};


class DVDControlInterface : public TFThread
{
public:
    DVDControlInterface();
    ~DVDControlInterface();

    int DeInitialize();
    tResult Initialize(const tMountPoint mountPoint, int ConfigureFPGA = 0 , int regionCode = 0 , bool isDataDisc = false);
    void  DoPolling();
    void Do(int functionID, void *ptr);
    void RegisterCallbacks(DVDControlInterfaceCallback *callbacks);
      tResult play(IN const tURL url, IN const me::speed_e speed, IN const tPlaytime position, IN const tPEHandle handle);
      tResult directPlay();
      tResult pause(IN bool queue = true);
      tResult resume();
      tResult stop(bool queue = true);
      tResult next(bool queue = true);
      tResult previous(bool queue = true);
      tResult seek(IN const me::speed_e speed, IN const tPlaytime position);
      tResult frevStart(tCueingRate rate);
      tResult srevStart(tCueingRate rate);
      tResult frevStop();
      tResult ffwdStart(tCueingRate rate);
      tResult sfwdStart(tCueingRate rate);
      tResult ffwdStop();
      void getParameter(OUT tPEHandle &handle,
              OUT tPEPlaybackState &peState, OUT me::reason_e &reason, OUT me::speed_e &speed);
     int SwitchtoBackendMode(IN bool queue = true);
     int SwitchtoMassStorageMode(IN bool queue = true);
     int SwitchtoMassStorageModeDisablePolling();
     tResult readDiscInformation(IN bool queue = true);
     void resetToc();
     tResult readCDTEXTAlbum(IN bool queue = true);
     tResult readCDTEXTbyTrack(IN unsigned char tracknumber,IN bool queue = true);
     unsigned char getNumberOfTracks();
     tResult readToc( tCDTOCInfo&  TOCAddressBuffer);
     tResult oneTrackPlay(unsigned char trackNumber);
     tResult setPlaybackMode(tPlaybackFunctionControl playbackmode);
     tResult getTrackTextInfo(OUT tFiles *tocDataOneTrack,unsigned char trackIndex);
     tResult setSubtitle(tSubtitleControl , unsigned char subtitleNumber) ;
     tResult setAudioChannel(unsigned char selection , unsigned char audioChannel);
     tResult sendNavigationCommand(unsigned char naviKey);
     tResult titleSearch(tU16 titleNumber);
     tResult directSearch(tU16 groupNumber,tU16 trackNumber);
     tResult directNumber(tU16 directNumber);
     tResult setAngle(unsigned char selection , unsigned char angleNumber);
     void StoreResumeInformationData(unsigned char* dataBuffer, unsigned int length , bool bDriveResumeInfo = false);
     tResult ejectDisc();
     tResult sendTouchCommand(TouchInput& ptouchInput);
     tResult CMSkip(tSkipTiming skipTime);
     tResult setMenuPlayback(tMenuControl menuSelection);
     void StoreSetupInformationData(tDVDSetupInfo&);
     tResult ChangeSetupInformationData(tDVDSetupInfo& setupInfo);
     void GetSetupInformationData(tDVDSetupInfo& setupInfo);
     tResult setDeviceActive(bool deviceStatus, int setFPGARegistry = 0);
     tResult getTemperature();
     tOperationModeStatus getDriveMode();
     void revertModetoBackend();

private:
      tOpInfoData m_OpInfoData;
      TOCTextBuffer mTOCResponseBuffer;
      bool isResumeInformationSetupCompleted;
      tCDTOCInfo mToc;
      bool mTocRead;
      int mTrackCount;
      bool m_bCDTextInfoRead ;
      int SendBackEndCMDHostToDrive(tU8* cmd,tU16 cmdLength);
      int SendResumeInformationData();
      int SendSetupInformationData(bool queue = false);
      int  AnalyzeDataResponse(unsigned char* data,int length);
      int  AnalyseDataRead(unsigned char* data,int length);
      void  AnalyzeAudioInfoData(unsigned char* dataBuffer , int bufferLength);
      void AnalyzeSetupInformationData(unsigned char* dataBuffer , int bufferLength);
      int  AnalyzeOperationInfoData(unsigned char* dataBuffer , int bufferLength);
      int  AnalyzeDiscInfoData(unsigned char* dataBuffer , int bufferLength);
      int  AnalyseCDTextResponse(unsigned char* dataBuffer , int bufferLength);
      void AnalyzeTemperatureResponse(unsigned char* dataBuffer , int bufferLength);
      int  SendDiscInformationDataRequest(bool queue = true);
      int  SendOperInformationDataRequest(bool queue = true);
      tResult readCDText();
      void clearCDText();
      void PrepareResumeInformationDataSetCmd();
      void PrepareSetupInformationDataSetCmd();
      tResult ExecuteMessage(tU8* cmd,tU32 cmdLength, bool bkeyResponseRequired = true);
      tResult AddMessageToQueue(tU8* cmd,tU32 cmdLength, bool bkeyResponseRequired = true);
      void SendMessageFromQueue();
      tResult ReadStatusAndClearMessageFromQueue();
      void GetSense();
      tResult getCDTextInfo(OUT tFiles *tocDataOneTrack,unsigned char trackIndex);
      void prepare_SG_IO_Command(bool awaitingResponse);
      int run_SG_IO_Command();
      int ReadDataFromDriveToHost(unsigned char* buffer,short bufferLength, int& dataTransferedLength);
      bool isMessageAvailable();
      tResult setCDText(unsigned int u32ATACDTextLen , unsigned char* mResponseBuffer);
      void convertPlayTimeInformation();
      void readResumeInfoFromFile();
      void CheckPlayTimeInfo(unsigned char*);
      void CheckSubtitleInfo(unsigned char*);
      void CheckAngleInfo(unsigned char);
      void CheckCurrentAudioOutputInfo(unsigned char*);
      void CheckDisplayAspectRatio(unsigned char);
      void CheckCMSkipAvailability(unsigned char);
      void CheckDirectButtonAvailability(unsigned char);
      void CheckCommand(unsigned char data);
      void AnalyzeKeyResponse(unsigned char* dataBuffer , int bufferLength);
      void checkForKeyCommand(unsigned char);
      bool getDeviceActive();
      void convertHexEquivalentDecimal(unsigned char &byte);
      void selectDvdI2sline();
      void selectDvdBT656Line();
      void selectFPGAForDVDPlayback();
      int i2cRead(T_I2CDATA i2cdata,unsigned char* inputbufr,unsigned char len);
      int i2cWrite(T_I2CDATA i2cdata,unsigned char* data,unsigned char len);
};

#endif // DVDCONTROLINTERFACE_H
