#ifndef _DVDBACKENDCMD_H_
#define _DVDBACKENDCMD_H_

typedef enum {
BE_COMMAND_REQUEST_SYSTEM = 0x30 ,
BE_COMMAND_REQUEST_SYSTEM_LOAD_EJECT = 0x00 ,
BE_COMMAND_REQUEST_SYSTEM_POWER = 0x01,
BE_COMMAND_REQUEST_SYSTEM_MODE = 0x03,
BE_COMMAND_REQUEST_DATA_INFO = 0x40,
BE_COMMAND_REQUEST_DATA_INFO_OPERATION = 0x00,
BE_COMMAND_REQUEST_DATA_INFO_DISC = 0x01,
BE_COMMAND_REQUEST_DATA_INFO_FOLDER = 0x02  ,
BE_COMMAND_REQUEST_DATA_INFO_VERSION = 0x03,
BE_COMMAND_REQUEST_DATA_INFO_TEMPERATURE = 0x07  ,
BE_COMMAND_REQUEST_TEXT = 0x41,
BE_COMMAND_REQUEST_TEXT_CD = 0x00,
BE_COMMAND_REQUEST_TEXT_FILE_NAME = 0x01,
BE_COMMAND_REQUEST_TEXT_FILE_INFO = 0x02,
BE_COMMAND_REQUEST_TEXT_DVD_VR = 0x03,
BE_COMMAND_RESPONSE_INFO = 0x60,
BE_COMMAND_RESPONSE_INFO_SETUP = 0x00,
BE_COMMAND_RESPONSE_INFO_RESUME = 0x01,
BE_COMMAND_REQUEST_KEY = 0x50, //////////// All the above commands are from host to driver
BE_COMMAND_REQUEST_INFO = 0xB0,
BE_COMMAND_REQUEST_INFO_SETUP = 0x00,
BE_COMMAND_REQUEST_INFO_RESUME = 0x01,
BE_COMMAND_COMP_NOTIFICATION = 0xA0,
BE_COMMAND_COMP_NOTIFICATION_SETUP = 0x00,
BE_COMMAND_COMP_NOTIFICATION_RESUME = 0x01,
BE_COMMAND_COMP_NOTIFICATION_FUNCTION = 0x02,
BE_COMMAND_RESPONSE_AUDIO_INFO = 0xA1,
BE_COMMAND_RESPONSE_DATA_INFO = 0xD0,
BE_COMMAND_RESPONSE_DATA_INFO_OPERATION = 0x00  ,
BE_COMMAND_RESPONSE_DATA_INFO_DISC = 0x01,
BE_COMMAND_RESPONSE_DATA_INFO_FOLDER = 0x02 ,
BE_COMMAND_RESPONSE_DATA_INFO_VERSION = 0x03,
BE_COMMAND_RESPONSE_DATA_INFO_TEMPERATURE = 0x07 ,
BE_COMMAND_RESPONSE_TEXT = 0xD1,
BE_COMMAND_RESPONSE_TEXT_CD = 0x00,
BE_COMMAND_RESPONSE_TEXT_FILE_NAME = 0x01,
BE_COMMAND_RESPONSE_TEXT_FILE_INFO = 0x02,
BE_COMMAND_RESPONSE_TEXT_DVD_VR = 0x03,
BE_COMMAND_RESPONSE_KEY = 0xC0,
BE_COMMAND_NULL_DATA = 0xF0 //////////// All the above commands are from driver to host
}tBECommands;



typedef enum {
DVD_VIDEO_REGION_CODE_1= 0x01,
DVD_VIDEO_REGION_CODE_2= 0x02,
DVD_VIDEO_REGION_CODE_3= 0x04,
DVD_VIDEO_REGION_CODE_4= 0x08,
DVD_VIDEO_REGION_CODE_5= 0x10,
DVD_VIDEO_REGION_CODE_6= 0x20
 } tDvdVideoRegionCode; // byte 3h


#define PLAYER_DISC_SETTING 0x1C //Support all disc types – byte 04h
#define OSD_SUPPORT 0x10 // byte 05h
#define POWER_ON_RESET 0x00 // byte 07h
#define DEFAULT_LANGUAGE 0xffff // byte 43-44h, 45-46h, 47-48h
#define DEFAULT_INVALID 0xff
#define DEFUALT_RESERVED 0x00
#define AUDIO_FILE_SUPPORT 0x07 // Byte 55h
#define POLLING_TIMEOUT 50000 // 50ms

typedef enum {
POWER_ON_RESET_ON = 0x00,
POWER_ON_RESET_OFF= 0x01
} tPowerOnReset; // byte 07h

typedef enum{
DEFAULT_DISPLAY_16_9= 0x00,
LETTER_DISPLAY_4_3= 0x01,
PAN_DISPLAY_4_3 = 0x02
} tDisplaySetting ;// byte 50h

typedef enum{
ANGLE_MARK_OFF = 0x00,
ANGLE_MARK_ON= 0x04
} tAngleMarkSetting ;// byte 50h

typedef enum{
DEFAULT_DISPLAY_NTSC = 0x00,
DEFAULT_DISPLAY_PAL = 0x01,
NTSC_DISPLAY= 0x10,
PAL_DISPLAY= 0x11
} tVideoOutputMode; //Byte  64h

typedef enum{
OSD_PLAY_STATUS_ON= 0x01,
OSD_PLAY_STATUS_OFF= 0x00
} tOSDPlayStatus; //Byte  66h

typedef enum{
VIDEO_MODE_DEFAULT = 0x00,
COMPONENT_VIDEO_MODE = 0x01,//01
PROGRESSIVE_SCAN_DEFAULT_VIDEO_MODE = 0x02,
PROGRESSIVE_SCAN_COMPONENT_VIDEO_MODE  = 0x0A
} tComponentVideoMode; //Byte  68h

typedef enum{
AUDIO_CHANNEL_STEREO_SUPPORT= 0x00,
AUDIO_CHANNEL_DOLBY_SUPPORT = 0x10
} tAudioChannelDownMixing; //Byte  83h

typedef enum{
NORMAL_COMPRESSION= 0x0A,
WIDE_COMPRESSION = 0x00,
BOOST_COMPRESSION = 0x0F,
} tDRC; //Byte  8Ah

typedef enum{
LOAD_DISC = 0x00,
EJECT_DISC = 0x01
} tDiscMechanism;// Disc Mechanical Operation

typedef enum{
COMMAND_POWER_ON = 0x00,
COMMAND_POWER_OFF = 0x01
} tPowerMode; // Power Mode

typedef enum{
SELECT_MASS_STORAGE_MODE = 0x00,
SELECT_BACKEND_MODE = 0x01
} tModeSelection; // Drive Mode Selection

typedef enum{
KEY_STOP = 0x00,
KEY_PAUSE = 0x01,
KEY_PLAY = 0x02,
KEY_FAST_FWD = 0x03,
KEY_FAST_BWD = 0x04,
KEY_SLOW_FWD = 0x05,
KEY_SLOW_BWD = 0x06,
KEY_RELEASE = 0x07,
KEY_UP = 0x08,
KEY_DOWN = 0x09,
KEY_FUNCTION = 0x0A,
KEY_PROGRAM_SEARCH = 0x0B,
KEY_TITLE_SEARCH = 0x0C,
KEY_TIME_SEARCH = 0x0D,
KEY_STEP = 0x0E,
KEY_SUBTITLE = 0x0F,
KEY_AUDIO = 0x10,
KEY_ANGLE = 0x11,
KEY_MENU = 0x12,
KEY_ENTER = 0x13,
KEY_RETURN = 0x14,
KEY_CURSOR = 0x15,
KEY_DIRECT_NUMBER = 0x16,
KEY_DIRECT_SEARCH = 0x18,
KEY_PAGE_UP = 0x1B,
KEY_PAGE_DOWN = 0x1C,
KEY_TOUCH = 0x1F,
KEY_DVD_VR_PROGRAM_SEARCH = 0x20,
KEY_DVD_VR_PLAYLIST_SEARCH = 0x21,
KEY_SKIP = 0x22
} tPlayBackKeyCommand;// Play Back Key Operation

typedef enum
{
FILE_UP_DOWN = 0x00,
FOLDER_UP_DOWN = 0x01
}tUpDownOperationMode;

typedef enum
{
TRACK_ONLY = 0x00,
TRACK_STEP_SWITCH = 0x01
}tUpDownStepControl;


typedef enum
{
STEP_FORWARD = 0x00,
STEP_BACKWARD = 0x01
}tStepControl;

typedef enum
{
SUB_ON_OFF = 0x00,
SUB_CYCLIC = 0x01,
SUB_REV_CYCLIC = 0x02,
SUB_CYCLIC_WIH_OFF = 0x03,
SUB_REV_CYCLIC_WITH_OFF = 0x04,
SUB_DIRECT = 0x05
}tSubtitleControl;

typedef enum
{
CYCLIC = 0x00,
REV_CYCLIC = 0x01,
DIRECT = 0x02
}tSelectionOrder; // common for audio control , angle control


typedef enum
{
UPPER = 0x00,
LOWER = 0x01,
RIGHT = 0x02,
LEFT = 0x03
}tCursorControl; // cursor control

typedef enum
{
TOP_MENU = 0x00,
MENU = 0x01
}tMenuControl ;

typedef enum
{
TOUCH_ON = 0x00,
TOUCH_OFF = 0x01
}tTouchControl ;

typedef enum
{
SKIP_FWD_15 = 0x0F,
SKIP_FWD_30  = 0x1E,
SKIP_FWD_60  = 0x3C,
SKIP_REV_15 = 0xF1,
SKIP_REV_30  = 0xE2,
SKIP_REV_60  = 0xC4
}tSkipTiming;

typedef enum
{
CD_TEXT_TITLE = 0x80,
CD_TEXT_PERFORMER = 0x81
}tCDTextSelection ;

typedef enum
{
TEXT_NOT_DETERMINED = 0x00 ,
TEXT_NOT_AVAILABLE = 0x01,
TEXT_AVAILABLE = 0x02 ,
TEXT_NO_CHAR_CODE_REQUESTED = 0X03
}tTextSelectionStatus;

typedef enum
{
CD_CHAR_CODE_ISO_8859_1 = 0x00 ,
CD_CHAR_CODE_ISO_646_ASCII = 0x01,
CD_CHAR_CODE_MUSIC_SHIFT_JIS = 0x80,
CD_CHAR_CODE_KOREAN = 0x81,
CD_CHAR_CODE_MANDARIN_CHINESE = 0x82
}tCDTextCharacterCode;

typedef enum
{
LANGUAGE_INDEX_0 = 0x00,
LANGUAGE_INDEX_1 = 0x01,
LANGUAGE_INDEX_2 = 0x02,
LANGUAGE_INDEX_3 = 0x03,
LANGUAGE_INDEX_4 = 0x04,
LANGUAGE_INDEX_5 = 0x05,
LANGUAGE_INDEX_6 = 0x06,
LANGUAGE_INDEX_7 = 0x07
}tCDTextLanguageIndexNumber;

typedef enum
{
DVD_VR_PROGRAM_TITLE = 0x00,
DVD_VR_PLAYLIST_TITLE = 0x10
}tDVDVRTextSelection ;

typedef enum
{
DVD_CHAR_CODE_ISO_646_ASCII = 0x00,
DVD_CHAR_CODE_ISO_8859_1 = 0x11,
DVD_CHAR_CODE_MUSIC_SHIFT_JIS = 0x12,
DVD_CHAR_CODE_KS_C_5601_1987 = 0x13,
DVD_CHAR_CODE_KS_C_5700_1995 = 0x14
}tDVDTextCharacterCode;

typedef enum{
DISC_NO_ERROR = 0x00,
DISC_DVD_VIDEO_REGION_CODE_ERROR = 0x03,
DISC_DVD_VIDEO_PARENTAL_LEVEL_ERROR = 0x13,
DISC_DVD_DESCRAMBLE_FAILED = 0x23,
DISC_READ_ERROR = 0x04,
DISC_UNKNOWN_ERROR = 0x05,
DISC_UNKNOWN_CD_ERROR = 0x15,
DISC_UNKNOWN_DVD_ERROR = 0x25,
DISC_UPDATE_DISC_ERROR = 0x06,
DISC_MECHA_ERROR = 0x99,
DISC_HOT_ERROR = 0x0D
}tDiscErrorCode; // oper info data byte 04h

typedef enum{
DISC_CHUCKING = 0x00,
DURING_DISC_LOADING = 0x01,
DISC_EJECT_FINISH_DISC_EXIST = 0x02,
DURING_DISC_EJECT = 0x12,
DISC_EJECT_FINISH_NO_DISC = 0x22,
DISC_STOP = 0x03,
DISC_MECHANISM_UNDECIDED= 0xFF
} tDiscMechanicalStatus;// oper info data byte 05h

typedef enum{
POWER_OFF = 0x0F,
POWER_ON_STATE_SHIFT = 0x1F,
POWER_OFF_STATE_SHIFT = 0x2F
}tDiscPowerStatus ;// oper info data byte 06h

typedef enum{
DVD_STOP = 0x00,
RESUME_STOP = 0x10,
DVD_PAUSE = 0x02,
DVD_PLAY = 0x01,
PAUSE_PARENTAL_REQUEST = 0x12,
AUTO_PAUSE_STILL = 0x22,
FAST_FWD_1 = 0x03,
FAST_FWD_2 = 0x13,
FAST_FWD_3 = 0x23,
FAST_BWD_1 = 0x04,
FAST_BWD_2 = 0x14,
FAST_BWD_3 = 0x24,
SLOW_FWD_1 = 0x05,
SLOW_FWD_2 = 0x15,
SLOW_FWD_3 = 0x25,
SLOW_BWD_1 = 0x06,
SLOW_BWD_2 = 0x16,
SLOW_BWD_3 = 0x26
}tPlayBackStatus ;// Play Back status oper info data byte 07h

typedef enum{
NOT_SEARCHING = 0x00,
FORWARD_SEARCH = 0x01,
REVERSE_SEARCH = 0x02,
TRACK_REPEAT_SEARCH = 0x03,
DISC_REPEAT_SEARCH = 0x04,
TRACK_SCAN_SEARCH = 0x05,
TRACK_RANDOM_SEARCH = 0x06,
A_TIME_SEARCH = 0x08,
FORWARD_FOLDER_SEARCH = 0x0B,
REVERSE_FOLDER_SEARCH = 0x0C
}tSearchStatus ;// Search status  - oper info data byte 08h

typedef enum{
FUNCTION_OFF = 0x00,
TRACK_SCAN = 0x01,
TRACK_CHAPTER_REPEAT= 0x02,
RANDOM = 0x03,
GROUP_TITLE_REPEAT= 0x05,
ONE_TRACK_PLAY = 0x06,
DISC_REPEAT_ON = 0x10
}tFunctionStatus ;// Function status __X - oper info data byte 09h


typedef enum{
ASPECT_RATIO_4_3 = 0x00, // Bit 0
ASPECT_RATIO_16_9 = 0x01 , // Bit 0  , BIT 1 UNUSED
DVD_NON_MULTI_ANGLE = 0x00, // Bit 2
DVD_MULTI_ANGLE = 0x04, // Bit 2
CD_TRACK_INFO_AUDIO = 0x00, // Bit 2
CD_TRACK_INFO_ROM = 0x04, // Bit 2
DVD_EXCEPT_OF_MENU = 0x00, // Bit 3
DVD_MENU = 0x08, // Bit 3
DATA_DISC_FILE_SUPPORTED = 0x00, // Bit 4
DATA_DISC_FILE_UNSUPPORTED  = 0x10, // Bit 4
DVD_PLAYBACK_ZONE_VIDEO = 0x00, // Bit 5
DVD_PLAYBACK_ZONE_AUDIO = 0x20, // Bit 5
DVD_VR_PLAYBACK_ZONE_MOVIE = 0x00, // Bit 5
DVD_VR_PLAYBACK_ZONE_STILL_PICTURE = 0x20, // Bit 5
DISC_DISPLAY_NTSC = 0x00, // Bit 6
DISC_DISPLAY_PAL = 0x40, // Bit 6
DVD_BUTTON_OPERATION_STATUS_VALID = 0x80, // Bit 7
DVD_BUTTON_OPERATION_STATUS_INVALID = 0x10, // Bit 7
}tDiscInfoDataFlags ; //- oper info data byte 0Bh

typedef enum{
SW_UNDER_UPDATE = 0x00,
SW_NOT_UNDER_UPDATE = 0x80,
}tSoftwareUpdateStatus ;// SW status  - oper info data byte 0Bh

typedef enum{
DVD_VR_PLAYLIST_MODE_OFF = 0x00,
DVD_VR_PLAYLIST_MODE_ON = 0x08
}tDVDPlaylistMode ;// Playlist mode DVD VR status  - oper info data byte 0Bh

typedef enum{
MASS_STORAGE_MODE = 0x00,
TRANSITION_TO_MASS_STORAGE_MODE = 0x10,
BACKEND_MODE = 0x01,
TRANSITION_TO_BACKEND_MODE = 0x11,
INVALID_MODE = 0XFF
}tOperationModeStatus ;// Operation Mode status  - oper info data byte 1Bh

typedef enum
{
VCD_CHANNEL_STEREO = 0x00,
VCD_CHANNEL_LL = 0x10,
VCD_CHANNEL_RR = 0x20,
VCD_CHANNEL_MONO = 0x30,
VCD_CHANNEL_2_STEREO = 0x40,
VCD_CHANNEL_2_LL = 0x50,
VCD_CHANNEL_2_RR = 0x60,
VCD_CHANNEL_2_MONO = 0x70
}tVCDAudioChannelOutput ; // - oper info data byte 2Dh-- X_

typedef enum
{
DVD_AUDIO_BLANK = 0x00,
DVD_AUDIO_1 = 0x10,
DVD_AUDIO_2 = 0x20,
DVD_AUDIO_1_MAIN = 0x50,
DVD_AUDIO_2_MAIN = 0x60,
DVD_AUDIO_1_SUB = 0x90,
DVD_AUDIO_2_SUB= 0xA0,
DVD_AUDIO_1_MAIN_SUB = 0xD0,
DVD_AUDIO_2_MAIN_SUB = 0xE0,
}tDVDAudioChannelOutput; // - oper info data byte 2Dh -- X_

typedef enum
{
AUDIO_LINEAR_PCM = 0x00 ,
AUDIO_CD_DTS = 0x10 ,
AUDIO_DOLBY_DIGITAL = 0x02 ,
AUDIO_MPEG_1_2_WITHOUT_EXTENSION = 0x03 ,
AUDIO_MPEG_2_WITH_EXTENSION = 0x04 ,
AUDIO_DVD_DTS = 0x05 ,
AUDIO_SDDS_RESERVED = 0x06 ,
AUDIO_UNKNOWN = 0xFF,
AUDIO_INVALID = 0xF0
}tAudioCodingMode; // - oper info data byte 2Eh

typedef enum
{
SUBTITLE_ON = 0x80,
SUBTITLE_OFF = 0x00
}tSubtitleStatus ;// - oper info data byte 31h  , BIT 7

typedef enum
{
VALID_OPERATION = 0x00,
PROHIBITED_BY_PLAYER = 0x01,
PROHIBITED_BY_DISC = 0x02,
INVALID_INPUT = 0X03
}tKeyCommandStatus ;// - oper info data byte 31h  , BIT 7

typedef enum
{
INITIAL_PLAY = 0x00,
CONTINOUS_PLAY_FUNC_OFF = 0x01,
CONTINOUS_PLAY_FUNC_ON = 0x02,
}tPlayControl;

typedef enum
{
PLAY_ONLY = 0x00,
PLAY_PAUSE_SWITCH = 0x01
}tPlaySwitch;

typedef enum
{
SPEED_1 = 0x01,
SPEED_2 = 0x02,
SPEED_3 = 0x03
}tForwardReverseSpeed;

/*Dvd Property Update Info types*/

typedef struct
{
    tBool isError;
    tU8 diskError;
}tDvdDiscError;



// For FPGA Settings
//User defined macros
#define FPGA_DEVICE_OPEN_ERR 			-1
#define SERIAL_DEVICE    			"/dev/ttymxc2"
#define I2C_DEVICE       			"/dev/i2c-1"
#define SUB_PCB_FPGA_ADDR			0x10
#define SUB_PCB_FPGA_GPOUT1_ADDR	0x21 //Register address for TV_RESET.
#define SUB_PCB_FPGA_GPOUT2_ADDR	0x22 //Register address for TV_RESET.
#define ADC_SLAVE_ADDR				0x49
#define ADC_CONV_POINTER_REG		0x00
#define ADC_CONFIG_POINTER_REG		0x01

// User Defined data types.
struct T_I2CDATA
{
	const char* devicebusname;
	unsigned char deviceaddr;
	unsigned char registersubaddr;
};
	
#endif
