/*
 * BTDaemonProxy.h
 *
 *  Created on: Oct 16, 2013
 *      Author: din3kor
 */

#ifndef BTDAEMONPROXY_H_
#define BTDAEMONPROXY_H_

#include <map>
#include<sstream>
#include<iostream>
#include <netinet/in.h>
#include "IPCProvider.h"
#include "Timer.h"

class BTDaemonProxy : public IPCListener
{
public:
    /*
     * returns singleton instance of BTDaemony proxy class
     **/
    static BTDaemonProxy &GetInstance();

    /*
     * constructor
     */
    BTDaemonProxy(void);

    /*
     * returns true if the message name belongs to B-Daemon service interface
     */
    bool belongs(const char* messageName, const char* params) ;

    /*
     * returns true if the serial belongs to B-Daemon service communication
     */
    bool belongs(tU32 serial) ;

    /*
     * receives the dbus signal from the BT-Daemon and taken necessary action
     */
    void RouteSignal(const char* name, const char* params) ;

    /*
     * receives the dbus method answer from the BT-Daemon and taken necessary action
     */
    void RouteMethodAnswer(tU32 serial, const char* params) ;

    /*
     * receives the dbus method request from the BT-Daemon and taken necessary action
     */
    void RouteMethodRequest(tU32 serial, const char* name, const char* params) ;

    /*
     * receives the dbus error message from the BT-Daemon and taken necessary action
     */
    void RouteError(tU32 serial, const char* error) ;

    /*Method calls to BT-Daemon*/
    tResult AvpGetMediaPlayerItem(const tNumOfPlayers MaxNumber);
    tResult AvpGetFolderItem(const tScope Scope,const tStartItem StartItem,const tEndItem EndItem);
    tResult AvpSetPlayer(const  tPlayerId PlayerId,const tPlayerMode PlayerMode);
    tResult AvpChangePath(const tDirection Direction,const tItemUID ItemUID,const tBoolean isPlayerChanged = false,string PlayerName = "");
    tResult AvpGetNumberOfItemsInCurrentFolder();
    tResult StartAudioPipe(const tMountPoint mountpoint);
    tResult AvpCtrlCmd(const tBTControlCmd Command,const tBTButtonEvent ButtonAction);
    tResult StopAudioPipe();
    tResult AvpGetCapabilities(const tCapabilityId CapabilityId);
    tResult AvpConfigNotify(const tEventsSupported EventId);
    tResult AvpSetPlaybackModeVal(const tBTPlayerSettingAttributeMode Mode,const tBTShuffleMode Value);
    tResult AvpSetRepeatModeVal(const tBTPlayerSettingAttributeMode Mode,const tBTRepeatMode Value);
    tResult AvpGetMetadataAttr(tScope Scope,tItemUID &ItemUID,tAttributeArray &AttributeArray);
    tResult AvpListAttr();
    tResult AvpListVal(const tBTPlayerSettingAttributeMode AttributeId);
    tResult RequestMetadata(void);
    void AvpPlayItem(tScope Scope,tItemUID ItemUID);
    //void AvpGetImageProperties(const char *albumArtHandle);
    void AvpGetImage(const tBTCoverArtInfo coverArtInfo);
    void AvpCancelGettingImage(const char *albumArtHandle);

    tResult RegisterForBTSignals();
    tResult UnRegisterForBTSignals();

    static unsigned char getHexInDecimal( unsigned char ch );

    tResult SwitchObserver(const tDeviceType smName);
    void GetNowPlayingMetadata(tMetadata &metadata1,tMetadata &metadata2,tMetadata &metadata3,tMetadata &metadata4);
    void UpdateBTDeviceControlState(tBoolean IsActive);
    void ClearDeviceInfoflags();
    void GetLastActivePlaybackState(tPEPlaybackState &Playbackstate);
    void SetLastActivePlaybackState(tPEPlaybackState Playbackstate);
    void GetLatestPlaybackStateFromDevice(tPEPlaybackState &Playbackstate);
    void OverrideEvoObjectPaths(string playerName);
    tPEPlaybackState GetNowPlayingStatus();


    tResult GetSupportedAvpNotifications(const tCapabilityId capabilityId,tBTMethodRequestStatus &status,tEventsSupported &EventsSupported);
    tResult SetupPlayerForBrowsing(string playerInfo, tNumOfItems &numOfItems);
    tResult IsPlayerBrowsable(string playerInfo,tBoolean &isBrowsable);
    tBoolean ResetBrowsePathToRoot(unsigned int numOfLevelUpNeeded);
    tResult GetAttributeValue(tBTPlayerSettingAttributeMode attributeId, int& attributeValue);
    tResult GetPlayerAttributes(tBTMethodRequestStatus &status,tPlayerAttributes &SupportedAttributes);
    tResult GetFolderItems(const tScope scope,const tStartItem startItem,const tEndItem endItem,string &result);
    tResult ChangeFolderPath(const tDirection direction,const tItemUID itemUID);
    tBTPlayerInfo GetPlayerInfo();
    void startTimer(const int timeoutValue, const int timeInterval);
    void stopTimer();
    tPEPlaybackState getPlaybackState();
    void setPlaybackState(tPEPlaybackState playbackState);
    void UpdateVolumeToDevice(int Volume , int HeadUnitVolume);

    tNumOfItems GetNumberOfItemsInCurrentPath();

    //Function will iterate over the given vector of track info and
    //update the metadata member variables and update to Device control if there is a change
    void StoreNowPlayingMetadata( std::vector<std::string>& tokenVector);
    void setPlayerObjectPath(string objectPath);

    tAbsoluteVolumeSupportValues GetAbsoluteVolumeSupportValues();

private:

    /*Method Response / Error response callback handlers */
    void GetMediaPlayerItemMethodReturn(const char* params,bool isError);
    void AvpGetFolderItemMethodReturn(const char* params,bool isError);
    void AvpSetPlayerMethodReturn(const char* params,bool isError);
    void AvpChangePathMethodReturn(const char* params,bool isError);
    void ChangeFolderMethodReturn(const char* params,bool isError);
    void StartAudioPipeMethodReturn(const char* params,bool isError);
    void AvpCtrlCmdMethodReturn(const char* params,bool isError);
    void StopAudioPipeMethodReturn(const char* params,bool isError);
    void AvpGetCapabilitiesMethodReturn(const char* params,bool isError);
    void AvpSetPlaybackModeValMethodReturn(const char* params,bool isError);
    void AvpSetRepeatModeValMethodReturn(const char* params,bool isError);
    void AvpGetMetadataAttrMethodReturn(const char* params,bool isError);
    void RequestMetadataMethodReturn(const char* params,bool isError);
    void AvpListAttrMethodReturn(const char* params,bool isError);
    void AvpListShuffleModeValMethodReturn(const char* params,bool isError);
    void AvpListRepeatModeValMethodReturn(const char* params,bool isError);
    void AvpGetNumberOfItemsInCurrentFolderMethodReturn(const char* params,bool isError);
    void AvpGetImageMethodReturn(const char* params,bool isError);
    void AvpCancelGettingImageMethodReturn(const char* params,bool isError);
    void GetCoverArtConStatus();

    /*Signal handlers*/
    void AvpNotifySetCompleteSignal(const char* params);
    void AvpNotifyChgSignal(const char* params);
    void AvpPlayStatusSignal(const char* params);
    void AvpCtrlCmdIndSignal(const char* params);

    void propertiesChangedSignal(const char* params);
    //void playerAddedSignal(const char* params);
    void AddressedPlayerChanged(string playername);

    void AvpTrackChangedSignal(const char* params);
    void AvpPlayerRemovedSignal(const char* params);
    void AvpUIDsChangedSignal(const char* params);
    void AvpAvailablePlayerChangedSignal(const char* params);

    void NowPlayingContentSignal(const char* params);
    tResult GetAddressedPlayer();
    static bool TimerCallBack(timer_t /*timerID*/ , void* instance,const void */*userData*/);


    typedef void (BTDaemonProxy::*MessageHandler)(const char* params,bool isError); /**< signature of generic message/error handler function */
    typedef void (BTDaemonProxy::*SignalHandler)(const char* params); /**< signature of generic message handler function */

    map<tU32, MessageHandler> mMessageHandlers; /**< map of DBus serial and specific message handler function */
    map<string, SignalHandler> mSignalHandlers; /**< map of signal name and specific signal handler function */
    tPEPlaybackState mPlaybackState; //todo ; move it to BTControl
    tMetadata mNowPlayingMetadata1,mNowPlayingMetadata2,mNowPlayingMetadata3,mNowPlayingMetadata4;
    tObjectID mObjectID;
    std::string mNowPlayingAlbumArtHandle;
    std::string mNowPlayingObjectPath;

    void AvpPlayItemMethodReturn(const char* params,bool isError);
    tPEPlaybackState mStatusBeforeForwardRewind;/*Store the PLAYBACK STATUS before Forward or Rewind*/

    tDeviceType mSMObserver; /** state machine observer (BTControl, iPodControl) */
    //tBoolean mIsPauseSent;    /**To Pause the Device idf it already playing music while connecting via BT **/
    tBoolean mIsBTDeviceControlActive;
    void CleanupNowPlayingMetadata();
    void DeleteMemoryAllocated(tByteArray &pDataAddr,tArrayLength &arrayLength);
    void AvpChangePathToRootMethodReturn(const char* params,bool isError);

    Lock mMessageHandlersMutex;                                       /**< lock for accessing mMessageHandlers map */
    //parameter Events Supported by the Player
    tEventsSupported mEventsSupported;
    tPlaytime mtotalPlayTime;
    tPlaytime melapsedPlayTime;
    //Parameter to store the last playback state while BTControl active.
    tPEPlaybackState mBTActivePlaybackstate;

    //Local function to send no responce message
    void SendNoResponseMsg(const me::reason_e reason);
    /*Variable to remember the last playback status received from the device.
    Which will used to avoid sending play command to device if the device is in PLAYING state*/
    tPEPlaybackState mLatestPlaybackStateFromDevice;
    tBTPlayerInfo mPlayerInfo;
    sem_t m_GetFolderItemSyncSem;
    string m_ResultGetFolderItemsMethodReturn;
    void SetResultGetFolderItemsMethodReturn(const char* params);
    void GetFolderItemsMethodReturn(const char* params,bool isError);
    void ClearResultGetFolderItemsMethodReturn();
    void SetTaskSyncSemWaitFolderItem(tBoolean Value);
    tBoolean GetTaskSyncSemWaitFolderItem();
    void SetElapsedPlayTime(tPlaytime time);
    tPlaytime GetElapsedPlayTime();
    void SetOldElapsedPlayTime(tPlaytime time);
    tPlaytime GetOldElapsedPlayTime();
    tBoolean m_TaskSyncSemWaitFolderItem;
    Lock  m_TaskSyncSemFolderItemMutex;
    timer_t mUpdateTimerID;
    Timer mUpdateTimer;
    bool mTimerAlreadyRunning;
    tPlaytime mold_elapsedPlayTime;
    Lock melapsedPlayTimeMutex;
    sem_t m_ChangeFolderSyncSem;
    tBoolean m_TaskSyncSemWaitChangeFolder;
    Lock  m_TaskSyncSemChangeFolderMutex;
    void SetTaskSyncSemWaitChangeFolder(tBoolean Value);
    tBoolean GetTaskSyncSemWaitChangeFolder();
    vector<string> mInterfacenames;    /* Names of the Interface name for this component*/
    tBoolean AvpIsShuffleSupported();
    int AvpGetShuffleValue();
    tBoolean AvpIsRepeatSupported();
    int AvpGetRepeatValue();

    //"Absolute Volume Support" related variables and functions
    void SupportAbsoluteVolume();
    void GetObjectPathForAbsoluteVolume();
    string mObjectPathForAbsoluteVolume;
    tAbsoluteVolumeSupportValues mAbsoluteVolumeSupport;
    typedef enum
   {
        SET_ALL_TO_DEFAULT = 0UL,  // default
        VOLUME_SENT_TO_DEVICE,
        CURRENT_VOLUME_RECEIVED_FROM_AUDIO,
        WAITING_FOR_VOLUME_UPDATE,
        CURRENT_VOLUME_IN_DEVICE
   } tAbsoluteVolumeSupportVariables;
    void SetAbsoluteVolumeSupportValues(tAbsoluteVolumeSupportVariables Variable,int Value);
    Lock m_AbsoluteVolumeSupportValueMutex;
    void GetVolumeFromDevice();

    //timer related variables amd functions for "Absolute Volume Support"

    Timer mAbsoluteVolumeWaitTimer;
    timer_t mAbsoluteVolumeWaitTimerID;
    tResult StartAbsoluteVolumeWaitTimer();
    tResult StopAbsoluteVolumeWaitTimer();
    static bool AbsoluteVolumeWaitTimerCallBack(timer_t timerID , void* instance, const void *userData);

    me::reason_e _oldReason;
    Lock m_PlaybackStateMutex;

    //For BT CoverArt
    tBool mGetImageReqInProgress;
    tBTCoverArtInfo mCoverArtInfoGetImageIsInProgress;
    tBTCoverArtInfo mCoverArtInfoGetImagePending;
};

#endif /* BTDAEMONPROXY_H_ */
