/**
 * @addtogroup Ipc
 * @author Reenuhaa Pechi S
 *
 * Define the IPC me::speed_ethod calls to Alps-bt-daemon service
 *
 * @{
 */

#ifndef BTDAEMONIPCIF_H_
#define BTDAEMONIPCIF_H_

#include "IpcTypes.h"
#define BT_TEST_WITH_DUMMY 1

/***Alps-bt-daemon****************************************************************************************************************************************************************/

#define IPC_ALPS_BTDAEMON_SERVICE                           "com.alps.bt"
#define IPC_ALPS_BTDAEMON_AUDIO_INTERFACE                   "com.alps.bt.Audio"
#define IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE             "com.alps.bt.Audiovisual"

#if BT_TEST_WITH_DUMMY
#define IPC_ALPS_BTDAEMON_PATH  "/com/alps/bt/dev_aa_bb_cc_dd_ee_ff"                //Where dev_aa_bb_cc_dd_ee_ff is DeviceAddress string//
#else
#define IPC_ALPS_BTDAEMON_PATH  "/com/alps/bt/"
#endif

#define IPC_ALPS_BTDAEMON_BASEOBJECT_PATH "/com/alps/bt"                            //For Doing StartAudioPipe/StopAudioPipe

/*Note : For Communication with BT Devices,Method call should be done via their device Specific Object Path.
 *       The Object Path is specific for each BT Device and it is given by the Alps-bt-daemon on Connection.
 *       So Base Object Path is used (here)but it will be not be used for Communication.
 *       Instead device Specific path will be used for Communication*/

IPC_DECLARE_MESSAGE( ipc_AlpsBTDaemon_StartAudioPipe , IPC_ALPS_BTDAEMON_SERVICE, IPC_ALPS_BTDAEMON_BASEOBJECT_PATH,IPC_ALPS_BTDAEMON_AUDIO_INTERFACE, "StartAudioPipe");
IPC_DECLARE_MESSAGE( ipc_AlpsBTDaemon_StopAudioPipe , IPC_ALPS_BTDAEMON_SERVICE, IPC_ALPS_BTDAEMON_BASEOBJECT_PATH,IPC_ALPS_BTDAEMON_AUDIO_INTERFACE, "StopAudioPipe");

//Methods Related to Folder Browsing
IPC_DECLARE_MESSAGE( ipc_AlpsBTDaemon_AvpChangePath , IPC_ALPS_BTDAEMON_SERVICE, IPC_ALPS_BTDAEMON_PATH,IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE, "AvpChangePath");
IPC_DECLARE_MESSAGE( ipc_AlpsBTDaemon_AvpPlayItem   , IPC_ALPS_BTDAEMON_SERVICE, IPC_ALPS_BTDAEMON_PATH,IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE, "AvpPlayItem");
IPC_DECLARE_MESSAGE( ipc_AlpsBTDaemon_AvpGetMediaPlayerItem , IPC_ALPS_BTDAEMON_SERVICE, IPC_ALPS_BTDAEMON_PATH,IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE, "AvpGetMediaPlayerItem");
IPC_DECLARE_MESSAGE( ipc_AlpsBTDaemon_AvpGetFolderItem  , IPC_ALPS_BTDAEMON_SERVICE, IPC_ALPS_BTDAEMON_PATH,IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE, "AvpGetFolderItem");

//Methods Related to PlayerSelection in BT Device
IPC_DECLARE_MESSAGE( ipc_AlpsBTDaemon_AvpSetPlayer  , IPC_ALPS_BTDAEMON_SERVICE, IPC_ALPS_BTDAEMON_PATH,IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE, "AvpSetPlayer");

//Methods Related to Playback
IPC_DECLARE_MESSAGE( ipc_AlpsBTDaemon_AvpGetMetadataAttr    , IPC_ALPS_BTDAEMON_SERVICE, IPC_ALPS_BTDAEMON_PATH,IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE, "AvpGetMetadataAttr");
IPC_DECLARE_MESSAGE( ipc_AlpsBTDaemon_AvpConfigNotify   , IPC_ALPS_BTDAEMON_SERVICE, IPC_ALPS_BTDAEMON_PATH,IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE, "AvpConfigNotify");
IPC_DECLARE_MESSAGE( ipc_AlpsBTDaemon_AvpSetVal , IPC_ALPS_BTDAEMON_SERVICE, IPC_ALPS_BTDAEMON_PATH,IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE, "AvpSetVal");
IPC_DECLARE_MESSAGE( ipc_AlpsBTDaemon_AvpListVal    , IPC_ALPS_BTDAEMON_SERVICE, IPC_ALPS_BTDAEMON_PATH,IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE, "AvpListVal");
IPC_DECLARE_MESSAGE( ipc_AlpsBTDaemon_AvpListAttr   , IPC_ALPS_BTDAEMON_SERVICE, IPC_ALPS_BTDAEMON_PATH,IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE, "AvpListAttr");
IPC_DECLARE_MESSAGE( ipc_AlpsBTDaemon_AvpGetCapabilities    , IPC_ALPS_BTDAEMON_SERVICE, IPC_ALPS_BTDAEMON_PATH,IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE, "AvpGetCapabilities");
IPC_DECLARE_MESSAGE( ipc_AlpsBTDaemon_AvpCtrlCmd    , IPC_ALPS_BTDAEMON_SERVICE, IPC_ALPS_BTDAEMON_PATH,IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE, "AvpCtrlCmd");

//Signals For Notification(Related to Playtime::speed_e,Status etc..)
IPC_DECLARE_MESSAGE( ipc_AlpsBTDaemon_AvpCodecAndBitrate    , IPC_ALPS_BTDAEMON_SERVICE, IPC_ALPS_BTDAEMON_PATH,IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE, "AvpCodecAndBitrate");
IPC_DECLARE_MESSAGE( ipc_AlpsBTDaemon_AvpNotifyChg  , IPC_ALPS_BTDAEMON_SERVICE, IPC_ALPS_BTDAEMON_PATH,IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE, "AvpNotifyChg");
IPC_DECLARE_MESSAGE( ipc_AlpsBTDaemon_AvpNotifySetComplete  , IPC_ALPS_BTDAEMON_SERVICE, IPC_ALPS_BTDAEMON_PATH,IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE, "AvpNotifySetComplete");
IPC_DECLARE_MESSAGE( ipc_AlpsBTDaemon_AvpPlayStatus , IPC_ALPS_BTDAEMON_SERVICE, IPC_ALPS_BTDAEMON_PATH,IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE, "AvpPlayStatus");
IPC_DECLARE_MESSAGE( ipc_AlpsBTDaemon_AvpCtrlCmdInd , IPC_ALPS_BTDAEMON_SERVICE, IPC_ALPS_BTDAEMON_PATH,IPC_ALPS_BTDAEMON_AUDIOVISUAL_INTERFACE, "AvpCtrlCmdInd");
/*******************************************************************************************************************************************************************/

#define IPC_EVOLUTION_SERVICE                               "org.bluez"
#define IPC_EVOLUTION_INTERFACE                             "org.bluez.MediaPlayer"
#define IPC_EVOLUTION_MEDIAFOLER_INTERFACE                  "org.bluez.MediaFolder"
#define IPC_EVOLUTION_MEDIAITEM_INTERFACE                   "org.bluez.MediaItem"
#define IPC_EVOLUTION_MEDIATRANSPORT_INTERFACE              "org.bluez.MediaTransport"
#define IPC_EVOLUTION_AVP_INTERFACE                         "org.bluez.evo.AVP"
#define IPC_EVOLUTION_PROPERTY_INTERFACE                    "org.freedesktop.DBus.Properties"
#define IPC_EVOLUTION_OBJECT_PATH                           "/org/bluez/hci1/"
#define IPC_EVOLUTION_OBJECT_DUMMY_PATH                     "/org/bluez/hci1"

//Method to Get Players
IPC_DECLARE_MESSAGE ( ipc_Evolution_GetPlayers , IPC_EVOLUTION_SERVICE, IPC_EVOLUTION_OBJECT_DUMMY_PATH,IPC_EVOLUTION_AVP_INTERFACE, "GetPlayers");

//Methods Related to Playback
IPC_DECLARE_MESSAGE ( ipc_Evolution_MediaPlay , IPC_EVOLUTION_SERVICE, IPC_EVOLUTION_OBJECT_DUMMY_PATH,IPC_EVOLUTION_INTERFACE, "Play");
IPC_DECLARE_MESSAGE ( ipc_Evolution_MediaPause , IPC_EVOLUTION_SERVICE, IPC_EVOLUTION_OBJECT_DUMMY_PATH,IPC_EVOLUTION_INTERFACE, "Pause");
IPC_DECLARE_MESSAGE ( ipc_Evolution_MediaStop , IPC_EVOLUTION_SERVICE, IPC_EVOLUTION_OBJECT_DUMMY_PATH,IPC_EVOLUTION_INTERFACE, "Stop");
IPC_DECLARE_MESSAGE ( ipc_Evolution_MediaNext , IPC_EVOLUTION_SERVICE, IPC_EVOLUTION_OBJECT_DUMMY_PATH,IPC_EVOLUTION_INTERFACE, "Next");
IPC_DECLARE_MESSAGE ( ipc_Evolution_MediaPrevious , IPC_EVOLUTION_SERVICE, IPC_EVOLUTION_OBJECT_DUMMY_PATH,IPC_EVOLUTION_INTERFACE, "Previous");
IPC_DECLARE_MESSAGE ( ipc_Evolution_MediaFastForward , IPC_EVOLUTION_SERVICE, IPC_EVOLUTION_OBJECT_DUMMY_PATH,IPC_EVOLUTION_INTERFACE, "FastForward");
IPC_DECLARE_MESSAGE ( ipc_Evolution_MediaRewind , IPC_EVOLUTION_SERVICE, IPC_EVOLUTION_OBJECT_DUMMY_PATH,IPC_EVOLUTION_INTERFACE, "Rewind");
IPC_DECLARE_MESSAGE ( ipc_Evolution_SetBrowsedPlayer , IPC_EVOLUTION_SERVICE, IPC_EVOLUTION_OBJECT_DUMMY_PATH,IPC_EVOLUTION_INTERFACE, "SetBrowsedPlayer");
IPC_DECLARE_MESSAGE ( ipc_Evolution_SetAddressedPlayer , IPC_EVOLUTION_SERVICE, IPC_EVOLUTION_OBJECT_DUMMY_PATH,IPC_EVOLUTION_INTERFACE, "SetAddressPlayer");

//Methods Related to Folder Browsing
IPC_DECLARE_MESSAGE( ipc_Evolution_ChangeFolder , IPC_EVOLUTION_SERVICE, IPC_EVOLUTION_OBJECT_DUMMY_PATH,IPC_EVOLUTION_MEDIAFOLER_INTERFACE, "ChangeFolder");
IPC_DECLARE_MESSAGE( ipc_Evolution_ListItems , IPC_EVOLUTION_SERVICE, IPC_EVOLUTION_OBJECT_DUMMY_PATH,IPC_EVOLUTION_MEDIAFOLER_INTERFACE, "ListItems");

//Methods Related to MediaItem interface
IPC_DECLARE_MESSAGE( ipc_Evolution_PlayItem   , IPC_EVOLUTION_SERVICE, IPC_EVOLUTION_OBJECT_DUMMY_PATH,IPC_EVOLUTION_MEDIAITEM_INTERFACE, "Play");
IPC_DECLARE_MESSAGE( ipc_Evolution_GetImageProperties   , IPC_EVOLUTION_SERVICE, IPC_EVOLUTION_OBJECT_DUMMY_PATH,IPC_EVOLUTION_MEDIAITEM_INTERFACE, "GetImageProperties");
IPC_DECLARE_MESSAGE( ipc_Evolution_GetImage   , IPC_EVOLUTION_SERVICE, IPC_EVOLUTION_OBJECT_DUMMY_PATH,IPC_EVOLUTION_MEDIAITEM_INTERFACE, "GetImage");
IPC_DECLARE_MESSAGE( ipc_Evolution_CancelGettingImage   , IPC_EVOLUTION_SERVICE, IPC_EVOLUTION_OBJECT_DUMMY_PATH,IPC_EVOLUTION_MEDIAITEM_INTERFACE, "CancelGettingImage");

//Methods Related to Properties
IPC_DECLARE_MESSAGE ( ipc_Evolution_Get , IPC_EVOLUTION_SERVICE, IPC_EVOLUTION_OBJECT_DUMMY_PATH,IPC_EVOLUTION_PROPERTY_INTERFACE, "Get");
IPC_DECLARE_MESSAGE ( ipc_Evolution_Set , IPC_EVOLUTION_SERVICE, IPC_EVOLUTION_OBJECT_DUMMY_PATH,IPC_EVOLUTION_PROPERTY_INTERFACE, "Set");
IPC_DECLARE_MESSAGE ( ipc_Evolution_Getall , IPC_EVOLUTION_SERVICE, IPC_EVOLUTION_OBJECT_DUMMY_PATH,IPC_EVOLUTION_PROPERTY_INTERFACE, "GetAll");

//signal
IPC_DECLARE_MESSAGE( ipc_Evolution_PropertiesChanged  , IPC_EVOLUTION_SERVICE, IPC_EVOLUTION_OBJECT_DUMMY_PATH,IPC_EVOLUTION_PROPERTY_INTERFACE, "PropertiesChanged");

#endif /*BTDAEMONIPCIF_H__*/

/** @} */
