#ifndef _DATAPOOLTEST_H_
#define _DATAPOOLTEST_H_

/*lint -save -e578 */

#include <cppunit/extensions/HelperMacros.h>

#include <TypeDefinitions.h>
#include <TimeTrace.h>

#include "test_util.h"
#include "Listener.h"
#include "Datapool.h"

class DatapoolTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( DatapoolTest );
    CPPUNIT_TEST( verifyCallControlsConfiguration );
    CPPUNIT_TEST_SUITE_END();

public:

    DatapoolTest();

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();

    /*test cases*/
    void verifyCallControlsConfiguration();

private:
    TimeTrace        ticks;         /**< time object to trace the time taken by testcases*/
    Datapool dpObj;

};

#endif  // _DatapoolTest_H_
