/***********************************************************************/
/*!
* \file  Datapool.cpp
* \brief Wrapper class for Datapool usage
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   MediaPlayer
DESCRIPTION:    Wrapper class for Datapool usage
AUTHOR:
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                  | Modification
08.07.2019  | Anoop Gopalakrishnan    | Initial Version

\endverbatim
*************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "Datapool.h"
#include "Framework_Errorcodes.h"
#include "TypeDefinitions.h"

#ifdef TARGET_BUILD
#include <glib.h>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_mediaplayer_if.h"
#endif

#include "etrace_mp.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_DATAPOOL

#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_DATAPOOL
      #include "trcGenProj/Header/Datapool.cpp.trc.h"
   #endif
#endif


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
#ifdef DP_S_IMPORT_INTERFACE_FI
typedef dp_tclmediaplayerDPDiPOCallControlsConfiguration dp_CallControlConf;
#endif
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/


/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/***************************************************************************
*********************************PUBLIC*************************************
***************************************************************************/

/***************************************************************************
** FUNCTION:  Datapool::Datapool(const trGPSData& rfcorGpsData)
***************************************************************************/
Datapool::Datapool()
{
   ETG_TRACE_USR1(("Datapool() entered \n"));
}

/***************************************************************************
** FUNCTION: Datapool::~Datapool()
***************************************************************************/
Datapool::~Datapool()
{
   ETG_TRACE_USR1(("~Datapool() entered \n"));
}

/***************************************************************************
** FUNCTION:  tenEnabledInfo Datapool::bReadCallControlsSetting()
***************************************************************************/
tU8 Datapool::readCallControlsSetting() const
{
   tU8 callControlsConfig = 0;
#ifdef DP_S_IMPORT_INTERFACE_FI
   //! Create an object of Datapool FI class & read the data
   dp_CallControlConf callControlsSetting;
   callControlsConfig = callControlsSetting.tGetData();

   ETG_TRACE_USR3(("Datapool::readCallControlsSetting: left with callControlsConfig = %u \n",
           callControlsConfig));
#else
   ETG_TRACE_USR3(("Datapool::Datapool not implemented"));
#endif
   return callControlsConfig;
}

/***************************************************************************
** FUNCTION:  t_Bool Datapool::bWriteCallControlsSetting(tenEnabledInfo...)
***************************************************************************/
tResult Datapool::writeCallControlsSetting(tU8 callControlsConfig)
{
   ETG_TRACE_USR3(("Datapool::writeCallControlsSetting: entered with callControlsConfig = %u \n",
           callControlsConfig));

   tResult res = MP_NO_ERROR;
#ifdef DP_S_IMPORT_INTERFACE_FI
   //! Create an object of Datapool FI class & set the data
   dp_CallControlConf callControlsSetting;
   tS32 s32WriteError = callControlsSetting.s32SetData(callControlsConfig);

   if (DP_S32_NO_ERR != s32WriteError)
   {
      ETG_TRACE_ERR((" Datapool::writeCallControlsSetting: Write error: %u", s32WriteError));
      res = MP_ERR_DATAPOOL_WRITE_FAILURE;
   }
#else
   ETG_TRACE_USR3(("Datapool::Datapool not implemented"));
#endif
   return res;
}
