/***********************************************************************/
/*!
* \file  Datapool.h
* \brief Wrapper class for Datapool usage
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Media Player
DESCRIPTION:    Wrapper class for Datapool usage
AUTHOR:         Anoop
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                        | Modification
08.07.2019  | Anoop Gopalakrishnan          | Initial Version


\endverbatim
*************************************************************************/

#ifndef _DATAPOOL_H_
#define _DATAPOOL_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "BaseTypes.h"


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
* \class Datapool
* \brief
* It provides methods to store & retrieve persistent data in SPI using Datapool.
****************************************************************************/
class Datapool
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  Datapool::Datapool()
   ***************************************************************************/
   /*!
   * \fn      Datapool()
   * \brief   Default Constructor
   * \sa      ~Datapool()
   ***************************************************************************/
   Datapool();

   /***************************************************************************
   ** FUNCTION: Datapool::~Datapool()
   ***************************************************************************/
   /*!
   * \fn      ~Datapool()
   * \brief   Destructor
   * \sa      Datapool()
   ***************************************************************************/
   virtual ~Datapool();

   tU8 readCallControlsSetting() const;
   tResult writeCallControlsSetting(tU8 callControlsConfig);
};

#endif  //_DATAPOOL_H_
