#ifndef _DataProviderTest_H_
#define _DataProviderTest_H_

/*lint -save -e578 */

#include <cppunit/extensions/HelperMacros.h>

#include <TypeDefinitions.h>
#include <TimeTrace.h>

#include "test_util.h"
#include "Listener.h"

class DataProviderTest : public CppUnit::TestFixture, cBaseTest
{
    CPPUNIT_TEST_SUITE( DataProviderTest );
    CPPUNIT_TEST( TraceConfigurations );
    CPPUNIT_TEST( GetMediaObjectAlbumArtInfo );
    CPPUNIT_TEST( GetMediaObjectAlbumArt );
    CPPUNIT_TEST( GetURL );
    CPPUNIT_TEST( ActiveMediaDeviceSet );
    CPPUNIT_TEST( ImportAndCut );
    CPPUNIT_TEST( ProcessConfigTable );
    CPPUNIT_TEST( GetFallbackAction );
    CPPUNIT_TEST( MarshalUnMarshalDeviceInfoString );
    CPPUNIT_TEST_SUITE_END();

public:

    DataProviderTest();

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();

    /*test cases*/
    void TraceConfigurations();
    void GetMediaObjectAlbumArtInfo();
    void GetMediaObjectAlbumArt();
    void GetURL();
    void ActiveMediaDeviceSet();
    void ImportAndCut();
    void ProcessConfigTable();
    void GetFallbackAction();
	virtual void testCallback(cTestData *objTestData);
    void GetMediaObjectAlbumArtInfotestCallback(cTestData *objTestData);
    void (DataProviderTest::*funPtr)(cTestData *);
    void LockResult(int );
    void MarshalUnMarshalDeviceInfoString();

private:
    TimeTrace	 	 ticks;			/**< time object to trace the time taken by testcases*/

    pthread_cond_t   condition ;	/**< wait condition used for asynchronous test cases */
    pthread_mutex_t  mutex ;		/**< lock used during asynchronous test case execution*/
	pthread_mutex_t  mutex2 ;
	pthread_mutexattr_t mAttr;
};

#endif  // _DataProviderTest_H_
