/* ETG definitions */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/DataProviderTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif
#include "FunctionTracer.h"
#include "VarTrace.h"

#include  <errno.h>
#include <memory.h>
#include <glib.h>
#include <ListControl.h>

#include "DataProviderTest.h"
#include <FunctionTracer.h>
#include "LocalSPM.h"
#include "CppUnitDefinitions.h"
#include "FastUTF8.h"

pthread_mutex_t hMutex2 ;
pthread_mutexattr_t mAttr;
struct timespec abstime;
static int resultVerified = -1;

#include <errno.h>

#define MQMSGQUEUE "/tmp/MQMSGQUEUE"

DataProviderTest::DataProviderTest()
{
    funPtr = NULL;
}

void DataProviderTest::setUp()
{
    pthread_mutex_init(&mutex,NULL);
    pthread_cond_init(&condition,NULL);
    ticks.begin();
}

void DataProviderTest::tearDown()
{
    ticks.elapsed();
    pthread_mutex_destroy(&mutex);
    pthread_cond_destroy(&condition);
}

void DataProviderTest::LockResult(int t_seconds)
{
    ENTRY_INTERNAL
    int rc;
    pthread_mutex_init(&hMutex2,NULL);
    pthread_mutexattr_init(&mAttr);
    pthread_mutexattr_settype(&mAttr, PTHREAD_MUTEX_RECURSIVE_NP);
    pthread_mutex_lock(&hMutex2);
    bool bflag = false;
    int nValue = 0;
    while(false == bflag && (-1 == resultVerified))
    {
        clock_gettime(CLOCK_REALTIME, &abstime);
        abstime.tv_sec += 1;
        nValue += 1;
        if ((rc = pthread_mutex_timedlock(&hMutex2, &abstime)) > 0 )
        {
            //fprintf(stderr, "ERROR second pthread_mutex_timedlock. %s\n", strerror(rc));
        }
        if(nValue > t_seconds)
        {
            pthread_mutex_unlock(&hMutex2);
            bflag = true;
        }
    }
    pthread_mutex_unlock(&hMutex2);
    resultVerified = -1;
}

void releaseLock()
{
    ENTRY_INTERNAL
    resultVerified =0;
    pthread_mutex_unlock(&hMutex2);
}

/**********************************************************************
 * Test cases
 *********************************************************************/
void DataProviderTest::GetMediaObjectAlbumArtInfotestCallback(cTestData *objTestData)
{
    ENTRY_INTERNAL

    if(objTestData !=NULL)
    {
        switch(objTestData->eMSGTYPE)
        {
            case EV_GETMEDIAOBJECTALBUMINFOANSWER:

                ETG_TRACE_USR2 (( "type %d", objTestData->mimeType));
                ETG_TRACE_USR2 (( "size %d", objTestData->mimeType));

                //if ( userContext.functionID == objTestData->userContext.functionID )
                    nresultObatined = 0;
                break;
            default:
                break;
        };
    }

    ::sleep(7);

    releaseLock();
}

void DataProviderTest::testCallback(cTestData *objTestData)
{
    ENTRY_INTERNAL
     (this->*funPtr)(objTestData);
 }

void DataProviderTest::GetMediaObjectAlbumArtInfo()
{
    ENTRY_TEST

    tResult res;
    tListID listID;
    tFilterTag tag;
    vector<tMediaObject> mediaObjectVector;
    tUserContext userContext;
    this->m_strTestcase = "GetMediaObjectAlbumArtInfo";
    this->bLetFWValidateResult = false ;
    nresultObatined = -1;
    //Test Bench call

    CListener *oListener = CListener::getCListenerInstance();
    oListener->registerCallback(this);
    oListener->startListen();
    oListener->registerEvent(EV_GETMEDIAOBJECTALBUMINFOANSWER);
    DataProviderTest::funPtr =  &DataProviderTest::GetMediaObjectAlbumArtInfotestCallback;

  //  useTestFw(this);

    //create an all song list and find album "Garbage"
    tListSize listSize;
    tStreaming streaming = false;
    tFilterTag1 tag1 = {0};
    tFilterTag2 tag2 = {0};
    tFilterTag3 tag3 = {0};
    tFilterTag4 tag4 = {0};
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            MY_MEDIA);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(listSize == 31);

    /* get the first contents */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector, IN listID, 0, 1);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObjectVector.size() > 0);
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField4, "Garbage"));


    // set the filter tags
    tag = mediaObjectVector[0].objectID; // must be a song tag

    mediaObjectVector.clear();
    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    // call create list
    res = LocalSPM::GetListControl().CreatePlayList(OUT listID, IN tag, PC_NO_REPEAT, MY_MEDIA);
    CPPUNIT_ASSERT(res == 0);


    /* get the first contents */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            0,
            1);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObjectVector.size() > 0);
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField1, "Alternative"));

    /* get the device info for the media object */
    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN mediaObjectVector[0].deviceID);
    CPPUNIT_ASSERT(res == 0);

    /* create the compare string */
    char compareString[1024];
    strncpy_r(compareString, deviceInfo.mountPoint, sizeof(compareString));
    strncat_r(compareString, "/music/Garbage/Garbage-Garbage-06-A_Stroke_of_Luck.mp3", sizeof(compareString));

    CPPUNIT_ASSERT(strcmp(mediaObjectVector[0].albumArtString, compareString) == 0);

    /* ask for album art information*/
    userContext.sourceAppID = 0x109;
    userContext.registerID = 0x4;
    userContext.cmdCounter = 0x1;
    userContext.functionID = 0x1234;
    userContext.serviceID = 0;

    res = LocalSPM::GetDataProvider().GetMediaObjectAlbumArtInfo(
            IN mediaObjectVector[0].albumArtString,
            128,
            128,
            MMT_JPG,
            userContext);
    CPPUNIT_ASSERT(res == 0);

    //ASYNC_WAIT_START(10);
    LockResult(20);
    if (-1 == nresultObatined)
        CPPUNIT_ASSERT(1);
    else
        //result = 0;//oListener->getResult();
        CPPUNIT_ASSERT(nresultObatined == 0);
    oListener->stopListen();

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == 0);
}

void DataProviderTest::GetMediaObjectAlbumArt()
{
    ENTRY_TEST

    tResult res;
    tListID listID;
    tFilterTag tag;
    vector<tMediaObject> mediaObjectVector;
    tUserContext userContext;

    //create an all song list and find album "Garbage"
    tListSize listSize;
    tStreaming streaming = false;
    tFilterTag1 tag1 = {0};
    tFilterTag2 tag2 = {0};
    tFilterTag3 tag3 = {0};
    tFilterTag4 tag4 = {0};
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            MY_MEDIA);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(listSize == 31);

    /* get the first contents */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector, IN listID, 0, 1);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObjectVector.size() > 0);
    CPPUNIT_ASSERT(!strcmp(mediaObjectVector[0].MetadataField4, "Garbage"));

    // set the filter tags
    tag = mediaObjectVector[0].objectID; // must be a song tag

    mediaObjectVector.clear();
    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == 0);

    // call create list
    res = LocalSPM::GetListControl().CreatePlayList(OUT listID, IN tag, PC_NO_REPEAT, MY_MEDIA);
    CPPUNIT_ASSERT(res == 0);

    /* get the first contents */
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(
            OUT mediaObjectVector,
            IN listID,
            0,
            1);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObjectVector.size() > 0);
    CPPUNIT_ASSERT(strcmp(mediaObjectVector[0].MetadataField1, "Alternative") == 0);

    /* get the device info for the media object */
    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN mediaObjectVector[0].deviceID);
    CPPUNIT_ASSERT(res == 0);

    /* create the compare string */
    char compareString[1024];
    strncpy_r(compareString, deviceInfo.mountPoint, sizeof(compareString));
    strncat_r(compareString, "/music/Garbage/Garbage-Garbage-06-A_Stroke_of_Luck.mp3", sizeof(compareString));

    CPPUNIT_ASSERT(strcmp(mediaObjectVector[0].albumArtString, compareString) == 0);

    /* ask for album art information*/
    userContext.sourceAppID = 0x109;
    userContext.registerID = 0x4;
    userContext.cmdCounter = 0x1;
    userContext.functionID = 0x1234; // this magic prevents the data provider rom delting the intermediate file
    userContext.serviceID = 0x0;

#define ENDURANCE_AA 0
#if ENDURANCE_AA
    userContext.functionID = 0x0;
    for(int i=0; i< 50; i++) {
        printf("GetMediaObjectAlbumArt: run=%d\n", i);
    //while(1) { // endless
#endif

    res = LocalSPM::GetDataProvider().GetMediaObjectAlbumArt(
            IN mediaObjectVector[0].albumArtString,
            160,
            160,
            MMT_JPG,
            userContext);
    if (res) {
        CPPUNIT_ASSERT(res == 0);
    }

    res = LocalSPM::GetDataProvider().GetMediaObjectAlbumArt(
            IN mediaObjectVector[0].albumArtString,
            170,
            170,
            MMT_PNG,
            userContext);
    if (res) {
        CPPUNIT_ASSERT(res == 0);
    }
#if ENDURANCE_AA
    }
#endif

    res = LocalSPM::GetListControl().ReleaseList(IN listID);
    CPPUNIT_ASSERT(res == 0);
}

void DataProviderTest::GetURL()
{
    ENTRY_TEST

    tResult res;
    tListID listID;
    tListSize listSize;
    tStreaming streaming = false;
    tFilterTag1 tag1 = {0};
    tFilterTag2 tag2 = {0};
    tFilterTag3 tag3 = {0};
    tFilterTag4 tag4 = {0};
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            MY_MEDIA);
    CPPUNIT_ASSERT(res == 0);
    vector<tMediaObject> mediaObjectVector;
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 4, 1);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObjectVector.size() == 1);


    tTag fileName;
    res = LocalSPM::GetDBManager().GetURLOfMediaObject(OUT fileName, IN mediaObjectVector[0].objectID, IN CTY_SONG);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(strcmp(fileName, mediaObjectVector[0].fileName) == 0);

    LocalSPM::GetListControl().ReleaseList(IN listID);
}

void DataProviderTest::ActiveMediaDeviceSet()
{
    ENTRY_TEST

    tResult res;
    tDeviceInfo deviceInfo;
    tDeviceID deviceID;
    tDeviceID deviceID2;

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, IN DTY_USB, IN "USB");
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID2, IN DTY_IPOD, IN "IPOD");
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDataProvider().ActiveMediaDeviceSet(IN deviceID, true);
    CPPUNIT_ASSERT(res == 0);

    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID2);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(deviceInfo.activeSource == 0);

    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(deviceInfo.activeSource == 1);
}

void DataProviderTest::ImportAndCut()
{
    ENTRY_TEST

    //char *testString = "中国abc";
    char testStringGBKBuffer[] = {(char)0xd6,(char)0xd0,(char)0xb9,(char)0xfa,0x61,0x62,0x63,0x0};
    char testString[1024];

    /* switch on china mode */
    LocalSPM::GetDataProvider().GBKSupported = 1;

    /* generate a gbk string which is longer than 90 characters */
    *testString = 0;
    for(int i=0; i<(LocalSPM::GetDataProvider().MaxMetadataStringLen()/5) + 3; i++) {
        strncat_r(testString, testStringGBKBuffer, sizeof(testString));
    }

    /* convert to media players utf-8 */
    LocalSPM::GetDataProvider().ImportAndCut(INOUT (FastUTF8::tString)testString, sizeof(testString));

#if 0
    /* check the result */
    for(int j=0; j<10; j++) {
        printf("[0x%02x]", testString[j]);
    }
    printf("\n");
    printf("strlen_r(testString)=%d\n", strlen_r(testString));
#endif

    /* switch off china mode */
    LocalSPM::GetDataProvider().GBKSupported = 0;

    CPPUNIT_ASSERT(g_utf8_validate(testString , -1, NULL) == true);
    CPPUNIT_ASSERT(strlen_r(testString) == 161);
}

void DataProviderTest::TraceConfigurations()
{
    LocalSPM::GetDataProvider().TraceMediaplayerConfigurations();
}

void DataProviderTest::ProcessConfigTable()
{
     ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tUInt decisionMatrix[16][5] = {
    {CTP_TEST1,0,0,0,CTA_NONE},
    {CTP_TEST1,0,0,1,CTA_TEST3},
    {CTP_TEST1,0,1,0,CTA_TEST1},
    {CTP_TEST1,0,1,1,CTA_TEST1},
    {CTP_TEST1,1,0,0,CTA_NONE},
    {CTP_TEST1,1,0,1,CTA_TEST2},
    {CTP_TEST1,1,1,0,CTA_TEST1},
    {CTP_TEST1,1,1,1,CTA_TEST1},

    {CTP_TEST2,0,0,0,CTA_TEST6},
    {CTP_TEST2,0,0,1,CTA_TEST6},
    {CTP_TEST2,0,1,0,CTA_TEST6},
    {CTP_TEST2,0,1,1,CTA_TEST4},
    {CTP_TEST2,1,0,0,CTA_TEST5},
    {CTP_TEST2,1,0,1,CTA_TEST5},
    {CTP_TEST2,1,1,0,CTA_TEST6},
    {CTP_TEST2,1,1,1,CTA_TEST4}};

    tUInt index = 0;
    tConfigTableAction action = CTA_NONE; //No action
    tConfigTable usedConfigTable = CT_TEST; //TestConfigTable
    tDeviceID deviceID = 1;

    for( tUInt precondition=CTP_TEST1; precondition <= CTP_TEST2; precondition++)
    {
        for(tUInt criteria1=0; criteria1 < 2; criteria1++)
        {
            for(tUInt criteria2=0; criteria2 < 2; criteria2++)
            {
                for(tUInt criteria3=0; criteria3 < 2; criteria3++)
                {
                    /* Set test criteria */
                    res = LocalSPM::GetDataProvider().SetTestCriteria(criteria1, criteria2, criteria3);
                    CPPUNIT_ASSERT(res == 0);

                    /* Calculate action from config table */
                    res = LocalSPM::GetDataProvider().ProcessConfigTable(OUT action, IN usedConfigTable, IN (tConfigTablePrecondition)precondition, IN deviceID);
                    CPPUNIT_ASSERT(res == 0);

                    /* Check result (action) */
                    CPPUNIT_ASSERT((tUInt)action == decisionMatrix[index][4]);

                    index++;
                }
            }
        }
    }

    /* Reset test criteria */
    res = LocalSPM::GetDataProvider().ResetTestCriteria();
    CPPUNIT_ASSERT(res == 0);
}

void DataProviderTest::GetFallbackAction()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;
    tConfigTableAction fallbackAction = CTA_NONE;

    /* Get fallback solution */
    tConfigTableAction action = CTA_PLAY_DB_LAST_MODE_LIST;
    res = LocalSPM::GetDataProvider().GetFallbackAction(OUT fallbackAction, IN action);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(fallbackAction != CTA_NONE);

    action = CTA_NONE;
    res = LocalSPM::GetDataProvider().GetFallbackAction(OUT fallbackAction, IN action);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(fallbackAction == CTA_NONE);
}
void DataProviderTest::MarshalUnMarshalDeviceInfoString()
{
    ENTRY_TEST

    tDeviceInfo deviceInfo;
    InitDeviceInfo(IN deviceInfo);

    tDeviceInfoString deviceInfoString;
    tResult result = MP_NO_ERROR;

    //Prepare DeviceInfo to marshal
    strncpy_r(deviceInfo.serialNumber,"8ADEFgK-2333-456",sizeof(deviceInfo.serialNumber));
    strncpy_r(deviceInfo.mountPoint,"/media/AAM_DEV_SDA",sizeof(deviceInfo.mountPoint));
    strncpy_r(deviceInfo.deviceVersion,"290",sizeof(deviceInfo.deviceVersion));
    strncpy_r(deviceInfo.deviceName,"Test-Media",sizeof(deviceInfo.deviceName));
    strncpy_r(deviceInfo.accessoryName,"MyPersonalDevice",sizeof(deviceInfo.accessoryName));
    deviceInfo.deviceID = 8;
    deviceInfo.connectionCount =101;
    deviceInfo.numberOfAudioFiles = 368945;
    deviceInfo.productID =  98996;
    deviceInfo.diPOActive = true;
    deviceInfo.diPOCaps = DIPO_CAP_CARPLAY_WIFI_FEASIBLE;
    deviceInfo.connected = true;
    deviceInfo.deviceType = DTY_MUSICBOX;
    deviceInfo.connectionType = DCT_USB;
    deviceInfo.connectionState = CS_OVERTEMP;
    deviceInfo.deviceState = DS_OK;

    //marshal it
    result = DataProvider::MarshalDeviceInfo(OUT deviceInfoString,IN deviceInfo);
    CPPUNIT_ASSERT(result == MP_NO_ERROR);

    //unmarshal it
    tDeviceInfo unmarshaledDeviceInfo;
    result = DataProvider::UnMarshalDeviceInfo(IN deviceInfoString,OUT unmarshaledDeviceInfo);
    CPPUNIT_ASSERT(result == MP_NO_ERROR);

    //verify unmarshalled DeviceInfo same as the one marshalled
    CPPUNIT_ASSERT(strcmp(unmarshaledDeviceInfo.serialNumber, deviceInfo.serialNumber) == 0);
    CPPUNIT_ASSERT(strcmp(unmarshaledDeviceInfo.deviceVersion, deviceInfo.deviceVersion) == 0);
    CPPUNIT_ASSERT(strcmp(unmarshaledDeviceInfo.deviceName, deviceInfo.deviceName) == 0);
    CPPUNIT_ASSERT(strcmp(unmarshaledDeviceInfo.mountPoint, deviceInfo.mountPoint) == 0);
    CPPUNIT_ASSERT(strcmp(unmarshaledDeviceInfo.accessoryName, deviceInfo.accessoryName) == 0);

    CPPUNIT_ASSERT(deviceInfo.deviceID == unmarshaledDeviceInfo.deviceID);
    CPPUNIT_ASSERT(deviceInfo.connectionCount == unmarshaledDeviceInfo.connectionCount);
    CPPUNIT_ASSERT(deviceInfo.numberOfAudioFiles == unmarshaledDeviceInfo.numberOfAudioFiles);
    CPPUNIT_ASSERT(deviceInfo.productID == unmarshaledDeviceInfo.productID);
    CPPUNIT_ASSERT(deviceInfo.diPOActive == unmarshaledDeviceInfo.diPOActive);
    CPPUNIT_ASSERT(deviceInfo.diPOCaps == unmarshaledDeviceInfo.diPOCaps);
    CPPUNIT_ASSERT(deviceInfo.connected == unmarshaledDeviceInfo.connected);
    CPPUNIT_ASSERT(deviceInfo.deviceType == unmarshaledDeviceInfo.deviceType);
    CPPUNIT_ASSERT(deviceInfo.connectionType == unmarshaledDeviceInfo.connectionType);
    CPPUNIT_ASSERT(deviceInfo.connectionState == unmarshaledDeviceInfo.connectionState);
    CPPUNIT_ASSERT(deviceInfo.deviceState == unmarshaledDeviceInfo.deviceState);
}

