/*lint -save -e578 */
/* ETG definitions */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_DATA_PROVIDER
#ifdef TARGET_BUILD
#include "trcGenProj/Header/DataProvider.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_DATA_PROVIDER
#endif
#endif
#include "FunctionTracer.h"
#include "VarTrace.h"

/* others */
#include "DataProvider.h"
#include "Datapool.h"
#include "LocalSPM.h"
#include "RequestResponseSM.h"


#include <errno.h>
#include <string.h>
#include <vector>
#include <glib.h>
#include <iconv.h>
#include <setjmp.h>

#ifdef USE_FREEIMAGE
#include "FreeImage.h"
#else
#include <IL/devil_cpp_wrapper.hpp>
#endif

#include <taginfo.h>
using namespace std;
using namespace TagInfo;

#define FUNCTION_ID_ALBUMART 1
#define FUNCTION_ID_ALBUMARTINFO 2

/*static list of all the configuration items objects*/
vector <DataProvider::ConfigItemBase*> DataProvider::configurationItems;

/*lint -save -e774 */

DataProvider::DataProvider(const tComponentID componentID):ILocalSPM(componentID)
{
    ENTRY_INTERNAL

    /* Early initialization of variables */
    ResetTestCriteria();
    setFileSystemtype();
    mSPMStandByModeStatus =  false;
    mIpodMuteStatus = false;
}

DataProvider::~DataProvider()
{
    ENTRY_INTERNAL
}

tResult DataProvider::Done()
{
    ENTRY
    return DoneDone(0);
}

void DataProvider::Do(int functionID, void *ptr)
{
    ENTRY

    switch(functionID)
    {
        case FUNCTION_ID_ALBUMART: {
            LocalSPM::GetThreadFactory().SetName("ID_ALBUMART");
            DoGetMediaObjectAlbumArt((char*) ptr);
            break;
        }
        case FUNCTION_ID_ALBUMARTINFO: {
            LocalSPM::GetThreadFactory().SetName("ID_ALBUMARTINFO");
            DoGetMediaObjectAlbumArtInfo((char*) ptr);
            break;
        }
        default:
            break;
    }
}

tResult DataProvider::DeviceInitialized(const tDeviceID deviceID,
    const tDeviceName deviceName,
    const tConnectionState connectionState,
    const tDeviceState deviceState)
{
    ENTRY
    tResult res;

    //Roadmap 13023 ExtConfiguration
    switch(deviceState) {
    case DS_UNSUPPORTED:
        if(!UnsupportedDeviceTypeVisible()) return MP_NO_ERROR;
        break;
    case DS_UNSUPPORTED_FILESYSTEM:
        if(!UnsupportedFileSystemVisible()) return MP_NO_ERROR;
        break;
    case DS_UNSUPPORTED_PARTITION:
        if(!UnsupportedPartitionVisible()) return MP_NO_ERROR;
        break;
    default:
        break;
    }

    res = LocalSPM::GetDBManager().SetDeviceNameAndConnectionState(IN deviceID, IN deviceName, IN connectionState, IN deviceState);
    if (res) return res;

    return MP_NO_ERROR;
}

void DataProvider::TraceConfigValue(const int data, const char *dbName)
{
    ETG_TRACE_USR1(("GMP Configuration name:%128s , Value:%d", dbName,data));
}

void DataProvider::TraceConfigValue(const long data, const char *dbName)
{
    ETG_TRACE_USR1(("GMP Configuration name:%128s , Value:%ld", dbName,data));
}

void DataProvider::TraceConfigValue(const float data, const char *dbName)
{
    ETG_TRACE_USR1(("GMP Configuration name:%128s , Value:%d", dbName,data));
}

void DataProvider::TraceConfigValue(string &data, const char *dbName)
{
    ETG_TRACE_USR1(("GMP Configuration name:%128s , Value:%s", dbName,data.c_str()));
}

void DataProvider::TraceMediaplayerConfigurations(void)
{
    unsigned int iter;
    for(iter = 0 ; iter < DataProvider::configurationItems.size() ; iter++)
    {
        DataProvider::configurationItems[iter]->Trace();
    }
}

tResult DataProvider::SetLanguage(const tLanguageType language)
{
    ENTRY
    tResult result = MP_NO_ERROR;

    result = LocalSPM::GetDBManager().SetLanguage(IN language);

    switch(language)
    {
        case LNG_NA_ENGLISH: /**< North American English */
            DBSortLanguage = "en_US";
            break;
        case LNG_GERMAN:
            DBSortLanguage = "de_De";
            break;
        case LNG_ITALIAN:
            DBSortLanguage = "it_IT";
            break;
        case LNG_SWEDISH:
            DBSortLanguage = "sv_SE";
            break;
        case LNG_FRENCH :   /**< European French */
            DBSortLanguage = "fr_FR";
            break;
        case LNG_SPANISH:   /**< European Spanish */
            DBSortLanguage = "es_ES";
            break;
        case LNG_DUTCH:
            DBSortLanguage = "nl_NL";
            break;
        case LNG_PORTUGUESE:
            DBSortLanguage = "pt_PT";
            break;
        case LNG_NORWEGIAN:
            DBSortLanguage = "no_NO";
            break;
        case LNG_FINNISH:
            DBSortLanguage = "fi_FI";
            break;
        case LNG_DANISH:
            DBSortLanguage = "da_DK";
            break;
        case LNG_GREEK:
            DBSortLanguage = "el_GK";
            break;
        case LNG_JAPANESE:
            DBSortLanguage = "ja";
            break;
        case LNG_ARABIC:
            DBSortLanguage = "ar";
            break;
        case LNG_STANDARD_CHINESE:
            DBSortLanguage = "zh";
            break;
        case LNG_POLISH:
            DBSortLanguage = "pl_PL";
            break;
        case LNG_TURKISH:
            DBSortLanguage = "tr_TR";
            break;
        case LNG_KOREAN:
            DBSortLanguage = "ko";
            break;
        case LNG_TRADITIONAL_CHINESE:
            DBSortLanguage = "zh";
            break;
        case LNG_UK_ENGLISH:    /**< British English */
            DBSortLanguage = "en_UK";
            break;
        case LNG_HUNGARIAN:
            DBSortLanguage = "hu_HU";
            break;
        case LNG_CZECH:
            DBSortLanguage = "cs_CZ";
            break;
        case LNG_SLOVAK:
            DBSortLanguage = "sk_SK";
            break;
        case LNG_RUSSIAN:
            DBSortLanguage = "ru_RU";
            break;
        case LNG_BRAZILIAN_PORTUGUESE:
            DBSortLanguage = "pt_BR";
            break;
        case LNG_THAI:
            DBSortLanguage = "th";
            break;
        case LNG_BULGARIAN:
            DBSortLanguage = "bg";
            break;
        case LNG_ROMANIAN:
            DBSortLanguage = "ro_RO";
            break;
        case LNG_SLOVENIAN:
            DBSortLanguage = "sl_SL";
            break;
        case LNG_CROATIAN:
            DBSortLanguage = "hr_HR";
            break;
        case LNG_UKRAINIAN:
            DBSortLanguage = "uk";
            break;
        case LNG_NA_FRENCH:     /**< North American French */
            DBSortLanguage = "fr_CA";   //Canadian French
            break;
        case LNG_NA_SPANISH:    /**< North American Spanish */
            DBSortLanguage = "es_MX"; // Mexican Spanish
            break;
        case LNG_CANTONESE:
            DBSortLanguage = "es_MX";
            break;
        default:
            break;
    }

    return result;
}

tResult DataProvider::ClearMediaPlayerData(void)
{
    ENTRY
    tResult result = MP_NO_ERROR;
    tResult res;

    // this function may return stop in between

    res = LocalSPM::GetInstance().StateChangeOff();
    if (result == MP_NO_ERROR) result = res;

    res = LocalSPM::GetDBManager().ClearMediaPlayerData();
    if (result == MP_NO_ERROR) result = res;
    tDiPOCallControlsConfiguration config;
    config.value = 0;
    res = SetDiPOCallControlsConfiguration(config);

    res = LocalSPM::GetInstance().StateChangeNormal();
    if (result == MP_NO_ERROR) result = res;

    return result;
}

tResult DataProvider::RecreateTestDatabase(const tBoolean createDevices, const tBoolean createSongs)
{
    ENTRY
    tResult res;

    /* release all created lists from test before */
    res = LocalSPM::GetListControl().ReleaseAllLists();
    if (res) return res;

    /* clear the complete data base */
    res = ClearMediaPlayerData();
    if (res) return res;

    /* create the test database */
    res = LocalSPM::GetDBManager().CreateTestDatabase(createDevices, createSongs);
    if (res) return res;

    return MP_NO_ERROR;
}

tResult DataProvider::GetMediaObjectAlbumArtInfo(const tAlbumArt albumArtString,
    const tSize sizeX,
    const tSize sizeY,
    const tMimeType mimeType,
    const tUserContext userContext)
{
    (void)userContext;
    ENTRY
    const size_t size = sizeof(tAllParameters);
    char *parameterString = new char[size]; //deleted by DoGetMediaObjectAlbumArtInfo
    SMF::Marshal(parameterString, size - 1, "tiiiiiiii", albumArtString, sizeX, sizeY, mimeType, userContext.sourceAppID, userContext.registerID, userContext.cmdCounter, userContext.functionID, userContext.serviceID);

    LocalSPM::GetThreadFactory().Do(IN this, IN FUNCTION_ID_ALBUMARTINFO, IN parameterString);
    return MP_NO_ERROR; //lint !e429
}

tResult DataProvider::DoGetMediaObjectAlbumArtInfo(char *parameterString)
{
    ENTRY;
    tResult res;
    tAlbumArt albumArtString;
    tAlbumArtObjectPtr aaObjectPtr = NULL;
    tSize sizeX;
    tSize sizeY;
    tMimeType mimeType;
    tUserContext userContext;

    SMF::UnMarshal(parameterString, "Tiiiiiiii",
            albumArtString, sizeof(albumArtString)-1,
            &sizeX,
            &sizeY,
            &mimeType,
            &userContext.sourceAppID,
            &userContext.registerID,
            &userContext.cmdCounter,
            &userContext.functionID,
            &userContext.serviceID);

    if (parameterString) {
        delete[] parameterString; //new by GetMediaObjectAlbumArtInfo
    }

    res = GetAlbumArtObject(OUT aaObjectPtr, IN albumArtString, IN sizeX, IN sizeY, IN mimeType, IN userContext);
    if (res){
        ETG_TRACE_ERR(("GetAlbumArtObject() returned error: %d", res));
        aaObjectPtr = NULL;
        //continue and forward error
    }

    /* call the output wrapper */
    res = ForwardAlbumArtInfo(IN aaObjectPtr, IN userContext);
    if (res) return res;

    return MP_NO_ERROR;
}

tResult DataProvider::GetMediaObjectAlbumArt(const tAlbumArt albumArtString,
    const tSize sizeX,
    const tSize sizeY,
    const tMimeType mimeType,
    const tUserContext userContext)
{
    ENTRY
    const size_t size = sizeof(tAllParameters);
    char *parameterString = new char[size]; //deleted by DoGetMediaObjectAlbumArtInfo
    SMF::Marshal(parameterString, size - 1, "tiiiiiiii", albumArtString, sizeX, sizeY, mimeType, userContext.sourceAppID, userContext.registerID, userContext.cmdCounter, userContext.functionID, userContext.serviceID);

    LocalSPM::GetThreadFactory().Do(IN this, IN FUNCTION_ID_ALBUMART, IN parameterString);
    return MP_NO_ERROR; //lint !e429
}

tResult DataProvider::DoGetMediaObjectAlbumArt(char *parameterString)
{
    (void)parameterString;
    ENTRY
    tResult res;
    tAlbumArt albumArtString;
    tAlbumArtObjectPtr aaObjectPtr = NULL;
    tSize sizeX;
    tSize sizeY;
    tMimeType mimeType;
    tUserContext userContext;

    SMF::UnMarshal(parameterString, "Tiiiiiiii",
            albumArtString, sizeof(albumArtString)-1,
            &sizeX,
            &sizeY,
            &mimeType,
            &userContext.sourceAppID,
            &userContext.registerID,
            &userContext.cmdCounter,
            &userContext.functionID,
            &userContext.serviceID);

    if (parameterString) {
        delete[] parameterString; //new by GetMediaObjectAlbumArtInfo
    }

    res = GetAlbumArtObject(OUT aaObjectPtr, IN albumArtString, IN sizeX, IN sizeY, IN mimeType, IN userContext);
    if (res) {
        ETG_TRACE_ERR(("GetAlbumArtObject() returned error: %d", res));
        aaObjectPtr = NULL;
        //continue and forward error
    }

    /* call the output wrapper to send image data */
    res = ForwardAlbumArtObject(IN aaObjectPtr, IN userContext);
    if (res) return res;

    return MP_NO_ERROR;
}

tResult DataProvider::GetAlbumArtObject(tAlbumArtObjectPtr &aaObjectPtr,
    const tAlbumArt albumArtString, const tSize sizeX, const tSize sizeY,
    const tMimeType mimeType, const tUserContext userContext)
{
    (void)userContext;
    ENTRY;
    tResult res = MP_NO_ERROR;

    bool isAppleDevice = false;
    tDeviceID deviceID;
    tDeviceInfo deviceInfo;
    /* get the device id out of the album art string */
    res = LocalSPM::GetDBManager().GetDeviceFromAlbumArtString(OUT deviceID, IN albumArtString);
    if(MP_NO_ERROR ==  res)
    {
        /* get device infos to get the device type */
        res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);

        if(MP_NO_ERROR ==  res)
        {
            isAppleDevice = IsAppleDevice(deviceInfo.deviceType);
        }
    }

    /* check if album art is NOT in cache or is the device is an apple device for apple devices get the albumart from device*/
    if (isAppleDevice || !mAlbumArtCache.IsAlbumArtInCache(IN albumArtString)) {

        /* request album art from device and load it into cache */
        aaObjectPtr = NULL;
        res = GetAlbumArtObjectFromDevice(IN albumArtString, OUT aaObjectPtr);
        if (res) return res;
        if (!aaObjectPtr) {
            return MP_ERR_DP_NO_ALBUM_ART_POINTER;
        }

        /*convert the albumart to requested size and format*/
        tAlbumArtObjectPtr newObjectPtr;
        res = ConvertAlbumArt(IN aaObjectPtr,
                OUT newObjectPtr,
                IN sizeX,
                IN sizeY,
                IN mimeType);

        if (aaObjectPtr->imageData) free(aaObjectPtr->imageData);
        if (aaObjectPtr) delete aaObjectPtr;
        aaObjectPtr = NULL;
        if (res) return res;

        if (!newObjectPtr) {
            return MP_ERR_DP_NO_ALBUM_ART_POINTER;
        }
        /*store the converted album art into cache*/
        mAlbumArtCache.AddToCache(IN albumArtString, IN newObjectPtr);
    }

    /* fetch the information from cache */
    res = mAlbumArtCache.GetAlbumArtObjectFromCache(OUT aaObjectPtr, IN albumArtString);
    return res;
}

#ifdef USE_FREEIMAGE
/**
FreeImage error handler
@param fif Format / Plugin responsible for the error
@param message Error message
*/
void FreeImageErrorHandler(FREE_IMAGE_FORMAT fif, const char *message)
{
    ENTRY

    if(fif != FIF_UNKNOWN)
    {
        ETG_TRACE_ERR(("FreeImageErrorHandler Format : %s ", FreeImage_GetFormatFromFIF(fif)));
    }

    if(message != NULL)
    {
        ETG_TRACE_ERR(("FreeImageErrorHandler errorMessage : %s", message));
    }
}

tResult DataProvider::ConvertAlbumArt(const tAlbumArtObjectPtr orgAlbumArtObject,
        tAlbumArtObjectPtr &convertedAlbumArtObject,
        const tSize newSizeX,
        const tSize newSizeY,
        const tMimeType newMimeType)
{
    ENTRY_INTERNAL

    tResult res = MP_NO_ERROR;
    convertedAlbumArtObject = NULL;
    static int freeImageInit = 0;
    tSize newSizeX_ = newSizeX;
    tSize newSizeY_ = newSizeY;

    mDevilLock.lock();

    /* sanity check */
    if ((!orgAlbumArtObject) && (!orgAlbumArtObject->imageData))
    {
        ETG_TRACE_ERR(("DataProvider::ConvertAlbumArt -> orgAlbumArtObject = NULL"));
        mDevilLock.unlock();
        return MP_ERR_DP_NO_ALBUM_ART_POINTER;
    }

    /* initialize FreeImage in order to get defined behavior of the app */
    if (!freeImageInit)
    {
        /*Initialises the library.Note: Its not required if lib is loaded dynamically*/
        //FreeImage_Initialise();

        freeImageInit = 1;

        FreeImage_SetOutputMessage(FreeImageErrorHandler);
    }

    /* check if requested format supported? */
    FREE_IMAGE_FORMAT newFormat;
    switch(newMimeType)
    {
        case MMT_PNG:
            newFormat = FIF_PNG;
            break;
        case MMT_BMP:
            newFormat = FIF_BMP;
            break;
        case MMT_GIF:
            newFormat = FIF_GIF;
            break;
        case MMT_JPG:
            newFormat = FIF_JPEG;
            break;
        default:
            mDevilLock.unlock();
            return MP_ERR_DP_FORMAT_NOT_SUPPORTED;
    }

    /* open temp file */
    tFilename picFileName = {0};
    GenerateTempFileName(picFileName, "AA");
    FILE *fpPic = fopen(picFileName, "wb");
    if (!fpPic)
    {
        ETG_TRACE_ERR(("fopen: error: %d/%s", errno, strerror(errno)));
        mDevilLock.unlock();
        return -1;
    }

    /* write original picture data */
    fwrite(orgAlbumArtObject->imageData, 1, orgAlbumArtObject->imageSize, fpPic);
    fclose(fpPic);

    /* Get mime type using FreeImage (mime type from taglib is incorrect for few albumarts) */
    FREE_IMAGE_FORMAT orgformat = FreeImage_GetFileType(picFileName, 0);


    FIBITMAP *bitmap = FreeImage_Load(orgformat, picFileName);

    if (bitmap)
    {
        tSize orgSizeX = FreeImage_GetWidth(bitmap);
        tSize orgSizeY = FreeImage_GetHeight(bitmap);
        ETG_TRACE_USR3(("DataProvider::ConvertAlbumArt -> FreeImage orgSizeX:%ld, orgSizeY:%ld", (long)orgSizeX, (long)orgSizeY));

        /* Check if upscaling is supported */
        if(!ScaleUpAlbumArt())
        {
            if(orgSizeX < newSizeX_) //new size is larger than original one
            {
                newSizeX_ = orgSizeX;
            }

            if(orgSizeY < newSizeY_) //new size is larger than original one
            {
                newSizeY_ = orgSizeY;
            }
        }

        /*resize*/
        ETG_TRACE_USR3(("DataProvider::ConvertAlbumArt -> Resize newSizeX:%ld, newSizeY:%ld", (long)newSizeX_, (long)newSizeY_));
        FIBITMAP *rescaledbitmap = FreeImage_Rescale(bitmap, (int)newSizeX_, (int)newSizeY_, FILTER_BILINEAR);

        /*save the new image in the requested format*/
        //CID 486813 : Resource leak
        if(rescaledbitmap)
        {
            if(!FreeImage_Save(newFormat, rescaledbitmap, picFileName))
            {
                ETG_TRACE_ERR(("DataProvider::ConvertAlbumArt -> FreeImage_Save failed"));
                res = MP_ERR_DP_NO_ALBUM_ART_AVAIL;/*NCG3D-106607*/
            }

            /*free*/
            FreeImage_Unload(rescaledbitmap);
        }
        else
        {
            ETG_TRACE_ERR(("DataProvider::ConvertAlbumArt -> FreeImage_Load failed"));
            res = MP_ERR_DP_NO_ALBUM_ART_AVAIL;
        }
        /*free*/
        FreeImage_Unload(bitmap);
    }
    /* was a decoding problem before? */
    if (res)
    {
        mDevilLock.unlock();
        return res;
    }

    /* reread file into a new object */
    convertedAlbumArtObject = new tAlbumArtObject;
    strncpy_r(OUT convertedAlbumArtObject->albumArtString, IN orgAlbumArtObject->albumArtString, IN sizeof(convertedAlbumArtObject->albumArtString));
    convertedAlbumArtObject->imageData = mAlbumArtCache.ReadPicture(OUT convertedAlbumArtObject->imageSize, IN picFileName);
    convertedAlbumArtObject->sizeX = newSizeX_;
    convertedAlbumArtObject->sizeY = newSizeY_;
    convertedAlbumArtObject->mimeType = newMimeType;

    /* remove temp file */
    remove(picFileName);

    mDevilLock.unlock();

    return res;
}
#else
tResult DataProvider::ConvertAlbumArt(const tAlbumArtObjectPtr orgAlbumArtObject,
        tAlbumArtObjectPtr &convertedAlbumArtObject,
        const tSize newSizeX,
        const tSize newSizeY,
        const tMimeType newMimeType)
{
    ENTRY_INTERNAL
    tResult res;
    convertedAlbumArtObject = NULL;
    static int DevilInit = 0;

    /* sanity check */
    if (!orgAlbumArtObject)
    {
            ETG_TRACE_ERR(("orgAlbumArtObject = NULL"));
        return MP_ERR_DP_NO_ALBUM_ART_POINTER;
    }

    /* initialize DevIL in order to get defined behavior of the app */
    if (!DevilInit)
    {
        ilInit();
        iluInit();
#ifdef TARGET_BUILD
        ilutInit();
#endif

        DevilInit = 1;
    }

    /* check if requested format supported? */
    ILenum newFormat;
    switch(newMimeType)
    {
        case MMT_PNG:
            newFormat = IL_PNG;
            break;
        case MMT_BMP:
            newFormat = IL_BMP;
            break;
        case MMT_GIF:
            newFormat = IL_GIF;
            break;
        case MMT_JPG:
            newFormat = IL_JPG;
            break;
        default:
            return MP_ERR_DP_FORMAT_NOT_SUPPORTED;
    }

    /* open temp file */
    tFilename picFileName = {0};
    GenerateTempFileName(picFileName, "AA");
    FILE *fpPic = fopen(picFileName, "wb");
    if (!fpPic)
    {
            ETG_TRACE_ERR(("fopen: error: %d/%s", errno, strerror(errno)));
            return -1;
    }

    /* lock devil lib */
    mDevilLock.lock();

    /* install a segv handler to catch problems in lib devil */
    struct sigaction sigAction;
    struct sigaction oldSigAction;

    memset(&sigAction, 0, sizeof(sigAction));
    sigemptyset(&sigAction.sa_mask);
    sigAction.sa_sigaction = CatchSEGVforDevil;
    sigAction.sa_flags   = SA_SIGINFO;
    sigaction(SIGSEGV, &sigAction, &oldSigAction);

    ilImage *image = new ilImage();
    res = MP_NO_ERROR;

    /* set the jump back point for long jump out of segv catcher */
    switch(setjmp(mCatchSEGVforDevilBackJump))
    {
        case 0: // normal processing

            /* write the picture data */
            fwrite(orgAlbumArtObject->imageData, 1, orgAlbumArtObject->imageSize, fpPic);
            fclose(fpPic);

            /* start devil with this image */
            image->Load(picFileName);

            image->iGenBind();
            VARTRACE(image->Height());
            VARTRACE(image->Width());
            iluImageParameter(ILU_FILTER, ILU_BILINEAR);

            /* resize the image */
            image->Resize(newSizeX, newSizeY, image->Depth());

            /* save file */
            ilEnable(IL_FILE_OVERWRITE);
            image->Save(picFileName, newFormat);

            /* delete image from cache */
            image->Delete();

            break;

        case 1: // abort by segv callback

            ETG_TRACE_ERR(("Devil: Error in image decoding: %s", picFileName));
            res = MP_ERR_DP_NO_ALBUM_ART_AVAIL;
            break;
        default:
            break;
    }

    /* reinstall the old signal handler */
    sigaction(SIGSEGV, &oldSigAction, NULL);

    /* delete image object */
    delete image;

    /* unlock devil lib */
    mDevilLock.unlock();

    /* was a decoding problem before? */
    if (res) return res;

    /* reread file into a new object */
    convertedAlbumArtObject = new tAlbumArtObject;
    strncpy_r(OUT convertedAlbumArtObject->albumArtString, IN orgAlbumArtObject->albumArtString, IN sizeof(convertedAlbumArtObject->albumArtString));
    convertedAlbumArtObject->imageData = mAlbumArtCache.ReadPicture(OUT convertedAlbumArtObject->imageSize, IN picFileName);
    convertedAlbumArtObject->sizeX = newSizeX;
    convertedAlbumArtObject->sizeY = newSizeY;
    convertedAlbumArtObject->mimeType = newMimeType;

    /* remove temp file */
    remove(picFileName);

    return MP_NO_ERROR;
}

static jmp_buf mCatchSEGVforDevilBackJump;

void DataProvider::CatchSEGVforDevil(int signal, siginfo_t *si, void *arg)
{
    (void)signal;
    (void)si;
    (void)arg;

    /* jump back to caller and trace the error */
    longjmp (mCatchSEGVforDevilBackJump, 1);
}

#endif

tResult DataProvider::GetAlbumArtObjectFromDevice(const tAlbumArt albumArtString , tAlbumArtObjectPtr &albumArtObjectPointer)
{
    ENTRY

    /* use a request / response state machine to request albumart from the devicecontrol (usb/ipod/mtp etc)*/
    class AlbumArtRR : public RequestResponseSM
    {
        int HandleInitRequest()
        {
            mAlbumArtObjectPointer = NULL;
            mResult = MP_NO_ERROR;
            return 0;
        }

        int HandleActionError()
        {
            mAlbumArtObjectPointer = NULL;
            mResult = MP_ERR_DP_NO_ALBUM_ART_AVAIL;
            return 0;
        }

        int HandleLoopBackMessage(const char *allParameters)
        {
            (void)allParameters;
            HandleSuccessRequest(NULL);
            return 0;
        }

        int HandleSuccessRequest(const char *allParameters)
        {

            if (!allParameters || strlen_r(allParameters) == 0) {
#if FAKE_ALBUM_ART
                mAlbumArtCache->LoadAlbumArtIntoCache(IN mAlbumArtString);
                return 0;
#else
                /* set an error */
                mResult = MP_ERR_DP_NO_ALBUM_ART_AVAIL;
#endif
            }
            else
            {
            /* read out the pointer to the album art object */
            UnMarshal(IN allParameters, "p", OUT &mAlbumArtObjectPointer);

            /* no album art object? then set the erro*/
            if (!mAlbumArtObjectPointer)
            {
                mResult = MP_ERR_DP_NO_ALBUM_ART_AVAIL;
                }
            }

            return 0;
        }
        public:
        tAlbumArtObjectPtr mAlbumArtObjectPointer;
        tResult mResult;
        tAlbumArt mAlbumArtString;
    };

    AlbumArtRR rrAlbumArt;
    tDeviceID deviceID;
    tDeviceInfo deviceInfo;
    tDeviceControlName deviceControlName;
    char msgToSendString[64];
    tResult res;

    /* get the device id out of the album art string */
    res = LocalSPM::GetDBManager().GetDeviceFromAlbumArtString(OUT deviceID, IN albumArtString);
    if (res) return res;

    /* it must always be a real device that is requested */
    if (deviceID == MY_MEDIA) return MP_ERR_DP_NO_ALBUM_ART_AVAIL;

    /* get device infos to get the device type */
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    if (res) return res;

    /* get the name of the device control to address the correct state machine */
    res = LocalSPM::GetDeviceDispatcher().GetDeviceControlName(OUT deviceControlName, IN deviceInfo.deviceType);
    if (res) return res;

    /* compose the message name */
#if FAKE_ALBUM_ART
    strncpy_r(OUT msgToSendString, IN rrAlbumArt.GetSMNameFull(), IN sizeof(msgToSendString));
    strncat_r(OUT msgToSendString, IN "::LOOP_BACK_MESSAGE", IN sizeof(msgToSendString));
#else
    strncpy_r(OUT msgToSendString, IN deviceControlName, IN sizeof(msgToSendString));
    strncat_r(OUT msgToSendString, IN "::GET_ALBUM_ART", IN sizeof(msgToSendString));
#endif

    /* send the request for a album art object to device */
    strncpy_r(OUT rrAlbumArt.mAlbumArtString, IN albumArtString, IN sizeof(rrAlbumArt.mAlbumArtString));

    res = rrAlbumArt.DoEventAnswer(IN msgToSendString, IN albumArtString, NULL, 10000);
    if (res) return res;
    if (rrAlbumArt.mResult) return rrAlbumArt.mResult;

    albumArtObjectPointer = rrAlbumArt.mAlbumArtObjectPointer;

    return MP_NO_ERROR;
}

tResult DataProvider::ForwardAlbumArtObject(const tAlbumArtObjectPtr ptrToAlbumArtObject, const tUserContext userContext)
{
    ENTRY
    tResult errorCode;
    tResult res;

    if (ptrToAlbumArtObject && ptrToAlbumArtObject->imageSize > 0) { // no error
        res = LocalSPM::GetOutputWrapper().SendGetMediaObjectAlbumArtAnswer(ptrToAlbumArtObject->imageData, IN ptrToAlbumArtObject->imageSize, userContext);
        if (res) return res;
    } else {
        errorCode = 0x1;
        res = LocalSPM::GetOutputWrapper().SendGetMediaObjectAlbumArtError(errorCode, userContext);
        if (res) return res;
    }

    return MP_NO_ERROR;
}

tResult DataProvider::ForwardAlbumArtInfo(const tAlbumArtObjectPtr ptrToAlbumArtObject, const tUserContext userContext)
{
    ENTRY
    tResult errorCode;
    tResult res;

    if (ptrToAlbumArtObject && ptrToAlbumArtObject->imageSize > 0) { // no error
        res = LocalSPM::GetOutputWrapper().SendGetMediaObjectAlbumArtInfoAnswer(ptrToAlbumArtObject->mimeType, IN ptrToAlbumArtObject->imageSize, IN userContext);
        if (res) return res;
    } else {
        errorCode = 0x1;
        res = LocalSPM::GetOutputWrapper().SendGetMediaObjectAlbumArtInfoError(IN errorCode, IN userContext);
        if (res) return res;
    }

    return MP_NO_ERROR;
}

tResult DataProvider::ActiveMediaDeviceSet(const tDeviceID deviceID, const tBoolean activeSource)
{
    ENTRY
    tResult res;
    tDeviceInfo deviceInfo;

    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    if (res) return res;

    if(deviceInfo.activeSource != activeSource)
    {
        res = LocalSPM::GetDBManager().ActiveMediaDeviceSet(IN deviceID, IN activeSource);
        if (res) return res;

        //CarPlay TAKE/BORROW HID Play extension
        //internal mediaplayer source device switched -> CarPlay audio TAKE
        DiPOStopReason = DIPO_STOP_REASON_DEVICE_SWITCHED;
    }

    return MP_NO_ERROR;
}

tResult DataProvider::GetAutoplayDeviceTypes(vector<tDeviceType> &deviceTypes)
{
    ENTRY_INTERNAL
    tUInt noOfAutoplayDeviceTypes = AutoplayDeviceTypes();
    deviceTypes.clear();

    for(tUInt i=0; i<noOfAutoplayDeviceTypes; i++) {
        switch(i) {
        case 0:
            deviceTypes.push_back((tDeviceType)AutoplayDeviceType_1());
            break;
        case 1:
            deviceTypes.push_back((tDeviceType)AutoplayDeviceType_2());
            break;
        case 2:
            deviceTypes.push_back((tDeviceType)AutoplayDeviceType_3());
            break;
        case 3:
            deviceTypes.push_back((tDeviceType)AutoplayDeviceType_4());
            break;
        case 4:
            deviceTypes.push_back((tDeviceType)AutoplayDeviceType_5());
            break;
        case 5:
            deviceTypes.push_back((tDeviceType)AutoplayDeviceType_6());
            break;
        case 6:
            deviceTypes.push_back((tDeviceType)AutoplayDeviceType_7());
            break;
        case 7:
            deviceTypes.push_back((tDeviceType)AutoplayDeviceType_8());
            break;
        default:
            ETG_TRACE_FATAL(("[ERROR] DataProvider::GetAutoplayDeviceTypes: Check mediaplayer configuration"));
            break;
        }
    }

    return MP_NO_ERROR;
}

tResult DataProvider::GetIndexingPriority(tPriority &priority, const tDeviceType deviceType)
{
    ENTRY
    priority = PRIORITY_NONE;
    tUInt noOfIndexingSupportDeviceTypes = IndexingSupportDeviceTypes();

    for(tUInt i=0; i<noOfIndexingSupportDeviceTypes; i++)
    {
        switch(i)
        {
        case 0:
            if(deviceType == (tDeviceType)IndexingSupportDeviceType_1()) {priority = i;}
            break;
        case 1:
            if(deviceType == (tDeviceType)IndexingSupportDeviceType_2()) {priority = i;}
            break;
        case 2:
            if(deviceType == (tDeviceType)IndexingSupportDeviceType_3()) {priority = i;}
            break;
        case 3:
            if(deviceType == (tDeviceType)IndexingSupportDeviceType_4()) {priority = i;}
            break;
        case 4:
            if(deviceType == (tDeviceType)IndexingSupportDeviceType_5()) {priority = i;}
            break;
        case 5:
            if(deviceType == (tDeviceType)IndexingSupportDeviceType_6()) {priority = i;}
            break;
        case 6:
            if(deviceType == (tDeviceType)IndexingSupportDeviceType_7()) {priority = i;}
            break;
        case 7:
            if(deviceType == (tDeviceType)IndexingSupportDeviceType_8()) {priority = i;}
            break;
        default:
            ETG_TRACE_FATAL(("[ERROR] DataProvider::GetIndexingPriority: Check mediaplayer configuration"));
            break;
        }

        if(PRIORITY_NONE != priority)
        {
            break;
        }
    }

    return MP_NO_ERROR;
}

tBoolean DataProvider::IsIndexingSupported(const tDeviceType deviceType)
{
    ENTRY

    tBoolean answer = false;
    tPriority priority = PRIORITY_NONE;
    GetIndexingPriority(priority, deviceType);
    if(PRIORITY_NONE != priority)
    {
        answer = true;
    }

    return answer;
}

tBoolean DataProvider:: IsIndexableDevice(tDeviceType deviceType,tConnectionType connectionType)
{
    ENTRY

    tBoolean isIndexable = false;
    if(IAPBTConnectionOnlyForSmartApp() && connectionType == DCT_BLUETOOTH)
        return isIndexable;

    tUInt noOfIndexingSupportDeviceTypes = IndexingSupportDeviceTypes();

    for(tUInt i=1; i<= noOfIndexingSupportDeviceTypes; i++)
    {
        switch(i)
        {
        case 1:
            if(deviceType == (tDeviceType)IndexingSupportDeviceType_1()) {isIndexable = true;}
            break;
        case 2:
            if(deviceType == (tDeviceType)IndexingSupportDeviceType_2()) {isIndexable = true;}
            break;
        case 3:
            if(deviceType == (tDeviceType)IndexingSupportDeviceType_3()) {isIndexable = true;}
            break;
        case 4:
            if(deviceType == (tDeviceType)IndexingSupportDeviceType_4()) {isIndexable = true;}
            break;
        case 5:
            if(deviceType == (tDeviceType)IndexingSupportDeviceType_5()) {isIndexable = true;}
            break;
        case 6:
            if(deviceType == (tDeviceType)IndexingSupportDeviceType_6()) {isIndexable = true;}
            break;
        case 7:
            if(deviceType == (tDeviceType)IndexingSupportDeviceType_7()) {isIndexable = true;}
            break;
        default:
            ETG_TRACE_FATAL(("[ERROR] DataProvider::IsIndexableDevice: Check mediaplayer configuration"));
            break;
        }

        if(true == isIndexable)
        {
            break;
        }
    }

    return isIndexable;
}

tBoolean DataProvider::IsAlbumArtIndexingSupported(const tDeviceType deviceType)
{
    ENTRY

    tBoolean isSupported = false;

    if(AlbumArtThumbnail() || CoverArtFlow()) //Check if one of the feature switches for collecting album arts is enabled
    {
        tUInt noOfAlbumArtIndexingSupportDeviceTypes = AlbumArtIndexingSupportDeviceTypes();

        for(tUInt i=0; i<noOfAlbumArtIndexingSupportDeviceTypes; i++)
        {
            switch(i)
            {
            case 0:
                if(deviceType == (tDeviceType)AlbumArtIndexingSupportDeviceType_01()) {isSupported = true;}
                break;
            case 1:
                if(deviceType == (tDeviceType)AlbumArtIndexingSupportDeviceType_02()) {isSupported = true;}
                break;
            case 2:
                if(deviceType == (tDeviceType)AlbumArtIndexingSupportDeviceType_03()) {isSupported = true;}
                break;
            case 3:
                if(deviceType == (tDeviceType)AlbumArtIndexingSupportDeviceType_04()) {isSupported = true;}
                break;
            case 4:
                if(deviceType == (tDeviceType)AlbumArtIndexingSupportDeviceType_05()) {isSupported = true;}
                break;
            case 5:
                if(deviceType == (tDeviceType)AlbumArtIndexingSupportDeviceType_06()) {isSupported = true;}
                break;
            case 6:
                if(deviceType == (tDeviceType)AlbumArtIndexingSupportDeviceType_07()) {isSupported = true;}
                break;
            case 7:
                if(deviceType == (tDeviceType)AlbumArtIndexingSupportDeviceType_08()) {isSupported = true;}
                break;
            default:
                ETG_TRACE_FATAL(("[ERROR] DataProvider::IsAlbumArtIndexingSupported: Check mediaplayer configuration"));
                break;
            }

            if(true == isSupported)
            {
                break;
            }
        }
    }

    return isSupported;
}

tBoolean DataProvider::IsAlbumArtSupported(const tDeviceType deviceType)
{
    tBoolean isSupported = true;

    tUInt noOfAlbumArtUnSupportedDeviceTypes = AlbumArtUnSupportedDeviceTypes();

    for(tUInt i=0; i<noOfAlbumArtUnSupportedDeviceTypes; i++)
    {
        switch(i)
        {
            case 0:
                if(deviceType == (tDeviceType)AlbumArtUnSupportedDeviceType_1()) {isSupported = false;}
                break;
            case 1:
                if(deviceType == (tDeviceType)AlbumArtUnSupportedDeviceType_2()) {isSupported = false;}
                break;
            case 2:
                if(deviceType == (tDeviceType)AlbumArtUnSupportedDeviceType_3()) {isSupported = false;}
                break;
            default:
                ETG_TRACE_FATAL(("[ERROR] DataProvider::IsAlbumArtSupported: Check mediaplayer configuration"));
                break;
        }

        if(false == isSupported)
        {
            break;
        }
    }

    return isSupported;
}

tResult DataProvider::GetPermanentStreamingDeviceTypes(vector<tDeviceType> &deviceTypes)
{
    ENTRY_INTERNAL
    tUInt noOfPermanentStreamingDeviceTypes = PermanentStreamingDeviceTypes();
    deviceTypes.clear();

    for(tUInt i=0; i<noOfPermanentStreamingDeviceTypes; i++) {
        switch(i) {
        case 0:
            deviceTypes.push_back((tDeviceType)PermanentStreamingDeviceType_1());
            break;
        case 1:
            deviceTypes.push_back((tDeviceType)PermanentStreamingDeviceType_2());
            break;
        case 2:
            deviceTypes.push_back((tDeviceType)PermanentStreamingDeviceType_3());
            break;
        case 3:
            deviceTypes.push_back((tDeviceType)PermanentStreamingDeviceType_4());
            break;
        case 4:
            deviceTypes.push_back((tDeviceType)PermanentStreamingDeviceType_5());
            break;
        case 5:
            deviceTypes.push_back((tDeviceType)PermanentStreamingDeviceType_6());
            break;
        case 6:
            deviceTypes.push_back((tDeviceType)PermanentStreamingDeviceType_7());
            break;
        case 7:
            deviceTypes.push_back((tDeviceType)PermanentStreamingDeviceType_8());
            break;
        default:
            ETG_TRACE_FATAL(("[ERROR] DataProvider::GetPermanentStreamingDeviceTypes: Check mediaplayer configuration"));
            break;
        }
    }

    return MP_NO_ERROR;
}

tFileExtensions DataProvider::GetSupportedFileExtensions()
{
    ENTRY
    tFileExtensions fileExtensions;
    fileExtensions.clear();

    for(int i=1; i<=SupportedFileTypes(); i++) {
        switch(i) {
        case 1:
            fileExtensions.push_back(SupportedFileTypeExtension_01());
            break;
        case 2:
            fileExtensions.push_back(SupportedFileTypeExtension_02());
            break;
        case 3:
            fileExtensions.push_back(SupportedFileTypeExtension_03());
            break;
        case 4:
            fileExtensions.push_back(SupportedFileTypeExtension_04());
            break;
        case 5:
            fileExtensions.push_back(SupportedFileTypeExtension_05());
            break;
        case 6:
            fileExtensions.push_back(SupportedFileTypeExtension_06());
            break;
        case 7:
            fileExtensions.push_back(SupportedFileTypeExtension_07());
            break;
        case 8:
            fileExtensions.push_back(SupportedFileTypeExtension_08());
            break;
        case 9:
            fileExtensions.push_back(SupportedFileTypeExtension_09());
            break;
        case 10:
            fileExtensions.push_back(SupportedFileTypeExtension_10());
            break;
        case 11:
            fileExtensions.push_back(SupportedFileTypeExtension_11());
            break;
        case 12:
            fileExtensions.push_back(SupportedFileTypeExtension_12());
            break;
        case 13:
            fileExtensions.push_back(SupportedFileTypeExtension_13());
            break;
        case 14:
            fileExtensions.push_back(SupportedFileTypeExtension_14());
            break;
        case 15:
            fileExtensions.push_back(SupportedFileTypeExtension_15());
            break;
        case 16:
            fileExtensions.push_back(SupportedFileTypeExtension_16());
            break;
        case 17:
            fileExtensions.push_back(SupportedFileTypeExtension_17());
            break;
        case 18:
            fileExtensions.push_back(SupportedFileTypeExtension_18());
            break;
        case 19:
            fileExtensions.push_back(SupportedFileTypeExtension_19());
            break;
        case 20:
            fileExtensions.push_back(SupportedFileTypeExtension_20());
            break;
        case 21:
            fileExtensions.push_back(SupportedFileTypeExtension_21());
            break;
        case 22:
            fileExtensions.push_back(SupportedFileTypeExtension_22());
            break;
        case 23:
            fileExtensions.push_back(SupportedFileTypeExtension_23());
            break;
        case 24:
            fileExtensions.push_back(SupportedFileTypeExtension_24());
            break;
        case 25:
            fileExtensions.push_back(SupportedFileTypeExtension_25());
            break;
        case 26:
            fileExtensions.push_back(SupportedFileTypeExtension_26());
            break;
        case 27:
            fileExtensions.push_back(SupportedFileTypeExtension_27());
            break;
        case 28:
            fileExtensions.push_back(SupportedFileTypeExtension_28());
            break;
        case 29:
            fileExtensions.push_back(SupportedFileTypeExtension_29());
            break;
        case 30:
            fileExtensions.push_back(SupportedFileTypeExtension_30());
            break;
        case 31:
            fileExtensions.push_back(SupportedFileTypeExtension_31());
            break;
        case 32:
            fileExtensions.push_back(SupportedFileTypeExtension_32());
            break;
        case 33:
            fileExtensions.push_back(SupportedFileTypeExtension_33());
            break;
        case 34:
            fileExtensions.push_back(SupportedFileTypeExtension_34());
            break;
        case 35:
            fileExtensions.push_back(SupportedFileTypeExtension_35());
            break;
        case 36:
            fileExtensions.push_back(SupportedFileTypeExtension_36());
            break;
        case 37:
            fileExtensions.push_back(SupportedFileTypeExtension_37());
            break;
        case 38:
            fileExtensions.push_back(SupportedFileTypeExtension_38());
            break;
        case 39:
            fileExtensions.push_back(SupportedFileTypeExtension_39());
            break;
        case 40:
            fileExtensions.push_back(SupportedFileTypeExtension_40());
            break;
        default:
            ETG_TRACE_FATAL(("[ERROR] DataProvider::GetSupportedFileExtensions: Check mediaplayer configuration (SupportedFileTypes)"));
            break;
        }
    }

    ETG_TRACE_USR3(("GetSupportedFileExtensions: Number of supported file extensions:%d", fileExtensions.size()));

    return fileExtensions;
}

tFileExtensions DataProvider::GetSupportedFileFilters()
{
    ENTRY
    tFileExtensions fileFilters;
    fileFilters.clear();

    for(int i=1; i<=LocalSPM::GetDataProvider().FileFilterCount(); i++)
    {
        switch(i)
        {
            case 1:
                fileFilters.push_back(LocalSPM::GetDataProvider().FileFilter_01());
                break;
            case 2:
                fileFilters.push_back(LocalSPM::GetDataProvider().FileFilter_02());
                break;
            case 3:
                fileFilters.push_back(LocalSPM::GetDataProvider().FileFilter_03());
                break;
            case 4:
                fileFilters.push_back(LocalSPM::GetDataProvider().FileFilter_04());
                break;
            case 5:
                fileFilters.push_back(LocalSPM::GetDataProvider().FileFilter_05());
                break;
            case 6:
                fileFilters.push_back(LocalSPM::GetDataProvider().FileFilter_06());
                break;
            default:
                ETG_TRACE_FATAL(("[ERROR] DataProvider::GetSupportedFileFilters: Check mediaplayer configuration (FileFilterCount)"));
                break;
        }
    }

   ETG_TRACE_USR3(("GetSupportedFileFilters: Number of supported filefilters:%d", fileFilters.size()));

   return fileFilters;
}

tResult DataProvider::GetSearchStringForValidPartition(tSearchString &searchString)
{
    ENTRY
    tResult ret = -1;
    tSearchString extension = {0};
    tUInt extensionCount = 0;

    strncat_r(OUT searchString, IN ".*/.*\\.\\(", IN sizeof(searchString));

    /* Search string for "find"/"grep" */
    for(int index =1 ; index <= SupportedFileTypes(); index++)
    {
        extension[0] = '\0';
        switch(index) {
        case 1:
            SupportedFileTypeExtension_01().copy(extension,strlen_r(SupportedFileTypeExtension_01().c_str()),1);
            break;
        case 2:
            SupportedFileTypeExtension_02().copy(extension,strlen_r(SupportedFileTypeExtension_02().c_str()),1);
            break;
        case 3:
            SupportedFileTypeExtension_03().copy(extension,strlen_r(SupportedFileTypeExtension_03().c_str()),1);
            break;
        case 4:
            SupportedFileTypeExtension_04().copy(extension,strlen_r(SupportedFileTypeExtension_04().c_str()),1);
            break;
        case 5:
            SupportedFileTypeExtension_05().copy(extension,strlen_r(SupportedFileTypeExtension_05().c_str()),1);
            break;
        case 6:
            SupportedFileTypeExtension_06().copy(extension,strlen_r(SupportedFileTypeExtension_06().c_str()),1);
            break;
        case 7:
            SupportedFileTypeExtension_07().copy(extension,strlen_r(SupportedFileTypeExtension_07().c_str()),1);
            break;
        case 8:
            SupportedFileTypeExtension_08().copy(extension,strlen_r(SupportedFileTypeExtension_08().c_str()),1);
            break;
        case 9:
            SupportedFileTypeExtension_09().copy(extension,strlen_r(SupportedFileTypeExtension_09().c_str()),1);
            break;
        case 10:
            SupportedFileTypeExtension_10().copy(extension,strlen_r(SupportedFileTypeExtension_10().c_str()),1);
            break;
        case 11:
            SupportedFileTypeExtension_11().copy(extension,strlen_r(SupportedFileTypeExtension_11().c_str()),1);
            break;
        case 12:
            SupportedFileTypeExtension_12().copy(extension,strlen_r(SupportedFileTypeExtension_12().c_str()),1);
            break;
        case 13:
            SupportedFileTypeExtension_13().copy(extension,strlen_r(SupportedFileTypeExtension_13().c_str()),1);
            break;
        case 14:
            SupportedFileTypeExtension_14().copy(extension,strlen_r(SupportedFileTypeExtension_14().c_str()),1);
            break;
        case 15:
            SupportedFileTypeExtension_15().copy(extension,strlen_r(SupportedFileTypeExtension_15().c_str()),1);
            break;
        case 16:
            SupportedFileTypeExtension_16().copy(extension,strlen_r(SupportedFileTypeExtension_16().c_str()),1);
            break;
        case 17:
            SupportedFileTypeExtension_17().copy(extension,strlen_r(SupportedFileTypeExtension_17().c_str()),1);
            break;
        case 18:
            SupportedFileTypeExtension_18().copy(extension,strlen_r(SupportedFileTypeExtension_18().c_str()),1);
            break;
        case 19:
            SupportedFileTypeExtension_19().copy(extension,strlen_r(SupportedFileTypeExtension_19().c_str()),1);
            break;
        case 20:
            SupportedFileTypeExtension_20().copy(extension,strlen_r(SupportedFileTypeExtension_20().c_str()),1);
            break;
        case 21:
            SupportedFileTypeExtension_21().copy(extension,strlen_r(SupportedFileTypeExtension_21().c_str()),1);
            break;
        case 22:
            SupportedFileTypeExtension_22().copy(extension,strlen_r(SupportedFileTypeExtension_22().c_str()),1);
            break;
        case 23:
            SupportedFileTypeExtension_23().copy(extension,strlen_r(SupportedFileTypeExtension_23().c_str()),1);
            break;
        case 24:
            SupportedFileTypeExtension_24().copy(extension,strlen_r(SupportedFileTypeExtension_24().c_str()),1);
            break;
        case 25:
            SupportedFileTypeExtension_25().copy(extension,strlen_r(SupportedFileTypeExtension_25().c_str()),1);
            break;
        case 26:
            SupportedFileTypeExtension_26().copy(extension,strlen_r(SupportedFileTypeExtension_26().c_str()),1);
            break;
        case 27:
            SupportedFileTypeExtension_27().copy(extension,strlen_r(SupportedFileTypeExtension_27().c_str()),1);
            break;
        case 28:
            SupportedFileTypeExtension_28().copy(extension,strlen_r(SupportedFileTypeExtension_28().c_str()),1);
            break;
        case 29:
            SupportedFileTypeExtension_29().copy(extension,strlen_r(SupportedFileTypeExtension_29().c_str()),1);
            break;
        case 30:
            SupportedFileTypeExtension_30().copy(extension,strlen_r(SupportedFileTypeExtension_30().c_str()),1);
            break;
        case 31:
            SupportedFileTypeExtension_31().copy(extension,strlen_r(SupportedFileTypeExtension_31().c_str()),1);
            break;
        case 32:
            SupportedFileTypeExtension_32().copy(extension,strlen_r(SupportedFileTypeExtension_32().c_str()),1);
            break;
        case 33:
            SupportedFileTypeExtension_33().copy(extension,strlen_r(SupportedFileTypeExtension_33().c_str()),1);
            break;
        case 34:
            SupportedFileTypeExtension_34().copy(extension,strlen_r(SupportedFileTypeExtension_34().c_str()),1);
            break;
        case 35:
            SupportedFileTypeExtension_35().copy(extension,strlen_r(SupportedFileTypeExtension_35().c_str()),1);
            break;
        case 36:
            SupportedFileTypeExtension_36().copy(extension,strlen_r(SupportedFileTypeExtension_36().c_str()),1);
            break;
        case 37:
            SupportedFileTypeExtension_37().copy(extension,strlen_r(SupportedFileTypeExtension_37().c_str()),1);
            break;
        case 38:
            SupportedFileTypeExtension_38().copy(extension,strlen_r(SupportedFileTypeExtension_38().c_str()),1);
            break;
        case 39:
            SupportedFileTypeExtension_39().copy(extension,strlen_r(SupportedFileTypeExtension_39().c_str()),1);
            break;
        default:
            ETG_TRACE_USR3(("Unsupported file type"));
            break;
        }

        if(0 < strlen_r(extension))
        {
            extensionCount++;

            if(1 < extensionCount) //first element
            {
                strncat_r(OUT searchString, IN "\\|", IN sizeof(searchString));
            }

            strncat_r(OUT searchString, IN extension, IN sizeof(searchString));
        }
    }


    strncat_r(OUT searchString, IN "\\)", IN sizeof(searchString));


    ETG_TRACE_USR3(("Search string for valid partition check: %s", searchString));
    if(extensionCount == 0)
    {
        ETG_TRACE_USR3(("NO supported types found"));
    }
    else
    {
        ret = MP_NO_ERROR;
    }
    return ret;
}

tBool DataProvider::IsValidContentAvilable( const tMountPoint mountPoint)
{
    ENTRY
    tBool isValid = false;
    tResult ret;
    tFilename outFileName = {0};
    tSearchString searchString = {0};

    FILE *fp = NULL;
    GenerateTempFileName(outFileName, "CheckValidPartition");

    ret = GetSearchStringForValidPartition(INOUT searchString);

    if((ret == MP_NO_ERROR) && (0 < strlen_r(searchString)))
    {
        //Check mountPoint for any supported file types from searchString.
        char* commandStr[]={(char *)"/usr/bin/find",(char *)mountPoint,(char *)("-type"),(char *)("f"),(char *)("-regex"),searchString,NULL};
        ETG_TRACE_USR4(("DataProvider::IsValidContentAvilable: calling executeCommand() for find -type f -regex"));
        int retStatus=executeCommand(commandStr,string(outFileName));
        if(0 == retStatus)
        {
            ETG_TRACE_USR3(("DataProvider::IsValidContentAvilable: executeCommand() success for find -type f -regex"));
            ifstream read(outFileName);
            if (!read)
            {
                ETG_TRACE_ERR(("creating file stream failed: error: %d/%s", errno, strerror(errno)));
            }
            else
            {
                if(read.peek() == EOF)
                {
                    ETG_TRACE_USR3(("The mount point :%s doesn't contain any valid files",mountPoint));
                }
                else
                {
                    ETG_TRACE_USR3(("The mount point :%s contains valid files",mountPoint));
                    isValid = true;
                }
                read.close();
            }
        }
        else
        {
            ETG_TRACE_ERR(("DataProvider::IsValidContentAvilable: executeCommand() failed for find -type f -regex. Error:%s",strerror(retStatus)));
        }

        if(0 != remove(outFileName))
        {
            ETG_TRACE_ERR(("Error deleting(CheckValidPartition) file. Error:%s",strerror(errno)));
        }
    }
    else
    {
        ETG_TRACE_ERR(("Error while getting Supported file types "));
    }

    return isValid;
}


tResult DataProvider::GetFallbackAction(tConfigTableAction &outAction, const tConfigTableAction inAction)
{
    ENTRY_INTERNAL
    tUInt noOfFallbackActions = FallbackActions();
    outAction = CTA_NONE;

    for(tUInt i=0; i<noOfFallbackActions; i++) {
        switch(i) {
        case 0:
            if(inAction == (tConfigTableAction)FallbackInAction_01())
            {
                outAction = (tConfigTableAction)FallbackOutAction_01();
            }
            break;
        case 1:
            if(inAction == (tConfigTableAction)FallbackInAction_02())
            {
                outAction = (tConfigTableAction)FallbackOutAction_02();
            }
            break;
        case 2:
            if(inAction == (tConfigTableAction)FallbackInAction_03())
            {
                outAction = (tConfigTableAction)FallbackOutAction_03();
            }
            break;
        case 3:
            if(inAction == (tConfigTableAction)FallbackInAction_04())
            {
                outAction = (tConfigTableAction)FallbackOutAction_04();
            }
            break;
        case 4:
            if(inAction == (tConfigTableAction)FallbackInAction_05())
            {
                outAction = (tConfigTableAction)FallbackOutAction_05();
            }
            break;
        case 5:
            if(inAction == (tConfigTableAction)FallbackInAction_06())
            {
                outAction = (tConfigTableAction)FallbackOutAction_06();
            }
            break;
        case 6:
            if(inAction == (tConfigTableAction)FallbackInAction_07())
            {
                outAction = (tConfigTableAction)FallbackOutAction_07();
            }
            break;
        case 7:
            if(inAction == (tConfigTableAction)FallbackInAction_08())
            {
                outAction = (tConfigTableAction)FallbackOutAction_08();
            }
            break;
        default:
            ETG_TRACE_FATAL(("[ERROR] DataProvider::GetFallbackAction: Check mediaplayer configuration"));
            break;
        }
    }

    ETG_TRACE_USR3(("DataProvider::GetFallbackAction: inAction:%d -> outAction:%d", inAction, outAction));

    return MP_NO_ERROR;
}

tResult DataProvider::ProcessConfigTable(tConfigTableAction &action, const tConfigTable usedConfigTable, const tConfigTablePrecondition precondition, const tDeviceID deviceID)
{
    ENTRY
    //tResult res = MP_NO_ERROR;

    tUInt configTableRows = 0;
    tUInt configTableColumns = 0;

    tConfigTableCriteria configTableFunctionCriteria[] = {CTC_NONE,CTC_NONE,CTC_NONE,CTC_NONE,CTC_NONE,CTC_NONE,CTC_NONE,CTC_NONE}; //used function criteria
    tInteger valueIsStartupPhase = -1;
    tInteger valueIsLastPlayedDevice = -1;
    tInteger valueIsAnyDeviceActive = -1;
    tInteger valueIsAnyDeviceConnected = -1;
    tInteger valueIsDeviceAutoplay = -1;
    tInteger valueIsSameDeviceTypeLikeBefore = -1;
    tInteger valueIsPermanentStreamingActive = -1;
    tInteger valueIsLastModeListAvailable = -1;
    tInteger valueIsAnyDBContentAvailable = -1;
    tInteger valueIsCurrentIPodSelectionChanged = -1;
    tInteger valueIsHwMalfuncInLastConnection = -1;


    tInteger configTable[20][10] = {
            {0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0,0,0,0}
            };


    switch(usedConfigTable)
    {
        case CT_TEST: // Test config table
        {
            configTableRows = TestConfigTableRows(); //6
            configTableColumns = TestConfigTableColumns(); //5

            sscanf( TestConfigTableUsedCriteria().c_str(), "%u,%u,%u",
                    &configTableFunctionCriteria[0], &configTableFunctionCriteria[1], &configTableFunctionCriteria[2]);

            for(tUInt row=0; row < configTableRows; row++)
            {
                switch(row)
                {
                case 0:
                {
                    configTable[row][0] = TestConfigTablePrecondition_01();
                    sscanf( TestConfigTableCriteria_01().c_str(), "%d,%d,%d", &configTable[row][1], &configTable[row][2], &configTable[row][3]);
                    configTable[row][configTableColumns - 1] = TestConfigTableAction_01();
                    break;
                }
                case 1:
                {
                    configTable[row][0] = TestConfigTablePrecondition_02();
                    sscanf( TestConfigTableCriteria_02().c_str(), "%d,%d,%d", &configTable[row][1], &configTable[row][2], &configTable[row][3]);
                    configTable[row][configTableColumns - 1] = TestConfigTableAction_02();
                    break;
                }
                case 2:
                {
                    configTable[row][0] = TestConfigTablePrecondition_03();
                    sscanf( TestConfigTableCriteria_03().c_str(), "%d,%d,%d", &configTable[row][1], &configTable[row][2], &configTable[row][3]);
                    configTable[row][configTableColumns - 1] = TestConfigTableAction_03();
                    break;
                }
                case 3:
                {
                    configTable[row][0] = TestConfigTablePrecondition_04();
                    sscanf( TestConfigTableCriteria_04().c_str(), "%d,%d,%d", &configTable[row][1], &configTable[row][2], &configTable[row][3]);
                    configTable[row][configTableColumns - 1] = TestConfigTableAction_04();
                    break;
                }
                case 4:
                {
                    configTable[row][0] = TestConfigTablePrecondition_05();
                    sscanf( TestConfigTableCriteria_05().c_str(), "%d,%d,%d", &configTable[row][1], &configTable[row][2], &configTable[row][3]);
                    configTable[row][configTableColumns - 1] = TestConfigTableAction_05();
                    break;
                }
                case 5:
                {
                    configTable[row][0] = TestConfigTablePrecondition_06();
                    sscanf( TestConfigTableCriteria_06().c_str(), "%d,%d,%d", &configTable[row][1], &configTable[row][2], &configTable[row][3]);
                    configTable[row][configTableColumns - 1] = TestConfigTableAction_06();
                    break;
                }
                default:
                {
                    ETG_TRACE_FATAL(("[ERROR] DataProvider::ProcessConfigTable: Check mediaplayer configuration"));
                    break;
                }
                } //switch(row)
            }
            break;
        }
        case CT_DEVICE_ACTIVATION: // Device activation config table
        {
            configTableRows = DeviceActivationTableRows();
            configTableColumns = DeviceActivationTableColumns();

            /* Fill used function criteria from configuration */
            sscanf( DeviceActivationTableUsedCriteria().c_str(), "%u,%u,%u,%u,%u,%u,%u",
                    &configTableFunctionCriteria[0], &configTableFunctionCriteria[1], &configTableFunctionCriteria[2],
                    &configTableFunctionCriteria[3], &configTableFunctionCriteria[4], &configTableFunctionCriteria[5], &configTableFunctionCriteria[6]);

            /* Fill config table from configuration */
            for(tUInt row=0; row < configTableRows; row++)
            {
                switch(row)
                {
                case 0:
                {
                    configTable[row][0] = DeviceActivationTablePrecondition_01();
                    sscanf( DeviceActivationTableCriteria_01().c_str(), "%d,%d,%d,%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4], &configTable[row][5], &configTable[row][6],&configTable[row][7]);
                    configTable[row][configTableColumns - 1] = DeviceActivationTableAction_01();
                    break;
                }
                case 1:
                {
                    configTable[row][0] = DeviceActivationTablePrecondition_02();
                    sscanf( DeviceActivationTableCriteria_02().c_str(), "%d,%d,%d,%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4], &configTable[row][5], &configTable[row][6], &configTable[row][7]);
                    configTable[row][configTableColumns - 1] = DeviceActivationTableAction_02();
                    break;
                }
                case 2:
                {
                    configTable[row][0] = DeviceActivationTablePrecondition_03();
                    sscanf( DeviceActivationTableCriteria_03().c_str(), "%d,%d,%d,%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4], &configTable[row][5], &configTable[row][6], &configTable[row][7]);
                    configTable[row][configTableColumns - 1] = DeviceActivationTableAction_03();
                    break;
                }
                case 3:
                {
                    configTable[row][0] = DeviceActivationTablePrecondition_04();
                    sscanf( DeviceActivationTableCriteria_04().c_str(), "%d,%d,%d,%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4], &configTable[row][5], &configTable[row][6], &configTable[row][7]);
                    configTable[row][configTableColumns - 1] = DeviceActivationTableAction_04();
                    break;
                }
                case 4:
                {
                    configTable[row][0] = DeviceActivationTablePrecondition_05();
                    sscanf( DeviceActivationTableCriteria_05().c_str(), "%d,%d,%d,%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4], &configTable[row][5], &configTable[row][6], &configTable[row][7]);
                    configTable[row][configTableColumns - 1] = DeviceActivationTableAction_05();
                    break;
                }
                case 5:
                {
                    configTable[row][0] = DeviceActivationTablePrecondition_06();
                    sscanf( DeviceActivationTableCriteria_06().c_str(), "%d,%d,%d,%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4], &configTable[row][5], &configTable[row][6], &configTable[row][7]);
                    configTable[row][configTableColumns - 1] = DeviceActivationTableAction_06();
                    break;
                }
                case 6:
                {
                    configTable[row][0] = DeviceActivationTablePrecondition_07();
                    sscanf( DeviceActivationTableCriteria_07().c_str(), "%d,%d,%d,%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4], &configTable[row][5], &configTable[row][6], &configTable[row][7]);
                    configTable[row][configTableColumns - 1] = DeviceActivationTableAction_07();
                    break;
                }
                case 7:
                {
                    configTable[row][0] = DeviceActivationTablePrecondition_08();
                    sscanf( DeviceActivationTableCriteria_08().c_str(), "%d,%d,%d,%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4], &configTable[row][5], &configTable[row][6], &configTable[row][7]);
                    configTable[row][configTableColumns - 1] = DeviceActivationTableAction_08();
                    break;
                }
                case 8:
                {
                    configTable[row][0] = DeviceActivationTablePrecondition_09();
                    sscanf( DeviceActivationTableCriteria_09().c_str(), "%d,%d,%d,%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4], &configTable[row][5], &configTable[row][6], &configTable[row][7]);
                    configTable[row][configTableColumns - 1] = DeviceActivationTableAction_09();
                    break;
                }
                default:
                {
                    ETG_TRACE_FATAL(("[ERROR] DataProvider::ProcessConfigTable: Check mediaplayer configuration"));
                    break;
                }
                } //switch(row)
            }
            break;
        }
        case CT_LIST_SELECTION: // List selection config table
        {
            configTableRows = ListSelectionTableRows();
            configTableColumns = ListSelectionTableColumns();

            /* Fill used function criteria from configuration */
            sscanf( ListSelectionTableUsedCriteria().c_str(), "%u,%u,%u,%u",
                    &configTableFunctionCriteria[0], &configTableFunctionCriteria[1],
                    &configTableFunctionCriteria[2], &configTableFunctionCriteria[3]);

            /* Fill config table from configuration */
            for(tUInt row=0; row < configTableRows; row++)
            {
                switch(row)
                {
                case 0:
                {
                    configTable[row][0] = ListSelectionTablePrecondition_01();
                    sscanf( ListSelectionTableCriteria_01().c_str(), "%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4]);
                    configTable[row][configTableColumns - 1] = ListSelectionTableAction_01();
                    break;
                }
                case 1:
                {
                    configTable[row][0] = ListSelectionTablePrecondition_02();
                    sscanf( ListSelectionTableCriteria_02().c_str(), "%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4]);
                    configTable[row][configTableColumns - 1] = ListSelectionTableAction_02();
                    break;
                }
                case 2:
                {
                    configTable[row][0] = ListSelectionTablePrecondition_03();
                    sscanf( ListSelectionTableCriteria_03().c_str(), "%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4]);
                    configTable[row][configTableColumns - 1] = ListSelectionTableAction_03();
                    break;
                }
                case 3:
                {
                    configTable[row][0] = ListSelectionTablePrecondition_04();
                    sscanf( ListSelectionTableCriteria_04().c_str(), "%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4]);
                    configTable[row][configTableColumns - 1] = ListSelectionTableAction_04();
                    break;
                }
                case 4:
                {
                    configTable[row][0] = ListSelectionTablePrecondition_05();
                    sscanf( ListSelectionTableCriteria_05().c_str(), "%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4]);
                    configTable[row][configTableColumns - 1] = ListSelectionTableAction_05();
                    break;
                }
                case 5:
                {
                    configTable[row][0] = ListSelectionTablePrecondition_06();
                    sscanf( ListSelectionTableCriteria_06().c_str(), "%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4]);
                    configTable[row][configTableColumns - 1] = ListSelectionTableAction_06();
                    break;
                }
                case 6:
                {
                    configTable[row][0] = ListSelectionTablePrecondition_07();
                    sscanf( ListSelectionTableCriteria_07().c_str(), "%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4]);
                    configTable[row][configTableColumns - 1] = ListSelectionTableAction_07();
                    break;
                }
                case 7:
                {
                    configTable[row][0] = ListSelectionTablePrecondition_08();
                    sscanf( ListSelectionTableCriteria_08().c_str(), "%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4]);
                    configTable[row][configTableColumns - 1] = ListSelectionTableAction_08();
                    break;
                }
                case 8:
                {
                    configTable[row][0] = ListSelectionTablePrecondition_09();
                    sscanf( ListSelectionTableCriteria_09().c_str(), "%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4]);
                    configTable[row][configTableColumns - 1] = ListSelectionTableAction_09();
                    break;
                }
                case 9:
                {
                    configTable[row][0] = ListSelectionTablePrecondition_10();
                    sscanf( ListSelectionTableCriteria_10().c_str(), "%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4]);
                    configTable[row][configTableColumns - 1] = ListSelectionTableAction_10();
                    break;
                }
                case 10:
                {
                    configTable[row][0] = ListSelectionTablePrecondition_11();
                    sscanf( ListSelectionTableCriteria_11().c_str(), "%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4]);
                    configTable[row][configTableColumns - 1] = ListSelectionTableAction_11();
                    break;
                }
                case 11:
                {
                    configTable[row][0] = ListSelectionTablePrecondition_12();
                    sscanf( ListSelectionTableCriteria_12().c_str(), "%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4]);
                    configTable[row][configTableColumns - 1] = ListSelectionTableAction_12();
                    break;
                }
                case 12:
                {
                    configTable[row][0] = ListSelectionTablePrecondition_13();
                    sscanf( ListSelectionTableCriteria_13().c_str(), "%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4]);
                    configTable[row][configTableColumns - 1] = ListSelectionTableAction_13();
                    break;
                }
                case 13:
                {
                    configTable[row][0] = ListSelectionTablePrecondition_14();
                    sscanf( ListSelectionTableCriteria_14().c_str(), "%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4]);
                    configTable[row][configTableColumns - 1] = ListSelectionTableAction_14();
                    break;
                }
                case 14:
                {
                    configTable[row][0] = ListSelectionTablePrecondition_15();
                    sscanf( ListSelectionTableCriteria_15().c_str(), "%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4]);
                    configTable[row][configTableColumns - 1] = ListSelectionTableAction_15();
                    break;
                }
                case 15:
                {
                    configTable[row][0] = ListSelectionTablePrecondition_16();
                    sscanf( ListSelectionTableCriteria_16().c_str(), "%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4]);
                    configTable[row][configTableColumns - 1] = ListSelectionTableAction_16();
                    break;
                }
                case 16:
                {
                    configTable[row][0] = ListSelectionTablePrecondition_17();
                    sscanf( ListSelectionTableCriteria_17().c_str(), "%d,%d,%d,%d",
                            &configTable[row][1], &configTable[row][2], &configTable[row][3], &configTable[row][4]);
                    configTable[row][configTableColumns - 1] = ListSelectionTableAction_17();
                    break;
                }
                default:
                {
                    ETG_TRACE_FATAL(("[ERROR] DataProvider::ProcessConfigTable: Check mediaplayer configuration"));
                    break;
                }
                } //switch(row)
            }
            break;
        }
        default: // Unknown
            ETG_TRACE_FATAL(("[ERROR] DataProvider::ProcessConfigTable: Check mediaplayer configuration"));
            break;
    } //switch(usedConfigTable)

    action = CTA_NONE; //No action
    tBoolean found = FALSE;
    for(tUInt row=0; row < configTableRows; row++) //Zeile/Reihe ---
    {
        if(precondition == (tConfigTablePrecondition)configTable[row][0])
        {
            found = TRUE;

            // loop over the criteria to check
            for(tUInt criteria = 0; criteria < configTableColumns - 2; criteria++)
            {
                if(configTable[row][criteria + 1] != -1) // criteria is not ignore
                {
                    tInteger value = -1;
                    switch(configTableFunctionCriteria[criteria])
                    {
                    case CTC_TEST1: // Test criteria (use mTestValue1)
                        value = mTestValue1;
                        break;
                    case CTC_TEST2: // Test criteria (use mTestValue2)
                        value = mTestValue2;
                        break;
                    case CTC_TEST3: // Test criteria (use mTestValue3)
                        value = mTestValue3;
                        break;
                    case CTC_STARTUP: // Is startup phase?
                        if(-1 == valueIsStartupPhase) // Get value only once
                        {
                            valueIsStartupPhase = IsStartupPhase();
                        }
                        value = valueIsStartupPhase;
                        break;
                    case CTC_LAST_PLAYED_DEVICE: // Is last played device?
                        if(-1 == valueIsLastPlayedDevice) // Get value only once
                        {
                            valueIsLastPlayedDevice = IsLastPlayedDevice(IN deviceID);
                        }
                        value = valueIsLastPlayedDevice;
                        break;
                    case CTC_ANY_DEVICE_ACTIVE: // Is any device active?
                        if(-1 == valueIsAnyDeviceActive) // Get value only once
                        {
                            valueIsAnyDeviceActive = IsAnyDeviceActive();
                        }
                        value = valueIsAnyDeviceActive;
                        break;
                    case CTC_ANY_DEVICE_CONNECTED: // Is any device connected?
                        if(-1 == valueIsAnyDeviceConnected) // Get value only once
                        {
                            valueIsAnyDeviceConnected = IsAnyDeviceConnected(IN deviceID);
                        }
                        value = valueIsAnyDeviceConnected;
                        break;
                    case CTC_AUTOPLAY_DEVICE: // Is device auto sourcing?
                        if(-1 == valueIsDeviceAutoplay) // Get value only once
                        {
                            valueIsDeviceAutoplay = IsDeviceAutoplay(IN deviceID);
                        }
                        value = valueIsDeviceAutoplay;
                        break;
                    case CTC_SAME_DEVICE_TYPE_LIKE_BEFORE: // Is same device type like before?
                        if(-1 == valueIsSameDeviceTypeLikeBefore) // Get value only once
                        {
                            valueIsSameDeviceTypeLikeBefore = IsSameDeviceTypeLikeBefore(IN deviceID);
                        }
                        value = valueIsSameDeviceTypeLikeBefore;
                        break;
                    case CTC_STREAMING_ACTIVE: // Streaming mode active?
                        if(-1 == valueIsPermanentStreamingActive) // Get value only once
                        {
                            valueIsPermanentStreamingActive = IsPermanentStreamingActive(IN deviceID);
                        }
                        value = valueIsPermanentStreamingActive;
                        break;
                    case CTC_LAST_MODE_LIST_AVAILABLE: // Last mode list available?
                        if(-1 == valueIsLastModeListAvailable) // Get value only once
                        {
                            valueIsLastModeListAvailable = IsLastModeListAvailable(IN deviceID);
                        }
                        value = valueIsLastModeListAvailable;
                        break;
                    case CTC_ANY_DB_CONTENT_AVAILABLE: // Any DB content available?
                        if(-1 == valueIsAnyDBContentAvailable) // Get value only once
                        {
                            valueIsAnyDBContentAvailable = IsAnyDBContentAvailable(IN deviceID);
                        }
                        value = valueIsAnyDBContentAvailable;
                        break;
                    case CTC_IPOD_CURRENT_SELECTION_CHANGED: // Current selection on iPod is changed from MP?
                        if(-1 == valueIsCurrentIPodSelectionChanged) // Get value only once
                        {
                            valueIsCurrentIPodSelectionChanged = IsCurrentIPodSelectionChanged(IN deviceID);
                        }
                        value = valueIsCurrentIPodSelectionChanged;
                        break;
                    case CTC_HW_MALFUNC_IN_LAST_CONNECTION:
                        if(-1 == valueIsHwMalfuncInLastConnection) // Get value only once
                        {
                            valueIsHwMalfuncInLastConnection = IsHwMalfuncInLastConnection(IN deviceID);
                        }
                        value = valueIsHwMalfuncInLastConnection;
                        break;
                    case CTC_NONE: // No criteria
                    default:
                        break;
                    }

                    // check the got value against the table entry
                    if(value != configTable[row][criteria + 1])
                    {
                        found = FALSE;
                    }

                    if(FALSE == found)
                    {
                        break; // criteria not met -> continue with next row
                    }
                }
            } //for(tUInt criteria=0; ...
        }

        if(FALSE != found)
        {
            // row found: return action
            action = (tConfigTableAction)configTable[row][configTableColumns - 1]; // action column
            break;
        }
    } //for(tUInt row=0; ...

    ETG_TRACE_USR3(("DataProvider::ProcessConfigTable: usedConfigTable:%d, precondition:%d, deviceID:%d -> action:%d",
            usedConfigTable, precondition, deviceID, action));

    return MP_NO_ERROR;
}

tResult DataProvider::SetTestCriteria(const tInteger value1, const tInteger value2, const tInteger value3)
{
    ENTRY_INTERNAL

    mTestValue1 = value1;
    mTestValue2 = value2;
    mTestValue3 = value3;

    return MP_NO_ERROR;
}

tResult DataProvider::ResetTestCriteria()
{
    ENTRY_INTERNAL

    mTestValue1 = -1;
    mTestValue2 = -1;
    mTestValue3 = -1;

    return MP_NO_ERROR;
}

tBoolean DataProvider::IsStartupPhase()
{
    ENTRY_INTERNAL

    /* Get info if MP is in the startup phase (running startup timer) */
    tBoolean answer = LocalSPM::GetCustomControl().IsStartupPhase();

    ETG_TRACE_USR3(("DataProvider::IsStartupPhase? %d", answer));
    return answer;
}

tBoolean DataProvider::IsLastPlayedDevice(const tDeviceID deviceID)
{
    ENTRY_INTERNAL
    tResult res = MP_NO_ERROR;
    tBoolean answer = false;

    tDeviceID lastDeviceID = DEVICE_ID_NOT_SET;
    res = LocalSPM::GetDBManager().GetLastActiveDevice(OUT lastDeviceID);

    if((MP_NO_ERROR == res)
       &&
       (deviceID == lastDeviceID))
    {
        answer = true; //Device is last played device
    }

    ETG_TRACE_USR3(("DataProvider::IsLastPlayedDevice (deviceID: %d)? %d", deviceID, answer));
    return answer;
}

tBoolean DataProvider::IsAnyDeviceActive()
{
    ENTRY_INTERNAL
    tResult res = MP_NO_ERROR;
    tBoolean answer = false;

    tDeviceID activeDevice = DEVICE_ID_NOT_SET;
    res = LocalSPM::GetDBManager().GetActiveDevice(OUT activeDevice);

    if((MP_NO_ERROR == res)
       &&
       (DEVICE_ID_NOT_SET != activeDevice))
    {
        answer = true; //Found an active devices
    }

    ETG_TRACE_USR3(("DataProvider::IsAnyDeviceActive? %d", answer));
    return answer;
}

tBoolean DataProvider::IsAnyDeviceConnected(const tDeviceID deviceID)
{
    ENTRY_INTERNAL
    tResult res = MP_NO_ERROR;
    tBoolean answer = false;

    tDeviceCount devCount = 0;
    res = LocalSPM::GetDBManager().GetConnectedDeviceCount(OUT devCount);

    if ((MP_NO_ERROR == res)
        &&
        (0 < devCount))
    {
        /* Exclude new device */
        tDeviceInfo deviceInfo;
        res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);

        if ((MP_NO_ERROR == res)
            &&
            (deviceInfo.connectionState == CS_CONNECTED))
        {
            devCount--;
        }

        if (0 < devCount)
        {
            answer = true; //Found one or more devices connected
        }
    }

    ETG_TRACE_USR3(("DataProvider::IsAnyDeviceConnected? %d", answer));
    return answer;
}

tBoolean DataProvider::IsDeviceAutoplay(const tDeviceID deviceID)
{
    ENTRY_INTERNAL
    tResult res = MP_NO_ERROR;
    tBoolean answer = false;

    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    if (res) return false;

    /* Check if device is connected */
    if (deviceInfo.connectionState != CS_CONNECTED)
    {
        ETG_TRACE_USR1(("DataProvider::IsDeviceAutoplay: Device (deviceID: %d) not connected - do not autoplay this", deviceID));
        return false;
    }

    /* Check if device is NOT MY_MEDIA */
    if (deviceInfo.deviceID == MY_MEDIA)
    {
        ETG_TRACE_USR1(("Device is MyMedia - do not autoplay this"));
        return false;
    }

    /* Get autoplay list from DataProvider */
    vector<tDeviceType> autoplayDevices;
    res = GetAutoplayDeviceTypes(OUT autoplayDevices);
    if (res) return false;

    /* Look at the vector if device type is in */
    tUInt i;
    //ETG_TRACE_USR2(("checking: autoplayDevices.size()=%d", autoplayDevices.size()));
    for( i=0; i<autoplayDevices.size(); i++)
    {
        //ETG_TRACE_USR2(("checking: deviceType=%d", deviceInfo.deviceType));
        if (autoplayDevices[i] == deviceInfo.deviceType) break;
    }

    if(i < autoplayDevices.size())
    {
        answer = true;
    }

    ETG_TRACE_USR3(("DataProvider::IsDeviceAutoplay (deviceID: %d, deviceType: %d)? %d", deviceID, deviceInfo.deviceType, answer));
    return answer;
}

tBoolean DataProvider::IsSameDeviceTypeLikeBefore(const tDeviceID deviceID)
{
    ENTRY_INTERNAL
    tResult res = MP_NO_ERROR;
    tBoolean answer = false;

    tDeviceID lastDeviceID = DEVICE_ID_NOT_SET;
    res = LocalSPM::GetDBManager().GetLastActiveDevice(OUT lastDeviceID);
    if(res) return false;

    if (deviceID == lastDeviceID)
    {
        answer = true; //Same device
    }
    else
    {
        tDeviceInfo deviceInfo;
        res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
        if (res) return false;

        if(DTY_IPHONE == deviceInfo.deviceType)
        {
            deviceInfo.deviceType = DTY_IPOD;
        }

        tDeviceInfo lastDeviceInfo;
        res = LocalSPM::GetDBManager().GetDeviceInfo(OUT lastDeviceInfo, IN lastDeviceID);
        if (res) return false;

        if(DTY_IPHONE == lastDeviceInfo.deviceType)
        {
            lastDeviceInfo.deviceType = DTY_IPOD;
        }

        if (deviceInfo.deviceType == lastDeviceInfo.deviceType)
        {
            answer = true; //Same device type
        }
    }

    ETG_TRACE_USR3(("DataProvider::IsSameDeviceTypeLikeBefore (deviceID: %d, lastDeviceID: %d)? %d", deviceID, lastDeviceID, answer));
    return answer;
}

tBoolean DataProvider::IsPermanentStreamingActive(const tDeviceType deviceType)
{
    ENTRY_INTERNAL
    tResult res = MP_NO_ERROR;
    tBoolean answer = false;

    /* Get permanent streaming list from DataProvider */
    vector<tDeviceType> streamingDevices;
    res = GetPermanentStreamingDeviceTypes(OUT streamingDevices);
    if (res) return false;

    /* Look at the vector if device type is in */
    tUInt i = 0;
    for( i=0; i<streamingDevices.size(); i++)
    {
        if (streamingDevices[i] == deviceType) break;
    }

    if(i < streamingDevices.size())
    {
        answer = true;
    }

    ETG_TRACE_USR3(("DataProvider::IsPermanentStreamingActive (deviceType: %d)? %d", deviceType, answer));
    return answer;
}

tBoolean DataProvider::IsPermanentStreamingActive(const tDeviceID deviceID)
{
    ENTRY_INTERNAL
    tResult res = MP_NO_ERROR;

    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    if (res) return false;

    return IsPermanentStreamingActive(deviceInfo.deviceType);
}

tBoolean DataProvider::IsLastModeListAvailable(const tDeviceID deviceID)
{
    ENTRY_INTERNAL
    tResult res = MP_NO_ERROR;
    tBoolean answer = false;

    tListID dbLastModeListID = LIST_ID_NONE;
    tObjectID lastObjectID = OBJECT_ID_NONE;
    tPlaytime playtime = PLAYTIME_NONE;
    res = LocalSPM::GetDBManager().GetLastPlayed(OUT dbLastModeListID, OUT lastObjectID, OUT playtime, IN deviceID);
    if (res && res != MP_ERR_DB_END_OF_LIST) return false;

    if(LIST_ID_NONE != dbLastModeListID)
    {
        if(OBJECT_ID_NONE != lastObjectID)
        {
            answer = true;
        }

        /* Release last mode list because it is not needed anymore */
        res = LocalSPM::GetDBManager().ReleaseDBList(IN dbLastModeListID);
        //if (res) return false;
    }

    ETG_TRACE_USR3(("DataProvider::IsLastModeListAvailable (deviceID: %d)? %d", deviceID, answer));
    return answer;
}

tBoolean DataProvider::IsAnyDBContentAvailable(const tDeviceID deviceID)
{
    ENTRY_INTERNAL
    tResult res = MP_NO_ERROR;
    tBoolean answer = false;

    tNumberOfMediaObjects numberOfAudioObjectsInDB = 0;
    tNumberOfMediaObjects numberOfVideoObjectsInDB = 0;
    res = LocalSPM::GetDBManager().GetNumberOfPlayableObjectsInDB(OUT numberOfAudioObjectsInDB, OUT numberOfVideoObjectsInDB, IN deviceID);
    if (res) return false;

    if(0 < (numberOfAudioObjectsInDB + numberOfVideoObjectsInDB))
    {
        answer = true;
    }

    ETG_TRACE_USR3(("DataProvider::IsAnyDBContentAvailable (deviceID: %d)? %d", deviceID, answer));
    return answer;
}

tBoolean DataProvider::IsCurrentIPodSelectionChanged(const tDeviceID deviceID)
{
    ENTRY_INTERNAL
    tResult res = MP_NO_ERROR;
    tBoolean answer = false;

    res = LocalSPM::GetIPODControl().CurrentSelectionChanged(OUT answer, IN deviceID);
    if (res) return false;

    if(false == answer)
    {
        /* FOR IGN CYCLE: compare current selection with last played list from DB */
        /* and continue playback based on the last played indexed list if matching */
        /* the current playing song from iDevice */

        /* Get the last mode list */
        tListID dbLastModeListID = LIST_ID_NONE;
        tObjectID lastObjectID;
        tPlaytime playtimeDB = PLAYTIME_NONE;
        res = LocalSPM::GetDBManager().GetLastPlayed(OUT dbLastModeListID, OUT lastObjectID, OUT playtimeDB, IN deviceID);
        if (res) return false;

        /* Is a last played list available? */
        if (dbLastModeListID != LIST_ID_NONE)
        {
            /* Get current media object of last played list in the DB */
            tMediaObject mediaObjectDB;
            res = LocalSPM::GetDBManager().GetCurrentMediaObject(OUT mediaObjectDB, IN dbLastModeListID);
            if (res) return false;

            tListID iPodListID = LIST_ID_NONE;
            tStreaming streaming = FALSE;
            tFilterTag1 tag1;
            tFilterTag2 tag2;
            tFilterTag3 tag3;
            tFilterTag4 tag4;

            tag1.tag = IPOD_MARKER_BIT;
            tag2.tag = IPOD_MARKER_BIT;
            tag3.tag = IPOD_MARKER_BIT;
            tag4.tag = IPOD_MARKER_BIT;

            /* Create a play list for the iPod */
            res = LocalSPM::GetListControl().CreatePlayList(OUT iPodListID, LTY_CURRENT_SELECTION,
                    IN streaming, IN tag1, IN tag2, IN tag3, IN tag4, PC_NO_REPEAT, IN deviceID);
            if (res) return false;

            /* Position the iPod current selection and get that media object */
            tMediaObject mediaObject;
            res = LocalSPM::GetListControl().SetMediaObject(OUT mediaObject, IN iPodListID, IN INDEX_LAST_ACTIVE_OBJECT);
            if (res) return false;

            tPlaytime playtime = PLAYTIME_NONE;
            res = LocalSPM::GetIPODControl().GetCurrentPlaytime(OUT playtime, IN deviceID);
            if (res) return false;

            /* Let the iPodControl compare these object to identify if they are identical */
            res = LocalSPM::GetIPODControl().CompareMediaObjects(OUT answer, IN mediaObject, IN playtime, IN mediaObjectDB, IN playtimeDB);
            if (res) return false;

            /* Release last mode list because it is not needed anymore */
            res = LocalSPM::GetDBManager().ReleaseDBList(IN dbLastModeListID);
            //if (res) return false;

            /* Release play list because it is not needed anymore */
            res = LocalSPM::GetListControl().ReleaseList(IN iPodListID);
            //if (res) return false;
        }
    }

    ETG_TRACE_USR3(("DataProvider::IsCurrentIPodSelectionChanged (deviceID: %d)? %d", deviceID, answer));
    return answer;
}

tBoolean DataProvider::IsHwMalfuncInLastConnection(const tDeviceID deviceID)
{
    ENTRY_INTERNAL
    tResult res = MP_NO_ERROR;
    tBoolean answer = false;


    tDeviceInfo deviceInfo;
    res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    if (res) answer = false;

    if(deviceInfo.formerConnectionState == CS_CONNECTED)
    {
        answer = true;
    }

    ETG_TRACE_USR3(("DataProvider::IsHwMalfuncInLastConnection (deviceID: %d)? %d", deviceID, answer));
    return answer;
}

tResult DataProvider::GetApplicationTable(vector<tApplTableEntry> &appTable, const tDeviceType deviceType) //Roadmap 13008
{
    ENTRY
    appTable.clear();
    tApplTableEntry entry;

    for(int i=0; i<ApplicationNumbers(); i++)
    {
        switch(i) {
        case 0:
            if ((tDeviceType)ApplicationDeviceTypeNumber_01() == deviceType)
            {
                strncpy_r(OUT entry.appName, IN ApplicationNameNumber_01().c_str(), IN sizeof(entry.appName));
                entry.source = ApplicationSourceNumber_01();
                appTable.push_back(entry);
            }
            break;
        case 1:
            if ((tDeviceType)ApplicationDeviceTypeNumber_02() == deviceType)
            {
                strncpy_r(OUT entry.appName, IN ApplicationNameNumber_02().c_str(), IN sizeof(entry.appName));
                entry.source = ApplicationSourceNumber_02();
                appTable.push_back(entry);
            }
            break;
        case 2:
            if ((tDeviceType)ApplicationDeviceTypeNumber_03() == deviceType)
            {
                strncpy_r(OUT entry.appName, IN ApplicationNameNumber_03().c_str(), IN sizeof(entry.appName));
                entry.source = ApplicationSourceNumber_03();
                appTable.push_back(entry);
            }
            break;
        case 3:
            if ((tDeviceType)ApplicationDeviceTypeNumber_04() == deviceType)
            {
                strncpy_r(OUT entry.appName, IN ApplicationNameNumber_04().c_str(), IN sizeof(entry.appName));
                entry.source = ApplicationSourceNumber_04();
                appTable.push_back(entry);
            }
            break;
        case 4:
            if ((tDeviceType)ApplicationDeviceTypeNumber_05() == deviceType)
            {
                strncpy_r(OUT entry.appName, IN ApplicationNameNumber_05().c_str(), IN sizeof(entry.appName));
                entry.source = ApplicationSourceNumber_05();
                appTable.push_back(entry);
            }
            break;
        case 5:
            if ((tDeviceType)ApplicationDeviceTypeNumber_06() == deviceType)
            {
                strncpy_r(OUT entry.appName, IN ApplicationNameNumber_06().c_str(), IN sizeof(entry.appName));
                entry.source = ApplicationSourceNumber_06();
                appTable.push_back(entry);
            }
            break;
        case 6:
            if ((tDeviceType)ApplicationDeviceTypeNumber_07() == deviceType)
            {
                strncpy_r(OUT entry.appName, IN ApplicationNameNumber_07().c_str(), IN sizeof(entry.appName));
                entry.source = ApplicationSourceNumber_07();
                appTable.push_back(entry);
            }
            break;
        case 7:
            if ((tDeviceType)ApplicationDeviceTypeNumber_08() == deviceType)
            {
                strncpy_r(OUT entry.appName, IN ApplicationNameNumber_08().c_str(), IN sizeof(entry.appName));
                entry.source = ApplicationSourceNumber_08();
                appTable.push_back(entry);
            }
            break;
        default:
            ETG_TRACE_FATAL(("[ERROR] DataProvider::GetApplicationTable: Check mediaplayer configuration"));
            break;
        }
    }

    return MP_NO_ERROR;
}

tResult DataProvider::VerifyGenreName(tUInt genreID ,tMetadata &genre) //Roadmap 13014
{
    switch(genreID)
    {
        case 148:   strncpy_r(OUT genre, IN Genre_148().c_str(), IN sizeof(tMetadata));            break;
        case 149:   strncpy_r(OUT genre, IN Genre_149().c_str(), IN sizeof(tMetadata));            break;
        case 150:   strncpy_r(OUT genre, IN Genre_150().c_str(), IN sizeof(tMetadata));            break;
        case 151:   strncpy_r(OUT genre, IN Genre_151().c_str(), IN sizeof(tMetadata));            break;
        case 152:   strncpy_r(OUT genre, IN Genre_152().c_str(), IN sizeof(tMetadata));            break;
        case 153:   strncpy_r(OUT genre, IN Genre_153().c_str(), IN sizeof(tMetadata));            break;
        case 154:   strncpy_r(OUT genre, IN Genre_154().c_str(), IN sizeof(tMetadata));            break;
        case 155:   strncpy_r(OUT genre, IN Genre_155().c_str(), IN sizeof(tMetadata));            break;
        case 156:   strncpy_r(OUT genre, IN Genre_156().c_str(), IN sizeof(tMetadata));            break;
        case 157:   strncpy_r(OUT genre, IN Genre_157().c_str(), IN sizeof(tMetadata));            break;
        case 158:   strncpy_r(OUT genre, IN Genre_158().c_str(), IN sizeof(tMetadata));            break;
        case 159:   strncpy_r(OUT genre, IN Genre_159().c_str(), IN sizeof(tMetadata));            break;
        case 160:   strncpy_r(OUT genre, IN Genre_160().c_str(), IN sizeof(tMetadata));            break;
        case 161:   strncpy_r(OUT genre, IN Genre_161().c_str(), IN sizeof(tMetadata));            break;
        case 162:   strncpy_r(OUT genre, IN Genre_162().c_str(), IN sizeof(tMetadata));            break;
        case 163:   strncpy_r(OUT genre, IN Genre_163().c_str(), IN sizeof(tMetadata));            break;
        case 164:   strncpy_r(OUT genre, IN Genre_164().c_str(), IN sizeof(tMetadata));            break;
        case 165:   strncpy_r(OUT genre, IN Genre_165().c_str(), IN sizeof(tMetadata));            break;
        case 166:   strncpy_r(OUT genre, IN Genre_166().c_str(), IN sizeof(tMetadata));            break;
        case 167:   strncpy_r(OUT genre, IN Genre_167().c_str(), IN sizeof(tMetadata));            break;
        case 168:   strncpy_r(OUT genre, IN Genre_168().c_str(), IN sizeof(tMetadata));            break;
        case 169:   strncpy_r(OUT genre, IN Genre_169().c_str(), IN sizeof(tMetadata));            break;
        case 170:   strncpy_r(OUT genre, IN Genre_170().c_str(), IN sizeof(tMetadata));            break;
        case 171:   strncpy_r(OUT genre, IN Genre_171().c_str(), IN sizeof(tMetadata));            break;
        case 172:   strncpy_r(OUT genre, IN Genre_172().c_str(), IN sizeof(tMetadata));            break;
        case 173:   strncpy_r(OUT genre, IN Genre_173().c_str(), IN sizeof(tMetadata));            break;
        case 174:   strncpy_r(OUT genre, IN Genre_174().c_str(), IN sizeof(tMetadata));            break;
        case 175:   strncpy_r(OUT genre, IN Genre_175().c_str(), IN sizeof(tMetadata));            break;
        case 176:   strncpy_r(OUT genre, IN Genre_176().c_str(), IN sizeof(tMetadata));            break;
        case 177:   strncpy_r(OUT genre, IN Genre_177().c_str(), IN sizeof(tMetadata));            break;
        case 178:   strncpy_r(OUT genre, IN Genre_178().c_str(), IN sizeof(tMetadata));            break;
        case 179:   strncpy_r(OUT genre, IN Genre_179().c_str(), IN sizeof(tMetadata));            break;
        case 180:   strncpy_r(OUT genre, IN Genre_180().c_str(), IN sizeof(tMetadata));            break;
        case 181:   strncpy_r(OUT genre, IN Genre_181().c_str(), IN sizeof(tMetadata));            break;
        case 182:   strncpy_r(OUT genre, IN Genre_182().c_str(), IN sizeof(tMetadata));            break;
        case 183:   strncpy_r(OUT genre, IN Genre_183().c_str(), IN sizeof(tMetadata));            break;
        case 184:   strncpy_r(OUT genre, IN Genre_184().c_str(), IN sizeof(tMetadata));            break;
        case 185:   strncpy_r(OUT genre, IN Genre_185().c_str(), IN sizeof(tMetadata));            break;
        case 186:   strncpy_r(OUT genre, IN Genre_186().c_str(), IN sizeof(tMetadata));            break;
        case 187:   strncpy_r(OUT genre, IN Genre_187().c_str(), IN sizeof(tMetadata));            break;
        case 188:   strncpy_r(OUT genre, IN Genre_188().c_str(), IN sizeof(tMetadata));            break;
        case 189:   strncpy_r(OUT genre, IN Genre_189().c_str(), IN sizeof(tMetadata));            break;
        case 190:   strncpy_r(OUT genre, IN Genre_190().c_str(), IN sizeof(tMetadata));            break;
        case 191:   strncpy_r(OUT genre, IN Genre_191().c_str(), IN sizeof(tMetadata));            break;

        default :
            break;
    }
    return MP_NO_ERROR;
}

void DataProvider::Convert2UTF8(FastUTF8::tString str, const size_t size)
{
    ENTRY_INTERNAL;

    /* sanities */
    if (!str) return;
    if (*str == 0) return;

    /* set the target char set */
    const gchar *fromCodeset = (const gchar *)"ISO-8859-1"; // default

    if (GBKSupported()) {
        fromCodeset = (const gchar *)"GBK";
    } else if (EUC_KRSupported()) {
        fromCodeset = (const gchar *)"EUC-KR";
    }

    // ETG_TRACE_USR2(("check: %s", str));

    /* check if str is non utf-8 */
    if (g_utf8_validate((gchar *)str , -1, NULL) != true) {

        ETG_TRACE_USR2(("convert from: %s", fromCodeset));

        gchar *newUTF8String;

        /* convert it as language adjusted and store it as UTF-8 */
        newUTF8String = g_convert((gchar *)str, -1, "UTF-8", fromCodeset, NULL, NULL, NULL);
        if (newUTF8String) {
            ETG_TRACE_USR2(("conversion success: from: %s", str));
            ETG_TRACE_USR2(("conversion success: to  : %s", newUTF8String));
            strncpy_r(OUT (char *)str, IN newUTF8String, IN size);
            g_free(newUTF8String);
        } else {
            ETG_TRACE_ERR(("conversion failed"));
        }
    }
}

void DataProvider::CutMetadata(FastUTF8::tString str, const size_t size)
{
    (void) size;

    /* sanities */
    if (!str) return;
    if (*str == 0) return;

    /* cut the string */
    int maxLen = MaxMetadataStringLen();
    FastUTF8::tString c;
    FastUTF8::tString lastC = (FastUTF8::tString)str;
    int count = 0; // lint !e578
    for(c = (FastUTF8::tString)str; *c; c = FastUTF8::Next(c)) {
        count++;
        if (count > maxLen || !FastUTF8::isValid(c)) {
            *lastC = 0; // cut at the last char position
            break;
        }
        lastC = c;
    }
}

tBoolean DataProvider::IsDeviceTypeSupported(const tDeviceType deviceType)
{
    ENTRY_INTERNAL;
    tBoolean answer = false;

    for(int i=1; i<=SupportedDeviceTypes(); i++)
    {
        switch(i) {
        case 1:
            if(SupportedDeviceType_01() == deviceType) {answer = true;}
            break;
        case 2:
            if(SupportedDeviceType_02() == deviceType) {answer = true;}
            break;
        case 3:
            if(SupportedDeviceType_03() == deviceType) {answer = true;}
            break;
        case 4:
            if(SupportedDeviceType_04() == deviceType) {answer = true;}
            break;
        case 5:
            if(SupportedDeviceType_05() == deviceType) {answer = true;}
            break;
        case 6:
            if(SupportedDeviceType_06() == deviceType) {answer = true;}
            break;
        case 7:
            if(SupportedDeviceType_07() == deviceType) {answer = true;}
            break;
        case 8:
            if(SupportedDeviceType_08() == deviceType) {answer = true;}
            break;
        case 9:
            if(SupportedDeviceType_09() == deviceType) {answer = true;}
            break;
        case 10:
            if(SupportedDeviceType_10() == deviceType) {answer = true;}
        break;

        default:
            ETG_TRACE_FATAL(("[ERROR] DataProvider::IsDeviceTypeSupported: Check mediaplayer configuration"));
            break;
        }
     }

    ETG_TRACE_USR4(("DataProvider::IsDeviceTypeSupported: answer: 0x%x (false:0x%x,true:0x%x)", answer, false, true));
    return answer;
}

tResult DataProvider::IsFileSystemSupported(const tFileSystemType fileSystemType)
{
    ENTRY_INTERNAL;
    tBoolean answer = false;

    for(int i=1; i<=SupportedFileSystems(); i++)
    {
        switch(i) {
        case 1:
            if(SupportedFileSystem_01() == fileSystemType) {answer = true;}
            break;
        case 2:
            if(SupportedFileSystem_02() == fileSystemType) {answer = true;}
            break;
        case 3:
            if(SupportedFileSystem_03() == fileSystemType) {answer = true;}
            break;
        case 4:
            if(SupportedFileSystem_04() == fileSystemType) {answer = true;}
            break;
        case 5:
            if(SupportedFileSystem_05() == fileSystemType) {answer = true;}
            break;
        case 6:
            if(SupportedFileSystem_06() == fileSystemType) {answer = true;}
            break;
        case 7:
            if(SupportedFileSystem_07() == fileSystemType) {answer = true;}
            break;
        case 8:
            if(SupportedFileSystem_08() == fileSystemType) {answer = true;}
            break;
        default:
            ETG_TRACE_FATAL(("[ERROR] DataProvider::IsFileSystemSupported: Check mediaplayer configuration"));
            break;
        }
    }

    ETG_TRACE_USR4(("DataProvider::IsFileSystemSupported: answer: 0x%x (false:0x%x,true:0x%x)", answer, false, true));
    return answer;
}


tResult DataProvider::IsPartitionSupported(const tPartitionNumber partitionNumber)
{
    ENTRY_INTERNAL;
    tBoolean answer = false;

    tPartitionNumber partitionsSupported = SupportedPartionNumbers();

    if(partitionsSupported == PARTITION_NUMBER_NONE)
    {
        answer = false;
    }
    else if( partitionNumber <= partitionsSupported)
    {
        answer = true;
    }
    else
    {
        answer = false;
    }

    ETG_TRACE_USR4(("DataProvider::IsPartitionSupported: answer: 0x%x (false:0x%x,true:0x%x)", answer, false, true));
    return answer;
}

tResult DataProvider::GetDefaultPEState(me::state_t &peState)
{
    ENTRY

    //InitPEState(OUT peState);
     peState = me::state_t();

    /* Set default parameter of PEState */
#ifndef TARGET_BUILD
    //strncpy_r(OUT state.proc, IN "/home/pht2hi/bosch/pht2hi_GMG3G_LINUX_14.0A014.vws_GEN/ai_projects/generated/bin/linuxx86make/debug/pengineserver_out.out", IN sizeof(state.proc));
    const char* path;
    path = getenv("_SWBUILDROOT");
    peState.proc() = path;
    peState.proc() << "/generated/bin/linuxx86make/debug/mengineserver_out.out";
#else
    peState.proc() = "/opt/bosch/gm/processes/mengineserver_out.out";
    //peState.proc() = "./pengineserver_out.out";
#endif
    //peState.server() = "~mengine";

   //peState.ramp().num() = PEConfigRampIntermediateSteps();

   peState.ramp().steps()[ 0].lvl() = (tPEPercentage)PEConfigRampStepPercentage_01();
   peState.ramp().steps()[ 1].lvl() = (tPEPercentage)PEConfigRampStepPercentage_02();
   peState.ramp().steps()[ 2].lvl() = (tPEPercentage)PEConfigRampStepPercentage_03();
   peState.ramp().steps()[ 3].lvl() = (tPEPercentage)PEConfigRampStepPercentage_04();
   peState.ramp().steps()[ 4].lvl() = (tPEPercentage)PEConfigRampStepPercentage_05();
   peState.ramp().steps()[ 5].lvl() = (tPEPercentage)PEConfigRampStepPercentage_06();
   peState.ramp().steps()[ 6].lvl() = (tPEPercentage)PEConfigRampStepPercentage_07();
   peState.ramp().steps()[ 7].lvl() = (tPEPercentage)PEConfigRampStepPercentage_08();
   peState.ramp().steps()[ 8].lvl() = (tPEPercentage)PEConfigRampStepPercentage_09();
   peState.ramp().steps()[ 9].lvl() = (tPEPercentage)PEConfigRampStepPercentage_10();
   peState.ramp().steps()[10].lvl() = (tPEPercentage)PEConfigRampStepPercentage_11();
   peState.ramp().steps()[11].lvl() = (tPEPercentage)PEConfigRampStepPercentage_12();
   peState.ramp().steps()[12].lvl() = (tPEPercentage)PEConfigRampStepPercentage_13();
   peState.ramp().steps()[13].lvl() = (tPEPercentage)PEConfigRampStepPercentage_14();
   peState.ramp().steps()[14].lvl() = (tPEPercentage)PEConfigRampStepPercentage_15();
   peState.ramp().steps()[15].lvl() = (tPEPercentage)PEConfigRampStepPercentage_16();

   peState.ramp().steps()[ 0].dur().ms() = (tPEMilliseconds)PEConfigRampStepDuration_01();
   peState.ramp().steps()[ 1].dur().ms() = (tPEMilliseconds)PEConfigRampStepDuration_02();
   peState.ramp().steps()[ 2].dur().ms() = (tPEMilliseconds)PEConfigRampStepDuration_03();
   peState.ramp().steps()[ 3].dur().ms() = (tPEMilliseconds)PEConfigRampStepDuration_04();
   peState.ramp().steps()[ 4].dur().ms() = (tPEMilliseconds)PEConfigRampStepDuration_05();
   peState.ramp().steps()[ 5].dur().ms() = (tPEMilliseconds)PEConfigRampStepDuration_06();
   peState.ramp().steps()[ 6].dur().ms() = (tPEMilliseconds)PEConfigRampStepDuration_07();
   peState.ramp().steps()[ 7].dur().ms() = (tPEMilliseconds)PEConfigRampStepDuration_08();
   peState.ramp().steps()[ 8].dur().ms() = (tPEMilliseconds)PEConfigRampStepDuration_09();
   peState.ramp().steps()[ 9].dur().ms() = (tPEMilliseconds)PEConfigRampStepDuration_10();
   peState.ramp().steps()[10].dur().ms() = (tPEMilliseconds)PEConfigRampStepDuration_11();
   peState.ramp().steps()[11].dur().ms() = (tPEMilliseconds)PEConfigRampStepDuration_12();
   peState.ramp().steps()[12].dur().ms() = (tPEMilliseconds)PEConfigRampStepDuration_13();
   peState.ramp().steps()[13].dur().ms() = (tPEMilliseconds)PEConfigRampStepDuration_14();
   peState.ramp().steps()[14].dur().ms() = (tPEMilliseconds)PEConfigRampStepDuration_15();
   peState.ramp().steps()[15].dur().ms() = (tPEMilliseconds)PEConfigRampStepDuration_16();

   // display configuration;
   peState.display().num() = PEConfigDisplays();

   peState.display().screens()[0].rsl().width()  = (int_t)PEConfigDisplayWidth_01();
   peState.display().screens()[0].rsl().height() = (int_t)PEConfigDisplayHeight_01();
   peState.display().screens()[0].layer()        = (int_t)PEConfigDisplayLayer_01();
   peState.display().screens()[0].srf()          = (int_t)PEConfigDisplaySurface_01();

   peState.display().screens()[1].rsl().width()  = (int_t)PEConfigDisplayWidth_02();
   peState.display().screens()[1].rsl().height() = (int_t)PEConfigDisplayHeight_02();
   peState.display().screens()[1].layer()        = (int_t)PEConfigDisplayLayer_02();
   peState.display().screens()[1].srf()          = (int_t)PEConfigDisplaySurface_02();

   peState.display().screens()[2].rsl().width()  = (int_t)PEConfigDisplayWidth_03();
   peState.display().screens()[2].rsl().height() = (int_t)PEConfigDisplayHeight_03();
   peState.display().screens()[2].layer()        = (int_t)PEConfigDisplayLayer_03();
   peState.display().screens()[2].srf()          = (int_t)PEConfigDisplaySurface_03();

   peState.display().screens()[3].rsl().width()  = (int_t)PEConfigDisplayWidth_04();
   peState.display().screens()[3].rsl().height() = (int_t)PEConfigDisplayHeight_04();
   peState.display().screens()[3].layer()        = (int_t)PEConfigDisplayLayer_04();
   peState.display().screens()[3].srf()          = (int_t)PEConfigDisplaySurface_04();

   peState.display().screens()[4].rsl().width()  = (int_t)PEConfigDisplayWidth_05();
   peState.display().screens()[4].rsl().height() = (int_t)PEConfigDisplayHeight_05();
   peState.display().screens()[4].layer()        = (int_t)PEConfigDisplayLayer_05();
   peState.display().screens()[4].srf()          = (int_t)PEConfigDisplaySurface_05();

   peState.display().screens()[5].rsl().width()  = (int_t)PEConfigDisplayWidth_06();
   peState.display().screens()[5].rsl().height() = (int_t)PEConfigDisplayHeight_06();
   peState.display().screens()[5].layer()        = (int_t)PEConfigDisplayLayer_06();
   peState.display().screens()[5].srf()          = (int_t)PEConfigDisplaySurface_06();

   peState.display().screens()[6].rsl().width()  = (int_t)PEConfigDisplayWidth_07();
   peState.display().screens()[6].rsl().height() = (int_t)PEConfigDisplayHeight_07();
   peState.display().screens()[6].layer()        = (int_t)PEConfigDisplayLayer_07();
   peState.display().screens()[6].srf()          = (int_t)PEConfigDisplaySurface_07();

   peState.display().screens()[7].rsl().width()  = (int_t)PEConfigDisplayWidth_08();
   peState.display().screens()[7].rsl().height() = (int_t)PEConfigDisplayHeight_08();
   peState.display().screens()[7].layer()        = (int_t)PEConfigDisplayLayer_08();
   peState.display().screens()[7].srf()          = (int_t)PEConfigDisplaySurface_08();

    // usage of RootDaemon;
    peState.local() = RootDaemonDirectCallGMPCommands();

    return MP_NO_ERROR;
}

tResult DataProvider::GetInternalDevices(vector<tDeviceInfo> &deviceInfos)
{
    ENTRY
    deviceInfos.clear();
    tUInt noOfInternalDevices = InternalDevices();
    tDeviceInfo deviceInfo;

    for(tUInt i=0; i<noOfInternalDevices; i++)
    {
        InitDeviceInfo(INOUT deviceInfo);

        deviceInfo.activeSource = 0;
        deviceInfo.connected = 1;
        deviceInfo.deviceType = DTY_FLASH;
        deviceInfo.connectionState = CS_CONNECTED;
        strncpy_r(OUT deviceInfo.deviceVersion, IN "1.0", IN sizeof(deviceInfo.deviceVersion));
        strncpy_r(OUT deviceInfo.UUID, IN "1", IN sizeof(deviceInfo.UUID));
        //strncpy_r(OUT deviceInfo.accessoryName, IN "/dev/mmcblk0", IN sizeof(deviceInfo.accessoryName));

        deviceInfo.fileSystemType = FSTY_EXT4;
        deviceInfo.partitionNumber = 1;
        //deviceInfo.totalSize = 33554432; //32GB
        //deviceInfo.freeSize = 20971520; //20GB
        //deviceInfo.productID = 0;
        deviceInfo.connectionType = DCT_FLASH;

        switch(i)
        {
        case 0:
            strncpy_r(OUT deviceInfo.serialNumber, IN "InternalFlash_0001", IN sizeof(deviceInfo.serialNumber));
#ifndef TARGET_BUILD
            strncpy_r(OUT deviceInfo.mountPoint, IN get_current_dir_name(), IN sizeof(deviceInfo.mountPoint));
            strncat_r(OUT deviceInfo.mountPoint, IN "/Customer/Simulation/CustomControl/emmc", IN sizeof(deviceInfo.mountPoint));
#else
            strncpy_r(OUT deviceInfo.mountPoint, IN InternalDeviceMountPoint_1().c_str(), IN sizeof(deviceInfo.mountPoint));
#endif
            strncpy_r(OUT deviceInfo.deviceName, IN InternalDeviceName_1().c_str(), IN sizeof(deviceInfo.deviceName));
            break;
        case 1:
            strncpy_r(OUT deviceInfo.serialNumber, IN "InternalFlash_0002", IN sizeof(deviceInfo.serialNumber));
#ifndef TARGET_BUILD
            strncpy_r(OUT deviceInfo.mountPoint, IN get_current_dir_name(), IN sizeof(deviceInfo.mountPoint));
            strncat_r(OUT deviceInfo.mountPoint, IN "/Customer/Simulation/CustomControl/stick_2", IN sizeof(deviceInfo.mountPoint));
#else
            strncpy_r(OUT deviceInfo.mountPoint, IN InternalDeviceMountPoint_2().c_str(), IN sizeof(deviceInfo.mountPoint));
#endif
            strncpy_r(OUT deviceInfo.deviceName, IN InternalDeviceName_2().c_str(), IN sizeof(deviceInfo.deviceName));
            break;
        default:
            ETG_TRACE_FATAL(("[ERROR] DataProvider::GetInternalDevices: Check mediaplayer configuration"));
            break;
        }

        deviceInfos.push_back(deviceInfo);
    }

    return MP_NO_ERROR;
}

#define DATAPROVIDER_DEVICEINFO_MARSHAL_FORMAT tDeviceID_format \
                                                tDeviceSerialNumber_format \
                                                tDeviceVersion_format \
                                                tDeviceName_format \
                                                tMountPoint_format \
                                                tConnectionCount_format \
                                                tDeviceType_format \
                                                tConnectionType_format \
                                                tConnectionState_format \
                                                tAccessoryName_format \
                                                tDeviceState_format \
                                                tNumberOfFiles_format \
                                                tNumberOfFiles_format \
                                                tProductID_format \
                                                tDiPOCaps_format \
                                                tDiPOActive_format \
                                                tDeviceConnected_format


tResult DataProvider::MarshalDeviceInfo(tDeviceInfoString &deviceInfoString, const tDeviceInfo deviceInfo)
{
    ENTRY_INTERNAL;
    deviceInfoString[0] = 0;

    SMF::Marshal(deviceInfoString, sizeof(deviceInfoString) - 1,
            DOUBLE_MARSHAL_SEPARATOR,
            DATAPROVIDER_DEVICEINFO_MARSHAL_FORMAT,

            deviceInfo.deviceID,
            //tUUID UUID;
            deviceInfo.serialNumber,
            deviceInfo.deviceVersion,
            deviceInfo.deviceName,
            deviceInfo.mountPoint,
            deviceInfo.connectionCount,
            //tDeviceActiveSource activeSource,
            deviceInfo.deviceType,
            deviceInfo.connectionType,
            //tIndexingState indexedState,
            deviceInfo.connectionState,
            deviceInfo.accessoryName,
            deviceInfo.deviceState,
            //tFileSystemType fileSystemType,
            //tPartitionNumber partitionNumber,
            //tMemorySize totalSize,
            //tMemorySize freeSize,
            deviceInfo.numberOfAudioFiles,
            deviceInfo.numberOfVideoFiles,
            deviceInfo.productID,
            deviceInfo.diPOCaps,
            deviceInfo.diPOActive,
            //tDiPOVersion diPOVersion,
            //tPath lastPlayedFile,
            deviceInfo.connected);

    return MP_NO_ERROR;
}

tResult DataProvider::UnMarshalDeviceInfo(const tDeviceInfoString deviceInfoString, tDeviceInfo &deviceInfo)
{
    ENTRY_INTERNAL;
    InitDeviceInfo(deviceInfo);

    SMF::UnMarshal(deviceInfoString,
            DOUBLE_MARSHAL_SEPARATOR,
            DATAPROVIDER_DEVICEINFO_MARSHAL_FORMAT,

            &deviceInfo.deviceID,
            //tUUID UUID;
            deviceInfo.serialNumber,
            deviceInfo.deviceVersion,       /**< FirmwareVersion */
            deviceInfo.deviceName,             /**< FriendlyName */
            deviceInfo.mountPoint,
            &deviceInfo.connectionCount,
            //tDeviceActiveSource activeSource,
            &deviceInfo.deviceType,
            &deviceInfo.connectionType,
            //tIndexingState indexedState,
            &deviceInfo.connectionState,
            deviceInfo.accessoryName,       /**< Additional name information e.g. alsa device name (AudioInputDevice) */
            &deviceInfo.deviceState,           //Roadmap 13023
            //tFileSystemType fileSystemType,     //Roadmap 13023
            //tPartitionNumber partitionNumber,   //Roadmap 13023
            //tMemorySize totalSize,              //Roadmap 13001
            //tMemorySize freeSize,               //Roadmap 13001
            &deviceInfo.numberOfAudioFiles,       //Roadmap 13002
            &deviceInfo.numberOfVideoFiles,
            &deviceInfo.productID,               //Roadmap 13006
            &deviceInfo.diPOCaps,            //Roadmap 13034
            &deviceInfo.diPOActive,             //Roadmap 13034
            //tDiPOVersion diPOVersion,           //Roadmap 13034
            //tPath lastPlayedFile,               //Roadmap 14005
            &deviceInfo.connected);

    return MP_NO_ERROR;
}

int DataProvider::Statistics(OUT tStatistics stat)
{
    stat[0]=0;

    /* create some statistic information */
    snprintf(stat, sizeof(tStatistics), "AlbumArtCacheElem=%d/%d",
            mAlbumArtCache.GetCacheCount(), mAlbumArtCache.mNoOfCachelines);

    return 0;
}

int DataProvider::GetAvailableCurrentForDevice(const tPath hubVendorID, const tPath hubProductID, const int portNumber)
{
    ENTRY;
    VARTRACE(hubVendorID);
    VARTRACE(hubProductID);
    VARTRACE(portNumber);

    int current_mA = AvailableCurrentDefault(); //default 1A

    if(PowerHubEnabled()) {
        VARTRACE(hubVendorID);
        VARTRACE(hubProductID);
        VARTRACE(portNumber);
        if(strcmp(hubVendorID, PowerHubVendorID().c_str()) == 0) {
            if(strcmp(hubProductID, PowerHubProductID_A().c_str()) == 0) {
                if(portNumber == PowerHubProductID_A_Port_A() ||
                   portNumber == PowerHubProductID_A_Port_B() ) {
                    current_mA = AvailableCurrentPowerHub();
                }
            } else if(strcmp(hubProductID, PowerHubProductID_B().c_str()) == 0) {
                if(portNumber == PowerHubProductID_B_Port_A() ||
                   portNumber == PowerHubProductID_B_Port_B() ) {
                    current_mA = AvailableCurrentPowerHub();
                }
            }
        }
    }

    VARTRACE(current_mA);
    return current_mA;
}

tBoolean DataProvider::IsLastModePositionSupported(const tDeviceType deviceType, const tCategoryType objectType)
{
    ENTRY_INTERNAL;
    tBoolean deviceFound = FALSE;
    tBoolean objectFound = FALSE;

    for(int i=1; i<=LastModePosDeviceTypes(); i++)
    {
        switch(i) {
        case 1:
            if(LastModePosDeviceType_01() == deviceType) {deviceFound = TRUE;}
            break;
        case 2:
            if(LastModePosDeviceType_02() == deviceType) {deviceFound = TRUE;}
            break;
        case 3:
            if(LastModePosDeviceType_03() == deviceType) {deviceFound = TRUE;}
            break;
        case 4:
            if(LastModePosDeviceType_04() == deviceType) {deviceFound = TRUE;}
            break;
        case 5:
            if(LastModePosDeviceType_05() == deviceType) {deviceFound = TRUE;}
            break;
        case 6:
            if(LastModePosDeviceType_06() == deviceType) {deviceFound = TRUE;}
            break;
        case 7:
            if(LastModePosDeviceType_07() == deviceType) {deviceFound = TRUE;}
            break;
        case 8:
            if(LastModePosDeviceType_08() == deviceType) {deviceFound = TRUE;}
            break;
        default:
            ETG_TRACE_FATAL(("[ERROR] DataProvider::IsLastModePositionSupported: Check mediaplayer configuration"));
            break;
        }
     }

    for(int i=1; i<=LastModePosCategoryTypes(); i++)
    {
        switch(i) {
        case 1:
            if(LastModePosCategoryType_01() == objectType) {objectFound = TRUE;}
            break;
        case 2:
            if(LastModePosCategoryType_02() == objectType) {objectFound = TRUE;}
            break;
        case 3:
            if(LastModePosCategoryType_03() == objectType) {objectFound = TRUE;}
            break;
        case 4:
            if(LastModePosCategoryType_04() == objectType) {objectFound = TRUE;}
            break;
        default:
            ETG_TRACE_FATAL(("[ERROR] DataProvider::IsLastModePositionSupported: Check mediaplayer configuration"));
            break;
        }
     }

    if((FALSE == deviceFound) || (FALSE == objectFound))
    {
        return FALSE;
    }
    else
    {
        return TRUE;
    }
}

tBoolean DataProvider::IsiPodControlLocationInfoEnabled()
{
    if(iPodControlLocationInfoGPGGA()) return TRUE;
    if(iPodControlLocationInfoGPRMC()) return TRUE;
    if(iPodControlLocationInfoGPGSV()) return TRUE;
    if(iPodControlLocationInfoGPHDT()) return TRUE;
    if(iPodControlLocationInfoPASCD()) return TRUE;
    if(iPodControlLocationInfoPAGCD()) return TRUE;
    if(iPodControlLocationInfoPAACD()) return TRUE;
    return FALSE;
}

tBoolean DataProvider::IsDeviceSupportTrackScanning(tDeviceType deviceType)
{
    tBoolean isSupported = false;
    tUInt noOfTrackScanSupportedDeviceTypes = TrackScanSupportedDeviceTypes();

    for(tUInt i=0; i<noOfTrackScanSupportedDeviceTypes; i++)
    {
        switch(i)
        {
        case 0:
            if(deviceType == (tDeviceType)TrackScanSupportedDeviceType_1()) {isSupported = true;}
            break;
        case 1:
            if(deviceType == (tDeviceType)TrackScanSupportedDeviceType_2()) {isSupported = true;}
            break;
        default:
            ETG_TRACE_FATAL(("[ERROR] DataProvider::IsDeviceSupportTrackScanning: Check mediaplayer configuration"));
            break;
        }

        if(true == isSupported)
        {
            break;
        }
    }

    return isSupported;
}
tResult DataProvider::FindLatin1Metadata(tMediaObject &mediaObject,const void* _info)
{
    tResult ret = MP_NO_ERROR;
    const Info* info = (const Info *)_info;

    tBoolean convertMetadataField1toUniCode = false;
    tBoolean convertMetadataField2toUniCode = false;
    tBoolean convertMetadataField3toUniCode = false;
    tBoolean convertMetadataField4toUniCode = false;
    tBoolean convertTitletoUniCode = false;

    tBoolean isMetadataField1Available  = !info->get_genre().isEmpty();
    tBoolean isMetadataField2Available  = !info->get_artist().isEmpty();
    tBoolean isMetadataField3Available  = !info->get_composer().isEmpty();
    tBoolean isMetadataField4Available  = !info->get_album().isEmpty();
    tBoolean isTitleAvailable           = !info->get_title().isEmpty();

    //All Latin1 strings are Retrieved as latin1 from Taglib.Non-latin1 are retrieved as UTF-8.
    if(isMetadataField1Available) convertMetadataField1toUniCode = !info->get_genre().isLatin1();
    if(isMetadataField2Available) convertMetadataField2toUniCode = !info->get_artist().isLatin1();
    if(isMetadataField3Available) convertMetadataField3toUniCode = !info->get_composer().isLatin1();
    if(isMetadataField4Available) convertMetadataField4toUniCode = !info->get_album().isLatin1();
    if(isTitleAvailable) convertTitletoUniCode = !info->get_title().isLatin1();

    //Note:Taglib::String::toCString(tBoolean bool), If bool is TRUE,UTF-8 retrieved.Else, Latin1
    if(isMetadataField1Available) strncpy_r(OUT mediaObject.MetadataField1,IN info->get_genre().toCString(convertMetadataField1toUniCode),IN sizeof(mediaObject.MetadataField1));
    if(isMetadataField2Available) strncpy_r(OUT mediaObject.MetadataField2,IN info->get_artist().toCString(convertMetadataField2toUniCode),IN sizeof(mediaObject.MetadataField2));
    if(isMetadataField3Available) strncpy_r(OUT mediaObject.MetadataField3,IN info->get_composer().toCString(convertMetadataField3toUniCode),IN sizeof(mediaObject.MetadataField3));
    if(isMetadataField4Available) strncpy_r(OUT mediaObject.MetadataField4,IN info->get_album().toCString(convertMetadataField4toUniCode),IN sizeof(mediaObject.MetadataField4));
    if(isTitleAvailable) strncpy_r(OUT mediaObject.title,IN info->get_title().toCString(convertTitletoUniCode),IN sizeof(mediaObject.title));

    /*
    For the Latin1 strings,the corresponding bit will be set in metadataConvertFlag.
    bit0- MetadataField1
    bit1- MetadataField2
    bit2- MetadataField3
    bit3- MetadataField4
    bit4- Title
    */

    mediaObject.metadataConvertFlag = 0;

    if(isMetadataField1Available && !convertMetadataField1toUniCode) mediaObject.metadataConvertFlag |= BITFLAG_METADATAFIELD1;
    if(isMetadataField2Available && !convertMetadataField2toUniCode) mediaObject.metadataConvertFlag |= BITFLAG_METADATAFIELD2;
    if(isMetadataField3Available && !convertMetadataField3toUniCode) mediaObject.metadataConvertFlag |= BITFLAG_METADATAFIELD3;
    if(isMetadataField4Available && !convertMetadataField4toUniCode) mediaObject.metadataConvertFlag |= BITFLAG_METADATAFIELD4;
    if(isTitleAvailable && !convertTitletoUniCode) mediaObject.metadataConvertFlag |= BITFLAG_TITLE;

#if CODESET_CONVERSION_TRACES_NEEDED
    //Used for CodesetConversion Hexdump Analysis
    FILE* codesetConvLogFile = fopen(IN CodeSetConvLogFilePath().c_str(), "a");
    if(codesetConvLogFile)
    {
        fprintf(codesetConvLogFile,"FindLatin1MetadataEntries : mediaObject.metadataConvertFlag:%d\n", mediaObject.metadataConvertFlag);
        fclose(codesetConvLogFile);
    }
#endif
    ETG_TRACE_USR4(("FindLatin1MetadataEntries : mediaObject.metadataConvertFlag:%d",mediaObject.metadataConvertFlag));
    return ret;
}
tResult DataProvider::FindNonUTF8Latin1Metadata(tMediaObject &mediaObject)
{
    //Copy Bitflag of each metadata .This Bitflag represents whether the metadata is in Latin1 or not
    tBoolean isMetadataField1inLatin1 = mediaObject.metadataConvertFlag & BITFLAG_METADATAFIELD1;
    tBoolean isMetadataField2inLatin1 = mediaObject.metadataConvertFlag & BITFLAG_METADATAFIELD2;
    tBoolean isMetadataField3inLatin1 = mediaObject.metadataConvertFlag & BITFLAG_METADATAFIELD3;
    tBoolean isMetadataField4inLatin1 = mediaObject.metadataConvertFlag & BITFLAG_METADATAFIELD4;
    tBoolean isTitleinLatin1 = mediaObject.metadataConvertFlag & BITFLAG_TITLE;

    //Reset the flag.The BitFlag will be set only for the Latin1 metadata which is found to be Non UTF-8
    mediaObject.metadataConvertFlag = 0;

    /* Check if any Latin1 metadata is Non-UTF8. If found,set its bitflag in mediaObject.metadataConvertFlag
     * No Codesetconversion needed for Latin1 metadata already in UTF-8
     */
    if(isMetadataField1inLatin1 && (g_utf8_validate((gchar *)mediaObject.MetadataField1 , -1, NULL) == false))
    {
        mediaObject.metadataConvertFlag |= BITFLAG_METADATAFIELD1;
    }

    if(isMetadataField2inLatin1 && (g_utf8_validate((gchar *)mediaObject.MetadataField2 , -1, NULL) == false))
    {
        mediaObject.metadataConvertFlag |= BITFLAG_METADATAFIELD2;
    }

    if(isMetadataField3inLatin1 && (g_utf8_validate((gchar *)mediaObject.MetadataField3 , -1, NULL) == false))
    {
        mediaObject.metadataConvertFlag |= BITFLAG_METADATAFIELD3;
    }

    if(isMetadataField4inLatin1 && (g_utf8_validate((gchar *)mediaObject.MetadataField4 , -1, NULL) == false))
    {
        mediaObject.metadataConvertFlag |= BITFLAG_METADATAFIELD4;
    }

    if(isTitleinLatin1 && (g_utf8_validate((gchar *)mediaObject.title , -1, NULL) == false))
    {
        mediaObject.metadataConvertFlag |= BITFLAG_TITLE;
    }

    return MP_NO_ERROR;
}

tResult DataProvider::ConvertNonUTF8Latin1Metadata2UTF8(tMediaObject &mediaObject,const void* _info)
{
    tResult ret = MP_NO_ERROR;
    gchar* res = NULL;

    FILE* codesetConvLogFile = NULL;
    const Info* info = (const Info *)_info;

#if CODESET_CONVERSION_TRACES_NEEDED
    //Used for CondesetConversion Hexdump Analysis
    codesetConvLogFile = fopen(IN CodeSetConvLogFilePath().c_str(), "a");
#endif
    //copy the Latin1 conversion needed information
    tBoolean convertMetadataField1toUniCode = mediaObject.metadataConvertFlag & BITFLAG_METADATAFIELD1;
    tBoolean convertMetadataField2toUniCode = mediaObject.metadataConvertFlag & BITFLAG_METADATAFIELD2;
    tBoolean convertMetadataField3toUniCode = mediaObject.metadataConvertFlag & BITFLAG_METADATAFIELD3;
    tBoolean convertMetadataField4toUniCode = mediaObject.metadataConvertFlag & BITFLAG_METADATAFIELD4;
    tBoolean convertTitletoUniCode = mediaObject.metadataConvertFlag & BITFLAG_TITLE;

    if(codesetConvLogFile)
    {
        fprintf(codesetConvLogFile,"Metadata Before Latin1 conversion");
        fprintf(codesetConvLogFile,"ConvertNonUTF8Latin1Metadata2UTF8 : mediaObject.metadataConvertFlag:%d\n", mediaObject.metadataConvertFlag);
        HexDumpMediaObjectMetadataFields(mediaObject,codesetConvLogFile);
    }

    //reset metadataConvertFlag.It will be updated on success of UTF-8 Conversion
    mediaObject.metadataConvertFlag = 0;

    /* Convert Latin1(i.e ISO 8859-1 Codepage) string to UTF-8 string
     * If Latin1 to UTF8 conversion fails, then retrieve UTF-8 string from taginfo.
     * Thus,it is ensured only UTF-8 be stored in DB & given to HMI
     */
    if(convertMetadataField1toUniCode)
    {
        res = g_convert((gchar*)mediaObject.MetadataField1,strlen_r((const char*)mediaObject.MetadataField1),"UTF-8","ISO-8859-1",NULL,NULL,NULL);
        if(res)
        {
            strncpy_r(mediaObject.MetadataField1,(const char*)(res),sizeof(mediaObject.MetadataField1));
            mediaObject.metadataConvertFlag |= BITFLAG_METADATAFIELD1;
            g_free(res);
        }
        else
        {
            strncpy_r(mediaObject.MetadataField1,(info->get_genre().toCString(true)),sizeof(mediaObject.MetadataField1));
        }
    }

    if(convertMetadataField2toUniCode)
    {
        res = g_convert((gchar*)mediaObject.MetadataField2,strlen_r((const char*)mediaObject.MetadataField2),"UTF-8","ISO-8859-1",NULL,NULL,NULL);
        if(res)
        {
            strncpy_r(mediaObject.MetadataField2,(const char*)(res),sizeof(mediaObject.MetadataField2));
            mediaObject.metadataConvertFlag |= BITFLAG_METADATAFIELD2;
            g_free(res);
        }
        else
        {
            strncpy_r(mediaObject.MetadataField2,(info->get_artist().toCString(true)),sizeof(mediaObject.MetadataField2));
        }
    }

    if(convertMetadataField3toUniCode)
    {
        res = g_convert((gchar*)mediaObject.MetadataField3,strlen_r((const char*)mediaObject.MetadataField3),"UTF-8","ISO-8859-1",NULL,NULL,NULL);
        if(res)
        {
            strncpy_r(mediaObject.MetadataField3,(const char*)(res),sizeof(mediaObject.MetadataField3));
            mediaObject.metadataConvertFlag |= BITFLAG_METADATAFIELD3;
            g_free(res);
        }
        else
        {
            strncpy_r(mediaObject.MetadataField3,(info->get_composer().toCString(true)),sizeof(mediaObject.MetadataField3));
        }
    }

    if(convertMetadataField4toUniCode)
    {
        res = g_convert((gchar*)mediaObject.MetadataField4,strlen_r((const char*)mediaObject.MetadataField4),"UTF-8","ISO-8859-1",NULL,NULL,NULL);
        if(res)
        {
            strncpy_r(mediaObject.MetadataField4,(const char*)(res),sizeof(mediaObject.MetadataField4));
            mediaObject.metadataConvertFlag |= BITFLAG_METADATAFIELD4;
            g_free(res);
        }
        else
        {
            strncpy_r(mediaObject.MetadataField4,(info->get_album().toCString(true)),sizeof(mediaObject.MetadataField4));
        }
    }

    if(convertTitletoUniCode)
    {
        res = g_convert((gchar*)mediaObject.title,strlen_r((const char*)mediaObject.title),"UTF-8","ISO-8859-1",NULL,NULL,NULL);
        if(res)
        {
            strncpy_r(mediaObject.title,(const char*)(res),sizeof(mediaObject.title));
            mediaObject.metadataConvertFlag |= BITFLAG_TITLE;
            g_free(res);
        }
        else
        {
            strncpy_r(mediaObject.title,(info->get_title().toCString(true)),sizeof(mediaObject.title));
        }
    }

    if(codesetConvLogFile)
    {
        fprintf(codesetConvLogFile,"Metadata After Latin1 conversion");
        fprintf(codesetConvLogFile,"ConvertNonUTF8Latin1Metadata2UTF8 : mediaObject.metadataConvertFlag:%d\n", mediaObject.metadataConvertFlag);
        HexDumpMediaObjectMetadataFields(mediaObject,codesetConvLogFile);
        fclose(codesetConvLogFile);
    }

    //ETG Tracing
    ETG_TRACE_USR4(("ConvertNonUTF8Latin1Metadata2UTF8 : mediaObject.metadataConvertFlag:%d",mediaObject.metadataConvertFlag));

    return ret;
}

tResult DataProvider::FindAndConvertLatin1MetadataEntries(tMediaObject &mediaObject,const void* _info)
{
    tResult ret = MP_NO_ERROR;

    //The Latin1 metadata are found and their corresponding BitFlags in mediaObject.metadataConvertFlag are set
    ret = FindLatin1Metadata(INOUT mediaObject,IN _info);

    if(mediaObject.metadataConvertFlag)
    {
        //The Latin1 metadata which are Non-UTF8 are found and their corresponding BitFlags in mediaObject.metadataConvertFlag are set
        ret = FindNonUTF8Latin1Metadata(INOUT mediaObject);
    }

    if(mediaObject.metadataConvertFlag)
    {
        //The Latin1 metadata found to be Non-UTF8 are converted to UTF-8 strings
        ret = ConvertNonUTF8Latin1Metadata2UTF8(INOUT mediaObject,IN _info);
    }
    return ret;
}
void DataProvider::HexDumpMediaObjectMetadataFields(tMediaObject &mediaObject,FILE* codesetConvLogFile)
{

    if(codesetConvLogFile)
    {
        hexDump(codesetConvLogFile,const_cast<char*>("mediaObject.MetadataField1"), (void *)mediaObject.MetadataField1,strlen_r(mediaObject.MetadataField1));
        hexDump(codesetConvLogFile,const_cast<char*>("mediaObject.MetadataField2"), (void *)mediaObject.MetadataField2,strlen_r(mediaObject.MetadataField2));
        hexDump(codesetConvLogFile,const_cast<char*>("mediaObject.MetadataField3"), (void *)mediaObject.MetadataField3,strlen_r(mediaObject.MetadataField3));
        hexDump(codesetConvLogFile,const_cast<char*>("mediaObject.MetadataField4"), (void *)mediaObject.MetadataField4,strlen_r(mediaObject.MetadataField4));
        hexDump(codesetConvLogFile,const_cast<char*>("mediaObject.title"), (void *)mediaObject.title,strlen_r(mediaObject.title));
    }
}

void DataProvider::vUpdateSPMSysPwrMode(tSPMSysPwrMode SPMSysPwrMode)
{
    ENTRY
    ETG_TRACE_USR2(("DataProvider::vUpdateSPMSysPwrMode  : SPMSysPwrMode : %d",ETG_CENUM(tSPMSysPwrMode,SPMSysPwrMode)));
    mSPMSysPwrMode = SPMSysPwrMode;
}


tSPMSysPwrMode DataProvider::GetSPMSysPwrMode()
{
    ENTRY
    ETG_TRACE_USR2(("DataProvider::GetSPMSysPwrMode : mSPMSysPwrMode : %d",ETG_CENUM(tSPMSysPwrMode,mSPMSysPwrMode)));
    return mSPMSysPwrMode;
}

tResult DataProvider::GetReadOnlyFlag(tBoolean &bReadOnlyFlag, const tFileMode fileMode, const tUserID fileUserID, const tGroupID fileGroupID)
{
    ENTRY

    /* Determine read only flag */
    bReadOnlyFlag = true;
    tUserID ownUserID = getuid();
    tGroupID ownGroupID = getgid();
    if((0 == ownUserID) || (fileUserID == ownUserID)) //user is root or same like file
    {
        if(S_IWUSR & fileMode)
        {
            bReadOnlyFlag = false;
        }
    }
    else if((0 == ownGroupID) || (fileGroupID == ownGroupID)) //group is root or same like file
    {
        if(S_IWGRP & fileMode)
        {
            bReadOnlyFlag = false;
        }
    }
    else
    {
        if(S_IWOTH & fileMode)
        {
            bReadOnlyFlag = false;
        }
    }

    /* Convert fileMode to readable format */
    char l_rwx[10];
    char rwx[] = "rwxrwxrwx";
    int bits[] =
    {
       S_IRUSR,S_IWUSR,S_IXUSR,   //access permission User
       S_IRGRP,S_IWGRP,S_IXGRP,   //access permission Group
       S_IROTH,S_IWOTH,S_IXOTH    //access permission Other
    };

    for(tUInt i = 0; i < 9; i++)
    {
       if(fileMode & bits[i])
          l_rwx[i]=rwx[i];  /*r,w or x*/
       else
          l_rwx[i] = '-'; /*if not set use '-'*/
    }
    l_rwx[9]='\0';

    ETG_TRACE_USR3(("GetReadOnlyFlag bReadOnlyFlag: %d, ownUID: %d, ownGID: %d, fileUID: %d, fileGID: %d, fileMode: %s",
            bReadOnlyFlag, ownUserID, ownGroupID, fileUserID, fileGroupID, l_rwx));
    return MP_NO_ERROR;
}
void DataProvider::AddDeviceToIgnoreLastModePause(const tDeviceID deviceID)
{
    ENTRY
    VARTRACE(deviceID)

    vector<tDeviceID>::iterator iter;

    if(DEVICE_ID_NOT_SET == deviceID)
    {
        ETG_TRACE_ERR(("AddDeviceToIgnoreLastModePause : Invalid DeviceID"));
    }
    else
    {
        iter = find(mIgnoreLastModePauseDevices.begin(), mIgnoreLastModePauseDevices.end(), deviceID);

        if(mIgnoreLastModePauseDevices.end() == iter)
        {
            mIgnoreLastModePauseDevices.push_back(deviceID);
        }
        else
        {
            ETG_TRACE_ERR(("AddDeviceToIgnoreLastModePause: DeviceID %d is already available in List",deviceID));
        }
    }
}

tBoolean DataProvider::IsIgnoreLastModePauseNeeded(const tDeviceID deviceID)
{
    ENTRY
    VARTRACE(deviceID)

    vector<tDeviceID>::iterator iter;
    tBoolean isIgnoreNeeded = false;

    if(DEVICE_ID_NOT_SET == deviceID)
    {
        ETG_TRACE_ERR(("IsIgnoreLastModePauseNeeded : Invalid DeviceID"));
    }
    else
    {
        iter = find(mIgnoreLastModePauseDevices.begin(), mIgnoreLastModePauseDevices.end(), deviceID);
        if(iter != mIgnoreLastModePauseDevices.end())
        {
            isIgnoreNeeded = true;
        }
    }

    VARTRACE(isIgnoreNeeded)

    return isIgnoreNeeded;
}

void DataProvider::RemoveDeviceFromLastModePauseList(const tDeviceID deviceID)
{
    ENTRY
    VARTRACE(deviceID)

    vector<tDeviceID>::iterator iter;

    if(DEVICE_ID_NOT_SET == deviceID)
    {
        ETG_TRACE_ERR(("RemoveDeviceFromLastModePauseList : DeviceID Invalid"));
    }
    else
    {
        iter = find(mIgnoreLastModePauseDevices.begin(), mIgnoreLastModePauseDevices.end(), deviceID);
        if(mIgnoreLastModePauseDevices.end() == iter)
        {
            ETG_TRACE_ERR(("RemoveDeviceFromLastModePauseList:DeviceID %d is unavailable to remove",deviceID ));
        }
        else
        {
            mIgnoreLastModePauseDevices.erase(iter);
        }
    }
}

void DataProvider::clearCache()
{
    mAlbumArtCache.clearCache();
}
void DataProvider::setFileSystemtype()
{
    mFileSystemType.clear();
    mFileSystemType[FSTY_UNKNOWN] = "unknown";
    mFileSystemType[FSTY_FAT] = "vfat";
    mFileSystemType[FSTY_NTFS] = "ntfs";
    mFileSystemType[FSTY_EXT4] = "ext4";
    mFileSystemType[FSTY_HFS]="hfs";
    mFileSystemType[FSTY_EXFAT] = "exfat";
    mFileSystemType[FSTY_ISO9660] = "iso9660";
    mFileSystemType[FSTY_UDF] = "udf";
}
string DataProvider::GetDeviceFileSystemType(tFileSystemType etype)
{
    ENTRY
    std::map<tFileSystemType, string>::iterator it = mFileSystemType.find(etype);
    if (it != mFileSystemType.end())
    {
        return it->second;
    }
    return "unknown";
}

string DataProvider::ConvertDbPath(string Path)
{
    ENTRY
    /* Sanity check for path */
    string localPath = Path;

    if(NULL == FastUTF8::StartsWith((const FastUTF8::tString)Path.c_str(), (const FastUTF8::tString)"/")) //lint !e1773
    {
        ETG_TRACE_ERR(("%s is called with a path without leading /",__PRETTY_FUNCTION__));
        localPath = "/";
        localPath = localPath+Path;
        localPath = localPath+"/";
    }
    if(NULL == FastUTF8::EndsWith((const FastUTF8::tString)Path.c_str(), (const FastUTF8::tString)"/"))
    {
        ETG_TRACE_ERR(("%s is called with a path without end of /",__PRETTY_FUNCTION__));
        localPath = Path;
        localPath = localPath+"/";
    }
    return localPath;
}
int DataProvider::getnullPos(tU8 *ch, int length)
{
    if(ch)
    {
        for(int i = 0; i < length ;i++)
        {
            if(ch[i] == 0)
                return i; // return position of null character
        }
    }
    return -1; // return -1 id not found
}

tBool DataProvider::isValidPack(tU8 pty, int id, tU8 TrackNo)
{
    // id value should be 0 to maximum track avilable in the CDDA.
    if(id >= 0 && id <=TrackNo+1)
    {
        //pty value should be valid as per Audio CD-TEXT Format in the Lead-in Area
        return (pty >= enCDAUDIO_CDTEXT_TYPE_TITLE)&&(pty <= enCDAUDIO_CDTEXT_TYPE_SIZEINFO);
    }
    return false;
}
tResult DataProvider::parseCddaResponseBuffer(IN const tU8 *pu8RawATA,IN const tU16 textLength,IN const tU8 TrackNo)
{
    ENTRY
    tResult u32Ret = MP_NO_ERROR;
    tU32 u32ATARowCur = 0;
    tU32 u32ATARowMax = 0;
    tCDTextInfo lInfo;
    tU8 u8ATAId = 0;
    tU8 packNo = 0;
    tU8 index = 0;
    tGeneralString textEntry;
    tBoolean bIfRecievedAlbum = false;
    tBoolean bIfRecievedTitle = false;

    mAlbum.clear();
    mTitelCDText.clear();
    mArtistCDText.clear();
    m_bArtistCDTextforAlbumPresent = false;

    u32ATARowMax = (textLength / CDAUDIO_CDTEXT_ATA_BUFFER_BYTES_PER_LINE);
    while(u32ATARowCur < u32ATARowMax)
    {
        tU8 iLineIndex;
        if(u8ATAId!=CDAUDIO_ATABYTE(pu8RawATA, u32ATARowCur, 0) || bIfRecievedTitle == false)
        {
            u8ATAId = CDAUDIO_ATABYTE(pu8RawATA, u32ATARowCur, 0);
            packNo = 0;
        }
        lInfo.ID = CDAUDIO_ATABYTE(pu8RawATA, u32ATARowCur, 1);
        lInfo.pos = CDAUDIO_ATABYTE(pu8RawATA, u32ATARowCur, 3);
        lInfo.startpos = 0;
        if(isValidPack(u8ATAId,lInfo.ID,TrackNo))
        {
            memset(lInfo.srtPack,0,sizeof(lInfo.srtPack));
            if(lInfo.ID == 0 && enCDAUDIO_CDTEXT_TYPE_TITLE == u8ATAId && index < CDTEXT_MAX_BUFFER)
            {
                //work on current line for Album .
                for(iLineIndex = 0; iLineIndex < CDAUDIO_CDTEXT_ATA_BUFFER_TEXT_PER_LINE;
                        ++iLineIndex)
                {
                    textEntry[index] = CDAUDIO_ATABYTE(pu8RawATA, u32ATARowCur, 4 + iLineIndex);
                    if(0 == textEntry[index] && bIfRecievedAlbum == false)
                    {
                        mAlbum = (char*)textEntry;
                        // if album is already received and reset of string for Title
                        bIfRecievedAlbum = true;
                        index = 0;
                        iLineIndex++;
                        lInfo.startpos = iLineIndex;
                    }
                    if(bIfRecievedAlbum && iLineIndex < CDAUDIO_CDTEXT_ATA_BUFFER_TEXT_PER_LINE)
                    {
                        lInfo.srtPack[iLineIndex] = CDAUDIO_ATABYTE(pu8RawATA, u32ATARowCur, 4 + iLineIndex);
                        bIfRecievedTitle = true;
                    }
                    index++;
                } //for(iLineIndex ...
                if(bIfRecievedTitle) // If rest of the string is title insert into map
                {
                    lInfo.srtPack[CDAUDIO_CDTEXT_ATA_BUFFER_TEXT_PER_LINE] = 0;
                    mTitelCDText.insert(std::pair<tU8,tCDTextInfo>(packNo,lInfo));
                }
            }
            else
            {
                /*If null character not found and ID value changed */
                if(bIfRecievedAlbum == false && index < CDTEXT_MAX_BUFFER )
                {
                    textEntry[index] = 0;
                    mAlbum = (char*)textEntry;
                    bIfRecievedAlbum = true;
                }
                //work on current line
                for(iLineIndex = 0; iLineIndex < CDAUDIO_CDTEXT_ATA_BUFFER_TEXT_PER_LINE;
                        ++iLineIndex)
                {
                    lInfo.srtPack[iLineIndex] = CDAUDIO_ATABYTE(pu8RawATA, u32ATARowCur, 4 + iLineIndex);

                } //for(iLineIndex ...
            }
            lInfo.srtPack[CDAUDIO_CDTEXT_ATA_BUFFER_TEXT_PER_LINE] = 0;

            if(enCDAUDIO_CDTEXT_TYPE_TITLE == u8ATAId && lInfo.ID > 0)
            {
                lInfo.ID = lInfo.ID -1; // ID value for title starts from 1
                mTitelCDText.insert(std::pair<tU8,tCDTextInfo>(packNo,lInfo)); // insert title into map
                bIfRecievedTitle = true;
            }
            if(enCDAUDIO_CDTEXT_TYPE_ARTIST == u8ATAId)
            {
                if(lInfo.ID == 0)
                {
                    m_bArtistCDTextforAlbumPresent = true;
                }
                mArtistCDText.insert(std::pair<tU8,tCDTextInfo>(packNo,lInfo)); // insert artist into map
            }
            memset(&lInfo,0,sizeof(lInfo));
        }//End of Pack Validity check
        packNo++;
        u32ATARowCur++;
    }
    return u32Ret;
}
tResult DataProvider::getCddaMetaDataForTitle(OUT string & Album , OUT MapCDDAMetadata & Title, IN tU8 TrackNo)
{
    ENTRY
    tResult res = MP_NO_ERROR;

    res = getMetaData(Title,mTitelCDText,TrackNo,false);
    Album = mAlbum;
    return res;
}
tResult DataProvider::getCddaMetaDataForArtist(OUT MapCDDAMetadata & Artist, IN tU8 TrackNo)
{
    ENTRY
    tResult res = MP_NO_ERROR;

    res = getMetaData(Artist,mArtistCDText,TrackNo,true);
    return res;
}
tResult DataProvider::getMetaData(OUT MapCDDAMetadata & metadata, IN  MapCDCode &CDText, IN tU8 TrackNo,bool artist)
{
    ENTRY
    tResult res = MP_NO_ERROR;
    string tsMetaData;
    tU8 _id = 0;
    tU8 l_trackNo = 0;
    MapCDCode::iterator Prev_it;
    MapCDCode::iterator it;
    tU8 Pakpos = 0;

    if((artist ==true) && (m_bArtistCDTextforAlbumPresent == true))
    {//if artist tag starts from 0, change the track no accordingly
        TrackNo++;
    }
    /*Get the first track ID*/
    if(CDText.size())
        _id = CDText.begin()->second.ID;
    while(Pakpos <= CDText.size()) // loop run upto last track
    {
        it = CDText.find(Pakpos);
        if(Pakpos == CDText.size()) // Get last Track Info
        {
            /*Get information about last pack , find any new track available*/
            it = CDText.find(Pakpos-1); // get the previous pack because last track is already reached
            if(it!=CDText.end())
            {
                int chPos = getnullPos(it->second.srtPack, CDAUDIO_CDTEXT_ATA_BUFFER_TEXT_PER_LINE);
                if(l_trackNo < TrackNo)
                {
                    metadata.insert(std::pair<tU8,string>(l_trackNo,tsMetaData));
                    l_trackNo = l_trackNo+1;
                }
                if((l_trackNo < TrackNo) && (-1 != chPos))
                {
                    tsMetaData = (char*)&(it->second.srtPack[chPos+1]);
                    metadata.insert(std::pair<tU8,string>(l_trackNo,tsMetaData));
                }
                tsMetaData.clear();
            }
        }
        else if(it!=CDText.end())
        {
            string t_Metadata;

            if((_id != it->second.ID) && (l_trackNo < TrackNo))
            {
                metadata.insert(std::pair<tU8,string>(l_trackNo,tsMetaData));
                tsMetaData.clear();
                int avail = (it->second.ID - _id);
                int s_pos = 0;
                /*In case more than one track available in single packet*/
                while(avail > 1 && avail < CDAUDIO_CDTEXT_ATA_BUFFER_TEXT_PER_LINE)
                {
                    Prev_it =  CDText.find(it->first-1);
                    if(Prev_it!=CDText.end())
                    {
                    int pos = getnullPos(&(Prev_it->second.srtPack[s_pos]), CDAUDIO_CDTEXT_ATA_BUFFER_TEXT_PER_LINE-s_pos)+1;
                    s_pos+=pos;
                    if((-1!=pos) && (s_pos < CDAUDIO_CDTEXT_ATA_BUFFER_TEXT_PER_LINE))
                    {
                        l_trackNo = l_trackNo+1;
                        if(l_trackNo < TrackNo)
                        {
                            tsMetaData = (char*)&(Prev_it->second.srtPack[s_pos]);
                            metadata.insert(std::pair<tU8,string>(l_trackNo,tsMetaData));
                            tsMetaData.clear();
                            }
                        }
                    }
                    avail--;
                }
                _id = it->second.ID;
                l_trackNo = l_trackNo+1;
            }
            tU8 pos = (it->second.pos&CDAUDIO_CDTEXT_ATA_BUFFER_CHARPOS_MASK);
            if(pos > 0 && pos < CDAUDIO_CDTEXT_ATA_BUFFER_TEXT_PER_LINE)
            {
                /*Get Previous packet info from the position value available in the packet*/
                if(it->first)
                {
                    Prev_it =  CDText.find(it->first-1);
                    if(Prev_it!=CDText.end() && !Prev_it->second.startpos) // copy only start position for pack is 0
                        t_Metadata = (char*)&(Prev_it->second.srtPack[CDAUDIO_CDTEXT_ATA_BUFFER_TEXT_PER_LINE - pos]);
                }
            }
            t_Metadata.append((char *)&(it->second.srtPack[it->second.startpos]));
            tsMetaData.append(t_Metadata);
        }
        Pakpos++;
    }
    if((artist ==true) && (m_bArtistCDTextforAlbumPresent == true))
    {
        VARTRACE("### If artist for album also available, reordering of map ###");
        MapCDDAMetadata tempMetadata;
        for(MapCDDAMetadata::iterator it = metadata.begin() ;it!=metadata.end();it++)
        {
            tU8 index = (it->first);
            if(index > 0)
            {
            tempMetadata.insert(std::pair<tU8,string>((index -1),it->second));
            }
        }
        metadata.clear();
        metadata = tempMetadata;
    }
    return res;
}

tBTLimitationModeDeviceList& DataProvider::getBTLimitationModeDeviceList()
{
    return btLimitationModeDeviceList;
}

void AssignUnknownText(char *p_ctext)
{

    /* UNKNOWN macro: if string is empty take UnknownText from configuration */
    if(p_ctext)
    {
        if(strlen(p_ctext))
        {
            strtrim((char *)p_ctext);
        }
        else
        {
            strncpy_r(p_ctext,LocalSPM::GetDataProvider().DBUnknownText().c_str(),strlen(LocalSPM::GetDataProvider().DBUnknownText().c_str())+1);
        }
    }
}

tResult DataProvider::GetThumbNailObject(OUT tAlbumArtObjectPtr &ThumbNailObjectPtr, IN const tThumbnailImage &Image,
        IN tSize Width, IN tSize Height, IN tMimeType MimeType, IN const char* filename)
{
    ENTRY
    tResult res = MP_ERR_DP_NO_ALBUM_ART_AVAIL;
    ThumbNailObjectPtr = NULL;
    static int freeImageInit = 0;
    tSize newSizeX_ = Height;
    tSize newSizeY_ = Width;
    tU8 l_bpp = 24;
    tS32 getPixel = l_bpp / 8;
    tS32 temp_Pixel;
    tS32 position;
    tFilename picFileName = {0};
    GenerateTempFileName(picFileName, "AA");

    mDevilLock.lock();

    /* sanity check */
    if (!(Image.imageBlob.imageData))
    {
        ETG_TRACE_ERR(("DataProvider::GetThumbNailObject -> orgAlbumArtObject = NULL"));
        mDevilLock.unlock();
        return MP_ERR_DP_NO_ALBUM_ART_POINTER;
    }
    for (tS32 i = 0; i < Image.sizeX*Image.sizeY; i++)
    {
        position = i * 3;
        if(position < Image.imageBlob.imageSize)
        {
            temp_Pixel = Image.imageBlob.imageData[position];
            Image.imageBlob.imageData[position] = Image.imageBlob.imageData[position+2];
            Image.imageBlob.imageData[position+2] = temp_Pixel;
        }
    }
        /* check if requested format supported? */
    FREE_IMAGE_FORMAT newFormat;
    switch(MimeType)
    {
        case MMT_PNG:
            newFormat = FIF_PNG;
            break;
        case MMT_BMP:
            newFormat = FIF_BMP;
            break;
        case MMT_GIF:
            newFormat = FIF_GIF;
            break;
        case MMT_JPG:
            newFormat = FIF_JPEG;
            break;
        default:
            mDevilLock.unlock();
            return MP_ERR_DP_FORMAT_NOT_SUPPORTED;
    }
    FIBITMAP* bitmap = FreeImage_ConvertFromRawBits(Image.imageBlob.imageData,
                       Image.sizeY, Image.sizeX, getPixel*Image.sizeY, l_bpp, FI_RGBA_RED_MASK, FI_RGBA_GREEN_MASK, FI_RGBA_BLUE_MASK, true);
    if(bitmap)
    {
        FIBITMAP *rescaledbitmap = FreeImage_Rescale(bitmap, (int)newSizeX_, (int)newSizeY_, FILTER_BILINEAR);
        /*save the new image in the requested format*/
        if(rescaledbitmap)
        {
            if( FreeImage_Save(newFormat, rescaledbitmap, picFileName))
            {
                res = MP_NO_ERROR;
                ETG_TRACE_ERR((" save video thumb nail"));
            }
            FreeImage_Unload(rescaledbitmap);
        }
        FreeImage_Unload(bitmap);
    }
    /* was a decoding problem before? */
    if (res)
    {
        mDevilLock.unlock();
        return res;
    }
    /* reread file into a new object */
    ThumbNailObjectPtr = new tAlbumArtObject;
    if(ThumbNailObjectPtr)
    {
        strncpy_r(OUT ThumbNailObjectPtr->albumArtString, IN Image.string, IN sizeof(Image.string));
        ThumbNailObjectPtr->imageData = mAlbumArtCache.ReadPicture(OUT ThumbNailObjectPtr->imageSize, IN picFileName);
        ThumbNailObjectPtr->sizeX = newSizeX_;
        ThumbNailObjectPtr->sizeY = newSizeY_;
        ThumbNailObjectPtr->mimeType = MimeType;
    }
    /* remove temp file */
    remove(picFileName);

    mDevilLock.unlock();
    return res;
}

tResult DataProvider::FillCodecRestrictionTable()
{
    ENTRY

    //m_CodecRestrictionTable.clear();
    if( 0 < m_CodecRestrictionTable.capacity() )
    {
        vector<tCodecRestriction>().swap(m_CodecRestrictionTable); //used instead of clear to guarantee a memory reallocation
    }


    ETG_TRACE_USR4(("Codec Restriction No.: codec, profile, supported, max level, max resolution, max bitrate, max framerate"));
    ETG_TRACE_USR4(("Codec enum: 0=OTHER, 1=MPEG2, 2=MPEG4, 3=DIVX, 4=XVID, 5=AVC, 6=WMV7, 7=WMV8, 8=WMV9, 9=VP6, 10=VP8, 11=SORENSON, 12=H263, 13=WMA"));
    for(tUInt i=1; i<=(tUInt)LocalSPM::GetDataProvider().CodecRestrictions(); i++)
    {
        tCodecRestriction codecRestrictElem;

        switch(i)
        {
        case 1:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_01();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_01().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_01();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_01();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_01();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_01();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_01();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_01();
            break;
        case 2:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_02();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_02().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_02();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_02();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_02();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_02();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_02();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_02();
            break;
        case 3:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_03();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_03().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_03();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_03();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_03();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_03();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_03();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_03();
            break;
        case 4:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_04();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_04().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_04();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_04();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_04();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_04();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_04();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_04();
            break;
        case 5:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_05();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_05().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_05();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_05();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_05();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_05();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_05();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_05();
            break;
        case 6:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_06();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_06().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_06();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_06();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_06();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_06();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_06();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_06();
            break;
        case 7:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_07();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_07().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_07();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_07();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_07();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_07();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_07();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_07();
            break;
        case 8:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_08();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_08().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_08();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_08();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_08();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_08();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_08();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_08();
            break;
        case 9:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_09();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_09().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_09();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_09();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_09();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_09();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_09();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_09();
            break;
        case 10:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_10();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_10().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_10();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_10();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_10();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_10();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_10();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_10();
            break;
        case 11:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_11();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_11().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_11();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_11();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_11();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_11();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_11();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_11();
            break;
        case 12:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_12();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_12().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_12();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_12();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_12();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_12();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_12();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_12();
            break;
        case 13:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_13();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_13().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_13();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_13();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_13();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_13();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_13();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_13();
            break;
        case 14:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_14();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_14().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_14();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_14();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_14();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_14();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_14();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_14();
            break;
        case 15:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_15();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_15().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_15();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_15();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_15();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_15();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_15();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_15();
            break;
        case 16:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_16();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_16().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_16();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_16();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_16();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_16();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_16();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_16();
            break;
        case 17:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_17();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_17().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_17();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_17();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_17();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_17();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_17();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_17();
            break;
        case 18:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_18();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_18().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_18();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_18();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_18();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_18();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_18();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_18();
            break;
        case 19:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_19();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_19().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_19();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_19();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_19();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_19();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_19();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_19();
            break;
        case 20:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_20();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_20().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_20();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_20();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_20();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_20();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_20();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_20();
            break;
        case 21:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_21();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_21().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_21();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_21();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_21();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_21();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_21();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_21();
            break;
        case 22:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_22();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_22().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_22();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_22();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_22();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_22();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_22();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_22();
            break;
        case 23:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_23();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_23().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_23();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_23();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_23();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_23();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_23();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_23();
            break;
        case 24:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_24();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_24().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_24();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_24();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_24();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_24();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_24();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_24();
            break;
        case 25:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_25();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_25().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_25();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_25();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_25();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_25();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_25();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_25();
            break;
        case 26:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_26();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_26().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_26();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_26();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_26();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_26();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_26();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_26();
            break;
        case 27:
            codecRestrictElem.codec = (tCodec)CodecRestrictionCodec_27();
            strncpy_r(codecRestrictElem.profile, CodecRestrictionProfile_27().c_str(), sizeof(codecRestrictElem.profile));
            codecRestrictElem.supported = (tBoolean)CodecRestrictionSupported_27();
            codecRestrictElem.maxLevel = (tVideoProfileLevel)CodecRestrictionMaxLevel_27();
            codecRestrictElem.maxWidth = (tSize)CodecRestrictionMaxWidth_27();
            codecRestrictElem.maxHeight = (tSize)CodecRestrictionMaxHeight_27();
            codecRestrictElem.maxBitRate = (tBitRate)CodecRestrictionMaxBitRate_27();
            codecRestrictElem.maxFrameRate = (tFrameRate)CodecRestrictionMaxFrameRate_27();
            break;
        default:
            ETG_TRACE_FATAL(("[ERROR] USBControl::FillCodecRestrictionTable: Check mediaplayer configuration"));
            return MP_NO_ERROR;
            break;
        }

        /* Put it into the table */
        m_CodecRestrictionTable.push_back(codecRestrictElem);
        ETG_TRACE_USR4(("Codec Restriction %d: %d, %20s, %d, %f, %dx%d, %d, %d", i, codecRestrictElem.codec, codecRestrictElem.profile,
                codecRestrictElem.supported, codecRestrictElem.maxLevel, codecRestrictElem.maxWidth,
                codecRestrictElem.maxHeight, codecRestrictElem.maxBitRate, codecRestrictElem.maxFrameRate));
    }

    return MP_NO_ERROR;
}

tReturnValue DataProvider::IsVideoPlayable(const tCodec codec,
                                    const tVideoProfileName profile,
                                    const tVideoProfileLevel level,
                                    const tSize width,
                                    const tSize height,
                                    const tFrameRate frameRate,
                                    const tBitRate bitRate)
{
    ENTRY
    VARTRACE(codec);
    VARTRACE(profile);
    VARTRACE(level);
    VARTRACE(width);
    VARTRACE(height);
    VARTRACE(frameRate);
    VARTRACE(bitRate);

    tSize heightVariance = VideoHeightVariance();

    /* Search for restrictions for specific codec + profile */
    tBoolean codecFound = FALSE;
    tBoolean profileFound = FALSE;
    tUInt i = 0;
    for(i=0; i<m_CodecRestrictionTable.size(); i++)
    {
        if(codec == m_CodecRestrictionTable[i].codec)
        {
            codecFound = TRUE;

            //if(NULL != strstr(profile, m_CodecRestrictionTable[i].profile))
            if(0 == strncmp(m_CodecRestrictionTable[i].profile, profile, strlen_r(m_CodecRestrictionTable[i].profile)))
            {
                profileFound = TRUE;
                break;
            }
            else if((false != m_CodecRestrictionTable[i].supported)
                    &&
                    ((-1 == m_CodecRestrictionTable[i].maxLevel) || (level <= m_CodecRestrictionTable[i].maxLevel))
                    &&
                    (width <= m_CodecRestrictionTable[i].maxWidth)
                    &&
                    (height <= (m_CodecRestrictionTable[i].maxHeight + heightVariance))
                    &&
                    (bitRate <= m_CodecRestrictionTable[i].maxBitRate)
                    &&
                    (frameRate <= m_CodecRestrictionTable[i].maxFrameRate))
            {
                ETG_TRACE_USR1(("Guessing profile: %s", m_CodecRestrictionTable[i].profile));
                profileFound = TRUE; //Parameters will fit to at least one of the profiles of a codec
                break;
            }
        }
    }

    if(FALSE == codecFound)
    {
        ETG_TRACE_USR1(("No restrictions found for specific codec -> Video file is playable"));
        /* For example: No restrictions for MPEG-1 */
        return TRUE;
    }

    if(FALSE == profileFound)
    {
        ETG_TRACE_USR1(("Video file is not playable because no supported profile found for specific codec"));
        return FALSE;
    }

    /* Check restrictions */
    if(false == m_CodecRestrictionTable[i].supported)
    {
        ETG_TRACE_USR1(("Video file is not playable because codec profile is not supported"));
        return FALSE;
    }

    if((-1 != m_CodecRestrictionTable[i].maxLevel) && (level > m_CodecRestrictionTable[i].maxLevel))
    {
        ETG_TRACE_USR1(("Video file is not playable because level (%f) is higher than max supported level (%f)", level, m_CodecRestrictionTable[i].maxLevel));
        return FALSE;
    }

    if((width > m_CodecRestrictionTable[i].maxWidth) || (height > (m_CodecRestrictionTable[i].maxHeight + heightVariance)))
    {
        ETG_TRACE_USR1(("Video file is not playable because resolution (%dx%d) is higher than max supported resolution (%dx%d)",
                width, height, m_CodecRestrictionTable[i].maxWidth, (m_CodecRestrictionTable[i].maxHeight + heightVariance)));
        return FALSE;
    }

    if(bitRate > m_CodecRestrictionTable[i].maxBitRate)
    {
        ETG_TRACE_USR1(("Video file is not playable because bitrate (%d) is higher than max supported bitrate (%d)", bitRate, m_CodecRestrictionTable[i].maxBitRate));
        return FALSE;
    }

    if(frameRate > m_CodecRestrictionTable[i].maxFrameRate)
    {
        ETG_TRACE_USR1(("Video file is not playable because framerate (%d) is higher than max supported framerate (%d)", frameRate, m_CodecRestrictionTable[i].maxFrameRate));
        return FALSE;
    }

    ETG_TRACE_USR1(("Video file is playable"));
    return TRUE;
}

tReturnValue DataProvider::IsAudioPlayable(const tCodec codec, const tAudioVersionName version)
{
    ENTRY
    VARTRACE(codec);
    VARTRACE(version);

    /* Search for restrictions for specific codec + version */
    tBoolean codecFound = FALSE;
    //tBoolean versionFound = false;
    tUInt i = 0;
    for(i=0; i<m_CodecRestrictionTable.size(); i++)
    {
        if(codec == m_CodecRestrictionTable[i].codec)
        {
            codecFound = TRUE;

            //if(NULL != strstr(version, m_CodecRestrictionTable[i].profile))
            if(0 == strcmp(m_CodecRestrictionTable[i].profile, version))
            {
                //versionFound = true;
                break;
            }
        }
    }

    if(FALSE == codecFound)
    {
        ETG_TRACE_USR1(("No restrictions found for specific codec -> Audio file is playable"));
        /* For example: No restrictions for MPEG Audio */
        return TRUE;
    }

#if 0
    if(false == versionFound)
    {
        ETG_TRACE_USR1(("Audio file is not playable because no restrictions found for specific version of a codec"));
        /* For example: No restrictions for WMA Version 2 */
        return TRUE;
    }
#endif

    /* Check restrictions */
    if(false == m_CodecRestrictionTable[i].supported)
    {
        ETG_TRACE_USR1(("Audio file is not playable because codec version is not supported"));
        return FALSE;
    }

    ETG_TRACE_USR1(("Audio file is playable"));
    return TRUE;
}

tReturnValue DataProvider::checkIfDeviceConnected(string mountPoint)
{
    ENTRY
    VARTRACE(mountPoint.c_str());

    /*For unittesting use exists_directory and not checkIfMounted, since for unit testing the directories(mount point) are not actually mounted*/
    if(UnitTestEnabled())
    {
        return exists_directory(mountPoint.c_str());
    }
    else
    {
        /*Trim the last character if it is forward slash, to avoid issues in matching mountpoint with /etc/mtab*/
        if(mountPoint[mountPoint.size() - 1] == '/')
        {
            mountPoint[mountPoint.size() - 1] = '\0';
            VARTRACE(mountPoint.c_str());
        }
        return checkIfMounted(mountPoint.c_str());
    }
}

tBoolean DataProvider::IsCoverArtInfoNeededInList(const tListType listType)
{
    tBoolean isNeeded = false;

    tUInt noOfCoverArtLimitedListTypes = LimitCovertArtInfoToListTypes();

    if(noOfCoverArtLimitedListTypes)
    {
        //Need of CovertArt is limited to few list types.
        //Hence treat as "Cover Art Needed" ONLY if requested listType is available as an one of the CoverArt limited ListTypes
        for(tUInt i=0; i<noOfCoverArtLimitedListTypes; i++)
        {
            switch(i)
            {
                case 0:
                    if(listType == (tListType)LimitCovertArtInfoToListType_01()) {isNeeded = true;}
                    break;
                default:
                    ETG_TRACE_FATAL(("[ERROR] DataProvider::IsCoverArtInfoNeededInList: Check mediaplayer configuration"));
                    break;
            }
        }
    }
    else
    {
       //Need of CovertArt is not limited to any list type.Hence treat as "Cover Art Needed"
       isNeeded = true;
    }

    return isNeeded;
}

tBoolean DataProvider::IsThumbnailInfoNeededInList(const tListType listType)
{
    tBoolean isNeeded = false;

    tUInt noOfThumbnailLimitedListTypes = LimitThumbnailInfoToListTypes();

    if(noOfThumbnailLimitedListTypes)
    {
        //Need of Thumbnail is limited to few list types.
        //Hence treat as "Thumbnail Needed" ONLY if requested listType is available as an one of the Thumbnail limited ListTypes
        for(tUInt i=0; i<noOfThumbnailLimitedListTypes; i++)
        {
            switch(i)
            {
                case 0:
                    if(listType == (tListType)LimitThumbnailInfoToListType_01()) {isNeeded = true;}
                    break;
                default:
                    ETG_TRACE_FATAL(("[ERROR] DataProvider::IsThumbnailInfoNeededInList: Check mediaplayer configuration"));
                    break;
            }
        }
    }
    else
    {
       //Need of thumbnail is not limited to any list type.Hence treat as "Thumbnail Needed"
       isNeeded = true;
    }

    return isNeeded;
}

tBoolean DataProvider::IsFileBrowsingByDb(const tDeviceInfo &deviceInfo, const char *path, const tListType &listType)
{
    ENTRY
    tBoolean isPossible = false;

    /* get file attributes from configuration via file extension */
    tFileFormat fileFormat = FFT_UNKNOWN;
    tFileType fileType = FT_UNKNOWN;
    tReturnValue res = LocalSPM::GetDBManager().GetFileFormat(OUT fileFormat, OUT fileType, IN path);
    (void)res; //To avoid unused variable warning

    /* in case of device is already indexed use folder database instead of VTFile */
    if((DBFileBrowsingByDB())
       &&
       ((DBFileListWhileIndexing()) || (IDS_COMPLETE == deviceInfo.indexedState) || (IDS_COMPLETE_FULL_DB == deviceInfo.indexedState))
       &&
       ((LTY_FILELIST == listType) || (LTY_MTP_FILELIST == listType ))
       &&
       (FT_PLAYLIST != fileType)        //Not for playlists
       &&
       ((IsMassStorageDevice(IN deviceInfo.deviceType)) || (DTY_MTP == deviceInfo.deviceType)))
    {
        isPossible = true;
    }

    VARTRACE(isPossible);
    return isPossible;
}
tResult DataProvider::SetDiPOCallControlsConfiguration(const tDiPOCallControlsConfiguration config)
{
    ENTRY
    Datapool dpObject;
    return dpObject.writeCallControlsSetting(config.value);
}

tDiPOCallControlsConfiguration DataProvider::GetDiPOCallControlsConfiguration()
{
    ENTRY
    Datapool dpObject;
    tDiPOCallControlsConfiguration config;
    config.value = 0;
    config.value = dpObject.readCallControlsSetting();
    return config;
}

void DataProvider::SetSPMStandByModeStatus(const bool standbyModeStatus)
{
    ENTRY
    VARTRACE(standbyModeStatus);
    Locker locker(&mLock);
    mSPMStandByModeStatus = standbyModeStatus;
}


bool DataProvider::GetSPMStandByModeStatus()
{
    ENTRY
    VARTRACE(mSPMStandByModeStatus);
    Locker locker(&mLock);
    return mSPMStandByModeStatus;
}

void DataProvider::SetIpodMuteStatus(const bool IpodMuteStatus)
{
    ENTRY
    VARTRACE(IpodMuteStatus);
    Locker locker(&mLock);
    mIpodMuteStatus = IpodMuteStatus;
}


bool DataProvider::GetIpodMuteStatus()
{
    ENTRY
    VARTRACE(mIpodMuteStatus);
    Locker locker(&mLock);
    return mIpodMuteStatus;
}
