/*
 * AlbumArtCache.cpp
 *
 *  Created on: Jan 22, 2013
 *      Author: tritonsu
 */
/* ETG definitions */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_DATA_PROVIDER
#ifdef TARGET_BUILD
#include "trcGenProj/Header/AlbumArtCache.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_DATA_PROVIDER
#endif
#endif
#include "FunctionTracer.h"
#include "VarTrace.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <vector>
#include <algorithm>
#include <utility>

#include "TypeDefinitions.h"
#include "AlbumArtCache.h"

int AlbumArtCache::FindInCache(tUInt &index, const tAlbumArt albumArt) // finished: 100%
{
    ENTRY


    for(int i=0; i<mNoOfCachelines; i++) {

        // not empty entry?
        if (mAlbumArtCache[i].valid == 1) {

            // key value found?
            if (!strcmp(mAlbumArtCache[i].albumArt, albumArt)) {
                index = i;
                ETG_TRACE_USR1(("albumArt found in cache (%d)=%s", i, albumArt));
                return 1;
            }
        }
    }

    ETG_TRACE_USR1(("albumArt NOT found in cache=%s", albumArt));

    return 0;
}

void AlbumArtCache::AddToCache(const tAlbumArt albumArt, const tAlbumArtObjectPtr albumArtPtr) // finished: 100%
{
    ENTRY

    tInteger oldestIndex = -1;
    tUInt biggestAge = 0;

    for(int i=0; i<mNoOfCachelines; i++) {

        // empty entry?
        if (mAlbumArtCache[i].valid == 0 || !strcmp(mAlbumArtCache[i].albumArt, albumArt)) {

            // add new entry
            mAlbumArtCache[i].valid = 1;
            mAlbumArtCache[i].age = mAgeCounter++;
            strncpy_r(mAlbumArtCache[i].albumArt, albumArt, sizeof(mAlbumArtCache[i].albumArt));
            mAlbumArtCache[i].albumArtPtr = albumArtPtr;

            return;

        } else {

            // save oldest index
            if (mAlbumArtCache[i].age > biggestAge) {
                biggestAge = mAlbumArtCache[i].age;
                oldestIndex = i;
            }
        }
    }

    // free the oldest
    if (mAlbumArtCache[oldestIndex].albumArtPtr->imageData) free(mAlbumArtCache[oldestIndex].albumArtPtr->imageData);
    if (mAlbumArtCache[oldestIndex].albumArtPtr) free(mAlbumArtCache[oldestIndex].albumArtPtr);

    // overwrite the oldest index with the newest
    mAlbumArtCache[oldestIndex].age = mAgeCounter++;
    strncpy_r(mAlbumArtCache[oldestIndex].albumArt, albumArt, sizeof(mAlbumArtCache[oldestIndex].albumArt));
    mAlbumArtCache[oldestIndex].albumArtPtr = albumArtPtr;
}

AlbumArtCache::AlbumArtCache() // finished: 100%
{
    ENTRY

    /* clear the cache */
    for(int i=0; i<mNoOfCachelines; i++) mAlbumArtCache[i].valid = 0;
    mAgeCounter = 0;

    mAAObject.albumArtString[0] = '\0';
    mAAObject.mimeType = MMT_PNG;
    mAAObject.sizeX = 0;
    mAAObject.sizeY = 0;
    mAAObject.imageData = 0;
    mAAObject.imageSize = 0;
}

tResult AlbumArtCache::IsAlbumArtInCache(const tAlbumArt albumArtString) // finished: 100%
{
    ENTRY

    tUInt index;
    return FindInCache(OUT index, IN albumArtString);
}

tResult AlbumArtCache::GetAlbumArtObjectFromCache(tAlbumArtObjectPtr &aaObjectPtr, const tAlbumArt albumArtString) // finished: 100%
{
    ENTRY

    tResult res;
    tUInt index;

    ETG_TRACE_USR1(("albumArtString=%s", albumArtString));

    // find the object
    res = FindInCache(OUT index, IN albumArtString);
    if (res != 1) return -1;

    // set the result */
    aaObjectPtr = mAlbumArtCache[index].albumArtPtr;
    ETG_TRACE_USR1(("albumArtPtr=0x%x", mAlbumArtCache[index].albumArtPtr));
    if (NULL == aaObjectPtr) return -1;

    return 0;
}

tImageData AlbumArtCache::ReadPicture(tImageSize &imageSize, const tAlbumArt albumArt) // finished: 100%
{
    ENTRY

    tImageData imageData = NULL;
    tResult res;
    struct stat statBuffer;
    FILE *fpImage;

    /* get the file size */
    res = stat(albumArt, &statBuffer);
    if (res) return NULL;
    imageSize = statBuffer.st_size;

    /* allocate memory */
    imageData = (tImageData)malloc(statBuffer.st_size);
    if (!imageData) return NULL;

    /* read in the file */
    fpImage = fopen(albumArt, "rb");
    if (!fpImage) {
        free(imageData);
        return NULL;
    }

    fread(imageData, 1, statBuffer.st_size, fpImage);
    fclose(fpImage);

    return imageData;
}

tResult AlbumArtCache::LoadAlbumArtIntoCache(const tAlbumArt albumArtString) // finished: 100%
{
    ENTRY

    tImageSize imageSize;
    tAlbumArt imagePath;

    // for fake: put in one element into the cache
#ifndef TARGET_BUILD
    char *pwd = get_current_dir_name();
    strncpy_r((char *)imagePath, (const char *)pwd, sizeof(tAlbumArt)); // Fake the picture name
    strncat_r((char *)imagePath, "/Customer/Simulation/CustomControl/test/albumart/Nations_256.jpg", sizeof(tAlbumArt));
#else
    strncpy_r((char *)imagePath, "/opt/bosch/test/data/GMP/test/albumart/Nations_256.jpg", sizeof(tAlbumArt));
#endif
    /* create the cache object */
    strncpy_r(mAAObject.albumArtString, albumArtString, sizeof(mAAObject.albumArtString));
    mAAObject.mimeType = MMT_JPG;
    mAAObject.sizeX = 256;
    mAAObject.sizeY = 256;
    mAAObject.imageData = (tImageData)ReadPicture(imageSize, imagePath);
    mAAObject.imageSize = imageSize;
    ETG_TRACE_USR1(("albumArtString=%s", mAAObject.albumArtString));
    ETG_TRACE_USR1(("imagePath(0x%x, img=0x%x)=%s", &mAAObject, mAAObject.imageData, imagePath));

    // add one entry to the cache for testing
    AddToCache(IN albumArtString, IN &mAAObject);

    return 0;
}

int AlbumArtCache::GetCacheCount()
{
    int usedEntries = 0;
    for(int i=0; i<mNoOfCachelines; i++) {
        if (mAlbumArtCache[i].valid) usedEntries++;
    }
    return usedEntries;
}

void AlbumArtCache::clearCache()
{
    ETG_TRACE_USR1(("AlbumArtCache::clearCache()"));
    for(int i=0; i<mNoOfCachelines; i++ )
    {
        mAlbumArtCache[i].valid = 0;
        strncpy_r(mAlbumArtCache[i].albumArt, "", sizeof(mAlbumArtCache[i].albumArt));
    }
}
