#ifndef _DBTriggerTest_H_
#define _DBTriggerTest_H_

/*lint -save -e578 */

#include <cppunit/extensions/HelperMacros.h>

#include <TypeDefinitions.h>
#include <TimeTrace.h>
class DBTriggerTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( DBTriggerTest );
	CPPUNIT_TEST( InitSuite );
	CPPUNIT_TEST( InsertTrigger );
	CPPUNIT_TEST( UpdateTriggerAllColumns );
	CPPUNIT_TEST( UpdateTriggerSpecificColumn );
	CPPUNIT_TEST( UpdateTriggerSpecificColumnWithClause );
	CPPUNIT_TEST( DeleteTrigger );
	CPPUNIT_TEST( TriggerSMCallbackTest );
	CPPUNIT_TEST( DeInitSuite );
    CPPUNIT_TEST_SUITE_END();

public:

    /*test cases*/	
    void InitSuite();
    void InsertTrigger();
    void DeleteTrigger();
    void UpdateTriggerAllColumns();
    void UpdateTriggerSpecificColumn();
    void UpdateTriggerSpecificColumnWithClause();
    void TriggerSMCallbackTest();
    void DeInitSuite();

private:
    TimeTrace	 	 ticks;			/**< time object to trace the time taken by testcases*/

    pthread_cond_t   condition ;	/**< wait condition used for asynchronous test cases */
    pthread_mutex_t  mutex ;		/**< lock used during asynchronous test case execution*/

    void DeRegisterTrigger(tTriggerID triggerID);
};

#endif  // _DBTriggerTest_H_
