#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/DBTriggerTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include  <errno.h>
#include <memory.h>
#include <DBTriggerManager.h>

#include "DBTriggerTest.h"
#include "RequestResponseSM.h"
#include "LocalSPM.h"
#include <FunctionTracer.h>

static sqlite3 *db = NULL;
static DBTriggerManager mTriggerManager;

/**********************************************************************
 * Test cases
 *********************************************************************/

void DBTriggerTest::InitSuite()
{
    ENTRY_TEST

    tResult ret;
    char* msg = NULL;

    ret = sqlite3_open(":memory:", &db) ;  // Open an in-memory database
    CPPUNIT_ASSERT_MESSAGE("Open database in memory failed", ret == SQLITE_OK);

    ret = sqlite3_exec(db, "create table trig_t (myIndex INTEGER, myValue INTEGER)", NULL, NULL, &msg);//Create table
    if(SQLITE_OK != ret)
    {
        ETG_TRACE_ERR(("failed to create a test table :%s\n",msg));
        sqlite3_free(msg);
        sqlite3_close(db);
        return;
    }

    mTriggerManager.AttachDB(db);
}

void DBTriggerTest::DeInitSuite()
{
    ENTRY_TEST

    sqlite3_exec (db, "DROP table trig_t", 0,0,0);
    sqlite3_close(db);
}

void DBTriggerTest::InsertTrigger()
{ 
    ENTRY_TEST

    tTriggerID triggerID = mTriggerManager.RegisterOnInsert ("trig_t","mySM", "myMSG_OnInsert" );

    for (int value=21; value<30; value++)
    {
        const char *SQL_ADD_ENTRY ="INSERT INTO trig_t VALUES (%d, %d)";
        char sql[512];

        sprintf (sql, SQL_ADD_ENTRY, value, value * 10);
        ETG_TRACE_USR3(("DBTriggerTest::InsertTrigger - >Inserting new row : %d,%d\n",value,value*10));
        if (SQLITE_OK != sqlite3_exec (db, sql, 0,0,0))
            ETG_TRACE_ERR(("error while inserting a row: %s\n",sqlite3_errmsg(db)));
    }
    //validate trigger callback data

    DeRegisterTrigger(triggerID);
}

void DBTriggerTest::DeleteTrigger()
{ 
    ENTRY_TEST

    tTriggerID triggerID = mTriggerManager.RegisterOnDelete ("trig_t","mySM", "myMSG_OnDelete" );

    /*delete all the rows*/
    const char *SQL_DEL_ENTRY ="DELETE from trig_t";

    if (SQLITE_OK != sqlite3_exec (db, SQL_DEL_ENTRY, 0,0,0))
        ETG_TRACE_ERR(("DeleteTrigger error message:%s\n", sqlite3_errmsg(db) ));

    DeRegisterTrigger(triggerID);

}
void DBTriggerTest::UpdateTriggerAllColumns()
{ 
    ENTRY_TEST

    tTriggerID triggerID = mTriggerManager.RegisteronUpdate ("trig_t","mySM", "myMSG_OnUpdate" );

    const char *SQL_UPD_ENTRY ="UPDATE trig_t SET myValue=100 WHERE myIndex=23";

    if (SQLITE_OK != sqlite3_exec (db, SQL_UPD_ENTRY, 0,0,0))
        ETG_TRACE_ERR(("UpdateTriggerAllColumns error message:%s\n", sqlite3_errmsg(db) ));

    DeRegisterTrigger(triggerID);
}

void DBTriggerTest::UpdateTriggerSpecificColumn()
{ 
    ENTRY_TEST

    tTriggerID triggerID = mTriggerManager.RegisteronUpdate ("trig_t","mySM", "myMSG_OnUpdate" , "myIndex");
    const char *SQL_UPD_ENTRY ="UPDATE trig_t SET myIndex=260 WHERE myValue=260";

    if (SQLITE_OK != sqlite3_exec (db, SQL_UPD_ENTRY, 0,0,0))
        ETG_TRACE_ERR(("UpdateTriggerAllColumns error message:%s\n", sqlite3_errmsg(db) ));

    DeRegisterTrigger(triggerID);
}

void DBTriggerTest::UpdateTriggerSpecificColumnWithClause()
{
    ENTRY_TEST

    tTriggerID triggerID = mTriggerManager.RegisteronUpdate ("trig_t","mySM", "myMSG_OnUpdate" , "myIndex" , "WHEN OLD.myIndex=27 AND NEW.myIndex=270");
    const char *SQL_UPD_ENTRY ="UPDATE trig_t SET myIndex=270 WHERE myValue=270";

    if (SQLITE_OK != sqlite3_exec (db, SQL_UPD_ENTRY, 0,0,0))
        ETG_TRACE_ERR(("UpdateTriggerAllColumns error message:%s\n", sqlite3_errmsg(db) ));

    DeRegisterTrigger(triggerID);
}

void DBTriggerTest::DeRegisterTrigger(tTriggerID triggerID)
{
    ENTRY_INTERNAL

    mTriggerManager.DeRegister(triggerID);
}

void DBTriggerTest::TriggerSMCallbackTest()
{
    ENTRY_TEST

    tResult res;

    /* use a request / response state machine for testing the trigger */
    class TriggerTestRR : public RequestResponseSM
    {

        int HandleInitRequest()
        {
            return 0;
        }

        int HandleLoopBackMessage(const char *allParameters)
        {
            (void)allParameters;

            /* register a trigger on DB */
            switch(mTestPath) {
            case 0: // insert test
            {    triggerID = mTriggerManager.RegisterOnInsert(IN "trig_t", IN GetSMNameFull(), IN "SUCCESS_REQUEST");
                ETG_TRACE_USR2(("triggerID=%d", triggerID));
                CPPUNIT_ASSERT(triggerID != 0);
                const char *SQL_ADD_ENTRY ="INSERT INTO trig_t VALUES (%d, %d)";
                char sql[512];

                sprintf (sql, SQL_ADD_ENTRY, 31, 310);
                ETG_TRACE_USR2(("Inserting new row \n"));
                if (SQLITE_OK != sqlite3_exec (db, sql, 0,0,0))
                    ETG_TRACE_ERR(("error while inserting a row: %s\n",sqlite3_errmsg(db)));
            }
            break;

            case 1: // update test
            {
                triggerID = mTriggerManager.RegisteronUpdate(IN "trig_t",IN GetSMNameFull(), IN "SUCCESS_REQUEST",  IN "myValue", IN "WHEN OLD.myValue=310 AND NEW.myValue=100");

                ETG_TRACE_USR2(("triggerID=%d", triggerID));
                CPPUNIT_ASSERT(triggerID != 0);

                const char *SQL_UPD_ENTRY ="UPDATE trig_t SET myValue=100 WHERE myIndex=31";

                if (SQLITE_OK != sqlite3_exec (db, SQL_UPD_ENTRY, 0,0,0))
                    ETG_TRACE_ERR(("UpdateTriggerAllColumns error message:%s\n", sqlite3_errmsg(db) ));
            }
            break;

            case 2: // delete test
            {    triggerID = mTriggerManager.RegisterOnDelete(IN "trig_t",IN GetSMNameFull(), IN "SUCCESS_REQUEST");
                ETG_TRACE_USR2(("triggerID=%d", triggerID));
                CPPUNIT_ASSERT(triggerID != 0);

                /*delete all the rows*/
                const char *SQL_DEL_ENTRY ="DELETE from trig_t WHERE myValue=100";
                if (SQLITE_OK != sqlite3_exec (db, SQL_DEL_ENTRY, 0,0,0))
                    ETG_TRACE_ERR(("DeleteTrigger error message:%s\n", sqlite3_errmsg(db) ));
                break;
            }
            default:
                break;
            }

            return 0;
        }

        int HandleSuccessRequest(const char *allParameters)
        {
            tResult res; //lint !e578

            /* check the incoming values */
            ETG_TRACE_USR3(("HandleSuccessRequest(%s)", allParameters));

            /* read out the returned values */
            UnMarshal(allParameters, "ii", &mCount, &mRowID);

           /* deregister the trigger */
            res = mTriggerManager.DeRegister(IN triggerID);
            CPPUNIT_ASSERT(res);
            /* do a send answer to unlock the EventAnswer mechanism */
            SendAnswer(NULL);

            return 0;
        }
    public:
        tTriggerID triggerID;
        int mTestPath;

        int mRowID;
        int mCount;
    };


    /* send LOOP_BACK_MESSAGE to start the tests */
    TriggerTestRR rrTriggerTest;
    char message[128];
    strncpy_r(message, rrTriggerTest.GetSMNameFull(),sizeof(message));//CID 17359
    strncat_r(message, "::LOOP_BACK_MESSAGE",sizeof(message));//CID 17359

    // insert test
    ETG_TRACE_USR2(("Insert Trigger Test"));
    rrTriggerTest.mCount = 0;
    rrTriggerTest.mRowID = 0;
    rrTriggerTest.mTestPath = 0;
    res = rrTriggerTest.DoEventAnswer(message, NULL, NULL, 2000);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(rrTriggerTest.mCount != 0);
    CPPUNIT_ASSERT(rrTriggerTest.mRowID != 0);

    // update test
    ETG_TRACE_USR2(("Update Trigger Test"));
    int oldCount = rrTriggerTest.mCount;
    int oldRowID = rrTriggerTest.mRowID;
    rrTriggerTest.mTestPath = 1;
    res = rrTriggerTest.DoEventAnswer(message, NULL, NULL, 2000);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(oldCount == rrTriggerTest.mCount);
    CPPUNIT_ASSERT(oldRowID == rrTriggerTest.mRowID);

    // delete test
    ETG_TRACE_USR2(("Delete Trigger Test"));
    oldCount = rrTriggerTest.mCount;
    oldRowID = rrTriggerTest.mRowID;
    rrTriggerTest.mTestPath = 2;
    res = rrTriggerTest.DoEventAnswer(message, NULL, NULL, 2000);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT((oldCount-1) == rrTriggerTest.mCount);
    CPPUNIT_ASSERT(oldRowID == rrTriggerTest.mRowID);
}
