/*
 * MTPVTTest.h
 *
 *  Created on: Dec 26, 2013
 *      Author: din3kor
 */
/*lint -save -e578 */
#ifndef MTPVTTEST_H_
#define MTPVTTEST_H_

#include <cppunit/extensions/HelperMacros.h>
#include <TypeDefinitions.h>
#include "MTPControlTestUtil.h"

class MTPVTTest : public MTPControlTestUtil,public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( MTPVTTest );
    CPPUNIT_TEST( InitTestSuite );
    CPPUNIT_TEST( CreateVT );
    CPPUNIT_TEST( GetStorages );
    CPPUNIT_TEST( GetStorageContents );
    //CPPUNIT_TEST( GetLevel2Contents );
    //CPPUNIT_TEST( GetLevel3Contents );
    CPPUNIT_TEST( DeleteVT );
    CPPUNIT_TEST( EndTestSuite );
    CPPUNIT_TEST_SUITE_END();

public:
    MTPVTTest(){};

    /*generic vt query implementation used across all the testcases*/
    int Query(char *mountPoint, char *path, char *comparePath, int flags, vector<char *> expectedNames, vector<int> expectedTypes, int doAssert = 1);
    void QueryCount(char *mountPoint, char *path, int countDirectories, int countMediaObjects, int doAssert = 1);

    /*test cases*/
    void InitTestSuite();
    void CreateVT();
    void GetStorages();
    void GetStorageContents();
    void GetLevel2Contents();
    void GetLevel3Contents();
    void DeleteVT();
    void EndTestSuite();

};

#endif /* MTPVTTEST_H_ */
